from pytorch_cam.base_cam import BaseCAM
import torch

class SimCAM(BaseCAM):
    def __init__(self, model, target_layers, use_cuda=False,
                 reshape_transform=None):
        super(
            SimCAM,
            self).__init__(
            model,
            target_layers,
            use_cuda,
            reshape_transform,
            compute_input_gradient=False,
            uses_gradients=False)

        params = list(model.parameters())
        self.dense_weights = params[-2]

    def get_cam_weights(self,
                        input_tensor,
                        target_layer,
                        target_category,
                        activations,
                        grads):
        return torch.index_select(self.dense_weights, 0, target_category).data.cpu().numpy()
