import os
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

data_path = 'output'

full_magnitude = np.loadtxt(os.path.join(data_path,'magnitude_computation_time.txt'))
full_magnitude_formatted = np.zeros((len(full_magnitude),4))

# Number of patches is 1
full_magnitude_formatted[:,0] = 1

# Computation time
full_magnitude_formatted[:,1] = full_magnitude

# Create a dataframe, errors are 0 as we use the exat calculation
full_magnitude_df = pd.DataFrame(data=full_magnitude_formatted,
                                 columns=['n_patches','time','max_error','Frobenius_error'],
                                 index = [f'image_{i}' for i in range(1,len(full_magnitude)+1)])

for i in range(1,11):
    # Do the smae for the patched versions
    tmp = pd.DataFrame(data=np.loadtxt(os.path.join(data_path,f'patches_img_0000000{i}_000.txt')),
                                     columns=['n_patches','time','max_error','Frobenius_error'],
                                     index = [f'image_{i}_patches_{n}' for n in [2,4,8,16,32,64,128,256]])
    full_magnitude_df = full_magnitude_df.append(tmp)

full_magnitude_df['n_patches'] = full_magnitude_df['n_patches'].astype(int)

fig,ax = plt.subplots()
fig.set_size_inches(8,6)
sns.stripplot(x='n_patches',y='time',data=full_magnitude_df,ax=ax)
plt.xlabel('Number of patches per dimension',fontsize=20)
plt.ylabel('Computation time [s]',fontsize=20)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.tight_layout()
plt.savefig(os.path.join('output','computation_time.pdf'))

fig,ax = plt.subplots()
fig.set_size_inches(8,6)
sns.boxplot(x='n_patches',y='max_error',data=full_magnitude_df,ax=ax)
plt.xlabel('Number of patches per dimension',fontsize=20)
plt.ylabel('Maximum error',fontsize=20)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.tight_layout()
plt.savefig(os.path.join('output','max_error.pdf'))

fig,ax = plt.subplots()
fig.set_size_inches(8,6)
sns.boxplot(x='n_patches',y='Frobenius_error',data=full_magnitude_df,ax=ax)
plt.xlabel('Number of patches per dimension',fontsize=20)
plt.ylabel('Frobenius error',fontsize=20)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.tight_layout()
plt.savefig(os.path.join('output','Frobenius_error.pdf'))
plt.show()
