import pickle
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.pyplot import cm

with open('batchsize.pickle', 'rb') as handle:
    record = pickle.load(handle)

batch_sizes =  [1,  10, 100, 1000  ]
y_axis = {}
color = iter(cm.rainbow(np.linspace(0, 1, 5)))
fig, ax = plt.subplots()
for batch_size in batch_sizes:
    c = next(color)
    record[batch_size] = np.mean(np.array(record[batch_size]), axis=0)
    y_axis[batch_size] = np.linspace(1, 1000000, len(record[batch_size]))

    ax.plot(y_axis[batch_size], record[batch_size], label='Batch Size: '+str(batch_size), color=c)
legend = ax.legend()
plt.show()

