import pickle
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.pyplot import cm
import matplotlib
font = {'weight' : 'bold',
        'size'   : 22}
matplotlib.rc('font', **font)

# with open('tau.pickle', 'rb') as handle:
#with open('tau_skip.pickle', 'rb') as handle:
with open('tau_skip.pickle', 'rb') as handle:
    record = pickle.load(handle)
with open('tau_bs.pickle', 'rb') as handle:
    recordb = pickle.load(handle)

record = recordb

line_width = 4

batchsize = 1
xi = [1, 50, 100, 150, 200]
x_ax = [i+1 for i in range(len(record[(0.25, batchsize)]))]
plt.plot(x_ax, record[(0.25, batchsize)], label="r=0.25",linewidth=line_width,   c="y")
plt.plot(x_ax, record[(0.5, batchsize)],label="r=0.5",linewidth=line_width, c="r")
plt.plot(x_ax, record[(1, batchsize)],label="r=1",linewidth=line_width,   c="b")
plt.plot(x_ax, record[(2, batchsize)],label="r=2",linewidth=line_width,    c="g")
plt.legend()
plt.xlabel(r"$\tau$")
plt.ylabel("bias", weight="bold")
plt.xlim(-10, 250)
plt.ylim(-0.05, 0.2)
# plt.title("Batch Size = 1", weight="bold")
plt.title("Batch Size = 1", weight="bold")
plt.xticks(xi)
plt.tight_layout()
plt.savefig("skip-"+str(batchsize)+".png", dpi=300)
plt.show()


batchsize = 10
xi = [1, 5, 10, 15, 20]
x_ax = [i+1 for i in range(len(record[(0.25, batchsize)]))]
plt.plot(x_ax, record[(0.25, batchsize)], label="r=0.25",linewidth=line_width,   c="y")
plt.plot(x_ax, record[(0.5, batchsize)],label="r=0.5",linewidth=line_width, c="r")
plt.plot(x_ax, record[(1, batchsize)],label="r=1",linewidth=line_width,   c="b")
plt.plot(x_ax, record[(2, batchsize)],label="r=2",linewidth=line_width,    c="g")
plt.legend()
plt.xlabel(r"$\tau$")
plt.ylabel("bias", weight="bold")
#plt.title("Batch Size = 10", weight="bold")
plt.title("Batch Size = 10", weight="bold")
plt.xlim(-25/20.0, 25)
plt.ylim(-0.05, 0.2)
plt.xticks(xi)
plt.tight_layout()
plt.savefig("skip-"+str(batchsize)+".png", dpi=300)
plt.show()


batchsize = 100
xi = [1,2,3,4,5]
x_ax = [i+1 for i in range(len(record[(0.25, batchsize)]))]
plt.plot(x_ax, record[(0.25, batchsize)], label="r=0.25",linewidth=line_width,   c="y")
plt.plot(x_ax, record[(0.5, batchsize)],label="r=0.5",linewidth=line_width, c="r")
plt.plot(x_ax, record[(1, batchsize)],label="r=1",linewidth=line_width,   c="b")
plt.plot(x_ax, record[(2, batchsize)],label="r=2",linewidth=line_width,    c="g")
plt.legend()
plt.xlabel(r"$\tau$")
plt.ylabel("bias", weight="bold")
plt.xticks(xi)
#plt.title("Batch Size = 100", weight="bold")
plt.title("Batch Size = 100", weight="bold")
plt.xlim(6/20.0, 6)
plt.ylim(-0.05, 0.2)
plt.tight_layout()
plt.savefig("skip-"+str(batchsize)+".png", dpi=300)
plt.show()

###############################################################
# chang value of r
###############################################################

r = 0.5
xi = [1, 25, 50, 75, 100  ]
plt.plot(record[(r, 1)], label="B=1",linewidth=line_width, c="b")
plt.plot(record[(r, 10)], label="B=10",linewidth=line_width, c="r")
plt.plot(record[(r, 100)], label="B=100",linewidth=line_width, c="y")
plt.title("r=0.5", weight="bold")
plt.legend()
plt.xlabel(r"$\tau$")
plt.ylabel("bias", weight="bold")
plt.xlim(-10, 105)
plt.ylim(-0.05, 0.2)
plt.xticks(xi)
plt.tight_layout()
plt.savefig("skip2-"+str(r)+".png", dpi=300)
plt.show()

r = 1
plt.plot(record[(r, 1)], label="B=1", linewidth=line_width,c="b")
plt.plot(record[(r, 10)], label="B=10",linewidth=line_width, c="r")
plt.plot(record[(r, 100)], label="B=100", linewidth=line_width,c="y")
plt.title("r=1", weight="bold")
plt.legend()
plt.xlabel(r"$\tau$")
plt.ylabel("bias", weight="bold")
plt.xlim(-10, 105)
plt.ylim(-0.05, 0.2)
plt.xticks(xi)
plt.tight_layout()
plt.savefig("skip2-"+str(r)+".png", dpi=300)
plt.show()

r = 2
plt.plot(record[(r, 1)], label="B=1",linewidth=line_width, c="b")
plt.plot(record[(r, 10)], label="B=10",linewidth=line_width, c="r")
plt.plot(record[(r, 100)], label="B=100",linewidth=line_width, c="y")
plt.title("r=2", weight="bold")
plt.legend()
plt.xlabel(r"$\tau$")
plt.ylabel("bias", weight="bold")
plt.xlim(-10, 105)
plt.ylim(-0.05, 0.2)
plt.xticks(xi)
plt.tight_layout()
plt.savefig("skip2-"+str(r)+".png", dpi=300)
plt.show()

