# Experiment Guide

## Experiment Names:
* UnlimitedBuffer -- Buffer size is set to an inordinately large number (e.g. 10^15); remaining hyperparmeters are standard for the given method and environment
* TunedBuffer -- Buffer size is set to a reasonable number for the given method and environment; remaining hyperparameters are standard for the given method and environment
* SmallBuffer -- Buffer size is set a very small number (e.g. 400 for cartpole); remaining hyperparmeters are standard for the given method and environment
* Cropping -- MAX_PREDICTION_DISTANCE is set to a small number (defaults to 10^6); remaining hyperparmeters are standard for the given method and environment

It is possible to have some names combined. For example, UnlimitedBufferCropping or SmallBufferCropping are both possibilities. UnlimitedBufferSmallBuffer is not.
These experiments are mutually exclusive.

## Hyperparameters/Settings Names:
* RUNS -- Number of separate runs (samples) of an experiment to complete. For some experiments, multiple runs are required in order to generate statistics.
* EPOCHS -- Number of training iterations to complete within a single run
* NEW_DATA_TRAIN_THRESHOLD -- Specific to UARF, the amount of experience, relative to the size of the buffer at the last training, that must be added to the buffer before training is triggered again.
* METHOD -- BASELINE, BICHO, or UARF
* BETA and LOOKAHEAD -- Tunable parameters for modifying skipping behavior of BICHO and UARF.
* MAX_PREDICTION_DISTANCE -- Specific to UARF, recalculations after this many skipped steps are not added to the replay buffer.
* ENV -- Testing environment used (cartpole, reacher, pusher, half-cheetah, pointbot)
* MAX_BUFFER_LENGTH -- The maximum number of experiences to be stored in the replay buffer before oldest experiences are dropped out.
* COLD_START_STEPS -- Specific to UARF, if operating in a more complex environment, cold start indicates the number of steps that are added to the replay buffer regardless of whether a recalculation occurred or not.
* SAVE_BUFFERS -- Flag for indicating whether replay buffers should be saved after each epoch.
