# mbrl_rb_crop

## Dependencies
Included in this repo is an environment.yml file. This can be used to replicate the virtual environment that was used to run all of the experiments in this work.

It should be noted that the "prefix" at the bottom of the .yml file must be changed to correspond to one's absolute path to the new environment. This would be something like "/home/<username>/anaconda3/envs/<new_env_name>" on Ubuntu systems.

To create a virtual environment from a .yml file, run the command `conda env create -f environment.yml`

## How to replicate experiments

run.py and multi_step_run.py files included for easier issuance of run commands.

These files consist of a function that uses the python subprocess module to issue multiple run commands in sequence. This enables running multiple trials or multi-step experiments without having to launch each run manually. These scripts do not require any additional command line arguments and can be run by simply passing "python run.py" or "python multi_step_run.py" to the command line. Additionally, these scripts contain all of the relevant experiments for this work predefined. As such, one can run all or some of the experiments that appear in this paper simply by running the scripts in their original form or by commenting out any unnecessary experiments.

Comments are included in these scripts that detail how to add new experiments to the experiment queue.

## Creating summary files

In order to summarize the results of our experiments and create visualizations of these results, we have included the ResultsAnalyzer.py script for generating summary csv files.

This script takes two arguments:
* --path: This argument should be the path to the top level experiment directory for which you want to make a summary file. For example: if `Experiments/cartpole/UARF/UnlimitedBuffer/` contains multiple runs, passing in this path for the path argument would generate a file containing summary statistics for these runs. It is possible to use command line wildcards with this argument. If wildcards are used, the path should be wrapped in quotation marks (e.g. "Experiments/cartpole/UARF/\*" would generate summary files for all experiments captured by this wildcard).

* --multistep: This argument is a boolean; thus, it should only be included if the desired experiment for which summary statistics should be generated is a multi-step continual learning experiment. Otherwise, it should be omitted entirely. For the test runs of multi-step experiments, this argument can also be omitted. This is because the test runs contain only one maneuver (usually the full track all at once), so they would not have the same directory structure as directories containing runs on multiple maneuvers.

## Generating plots

Jupyter Notebooks titled Experiment1_PlotGenerator and Experiment2_PlotGenerator were included for convenience. These notebooks serve to generate the plots that are included in this work. In order to recreate all of the plots used in this work, it should only be necessary to change the experiment paths such that they point to the correct experiments to be included in the plot. The rest of the code should be able to be left as is.
