from .obstacle import Obstacle, ComplexObstacle
import numpy as np
import pandas as pd
import os

"""
Constants associated with the PointBot env.
"""

START_POS = [-50, 0]
END_POS = [0, 0]
GOAL_THRESH = 1.
START_STATE = [START_POS[0], 0, START_POS[1], 0]
GOAL_STATE = [END_POS[0], 0, END_POS[1], 0]

MAX_FORCE = 1
HORIZON = 100

NOISE_SCALE = 0.0 # original was 0.05
AIR_RESIST = 0.6
NOISE_ON_INIT_STATE = True


# hack
#NOISE_SCALE = 0.0
#NOISE_ON_INIT_STATE = False



HARD_MODE = False
LINE_FOLLOWER_MODE = True

FAILURE_COST = 0


OBSTACLE = {
	1: ComplexObstacle([[[-1000, -999], [-1000, -999]]]),
	2: ComplexObstacle([[[-30, -20], [-20, 20]]]),
	3: ComplexObstacle([[[-30, -20], [-20, -10]], [[-30, -20], [0, 20]]]),
	4: ComplexObstacle([[[-30, -20], [-20, 20]], [[-20, 5], [10, 20]], [[0, 5], [5, 10]], [[-20, 5], [-20, -10]]])
}


def get_path_relative_to_this_script():
	return os.path.dirname(os.path.realpath(__file__))

TOP_SPEED = 0.5 # m/s

def load_track(name):
    path_name = os.path.join( get_path_relative_to_this_script(), './track_segments', name + '.csv')
    df = pd.read_csv(path_name)
    
    pos_x = df[['pos_x']].values[0]
    pos_z = df[['pos_z']].values[0]
    yaw = df[['angle_y']].values[0]
    speed_x = np.cos( yaw ) * TOP_SPEED * 0.5 # start with some speed
    speed_y = np.sin( yaw ) * TOP_SPEED * 0.5
    start_state = np.array( [pos_x, speed_x, pos_z, speed_y] ).flatten()  #x, sx, y, sy
    racing_line = df[['pos_x', 'pos_z']].values
    
    return {'racing_line': racing_line, 'start_state':start_state}

MANEUVERS = {
            # straight; stand still starting
            'straight':{
                    'racing_line':
                        np.array([
                                    [-100, 0],
                                    [500,0],
                        ]),
                    'start_state':
                        np.array( [-100,0,0,0] )  #x, sx, y, sy
            },
            'c1':load_track('c1'),
            'c1_i':load_track('c1_i'),
            'c14':load_track('c14'),
            'c14_i':load_track('c14_i'),
    
            'chicane':load_track('chicane'),
            'chicane_i':load_track('chicane_i'),
                
            'sector_1':load_track('sector_1'),
            'sector_1_i':load_track('sector_1_i'),
            'full_track_barcelona':load_track('full_track_barcelona'),
}



