import os
import subprocess
import utils

def experiment(experiment_name, env, method, runs, epochs, beta, lookahead,
 new_data_train_threshold = None, max_buffer_length = None, cold_start = None, save = None,
 maneuvers = None, loaddir = None, test = None):
    HYPERPARAMETERS = {
    'RUNS' : str(runs),
    'EPOCHS' : str(epochs),
    'NEW_DATA_TRAIN_THRESHOLD' : str(new_data_train_threshold) if new_data_train_threshold else "0",
    'METHOD' : method,
    'BETA' : str(beta),
    'LOOKAHEAD' : str(lookahead),
    'ENV' : env,
    'MAX_BUFFER_LENGTH' : str(max_buffer_length) if max_buffer_length else "10e15",
    'COLD_START_STEPS' : str(cold_start) if cold_start else "0",
    'SAVE' : save,
    'LOADDIR' : loaddir,
	'MANEUVER' : maneuvers
    }

    assert not os.path.exists(f"Experiments/{HYPERPARAMETERS['ENV']}/{HYPERPARAMETERS['METHOD']}/REWORK/{experiment_name}"), "Output directory already exists, ensure you are not overwriting experiment data."
    for i in range(int(HYPERPARAMETERS['RUNS'])):
        command = ["python", "8_online.py", "-env", HYPERPARAMETERS['ENV'],
        "-logdir", f"Experiments/{HYPERPARAMETERS['ENV']}/{HYPERPARAMETERS['METHOD']}/REWORK/{experiment_name}/run{i}",
        "-o", "exp_cfg.exp_cfg.ntrain_iters", HYPERPARAMETERS['EPOCHS'],
        "--NEW_DATA_TRAIN_THRESHOLD", HYPERPARAMETERS['NEW_DATA_TRAIN_THRESHOLD'], "--METHOD", HYPERPARAMETERS['METHOD'],
        "--S_FUT_KL_CST", HYPERPARAMETERS['BETA'], "--S_FUT_LASTEPS", HYPERPARAMETERS['LOOKAHEAD'],
        "--MAX_BUFFER_LENGTH", HYPERPARAMETERS['MAX_BUFFER_LENGTH'], "--COLD_START_STEPS", HYPERPARAMETERS['COLD_START_STEPS'], 
		"--MANEUVER", HYPERPARAMETERS['MANEUVER'][i]] 
        if HYPERPARAMETERS['SAVE']:
            command.append("--SAVE")
        if i != 0 or test:
            command.append("--LOAD")
            if HYPERPARAMETERS['LOADDIR']:
                command.append(HYPERPARAMETERS['LOADDIR'])
            else:
                command.append(f"Experiments/{HYPERPARAMETERS['ENV']}/{HYPERPARAMETERS['METHOD']}/REWORK/{experiment_name}/run{i-1}/buffers")
        print(command)
        subprocess.run(command)

    utils.to_json(HYPERPARAMETERS, f"Experiments/{HYPERPARAMETERS['ENV']}/{HYPERPARAMETERS['METHOD']}/REWORK/{experiment_name}/hyperparameters.txt")

experiment_queue = [
        #To add an experiment to the queue, add a list of arguments with the following order:
        #[ExperimentName, environment, method, num_runs, num_epochs, beta, lookahead, new_data_train_threshold, max_buffer_length, cold_start_steps, save_flag, model_load_directory, maneuver, test_flag]

        #Unlimited Buffer Continual Learning (Experiment 2)
        ["FullTrackUnlimitedBuffer",  "pointbot", "UARF", 7, 30, 0.5, 10, 0.01, None, None, True, ['c1', 'c1_i', 'chicane', 'chicane_i', 'c14', 'c14_i', 'straight']],
        ["FullTrackUnlimitedBufferTest",  "pointbot", "UARF", 1, 1, 0.5, 10, None, None, None, None, ['full_track_barcelona'], "Experiments/pointbot/UARF/REWORK/FullTrackUnlimitedBuffer/run6/buffers", True],

	["FullTrackUnlimitedBuffer",  "pointbot", "BICHO", 7, 30, 0.5, 10, 0.01, None, None, True, ['c1', 'c1_i', 'chicane', 'chicane_i', 'c14', 'c14_i', 'straight']],
        ["FullTrackUnlimitedBufferTest",  "pointbot", "BICHO", 1, 1, 0.5, 10, None, None, None, None, ['full_track_barcelona'], "Experiments/pointbot/BICHO/REWORK/FullTrackUnlimitedBuffer/run6/buffers", True],

        ["FullTrackUnlimitedBuffer",  "pointbot", "BASELINE", 7, 30, 0.5, 10, 0.01, None, None, True, ['c1', 'c1_i', 'chicane', 'chicane_i', 'c14', 'c14_i', 'straight']],
        ["FullTrackUnlimitedBufferTest",  "pointbot", "BASELINE", 1, 1, 0.5, 10, None, None, None, None, ['full_track_barcelona'], "Experiments/pointbot/BASELINE/REWORK/FullTrackUnlimitedBuffer/run6/buffers", True],

        #Catastrophic Forgetting (Experiment 3)
        ["FullTrackFixedBuffer",  "pointbot", "UARF", 7, 30, 0.5, 10, 0.01, 5000, None, True, ['c1', 'c1_i', 'chicane', 'chicane_i', 'c14', 'c14_i', 'straight']],
        ["FullTrackFixedBufferTest",  "pointbot", "UARF", 1, 1, 0.5, 10, None, 5000, None, None, ['full_track_barcelona'], "Experiments/pointbot/UARF/REWORK/FullTrackFixedBuffer/run6/buffers", True],
	["FullTrackFixedBufferC1ITest",  "pointbot", "UARF", 1, 1, 0.5, 10, None, 5000, None, None, ['c1_i'], "Experiments/pointbot/UARF/REWORK/FullTrackFixedBuffer/run6/buffers", True],

	["FullTrackFixedBuffer",  "pointbot", "BICHO", 7, 30, 0.5, 10, 0.01, 5000, None, True, ['c1', 'c1_i', 'chicane', 'chicane_i', 'c14', 'c14_i', 'straight']],
        ["FullTrackFixedBufferTest",  "pointbot", "BICHO", 1, 1, 0.5, 10, None, 5000, None, None, ['full_track_barcelona'], "Experiments/pointbot/BICHO/REWORK/FullTrackFixedBuffer/run6/buffers", True],
	["FullTrackFixedBufferC1ITest",  "pointbot", "BICHO", 1, 1, 0.5, 10, None, 5000, None, None, ['c1_i'], "Experiments/pointbot/BICHO/REWORK/FullTrackFixedBuffer/run6/buffers", True],

	["FullTrackFixedBuffer",  "pointbot", "BASELINE", 7, 30, 0.5, 10, 0.01, 5000, None, True, ['c1', 'c1_i', 'chicane', 'chicane_i', 'c14', 'c14_i', 'straight']],
        ["FullTrackFixedBufferTest",  "pointbot", "BASELINE", 1, 1, 0.5, 10, None, 5000, None, None, ['full_track_barcelona'], "Experiments/pointbot/BASELINE/REWORK/FullTrackFixedBuffer/run6/buffers", True],
	["FullTrackFixedBufferC1ITest",  "pointbot", "BASELINE", 1, 1, 0.5, 10, None, 5000, None, None, ['c1_i'], "Experiments/pointbot/BASELINE/REWORK/FullTrackFixedBuffer/run6/buffers", True],
]

for e in experiment_queue:
    experiment(*e)
