



# Dependencies

- Python Version 3.7.6
-Numpy Version 1.19.2
-Pandas Version 1.2.3
-Scipy Version 1.6.2
-Matplotlib Version 3.3.4


# File Descriptions

- *irl_main_experiment.py*: Running this file as `main` uses the given set of seeds
to generate a random IRL problem and then runs Algorithm 2 from the paper on it for a 
specified number of repetitions while varying the number of samples. It then saves
a Pandas Dataframe recording the proportion of runs returning a Bellman optimal
reward function at each value of the sample parameter.


- *sampling_main_experiment.py*: Running this file as `main` generates a random
polynomial conditional probability distribution.  It then learns the empirical
Z-matrix for each sampling parameter value provided for a specified number of
repetitions.  Then, the script outputs a graph showing the average observered
error between the estimated and exact Z-matrix compared to the theoretical guarantee.


- *polynomial_dist.py*: Contains objects to create and manipulate random polynomial
 distributions `(PolynomialDist)` and conditional probability distributions `(MixtureModel)`.

 
- *sampling_funcs.py*: Contains functions to construct the empirical coefficient matrix
'Zhat' by sampling from a `MixtureModel` and measure sampling error compared to the
true coefficient matrix 'Z'.


- *irl_funcs.py*: Contains functions to construct and solve the LP described of 
Algorithm 2 in the paper and return the optimal reward function vector alpha.
Also contains a function to generate a random polynomial MDP with three actions
and measure the performance of the full IRL algorithm by estimating the transition 
dynamics and solving the linear program using the estimated coefficients.


- *beta_gen_main.py*: This script can be used to generate a set of random IRL
problems and compute an optimal reward function using the exact transition matrices.
The seeds used to generate each problem along with the computed 'beta' value
are then saved and output to a csv file.


# Running Experiments

Use `irl_main_experiment.py` and set the parameters as described in the file to 
test Algorithm 2, as shown by Figure 3 land 4 in the paper.

Use `sampling_main_experiment.py` and set the parameters as described in the file
to test Algorithm 1 specifically, as shown by Figure 2 in the paper.




