# -*- coding: utf-8 -*-
"""
Created on Tue Mar  2 11:53:11 2021

@author: grego
"""



import numpy as np
import pandas as pd
import scipy as sc

from polynomial_dist import MixtureModel
from irl_funcs import compute_alpha_opt

PI = 3.14159265359
SIZE = 5    ## Max degree of trigonometric polynomial in series (k=2*SIZE + 1)
GAMMA = 0.7 # Discount factor
COVER_SIZE = 500  ## Size of cover set \bar{S}

NUM_BETA = 400  # Number of IRL problems to generate and test

sc.special.seterr(all = 'raise')


run_list = []
for i in range(NUM_BETA):
    print("Iteration:", i)
    np.random.seed()
    
    seeds = np.random.choice(1000, size=3, replace=False)
    
    model_list = []
    model_list.append(MixtureModel(lambda s: s**2, seeds[0]))
    model_list.append(MixtureModel(lambda s: s**2, seeds[1]))
    model_list.append(MixtureModel(lambda s: s**2, seeds[2]))
    
    Z_list = [mod.compute_Zmat(SIZE) for mod in model_list]
    
    res = compute_alpha_opt(Z_list, SIZE, COVER_SIZE, GAMMA, return_res = True)
    
    if res['success']:
        run_list.append((res['fun'], seeds[0], seeds[1], seeds[2]))
    else:
        print("Run Failed")

df = pd.DataFrame(run_list)
df.columns = ['Beta^-1', 'S1', 'S2', 'S3']
df.to_csv('beta_values.csv', index = False)











