# ---------------------------
# _, _ -- 2019
# The University of _, The _ Institute
# contact: _, _
# ---------------------------
"""Functions to build a fake dataset
"""
import tensorflow as tf

import numpy as np


def build_fake_input_fns(batch_size, image_shape):
    """Builds fake MNIST-style data for unit testing."""
    random_sample = np.random.rand(batch_size, *image_shape).astype("float32")

    def train_input_fn():
        dataset = tf.data.Dataset.from_tensor_slices(random_sample).map(
            lambda row: (row, 0)).batch(batch_size).repeat()
        return dataset.make_one_shot_iterator().get_next()

    def eval_input_fn():
        dataset = tf.data.Dataset.from_tensor_slices(
            random_sample).map(lambda row: (row, 0)).batch(batch_size)
        return dataset.make_one_shot_iterator().get_next()

    return train_input_fn, eval_input_fn
