# ---------------------------
# _, _ -- 2019
# The University of _, The _ Institute
# contact: _, _
# ---------------------------
""" Functions for the specification of priors in stochastic layers
"""
import tensorflow as tf
import tensorflow_probability as tfp
tfd = tfp.distributions


def make_gaussian_prior(latent_size, name):
    """Creates the mixture of Gaussians prior distribution.

  Args:
    latent_size: The dimensionality of the latent representation.

  Returns:
    random_prior: A `tfd.Distribution` instance representing the distribution
      over encodings in the absence of any evidence.
  """
    # See the module docstring for why we don't learn the parameters here.
    return dict(
        prob=tfd.Normal(
            loc=tf.zeros([latent_size]),
            scale=tf.ones([latent_size]),
            name=name),
        mu=tf.zeros([latent_size]),
        var=tf.ones([latent_size]))
