# ---------------------------
# _, _ -- 2019
# The University of _, The _ Institute
# contact: _, _
# ---------------------------
"""Functions that are missing in TF but would be oh so useful if they were around
"""

import tensorflow as tf
import numpy as np


def nunique_cols(x, axis=0):
    """
    Finds the number of unique values in each column of an array.

    Args:
      x: 2d array
      axis: axis along which to count unique values

    Returns:
      np array of number of unique values along axis.

    """
    return np.apply_along_axis(
        lambda col: len(np.unique(col)), axis=axis, arr=x).astype(np.float32)
