#! /bin/bash

## ARGS
# 1: start idx
# 2: end idx
# 3: robotname

robot_folder=/media/barry/multirobot/$3
mkdir -p $robot_folder

# iterate indices from argument 1 to argument 2
for i in $(seq $1 $2)
do
    # run the script for each index
    echo "running process $3 $i"
    log_file=$robot_folder/processing_logs_$3_$i.txt
    touch $log_file
    python process_data.py --idx $i --robot $3 > $log_file &
    
    # for every 10 indices, wait for all processes to finish
    if [ $(($i % 10)) -eq 9 ]
    then
        wait
    fi
done