We have used the following CutMix code and modified:
- [Cutmix-PyTorch](https://github.com/clovaai/CutMix-PyTorch)

### Requirements
- Python3
- PyTorch (> 1.0)
- torchvision (> 0.2)
- NumPy
- OpenCV-contrib-python (4.2.0.32)


### Dataset
```
Please Keep the ImageNet training data in 'datasets/ImageNet/train' and  
test data in 'datasets/ImageNet/val'
```


### Training Example
- ImageNet with 4 NVIDIA GeForce RTX 2080 Ti GPUs 
```
python train.py \
--net_type resnet \
--dataset imagenet \
--batch_size 256 \
--lr 0.1 \
--depth 101 \
--epochs 300 \
--expname ResNet50 \
-j 40 \
--beta 1.0 \
--cutmix_prob 1.0 \
--no-verbose
```

### Test Examples using ImageNet Pretrained models

- Please download the pre-trained model from the following [Dropbox](https://www.dropbox.com/sh/zzo0m9o20bndmaq/AACvk_KyOLJl_T2cCWagivjDa?dl=0)
 link and put then under the folder named 'runs'

- ResNet-50
```
python test.py \
--net_type resnet \
--dataset imagenet \
--batch_size 64 \
--depth 50 \
--pretrained /runs/ResNet50_SaliencyMix_21.26/model_best.pth.tar
```
- ResNet-101
```
python test.py \
--net_type resnet \
--dataset imagenet \
--batch_size 64 \
--depth 101 \
--pretrained /runs/ResNet101_SaliencyMix_20.09/model_best.pth.tar
```
