### Dependencies
Relevant packages can be installed using "pip install -r requirements.txt". Please note that running the RSA analysis additionally requires installing the thingsvision toolbox (https://github.com/ViCCo-Group/THINGSvision).
Please note that running the RSA analysis additionally requires installing the models vs. human toolbox (https://github.com/bethgelab/model-vs-human)
### Training
Model training for the different conditions was initiated using batch scripts. As an example, the batch script "run_econ_res18.sh" starts the training for all conditions on a SLURM based system. An example call for this would be: "./run_econ_res18.sh", which starts all conditions for the standard paradigm of a ResNet-18 on ImageNet. Since this operation requires the availability of a SLURM cluster, we have supplied the file "main_test.ipynb". In this file, the variables for the different conditions have to be set by hand and a model can be trained within the notebook. Please note however that this still requires the availability of the respecitve validation sets. The location of the validation set has to be specified in the file "data.py" under the "init_dataset" function. 

### Analysis
Data analysis was conducted using the "analysis_note.ipynb" notebook. Please note, that for the analysis to be run on a specific paradigm (like "Res18" for the standard ResNet-18 paradigm on ImageNet or "Res18CIFAR" for the standard paradigm on CIFAR-100, the name of this condition has to be specified in the file. Furthermore, after training all models of a paradigm, the folder ending with "Different_data" has to be renamed to end with "Half_data" instead in order for the analysis to perform without errors. Available paradigms are: "Res18" (standard ResNet-18 on ImageNet), "Res18CIFAR" (standard ResNet-18 on CIFAR-100), "Res18fc100" (standard ResNet-18 on our Gaussian dataset), "VGG11" (VGG-11 on ImageNet), and "Dense121" (DenseNet-121 on ImageNet). Additionally, if the RSA analysis is to be repeated, this requires the thingsvision toolbox and access to the ImageNet validation set. If thingsvision is installed, the RSA can be run using the "RSA_note.ipynb" notebook before the analysis notebook is run. 

### Gaussian dataset
The code used in order to generate the Gaussian dataset is included under "MakeTimeSeries.py". 
