#! /usr/bin/env python3
# coding=utf-8


class ILConfig(object):
    output_dir = 'rl_yelp'
    log_name = 'rl_training'

    model_type = 'facebook/bart'
    model_name_or_path = 'yelp_pos2neg_lm_kg_bart_base'
    config_name = 'yelp_pos2neg_lm_kg_bart_base'
    tokenizer_name = 'yelp_pos2neg_lm_kg_bart_base'

    train_data_path = './data/yelp/il/pos2neg/train_yelp_lm_kg_tok300_top06.csv'
    eval_data_path = './data/yelp/il/pos2neg/eval_yelp_lm_kg_tok300_top06.csv'
    test_data_path = './data/yelp/il/pos2neg/test_pos.csv'
    overwrite_cache = False

    cache_dir = 'cached'
    max_source_length = 256
    max_target_length = 256

    max_train_samples = 500

    per_gpu_train_batch_size = 1
    per_gpu_eval_batch_size = 1
    gradient_accumulation_steps = 1
    learning_rate = 5e-5
    weight_decay = 0.0
    adam_epsilon = 1e-8
    max_grad_norm = 1.0
    num_train_epochs = 10
    max_steps = -1
    warmup_steps = 0
    disable_skip = True

    rl_sample_count = 4

    save_total_limit = 3
    no_cuda = False
    overwrite_output_dir = True
    should_continue = False
    seed = 25536

    n_gpu = 1
    gpu_ids = [0]

    local_rank = -1
    fp16 = False
    fp16_opt_level = 'O1'
