#!/bin/bash

#python3 get_candidate.py --tokenizer roberta --data_path ../../data/synthetic_data/matchsum/single_group/christianity/christianity.jsonl --index_path ../../data/synthetic_data/matchsum/single_group/christianity/christianity_step-1.id --write_path ../../data/synthetic_data/matchsum/single_group/christianity/processed/christianity.jsonl --n_cpus 20
#cd ../MatchSum && CUDA_VISIBLE_DEVICES=0 python train_matching.py --mode=test --encoder=roberta --save_path=./roberta/ --gpus=0 --data_path ../../data/synthetic_data/matchsum/multigroup/processed/{g}

groups=("men" "women" "black" "white" "asian" "hispanic" "judaism" "islam" "christianity")
summarizers=("facebook/bart-large-cnn", "google/pegasus-cnn_dailymail")
b=5

for i in $(seq 0.5 0.4 0.9); do

    if [ 1 -eq "$(echo "$i > 0.1 && $i < 0.4" | bc)" ]; then
        b=4;
    elif [ 1 -eq "$(echo "$i > 0.3 && $i < 0.6" | bc)" ]; then
        b=3;
    elif [ 1 -eq "$(echo "$i > 0.5 && $i < 0.9" | bc)" ]; then
        b=2;
    elif [ 1 -eq "$(echo "$i > 0.8" | bc)" ]; then
        b=1;
    fi

    for index in $(seq 0 2 8); do
        #dataset="../data/synthetic_data/articles/${g}.csv"
        g1=${groups[$index]}
        g2=${groups[$index+1]}

        echo "${i} ${g1} ${g2}"

        python3 presumm_summarize.py "../data/synthetic_data/matchsum/single_group/${g1}.txt" $i "../data/synthetic_data/presumm/single_group/${g1}/${i}_${g1}" --device 0 & PID1=$!;
        python3 presumm_summarize.py "../data/synthetic_data/matchsum/single_group/${g2}.txt" $i "../data/synthetic_data/presumm/single_group/${g2}/${i}_${g2}" --device 1 & PID2=$!;
        #python3 textrank_summarize.py --dataset_file $dataset --save_path "../data/synthetic_data/textrank/${i}_${g}.csv" --summary_length_percent $i;
        #python3 summarize.py --model_name facebook/bart-large-cnn --dataset_file $dataset --save_path "../data/synthetic_data/bart/${i}_${g}.csv" --length_percent $i --batch_size 5 --device 0 & PIDBART=$!;
        #python3 summarize.py --model_name google/pegasus-cnn_dailymail --dataset_file $dataset --save_path "../data/synthetic_data/pegasus/${i}_${g}.csv" --length_percent $i --batch_size $b --device 1 & PIDPEG=$!;
        #wait $PIDBART
        #wait $PIDPEG
        wait $PID1
        wait $PID2
        done
    done