# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from typing import List, Tuple
from bosot.configs.kernels.base_kernel_config import BaseKernelConfig
from bosot.kernels.kernel_grammar.kernel_grammar import KernelGrammarOperator
from bosot.kernels.kernel_kernel_grammar_tree import FeatureType


class OptimalTransportGrammarKernelConfig(BaseKernelConfig):
    feature_type_list: List[FeatureType]
    input_dimension: int = 0
    base_variance: float = 1.0
    base_lengthscale: float = 1.0
    base_alpha: float = 0.5
    alpha_trainable: bool = True
    parameters_trainable: bool = True
    transform_to_normal: bool = False
    name = "OptimalTransportGrammarKernel"


class OTWeightedDimsExtendedGrammarKernelConfig(OptimalTransportGrammarKernelConfig):
    feature_type_list: List[FeatureType] = [FeatureType.DIM_WISE_WEIGHTED_ELEMENTARY_COUNT, FeatureType.REDUCED_ELEMENTARY_PATHS, FeatureType.SUBTREES]
    name = "OTWeightedDimsExtendedGrammarKernel"
