# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from typing import Tuple
from bosot.configs.kernels.base_kernel_config import BaseKernelConfig
from bosot.configs.kernels.base_elementary_kernel_config import BaseElementaryKernelConfig


class BasicRQConfig(BaseElementaryKernelConfig):
    base_lengthscale: float = 1.0
    base_variance: float = 1.0
    base_alpha: float = 1.0
    add_prior: bool = False
    lengthscale_prior_parameters: Tuple[float, float] = (2.0, 2.0)
    variance_prior_parameters: Tuple[float, float] = (2.0, 3.0)
    alpha_prior_parameters: Tuple[float, float] = (2.0, 2.0)
    name = "BasicRQ"


class RQWithPriorConfig(BasicRQConfig):
    add_prior: bool = True
    name = "RQWithPrior"
