# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from enum import Enum


class AcquisitionFunctionType(Enum):
    GP_UCB = 1
    EXPECTED_IMPROVEMENT = 2
    RANDOM = 3
    EXPECTED_IMPROVEMENT_PER_SECOND = 4


class ValidationType(Enum):
    MAX_OBSERVED = 1

    @staticmethod
    def get_name(val_type):
        if val_type == ValidationType.MAX_OBSERVED:
            return "MAXOBSERVED"


class AcquisitionOptimizationObjectBOType(Enum):
    TRAILING_CANDIDATES = 1
    EVOLUTIONARY = 2
