# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from pydantic import BaseSettings
from bosot.bayesian_optimization.enums import AcquisitionFunctionType, AcquisitionOptimizationObjectBOType, ValidationType


class BaseObjectBOConfig(BaseSettings):
    acquisition_function_type: AcquisitionFunctionType
    validation_type: ValidationType = ValidationType.MAX_OBSERVED
    acquisiton_optimization_type = AcquisitionOptimizationObjectBOType.TRAILING_CANDIDATES
    population_evolutionary: int = 100
    n_steps_evolutionary: int = 10
    num_offspring_evolutionary: int = 9  # population % (n_offspring+1)==0
    n_prune_trailing: int = 600
    do_plotting: bool = False
    name = "BaseObjectBO"


class ObjectBOExpectedImprovementConfig(BaseObjectBOConfig):
    acquisition_function_type: AcquisitionFunctionType = AcquisitionFunctionType.EXPECTED_IMPROVEMENT
    name = "ExpectedImprovementBO"


class ObjectBOExpectedImprovementEAConfig(ObjectBOExpectedImprovementConfig):
    acquisiton_optimization_type = AcquisitionOptimizationObjectBOType.EVOLUTIONARY
    population_evolutionary: int = 100
    n_steps_evolutionary: int = 10
    num_offspring_evolutionary: int = 4
    name = "ExpectedImprovementBOEA"


class ObjectBOExpectedImprovementEAFewerStepsConfig(ObjectBOExpectedImprovementEAConfig):
    n_steps_evolutionary: int = 6
    name = "ObjectBOExpectedImprovementEAFewerSteps"


class ObjectBOExpectedImprovementPerSecondEAConfig(BaseObjectBOConfig):
    acquisition_function_type: AcquisitionFunctionType = AcquisitionFunctionType.EXPECTED_IMPROVEMENT_PER_SECOND
    acquisiton_optimization_type = AcquisitionOptimizationObjectBOType.EVOLUTIONARY
    population_evolutionary: int = 200
    n_steps_evolutionary: int = 10
    num_offspring_evolutionary: int = 9
    name = "ExpectedImprovementPerSecondBOEA"
