# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from pydantic import BaseSettings


class BaseGreedyKernelSearchConfig(BaseSettings):
    limit_num_visited_neighbours: bool = False
    max_number_of_visited_neigbours: int = 20
    start_with_base_kernels_only: bool = False
    name = "GreedyKernelSearch"


class GreedyKernelSearchBaseInitialConfig(BaseGreedyKernelSearchConfig):
    start_with_base_kernels_only: bool = True
    name = "GreedyKernelSearchBaseInitial"
