# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from bosot.configs.kernels.kernel_grammar_generators.base_kernel_grammar_generator_config import BaseKernelGrammarGeneratorConfig


class CKSHighDimGeneratorConfig(BaseKernelGrammarGeneratorConfig):
    n_initial_factor_trailing: int = 5
    n_exploration_trailing: int = 15
    exploration_p_geometric: float = 1.0 / 3.0
    n_exploitation_trailing: int = 50
    walk_length_exploitation_trailing: int = 5
    do_random_walk_exploitation_trailing: bool = False
    name: str = "CKSHighDimGenerator"
