# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from typing import Tuple
import numpy as np


class BaseObjectOracle:
    def query(self, x: object) -> Tuple[np.float, np.float]:
        """
        Queries the oracle at input object x and gets back the oracle value

        Arguments:
            x : object - General oracle -> input can be any object (not restricted to numbers/arrays)
        Returns:
            np.float - value of oracle at location x
            np.float - time duration of query call in seconds
        """
        raise NotImplementedError
