# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from bosot.configs.models.base_model_config import BaseModelConfig
from bosot.configs.kernels.base_kernel_config import BaseKernelConfig
from bosot.models.gp_model import PredictionQuantity


class BasicGPModelConfig(BaseModelConfig):
    kernel_config: BaseKernelConfig
    observation_noise: float = 0.01
    optimize_hps: bool = True
    train_likelihood_variance: bool = True
    pertube_parameters_at_start: bool = True
    perform_multi_start_optimization: bool = True
    n_starts_for_multistart_opt: int = 5
    set_prior_on_observation_noise: bool = False
    expected_observation_noise: float = 0.1
    prediction_quantity: PredictionQuantity = PredictionQuantity.PREDICT_Y
    name = "GPModel"


class GPModelExtenseOptimization(BasicGPModelConfig):
    n_starts_multi_start_optimization: int = 20
    name = "GPModelExtenseOptimization"


class GPModelFastConfig(BasicGPModelConfig):
    perform_multi_start_optimization: bool = False
    name = "GPModelFast"


class GPModelFixedNoiseConfig(BasicGPModelConfig):
    train_likelihood_variance: bool = False
    name = "GPModelFixedNoise"


if __name__ == "__main__":
    pass
