# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from typing import List, Optional
import gpflow
from abc import ABC, abstractmethod
import tensorflow as tf


class BaseObjectKernel(gpflow.kernels.Kernel, ABC):
    @abstractmethod
    def K(self, X: List[object], X2: Optional[List[object]] = None) -> tf.Tensor:
        raise NotImplementedError

    @abstractmethod
    def K_diag(self, X: List[object]):
        raise NotImplementedError

    def transform_X(self, X: List[object]):
        return X

    def __call__(self, X, X2=None, *, full_cov=True):
        if (not full_cov) and (X2 is not None):
            raise ValueError("Ambiguous inputs: `not full_cov` and `X2` are not compatible.")

        if not full_cov:
            assert X2 is None
            return self.K_diag(X)

        else:
            return self.K(X, X2)
