# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from abc import ABC, abstractmethod
import tensorflow as tf
import numpy as np


class RegularizedKernelInterface(ABC):
    """
    Interface that a kernel needs to admit such that regularizer of the kernel is added to loss in GPModel
    """

    @abstractmethod
    def regularization_loss(self, x_data: np.array) -> tf.Tensor:
        """
        Method for retrieving the loss that should be added to the marginal likelihood loss of a gp (loss is regularizer for kernel HP's)

        Arguments:
        x_data - np.array with anchor input data shape (n,d)

        Returns:
        tf.Tensor - single float tf.Tensor with the loss value
        """
        raise NotImplementedError
