# Copyright (c) 2022 Copyright holder of the paper Structural Kernel Search via Bayesian Optimization and Symbolical Optimal Transport submitted to NeurIPS 2022 for review.
# All rights reserved.
from gpflow import kernels
from scipy.stats.stats import mode
from bosot.configs.models.base_model_config import BaseModelConfig
from bosot.configs.models.gp_model_config import BasicGPModelConfig
from bosot.configs.models.gp_model_laplace_config import BasicGPModelLaplaceConfig
from bosot.models.gp_model import GPModel
from bosot.models.gp_model_laplace import GPModelLaplace
from bosot.kernels.kernel_factory import KernelFactory
from bosot.models.object_gp_model import ObjectGpModel
from bosot.configs.models.object_gp_model_config import BasicObjectGPModelConfig
import gpflow
import numpy as np


class ModelFactory:
    @staticmethod
    def build(model_config: BaseModelConfig):
        if isinstance(model_config, BasicGPModelConfig):
            kernel = KernelFactory.build(model_config.kernel_config)
            model = GPModel(kernel=kernel, **model_config.dict())
            return model
        elif isinstance(model_config, BasicGPModelLaplaceConfig):
            # @TODO: all kernels should be applicaple to laplace and gpmodelmarg
            kernel = KernelFactory.build(model_config.kernel_config)
            model = GPModelLaplace(kernel=kernel, **model_config.dict())
            return model
        elif isinstance(model_config, BasicObjectGPModelConfig):
            kernel = KernelFactory.build(model_config.kernel_config)
            model = ObjectGpModel(kernel=kernel, **model_config.dict())
            return model


if __name__ == "__main__":
    pass
