# Sequential Gradient Coding For Straggler Mitigation

## 0. Creating and Deploying the Cloud Resources on AWS

Requirement:  AWS CLI + SAM CLI toolkit

``` sh
cd 0_create_aws_lambda/sam-efs
python deploy.py -r Canada -p

# Can replace `Canada` by `London`, `Tokyo`, or `Sydney`.
```

This will create a cloudformation stack called sam-gc-cnn, instantiates and sets
up aws resources, and populates EFS folders required to run the experiments.

## 1. Creating Delay Profiles

```sh
cd ./1_create_delay_profiles
python main.py \
    -n 100\
    -w 256\
    -b 4096 \
    -l 0.0 0.25 0.5 0.75 1.0 \
    -c no_forloop \
    -r Canada \
    -f profile_est_desktop_long4_new \
    -s sam-gc-cnn \
    -d 2
```

This will generate (short) delay profiles for finding the parameters of
sequential gradient coding schemes.

Results are saved in `./delay_profiles` directory.

## 2. Find Runtimes

`results.ipynb` generates all the results in the paper.

Note: after finding scheme parameters, 2 csv files are saved in the previously
generated delay profile directory. After this step, delay profiles for the main 
experiment can be generated:

```sh
cd ./1_create_delay_profiles
python main2.py
```