# Supplementary code for "Adversarial Learned Fair Representations using Dampening and Stacking"
This codebase contains all the required Python scripts to replicate the experimental findings of our paper. 
It consists of the following three files which can be run:

- `MNIST_results.py` allows us to get results for the MNIST experiment (section 5.1).
- `MNIST_example.py` allows us to get the censored digit image from the paper (section 5.1).
- `aif360_comparison_study.py` allows us to get all the results of the comparison study (section 5.2)
## Installing dependencies
In order to install the required dependencies, please run the following command:
``pip install -r requirements.txt``

Code has been tested on Python 3.8.0 on Windows and Linux machines.

## Reproducability
This codebase contains some saved models in which all the results from the paper can be reproduced. This code also allows
a user to retrain these models by adding an extra parameter. However, once a model is retrained, results can vary slightly.

### Running MNIST results
- The script `MNIST_results.py` allows us to get results for the MNIST experiment.

    Usage: ```python3 MNIST_results.py [-h] [--train_new TRAIN_NEW] [--device DEVICE]
                       [--num_workers NUM_WORKERS] [--batch_size BATCH_SIZE]```

    ~~~
    Optional arguments:
      -h, --help            show this help message and exit
      --train_new TRAIN_NEW
                            Whether or not to train a new model, or load from
                            disk.
      --device DEVICE       Device to use for training (default "cpu").
      --num_workers NUM_WORKERS
                            How many parallel workers to use for data loading.
      --batch_size BATCH_SIZE
                            Batch size for training.
    ~~~
- The script `MNIST_example.py` allows us to get the censored digit image from the paper.

    Usage: ```python3 MNIST_example.py [-h] [--train_new TRAIN_NEW]```
    
    Run IMDb results.
    
    ~~~
    optional arguments:
      -h, --help            show this help message and exit
      --train_new TRAIN_NEW
                            Whether or not to train a new model, or load from
                            disk.
    ~~~
### Running AIF360 comparisons
- The script `aif360_comparison_study.py` allows us to get results for the AIF360 experiment (section 5.2).

  Usage: ```python3 aif360_comparison_study.py [-h] [--run_adult RUN_ADULT] [--run_german RUN_GERMAN]
                       [--run_bank RUN_BANK] [--run_compas RUN_COMPAS]```
  

Note that in order to run `adult`/`german`/`bank`/`compas` studies, the appropriate datasets have to be
downloaded and placed in the correct folder. More information can be found here: https://github.com/Trusted-AI/AIF360/tree/master/aif360/data.

More implementation details on the specific algorithms can be found here https://aif360.readthedocs.io/en/latest/modules/algorithms.html#module-aif360.algorithms.preprocessing



