# Implicit Autoencoder for Point Cloud Self-supervised Representation Learning 

<div align="center">
  <img width="100%" alt="IAE Pipeline" src="imgs/main_figure.png">
</div>

This codebase contains the PyTorch implementation of our paper: Implicit Autoencoder for Point Cloud Self-supervised Representation Learning.

## Installation

Our code is tested with Ubuntu 18.04, Python 3.6.7, Pytorch v1.4.0, TensorFlow v1.14, and CUDA 10.1.

First you have to make sure that you have all dependencies in place.

You can create an anaconda environment called `iae` using
```
conda env create -f environment.yaml
conda activate iae
```
**Note**: you might need to install **torch-scatter** mannually following [the official instruction](https://github.com/rusty1s/pytorch_scatter#pytorch-140):
```
pip install torch-scatter==2.0.4 -f https://pytorch-geometric.com/whl/torch-1.4.0+cu101.html
```

To compile the CUDA layers for PointNet++
```
cd src/encoder/pointnet2

python setup.py install
```

## Datasets

We pre-train our model on two different datasets, ShapeNet and ScanNet, for different downstream tasks. Please refer to `datasets` for more details.

## Usage

To train our model, run:
```
python train.py CONFIG.yaml
```
We provide different model config files under `configs` folder.

## Downstream Tasks

Please refer to README.md under `downstream_tasks` folders.

