import torch

def vadd(vec1, vec2):
    return [(v1+v2).clone().detach() for v1, v2 in zip(vec1, vec2)]

def compute_sub(vec1, vec2):
    return [(v1-v2).clone().detach() for v1, v2 in zip(vec1, vec2)]

def compute_cosdist(vec1, vec2):
    v1v1 = 0
    v2v2 = 0
    v1v2 = 0
    for v1, v2 in zip(vec1, vec2):
        v1 = v1.clone().detach()
        v2 = v2.clone().detach()
        v1v1 += (v1*v1).sum()
        v2v2 += (v2*v2).sum()
        v1v2 += (v1*v2).sum()
    return 1. - (v1v2 / (v1v1.sqrt() * v2v2.sqrt() + 1e-20))

def compute_eucdist(vec1, vec2):
    l2sum = 0
    for v1, v2 in zip(vec1, vec2):
        diff = (v1-v2).clone().detach()
        l2sum += max((diff*diff).sum(),0)
    return l2sum.sqrt()

def compute_len(vec):
    l2sum = 0
    for v in vec:
        v = v.clone().detach()
        l2sum += max((v*v).sum(),0)
    return l2sum.sqrt()

def compute_abs_mean(vec):
    abs_mean = 0.
    count = 0.
    for v in vec:
        v = v.clone().detach().view(-1)
        count += v.size(0)
        abs_mean += v.abs().sum()
    return abs_mean / (count + 1e-20)
