#!/bin/bash

# Script for setting up Gurobi after running install_tool.sh

if [[ -z "${VNNCOMP_PYTHON_PATH}" ]]; then
	VNNCOMP_PYTHON_PATH=/home/ubuntu/miniconda/envs/alpha-beta-crown/bin
fi

# Get the license from the url which is the final output of install_tool.sh
# The url should be visited from a university network
# Update the license below when the evaluation is paused
cat > gurobi.lic <<EOF
# DO NOT EDIT THIS FILE except as noted
#
# License ID 2391139
#
# Place this file in your home directory that takes precedence
# or in one of the following shared locations:
#    * C:\gurobi\ on Windows
#    * /opt/gurobi/ on Linux
#    * /Library/gurobi/ on Mac OS X
# Or set the environment variable GRB_LICENSE_FILE to point to this file,
# it will override the default locations
#
TYPE=ACADEMIC
VERSION=10
HOSTNAME=ip-172-31-2-36
HOSTID=f05ea16f
USERNAME=ubuntu
EXPIRATION=2024-06-26
KEY=CARGFDTM
CKEY=CARGFDTM
EOF

# Make sure this is the default location for license
# Default location can be found in the license
sudo mkdir -p /opt/gurobi
sudo mv gurobi.lic /opt/gurobi/

if grep -q "Using license file /opt/gurobi/gurobi.lic" <<< "$(${VNNCOMP_PYTHON_PATH}/gurobi_cl)"; then
	echo "license setup is successful"
fi