# EPIC

This folder contains codes that reproduces the main results of EPIC in Table 1.

| Datasets | #Layers | Performance  |
| -------- | ------- | ------------ |
| Arxiv    | 3       | 73.06 ± 0.13 |
| Products | 7       | 78.58 ± 0.27 |
| Proteins | 60      | 85.85 ± 0.09 |

## Arxiv

### Dependencies

- Python 3.7.4
- Pytorch 1.13.1+cu116
- PyG 2.2.0
- ogb 1.3.6

### Knowledge from the Teacher

**Due to the size limitations for supplementary materials, the folder does not contain the knowledge files currently. We will supplement these files if this paper is accepted.**

- `[your_path]/codes_epic/arxiv/examples/ogb_eff/ogbn_arxiv/teacher/teacher.pth`: The well-trained parameters of the teacher.

- `[your_path]/codes_epic/arxiv/examples/ogb_eff/ogbn_arxiv/teacher/embs_t.npy`: The final embeddings of the teacher on train and valid nodes.
- `[your_path]/codes_epic/arxiv/examples/ogb_eff/ogbn_arxiv/teacher/logits.npy`: The logits of the teacher on train and valid nodes.

### Reproduction of the Results

cd [your_path]/codes_epic/arxiv/examples/ogb_eff/ogbn_arxiv

python distill.py --use_gpu --conv_encode_edge --block res+ --gcn_aggr max --num_layers 3 --hidden_channels 256 --lr 1e-3 --backbone jkrev --dropout 0.5 --group 2 --device 0 --self_loop --cluster_number 1 --valid_cluster_number 1 --r_t 1e-2 --r_e 1e-2 --norm batch --runs 5

CUDA_VISIBLE_DEVICES=2 python distill_tran.py --use_gpu --conv_encode_edge --block res+ --gcn_aggr max --num_layers 3 --hidden_channels 256 --lr 1e-3 --backbone jkrev --dropout 0.5 --group 2 --device 0 --self_loop --cluster_number 1 --valid_cluster_number 1 --r_t 1e-2 --r_e 1e-2 --norm batch --runs 1

CUDA_VISIBLE_DEVICES=3 python distill.py --use_gpu --conv_encode_edge --block res+ --gcn_aggr max --num_layers 1 --hidden_channels 256 --lr 1e-3 --backbone jkrev --dropout 0.5 --group 2 --device 0 --self_loop --cluster_number 1 --valid_cluster_number 1 --r_t 1e-2 --r_e 1e-2 --norm batch --runs 1

CUDA_VISIBLE_DEVICES=5 python distill.py --use_gpu --conv_encode_edge --block res+ --gcn_aggr max --num_layers 3 --hidden_channels 256 --lr 1e-3 --backbone jkrev --dropout 0.5 --group 2 --device 0 --self_loop --cluster_number 1 --valid_cluster_number 1 --r_t 1e-2 --r_e 1e-2 --norm batch --runs 1

## Products

### Dependencies

- Python 3.8.17
- Pytorch 1.12.0+cu113
- PyG 2.1.0
- ogb 1.3.6

### Knowledge from the Teacher

**Due to the size limitations for supplementary materials, the folder does not contain the knowledge files currently. We will supplement these files if this paper is accepted.**

### Reproduction of the Results

python distill.py --num_layers 7 --hidden_channels 320 --norm batch --r_t 1e-2 --r_e 1e-3 --test_num_parts 1 --train_num_parts 10 --seed 0

python distill.py --num_layers 7 --hidden_channels 320 --norm batch --r_t 1e-2 --r_e 1e-3 --test_num_parts 1 --train_num_parts 10 --seed 1

python distill.py --num_layers 7 --hidden_channels 320 --norm batch --r_t 1e-2 --r_e 1e-3 --test_num_parts 1 --train_num_parts 10 --seed 2

python distill.py --num_layers 7 --hidden_channels 320 --norm batch --r_t 1e-2 --r_e 1e-3 --test_num_parts 1 --train_num_parts 10 --seed 3

python distill.py --num_layers 7 --hidden_channels 320 --norm batch --r_t 1e-2 --r_e 1e-3 --test_num_parts 1 --train_num_parts 10 --seed 4

## Proteins

### Dependencies

- Python 3.7.4
- Pytorch 1.13.1+cu116
- PyG 2.2.0
- ogb 1.3.6

### Knowledge from the Teacher

**Due to the size limitations for supplementary materials, the folder does not contain the knowledge files currently. We will supplement these files if this paper is accepted.**

- `[your_path]/codes_epic/proteins/examples/ogb_eff/ogbn_proteins/teacher/teacher.pth`: The well-trained parameters of the teacher.

- `[your_path]/codes_epic/proteins/examples/ogb_eff/ogbn_proteins/teacher/embs_t.npy`: The final embeddings of the teacher on train and valid nodes.
- `[your_path]/codes_epic/proteins/examples/ogb_eff/ogbn_proteins/teacher/train_logits.npy`: The logits of the teacher on train nodes.
- `[your_path]/codes_epic/proteins/examples/ogb_eff/ogbn_proteins/teacher/valid_logits.npy`: The logits of the teacher on valid nodes.

### Reproduction of the Results

cd [your_path]/codes_epic/proteins/examples/ogb_eff/ogbn_proteins

python distill.py --use_gpu --conv_encode_edge --block res+ --gcn_aggr max --num_layers 60 --hidden_channels 160 --lr 1e-3 --backbone jkrev --dropout 1e-3 --group 2 --device 0 --cluster_number 10 --valid_cluster_number 5 --r_t 1e-2 --r_e 1e-3 --norm batch --runs 5