# URT


## Dependencies
This code requires the following:
* Python 3.6 or greater
* PyTorch 1.0 or greater
* TensorFlow 1.14 or greater


## Installation
Configure Meta-Dataset:
    * Follow the the "User instructions" in the Meta-Dataset repository (https://github.com/google-research/meta-dataset) for "Installation" and "Downloading and converting datasets". Brace yourself, the full process would take around a day.
    * If you want to test out-of-domain behavior on additional datasets, namely, MNIST, CIFAR10, CIFAR100, follow the installation instructions in the [CNAPs repository](https://github.com/cambridge-mlg/cnaps) to get these datasets. This step is takes little time and we recommended to do it.

## Getting the Feature Extractors
1. The easiest way is to download SUR's pre-trained models and use them to obtain a universal set of features directly. If that is what you want, execute the following command in the root directory of this project:```wget http://thoth.inrialpes.fr/research/SUR/all_weights.zip && unzip all_weights.zip && rm all_weights.zip```
It will donwnload all the weights and place them in the `./weights` directory.

2. Alternatively, instead of using the pretrained models, one can train the models from scratch following this [SUR repository](https://github.com/dvornikita/SUR).

## Train and evaluate URT
1. speed up training via dumping features for every episode: ```bash ./scripts/pre-extract-feature.sh resnet18 ${cache_dir}``` 
2. run URT: ```bash ./fast-scripts/urt-avg-head.sh ${log_dir} ${num_head} ${cache_dir}```
