# A Markov Decision Process for variable selection in Branch and bound

## Installation

See installation instructions [here](INSTALL.md).

## Generating instances

Although we included evaluation instances in the `./data/` folder, you can generate your own instances.
We provide a script in the `./scripts/` folder to generate instances for on the ecole benchmark.

```
# Generate MILP instances
sh generate_instances.py 
```

## Running the experiments

For a given TYPE in {SetCovering, CombinatorialAuction, MaximumIndependentSet, MultipleKnapsack},
and a given AGENT in {dqn_bbmdp, dqn_retro, dqn_tMDP, pg_tMDP, il}, run scripts in the `./scripts/`
folder to reproduce experiments on the Ecole benchmark.

```
# Evaluation
sh run_benchmark.sh $TYPE $AGENT

# Training (only for reinforcement learning DQN agents)
sh run_dqn_trainer.sh $TYPE $AGENT

```

Both evaluation and training performance can be monitored from the folder located in `./experiments/logs/$TYPE/`.
