#!/bin/bash

# [ t2v-turbo ]
output_root="./results/multi_k/k10/vc2/"
eval_sections=("count")   #  "color" "count"

for section in "${eval_sections[@]}"
do
    CUDA_VISIBLE_DEVICES=1,2,3 python main_iter.py \
                        --output_root="$output_root" \
                        --eval_section="$section" \
                        --model='videocrafter2' \
                        --load_molmo \
                        --selection_score='dsg_blip' \
                        --seed=123 \
                        --round=1 \
                        --k=10 \
                        --div_seeds

    CUDA_VISIBLE_DEVICES=1 python collect_best.py --output_root="$output_root" --eval_section="$section" --data='evalcrafter' --round=1
done


