import math
import numpy as np


def smooth(scalars, weight):
    last = 0
    smoothed = []
    for num_acc, next_val in enumerate(scalars):
        last = last * weight + (1 - weight) * next_val
        smoothed.append(last / (1 - math.pow(weight, num_acc+1)))
    smoothed = np.array(smoothed)
    return smoothed


###
# A[0] = 0
# D[0] = 1
# A[t+1] = w * A[t] + (1-w) * X[t]
# D[t+1] = w * D[t]
# S[t] = A[t] / D[t]

# A[t] = w * A[t-1] + (1-w) * X[t-1]

###

def smooth_v2(scalars, weight):
    last = 0
    delta = 1

    smoothed = []
    for val in scalars:
        last = last * weight + (1 - weight) * val
        delta = delta * weight
        smoothed.append(last / (1 - delta))
        
    smoothed = np.array(smoothed)
    return smoothed
    

a = np.random.rand(8)
a.sort()
print("a:", a, a.shape)
b = smooth(a, 0.9)
print("b:", b, b.shape)
c = smooth_v2(a, 0.9)

print("c:", c, c.shape)
print("b == c:", np.allclose(b, c))
