# Weakly-Supervised Affordance Grounding Guided by Part-Level Semantic Priors

This is the PyTorch implementation of our ICLR 2025 submission "Weakly-Supervised Affordance Grounding Guided by Part-Level Semantic Priors"

## Data preparation

Please follow [LOCATE](https://github.com/Reagan1311/LOCATE) to prepare the AGD20K datasets. 

We will provide the original and refined pseudo labels, the detected object bounding boxes, and the pre-extracted language features in the Github repo.

Please download the pre-trained ViT-B/16 weights from [CLIP](https://openaipublic.azureedge.net/clip/models/5806e77cd80f8b59890b7e101eabd078d9fb84e6937f9e85e4ecb61988df416f/ViT-B-16.pt).

## Prerequisites

The code is based on torch=1.10.0+cu111, torchvision=0.11.0+cu111, and numpy, opencv-python, PyYAML, tqdm, Pillow.


## Training

To train the model, run:

```
python train.py --config configs/seen.yaml --seed 100
```

or

```
python train.py --config configs/unseen.yaml --seed 100
```

for the seen/unseen split.

Please modify the paths in the .yaml files to the locations of the datasets and pre-trained ViT weights.

## Testing

To test the trained model, run:

```
python eval.py --config configs/test_seen.yaml
```

or

```
python eval.py --config configs/test_unseen.yaml
```

Please modify the paths in the .yaml files to the locations of the datasets and the trained model weights.



The trained weights will also be provided in our Github repo.

## Acknowledgement

We sincerely thank the codebase of [CLIP](https://github.com/openai/CLIP/), [SAM](https://github.com/facebookresearch/segment-anything/tree/main), and [LOCATE](https://github.com/Reagan1311/LOCATE).