# VLMLight

## Folder Structure

* **sim\_envs**: Contains the experimental environments.
* **rl\_tsc**: Directory for training the reinforcement learning (RL) traffic signal control (TSC) policy.
* **vla\_tsc\_en** & **vla\_tsc\_zh**: Directories for TSC Agents in English and Chinese, respectively.

## Running the Code

To train the RL model from scratch, first run the following command to train the RL policy:

```bash
python ./rl_tsc/train_rl_tsc.py
```

### Default Configuration

The default configuration for different traffic scenarios is as follows:

```python
SCENARIO_CONFIGS = {
    "Hongkong_YMT": {
        "SCENARIO_NAME": "Hongkong_YMT",
        "NETFILE": "ymt_eval",
        "JUNCTION_NAME": "J1",
        "PHASE_NUMBER": 4
    },
    "SouthKorea_Songdo": {
        "SCENARIO_NAME": "SouthKorea_Songdo",
        "NETFILE": "songdo_eval",
        "JUNCTION_NAME": "J2",
        "PHASE_NUMBER": 4
    },
    "France_Massy": {
        "SCENARIO_NAME": "France_Massy",
        "NETFILE": "massy_eval",
        "JUNCTION_NAME": "INT1",
        "PHASE_NUMBER": 3
    }
}
```

### Configuring the LLM (Language Model)

Next, configure the LLM settings in the `llm_cfg` and `llm_cfg_json` files. Example configuration for the language model:

```python
llm_cfg = {
    'model': 'Qwen/Qwen2.5-72B-Instruct-AWQ',
    'model_type': 'oai',
    'model_server': 'http://localhost:5060/v1',
    'api_key': 'token-abc123',

    'generate_cfg': {
        'top_p': 0.8,
    }
}  # Language Model

llm_cfg_json = {
    'model': 'Qwen/Qwen2.5-72B-Instruct-AWQ',
    'model_type': 'oai',
    'model_server': 'http://localhost:5060/v1',
    'api_key': 'token-abc123',

    'generate_cfg': {
        'top_p': 0.8,
        'response_format': {"type": "json_object"},
    }
}  # Language Model

vlm_cfg = {
    'model': 'Qwen/Qwen2.5-VL-32B-Instruct-AWQ',
    'model_type': 'qwenvl_oai',
    'model_server': 'http://localhost:5030/v1',
    'api_key': 'token-abc123',

    'generate_cfg': {
        'top_p': 0.8,
    }
}  # Vision Language Model
```

### Running VLMLight

Finally, run the core VLMLight code using the following command:

```bash
python ./vla_tsc_en/decision_3dtsc.py
```

This will initiate the VLMLight TSC framework for decision-making based on the trained RL policies and LLM configurations.
