
diverse_basic_prompt = '''
Write three diverse and persuasive counterarguments against the given argument.

Given argument: {input}

Instructions:
1. The counterargument must be logically sound, respectful in tone, and directly challenge the original argument.
2. Do not use any first-person language (e.g., "I", "we").
3. Instead, let the reasoning, tone, and examples naturally reflect a broader worldview or perspective.
4. Each counterargument should be at least 10 sentences long but under 500 tokens.
5. Focus on making the counterargument clear, well-reasoned, and persuasive to the original author.

Format your response as follows:

Counterargument 1:
[First counterargument]

Counterargument 2:
[Second counterargument]

Counterargument 3:
[Third counterargument]
'''

diverse_strategy_prompt = '''
Write three diverse and persuasive counterarguments against the given argument, each based on a different argumentation strategy.

Given argument: {input}

Available strategies include:
[Argument From Analogy, Argument From Best Explanation, Argument From Cause to Effect, Argument From Expert Opinion, Argument From Example, Argument From Ignorance, Argument From Position to Know, Argument From Popular Opinion, Argument From Popular Practice, Argument From Precedent, Argument From Established Rule, Argument From Sunk Costs, Argument From Sign, Argument From Threat, Argument From Verbal Classification, Argument From Waste, Argument From Witness Testimony, Direct ad Hominem, Inconsistent Commitment, Slippery Slope]

Instructions:
1. The counterargument must be logically sound, respectful in tone, and directly challenge the original argument.
2. Do not use any first-person language (e.g., "I", "we").
3. Instead, let the reasoning, tone, and examples naturally reflect a broader worldview or perspective.
4. Each counterargument should be at least 10 sentences long but under 500 tokens.
5. Focus on making the counterargument clear, well-reasoned, and persuasive to the original author.

Format your response as follows:

Counterargument 1 (Strategy: [Name]):
[First counterargument]

Counterargument 2 (Strategy: [Name]):
[Second counterargument]

Counterargument 3 (Strategy: [Name]):
[Third counterargument]
'''

diverse_op_prompt = '''
Write three diverse and persuasive counterarguments against the given argument and author's persona.
Given argument: {input}
Author's Persona: {author_persona}

You will be given three different personas. Your task is to write one counterargument from each persona's values, perspective or experiences.

Please follow these instructions:
1. Create three counterarguments that directly refute or challenge the argument.
2. Ensure that each counterargument is self-contained, logically sound, and at least 10 sentences long.
3. Each counterargument must be clearly distinct from the others, based on the persona provided.
4. Begin with a clear signal of the perspective (e.g., "Someone like (persona) might argue that…", "(Persona) might claim that…"). Avoid first-person expressions such as "As a (persona),". Let the persona's identity emerge through tone, reasoning, and illustrative examples.

Format your response exactly as follows:

Counterargument 1:
[First counterargument]

Counterargument 2:
[Second counterargument]

Counterargument 3:
[Third counterargument]
'''

diverse_op_and_persona_prompt = '''
Write three diverse and persuasive counterarguments against the given argument, taking into account the persona of the argument's author.

Given argument: {input}
Author's Persona: {author_persona}

Write a detailed and persuasive counterargument from the given persona’s perspective.
Do not use any first-person language (e.g., "I", "we", "as a").
Let the persona’s worldview emerge through tone, logic, and examples.
Aim to write in a way that could realistically persuade the original author, while keeping the tone respectful and well-reasoned.
You should consider the author when writing, but remember that the author persona is only an inferred estimation and should not be directly included in the content.
The counterargument must be at least 10 sentences and under 500 tokens.

Counterargument 1 (Persona: {persona_1}):
[First counterargument]

Counterargument 2 (Persona: {persona_2}):
[Second counterargument]

Counterargument 3 (Persona: {persona_3}):
[Third counterargument]
'''


diverse_op_and_persona_prompt = '''
Write three diverse and persuasive counterarguments against the given argument and author's persona.
Given argument: {input}
Author's Persona: {author_persona}

Write a detailed and persuasive counterargument.
Do not use any first-person language (e.g., "I", "we", "as a").
Aim to write in a way that could realistically persuade the original author, while keeping the tone respectful and well-reasoned.
You should consider the author when writing, but remember that the author persona is only an inferred estimation and should not be directly included in the content.
The counterargument must be at least 10 sentences and under 500 tokens.

Format your response exactly as follows:

Counterargument 1 (Persona: {persona_1}):
[First counterargument]

Counterargument 2 (Persona: {persona_2}):
[Second counterargument]

Counterargument 3 (Persona: {persona_3}):
[Third counterargument]
'''