# Coverage Report

Total executable lines: 2
Covered lines: 2
Missed lines: 0
Coverage percentage: 100.00%

## Source Code with Coverage

```python
1: ✓ def DoubleQuadruple(x):
2: ✓     return (2 * x, 4 * x)
```

## Complete Test File

```python
def DoubleQuadruple(x):
    return (2 * x, 4 * x)

def run_tests():
    test_results = []
    # Test case 1
    try:
        result = DoubleQuadruple(0)
        assert result == '(0, 0)', f"Test 1 failed: got {result}, expected {'(0, 0)'}"
        print(f"Test 1 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 1 failed: {e}")
        test_results.append(False)

    # Test case 2
    try:
        result = DoubleQuadruple(1)
        assert result == '(2, 4)', f"Test 2 failed: got {result}, expected {'(2, 4)'}"
        print(f"Test 2 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 2 failed: {e}")
        test_results.append(False)

    # Test case 3
    try:
        result = DoubleQuadruple(-1)
        assert result == '(-2, -4)', f"Test 3 failed: got {result}, expected {'(-2, -4)'}"
        print(f"Test 3 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 3 failed: {e}")
        test_results.append(False)

    # Test case 4
    try:
        result = DoubleQuadruple(10)
        assert result == '(20, 40)', f"Test 4 failed: got {result}, expected {'(20, 40)'}"
        print(f"Test 4 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 4 failed: {e}")
        test_results.append(False)

    # Test case 5
    try:
        result = DoubleQuadruple(-5)
        assert result == '(-10, -20)', f"Test 5 failed: got {result}, expected {'(-10, -20)'}"
        print(f"Test 5 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 5 failed: {e}")
        test_results.append(False)

    return test_results

if __name__ == '__main__':
    results = run_tests()
    print(f"\n{sum(results)}/{len(results)} tests passed")

```
