# Coverage Report

Total executable lines: 8
Covered lines: 8
Missed lines: 0
Coverage percentage: 100.00%

## Source Code with Coverage

```python
1: ✓ def isSublist(sub, main):
2: ✓     n, m = len(sub), len(main)
3: ✓     if n == 0:
4: ✓         return True
5: ✓     for i in range(m - n + 1):
6: ✓         if main[i:i+n] == sub:
7: ✓             return True
8: ✓     return False
```

## Complete Test File

```python
def isSublist(sub, main):
    n, m = len(sub), len(main)
    if n == 0:
        return True
    for i in range(m - n + 1):
        if main[i:i+n] == sub:
            return True
    return False

def run_tests():
    test_results = []
    # Test case 1
    try:
        result = isSublist([1, 2], [3, 1, 2, 4])
        assert result == True, f"Test 1 failed: got {result}, expected {True}"
        print(f"Test 1 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 1 failed: {e}")
        test_results.append(False)

    # Test case 2
    try:
        result = isSublist([2, 3], [3, 1, 2, 4])
        assert result == False, f"Test 2 failed: got {result}, expected {False}"
        print(f"Test 2 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 2 failed: {e}")
        test_results.append(False)

    # Test case 3
    try:
        result = isSublist([3, 1], [3, 1, 2, 4])
        assert result == True, f"Test 3 failed: got {result}, expected {True}"
        print(f"Test 3 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 3 failed: {e}")
        test_results.append(False)

    # Test case 4
    try:
        result = isSublist([4], [3, 1, 2, 4])
        assert result == True, f"Test 4 failed: got {result}, expected {True}"
        print(f"Test 4 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 4 failed: {e}")
        test_results.append(False)

    # Test case 5
    try:
        result = isSublist([5], [3, 1, 2, 4])
        assert result == False, f"Test 5 failed: got {result}, expected {False}"
        print(f"Test 5 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 5 failed: {e}")
        test_results.append(False)

    # Test case 6
    try:
        result = isSublist([], [3, 1, 2, 4])
        assert result == True, f"Test 6 failed: got {result}, expected {True}"
        print(f"Test 6 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 6 failed: {e}")
        test_results.append(False)

    # Test case 7
    try:
        result = isSublist([1, 2], [])
        assert result == False, f"Test 7 failed: got {result}, expected {False}"
        print(f"Test 7 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 7 failed: {e}")
        test_results.append(False)

    # Test case 8
    try:
        result = isSublist([], [])
        assert result == True, f"Test 8 failed: got {result}, expected {True}"
        print(f"Test 8 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 8 failed: {e}")
        test_results.append(False)

    return test_results

if __name__ == '__main__':
    results = run_tests()
    print(f"\n{sum(results)}/{len(results)} tests passed")

```
