# Coverage Report

Total executable lines: 6
Covered lines: 6
Missed lines: 0
Coverage percentage: 100.00%

## Source Code with Coverage

```python
1: ✓ def DivisionFunction(x, y):
2: ✓     if y == 0:
3: ✓         return (x, 0)
4: ✓     q = x // y
5: ✓     r = x % y
6: ✓     return (r, q)
```

## Complete Test File

```python
def DivisionFunction(x, y):
    if y == 0:
        return (x, 0)
    q = x // y
    r = x % y
    return (r, q)

def run_tests():
    test_results = []
    # Test case 1
    try:
        result = DivisionFunction(10, 3)
        assert result == '(1, 3)', f"Test 1 failed: got {result}, expected {'(1, 3)'}"
        print(f"Test 1 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 1 failed: {e}")
        test_results.append(False)

    # Test case 2
    try:
        result = DivisionFunction(15, 5)
        assert result == '(0, 3)', f"Test 2 failed: got {result}, expected {'(0, 3)'}"
        print(f"Test 2 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 2 failed: {e}")
        test_results.append(False)

    # Test case 3
    try:
        result = DivisionFunction(7, 2)
        assert result == '(1, 3)', f"Test 3 failed: got {result}, expected {'(1, 3)'}"
        print(f"Test 3 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 3 failed: {e}")
        test_results.append(False)

    # Test case 4
    try:
        result = DivisionFunction(0, 4)
        assert result == '(0, 0)', f"Test 4 failed: got {result}, expected {'(0, 0)'}"
        print(f"Test 4 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 4 failed: {e}")
        test_results.append(False)

    # Test case 5
    try:
        result = DivisionFunction(10, 0)
        assert result == '(10, 0)', f"Test 5 failed: got {result}, expected {'(10, 0)'}"
        print(f"Test 5 passed")
        test_results.append(True)
    except Exception as e:
        print(f"Test 5 failed: {e}")
        test_results.append(False)

    return test_results

if __name__ == '__main__':
    results = run_tests()
    print(f"\n{sum(results)}/{len(results)} tests passed")

```
