import sys
sys.path.append("/home/XXX/agent/audio/audio_attack/src/models")
sys.path.append("/home/ec2-user/agent/audio/audio_attack/src/models")
import torch
import torch.nn as nn
from fairseq.models.text_to_speech.vocoder import CodeHiFiGANVocoder
import soundfile as sf
from typing import List
import argparse
import logging
import json
from tqdm import tqdm
import os
import re
import traceback
from peft import PeftModel
import sys
sys.path.append('/home/XXX/agent/AudioAttack/models_audio/speechgpt')
sys.path.append('/home/ec2-user/agent/AudioAttack/models_audio/speechgpt')
from utils.speech2unit.speech2unit import Speech2Unit
import transformers
from transformers import AutoConfig, LlamaForCausalLM, LlamaTokenizer, GenerationConfig
import torch._dynamo
torch._dynamo.config.suppress_errors = True


logging.basicConfig()
logging.root.setLevel(logging.INFO)
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)



NAME="SpeechGPT"
META_INSTRUCTION="You are an AI assistant whose name is SpeechGPT.\n- SpeechGPT is a intrinsic cross-modal conversational language model that is developed by Fudan University.  SpeechGPT can understand and communicate fluently with human through speech or text chosen by the user.\n- It can perceive cross-modal inputs and generate cross-modal outputs.\n"
DEFAULT_GEN_PARAMS = {
        "max_new_tokens": 1024,
        "min_new_tokens": 10,
        # "max_length": 2048,
        "temperature": 0.8,
        "do_sample": True, 
        "top_k": 60,
        "top_p": 0.8,
        }  
device = torch.device('cuda')


def extract_text_between_tags(text, tag1='[SpeechGPT] :', tag2='<eoa>'):
    pattern = f'{re.escape(tag1)}(.*?){re.escape(tag2)}'
    match = re.search(pattern, text, re.DOTALL)
    if match:
        response = match.group(1)
    else:
        response = ""
    return response



class SpeechGPTInference:
    def __init__(
        self, 
        model_name_or_path: str,
        lora_weights: str=None,
        s2u_dir: str="speechgpt/utils/speech2unit/",
        vocoder_dir: str="speechgpt/utils/vocoder/", 
        output_dir="speechgpt/output/"
        ):
        
        self.meta_instruction = META_INSTRUCTION
        self.template= "[Human]: {question}{optim_suffix}<eoh>. [SpeechGPT]: "


        #speech2unit
        self.s2u = Speech2Unit(ckpt_dir=s2u_dir)
        
        #model
        self.model = LlamaForCausalLM.from_pretrained(
            model_name_or_path,
            load_in_8bit=False,
            torch_dtype=torch.bfloat16,
            device_map="cuda:0",
            )

        if lora_weights is not None:
            self.model = PeftModel.from_pretrained(
                self.model,
                lora_weights,
                torch_dtype=torch.float16,
                device_map="auto",
            )

        self.model.half()  

        self.model.eval()
        # if torch.__version__ >= "2" and sys.platform != "win32":
        #     self.model = torch.compile(self.model)

        #tokenizer
        self.tokenizer = LlamaTokenizer.from_pretrained(
            model_name_or_path)
        self.tokenizer.pad_token_id = (0)
        self.tokenizer.padding_side = "left" 


        #generation
        self.generate_kwargs = DEFAULT_GEN_PARAMS


        #vocoder
        vocoder = os.path.join(vocoder_dir, "vocoder.pt")
        vocoder_cfg = os.path.join(vocoder_dir, "config.json")
        with open(vocoder_cfg) as f:
            vocoder_cfg = json.load(f)
        self.vocoder = CodeHiFiGANVocoder(vocoder, vocoder_cfg).to(device)

        self.output_dir = output_dir

        self.embedding_layer = self.model.get_input_embeddings()


    def preprocess(
        self,
        raw_text,
        optim_suffix = "",
    ):

        processed_parts = []
        if isinstance(raw_text, List) and len(raw_text)==2:
            processed_parts.append(self.s2u(raw_text[0].strip(), merged=True)[:-6] + self.s2u(raw_text[1].strip(), merged=True)[6:])
        elif isinstance(raw_text, str):
            for part in raw_text.split("is input:"):
                if os.path.isfile(part.strip()) and os.path.splitext(part.strip())[-1] in [".wav", ".flac", ".mp4"]:
                    processed_parts.append(self.s2u(part.strip(), merged=True))
                else:
                    processed_parts.append(part)
        else:
            raise ValueError(f"typeerror by {raw_text}")
        processed_text = "is input:".join(processed_parts)

        prompt_seq = self.meta_instruction + self.template.format(question=processed_text, optim_suffix=optim_suffix)
        return prompt_seq

    def preprocess_jailbreak(
        self,
        raw_text: str,
        optim_suffix: str="",
    ):
        processed_parts = []
        if isinstance(raw_text, List) and len(raw_text) == 2:
            processed_parts.append(
                self.s2u(raw_text[0].strip(), merged=True)[:-6] + self.s2u(raw_text[1].strip(), merged=True)[6:])
        elif isinstance(raw_text, str):
            for part in raw_text.split("is input:"):
                if os.path.isfile(part.strip()) and os.path.splitext(part.strip())[-1] in [".wav", ".flac", ".mp4"]:
                    processed_parts.append(self.s2u(part.strip(), merged=True))
                else:
                    processed_parts.append(part)
        else:
            raise ValueError(f"typeerror by {raw_text}")
        processed_text = "is input:".join(processed_parts)

        self.template_jailbreak_1 = "[Human]: {question}"
        self.template_jailbreak_2 = "<eoh>. [SpeechGPT]: "
        prompt_seq_1 = self.meta_instruction + self.template_jailbreak_1.format(question=processed_text)
        prompt_seq_1 = prompt_seq_1[:-6]
        prompt_seq_2 = "<eosp>" + self.template_jailbreak_2 + self.prompt_ori + " [ta] "
        # prompt_seq_2 = "<eosp>" + self.template_jailbreak_2 + " [ta] "
        return prompt_seq_1, prompt_seq_2

    def preprocess_jailbreak_universal(
        self,
        raw_text: str,
        prompt_text: str,
        optim_suffix: str="",
    ):
        processed_parts = []
        if isinstance(raw_text, List) and len(raw_text) == 2:
            processed_parts.append(
                self.s2u(raw_text[0].strip(), merged=True)[:-6] + self.s2u(raw_text[1].strip(), merged=True)[6:])
        elif isinstance(raw_text, str):
            for part in raw_text.split("is input:"):
                if os.path.isfile(part.strip()) and os.path.splitext(part.strip())[-1] in [".wav", ".flac", ".mp4"]:
                    processed_parts.append(self.s2u(part.strip(), merged=True))
                else:
                    processed_parts.append(part)
        else:
            raise ValueError(f"typeerror by {raw_text}")
        processed_text = "is input:".join(processed_parts)

        self.template_jailbreak_1 = "[Human]: {question}"
        self.template_jailbreak_2 = "<eoh>. [SpeechGPT]: "
        prompt_seq_1 = self.meta_instruction + self.template_jailbreak_1.format(question=processed_text)
        prompt_seq_1 = prompt_seq_1[:-6]
        prompt_seq_2 = "<eosp>" + self.template_jailbreak_2 + prompt_text + " [ta] "
        # prompt_seq_2 = "<eosp>" + self.template_jailbreak_2 + " [ta] "
        return prompt_seq_1, prompt_seq_2

    def postprocess(
        self,
        response: str,
    ):

        # question = extract_text_between_tags(response, tag1="[Human]", tag2="<eoh>")
        # answer = extract_text_between_tags(response + '<eoa>', tag1=f"[SpeechGPT] :", tag2="<eoa>")
        # tq = extract_text_between_tags(response, tag1="[SpeechGPT] :", tag2="; [ta]") if "[ta]" in response else ''
        # ta = extract_text_between_tags(response, tag1="[ta]", tag2="; [ua]") if "[ta]" in response else ''
        # ua = extract_text_between_tags(response + '<eoa>', tag1="[ua]", tag2="<eoa>") if "[ua]" in response else ''

        question = extract_text_between_tags(response, tag1="[Human]", tag2="<eoh>")
        answer = extract_text_between_tags(response + '<eoa>', tag1=f"[ta]", tag2="[ua]") if "[ua]" in response and '[ta]' in response else ""
        ua = extract_text_between_tags(response + '<eoa>', tag1="[ua]", tag2="<eoa>") if "[ua]" in response else ''

        return {"question":question, "answer":answer, "unitAnswer":ua}


    def forward(
        self, 
        prompts: List[str],
        audio_save_path: str
    ):

        with torch.no_grad():
            #preprocess
            preprocessed_prompts = []
            for prompt in prompts:
                preprocessed_prompts.append(self.preprocess(prompt))

            # print('preprocessed_prompts')
            # print(preprocessed_prompts)
            input_ids = self.tokenizer(preprocessed_prompts, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids


            for input_id in input_ids:
                if input_id[-1] == 2:
                    input_id = input_id[:, :-1]

            input_ids = input_ids.to(device)

            #generate
            generation_config = GenerationConfig(
                temperature=0.7,
                top_p=0.8,
                top_k=50,
                do_sample=True,
                max_new_tokens=2048,
                min_new_tokens=10,
                )

            generated_ids = self.model.generate(
                input_ids=input_ids,
                generation_config=generation_config,
                return_dict_in_generate=True,
                output_scores=True,
                max_new_tokens=1024,
                do_sample=False
            )
            generated_ids = generated_ids.sequences
            responses = self.tokenizer.batch_decode(generated_ids.cpu(), skip_special_tokens=True)



            raw_response = responses[0]
            #postprocess
            responses = [self.postprocess(x) for x in responses]
            r = responses[0]

            try:
                res = r["answer"].split('[ta]')[1].strip()
            except:
                res = r["answer"].strip()

            #save repsonses
            # init_num = sum(1 for line in open(f"{self.output_dir}/responses.json", 'r')) if os.path.exists(f"{self.output_dir}/responses.json") else 0
            # with open(f"{self.output_dir}/responses.json", 'a') as f:
            #     for r in responses:
            #         if r["textAnswer"] != "":
            #             print("Transcript:", r["textQuestion"])
            #             print("Text response:", r["textAnswer"])
            #         else:
            #             print("Response:\n", r["answer"])
            #         json_line = json.dumps(r)
            #         f.write(json_line+'\n')

            #dump wav
            wav = torch.tensor(0)
            os.makedirs(f"{self.output_dir}/wav/", exist_ok=True)
            for i, response in enumerate(responses):
                if '<sosp>' in response['unitAnswer']:
                    unit = [int(num) for num in re.findall(r'<(\d+)>', response['unitAnswer'])]
                    x = {
                            "code": torch.LongTensor(unit).view(1, -1).to(device),
                        }
                    wav = self.vocoder(x, True)
                    self.save_wav(wav, audio_save_path)

            # print(f"Response json is saved in {self.output_dir}/responses.json")

        return raw_response
        # return 16000, wav.detach().cpu().numpy()

    def compute_token_gradient(self, optim_ids, num_universal=25):
        optim_ids_onehot = torch.nn.functional.one_hot(optim_ids, num_classes=self.embedding_layer.num_embeddings)
        optim_ids_onehot = optim_ids_onehot.to(dtype=self.model.dtype, device=self.model.device)
        optim_ids_onehot.requires_grad_()
        optim_embeds = optim_ids_onehot @ self.embedding_layer.weight
        input_embeds = torch.cat([self.input_embeds_1, optim_embeds.repeat(num_universal, 1, 1), self.input_embeds_2, self.target_embeds], dim=1).to(device)
        generated_ids = self.model(
            inputs_embeds=input_embeds,
        )


        logits = generated_ids.logits

        shift = input_embeds.shape[1] - self.target_ids.shape[1]
        shift_logits = logits[..., shift - 1:-1, :].contiguous()  # (1, num_target_ids, vocab_size)
        shift_labels = self.target_ids.to(device)

        # temp
        # token_ids = torch.argmax(shift_logits, dim=-1)
        # print(f'tokens')
        # print(self.tokenizer.batch_decode(token_ids))
        # print(self.tokenizer.batch_decode(shift_labels))
        # print(shift_logits.shape)
        # print(shift_labels.shape)

        loss = torch.nn.functional.cross_entropy(shift_logits.view(-1, shift_logits.size(-1)),
                                                 shift_labels.view(-1))
        optim_ids_onehot_grad = torch.autograd.grad(outputs=[loss], inputs=[optim_ids_onehot])[0]
        del generated_ids
        torch.cuda.empty_cache()
        return optim_ids_onehot_grad

    def sample_ids_from_grad(self,
            ids,
            grad,
            search_width = 256,
            topk = 128,
            n_replace = 1,
    ):
        n_optim_tokens = len(ids)
        original_ids = ids.repeat(search_width, 1)

        # topk_ids = (-grad[:, :]).topk(topk, dim=1).indices

        self.audio_ids = list(range(32000,33000))
        topk_ids = (-grad[:,self.audio_ids]).topk(topk, dim=1).indices + 32000


        sampled_ids_pos = torch.argsort(torch.rand((search_width, n_optim_tokens), device=grad.device))[..., :n_replace]
        sampled_ids_val = torch.gather(
            topk_ids[sampled_ids_pos],
            2,
            torch.randint(0, topk, (search_width, n_replace, 1), device=grad.device)
        ).squeeze(2)

        new_ids = original_ids.scatter_(1, sampled_ids_pos, sampled_ids_val)


        return new_ids

    def compute_candidates_loss(self, input_embeds):
        with torch.no_grad():
            generated_ids = self.model(
                inputs_embeds=input_embeds,
            )

            logits = generated_ids.logits

            shift = input_embeds.shape[1] - self.target_ids.shape[1]
            shift_logits = logits[..., shift - 1:-1, :].contiguous()  # (1, num_target_ids, vocab_size)
            shift_labels = self.target_ids.to(device).repeat(shift_logits.shape[0],1)
            loss = torch.nn.functional.cross_entropy(shift_logits.view(-1, shift_logits.size(-1)),
                                                     shift_labels.view(-1), reduction="none")
            loss = loss.reshape(input_embeds.shape[0], -1).mean(-1)

            # print(input_embeds.shape)
            # print(loss.shape)
            # print()
            return loss



    def jailbreak(self, optim_ids, num_epoch=50):
        losses = []
        ids = []
        best_loss, best_id = 1e10, optim_ids
        qbar = tqdm(range(num_epoch))
        for ep in qbar:
            # Compute the token gradient
            optim_ids_onehot_grad = self.compute_token_gradient(optim_ids)


            if ep < int(0.2 * num_epoch):
                nrep = int(0.1 * self.num_token_suffix)
            elif int(0.2 * num_epoch) < ep and ep < int(0.3 * num_epoch):
                nrep = int(0.05 * self.num_token_suffix)
            else:
                nrep = 1
            with torch.no_grad():
                # Sample candidate token sequences based on the token gradient
                sampled_ids = self.sample_ids_from_grad(
                    optim_ids.squeeze(0),
                    optim_ids_onehot_grad.squeeze(0),
                    n_replace= nrep
                )

                # if config.filter_ids:
                #     sampled_ids = filter_ids(sampled_ids, tokenizer)

                new_search_width = sampled_ids.shape[0]

                # Compute loss on all candidate sequences
                batch_size = 32
                start = 0
                losses = []
                while start < new_search_width:
                    input_embeds = torch.cat([
                        self.input_embeds_1.repeat(batch_size, 1, 1),
                        self.embedding_layer(sampled_ids[start:start+batch_size]),
                        self.input_embeds_2.repeat(batch_size, 1, 1),
                        self.target_embeds.repeat(batch_size, 1, 1),
                    ], dim=1)

                    loss = self.compute_candidates_loss(input_embeds)
                    losses.append(loss)
                    start += batch_size
                loss = torch.concatenate(losses)
                current_loss = loss.min().item()
                optim_ids = sampled_ids[loss.argmin()].unsqueeze(0)
                # Update the buffer based on the loss
                losses.append(current_loss)
                ids.append(optim_ids)

                qbar.set_description(f'loss: {current_loss}')

                # print(f'loss: {current_loss}')
                # print(f'id: {optim_ids}')

                if current_loss < best_loss:
                    best_loss = current_loss
                    best_id = optim_ids

            optim_ids = best_id
            torch.cuda.empty_cache()
        return best_id

    def compute_token_gradient_universal(self, optim_ids, num_universal=25):
        optim_ids_onehot = torch.nn.functional.one_hot(optim_ids, num_classes=self.embedding_layer.num_embeddings)
        optim_ids_onehot = optim_ids_onehot.to(dtype=self.model.dtype, device=self.model.device)
        optim_ids_onehot.requires_grad_()


        st = 0
        k = min(5, num_universal)
        cnt = 0
        optim_ids_onehot_grad = None
        while st + k <= num_universal:
            optim_ids_onehot_grad = optim_ids_onehot.detach()
            optim_embeds = optim_ids_onehot @ self.embedding_layer.weight
            input_embeds = torch.cat([self.input_embeds_1[st:st+k], optim_embeds.repeat(k, 1, 1), self.input_embeds_2[st:st+k], self.target_embeds[st:st+k]], dim=1).to(device)
            generated_ids = self.model(
                inputs_embeds=input_embeds,
            )
            logits = generated_ids.logits

            shift = input_embeds.shape[1] - self.target_ids.shape[1]
            shift_logits = logits[..., shift - 1:-1, :].contiguous()  # (1, num_target_ids, vocab_size)
            shift_labels = self.target_ids.to(device)[st:st+k]
            loss = torch.nn.functional.cross_entropy(shift_logits.view(-1, shift_logits.size(-1)),
                                                     shift_labels.view(-1))
            if optim_ids_onehot_grad == None:
                optim_ids_onehot_grad = torch.autograd.grad(outputs=[loss], inputs=[optim_ids_onehot])[0].detach().clone()
            else:
                optim_ids_onehot_grad += torch.autograd.grad(outputs=[loss], inputs=[optim_ids_onehot])[0].detach().clone()
            st += k
            cnt += 1
        del generated_ids
        torch.cuda.empty_cache()
        return optim_ids_onehot_grad / cnt

    def compute_candidates_loss_universal(self, input_embeds, st, end, past_key_values=None):
        with torch.no_grad():

            generated_ids = self.model(
                inputs_embeds=input_embeds,
                past_key_values = past_key_values,
            )

            logits = generated_ids.logits
            shift = input_embeds.shape[1] - self.target_ids.shape[1]
            shift_logits = logits[..., shift - 1:-1, :].contiguous()  # (1, num_target_ids, vocab_size)
            shift_labels = self.target_ids[st:end].to(device).repeat(logits.shape[0],1)
            loss = torch.nn.functional.cross_entropy(shift_logits.view(-1, shift_logits.size(-1)),
                                                     shift_labels.view(-1), reduction="none")
            # print("loss.shape")
            # print(loss.shape)
            loss = loss.reshape(input_embeds.shape[0], -1)
            # weights = torch.linspace(1, 0.1, loss.shape[1]).unsqueeze(0).to(loss.device)
            # loss = loss * weights
            loss = loss.mean(-1)
            return loss

    def jailbreak_universal(self, optim_ids, num_epoch=50, num_universal=25):
        losses_records = []
        ids_records = []
        ids = []
        best_loss, best_id = 1e10, optim_ids
        qbar = tqdm(range(num_epoch))
        # past_key_values_all = []
        for ep in qbar:
            # Compute the token gradient
            optim_ids_onehot_grad = self.compute_token_gradient_universal(optim_ids, num_universal=num_universal)

            if ep < int(0.2 * num_epoch):
                nrep = int(0.1 * self.num_token_suffix)
            elif int(0.2 * num_epoch) < ep and ep < int(0.3 * num_epoch):
                nrep = int(0.05 * self.num_token_suffix)
            else:
                nrep = 1
            with torch.no_grad():
                # Sample candidate token sequences based on the token gradient
                sampled_ids = self.sample_ids_from_grad(
                    optim_ids.squeeze(0),
                    optim_ids_onehot_grad.squeeze(0),
                    n_replace= nrep,
                    search_width=256,
                )

                # if config.filter_ids:
                #     sampled_ids = filter_ids(sampled_ids, tokenizer)

                new_search_width = sampled_ids.shape[0]

                # Compute loss on all candidate sequences
                batch_size = self.batch_size
                losses = []
                for j in range(num_universal):
                    start = 0

                    input_embeds_prefix = torch.cat([
                        self.input_embeds_1[j:j + 1].repeat(batch_size, 1, 1),
                    ], dim=1)
                    outputs_prefix = self.model(
                        inputs_embeds=input_embeds_prefix,
                        use_cache=True
                    )
                    past_key_values = outputs_prefix.past_key_values
                    del outputs_prefix
                    # past_key_values_all.append(tuple([tuple([t.cpu() for t in layer]) for layer in past_key_values]))

                    # past_key_values = self.jailbreak_kv_cache[j]

                    while start < new_search_width:
                        input_embeds = torch.cat([
                            # self.input_embeds_1[j:j+1].repeat(batch_size, 1, 1),
                            self.embedding_layer(sampled_ids[start:start+batch_size]),
                            self.input_embeds_2[j:j+1].repeat(batch_size, 1, 1),
                            self.target_embeds[j:j+1].repeat(batch_size, 1, 1),
                        ], dim=1)

                        loss = self.compute_candidates_loss_universal(input_embeds, j, j+1, past_key_values)
                        # print(loss)
                        if j==0:
                            losses.append(loss)
                        else:
                            for idx in range(batch_size):
                                losses[idx+start] += loss[idx]
                        start += batch_size
                    if j==0:
                        losses = torch.concatenate(losses)
                losses = losses / num_universal
                current_loss = losses.min().item()
                optim_ids = sampled_ids[losses.argmin()].unsqueeze(0)
                # Update the buffer based on the loss
                losses_records.append(current_loss)
                ids.append(optim_ids)

                qbar.set_description(f'loss: {current_loss}')

                # print(f'loss: {current_loss}')
                # print(f'id: {optim_ids}')

                if current_loss < best_loss:
                    best_loss = current_loss
                    best_id = optim_ids

                # if current_loss < 0.2:
                #     break

            optim_ids = best_id
            torch.cuda.empty_cache()
        return best_id, losses, ids

    def compute_kv_cache(self):
        self.jailbreak_kv_cache = []
        for j in range(self.num_universal):
            input_embeds_prefix = torch.cat([
                        self.input_embeds_1[j:j + 1].repeat(self.batch_size, 1, 1),
                    ], dim=1)
            outputs_prefix = self.model(
                inputs_embeds=input_embeds_prefix,
                use_cache=True
            )
            past_key_values = outputs_prefix.past_key_values
            self.jailbreak_kv_cache.append(past_key_values)
            del outputs_prefix

    def jailbreak_forward(
        self,
        prompts: List[str],
        audio_save_path: str,
        ori_prompt,
        audio_jailbreak_init,
        num_token_suffix = 100,
        num_epochs = 50,
    ):

        self.num_token_suffix = num_token_suffix

        # target = ori_prompt + "; [ta] Sure! I can help you with that"
        # target = "Sure, I can help you with that. These are the steps"
        target = "Sure, I can provide you with step-by-step instructions"
        # target = "Sure!"

        self.prompt_ori = ori_prompt

        #preprocess
        prompts_1, prompts_2 = self.preprocess_jailbreak(prompts[0])
        prompts_1 = [prompts_1]
        prompts_2 = [prompts_2]
        prompts_jailbreak_init, _ = self.preprocess_jailbreak(audio_jailbreak_init)
        prompts_jailbreak_init = [prompts_jailbreak_init]

        # print("prompts_1")
        # print(prompts_1)
        # print("prompts_jailbreak_init")
        # print(prompts_jailbreak_init)


        input_ids_1 = self.tokenizer(prompts_1, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        input_ids_2 = self.tokenizer(prompts_2, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        input_ids_jailbreak_init = self.tokenizer(prompts_jailbreak_init, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        self.target_ids = self.tokenizer(target, return_tensors="pt", padding=True, max_length=512, truncation=True, add_special_tokens=False).input_ids



        for input_id in input_ids_1:
            if input_id[-1] == 2:
                input_id = input_id[:, :-1]
        for input_id in input_ids_2:
            if input_id[-1] == 2:
                input_id = input_id[:, :-1]

        input_ids_1 = input_ids_1.to(device)
        input_ids_2 = input_ids_2.to(device)
        self.target_ids = self.target_ids.to(device)

        self.input_embeds_1 = self.embedding_layer(input_ids_1)
        self.input_embeds_2 = self.embedding_layer(input_ids_2)
        self.target_embeds = self.embedding_layer(self.target_ids)

        optim_ids = input_ids_jailbreak_init[:,len(input_ids_1):].to(device)
        optim_ids = torch.tensor([[32500] * num_token_suffix]).to(device)
        # optim_ids = input_ids_1[:,-50:].clone().to(device)

        # print('optim_ids.shape')
        # print(optim_ids.shape)


        optim_ids = self.jailbreak(optim_ids, num_epochs)

        input_ids = torch.concatenate([input_ids_1, optim_ids, input_ids_2], dim=1)

        generation_config = GenerationConfig(
            # temperature=0.7,
            # top_p=0.8,
            # top_k=50,
            do_sample=False,
            max_new_tokens=2048,
            min_new_tokens=10,
        )

        generated_ids = self.model.generate(
            input_ids=input_ids,
            generation_config=generation_config,
            return_dict_in_generate=True,
            output_scores=True,
            max_new_tokens=1024,
            do_sample=False
        )
        generated_ids = generated_ids.sequences

        responses = self.tokenizer.batch_decode(generated_ids.cpu(), skip_special_tokens=True)
        res = responses[0]


        # print(f'raw responese')
        # print(responses)
        #
        # #postprocess
        responses = [self.postprocess(x) for x in responses]
        # r = responses[0]
        #
        # res = r["answer"]


        #dump wav
        wav = torch.tensor(0)
        os.makedirs(f"{self.output_dir}/wav/", exist_ok=True)
        for i, response in enumerate(responses):
            if '<sosp>' in response['unitAnswer']:
                unit = [int(num) for num in re.findall(r'<(\d+)>', response['unitAnswer'])]
                x = {
                        "code": torch.LongTensor(unit).view(1, -1).to(device),
                    }
                wav = self.vocoder(x, True)
                self.save_wav(wav, audio_save_path)

        return res

    def universal_jailbreak_forward(
        self,
        prompts: List[str],
        audio_save_path: List[str],
        ori_prompt,
        audio_jailbreak_init,
        num_token_suffix = 100,
        num_epochs = 50,
        num_universal = 5,
    ):

        self.num_universal = num_universal
        self.batch_size = 64

        self.num_token_suffix = num_token_suffix
        target = "Sure, I can provide you with step-by-step instructions: first,"
        # target = "Sure, I can help you with that. Here is a step-by-step guide on how to make a bomb:"


        self.prompt_ori = ori_prompt

        #preprocess
        prompts_1, prompts_2 = [], []
        for i in range(len(prompts)):
            p1, p2 = self.preprocess_jailbreak_universal(prompts[i], self.prompt_ori[i])
            prompts_1.append(p1)
            prompts_2.append(p2)
        # prompts_jailbreak_init, _ = self.preprocess_jailbreak_universal(audio_jailbreak_init)
        # prompts_jailbreak_init = [prompts_jailbreak_init]

        # print(prompts_1)
        # print(prompts_2)

        input_ids_1 = self.tokenizer(prompts_1, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        input_ids_2 = self.tokenizer(prompts_2, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        # input_ids_jailbreak_init = self.tokenizer(prompts_jailbreak_init, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        self.target_ids = self.tokenizer(target, return_tensors="pt", padding=True, max_length=512, truncation=True, add_special_tokens=False).input_ids

        # initialization
        # self.prompt_ori = "xxx"
        # tp1= self.preprocess('/home/XXX/agent/AudioAttack/dataload/test.wav')
        # print(tp1)
        # ip1 = self.tokenizer([tp1], return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        # print(ip1)
        # exit()

        for input_id in input_ids_1:
            if input_id[-1] == 2:
                input_id = input_id[:, :-1]
        for input_id in input_ids_2:
            if input_id[-1] == 2:
                input_id = input_id[:, :-1]

        input_ids_1 = input_ids_1.to(device)
        input_ids_2 = input_ids_2.to(device)
        self.target_ids = self.target_ids.to(device).repeat(len(prompts), 1)


        self.input_embeds_1 = self.embedding_layer(input_ids_1)
        self.input_embeds_2 = self.embedding_layer(input_ids_2)
        self.target_embeds = self.embedding_layer(self.target_ids)

        # optim_ids = input_ids_jailbreak_init[:,len(input_ids_1):].to(device)
        initial = [[32063, 32644, 32389, 32771, 32685, 32384, 32488, 32443, 32912, 32085, 32866, 32586, 32362, 32059, 32663, 32787, 32935, 32271, 32333, 32523, 32918, 32233, 32337, 32431, 32531, 32074, 32803, 32791, 32087, 32164, 32726, 32755, 32584, 32819, 32619]
                  + [32918, 32233, 32337, 32431, 32531, 32074, 32803, 32791, 32087, 32164, 32726, 32755, 32584, 32819, 32619]]
        optim_ids = torch.tensor(initial).to(device)
        # optim_ids = torch.tensor([[32500] * num_token_suffix]).to(device)

        # self.compute_kv_cache()
        optim_ids, loss_records, id_records = self.jailbreak_universal(optim_ids, num_epochs, num_universal=self.num_universal)

        input_ids = torch.concatenate([input_ids_1, optim_ids.repeat(len(prompts), 1), input_ids_2], dim=1)

        generation_config = GenerationConfig(
            # temperature=0.7,
            # top_p=0.8,
            # top_k=50,
            do_sample=False,
            max_new_tokens=2048,
            min_new_tokens=10,
        )

        generated_ids = self.model.generate(
            input_ids=input_ids,
            generation_config=generation_config,
            return_dict_in_generate=True,
            output_scores=True,
            max_new_tokens=1024,
            do_sample=False
        )
        generated_ids = generated_ids.sequences

        responses = self.tokenizer.batch_decode(generated_ids.cpu(), skip_special_tokens=True)
        original_responses = responses.copy()

        responses = [self.postprocess(x) for x in responses]


        #dump wav
        wav = torch.tensor(0)
        os.makedirs(f"{self.output_dir}/wav/", exist_ok=True)
        for i, response in enumerate(responses):
            if '<sosp>' in response['unitAnswer']:
                unit = [int(num) for num in re.findall(r'<(\d+)>', response['unitAnswer'])]
                x = {
                        "code": torch.LongTensor(unit).view(1, -1).to(device),
                    }
                wav = self.vocoder(x, True)
                self.save_wav(wav, audio_save_path[i])
        # print(len(self.prompt_ori))
        # print(len(id_records))
        # print(len(losses))
        # return original_responses, [ {"prompt": self.prompt_ori[i], "ids": id_records[i]} for i in range(len(prompts))]
        return original_responses, []

    def final_forward(
        self,
        prompts,
        audio_save_path,
        prompt_ori
    ):
        self.prompt_ori = prompt_ori
        prompts_1, prompts_2 = self.preprocess_jailbreak(prompts[0])
        prompts_1 = [prompts_1]
        prompts_2 = [prompts_2]

        # print('prompts_1')
        # print(prompts_1)
        # print('prompts_2')
        # print(prompts_2)

        input_ids_1 = self.tokenizer(prompts_1, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids
        input_ids_2 = self.tokenizer(prompts_2, return_tensors="pt", padding=True, max_length=512, truncation=True).input_ids

        for input_id in input_ids_1:
            if input_id[-1] == 2:
                input_id = input_id[:, :-1]
        for input_id in input_ids_2:
            if input_id[-1] == 2:
                input_id = input_id[:, :-1]

        input_ids_1 = input_ids_1.to(device)
        input_ids_2 = input_ids_2.to(device)

        self.input_embeds_1 = self.embedding_layer(input_ids_1)
        self.input_embeds_2 = self.embedding_layer(input_ids_2)
        input_ids = torch.concatenate([input_ids_1, input_ids_2], dim=1)

        generation_config = GenerationConfig(
            # temperature=0.7,
            # top_p=0.8,
            # top_k=50,
            do_sample=False,
            max_new_tokens=2048,
            min_new_tokens=10,
        )

        generated_ids = self.model.generate(
            input_ids=input_ids,
            generation_config=generation_config,
            return_dict_in_generate=True,
            output_scores=True,
            max_new_tokens=1024,
            do_sample=False
        )
        generated_ids = generated_ids.sequences

        responses = self.tokenizer.batch_decode(generated_ids.cpu(), skip_special_tokens=True)
        res = responses[0]

        responses = [self.postprocess(x) for x in responses]

        #dump wav
        wav = torch.tensor(0)
        os.makedirs(f"{self.output_dir}/wav/", exist_ok=True)
        for i, response in enumerate(responses):
            if '<sosp>' in response['unitAnswer']:
                unit = [int(num) for num in re.findall(r'<(\d+)>', response['unitAnswer'])]
                x = {
                        "code": torch.LongTensor(unit).view(1, -1).to(device),
                    }
                wav = self.vocoder(x, True)
                self.save_wav(wav, audio_save_path)

        return res


    def dump_wav(self, sample_id, pred_wav, prefix):
        sf.write(
            f"{self.output_dir}/wav/{prefix}_{sample_id}.wav",
            pred_wav.detach().cpu().numpy(),
            16000,
        )

    def save_wav(self, wav, path):
        sf.write(
            path,
            wav.detach().cpu().numpy(),
            16000,
        )
        
    def __call__(self, input):
        return self.forward(input)

    
    def interact(self):
        prompt = str(input(f"Please talk with {NAME}:\n"))
        while prompt != "quit":
            try:
                self.forward([prompt])
            except Exception as e:
                traceback.print_exc()
                print(e)

            prompt = str(input(f"Please input prompts for {NAME}:\n"))
            

            
if __name__=='__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("--model-name-or-path", type=str, default="")
    parser.add_argument("--lora-weights", type=str, default=None)
    parser.add_argument("--s2u-dir", type=str, default="speechgpt/utils/speech2unit/")
    parser.add_argument("--vocoder-dir", type=str, default="speechgpt/utils/vocoder/")
    parser.add_argument("--output-dir", type=str, default="speechgpt/output/")
    args = parser.parse_args()
    
    os.makedirs(args.output_dir, exist_ok=True)


    infer = SpeechGPTInference(
        args.model_name_or_path,
        args.lora_weights,
        args.s2u_dir,
        args.vocoder_dir,
        args.output_dir
    )

    infer.interact()