# Benchmarking

This module contains scripts with CLI tools for batched benchmarks for training and reconstruction quality evaluation in `benchmarking.py` as well as downstream performance benchmarks in `downstream_benchmarking.py`.

## Training and Reconstruction Quality
| Argument      | Description                                                                                        | Options                                                   | Default        |
|---------------|----------------------------------------------------------------------------------------------------|-----------------------------------------------------------|----------------|
| dim_reduction | Takes a latent-ratio value which determines the ratio between input dimension and latent dimension | $$\text{Number} \in (0,1]$$                              | 0.505          |
| data_path     | Path to the locally downloaded and processed datasets                                              | path/to/datasets (String)                                 | artifacts/data |
| models        | Takes a space separated list of model names                                                        | StandardAE, DeepCAE, JointVAE, PCA, TransformerAE, ConvAE | ALL            |
| max_epochs    | Maximum number of epochs for training                                                              | $$\text{Number} \in \N^+$$                              | 800            |


### Examples
To train all models on all datasets with a 50.5% latent-ratio simply use the following command:
```
python -m benchmarking.benchmarking
```

To run benchmarking for a subset of models (e.b. JointVAE and PCA) use:
```
python -m benchmarking.benchmarking --models JointVAE PCA
```

## Downstream Prediction Performance

The downstream predictions are run for all available datasets and corresponding embeddings. The CLI tool takes the following arguments:

| Argument        | Description                                           | Options                     | Default              |
|-----------------|-------------------------------------------------------|-----------------------------|----------------------|
| embeddings_path | Path to the embeddings generated by the autoencoders  | path/to/embeddings (String) | artifacts/embeddings |
| data_path       | Path to the locally downloaded and processed datasets | path/to/datasets (String)   | artifacts/data       |

### Examples

To run the downstream prediction tasks for each of the datasets use the following command:
```
python -m benchmarking.downstream_benchmarking

```

## Plotting

For plotting, the following command could be used (make sure to replace FinalResults with your results dir):
```
python -m benchmarking.utils.plots_and_tables --result_file_name FinalBenchmarking
```
To ensure you can plot with Times New Roman font, go these steps when working on a UNIX device that does not have this font installed (e.g. an EC2 instance):

1. Install the new font:
```
sudo apt-get update
sudo apt-get install ttf-mscorefonts-installer
```

2. Delete the old font-list. Sometimes the name is slightly different:
```
rm ~/.cache/matplotlib/fontList.json
```

3. Re-new font cache:
```
sudo fc-cache -fv
```

Now run the plotting again, and verify it uses the right font family.
