# Dataset Information
# The goal of this dataset is to predict maximum water depth for flood modelling. 
# The dataset contains 673 hourly rainfall events time series which are used to predict the maximum water depth of a domain (Digital Elevation Model, DEM).
# The rainfall events and DEM are generated synthetically by researchers at Monash University because real DEM data with accurate rainfall events are rare. 
#
# Data Donor
# Jihane Elyahyioui, jihane.elyahyioui@monash.edu
@problemname FloodModeling1
@timestamps false
@missing false
@univariate true
@equallength true
@targetlabel true
@data
0.190118275,0.278452167,0.36494119700000005,0.44635393,0.519787268,0.582824302,0.633666574,0.671233258,0.695221419,0.7061235570000001,0.705200835,0.694412788,0.676306634,0.653871532,0.630365127,0.609121327,0.593349448,0.585935552,0.589256904,0.605020035,0.63413192,0.676612227,0.731552665,0.7971271409999999,0.870653868,0.948707918,1.02728003,1.10197501,1.16824084,1.22161766,1.25799471,1.27386227,1.26654562,1.23440864,1.17701551,1.09524099,0.99132177,0.8688440609999999,0.7326655209999999,0.588772768,0.444078714,0.306166973,0.18299330600000002,0.0825562786,0.0125511146,0.0,0.0,0.050335313300000004,0.16116314199999998,0.32496983,0.54131837,0.807810702,1.12010165,1.47199272,1.85560341,2.26161421,2.67957241,3.09824878,3.50603112,3.89133866,4.24304052,4.55086107,4.80575526,5.000238700000001,5.12865864,5.18739486,5.17498217,5.09214995,4.94177728,4.72876609,4.45983806,4.14326447,3.78854051,3.40601837,3.00651463,2.60090845,2.19974749,1.81287751,1.44911055,1.11594479,0.8193463009999999,0.5636004179999999,0.351237012,0.18303070100000002,0.058073674299999996,0.0,0.0,0.0,0.0,0.0,3.85051896e-16,0.0528086316,0.10716036400000001,0.157768468,0.200189776,0.230979805,0.247791261,0.249413506,0.23575350399999997,0.207761534,0.16730757699999999,0.11701650599999999,0.0600719466,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,6.4175316e-17,0.0551824097,0.10659119,0.15132437199999998,0.186891886,0.211350487,0.223406605,0.222481915,0.208738516,0.183062826,0.14700950699999998,0.102708921,0.0527434878,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.85051896e-16,0.0524090341,0.101977085,0.145848996,0.181479148,0.20677591399999998,0.22022202,0.22096424,0.20886745399999998,0.184530024,0.14925949,0.10500971199999999,0.0542826667,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0214280552,0.103324625,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
0.44362301,2.39413786,0.0,0.0,0.32292562,0.286182571,0.0,0.0,0.0,0.565279958,0.70356376,0.424802387,3.45988818,1.04555762,3.17994264,0.8545293340000001,0.0,0.0,0.0,0.0875216614,0.0,0.0,0.0,0.668048352,0.42461343799999995,0.0,0.0,0.701567547,0.0866894951,0.0,0.0,0.599018753,0.0,0.479904051,0.0,2.47350034,1.33606214,0.0,0.0,1.96500875,1.25574079,0.0,0.0,0.0,1.9343546999999999,1.94019029,4.82945753,7.8381849,4.32577842,0.0141452749,0.695396861,0.6811164670000001,0.0,0.686853026,1.18835483,0.0,0.0,0.0,0.35728810899999996,0.0,0.0,0.614399949,0.0,1.75332042,0.0,2.11324621,0.0,0.0,0.0138228256,0.0,0.0,1.35909703,0.0,0.0,0.399937728,3.40052741,0.82558974,0.0,0.0,0.0,0.0,0.0933102366,0.0,0.0,0.114329882,0.0,0.0,0.292511123,2.01156103,0.0,0.428541856,1.2746431,0.0585704005,0.0,0.42227136299999996,0.0,1.28925967,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.82879869,0.0,0.0,0.50595419,1.19148405,0.0,1.06981801,0.04834087,0.0,0.32902504,0.98968806,0.26102562,0.23421220000000004,0.0,0.79337143,0.76225504,0.80459619,0.22022209,0.61995627,0.45506082,0.0,0.21417070000000005,0.0,0.89978281,0.0,0.19785052,0.0,0.0,0.248689,0.0,0.0,0.71332583,0.24574899999999997,0.0,0.96544884,0.0,0.0,0.32627057,0.0,0.43733028,0.0,0.75897253,0.0,0.0,0.0,0.50347925,0.0,0.20732470000000003,0.0,0.08082312,0.91340709,0.6479351999999999,0.16244496,0.0,0.2521319,0.43119207,0.0,0.46979349,0.0,0.62720075,0.0,0.22491506,0.0,0.0,0.0,0.0,0.0,0.49028339,0.26332019,0.29297449,0.0,1.6805880000000002,1.92566,0.50452604,3.26815872,2.61456763,3.70293181,2.52917916,3.01285962,3.48790388,1.85376511,1.27863883,1.62541241,0.0,0.20430743,0.5142428,0.0,0.0,0.0,0.0,0.47554323,0.0,0.0,0.0,0.45700222,0.78328658,0.02826481,0.0,0.21626041,0.06136905,0.97195235,0.0,0.0,1.0506746999999999,0.16461195,0.0,0.0,0.34425326,0.24982172,0.0,0.0,1.02512245,0.82996003,0.0,0.19906108,0.05044477,0.7777246999999999,0.72515171,1.38328298,0.0,0.15374138,0.03675797,0.86811788,1.10615796,0.0,0.58766246,0.54599498,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.0119677073,0.144831904,0.47257558,0.863097426,1.14755446,1.19566236,0.971205213,0.545310971,0.0642078272,0.0,0.0,0.0,0.0,0.104321527,0.297607382,0.33755826899999997,0.226127259,0.0295085671,0.0,0.0,0.0,0.0,0.0490847539,0.166248455,0.197635244,0.138927266,0.0259549863,0.0,0.0,0.0,0.0,0.0218781177,0.0900048831,0.109596457,0.0787041688,0.0182960338,0.0,0.0,0.0,0.0,0.00669464245,0.034107426,0.039346559100000005,0.0259109623,0.00606924329,0.0,0.0,0.0,0.00249411442,0.0,0.0,0.0,0.0,0.0,0.019010148600000002,0.0506857246,0.0638694924,0.0456015212,0.0,0.0,0.0,0.0,0.0,0.045319943499999994,0.127550247,0.16565069400000001,0.136350643,0.0467480773,0.0,0.0,0.0,0.0,0.061781469000000006,0.192031979,0.24798064399999997,0.188162372,0.0219133008,0.0,0.0,0.0,0.0,0.129715305,0.5232524510000001,0.864012557,1.04617747,1.02119506,0.816201025,0.52058898,0.246325303,0.0795348196,0.045164283,0.100902296,0.163228503,0.153372285,0.041067398399999996,0.0,0.0,0.0,0.0,0.10971893699999999,0.410720686,0.578002363,0.49453470200000005,0.149309513,0.0,0.0,0.0,0.0,1.10452314,2.74091241,4.44953522,5.79632283,6.41063841,6.10946878,4.96157323,3.26707718,1.45928624,0.0,0.0,0.0,0.0,0.0,0.266101827,0.558123315,0.5534161710000001,0.344292494,0.107081753,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.207911519,0.127444701,0.224039058,0.9602286609999999,1.07917116,1.50739141,2.06550288,2.52074103,3.02696827,3.63504753,3.35272856,4.30137384,4.47615,4.43234768,4.16325326,4.94163583,4.48883934,4.90363808,4.55990027,4.46542259,4.60506887,3.84398733,4.03674988,3.00789778,3.30328288,2.37646952,2.19081577,2.11119155,1.77529083,1.20851428,1.3413048,0.766182362,0.893660179,1.29947379,0.6073520379999999,0.820436732,0.332690473,0.810658332,0.943958691,1.31790052,1.19421447,0.708088755,0.983924166,1.2710748,1.53305587,1.30732058,1.62728612,2.18749082,2.16162071,1.67093397,1.38427496,2.10305981,1.81585962,1.24135419,1.82569322,1.28988513,1.44652863,0.6573091120000001,1.22519111,0.798198423,0.333128449,0.583905724,0.0,0.298635511,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.038146537,0.41383564,0.0,0.0,0.032815592000000005,0.0652385935,0.588387219,0.279486258,0.0,0.0387646409,0.492516047,0.48295372,0.0,0.0,0.0,0.37099088399999997,0.303189912,0.0,0.260990324,0.167383551,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.239508988,0.34276042799999995,0.035221385200000004,0.359289079,0.0,0.194332869,0.7089443240000001,0.0,0.330393846,0.618234214,0.49890460299999995,0.004254283770000001,0.0,0.0,0.0,0.0,0.0,0.318560575,0.0,0.0,0.0,0.0518326888,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.341425741,0.0,0.114435856,0.0,0.669650568,0.6160310920000001,0.11263114,0.498124939,0.428628995,0.0339309538,0.0,0.0,0.0,0.14909971,0.0,0.0,0.217216519,0.0,0.10640020300000001,0.0,0.0,0.08119443009999999,0.0,0.0,0.0,0.253781302,0.0563109938,0.0,0.0,0.441116324,0.0,0.417824542,0.598140358,0.471941493,0.631231078,0.268783252,0.7113970609999999,0.230077385,0.373212289,0.0,0.0,0.248614005,0.0,0.0,0.152942864,0.0,0.0,0.0,0.0,0.16408535900000001,0.216068867,0.325133154,0.0,0.0,0.27968368,0.23646522,0.580059419,0.750691125,0.390110766,0.983164107,1.01986047,1.00459092,0.721046284,1.04728596,1.08936504,0.30245674,0.751498777,0.646816605,0.20911526,0.257621221,0.10061470900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.6922443770000001,1.33027317,1.79829448,1.03224518,0.0,0.0,0.0,0.0,0.77915356,1.16029217,0.7587188770000001,0.6121939270000001,0.946386556,1.39463191,1.14894431,0.717497396,0.549210455,1.1122239999999999,0.344668464,0.0,0.0,0.42288009600000004,0.0,0.0,0.9610303570000001,0.636742892,0.0,0.0,0.331032618,0.0,0.0,0.579945689,0.135150973,0.381535281,0.261491872,0.438971348,0.06178240559999999,0.0,0.0,0.0,0.0,0.415622985,0.45048752700000005,0.0803693738,0.0,0.0,1.26261686,0.811430377,0.920559903,0.0,0.359667767,0.677777458,2.59548601,2.62801854,2.95854505,0.664612113,0.7191503020000001,0.6827628290000001,0.46457145899999996,0.26097354,0.0,0.0,0.134849875,0.0866584838,0.150069313,0.0,0.537716241,1.94894885,1.30906778,0.0,0.0,0.0,0.0,0.21389816899999997,0.612240589,0.353220927,0.0849190401,0.909563061,3.46337866,3.94128857,1.6689679,0.108130644,1.27666957,4.11692987,5.75907751,3.1736831000000003,1.19135537,0.0,0.257902014,1.6118566,0.689543294,0.0,1.21829934,3.76474307,3.84354077,0.775450071,0.0,0.0,0.393744486,0.0,1.54158161,1.80044723,0.170797268,0.0,0.193842132,0.597703659,1.38368468,0.0,0.0,0.681704781,0.346980655,0.0,0.6796750890000001,2.50953061,3.28962026,2.40714504,0.71917994,0.6874590190000001,1.04711392,0.7847967920000001,0.567400941,2.01503129,2.5010133,1.50064423,0.0,0.464580682,2.12346379,0.885751552,0.0,0.0,0.38459931299999994,0.0,0.0,0.0,0.54171696,0.170007501,0.33717910799999995,0.0,0.0,0.115503687,0.07250007160000001,0.37263212,0.0,0.0,0.462336921,0.0,0.249921607,0.36074956,0.0,0.288390166,0.0,0.0,0.0,0.0,0.0,0.7493402709999999,1.03202976,0.960632387,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.55315749,0.0,0.0,0.0,1.53212949,0.0,0.55703707,0.0,0.0,0.04317454,0.83695718,0.0,0.0,0.8820904,0.0,0.0,0.54999529,0.85550359,0.0,0.05256461,0.42644528,1.96185535,0.0,0.09800471,0.0,0.37616914,0.19021921,0.0,1.10495222,1.12118706,2.57368039,3.87820976,0.13606463,1.4997878,3.43285036,5.51145987,6.8451961,3.44361437,5.86076926,2.6936299999999997,0.49038273,0.0,1.14538784,0.57407233,0.14206801,0.0,0.15509694,1.00439976,0.0,0.12145843,0.58583941,0.0,0.06104812,0.0,1.48070721,0.0,0.0,0.0,0.39993119,3.15866844,4.30557784,5.38535552,5.79120534,2.3905621,0.0,0.0,0.0,1.58525097,1.62839887,0.63924449,0.30754223,0.0,0.78460633,1.06896743,0.68423881,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
0.174059333,0.0,0.0,0.0,0.0,0.0,0.0,0.250404748,0.406767789,0.842885233,1.00314568,1.60163672,1.9012679,2.40677033,2.44544687,1.99809129,1.59093061,1.37938543,1.30339317,0.6803095929999999,0.537886268,0.390056164,0.304984314,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14417392699999998,0.0560507057,0.426315929,0.0874306143,0.33852958299999997,0.39497798700000003,0.38221637799999997,0.0,0.25402896199999997,0.0805286251,0.0,0.0,0.0,0.0,0.0,0.0,0.199123308,0.35968145700000004,0.0,0.409413239,0.0,0.221438076,0.282220674,0.0,0.272352728,0.0,0.0707756764,0.0,0.0,0.0,0.0,0.0,0.22722425899999998,0.16612697699999998,0.0,0.00417207675,0.08486023039999999,0.357962961,0.302587504,0.0243884122,0.22719092100000002,0.0,0.0,0.030746230099999997,0.0,0.0,0.0,0.327797395,0.0396957434,0.0,0.06683353389999999,0.161852204,0.25569591399999997,0.486532807,0.471767249,0.283690691,0.0,0.0,0.100021507,0.12476405900000001,0.295298954,0.0,0.313309862,0.247100452,0.0,0.031669631499999996,0.180902151,0.0,0.0913115956,0.0242589548,0.360262815,0.0692460921,0.34983559,0.122300934,0.0,0.0,0.276795511,0.0,0.0,0.0,0.0,0.0,0.21130190699999998,0.427229276,0.0,0.0,0.0,0.273896535,0.469234615,0.518472999,0.573847696,0.265405025,0.528998769,0.604384617,0.278420768,0.741773535,0.779289815,0.623816475,0.387292281,0.880182017,0.5719854,0.905858125,0.843336442,1.30798342,1.14571676,1.49745904,1.51005968,1.94449475,2.17376201,2.7633222,2.9070725,2.95621634,3.45848748,3.46403882,3.41074841,3.82093468,3.59263213,3.47258554,3.92856744,3.68629374,3.13144222,3.2186836,2.55401246,2.45145417,2.25604007,1.66301477,0.902938514,0.547379835,0.816677228,0.10160278199999999,0.417502196,0.16934424899999997,0.0839781258,0.0,0.0,0.0325069443,0.0,0.0,0.328786331,0.20321487600000002,0.234310231,0.47131856899999997,0.5792241229999999,0.009084407409999998,0.27565263100000004,0.0,0.0,0.0,0.0219511987,0.0,0.0,0.0,0.258882251,0.0,0.49951124,0.0,0.176786902,0.871965729,0.834083866,0.48511137200000004,0.257327656,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.185368742,0.0,0.0304160988,2.1477112000000003,0.0,0.0,1.30407963,0.0,0.569956,0.0,0.0,0.099847715,0.0,0.132531906,0.0,0.036069076,0.0,0.760845078,0.308118173,0.0,0.198215872,0.12739794599999998,0.0,0.223676805,0.424250809,0.0,0.0,0.586089387,0.0,0.33413044,0.651737221,1.60782998,1.16374776,0.72479846,0.0,1.19887619,3.4614997000000005,3.71841069,2.69867602,0.6866731979999999,0.330758278,0.486696411,0.9630637409999999,1.33272584,0.477903696,0.013211216299999998,0.820602088,0.525585376,0.550673647,0.266083209,0.777685924,0.335213431,0.0,0.508784156,0.0,0.154045299,0.755850096,0.7757586890000001,0.0,0.505278638,0.36164251,0.0,0.0,0.943567884,0.0,0.42708418299999995,0.14491162900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
1.19891851,1.54691328,1.71105159,1.65613738,1.44253532,1.1757688,0.93472954,0.732592626,0.535395217,0.316339084,0.0969160807,0.0,0.0,0.0,0.0730915595,0.125573896,0.0745170063,0.0,0.0,0.0,0.211013827,0.668009494,1.20461447,1.68503084,1.98714959,2.0376876,1.83150368,1.43562769,0.9744594659999999,0.591634735,0.39558711700000004,0.414132206,0.589929984,0.829275442,1.07849901,1.37347919,1.81657793,2.48408131,3.32446934,4.12834056,4.61114287,4.57125764,4.02375585,3.2140492000000003,2.49017426,2.10879999,2.09914374,2.27253546,2.36655727,2.22140391,1.86812887,1.47618064,1.21033299,1.10874279,1.07036117,0.952038415,0.692167816,0.361986353,0.107142759,0.0303158378,0.11065132,0.22346503,0.24173635899999998,0.13579887,0.0,0.0,0.011470698,0.17038857100000002,0.27769367899999997,0.24071692600000003,0.0804954734,0.0,0.0,0.0,0.121536386,0.209356367,0.16579448800000002,0.0412978517,0.0,0.0,0.11685396099999999,0.22445643699999998,0.20150241800000002,0.0417850526,0.0,0.0,0.0,0.09868759140000001,0.250696611,0.23583091899999997,0.0738369767,0.0,0.0,0.0,0.133024314,0.20040539100000002,0.0994682642,0.0,0.0,0.0,0.0334655846,0.217065772,0.226848353,0.0438456905,0.0,0.0,0.0,0.132396439,0.30109563699999997,0.22373483,0.0,0.0,0.0,0.0,0.258582039,0.362200334,0.160661315,0.0,0.0,0.246252599,1.05106242,1.73487503,1.79814237,1.13718181,0.232699276,0.0,0.875298591,3.05789049,5.64676423,7.41796935,7.44389119,5.644710400000001,2.84049187,0.26843078800000003,0.0,0.0,0.0,0.34792444,0.534118576,0.241808749,0.0,0.21997593899999998,1.05672773,2.08990611,2.73540494,2.62663691,1.8495522,0.856709064,0.147994767,0.0,0.164225154,0.43611738,0.5042283120000001,0.32689679899999996,0.0652454823,0.0,0.0,0.0747893956,0.149590395,0.09748731039999999,0.0,0.0,0.0,0.0,0.0791505231,0.10150920699999999,0.0912167472,0.142919355,0.316129129,0.559162617,0.7252472059999999,0.676927527,0.398757188,0.0259110587,0.0,0.0,0.0,0.126391312,0.221916177,0.13419725300000002,0.0,0.0,0.0,0.0,0.13430745300000002,0.162294148,0.0584519109,0.0,0.0,0.0,0.0390108354,0.13498865300000001,0.11764641599999999,0.00583618584,0.0,0.0,0.0,0.0712141768,0.125251463,0.07565891799999999,0.0,0.0,0.0,0.0,0.08930588800000001,0.106053871,0.0360438509,0.0,0.0,0.0,0.0293283927,0.09311333849999999,0.07874113860000001,0.00132430169,0.0,0.0,0.0,0.0538839281,0.113487619,0.153531688,0.237412133,0.441497955,0.7858965840000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.462
0.8076496409999999,0.625350025,0.72791932,0.39405769700000004,0.34403273100000004,0.735753215,1.22765422,0.163172087,0.546971368,0.0,0.278536861,0.693568904,0.0,0.923166072,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.13502064,0.0,0.0,0.0,0.41465153200000004,0.0370072052,0.97139914,0.161203598,0.421215864,2.11727615,0.0,0.0,1.66105965,0.0,0.391649322,0.0,0.20159981100000002,0.996725493,0.5531080429999999,0.0,0.248456765,1.47046461,1.61563282,1.80191812,0.0,0.0,0.65128539,0.229008315,0.28896603600000004,1.31407752,3.02539883,3.66585535,1.87857868,0.0,0.0,0.33555561899999997,0.0,0.0,0.0229948584,0.0,0.7230473740000001,0.548359711,0.19011636,0.575003786,0.0,0.0,0.0,0.0,0.0,0.0,0.824570569,0.0,0.18099005699999998,0.0,0.47384831200000005,0.36138861299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
1.05563451,0.774000824,0.163686697,0.971979617,0.47259230700000004,0.843529788,1.11699467,1.35546631,0.770948493,2.1256079,2.29811733,2.86570811,2.81589705,2.06877071,2.34682504,1.94102231,2.80237213,2.3397031000000004,2.7526736,2.95137725,2.72601038,3.22963767,2.38575309,2.03304184,3.20018935,1.68234365,1.7742897000000002,1.90654538,1.17811049,1.77446735,0.49763813,1.56510773,0.469760506,0.8537806809999999,0.13663105,0.703212232,0.35432810200000003,0.495277645,0.923308447,0.590851579,0.0,0.498943289,0.0,0.55776255,0.47462148600000004,1.07378709,0.11311008,0.198142171,1.18249226,0.91321069,1.40302493,1.07898518,0.0,0.41844340399999996,1.3810307,0.0,1.30467176,0.560340947,0.9803537790000001,2.34856664,1.74692,0.730129963,1.13225279,1.31338787,0.422189726,0.291057578,0.7319647229999999,0.299779411,0.0,1.11644554,0.0,0.0,0.86609438,0.706000683,0.32726475899999996,0.0,0.0,0.0877063669,0.0,0.0,0.0,0.38597284299999995,0.25554575,0.0,0.840613023,0.0331272107,0.250980969,0.353785481,0.121701062,0.0,1.21197497,0.18320230399999998,0.0,0.0,0.0,0.054091468600000005,1.10928854,0.8382839559999999,0.09018098599999999,0.0,0.00300110262,0.255276396,0.0,0.24118743399999998,0.0,0.058822356500000006,0.0,0.46853700299999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.115459149,1.48621879,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
2.12871512,2.71662638,2.58698736,3.27087836,3.61976162,4.0906902,3.58959708,3.9971375,4.44956618,3.83128634,4.44865562,4.71166179,3.97774266,3.86368707,4.19879641,3.52375221,3.66288155,3.32635045,3.06853065,2.63247772,2.72223375,2.54343963,2.25153916,1.4461879,1.90439953,1.24425473,0.6797952979999999,0.867658622,0.417916138,0.396001514,0.0,0.195396089,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.31990448899999996,0.067500375,0.0,0.39178066,0.392570297,0.209269633,0.588845589,0.38643104799999994,0.133827748,0.454702086,0.653071725,0.0,0.0,0.0,0.311938335,0.162988164,0.0,0.255788638,0.10028370699999999,0.314027674,0.0,0.0,0.0,0.300755824,0.0,0.0,0.0,0.0,0.0,0.161819929,0.0,0.47054144600000003,0.0713158925,0.44609442899999996,0.22255097100000001,0.0,0.38715805600000003,0.574319678,0.58186313,0.0,0.28905052,0.357469961,0.250184946,0.323666706,0.0,0.307361814,0.360869249,0.250970556,0.0,0.0,0.0,0.0,0.0,0.0701477523,0.0,0.0,0.0,0.23877235,0.0,0.290544574,0.0,0.0,0.276035651,0.0,0.0,0.0,0.0,0.146653136,0.0,0.0,0.0,0.18586623300000002,0.0,0.025048837999999997,0.335270539,0.0,0.263566295,0.18070524899999998,0.357897322,0.0,0.171799907,0.0,0.215994296,0.389828447,0.052148734,0.0,0.0330734944,0.313089154,0.0812961791,0.0,0.0,0.0,0.05208461599999999,0.0,0.043786613700000004,0.0,0.08410514109999999,0.41657759299999997,0.195337275,0.11040122699999999,0.144588101,0.0019862957999999997,0.22271991,0.0,0.204092973,0.213329601,0.0,0.0,0.0,0.273344256,0.0831099001,0.031542099,0.0,0.0,0.0,0.0896855474,0.0,0.0,0.301158443,0.137096616,0.253912034,0.406628731,0.362736186,0.119273823,0.00892001997,0.328918115,0.0,0.41847792,0.23870091300000001,0.0,0.18901475,0.0,0.472829302,0.0,0.597870487,0.0,0.0,0.5008369020000001,0.6831168870000001,0.46949758700000005,0.157397557,0.70965173,0.937313305,0.8274395790000001,0.36890177,0.25121188699999997,0.43269448200000005,0.7296148709999999,0.30327321,0.331860624,1.00335403,0.564084287,0.9094652590000001,0.6138112579999999,0.418499839,0.882174555,0.80240237,0.473436254,0.560957676,0.298339917,0.351559279,0.298368337,0.392937301,0.131391135,0.15675230699999998,0.501533466,0.0,0.400466383,0.681355332,0.734184287,0.7439866829999999,0.6581604839999999,0.750751458,1.44681616,1.83821318,1.92169588,1.89323559,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
2.8158606,3.26349778,3.64043662,3.83123803,3.68606712,3.09459895,2.06753716,0.781342987,0.0,0.0,0.0,0.0,0.08814424289999999,1.06311106,1.5647399,1.29596962,0.290079829,0.0,0.0,0.0,0.0,1.30551143,4.40269844,7.36601594,9.33875258,9.74340499,8.48391504,5.97156061,2.96698041,0.303572968,0.0,0.0,0.0,0.0,0.49739428,1.03438466,1.04230792,0.6691046979999999,0.202715617,0.0,0.0,0.14923740800000002,0.44587651,0.619319929,0.588891293,0.418054771,0.27547852,0.33758809,0.684726258,1.24502226,1.81529304,2.14969554,2.07355244,1.56772225,0.783315608,0.0,0.0,0.0,0.0,0.0,0.292326442,0.514658184,0.46354658600000004,0.19674856699999999,0.0,0.0,0.0,0.0,0.0296556113,0.253228382,0.333601644,0.2442613,0.0431948333,0.0,0.0,0.0,0.0,0.08828624800000001,0.211031229,0.220629689,0.12129378099999999,0.0,0.0,0.0,0.0,0.0,0.102892484,0.160147424,0.134206546,0.044735829299999995,0.0,0.0,0.0,0.0,0.0237929167,0.0902653575,0.10631271199999999,0.0690040287,0.001942728,0.0,0.0,0.0,0.0,0.0331983302,0.0623944559,0.057956248200000005,0.0262135334,0.0,0.0,0.0,0.0,0.0020945434,0.042241361399999997,0.0865338001,0.140585887,0.214704119,0.316976302,0.446913028,0.592860134,0.7340867209999999,0.8460708859999999,0.906439655,0.89964849,0.8200220359999999,0.6738782459999999,0.48119765600000003,0.275873569,0.102249485,0.00592089068,0.0192811923,0.146102325,0.352344244,0.570064262,0.716821513,0.725733,0.574719745,0.30128933399999996,0.0,0.0,0.0,0.0,0.0,0.20665309399999998,0.335224053,0.297275933,0.10189808300000001,0.0,0.0,0.0,0.0,0.186659656,0.723780669,1.29846558,1.84458368,2.34500142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.485
2.57065955,2.22790671,2.38241963,2.35675458,2.24183064,1.35125368,1.61007739,1.09302201,0.9919881190000001,0.870354346,1.59438578,0.9107009340000001,0.581691608,0.7067359740000001,0.673583918,0.0,0.19095032399999998,0.0,0.0,0.0,0.0,0.0763467151,0.329254498,0.0,0.419414374,0.0481670625,0.0,0.247746524,0.0,0.31995077,0.610425111,0.504821697,1.65047914,1.04964591,0.153045609,0.0,0.20154618100000002,0.907168505,0.0,0.795807795,0.293749095,0.0,0.597558872,1.19432324,1.25420967,0.0,0.0,0.616583028,0.0,0.126282022,0.0943743432,0.0,0.0,1.06223377,0.0,0.0,0.50017512,0.0,0.0,0.6253705829999999,0.09077037130000001,0.0,0.46443290200000004,0.33332651399999996,0.0,0.155998555,0.0,1.37695677,0.0,0.636359707,0.45251233799999996,0.0,0.0,0.305766201,0.0,0.0,0.0,0.260424932,0.0,0.0,0.0,0.0,0.13877419400000002,0.98707866,0.011358651599999998,0.0,0.78209228,0.0,1.07486428,0.0,0.0,0.0,0.0,1.25775163,0.14036901,1.26087452,0.289064642,0.0,0.0,0.0,0.0,0.0,0.513278396,0.276134957,0.0,0.151229461,0.09381182310000001,0.395123403,0.822849389,0.36641940799999995,0.47932505700000005,0.336661084,0.327005076,0.27880462899999997,0.375557057,0.6961115379999999,0.45659467,1.93498327,0.719409634,0.0,0.604954506,0.361333505,0.712980115,0.571568179,1.25906731,1.306977,0.523573481,0.597011075,0.5064968320000001,0.606462784,0.0970946597,0.332692125,0.621885791,1.04518204,1.8439708,0.699776223,1.85210199,1.45499319,1.16385305,2.11160636,2.49906778,1.66714627,2.568476,1.9616178,2.56181291,2.96243802,3.05922348,2.86574331,2.83279839,2.40711626,2.41298451,2.22145849,4.0175279,2.44972792,1.45867296,1.39166156,1.90500337,0.620017699,1.84696809,0.853446002,0.610378777,1.13843477,0.0,0.0604002932,0.0,0.12012474,0.320164467,0.682381131,0.54641899,0.0,0.0,0.0,0.618431941,0.528190881,0.0,0.9147608190000001,0.0,0.623452608,0.630256767,0.0,0.0,0.165745893,0.072209436,1.28540772,0.29370424300000003,0.0,0.143462643,0.0,0.0,0.254202726,0.420627233,0.116774615,0.0,0.26479417,0.137210045,0.0,0.50414294,0.0,0.424600252,0.30956294,0.9227168370000001,0.6839872109999999,1.68332154,0.863726225,2.1331846000000003,1.71951321,1.3448499,2.84030724,1.11090061,2.24198101,1.15394811,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
2.22890075,0.0,0.0,1.90551058,2.4774111,0.8479734459999999,0.365303704,0.418428285,0.27461753899999997,0.6177730060000001,0.0,0.0,0.782510107,0.0,0.0,0.0,0.0,0.8817593709999999,0.753279048,0.366720806,0.30726283,0.0,1.2570308000000001,0.0,0.0,0.0254770771,0.508633319,0.0,0.0,0.0,1.53760024,0.0,0.466802792,0.0,0.0,0.24928389199999998,0.171252613,0.0,0.571366123,0.0,2.29723303,0.41184587100000003,0.0,0.0,1.42782867,4.52741807,4.93601806,2.60731271,0.0,0.0,0.387022085,0.0,1.19055943,0.8332119240000001,0.9105177879999999,0.509687365,1.76498823,1.8589335999999999,1.46067227,0.360993587,0.7180828340000001,0.0,0.642519823,0.0108398814,0.0,0.0,1.21877673,0.0,0.644314605,0.422090321,1.21343891,0.0,1.09811859,0.0,0.0,0.246285297,0.0,0.416657165,0.159715666,1.09743637,0.0,0.0,0.0,0.136764899,0.0,1.8789318,1.34552181,0.0,0.175688603,0.0,0.0,0.0,0.0,0.470691769,0.8962492959999999,1.14984685,0.7135773670000001,1.98428947,0.0,0.0862092942,0.0,0.0,0.23171623,0.0,0.0,1.02027997,0.0,0.529786844,0.0,0.0,0.0,0.48421281,0.0,0.0,1.36082648,0.8697338920000001,3.59809311,0.0,0.0,1.51855861,0.0,0.679362948,0.0,0.5817160029999999,0.0,2.05473898,0.0,0.225409545,0.878251956,0.0,1.49960208,1.08172295,0.0,0.0,0.0,0.0891308532,0.0,0.88039195,0.0696835058,0.0,0.0,0.0,0.701706237,0.0,0.0,0.0,0.179385078,1.95490534,0.0,1.33423425,2.73508184,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.25200379100000003,0.0,0.7926623759999999,0.0,0.0,0.0979982604,0.0,0.0,0.0,0.0,0.380627647,0.0,0.266904004,0.884482422,0.0,0.34674931600000003,0.0,0.0,0.0,0.698469793,0.671373563,0.0,0.0,0.0,0.0,0.309505982,0.0,0.5949200179999999,0.0,0.664833613,0.00257841335,0.146525495,0.0,0.0,0.021427059,0.0,0.60701681,0.0,0.0,0.0806849419,0.0956239606,0.36076029600000004,0.0,1.01663922,0.0,0.127516858,0.0,0.0,0.0,0.688735475,0.0,1.26290437,1.70175862,1.00436333,0.698658028,0.111164394,0.0,0.0,0.41772173700000004,0.746879395,0.653423686,0.8490871240000001,0.0,0.0,0.340861645,0.0,0.964035037,0.178663787,0.0,0.7886481809999999,0.0,1.09383417,0.935804503,0.0,0.31731559800000003,0.400891139,0.0,0.115436532,0.693214364,1.3345972,0.868045486,1.35886668,1.68725793,1.23373021,0.324715686,0.283107937,0.0,0.023651336600000003,2.21984728,2.78804146,3.11684014,3.59026309,2.53393375,0.588823813,1.09594333,0.0,0.0,0.0,0.0,0.295715964,0.672172048,0.0,0.0,0.0,0.0,0.115790961,0.0743234728,0.0,0.0,1.4968788999999998,0.126690009,1.02990158,0.0,0.989953566,0.0,0.230410084,0.0,0.283429796,0.0,0.0,0.0,0.0,0.0,0.0,1.14030251,0.362664747,0.049216176699999996,0.281903809,0.0,0.0,0.49871194700000004,0.0,0.46324758200000005,0.0,0.0,0.0,0.0101673709,0.665382124,0.0,0.686633553,0.0,0.08674933580000001,0.178989693,0.0,0.49950952600000004,0.44936979200000005,0.0,1.05961889,0.045568141799999996,0.179360183,0.15575888300000001,1.19883493,0.0,0.32380437,0.0,0.129829673,0.200903891,0.11191751800000001,0.0,0.0,0.9276462999999999,0.394897503,0.0,0.99729354,0.0,0.255095974,0.0,0.0,0.0,0.642413572,0.25607830600000003,0.558846032,0.675908375,0.0,0.0,1.12132428,0.406292974,0.0,0.0,0.700039889,1.44254318,0.110787296,0.0,0.0,0.0,0.060863099000000004,0.0,0.0,0.0,0.5690493320000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.95276865,3.13077115,5.43645685,3.86126861,2.32361486,4.22625483,2.96527323,1.45892498,1.07933205,0.25593694,0.49163769,0.25629124,0.37591343,0.6648721,0.72478261,2.24315308,0.95713221,2.29481462,2.24609928,1.22844001,1.57213356,1.72198949,1.22408762,0.6921041,0.16036366,0.15801779999999999,0.29930713,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.18693408,0.0,0.02638216,0.16045003,0.25058026,0.32606149,0.39418378,0.37484006,0.18409788,0.0,0.0,0.0,0.08950148,0.48665569,0.51086038,0.0,0.0,0.0,0.0,1.54208479,3.77568255,5.31334453,5.30420816,3.69696738,1.30687696,0.0,0.0,0.0,0.21015727,0.9021046999999999,0.75069028,0.0,0.0,0.0,0.0,0.5226688,0.70804758,0.26538249999999997,0.0,0.0,0.67542671,2.61142351,4.64719514,5.85212486,5.71209701,4.39837835,2.59702192,1.05724923,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.0973881266,0.0,0.220448697,0.260702838,0.35751353799999996,0.406241704,0.533690925,0.40472104799999997,0.321111443,0.582320058,0.5687634020000001,0.518733463,0.393326275,0.388455124,0.0267601003,0.0,0.0356276698,0.0,0.0,0.0,0.0104229117,0.0,0.0,0.0,0.0,0.0507534336,0.0,0.0,0.0,0.0,0.0794444958,0.0153544145,0.40156339799999996,0.0,0.0,0.216627812,0.532339614,0.269449447,0.542861379,0.510277799,0.285753358,0.44576802200000004,0.29204502,0.0484920276,0.0,0.0,0.11624836300000001,0.0,0.0272905507,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000850351897,0.26785158800000003,0.46522069899999996,0.0211800899,0.589643473,0.4419848,0.086248558,0.305915025,0.162996119,0.08054601230000001,0.427673044,0.450351846,0.43545521299999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0990648174,0.0,0.0836130229,0.213769045,0.930518979,1.02608209,0.923016084,1.570086,1.8801332,2.23317473,2.25585679,2.13535858,2.53054605,2.80234415,2.72534825,3.24549412,2.93461009,3.07374979,2.79937386,2.92637968,2.5031901000000003,2.55932761,2.46910065,2.16498101,1.68021778,1.48758827,1.58780078,1.38836681,0.750004213,0.41555817700000003,0.049595486900000006,0.274116126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.43955829999999996,0.0,0.0,0.0,0.33838896,0.90845932,0.0,0.0,0.0,0.40732738,0.6209215,0.0,0.0,0.0,4.16229927,8.11237391,8.01727939,4.46960227,0.0,0.0,0.0,0.57839573,0.70149082,0.27207934,0.16521585,1.37261845,2.07627843,0.32611128,0.0,0.0,0.0,0.030804400000000003,0.11695165,0.0,0.0,0.0,0.0,0.74412731,0.49311914,0.0,1.00382402,1.06031038,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45799999999999996
0.0205554102,0.00971196574,0.0,0.0,0.521929338,0.19541381,0.0,0.20537721899999997,0.0,0.0,0.388775666,0.0,0.0,0.0,0.0,0.348473222,0.47991196799999997,0.0,0.0,0.06995237650000001,0.143667996,0.0,0.0687462638,0.0,0.478696326,0.21414831899999998,0.0,0.41724893399999996,0.0,0.0,0.349751865,0.0,0.0,0.0,0.0,0.0,0.0,0.573938987,0.0,0.470859336,0.0,0.0,0.014058236000000002,0.0,0.0145795122,0.536444056,0.452150503,0.0456552383,0.0,0.507169042,0.33694405200000005,0.27533505399999997,0.46995478399999996,0.0198093599,0.0,0.0,0.0,0.0,0.43527036700000005,0.20729819300000002,0.105953559,0.0,0.0,0.0138403543,0.167755854,0.09685140939999999,0.7677985270000001,0.241449463,0.0,0.180172732,0.40909288200000005,0.211023248,0.004353524520000001,0.0,0.0,0.0,0.44505131600000003,0.0,0.232035975,0.544089819,0.0,0.194739745,0.0,0.426286173,0.0,0.0,0.227050114,1.22059483,1.40812416,1.20341337,0.5029985260000001,0.157482752,0.0,0.0,0.0,1.33204644,3.27421776,4.69989481,5.21023407,5.44916949,4.15479933,2.17432826,0.824203597,0.0,0.895482071,1.56826451,2.24351041,2.10659117,1.13858471,0.427311747,0.365682329,0.0,0.0,0.0,0.0,0.00737360468,0.50358566,0.0,0.35289941,0.0,0.0,0.487195041,0.14042669,0.35937871899999996,0.0,0.48012551600000003,0.504661586,0.274181827,0.487581611,0.0,0.0,0.0,0.364504865,0.01144905,0.372012357,0.730822979,1.80069004,0.98443394,1.25118074,0.296979597,0.964401919,0.0,0.0,0.0,0.0,0.0,0.0,0.312801857,0.11209373800000001,0.0,0.0,0.528338859,0.0,0.0,0.34026529299999997,0.0690021146,0.0,0.47266295700000005,0.0,0.475132623,0.0,0.0,0.0,0.466604316,0.0,0.0,0.0,0.267636985,0.0,0.9944217940000001,0.8960806240000001,0.22238095800000002,0.788749733,0.477347484,0.0,0.374371464,0.540748529,0.0,0.174948611,0.0,0.449968262,0.441049065,0.40674333,0.9356490270000001,0.235094062,0.029625009,0.590552318,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.85838145,0.15433728,1.32100067,0.0,0.98292284,0.48023242,0.24917097,0.0,1.62666361,1.3435282,0.71038616,0.64867097,0.7077776,0.0,0.0,0.0,3.53220336,2.70090603,0.0,0.61030437,0.0,0.0,0.0,0.16788079,0.0,2.69091699,0.54404086,1.3221029,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.414
0.407698203,0.36626116799999997,0.47823764,0.0,0.686499031,0.416872333,0.702187275,1.50164587,2.24151818,0.797288566,0.0,0.318341854,0.0,0.0419968537,1.15379046,0.402101049,0.0,3.25828423,3.26946446,2.23024917,0.0,1.29065396,0.840674445,0.0,0.304773377,0.0,1.41734838,0.271588587,0.0,0.0,0.0,0.0878463423,0.80816052,0.760715191,0.7777769920000001,0.0,0.0,0.0,0.0,0.5912156679999999,0.980364207,0.0,0.0,0.0,0.0,0.0,0.236007477,0.0,0.0,1.42691717,0.65066657,0.357713351,0.91067194,0.0,0.5796933710000001,2.18830091,0.0,1.10990645,0.265457438,0.0,0.0,0.0,1.5370747999999999,0.803406983,0.0,0.0,0.0,0.93333048,0.0333554156,0.412393324,0.0,0.7852666079999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
1.75647098,2.53881092,0.0,0.0,1.60066429,2.59616592,1.04013977,3.66555999,6.86746215,3.12909067,1.7818665,0.43732881,0.64944631,0.0,0.0,0.0,0.0,0.76823201,0.40495763,0.42607789,0.29625159,0.34470813,0.42444421,0.83908484,2.62172036,8.22285899,0.21935433,1.19247903,2.92376802,0.0,1.11449723,0.0,0.0,0.96335135,0.0,0.24863403,0.06837209,0.0,0.77570599,0.0,0.25932029,0.75443901,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
1.03116016,0.42851627299999995,0.44828962899999997,0.929584321,0.0,0.0,0.0,0.683506906,0.0,0.142499576,0.0,1.29701406,0.515292167,0.7368650720000001,0.591247759,0.47502267,0.551714265,1.00205583,0.854457293,0.0,0.344792569,0.609788209,0.701134448,0.367777035,0.06394879049999999,0.5438086639999999,0.15229178300000001,0.45783247,0.0,0.22392592600000003,0.0,0.0,0.0,0.0,0.0,0.437875467,1.27055003,0.160396418,0.0,0.34243802100000004,0.38428950700000003,0.0,1.91559714,2.66174912,0.0,0.812333248,0.0,0.55513718,0.67969662,0.335152002,0.0,0.18545316,0.0177338041,0.9112476359999999,0.0,0.0,0.704941747,0.7798975890000001,0.550627816,2.00743838,1.93815654,0.0,0.332655802,0.373372989,0.9648686540000001,1.55137636,0.837417168,0.0,0.45769246399999997,1.96470791,2.0611439,0.303105236,0.0,0.35755251299999996,0.0,0.0,0.0,0.24813644,0.503139152,0.317091298,0.0,0.0,0.559876199,0.0,0.0,0.535996879,0.65340388,0.14088446300000002,0.0,0.774573787,0.611216523,0.0,0.962930715,4.78639304,4.30675917,4.5787849000000005,4.20151253,3.52931898,2.79676702,2.80163644,2.88243322,1.71627504,0.902649195,0.20676066199999998,0.0,0.328090902,0.573054498,0.482318044,0.659192882,0.509675335,0.053469320300000005,0.807139426,6.10444157,7.70441898,4.81160556,4.47751927,4.36170621,1.88777607,0.819222001,0.410365473,0.0,0.0,0.0116931695,0.51125372,0.308234472,0.0,0.362054208,0.0,0.0,0.266575888,0.0,0.0,0.0,0.0,0.0,0.0,0.6971747420000001,0.15407994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
1.72815755,1.18178269,0.793909622,0.9027222579999999,1.02146767,0.582479968,0.942823636,0.5905160939999999,1.12251366,1.30330909,1.3771107,1.09399017,0.691115775,1.38832388,0.9367901409999999,0.731839152,1.18535071,1.09857129,1.24836973,0.9869053,1.11599799,0.835380848,0.5128505,0.393915113,0.823991868,0.19237447600000002,0.0,0.277743609,0.0,0.282160097,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.178839615,0.165686364,0.195338137,0.0,0.295938084,0.0253105207,0.0,0.40480003700000006,0.00814732304,0.11104823,0.42212871700000004,0.2948735,0.366361392,0.62688114,0.487413848,0.882708623,0.5679541,0.525866013,0.089061905,0.1216681,0.21990165600000003,0.550253051,0.039847213799999996,0.382749523,0.0,0.265109773,0.29054343899999996,0.325372973,0.0,0.140848719,0.014059508200000001,0.185197229,0.0,0.135743155,0.0,0.0,0.42168270799999996,0.0,0.295899885,0.39465245200000004,0.340642056,0.0174493782,0.173349638,0.0,0.187537863,0.0,0.0,0.403900941,0.0,0.40919968100000004,0.00361696667,0.0729782506,0.0,0.014035181599999998,0.0,0.0,0.24737694100000002,0.0,0.10070088099999999,0.201919698,0.0,0.0,0.0841026733,0.0,0.0,0.21779337399999998,0.0,0.120962439,0.0,0.314399718,0.161404732,0.0,0.22842151100000002,0.051064960199999995,0.0,0.20132381300000002,0.426351097,0.0,0.0,0.0,0.127654247,0.0,0.335336129,0.0459376335,0.0527230717,0.0,0.0,0.0,0.0,0.19385287399999998,0.0231042789,0.218268221,0.0,0.0,0.0,0.241484715,0.0,0.0,0.032552017999999995,0.424433021,0.22599056399999998,0.312107798,0.221502382,0.032366950400000004,0.0,0.0,0.0,0.0,0.0,0.17317493899999997,0.100994185,0.319401936,0.0,0.0,0.0,0.0,0.21302352800000002,0.0,0.13287174,0.066013904,0.06619036610000001,0.19188744100000002,0.0,0.0,0.003971828679999999,0.26596279,0.102265762,0.468391712,0.443711466,0.0351743459,0.12564999,0.175685765,0.415601751,0.543980279,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0893775857,0.04706372,0.0,0.0,0.0,0.15629902699999998,0.0,0.427554767,0.8313750679999999,0.980246561,1.17324897,1.30980262,1.2868966,1.88857951,2.00506988,2.61950208,2.9487028,2.70021158,2.83778174,3.75412543,3.43562952,4.13888786,4.15225788,4.29854443,3.72283686,4.0165301,4.49521916,4.04987913,4.27891874,3.72944958,4.11667684,3.65939737,3.8613358,2.88942609,3.42170407,2.99869696,2.65313822,2.37792178,2.02103618,1.65778094,1.43106826,1.38991733,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.0352993639,0.49866088799999997,0.440383025,0.0,0.0,0.0,0.210683987,0.0,0.0,0.33219996,0.297581201,0.0,0.0,1.87009594,2.0882241,0.6226566610000001,0.0,1.49711357,4.25269834,0.0,0.0,0.0,0.31000524100000004,0.0,0.7415255959999999,1.09295111,0.407677886,0.478174198,0.136425576,5.46519076,2.15689827,0.0,0.905101376,0.0,0.886333082,0.13664942300000002,0.344539675,0.0857222064,0.935120528,2.47930192,0.41207152700000005,0.38067057200000004,0.0709967255,1.57305187,1.85343445,0.0,0.416132885,0.0,0.13156747900000001,0.0,0.298526622,0.0,0.0,0.507831476,2.3458938999999996,4.96686675,5.12057904,3.43286456,0.0,0.638379426,0.0,0.664003442,1.87506834,3.89320947,4.92197694,2.73486809,0.039942095899999995,0.0,0.642267444,0.0,0.08442302730000001,0.0,0.0,0.0,0.16779081699999998,0.226921801,0.7084826059999999,2.21287508,0.0,0.671269033,0.15290629,0.734564951,1.81617995,0.0,0.7518066809999999,0.0,0.0935582539,0.0,0.0,0.282360268,1.4561937,0.192272859,0.23270610000000003,0.347150333,0.0,1.89209051,0.44155476899999996,0.14620372199999998,0.0,0.0,0.47868405,0.0646769049,0.132701928,0.493705675,0.490551987,0.163919192,1.39967397,0.606808696,0.0,0.7577941709999999,0.241732211,0.64319795,0.0421870346,0.239418429,0.131009701,0.0455055862,0.126296908,0.057904917699999996,0.0,0.461963746,0.12957757,0.213583539,0.0,0.287594428,0.42711994799999997,0.9526918759999999,0.332352213,0.374850719,0.0,0.25834738,0.0,0.0,0.0,0.0901722866,0.343943551,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.722915895,0.225250457,0.309640456,0.217430305,0.175586186,0.501281044,1.3807515,1.61914251,4.35630508,6.39152378,6.26041475,5.99541936,3.46693759,1.68845851,0.0120596374,0.19882702600000002,0.147357722,0.0,0.0,0.0,0.415825554,1.11275231,1.46601996,0.524585446,0.470039059,0.0,0.49979949700000004,0.558089657,0.225383047,0.0,0.0,0.106427964,0.225058199,0.5138259310000001,0.0,0.188129825,0.0,0.0,0.0,0.0,0.533203714,0.424664315,0.0,0.0,0.0,0.024663229300000002,0.0,0.0,0.0,0.0,0.0,0.37361807,0.0,0.0,0.450165935,0.0,0.0,0.0,0.0,0.0,0.20993305199999998,0.912873646,0.22075563399999998,0.0,0.0,0.634741697,2.22406193,3.03257675,2.71704122,0.973047872,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
1.33480379,0.0,0.43469794,0.23853479,0.92397978,0.03758067,0.13838361,0.0,0.0,0.0,0.0,0.06649733,1.46039062,3.79880807,5.62823016,5.86297752,6.26458142,4.88849864,3.36653215,2.7738811,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.8147722629999999,0.84378807,0.219732603,0.0,0.452114917,5.474283,4.34486935,0.0,0.730858606,0.0,0.945375575,0.0,0.769171591,0.0,1.71486565,0.942359046,0.23917740199999998,1.37913659,0.220845551,0.10717716699999999,0.0,0.0,0.0,0.479824859,0.0,0.455597751,0.37288882100000004,0.0,0.624456425,0.34267532700000003,0.0,0.0,0.465557155,0.504363358,0.637812247,3.28427638,4.58816131,3.59147812,0.618096317,0.570422663,6.37134036,0.495020626,0.0,0.550336719,0.32369054399999997,1.33552149,0.0,0.0,0.0,0.0,0.152938516,0.07602043650000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.206235807,0.250567369,0.000392381686,0.599584359,0.0,0.16549175900000002,1.90513068,3.1668239,1.57275849,1.23626221,0.0,0.854832701,0.0,2.38152856,0.355310425,0.21184925899999998,0.871402824,0.285143056,0.223378878,0.124937225,0.370687841,0.23344923,0.0938380971,0.225557148,0.47810626,0.0196011356,0.46628647100000004,0.45472914299999995,0.0,0.0,0.415414695,0.0,0.0,0.344261607,0.5049421479999999,0.220434147,0.0,0.0460214196,0.788732167,0.0,0.032387518,1.03474639,1.75700104,0.0,0.261285377,0.8312339990000001,0.16114415199999998,0.0,0.0,0.5553767510000001,2.00214064,0.218638986,0.475713014,0.217100712,0.0380644648,0.0,0.0,0.0,0.543943126,0.43440118200000005,0.039277523700000004,0.0,0.0,1.70779967,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.2179584,0.84965247,0.0,1.28179977,0.93893994,0.06135905,4.56294912,10.03131126,7.74646965,3.47728886,0.0,3.07683636,0.0,1.57515823,0.0,2.37300146,0.23989125,2.64766014,0.0,0.64505897,1.3189877,4.01121163,3.20878334,0.0,0.23983836,3.49700647,4.27843205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.461
0.14551172,0.106526521,0.035936921499999996,0.0,0.0435924778,0.235525304,0.590455642,1.09189189,1.68585396,2.28954841,2.80694806,3.14791602,3.24671393,3.07586925,2.65240523,2.03511884,1.3135401000000002,0.590982779,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.189863941,0.365829788,0.43129763200000004,0.388312172,0.26277459,0.0955140733,0.0,0.0,0.0,0.0,0.0,0.0,0.0117141596,0.09030275460000001,0.132660656,0.135060892,0.104856083,0.0568421909,0.0080157037,0.0,0.0,0.0,0.0,0.0,0.0014516105300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0106874032,0.0731766016,0.131512239,0.166056384,0.160607441,0.10801864900000001,0.013882163500000001,0.0,0.0,0.0,0.0,0.0,0.0,0.112581938,0.31357244100000004,0.473427789,0.54710099,0.505488126,0.345083552,0.09259028009999999,0.0,0.0,0.0,0.0,0.0,0.22139484399999998,0.8942659890000001,1.66677443,2.43274661,3.07940876,3.50819554,3.65338241,3.49462573,3.0607207,2.42372726,1.68466689,0.953804368,0.329689603,0.0,0.0,0.0,0.0,0.0,0.0014739605599999998,0.113236956,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
1.07926648,1.32405754,0.321631575,0.443503397,0.8349948640000001,1.82460428,1.57832644,2.13154804,1.48740143,0.0,0.604011038,0.0,0.0,1.22725669,0.930440501,0.0,0.0,1.17102467,1.33995802,0.0,0.0,0.0,0.972821721,0.0,0.7582273420000001,0.0,0.750093647,2.02335909,0.45249547700000003,0.0,0.0,1.03973089,0.5312333029999999,0.39507161799999996,0.0,1.08453353,0.0,1.13010429,0.0,0.405169128,0.0,0.0,0.5574773129999999,0.0,1.87276696,0.006682469989999999,0.0,0.26354617399999997,0.0,0.0,0.44053471899999996,2.31153976,0.719925985,0.0,0.0,0.436198207,1.67566397,1.59480462,2.73203128,1.84205735,1.26509216,0.914778111,0.784630721,0.0,0.0,1.22199106,0.750859589,1.12108488,0.533365991,0.0,0.0,0.422338857,0.691135669,2.30282373,1.62499745,0.016827587800000002,0.0,0.0,2.13369113,2.220417,5.10395019,4.62757751,3.69559074,1.20023566,0.88526361,0.305222962,0.599611385,1.35279076,2.06975251,3.52997834,1.86757608,0.751478703,0.0,0.0,0.0,0.5589592520000001,1.34482213,0.0,0.306751862,0.0,0.0,0.0,0.582760511,0.0,0.0,0.0,0.639006273,0.0,0.9860806670000001,0.16712534099999998,1.90726104,0.0,0.90435965,0.0,0.060467266799999995,0.015345418999999999,0.60863423,1.19300894,0.06475685910000001,0.052498839299999996,0.0,0.0,0.0,2.32575434,0.702940735,0.019552407,0.298928712,0.8511518029999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.14942279,0.0,0.08100661,0.0,0.54439955,0.0,0.0,0.15875491,0.0,0.0,0.0,1.33632683,0.0,0.26694671,0.11511711,0.0,1.09891781,0.0,0.0,0.06083618,0.0,0.34318471,0.04348813,0.0,0.0,0.67551911,0.0,0.79656653,0.67214986,0.0,0.0,0.0,0.98169679,0.0,0.0,0.53356886,1.82077336,2.11224421,3.48242106,2.93281535,3.04614515,3.53280251,4.14288326,2.8764515,1.34567627,0.37241322,1.1683481000000002,0.0,0.0,0.0,0.85246964,0.69798048,0.8415321,0.71759456,0.55341686,0.0,1.46243566,1.67836767,1.0195457,0.0,0.0,0.0,0.0,0.0,0.61721539,0.59814268,0.0,0.0,1.17597198,0.0,0.5513788000000001,0.14502224,0.27004905,0.0,0.0,0.0,1.00622584,0.0,0.0,0.88664669,0.0,0.14897739999999998,1.32623592,0.18187026,1.60087467,0.42017896,0.95273717,0.95025215,0.51861472,0.16698613,0.0,0.65267451,0.0,0.17540306,0.03133496,0.6191236,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.7692130140000001,1.60106458,2.50899437,3.43000892,4.29661134,5.04286249,5.61042842,5.95400171,6.04554338,5.87691078,5.46060298,4.82855026,4.0290771,3.12235638,2.17482539,1.25313595,0.418250093,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.200617197,0.458511072,0.631294437,0.708339609,0.6911037040000001,0.591773872,0.43084437700000006,0.23397105899999998,0.028509490099999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00891306358,0.123605194,0.211202955,0.26349875300000003,0.27758227,0.255722677,0.204587678,0.133952777,0.0551106039,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.015335683000000001,0.037831484500000005,0.0482773591,0.047388569900000004,0.0379301138,0.024039465,0.0103452206,0.00103479136,0.0,0.00540298782,0.0191481483,0.0373216684,0.0555581514,0.0688658471,0.0725783151,0.0633047971,0.0397176027,0.00303499708,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012400376299999998,0.10265642400000001,0.19018824399999998,0.262154734,0.30647956600000004,0.313669166,0.278436539,0.200887034,0.0870650671,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20011502,0.462084436,0.709524533,0.9120062959999999,1.04184322,1.07774799,1.00802204,0.832866518,0.565483139,0.231756856,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0664600814,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.457
0.769160761,0.663915082,0.5346651889999999,0.0,0.365617924,0.623468594,0.0,0.0,1.13409014,0.0,0.0,0.418376824,0.253441873,0.0,0.0,0.00874319118,0.0,0.617059836,0.206889214,0.0,0.0,0.0605119025,0.0980391762,0.0210142363,0.0,0.0,0.129680593,0.0,0.705497037,0.0,0.596998854,0.0,0.356499411,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.376719976,0.780847785,1.45055982,0.17740145100000002,0.660445257,0.7059648270000001,0.461185675,0.788671682,0.672822885,0.60805444,0.0,0.09584244539999999,0.0,0.0,0.369993255,0.72462144,0.0,0.693574067,0.0,0.0,0.0,0.0,1.0849445,1.19530343,0.6718215270000001,1.96491279,1.93961176,1.87016375,3.23160645,2.70222352,2.97174393,2.96191064,2.76275965,2.67861372,1.97306868,0.972497818,1.72921116,1.18825932,0.367812594,0.0,0.0,0.0426286122,1.1234853999999999,0.0,0.0,0.0,0.0,0.0423557867,0.0,0.43274752899999996,0.817193299,0.0,0.35336551,0.618261077,0.7636983970000001,1.6052253,0.0,0.176562621,0.9289090729999999,0.0,0.0,0.27327073,1.20484864,0.0,0.0,0.0,0.0,0.639799031,0.0,0.94001685,0.288069017,0.357651791,0.766200848,0.7157197390000001,0.587156279,0.0,0.92973229,0.0,0.0,0.0,0.0,0.0017686508199999998,0.0,0.0,0.0569770334,0.391085347,0.258990473,0.0,0.48419869299999996,0.0,0.0,0.0,0.0,0.7122278759999999,0.0,0.39691034299999994,0.0,0.9159058859999999,1.39644401,0.938949527,0.529023575,0.660317673,0.442323399,1.56618871,1.09526294,0.21013969899999999,0.0,0.498436967,0.55915535,0.0,0.7600954759999999,0.29167045,0.0,0.0,0.989654279,0.0,0.0,0.424743563,0.34533366299999996,0.0,0.0,0.28599761100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.240568125,0.22801016300000002,0.00741876522,0.159999171,0.0,0.0414412773,0.0,0.0,0.046483685700000006,0.0,0.770888749,0.8920504229999999,1.79489062,3.2336002,2.48996634,1.80348883,0.0,0.641626829,0.0,0.740717029,0.971532373,0.0,0.0,0.08103597480000001,0.0,0.1274788,0.0,0.172805696,0.0,0.275272599,0.6744875770000001,0.23927834399999998,0.0,1.38277765,1.60923561,0.586147682,1.40291051,0.0,0.491873794,0.0,0.479795364,0.106407614,0.0,0.48795343799999996,1.27010525,0.159717697,0.0,0.43576234700000005,1.27207649,0.675128397,2.10234982,5.13214517,2.24282509,1.88392449,0.56252976,0.0,0.111555656,0.0,0.06622633730000001,0.0,0.0383055207,1.33787824,2.8176935000000003,1.7296241,0.0,0.305583068,0.178445228,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.612287545,1.16950412,1.73862287,2.25986506,2.67597446,2.9399523,3.02156102,2.91157674,2.62310991,2.18976939,1.66094308,1.09492247,0.550933118,0.081291871,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.114499621,0.235354277,0.294426567,0.290718579,0.23442447600000002,0.143649582,0.0401456695,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0238179634,0.059201796699999996,0.074943359,0.071569672,0.05403519389999999,0.030155521600000002,0.0085933891,0.0,0.0,0.0193684045,0.0535894147,0.0988361943,0.150531313,0.204759319,0.259377635,0.314449906,0.371853069,0.434124875,0.5028270810000001,0.576852813,0.6511663329999999,0.71641107,0.759661789,0.7663577090000001,0.7231819890000001,0.621405634,0.460045163,0.248134755,0.00550464096,0.0,0.0,0.0,0.0,0.0,0.0,0.121494646,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
1.06648748,0.9854153990000001,0.9978776340000001,1.12225738,1.33167663,1.56669352,1.75733645,1.84670437,1.80851767,1.65352684,1.42361986,1.17647682,0.9664261190000001,0.8279507690000001,0.766958763,0.7620422720000001,0.774543977,0.7634647240000001,0.6999494620000001,0.5766036520000001,0.408931586,0.22898021899999998,0.0738460179,0.0,0.0,0.0,0.0337111655,0.106608089,0.158489666,0.172206592,0.14570419,0.0906775533,0.0268111377,0.0,0.0,0.0,0.0,0.0,0.0141307424,0.024392717799999998,0.0215578057,0.0113237882,0.00211192082,0.000539350734,0.00796736476,0.0196558228,0.0269327549,0.021494194900000003,1.7639314e-16,0.0,0.0,0.0,0.0,0.0,0.0529875603,0.139771576,0.21399786199999998,0.25353518399999997,0.245694413,0.192495738,0.111045788,0.0284635606,0.0,0.0,0.0,0.0677714822,0.134848361,0.166535475,0.137552615,0.0431326713,0.0,0.0,0.0,0.0,0.0,0.10063825800000001,0.449207872,0.8124143840000001,1.11334342,1.28643492,1.29587165,1.14592706,0.8799738709999999,0.568283412,0.288206278,0.10271345900000001,0.0438135697,0.10584790699999999,0.250559238,0.42210833700000006,0.56705947,0.652785895,0.678272443,0.673757563,0.6892806359999999,0.775824142,0.9652009559999999,1.25533962,1.60599456,1.94666318,2.19465372,2.27803006,2.15657592,1.83446259,1.36079007,0.817810888,0.300296927,0.0,0.0,0.0,0.0,0.0,1.7639314e-16,0.149264368,0.22503341100000002,0.219432298,0.150278494,0.0511419827,0.0,0.0,0.0,0.0,0.0,0.017730973799999997,0.0613903415,0.0863646528,0.0943854366,0.0927877131,0.0893704589,0.08793675220000001,0.08648761,0.0787679958,0.0583402797,0.0232116979,0.0,0.0,0.0,0.0,0.0,0.0224000132,0.08814667849999999,0.13221614199999998,0.134241853,0.0867708056,0.0,0.0,0.0,0.0,0.0,0.0,0.0946324791,0.218903885,0.280301609,0.248204929,0.121722963,0.0,0.0,0.0,0.0,0.0,1.46994283e-16,0.286865352,0.516596689,0.596446472,0.47008750200000005,0.14266680699999998,0.0,0.0,0.0,0.0,0.0,0.325144285,1.47851826,2.74279547,3.88529153,4.68217961,4.97197653,4.69497393,3.9080857000000004,2.77112662,1.50821406,0.354611907,0.0,0.0,0.0,0.0,0.0,0.43148523,0.88228357,1.1541555000000001,1.23674976,1.17941504,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.747541426,0.24325350699999998,0.8528198290000001,0.278309896,0.10023603699999999,0.060875024800000004,0.0,0.0,0.0,0.0,0.0,0.0,0.21721823399999998,0.0,0.0,0.130513675,0.124220908,0.409979343,0.0,0.354374781,0.210389513,0.0,0.245255642,0.246387644,0.468395684,0.14092538699999999,0.0,0.129158302,0.43593164799999995,0.0339483818,0.019366453,0.0,0.0,0.0,0.037283014100000005,0.0,1.11225839,0.703851681,1.16079007,0.509749388,0.0,0.0,0.300917725,0.0,0.5055234789999999,0.553915143,0.624203043,1.11607796,0.965196245,0.0,0.0,0.0,0.0,0.0,0.0,0.970933215,0.46211362899999997,0.0,0.0,0.0,0.136845364,0.0,0.0,0.120871875,0.0,0.0,0.332582399,0.0,0.0,0.0,0.113882223,0.277453629,0.47036953600000003,0.23949028100000003,0.0,0.845939856,0.0,0.0,0.105994139,0.267760565,0.17755606100000002,0.0,0.35992595899999996,0.457503028,0.0245442938,0.996610423,0.330384183,1.2231162,0.283220292,0.417056054,0.0761683743,0.0,0.10858607599999999,0.899919088,0.399181845,0.9848693470000001,1.78924689,1.27258792,0.210805159,0.244859386,0.340449135,0.0,0.514098375,0.0,0.0,0.713766187,0.0,0.0,0.388524593,0.0,0.0,0.201279638,0.0,0.825514835,0.463121128,0.302355096,0.0,0.273731538,0.0,0.102367703,0.0,0.828475788,0.0,0.705915321,0.0,0.0,0.0279590059,0.27887207,0.194797744,0.730605704,0.0,0.35901735100000004,0.919590762,0.0382472653,0.272210839,0.0,1.19221001,0.0385343588,0.0,0.0,0.6144818439999999,1.71718937,1.20783198,0.53432474,0.0,0.0,0.0,0.0,0.230746481,0.358305136,0.148844367,0.24832214800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.156960141,0.0,0.0,1.11836266,0.23967040899999997,0.551616401,0.586081075,0.0,0.0,0.00354237979,0.8267136829999999,0.651993251,0.648167437,1.51602835,0.258905234,1.01593565,0.272564102,0.270408364,0.915010153,1.52084349,1.58799126,0.0,0.47754020799999997,1.14494471,0.276387606,0.7918025559999999,2.229488,1.94560351,1.27083178,0.484863875,1.29658741,0.0,0.0,0.0,0.0,0.575077153,0.247668045,0.750628913,0.989394135,0.635299476,0.0117775865,0.52166002,0.612685732,1.50248601,1.35942421,1.40753766,0.558456417,1.59846631,1.21451921,1.28743014,0.0,0.873238362,1.79950786,2.19585212,2.81535421,2.61462719,2.03951401,2.05417801,2.15026138,1.92703846,3.63917909,3.262082,2.32932364,1.43943471,0.591366269,0.632396006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.348685907,0.274255285,0.17856757899999998,0.0803674693,0.0,0.08643815630000001,0.0772547008,0.26756172100000003,0.470701286,0.0,0.0,0.503987558,0.0032248733399999996,0.0,0.327364878,0.0,0.0,0.0,0.0665023105,0.21585953100000002,0.33676449299999994,0.0,0.274586165,0.0,0.0,0.1497111,0.14436157800000002,0.205805732,0.529174523,0.228182119,0.5748699939999999,0.0,0.0,0.0,0.4263451,0.43271325200000005,0.121221226,0.37048103200000004,0.806252182,0.0901251962,0.025375244900000003,0.0,0.0,0.58610733,0.796375108,0.216480014,0.0,0.0,0.405106265,1.72172321,3.63815831,4.2184006,3.87206906,2.9267069,2.72491395,3.66152392,4.90002781,4.83479123,3.31951824,0.9649952890000001,0.0,0.0,0.0,0.408148536,0.365903955,0.0,0.0,0.0,0.0,0.779419588,0.331039342,0.0274519641,0.07009094639999999,0.357712904,0.383722905,0.17599215699999998,0.07126582740000001,0.10709238900000001,0.0,0.419673423,0.724518991,0.7497790459999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.869446596,0.555557875,0.66164844,1.02343605,0.92965325,1.12554402,1.53219152,1.51651919,1.37602532,1.45653472,1.21408027,0.6115210329999999,0.609797164,0.544119097,0.385557958,0.38572379799999995,0.24100380300000002,0.0,0.148679446,0.0,0.0,0.0,0.25593135699999997,0.0979857348,0.0,0.0724015477,0.0,0.0,0.0,0.009334504109999999,0.0,0.0,0.145041699,0.319424307,0.0,0.117132821,0.0,0.150047044,0.266444291,0.0661642974,0.0,0.112797096,0.268602672,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.238955964,0.0,0.42134657799999997,0.418052225,0.28942141899999996,0.0,0.0,0.0,0.048607295700000004,0.0,0.0,0.0,0.507782902,0.369897396,0.259280752,0.0844028219,0.028705346,0.0,0.0,0.0,0.0,0.0952881444,0.586681405,0.525099943,1.81019178,1.90083638,2.63394945,2.81414591,3.1432652,2.94985399,2.10990077,1.82815184,0.8536075259999999,0.269674036,0.0,0.0,0.0,0.0,0.0,0.0,0.264004837,0.10781125,0.516123199,0.41051169200000004,0.111679532,0.322273037,0.0,0.158105169,0.0,0.0,0.0,0.266219862,0.0,0.373657984,0.5547355429999999,0.0,0.274237512,0.10607614900000001,0.295983037,0.200481697,0.178764122,0.21828406399999997,0.26002895600000003,0.187735658,0.17748976,0.0,0.0,0.156074224,0.480560639,0.160966887,0.0,0.0,0.0,0.0,0.0,0.0479388105,0.348591919,0.0068872637,0.457919643,0.277865453,0.0163983713,0.0,0.0,0.0,0.26112099899999996,0.0,0.0,0.25260075600000004,0.0,0.24545510199999998,0.364631601,0.0,0.0,0.0,0.156904,0.0,0.134860082,0.0,0.285372375,0.0441262216,0.0,0.29564151699999996,0.38703531799999996,0.0,0.0,0.0150787804,0.170142496,0.059216255599999996,0.0,0.175627148,0.368260655,0.0,0.454230963,0.372261082,0.10984074099999999,0.370155844,1.11168422,0.862246115,1.17349243,0.885757085,1.21178619,1.19774129,0.849112476,0.527040229,0.955464933,0.393457887,0.508925551,0.152598919,0.526424896,0.42287284299999994,0.0,0.0,0.006801631409999999,0.276899638,0.553446733,0.0,0.0,0.0631902914,0.139990039,0.0,0.198396176,0.0,0.17716403100000003,0.210269222,0.00961422579,0.0,0.21326282800000002,0.204114625,0.214369723,0.0176052252,0.22443958600000002,0.0,0.249181083,0.276148516,0.143108721,0.025335332999999998,0.31831622600000004,0.0,0.0,0.41295480799999995,0.198473612,0.0,0.0,0.0,0.0,0.0,0.006489256729999999,0.0442717034,0.546145917,0.427803615,0.691649838,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0355545588,0.991976486,1.74202804,2.101768,2.98699736,3.55379474,3.75666097,3.90992081,3.55865976,2.96340099,2.88755979,2.53374268,1.51896247,1.07583843,0.26761878,0.28162846399999997,0.474260904,0.243271782,0.549327727,0.395455746,0.727460619,0.1121089,0.208528132,0.24916271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.591463875,0.7647082959999999,0.531069614,1.02291612,0.750312985,1.46251913,1.59297148,1.54470093,1.40984499,1.14423637,0.353466766,0.277959224,0.38396523200000005,0.0,0.0,0.0,0.164116818,0.059040679400000004,0.286526353,0.0,0.115382015,0.0,0.803276946,0.62232406,0.667156375,0.155974405,0.0,0.293992325,0.104429775,0.381903985,0.0,0.0,0.0,0.483838505,0.487186812,0.0,0.0,0.0,0.0,0.0,0.42679579999999995,0.312116612,0.0,0.26986318,0.00163706482,0.0,0.37147343899999996,0.0,0.789741237,0.0,0.0,0.0,0.0,0.321335501,0.0,0.393756548,0.227585338,0.319683478,0.112915595,0.0,0.0,0.604112355,0.00259379193,0.36707346399999996,0.0,0.257981723,0.0,0.0,0.524244134,0.375310222,0.07006112889999999,0.48671013399999996,0.0,0.252578659,0.0,0.0,0.688554302,0.0,0.0,0.659011485,0.398873194,0.0,0.0,0.496668913,0.602792233,0.563769964,0.0,0.205306656,0.0,0.0,0.0,0.09715505560000001,0.0,0.0,0.22237025300000002,0.0,0.0,0.0369093152,0.67039339,0.0,0.322341139,0.138178457,0.0,0.334748124,0.0,0.118438955,0.0815546308,0.366873564,0.27385042,0.433691315,0.48154268,0.72368783,0.8088145,0.659381581,0.582587564,0.269763433,0.0,0.0,0.141398636,0.0,0.13540773,0.170297632,0.0,0.0,0.513956606,1.18928834,0.5758940229999999,1.81926379,0.852767805,1.46687476,0.8200811309999999,0.42252022100000003,0.56157663,0.21718153399999998,0.134682216,0.422057875,0.5231530329999999,0.30834140600000004,0.0,0.0,0.0323364874,0.632877815,0.0,0.0,0.30367698,0.0,0.0,0.0,0.34925478600000004,0.0,0.7268065220000001,0.43366667600000003,0.859266671,0.149208278,0.193427355,1.0670110000000002,0.101481784,0.0,0.0,0.0,0.0,0.0,0.12643981099999999,0.0,1.14584129,3.32630999,4.28423477,4.73547353,6.49515577,6.55793098,6.88419348,7.39982646,6.12725643,5.92462141,3.80285556,2.01802773,1.26892606,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.728934895,0.443577391,0.346219596,0.46431564700000005,0.258361644,0.0,0.669226475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.45265388700000003,0.36694614799999997,0.189827314,0.542678992,0.0,0.0,0.192057888,0.0951207142,0.18758356899999998,0.0,0.0,0.0,0.0,0.0,0.496784533,0.0,0.330953925,0.160997478,0.37535107,0.0,0.0,0.365593555,0.0,0.407629267,0.0,0.0,0.365852301,0.328079441,0.0,0.0,0.0495267703,0.16741636,0.0,0.0,0.0,0.298915423,0.0,0.0894398592,0.242638226,0.069070406,0.0,0.013704256699999999,0.183445085,0.0,0.00976426807,0.23584941199999998,0.06773530629999999,0.124134465,0.15463759,0.23893818600000002,0.0,0.180517327,0.0,0.295849882,0.0393029935,0.0,0.39125749200000004,0.0,0.0491282847,0.0,0.0,0.0,0.0030202708799999998,0.0,0.403673193,0.0,0.0,0.132585203,0.490261644,0.457823596,0.0,0.236149019,0.24961966,0.254179957,0.264082322,0.162517768,0.0,0.37714104200000004,0.144017233,0.0730005701,0.0,0.18335527899999998,0.542206698,0.0,0.14433275199999998,0.25712615899999997,0.252740197,0.024642497200000002,0.23014577100000003,0.770884702,1.19984944,0.6991926629999999,0.793562544,1.13333139,1.22913847,0.519458154,1.00166628,0.49841064,0.0431510838,0.286795171,0.281950953,0.885081186,0.743420913,0.752828747,0.37037659999999994,0.505443259,0.628634249,0.47384866299999995,0.47865784299999997,0.19463371100000001,0.0,0.176599101,1.24274015,1.33188107,2.26421389,2.93717321,3.42412226,4.30024719,3.94644192,4.58369652,3.8916157,2.83733645,2.45533466,1.52000153,1.25050834,1.04848351,1.00129471,1.02601488,0.8670514109999999,1.36262258,1.66868026,1.48601727,1.9030456999999998,1.8387021000000001,1.72693451,1.59062244,1.53710039,1.30459449,0.879304185,0.6984722170000001,1.0776068,0.541919532,0.542874461,0.35255804,0.5887036520000001,0.663577541,0.434900634,0.0,0.0,0.0,0.0,0.174727861,0.007700377690000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.0305007306,0.0,0.0,0.0,0.0,0.0,0.0,0.183362594,0.0933182872,0.0,0.339222145,0.0,0.0,0.728153935,0.0,0.0,0.81160013,0.0,0.826592381,0.40393731299999996,0.39694135,0.181177432,0.835109082,0.200272977,0.0,0.0,0.0,0.7017723859999999,0.9554550070000001,1.52232511,1.67410762,0.958042684,0.0,0.0399065427,0.40400259,0.0,0.0831132718,0.0,0.158096766,0.44129150100000003,1.26039204,0.809721207,0.629667518,1.22333952,1.48888222,0.664248402,0.0,0.0,0.257575407,0.0,1.05197141,0.0,0.0,0.0,0.0,0.558551069,1.40310773,0.201058989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.583043538,0.261808634,0.90376756,0.0,0.0,0.16729496300000002,0.30243284800000003,0.0,0.0719286349,0.6930264509999999,1.0614832,0.461399606,0.0,0.362083339,0.0,0.0,0.0,0.0,0.76011511,0.270264165,0.754414994,0.0424040621,1.37819904,1.1627702,2.3424438,1.99645576,3.17223382,2.1675211,0.96999,1.39905506,0.8802526070000001,0.493480246,1.60335394,1.14208466,0.9844709079999999,0.0,0.0,0.352409514,1.19899266,0.39593791100000003,0.0,1.5532594,0.492077828,0.0,0.0,0.00933234835,0.08424656359999999,0.0,0.128701154,0.0,0.779009904,0.0,0.0,0.0,0.247605054,0.0404311424,0.38876679399999997,0.0,0.0,0.7692373370000001,0.16822944199999998,0.7501638759999999,0.0,0.0,0.060255051500000004,0.0,0.15153825,0.43903867,0.8275922720000001,1.0903735,0.583517988,0.0,0.0,0.192199609,0.994966618,0.433701934,0.0,0.0,0.0,0.0615246471,0.0,0.287935863,0.18342369600000002,0.0,0.0604367901,0.0,0.0,0.0,0.0,0.0,0.42675419600000003,0.0,0.319032603,0.07209602179999999,1.02955515,1.26889525,1.83128801,1.87943032,0.0704279686,0.0,0.9217073090000001,1.24982996,2.176302,1.12078228,1.9633386000000002,0.0,0.344934313,1.59513195,2.8113826,2.38946932,2.14533474,1.71801103,1.30682397,1.18566493,0.146053903,0.058415959,0.536535475,0.480132668,0.483769283,0.142184161,0.105470705,0.0,0.679163464,0.377901318,0.0,0.0,0.0,0.0,0.108795404,0.12080295099999999,0.0,0.32653494,0.0,0.0,0.0,0.36441517700000003,0.0,0.0,0.260727595,0.0,0.744651753,0.0,0.531577043,0.178751662,0.12475574099999999,0.41369429700000004,0.0,0.120058422,0.0,0.0,0.0,0.0,0.363034552,0.0,0.25854806199999997,0.0,0.44290078899999996,0.0,0.660171031,0.0,0.0,0.720493343,0.0575645988,0.84220295,0.397203353,1.55417111,0.675264338,1.20813217,1.67794836,0.708813813,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.39166776600000003,0.0,1.40588224,2.19872671,0.108545899,1.34291886,2.06477849,1.10128504,0.0,0.0,0.0,0.0752059679,0.0,0.674962101,0.0,0.0,0.0,0.0,0.576041616,0.0,0.128650113,0.0,0.0,0.42499994799999996,0.0,0.0,0.0,0.47151148600000004,0.0,0.849151076,1.43657695,0.0393953894,0.0,1.71085817,0.20034275899999998,0.0,0.723418942,0.0,0.275162862,1.72364466,0.234782087,0.93812945,0.0,1.16583813,0.0,1.08860251,0.0,1.13979177,0.0,0.273646308,0.0,0.0,0.632977494,0.4908143,0.22372451899999998,0.0,0.0,0.505372415,0.0,0.048984340300000005,0.0817632637,0.0,0.0,0.0,0.0,0.350575397,0.0,0.0,0.0,0.0,0.0,0.0,0.32740333,0.82755178,0.0,0.669409316,0.0,0.41945099799999996,0.273270453,0.0,0.0,0.9017456540000001,0.267891962,0.19999776600000002,0.488310996,0.0,0.354608629,0.235350123,0.0,0.0,0.27064594,0.7885329940000001,0.524397543,0.538520095,0.0878349489,0.8380770740000001,1.61860796,0.024756435,0.0,0.561356132,0.154755143,0.0,0.297996215,0.0,0.0,0.0,0.297589851,0.0,0.918444857,0.0,0.0,0.0,0.44269393799999995,0.0,0.8598151740000001,0.101867395,0.9269270390000001,1.64346544,0.0,0.0,0.02089964,0.0,0.491542374,0.9919832590000001,0.0,0.244003327,0.0,0.0,0.6897520629999999,0.443487201,0.48137861200000004,0.0,0.0,0.0,0.494376518,0.0,0.0,2.01105628,0.593483212,0.212969623,0.0,0.5221077479999999,0.479953452,0.0,0.0,0.47504744299999996,0.34462632200000004,0.08623172650000001,0.670656414,1.09260734,0.0,0.0,0.769631669,0.0,0.0,0.0,0.983025672,2.36762694,0.816098456,1.73591556,0.29930062,0.099073618,1.59591767,0.8845512329999999,1.5375536,1.5787143999999997,3.12325922,4.6060233,2.80025891,5.65588497,2.9721646,1.46992412,1.33546393,2.55403112,1.2389301000000001,1.92217182,1.20525672,1.11529861,0.0,0.245982385,0.0,0.0,0.510242519,0.377199467,0.599389207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
1.81726505,2.15910728,2.15967616,1.89418958,2.48511472,1.8113408,1.70298893,1.86504928,1.65679548,3.07150174,1.8713904,1.89990837,1.26664046,1.18471269,0.750637168,1.60368038,0.857488215,0.959034948,1.81969126,0.973437023,0.40362366200000005,0.480851146,0.6875597090000001,0.639848448,1.2322374,0.0,0.5424474970000001,0.433109387,0.0,0.436038281,0.0,0.694550552,0.20388181600000002,0.7434826440000001,0.0,0.0,0.038864336,0.191609103,0.0,0.165037254,0.0,0.0,0.0,0.0374084584,0.602918872,0.168108772,0.426777025,0.0658343953,0.506495561,0.0,0.0,0.0,0.52277357,0.0708984394,0.0,0.347053936,0.0,0.0455755546,0.0043437684100000006,0.0,0.722945976,0.0,0.167237359,0.0,0.270914534,0.61137671,0.049482407,0.959537805,0.12902819599999998,0.387106305,0.0,0.0,0.44051777299999995,0.219387508,0.0766359462,0.412185454,0.0,0.31717465100000003,0.0,0.0,0.17062092199999998,0.0,0.0,0.346131266,0.0,0.0,0.29344409899999996,0.0310988808,0.43041987299999995,0.826829183,0.0601093504,0.0415657273,0.194585719,0.0,0.34172163,0.44488927100000003,0.69289877,0.0630197895,0.0,0.0293245111,0.27554379,0.0172804286,0.352290307,0.62678494,0.132282656,0.702774479,0.0,0.301772312,0.662950493,0.0,0.0,0.06950049330000001,0.34125495299999997,0.892506695,0.0,1.04364936,0.00767387728,0.439014655,0.0,0.0,0.0,0.0,0.464530702,0.0,0.0,0.589783209,0.0,0.636116865,0.138540375,0.283908969,0.080607124,0.16973653,0.0,0.628002492,0.0,0.0,0.0,0.292187687,0.290942812,0.0,1.29562363,0.09097438210000001,0.506083586,0.0,0.0,0.0,0.0317602986,0.0285125917,0.793398788,0.10164514300000001,0.0,0.0,0.00913480105,0.0652386613,0.0,0.0,0.0,0.383705013,0.0,0.630969275,0.0,0.205110595,0.7882687079999999,0.0,0.0,0.0,0.443461325,0.0,0.101018137,0.0,0.0,0.0522079892,0.8374706000000001,0.0,0.0,0.0,0.5401017770000001,0.47786850700000005,0.0,0.0,0.6187304570000001,0.307385766,0.0,0.58303021,0.0,0.388268978,0.0,0.0,0.0,0.7712330390000001,0.0,1.70023747,0.962800323,1.99582749,1.14614536,1.41295498,1.0580368999999998,0.750745353,1.87083677,1.24128927,1.64432211,1.80409494,1.98930137,1.92422606,2.02655608,2.2134956000000003,2.0014853,3.14419779,2.84590927,2.87366508,3.14504325,2.62970285,1.95272247,2.20844405,2.03959579,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.42838604,1.57058715,0.8626852190000001,1.28853456,0.875683069,0.367380813,0.5809683139999999,0.153595944,0.361564076,0.0,0.7194781840000001,0.210396732,0.99085349,2.30566287,2.69045709,3.49874411,3.81449535,4.92685238,5.20689346,4.93873491,4.80969146,4.43559894,4.35508254,3.30658971,3.13340271,2.03450958,1.25157974,1.23893776,1.16120599,0.487131084,0.6759759259999999,0.526735755,0.749498476,1.09665854,1.52243077,0.7820260379999999,0.451796139,0.26725166100000003,0.764142012,0.0,0.261365099,0.0,0.0,0.0,0.0,0.11676679599999999,0.360584986,0.363905849,0.464208114,0.0,0.598997412,0.636891179,0.0,0.282813119,0.0,0.0,0.0,0.0,0.39521426,0.5384720679999999,0.11142790300000001,0.0,0.40832847299999997,0.0,0.0222651643,0.44208129700000004,0.0966212857,0.0,0.38471012,0.22589350100000002,0.154126517,0.281050315,0.0,0.21340353199999998,0.0,0.0803482907,0.0,0.12639113800000001,0.0460445127,0.253698478,0.0,0.0,0.055097577800000005,0.189675281,0.11596852,0.0,0.0,0.0,0.230601101,0.0,0.0,0.43220648100000003,0.340712908,0.441222944,0.415486459,0.0708020761,0.298585783,0.310076872,0.29584353399999996,0.532204188,0.0,0.5300804370000001,0.546013586,0.0,0.22071274800000001,0.338516414,0.366733109,0.0,0.0,0.0,0.0,0.0,0.0,0.494040086,0.0,0.11298232400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.130386628,0.0,0.0,0.0,0.084896149,0.19982674,0.0,0.354224008,0.0,0.0,0.0,0.102253359,0.0,0.0,0.26591355899999997,0.0,0.405904819,0.0,0.0,0.0,0.51146097,0.21123571,0.0,0.399778632,0.171530078,0.0856110061,0.0,0.0,0.0,0.320764332,0.0,0.0,0.360109192,0.0,0.0,0.480493926,0.0,0.0643659383,0.46116331899999996,0.0,0.0045326371,0.0,0.0,0.0645120076,0.351927331,0.266776992,0.0,0.155039813,0.169157373,0.12375084199999999,0.0,0.41379275600000004,0.00276621363,0.0,0.0,0.452713354,0.455748876,0.49664840299999996,0.0,0.45419771700000006,0.406346195,0.23687486800000002,0.513785818,0.0,0.0,0.38805940299999997,0.0,0.18141589,0.0,0.20467808,0.0,0.42700941200000003,0.0424378713,0.21775749100000003,0.0,0.0305685263,0.0,0.158242451,0.312682269,0.0,0.164483408,0.33147229300000003,0.227913175,0.28680526,0.0,0.30352693,0.0,0.0,0.0,0.537028222,0.182497656,0.46978982799999996,0.09969553490000001,0.699447224,0.0,0.29862768,0.966818018,0.43098932,0.97133454,1.09577258,1.21679632,1.52101643,0.6865328279999999,0.9773348740000001,0.29225002899999997,1.14078946,0.6106590999999999,1.14977831,1.14889109,0.743321624,1.10627696,0.720520005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.0692283485,0.0499638009,0.0632179188,0.108093679,0.171045539,0.23172068899999998,0.272348036,0.287042849,0.287210919,0.300552392,0.363515779,0.509555613,0.7572407729999999,1.1024737,1.51769841,1.95849158,2.37527008,2.72601364,2.98559429,3.14864972,3.2254292999999996,3.23273069,3.18389701,3.08213826,2.92004708,2.68562109,2.37236414,1.9891880000000002,1.56562573,1.14943397,0.796460735,0.555658729,0.454196479,0.487945775,0.621021754,0.795051802,0.945507867,1.01995382,0.9923383370000001,0.8687774420000001,0.6831597620000001,0.484347112,0.319515455,0.21932086899999997,0.189713482,0.212714994,0.255260248,0.282448486,0.270223096,0.213019233,0.124018534,0.0284930429,0.0,0.0,0.0,0.0,0.0,0.0339257418,0.0451928025,0.0341140598,0.0122347255,0.0,0.0008835902779999999,0.0305759167,0.078718151,0.129495904,0.164764367,0.171932278,0.1496797,0.10903327,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
1.8332282,7.70735371,4.00052803,1.44433135,0.0,0.30108027,1.21972411,2.89081132,1.25297212,0.0,0.76692486,0.0,0.17704937,0.17738743,0.0,0.74360019,0.0,0.74485195,0.0,0.0,1.14592025,0.0,8.42801533,12.20924192,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.462
0.33056703,0.0,0.0,0.0,0.615414297,0.0,0.0,0.8546401920000001,0.0,1.44953931,0.0,0.0,0.187451129,0.228374887,0.44704531,0.561808114,0.0,0.0,0.174030488,0.5082989170000001,0.0,0.0,0.0741682092,0.538257925,0.0,0.535341873,0.478853442,0.35575491299999995,1.13537995,0.374308573,0.607053442,0.0,0.0,0.0,0.36148892899999996,0.0,0.5108593920000001,0.538966509,0.225023544,0.0,0.0,0.16389493900000002,1.83015959,2.20556234,2.32796725,3.39357405,2.02618652,1.47851231,0.356708204,0.0,0.783658973,0.0,0.0,0.0893840625,0.0,0.0,0.0,0.577344535,1.00120896,0.8021302690000001,2.09545401,0.8292488659999999,1.41845843,0.0,0.428330944,0.0,0.394972079,0.0,0.515502726,0.527129693,0.267323091,0.0,0.12143974199999999,0.0,1.32431285,0.0,0.17423154600000001,0.0,0.12622535,0.29840018,0.0,0.0,0.0,1.37168779,0.5825909979999999,0.5207647120000001,0.0752276814,1.67881907,1.25911413,0.0,0.0,0.572874316,0.0,0.342481834,0.0,0.0,0.0,0.284910532,0.058041958600000006,0.0,0.0,0.877990955,0.0,0.755383292,0.19557365100000002,0.0,0.11422670900000001,0.0,0.0400239877,0.0,0.116017392,0.45950956,0.463539169,0.0,0.0,0.79182634,0.203690503,0.0,0.0,0.0,0.0,0.0,0.47983933,0.651622635,0.0,0.6446094729999999,1.51478306,0.643059405,0.27394126399999996,1.08557608,0.333750647,0.0,0.0,0.58454364,0.0,0.859900365,0.0,0.985348125,0.0,0.0,1.64984324,0.0,0.25150982,0.324873499,0.752678528,0.35944387,0.0,0.0,0.0,0.12293870300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.45623888,0.56927541,0.0,0.0,0.0,0.33895673,0.3756393,0.0,0.0,0.0,0.52939097,0.58683405,0.0,0.0,0.71269973,3.00997652,4.88660705,4.75154364,2.63246338,0.18450408,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.17307395600000003,0.517129419,1.1990656000000002,1.54372146,1.40029655,1.93923598,2.6528593999999996,3.36817817,3.07707962,3.68418648,4.31304926,4.13668972,4.41126175,4.55865816,5.31606863,5.44891771,5.45093764,5.10837023,5.09713308,5.00853925,4.9133966,4.35540734,4.89270642,4.41733061,4.04358301,3.26312277,2.64852131,2.46370614,2.10499155,1.10872391,0.656039719,1.25658286,0.6828347290000001,0.00435282597,0.0,0.0118072633,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0821335772,0.0,0.28228042,0.0,0.0,0.0,0.776842943,0.595274553,0.0271281183,0.161278877,0.480252678,0.0779275257,0.7700336590000001,0.35937711299999997,0.00716096015,0.0,0.0,0.283545982,0.25697372,0.189242572,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.186506891,0.0,0.0,0.125727855,0.0,0.0,0.292006149,0.458588038,0.08593926730000001,0.46517646700000004,0.0,0.314327144,0.233526376,0.0,0.0476129125,0.036693267200000004,0.175991822,0.182244619,0.0,0.588088485,0.0,0.48887945200000005,0.22435876100000002,0.30526645399999996,0.340382754,0.0,0.0,0.419752226,0.0,0.0,0.0,0.5840629420000001,0.0295837292,0.36611153,0.187351132,0.42449588299999996,0.0,0.335815294,0.244597941,0.140093745,0.335032558,0.338097909,0.0,0.0,0.40424310799999996,0.0,0.0,0.0092232139,0.0,0.0507826889,0.17719786699999998,0.0171507461,0.0,0.0,0.0,0.0,0.342356837,0.0,0.08317009980000001,0.0,0.535697373,0.512109273,0.014208036200000001,0.0,0.46631036200000003,0.498831081,0.689010259,0.495804766,0.735919889,0.385419616,1.0898443000000002,0.551101729,0.7565345379999999,1.00368084,0.580284225,0.0,0.538410571,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
0.162961779,0.10316610300000001,0.106171406,0.18742322100000003,0.332883755,0.501795255,0.638877339,0.6922094590000001,0.631019508,0.45743698299999996,0.20806990600000003,0.0,0.0,0.0,0.0,0.0,0.0345124425,0.24882262600000002,0.39201944,0.418587043,0.319990648,0.127286663,0.0,0.0,0.0,0.0,0.0,0.010736309599999999,0.21641951,0.350493245,0.369108668,0.266032889,0.0747984941,0.0,0.0,0.0,0.0,0.0,0.060419071500000004,0.26296181,0.38079694700000005,0.373786656,0.242483515,0.0285350877,0.0,0.0,0.0,0.0,0.0,0.11931259599999999,0.327940561,0.431904059,0.39415281700000004,0.223824706,0.0,0.0,0.0,0.0,0.0,0.0,0.197555676,0.42045902700000004,0.509871848,0.43124203200000005,0.204853421,0.0,0.0,0.0,0.0,0.0,0.0,0.314740203,0.565051696,0.636791902,0.49668882700000005,0.180721319,0.0,0.0,0.0,0.0,0.0,0.06936804740000001,0.522608869,0.830922092,0.87851377,0.628228221,0.14004524699999998,0.0,0.0,0.0,0.0,0.0,0.285007744,1.02557202,1.50822997,1.52890282,1.00683275,0.0277707879,0.0,0.0,0.0,0.0,0.0,1.45873322,4.38908006,7.43847222,10.050007800000001,11.723073800000002,12.1290555,11.1882761,9.08854877,6.24064453,3.18215805,0.454312981,0.0,0.0,0.0,0.0,0.0,0.444140881,1.25092325,1.55385235,1.33730603,0.7367014359999999,0.0,0.0,0.0,0.0,0.0,0.0,0.339546335,0.733419704,0.863047748,0.708802932,0.340856679,0.0,0.0,0.0,0.0,0.0,0.0,0.303435932,0.545208104,0.598809983,0.457135784,0.17561493600000003,0.0,0.0,0.0,0.0,0.0,0.0211770055,0.284795228,0.445637912,0.455944064,0.318250987,0.0826382396,0.0,0.0,0.0,0.0,0.0,0.06881719830000001,0.27295553300000003,0.382060182,0.36364961799999995,0.227525862,0.0213467717,0.0,0.0,0.0,0.0,0.0,0.101751459,0.263505117,0.335236705,0.295852864,0.16097259,0.0,0.0,0.0,0.0,0.0,0.0,0.124101484,0.2501766,0.290720168,0.234979402,0.104650445,0.0,0.0,0.0,0.0,0.0,0.08127119940000001,0.239291959,0.337602445,0.34403663100000004,0.256044343,0.10132330099999999,0.0,0.0,0.0,0.0,0.0,0.0262580727,0.164672287,0.245598912,0.243798045,0.162327553,0.0310371997,0.0,0.0,0.0,0.0,0.0,0.130876609,0.255059624,0.319650844,0.312316178,0.247850448,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.509
2.64673251,2.46928538,2.2786504,2.07780429,1.86987158,1.65805517,1.44556534,1.23554906,1.03102161,0.834802048,0.649454521,0.477236619,0.320056279,0.179438189,0.0565004733,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0133153473,0.05042693980000001,0.08247637669999999,0.10864579699999999,0.12839171300000002,0.14144349,0.147793539,0.147679817,0.14156149099999998,0.130088793,0.11406824300000001,0.0944245464,0.0721605291,0.048316497699999995,0.023930387799999998,1.44944698e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.010196248100000001,0.0244657246,0.0370334229,0.0474553688,0.055395915899999995,0.0606376633,0.0630863061,0.0627703533,0.059835851100000004,0.054536439000000006,0.047219249299999995,0.038307311600000005,0.028279262200000002,0.0176472513,0.006934009790000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00560141391,0.0164719933,0.0277456635,0.0391663733,0.0505499825,0.0618065561,0.0729596794,0.08416183869999999,0.0957050324,0.108025925,0.121705046,0.137459724,0.156130695,0.178662514,0.206078166,0.239448477,0.279857127,0.328362279,0.38595596600000004,0.45352251200000004,0.531797364,0.621327698,0.722436229,0.835189527,0.959372095,1.09446731,1.2396461,1.39376414,1.55536795,1.72271007,1.89377331,2.0663037,2.23785141,2.40581883,2.56751472,2.72021288,2.8612140999999998,2.98790959,3.09784412,3.18877725,3.25874094,3.30609166,3.32955573,3.32826646,3.30179185,3.25015205,3.17382604,3.07374703,2.95128677,2.80822896,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.695580309,0.635761315,0.0,0.0,0.816527962,0.255880583,1.38355972,1.43215171,2.32273479,1.56540411,0.791524043,0.235346405,1.30968889,0.0760824808,1.47534243,1.49681624,2.6614758,3.54016813,3.24027328,3.20946632,4.11851724,3.53997723,1.96881834,1.0566389999999999,0.0,0.0,0.0,1.17137866,1.58436579,1.39773455,1.02257662,0.273715596,1.07790181,0.748057619,0.562711311,0.27503723399999996,0.0,0.10831548099999999,0.38013362700000003,0.0,0.29833447,0.242448059,0.0,1.06823409,0.0,0.18420335100000002,0.0,0.09796277960000001,0.0,0.41847138799999994,0.0,0.90218933,0.931657005,0.0,0.0,0.0599496132,0.326279998,0.0,0.654606879,0.0,0.961683704,0.0,0.0,0.192753825,0.0,0.875427222,0.39718654600000003,0.0,0.8053455970000001,0.0,0.6476138889999999,0.0,2.07574178,0.171558128,0.308194587,0.0,0.219106971,0.0,0.0,1.31159204,0.0,0.328229518,0.697854135,0.0,0.210630235,0.0,0.0,0.39912313299999996,0.0,0.6129474460000001,0.9009510159999999,0.0,0.144459913,0.13556754199999999,0.6976780890000001,0.0203712423,0.5396610589999999,0.0,0.0,0.74643713,0.0,0.298719807,0.0869518035,0.451605241,0.0,0.0,0.0,0.295881363,0.0,0.769057973,0.0,0.0,0.143664072,0.701275616,0.0,0.540228437,0.387195876,0.0,0.0,0.0,1.40566839,0.0,0.639389904,0.0,0.0,0.00876136573,0.450104754,0.689437435,0.0,0.168265745,0.471489861,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
1.77786053,2.81845821,3.58687994,3.82385079,3.42784704,2.504608,1.3442246,0.330314746,0.0,0.0,0.80331947,2.02891373,3.26915305,4.12883197,4.33488894,3.82160378,2.74320396,1.4122593,0.18869477399999998,0.0,0.0,0.0,0.0,0.19190666899999997,0.517071878,0.566977674,0.36627815700000005,0.0375055294,0.0,0.0,0.0,0.0,0.08995614769999999,0.272803256,0.317055059,0.216881264,0.0297184356,0.0,0.0,0.0,0.0,0.054006205700000004,0.181274465,0.218439432,0.15510137699999998,0.0262481153,0.0,0.0,0.0,0.0,0.0358961415,0.133767951,0.16588793,0.121311011,0.0242007967,0.0,0.0,0.0,0.0,0.0247979592,0.10356648,0.131505594,0.09844334960000001,0.0224003158,0.0,0.0,0.0,0.0,0.0167455418,0.0792338683,0.102035352,0.0772625909,0.0194007072,0.0,0.0,0.0,0.0,0.0092374074,0.048165703899999995,0.0580259599,0.038905442,0.008224948979999999,0.0,0.0168924703,0.09498109789999999,0.229958152,0.420770762,0.672488175,1.00226847,1.43507957,1.98808708,2.64912299,3.35953523,4.01222706,4.47087236,4.60763603,4.34775173,3.70410888,2.7864312,1.77788158,0.8841862070000001,0.271794066,0.017260268,0.08711265480000001,0.35652827,0.660238847,0.8561611179999999,0.876771999,0.747838434,0.567276361,0.45347864600000004,0.48557498600000004,0.662078862,0.8971677290000001,1.05802538,1.02861938,0.7726136709999999,0.366536404,0.0,0.0,0.09392546310000001,0.782030425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.0853505468,0.20800251600000003,0.285958534,0.296370998,0.24313110699999999,0.15278526,0.0617397495,0.000722653973,0.0,0.00199723747,0.0354853283,0.058759810999999995,0.055577326100000005,0.025094317999999997,0.0,0.0,0.0,0.0,0.0,0.0335517265,0.0613036574,0.061303875599999995,0.0346754852,0.0,0.0,0.0,0.0,0.0,0.0140889375,0.0312752937,0.028303849300000003,0.0116793614,0.0,0.016192352900000002,0.07878477860000001,0.19226850899999998,0.344483626,0.509965126,0.658700776,0.766520705,0.8227972720000001,0.832352159,0.811018844,0.77706317,0.7424126870000001,0.7076298390000001,0.662810101,0.593884584,0.49135925399999997,0.35741056299999996,0.207964507,0.0685924117,0.0,0.0,0.0,0.0,0.0423413767,0.0999684725,0.128873706,0.123352622,0.09119460230000001,0.048576977699999996,0.0123616722,0.0,0.0,0.0047671588,0.0196891899,0.030519560600000002,0.0355101638,0.0377868786,0.0418956631,0.0496363463,0.0578871205,0.060079621,0.0509371217,0.032054627,0.014962304099999999,0.0190876493,0.0643241972,0.160751066,0.300074966,0.453467974,0.578325871,0.6327740629999999,0.593005916,0.46645248200000006,0.294498403,0.142001152,0.07602799910000001,0.140967819,0.339462886,0.627259083,0.925335163,1.14620667,1.22558988,1.14797873,0.95633599,0.741573514,0.61479768,0.6716489929999999,0.9610054659999999,1.46869736,2.12133371,2.80804996,3.41179549,3.83904422,4.03844089,4.00400824,3.76486161,3.36822713,2.86399967,2.29673231,1.70614578,1.13238942,0.6197620110000001,0.21366948100000002,0.0,0.0,0.0,0.0,0.0525183028,0.0913093269,0.0508085307,0.0,0.0,0.0415197838,0.38868181799999996,0.978388548,1.72070125,2.43662688,2.90579579,2.94012965,2.45930529,1.53972913,0.41510486700000004,0.0,0.0,0.0,0.0686202792,1.63869341,3.46403481,5.11001825,6.18033055,6.431106400000001,5.8371794999999995,4.58949148,3.02618265,1.52236829,0.377016339,0.0,0.0,0.0,0.0,0.18141351600000002,0.275219452,0.31672945399999997,0.442266637,0.790789992,1.42702059,2.29400461,3.21515352,3.94626847,4.25850547,4.02115514,3.25300049,2.12274613,0.897952137,0.0,0.0,0.0,0.0,0.0,0.229535089,0.528831875,0.567480897,0.369152708,0.0448798266,0.0,0.0,0.0,0.0,0.0593303291,0.28730898,0.395593595,0.357435916,0.20778042300000002,0.023004107000000003,0.0,0.0,0.0,0.054819368099999995,0.186708073,0.252875858,0.222261593,0.107240904,0.0,0.0,0.0,0.0,0.0,0.0881562117,0.18970731899999999,0.215810138,0.160408043,0.0515966227,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.456
1.14738569,1.53504133,1.81821883,1.77702661,2.23949069,2.55857345,2.62332109,2.07344212,1.88268863,1.59299757,1.36339303,1.33125386,0.483830096,0.0580176351,0.0106703361,0.0375866828,0.0,0.036603880299999995,0.40395772799999996,0.648584164,0.770535553,1.32633383,1.59451456,1.93178063,2.3364397,2.54097399,2.72967156,2.94255004,2.33238772,2.18737446,1.91513552,1.86227225,1.25996676,0.629738417,0.5048978679999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.32632594600000003,0.199163223,0.0840158276,0.445148239,0.631026403,0.311152163,0.372769356,0.360333275,0.194574025,0.0,0.0,0.0119199807,0.0,0.0,0.0,0.0,0.0649483562,0.220253478,0.0,0.109809596,0.40995942,0.211798656,0.43641097,0.0,0.0862811465,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0961761415,0.0,0.292158945,0.00117885584,0.0,0.0663632789,0.343040771,0.0,0.0,0.0,0.11790941699999999,0.0,0.031159072700000002,0.0,0.0812111729,0.08484564480000001,0.132281369,0.0,0.19658277100000002,0.255059625,0.187847922,0.0,0.0,0.0,0.029767173900000003,0.310218372,0.0755574945,0.060403962900000004,0.0,0.0,0.0,0.0,0.0,0.00420103693,0.0200461262,0.0,0.256931332,0.227580859,0.0,0.0,0.182255765,0.0,0.167443667,0.0,0.0,0.0,0.152533719,0.15398620000000002,0.0,0.0571913658,0.20168450300000001,0.135457919,0.144437201,0.084227205,0.07327790070000001,0.0,0.195064295,0.20145255199999998,0.0,0.0,0.0128648053,0.178099006,0.120945347,0.14844068900000001,0.004086979970000001,0.0,0.0,0.0390689241,0.0864037994,0.0,0.0,0.0,0.146256163,0.0,0.0,0.0,0.0,0.0,0.192166778,0.181509847,0.0,0.0,0.0,0.045909628,0.0,0.0,0.36651827299999995,0.163658854,0.21727257100000003,0.0235862302,0.0968179073,0.452054377,0.648052395,0.81986427,1.00131352,1.12384221,1.20428375,1.53193569,1.70670726,1.63213489,1.97556869,2.42548072,2.24450012,2.42776661,2.5934566,2.72488413,3.05064389,2.55075262,2.9141054,2.30069295,2.49596717,1.79936484,1.45628631,1.54414978,1.00402206,0.9761846340000001,0.40793445799999994,0.0,0.0,0.0,0.170733298,0.0,0.27559044,0.433746773,0.43736407299999996,0.5532175810000001,0.208307611,0.47571786899999996,0.5884205379999999,0.6769491409999999,0.353193905,0.66427203,0.606213212,0.48526568299999995,0.063727667,0.0888031877,0.22280543100000003,0.216288707,0.647863134,0.23690951899999999,0.7674307020000001,0.621467982,0.73270703,0.394036107,0.788737605,0.478553368,0.621981853,0.560046872,0.329960634,0.112047038,0.074293998,0.023933650299999998,0.079889372,0.157105487,0.18481488,0.437304415,0.26229193300000003,0.664544799,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.01863415,0.0,0.09821489,0.0,0.1549326,0.17157041,0.24443369,0.42757968,0.37260765,0.30828871,0.64427452,0.5673113000000001,0.17253999,0.21480227,0.65320255,0.33478288,0.64973108,0.59941986,0.19055062,0.66789577,0.40964809,0.61140372,0.21825842,0.05056259,0.25621037,0.06435885,0.02085687,0.36774829,0.0,0.0,0.0,0.00892103,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04795644,0.0,0.0,0.0,0.07980572,0.0,0.30121223,0.21370608,0.14792467,0.49512294,0.46909739,0.52051151,0.64185982,0.64441439,0.23607699,0.39458038,0.6647225999999999,0.5621121,0.69523456,0.42921711,0.23205884,0.64766564,0.11329142,0.29400052,0.27581957,0.34334788,0.24172004,0.0,0.0,0.21608838,0.29844469,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.05068602,0.12640408,0.34687107,0.59793089,0.48190561,0.94039224,1.01303715,1.33783116,0.92176923,1.51439491,1.26061261,1.34625812,1.57816626,1.75637491,2.17695854,2.02655695,2.51065948,2.5084397999999997,2.40346964,2.73985178,2.45526907,2.73588749,2.90122894,3.13663503,3.16092364,2.72027412,3.23887203,3.01453651,2.69710035,2.76493816,3.16053628,3.07624338,2.59850867,2.59965053,2.57593112,2.81416683,2.54097821,2.35814659,2.46615378,1.93503509,2.1214767999999995,1.77835268,1.94883634,1.67657271,1.62464395,0.98989369,1.02149609,0.75695979,0.91190625,0.95054459,0.63485652,0.17859257,0.39469664,0.29324991,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.291507782,0.467154908,0.6461810020000001,0.783439599,0.8375465759999999,0.785225352,0.630577984,0.40560219999999997,0.161388798,0.0,0.0,0.0,0.0,0.0,0.0382393434,0.111328275,0.13139581,0.09933807439999999,0.0347742241,0.0,0.0,0.0,0.0,0.0,0.027940907,0.055752764100000005,0.057936575,0.037842777200000004,0.0071617079200000005,0.0,0.0,0.0,0.0,0.0,0.00906962246,0.0107532704,0.00591676238,0.000495260555,6.31829749e-05,0.006224113910000001,0.0153126908,0.020216226,0.014499881899999999,0.0,0.0,0.0,0.0,0.0,0.0123222304,0.056898659000000004,0.0857217408,0.081610298,0.039308033,0.0,0.0,0.0,0.0,0.0,0.060097904400000006,0.162525657,0.211720682,0.175880672,0.0549293513,0.0,0.0,0.0,0.0,0.0,0.21534087,0.449845108,0.535950437,0.398147749,0.038413916299999996,0.0,0.0,0.0,0.0,0.0897980398,1.38700274,2.94073063,4.432073,5.51713116,5.92281014,5.52836871,4.40634559,2.80822267,1.09730685,0.0,0.0,0.0,0.0,0.0,0.312904281,0.859185764,1.01947534,0.778185448,0.263147256,0.0,0.0,0.0,0.0,0.0,0.333277472,0.684204032,0.758247557,0.53155806,0.094353094,0.0,0.0,0.0,0.0,0.0,0.540546509,1.02652809,1.28365279,1.25742938,0.9901209809999999,0.598362234,0.225360633,0.0,0.0,0.026451199900000003,0.18464463899999997,0.298974728,0.292692144,0.150516916,0.0,0.0,0.0,0.0,0.0,0.126107276,0.36629438799999997,0.468018045,0.38180001,0.133472587,0.0,0.0,0.0,0.0,0.0,0.253558263,0.531811196,0.607597556,0.436515883,0.0722517413,0.0,0.0,0.0,0.0,0.0,0.486979285,0.8389523870000001,0.869819936,0.5346262070000001,0.0,0.0,0.0,0.0,0.538167457,2.34782009,4.58280911,6.80500035,8.52793311,9.34927959,9.06376603,7.72190851,5.61657942,3.20181769,0.9690822159999999,0.0,0.0,0.0,0.0,0.0,0.4069119,0.835671962,0.878823247,0.590891005,0.131162163,0.0,0.0,0.0,0.0,0.0,0.251245537,0.421373924,0.412267596,0.247215226,0.00524756093,0.0,0.0,0.0,0.0,0.0204437271,0.18653969199999998,0.266694103,0.237521056,0.119087612,0.0,0.0,0.0,0.0,0.0,0.049525338200000005,0.167240964,0.229841308,0.22439639399999997,0.163774739,0.0784319898,0.00250037177,0.0,0.0,0.0,0.022239577400000002,0.0471398646,0.0497437042,0.032058606499999996,0.00610789561,0.0,0.0,0.0,0.0164399884,0.031847591,0.0355636067,0.0316008438,0.035801326,0.07039362019999999,0.154059519,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.484
1.95343694,0.46356211399999997,1.08626857,0.0,0.8501578870000001,2.58817515,0.0,0.652246393,0.0,0.0,0.0,0.0,0.0,0.873540542,0.8373542209999999,0.0,0.0,1.64519003,1.31490471,0.0,1.11386507,0.0,1.31550713,1.92716394,0.168848028,0.0,0.0781643161,1.15582026,0.0,0.741873527,3.34077911,0.0,0.0139502224,3.58925619,1.09927103,0.0,0.555788939,7.90423499,7.16321733,2.09727901,0.128882295,4.21253844,0.0,0.0,0.0,0.0,0.0,1.69386637,0.95974941,0.0,0.0146723269,0.0,1.45429853,1.27390578,0.0,0.0,1.13372082,0.0,2.1145917,0.0,1.30628737,4.30703766,0.385990103,0.0,0.0,0.0,1.27397066,0.20297378300000002,0.526714879,0.0,0.0,0.129348273,0.0,0.47709298299999997,1.96866497,0.591950978,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
1.55147993,1.4958605,1.31829115,1.037453,0.688920132,0.320175642,0.0,0.0,0.0,0.0,0.0,0.0,0.023080375499999996,0.21261154399999999,0.33863388299999997,0.371553753,0.305007555,0.157381275,0.0,0.0,0.0,0.0,0.0,0.0,0.0465829711,0.244236592,0.382745891,0.421376477,0.34448644,0.16706855199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0994408917,0.38165140799999997,0.577104909,0.622567564,0.49277875200000004,0.21323684699999998,0.0,0.0,0.0,0.0,0.16982134699999998,1.12755072,2.41642867,3.8977047,5.3793138,6.64857322,7.5108618,7.82638533,7.53733881,6.67969266,5.37704223,3.81775422,2.22016767,0.7930722929999999,0.0,0.0,0.0,0.0,0.0,0.0,0.266686125,0.579901543,0.697307887,0.619631367,0.394632765,0.0993218649,0.0,0.0,0.0,0.0,0.0,0.0,0.13296775800000002,0.264125661,0.310212195,0.26932697899999997,0.163227092,0.029291727400000002,0.0,0.0,0.0,0.0,0.0,0.11053347599999999,0.210508334,0.266229183,0.264886387,0.209402283,0.11650965199999999,0.0112830719,0.0,0.0,0.0,0.0,0.0,0.0,0.052430251500000004,0.0857303075,0.09100198949999999,0.0714859516,0.0369690498,0.0,0.0,0.0,0.0,0.0,0.0,0.000395251248,0.00252196378,0.0,0.0,0.0,0.0,0.00242533533,0.028438205,0.055419238899999994,0.0722989681,0.0690559574,0.0407667207,0.0,0.0,0.0,0.0,0.0,0.0,0.0238809208,0.135441897,0.22924257399999998,0.27240866199999997,0.24045097,0.12607818199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.155616747,0.711415558,1.3433368,1.96049027,2.46608096,2.77610263,2.83623697,2.63321713,2.19806492,1.60038235,0.934859881,0.302891858,0.0,0.0,0.0,0.0,0.0,0.0,0.122578786,0.30994460100000004,0.39294600399999996,0.364866652,0.246513958,0.07821534570000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0752611415,0.17089174899999998,0.213977311,0.197516152,0.130412312,0.033973121,0.0,0.0,0.0,0.0,0.0,0.0,0.0573129997,0.11818800199999999,0.14457294199999998,0.131325603,0.08381420490000001,0.0159915621,0.0,0.0,0.0,0.0,0.0,0.0,0.0548529232,0.10670061900000001,0.13038039699999998,0.118975035,0.0744907834,0.007999116609999999,0.0,0.0,0.0,0.0,0.0525841005,0.245963667,0.497227236,0.7819896209999999,1.06679966,1.313526,1.48505045,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47200000000000003
0.247159335,0.162224145,0.0,0.355557826,0.755855733,0.0,0.0950155909,0.281896567,0.333898065,0.0,0.79016342,0.296134287,1.50284053,0.281746483,0.292692661,0.0,1.01577573,0.8843676559999999,0.267485711,1.36083617,0.0766499679,0.17883023899999997,1.07099106,0.85616912,0.40768376700000003,1.50283104,0.0,0.131364481,0.0643441616,0.0,4.70819829,5.33918092,0.0,2.0924613,7.7378266,2.37434193,0.0,0.751242972,0.0,2.35274496,0.0673749626,1.57559311,0.851250085,0.708017201,0.0,1.9934391,4.33778656,0.0,2.40724398,0.0,1.99674696,2.3006545,1.46102937,1.47757815,0.0,0.180804735,0.0,0.0504365029,0.171184557,0.40058881399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.336051439,0.7316743490000001,0.48859980799999997,0.046121721100000006,0.00893870691,0.128204216,0.0,0.0,0.0357120553,0.17612566300000002,0.0,0.0,0.258772182,0.510722448,0.261446072,0.187039567,0.631886098,0.7353537640000001,0.149813911,0.0752772692,1.0073505999999999,1.26097425,0.0,0.0,2.99798155,7.27078725,7.44472893,3.12591202,0.0,0.0,2.23484543,2.63845169,1.18066455,0.209128633,0.256330872,0.171963365,0.0,0.0,0.216172152,0.136060047,0.0,0.0,0.21058375899999998,0.106217605,0.0,0.0,0.26603109399999997,0.234909731,0.0,0.0,0.161444604,0.0471108893,0.0,0.08727852720000001,0.836797903,1.47216388,1.6977626000000001,1.53681076,0.9553255620000001,0.188324863,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
2.19873749,3.02805156,4.53992579,5.95589229,6.31488811,6.37225763,6.37530837,4.57215489,4.15145562,1.81432591,1.33060361,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.727349079,1.02027784,0.748807225,0.309276765,0.0,0.0,0.26551387,0.46234392399999996,0.8194959959999999,0.641903558,1.41449419,2.06426467,2.19264801,1.49965641,2.50289911,1.82613685,1.3178595,0.322962835,1.45493719,0.0323771807,0.852145553,0.663283262,1.33388455,1.25353576,1.57280146,1.21319364,1.59522261,1.25944289,1.89654069,1.31610177,2.47864247,1.63626546,1.5753382,2.43352897,1.79226887,1.9393215,1.95750078,0.811251272,1.14659699,0.249260664,0.755179838,0.0,0.0,0.0,0.0,0.537039641,0.0,0.422045062,0.0,0.0,0.0794964101,0.0,0.244756583,0.0,0.0,0.14946130800000001,0.215244646,0.297106676,0.54367947,0.005397078829999999,0.268038013,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.300706097,0.207283487,0.660440775,0.0,0.0,0.42909069200000005,0.0,0.313350409,0.022905155,0.0,0.189500855,0.00032799540500000004,0.0,0.0,0.22837732100000002,0.0,0.0,0.0,0.0,0.11901156199999999,0.24960043199999998,0.0,0.0948247594,0.0,0.49813307,0.737349093,0.68686714,0.132524043,0.24680843600000002,0.0,0.38976078299999994,0.0,0.0973021518,1.15771153,1.35084254,0.602750249,1.29354746,1.1198368,0.144258694,0.475113409,0.0,0.0,0.0,0.123921604,0.0,0.0,0.09215557279999999,0.209159956,0.596836229,0.049641890099999995,0.0,0.0,0.152041772,0.0,0.28586833300000003,0.052266816900000006,0.550818813,0.0412641766,0.195977593,0.283882426,0.9735303890000001,1.18338677,0.049144068099999993,0.0,0.309322056,0.0,0.00245931983,0.0,0.0,0.281253885,0.557558192,0.24690024300000002,0.0,0.0,0.21486771,0.0,0.24710236,0.0,0.0,0.148978014,0.44488476,0.273212804,0.345574327,0.594293007,0.5277293820000001,0.224255195,0.190307253,0.0,0.0,0.0,0.0,0.0,0.845254207,1.1755881000000001,0.7854987940000001,0.536001096,0.346766966,0.40004602799999994,0.0,0.0,0.0,0.0,0.0,0.10884431300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45799999999999996
0.0258942894,0.243431764,0.30102329899999997,0.13774666900000002,0.0,0.0,0.0,0.0,0.273420275,0.35724259399999997,0.170331044,0.0,0.0,0.0,0.0,0.34542583600000004,0.46618795799999996,0.23246752699999998,0.0,0.0,0.0,0.0,0.524622706,0.752983648,0.406870839,0.0,0.0,0.0,0.0,1.68452128,3.58873936,4.80622251,4.81765049,3.66058566,1.88960517,0.26221958,0.0,0.0,0.0,0.180083406,0.382907428,0.256020535,0.018085503899999997,0.0,0.191064961,0.655357255,1.1126945,1.35214079,1.3139638,1.10552935,0.9058573529999999,0.8368047259999999,0.891336205,0.9595625329999999,0.922014039,0.737751762,0.46747402600000004,0.22376812,0.0917058451,0.077978968,0.11964494099999999,0.13827165,0.0956920325,0.012518176399999999,0.0,0.0,0.0,0.0179853703,0.0490912355,0.039996006,0.00590308176,0.0,0.0,0.0,0.0054294535100000004,0.0127734873,0.00773480372,0.0006584219990000001,0.000410185778,0.005247142739999999,0.00569624172,0.0,0.0,0.0,0.0,0.021447071,0.0370873398,0.0246307537,0.0,0.0,0.0,0.0,0.0426523003,0.0709419024,0.04589112,0.0,0.0,0.0,0.0,0.0670140567,0.111775575,0.07276493690000001,0.0,0.0,0.0,0.0,0.09891269130000001,0.167600545,0.111015584,0.0,0.0,0.0,0.0,0.147136732,0.255481383,0.173576586,0.0,0.0,0.0,0.0,0.235084335,0.423299405,0.298682043,0.0,0.0,0.0,0.0,0.45453989100000003,0.874062265,0.662295606,0.0,0.0,0.0,0.0,3.02040166,7.28344295,11.4312623,14.1118914,14.5100446,12.706149400000001,9.58196827,6.34135131,3.92589853,2.64534526,2.19430095,1.98977454,1.58688432,0.916422373,0.231835305,0.0,0.0,0.19639449,0.45371870700000005,0.43233533700000004,0.13604117400000001,0.0,0.0,0.0,0.07853643639999999,0.338667172,0.35185433299999996,0.118460257,0.0,0.0,0.0,0.032623740299999995,0.260723645,0.28710883600000003,0.10202181,0.0,0.0,0.0,0.0237093356,0.220825026,0.256524906,0.13051200400000001,0.0,0.0,0.114727521,0.374444775,0.546006575,0.490940744,0.22134589899999998,0.0,0.0,0.0,0.0172159421,0.23791962100000003,0.27839817899999997,0.111075204,0.0,0.0,0.0,0.012468422,0.22835425899999998,0.27302269100000004,0.11312858099999999,0.0,0.0,0.0,0.00844395882,0.231391328,0.283377146,0.12214941900000001,0.0,0.0,0.0,0.00475368926,0.270235712,0.37240861700000005,0.24793483100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.527
20.647835999999998,0.535934197,0.0,1.14641475,1.46468963,0.0,0.0,1.02757097,0.0,0.0,0.0,2.05483435,1.82296432,0.0,0.637299818,0.0,0.795438172,0.472272355,0.0,0.391265377,0.0,1.90271315,1.27829264,0.0,0.0,1.2302171,1.23949169,0.15673984400000002,0.551488483,0.0,0.9810298390000001,0.0,0.0,0.0,0.0,0.0,0.0,0.859579436,0.0,0.0,1.51545349,0.0,0.298860572,1.67337604,0.0,0.7307226840000001,1.86079766,0.0,0.45356078,1.74662187,1.66628309,0.0,1.0730206,0.076306998,1.48517962,0.0,1.51656779,0.661103814,0.0,1.95510229,0.0,0.0,0.0,0.408131339,0.0,0.0907930985,0.0,1.50702296,0.0,0.0,0.0,1.88869244,0.235125045,1.7860526,0.0,0.0,0.0420417331,0.443862185,1.05755808,0.0,0.0,0.0,0.104377976,0.0,1.20057427,0.0,0.0,0.0566509343,0.0133749145,1.83266665,0.0,0.0,0.0,1.75725548,0.0,0.0,1.80580906,0.0,0.0,0.455696363,0.0,0.0,0.0,1.80545555,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
1.53346318,0.0,0.489253985,0.0,0.0,0.0343924043,0.413067925,0.0,1.39742902,2.3578471000000003,1.25437383,5.07016784,5.32366045,3.58143209,3.15523157,1.49759436,0.0,0.0,0.0,0.0,0.0,0.62662579,1.24364494,1.67413597,1.41369136,0.0,0.0,0.0,1.63804425,0.0,0.0,0.0,2.01314415,0.0,0.303282502,0.144872577,0.0,0.281641431,0.0,1.9279036,0.0,0.5109364129999999,0.0,0.0,0.0,0.17645507100000002,0.0,1.51881348,3.77491635,0.0,0.0,1.36495747,0.576912512,0.0563026368,0.0,0.144367894,0.0,2.02554365,0.0,0.0,0.0,0.0,0.0,1.58398137,2.40050057,0.0,0.887628834,2.07823775,2.69445693,2.29048277,1.25770775,1.4955744,0.569744974,1.61189765,0.177808582,0.872558051,0.693302176,0.707221019,0.0,0.0,0.0,0.0303630523,1.96049918,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0694077397,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
1.68175759,0.0298880601,1.77908471,1.32811173,0.0,1.02408674,0.0,0.6796054109999999,0.265905945,0.8913976509999999,0.91257082,1.40209215,0.350636424,0.999674745,0.243936995,1.89822618,0.0,0.0,0.0,0.0,0.145669291,0.0,0.956599255,1.04152171,1.86110328,0.0,0.0,0.0,0.0,0.36284208100000004,0.0,0.0,1.22357496,1.46143333,1.48997865,0.0473289805,0.0,0.135521312,0.703672147,1.09810751,0.7980994090000001,1.22724287,0.462755057,0.0,0.0,0.0,0.451836351,1.74751038,1.69925636,3.30018427,3.61747706,3.8518123999999996,3.70896397,1.40076475,2.4214306,1.31636387,0.0,0.0,0.13316502,0.0,0.0,0.77131545,0.0,0.0,0.0,0.0,0.0,0.0,1.80643985,0.6854477440000001,2.64856273,0.0,0.8395727829999999,1.94379223,0.0,0.0,0.7253809590000001,0.0,0.652320562,0.502751709,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0805069161,0.0,0.0,0.0,0.7954294890000001,0.0,0.0,0.363512799,0.057215301600000004,0.0,0.0,0.43568396200000004,0.0,0.0,1.32075009,0.0,0.0,0.733977202,0.384696969,0.453212438,0.55014274,0.709289561,0.352692845,1.47338472,0.992251887,1.5006137,0.644580258,0.40898016,0.83146884,2.47642862,3.16446175,2.50863674,2.05396431,0.46230184399999996,0.49173599100000004,0.618119506,0.344418625,0.0,0.0,0.0,0.0,1.04770224,0.157029281,0.0,0.746747321,0.0,0.0,0.6865118259999999,0.131840182,1.41182902,0.0,0.0,0.0,0.0,0.0,0.736287375,0.0,0.0,0.0,0.0,0.757817953,0.0,0.26682135100000004,0.30317978,0.0,0.362185211,1.14971502,1.24686906,1.30667101,0.0,0.28100807,0.0,0.0,0.9272753440000001,0.6477596520000001,1.51501995,0.45667178,0.0,0.0,0.0,0.0428650279,0.061563012300000004,0.0,0.814457962,0.0,0.908184185,0.38334842700000005,0.0,0.180468623,0.0,0.0,0.0,0.945154842,0.0,1.02804769,0.6529184060000001,0.41357822,0.783236011,0.140594783,0.0,1.10998701,0.0,0.127974933,0.0,0.621874028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.14537687,0.0,0.0,0.62687782,0.0,0.29109773,0.0,0.0,0.26397919,0.0,0.61324749,0.36175534,0.15152729,0.0,0.0,0.0,0.0,0.94267752,0.0,0.54706294,0.0,0.0,0.0,0.10004785,0.0,0.0,0.37125839,0.93907322,1.09931938,1.03920349,1.44594433,1.14116259,2.72810332,3.51698644,2.36633911,3.73782471,2.8900367,3.81199727,2.78726232,3.13381624,2.86796205,4.59779693,2.04181909,1.68370661,1.28412757,1.01445055,0.40291051,0.0,0.05544278,0.0,0.37031083,0.97585267,0.0,0.2803676,0.0,0.45013681,0.0,0.31688511,0.61160242,0.0,0.36017382,0.0,0.0,0.0,0.80111126,0.0,0.02219754,0.0,0.0,0.82269436,0.0,0.26650269,0.0,0.0,0.0,0.0,0.02682584,0.51715673,0.31290421,0.16199118,0.06179034,0.0,0.37023459999999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.53611338,0.0,0.0,0.21616356,0.0,0.2826965,1.29953412,0.0,0.0,1.06429511,0.0,0.69172181,0.06700569,0.14632557,0.0,0.0,0.0,0.62627717,0.60109999,0.0,1.29883683,0.11086885,0.0,0.0975537,0.0,0.22679924,0.19061129999999998,0.08171289999999999,0.0,0.0,1.28044925,0.0,0.0,0.0,0.0,0.0,0.0,0.12426232,0.73203983,0.0,0.62973262,0.5960586999999999,0.38969049,0.0,0.0,0.08105029,0.0,0.8783789000000001,0.0,0.38814711,0.82235917,0.0,0.0,1.21278598,0.0,0.15177762,0.0,0.30694976,0.37945883,0.0,0.06247506,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.555413109,0.0,1.22829747,0.0,0.0,1.23031101,0.200620561,0.0,0.0,0.128316922,0.0,0.291667571,0.407170462,0.0,0.0,0.41851877200000004,0.7938356059999999,0.797280213,0.241544581,0.0,0.41420148799999995,0.025682196600000002,0.546320324,1.32276739,0.192494214,0.0,0.0,0.0,0.0,0.0,1.39442419,0.017448345900000002,0.432571903,0.262269967,0.0,0.183916778,0.0,1.58668862,0.0,0.0,1.6369709,2.36610019,2.18784046,1.21053823,2.6318192000000002,3.12190212,1.37618638,0.908822892,0.579302994,0.0361638505,1.93715046,0.48516890700000004,0.0,0.0,1.65657979,0.0,1.05462644,0.439009386,1.4638088,2.81354648,1.90070327,0.0,0.8442856759999999,0.428237479,1.16564967,2.72429505,2.78342701,1.10943684,0.9184221140000001,2.17359983,2.02022784,0.6818942790000001,1.05098385,0.0,1.4397148000000002,0.91826888,0.0,0.0,1.57308177,0.0,2.13090437,2.21293607,1.90437086,3.92158226,2.30118681,4.08720927,3.94345278,3.84931543,3.18630794,1.59100563,1.96253915,1.08831926,0.70621822,0.0,0.0,0.400089195,0.0,1.10236215,0.0,1.74897897,0.350481893,2.64128518,0.32479949399999997,0.48603733200000004,0.0,0.232396662,0.0,0.9287999159999999,0.0,0.0,0.0,0.590702287,0.0,0.0,0.061524864299999996,0.21281316399999997,1.7779128,0.0,0.0,0.0543314521,0.595843362,2.66834172,1.34509137,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.290332934,0.14520955300000002,0.23416311,0.316111138,0.132278381,0.0,0.38511624200000005,0.0,0.0,0.0,0.0,0.0,0.11938716699999999,0.0,0.0,0.409647121,0.0,0.0,0.0,0.343023065,0.390532004,1.98047984,0.7248401409999999,0.593650758,0.0,0.0,0.19880062399999998,2.82809321,2.11682704,0.0,0.387458749,0.0,0.0,0.0,0.496372142,0.0,1.05445744,0.0730281989,1.40878863,0.0,0.467292184,0.307492761,0.50184457,1.07714388,4.36814882,0.93854432,0.0,0.426018392,0.369028088,0.34455441700000006,0.384723007,0.216914816,0.2543406,0.463499354,0.183032673,0.405338407,0.357668869,0.17701192300000002,1.30063101,0.130230433,0.0,0.0,0.0,0.0750193615,0.191707152,1.69606193,0.34473224399999997,0.0,0.09708551,0.0,0.0,0.0,0.0,0.261585567,0.0,0.0,0.148937058,0.180879757,0.12817990699999998,0.0,1.39948468,2.2075186,3.14480385,3.19031911,2.40569624,1.0639254999999999,0.0,0.0,0.0785107638,0.045657200599999996,0.522424019,0.56183707,0.999047927,2.24796337,3.17336041,2.43471199,1.77315694,0.77956999,0.0478595949,0.208186525,0.0904306427,0.0,0.11207921400000001,0.0,0.203706092,0.0,0.164579107,0.182074806,0.20831065899999998,0.0,0.0,0.020288548,0.28688522699999996,1.65991441,0.741301234,0.0,0.260008116,0.0,0.0,0.436968374,1.30543595,0.8931189140000001,0.0,0.545152379,0.454195522,0.0,0.555354231,0.0,0.0450013083,0.22806402399999998,0.062358586900000006,0.0,1.2236292,0.77285864,0.0,0.12330010699999999,0.160258991,0.52758853,0.0,0.5308462829999999,2.09986098,0.335001227,0.46112924200000005,0.0540742926,0.0,0.0,0.0,0.0,0.0904410991,0.21119560699999998,0.00246146506,0.0,0.354568914,0.129861449,0.40081948,0.37129015299999996,0.9800029,0.0657973823,0.34968263,0.0,0.485611774,0.303918578,0.131221569,0.39704663700000004,0.348687134,0.0,0.39594801700000004,0.15998469699999998,0.0341758854,0.321740453,0.231567881,0.0,0.154704393,0.40440898200000003,0.0,0.0,0.0,0.054527737199999995,0.11077141800000001,0.0,0.165027748,0.207086098,0.699805074,0.252271767,0.520921855,0.0,0.22236991600000003,0.257475599,0.0,0.0,0.39440923899999997,0.0,0.0297529409,0.0,0.301621276,0.0,0.172100742,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.9869107559999999,0.768738665,0.59804776,0.49080025200000005,0.450183455,0.46682233100000003,0.52106675,0.586926422,0.636976435,0.64741921,0.602482631,0.497456105,0.33989385299999997,0.148809631,0.0,0.0,0.0,0.0,0.0,0.0,0.196587719,0.560894062,0.97119818,1.3889266000000002,1.7737881000000002,2.08874499,2.30448895,2.40283361,2.37860513,2.23983278,2.00627964,1.70657528,1.37438669,1.0441698,0.7470704840000001,0.507491635,0.340724889,0.251880573,0.236164531,0.280371114,0.36531203700000003,0.468799041,0.56875435,0.646038504,0.68665354,0.6830876140000001,0.6346975779999999,0.547159727,0.431138258,0.300411211,0.16974561,0.052823185,0.0,0.0,0.0,0.0,0.0,0.0,2.75485839e-17,0.0473205747,0.08311656860000001,0.10209871300000001,0.102217747,0.08470310060000001,0.053615366100000006,0.0150042519,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00855962364,0.0403584052,0.064300313,0.0764095521,0.0748215374,0.060065305199999995,0.0349394653,0.00400451597,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0150987351,0.0421770438,0.0611105771,0.06855734549999999,0.0633944581,0.0469873279,0.023006725,0.0,0.0,0.0,0.0,0.0,0.010455633399999999,0.0520693325,0.0979324283,0.140411716,0.17181045,0.18573490899999998,0.178304004,0.148979724,0.100853394,0.0403115618,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0623322209,0.114707898,0.14763253199999998,0.15478371300000002,0.13420936,0.0888035535,0.025950712200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.020202315,0.0987203958,0.162968871,0.200645348,0.203591078,0.169422105,0.102225665,0.0121650788,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0693294006,0.211426367,0.341469013,0.441130805,0.49665226100000004,0.501146191,0.45577936799999996,0.369603677,0.258037898,0.140235608,0.0357746238,0.0,0.0,0.0,0.0,0.055536546299999996,0.133992356,0.19932043600000002,0.23384603399999998,0.22552081100000002,0.170551712,0.0746031224,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18863960100000002,0.362686429,0.487677745,0.534334127,0.48442989799999997,0.335369339,0.102605074,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.532610685,1.32144641,2.20003588,3.08866807,3.90046939,4.55198688,4.97370447,5.11903539,4.97052004,4.54233307,3.87871403,3.04850706,2.13654411,1.23305089,0.422529451,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24793556600000002,0.519394521,0.6868846209999999,0.732438571,0.660405992,0.495263049,0.276510447,0.0515499885,0.0,0.0,0.0,0.0,0.11020186900000001,0.41279180600000004,0.7564193990000001,1.09750338,1.39359008,1.60969902,1.72326962,1.72699446,1.62918016,1.45167603,1.22578979,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.336972919,0.5644793889999999,0.744726373,0.802047975,0.6986248409999999,0.469485834,0.21670104199999998,0.0471556125,0.0,0.0167903212,0.0229288072,0.0,0.0,0.0,0.0272292152,0.0753430405,0.0455239056,0.0,0.0,0.0,0.0585882477,0.11628003,0.0514989935,0.0,0.0,0.0,0.110854415,0.17523066399999998,0.0510472825,0.0,0.0,0.0,0.230671779,0.312545741,0.0399212261,0.0,0.0,0.0,1.019305,2.01911271,2.35904166,1.82662008,0.789404485,0.0,0.0,0.0476575313,0.6067029820000001,0.937279073,0.941805558,0.830263897,0.838761772,0.972742177,1.01500268,0.768406447,0.280802199,0.0,0.0,0.0,0.132557819,0.23518164600000002,0.09528299119999999,0.0,0.0,0.0,0.123956974,0.183286168,0.052206914900000005,0.0,0.0,0.0,0.158276888,0.21205719399999998,0.0547458658,0.0,0.0,0.0,0.380569083,0.683567186,0.6912821,0.423067387,0.10783961,0.00374515434,0.198516503,0.547194266,0.789831664,0.7501973820000001,0.459300128,0.114513944,0.0,0.0,0.039405559900000005,0.10199502099999999,0.05400143599999999,0.0,0.0,0.069269807,0.19754216,0.21273136199999998,0.0795871281,0.0,0.0,0.0,0.0762954769,0.08818698539999999,0.00913224147,0.0729484555,0.5011935270000001,1.1926928999999997,1.65038108,1.32575513,0.180407543,0.0,0.0,0.763116665,4.09858947,7.32457872,8.61627927,7.16068142,3.76937995,0.35165471200000004,0.0,0.0,0.22935462199999998,1.09890865,0.7802621540000001,0.0,0.0,0.0,0.326944592,0.970778461,0.611253618,0.0,0.0,0.0,1.72976738,4.03607487,5.21680052,4.61048508,2.67966149,0.594791936,0.0,0.0,0.0,0.302831681,0.351537573,0.0732167286,0.0,0.0,0.0,0.164579253,0.229128998,0.158744664,0.059977998399999996,0.0404524443,0.141266657,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
3.2566992000000003,2.79393263,1.88820325,1.33638235,3.29841947,2.05617441,1.86013626,3.37410799,2.1005466,0.64237197,1.99496984,0.84307945,0.0,0.25377109,0.75827959,0.0,0.0,0.0,1.57673097,0.12613123,0.0,0.0,0.0,0.0,0.72202594,0.4302834,0.21083479,0.0,0.24592498,0.67236086,0.0,0.0,0.0,0.23070658,1.04042857,0.56422668,0.0,0.30990842,0.30178374,0.0,0.0,0.97364933,0.78565403,0.01451099,0.0,0.0,0.73487619,0.27926642,0.90529405,0.04528696,0.87793091,0.0,0.0,0.26236086,0.0,0.44928775,0.39815971,0.0,0.0,0.31867773,0.0,0.0,0.0,0.29531558,0.31738071,0.10499556,0.71398786,0.28390871,0.0,0.18982664,0.7128466999999999,0.0,0.0,0.24652381,1.58709383,0.0,0.41156185,0.0,0.54684306,0.7823036999999999,0.5407901999999999,0.30578666,1.39231379,2.13161348,1.71649994,3.80367228,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.375383288,0.0,0.379877477,0.0,0.0,0.223725604,0.0,0.0,0.0291050506,0.062417746600000004,0.0,0.352851984,0.242116232,0.0,0.289860143,0.0,0.0,0.0947155433,0.109643012,0.186686932,0.372767935,0.0,0.0,0.392571422,0.0526251409,0.0,0.0,0.0192187963,0.269832964,0.0,0.293686938,0.301037929,0.0,0.307938662,0.0,0.0,0.236411145,0.0,0.118483246,0.21580284600000002,0.410790861,0.0548109203,0.16322137,0.0,0.21575645,0.229318196,0.600842269,0.138044782,0.503571133,0.483347953,0.0,0.0,0.00397593862,0.31169723,0.21782702399999998,0.183673959,0.8731644940000001,0.440457681,0.624783228,0.454528125,0.46217497399999996,1.07536561,1.44284384,1.52473751,1.11988395,0.747311765,0.45903138,0.19263266899999998,0.0,0.0,0.051943319800000005,0.534418898,0.0,0.0,0.0,0.439604946,0.49871011200000004,1.03403648,2.57878157,3.32976121,3.93632035,4.02795489,3.59415687,2.89336237,2.09246201,1.4650196000000002,0.89260371,0.7967392040000001,0.08432689439999999,0.0,0.0676268675,0.0905529133,0.377438857,0.35297006799999997,0.0,0.31059096199999997,0.0408985473,0.005646951460000001,0.0,0.0,0.257685242,0.518210132,0.0,0.0,0.0,0.0,0.324716835,0.5752165379999999,0.46357300799999995,0.8835471159999999,1.11889827,1.009142,0.46405870000000005,0.22182706,0.199424679,0.608260637,0.511895001,0.48004819,0.208895213,0.228518382,0.10905621199999999,0.0,0.0,0.0,0.36196596600000003,0.548406458,0.170860068,0.141576833,0.391061451,0.630428268,0.74416562,0.44277186799999996,0.37678140200000004,0.983855646,0.24634327600000003,0.640637739,0.684509397,0.64755848,0.742896007,0.765300867,0.10181182300000001,0.0,0.41697826299999996,0.24800576300000002,0.0,0.21863479100000002,0.55103387,0.252641231,0.781245799,0.368432473,0.263442417,0.0568442916,0.0,0.0,0.489546026,0.36695391200000005,0.0894929907,0.374238296,0.06280679559999999,0.013730440600000001,0.196374557,0.303691715,0.38814083,0.332582059,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
2.73571291,0.154377295,0.335093445,0.0,0.47200127299999994,0.28274894,0.5020611229999999,0.21667830899999999,0.0452054387,0.115233994,0.171106189,0.0336867812,0.34775111700000005,0.0,0.307493117,0.0,0.35412644,0.0,0.43015113,0.0,0.5807291,0.0,1.46695933,1.55928355,0.042881776600000004,0.525106569,0.00434962286,0.0,0.376587425,0.0,0.36790281,0.16431605400000002,0.5687096220000001,6.05331568,0.0,0.0297292763,0.0399420126,0.0,0.09358993019999999,0.0,0.111420012,0.0,0.117315376,0.0,0.09646851039999998,0.471575115,2.89181623,2.98025303,4.55221551,6.94342157,4.25217235,1.15372258,0.127810894,0.10605331300000001,0.0,0.107869229,0.0,0.547709362,1.01204523,1.94259225,1.30921827,1.00727339,0.0,0.45104615299999995,0.700321058,0.7002404590000001,0.479597555,0.47097981,3.12533889,0.0,0.00601897944,0.0,0.0831659342,0.0,6.83813821,1.0562456,0.0,0.524326974,0.0,0.521478447,0.0,0.444419138,0.0,0.410583165,0.0,0.38230722100000003,0.0,0.353056582,0.0,0.319646224,0.0,0.278799068,0.0,0.223236656,0.0,0.118170773,0.0593375243,1.00521483,1.04426846,3.44364231,1.33222076,0.707940117,0.0,0.188709687,0.0,0.19501835399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.87844779,0.229275213,0.319588419,0.12444707099999999,0.866434349,0.885230361,0.5823406720000001,0.289426841,0.0,0.0404791737,0.0,0.0551060267,0.130265851,0.07328076480000001,0.32618037899999996,0.308510593,0.13627567699999998,1.82025783,0.19448853100000002,0.025724805899999998,0.0,0.500874402,0.13783472300000002,0.83488534,1.68923566,0.0,0.984705828,0.34565320299999996,1.03904741,0.23145155399999998,0.0,0.0710505755,0.0,0.036214299,0.0,0.143272196,0.0138157215,0.812091297,4.11678742,4.07108306,3.03844339,2.1762,0.355407066,0.455983948,0.0,0.870408428,5.94437531,4.73916075,1.07801494,0.0,0.117012255,0.0107865255,0.0469650414,0.0,0.0802711364,0.11925099,0.164546133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.332457348,0.0,0.0,0.324453378,0.650070849,0.317899944,0.0,0.0,0.0,0.287788735,0.27292435,0.0524256455,0.0,0.18577801300000002,0.486133762,0.543751329,0.27943488899999996,0.0,0.0,0.0,0.166487539,0.18968277,0.0431834924,0.0,0.0,0.0490799718,0.108806962,0.0396097139,0.0,0.0,0.0,0.0820917296,0.0724044354,0.0,0.0,0.0,0.044745372,0.0884211356,0.0277309057,0.0,0.0,0.0,0.120067239,0.116485718,0.0,0.0,0.0,0.331563779,1.16221256,1.8536646,1.92184151,1.26496862,0.344540316,0.0,0.36649422200000004,1.44498641,2.30780142,2.27405967,1.40363708,0.42870987200000005,0.0589734244,0.320727577,0.594150883,0.330725095,0.0,0.0,0.5008845820000001,2.14976843,3.38998393,3.2849421000000003,1.96666634,0.534533495,0.0550420101,0.623258408,1.37679783,1.40057855,0.597034187,0.0,0.0,0.0,0.35557519200000004,0.397981113,1.88980123e-16,0.0,0.0,0.0988695843,0.30551445,0.147484312,0.0,0.0,0.0,0.166242623,0.158549781,0.0,0.0,0.147835284,0.40101370700000005,0.407045327,0.16305404,0.00399669169,0.22061570600000002,0.67735671,0.89756073,0.567655052,0.0,0.0,0.0,0.204083493,0.45257830600000004,0.169136492,0.0,0.0,0.0,0.451058632,0.43856240700000004,0.0,0.0,0.0,0.559426952,1.76820724,2.29454358,1.82841437,0.815555969,0.0,0.0,0.00801084943,0.244374714,0.26721201699999997,0.194852512,0.262992767,0.521545786,0.7724165959999999,0.77155279,0.464679698,0.0404594377,0.0,0.0,0.291956302,0.768858388,1.01053165,0.862892468,0.47509136399999996,0.25787676800000003,0.606154964,1.55427097,2.65887567,3.26727529,2.99523125,2.01672143,0.90807957,0.18794005800000002,0.0,0.0,0.00319262235,0.0,0.0,0.028115348999999998,0.150222932,0.13654402300000001,0.0,0.0,0.0,0.14698238,0.267198838,0.199474409,0.0364133794,0.0,0.026622540299999997,0.10803163800000001,0.0631333315,0.0,0.0,0.0,0.132402319,0.15536297400000001,0.0,0.0,0.0,0.0895261048,0.282649394,0.22138835,0.0,0.0,0.0,0.187566493,0.205469357,0.0,0.0,0.0,0.148131963,0.36184388799999995,0.147568375,0.0,0.0,0.0,0.535117209,0.560193377,0.0,0.0,0.0,0.98421949,3.42328592,4.96095086,4.54189801,2.52061196,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.0417999896,0.0,0.495693812,0.339655224,0.0,0.301880973,0.306865564,0.0,0.439245227,2.82105554,2.20386637,0.08214933469999999,0.0,0.165928718,0.15588485300000002,0.41279781299999996,0.571085791,0.09950908359999999,0.0,0.042731908,0.040662090299999995,0.0,0.00563464274,0.0111663663,0.0,0.000417603785,0.0,0.0197831631,0.0109671659,0.0,0.0295912476,0.0352993926,0.0,0.0278636788,0.0795766389,0.0,0.0081363356,0.17518345800000001,0.0,0.0,1.16300394,1.34049822,0.22116566899999998,0.0,0.060488653200000006,0.059828396,0.0,0.00146594611,0.0,0.0551493576,0.0112390427,0.0,0.174291239,0.134341798,0.0,0.623105344,3.59007998,3.3409273999999995,0.206753584,0.0,0.65327,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41700000000000004
2.50765647,2.93264039,0.840516432,0.8207973559999999,1.33706668,0.0,0.624818458,2.11320493,0.0,0.0,0.221209507,1.0342619,0.654188257,0.0,1.11757849,0.0,1.03761511,2.20378168,1.90502161,0.0148626024,2.03667027,0.524768965,0.379089334,0.5878297229999999,0.0,0.0,0.0,0.620898065,0.0,0.0,3.59084181,0.578090439,0.0,1.39972318,2.00088245,4.97188248,0.575104124,1.46172207,1.52842608,0.509190448,0.0,0.0,0.0,0.0,2.31320212,1.98923571,2.71345113,1.09769825,0.0,0.515139731,0.0,0.0,0.0,0.679567774,1.1339454,0.0,2.92399499,0.0,0.0,0.045630121600000004,0.0,0.0,1.83921763,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.7409395559999999,0.0,0.0,0.0209309484,0.39855973899999997,0.0,0.7414805309999999,0.0,0.0,0.0,0.8434723959999999,0.0,0.0,0.0,1.15862318,0.0,0.0,0.0,0.0,1.14967452,0.0,0.5344855279999999,0.541607844,1.59306698,2.39620927,0.628728899,0.21717341899999998,0.0,0.0,0.0,0.0,0.0625007582,0.667684933,1.52939705,3.42214613,3.79667075,2.84720058,0.823306568,0.0,0.0,0.11486437199999999,0.324438522,0.577736557,0.240920207,0.49673006700000005,0.0,0.784573994,0.48229649799999996,0.696568269,0.234127143,0.0,0.63706742,0.357484939,1.1235620000000002,0.0,0.0,1.26750121,0.0,0.929577248,1.03819298,1.30516183,0.0,0.0,0.0,0.0,0.0,0.0,0.291026078,0.0,0.836875115,0.0,0.0,1.06050762,1.15108501,0.0,0.0,0.0,0.0,0.286255573,0.6839443270000001,0.785436543,0.795253318,0.942419792,1.50313368,1.06582358,0.24432360600000003,0.250826106,0.35388107399999996,1.56102019,0.251545471,0.083748488,1.13586965,1.09310436,0.0,0.596235277,0.0,0.697328418,0.0,0.104276989,0.680753365,0.495440462,0.810903513,0.0,0.0,1.04036648,0.289955966,0.0,0.0,0.0,0.0,0.0,0.739391238,0.0,0.933952193,0.0,0.0,0.451214224,0.46332207700000005,0.501249698,0.556364914,0.754483261,1.73603877,0.72509625,0.820109361,0.80482868,0.7674317540000001,0.470135511,0.0,0.21200728100000002,0.27763792800000003,0.944940045,0.011286839299999999,0.0,0.300754594,0.0,0.0,0.0418176139,0.92598386,0.226229125,0.0,0.0171549178,0.0,0.0,0.0,0.061119185300000003,0.52780648,0.0,0.0,0.5989679720000001,0.492206153,1.79928604,1.91943475,0.827295454,0.8907927520000001,0.454049341,0.0,0.0,0.0,0.0,0.0,0.0429119813,0.0,0.0,0.0,0.0,0.0,0.14880464300000001,0.086352029,0.0,0.651690391,1.22187968,0.19014704899999998,1.55850484,0.0,0.7720453490000001,0.0,0.0,0.0,0.0,0.768401516,0.0,1.54728831,1.21530938,0.36285246299999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
3.61061832,0.0,0.0,0.0,0.0,1.48054519,0.023910884900000002,1.4386605,0.012724490900000001,0.0,0.0,0.0,0.0,0.0,2.06180286,1.3972532,0.0,0.0,11.304594300000002,0.0,1.43766375,3.66992368,0.0,0.204397317,0.0,1.90062001,3.30938824,0.0,0.0,4.04815276,0.0,0.213810935,3.24156169,1.97426067,0.0,0.844277776,0.0,1.28111374,0.7072229859999999,0.0,4.40959663,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.987309275,1.53092079,0.311143709,0.00576628726,0.147789535,0.0,0.167622558,0.0,0.0,0.21213792199999998,0.0,0.0210718898,0.129954392,0.0,0.167740687,0.0,0.0,0.240088813,0.0,0.0514638983,0.21501635,0.0,0.842593603,2.02109775,0.40332655100000003,0.0,0.204891214,0.0,0.0,0.523216231,0.37058268,0.0,0.0,0.045833756600000004,0.0,0.0155398275,0.0275687604,0.0,0.0807616192,0.0,0.0,0.178321838,0.0,0.132718989,0.220385584,0.0,2.33883236,6.01865062,2.32385373,0.0,0.6372591999999999,0.172193355,0.7666197240000001,0.88665843,0.0,0.44579906,0.218999195,0.0,0.687695165,0.0,0.0,0.7197604320000001,0.0,0.5209079870000001,0.274611972,0.0,2.30422952,1.51222211,0.0,1.27167076,0.0,4.00960721,14.8363904,5.44444897,0.0,1.27055289,0.21281213100000002,0.0,1.03458917,0.0,0.0,0.526722429,0.0,0.360841195,0.0340819563,0.0,0.426492276,0.0,0.0,0.24919855600000002,0.0,0.241033933,0.42046851399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47100000000000003
0.34745013,0.470282249,0.358128016,0.0868625326,0.0,0.0,0.0868625326,0.243365697,0.20536955699999998,6.17195416e-16,0.0,0.0,6.17195416e-16,0.198408883,0.233866465,0.0868625326,0.0,0.0,3.08597708e-16,0.157352771,0.16704427300000002,1.02865903e-16,0.0,0.0,8.22927221e-16,0.243372707,0.307364287,0.173725065,0.133476638,0.61310763,1.82411318,3.51215406,5.03269498,5.73292715,5.371226,4.26221542,3.04018864,2.2245733,1.91461247,1.82411318,1.59176356,1.09524694,0.5211751960000001,0.164245113,0.153731666,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
1.13305444,2.34106883,1.56837909,2.98155153,1.74216927,0.65357679,0.0,3.03859467,0.0,0.0,0.0147324391,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.8564917,1.60234191,0.0,0.0,0.6989870509999999,0.32875023600000003,0.196037712,0.0,0.0,0.036022169,0.168136642,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.91221478,0.0,0.41452465899999996,0.0,0.0,0.0,0.0,0.0,0.83449464,0.684399602,0.0,0.6443087270000001,1.32055005,2.06005803,0.20315038800000002,0.927772067,2.01293484,0.16948279100000002,0.0,1.70059383,0.0,0.0,0.0,0.863477927,0.0,0.0,0.0,0.0,0.0207136527,0.172236505,0.842628915,0.00335496735,0.6871019859999999,2.50867782,1.94996714,2.75486332,0.0,2.03080408,0.733177741,1.77190294,1.51942814,0.0,0.0,0.37810752799999997,0.649823406,1.5908027,0.0,1.90845021,0.0,0.0,1.02167398,1.72676975,1.05769321,3.55135172,2.04813779,2.84683942,5.84164719,5.24136572,5.66227233,5.00484606,3.2150124,1.76301974,2.73055006,1.62558315,1.53312944,0.563024388,2.31536381,0.0,0.0,0.0,0.9839430459999999,0.0,0.573310289,0.0,1.24624163,0.227007132,0.0,0.892151879,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
1.39814137,0.631106539,0.80216559,0.787944943,1.22047455,2.64730655,3.0952558999999997,3.7909962,4.56187401,5.66942227,5.65082825,5.33624156,6.16086926,5.10792674,4.33622255,2.91311559,1.38747206,1.39652881,0.0,0.0,0.0,0.0,0.0,0.0,0.9546884809999999,0.724933222,1.31029467,1.30849947,1.42649325,1.37925705,0.9341625509999999,0.504350801,0.184715061,0.567839871,0.276441011,0.026513936499999998,0.044285253200000006,0.349424976,0.0,0.0,0.0,0.506368083,0.5134121429999999,0.309828748,0.0,0.0617029488,0.0,0.0,0.0,0.0,0.43599103,0.0,0.0,0.0,0.0,0.0,0.308073681,0.0,0.0,0.390277793,0.0,0.0806167859,0.0,0.0,0.167630952,0.44852397299999996,0.181331883,0.0,0.129836276,0.11885335699999999,0.011515818200000002,0.0303520682,0.00673063479,0.0191487425,0.0,0.122488809,0.206980232,0.176596967,0.0,0.0,0.44900754200000004,0.0,0.068228094,0.0,0.0,0.235795158,0.0,0.0,0.0,0.0461169751,0.0163665097,0.0,0.0,0.0,0.0,0.24273197600000002,0.0,0.0,0.0,0.0,0.206236048,0.0,0.0,0.0,0.45719911799999996,0.0,0.0,0.0,0.0,0.37254685200000004,0.0,1.05263835,0.8608030590000001,1.9894843,1.49867345,2.12521237,1.95294855,2.38877038,2.19253013,2.17318635,1.97694906,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.18432885899999998,0.19250293,0.19290364,0.17687314699999998,0.143143585,0.0987132564,0.0568067591,0.0326359337,0.038378273399999996,0.0790111463,0.150328249,0.23973751899999998,0.329545404,0.401664189,0.44227853,0.445087689,0.412254071,0.352950143,0.280146253,0.20677786399999998,0.142524613,0.0921180047,0.055499432300000005,0.0294935872,0.0101726652,0.0,0.0,0.0,0.0,0.0,0.00392923755,0.0207305671,0.0322239829,0.0327563373,0.0201243393,0.0,0.0,0.0,0.0,0.0138235253,0.09231131140000001,0.199544865,0.321631524,0.440758384,0.540553786,0.611776636,0.65669546,0.6907807140000001,0.741004161,0.840930545,1.02364591,1.31415178,1.72300528,2.24267126,2.8473738999999996,3.49639153,4.13996205,4.7264565,5.20934243,5.55269213,5.73448532,5.74754407,5.59844825,5.30508961,4.89358801,4.39515357,3.84322973,3.27100969,2.70927011,2.18444943,1.71698856,1.32008186,0.9990749590000001,0.7517331079999999,0.56947264,0.43943456799999997,0.34705456100000004,0.278629538,0.223358716,0.174463007,0.129227733,0.0880965617,0.0531823348,0.026681231,0.00964820323,0.0014304591199999998,0.0,0.00176083872,0.0042782216799999995,0.0052970080200000005,0.00406309244,0.00107979851,0.0,0.0,0.0,0.0,0.0,0.00163296082,0.0037324202299999997,0.004292489470000001,0.00328462135,0.00126363458,0.0,0.0,0.0,0.0,0.0,0.000361919862,0.0011617624099999999,0.00128366112,0.0008771460679999999,0.000312445942,0.0,1.70718899e-05,0.000362929523,0.000677268613,0.0005995989469999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0021196055800000004,0.00408730816,0.00479312849,0.0036474096999999997,0.000745773462,0.0,0.0,0.0,0.0,0.0,0.0038703793,0.008959488659999999,0.011295536100000001,0.00950579352,0.00365492786,0.0,0.0,0.0,0.0,0.0,0.00504081992,0.0166054456,0.023447263700000002,0.0220918694,0.0117115104,0.0,0.0,0.0,0.0,0.0,0.0043495036299999994,0.0331204214,0.054773336299999996,0.0589982791,0.0398085691,0.0,0.0,0.0,0.0,0.0,0.0,0.123302366,0.294247741,0.47290820899999997,0.625470085,0.720755667,0.7382389570000001,0.673735383,0.541054282,0.36897197200000004,0.19419016600000003,0.052109288600000005,0.0,0.0,0.0,0.0644793414,0.140874737,0.190269064,0.19331649199999998,0.14612539900000002,0.0609701166,0.0,0.0,0.0,0.0,0.0,0.0306938421,0.156055149,0.269994313,0.35025169700000003,0.38511812799999995,0.375629713,0.33388883199999997,0.278270483,0.227186895,0.193438,0.180881282,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.588217261,0.30519998,0.0,0.49214427299999997,0.0384188636,0.0,0.0,0.7063643079999999,0.155825474,0.0,0.356615945,0.0013381797,1.28440292,0.0,1.13783887,1.2147444,0.0,0.0,0.0,0.0686509733,1.75004254,0.434641404,0.47208214600000004,1.28576035,0.736926815,0.0,0.0,1.84880214,0.610927268,1.66617853,0.105640598,0.244099762,0.0,0.0,0.0,0.804731465,0.0,0.0,1.32385334,0.163482654,0.0,0.0,0.9755046,1.3575701,0.202104786,2.05435939,1.13338276,0.10401655900000001,1.03177478,0.0,0.0,0.0,0.322284802,0.0,0.0,0.0,0.0486789971,0.49216504899999997,0.38780807100000003,0.0,0.215158735,2.37132918,1.20489482,0.9993245740000001,0.0,1.65150678,0.0,0.0,0.63444005,0.0,0.0,0.0,0.0,0.7008082859999999,0.6066314389999999,0.0,0.0,0.90860632,0.942662123,0.370636824,0.0,0.0,0.0,0.0,0.146870262,0.0,0.385089071,0.83806382,0.0,0.0,0.0,0.0,1.10416003,0.216506312,0.0,0.0,0.0148102631,0.0,0.7121143040000001,0.0,0.0,0.893781866,0.0,0.885026345,1.39536388,0.0,1.80320784,0.39946499799999996,0.65157903,0.6433807429999999,0.34897369799999994,0.0,0.0,0.0,0.0,0.0,0.217206005,0.0,0.8147320779999999,0.0,1.22006123,0.0,0.8436617759999999,0.0439124144,0.183976626,0.38771016799999997,2.25692789,0.0,0.0,0.0,0.571854359,0.0,1.16548512,2.10651836,0.9721178859999999,1.51107555,0.40121356,3.39967778,6.05547369,4.0343292,5.55247815,5.23887471,4.90871003,4.83949317,6.21785956,5.99288935,4.90467615,2.84860499,2.48656716,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.42113786799999997,0.8118426009999999,0.91494003,0.678993698,0.291123868,0.0143680512,0.0,0.0920038747,0.1605043,0.0686846208,0.0,0.0,0.0,0.102989586,0.22495932300000002,0.137486139,0.0,0.0,0.0,0.29436594,0.588611899,0.614298581,0.395507371,0.19255678699999998,0.266645599,0.618555791,0.9525515370000001,0.930026508,0.507004425,0.0396832696,0.0157317179,0.601720229,1.40356506,1.71068369,1.10192608,0.0,0.0,0.312265893,3.16595621,6.86044018,9.59949356,9.88611207,7.49556227,3.65982905,0.318369925,0.0,0.0,1.60002968,3.15273212,3.46462057,2.60594358,1.34227342,0.453043168,0.202972476,0.312786956,0.343600987,0.110044186,0.0,0.0,0.0,0.172080345,0.32325238300000003,0.174947075,0.0,0.0,0.0,0.08644154529999999,0.287363794,0.222073766,0.0,0.0,0.0,0.0104381864,0.303429214,0.39444471700000006,0.234521581,0.0,0.0,0.0,0.14197291,0.21304895100000001,0.0804560403,0.0,0.0,0.0,0.503297648,1.12934983,1.6644096000000002,1.9987667000000002,2.12623196,2.06690601,1.80727367,1.33188766,0.7132066509999999,0.149847136,0.0,0.011174494299999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48200000000000004
0.38286156200000004,0.992887992,1.08725233,0.64768794,0.43052068,1.90281883,2.67871081,2.45839995,2.88353349,3.84858955,5.06485764,4.58209678,3.54338765,4.18779664,1.28480298,0.775621863,2.47525839,0.0,0.0186595285,0.09499483689999999,0.0,0.0,0.0,0.624326942,0.0,0.953222725,0.8653352009999999,0.752471215,1.11247054,1.2709081,0.0,0.0,0.0,0.46434632,0.0,0.0,0.0,0.78238576,1.30154681,0.0,0.0,0.46470117,0.0,0.275337901,1.25447969,0.0,0.716196363,2.0753037,0.427357369,1.69831064,1.07638803,0.0,0.170391622,0.287624532,0.63693881,0.0,0.0,0.0,0.0,0.0151256352,0.0,0.0,0.3478983,0.148032766,0.612687964,0.648675728,0.0,0.0,0.501529531,0.395603556,0.047840506799999995,0.071501674,0.0,0.0,0.28197258399999997,0.121611289,0.0,0.0,0.0,0.0,0.0,0.0,0.807006785,0.948347211,0.0,0.16263714199999998,0.0,0.0,0.0,0.434410029,0.617450408,0.0,1.4269052,0.0,0.35784796399999996,0.0,0.0,0.0,0.629521589,0.0,0.260513279,0.0,0.0,2.23135659,0.0,0.0,0.0,0.594011182,0.0,0.0,0.0,1.34504699,1.73746825,0.0,0.0,0.0,0.7035704220000001,0.501421191,0.0,0.0,0.0326717576,0.0,0.0,0.803621519,0.426374005,0.0,0.665730775,0.901066748,0.16902451300000002,0.0237262019,0.5186840629999999,0.14924147,0.0,0.793312701,0.0238752011,0.50114565,0.0,0.860144536,0.693321101,0.427262727,0.0482761623,0.485722325,0.214163713,0.0542176803,1.02954581,0.7329356220000001,1.08291779,0.659156585,0.34722234399999996,0.0,0.67959524,0.056559457,0.0,0.0,1.1938893999999998,0.0,0.0,0.0,0.334400186,0.114466523,0.8692167820000001,0.030830043999999997,0.934254605,0.0,1.25249958,0.16577782,0.83264044,0.357182099,0.659429881,1.36577979,0.636019144,0.0,1.56205392,0.0,1.00032498,0.206290337,0.0505909772,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.0182894414,0.0339128505,0.057332467000000005,0.0858531101,0.115882821,0.14344105099999999,0.164746273,0.176795466,0.17784624899999998,0.16772457,0.147905261,0.12134604800000001,0.0920928801,0.06471005070000001,0.043616985700000006,0.0324302521,0.033411275899999995,0.0471068225,0.0722420352,0.105888557,0.143888375,0.181473865,0.213992238,0.237623525,0.249978665,0.250479224,0.24045111800000002,0.22290726800000002,0.202042392,0.182509915,0.168589104,0.163373832,0.168118551,0.18186068600000002,0.20140309899999997,0.22168998399999998,0.23655114,0.239731375,0.226072203,0.192679839,0.139902245,0.0719515167,0.0,0.0,0.0,0.0,0.0,0.0,0.16087142599999998,0.40377666100000004,0.717199679,1.09053806,1.50678255,1.94369487,2.37559581,2.77558316,3.1179437,3.38049743,3.54661663,3.60669922,3.55893905,3.40931824,3.17083707,2.86208531,2.50533214,2.12436249,1.74230916,1.37971959,1.05305726,0.77377438,0.548015061,0.376926644,0.257481682,0.18365496399999998,0.14776529800000002,0.141784773,0.158438661,0.191963147,0.238448561,0.295763517,0.363120345,0.440395071,0.527348501,0.622904397,0.7246253909999999,0.828490123,0.9290220370000001,1.01975978,1.09400053,1.14569974,1.17038146,1.16590671,1.13296467,1.07519078,0.998870481,0.91225031,0.824539263,0.744733594,0.68043021,0.63680179,0.615889413,0.6163275189999999,0.633557016,0.660513371,0.688707297,0.7095562059999999,0.7157835570000001,0.702687029,0.669087832,0.617811569,0.555611163,0.49251656299999996,0.440674292,0.41281178799999996,0.420516809,0.472553265,0.573436982,0.722467333,0.9133567490000001,1.13452656,1.37005402,1.60117261,1.80815656,1.97237071,2.07824396,2.11493292,2.07747949,1.96732819,1.79214694,1.56497966,1.30283868,1.02491004,0.7505868440000001,0.497560888,0.280188033,0.10830267800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0259467752,0.06854166190000001,0.0978365079,0.11045972800000001,0.10613152199999999,0.0872466579,0.058153879400000004,0.024257644100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.007396100059999999,0.0229293298,0.0328073083,0.036234213700000004,0.0335646629,0.0261150811,0.0158325717,0.0048881535,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000227349123,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00994432323,0.0265688318,0.0457298188,0.0652423505,0.0826285606,0.095515061,0.10203930300000001,0.10119647400000001,0.09306568289999999,0.0788717116,0.0608639066,0.0420229158,0.0256343952,0.0147918531,0.0119046609,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
1.0549271,1.15791862,0.237975154,0.0,0.44490788600000003,0.7483438259999999,0.0,0.885831588,0.0,0.481160431,0.08905318460000002,0.0,0.0,0.37107517700000003,0.296541122,0.814684043,0.0,0.962818125,1.92817278,0.201243375,1.49054527,0.18641224399999998,0.876731533,0.022779109199999998,0.421059578,0.0,0.100209404,0.0,0.21145887600000002,0.813887802,0.0,0.0,0.0,0.0,0.36735349100000003,0.0027649688899999995,0.0,0.0,0.6753791090000001,0.0,0.0,0.0,0.687118107,0.459758293,0.0,1.02116995,1.78885112,0.608663624,1.40203167,1.480027,0.135333712,0.15637612,0.0,0.0,0.0,0.0,0.34221849200000004,0.0,0.903996294,0.646588064,0.0,0.0,0.487864126,0.0908500392,0.636071552,0.675646926,1.0643915000000002,0.0,0.007203318309999999,1.06496185,0.493984453,0.0,1.95999783,1.3041923,0.0,0.0,0.0,0.293347173,1.12183527,0.0,0.5545683579999999,0.0670109381,0.31382877,1.24082491,1.72187729,0.737917335,0.0,0.320083751,1.55371162,0.0,0.6458623029999999,0.688551483,2.33428662,0.0,0.0,4.11949218,3.32827207,1.21543088,0.290458898,0.0,1.67611283,0.0,2.69581327,1.01461374,1.15584882,3.22801156,1.63496544,1.55568496,1.82420125,3.02957055,4.76479339,4.41287555,2.49233304,2.40764532,4.99666995,4.13180102,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.294672723,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.795980815,0.0,0.6947555240000001,1.10741675,0.00332119534,0.41741717899999997,0.0151318824,0.218454304,0.0,0.0,0.661172717,0.0,0.006656041559999999,0.0,2.16426773,0.367924629,0.8516383679999999,0.18402342100000002,0.0,0.40460631700000005,1.03341382,0.0,0.266233206,0.0,0.0,0.310823904,0.0,0.8787743990000001,1.21448262,1.81638702,1.18719096,1.79801706,1.42920283,1.7827633000000003,2.42203241,1.17247438,1.96338085,1.14501104,0.36115437,0.0,0.0,0.864351377,0.0,0.0,0.29729476899999996,1.15032841,0.0503989369,0.35516235700000004,0.0,0.0,0.0,0.34322985200000006,0.0700315338,0.0,1.12193074,1.71566938,3.12927326,2.63786441,2.27636426,1.9500439999999999,2.31412844,1.65269557,0.0,0.673793093,1.01005309,0.24814730399999999,0.9565399729999999,0.587111156,2.1520537,1.25883285,0.24865581399999998,0.412047679,0.539570656,1.69584423,1.42206277,1.54148903,0.26747940000000003,0.362731345,0.923434158,0.278270174,2.04041324,0.7551865520000001,0.0,1.16320792,0.479716311,0.758692598,0.642355045,1.34222658,0.513651939,0.0,0.110836965,0.0608579322,0.0,0.713661688,1.02900169,0.0,0.0,0.0,0.0,0.07102842990000001,0.0,0.0,0.0,0.126663204,0.0,0.393929343,0.0,0.0,0.0,0.0,0.9853313370000001,0.0846593555,0.0,0.0,0.928244007,0.0,0.0,1.10933696,0.341092867,0.651243178,0.0,0.0,0.132602059,0.475234592,0.0,0.0,0.684218455,0.5553825020000001,0.604630561,0.0,1.88385607,0.325312397,1.01561344,0.0,0.35362051,0.0,0.0,0.0,0.0,0.0,0.0,0.35049889100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.645931238,0.557051947,0.0,0.0,0.645476625,0.0,0.634874057,0.0,0.0,0.0,0.450373065,0.0,0.467501913,0.10564944,0.661007829,0.506930123,0.7092789629999999,0.0,0.0,0.428060385,0.35416468700000003,0.0,0.605175389,0.0,0.61592195,0.0,0.0,0.711905569,0.0,0.0,0.0,0.0,0.40924279999999996,0.804187623,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.57327555,0.0,1.51040642,0.0,0.0,0.0,0.0,0.0,0.532864116,0.510315823,0.0,0.5478040679999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.594602382,0.491119015,0.0,0.348687256,0.1190294,0.0,0.0,0.6049160720000001,0.0,0.6154759329999999,1.50024817,0.0,0.381200551,0.0,0.0,0.0,0.0,1.39153504,0.625345884,2.91120783,0.0,0.0,0.0,1.32308799,0.0,0.0,0.06598301570000001,3.65005477,2.39236525,3.80410681,4.81569579,5.09189781,4.09850919,3.61502365,2.95285278,2.64248439,0.910947218,0.9277467359999999,2.42412687,0.622093068,0.0,0.394979353,1.68016636,1.78270639,0.0,0.266045577,0.116627522,0.0755572207,0.0,0.6761912729999999,1.45727262,0.0,0.37261617,1.96753356,1.20232148,2.47157257,1.99195013,2.21862739,2.18461097,1.97027733,1.60829504,1.23385322,1.96691434,0.09717999050000001,0.576233907,1.70680828,1.52031853,0.0,0.006430651850000001,0.0,0.0,0.0,1.8129455,1.176476,0.0,0.346224615,0.49197975200000005,0.322721297,0.0,0.0,0.0,0.0,0.5221216710000001,0.0,0.0,0.0,0.0,0.0,0.0,2.73874129,0.45975882,0.0,0.0,0.0,0.0,0.0,0.032982327799999996,0.0,0.586546776,0.0,0.0,1.70636028,0.294444666,0.0,1.05281049,1.08931055,0.0,0.692899286,0.0,0.629588002,0.0,0.0,0.0,0.0,0.166586278,1.45518897,0.918230289,0.55526245,0.0,0.0,0.0,0.0675571007,0.0,2.18309497,2.27218972,1.43648715,0.459936433,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.0285787902,0.0,0.0,0.0,0.0,0.0533265969,0.08961956539999999,0.0766104001,0.023408678999999998,0.0,0.0,0.0,0.0,0.0246049957,0.0621704606,0.0646191818,0.0333923967,0.0,0.0,0.0,0.0,0.0044242966,0.0454780531,0.0658127849,0.0526975265,0.00513598222,0.0,0.0,0.0,0.0,0.20623058800000002,0.666188671,1.33132831,2.14104287,2.96957991,3.64638033,4.00025806,3.91530201,3.37802124,2.49491769,1.46895693,0.539327522,0.0,0.0,0.0,0.0814059338,0.41183217200000005,0.596183855,0.561075526,0.339955735,0.0457021229,0.0,0.0,0.0,0.00847317391,0.195285992,0.28587741,0.24186518699999998,0.09365671560000001,0.0,0.0,0.0,0.0,0.0415989169,0.150831256,0.17441057100000001,0.105667201,0.0,0.0,0.0,0.0,0.0,0.09591556359999999,0.144852888,0.11554444,0.0259678116,0.0,0.0,0.0,0.0,0.0559122279,0.122879265,0.123133865,0.057448858600000006,0.0,0.0,0.0,0.0,0.11001860599999999,0.250667831,0.342102202,0.353818594,0.289935298,0.184190025,0.08157651860000001,0.0166190609,0.0,0.0142838956,0.0340475642,0.0351881116,0.011472776799999999,0.0,0.0,0.0,0.0,0.0211683735,0.053609856500000004,0.057494688099999997,0.030031712400000004,0.0,0.0,0.0,0.0,0.00602321547,0.0458487779,0.0607298446,0.0428553388,0.00221751016,0.0,0.0,0.0,0.0,0.0311008409,0.054331638,0.0479093445,0.0163124275,0.0,0.0,0.0,0.0,0.0138211435,0.0376620633,0.039232797,0.020315685400000002,0.0,0.0,0.0,0.0,0.000269130179,0.0,0.0,0.0,0.0,0.0755906612,0.21987193300000002,0.396646014,0.5516552060000001,0.626002231,0.582579603,0.425729187,0.203620412,0.0,0.0,0.0,0.0,0.0414039295,0.140189425,0.161361966,0.0962977339,0.0,0.0,0.0,0.0,0.0872589595,0.255595382,0.375187831,0.40397340600000003,0.34279419299999997,0.23278817699999999,0.133126703,0.0908120188,0.11797591800000001,0.18793956899999997,0.251451482,0.26413809,0.21062138,0.11278518,0.0181475473,0.0,0.0058028686,0.0976254328,0.20655742100000002,0.281388192,0.289078652,0.23041160300000002,0.137654997,0.0559971267,0.0190870298,0.031941720800000004,0.0702482783,0.09602472179999999,0.0806344283,0.0221474348,0.0,0.0,0.0,0.0,0.046038875199999996,0.112619645,0.12065817300000001,0.0620657393,0.0,0.0,0.0,0.0,0.0186345154,0.11985095800000001,0.160698844,0.114785985,0.00210939579,0.0,0.0,0.0,0.0,0.115225127,0.205852095,0.18837226,0.0637795557,0.0,0.0,0.0,0.0,0.09359254859999999,0.26658408100000003,0.30659015,0.176047657,0.0,0.0,0.0,0.0,0.28380679,0.789683864,1.15054592,1.17883299,0.8178290420000001,0.193403535,0.0,0.0,0.0,0.881004892,2.56407057,4.438171400000001,6.04609587,6.991175200000001,7.06424964,6.30102576,4.95228696,3.38411684,1.95090722,0.8903806879999999,0.275932019,0.034879117599999995,0.0141686884,0.059151426900000005,0.0716793727,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46299999999999997
0.333514421,0.509078946,0.0,0.13355272699999998,0.33837092399999996,0.293793266,0.152343154,0.686722396,1.16762488,0.0,0.937573668,0.567743997,0.0,0.0,0.296306264,0.0,0.0,0.732846538,0.0957531563,0.0390584051,0.568281816,0.956891733,1.28349263,1.10120164,1.66131061,0.587654122,1.26108517,0.489921171,0.949152478,0.0,0.174906932,0.389430668,0.244009561,0.40782623100000004,0.0,0.2586396,1.01965108,0.13106831300000002,0.34658530200000004,0.0,0.6368646920000001,0.0,0.0,0.127222523,0.0,0.0,0.0,0.0,0.22271580300000002,0.462771695,0.0,0.0647752178,0.0,0.0,0.0,0.05410452650000001,0.0,0.0,1.05398985,1.20353555,1.0821426,0.665367886,0.0,1.03498386,0.106204711,0.389951765,0.0,0.0,0.0,0.0,0.18240663199999999,1.13128106,0.878091372,1.46291451,0.912323795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.07836112,3.46724495,5.29101662,6.44648823,6.94061547,6.6292103000000004,6.64832618,5.52881185,4.69983872,3.04559033,0.451285636,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.308307065,1.24021859,0.426551333,0.0,0.0,0.31264648899999997,0.160184271,0.0,0.0,0.0,0.454549811,0.0,0.00730293823,0.382506246,0.0,0.06609869110000001,0.427880718,0.38128286,0.0,0.0,0.0849040501,0.0,0.0856737177,0.5634241489999999,0.240455535,0.0,0.0,0.0,0.0,0.0,0.59176723,0.0,0.0,0.24109523300000002,0.0,0.49243853299999996,0.519707546,0.0,0.0,0.0,0.713282163,0.941572252,0.0,0.228949238,0.580528131,1.72720102,1.02988139,0.703657988,1.25737322,0.468704853,1.11117862,0.360342014,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.356346282,0.303961209,0.539641457,0.9310330790000001,0.7749547109999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46399999999999997
0.310836336,0.0996037298,0.0,0.0173106148,0.0,0.0,0.0,0.127543234,0.0,0.450576466,0.881413124,1.00971448,2.08578447,2.11160984,2.45528404,2.97375006,3.04197546,3.9048601,3.58410738,4.11986254,3.94399495,4.19980905,3.5262941,3.64713008,3.00761787,3.03911324,2.05109775,1.76614455,1.13627373,0.706918571,0.548429309,0.042006225,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.310991975,0.539071531,0.117853221,0.124231169,0.42971322700000003,0.146278529,0.220960768,0.18056500600000003,0.317774629,0.0,0.013520197900000001,0.312623969,0.0,0.0,0.0,0.0,0.168947139,0.265983185,0.00242241637,0.267045591,0.40825827600000003,0.924918515,0.651766874,1.03629184,1.25301422,1.15226386,1.15840142,1.18424857,1.65658721,1.72334074,1.40550487,1.5651629999999999,0.670624811,0.8448164709999999,1.16957072,0.87330793,0.224937257,0.32099383800000003,0.650184057,0.20726396100000002,0.0,0.347586509,0.0,0.0,0.0,0.0,0.120022781,0.0,0.0,0.0,0.35457398,0.22098425300000002,0.160832594,0.29454648699999997,0.0,0.0,0.0,0.0,0.05041339190000001,0.0,0.0,0.0311212725,0.0,0.0,0.0,0.334511575,0.0,0.0,0.0,0.172728153,0.160716459,0.107325766,0.0,0.0,0.196107933,0.0,0.176051475,0.0,0.0,0.275878136,0.113917116,0.386274768,0.0,0.431065895,0.0,0.0,0.0,0.289481062,0.142562242,0.0,0.0,0.0,0.187052775,0.148999517,0.0,0.0,0.0,0.261513817,0.0,0.0,0.0,0.0,0.390671586,0.158393114,0.19328304,0.07254740700000001,0.0,0.0,0.0,0.294433936,0.0279489684,0.23836803,0.0945128443,0.0,0.0,0.0,0.0,0.0,0.285946071,0.0,0.0,0.0,0.10285777900000001,0.339994109,0.413988423,0.50621018,0.431695135,0.0,0.166083707,0.114214717,0.285069167,0.12011371300000001,0.0,0.130108542,0.33722559799999996,0.247746303,0.203799072,0.0,0.6980091709999999,0.429643135,0.670563266,0.7720591179999999,0.8746236959999999,0.815853266,0.975643578,0.9554171509999999,1.54480654,1.53032186,1.21765503,1.3274089,1.09952836,0.903961297,0.61782496,0.985245195,1.05662656,0.449252185,0.38957911799999995,0.675654713,0.0,0.621764377,0.259103569,0.534903601,0.0230355835,0.0,0.06307040230000001,0.6521830510000001,0.488066599,0.20168115399999997,0.433465273,0.501336762,0.0,0.117425376,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.70599279,0.63411283,1.20477845,3.43048325,3.77657173,3.47001807,3.33698224,2.73983691,2.38565583,1.0083107,1.27381531,0.0,0.0,0.0,0.59142593,0.61576475,0.4384589,0.0,0.9286209999999999,0.0,0.53013698,0.0,0.0,0.0,0.0,0.34081598,0.0,0.0,0.05820979,0.0,0.0,0.1275817,1.16159082,0.0,0.28674144,0.0,0.0,0.0,1.87959171,0.30312136,2.19333552,0.6958116999999999,0.4942955,1.91132981,2.0920083,1.95978303,0.74855529,0.13374644,0.0,0.0,0.42613976,1.57110464,0.0,0.04725534,0.0,1.030877,0.20120427,0.31620428,0.0,0.66719935,0.8435113999999999,0.0,0.7825069,0.0,0.81325856,0.74194236,0.99240501,0.0,0.0,0.60658797,0.0,0.24213502,0.44122557,0.0,0.0,0.49768278,0.0,0.0,0.0,0.16657753,0.99877705,0.0,0.0,0.78743949,0.22450885,1.02405643,0.0,0.0,0.0,1.6192948999999999,0.74201744,0.0,0.0,1.14485778,0.46930468,0.0,1.4263006999999999,0.2822453,0.0,0.0,1.29932043,0.29215399999999997,1.30376179,1.63968177,0.0,0.0,0.17194934,0.31282647,0.0,0.16087529,0.0,1.77409854,0.24068243,0.0,0.0,0.0,0.0,0.50842729,0.79143325,0.32706333,0.60247969,2.23042034,1.68719187,3.69378975,2.57205502,1.13652612,0.19969682,0.0,0.0,0.92050484,0.0,0.0,0.46755332,0.0,0.76523794,0.62325286,0.60761559,0.41179442,0.0,0.62743406,0.0,0.0,0.0,0.0,0.37929559999999996,0.0,0.0,0.89280753,1.29458706,0.1284243,1.13078607,0.0,0.41382363,0.0,0.0,0.0,0.54740579,1.08748574,0.0,1.31787056,0.0,0.0,0.16404481,0.0,0.27263474,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
4.38497486,2.89939569,1.00390444,2.54106449,0.90995164,4.60607019,2.30915925,0.96256245,0.0,0.0,2.68119704,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.36084056700000006,0.211520942,0.0,0.0969337814,0.052953655499999995,0.0,0.8924661690000001,1.48373483,1.86189611,1.63039981,0.76801724,0.49710126299999996,0.0182806408,0.0,0.0,0.342622576,0.0,0.0,0.316770562,0.0,0.0,0.0,0.0,0.11369688900000001,0.355355514,0.015621243200000001,0.350322139,0.46890055700000005,0.297671775,0.185683198,1.06585659,2.1990682999999995,3.04428987,3.45756346,2.9842031,1.70145901,0.057278370700000004,0.0,0.0,0.0,0.0566937622,0.0,0.24049975,0.266433392,0.0775870731,0.0,0.234106085,0.0,0.0,0.0,0.842229253,1.27153026,1.35942518,1.29510416,0.43789631799999995,0.97947575,0.671170437,0.618629315,0.9156718309999999,0.275285459,0.0,0.164259808,1.28016839,2.86034219,3.20346463,3.11059512,1.74871336,0.37044869799999997,0.0,0.0,0.157460335,0.400971791,0.422207792,0.0,0.0,0.460528879,1.27772302,1.55101016,1.28538112,1.42645642,0.623744367,0.308621995,0.287236535,0.0,0.0,0.183225172,0.586703329,0.177718572,0.68139585,0.420547228,0.124655901,0.21443999,0.445723463,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.061212398700000004,0.039124135899999996,0.0,0.0720768047,0.136347095,0.0,0.138905643,0.284587162,0.31389190699999997,0.05512393980000001,0.24658423100000001,0.214690302,0.0,0.128216368,0.107801657,0.0,0.0,0.0,0.0,0.119552881,0.0,0.161299094,0.0,0.0,0.0408400612,0.21651696399999998,0.296480365,0.143993795,0.157639734,0.0,0.0,0.054745504199999996,0.0,0.0,0.0,0.21611607600000002,0.00518338827,0.315529237,0.115073991,0.0799309043,0.263313568,0.330461692,0.30433204399999997,0.05318779269999999,0.0,0.0,0.0,0.0383552109,0.223300085,0.267145845,0.0657608192,0.061366390800000004,0.0,0.0934073916,0.269799716,0.0,0.229059583,0.0382858952,0.0,0.210845358,0.0,0.0,0.20107702600000002,0.0,0.0,0.0,0.0858586684,0.00839194538,0.129158621,0.0,0.37811516,0.297743962,0.111443736,0.134279048,0.225284111,0.051788223099999996,0.0,0.0,0.144970914,0.0,0.0,0.190333738,0.15670593900000002,0.264750241,0.17534163600000002,0.342349146,0.24179550100000002,0.237540245,0.0,0.0,0.012476325600000001,0.0,0.0,0.0,0.0349613975,0.257521519,0.0458253261,0.0,0.0393272173,0.38688819799999996,0.189509188,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0517216337,0.12531076,0.5700374189999999,1.20388047,1.55564942,1.33841004,1.45552593,1.96264548,1.56086123,1.84541757,1.57394522,1.43394573,0.8671564209999999,0.622706071,0.0256973877,0.0,0.0,0.0,0.0,0.0,0.0,0.045966962,0.0,0.393180986,0.326697327,0.284053713,0.547069394,0.425376519,0.240050421,0.226869181,0.0,0.0,0.0,0.027371194300000002,0.0,0.0,0.0,0.236346102,0.375085834,0.253085773,0.244513559,0.32934248,0.0,0.43831074299999995,0.279135103,0.0,0.059321007,0.17813432699999998,0.0293279698,0.13714348,0.0,0.196380838,0.299779902,0.48018765799999996,0.479478529,0.7912678940000001,0.586465645,0.20484939300000002,0.324820927,0.265745358,0.146237008,0.0498084747,0.0,0.0,0.0,0.0,0.0015721331099999999,0.105915359,0.646158594,1.00268279,1.24050421,1.43541839,1.61437183,2.32126565,2.46917523,2.22443454,2.7179327,2.67964824,2.14256841,2.11876965,1.96166477,2.15057217,1.98100319,2.01172814,1.58276007,1.63627312,2.19736409,2.28361339,1.95608546,2.15253559,2.45154691,2.61884955,2.71473076,2.84812332,3.31263657,2.78623161,2.82853322,2.73955157,2.4865424,2.53929251,2.48868707,2.36828687,1.84418483,1.7020747999999999,1.62462169,0.973425402,0.87128843,0.34760330700000003,0.668014778,0.0223827705,0.35920549399999996,0.0,0.028867205899999998,0.0169655669,0.0,0.436204414,0.507361492,0.416978845,0.581714961,0.876771745,0.622802823,0.748516486,0.839695173,0.858348915,0.244994052,0.213019663,0.0202809645,0.0718617167,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.8565165920000001,0.476867718,0.0,0.319414128,0.31942077,0.047762088099999996,0.185590859,0.27588225,0.402790611,0.0710981009,0.0,0.09829940279999999,0.0,0.47132569700000004,0.833091567,0.046614858099999996,0.0,0.04961715480000001,0.115169607,0.31007672,0.0328130846,0.0,0.0512535708,0.0,0.00890281469,0.00672872184,0.0,0.0146419646,0.0,0.0161657119,0.437720275,0.921066155,0.8868246890000001,1.43212873,2.23455242,1.79342978,1.35664243,1.20510357,0.9936570459999999,1.76753614,2.36139527,1.66842019,0.588347992,0.20033658,0.6571613510000001,0.598462377,0.209107525,0.183986918,0.0,0.0,0.0662990291,0.0,0.143264908,0.0,0.0,0.143606821,0.0,0.84613278,2.27296524,0.9663021209999999,0.0,0.140771173,0.0,0.11284265,0.661821731,0.7032963590000001,0.728088471,0.40162926299999996,0.0,0.0,0.0239325873,0.0,0.013662044199999999,0.0,0.0,0.00919396718,0.0,0.00886943416,0.0,0.0,0.0174639823,0.0,0.07848558650000001,0.564639141,1.27078797,2.35750312,4.10094874,4.912429400000001,2.99081111,0.571762809,0.0,0.259937383,0.931288821,1.13347024,0.17127252399999998,0.0,0.11859233599999999,0.180365078,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
22.05772024,0.0,9.91707543,12.26982457,3.05123325,3.12283162,1.83005543,8.06695702,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.474
0.0916234628,0.0,0.500276295,0.223446764,0.0,0.576177037,0.483735074,0.490477455,1.27230018,1.01058559,1.544478,1.36752042,1.2923524,1.2359950000000002,0.653901107,0.532561959,0.0743490713,0.5590323970000001,0.272586349,0.0,0.6334084,0.6522191079999999,0.0,0.0,0.215758358,0.0,0.0,0.21618088,0.0840536027,0.200204694,0.140956553,0.0242674067,0.0,0.31521580899999996,0.0,0.121961579,0.0,0.0,0.0,0.0,0.0,0.0,0.170303603,0.0,0.0,0.0,0.0851248753,0.0,0.0,0.0,0.0,0.05819256019999999,0.0,0.0,0.629548869,0.739092625,0.744634786,0.0110375263,0.0,0.0,0.0,0.0,0.0944519677,0.616017661,1.75828686,2.11881617,3.05542004,4.52449471,4.81265159,4.29273467,3.22077471,2.73750889,1.5381403999999999,1.214909,0.7625885029999999,0.16964528899999998,0.238417665,0.0510271953,0.409250761,0.5963969720000001,0.0384362641,0.0,0.0629692473,0.0953735049,0.0,0.0,0.8409543820000001,1.16308796,1.50520968,1.66989682,2.51628905,2.24468222,1.90344512,2.0064572,0.8458148320000001,0.918347122,1.00915987,0.393618556,0.38528760700000003,0.44611380700000003,0.533359105,0.37845844,1.13944743,0.801275802,0.306157677,0.21979857600000002,0.0,0.0,0.407820635,0.410248385,0.42810118399999997,0.342363999,0.8412521999999999,0.335487523,0.951094313,0.48936079200000004,0.453384399,0.631062548,0.39262785899999997,0.0,0.45216372,0.0,0.0,0.0,0.062404992400000005,0.38693984200000003,0.0,0.0739404279,0.0,0.0189769591,0.421946159,0.134870845,0.0,0.0642714189,0.0,0.0,0.0,0.160399257,0.0,0.0,0.0,0.31723297,0.0,0.227270374,0.0,0.0,0.19973159399999998,0.0,0.0,0.0,0.0,0.139223811,0.0,0.384041688,0.15008375,0.0,0.0,0.0,0.408414313,0.238371597,0.0,0.0,0.37932921,0.0183544535,0.559620119,0.731901747,0.44401679200000005,0.0,0.215110815,0.38767795299999996,0.37946929100000004,0.0418476216,0.518085475,0.12577944800000002,0.267631364,0.267285322,0.0,0.317137433,0.026057744100000002,0.0,0.0,0.0,0.225149545,0.549100558,0.23099383199999998,0.758556936,0.45785385100000003,0.294433299,0.624715217,0.471668498,1.03434211,0.6687742879999999,1.32933757,1.12294861,1.15669573,1.21805115,0.6435561439999999,1.01383026,0.338419883,0.952269409,0.939293553,0.45420234299999995,0.889935215,1.14463327,0.73224665,0.5750528770000001,0.40523394100000004,0.6948125709999999,0.0724259995,0.419699649,0.0,0.44870465600000004,0.0,0.515469984,0.58026679,0.05014995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.263624242,0.18244932600000002,0.129729478,0.113794169,0.134262998,0.18227613199999998,0.24268737199999998,0.29764471800000003,0.33070218,0.33052187,0.293348646,0.223737237,0.133413914,0.038570834,0.0,0.0,0.0,0.0,0.0,0.0,0.0560379182,0.101588359,0.12224676,0.113503015,0.0779197884,0.024341879599999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0135767772,0.0670192447,0.104411981,0.116884906,0.101436315,0.061644629900000004,0.00685067182,0.0,0.0,0.0,0.0,0.0,0.0,0.032008893,0.0857753357,0.12003165,0.12610571199999998,0.101820751,0.0521714536,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0611625442,0.12429551900000001,0.160371529,0.159116185,0.11860648800000001,0.0462058931,0.0,0.0,0.0,0.0,0.0,0.0,0.013841938,0.131636824,0.229505987,0.281000187,0.267553814,0.18368356600000002,0.0399464574,0.0,0.0,0.0,0.0,0.0,0.0,0.313378952,0.833327528,1.42586467,2.03109939,2.58415546,3.02488759,3.30692827,3.40450314,3.31585663,3.06274682,2.68617937,2.23922011,1.77822796,1.3540907,1.00498725,0.751857687,0.597211305,0.527254387,0.516701803,0.535168753,0.5538063520000001,0.550883706,0.515310854,0.447572611,0.358099655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.23449830100000002,0.0,0.0,0.0,0.23783600600000002,0.0,0.0,0.0,0.336956863,0.0,0.0,0.0,1.36325213,0.015493347900000001,0.0,0.0,1.46357647,1.19834691,0.18572533300000002,2.03509645,1.03426905,1.46521695,1.46221358,0.0,0.436499838,2.0837084999999997,0.071728977,0.0,1.41868263,1.8119212,3.54726879,4.00514735,4.37606027,3.82146901,4.43889246,3.18719769,0.8255965679999999,0.247814626,0.0,0.0,0.0,0.0,0.0,0.0,0.851012153,1.58704032,0.935356202,0.6730683679999999,0.0,0.0,0.0,0.0,0.111293781,0.352417724,0.0,0.178628974,0.0,0.391626223,0.750830795,0.0,0.890425503,0.668936129,0.458279738,0.0,0.0,1.10684823,0.0,0.0,0.321086745,1.20179478,0.735675876,0.0,0.16434647300000002,0.18582290899999998,0.463589928,1.10802421,0.0,0.0,0.742797879,0.0,0.675361733,0.0,0.412573009,0.158911547,0.0,0.0,0.0,0.8780823090000001,0.0,0.610041068,1.23063302,0.0,1.92675463,0.528707342,0.0,0.0,0.0,0.0,0.0,0.0,0.679479473,1.59656261,1.01721328,1.87711727,2.42737931,2.79012177,1.67069732,1.01362127,2.10812122,0.0,0.938874251,0.0,0.7632238379999999,0.0,0.0,1.32767075,0.100081714,0.57590357,0.6086883679999999,1.12023045,0.0454038594,1.01997838,0.049347724100000004,1.41642687,0.0,0.889487508,0.8226077479999999,0.0,0.127797369,0.0,1.46587472,1.05677877,0.0,0.0,0.0,0.6449024520000001,0.316603633,0.029992799100000002,0.0,0.7115473370000001,0.850383656,0.889249418,0.0,0.49931928600000003,0.8440875090000001,0.0,0.0,0.0,0.268684837,0.0,1.51898867,0.0,0.0,0.0,0.893781103,0.0,0.6846765109999999,0.626686727,1.15498152,0.0,0.0,0.7269723920000001,0.544587492,0.0,0.0,0.6286124679999999,0.0,0.9946003840000001,1.1579316000000002,1.02203657,0.651633378,0.0,1.30465746,0.597426302,0.0,0.909951389,1.40630939,0.828375808,0.0,1.39449169,0.00878890468,0.57000822,0.138338522,1.49926641,0.763083332,0.0,0.0872443207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
0.356667254,0.0,0.12408561300000001,0.0,0.44210552299999994,0.0,0.0,0.237409498,0.253458835,0.0,0.0,0.430477116,0.503348541,0.349184747,0.358230612,0.67309046,0.65621508,0.51976324,0.564661644,0.0,0.40830094,0.472201173,0.0,0.368556485,0.0,0.440244085,0.530314949,0.6322280579999999,0.75254954,0.177318568,0.213022094,0.98847713,0.98138162,0.637454223,0.569782343,0.447720261,1.15519664,1.25198467,0.76848727,0.668212605,1.11049161,0.894742025,0.520766359,0.566775968,0.139524865,0.0,0.82403302,0.854743348,0.416327414,0.869706865,0.7422118759999999,0.263975225,0.0,0.146575986,0.8579225420000001,0.31851350100000003,0.423990542,0.481828673,0.0412009947,0.35976690000000006,0.21949813199999998,0.0,0.0,0.21106971,0.0,0.0,0.0,0.209029238,0.185724497,0.344929855,0.0,0.0,0.052106166399999994,0.300303909,0.0,0.12185245900000001,0.620413828,0.0984831624,0.0909253434,0.0,0.216093822,0.0,0.0,0.0,0.12174076199999999,0.0,0.14337866400000002,0.6896123559999999,0.260045779,0.517180463,0.80766114,0.583858758,0.730385623,0.514835334,0.597364392,0.523594098,0.0,0.274761381,0.0,0.0,0.0,0.0,0.0,0.0,0.408399655,0.0,0.090626385,0.920464779,0.0690805259,0.585184201,0.0910312126,0.147902173,0.467507447,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.43697863600000003,0.347080066,1.80353286,2.66368209,3.20456409,3.41115507,4.4838644,5.17357022,4.95257364,4.66168713,4.60233196,4.2000767,3.65893609,2.95588508,2.60888813,2.13223742,1.04849925,0.412139373,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.601496434,0.809817557,0.566983215,0.310696295,0.6994114159999999,0.9359287270000001,0.653582,0.030252870499999997,0.37614528,0.04467562940000001,0.0,0.0,0.0654727371,0.0,0.0,0.0,0.0,0.0871556241,0.22547685899999997,0.0,0.0,0.0,0.30066755,0.675003894,0.141349337,0.20059888399999998,0.0,0.0,0.0,0.184027778,0.0,0.223431838,0.279490101,0.304950793,0.0,0.11317838699999999,0.37857145700000006,0.404356912,0.153456174,0.43756945700000005,0.0,0.279963,0.52187638,0.171384708,0.0,0.0,0.08385212110000001,0.34906968200000005,0.0,0.291135409,0.460477421,0.0562056036,0.12690821800000002,0.0,0.0,0.0,0.429785673,0.280824473,0.0,0.26536652899999996,0.0,0.286369431,0.0,0.642111046,0.5961761170000001,0.8741275609999999,0.192198845,1.21701381,0.575368776,0.62020578,1.40210449,1.46886758,0.951891547,1.03958072,0.513830947,0.596353237,0.521099202,0.611598494,0.195707199,0.361958909,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.054939553499999995,0.00225936698,0.452233975,0.0,0.025477696600000002,0.318304049,0.340604344,0.103078782,0.127475425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.24502321300000002,0.0,0.330797293,0.0,0.0897577227,0.0,0.0,0.0,0.0,0.08975698210000001,0.0,0.265033797,0.127091402,0.17301338,0.0,0.0,0.0,0.005746943420000001,0.0,0.0,0.023141542200000004,0.0,0.0,0.0,0.0,0.0341270273,0.150489935,0.0760084642,0.125234859,0.0,0.101820946,0.155231979,0.18056386100000002,1.03716461,1.34473121,1.31446988,1.75210546,2.05755325,1.81759928,1.08730797,0.898560155,0.491161412,0.424175161,0.638854548,0.148175248,0.403564694,0.81010707,0.494906764,0.302881532,0.7674986429999999,0.446705156,0.24238121899999998,0.405618745,0.869197071,1.12761501,1.2432598,1.13221931,0.823427303,1.0898236000000001,0.977736782,0.324017485,0.34214817200000003,0.199239058,0.198046497,0.0482193025,0.39286398299999997,0.25443725100000003,0.17685492100000003,0.389747611,1.26529896,1.8656803,2.37824154,3.03888585,2.94303102,2.9353921,3.16511569,2.42914301,1.65361181,0.875630789,0.629149472,0.13338488,0.211399941,0.0,0.0,0.380739248,0.0,0.246187099,0.404514921,0.46212680100000003,0.0,0.439133816,0.402622918,0.0,0.524118106,0.045470696399999996,0.46780877299999996,0.40320747100000004,0.0,0.0,0.0,0.06541190549999999,0.110516951,0.0962149534,0.0,0.14099988300000002,0.0,0.348826333,0.210159655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
8.52994098,0.54550651,0.03320841,1.09940106,0.0,0.2475151,0.0,0.0,0.0,0.44420461,0.0,1.21734749,0.06641703,0.58841963,0.0,0.5821381999999999,0.0,1.86884766,1.04537699,1.64773377,0.64733923,0.20626813,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.40700000000000003
0.7133160129999999,0.0,0.0,0.0,0.0,1.13492499,1.6013913999999998,0.0,0.36735443,0.523888245,0.0,0.75162961,0.354536301,0.06905119929999999,0.0,0.0,0.761246382,0.0170138876,0.0,0.0,0.163095776,0.0,1.32097168,0.0,0.9248261609999999,0.0,1.17295382,1.96986959,1.74971406,0.0,0.28889681100000003,0.0,0.0,2.80686621,0.0,0.0,0.0,0.0,0.0,1.2748746000000002,1.28447468,0.0,0.0,0.0,0.0,0.796804504,0.49972358100000003,1.14298704,0.0,0.0,0.18025992300000002,0.0,0.0,0.0,1.58800054,1.79515508,0.5613811360000001,1.15864163,0.0,0.0,0.0,0.21217589,0.0,0.0,0.0,0.296367737,1.70055699,0.0,0.0,0.0,0.0,0.7948434590000001,0.0,0.8649713990000001,0.830188673,0.0,0.0072400901799999995,0.33036222,0.0,1.9949303,0.0,0.0359938407,0.0,0.0,0.0,0.0,0.959306082,0.0,0.0,0.0846945164,0.0,2.62097563,0.0,2.09434642,0.0,0.0,0.8779856770000001,0.0,1.11524723,0.0,0.776329934,1.24125911,0.0,0.0,1.85291839,0.34379198200000005,0.0,0.507380273,1.23944648,0.0,0.292083758,0.0,0.0,0.0,1.00374952,0.0,2.33362806,2.31311932,3.58734656,4.66114552,4.70580118,3.11858138,5.18556083,3.69634558,2.21058213,1.06974491,0.0,0.0,0.0,0.0,1.46797457,0.0,0.0,1.21693599,1.22185782,0.0,0.740453701,0.0,0.124823764,1.69786244,0.0,1.23928682,0.600900136,0.0,0.0,0.0,0.5320420339999999,0.0,1.18361318,4.02969229,0.0,0.45320462899999997,0.280745425,0.0,0.27855247,0.247738746,0.653781772,0.0,0.0,0.44578798700000005,0.0,0.345169766,1.18936573,0.221441214,0.07930994400000001,0.5560950020000001,0.28483483600000004,0.0,0.0,0.8456242159999999,0.809380614,0.364534136,1.5906989,1.04256353,0.919158307,2.29105513,0.52419924,0.0357751377,0.0,1.02774814,0.0,0.0,0.333794787,0.823588271,0.0,0.0,0.0,0.41359512600000004,0.0,0.0,0.393043159,0.0,0.0,1.10077439,1.29726619,1.55452804,0.7393898190000001,0.125509635,0.534235434,1.47754909,0.666676165,0.9550385020000001,1.11929473,3.33263927,2.39486069,2.24918918,1.3353802,1.78300152,0.692051385,0.322149205,0.0272055733,0.0,0.833216162,0.0,0.0,0.0,0.0,0.0981675226,0.0,0.0,0.223118998,0.234382249,0.0,0.743116619,0.647682462,0.0,0.686018232,0.0,0.634107923,0.8731006659999999,1.11443229,0.0,0.0,2.05523396,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.308192225,0.247232431,0.20197579999999998,0.16560735199999999,0.133337302,0.102646504,0.0730931895,0.0457695375,0.0225511534,0.00530743166,0.0,0.0,0.0,0.0031023725199999996,0.0117222197,0.018873248000000002,0.0223589877,0.020977150299999997,0.014744633799999999,0.0048587002200000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00970429816,0.020743086100000002,0.027688139,0.0289652567,0.024148316800000003,0.0140701018,0.00067654449,0.0,0.0,0.0,0.0,0.0,0.0,0.00247773596,0.0200044642,0.0356919188,0.04687834,0.0517724292,0.0497903369,0.0416511714,0.029212617000000003,0.015080596399999998,0.00207252963,0.0,0.0,0.0,0.0,0.00498202606,0.014512156399999998,0.0219025458,0.0250513221,0.0228104174,0.0152599617,0.0037228027600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0148398288,0.0291010627,0.0380149692,0.0393056757,0.0321713947,0.0175480698,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00797878727,0.035749214700000004,0.0587723884,0.0715512944,0.0700653853,0.05272693690000001,0.020972584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0660269085,0.185219973,0.32050964600000004,0.461031288,0.59546971,0.71371636,0.80835458,0.875738178,0.9164961979999999,0.935392386,0.940574496,0.942347851,0.951682044,0.978696858,1.03136734,1.11464039,1.23007568,1.37602679,1.54828237,1.74100919,1.94779291,2.16256633,2.38024888,2.59698826,2.8099818,3.01694521,3.21537154,3.40177031,3.57108518,3.71645821,3.8294433,3.90068488,3.92098454,3.88259733,3.7805449,3.6137156999999998,3.38554706,3.10414553,2.78179061,2.43386709,2.07736509,1.72915834,1.40430744,1.11463031,0.867737267,0.666651656,0.51004237,0.392998158,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.202237503,0.40350060600000004,0.24357125899999998,0.5137478879999999,0.686864908,0.736508568,1.25804308,1.14559933,0.7463362859999999,1.00773699,0.0,0.388420009,0.567156445,0.15150514699999998,0.0,0.0018889357399999999,0.0,0.34867722100000004,0.0,0.0,0.27960815,0.0,0.0,0.0763609763,0.6486053270000001,0.572343662,0.0,0.0,0.0,0.0,0.120192406,0.0,0.0,0.24221428899999997,0.0,0.0,0.315649201,0.212698976,0.0131401903,0.0,0.0,0.579065461,0.0,0.0,0.0,0.42139891100000004,0.0,0.0,0.0,0.0369837783,0.0,0.359129053,0.49077808100000003,0.350408689,0.367128519,0.307869722,0.0,0.360371161,0.161416682,0.317956759,0.0824658501,0.438881215,0.49431869,0.262519939,0.0,0.0221096496,0.0,0.39994163299999996,0.36803426899999997,0.168727352,0.40387976200000003,0.438096679,0.0,0.0,0.498246012,0.0,0.0,0.080101504,0.20541383,0.0,0.0,0.0726376631,0.0,0.0,0.0,0.22038133199999999,0.414460449,0.0,0.0,0.47297813200000005,0.0,0.0,0.336118876,0.0,0.0,0.37310180600000004,0.0,0.0,0.0026126150100000004,0.0,0.0,0.537724335,0.29138506399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.247110396,0.0,0.0,0.0,0.35348187,0.09912652710000001,0.570846883,0.225752287,0.0,0.752032532,0.0,0.0245773646,0.0,0.0,0.0,0.144225772,0.0,0.0,0.0,0.0,0.0,0.063004602,0.36223175799999996,0.26017745,0.160374846,0.658715352,0.384371587,0.7249680829999999,0.45998308,0.22639444600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.185423366,0.948411289,2.1787995,2.86714548,3.08248924,4.44891865,4.14314747,4.69441789,5.17356843,5.54709264,5.46309664,4.85754283,3.7254247000000005,3.4162627999999997,2.82011632,1.42589343,0.418568139,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
0.12866301,0.0,0.0,0.13059462,0.0,0.0,2.83620992,6.10439046,4.34973669,0.0,0.0,0.60922909,0.48596818,0.33960817,0.21071807,0.62903617,0.0,0.0,0.04965913,0.08520413,0.07233862,0.0,0.0,0.44346140000000006,0.0,0.59917492,0.36481915,0.02468667,0.34447146,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.414
0.257116369,1.06943522,1.36209202,0.11665819699999999,0.399219439,0.21986528100000002,0.22910431399999998,0.0,0.0,0.0,0.0,0.242982521,0.219990446,0.0,0.689044453,0.575637344,0.8204334520000001,0.0,0.35149250000000004,0.0,0.0,0.0,0.0767381637,0.0,0.9128338779999999,0.493724221,0.22082267,0.661832191,0.0,0.0,0.580459658,0.0827379437,0.618244461,0.683855833,0.0,0.188878613,0.11161276699999999,0.0,0.0,0.0,0.504383819,0.0,0.41892683399999997,0.0,0.120538774,0.0,0.0,0.330442425,0.178941004,0.430779376,0.0,0.0,0.0,0.597587187,0.0,0.0,0.12145849800000001,0.0,0.423927582,0.55698906,0.381816936,0.570436721,0.0547371085,0.74329778,0.0,0.0,0.19350806899999998,0.0,0.406522035,0.0,0.0580175307,0.471488801,0.444069344,0.8328906220000001,0.00121871734,0.0,0.0,0.0,0.63700033,0.0,0.0,0.5277968670000001,0.6355010839999999,0.0,0.404377706,0.0,0.488683133,0.900093228,0.443616116,0.0,0.510824477,0.0,0.0,0.21791034,0.0145246651,0.0,0.31032121,0.144865088,0.20499774399999998,0.0,0.0,0.0,0.0,0.0,0.0707687472,0.941055599,0.0,0.21523215899999998,1.17828695,0.0488425906,0.670943877,0.0,0.0,0.0,0.0,0.747703992,1.56788124,3.77316191,5.42830722,5.78617153,7.59275004,7.50468744,7.13497933,6.56037716,4.95802556,2.88381051,0.8014612520000001,0.0501320034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.469
0.605869398,0.0,0.0,0.0,0.374474615,0.945344547,0.897062468,0.463797975,0.0,0.8603681879999999,0.347630216,0.0,0.0,0.0,0.0,0.0,1.17372681,0.908762631,1.02548906,1.28251278,0.330168521,0.0,0.0,0.0441835055,0.0,0.042017957300000006,0.756249224,1.93626349,1.65283796,0.0,0.587356112,0.0,0.249137998,0.0,0.16378251300000002,1.42136098,0.788916148,0.405808283,1.62192191,0.805792017,0.0,0.7894494590000001,0.08407861189999999,0.714507255,0.0728941184,0.0974016157,0.602361968,0.0,0.622366551,0.0,0.611205885,0.0,0.719033455,0.0,0.0,0.61548076,0.036468322000000004,0.278791462,0.0,0.0,0.0205320028,0.263516328,0.0,0.0,0.46256296799999996,1.01893576,0.405767463,0.0,0.581513276,1.05274232,0.423288139,0.0,0.410057303,1.18276182,0.0,1.30751585,0.823573095,0.378057566,0.0,0.0,0.0667294871,0.9753752459999999,0.608748772,0.161794868,0.0,0.0,0.73368918,0.0,0.0,1.14279523,0.762316295,0.0,0.021558717999999998,0.0,0.0,0.0,0.402751545,1.31801569,0.478456767,1.19669267,0.027785993,0.0,0.0,0.131276137,0.662323023,0.0,0.0,0.0,1.58998012,0.0,0.0,1.68117646,4.18141149,2.83672845,1.46134432,0.22750167300000002,0.35216414700000004,1.50265089,0.332698196,0.0,0.400026141,0.96087871,0.0,0.250087728,0.0,0.633823123,0.0,0.43213331,0.315535053,0.0,0.24903582100000002,0.213772735,0.0,0.0064017883700000005,0.594765573,0.9067575520000001,0.858627189,0.6384279979999999,0.285440712,1.02400342,0.0,0.08598305369999999,0.261355238,0.0,0.43458922200000005,0.0,1.39735767,0.380187692,1.54899378,0.30678017,0.0,0.0,0.0698760033,0.835751534,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.82133408,2.24005628,3.46087696,2.0486579,3.26974899,4.52489906,3.80041693,0.0,0.14428092,2.29420286,0.37461642,0.0,0.05882821,0.0,0.26578083,0.25485444,0.66393372,0.52814232,0.41652585,1.11415767,9.65666387,0.05502046,2.13914946,2.45440611,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
7.62602767,0.27896905,0.0,1.63287498,1.01359317,0.0,0.46654377,0.38148118,0.57049121,0.0,0.52892195,0.0,0.0,0.0,0.99935078,0.51073955,0.0,1.75931262,7.45932942,11.87110469,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.461
0.16914487,1.57945473,1.96290648,2.62528912,3.02830816,3.88972745,4.66408716,4.75073108,4.95214684,5.87704711,6.05117986,6.02336107,5.80532005,5.33759795,5.24702504,4.812751400000001,3.48026824,2.8682887000000004,2.40563014,2.23993626,1.1195563,0.2159996,0.45791457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.25554343,0.36238408,0.6759808,0.73222297,0.96455672,0.5638632,1.23876548,0.41741199,0.90264244,0.55896645,0.41157169,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04153753,0.0,0.12460908,0.20487908,0.69054917,0.68110851,0.32192088,0.88852266,0.95345787,0.43944251,0.32004707,0.25735305,0.0,0.4473545,0.08421653,0.01001661,0.0,0.0,0.0,0.0,0.0,0.0,0.20579539999999996,0.09366671,0.0,0.25093196,0.52315221,0.84180489,0.82172096,1.09476438,0.3294917,0.61983601,0.90812946,0.23676674,0.42300988,0.04723823,0.2272834,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.457
1.12567077,0.0270524492,0.87259973,0.010394050600000001,0.0,0.0,0.0828800552,1.36556267,1.53109054,1.64138831,2.36063617,1.69193231,1.71553545,1.24299834,0.828797813,0.404034624,0.37290064100000003,0.635366825,0.589800247,0.0,0.0,0.0,0.0,0.40346108399999997,0.34715043100000004,0.0,0.0,0.00417629234,0.0,0.26272470800000003,0.252388334,0.44557842200000003,0.0,0.0,0.335003899,0.0,0.157473741,0.650214173,0.155083406,0.0,0.0,0.20105456100000002,0.0,0.0,0.0499389888,0.298563409,0.343112294,0.48153621799999996,0.410360612,0.50535011,0.0,0.408182669,0.555614509,0.0,0.0,0.506537413,0.0,0.614495966,0.055270815099999995,0.6136284000000001,0.0,0.0873868577,0.0,0.0,0.0,0.0,0.101186052,1.02735079,0.444846966,1.08559842,1.47386002,1.33431824,0.813127631,0.9099617259999999,0.24287091600000002,0.0,0.0,0.068907361,0.0,0.180459995,0.7808037440000001,0.514261069,0.662582869,0.26711082199999997,0.0,0.419792447,0.0,0.0,0.0785868134,0.227457753,0.0,0.0,0.636489655,0.0,0.42825098799999994,0.0,0.29079277800000003,0.0,0.0626804181,0.09656968980000001,0.582519557,0.257415597,0.41711749200000003,0.0,0.0,0.0,0.793559749,0.54917432,0.647990253,0.22235682399999998,0.0,0.0,0.385605377,1.10742102,2.88327272,2.90743256,2.45411754,1.47988572,0.773584932,1.99712641,3.03863751,4.57500774,5.69579498,6.58297728,4.76275944,2.45167547,0.9710397270000001,0.0,0.0,0.0,0.213538272,0.553626803,0.9753844559999999,0.0470536765,0.0,0.0,0.0,0.158837235,0.822350928,0.121382875,0.0,0.0,0.0,0.219637201,1.36137252,3.40857746,4.83986103,4.5766747,4.66782249,3.90337991,3.47247885,1.81819525,1.19161498,0.363497277,0.310042102,0.274777764,0.548851861,0.37138849399999996,0.0179034856,0.0,0.284358518,0.247541641,0.123319089,0.123520516,0.0,0.436601691,0.609956095,0.0,0.21175977399999998,0.52101599,0.0,0.0,0.596416275,0.0,0.0,0.0,0.0,0.0977304758,0.574530634,0.24885045,0.0,0.0,0.0,0.9131755290000001,1.23458165,1.32547383,1.58784168,1.74231328,1.28904857,0.928806358,0.0,0.250880559,0.0,0.329863354,0.0,0.41285792600000004,0.560027843,0.0,0.234938201,0.0249225952,0.0,0.0174031327,0.22430748600000003,0.0504639051,0.0,0.0,0.0,0.598232505,0.0,0.482790967,0.0,0.0,0.0,0.518412291,0.0,0.068541562,0.0599551292,0.0,0.62052813,0.5757082920000001,0.0133252027,0.0,0.0,0.38806227299999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
0.45481767,0.31695204,0.18772552,0.41381559,0.57174102,0.35376631,0.30897244,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.52413946,0.0,0.25319877,0.0,0.0,0.26828589,0.0,0.10346309,0.89505165,0.17912557,0.1143462,0.06964679,0.0,1.33512997,0.51825852,0.95584134,1.87806172,1.39887431,1.28598334,1.10722282,1.50003461,1.65224908,2.54016152,2.12917211,2.25641181,2.15988425,1.05412008,2.75245737,3.38145863,3.37568297,2.4626813,2.11413188,2.06048266,3.24924112,2.08722086,2.42222715,1.79548668,2.10282337,1.60841003,0.64678721,0.06870311,0.68411002,1.10637635,0.11918153,0.82743688,1.21969737,0.69766056,0.0,0.73351151,0.0,0.04040973,0.0,0.10264929,0.0,0.0,0.38439793,0.41121745,0.39470676,0.95158651,0.1687813,0.03431932,0.29467957,0.030194400000000003,0.0,0.51447077,0.69865377,0.16191124,0.26673522,0.72010806,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.9861938259999999,2.90927943,1.77301735,0.024838383199999998,0.112738145,0.213441535,0.0,0.243105087,0.060322159800000004,0.0750065855,0.0833679287,0.0,0.059814822999999996,0.0,0.0,0.8586799740000001,0.451190826,0.0,0.0,0.0658247203,0.473522195,0.0,0.0,0.6234333710000001,0.23250245,0.405185045,0.204159024,0.156012617,0.0,1.5415295,3.11268757,1.68604056,0.0,0.42189454600000004,0.0,0.0,0.548009353,0.651519356,0.0,0.0,0.28128988,0.49794802299999996,0.0,0.0,0.0,0.0,0.42884247299999995,0.100298303,0.205727708,0.0,0.47684162399999996,0.750412792,1.80253099,1.25119413,0.0,0.0,0.630814835,0.705555411,0.0,0.0,0.0,0.6125169460000001,0.8502342390000001,0.0852010843,0.0,0.0793181964,0.148112424,0.0,0.0,0.6717029109999999,0.0675233364,0.0,0.7893633809999999,1.75866489,0.809434839,0.0,0.0,0.0951484091,0.0,0.0,0.414773546,0.0,0.0,0.30713991,0.40148313,0.0,0.0,0.0,0.80566044,0.46882681299999995,0.0,1.46608529,4.79819573,3.45971575,0.0,0.0,0.9537891479999999,0.516945261,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.0689265931,0.0,0.0,0.0,0.057713287,0.0451448452,0.0,0.0197899136,0.131953283,0.263628372,0.36175099,0.5048973489999999,0.903418718,1.75174912,3.02849081,4.404022,5.3556843,5.44403998,4.57798924,3.08887911,1.55558663,0.489047205,0.07705257830000001,0.143638602,0.328148609,0.345294534,0.148575727,0.0,0.0,0.0,0.311093414,0.581628499,0.653849194,0.516095414,0.280081834,0.0849288041,0.00260017818,0.0108298586,0.0382195756,0.0322190022,0.0,0.0,0.0,0.0,0.025435290899999997,0.0319099278,0.0127669705,0.0,0.0,0.0,0.0016175187599999999,0.00431847762,0.0,0.0,0.007253765069999999,0.0148236161,0.00860428234,0.0,0.0,0.0,0.00842895502,0.0434291342,0.0463480761,0.00603141527,0.0,0.0,0.0,0.04452397599999999,0.09373953410000001,0.0664702503,0.0,0.0,0.0,0.0,0.116293038,0.158363464,0.06441036,0.0,0.0,0.0,0.0675836851,0.262844428,0.259687352,0.0118931443,0.0,0.0,0.0,0.6386584439999999,1.50002714,2.06933771,2.06946595,1.52418764,0.731902341,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
1.86927879,0.6499073000000001,0.03109469,0.0,0.0,0.0,0.73159846,0.0,0.15884142,0.0,0.0,0.0,0.0,0.25639648,0.74882379,0.05061128,1.22906124,0.43314611,0.0,1.43103433,2.27881155,2.96033516,2.42069038,3.50732487,0.83056771,0.0,0.17725509,0.10712235,0.91103537,2.40811716,3.07254581,1.5297498999999999,0.59400701,0.0,0.35118704,0.79933995,1.14361332,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.633621201,0.0,0.0,0.61372957,0.270308798,0.0,0.0,0.0,0.7430206570000001,0.0,1.19675333,0.0,0.275614466,0.499658285,0.444473285,0.137605952,0.884432992,0.248876349,0.0,0.46394424799999995,0.0,0.616632516,0.481629983,0.256390015,0.0,0.25569222199999997,0.0,0.0,0.0,0.974016969,0.914844452,0.0,0.46563473200000005,0.820568238,0.762921828,1.12463162,2.61008603,2.06331878,2.53213701,2.69092618,3.01950299,2.48150813,2.74193422,2.69039356,2.08481954,1.56884281,1.80888823,1.53392859,0.222333285,0.408386739,0.992902828,0.908561782,0.0,0.0016392091,0.35414401799999995,0.0,0.81392267,0.9596073909999999,0.676319352,0.43746557,0.44018212700000003,0.571774817,1.15953278,0.9684206959999999,0.0054399737100000005,0.40843186,0.61256156,0.1947443,0.37681439200000005,0.0,0.0,0.0,0.333565567,0.0,0.0,0.0,0.8615932709999999,0.0,0.0,0.132184066,1.10301507,0.0,0.219652145,0.20108873,0.075386294,0.0,0.37831379,0.38670771600000003,0.0,0.195897915,0.0,0.0,1.1509178,0.647212468,0.0,0.171876246,0.648748937,1.38221201,0.22845362600000002,0.239378247,0.0,0.0,1.34286404,0.0,0.383673014,0.0,0.0,0.0898334417,0.288246063,0.670095265,0.0,0.21575542,0.0,0.0,0.923391208,0.0,0.928461932,0.0,0.0,1.18919031,0.09309166320000001,0.40287922200000004,0.0,0.0,0.0,0.18787060000000003,0.0,0.33336146699999997,0.46332112799999997,0.612222743,0.35332604,0.858067134,0.312980727,0.72042146,0.0,0.29077743899999997,0.0,0.0,0.843881344,0.8753193309999999,0.0,0.0,0.353939186,0.733674273,0.901576687,0.645543375,0.7177784840000001,1.61761504,0.14287687300000002,0.0035712529299999993,1.16101958,1.58600863,0.762023424,0.272689904,0.596421627,0.498009995,0.8310068429999999,0.543690885,1.36742601,0.637997181,0.072403211,0.565518642,1.07002067,0.6157126629999999,0.67779257,0.56779312,1.31474162,0.586500484,0.362497778,0.282655798,0.600765291,0.0,0.206424252,0.59410776,0.0,0.0,0.0,0.0,0.325720884,0.58705783,0.46406915600000004,0.483261399,0.0,0.0,0.26565045600000003,0.8682964,0.0,0.6244592170000001,0.491325285,0.0,0.0,0.599041375,0.0,0.0,0.0,0.19665716800000002,0.622972955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.67001756,1.38681599,2.90909784,2.74926645,3.65115331,4.41562081,5.19311009,4.50772086,4.56136733,4.43486679,3.6036203999999996,2.70748979,2.11708579,1.21010263,0.38920398,0.54785925,0.0,0.01148356,0.0,0.0,0.06277486,0.0,0.0,0.57908441,0.60238191,0.0,0.50994038,0.16098271,0.0,0.36860671,0.0,0.47133334,0.41670274,0.61853988,0.44405259,0.60270329,0.51133702,0.0,0.0,0.0,0.0,0.0,0.0,0.05811837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.58202058,0.8152913,0.91094306,1.1537895,0.7803467,0.75200471,0.93745981,0.31582467,1.55186131,0.09338546,1.86433681,0.62233839,0.41934799999999994,0.71599896,1.53993756,0.44684776,1.48063803,1.69803666,1.64200038,1.36017967,2.62523132,1.15790051,1.60144595,1.69036143,1.95845785,2.84812965,2.03784204,2.49453153,3.56827468,3.29157748,2.23233137,2.72929227,2.33642141,2.5012717,2.63758393,3.23374895,3.4965521,2.61064133,2.92790525,2.3311148,2.02494064,3.40624995,2.37622967,2.79871985,2.79458069,2.23839034,2.60640044,2.46442256,3.00605173,2.17804739,2.46040676,1.55473653,2.59525586,1.32910802,2.80098954,1.27655786,1.22014558,2.12149366,1.47998565,1.77117006,1.01731186,1.96191907,1.57449206,2.10132447,1.21384461,1.25227266,1.90050927,1.47224617,0.43154267,1.16680836,1.20519264,1.44680699,0.50991335,0.77723892,0.61066876,0.76488911,0.0,0.32869478,0.50226491,0.56010527,0.29933137,0.75436664,0.13760694,0.0,0.14474893,0.0,0.06438443,1.19896743,0.0,0.0,0.0,0.0,0.0,0.04087101,0.08068381,0.0,0.32089367,0.0,0.0,0.0,0.27044401,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.4848989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04864252,0.0,0.0,0.33635704,0.79484127,0.0,0.0,1.08072039,0.37652687,0.25520697,0.48095351,0.0,0.0,0.50869313,0.0,1.06000527,0.0,0.0,0.0,0.82482847,0.0,0.53227571,0.35528207,0.0,0.10403236,1.20176265,1.58676328,0.80754734,1.31085963,0.16941723,0.7026733000000001,1.70899236,0.22110947,1.35283142,0.17855809,0.10691527,1.35759288,1.40408846,0.25561452,0.06458729,0.0,0.0,0.35808742,0.0,0.0,1.93829502,0.0,0.0,0.28760191,0.01420142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22605915,0.0,0.0,0.0,0.09322164,0.08090708,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.62249914,0.0,0.0,0.21046108,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.460974414,2.445322,1.15775819,2.11796626,1.00924016,0.831304411,0.441467469,0.0,0.0,0.06462297269999999,1.00612166,0.7669085529999999,2.34475779,1.98383722,0.9278730609999999,0.257178538,0.0,0.0,1.50974111,0.0,0.17200700600000002,2.23130449,0.0,0.0,0.0,1.41318428,0.0,0.0,0.0,0.180344599,0.5926286270000001,0.662318113,0.8812590240000001,0.37701108899999997,0.0567703097,0.0,0.9083919540000001,0.42405221600000004,0.59229826,0.0,0.0,0.0,0.0,0.795459985,0.644622052,1.58141423,0.0,1.64085814,0.0,0.0,0.0,0.6604117389999999,0.353077242,0.589197463,1.32412802,0.580325584,0.0,0.0,1.28798557,0.829092895,0.0,0.0,0.00167328995,0.0,0.39913201200000004,2.28394312,3.68660752,3.87773682,2.34906211,0.0,0.007461930109999999,0.0,2.52226577,0.19344747,0.18180977399999998,0.0,0.335161101,2.88988137,1.78225574,2.04919809,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.516220815,0.22758313300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.571047439,0.332380137,0.778528063,2.00532437,1.36068116,1.83592412,1.83609882,1.9867352999999999,3.24519679,3.91533642,2.17158548,3.08854886,2.86459062,1.76092758,2.72591197,0.753116783,1.59560703,1.94874343,1.1180165000000002,0.9629318290000001,0.0,1.03844805,0.00938270271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6847128029999999,1.02801557,0.0,0.0,0.0,0.531053639,0.38891829200000005,0.0,0.0,0.414751806,0.0,0.109165353,0.33162452600000003,0.0,0.0,0.9041443640000001,0.0,0.0,0.19300468699999998,0.299133143,0.8093741390000001,0.0,0.0,0.0,0.0355140298,0.264431637,0.0,0.0,0.0,0.44980465,0.0,0.510042898,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.687251933,0.256204065,0.58563173,0.3253348,0.159261051,0.0,0.0,0.304906898,0.928524242,0.0,0.0,0.0,0.159227429,0.0,0.0,0.571217774,0.184273634,0.0,0.563500452,0.006656426280000001,0.0,0.5804980279999999,0.0,0.0,0.0,0.930223473,0.629939265,0.0,0.0594259426,0.0,0.404904816,0.79992458,0.0,0.0,0.131051445,0.0,0.0,0.0,0.0,0.847621126,0.0,0.630100761,0.536627324,0.0,0.811041344,0.019500441599999998,0.573580267,0.17494671399999998,0.0,1.30944976,0.0,0.0,0.025419371800000003,0.363468247,0.9833396109999999,0.279518972,0.158248427,0.0,0.0,1.05308838,0.426988241,0.071600328,0.0,1.48100931,0.162218329,0.478014479,0.309824366,0.9841271340000001,0.601072127,0.556350593,1.41043961,1.42904852,1.35383189,1.22374845,1.49472955,0.691117106,1.08765975,1.33465405,0.7698494109999999,0.614831569,1.00786613,0.665164796,0.609773537,0.354859607,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.35253541,0.292384184,0.60069036,1.18932368,0.0,0.772764145,0.36175795200000005,0.0,0.0,0.006615651750000001,0.0,0.657194445,1.50147328,1.11976985,0.0,0.0,0.0,0.0,1.00907886,1.22794923,0.0,0.0,0.968516976,0.580943148,0.0,0.0,0.0,0.0,0.0,0.0,0.160165759,0.0,0.698102184,0.87920814,1.19124436,3.34555889,3.5673307999999997,2.90411483,1.76669534,0.0,0.0,0.7769455679999999,1.21567301,0.0854856001,0.0,0.0,1.40552255,0.0,1.76900493,0.0630758965,0.0,0.0,0.198120895,2.4677599999999997,4.21042198,6.01756227,4.424186,2.17088251,0.473339395,0.0,0.16008705199999998,0.0,0.12896211400000002,0.385630721,0.0,0.499126566,2.50355514,0.0,0.0,0.0,0.9151704340000001,1.27846513,1.1991618999999998,2.2581276000000003,3.3602915,1.53150476,0.0,0.0,0.7117569009999999,1.61788441,1.73407128,1.39016797,0.24732481899999997,0.0,0.453369349,0.406907625,0.0,0.88735578,0.123409974,0.0,0.206534544,0.27349139899999997,0.0,0.0,0.327246766,1.5212789,0.0,0.53702143,1.00584087,1.0765037,1.72957729,0.0,0.37135590399999996,0.558095832,1.58854837,0.0,0.0,0.0,0.722417359,0.0,0.0,1.43217116,0.0,1.01963031,0.0,1.95313068,0.0722639622,0.0,0.9620778590000001,0.0,0.22323252899999999,0.0,0.21660978399999997,0.42278031299999996,0.6306997639999999,0.0,0.8867662270000001,0.0,0.0,0.0,0.0,0.0,0.0,0.079102344,1.20175214,0.0,0.0,0.657548351,0.0,0.0,0.52725436,0.0,0.00332202714,0.42796072799999996,0.0,2.03946163,0.0,0.0,0.453567372,0.0,0.0,1.79569699,0.9996498840000001,0.0,0.0,0.028293700499999998,0.0,0.0,0.270283975,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
2.92567279,2.79817725,2.50773739,2.43356825,2.71294717,2.32903511,2.21047409,2.1678806,1.66399763,1.4679743,1.77969232,1.46762412,1.06583668,0.85452382,0.81674025,0.48638684,0.29836961100000003,0.15644844900000002,0.0,0.0,0.0,0.0166578657,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.031206992700000002,0.18931356300000002,0.25876355100000004,0.31285668,0.25409671300000003,0.046626396699999996,0.302256647,0.016528436,0.341887137,0.443704813,0.08572674710000001,0.461591595,0.293707772,0.0,0.18252464100000002,0.193806156,0.0756876984,0.229499234,0.184158058,0.0,0.0,0.0,0.08745349279999999,0.11350521699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0152827391,0.152329719,0.0,0.0,0.224716002,0.0,0.324742213,0.0,0.0608713796,0.0231837868,0.0,0.0,0.0,0.268664616,0.0,0.130411257,0.0,0.0,0.0,0.0,0.047280897599999996,0.0,0.0,0.07201344679999999,0.189045262,0.111764044,0.16390500800000002,0.2615307,0.0104031381,0.31593903100000004,0.481425919,0.7510664429999999,0.331520665,0.675377807,0.563788972,0.83186806,0.749277428,0.808355446,0.978366838,1.26810353,0.950886522,1.52162746,1.09016886,1.35617124,1.52515437,1.16484027,1.55835805,1.19624751,1.40744389,0.9547104540000001,0.979166603,1.13357512,0.699560156,0.6794770379999999,0.45946718700000005,0.219434665,0.346632382,0.0,0.0,0.0,0.00014004622999999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.104150293,0.0,0.274796869,0.643209055,0.7669960029999999,1.05941664,0.96768363,1.12725458,1.48929197,1.61630397,1.80424696,2.23446372,2.15080525,2.32149044,2.36239704,2.80774442,2.74306393,3.11014463,2.9660518,2.92907424,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.99365332,6.72861995,6.0157815999999995,1.33788068,0.5109521370000001,3.0024766,2.37935357,0.0,0.0,0.9716825290000001,1.51065015,0.620675605,5.19224088e-16,0.11045347800000001,0.602932036,0.46578932,0.0,0.0,0.9459339920000001,0.36478687600000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.26650599,5.75146985,11.27498349,8.86989755,6.14971986,2.34299515,0.25054952,0.0,0.0,0.0,1.07077696,0.9440742,0.28494074,0.0,0.0,0.0,0.0,0.25335874,0.59197549,0.0,0.03987355,0.0,0.0,0.0,0.31919824,0.0,0.73334988,0.0,1.88967012,1.76428884,0.0,0.47226238,0.0,0.0,0.19831853,0.0,0.0,0.84288433,0.20233485,2.23336591,0.0,0.0,0.0,0.20685799,0.0,0.0,0.0,0.0,0.0,0.0,0.81287422,1.52839619,0.0,0.0,1.75779198,1.49274775,0.0,3.42789843,2.34751651,0.0,0.0,0.0,1.5682876000000001,0.0,0.79085584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.165925266,0.0,0.506013333,0.244561296,0.6920486109999999,0.706280571,0.634120716,0.657385695,0.16710129999999998,0.606682677,0.0,0.48495652899999997,0.138422146,0.559433733,0.0,0.14279461599999999,0.0,0.11064253,0.0,0.0,0.221782649,0.0264706067,0.19787272600000003,0.0,0.105543829,0.328743119,0.0,0.147876441,0.0,0.0,0.344569346,0.056722031299999996,0.273979297,0.933456835,1.18986829,1.00130767,0.966076037,1.43602958,1.78599268,1.63037181,1.88430649,1.70534516,1.32317519,1.55132915,1.75292805,1.43763087,0.589163004,0.8291023679999999,0.179521643,0.539546389,0.583577106,0.0,0.0,0.18675377399999998,0.0,0.0703494038,0.0,0.0,0.21456095600000002,0.453623326,0.322051627,0.0,0.275086588,0.235938852,0.24881375100000003,0.0,0.0,0.194377308,0.0,0.0130171373,0.0,0.12248776800000001,0.39808464299999996,0.214698639,0.953307481,0.998686583,1.07887661,0.522331366,0.604803011,1.10851233,0.7483741190000001,0.698521779,0.762683318,0.852880995,0.7002505509999999,0.837448658,1.04970851,0.585046309,0.789203867,0.6373257179999999,0.474799746,0.6178841270000001,0.093812959,0.581102119,0.50300887,0.231957195,0.021837311800000002,0.484148632,0.0,0.0,0.0,0.31202147399999997,0.0,0.1260752,0.0672145007,0.27895656399999996,0.635196882,0.613179566,0.08998344859999999,0.364909017,0.851610738,0.9827410459999999,0.987807216,0.471301099,0.37303892,1.02964343,0.953616612,0.773460363,1.28656511,0.5450811879999999,1.05245708,1.11133966,1.4789249,0.800206173,1.21138363,1.54255337,1.44649289,1.84551576,1.89095694,2.11675298,1.81086249,1.41217151,1.76455966,1.41044542,1.2314631999999999,1.37413714,1.20035227,0.602931969,1.23400764,0.7514700240000001,0.7167967670000001,1.01380536,0.7594600640000001,0.7529147270000001,0.5947629529999999,0.9372570309999999,0.683025131,0.856084983,1.39178165,0.9485431870000001,1.34740791,1.03218213,0.8534055779999999,0.7497598459999999,0.79173637,0.686099485,0.327845589,0.456180215,0.185329325,0.0,0.8044704340000001,1.33538603,1.70618515,2.34175635,2.2940112,2.86830668,3.15398159,4.03227227,3.99924138,4.47545441,4.45782121,4.01498336,4.00986174,3.19357876,2.57125259,2.55451095,1.89594067,0.8941502579999999,0.736276625,0.616665903,0.0964695743,0.092503405,0.339457319,0.245445282,0.394845505,0.0549235161,0.454601569,0.674279307,0.755360912,0.739113472,0.568678961,0.646506641,0.48685693399999996,0.5347874570000001,0.123630201,0.0,0.0,0.0,0.0,0.0,0.13354888,0.328335325,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.64187543,0.0,0.0,0.0,4.39610888,0.0,4.61971496,0.57300203,0.0,0.0,0.0,0.0,0.6166976,0.0,0.0,0.0,3.56413978,5.40840916,2.37479082,2.74856686,2.05652384,0.34807394,0.98286661,0.24210234,1.25148014,2.41931417,3.66947404,0.0,16.91019492,7.69421667,0.0,2.41676791,0.0,0.0,0.0,3.05869886,0.57469504,0.38127909,1.26031311,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48
1.84121959,1.92296204,0.0,0.847162278,1.25606173,1.0186727,2.14161189,1.28963771,0.0,1.50797248,2.55463216,2.65113104,1.44669663,2.32269181,3.31372916,0.0,0.0,4.3954205,3.85360182,6.16531101,0.0,1.55194395,0.0,1.08636075,1.03139652,0.0,0.0,0.0,2.49025909,0.0,0.0,1.16317707,2.20093596,0.0,0.964663774,0.0,0.0,0.246725532,0.0,0.0,0.0,0.0,0.0,0.0,0.22600121199999998,0.0,1.23556283,0.0,0.18193836,0.0,3.61360339,1.29660498,0.7995186129999999,0.0,0.0342571067,0.0,0.0,0.0,0.0,1.34168332,0.0,0.630162532,0.0,0.0,0.0374505886,0.0,0.0,0.0,0.0,0.0,0.0,1.36258435,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.27262504,0.0,0.67058851,0.71461626,0.3656551,0.30575631,0.35825552,0.43937813,0.73475181,0.75573744,0.69522753,0.39823797,0.88518788,0.30653058,0.30736343,0.62572033,0.15555512,0.28126688,0.0,0.05577234,0.04642887,0.0,0.0,0.0,0.16096667,0.0,0.45778131,0.185089,0.57885957,0.53467307,1.01231549,1.29610609,1.16889483,1.56414692,1.27040879,1.46530019,1.65107234,2.0170985,1.43885384,1.97133139,1.77110051,1.55054004,1.73998295,1.41701645,0.88667726,0.91226266,0.91434018,0.79322174,0.55848666,0.39476341,0.04704994,0.45453833,0.23796289999999998,0.24302087,0.0,0.19434210000000002,0.0,0.14837153,0.0,0.22811626,0.0,0.0,0.0,0.0,0.21780337,0.28581452,0.23089810000000002,0.16022750000000002,0.02018837,0.0,0.0,0.20016688,0.0,0.0,0.0,0.0,0.08612768,0.0,0.24870062,0.34101829,0.30033463,0.64259649,0.93928472,1.08600991,1.59209211,1.37359826,1.75849546,2.02524692,2.6247535,2.61365123,3.04132191,2.87061523,2.83841293,2.98045401,3.51118764,3.27352924,3.45306103,2.92111285,2.90762079,2.70510891,2.67950489,2.53761873,1.89338632,1.53882738,1.52757453,1.1064583000000001,1.12818721,0.46317055,0.12986701,0.19816992,0.36539784,0.09154738,0.0,0.0,0.12872106,0.0,0.0,0.0,0.30089276,0.0,0.23319754,0.082014,0.50259583,0.43156863,0.34228986,0.22639895,0.51678377,0.50687387,0.61859776,0.27827689,0.42929565,0.42401053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.31007548,0.27036318,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
5.49939927,4.54307324,4.33760199,3.37285017,1.87674498,0.1160559,0.0,0.0,0.0,0.0,0.0,0.0,0.46212048200000005,0.6381398229999999,1.07891806,1.33937162,1.09657882,0.582261123,1.01214247,0.74854533,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.588161678,0.0,0.663403841,0.0756527428,0.7872215459999999,0.694004537,0.12998768,0.11463636699999999,0.0,0.0,0.36037253,0.7122553909999999,0.620337913,0.0,0.568769474,0.0,0.492915515,0.504504415,0.0,0.0,0.0,0.052824036100000006,0.41309015600000004,0.0,0.0,0.0107328079,0.0,0.0337111436,0.0,0.0,0.0,0.219135794,0.387015957,0.0,0.284300322,0.726765346,0.9268522309999999,0.9428377990000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.165485026,0.22292201399999997,1.72672982,2.72904433,3.73105163,5.31014415,5.32633672,6.2984243,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
1.72272603,0.79664968,0.156008062,0.00175481579,0.103200235,0.13879572199999998,0.0175891474,0.0,0.0,0.030045530600000002,0.112266635,0.06774226030000001,0.0,0.0,0.0012197265400000002,0.0,0.0,0.0,0.265732509,1.23415859,2.30539853,2.74703104,2.09766716,0.6313566820000001,0.0,0.0,0.0,0.85061471,1.71873811,1.73964554,1.18474235,0.6755691229999999,0.560555708,0.6487342460000001,0.521356073,0.0595969835,0.0,0.0,0.247372022,0.8506132059999999,0.8965644429999999,0.329135138,0.0,0.0,0.597456675,1.37631664,1.27036952,0.159521094,0.0,0.0,0.674673885,3.22302459,4.99074025,4.85901657,3.13626415,1.30815028,0.820853132,1.9318325,3.58658682,4.37376831,3.69211776,2.1383446,0.866929205,0.57784651,1.04446523,1.51949329,1.53213284,1.28491355,1.31550024,1.82631393,2.38796603,2.32500555,1.4062656,0.157264365,0.0,0.0,1.01408811,2.07649242,2.32953485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.107300254,0.356027793,0.544250586,0.622758368,0.565718328,0.378071845,0.09609764789999999,0.0,0.0,0.0,0.0,0.0,0.0,0.156150219,0.552449925,0.87487207,1.05435319,1.05274591,0.872532985,0.557247576,0.18213717399999999,0.0,0.0,0.0,0.0,0.0,0.27154866899999996,0.596591175,0.805548858,0.826624461,0.632687815,0.251416775,0.0,0.0,0.0,0.0,0.0,0.0,0.116976235,0.8220018459999999,1.40477061,1.70068144,1.59437358,1.05335674,0.146482566,0.0,0.0,0.0,0.0,0.0,0.0,1.28988687,3.99383254,6.90087282,9.62402868,11.7809601,13.059681199999998,13.273293300000002,12.3932462,10.5546784,8.03273872,5.19437871,2.43479412,0.11054284699999999,0.0,0.0,0.0,0.0,0.0,0.509431764,1.51426559,2.16047645,2.34151272,2.05976682,1.41497139,0.574052715,0.0,0.0,0.0,0.0,0.0,0.0,0.0160737449,0.54314096,0.89774419,1.01319389,0.882650678,0.555967037,0.124061974,0.0,0.0,0.0,0.0,0.0,0.0,0.14452768,0.440186815,0.613367653,0.6310084539999999,0.498538818,0.25627768300000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.184167932,0.358617733,0.43828546,0.409615556,0.28546602,0.100604468,0.0,0.0,0.0,0.0,0.0,0.0,0.032168088,0.18092686600000002,0.278090711,0.303592531,0.25561526100000004,0.149970787,0.0152867174,0.0,0.0,0.0,0.0,0.0,0.0,0.0620659233,0.147849966,0.19218908199999998,0.18763801,0.139134135,0.0618883164,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0516732985,0.0869888375,0.100643015,0.0970320683,0.08709458869999999,0.08496526880000001,0.10373395699999999,0.151456888,0.228477304,0.326753193,0.431360565,0.523781747,0.586142732,0.605341389,0.576058659,0.501946137,0.39475132700000004,0.271652461,0.151498252,0.0508813362,0.0,0.0,0.0,0.0,0.0,0.022411422400000002,0.0439251904,0.051948822900000004,0.046423865300000006,0.030910366600000003,0.010925991000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.00191239122,0.0174266799,0.0369496496,0.061758660599999994,0.09206803470000001,0.125991612,0.15910365099999998,0.184890793,0.19611331,0.186785797,0.154240465,0.100632531,0.0333315449,0.0,0.0,0.0,0.0,0.0,0.0,0.014703333899999999,0.07528614480000001,0.115526356,0.12515258,0.102635453,0.0564982697,0.00398342557,0.0,0.0,0.0185223944,0.12329243599999999,0.269535643,0.431953661,0.57662126,0.668379297,0.679373852,0.5967023,0.427169965,0.19771068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.521
0.170848077,0.253509718,0.728922124,1.20044053,0.328849473,0.167132725,0.0,0.0,0.0,0.0,0.0,0.0553860767,1.80289686,2.88989376,3.92529138,4.61774457,4.98661343,5.66169863,5.18350724,4.60341526,2.92258281,1.32463991,0.27737084300000003,0.0,0.0,0.0,0.0,0.0,0.0974445865,0.103459439,0.899548653,0.87628914,0.651253958,0.782043438,0.52743689,0.0,0.0,0.0,0.0,0.0,0.09563231890000001,0.216673643,0.616253375,0.8176997779999999,0.7362921109999999,0.645152954,0.116318975,0.0318423278,0.0,0.0,0.0,0.042482527199999995,0.0,1.00390262,1.366184,1.52520457,2.04410227,2.04934709,2.50369469,2.00385456,1.28485255,1.65269766,0.630720407,0.200583861,0.252875898,0.144859164,0.0,0.0,0.11492761300000001,0.0,0.0,0.0391292679,0.0,0.450154723,0.0,0.373120365,0.013209161100000002,0.0,0.148939001,0.313900793,0.243262184,0.12020998,0.160241914,0.65013888,0.0122503098,0.0,0.0,0.28703485100000004,0.0,0.0,0.0,0.0,0.0,0.37945391,0.0,0.573216983,0.510358949,0.386794549,0.40585763,0.0,0.37887442600000004,0.263039553,0.0,0.312310782,0.159863859,0.0,0.401963599,0.0,0.605088893,0.32710021,0.0,0.0,0.04964555440000001,0.0,0.0,0.0,0.0,0.176144918,0.851840963,1.15781633,1.24366958,0.967084556,0.7319665040000001,0.45182313700000004,0.12314556199999999,0.0,0.0,0.558249511,0.655849935,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.449
0.18571479100000002,0.149499171,0.207371145,0.298368051,0.308208624,0.208456528,0.109773215,0.163253475,0.40152133100000004,0.681222221,0.7968800840000001,0.669010973,0.42983301399999996,0.318581808,0.47440052,0.8122927590000001,1.09426362,1.13162757,0.9385152290000001,0.705178291,0.623579032,0.7250025309999999,0.8687367,0.8802843109999999,0.7098370279999999,0.47675333799999997,0.37447753100000003,0.525622138,0.9011009179999999,1.34725105,1.6791808999999998,1.77049354,1.60120904,1.26390404,0.933651583,0.7967493790000001,0.94804021,1.31063993,1.6536836,1.73226345,1.46923784,1.03405063,0.730241438,0.757455296,1.03726386,1.26162709,1.14326827,0.665896348,0.11550503,0.0,0.00801839391,0.371723006,0.56551979,0.37026464299999995,0.0,0.0,0.0,0.30392131899999997,0.9708483109999999,1.32887657,1.19980642,0.730322639,0.238614238,0.0,0.0,0.00439287797,0.0449371004,0.024130765699999997,0.0,0.010907290900000002,0.046854239900000004,0.054238891799999994,0.0169833479,0.0,0.0,0.023080109100000003,0.0569244097,0.032990043399999995,0.0,0.0,0.0,0.039069675,0.0823804605,0.0423227142,0.0,0.0,0.0,0.0515272473,0.10061495,0.047788231699999996,0.0,0.0,0.0,0.0651808642,0.11961158599999999,0.0527087165,0.0,0.0,0.0,0.0828139967,0.14400063,0.0587666221,0.0,0.0,0.0,0.108833021,0.18076033100000002,0.0681509748,0.0,0.0,0.0,0.154232666,0.24785830399999997,0.086538775,0.0,0.0,0.0,0.262630812,0.424624555,0.142362748,0.0,0.0,0.0,1.01148182,2.60536338,3.80826629,4.15424077,3.69800796,2.88627731,2.17743321,1.74238403,1.46507491,1.17260166,0.836076009,0.557291376,0.398655783,0.275198504,0.04929726190000001,0.0,0.0,0.0,0.7451741820000001,1.74425526,2.32151442,2.08920294,1.16328128,0.0972047518,0.0,0.0,0.0,0.313532142,0.30645301199999997,0.0232342268,0.0,0.0,0.0,0.17616847300000002,0.17042212399999998,0.00666298826,0.0,0.0,0.07087878780000001,0.22319788899999998,0.25034632100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.358069783,0.44942719999999997,0.08213498309999999,0.120457341,0.0,0.526026864,0.390156374,0.20158283899999999,0.562616942,0.43260813299999995,0.468240954,0.9956469109999999,0.923978682,1.8563661,1.8502733,2.89833285,2.95681683,3.44873786,3.05443064,2.69609316,2.18813949,1.16692128,1.04135929,0.018122869,0.281711012,0.0511692782,0.0,0.0834786825,0.186895267,0.461244182,0.42840571299999997,0.577381322,0.3307894,0.23710248399999997,0.0,0.438231201,0.0132484512,0.408129941,0.35002711799999997,0.26795562300000003,0.202339753,0.0,0.0,0.0,0.34592836299999996,0.48025207299999995,0.57756244,0.35394909399999996,0.557424245,0.0636189381,0.0,0.10709024,0.0,0.0,0.303058206,0.0,0.0,0.21478998300000002,0.0,0.000251443432,0.0,0.0,0.039128889,0.40732049600000003,1.32986772,1.43520112,1.36282636,1.43155865,0.520998606,0.46608190299999996,0.279199061,0.0,0.0,0.0,0.199795831,0.0,0.263185344,0.32711689,0.131180919,0.0,0.0,0.0,0.0,0.21797217300000002,0.38204196799999995,0.198381964,0.61124036,0.9053951490000001,0.610495844,0.81893685,0.665529272,0.570553644,0.534255776,0.0,0.166498548,0.0,0.08708879679999999,0.449969004,0.774175756,1.29160378,1.13330502,1.86795062,1.74938253,1.08216884,1.0279984,0.752649252,0.408768714,0.021545985400000002,0.0,0.0,0.0,0.150274544,0.0702144054,0.06645664429999999,0.388423807,0.0,0.0,0.02671796,0.0,0.0,0.167242323,0.205111757,0.175933743,0.0,0.201388221,0.29322682899999997,0.0,0.0,0.0,0.454565534,0.505728367,0.0,0.336815101,0.0,0.0,0.0,0.0,0.38723564,0.0,0.486372371,0.35564045299999997,0.42538320399999996,0.336757872,0.457677224,0.460280595,0.41968320200000003,0.531831929,1.07367726,1.12363155,1.28344615,0.9097423040000001,0.284372463,0.691653085,0.255003717,0.08329309879999999,0.13644547,0.578803506,0.45307804100000004,0.831592069,1.29904832,0.85969213,0.8674416559999999,0.45464308,0.311667376,0.572029268,0.23931131100000003,0.641299607,0.0,0.39501273200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.33059627199999997,0.147251983,0.0,0.318513528,0.23154473,0.23903218,0.40201201200000003,0.0573988023,0.103026655,0.0,0.211827536,0.004577250729999999,0.0,0.0,0.142592998,0.0,0.0694969842,0.47873444200000004,0.0524921509,0.0,0.288518397,0.0,0.0,0.0,0.408557081,0.35913607399999997,0.486098097,0.307523986,0.015193135900000002,0.0,0.0746425189,0.08934165529999999,0.0,0.0,0.0219222227,0.0,0.0,0.272508291,0.109646856,0.0,0.0,0.0,0.0,0.07321768570000001,0.0651176808,0.0,0.17709360600000001,0.375949111,0.144337299,0.026904222599999996,0.0,0.0879921022,0.0,0.0,0.153113479,0.238345222,0.33478383100000003,0.00301613392,0.24927713699999998,0.0,0.0,0.0,0.0,0.0901533526,0.0,0.109771226,0.314636541,0.378718149,0.380720743,0.1885073,0.130882994,0.0,0.0,0.0,0.10891590300000001,0.312021157,0.334513458,0.647242686,0.92716301,0.726245259,0.889240438,0.8832571029999999,0.7192551759999999,0.811005911,1.25976398,1.91248605,1.99321453,2.22351267,2.44196674,3.04330369,2.96809626,3.0954877,2.72437668,2.3628082999999998,2.27697453,2.33652248,1.77022596,2.00412566,1.67768299,2.05501593,1.8703054000000001,1.88212432,2.04813104,1.81856734,1.84799438,2.04253121,1.97762377,1.56021588,1.3739063,0.679870999,0.224003645,0.36614407,0.14641844199999998,0.0,0.0,0.337251404,0.0242357627,0.376618047,0.0,0.28528732,0.0,0.0,0.0,0.0,0.0164769796,0.0,0.581453824,0.8909631140000001,1.37296794,1.34136525,0.9572571129999999,1.20405095,0.838620923,0.49435272799999996,0.00935721694,0.29817883,0.164113693,0.09190683179999999,0.5018283720000001,0.47185105,0.340076545,0.070355616,0.0,0.30515038699999997,0.308842897,0.09919469449999999,0.0633307865,0.300184863,0.523316615,0.166340655,0.0,0.256643095,0.0,0.0,0.278032909,0.753320377,1.17236995,1.4296437,1.87555513,1.88379765,1.56361221,1.6049387,1.00220906,1.18012737,0.826703558,0.9004504390000001,0.605355572,1.08085158,1.00523891,1.5556055,1.44484813,1.54484505,1.60019478,1.05804882,1.04265783,1.29951238,0.8358295,1.24558401,1.31084477,1.20683251,0.633342935,0.824672728,0.572906438,0.281598573,0.0304244737,0.363968532,0.0780937242,0.137529782,0.295329345,0.39203298799999997,0.415692246,0.0,0.137366995,0.0,0.0,0.148887874,0.726207108,1.05939598,1.40657093,1.85250118,1.63851908,1.42144737,1.32851124,0.395228769,0.0,0.0,0.0,0.0,0.0,0.08710350310000001,0.0,0.53298388,0.167610445,0.352097382,0.0,0.12116410300000001,0.045431563,0.315658177,0.41434541399999997,0.41593642700000005,0.709957675,0.601414592,0.50664149,0.380070223,0.00330694357,0.0,0.0,0.0,0.0380479845,0.150726764,0.34318234200000003,0.851880815,0.46484552,0.395394361,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.51486024,1.22434501,2.22473275,3.2868467000000003,4.16736935,4.66458356,4.66458356,4.16736935,3.2868467000000003,2.22473275,1.22434501,0.51486024,0.25881286,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.79949259,0.290914652,0.0,0.889297115,0.0,0.0,0.0,0.0,0.0,0.0,0.020702141,0.24600631,1.65246909,1.42067327,2.47429624,1.70808564,2.44829941,2.68600978,1.39235455,0.991809555,0.1813371,0.18836402600000002,0.0,1.65391205,0.0,0.328823723,0.0,0.0,0.0,2.07404172,0.285575717,0.586205269,0.130177378,0.0,0.78120741,1.61876152,0.0,0.0831322899,0.25768509300000003,0.0882410094,0.638528184,0.0248995319,0.581322921,0.752699805,0.7685625490000001,0.0,0.29171974,0.549617823,0.142677256,0.0,0.7354569940000001,0.138252904,0.804461364,0.0711703349,1.35770953,0.28254886100000004,0.0,0.698146547,0.0,0.427664025,0.0,1.35779161,1.72659766,0.39298809799999995,1.11043287,0.615078545,0.0,1.14429994,0.140118505,0.0,1.91754113,0.0,1.49424382,0.0,0.0,0.0,0.78048337,0.0,0.0,0.0,1.0553651000000002,0.0,0.06656560759999999,0.0,0.39394107799999994,0.134569974,0.0,0.354552651,1.25913319,0.0,0.0,0.584588192,1.23267382,0.8061092059999999,0.0,0.0,0.0,0.0,0.098683542,0.0,0.054729421900000005,0.0,0.41340981,0.918770957,0.161855181,0.0893536326,0.0,0.0,0.0,0.0,0.0,0.299308671,0.10269964,1.34774161,2.22820302,0.7370418440000001,0.0,1.2238672,0.72749791,0.231622038,0.551300389,0.307898528,1.67980722,2.3770992000000004,1.57160328,3.75751923,2.36197532,3.83855355,2.79704737,2.92737763,2.44861665,0.0,0.0,0.0,0.0,0.0,0.007981669129999999,0.689419607,2.99010322,1.05385386,0.497018267,0.0,0.0,0.0,0.0,0.0,0.0,1.32358587,1.83097898,1.04580008,0.0,0.518077294,0.518055771,0.0,0.0,0.0,0.0,0.0,0.0,1.3457712,0.0,0.0,0.36179598,0.0,0.0,0.036989565499999995,0.0,0.0,0.47712088799999997,0.289727998,0.36942192100000004,0.179971085,0.0,1.08110443,0.388159369,0.0,0.476197527,0.181377266,1.0934913,0.371292461,0.08321872599999999,0.0,0.0,0.38918946299999996,0.665456911,0.0,0.0,1.92508216,1.26793149,0.0,0.920890416,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7719266229999999,0.0,0.357159093,0.57771031,0.0,0.0,0.19884013899999997,0.0,0.0,0.0,0.120724846,1.091302,0.571874828,0.0,0.0,0.0,0.0770308178,0.562434326,0.0,1.04026972,0.0,0.0,0.307897385,0.263864227,0.0,0.0,0.0,0.0,0.772436392,0.743278165,0.61793753,0.875049344,3.12530822,1.90555903,1.81950219,1.25033129,2.3306161,0.24958104399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
3.06016361,2.47253648,4.27039153,3.09146354,2.85116837,4.08360723,2.88287749,1.79379959,0.7569201659999999,1.88691102,1.57255863,1.11132624,0.0,0.0,0.21901510600000001,0.0,0.702856316,0.121332044,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.478065664,0.0,0.7334083090000001,1.69101074,1.01971075,0.95176785,2.03453317,2.44752363,1.42254172,1.9822395000000002,1.87742571,2.27004084,1.46192072,2.48482642,2.55291059,1.61677424,2.47669208,1.49263966,1.65386603,0.66230654,0.780760243,0.880618791,0.0,2.17007964,0.680019778,0.0672786746,0.0,0.297971628,0.156636045,0.0,0.5474185079999999,0.00589697995,0.0,0.6448973139999999,0.0,0.0,0.0,0.0,0.0,0.0,0.17005751600000002,0.993342779,0.22198004300000002,1.57197185,0.0,0.482785654,0.377321959,0.0,0.0,0.842770852,0.009609286429999999,1.07717913,0.39458688399999997,0.0,0.0,0.0,0.0,0.45202010200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.415447402,1.19689136,0.773470509,1.41913243,0.6596059989999999,1.64457395,3.55417283,2.71704721,3.15499773,2.93529962,1.99028851,1.96083814,3.60045458,4.40811595,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
1.27446676,0.057894754900000005,0.0,0.0,0.892595252,0.0,0.731873942,0.0,0.0181948098,0.0,0.199064855,0.0,0.0,1.4266723999999997,0.0,0.0,0.0,0.0,1.02246778,1.44992248,0.565396502,0.587652246,0.21168061600000002,0.7073492229999999,0.77330333,0.166996599,0.229779848,0.0,0.0,0.0,1.41157012,1.29627587,0.0,0.0,1.26177224,0.0,0.0,2.23614454,0.0,0.0,0.0,0.0,0.12176236300000001,0.0,0.0,0.0,0.174553147,0.315051365,0.0,0.0,2.7812146,0.272441477,1.83157022,0.0,0.592024763,0.0,0.0,0.212284043,0.0,2.28344685,0.265974385,0.0,0.0,0.438431161,0.482479119,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.31377945,0.0354651121,0.0,0.0,0.0,1.31540532,0.0,0.13439894,0.570223316,0.0,0.0,0.0,0.0,1.52537763,0.0736984862,0.0,0.0,0.0,0.162438203,1.63130568,0.32247452,0.0,0.257433594,0.923547867,0.0,0.0,0.0,0.73433764,0.980368404,0.0,0.17758869300000002,0.145969151,0.0,0.297171933,0.0,0.0,1.07421159,0.0,0.207456974,1.0466133,1.79134508,0.8640369529999999,1.76977883,0.0,1.83397439,0.346731794,0.7733069509999999,0.0,0.678803507,0.00973467281,0.0,0.0,0.00170200331,0.0,0.0,1.16589486,0.0,0.26597598699999997,0.0,1.67109438,0.572678774,0.0,0.08955280210000001,0.0,0.0,0.0,3.62400862,3.53682793,6.39320994,6.38807678,4.67163189,2.44035277,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
0.475350679,0.0,1.18515571,1.73859345,1.28773146,0.0,0.0,0.08209805070000001,0.276806314,0.8945469770000001,0.0,0.32140439600000004,0.0,1.06046767,0.0,2.08423381,0.0,0.999140978,1.39705211,0.0950267615,1.67381131,0.0,0.0,1.05014021,0.0,0.0603207678,1.82420283,0.538293981,0.6620625720000001,0.7374088520000001,0.0,0.0,0.109873855,0.0,0.184183187,0.940604951,0.89030912,0.773933175,0.0,1.13767672,1.02875614,0.0,0.0,0.0,0.0,0.30510925699999997,0.0,0.0,0.333752587,0.622854361,0.0,0.7926489240000001,0.60170884,0.0,1.30379944,0.574265454,1.08412004,0.0,0.0,0.0,1.34152741,0.276163378,0.14592085400000002,0.0,1.60754266,0.0,0.175428059,0.0,0.262236519,1.10667061,0.0,0.0,0.8770476709999999,0.0,1.45777734,0.0,0.0,0.0428369882,1.42067268,0.1110719,0.0,0.0,0.0197725842,0.036566366499999996,0.629670191,1.00828846,0.0,0.0,1.10132549,0.687676313,5.20271475,3.94571598,3.73376107,6.17510031,3.85062478,2.97637376,2.1465883,2.84312462,0.0,1.57369868,1.38266352,0.348585739,2.20754861,2.08051001,1.10032084,0.0,0.0,0.724960475,0.0,0.583609808,0.0,1.24751321,0.469612168,0.0,1.27565091,0.0627920335,0.5682892079999999,0.973977578,0.297150063,0.65601118,0.0,0.0,0.849876154,0.0,0.0,0.817466933,0.43475856799999996,1.37046387,0.426246046,0.0,0.00871019187,0.26563375,1.76003896,0.25392007,1.09320909,0.0,0.17564814,0.0,0.31052359399999996,0.0,0.0,0.929247547,0.31274144,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.299872958,1.12677676,0.63014596,0.0,0.0,1.16751682,4.89625632,5.73886136,3.90864071,0.559725378,0.0,0.0,0.177486452,0.551196724,0.0,0.0,0.590476322,0.0,0.447797008,0.0,0.299501855,0.0981971539,0.548128415,0.0,0.0,0.567550172,0.0,0.23924922,0.0541960671,0.0,0.0,0.0,0.0,0.8498719570000001,2.00023859,1.84397432,0.0,0.0,0.0,0.532674298,0.324530967,0.0,0.19115899600000003,0.49750409,0.345585735,0.0,0.0,0.0,0.276969118,1.4073561,1.34683084,0.45555148799999995,0.0,0.0,0.230807547,0.5695238029999999,0.7586253159999999,1.18707105,0.898934316,0.25876589899999997,0.0,0.248229229,0.983073098,1.78524136,2.58638469,1.23969077,0.51456159,0.18913470100000002,0.0,0.662785813,0.43486536299999995,0.390909293,0.406808743,0.0,0.24016511899999998,0.5358961529999999,0.280216253,0.18448571600000002,0.0,0.0,0.758507783,0.0335514823,0.0,0.0,0.0434774137,1.30740195,0.424232447,0.7821753920000001,0.211662142,0.42778037799999996,0.516450069,0.0,0.0,0.250745998,2.79944474,3.11466637,1.9251318,0.021735946699999998,0.0,0.0,0.39776904799999996,0.8511521809999999,0.0458057463,0.104236342,0.5842571670000001,0.0,0.0,0.0,0.0,0.513003992,0.0,0.0,0.276647716,0.19324387399999998,0.0,0.7598459759999999,0.0806220077,0.304509111,0.36892995799999995,0.0808572966,0.0,0.40637747799999996,0.0,0.0555402523,0.0,0.130856321,0.0,0.0,0.518761403,0.464458194,0.130234146,0.592841601,0.0,0.781550066,1.58351765,2.00741157,2.07005414,1.37010179,0.276039615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.556788055,0.531725253,1.16468256,3.51815229,2.99537633,2.73960874,0.333145362,0.0,0.0,0.45123379399999997,2.73008085,2.70651286,1.99751093,0.09571407300000001,0.0,0.0,0.0,0.276714508,0.9160057009999999,0.43125048,0.0,0.0,0.0,0.0,0.0,0.0,0.357227247,0.316820589,0.0,0.0,0.735639872,0.0,0.0,0.0,0.0,0.0144830735,1.09257689,0.43093626,0.0799998851,1.55016782,2.65652441,5.41912132,7.97388593,8.81842925,5.41831686,1.82014989,0.0,0.388998676,1.777194,3.86352711,2.53935912,0.659460833,0.8879289440000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46799999999999997
0.9152943259999999,0.0,0.07086381309999999,0.581817306,0.806030852,0.031686469700000004,0.0,0.0,0.23019846100000002,0.0,0.805828698,0.15183896300000002,0.8474532159999999,0.49952121299999996,0.556902577,0.7448338409999999,1.02911352,0.37406690000000004,0.141961177,0.44492954100000004,0.151954504,0.0,1.22075399,0.329801701,1.41427639,1.281255,1.40869638,1.4548534,0.0,0.0694396068,1.39925398,2.11817002,1.4617737,1.31167404,0.0,0.0,0.919638002,0.0860908425,0.874177702,0.0,1.07628683,0.0,0.37134543600000003,0.0,0.0446023672,0.8997176159999999,0.0,0.10463442,0.682812062,1.65742181,1.05212439,1.32356375,0.34320252,0.0,0.550263953,3.02397673,3.0997409,2.18957029,1.31703509,0.0,0.112388686,0.0,2.4820995,1.43424047,0.48374935,0.0,0.19424011,0.0,0.5195838629999999,1.27105213,0.0438221106,0.506967597,0.0,0.448930473,0.0,0.235699167,0.0,0.792339373,0.0438758287,0.0,1.33638061,2.00974533,0.20129943600000003,2.16492093,0.48912617,0.850595277,0.525233862,1.59818976,0.984862672,0.0,0.0,0.601783582,0.0,0.0,0.0,0.41673415,1.14710865,0.0,0.0,0.6161440229999999,0.6324209820000001,0.0,0.131172578,0.433927434,0.0,0.0,0.121869456,0.07268661629999999,0.0,0.0,0.36356203,0.63233251,0.32290102800000003,0.0,0.0,0.0,0.0,0.0,0.562540786,0.35259017,1.84109688,1.41938806,2.14093618,0.0,1.32326237,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.203618653,0.0,0.163292145,0.0,1.20225047,0.034565906699999996,0.027410571,0.0,0.5373524000000001,3.39098275,1.42517201,0.746441659,3.55377332,0.789655648,1.83704488,4.09179467,4.1669321,0.00203908421,0.651239084,0.194409904,1.87340422,2.72158055,1.58956205,1.99474457,1.33277507,0.751315838,0.011525366200000001,0.0325494882,0.0761041875,0.0268740538,0.0,0.0112243399,0.0,0.00307988413,0.0,0.0,0.0370607109,0.151288481,0.0,1.10696982,0.118343514,0.8479706109999999,5.10897167,2.63885506,0.39435266,0.0,0.0709833134,0.0,0.0884833542,0.0,0.104335694,0.0,0.119394506,0.0,1.71746089,1.14480528,0.7298829579999999,0.28037751,0.0,0.0246387431,0.0,0.0,0.0228504288,0.0,0.0451927003,0.0,0.25201806,0.63435304,2.61974174,2.02802339,1.50977418,0.0,0.0,0.021831142799999998,0.00819632767,0.574593001,3.74298295,3.63973153,3.13762746,2.87553601,2.14670081,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.625749025,0.322899851,0.0326043669,0.0,0.56750513,0.0,0.322994203,0.428138225,0.0,0.0,0.0,0.0,0.0,0.28363218,0.0,0.348307384,0.0,0.0359747746,0.31851567199999997,0.0,0.0472833816,0.614840315,0.23941230600000002,0.0,0.0,0.199915696,0.0,0.0,0.0,0.0518122484,0.0,0.061645797,0.0,0.0,0.36649883200000005,0.0,0.0,0.189323968,0.0,0.48860381399999997,0.0,0.07429017730000001,0.0,0.0,0.0734136258,0.106220165,0.0250021071,0.36558151299999997,0.311715829,0.0,0.273398803,0.483106689,0.5274381539999999,0.0,0.261628566,0.08770516880000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.505919394,0.0646169853,0.0,0.046521877,0.6285089739999999,0.06368194690000001,0.18426298600000002,0.0612660777,0.0,0.149408155,0.0,0.0,0.0,0.0,0.0,0.0,0.301111223,0.463839203,0.125100841,0.42822023600000003,0.852126933,0.974771945,0.864672584,0.868163615,0.158311689,0.327140967,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7161954,1.26458573,2.26325142,2.10510368,3.6328324999999997,3.97328981,4.46366459,4.9278492,4.74206693,4.89261248,5.08590678,5.11387243,4.16570227,3.76070263,2.56960377,2.54701051,1.18512239,0.386301137,0.340046192,0.009142532890000001,0.0,0.0,0.0,0.0,0.0332216361,0.0,0.0,0.575732495,0.0,0.158578719,0.604286411,0.9083455340000001,0.6162514579999999,0.205846643,0.0,0.224832957,0.0,0.0,0.0,0.257864673,0.0,0.33988473,0.0,0.404728239,0.155912683,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
0.140728343,0.0,0.297037035,0.0,0.40171555700000006,0.415374719,0.0,0.0,0.0,0.0,0.33740023399999997,0.39419295,0.438499323,0.0,0.156361069,0.333434538,0.202754515,0.242016968,0.0,0.0,0.337749696,0.0,0.0898991524,0.421504139,0.302138904,0.0,0.0,0.0,0.472541906,0.0,0.343627174,0.237803748,0.0,0.0411685756,0.0,0.249237579,0.0504263291,0.0,0.332061544,0.251210193,0.0735300537,0.0,0.0,0.37208469,0.0,0.329163535,0.351790161,0.0,0.43604737600000004,0.143989845,0.19223082800000002,0.0951649094,0.291492982,0.10619574300000001,0.0,0.16909238699999998,0.0,0.0,0.256138495,0.0391514722,0.0,0.446351864,0.139997857,0.0,0.44093243299999996,0.40338984,0.0,0.060686526799999994,0.0,0.0,0.207774844,0.349149584,0.0,0.0,0.11548335900000001,0.46856913899999997,0.11066231800000001,0.0,0.0235429232,0.0,0.32970759,0.0,0.0,0.09383848970000001,0.174586143,0.0,0.439226639,0.18152408899999997,0.0,0.0,0.0,0.0,0.165623224,0.495133079,0.19283046199999998,1.55413157,2.22934799,2.89424451,3.45715597,2.98496059,2.75000287,2.93579985,1.72595213,1.11646248,0.34270625,0.0,0.0,0.0,0.0,0.0,1.19629807,2.46050859,3.28064794,3.85575884,4.62521746,5.09193066,4.91415228,3.48836845,3.34627342,2.54956134,1.09524913,1.25810482,0.834036094,0.670260712,0.5024313189999999,1.07833093,1.46686414,1.55122567,0.9293442479999999,1.24579842,0.6611315,1.20912899,0.15910955300000001,0.0636396477,0.394936423,0.0,0.0,0.0,0.0,0.0,0.487413759,0.204228823,0.0,0.0,0.0,0.0,0.297180383,0.0,0.0,0.16768064300000002,0.226706297,0.0,0.10839106,0.0786254147,0.0326820093,0.0,0.00989325972,0.0,0.0,0.114000688,0.0,0.38804253200000005,0.517343416,0.0,0.0,0.0,0.0,0.377660041,0.0,0.0,0.0,0.312048269,0.0426801616,0.128366907,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0695555582,0.332110714,0.0466401512,0.172402637,0.151937741,0.0378235877,0.0,0.052164167000000004,0.404168476,0.0,0.0,0.470047559,0.284243684,0.380197754,0.0795419924,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.34593273799999996,0.0,0.0,0.30031710699999997,0.41908551200000005,0.028864219500000003,0.0,0.40957551600000003,0.0,0.355981095,0.09545696029999999,0.39481739899999996,0.0,0.0,0.0,0.183249776,0.0,0.053117807999999996,3.94259601,5.58250907,2.11961551,0.0,0.325917846,0.0635864352,0.0,0.0,0.0,0.0,0.0,0.0585785944,0.0,0.0,0.0,0.0,0.458722821,0.08342847070000001,0.0,0.379614286,0.33132868600000004,0.0,0.0,0.76041752,0.0,0.922896032,3.74680133,2.15524782,0.0,0.0,0.25374519,0.0,0.0,0.40097234600000004,0.0,0.23549127600000003,0.39667652,0.430832847,0.0,0.328689809,0.0,0.0,0.463056815,0.41322356200000004,0.447347193,0.0,0.310138167,0.239989111,0.385529831,0.0,0.476318739,0.8474638520000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.865457629,0.0,0.008191893620000001,0.0,1.02334801,1.45069447,0.712677873,0.0,0.0,0.015299641200000002,0.22944304899999998,0.043264864400000005,0.36606421299999997,0.0,0.0,0.0,0.490364536,0.707980471,0.496276349,0.0,0.0,0.0,0.0,0.0,1.56916581,1.6785153999999998,0.598829576,0.0,0.0,0.7800088709999999,0.0,0.0,0.0,0.125283689,1.36329525,0.0,0.21276986399999998,1.28846084,0.0,0.0,0.435123644,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0848531758,0.0,0.104387992,0.571150377,0.8751119140000001,1.30603866,1.95049196,0.647443439,0.97780557,3.90696603,3.25661411,1.13637995,0.0,0.9414591659999999,1.88560893,6.87328927,8.75528594,3.59597363,0.0,0.510533873,0.0,0.312902154,0.529658143,0.0,0.0,0.7585638029999999,0.0,0.0,0.0,0.0,0.26836635600000003,0.0,0.0,0.313252825,0.41324602,0.252186265,2.4862866,1.60834323,0.0,0.250812741,0.7596711070000001,0.0,0.0,0.044192701200000004,0.0,0.0,0.0,0.0,0.28498290000000004,0.7474318040000001,0.36884710200000004,0.030463805299999997,0.397852834,0.45099143399999997,0.460732565,0.0,0.0,0.291040445,0.712615518,0.603259285,0.0,0.163327731,0.0,0.559477698,0.334986055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
2.22474804,0.56623215,9.17873842,16.48825359,6.38865181,0.0,0.17941516,1.27525724,0.0,0.05382455,0.10446319,0.23287029,0.2152982,0.0,1.8003718,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48
0.10902488199999999,0.434865693,0.43272879399999997,1.03508111,0.0,0.0,0.175348472,0.0,0.27634754100000003,0.0448083238,0.0,0.48448852299999995,0.07587069169999999,0.101253952,0.647062785,1.37117647,0.276520417,0.0,0.5618955760000001,1.03154044,0.897611963,0.0,0.68888376,0.112993404,0.0,0.0,0.440034727,0.929367785,1.03583411,0.0121949791,0.0,0.0,0.7203034770000001,0.0,0.0,0.0,1.41172104,1.27797318,3.08892263,1.42226709,2.70980378,0.8833179809999999,1.41533786,0.0,1.29166758,1.5669434,1.44834944,0.0,0.190936805,0.0,0.693534187,0.0,0.161987933,0.9266829190000001,1.5289556999999998,2.46867741,2.67657198,3.44507564,4.43245082,4.00717392,2.16327654,0.0,0.845841092,0.0,0.0,0.0,0.9376127479999999,0.13485211,1.61308521,1.33225238,1.44527656,1.05671299,1.21645567,2.26181415,0.0726917549,0.0,0.76202174,0.0,0.0,0.0,0.12559922099999998,0.0,0.0,1.26514444,0.0,0.794752397,1.01065189,2.16508228,1.68525577,1.27452611,1.10125826,2.85879827,1.32592251,2.38504564,2.02630859,1.67119031,0.9855145940000001,0.7304872179999999,0.335527755,0.169043623,0.18590271,0.0,0.0,0.31324101,0.0,1.32382684,1.03622141,0.278263043,0.0,0.23544403600000002,0.988751275,0.0,0.40159252799999995,0.0,0.21507938699999998,0.895963935,0.909931569,0.0388549558,0.868640622,0.0,0.0,0.0,0.111152525,0.528421216,0.844605818,0.0,0.0,0.0,0.9622527959999999,0.0,0.859083431,0.0,0.103001422,0.5043096020000001,0.39472172899999997,0.0,0.694897627,0.0,0.010751454099999998,0.0,0.308501174,0.0,0.0,1.35895573,0.569045416,0.045630339400000004,0.0,0.0,0.924577095,0.35726442,0.0,0.0,2.00206739,0.0,0.0345011575,0.157428665,0.27961213100000004,0.5139167020000001,0.8991846240000001,0.0,0.0,0.0,0.0731260388,0.11825386800000001,0.0,0.0,0.819726968,0.0,0.0,0.20859011600000002,0.0,0.0,0.0,0.646729395,0.482076327,0.0,0.0,0.0,1.16918892,0.0,0.0603661251,0.0,1.1268096,1.63511293,0.0,1.58507462,0.102780491,1.22728262,0.0,0.0,0.399541274,0.76767408,0.0,0.80680005,0.9971616059999999,1.29972126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.013697783500000001,0.708627309,1.02834979,1.9283279999999998,2.64468106,1.32164397,0.6293792770000001,0.8053151,0.0,0.661137458,0.14807562,4.80158764,1.07939656,3.6259071000000005,0.0,0.43263131899999996,3.16514611,1.90515585,1.88036591,2.23111256,0.417370288,1.75694464,0.0,2.52303223,0.0,0.0,0.222325073,1.36101205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.309010587,0.48392900200000005,0.668145815,0.860144692,1.05828426,1.26081574,1.46590229,1.6716398999999997,1.87607942,2.07724956,2.27318051,2.4619277999999998,2.64159618,2.81036304,2.96650124,3.10840079,3.2345892999999997,3.34375067,3.43474204,3.50660843,3.55859512,3.59015744,3.60096789,3.59092043,3.56013191,3.50894068,3.43790217,3.34778184,3.23954523,3.11434558,2.97350894,2.81851714,2.65098878,2.47265857,2.28535522,2.09097835,1.89147454,1.68881302,1.48496133,1.28186119,1.08140496,0.8854131040000001,0.695612821,0.513618227,0.340912317,0.17883095300000001,0.0285490684,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0126133353,0.07336518110000001,0.12965338,0.18074508600000003,0.22602890899999997,0.265019345,0.297359102,0.322819336,0.34129786,0.352815399,0.357510011,0.355629825,0.34752423600000004,0.333633781,0.314478865,0.29064758,0.262782838,0.23156904899999997,0.197718583,0.161958258,0.125016065,0.08760836710000001,0.0504277613,0.0141318008,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0175622806,0.0336270254,0.0479533575,0.0603489279,0.0706720673,0.0788328493,0.08479307609999999,0.0885652192,0.09021036699999999,0.08983525029999999,0.0875884343,0.0836557784,0.07825528,0.0716314255,0.0640491824,0.0557877667,0.0471343256,0.0383776703,0.029802191800000002,0.021682085499999997,0.014276001699999999,0.00782222434,0.0025344725,0.0,0.0,0.0,0.0,0.0,0.00344794946,0.00970464847,0.0176979176,0.027357620099999997,0.0385891988,0.051277437599999996,0.0652906129,0.0804849237,0.09670908369999999,0.113808956,0.131632112,0.15003218699999998,0.16887293899999997,0.18803188199999998,0.207403413,0.226901346,0.246460774,0.266039223,0.285617037,0.305196995,0.324803143,0.344478874,0.364284275,0.384292807,0.40458739,0.425255971,0.44638668600000003,0.46806272200000004,0.490357009,0.513326871,0.537008768,0.561413275,0.58652043,0.61227558,0.638585865,0.665317443,0.6922935709999999,0.719293623,0.7460531290000001,0.7722648790000001,0.797581133,0.82161694,0.843954568,0.864149,0.881734441,0.89623176,0.9071567629999999,0.914029172,0.9163821809999999,0.913772412,0.9057901190000001,0.892069452,0.87229858,0.846229496,0.8136872940000001,0.7745787270000001,0.728899862,0.67674265,0.618300242,0.553870909,0.483860429,0.408782838,0.329259459,0.24601615300000002,0.159878766,0.0717667759,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.144766192,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
1.14916715,0.11785610099999999,0.444763029,0.0,0.70797293,0.0,0.0,0.0,0.0,0.550565449,0.0,0.458340514,0.341496267,0.0,0.432997714,0.0,0.506937461,0.0118733249,1.03636086,0.464092073,0.0,0.6407316829999999,0.221196169,0.48238208299999996,0.0555175242,0.0,0.818954007,0.886358304,0.494920323,0.314331187,1.25838676,1.41735355,1.27944129,0.911658348,0.92619352,1.75360328,0.994084493,1.13035978,0.819120451,0.46861474700000005,0.0,0.25065985,0.277318216,1.29699179,0.351717269,0.274737707,0.0,0.0,0.613588476,0.0,0.253338601,0.0,0.375284725,0.0,0.0,0.0828442169,0.11162187,1.4062991000000002,0.81569434,0.024961565800000002,0.241182985,0.0,0.0,0.0,0.0,0.752444302,0.0,0.489177817,0.297937428,0.0,0.7854350720000001,0.0,0.474171116,0.321146315,0.36481315799999997,0.21762930100000002,1.12940919,0.194010396,0.0192507029,0.6405214,0.472135774,1.32726312,1.10680482,0.29078590600000004,0.0,0.0,0.0,0.0,0.0,0.7528607979999999,1.12658945,0.166785269,0.518991627,0.275601135,0.429836311,0.0,0.956961101,0.0,0.0,0.0,0.0,0.0,0.820072531,0.637860245,0.0,0.155747623,0.0,0.597612586,0.0,0.0,0.0553642936,0.0,0.0388663314,0.0,0.0,0.0,0.0,0.0,0.0,0.15397042,0.744696667,0.381057307,0.5013115920000001,0.011909711699999999,0.751764482,0.0,0.0338370356,0.0,0.204183742,0.2344833,0.0,0.0,0.0,0.462745264,0.0,0.502283171,0.0,0.0,0.193079212,0.239458791,0.45489697799999995,0.6152707829999999,0.41081350899999997,0.31322884,0.113746686,0.169383001,0.661487643,0.0,0.22936868100000002,0.5532308229999999,0.0,0.048017254,0.7132506759999999,0.0,0.80046859,0.0,0.0,0.0,0.0,0.0,0.680009841,0.33972275700000004,0.0169827689,0.89800708,0.0328787618,0.0540634383,0.38105432,0.0,1.34707602,0.11974840699999999,0.0,0.0,0.0,0.66897637,0.445781427,0.0,0.390573596,0.0,0.16458146099999998,1.08702024,0.0,0.0,0.266010232,0.0,0.0,0.675510658,0.0392206719,0.0,0.11840865699999999,0.620121162,0.5165578,1.61215189,0.0,0.732676832,0.232689605,1.14667829,0.868328179,0.0,0.49506724399999996,0.0,1.20699418,0.0,0.36765982799999997,0.278004431,0.222047123,0.7332126999999999,0.36885244899999997,0.0372644045,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.706300314,0.789979227,0.983123176,0.545729152,1.51916142,0.9975224140000001,2.20930918,2.79079025,2.14904421,2.55939204,3.70536435,3.15989534,2.77867425,2.39068001,2.19666636,0.9006906809999999,1.09369081,0.394800098,0.9836749859999999,0.296273025,0.0,0.0,0.0,0.0,0.93098634,0.48643124600000004,0.551875299,0.806922584,0.688393646,0.266046853,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.402288637,0.67759535,0.921029945,1.2994805,1.23363512,1.59410031,1.97832376,2.4036663,2.00263255,0.644467394,0.27108722,0.0,0.0,0.166534552,0.921827375,0.0,0.0,0.0,0.0,0.588716282,2.28774692,3.27453375,3.61951897,3.07306204,2.17445713,0.9570161770000001,0.332970988,1.05589418,1.21527293,0.7719494790000001,0.09541276439999999,0.0,0.0235431311,0.357333367,0.103443332,1.12791033,1.65018044,2.78097692,3.59274235,3.47120123,3.61441681,2.38735356,1.11126627,1.07635771,1.51415005,3.2129626,4.46184778,4.85366795,3.2175456000000002,2.04328532,0.12263319800000001,0.347890783,0.21753747699999998,1.45670012,0.973500945,0.43446588,0.14956228900000001,0.0,0.0,0.0654240939,0.706319913,0.536061194,0.0,0.0,0.0,0.0,0.0,0.0,0.391076975,0.0,0.0,0.0,0.23643513300000002,0.275500285,0.5457916,0.0,0.0,0.0,0.20899622,0.21695761600000002,0.0,0.0,0.0,0.0,0.0516253877,0.019713052800000002,0.241950955,0.0,0.40249980700000004,0.26134245300000003,0.0375063385,0.0,0.35434975399999996,0.156926898,0.0,0.0,0.200686702,0.258562798,0.0731489869,0.0,0.12442683,0.29627937600000004,0.0783306125,0.0,0.226812087,0.0,0.0,0.0,0.199581256,0.0,0.0,0.0,0.0,0.057997340300000005,0.0,0.140096826,0.0,0.0,0.0650419109,0.273594378,0.0,0.288286778,0.23371072399999998,0.111734292,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.62259776,0.76891297,1.01406193,2.34339281,0.0,1.34659693,0.27534833,0.0,0.13921281,0.0,0.0,0.17267821,0.0,0.0,0.0,0.63644602,2.17280131,1.2010442,3.01580652,3.67461941,2.1576841,4.70374761,6.69612429,4.69829879,4.00682477,4.51380841,1.8033153000000002,1.5229866,1.3262221,0.37054279,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.281948557,0.133761336,0.462963954,0.0034983330100000006,0.11645734699999999,0.14113889400000001,0.452757476,0.19093348300000001,0.31978117300000003,0.323124886,0.7489188379999999,0.985062407,0.9362386709999999,0.9976582490000001,0.646256753,0.678044992,0.470683535,0.0,0.0554713797,0.0,0.18079902899999997,0.21499738300000001,0.125795659,0.124326194,0.47966865399999997,0.0,0.047198904800000004,0.0,0.0,0.0,0.551827706,0.374229386,0.905587088,0.916010147,0.405491351,0.480750436,0.29666240000000005,0.228253218,0.0143223422,0.463689119,0.417641671,0.17122955199999998,0.300775658,0.0,0.0,0.0,0.19069217800000002,0.6020386910000001,1.97503078,2.67692353,3.11453598,3.33781993,2.86839778,2.01157576,0.84572284,0.0,0.0,0.0,0.0,0.288828312,0.0412893433,0.698132125,0.264539155,0.0305241319,0.0,0.0,0.06327899599999999,0.0,0.689152324,0.718249314,1.31106612,1.39509794,1.69952553,1.45466357,0.9070611759999999,0.595830626,0.496424366,0.41439243299999995,0.364379244,0.0,0.34521292,0.299201058,0.0,0.0,0.218909149,0.0,0.0,0.0,0.193642788,0.317121889,0.234928744,0.0188961829,0.0767614575,0.0,0.04508963480000001,0.0,0.0631946288,0.0169245118,0.0,0.266974775,0.0,0.0,0.0,0.009537677159999999,0.0,0.11310101800000001,0.349618673,0.18626111899999998,0.547444051,0.735704012,1.05267261,0.643062118,0.8602330770000001,0.476522218,0.38834081200000004,0.7928395770000001,1.24667432,1.67479733,2.06859087,2.3328869,2.30969305,1.66082829,1.19061791,0.472148054,0.0,0.0,0.0,0.0,0.0875675833,0.403772925,0.57798771,0.0989405833,0.12911283,0.0,0.0,0.0,0.0,0.0384474781,0.301721156,0.548152526,0.0,0.00276591353,0.0,0.0,0.0,0.0,0.108715731,0.5625127870000001,0.241292108,0.0,0.0,0.0,0.0,0.0,0.15787763300000002,0.5336635470000001,0.102210084,0.0,0.13441702,0.0,0.0,0.0,0.297606046,0.24157857300000002,0.0,0.0,0.0513042405,0.17742563,0.0,0.0,0.07234504580000001,0.0,0.24487468699999998,0.539708111,0.0,0.13654625,0.0,0.0,0.0,0.0,0.548797101,0.7173619040000001,0.629043955,0.97028058,0.500389116,0.22066728300000002,0.31041662600000003,0.0,0.042972538,0.0,0.0138250921,0.463229712,0.233002287,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
1.21545736,1.02197932,8.2216532,5.96571899,3.36364692,3.93201656,2.14300746,4.60812696,1.35956056,0.0,0.94858429,0.0,0.0,0.36801090000000003,2.35337654,0.19027457,0.0,0.0,5.29734584,6.48725597,0.91856589,5.72710111,6.770150500000001,1.1740603,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
1.01043264,1.73541944,1.82732231,1.26700768,0.45562663700000006,0.0,0.0,0.0,0.161455275,0.18992840800000002,0.0637252731,0.0,0.0,0.0,0.0414900355,0.0452958371,0.00598630912,0.0,0.0,0.0,0.00967845996,0.00443244841,0.0,0.0042308812,0.00649072422,0.0,0.0,0.0,0.0129133783,0.033757563399999996,0.0179143488,0.0,0.0,0.0,0.048811310999999996,0.07532693809999999,0.0142674967,0.0,0.0,0.0,0.159407184,0.191106083,0.0069862119700000004,0.0,0.0,0.173018941,0.9511164670000001,1.62306759,1.73132048,1.1751011,0.317633671,0.0,0.0,0.0714342409,0.427141434,0.408611779,0.0583866274,0.0,0.0,0.0328099177,0.518928594,1.00876361,1.55184825,2.26433426,3.05052698,3.51744362,3.24736828,2.21199617,0.91144343,0.038581902599999995,0.0,0.277667985,0.47174174799999996,0.15881489,0.0,0.0,0.0,0.854599538,1.34892803,1.02804409,0.287518647,0.07429052309999999,1.04129098,2.86811086,4.39623498,4.51784351,3.07287735,0.981992581,0.0,0.0,0.0,0.709377257,0.8970737870000001,0.6951502540000001,0.664264477,1.11645354,1.76492942,2.00254187,1.50461657,0.557768601,0.0,0.0,0.0669382077,0.44325972399999997,0.43307088,0.0995021806,0.0,0.0,0.120469448,0.277277687,0.130049938,0.0,0.0,0.0,0.238159906,0.34201118399999997,0.0610125733,0.0,0.0,0.10936639199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.16611225300000002,0.626649384,1.16102278,1.74028599,2.33004554,2.89307763,3.39227863,3.79368583,4.06929373,4.19940662,4.17430929,3.99510005,3.67360821,3.23140372,2.69799147,2.1083583999999997,1.5001004,0.9103927490000001,0.373078452,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143007836,0.285898124,0.379875145,0.421170669,0.411964086,0.35951759899999997,0.274869198,0.171251481,0.062423373399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0380120478,0.0624140513,0.0722975859,0.069101152,0.056176275199999993,0.0381046618,0.0198712769,0.006014268079999999,0.0,0.00303896316,0.015089098700000001,0.0336347877,0.0546855051,0.0732756181,0.0842696616,0.0832342492,0.06725304230000001,0.035565249199999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0938613594,0.217439348,0.33534192,0.43327128200000004,0.497686078,0.5174998,0.485657813,0.400405765,0.266085099,0.0933337633,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
0.031012897799999998,0.10220299199999999,0.15660876,0.190222361,0.201643018,0.19202653100000003,0.16477237,0.12499464800000001,0.0788439145,0.032759482400000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0353085563,0.0797564498,0.124588474,0.16526886400000002,0.198045169,0.220358257,0.231092098,0.23063947,0.220781808,0.204403118,0.185076806,0.16657834,0.152384322,0.14521906699999998,0.146703165,0.15714562199999998,0.17550359399999998,0.199513477,0.225976608,0.251164362,0.271293236,0.283012093,0.28384217300000003,0.27251589,0.2491722,0.215383144,0.174006083,0.128876814,0.08437790949999999,0.044931901600000004,0.0144785814,0.0,0.0,0.0,0.0210760433,0.0514196705,0.0869565207,0.122952174,0.154567697,0.177441992,0.188232559,0.18504929899999997,0.167726624,0.137896409,0.098846509,0.055174094699999995,0.0122673847,0.0,0.0,0.0,0.0,0.0,0.0118626139,0.0626271379,0.118449116,0.17230450100000003,0.21684085399999997,0.245231566,0.252022375,0.233872713,0.19010113,0.12296111300000001,0.0375997726,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.108892203,0.24124712899999998,0.355630492,0.438273951,0.478083178,0.46819259700000004,0.407230605,0.300145669,0.158477004,2.7544986599999996e-16,0.0,0.0,0.0,0.0,0.0,0.11707710800000001,0.531905261,1.08843112,1.77671179,2.57609665,3.45594626,4.37719341,5.29465473,6.15993369,6.92470069,7.54409749,7.97999631,8.20384958,8.19889502,7.96152984,7.50173398,6.84249891,6.01830003,5.07272915,4.05547244,3.01887296,2.01434958,1.08895409,0.282334415,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21976066600000002,0.445638737,0.605515551,0.6945624090000001,0.7157342990000001,0.678710149,0.598288521,0.492417093,0.38006036600000004,0.27911608,0.20457710699999998,0.167103754,0.172125179,0.219532648,0.30396737100000004,0.415647466,0.541627682,0.667346698,0.7782933259999999,0.861616831,0.907517751,0.9102826470000001,0.86886596,0.786970397,0.672629068,0.537342675,0.39486862100000003,0.259791714,0.146025267,0.0653952508,0.0264486805,0.033602209,0.0867106158,0.18109153600000003,0.30799672300000003,0.455476045,0.609542658,0.7555198870000001,0.879434935,0.969322806,1.01631563,1.01541651,0.9658901609999999,0.871242003,0.738798086,0.578937123,0.404058419,0.227392985,0.0617772325,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.479
0.034957927,0.0,0.115596967,0.09915547400000001,0.306191076,0.360927548,0.426646694,0.8698859809999999,0.7733329109999999,0.7143635690000001,1.08951521,0.62856109,0.169879573,0.507352327,0.356917063,0.127197241,0.398485925,0.217602505,0.0182250132,0.218699731,0.0420315774,0.0,0.100609335,5.49823852e-16,0.0,0.356966192,0.6849224359999999,0.244462583,1.07194477,3.79201049,4.85170542,3.2000522,1.70622376,0.76841749,0.08405269800000001,0.381318185,0.261774179,0.0691743389,1.39059329,1.69027261,0.41594998,0.180951864,0.0250911144,0.09907838880000001,1.89359459,2.04416353,6.46851591e-17,0.0,0.433837046,0.0,0.0,0.17114231,0.0,0.0,0.0167780647,0.008502084009999999,0.00583085694,0.0,0.105379368,0.0,0.0,0.598565627,0.540444819,0.146931335,1.68773544,2.233518,0.22604370699999998,0.0,0.309170404,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
2.3666015,3.23710079,3.27671857,0.79751045,0.0,0.0,0.0,0.0,0.0,0.20200158,0.0,0.251161672,0.61012753,0.0,0.25656451,0.0,0.7557453740000001,0.0,0.0,0.0,1.37865491,0.0,0.0,0.32365976,0.854256916,1.98984821,0.0399685794,0.0,2.10662302,0.0,0.257345819,0.342399144,0.0,0.0,0.472075617,0.260501949,0.7389852640000001,0.0,0.0,0.224505197,0.0,0.0,0.146704411,1.0629514,3.67958672,3.24582274,1.14502035,0.6129955579999999,0.301967182,0.0,0.0,1.11536426,0.907447082,0.0,1.43136297,1.26764262,0.73408789,0.0,0.0,0.509179212,0.42737957,0.0,0.0,0.0,0.483629844,1.23836873,1.53970068,0.0,0.509263162,1.47759019,1.71869342,0.0,0.0,0.7552387759999999,0.0,1.83662254,0.0,0.0,1.30275169,1.21938419,1.13073432,0.753284342,0.515552391,0.450875885,0.0,0.0,0.043418208099999994,0.742436911,0.34266989,0.0,0.0,0.0,0.146437223,1.07610455,0.0,1.50202261,0.724141485,0.506870925,0.0,0.225109842,0.514224114,2.06885789,0.477926881,0.0,2.54782863,1.92118834,3.23808711,0.0,0.27896603600000003,0.0,0.9376391909999999,0.131373587,0.0,0.460388741,2.55674456,0.0,0.0,0.0,0.19257512100000002,2.77739093,2.10006373,2.05061734,0.0,0.123674736,0.28821155,0.0,0.77838152,0.0,0.5267615720000001,1.30485318,0.40876637600000004,0.0,0.0,0.0,0.0,0.137387454,0.19478805800000001,1.41658875,0.0,1.23908556,0.0,0.0,0.0,1.04372764,0.41883496299999995,0.859548645,0.102898256,0.826788454,0.0,0.222721686,0.132239828,0.806956056,1.85580951,0.0,0.7807449409999999,0.9056263790000001,0.0,0.11247651300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
2.25967712,4.10715623,5.8518696,6.5626841,5.67235861,3.43953985,0.870213923,0.0,0.0,0.0,0.429306449,0.823516755,0.47022198,0.0,0.0,0.0,0.07307988900000001,0.45353540299999995,0.40329206799999995,0.0152035124,0.0,0.0,0.0,0.25751509300000003,0.341641662,0.12308611900000001,0.0,0.0,0.0,0.13292057,0.32192940600000003,0.273113521,0.0618955681,0.0,0.0,0.0166693427,0.145035309,0.13998106,0.0106689851,0.0,0.0,0.0,0.0917018183,0.126625241,0.048854082800000004,0.0,0.0,0.0,0.0395978051,0.0923077059,0.0600506749,0.0,0.0,0.0,0.00446380489,0.0521023465,0.048049180700000006,0.00495222922,0.0,0.0,0.0,0.0164230065,0.0186749104,0.00538586493,0.0,0.0007694844620000001,0.00454866754,0.0,0.0,0.0,0.0085313053,0.049197537,0.0536369142,0.0,0.0,0.0,0.0,0.19189968100000002,0.457791785,0.692235332,0.876331717,1.06931066,1.34320906,1.68878484,1.97860503,2.03257367,1.74561607,1.17931185,0.54112621,0.0613513117,0.0,0.0,4.892534470000001e-15,0.07039213849999999,0.0584755666,0.00789962013,0.0,0.0,0.0,0.0,0.0,0.0,0.014422166100000001,0.0393786931,0.029979517799999997,0.0,0.0,0.0,0.0105112569,0.0761707887,0.07814504650000001,0.00336508059,0.0,0.0,0.0,0.09007691179999999,0.131993955,0.052230367300000004,0.0,0.0,0.0,0.0749259607,0.18137329,0.126188729,0.0,0.0,0.0,0.0237005739,0.215795775,0.22234937800000001,0.0182945108,0.0,0.0,0.0,0.234538838,0.38443255200000004,0.24422058800000002,0.0,0.0,0.006570604690000001,0.43828558100000004,0.757348624,0.68027709,0.261678937,0.0,0.0,0.552493013,1.25220308,1.53320064,1.19090044,0.588652458,0.421580423,1.15498118,2.58606022,3.91757257,4.33432326,3.65097225,2.50652905,1.91551879,2.49457873,3.95748117,5.28068162,5.42776493,4.09024294,1.89524327,0.0,0.0,0.0,0.250754755,1.02883167,1.38975777,1.48153547,1.60976209,1.86797899,2.04382014,1.85339756,1.25068122,0.506964312,0.0,0.0,0.0,0.154690877,0.386843634,0.9851728190000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.488658335,1.12608325,3.36887198,0.559517722,2.30746564,0.0,1.10773092,0.9839648870000001,0.788044925,0.0,0.575628206,0.480477511,2.40903944,2.03390316,2.16394305,2.03788034,1.65312253,2.90557311,1.10245422,1.83341682,0.15082815800000002,0.0,0.0,1.2156394,1.41658934,0.571298043,0.30988861,1.24765759,0.0,0.927066979,0.0,0.9473140999999999,0.0,1.20406582,0.0,0.21841271,0.0,0.0,0.62133516,0.015943709599999998,2.35101557,1.17228053,1.44759017,0.941359775,0.0725851341,1.75867563,2.22461828,0.0,0.0,0.0,0.0,0.536084779,0.376830075,0.0,0.442673682,0.29607703399999996,0.0,1.25169803,0.0,0.0,0.781878388,0.0,0.9821109490000001,2.42128984,1.04838226,2.23499523,2.10433327,3.13715172,2.7647629,3.82230474,3.34382636,4.93117865,3.93712114,2.70973623,4.44343926,2.5687306,1.95538926,1.62966371,0.0,0.17469859699999998,0.229484226,0.0,0.0,1.3029068000000001,0.0,0.264765517,0.20576813600000002,0.0,0.0,0.0,0.8221060509999999,0.00582628166,0.8306495159999999,0.0,1.02670963,0.0,0.0,0.64122238,0.50534351,0.0,0.443796185,0.0,0.0,0.0503667352,1.40451426,0.0,2.17755251,0.0,0.334506106,0.0,0.0,0.8886731929999999,0.0,0.160228045,0.567061543,0.0296197244,0.0,0.0,0.0,0.056190628799999996,0.0,0.9205322770000001,0.556446669,0.581283985,0.0,0.0,1.51124556,0.615751657,0.28157099,0.0,0.0,0.792108659,0.264675497,0.536339162,0.517694464,1.85297042,0.7652388790000001,0.0,0.6505437079999999,1.56671008,1.45213246,0.0,0.31913719399999996,0.0,0.23363784,0.0,0.59112256,1.55078817,1.43586575,0.632184362,0.0,0.0,0.00123079956,0.897073516,0.0,0.016160268000000002,0.0,0.0,0.274358416,0.0,1.31372607,0.0,0.0,0.7579108809999999,0.0,0.671560189,0.0,0.56719416,0.0,0.8270066229999999,0.113938286,0.562962893,0.0,0.0,1.02401928,0.0,0.8686978540000001,0.0,1.30559295,0.0,0.559815956,0.258995397,0.0,0.37944333799999996,0.0,0.359213105,1.38083028,0.0,0.0,0.6242775429999999,0.635936139,0.0298999643,0.0,1.69889978,0.760009455,0.0,0.333140245,0.0,0.0,0.0,0.5389143789999999,0.0,0.9345435990000001,0.0,1.08083322,0.0,0.599104081,0.0,0.0,0.64489254,0.0,0.0,0.520168173,0.40454855100000003,0.6192011860000001,1.26280402,0.554529901,0.051060252599999995,0.969605555,0.0,0.0,0.0278422128,0.622165965,0.60919504,1.76058149,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
1.37550006,2.87828458,3.82050696,3.80331625,3.01959206,2.07795874,1.53492897,1.50404104,1.63901859,1.48036213,0.864818695,0.0605941642,0.0,0.0,0.0,0.335858066,0.36304343899999997,0.0488565596,0.0,0.0,0.0,0.27206199999999997,0.330250989,0.0617297474,0.0,0.0,0.0,0.328722141,0.489519789,0.24535434600000003,0.0,0.0,0.12357418699999999,1.02023577,1.89140949,2.26591223,2.0594443,1.65304497,1.60986692,2.25099234,3.41142359,4.54420074,5.07310848,4.72969254,3.66007254,2.28064212,1.02875178,0.178203571,0.0,0.0,0.0,0.0991841932,0.143617104,0.0524324388,0.0,0.0,0.0,0.084270181,0.148695139,0.06580898240000001,0.0,0.0,0.0,0.109687281,0.21243672600000002,0.104930875,0.0,0.0,0.0,0.163870953,0.347829425,0.188298322,0.0,0.0,0.168109282,1.45738567,3.04140498,4.2110768,4.52616852,4.13721326,3.63883474,3.56146842,3.91896417,4.19373023,3.77902743,2.51305107,0.859662906,0.0,0.0,0.0,0.217299661,0.49594892100000004,0.278132859,0.0,0.0,0.0,0.107619053,0.29096952,0.182214192,0.0,0.0,0.0,0.0668924596,0.207952028,0.140081811,0.0,0.0,0.0,0.0430863637,0.151803481,0.10450019699999999,0.0,0.0,0.0,0.162512421,0.24212678699999998,0.14927981699999998,0.0,0.0,0.0,0.16220087800000002,0.278083878,0.190658288,0.0,0.0,0.0,0.0264039861,0.182007103,0.151199216,0.0,0.0,0.055861166600000005,0.437539694,0.768205492,0.776582412,0.43289621799999994,0.0,0.0,0.0137049668,0.35984399100000003,0.46915045899999996,0.14813441800000002,0.0,0.0,0.04319902900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.0199236439,0.062242858600000006,0.0949398646,0.11374233,0.116630532,0.103965001,0.0782854312,0.0438237671,0.00581226637,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0192046451,0.0428493353,0.0589344158,0.06561624469999999,0.0625052763,0.0506373304,0.0322419524,0.0103522897,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.006431765779999999,0.0213992552,0.0322962145,0.0378280139,0.037564572000000004,0.0319447753,0.022152736099999997,0.0098927358,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00072674825,0.00966112214,0.016965736000000002,0.0219586108,0.0243782435,0.024366615600000002,0.0223885938,0.0191077667,0.0152445731,0.0114435248,0.008172497459999999,0.00566937745,0.00394137231,0.00281190422,0.00200112598,0.00122030226,0.000258566276,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0015318752300000002,0.0038602400700000006,0.00554835029,0.0061959497700000005,0.005637645479999999,0.0040430907,0.00196403526,0.000310621857,0.000250820804,0.00304067922,0.00980680883,0.0213137925,0.0377557567,0.058611696799999995,0.0825976724,0.107736245,0.131546147,0.151335655,0.164564613,0.169225524,0.164186414,0.14943895699999998,0.126205164,0.0968739743,0.0647629568,0.0337268678,0.00765989715,0.0,0.0,0.0,0.0039118806599999995,0.029032528,0.059770931799999996,0.0918266407,0.120673875,0.142257412,0.153662335,0.15365562800000002,0.14301007300000002,0.124547428,0.102875415,0.0838365722,0.073730571,0.0784086817,0.102363945,0.14794889,0.21484224300000002,0.2998575,0.39714255,0.49876638,0.595633266,0.6786147779999999,0.739752747,0.773368099,0.7769147959999999,0.751445405,0.701602545,0.635112727,0.56182798,0.49242670899999996,0.43693906,0.403295568,0.396105363,0.415849344,0.458626162,0.516519635,0.578574135,0.6322798270000001,0.665394112,0.667869713,0.633632038,0.5619537520000001,0.458213648,0.333896118,0.20577896199999998,0.0943597786,0.0216718284,0.00872584669,0.0728732803,0.225410265,0.469726201,0.8002467609999999,1.20233432,1.65319921,2.12375593,2.58124445,2.99234174,3.3264254,3.5586273999999998,3.67233516,3.66085765,3.52806825,3.28795347,2.96312143,2.58244304,2.17809597,1.78234592,1.42442415,1.12784137,0.908419729,0.7732338059999999,0.7205405890000001,0.7406609009999999,0.8176652609999999,0.931629147,1.06116604,1.18592764,1.28878031,1.3574211999999999,1.38527901,1.37164087,1.32104651,1.24208013,1.1457587,1.04375483,0.946698825,0.8627790059999999,0.7968064340000001,0.749838097,0.719371778,0.700047451,0.6847244509999999,0.665759119,0.6362891820000001,0.591340124,0.528602838,0.448785095,0.355503777,0.254750997,0.15402592199999998,0.0612676571,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.308541063,0.000194668601,0.157668634,0.400609518,0.509852816,0.0,0.0,0.462047965,0.416482484,0.19730527,0.0,0.0,0.558024053,0.8496183009999999,0.90701898,1.35697962,0.8058436240000001,0.85214789,1.01662489,0.46768902,0.534855722,0.0186782676,0.35502004299999995,0.0,0.38235395200000005,0.0,0.0,0.0,0.309029951,0.0,0.0,0.0,0.0,0.8286538790000001,1.24965047,2.04670226,3.39067882,4.4960402,4.6969762,4.52771547,4.91668589,3.86059443,3.62852094,2.47370519,2.18644948,0.919327753,1.39630238,0.553297695,0.501655747,1.02442003,0.0888251353,0.538081889,0.0,0.0,0.0,0.264822221,0.162632496,0.24700673399999998,0.0,0.0,0.601071365,0.0,0.0931750565,0.37752551799999995,0.0,0.0,0.270006698,0.22419909300000002,0.16600569099999998,0.0,0.0198265901,0.0528154109,0.469515513,0.190436895,0.278185337,0.0,0.37024881299999995,0.0,0.0,0.0,0.0,0.289635119,0.0,0.19411725,0.0,0.0,0.0,0.0,0.0,0.49701579,0.52378255,0.0,0.37787309399999996,0.26758417,0.12076489,0.0,0.0,0.34988503200000004,0.587849575,0.318575908,0.137305202,0.45230082899999996,0.8476050890000001,0.265236427,0.362561681,0.34864400799999995,0.0,0.0,0.0,0.296915416,0.0,0.0,0.0,0.121009065,0.0,0.426084743,0.0,0.0,0.10980739800000001,0.0,0.0,0.18849623699999998,0.108097791,0.437950069,0.19338445899999998,0.0,0.0,0.275329349,0.157488882,0.0,0.33631675299999997,0.413947038,0.39843729899999997,0.017076336799999998,0.377647315,0.0,0.19283676100000002,0.0729194169,0.303029709,0.434431878,0.0,0.133072139,0.0,0.162975345,0.0,0.0,0.0,0.437331773,0.464297275,0.09200158,0.466981747,0.408571777,0.187102915,0.0,0.22354095699999998,0.110908613,0.331492515,0.0,0.0299072848,0.110374068,0.431185369,0.39240076,0.437247483,0.512586482,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.0976943194,0.23473264800000002,0.242687349,0.144440485,0.0698819963,0.113744529,0.24158700100000002,0.329039026,0.287043041,0.145763223,0.0170289811,0.0,0.006282303120000001,0.010517187800000001,0.0,0.0,0.0,0.107001264,0.212435951,0.105701986,0.0,0.0,0.0,0.629976334,1.89400477,2.97705297,3.2905227999999997,2.64440179,1.39579686,0.229415127,0.0,0.0134695216,0.759026845,1.42783271,1.64282126,1.36818387,0.841176501,0.35441175799999997,0.0704459915,0.0,0.0,0.00234802467,0.0030481625,0.0,0.000651453616,0.00441229424,0.0035647567100000003,0.0,0.0,0.000465459155,0.0,0.0,0.0,0.0,0.0141993537,0.0181214593,0.00140459187,0.0,0.0,0.0,0.0343101035,0.0453727208,0.009277613359999999,0.0,0.0,0.0,0.059110166,0.08843977189999999,0.028689614900000004,0.0,0.0,0.0,0.117504715,0.26094120600000004,0.291927522,0.254595588,0.31318607,0.615213282,1.13666696,1.64931622,1.85794572,1.61116767,1.01911563,0.38095434,0.0,0.0,0.019354065400000002,0.137937481,0.14124825400000002,0.0567593992,0.0,0.0,0.0,0.0,0.0,0.0,0.013472001200000002,0.0737024946,0.0727124393,0.0,0.0,0.0,0.218280823,0.655644812,1.00788571,1.05692622,0.772275959,0.34066604799999994,0.0243983948,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.290047785,0.545623884,0.599572322,0.561347087,0.251767352,0.243418443,0.3401854,0.0,0.0,0.0,0.0,0.0,0.308885426,0.0,0.0,0.0,0.0,0.295779045,0.0,0.0,0.10671289099999999,0.0,0.0,0.0,0.0,0.0897007058,0.00619863341,0.0,0.0,0.11234975,0.0,0.341275038,0.19033708800000002,0.165167526,0.213217607,0.0,0.060901043499999995,0.345486942,0.272296921,0.44216398100000004,0.0,0.463717965,0.5636272520000001,1.12933825,1.82193277,2.25779699,2.82915401,2.4873106,2.17622279,1.12020804,0.755501742,0.32566597199999997,0.270365375,0.430515989,0.455117704,0.676548037,0.245111055,0.201957327,0.0,0.0,0.0,0.015391503300000001,0.47236634899999996,0.124405208,0.398017384,0.335013701,0.160430731,0.0,0.7478728370000001,2.0283946,2.70376959,3.44969324,3.24023515,2.91879033,1.92352116,1.24608063,0.0147878098,0.263661672,0.0597258088,0.16556854099999999,0.0,0.0,0.0391029013,0.132233668,0.116703766,0.337730808,0.511646419,0.48514453,0.0,0.15898625,0.0,0.0431297125,1.07899313,1.53033803,2.03779996,2.20299774,1.88886807,0.8370427509999999,0.24856695199999998,0.0907029065,0.0,0.26110560899999996,0.151856283,0.750805955,0.289724934,0.46505763,0.126515218,0.363048207,0.33589519,0.13610845400000002,0.0827391822,0.38010954,0.566326146,0.409887546,0.22811308100000002,0.560304172,0.718046387,0.799032045,0.8256340670000001,0.36509752100000004,0.0116342898,0.08687900259999999,0.33484506199999997,0.108046965,0.543465414,0.455629168,0.31454650300000003,0.484825842,0.0866086414,0.784925622,0.455355716,0.740788155,0.377508971,0.312663678,0.286014571,0.48342131299999996,0.34325472100000004,0.159333414,0.153756324,0.23260533100000003,0.0841642524,0.23679697,0.0,0.141685675,0.07731143780000001,0.0,0.32079638899999996,0.0,0.0,0.169504513,0.0,0.0,0.0,0.0,0.0,0.0452554139,0.0,0.0,0.141358146,0.0,0.186667279,0.033405973900000004,0.144342368,0.0,0.0448467471,0.156351655,0.0,0.0,0.0,0.0,0.0,0.304200602,0.0,0.14570118599999998,0.0792515933,0.036459786800000005,0.15382126,0.0,0.0,0.305885435,0.23670444899999998,0.0,0.0,0.13106495,0.0827673362,0.0,0.0,0.012885573899999999,0.0,0.0366000777,0.0,0.0,0.0,0.233793307,0.0,0.0,0.0,0.203888887,0.18734656600000002,0.0,0.290486116,0.00561033819,0.0,0.0,0.279495678,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
6.29884079,0.0,0.0,1.94389184,0.0,0.0,2.3904918,3.44410351,1.56848213,0.5755030560000001,0.229421094,0.18834789600000001,1.00063516,0.9634038359999999,0.0,1.62603504e-16,0.301538584,0.0,0.0,0.361282944,0.0,0.0,0.364830204,0.0,0.0,0.322479805,0.185975948,0.0,0.38004886600000004,0.933890642,0.0,0.0,0.574112318,0.0,0.0,1.11775313,0.0,0.0,8.15608734,13.7992984,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.271322815,0.0,0.22163112100000001,0.009853773140000001,0.0460788861,0.372716505,0.0248737381,0.034871515,0.0,0.06328368940000001,0.0,0.523298932,0.0966584002,0.00616393576,0.0570240977,1.24153635,1.00744782,1.66432562,1.0860771999999999,3.57687592,1.84357762,0.590590055,0.0,0.706285277,0.8765726009999999,0.6068835539999999,1.41187228,0.09759474259999999,0.0,0.874329118,1.25795375,1.31464727,1.45034334,0.0,0.238418347,0.504279275,0.0,1.35224762,4.69226357,7.65558581,9.34511234,1.04650931,0.184843664,0.176397415,0.480604959,0.0,0.242721137,0.0,0.182263809,0.0,0.140682381,0.0,0.0989170981,0.0,0.0208716676,0.395146961,1.34220264,0.690856336,2.29166703,0.0951139584,0.045566172099999996,0.0,0.0701783923,0.0,0.0637504568,0.0,0.0529364237,0.0,0.0392145423,0.0,0.134869093,0.201003443,0.21072054699999998,0.06765886230000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
1.66476661,1.85109582,2.0402506999999996,2.229409,2.41557708,2.59565001,2.7664767000000006,2.92492857,3.06797002,3.19272904,3.29656599,3.37713888,3.43246335,3.46096567,3.46152734,3.4335199,3.37682908,3.29186723,3.17957389,3.04140395,2.87930389,2.69567626,2.49333344,2.27544151,2.04545566,1.80704874,1.56403457,1.32028787,1.07966297,0.8459130570000001,0.622612036,0.413080981,0.220320829,0.046953019400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.56703087e-16,0.11672404199999999,0.236092585,0.355245375,0.471471246,0.582263306,0.685367035,0.7788202909999999,0.860984497,0.930566529,0.98663109,1.02860362,1.05626409,1.06973213,1.06944446,1.0561253000000002,1.0307511,0.994510763,0.9487625390000001,0.8949890770000001,0.8347518890000001,0.7696465259999999,0.70125968,0.631129297,0.560708662,0.491335236,0.424204866,0.360351772,0.30063454300000003,0.245728173,0.196121963,0.15212299199999998,0.113864644,0.0813196027,0.054316593600000004,0.0325600727,0.0156520379,0.0031150987899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,9.75471729e-17,0.0022008798600000002,0.00384562828,0.0048931936700000005,0.00535598182,0.005290632579999999,0.00478784339,0.00396174896,0.00293935015,0.0018504503699999998,0.000818507221,0.0,0.0,0.0,0.0,0.0,0.000287579018,0.00133450301,0.0026002381100000004,0.0039970338700000005,0.00542555814,0.0067811478799999995,0.00796022499,0.00886654103,0.0094169341,0.0095463145,0.00921164004,0.008394696529999999,0.00710355965,0.00537267975,0.00326159756,0.000852363447,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0035465151200000005,0.0070283820499999995,0.0102958132,0.0132055105,0.0156271445,0.0174493474,0.0185849453,0.018975185500000002,0.0185927559,0.0174434464,0.0155663558,0.0130326169,0.00994267127,0.00642219465,0.0026168324300000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00228874339,0.0054729629099999995,0.00822073061,0.0103994322,0.011908506200000002,0.0126865551,0.012716978700000001,0.0120318079,0.0107134847,0.00889440806,0.006754151440000001,0.0045143558000000006,0.00243139668,0.000787024331,0.0,0.0,0.00144156971,0.0044631016999999995,0.009286941690000002,0.0160838806,0.0249617268,0.0359557934,0.0490218199,0.06403178450000001,0.0807729709,0.0989505556,0.118193854,0.138066241,0.158078605,0.177706093,0.196407705,0.21364823,0.228921857,0.241776703,0.25183944199999997,0.25883913,0.262629337,0.263207668,0.26073182300000003,0.255531383,0.24811465,0.239169944,0.229560958,0.22031593300000002,0.212610573,0.207744878,0.207114214,0.212175193,0.22440709,0.245269719,0.276158847,0.318360345,0.373004359,0.441020882,0.523098071,0.619644686,0.73075792,0.856197812,0.995369281,1.14731263,1.31070316,1.48386033,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.0565639518,0.34705034,0.0,0.0,0.38916759700000003,0.0,0.37721082200000006,0.6620877589999999,1.37182688,1.2442911,0.526026209,1.23277778,2.51906339,2.92349196,1.17151151,1.53639007,0.582979977,0.0,0.0,0.0,0.0,0.0,0.0,0.289854249,0.496053349,0.383712025,0.061013722699999995,0.196627735,0.372586934,0.0,0.0,0.402384914,0.0,0.0,0.0,0.0374818393,0.808039362,0.0144684651,0.113604228,1.12039157,3.25269229,6.24172,7.8753922,8.94628792,6.98331811,3.24202556,0.0,0.0,0.0,0.424306045,1.17441052,0.942212852,0.951826046,0.673135045,0.0,0.536128488,0.0,0.803508714,0.212564675,0.018584119399999998,0.0,0.425109412,0.600155674,0.0,0.40897173600000003,0.0,0.336276969,0.0,0.156984221,0.657875891,0.144172241,0.0,0.042966490499999996,0.0,0.108950319,0.11576514199999999,0.5201181260000001,0.546076689,0.279268737,0.0901645928,0.7322729729999999,0.0,0.522150254,0.08242276429999999,0.438201036,0.0,0.710894445,0.19735990399999997,0.43498822,0.0,0.36047790399999996,0.0,0.0,0.702244298,0.0,0.0,0.0,0.0,0.5269138729999999,0.0,0.2595071,0.589891906,0.278154994,0.48262615,0.133976985,0.0,0.38356791700000004,1.09694873,1.68890252,2.18619355,1.91029587,0.630968038,0.7363548879999999,0.300877147,0.0,0.0,0.0,0.44329352299999997,0.63772192,0.799574795,0.579035769,0.0,0.0,0.284433905,0.0,0.0,0.0,0.465057636,0.557286954,0.0,0.0,0.703578684,0.136739156,0.0,0.0,0.0,0.0,0.34588385899999996,0.531158207,0.431546845,0.0,0.563816467,0.0,0.0,0.0,0.542946609,0.07141391030000001,0.0,0.0,0.0,0.0,0.0,0.318844327,0.0,0.8517075620000001,0.7151672659999999,0.18211601600000002,0.43378107,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47200000000000003
0.17402679,0.0,2.45429182,1.88968911,0.0,0.0,0.0,0.0,0.0,0.027780000000000003,1.36976481,0.17611237,0.59940259,1.23708845,0.0,1.06387799,0.41520874,0.26234882,2.20849103,0.0,0.0,0.18356270000000002,0.0,0.0,0.929365,1.10909816,0.16486729,0.0,0.0,0.0,0.0,0.0,0.73363744,0.0,1.03724165,0.0,0.23602612,0.16116857,0.0,0.13416494,0.11143983,0.56494304,0.46276644,0.0,0.0,0.0,0.0,2.12404614,2.54290645,3.41007519,5.48366061,5.68911993,4.83125992,1.97320863,2.9841566000000004,2.44251523,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.0287407801,0.0,0.0,0.0609629985,0.0822594698,0.0,0.0,0.0,0.0541339843,0.0556606083,0.0,0.0,0.0,0.0534271333,0.054233590899999996,0.0,0.0,0.0,0.563005651,1.74809579,3.1617476000000004,4.01321738,3.63318495,2.13911939,0.48322930299999994,0.0,0.0,0.468879169,0.5751125970000001,0.154928021,0.0,0.0,0.15814603,0.282947517,0.0605553435,0.0,0.0,0.08408748070000001,0.174470803,0.0177332544,0.0,0.0,0.0859210726,0.13754373,0.0,0.0,0.0,0.09227302539999999,0.11771182,0.0,0.0,0.008171208740000001,0.251252758,0.36112328299999996,0.24985316800000001,0.0711203206,0.0,0.0265166198,0.0313410137,0.0,0.0,0.0,0.0559152886,0.037079158,0.0,0.0,0.0038916225399999995,0.059707030999999994,0.029381458500000002,0.0,0.0,0.012046938500000002,0.0558888644,0.0190119675,0.0,0.0,0.016031331399999998,0.0411688739,0.00743293006,0.0,0.0,0.000270715168,0.0,0.0,0.181432772,0.478668511,0.630920236,0.449396998,0.0692950435,0.0,0.0,0.12104492,0.142278284,0.0,0.0,0.0185183979,0.300265226,0.406124983,0.266841135,0.106871475,0.126968028,0.245823525,0.242885082,0.0846392764,0.0,0.0660788278,0.245229266,0.286736131,0.154526645,0.029463066,0.0409714796,0.0962708963,0.044795624699999995,0.0,0.0,0.029995662000000003,0.12623736800000002,0.0413166112,0.0,0.0,0.0601196542,0.161164371,0.0287179172,0.0,0.0,0.106092755,0.209709195,0.00490735529,0.0,0.0,0.189332802,0.295823375,0.0,0.0,0.0,0.813109634,1.21573948,0.550149945,0.0,0.0,1.84955278,5.01224395,7.04123015,6.614177799999999,4.28619319,1.76904347,0.33583445799999995,0.00680997728,0.0688798076,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.7863209520000001,0.40935723700000004,1.69320109,0.515018513,0.0,0.0109576935,0.0,0.0,0.0,1.69246373,0.12402844,0.59810603,0.0,0.44099559200000005,0.30237736,1.34935431,0.0,1.89223894,0.0,0.0,0.0,0.747259399,0.0,1.5796127,0.413275934,0.0,0.0,0.0,0.0,0.0,0.141609398,0.41351647700000005,0.0,0.0,0.0,0.0647557454,0.5062322429999999,0.0,1.59100844,0.0,0.0,1.00654733,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7900852559999999,0.0,0.184938275,0.0,0.0,0.5931370189999999,0.031381586,0.0721974972,0.36407391100000003,0.304880305,0.147843135,0.310661665,1.01384469,0.0,2.21650565,0.314528266,1.04419772,0.057892232800000006,0.48210554200000005,0.0,0.0148666714,0.0,0.10108116,0.0,0.0,1.53097903,0.489689221,1.03685547,0.190109361,0.0,0.0,0.292187475,1.02081295,0.8343228779999999,0.0,1.18796062,0.47245910700000004,0.0,0.5588269379999999,0.0,0.9530032270000001,0.20441161300000002,0.811587023,0.0,0.0,0.0,1.1990058000000001,0.688214746,0.462758778,0.0,0.0,0.0,0.0,0.279548306,0.0,0.117383925,0.0,0.0,0.216345247,0.284547799,0.96774543,0.904363879,0.519743481,0.356618019,1.13962075,1.95802679,2.96242501,2.80201252,4.89739236,4.98873393,4.1246046000000005,4.90853341,3.51999166,3.37806366,0.0,1.60513323,0.0,0.160143114,0.0,0.0578243189,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.48297998299999995,0.61469658,0.339891286,0.649898626,0.17465792100000002,0.0356149791,0.359934428,0.0,0.209566413,0.129648018,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21311751399999998,0.0,0.38062254799999995,0.256175804,0.415801095,0.480490225,0.5040524710000001,0.45018543299999997,0.187781773,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0162113885,0.0413841351,0.0,0.395951399,0.122859389,0.45942737100000003,0.20052159,0.0356182806,0.0,0.226478665,0.312573489,0.12709994,0.0,0.0,0.0,0.0,0.0222451712,0.0668073448,0.0457855537,0.0,0.23290613699999999,0.239261162,0.398063658,0.287195207,0.201898455,0.0041885273,0.15359415099999998,0.239695766,0.0681338095,0.0,0.0207525425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.244778758,0.531830339,0.372136915,0.688241775,0.201651848,0.611579071,0.146030617,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0374628829,0.0,0.41738368,1.36420931,1.53675106,2.10649584,2.53880897,2.52704166,3.42068517,3.45947342,3.2165525,3.45811442,3.45334357,3.18476641,3.0753012,2.14898129,2.18486566,1.75499878,1.238229,0.7071893020000001,0.27309285899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.336626831,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.15081177,0.0,0.0,0.0,0.0,0.0,0.0,0.450654145,0.011745857,0.10203506,0.216336887,0.272415646,0.29093621199999997,0.0,0.9425387190000001,0.454704816,0.318096502,0.500901458,0.7700700770000001,0.484885426,0.38100749700000003,0.48695582,0.10018051,0.0,0.19737943100000002,0.0,0.0,0.530560688,0.0,0.0,0.77679868,0.760485222,0.853278847,1.62715543,1.18867476,0.826015497,0.0,0.8712025959999999,0.954338417,2.53711719,3.0062832000000004,2.60754868,1.70724893,0.631225285,0.377157461,0.444011028,1.45681061,1.78281579,1.85641909,1.34256946,1.32909869,2.43123018,2.70680878,3.07843819,2.15952989,2.14638732,2.28558407,2.89803642,4.57917749,5.15954706,5.19825715,4.37995588,3.02625185,1.08275349,0.215587328,0.0847721893,0.0,0.0635744899,0.255332014,0.0,0.0,0.163422214,0.61280899,0.21265352699999998,0.485808608,0.323702487,0.0,0.0,0.453871666,0.0,0.05101421,0.0,0.0,0.0,0.46695203799999996,0.339525146,0.0,0.0,0.0,0.0645254401,0.0,0.0,0.0,0.0,0.233715058,0.0,0.0,0.611676266,0.0,0.457896471,0.0,0.0,0.0,0.053784476100000006,0.0,0.0,0.0,0.369923629,0.0,0.0,0.319023179,0.29130669,0.0,0.0,0.34797796700000005,0.0,0.0,0.20739798399999998,0.5862433229999999,0.578268542,0.0,0.431668527,0.0184431677,0.056636184000000006,0.607969202,0.5196212729999999,0.273991871,0.6443560779999999,0.0937803063,0.0,0.0,0.0,0.40810226899999996,0.0,0.6586241389999999,0.0,0.343126572,0.8281778670000001,1.20967647,1.22091428,1.69367895,1.19653772,0.686241408,1.20910591,1.74530212,0.682581048,0.0,0.0,0.20609117300000002,0.17997481399999998,0.0,0.5182240579999999,0.109571195,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.014540773500000001,0.0,0.0430995889,0.0,0.0,0.0,0.0,0.0,0.43569508,0.0,0.7325564459999999,0.0,0.0,0.455231668,0.656720084,0.0,0.0,0.32725978,0.0,0.830489851,0.47653223299999997,0.159036571,0.0,0.0,1.24936098,1.58861864,1.511283,1.14239104,0.0,0.0,0.142264756,0.225367184,0.275247134,0.20276670100000002,0.0,0.0,0.0,0.201069138,1.42743915,0.0,0.0,0.482868531,0.0,0.592430111,0.47511668799999995,1.39383224,0.44055343,0.0,0.377442235,0.179446921,0.226763595,1.25662914,0.0,0.7148066120000001,0.0,0.19066238600000002,1.09792883,0.0,0.0,0.872019592,0.23012904,0.227415478,0.0,0.0,0.0,0.44847352,0.0,0.523086582,0.0,0.24173968399999998,0.549460276,0.0,0.0,0.73765485,0.451748173,1.07796311,0.834737845,0.361466536,0.5459411829999999,0.5145500279999999,0.0,0.0,0.020312718799999997,0.0,0.484357159,0.714627421,0.892957436,1.30440029,0.0,0.366930515,0.794033423,0.534986092,0.343605416,0.0,0.5478603329999999,0.0,1.09418167,3.19392902,3.21961178,2.54625863,1.15342614,0.647286866,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.23018616600000003,0.0414637758,0.648846595,0.22326599,0.0,0.667923049,0.16310160099999998,0.058597714800000006,0.0,0.0,0.08636645470000001,0.0,0.046328191100000006,0.0,0.497778674,0.179786502,0.652782266,0.11002638699999999,1.27417864,1.29765195,1.19048389,1.8393416,1.86746204,1.40508888,1.07629755,0.6410882520000001,0.216345006,0.0,0.0,0.511335937,0.0,0.0,0.0,0.0,0.13481253099999999,0.0,0.027997306200000002,0.0,0.0,0.49228770000000005,0.0,0.0,0.0,0.0,0.391816144,0.242806167,0.0,0.541701686,0.556216959,0.0,0.0,0.27769936,0.10908406,0.359992638,0.0,0.0,0.0,0.0,0.365095784,0.0,0.307915882,0.0,0.187711689,0.43873437,0.0,0.0154602024,0.0923386925,0.15647302,0.0,0.0,0.0,0.0,0.089732205,0.0,0.0,0.0,0.19978463100000002,0.246320132,0.060083743200000005,0.254262005,0.0,0.0,0.21772783699999998,0.335900739,0.0964887722,0.188905353,0.407255155,0.0,0.0,0.409630527,0.0,0.0318588775,0.0,0.39341237,0.0112052652,0.0,0.21152529,0.0,0.0756373447,0.333854124,0.446325972,0.31587992600000003,0.199286794,0.0,0.44320381299999995,0.08540397720000001,0.401711565,0.0,0.028922734,0.80877375,1.51017102,1.90880913,3.30658273,4.80542855,4.99736313,5.09580729,5.04143788,4.02371519,2.15552392,0.536557845,0.369319945,0.0,0.0,0.0,0.483964291,0.370003044,0.0,0.0,0.481602333,0.347121932,0.231440518,0.0,0.460077477,0.0431972241,0.38394285799999994,0.5976262520000001,0.06426028519999999,0.0,0.0,0.0,0.42993183700000004,0.0435480993,0.0,0.56583436,0.170886035,0.21043583800000001,0.0,0.0,0.0,0.32789689,0.5481223470000001,0.288208325,0.0,0.0,0.0,0.0,0.440263719,0.470195782,0.0,0.152159509,0.0,0.320244579,0.0,0.162293046,0.0,0.326913405,0.04599163690000001,0.679947083,0.0,0.45094042100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.323041697,0.546716899,0.253038495,0.876454292,0.64797886,1.64504988,2.46060453,3.54293771,3.60180811,3.01737576,0.489237782,0.0,0.0,0.139077069,0.291369506,0.590614609,0.0,0.0,0.169197905,0.798729204,0.0,0.0,0.0,0.109981765,0.397564123,0.49653411700000005,0.203067086,0.877750787,1.52360716,1.96605999,1.94419524,0.75567791,0.553445457,0.0,0.0,0.0,0.825989155,1.1767514,2.66895839,1.56241174,0.263501777,0.654294808,0.40465949700000003,0.0,0.0,0.0,0.0,0.0,0.9079057290000001,0.60509703,0.32926892,0.0,0.0,0.0,0.330029885,0.0,0.0,0.287187504,1.32160763,2.16098536,0.109816229,0.645182068,0.0,0.0,0.0,0.206713914,0.0,0.6213679120000001,0.0,0.0,0.0,0.17025997,0.327881188,0.678835078,0.0,0.547420527,0.20941039399999997,1.28000819,2.0590219,1.31187295,0.330618555,0.0,0.11726961,0.0,0.7074961409999999,0.0,0.0,0.0,0.48133654,0.39036707,0.24678741699999998,0.0,0.0,0.33609837600000003,0.20287435399999998,0.0,0.170422247,0.00255612973,0.0694081892,0.22494936699999998,0.0,0.0,0.238339894,0.192673001,0.0,0.30674188199999997,0.36148048899999996,0.20880543,0.786682918,0.118501125,0.0,0.0,0.404808126,0.264696038,0.6923876529999999,0.0,0.510070702,0.0,0.6126490729999999,0.885511983,1.23064955,0.15992297,0.358278142,0.46422398299999995,1.62150071,1.41492606,1.05103069,2.94819083,3.2727478,3.81624996,2.06094522,0.757821709,0.0,0.0,0.7676896040000001,1.77600638,2.34461228,1.11504391,1.14171998,0.50534814,0.9686689279999999,0.0622698088,0.109594396,0.0,0.750966468,0.8336590420000001,0.444480813,0.0,0.0,0.0,0.28012034399999997,0.787403072,1.13912431,1.63758352,1.51963847,1.28423007,0.260561557,0.22700366600000002,0.568419284,2.31392802,1.92767146,0.25112106,0.47076817,2.80443448,6.60138798,7.86138307,6.14745947,2.72703366,0.0,0.0,0.613612491,0.855122391,0.0,0.20184856399999998,0.12311862300000001,0.735260227,1.06530965,0.170159741,0.653726447,0.7390540879999999,0.525087046,0.229403496,0.591855293,0.0,0.160079815,0.0,0.329680083,0.0,0.0,0.0,0.668956969,0.6943225709999999,0.0,0.0,0.173813551,0.048940219800000004,0.412456249,0.0,0.235006491,0.385140645,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45799999999999996
0.26054770899999996,0.292468115,0.30480775,0.2988514,0.279136908,0.252637242,0.227691182,0.21281003199999998,0.215497489,0.24121475,0.292603851,0.36905143700000004,0.466636285,0.5784611620000001,0.695327716,0.8066765140000001,0.9016868570000001,0.9704153990000001,1.00485027,0.999768372,0.95330627,0.867187035,0.746582793,0.599631582,0.43666314700000003,0.269217768,0.10896209400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.16727099e-16,0.0699729396,0.12582697,0.162869848,0.17877838100000001,0.173649868,0.149801106,0.111351235,0.0636459351,0.012594490500000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0188872369,0.0546595344,0.08575170789999999,0.110606123,0.128702333,0.140495116,0.147229656,0.15066600900000002,0.152754728,0.155309563,0.159721244,0.166748912,0.17641403600000002,0.188007115,0.200202165,0.211259841,0.219288838,0.22252825199999998,0.219611718,0.209777433,0.192996102,0.170000309,0.14221219300000001,0.11157995,0.08034566580000001,0.050775901500000005,0.0248910746,0.00422951578,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000249218315,0.000852296167,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0038306350299999996,0.02018521,0.0365677873,0.050634831,0.0600962127,0.0630482193,0.0582784171,0.045498847800000006,0.0254712139,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.031726420299999995,0.073396448,0.109652864,0.135644055,0.147384042,0.142303333,0.11966765800000001,0.0808052378,0.0291024156,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.021720018900000002,0.11004060199999999,0.19295858100000002,0.260127884,0.302119834,0.31158637699999997,0.284291213,0.21988953100000003,0.122356979,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14921654199999998,0.48609938,0.873965056,1.29298424,1.7198768,2.12967355,2.49766714,2.80137814,3.02235844,3.14766789,3.17088949,3.09259098,2.92019302,2.66725935,2.35227888,1.99705662,1.62486611,1.25853611,0.918648083,0.622006839,0.38051708,0.20055657899999998,0.0828861805,0.0230834964,0.0124362416,0.0391877233,0.08999546230000001,0.151447185,0.21147795100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.27250960399999996,0.127631486,0.104126359,0.331341445,0.08371706570000001,0.562028272,0.0810220688,0.0,0.0,0.0,0.0,0.732879515,0.521699896,0.0,0.353501425,0.0,0.17004432600000002,0.0,0.0,0.0,0.0,0.21242970600000002,0.808356739,0.0,0.153560467,0.0,0.0,0.0155454338,1.05076322,0.0,0.0,0.0,0.73539404,0.416942429,0.0,0.0,0.0,0.0,0.905219875,0.135414359,0.0,0.0,0.659154724,0.08828154699999999,0.45377459,0.0,0.00998558431,0.233004309,0.6619291620000001,0.732739927,0.0,0.0,0.0,0.0,0.0,0.0,0.162715882,0.0,0.0,0.0,0.0,0.0179814287,0.0,0.440254761,0.0,0.952199598,0.058996550599999996,0.0,0.0,0.600457101,0.0,0.0,0.0,0.6796832629999999,0.44346032,0.182778645,0.0,0.13410015,0.0,0.0,0.0,0.40333928,0.263101022,0.737826712,1.69251758,1.59386679,2.70241957,1.2854313999999998,1.96233241,1.75343927,2.40600797,0.5471826129999999,1.98020658,2.71655219,2.25229604,2.61827338,1.7986781000000003,0.8412043840000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.755067728,0.35023129399999997,0.0,0.0,1.41971063,0.0,0.0203339609,1.08583793,0.481242015,0.0388140768,0.0,0.025100236600000003,0.0,0.0,0.952359284,0.66173316,0.0,0.0,0.879683764,0.0,0.0688901167,0.0112968335,0.456714423,0.361720605,0.5622179270000001,0.624909041,0.799786859,0.364071307,0.0,0.0,0.0,0.0,0.0,0.232154561,0.0,0.0,0.0,2.7820584999999998,2.38899083,2.97870499,3.33061964,3.2978239,2.3697542,2.36386824,2.48466676,1.16299782,0.578199563,0.00452610161,0.659096527,1.32264966,1.47663849,0.308447563,1.64119482,0.676423312,1.63733971,0.304491795,0.0,0.0,0.030275820800000002,0.346486478,0.131621001,0.280936347,0.6285161229999999,0.165201657,0.479049684,0.0,0.0,0.0,0.0,0.337555893,0.292119633,0.0,0.295246901,0.0,0.0,0.0,0.0140619825,0.0,0.0991108056,0.105346059,0.350433106,1.14291235,0.474501821,0.0,0.0,0.164875384,0.8993496670000001,0.0,1.06713874,1.44680471,1.53405751,0.9190288809999999,1.5450872,1.38670054,1.09660233,0.8288508609999999,2.069359,1.94930837,2.96482486,1.94756004,1.22722821,1.33553599,0.864716134,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.6208675029999999,0.0223715937,1.09893074,0.981882655,0.0,0.86139006,0.22216306800000002,0.488510765,1.3036881999999999,0.36686682600000003,0.0,0.0,0.0,0.7966964470000001,0.126022985,0.0,0.0644699187,0.0,0.164309324,0.0,0.39845200299999994,0.706038292,0.0,0.0,0.10367474199999999,0.0483088398,0.0,0.7160335240000001,0.869123347,0.0,0.756571275,0.0,0.0,0.0,0.0,0.40539871899999996,0.918837804,0.571250713,0.15138090699999998,0.0,0.0,0.0,1.18135735,0.5690699220000001,0.0,0.0970795992,0.0,0.774663975,0.0,0.701104918,0.0795886625,0.0,0.0,0.0,0.0,0.0,0.925243945,0.34117554,0.566415543,0.0,0.20970036,0.19571137600000002,0.0,0.0,0.224843845,2.12086477,1.93730661,4.07517012,3.03954609,1.99500925,0.258894308,0.0,0.0,0.0,0.35087151899999997,0.18569918100000002,0.0,0.363792272,0.49248034399999996,1.47798236,0.054828652900000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.37155075299999996,0.0606644041,0.0,0.6640581170000001,0.263623129,0.0,0.0,0.0,0.710243892,0.34623388299999996,0.0,0.0,0.0,0.499172492,0.22512956399999998,1.30329729,0.254301441,0.961432719,1.2421913,1.46825338,0.0,0.900061032,1.6330048000000001,2.03758059,0.700591573,0.162372776,2.05274338,0.0,0.0,0.0,0.0,0.5476189229999999,0.33964557,0.0766121954,0.532013815,0.0,0.0,0.378660237,0.0,0.0,0.0,0.41085255600000004,0.0,0.0,0.0,0.170083609,0.0,0.0,0.36971923100000004,0.18638169300000001,0.494861679,1.09465671,0.0,0.7154366659999999,0.54606751,0.0,0.0,0.0,0.44179916700000005,0.985455429,0.226543468,0.0,0.0,0.0,2.31866158,1.89171199,4.74094515,3.77329641,2.65957531,0.38126492799999995,0.0,0.571756505,0.727611983,0.41721539399999996,0.0,0.17339832,0.0,0.0,0.0,1.03684817,0.0,0.0,0.0,0.0,0.504825752,0.8398014220000001,0.34789983700000005,0.74912474,0.663335871,1.49091109,0.0,1.19154286,0.0,0.0,0.132471862,0.0,0.0,0.636911591,0.821869923,1.8840176,0.906764557,1.04165459,0.0,0.0,0.0,0.752001267,0.0914975348,0.599961476,0.809337018,0.0,0.0,0.826709755,0.30586435,1.14491944,0.610500527,0.0,0.0,0.19341303699999998,0.0,0.137397293,0.053561388200000004,0.0,0.5470964220000001,0.35349033399999996,0.034252777400000003,0.863459467,0.491801834,0.159866022,0.34014874799999995,0.45291043,0.0,0.846055179,0.0,0.879335029,0.0,0.0,0.361243008,0.0,0.37231231299999995,0.0,0.67422489,0.0,0.332638815,0.00656668256,0.0,0.0,0.0,0.08857074039999999,0.755243152,0.31223729699999997,0.0,0.29790114,0.0,0.160566401,0.0,0.436810223,1.41132914,0.0,1.00031806,0.57760551,0.9963111309999999,0.55002904,0.0671788319,0.7814572609999999,1.28291113,0.0,0.0,0.936368608,0.0,0.359111629,0.0,0.0,0.242556687,0.0,0.624168927,0.0,0.0,0.0,0.257367301,0.0,1.3809976000000002,0.0,1.85028968,1.51277153,0.0,0.0,0.0,0.0214187396,0.0,0.6657639639999999,0.265154408,0.0,0.0,0.0,0.524921825,0.0485419183,0.471884674,0.279920839,0.34281480799999997,0.17897781899999998,0.46398480299999995,0.7529974490000001,0.0196937506,0.0,1.13945175,0.5679926470000001,0.0,0.520603457,0.340262295,0.530053798,0.0,0.471998065,1.0482459000000002,0.45534199700000005,0.195908854,0.0,0.107091665,0.0,0.7218474570000001,0.165623383,0.390354805,0.0940920289,0.740500753,0.26808243800000003,0.0495726579,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.000882090371,0.58156006,1.23968428,1.90503312,2.50298982,2.96493261,3.23811021,3.29349466,3.13036565,2.77684369,2.28618842,1.72932129,1.18462198,0.726489825,0.414384329,0.28402205399999997,0.342110618,0.565484744,0.904849408,1.2926303999999997,1.65379112,1.91799611,2.0312641,1.96529556,1.72298212,1.33916055,0.8763823159999999,0.416224882,0.0473570464,0.0,0.0,0.204225735,0.781256728,1.58314778,2.53466083,3.53551622,4.47300979,5.23661069,5.73249623,5.89598392,5.70012078,5.15924261,4.32703651,3.28942208,2.15329491,1.03274334,0.0346761319,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17970479,0.58160695,0.850519468,0.959762818,0.90949184,0.724199473,0.446853336,0.130751174,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.107829064,0.309707857,0.453061186,0.5175383029999999,0.497031199,0.399745864,0.24594997600000001,0.0639034104,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0107212858,0.140225989,0.237898052,0.289737215,0.290256969,0.24284288699999998,0.158610534,0.0540455475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.068908422,0.12638279300000002,0.158119159,0.160981411,0.137004139,0.0926251343,0.0372073734,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0239465219,0.046668431600000004,0.057529911600000004,0.0564896238,0.045863822,0.0295741675,0.0121301568,0.0,0.0,0.0,0.0,0.0,0.00150457763,0.00447320006,0.0023307671600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00106603937,0.030683366200000003,0.0600112811,0.0828012293,0.09327772039999999,0.0874297846,0.0640622843,0.025368123599999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.06510451440000001,0.133493642,0.183966723,0.205812534,0.192654952,0.14396890099999998,0.06563501349999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09573376619999999,0.218375878,0.31112208399999997,0.35542812799999995,0.34004049,0.26350667,0.135130147,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.176737018,0.40103417700000005,0.580150625,0.679488193,0.675331459,0.559819807,0.34368135299999997,0.0561326929,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45399999999999996
4.03089213,4.0168907,3.97013305,3.89144419,3.78224963,3.64454093,3.48082774,3.29407758,3.08764517,2.86519293,2.63060491,2.3878964,2.14112154,1.89428132,1.65123445,1.41561321,1.19074657,0.979592364,0.784680171,0.608066322,0.45130189600000004,0.315414409,0.20090339699999998,0.107749749,0.0354382812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.018384086100000002,0.053166542000000004,0.0881779317,0.121315235,0.150726592,0.174855192,0.19247276300000002,0.20270192199999998,0.205027017,0.19929340399999998,0.185695468,0.164754045,0.137284161,0.10435434,0.0672389174,0.0273650207,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0048782758899999995,0.0488298935,0.0918015196,0.132311836,0.16896228300000002,0.200485272,0.225787978,0.24399023399999997,0.254455306,0.25681250899999997,0.25097091,0.23712367199999998,0.215742849,0.187564807,0.153566708,0.11493481,0.07302558740000001,0.029320930800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.034738135,0.0884943259,0.142720906,0.195697343,0.245733762,0.291231711,0.330743469,0.36302798299999994,0.38710161200000004,0.402281943,0.408223193,0.404941874,0.392831718,0.372667154,0.345594952,0.313114014,0.277043633,0.23948089600000003,0.202748247,0.16933251300000002,0.141817004,0.12280849,0.114861064,0.12039902400000001,0.141640945,0.180527154,0.23865272199999998,0.317207976,0.416928376,0.538055309,0.6803091379999999,0.8428754479999999,1.02440514,1.22302861,1.43638385,1.66165796,1.89564122,2.13479235,2.37531347,2.61323292,2.84449377,3.06504588,3.27093896,3.45841453,3.62399398,3.76456079,3.87743451,3.96043469,4.01193298,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.13957865,0.832951762,0.530563909,0.279117132,0.106451084,0.018315439399999998,0.000770495119,0.0270140619,0.0664287655,0.0932839215,0.0928615691,0.0636726905,0.015611474699999999,0.0,0.0,0.0,0.0,0.0,0.014924224,0.0531575468,0.07332235200000001,0.0707988209,0.04890315519999999,0.0172704551,0.0,0.0,0.0,0.0,0.0,0.00383645136,0.0,0.0,0.0,0.0,0.0,0.0,0.123608532,0.38786777899999997,0.727669375,1.10090972,1.44875145,1.70653209,1.81751394,1.74636089,1.48904214,1.07650718,0.570827048,0.0542467973,0.0,0.0,0.0,0.0,0.0,5.95031845e-16,0.424399519,0.8034227620000001,1.07435523,1.20274591,1.18744093,1.0576219999999998,0.862901692,0.6592104360000001,0.49418087899999996,0.395753519,0.366794566,0.38687988,0.420485493,0.429135583,0.384034441,0.275618576,0.117332646,0.0,0.0,0.0,0.0,0.0,0.0541198524,0.28304497300000003,0.487474398,0.614786081,0.630639976,0.529329222,0.336892,0.105760721,0.0,0.0,0.0,0.0,0.223911306,0.532347344,0.803713248,0.9582067670000001,0.939427572,0.731398125,0.366615025,0.0,0.0,0.0,0.0,0.0,0.0,0.7411945059999999,1.59422003,2.40582393,3.03733958,3.38275448,3.39160314,3.08003707,2.52747282,1.85949297,1.22080713,0.7443335999999999,0.52330959,0.59258657,0.923102405,1.43046432,1.99535252,2.49082118,2.81013876,2.88888556,2.71656222,2.3355584,1.82834481,1.29645553,0.836586066,0.519555926,0.376915245,0.397895354,0.536758006,0.7280532759999999,0.905473431,1.01931389,1.04815061,1.00202288,0.916714578,0.841054986,0.820921592,0.8843907609999999,1.03207795,1.23526817,1.44234986,1.59187679,1.6288544,1.52001112,1.26407208,0.894320105,0.472673515,0.0766322633,0.0,0.0,0.0,0.0,0.274473778,0.6865979390000001,1.07875645,1.37962371,1.53970409,1.5400089,1.39352178,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.532842944,0.570519737,0.572576097,0.534457399,0.44970285200000004,0.32231110399999996,0.174561645,0.042004540099999994,0.0,0.0,0.0,0.0,0.0236998479,0.027405930099999996,0.0134185244,0.0,0.0,0.0,0.000313436858,0.0,0.0,0.0,0.0,0.014837631,0.029417743399999998,0.024791827000000002,0.0,0.0,0.0,0.0,0.021065699500000003,0.0801838403,0.112402741,0.0995352493,0.0515728834,0.000738125448,0.0,0.0,0.0360142646,0.0580755022,0.039419203300000004,0.0,0.0,0.0,0.0,0.0551339076,0.17829056899999998,0.324057255,0.521019488,0.8175869729999999,1.23790759,1.73627455,2.18735478,2.4321646,2.36354327,2.00270735,1.51393565,1.1354286,1.05537944,1.30192898,1.71609703,2.03281981,2.03038101,1.66246999,1.09120959,0.5955905779999999,0.406302375,0.567686094,0.916638244,1.19914897,1.25750642,1.16947234,1.24053996,1.83476606,3.13073673,4.94551861,6.743191900000001,7.84612856,7.75106405,6.38577288,4.16642113,1.81926117,0.0558624337,0.0,0.0,0.012281548799999998,0.5962233579999999,0.784626376,0.5273151460000001,0.045890790599999995,0.0,0.0,0.0,0.11691078699999999,0.347185291,0.345275092,0.144569533,0.0,0.0,0.0,0.0,0.158678564,0.211431057,0.122280425,0.0,0.0,0.0,0.0,0.0697017291,0.147741109,0.123214585,0.0209011913,0.0,0.0,0.0,0.0117250525,0.0916507382,0.10547419699999999,0.0494765733,0.0,0.0,0.0,0.0446758987,0.19165633199999998,0.33957382,0.45683693200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47
1.48558542,1.21068875,2.18247927,2.31034352,3.4787646,2.76662937,0.637337767,0.0,0.736443414,0.552947648,0.0,0.748922949,0.0,0.360907921,0.258798501,1.00636122,1.26646916,1.30735804,0.171480032,0.0,0.0,3.09683156,9.35206353,13.0483476,10.4041554,5.57070536,1.86609716,0.0,0.0,0.112171141,0.833336705,0.37343476,0.048700451500000005,0.618682968,0.0,0.0,0.0,0.779682749,0.12363323699999999,0.0,0.43511178899999997,0.0,0.0,0.9601473070000001,0.060736039400000004,0.598883911,0.849346328,0.0,0.0,0.22231775899999998,0.0,0.219941864,0.0,0.93132254,0.0,0.304843728,0.0,1.26003296,0.251620401,0.0,0.348335881,0.555149412,1.00182613,0.0,0.0,0.0,0.0,0.0,1.47078111,0.658579609,3.54865238,5.18794449,4.27853823,2.75656382,1.98483102,0.0,0.630217082,0.0,0.007956682540000001,1.29788663,0.0,0.0,0.0,1.36830878,0.906947741,0.0,0.0,0.0,0.0,1.781391,0.0,0.79938351,1.86425422,0.501877941,0.0,1.17965539,0.546672995,0.0,0.0,0.0,0.0,0.030600344100000003,0.0,0.0,1.1571,0.0,0.252288229,0.0,0.0,0.639448675,0.239393551,0.730477785,0.0,0.0,0.0,0.0,1.02664023,0.0,0.105917499,0.0,0.0,0.533245917,0.348117222,0.0,0.0,0.0,0.690837605,1.03754418,0.20133831300000002,0.0,0.765493035,0.524558083,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.495
0.75589582,0.0,0.0,0.695847531,0.0891983535,0.0100750664,0.258686244,1.38471771,0.0,0.44350679600000004,0.26392393,0.974682259,0.210803585,0.521040429,0.267665826,0.5489329629999999,1.50496254,0.23712752399999998,1.03768991,0.546412707,0.668533166,1.47798794,0.978090424,1.48844362,0.7617064709999999,1.03491893,1.59125679,1.25435561,2.6110441000000004,1.88619382,1.45432646,1.10433239,1.20706299,1.71497955,1.77471494,1.0094413,0.5061124060000001,0.795262207,0.5613805829999999,0.745323648,2.11617148,1.3867857,1.99892224,3.41471926,2.67629828,3.51188137,3.24011555,3.06134783,2.66029062,3.09933811,2.63842843,3.19316889,2.59054912,1.52647775,0.0,1.57608708,0.76659572,1.47956774,0.20232169600000002,0.0,1.46619316,0.38116641100000004,0.17647826600000002,0.994173923,0.586410344,0.408654587,1.20929263,1.26865643,0.7074669090000001,0.6207603270000001,0.325530614,0.157250526,0.0,0.247689625,0.0,0.0,0.0,0.597777372,0.0,0.367851605,0.09333160119999999,0.761211152,0.41097485899999997,0.73467848,0.20353053899999998,0.403972824,0.0,0.45803554399999996,0.570404927,0.415709218,0.492813469,0.0,0.0,0.372640429,0.0,0.333280666,0.6262128029999999,0.056279769800000004,0.009448907259999998,0.266994974,0.0,0.0,0.394928965,0.0643839713,0.0,0.0,0.123969151,0.0,0.0,0.0,0.0,0.448497515,0.0,0.0,0.0,0.6088621,0.0,0.852230905,0.0673879582,0.45341513,0.8272985190000001,0.7078205879999999,0.882191582,0.25563542,0.0,0.0,0.15482411,0.537763129,0.0,0.0,0.770986698,0.020415590600000002,0.0,0.0,0.0,0.72049933,0.11273681199999999,0.0,0.0,0.06606932360000001,0.130426918,0.0,0.050568517199999996,0.0,0.0539051552,0.563979832,0.460207314,0.0,0.0,0.0,0.0,0.195428322,0.07252077009999999,0.0,0.31236032399999997,0.0,0.0,0.0,0.620247207,0.28666374,0.61758568,0.0,0.0,0.0,0.939857886,0.0,0.71865042,0.0,0.453327659,0.0,0.0,0.06901345,0.0,0.0,1.53192193,0.424139072,0.04504331599999999,1.20886303,1.08149357,1.13524938,1.36310181,1.39186656,1.38627395,2.01526636,0.0,1.78762284,1.33483043,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
