# Dataset Information
# The goal of this dataset is to predict maximum water depth for flood modelling. 
# The dataset contains 673 hourly rainfall events time series which are used to predict the maximum water depth of a domain (Digital Elevation Model, DEM).
# The rainfall events and DEM are generated synthetically by researchers at Monash University because real DEM data with accurate rainfall events are rare. 
#
# Data Donor
# Jihane Elyahyioui, jihane.elyahyioui@monash.edu
@problemname FloodModeling1
@timestamps false
@missing false
@univariate true
@equallength true
@targetlabel true
@data
0.0580103417,0.104611779,0.14722479800000002,0.178263333,0.191614836,0.18405694399999997,0.15621754599999998,0.11284504599999999,0.0622761897,0.015138955800000001,0.0,0.0,0.0,0.0446610749,0.11955970099999999,0.208108228,0.295564414,0.36561068,0.403252889,0.3977913,0.34535018799999995,0.250492636,0.126570506,0.0,0.0,0.0,0.0,0.0,0.114242783,0.41134723799999995,0.792184772,1.22997362,1.68904267,2.12887318,2.50890112,2.79341831,2.95589237,2.98211006,2.87172201,2.63800174,2.30589086,1.90864531,1.48358727,1.06757576,0.6928224740000001,0.383598626,0.15421974800000002,0.00848744149,0.0,0.0,0.0,0.0472897667,0.122231405,0.18845993600000002,0.235350665,0.257720502,0.255459563,0.232467648,0.195179171,0.15098919800000002,0.10686364400000001,0.0683394586,0.039014766299999996,0.0205173262,0.0128448681,0.0149102759,0.0251078486,0.0417439624,0.0632372848,0.0880741884,0.114584672,0.140664055,0.163591696,0.180083303,0.18666023699999998,0.180338503,0.159549064,0.125120079,0.08109979120000001,0.0351901735,0.0,0.0,0.0101435033,0.0875952348,0.228708198,0.43928451399999996,0.7180439809999999,1.05564754,1.43474121,1.83111544,2.21590508,2.55858781,2.83040132,3.00771699,3.07489514,3.02620917,2.86655402,2.61082926,2.28208122,1.90867023,1.52086948,1.14737869,0.8122360120000001,0.532537859,0.317239477,0.167135031,0.07593192019999999,0.0321718142,0.021635771,0.0298205519,0.0440935432,0.0552182121,0.0580733765,0.051542840599999994,0.0376992056,0.0205210319,0.0044467803000000005,0.0,0.0,0.0,0.0,0.0018531438,0.00573043424,0.00436781564,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0149102759,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.320714791,0.0,0.7018368159999999,1.42010749,0.0,0.284881791,0.0,0.0,0.498467655,0.0,0.32062894,0.395248224,0.764636015,0.334258359,0.0,0.49657353299999996,0.0,0.0,0.484811747,0.353939515,0.0,0.0199485998,0.0,0.0,0.0,0.283293837,0.5150845310000001,0.9176705540000001,0.0,0.0,0.0,0.0,0.205742578,0.0,0.0,0.695692161,1.85192315,0.481881006,0.0,0.408665787,0.596650504,0.0,0.0,0.676175613,0.0924931799,0.0,0.0,0.0,0.0,0.524485865,0.0,0.39796339700000005,0.317008914,0.5829234000000001,0.295232713,0.500730526,0.1351309,0.0,0.0,0.9142207509999999,0.0,0.380910763,0.584805757,1.19850246,0.0,0.0,0.0,0.376178974,0.111707141,0.0,0.657563817,0.17573341899999997,0.058332458399999995,0.0,0.0280491448,0.192580378,0.18971119600000003,0.0,0.0,0.648807157,0.0,0.0,0.0495402212,0.0,0.238167502,0.0,0.0,0.0,0.377277016,0.0,0.17461786699999998,0.15706445300000002,0.0,0.190794215,0.0,0.446179448,0.0,0.787352638,0.0,1.16713333,0.836208629,0.380015392,0.8871996240000001,0.22592262100000002,1.02971871,0.0,0.274550157,0.0,0.0,0.334327461,0.0,0.539965085,0.398432695,1.29364441,0.0677490666,1.21714503,0.0,0.537148395,0.53417498,0.262386482,0.0,0.296190426,0.45312044100000004,0.0,0.0,0.0,0.449347647,0.0,0.0,0.0,0.0,0.21526581,0.447753735,0.11366884199999999,0.6517027,0.0,0.0,0.0514749004,0.0,0.366002166,0.387625427,0.0,0.169281691,0.485816462,0.270517993,0.877641417,0.0,1.17006567,0.278584915,0.0,0.0,0.636522493,0.0,0.0,0.0,0.00789931773,0.0569577846,0.696501835,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24274965,0.5406821079999999,0.0,0.09509632359999999,0.640524849,1.12774086,0.8728110040000001,1.72834174,1.26811938,1.48841416,1.67509721,2.52307307,1.9958974999999999,2.43240516,3.26515786,2.47616855,3.04940227,1.8994008999999998,1.9673378000000001,2.7331001,2.94168013,1.92549533,1.75109178,1.97936885,0.360055215,2.17480002,2.4767931,2.13257379,1.43425496,1.25416683,0.73103012,1.89336118,0.339283785,1.15606157,0.143383544,0.0,0.47485284200000005,0.299063129,0.19971432,0.0,0.0,0.0,0.403685178,0.0,0.0,0.0,0.0,0.831556677,0.0,0.0,0.050109712199999996,0.0142084661,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.171158402,0.0752716744,0.0,0.0825046102,0.0,0.0924493679,0.0,0.21031858399999998,2.36025229,3.89081565,1.10606571,0.296734889,0.0,0.18808886600000002,0.0,0.22608390399999997,0.0,0.488499236,0.379316675,0.0,0.452616125,2.13956936,0.839672497,0.506397489,0.0,0.509891432,0.0,4.52422583,4.06184694,0.0,1.08918442,0.78734563,0.5931253000000001,0.0,0.106542007,0.0,0.0656587616,0.0,0.0333130976,0.0,0.0,0.0293592129,0.0,3.10456772,0.16293000900000001,0.109407136,2.22220265,0.34890740600000003,1.98424329,3.38008345,1.07854217,1.7389103,0.0,0.09339879050000001,0.22430096,2.33309143,0.780776655,0.457411413,0.227645248,0.515277743,1.23693734,0.0,0.201290868,0.0,0.624031365,1.49759189,0.45538652399999996,0.0,0.0767929345,0.07020555860000001,0.0,0.0391957519,0.0,0.043814026500000006,0.0,0.049612135,0.0,0.0558499918,0.0,0.0640402414,0.0,0.137863772,0.0,0.059188352,0.0,0.0652990833,0.147856362,0.882775922,0.28964513399999997,0.19162965199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
2.59872688,2.70701364,2.5186938999999997,1.79050121,1.00944392,0.531998176,0.854130458,0.602971913,0.248268343,0.0,0.0,0.0,0.0,0.356566097,0.0,0.0,0.0,0.276005818,0.47833695600000004,0.37079112299999994,0.0,0.0,0.124840786,0.0,0.0,0.39423858799999995,0.844489547,1.05257777,1.40345205,2.10749608,3.4353733999999996,4.238557900000001,4.42615233,4.90293646,5.36753195,5.74187474,4.81502262,4.75320659,4.80024443,4.2193013,3.99724629,2.67215183,1.95051337,1.12977438,0.82939719,0.18898390699999998,0.0,0.0,0.0,0.0,0.14393487300000002,0.242265829,0.572035587,0.0,0.0,0.801611207,0.125464725,0.562900846,0.0697666506,0.329360915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24712545,0.24490155,0.41434688,0.0,0.38185927399999997,0.0761514625,0.36194873899999996,0.220549288,0.28201376899999997,0.0,0.281261141,0.0,0.0,0.0,0.00413833407,0.0,0.17585214100000002,0.22089859,0.0,0.0,0.383243189,0.186635845,0.0,0.540728894,0.18454898399999997,0.0832207036,0.0,0.0,0.142505703,0.0,0.117290533,0.0,0.0,0.0,0.0,0.322011942,0.324560282,0.0,0.11415193900000001,0.132986884,0.0248104584,0.5460355339999999,0.42453485700000004,0.033414076200000004,0.0,0.276747783,0.0,0.0,0.0,0.0,0.0,0.292239293,0.34321241,0.0,0.572204943,0.0,0.120044162,0.0428167035,0.0,0.0,0.0,0.0,0.015106590800000002,0.0,0.0,0.16715032800000001,0.0993527272,0.0,0.27774592,0.534844099,0.109560368,0.0,0.650498403,0.0364644369,0.41612526299999997,0.0,0.152857977,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20303522699999998,0.40361755,0.0508456608,0.731734648,0.341017818,1.28720123,0.274694439,0.14147216199999998,0.274322468,0.0,0.0,0.348069145,0.0,0.0,0.0,0.0,0.026207169199999998,0.213033461,0.93629595,0.803547608,1.24021221,2.07381737,2.66847825,2.06916626,2.38475393,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
0.15999982699999998,0.0,0.152614596,0.9674096240000001,2.18478401,3.38682045,4.11687727,4.105567,3.40190685,2.33904314,1.35713484,0.784315641,0.694978578,0.9145047540000001,1.15324563,1.18217528,0.948020515,0.571208791,0.243963139,0.10203772900000001,0.15009917,0.278537045,0.349065556,0.286770628,0.11972114,0.0,0.0,0.0,0.0161584897,0.109334314,0.12023445099999999,0.04788741059999999,0.0,0.0,0.0,0.0,0.07214169320000001,0.101938932,0.0730110348,0.0196924522,0.0,0.022775696600000003,0.0997560441,0.181753095,0.223956448,0.206953023,0.14544227,0.074087714,0.023188752200000003,0.00215222036,0.000613824732,0.0027779249600000003,0.0013460435,0.0,0.0036763688899999996,0.00999083155,0.008735857540000001,0.0,0.0,0.023324304900000002,0.14380711599999998,0.361504056,0.637894258,0.889862535,1.026349,0.99648392,0.8199708040000001,0.579264091,0.376568474,0.281700887,0.303515225,0.402416127,0.533848694,0.691027112,0.914780507,1.26052333,1.74280616,2.29607956,2.78303642,3.05269577,3.01768823,2.70546889,2.25168487,1.83768948,1.60700408,1.60674219,1.78304131,2.02600998,2.2314854,2.34157541,2.34531323,2.25013998,2.0537049,1.74125404,1.31084506,0.804247025,0.31392018,0.0,0.0,0.0,0.0,0.141224152,0.177201759,0.0898530449,0.0,0.0,0.0,0.0,0.09788957449999999,0.15780166,0.10560283699999999,0.0,0.0,0.0,0.0053049859400000005,0.222292402,0.41835994600000004,0.5025446370000001,0.446594815,0.295123817,0.131784535,0.0263762154,0.0,0.014865575700000001,0.0282395366,0.009990927049999999,0.0,0.0,0.0,0.0065380366700000005,0.0550364795,0.0658404152,0.028642051800000002,0.0,0.0,0.0,0.0283115845,0.0961610193,0.11348717300000001,0.062475347599999995,0.0,0.0,0.0,0.0,0.0612897299,0.109787378,0.0805224929,0.0,0.0,0.0,0.0,0.0487173904,0.119565521,0.106572062,0.0155348779,0.0,0.0,0.0,0.031633053700000004,0.131100326,0.140346561,0.047341150199999994,0.0,0.0,0.0,0.00610906895,0.146153994,0.18941217600000002,0.095906335,0.0,0.0,0.0,0.0,0.17179971100000002,0.27880608,0.18889140399999998,0.0,0.0,0.0,0.0,0.26163258699999997,0.639562426,0.759207895,0.547253258,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
2.10419237,0.0,3.03493662,0.75511236,0.0,0.44951671,0.85456551,0.73953052,0.0,1.23307785,0.89451398,8.63546251,5.28210681,0.0,0.32169858,0.0,1.26443033,0.0,0.95795734,0.0,3.82670075,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.17080789,0.353345765,0.427603636,0.34336088299999995,0.17195794600000003,0.0303218879,0.0,0.0,0.0122349507,0.0,0.0,0.0,0.0175276008,0.08709274619999999,0.0857539397,0.0,0.0,0.0,0.0,0.118890155,0.172288334,0.0674122265,0.0,0.0,0.0,0.111839324,0.289275551,0.218166654,0.0,0.0,0.0,0.0244306177,0.5039256679999999,0.621935352,0.11830349400000001,0.0,0.0,0.0,1.6137508999999999,4.85062302,7.97049546,9.73561404,9.48608161,7.46903192,4.64314084,2.10978759,0.547372176,0.0,0.0,0.0775714683,0.0164829164,0.0,0.0,0.0,0.117887633,0.18912069199999998,0.09099833019999999,0.0,0.0,0.0,0.0505205635,0.16730081800000002,0.133638007,0.0,0.0,0.0,0.0,0.126084446,0.154748486,0.046003792599999996,0.0,0.0,0.0,0.0886307657,0.21119850399999998,0.204554469,0.0928257728,0.0,0.0,0.00978490717,0.0803254355,0.0823620117,0.007011613259999999,0.0,0.0,0.0,0.0670492703,0.101100824,0.0449122091,0.0,0.0,0.0,0.03333680000000001,0.0975060984,0.074450675,0.0,0.0,0.0,0.0,0.0748618483,0.08478327869999999,0.0205299743,0.0,0.0,0.0,0.0291601528,0.049823640700000005,0.0755855794,0.24210082100000002,0.684821509,1.40621651,2.21437254,2.79955611,2.9107312999999997,2.51066643,1.79642214,1.06963106,0.5525429479999999,0.28275006,0.152828134,0.045669583099999994,0.0,0.0,0.0963077566,0.391569922,0.6690487039999999,0.758405766,0.6032881929999999,0.310421882,0.0734499408,0.0309398738,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.483
0.36528173,0.62682091,0.17050409,0.60474426,0.0,0.0,1.65411672,2.3793254,2.9953456000000003,3.47664804,3.71912027,4.33742005,3.24164893,1.11022121,0.1483879,0.09228454,0.37380143,0.17852089,1.74875099,4.52822604,4.10983936,1.47070104,0.0,0.0,1.53516757,4.28475192,5.21681214,3.88761985,1.97982471,1.10201839,0.0,0.57884204,0.77941889,0.42295021,0.0,0.0,0.8857828000000001,1.06277419,0.03905164,0.29584498,0.12962805,0.48587119,0.52399939,0.37172166,0.30091362,0.23732866,0.0,0.39373327,0.0,0.34328841,0.16851495,0.0,0.0,0.55952107,0.14774924,0.25606386,0.15315607,0.0,0.0,0.0,0.48393317,0.0,0.0,0.54242717,1.55962668,1.62802339,1.19582207,0.48987226,0.08333057,0.0,0.0,0.4699817,0.17708149,1.68426156,1.43337944,1.59562543,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.536638987,2.22731331,1.41900577,0.0,0.171876632,0.0,0.0,0.144122165,0.328513247,0.0,0.0,0.327131684,0.057908063499999995,0.0733206313,0.52469615,0.39988822399999996,0.0,0.388963479,0.195528258,0.0213768891,0.287924409,0.0,0.5216505539999999,0.544299679,1.366571,1.47425399,0.09144756859999999,0.0,0.0,0.0,0.296364755,0.461308775,0.0,0.0968447968,0.0,0.0162829362,0.0,0.32615266600000004,0.10040929,0.0,0.0,0.0,0.232970576,0.0341075006,0.0,0.297704274,0.214442098,0.08314391780000001,0.171935013,0.289808877,1.63458456,1.59731941,0.9016635159999999,1.03101616,1.29437909,0.0,0.204162105,0.972452656,0.240017448,0.0426327107,0.0989306837,0.450506334,0.0,0.0,0.0,0.0,0.0424941775,0.0441690333,0.278148247,0.278689333,0.939500804,0.882236081,0.023961121800000002,0.0,0.246516685,0.0,0.439108737,0.0,0.0,0.155088409,0.0,0.46478586,0.0,0.0,0.267111861,0.0,0.0,0.059938895199999995,0.0,0.26181444,0.24981179399999998,0.0318841459,0.0,1.36916696,2.23996854,0.37740186299999995,0.148678759,0.270405569,0.318889456,0.0,0.0444576829,0.6355071,0.27359605600000003,0.288113708,0.0282420335,0.0,0.0,0.334049333,0.45480866,0.0,0.0817590928,0.0,0.0,0.421845233,0.0,0.356411992,0.866336565,1.20046091,1.39279016,1.81087003,2.60882346,1.47896252,0.600010397,0.740365846,0.073403551,0.0951501955,0.0,0.0,0.0,0.0,0.474840084,0.0,0.0,0.0,0.324405502,0.310458695,0.0,0.34907135,0.621826396,1.25621838,0.506153991,0.0,2.22242965,5.266702099999999,4.77958306,3.24044233,1.51521821,0.36695292399999996,0.127801391,0.36638414,0.900566847,0.642597776,0.0,0.0,0.0,0.0,0.269996406,0.30136796,0.715809823,1.0666634,1.86239422,0.309898265,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.419301926,0.366362843,0.235631769,0.067267465,0.0,0.0,0.0,0.0133292383,0.12798483300000002,0.194491201,0.186265071,0.11803028199999999,0.035665634700000004,0.0,0.013844928700000002,0.09860082640000001,0.206365744,0.28584619,0.298712243,0.237735582,0.128986877,0.0178715019,0.0,0.0,0.0,0.032399036400000004,0.0729075161,0.0739601105,0.0367032942,0.0,0.0,0.0,0.0,0.0037798858700000006,0.043952323200000004,0.058651043,0.042447577599999994,0.0063006726299999994,0.0,0.0,0.0,0.0,0.027575638399999998,0.046307742,0.042266500199999994,0.0190760565,0.0,0.0,0.0,0.0,0.0028292793100000006,0.0240318058,0.0380217136,0.0467694658,0.057920835,0.079066606,0.11167172199999999,0.148318767,0.175093315,0.178088108,0.150692511,0.0978088407,0.0346661978,0.0,0.0,0.0,0.0,0.00479394443,0.028110867,0.0342194708,0.0228085707,0.00175928768,0.0,0.0,0.0,0.0,0.0114233116,0.0221457998,0.021458573300000002,0.009611600849999999,0.0,0.0,0.0,0.015760748999999998,0.08963822029999999,0.210041681,0.37384120299999996,0.566352604,0.761755629,0.9279194190000001,1.03530166,1.06740725,1.02876788,0.9465294459999999,0.863787205,0.826092665,0.8656530459999999,0.989170013,1.17421922,1.3758796,1.5413226,1.62700583,1.61229096,1.50498486,1.33761176,1.15662266,1.00880974,0.929281068,0.933836942,1.01653723,1.15175206,1.29955219,1.41362675,1.45121254,1.38408612,1.20847306,0.950520897,0.663897496,0.417887268,0.277838239,0.283614409,0.43390300299999995,0.683296276,0.954824907,1.16453757,1.2494094999999998,1.18788183,1.00489819,0.759558903,0.520785765,0.341390666,0.24132555600000002,0.206441972,0.20188181800000002,0.192665025,0.161224633,0.113819586,0.0737259833,0.06581265019999999,0.101182329,0.17003443399999998,0.246192545,0.300401872,0.314902721,0.29132675,0.24782133899999997,0.207347476,0.184007717,0.175334507,0.165074959,0.134969385,0.07866836049999999,0.00931463697,0.0,0.0,0.0,0.0892749558,0.18749606,0.24496201,0.231449216,0.14966073300000002,0.0369580369,0.0,0.0,0.00373134365,0.130573661,0.254065799,0.31223166199999997,0.27311751100000004,0.15376678400000002,0.0156920615,0.0,0.0,0.148431162,0.400797615,0.65515016,0.833985819,0.89967387,0.870971822,0.8104164079999999,0.788442565,0.8426377690000001,0.9541725879999999,1.05574823,1.06962813,0.95805725,0.7599284909999999,0.591816319,0.607286573,0.928714345,1.58102281,2.45903628,3.3475439,3.99072275,4.18519795,3.85903565,3.10324106,2.14144089,1.24915913,0.6551345820000001,0.46421801,0.63152839,0.995329455,1.35150618,1.53635923,1.48337709,1.2333858,0.899124637,0.604782101,0.42983321799999996,0.38148691100000004,0.40453305,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
3.09376636,2.76394601,2.72962353,2.68810948,2.27025208,2.15539414,2.36529785,1.7191054000000001,1.74411186,1.75467404,1.57288808,1.45405312,1.03424043,1.32677376,1.19213817,1.02209508,0.818415947,0.241750737,0.44508387200000005,0.0037077725599999997,0.198500775,0.372205702,0.0,0.0,0.046398780300000005,0.0,0.0,0.0,0.0,0.0797494017,0.0,0.0,0.125741545,0.0,0.10880662699999999,0.156592285,0.10435896300000001,0.0,0.163143489,0.48475466700000003,0.0678219011,0.215442241,0.40403659799999997,0.341585229,0.287938353,0.165590334,0.161218164,0.19772086600000002,0.29187499,0.0832762822,0.44824534299999996,0.364724535,0.23354557899999998,0.0703867285,0.0,0.40963575,0.0,0.0168671287,0.105380716,0.0,0.0,0.0,0.169960074,0.0345496825,0.0,0.0,0.140898062,0.0,0.0,0.0,0.0,0.0,0.181318544,0.0,0.0,0.0,0.0,0.0,0.222139143,0.165482328,0.129879809,0.221794732,0.0313789045,0.0,0.0611893149,0.227799917,0.0,0.140001933,0.3600477,0.0,0.135346721,0.145430346,0.0,0.0737887596,0.286964654,0.276649042,0.0455881798,0.0,0.307171437,0.0,0.232152915,0.0,0.0745920935,0.0,0.173773039,0.0,0.0,0.0,0.0,0.0,0.0,0.0229101592,0.0,0.0,0.24678241399999998,0.15770298,0.236415937,0.0,0.0,0.029367939500000002,0.09134834210000001,0.0,0.266525868,0.0,0.0,0.0,0.0,0.007642568790000001,0.23248678899999997,0.245542786,0.0,0.0,0.0,0.201812838,0.0,0.289580273,0.0,0.0,0.0779134598,0.145302102,0.140398406,0.0,0.20049265,0.0,0.0,0.05505769730000001,0.133011886,0.0,0.0,0.104733096,0.2692372,0.0729371358,0.14771473599999999,0.146240329,0.351933651,0.0,0.183548603,0.19497301399999997,0.0,0.0,0.0,0.21892746100000002,0.31154326,0.253583023,0.108583634,0.512117438,0.16894404100000002,0.0210841056,0.113475675,0.424559942,0.314474253,0.637141304,0.295701991,0.8765333470000001,0.873621063,0.925760406,1.04020027,0.7465224970000001,0.9394374329999999,0.984667198,1.13466576,1.22428629,1.3791639999999998,1.98116469,2.18675787,2.1586809,2.17274303,1.99811152,2.67329028,2.24200302,2.41456296,2.8032003,2.74631904,2.81351365,3.06252215,3.12323881,2.96207069,3.33484906,2.78891591,3.05277492,2.94141576,3.0240162999999995,3.0891794,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.39731373799999997,0.407529838,0.41181822,0.40910716399999997,0.398656605,0.38012803,0.35362916,0.319729695,0.279446285,0.234196967,0.185727399,0.136013172,0.0871442213,0.0411986735,0.000114365471,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.002922257,0.0270072221,0.0483995345,0.0654314713,0.076840776,0.0818756195,0.0803676939,0.0727675075,0.0601382397,0.044107104400000006,0.0267758996,0.010595116399999998,0.0,0.0,0.0,0.00939500807,0.036199321,0.0766518947,0.130919423,0.19832259600000002,0.27731942600000004,0.36554145600000004,0.459882836,0.556638951,0.651688165,0.7407074029999999,0.8194099020000001,0.883791779,0.930373039,0.95641856,0.9601252859999999,0.940763448,0.8987619590000001,0.835731117,0.754419231,0.658603522,0.552919508,0.442636769,0.333392289,0.230895342,0.140619886,0.06750155320000001,0.0156564898,0.0,0.0,0.011912762700000001,0.0626251093,0.136480101,0.229775146,0.337690915,0.45453724799999995,0.574052998,0.689744378,0.795243901,0.884670568,0.95297149,0.996225818,1.01189362,0.9989949909999999,0.9582084470000001,0.8918815809999999,0.803951981,0.699780975,0.585907662,0.46973501799999995,0.359163699,0.26219211,0.18650333,0.139060359,0.12573092,0.15096162400000002,0.217518861,0.326310328,0.476296991,0.664500513,0.886106265,1.13465702,1.40232771,1.68026753,1.95899202,2.22880546,2.48023239,2.70443656,2.89360681,3.04129091,3.14266145,3.19470164,3.19630305,3.14827198,3.05324602,2.91552685,2.74083965,2.53603298,2.3087357,2.06698962,1.81887684,1.57216104,1.33396026,1.11046675,0.90672638,0.726486457,0.572117025,0.444606328,0.343627261,0.26766779399999996,0.21421516699999998,0.179981059,0.161153215,0.153658129,0.15341941,0.156597406,0.159797331,0.160235564,0.155856686,0.14539703199999998,0.128393945,0.10514315199999999,0.0766097579,0.044300893200000004,0.010110072,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.023442762599999997,0.0522122447,0.0770850954,0.0964278538,0.10899778,0.114019589,0.11122998699999999,0.100887716,0.0837491613,0.0610118117,0.0342299681,0.005208822429999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.029630871099999997,0.0636293411,0.0966526889,0.127406314,0.154861416,0.178314828,0.197423543,0.212211875,0.223051136,0.230613633,0.235804591,0.239677134,0.24333664,0.24784152899999998,0.254107777,0.26282421,0.274384869,0.28884356,0.305894176,0.324878534,0.344821592,0.36449192399999997,0.382483564,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
6.53350657,3.47126119,3.19691281,3.09953003,1.91920448,0.47215437,0.41707233,0.14465468,0.0,0.0,0.0,0.0,0.0,0.48986666,0.80058979,0.40071704,1.18256798,1.71489466,1.71116146,1.24222191,1.17207207,0.0,0.0,0.483684,0.24431609,0.37245999,0.75430946,0.04447243,0.0,1.04861737,0.0,0.46516476,0.0,0.0,0.02742969,1.92650047,0.0,0.0,0.06203275,0.28229734,0.0,1.10170791,0.0,0.44152572,0.0,0.22421341,0.60272236,0.0,0.0,0.73648248,0.0,0.0,0.34506284,0.75641295,0.15890876,0.0,1.54876771,1.2544676000000001,0.45742103,0.46071518,1.46707623,0.0,0.0,0.35377021,0.31415418,0.0,0.6116023,1.9708746,1.67103523,2.59391969,2.47161024,5.74641481,4.53245809,3.34361164,4.12697083,4.94978822,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.802677867,0.79377369,0.840080295,0.9423286209999999,0.94686533,0.724076642,0.351702246,0.0912409532,0.152581595,0.47330824899999996,0.7505797909999999,0.725274456,0.457776778,0.317549746,0.668935945,1.53087578,2.52924268,3.19666798,3.35124386,3.21069222,3.14566855,3.31061971,3.49683234,3.33518938,2.64877141,1.62783391,0.680746292,0.11705075699999999,0.0,0.0,0.0134945849,0.0,0.0,0.034517345299999995,0.0650350355,0.0181311312,0.0,0.0,0.0,0.118682132,0.148856761,0.0127968823,0.0,0.0,0.0,0.219976119,0.228819938,0.0,0.0,0.0,0.054974289100000004,0.3998427,0.359264207,0.0,0.0,0.0,0.248879834,1.16592977,1.48663599,0.9517586240000001,0.182228368,0.280143507,1.89427828,4.5280508,6.73604398,7.12938986,5.40798161,2.58366938,0.217995932,0.0,0.0,0.418784835,0.632104525,0.203410996,0.0,0.0,0.0,0.29222399600000004,0.36568119200000004,0.07466920769999999,0.0,0.0,0.0,0.222184464,0.35555682,0.515914277,0.9823360740000001,1.76110073,2.4080336,2.3245087000000004,1.31773028,0.0,0.0,0.0,1.04605898,2.79913549,3.70165984,3.30357659,2.02117767,0.7549989159999999,0.208311052,0.445030198,0.978032395,1.23542025,0.990848385,0.44554181,0.0,0.0,0.0,0.06628861650000001,0.11543735699999999,0.0464165719,0.0,0.0,0.0,0.030819256099999998,0.0442434754,0.013687498999999999,0.0,0.0,0.0,0.0181088414,0.0228348432,0.004776392,0.0,0.0,0.0,0.0169335929,0.0197311583,0.0016085952800000002,0.0,0.0,3.08932503e-16,0.025586712400000003,0.026618418300000002,0.0,0.0,0.0,0.00649965575,0.04724163519999999,0.0421701968,0.0,0.0,0.0,0.0242138565,0.0943425477,0.0713479831,0.0,0.0,0.0,0.0785945614,0.22250633,0.14469960099999998,0.0,0.0,0.0,0.44316447600000003,1.44779299,2.17812469,2.16028153,1.37882545,0.308472686,0.0,0.0,0.0,0.27448164399999997,0.331900421,0.06663341910000001,0.0,0.0,0.0,0.18813599399999997,0.20240387199999998,0.015099944099999998,0.0,0.0,0.0,0.157232675,0.14536639,0.0,0.0,0.0,0.021477406400000003,0.136665679,0.106405813,0.0,0.0,0.0,0.0332327255,0.108179595,0.0669609472,0.0,0.0,0.0,0.0165480091,0.00641563406,0.0,0.0697927567,0.38279441799999997,0.7930104240000001,1.00854083,0.8031541059999999,0.24587656100000002,0.0,0.0,0.0,0.344576095,0.668525709,0.606210338,0.291202418,0.023958252599999997,0.0,0.092191046,0.13880282,0.023385164500000003,0.0,0.0,0.11107016300000001,0.467967294,0.726817624,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.456
16.4325044,0.558604997,0.34644029,0.0,0.289027524,0.403936464,1.05846724,0.141308183,1.16774656,0.0,0.209197388,0.0,0.510396934,0.236885227,0.029544391099999998,0.0,0.812465944,9.30386953,1.04585894,0.0,2.16312152,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.18627765300000002,0.524776902,0.00487583434,0.0734048705,0.0,0.0,0.158282899,0.39971334399999997,0.208134195,0.015981484599999998,0.0,0.0278041011,0.301144465,0.0,0.199167409,0.197084245,0.20744230800000002,0.0,0.36115881299999997,0.293284022,0.121296885,0.0,0.0045037788,0.0,0.0,0.0,0.17182682800000001,0.153312629,0.0212681507,0.458095452,0.0,0.140570633,0.480214708,0.447497892,0.00383694119,0.21932687399999998,0.0,0.0,0.127973234,0.42750075200000004,0.105830791,0.0663779397,0.40430728299999996,0.132968389,0.327708507,0.0,0.0,0.4501589,0.726738635,0.157215924,0.566093516,0.5858945010000001,0.6831438879999999,0.481009323,0.967046558,1.03105087,0.9050805740000001,0.941405108,0.7517854840000001,1.00974389,1.03993774,1.12677047,0.895149102,0.79476049,1.12009855,0.949265409,0.59032322,0.7445415390000001,0.893475218,1.03369552,0.46665273700000004,0.880673114,0.40194057200000005,0.473664717,0.5431666629999999,0.998636003,0.981537144,1.27881568,1.01456357,1.06635422,1.40882897,1.51108524,1.30375498,1.60047593,1.5558919,2.26324082,1.82635381,2.672863,2.63538431,2.55336285,3.2209835,3.1793767999999996,3.11047054,3.64534784,3.26406881,3.36432023,3.36516829,3.43156889,3.49725088,3.48042268,3.37018408,3.50529743,3.67833338,3.45921191,3.82866304,3.1967227000000005,3.34796396,3.05941927,2.86187764,2.53550877,2.96124334,2.64528206,2.39226939,1.90136278,2.27234825,2.20561584,1.69994787,2.03149019,1.90634979,1.30554023,1.1423345,1.54154757,1.03931605,1.27940555,0.8021744670000001,0.780253715,0.7030716309999999,0.891706088,0.949508858,0.674827071,0.9699339509999999,0.918176133,0.378368493,0.526591571,0.21830613,0.15850430199999999,0.12537045800000002,0.216914372,0.0879372708,0.020540789099999998,0.386900229,0.00612475924,0.0535646841,0.0,0.0,0.0,0.386089798,0.165936817,0.27518304,0.1454557,0.0377563453,0.156118844,0.11782259699999999,0.692639743,0.429624241,0.536052602,0.19846593699999998,0.283193448,0.67321068,0.34126245899999996,0.659951651,0.6091050929999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.36399282,0.0,0.0,0.0,0.0,0.25873392,1.38249496,0.95016806,1.56640697,1.09538708,0.58985224,0.19992115,0.0,0.0,0.0,0.35638169,2.24675053,3.72120714,5.19024486,6.3703539000000005,5.67271223,5.37278856,3.64123401,1.95587243,0.87069225,0.0,0.0,0.0,0.0,0.0,0.08027092,0.2366419,0.77921161,0.84519295,0.0,0.04026115,0.0,0.35295014,0.50568637,0.4427107,0.14523027,0.30106776,0.50281735,0.61152038,0.15633339999999998,0.0,0.50209908,0.0,0.0271413,0.0,0.0,0.10815048,0.0,0.0,0.0,0.73427237,0.44295343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.284348732,0.420481097,0.510378833,0.541685921,0.511191931,0.425467976,0.300078823,0.15744962,0.023659289500000003,0.0,0.0,0.0,0.012358288899999998,0.181894867,0.400303436,0.64051757,0.870036797,1.05526395,1.16621438,1.18095427,1.08913757,0.8941111279999999,0.6132326,0.276276425,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.137754307,0.504944551,0.819781111,1.03268503,1.10526347,1.01626637,0.765701535,0.376494812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.474192393,1.63394994,2.93569195,4.28344768,5.57166576,6.69557258,7.561659,8.09713976,8.25733769,8.03017429,7.43727357,6.53156863,5.39169464,4.11381169,2.80178374,1.55681271,0.46767074700000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0405827817,0.47133306399999997,0.815404372,1.03936511,1.13006956,1.09441288,0.956608683,0.7534591009999999,0.528315805,0.324564161,0.179487481,0.11928443300000001,0.155834003,0.28555435,0.490418226,0.7409054620000001,1.00042851,1.23059052,1.39654758,1.47175658,1.44149325,1.30470589,1.07400276,0.7738234270000001,0.43708359,0.100776802,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.207591905,0.394359931,0.524974577,0.584936616,0.570189113,0.48717025700000005,0.351439493,0.18511062,0.013482131100000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.127115491,0.250124923,0.34036099799999997,0.385556543,0.38094327899999997,0.3298682,0.243191203,0.137562703,0.0328406648,0.0,0.0,0.0,0.0,0.0699000834,0.21320280600000002,0.375456487,0.534803049,0.668825389,0.757778175,0.7874872409999999,0.7514975859999999,0.65215346,0.500443225,0.314615966,0.117751657,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12154516900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.478
0.651904556,0.0,0.0,0.147108858,0.0,0.0,0.110664896,0.010858072,0.0,0.0729714194,0.056998169,0.0,0.0275582882,0.09017840560000001,0.0,0.0,0.10460148699999999,0.0,0.0,0.0949664783,0.0,0.0,0.0426430116,0.0,0.357017295,1.40026334,1.89526211,1.29739071,0.571773238,0.16759074599999998,0.0,0.0,0.09201300189999999,0.0,0.0,0.0815954743,0.0019661684,0.0,0.056954822599999996,0.035644384700000004,0.0,0.0233937355,0.05461764400000001,0.0,0.0,0.0468254487,0.0,0.0,0.125482638,0.96335365,2.82220707,3.93247149,2.73475871,0.8472691809999999,0.17087753600000002,0.12327187099999999,0.0,0.007642691259999999,0.052076635700000005,0.0,0.0,0.020155182,0.0035179420600000002,0.0310405632,0.0,0.0084913632,0.297026185,0.0,0.0,3.02424272,5.56021819,2.13282148,0.0,0.17454139899999999,1.38920899,0.0,0.0,1.33963985,0.0,0.0,1.55069347,0.291390319,0.0,2.89998617,11.475623800000001,9.56941704,2.24610601,0.197026603,1.52534656,3.33320794,6.44577748,6.35172083,1.46607601,0.0,1.37867357,1.45492511,0.0,0.103346634,0.829778992,0.427061212,0.858546787,1.3542142,0.497739316,0.0,0.0650185088,0.0030819656300000004,0.157237303,0.11599154199999999,0.0,1.45119324,4.39382469,4.151172,1.87862108,1.83874308,2.3432187,0.841062828,0.0,0.28865536399999997,0.055108032599999995,0.0,0.19299641899999997,0.18126028800000002,0.0,0.0556300549,0.257860335,0.0,0.0,0.287031747,0.0,0.0,0.240748829,0.0,0.536510135,2.7468783,3.57024104,1.58580636,0.0,0.268305362,1.38591797,1.50324979,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47
0.584556318,1.73942572,2.64247441,2.70679995,1.91140822,0.794076892,0.013973391000000002,0.0,0.106347314,0.291822103,0.173862535,0.0,0.0,0.0383315619,0.29050028899999997,0.285772963,0.0252305479,0.0,0.0,0.266851215,0.444087852,0.294092113,0.0224376719,0.0,0.113221775,0.22582529399999998,0.0862460142,0.0,0.0,0.248752301,0.518732975,0.412965121,0.125439298,0.16249729699999999,0.682028802,1.19393671,1.08792018,0.407656274,0.0,0.028748671400000002,0.501746232,0.45652737299999996,0.0,0.0,1.58725173,5.18847619,8.38107667,8.71503041,5.70729194,1.41267316,0.0,0.0,0.0,0.956225386,0.579771209,0.0,0.0,0.0,0.462704732,0.46258108600000003,0.0114828106,0.0,0.0666938055,0.466328025,0.442764525,0.0,0.0,0.0,0.155150719,0.318965516,0.0748259021,0.0,0.0,0.0746007534,0.323482686,0.185318992,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.182965667,0.0,0.537120357,0.0,0.60051847,0.0,0.0,0.0,0.0,0.15926216599999998,0.0,0.29020952,0.0,0.650592372,0.0,0.0,0.0,0.241540657,0.615487581,0.0,0.325488196,0.160347355,0.12175182,0.0,0.0,0.0,0.0,0.47688636700000003,0.0,0.0,0.0,0.0,0.574112935,0.0632523299,0.41438186299999996,0.335706035,0.397680188,0.0,0.42022921700000004,0.0,0.0,0.50975704,0.270776348,0.916934755,0.613197447,0.843884303,0.0512057438,0.0,0.555953975,0.207457442,0.646950857,1.73421736,3.23751917,4.29012821,5.06190813,6.72730364,6.07037236,6.89670372,6.11763314,4.295196,3.52635883,2.66637236,1.2640109,0.0,0.0,0.0,0.0,0.0,0.0,0.403555879,0.929666916,0.773595351,0.0,0.0486056474,0.235345263,0.0,0.0,0.0,0.328975445,0.22118066600000003,0.787141523,0.0147468272,0.359601183,0.12230768300000001,0.0,0.0,0.0,0.354976251,0.0459878348,0.0,0.525814269,0.6795388809999999,0.0,0.14252262300000001,0.30981854600000003,0.37023528200000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.462
0.0948560633,0.237156023,0.0,0.616113425,0.10012987599999999,0.0316014594,0.0,0.0,0.0,0.0,0.245391859,0.5849703279999999,0.404650799,1.03461275,0.511871834,0.37730634799999996,0.34208979100000003,0.361488295,0.628901244,0.126897599,0.0,0.037500686899999996,0.340354809,0.0,0.0,0.315305679,0.0,0.0,0.0,0.0,0.0,0.0,0.378008092,0.0,0.263380997,0.0,0.0,0.0,0.516342426,0.583182523,0.238428988,0.0,0.18836946100000002,0.0,0.0,0.0,0.0812833971,0.39291276399999997,0.19596244699999998,0.287160819,0.508726507,0.186291562,0.068200001,0.0,0.0,0.0,0.19917642600000002,1.19149917,2.61979054,3.99734282,4.92538126,5.85235883,4.80367084,4.20381587,2.20406427,0.42331780799999996,0.0,0.0,0.0,0.0,0.0,0.240058584,0.11765145699999999,0.994870815,0.8176202690000001,0.0,0.0514082495,0.0,0.0,0.0,0.665633399,0.5576985329999999,0.250665294,0.15739039800000001,0.18742519800000002,0.15221652900000002,0.0,0.0,0.30154614399999996,0.0,0.38429605299999997,0.511900216,0.0129481072,0.226383091,0.0,0.0,0.0,0.0,0.0,0.0,0.471687605,0.12493882,0.0471006193,0.422311625,0.785601201,0.9534171490000001,0.587320188,0.261459454,0.17906504199999998,0.8826584759999999,0.730465074,0.998766623,0.442707659,0.39358037799999995,0.8398497509999999,0.65955425,0.0,0.293997417,0.0693438964,0.47635623200000005,0.0,0.009924465379999999,0.6811653320000001,0.08696669480000001,0.0,0.0,0.0,0.0,0.24654347100000001,0.337975061,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.653755864,0.5703218720000001,0.319801095,0.0396460492,0.0,0.0,0.251764814,0.587928051,0.817763081,0.840825585,0.671458263,0.419954035,0.22015157800000001,0.15061681300000002,0.1981051,0.28336523199999997,0.329130262,0.32365963600000003,0.33673107,0.475893503,0.8094851940000001,1.30517812,1.82477647,2.18257154,2.23617657,1.95875937,1.45194707,0.8929380240000001,0.446805626,0.19339621199999998,0.10727952,0.0964111235,0.0708652535,0.0,0.0,0.0,0.0,0.030183215,0.13271355199999998,0.153910732,0.0711835242,0.0,0.0,0.0,0.0,0.109110115,0.198477789,0.155432326,0.0117597947,0.0,0.0,0.236012323,0.709057974,1.17295067,1.41663224,1.34118917,1.05244304,0.846595793,1.07849637,1.96880693,3.44873276,5.13252264,6.44873302,6.87981075,6.19872765,4.5853823,2.5604676,0.7639887740000001,0.0,0.0,0.0,0.491421116,0.8778396,0.834128944,0.43940674,0.0,0.0,0.0,0.0547416689,0.375837903,0.5138085929999999,0.421672115,0.241076862,0.211552993,0.512082315,1.13232131,1.85410206,2.35857815,2.39920138,1.94032131,1.17993517,0.44235298,0.00270423586,0.0,0.13563014699999998,0.323371356,0.304718745,0.0505201669,0.0,0.0,0.0,0.032205304,0.425859582,0.57108996,0.33714276200000004,0.0,0.0,0.0,0.0,0.886752302,1.87486747,2.41332479,2.24176391,1.47082605,0.551067921,0.0503749582,0.352982092,1.44176418,2.8852089,4.04194791,4.3782375,3.73232253,2.38819584,0.92382566,0.0,0.0,0.103776732,0.801314073,1.29705517,1.29689211,0.8142877709999999,0.123885244,0.0,0.0,0.0,0.0400382493,0.35077580799999997,0.401852634,0.20128869800000002,0.0,0.0,0.0,0.0,0.11495437800000001,0.233355592,0.204084452,0.09241288859999999,0.0249188492,0.09715765529999999,0.303750765,0.536834719,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
0.452623503,1.46044204,0.208885853,1.01921646,0.508739751,0.0,0.303891074,0.0,0.0,0.0,0.0,0.942283289,3.13689825,4.0105121,6.83807702,8.51492154,9.112726199999999,8.63983704,7.56642306,7.35394812,5.73877232,3.17515399,1.87683845,0.5754896939999999,0.0,0.0,0.142510933,0.472821819,0.0,1.04261564,0.0,0.222094436,0.229806945,0.051570982300000005,1.04428166,1.44327043,2.5814675,2.52522581,1.9126488999999998,2.51473204,2.421341,1.85602811,1.52107093,0.414459366,0.0708771187,0.00270046403,0.0,0.026433118399999997,0.620437329,0.869389436,0.0403823996,1.01862559,0.0,0.026639273199999997,0.6283233,0.46782936399999997,0.0,0.0113572246,0.0,0.0,0.6470782279999999,0.0,0.8184533820000001,0.0,0.152222615,0.635114769,0.0,0.0,0.0,0.0,0.0846678034,0.241586257,0.0,0.477396338,0.977221461,0.0,0.0,0.0,0.0,0.171132065,0.0,0.0,0.165552443,1.06318536,0.7672278440000001,1.11843219,1.35906627,0.54636107,0.46647037700000005,0.0,0.0,0.0,0.0,0.0,0.0,1.02869703,1.65931258,2.14160632,1.20302299,0.852240276,1.24048924,0.0349103539,0.361058819,0.0,0.0,0.381187496,0.312159672,0.314036196,0.777929489,0.0,0.0,0.307153607,0.9218578609999999,0.33137156,0.0413586371,0.0,0.0,0.0,0.0744497457,0.9067593629999999,0.71953315,0.7896774590000001,0.706409485,0.775761826,0.0,0.0,0.0,0.42077712,0.0,0.0,0.772258117,0.0,0.22680847699999998,0.540624341,0.0,0.0,0.0,0.754807929,0.209887209,0.0,0.737715021,0.37650319600000004,1.2943428999999997,0.303808425,0.0,0.112753874,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48200000000000004
3.31244518,2.00108598,4.10262301,4.8667129000000005,2.91002542,2.93634895,1.83367977,1.02242554,1.43006251,1.97283823,1.38148303,0.7653335729999999,0.879951369,1.38501099,0.41159289,1.0306568,0.765997705,0.0,0.0,0.550869526,0.554743121,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.09055628,0.273761932,0.0791722922,0.0,0.863016132,0.0,0.8254054809999999,0.0,0.450809268,0.0,0.153402744,0.0,0.877445742,0.307776497,0.163486156,0.6150937329999999,0.429866755,0.8414749429999999,0.0,0.988601118,0.0,0.0,1.03718814,0.23290300600000002,0.0924019575,0.0,0.0,0.00439408774,0.189044514,0.262123798,0.0,0.0,0.0,0.0,0.736061612,0.0,0.0322120319,0.0,0.0,0.130473082,0.0,0.0,0.0357905601,0.0,0.547797588,0.0,0.24992653199999998,0.0,0.0,0.487443101,0.699230143,0.357160387,0.31450789,0.0,0.0,0.0,0.396391184,0.131320115,0.33199808,0.0,0.72262835,0.759258772,0.6855423,0.8448512909999999,0.0,0.0,0.0,0.0,0.07945375860000001,0.0,0.0027073500800000004,0.0,0.668167835,0.0,0.0,0.27079699100000004,0.75656245,0.0,0.0,0.0789261318,0.101452012,0.035280480600000004,0.0,0.0,0.0,0.0,0.0,0.0,1.2924215000000001,0.0,0.0,0.040998011099999995,0.0378389944,0.0,0.49998689799999996,0.114566129,0.333717418,0.204392391,0.20971404899999999,0.617394088,0.0259562214,0.0,0.0,0.0,0.0,0.10123145300000001,1.0487521,1.35809165,0.38651369,0.0,0.0,0.938341456,0.0,0.0,0.600638631,1.40763646,0.20049994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.191671249,0.229620068,0.350919328,0.0,1.11606834,0.0,0.189507268,0.769364954,0.870535499,1.1098302,0.737643321,0.881841937,1.59601462,2.3755667000000003,2.35326978,2.02050171,2.63638334,2.54799856,2.56513718,2.26014406,1.75325002,3.48865755,2.22691256,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.36381168799999997,0.0,0.0,0.0,0.205795685,0.0,0.0,0.0,0.0,0.0477467378,0.0,0.0660148159,0.0,0.0,0.0,0.0,0.0,0.0,1.76797204,1.07498814,0.181756279,0.0,1.75808592,1.64452215,3.60131726,0.498159435,0.914119377,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.655946939,1.40720495,0.0,0.9068719040000001,0.304242892,0.0,0.0,0.0,0.0,0.882803989,2.81282138,0.955595992,0.0,1.46511932,0.0,1.12548015,0.0,0.0,1.80276412,2.08222185,0.229002352,1.97849234,0.0,1.56180762,0.298943435,0.69793406,0.569445403,0.34523934,0.0,0.0649495124,2.52080374,3.72095708,2.80512076,2.45599174,1.17573152,0.622179806,2.17729848,1.05593118,1.58506981,0.34810084,0.5956347879999999,0.5084128410000001,1.30026738,0.626837189,0.838143658,1.32980569,0.0,0.584217698,0.0,0.0241512211,0.599240754,0.156839449,1.7972453000000002,2.33374066,1.06039572,0.8603065670000001,0.710532506,0.0,1.05211252,1.77840633,2.51498895,1.14604455,0.0,0.0,0.33525341,0.143202953,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
5.0685449,4.65496424,4.03079488,2.84981725,2.18944123,0.41159181200000006,0.0,0.011147948400000001,0.0,0.0,0.0,0.0,0.0,0.32663896,0.237198994,0.910960045,0.581334372,0.169305722,0.271235858,0.333487778,0.0951712373,0.0,0.229479645,0.0,0.0,0.0,0.0,0.0,0.0724394537,0.626772289,0.0,0.0,0.496532862,0.0,0.452065316,0.399586669,0.0974839925,0.0,0.0,0.173912455,0.0,0.0,0.24676730300000002,0.0,0.328584366,0.08260374919999999,0.31512426,0.0,0.42151160600000004,0.10975773400000001,0.0,0.263127799,0.0,0.0,0.0,0.47471248,0.0,0.0,0.0620817027,0.16873464300000002,0.0,0.306444934,0.0,0.79327436,0.6825180240000001,0.538516708,0.5815036379999999,0.708883417,0.24825977800000001,0.627192549,0.467373375,0.0,0.0,0.0,0.0,0.0915699633,0.27463121100000004,1.14482429,2.0363944,2.4170771,3.30564436,3.93193508,4.32341362,4.72772153,5.27362941,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.15057040900000002,0.352363465,0.599280672,0.798421935,0.921048766,1.02551252,1.22367504,1.60684975,2.17258509,2.7966062999999997,3.27204354,3.40184463,3.09946036,2.44478313,1.66243984,1.02825708,0.7470562609999999,0.861102615,1.23453364,1.62170009,1.78568461,1.60875021,1.14158255,0.569928423,0.11885560699999999,0.0,0.0692858572,0.38311190100000003,0.7143836179999999,0.9194554970000001,0.949112903,0.857946447,0.7575573609999999,0.74406032,0.841929268,0.994334362,1.10248844,1.08904515,0.9482864459999999,0.7547085729999999,0.6257819579999999,0.660132852,0.885130295,1.24149736,1.61154511,1.87421421,1.95719923,1.86037705,1.64221473,1.38118652,1.13601204,0.925926425,0.7379933040000001,0.551890775,0.363528411,0.19201701699999998,0.0669823669,0.00659213999,0.00245986018,0.0224402889,0.029923662,0.006820337309999999,0.0,0.0,0.0,0.0,0.0663000962,0.0992510208,0.0683437081,0.0,0.0,0.0,0.0,0.050835785099999996,0.17845939,0.21039102699999998,0.0970551258,0.0,0.0,0.0,0.0,0.406338242,1.1048871999999998,1.74174499,2.09286413,2.03072968,1.58191022,0.915500705,0.267565043,0.0,0.0,0.0,0.051788515300000004,0.213659424,0.22679272600000003,0.102515052,0.0,0.0,0.0,0.0,0.08014679599999999,0.160328571,0.136414078,0.0298947931,0.0,0.0,0.0,0.0,0.09401929560000001,0.129559607,0.0816155323,0.0,0.0,0.0,0.0499239622,0.190146127,0.27663957100000003,0.245920096,0.100266262,0.0,0.0,0.0,0.0493472133,0.347826686,0.607605762,0.715414199,0.633405209,0.41968211299999997,0.19723297,0.08824269609999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.0013340755800000002,0.0,0.0,0.101538479,0.0,0.0,0.0,0.0,0.436760446,0.508610824,0.11276604800000001,0.0317992425,0.45889399799999997,0.154670389,0.0,0.0,0.0,0.0,0.0,0.0,0.8526287370000001,0.736310776,1.85150392,2.53927321,2.61691224,2.69369746,2.75782933,2.08238145,1.83438222,0.951998507,0.836892923,0.274529631,0.0,0.0,0.0,0.0,0.0,0.0,0.293794271,0.0,0.805473262,0.722462885,0.0186965916,0.0,0.354919938,0.0,0.0,0.110252169,0.287524933,0.0,0.424530416,0.47769439,0.24922655600000002,0.582305408,0.129728034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.385275627,0.0,0.0,0.0140905301,0.0,0.0,0.497089471,0.0,0.0,0.0,0.0244366961,0.0,0.0,0.0,0.0659082478,0.0,0.7703083559999999,0.0,0.661050322,0.0,0.421578544,0.0,0.061429239000000004,0.0,0.034769712700000004,0.150231476,0.30869921699999997,0.0,0.152617242,0.22574442,0.0477162591,0.37936871899999997,0.0,0.041310669700000004,0.0,0.0,0.0,0.0,0.055174903,0.258031341,1.00013029,1.57779774,3.08449129,3.84984913,4.48944719,5.252757,5.55924497,5.13122099,4.99060607,4.36087219,3.69027247,3.0758002,2.20306394,1.83336065,1.36170187,0.427692952,0.6303709679999999,0.43391948399999997,0.0,0.0,0.0196649868,0.0746096002,0.0,0.119369345,0.440207454,0.17132144,0.312397042,0.495021971,0.383330976,0.141335449,0.0,0.0,0.0,0.0,0.0,0.0,0.403403465,0.48912109299999995,0.5559510910000001,1.09375682,1.10059261,1.20014867,0.6079843739999999,1.16508179,1.07182633,0.729636017,1.05514818,1.15542983,0.36029430700000004,0.730969764,0.023315179900000003,0.25304451,0.0,0.476461344,0.398797095,0.0,0.165538189,0.0,0.0,0.0,0.0,0.0,0.0,0.524164359,1.08491485,1.51700006,1.4546551,1.48207604,1.31649478,1.86086214,1.52659799,0.479730615,0.156098725,0.0,0.422457856,0.0,0.0,0.0989809063,0.418719811,0.823226865,0.58667961,0.990938999,0.7933793379999999,0.44090481200000003,0.0,0.0,0.0753154143,0.24935909899999997,0.6906190659999999,0.25332526699999997,1.33836847,0.99046065,1.80463718,2.20464416,1.71898024,2.07989518,1.58879225,0.796086761,0.261054802,0.613457264,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.513255837,0.053082232199999996,0.5254187260000001,0.12378318199999999,0.423653235,0.42992070000000004,0.121346661,0.0,0.0,0.0,0.0,0.0,0.42326440600000004,0.15235569,0.724195626,0.253820878,0.011757086399999998,0.00162365861,0.0728968878,0.0,0.0,0.218724165,0.13069109,0.0,0.149087012,0.267257452,0.0807985987,0.0759949084,0.0,0.59643902,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
0.219428824,0.343514849,0.328267773,0.147652051,0.0,0.0,0.0,0.0,0.151577632,0.880230385,1.65673676,2.26460389,2.53059849,2.38848764,1.90302323,1.24432967,0.62319273,0.213590526,0.0933874266,0.22565060399999998,0.48548911100000003,0.7184607340000001,0.804560739,0.7014256179999999,0.45117119299999997,0.151886093,0.0,0.0,0.0,0.0,0.0443266196,0.124028974,0.130675621,0.0765217667,6.7737659e-17,0.0,0.0,0.0,0.0,0.0173500802,0.0267416877,0.0175871838,0.00419359332,0.00033742073600000005,0.00914919789,0.021192087400000004,0.0218949661,0.00346289935,0.0,0.0,0.0,0.016782611,0.09557476390000001,0.162744905,0.175755083,0.11093242,0.0,0.0,0.0,0.0,0.0,0.174768282,0.37798613299999995,0.453928336,0.345829785,0.0788476845,0.0,0.0,0.0,8.467207370000001e-17,0.6617576000000001,1.44074855,2.11691375,2.48999684,2.45353741,2.03349613,1.37551957,0.686427917,0.154800745,0.0,0.0,0.0,0.149949582,0.224136828,0.201999431,0.147636401,0.168666182,0.355216184,0.7262529190000001,1.20908157,1.66227809,1.93218977,1.91771578,1.6143286000000001,1.11775203,0.585860404,0.175835025,0.0,0.0143013425,0.186059086,0.37759336299999996,0.48243981700000005,0.454198386,0.320838745,0.16473418,0.0803541201,0.130917204,0.324315418,0.618212843,0.9496667190000001,1.27289972,1.58537751,1.9284961999999999,2.36181811,2.92285146,3.591758,4.27876012,4.8422557,5.13223256,5.04249213,4.55120038,3.73387105,2.743805,1.76746647,0.971161921,0.45744727399999996,0.244728363,0.274166085,0.43830258200000005,0.619429628,0.724444037,0.7063399370000001,0.568464094,0.353602853,0.12391756,0.0,0.0,0.0,0.0,1.01606488e-16,0.08934301439999999,0.130065977,0.10766964400000001,0.0342550026,0.0,0.0,0.0,0.0,0.0287493902,0.141975496,0.219847935,0.233650147,0.183436143,0.0991933669,0.028189682400000002,0.013571983400000001,0.0737652608,0.1924671,0.324599723,0.41627794799999995,0.43001959,0.363407231,0.251905385,0.153660159,0.122668864,0.18263670699999998,0.314131395,0.461880864,0.559725881,0.562168113,0.467795566,0.323076226,0.203818743,0.182010065,0.292860764,0.517249611,0.788013985,1.01770191,1.13550182,1.11675611,0.9918209159999999,0.830530972,0.7097290359999999,0.678971496,0.740054969,0.849239237,0.940254536,0.956543325,0.877256192,0.72505799,0.552939709,0.417429051,0.35186592,0.352783962,0.385391617,0.40433068,0.378293064,0.305506434,0.212274532,0.135943839,0.102063205,0.10868676,0.126986441,0.118453697,0.059584446500000006,0.0,0.0,0.0,0.0,0.0366075955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.92466389,0.45946905,0.0,0.47432558,0.0,0.0,0.50845064,0.0,0.0,0.0,0.0,1.10663092,0.14617129,0.52930812,1.15605757,0.50443971,0.0574423,1.07576239,0.0,0.20202014,0.0,0.73166155,0.0,0.92324784,0.0,0.0,0.04094452,0.0,0.44694516,0.16927376,0.67746018,0.0,1.11158871,0.0,0.02438275,0.0,0.11111773,0.03864479,0.0852876,1.2328146,0.74446223,0.41792451,1.19640004,0.30281337,1.88650668,2.36748767,2.24544481,2.4320119,3.8175611000000003,4.89887061,2.54185696,2.58162327,1.12954021,0.46714784,0.36548317,0.76976795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.205774255,0.0,0.338066821,0.0,1.17023728,6.16843975,1.94815708,0.007235671159999999,2.41026197,2.46604175,0.0,0.0,3.3378506000000003,0.0,0.0,1.52990094,0.626136484,0.0,2.79436963,1.4912899,0.5480728770000001,0.0,0.0,1.16379492,0.30992438899999997,3.76144012,2.38240311,3.29937453,10.9885235,6.25250977,0.7745386470000001,1.73475897,1.99083486,0.264182297,0.0,0.0,1.40741796,0.168740207,0.0,1.13747124,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.462
0.87698605,0.53073763,0.0,0.88513674,0.0,0.0,0.47582681,1.35872521,2.15340441,0.0,0.0,0.0,0.44112102,0.03525376,1.10129878,0.06990861,0.0,1.27650128,0.0,0.0,0.0,1.29219248,0.0,0.63233374,0.0,0.0,0.0,0.0,0.01171893,0.0,0.59365834,0.0,0.36277559,1.21009172,0.63039667,0.0,0.0,0.47389899999999996,0.0,0.37495295,0.15979838,0.36909019,0.0,0.53401196,0.0,0.90785039,0.0,0.38268181,0.97607158,0.0,1.45098507,0.0,1.34549808,0.24139787,0.38749976,0.81624781,0.38619148,0.27603513,2.41751719,2.34102107,1.40365234,1.4358236,0.82648042,2.79243339,0.8783526,1.17397957,0.6642656,0.80865913,1.53871371,2.02102405,1.3117754,0.99864325,1.19284137,0.5416029,0.55074709,0.0,0.0,1.27290925,0.74342468,0.63877951,0.0,0.0,0.0,1.49007832,0.23835963,1.58339556,2.39417091,1.09073299,1.6269305,1.867044,2.55597737,1.49159216,3.20500369,2.69058064,4.26479192,3.33692316,3.83281529,3.59341412,3.76314907,4.70287826,4.3288603,2.53816838,3.15516792,3.16504711,4.1224197,4.74682946,3.0140886,3.14622996,2.66857976,2.94044897,2.61498464,1.77894772,0.0,0.82468191,1.33610935,0.52975021,0.27527212,0.22474742,0.01822743,0.0,0.0,0.0,0.0,0.0,0.12375050000000001,0.0,0.0,0.0,0.0,0.0,0.25078752,1.1335867,0.0,0.17332553,1.06505073,0.0,0.07645933,1.24298829,0.0,0.0,1.38658262,0.09410751,0.0,1.1459023000000002,0.98011934,0.0,0.11063816,0.34836540000000005,0.0,0.0,0.0,0.83202433,0.0,0.3646028,1.19864488,0.87860042,0.72453226,0.08257489,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.44802123899999996,0.31902806899999997,0.086625787,0.0,0.0,0.0,0.15566466199999998,0.21759934600000003,0.14833067,0.032275305,0.0,0.0749463891,0.225905871,0.324575086,0.29149547,0.148266822,0.0,0.0,0.0,0.045169664500000005,0.0857863216,0.0509764123,0.0,0.0,0.0,0.0053746043,0.05691582480000001,0.05594346099999999,0.00898016232,0.0,0.0,0.0,0.0353891964,0.051374878799999996,0.026807357,0.0,0.0,0.0,0.00402316816,0.032366143300000004,0.04779514519999999,0.062415953499999996,0.0945949225,0.144986704,0.18831954,0.190524637,0.13746943,0.050314053399999996,0.0,0.0,0.0,0.006783630840000001,0.035362328900000004,0.0306825107,0.00250801157,0.0,0.0,0.0,0.015712361299999998,0.025384618799999998,0.0133562278,0.0,0.0,0.0045192472,0.10413177900000001,0.289606186,0.5470932789999999,0.8263354470000001,1.05210094,1.15765088,1.12544682,1.00810298,0.909223655,0.92862786,1.10285409,1.37909344,1.64119787,1.77292957,1.72006236,1.5156927,1.25848124,1.06175656,1.003269,1.09698181,1.29149533,1.48917324,1.57965577,1.48292138,1.19142092,0.790602265,0.436095911,0.28479864899999996,0.40935197,0.7471646359999999,1.12349912,1.34369135,1.30096021,1.03084431,0.6768626390000001,0.39296391700000005,0.251837057,0.220722337,0.213490735,0.17078678,0.10341131,0.0693849332,0.111594209,0.213415806,0.310111942,0.34292940899999996,0.305751512,0.242878453,0.202251684,0.18949617,0.167019,0.09958220359999999,0.0021431183499999997,0.0,0.0,0.101309235,0.23290248800000002,0.266326915,0.167080112,0.009007659599999999,0.0,0.0,0.171238765,0.32065631,0.312951665,0.14814549800000001,0.0,0.0,0.17357867300000002,0.539848961,0.855446045,0.9785808579999999,0.9289121029999999,0.8586839629999999,0.907414552,1.0653142,1.17269309,1.07252218,0.796509537,0.6171435470000001,0.889413447,1.77402976,3.04719458,4.16235408,4.55463062,3.99515841,2.75107816,1.43306969,0.627986072,0.562234578,1.01431818,1.51519723,1.67723522,1.41928928,0.951623404,0.567617546,0.419254736,0.44015846399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.40422869100000003,0.47957314799999995,0.519753873,0.521682154,0.48624980799999995,0.418022141,0.324571693,0.215541252,0.10154799,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0353505805,0.0832660684,0.11711745900000001,0.134800472,0.136240812,0.123212028,0.0989548795,0.0676555623,0.0338534473,0.00185352296,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00064899927,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0133676348,0.0398250874,0.06684681349999999,0.0905966222,0.10717813400000001,0.11317775199999999,0.1061865,0.0852306525,0.0510489341,0.00617004382,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.015443946000000002,0.09980917630000001,0.18080179100000002,0.24898713,0.295567904,0.31343304,0.298095808,0.24840820600000002,0.166956245,0.0600699725,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.153562378,0.341839913,0.510104279,0.63817672,0.70826226,0.707009804,0.627299081,0.46956219200000004,0.242481735,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.5284062589999999,1.31013207,2.17955539,3.09302719,4.00149194,4.85390313,5.60088173,6.19832245,6.61065265,6.81347519,6.79537627,6.55874886,6.11956433,5.50611377,4.75682648,3.91735002,3.03713641,2.16581757,1.34966667,0.628429488,0.032773257,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18732576,0.407433914,0.573242716,0.6730089920000001,0.7028908779999999,0.66657321,0.5742311379999999,0.44096747799999997,0.28490110399999996,0.125107034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0526239222,0.179241457,0.300683297,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.465
0.204183085,0.0,0.340572858,0.805130589,0.959674892,1.42626188,1.35625713,1.57572558,2.02340824,2.48852689,2.14695518,2.77110099,2.88486656,3.19182071,3.42616765,3.37677217,3.71668072,3.95124152,3.51349485,3.6221900999999996,3.82402958,3.55859953,3.68122595,3.07354736,3.2116345,2.69258308,2.75137874,2.25710026,2.10486668,1.9853145,1.51631241,0.9921902640000001,1.22023099,0.420435195,0.0791930221,0.0940465941,0.185274346,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0522068847,0.0,0.0,0.231480317,0.12853579199999998,0.409694678,0.25735872600000004,0.06388055320000001,0.302463876,0.315136071,0.539503899,0.437523216,0.111534046,0.366586116,0.16141465800000002,0.541109741,0.12993201199999999,0.0,0.341962372,0.0478414949,0.0,0.321119377,0.0747101783,0.0,0.0,0.0,0.0,0.09980249220000001,0.0399432245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.302036438,0.0,0.11768715099999999,0.0833626935,0.267092788,0.399516914,0.0,0.139724988,0.157746308,0.0,0.182990695,0.09448519679999999,0.142786222,0.32216348699999997,0.292286873,0.416880805,0.230297282,0.200582309,0.0,0.0,0.0322548528,0.162573783,0.0,0.0328642678,0.0796742763,0.00275073993,0.0,0.0,0.13788438,0.14493209599999998,0.00499874234,0.0,0.323032912,0.0,0.316045074,0.357803586,0.280640949,0.0,0.0,0.197430105,0.13050197800000002,0.0668410656,0.0690543193,0.0,0.378231866,0.0,0.0224937542,0.271612513,0.20932619800000002,0.0,0.106757332,0.0,0.0,0.17012988,0.00833094326,0.0,0.0,0.0,0.056624213099999994,0.0,0.0,0.0,0.259798659,0.0157094646,0.0,0.0,0.0,0.11450967199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10138141199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.128611146,0.0225935788,0.262337834,0.46562932799999995,0.07329346240000001,0.052523695499999995,0.0704263116,0.0,0.31290270800000003,0.126925216,0.53778181,0.530061047,0.568781843,0.28997979,0.8418246490000001,0.6085858510000001,0.741086445,0.41444956200000005,0.801086851,0.7298081479999999,0.719928146,0.46459731,0.37529555200000003,0.144737711,0.6176714729999999,0.506525232,0.637140466,0.029141977000000003,0.39484629,0.45411508799999994,0.0668371108,0.574212246,0.603447941,0.07033863280000001,0.47142484100000004,0.6431871779999999,0.185007463,0.311930356,0.34891330600000003,0.7084415829999999,0.8532765040000001,0.862978675,0.537526913,0.9456686559999999,0.755699511,0.716390285,0.67025199,0.738506015,0.5715077510000001,0.259778418,0.6823990440000001,0.5877100820000001,0.48417527299999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.279047721,0.564166519,0.0,0.0,0.0,0.482799847,0.0,0.0,0.221508495,0.48793897399999997,0.5849482970000001,1.01971001,1.09977751,0.418122913,1.12466432,1.69088238,1.37363557,1.46544744,1.18168323,1.48881591,0.629033452,0.711261162,0.7534013690000001,0.0663255205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.217797144,1.26956516,1.88636745,2.59188723,3.02147879,3.40972785,4.10284364,5.31200203,4.91722407,4.79916558,4.74828198,4.7119844,3.95042603,3.38979191,2.84184899,1.45929508,1.20371689,0.293002114,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0286831785,0.36632712700000003,0.299197404,0.688826272,0.13974202900000002,0.12221860000000001,0.0824291904,0.0,0.377682584,0.0,0.0,0.0,0.0,0.125325039,0.0,0.0,0.0647480121,0.0,0.0,0.12433682900000001,0.22638253600000002,0.0156709002,0.00500416549,0.00961529933,0.520904652,0.060949310199999995,0.0,0.089522369,0.10578792,0.0,0.14075253199999999,0.06312801330000001,0.0557702879,0.0,0.00501582154,0.0,0.0,0.282892016,0.0,0.44055498600000004,0.325201503,0.449830797,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17269600100000002,0.500130454,0.135052925,0.396774729,0.0,0.12046012099999999,0.48275257200000005,0.10332376199999999,0.399293501,0.0,0.0,0.48462411299999997,0.0,0.443787276,0.21251850600000002,0.10275491699999999,0.45768274600000003,0.543246091,0.31927606399999997,0.0,0.0,0.00458000695,0.0,0.0,0.0,0.0,0.0,0.09886098689999999,0.0194429704,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.276239398,0.35282047299999997,0.0,0.0,0.36501456,0.6887081409999999,0.24352100000000002,0.0,0.0,0.0,0.5705537310000001,0.722197995,1.39489525,1.96570009,1.8292491999999998,1.88490754,1.96721287,3.04738506,1.48893085,2.80353635,1.75809278,1.06858876,1.28612467,1.19161535,0.552885401,0.42693750799999997,0.0,0.0,0.0,0.0,0.0,0.24066704,0.512002451,0.44156589799999996,0.357063425,0.73296833,0.0,0.0,0.0,0.0,0.798432391,0.28752887,0.0,0.0,0.0,0.197670863,0.0,0.28353946399999996,0.346888035,0.0,0.0,0.0,0.0,0.0,0.0,0.0931611775,0.0,0.0,1.08421153,0.0,0.0,0.562024448,0.0,0.202149565,0.0,0.753969707,0.13621635699999998,1.12484006,0.0,0.0,0.0,0.0,0.09094413900000001,0.0,0.0,0.0,0.169888525,0.275213644,0.0,0.0,0.15646358900000001,0.965719433,0.0,0.0,0.699539024,0.0,0.354292455,0.0,0.0,0.21488032,0.0,0.745311171,0.0,0.0,0.0,0.0,0.22370328899999997,0.9975918340000001,0.0,0.0,0.246006189,0.055167479299999996,0.0,0.0,0.724394113,0.198044274,0.0,0.0,0.538088684,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.692754423,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.389232374,0.0896059685,0.0,0.0,0.0,0.27397385,0.0,0.36161185799999995,0.284434619,0.0,0.0,0.0,0.412018249,0.0,0.0,0.0,0.0,0.184542839,0.160551523,0.0,0.08959110869999999,0.0270082373,0.573346683,0.0,0.0,0.43980593100000004,0.0,0.0,0.0,0.0,0.0240037472,0.11634159,0.699687202,0.0,0.424631087,0.00152671204,0.524324663,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.12911169,4.59870689,4.89121671,2.82711809,3.95375048,0.0,0.58933238,0.98025632,0.0,2.15530045,1.8873273999999998,2.843928,0.0,11.55329297,10.11560567,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.469
0.34484597,0.506413088,0.0,0.728980168,0.157428823,0.114419348,0.0,0.239356299,0.0,0.158320966,0.629211037,0.307104618,0.25124387800000003,0.0,0.0,0.205796352,0.70419167,0.299689123,0.016823838100000002,0.0,0.0,0.106003128,0.0352978762,0.0,0.407599658,0.0,0.171522961,0.385318657,0.7702187970000001,1.35890791,1.96387527,1.81994416,0.129345089,0.657260663,0.0,0.174951255,0.22388633100000002,0.46173768600000004,0.0944814058,0.42702766700000006,0.0,0.330263662,0.273059663,0.0,0.0,0.0,0.0,0.21901230600000002,0.8431304209999999,0.369870885,0.0,0.0638285861,0.43336978600000003,0.0,0.0,1.34436184,0.9456259659999999,1.65542286,1.35777711,0.0,0.0,0.0,0.40941086,0.666690209,0.0,0.0,0.0,0.23670426,0.0,0.23734131100000003,0.349363665,0.0,0.0,0.0221260598,1.06608571,0.612977369,0.15627095400000002,0.0,0.8755979009999999,0.0,0.746142249,0.7199083959999999,0.0,0.0,0.275210367,0.09320020300000001,0.7090071809999999,0.406217744,1.62947109,0.7240154879999999,0.799118563,0.44699855899999996,0.33631997799999996,1.06160279,0.911974555,1.11977943,0.24901620100000002,0.624385413,0.569430992,0.127425122,0.38133653700000003,0.29777264600000003,0.615401021,0.0,0.17655037399999998,0.372841375,0.195789808,0.693689986,0.0,0.0338659295,0.0,0.153452031,0.0,0.47131425,0.10817546900000001,1.02803848,0.5077485070000001,0.0,0.15869691,0.0,0.30562676699999997,0.0,0.49833734700000004,0.0,0.0,0.33660835100000003,0.0,0.5752446729999999,0.221128264,0.515175727,0.38318380399999996,0.0,0.0,0.0,0.36519782799999995,0.288680365,1.37358904,2.38806039,1.8468793000000001,3.03576012,1.49870072,0.563001459,0.510123985,0.56227379,0.6505935939999999,0.7806038129999999,0.478288516,1.06846974,1.66430166,1.87606602,0.526199945,0.9767146440000001,0.0,0.00915277289,0.112111186,0.0,0.652261498,0.039464894300000004,0.0,0.0755310281,0.0,0.664257902,0.0,0.51229061,0.0,0.306051305,0.0,0.134761805,0.0165963414,0.290569676,0.0,0.978080231,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41700000000000004
1.00651004,1.32087009,2.61813067,2.67244631,4.01263493,4.6481940999999996,4.79778086,4.40908399,3.26347304,2.29387604,1.61443974,0.25443996,0.0,0.03433529,0.0,0.0916683,0.23264346,0.47084906,0.32667258,0.44668969999999997,0.0,0.1783649,0.0,0.0,0.0,0.033477099999999996,0.03748341,0.31899928,1.03251551,0.43384253,0.0,0.0,0.0,0.0,0.0,0.0,0.90332977,1.99938025,2.78225769,3.73683436,4.02177619,3.59969451,3.537211,2.20138231,1.38205675,0.83203279,0.0,0.0,0.0,0.0,0.0,0.18789798,0.34583472,0.67475272,0.55207959,0.34392438,0.0,0.18333996,0.0,0.20034138,0.0,0.05249393,0.0,0.53555294,0.33312482,0.27246124,0.42314663,0.24598817,0.48419121,0.52890667,0.0,0.0,0.0,0.34109099,0.27423574,0.57662592,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
2.53039522,1.1183714,1.75927804,2.13561722,3.96003539,2.95743615,2.0983923,1.25628057,0.485535369,0.0,0.0,0.56520583,0.0,0.35049995899999997,0.0,0.0,0.56620179,0.537596599,0.0,0.330344929,0.34112979200000004,0.0787571024,0.0,0.26679248699999997,0.0,0.147341739,0.642639569,0.0,0.21507374199999998,0.391168085,0.0543496653,0.407359749,0.613760862,0.0,0.0,0.0,0.25982126699999997,0.0,0.0,0.0,0.0,0.0,0.187214178,0.50527435,0.29481706,0.0,0.0,0.0,0.980980815,0.06595652,0.0,0.017665982900000002,0.0996291028,0.0652544986,0.731614645,0.0,0.0,0.0,0.108432982,2.62872397,4.65279747,6.51833579,6.57271077,4.49128046,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
0.28361205,0.0,0.0,0.0,0.0,4.20662173,0.0,0.0,0.5941903000000001,0.0,10.77269955,14.85993425,0.0,0.78608954,2.35535675,0.0,1.20478342,0.0,0.0,0.73963204,0.0,4.25542858,1.55421659,0.0,0.23479665,0.0,0.0,0.69559524,0.58682182,0.4838245,0.0,1.11804485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47700000000000004
0.270076818,0.599659987,0.549477636,0.0,1.29581883,0.024033229,1.49896802,0.0,0.0,0.319747569,0.22971243100000002,0.294374657,0.0,0.10149786699999999,0.44265551299999994,0.0230792029,0.0719481355,0.0,0.00725809559,0.0,0.554428946,0.0,0.71778982,0.0,0.0,0.0,0.412348321,0.707590666,0.418404784,0.0,0.506387547,0.616567024,0.0,0.7017604479999999,0.0,0.0,0.0,0.375672616,1.28601535,0.357015749,0.897014247,0.118901819,0.181691143,1.05159669,0.275938746,0.357182206,0.0,0.0,1.47431402,2.05496439,0.467619546,0.0,0.07297397809999999,0.76959297,0.0,0.0,0.0,0.317182504,1.63696936,0.0,0.814641935,0.0387115529,0.0015377432500000001,0.34245407,1.25243575,0.410940074,0.8127096359999999,1.03136733,2.20350481,0.423341519,1.19869006,1.41983397,0.220592784,1.51324719,0.183616841,0.758383681,0.905124589,1.36506831,0.0,0.0,0.0,0.0232858686,0.0,0.0,0.0,0.0,0.539763208,0.43692423399999997,0.220084285,0.136702783,0.378503756,0.25431205,0.24258371399999998,0.0,1.16218243,0.0,0.879853687,0.0,0.0,0.0,0.32241607699999997,0.698536497,0.0,0.0,0.528199719,1.95904863,0.0760955626,0.0,0.118988422,0.0,0.0,0.8896873829999999,0.0,0.0,0.665520573,0.0,0.744833654,1.04377188,0.178899211,0.43731280299999997,0.0,0.0,0.0,0.0,0.0,0.19689642699999998,0.0,0.0,0.0,0.7437322059999999,0.0,0.0,0.14149655,0.94877732,1.90124865,4.06306216,4.112229,3.21361737,4.06967562,3.86254525,3.21856269,4.20448734,3.30311699,3.22176135,1.15652363,1.89117836,0.431850137,0.33374416100000004,0.0,0.85362867,1.24256292,0.0,0.0,0.0,0.0,0.11655185900000001,0.0,0.0,0.0,0.42882945299999997,0.0,1.9026543999999999,1.03307591,0.0378212275,0.0,0.788460229,0.022213834900000003,0.0,0.0,0.0,0.0,0.0,0.0,1.61212267,0.0,0.7674401540000001,0.7406980559999999,0.34818035799999997,2.33291368,0.9553004390000001,0.934695123,1.53293986,0.61435307,0.625541124,0.19697043600000003,0.0,0.757239346,0.568802649,0.8516629790000001,0.0,0.0,0.0,0.0728862371,0.0,0.0,1.68685024,0.0,0.0,0.0,0.0,0.0,0.479067864,0.0,0.0,0.0,0.0,0.0,0.544374396,0.843794998,0.046310799699999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.940793304,1.56691154,1.50576623,1.75350191,1.75229251,1.88174271,1.69640718,1.25262321,0.967906698,1.08456429,0.7465969179999999,1.22885368,1.37892978,1.56254516,1.8433363999999999,2.30346473,2.6177444,3.19223192,3.17067727,3.02496682,2.8141418,2.95741464,2.31412387,2.01157711,1.71807328,2.21251509,1.95627245,1.85862324,1.94382618,2.56103842,2.35337317,2.36302675,2.34200889,2.07067881,1.55228401,1.16414156,0.6301429789999999,0.577036641,0.597737098,0.75711117,0.8171993590000001,0.895991557,0.630147577,0.670847416,1.09828861,0.894291196,0.531047095,0.748439175,0.47283773,0.518604538,0.331694301,0.374196938,0.27768738,0.0,0.0791529917,0.15568795,0.231887654,0.0,0.0,0.325697177,0.0,0.40117655399999996,0.153996823,0.7673349559999999,0.456238107,0.492269045,0.11205445,0.156871578,0.0674612684,0.053895846399999996,0.111708062,0.0,0.11945794300000001,0.0,0.0,0.0,0.0,0.265825555,0.016517110800000002,0.0,0.0,0.0,0.19345197,0.0,0.0,0.268049221,0.0,0.0,0.182687921,0.0,0.3441862,0.0,0.0,0.0523660699,0.0,0.0651557889,0.047357567,0.006550154420000001,0.0,0.170733508,0.307879048,0.0,0.0,0.123011275,0.0645611648,0.0,0.09527169939999999,0.0,0.0,0.0183246629,0.316641666,0.0,0.203833624,0.110022786,0.0,0.0,0.10154572,0.0,0.142748424,0.0,0.280277854,0.31656338100000003,0.0939234099,0.24787065100000003,0.0,0.210432528,0.38594331,0.755044245,0.646881839,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.675170334,0.6856729579999999,0.50295474,0.0,0.20114109600000002,0.207660475,0.39334356299999995,1.25178066,1.99676656,3.17635042,3.6734532999999994,3.86003561,3.46609069,2.96572909,1.96993735,0.779648096,0.196620335,0.0,0.11428472,0.625283374,0.658300949,0.586661038,0.0,0.0,0.0,0.47744380700000005,0.9560847659999999,1.49101519,1.31990627,1.424426,1.61620247,0.705160192,0.891834297,0.0,0.0,0.0,0.0,0.0,0.0998193364,0.011372426699999999,0.263453809,0.0,0.0,0.181717159,0.0184895485,0.446160815,0.0,0.24388449199999998,0.0,0.20678682399999998,0.298253124,0.285019389,0.145136406,0.0178094979,0.015100135,0.709104792,0.81636877,0.755056897,1.31805072,0.65444922,0.884444228,0.360417124,0.282674146,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
4.26706444,3.65905547,2.89728245,2.08452349,1.32300883,0.6962501109999999,0.255513196,0.0136023832,0.0,0.00464544504,0.123080094,0.240679891,0.3112303,0.311801648,0.24431554600000002,0.130962277,0.00520244388,0.0,0.0,0.0,0.0,0.0,0.047844368600000006,0.106406894,0.126695652,0.105001599,0.0505406615,0.0,0.0,0.0,0.0,0.0,0.0,0.059948269299999996,0.107925914,0.12176745300000001,0.0950855238,0.033623166499999996,0.0,0.0,0.0,0.0,0.0,0.0297933146,0.18527406899999999,0.35027250600000004,0.49485785,0.592398303,0.625328045,0.588778668,0.49129494100000004,0.35256641899999996,0.19880592100000002,0.0569266173,0.0,0.0,0.0,0.0,0.0,0.00942440583,0.0543852176,0.07643739769999999,0.0720485798,0.0455085821,0.0069838623,0.0,0.0,0.0,0.0,0.0,0.0167158667,0.045957615099999995,0.060051799100000004,0.054325688,0.030261034500000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0352802765,0.0730617573,0.0899550157,0.0771768472,0.0343439968,0.0,0.0,0.0,0.0,0.0,0.0116595356,0.168983009,0.350792891,0.525178715,0.6588063829999999,0.724626549,0.708481238,0.6128568870000001,0.45668338299999994,0.271062452,0.091880549,0.0,0.0,0.0,0.0,0.0,0.0022774547600000004,0.041345301699999996,0.0537710956,0.0535164557,0.07385413,0.160924496,0.362541309,0.714727041,1.22925253,1.88546028,2.62882334,3.37720183,4.03395181,4.5053545999999995,4.71869126,4.6369844,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.0369757734,0.349127781,0.8035244309999999,1.26291334,1.57264141,1.62379392,1.39767118,0.9718007329999999,0.485633091,0.0825073263,0.0,0.0,0.0,0.030217237,0.114861528,0.122953386,0.0697740472,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0429714325,0.145703779,0.223662828,0.222199134,0.12218976599999999,0.0,0.0,0.0,0.177483712,0.719616012,1.42447431,2.12489504,2.63447403,2.81603244,2.63278692,2.1603149,1.55447106,0.989613526,0.593966601,0.40908903700000004,0.388521936,0.43265288700000004,0.441190466,0.358438651,0.192071897,0.0,0.0,0.0,0.0,0.0,0.0789479605,0.133568599,0.115337304,0.043231520499999995,0.0,0.0,0.0,0.0,0.0151293576,0.060693924,0.0697637113,0.0433368605,6.933117730000001e-16,0.0,0.0,0.0,0.0,0.0180207574,0.0286877912,0.022900185299999997,0.00776699103,0.0,0.0,0.0,0.0,0.000709896563,0.000818155288,0.0,0.0,3.69462195e-16,0.00446189754,0.007170849050000001,0.005583784350000001,0.00106969674,0.0,0.000430677344,0.00551583022,0.00504908737,0.0,0.0,0.0,0.047805918600000004,0.261218176,0.6483146,1.18832118,1.78463367,2.27770764,2.49279819,2.30978406,1.72824137,0.897043058,0.08785060859999999,0.0,0.0,0.467603008,1.72480783,3.15943366,4.36117425,4.97482068,4.82117245,3.95517425,2.63939075,1.24465335,0.118322475,0.0,0.0,0.0,0.0,0.20907073399999998,0.322599272,0.25330283800000003,0.0857712682,0.0,0.0,0.0,0.0,0.0112088833,0.0223594846,0.0,0.0,1.6420542e-16,0.109658095,0.271767126,0.424097479,0.500582896,0.468349497,0.34786481399999997,0.20419139600000002,0.11310634,0.119913301,0.21347122100000002,0.330554253,0.389810028,0.33851740700000005,0.187570298,0.0149850097,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.823908141,0.8557702909999999,0.565827486,0.10987170800000001,0.0,0.184433608,1.03194476,1.835749,1.94835917,1.2858610000000001,0.426468681,0.0,0.0380329107,0.134522272,0.0136346253,0.0,0.0,0.111699921,0.135661082,0.0,0.0,0.0,0.155966084,0.09600117640000001,0.0,0.0,0.0491243531,0.182990985,0.0343427434,0.0,0.0,0.122958577,0.165718666,0.0,0.0,0.48087264799999996,1.13397206,1.29343783,0.9666367020000001,0.884771443,1.53762484,2.41973081,2.55467158,1.66585878,0.490349286,0.0,0.0,0.11376099999999999,0.09477480630000001,0.0067489779299999995,0.0185799275,0.035635646800000004,0.0,0.0,0.307592326,0.6774498000000001,0.711099635,0.41350337,0.22283725699999998,0.353716711,0.44608938,0.146561959,0.0,0.00278836131,0.72225804,1.02759208,0.38679489,0.0,0.044137936100000004,1.82538261,3.54848814,3.83875098,2.83412638,1.69050545,1.00274114,0.460588414,0.074991885,0.810594321,3.24189095,5.97968618,6.49030514,3.87569549,0.208359081,0.0,0.0,0.78110181,0.8282094640000001,0.0,0.0,0.0,0.6942387320000001,0.411020504,0.0,0.0,0.20867919399999998,0.8344779529999999,0.279597225,0.0,0.0,1.00034735,2.69308465,2.9267459,1.65754102,0.17927055,0.0,0.0,0.123784929,0.129565801,0.0,0.0,0.0,0.0187576314,0.0045731730600000004,0.00271939482,0.0130570976,0.0,0.0,0.0,0.027875030699999997,0.0230462782,0.0,0.0,0.048170916200000004,0.0801971561,0.102750681,0.320847172,0.9023489,1.66606188,2.13386936,1.97020523,1.3125696000000002,0.609145477,0.18312583600000001,0.0302868071,0.0,0.0,3.75501555e-17,0.0260237771,0.0135276109,0.0,0.0,0.015476594,0.0395115324,0.0019300327100000001,0.0,0.0,0.0334718487,0.038062828300000004,0.0,0.0,0.0,0.045914438499999995,0.0256897765,0.0,0.0,0.0158492994,0.0502993671,0.007152097049999999,0.0,0.0,0.057959501100000005,0.18641724699999998,0.368860851,0.647750687,0.941116139,1.03665747,0.81006707,0.40090019600000004,0.087432996,0.0,0.021155230299999998,0.00815536127,0.0,0.0,0.0310127172,0.0490881942,0.0,0.0,0.0,0.0509746654,0.0397876575,0.0,0.0,0.008398126390000002,0.061032230599999994,0.0196358167,0.0,0.0,0.0333321623,0.060573948499999995,0.0,0.0,0.0,0.0553411946,0.050513941900000005,0.0,0.0,0.00347871061,0.0784070778,0.034830194700000004,0.0,0.0,0.162394406,0.529855839,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.13778439,0.21615391899999997,0.288050125,0.35024246200000003,0.400243821,0.436454282,0.458251862,0.46602578,0.461150943,0.445905599,0.42333713100000003,0.39708375799999995,0.371162195,0.349733057,0.336856899,0.33625415399999997,0.351081915,0.383739514,0.43571323,0.5074683,0.598393883,0.706803795,0.829992913,0.96434627,1.10549515,1.24851215,1.3881351999999998,1.51900926,1.63593345,1.73410148,1.80932334,1.85821781,1.87836637,1.86842158,1.82816521,1.75851379,1.66147225,1.54003852,1.39806454,1.24008097,1.07109488,0.89637031,0.7212027320000001,0.550698059,0.389566681,0.241941803,0.111229983,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.47849175e-16,0.037837002,0.0691941978,0.09278329689999999,0.107905389,0.11443735099999999,0.11278836800000001,0.10383054800000001,0.08880883,0.0692362997,0.0467815542,0.0231549092,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,8.540839690000001e-17,0.0123886413,0.022739929,0.0304871541,0.0353019041,0.0371048411,0.0360576317,0.0325370946,0.0270938323,0.0203986617,0.013180978400000001,0.00616374157,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000582251219,0.0038686014200000006,0.00608508558,0.00652903069,0.0046252051500000006,2.51915161e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04912006360000001,0.111334192,0.186283222,0.27294204699999997,0.369615906,0.473975869,0.583134324,0.693759062,0.8022222059999999,0.904778016,0.997761584,1.07779877,1.14201654,1.1882421,1.21517933,1.22255134,1.21119936,1.18312988,1.14150424,1.09056762,1.03551741,0.98231404,0.93744054,0.9076200190000001,0.8995028079999999,0.919337179,0.97263897,1.06387618,1.19618462,1.37112966,1.58852783,1.84633913,2.14063833,2.46566979,2.81398651,3.17667007,3.54362433,3.9039318,4.24625847,4.55929026,4.83218219,5.05500056,5.21913813,5.31768322,5.34572558,5.30058431,5.181946599999999,4.99191011,4.734926000000001,4.41764433,4.04866793,3.63822513,3.1977756,2.7395665,2.27615864,1.81994348,1.38267253,0.975019677,0.606195681,0.283631256,0.0127421001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.105981849,0.19777347399999998,0.270537244,0.320932736,0.347191387,0.349109438,0.327962292,0.286347382,0.22796598699999998,0.157357343,0.0796004162,8.39717202e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0567262512,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
3.89102783,0.0743831297,0.0,0.0,0.305619925,0.0,0.37463513600000004,0.125665554,0.0,0.0,0.461855945,0.0,0.13768724699999998,0.0,0.021220882000000003,0.0,0.0,0.271676769,0.0,0.45553496,2.59177663,1.36239383,0.0,0.511523316,0.131806036,0.369440425,0.6383334860000001,0.0,0.0,0.712682582,1.92144035,0.0,0.0184696553,0.0,0.013707533999999999,0.0,0.8843592229999999,0.271614429,0.0,0.0,0.31040915,0.0,0.270253419,0.0,0.19882111100000002,0.0,1.39674511,0.450483366,2.35607616,1.33282062,0.0,0.595702457,1.20233529,1.44245182,0.0792451322,1.93384143,0.0,0.0,0.362272883,0.0292799502,0.0,0.181371437,0.0,0.0,0.34216230799999997,0.0451673871,0.445281521,0.047676101,0.501859012,0.146120001,0.350129655,0.0,0.07855619030000001,0.130767315,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.326076425,0.184512517,0.100415549,0.335998013,0.0,0.0765519654,0.0,0.0,0.45570647200000003,0.0187774309,0.44018156399999997,0.123252944,0.061873272199999996,0.078508137,0.32765307,0.7155092359999999,0.47313913399999996,0.74794414,0.508295484,1.32745432,1.21476591,0.9129121640000001,1.60878845,1.52776896,1.30538068,1.18234578,1.39154426,1.50912743,1.26465295,1.28452794,1.24042371,1.03519948,0.763701252,0.738006472,0.641159726,0.327128979,0.558050908,0.8440862490000001,0.970660548,0.6561121999999999,1.01625259,1.19949488,0.938661304,1.3569312,0.601088837,0.89569647,0.5242905720000001,0.556167771,0.823416485,0.7984442759999999,0.0270298457,0.0,0.178187934,0.0,0.27001584,0.0,0.0,0.0,0.0,0.0,0.06458146940000001,0.39834230200000004,0.318404366,0.514137693,0.8913403059999999,0.19329716800000002,0.6187070139999999,0.22454893399999998,0.128060498,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.179044697,0.39857522799999995,0.661797947,1.39187509,2.14970011,2.46308099,2.76205385,3.19932541,4.17703125,3.70423635,4.55483382,4.52274598,3.93298819,3.78975359,3.44960304,3.03544086,2.51500178,1.70512177,1.88887018,1.43441161,0.290844248,0.5858444079999999,0.34600507700000005,0.0,0.0,0.0,0.0,0.0,0.147787834,0.233390087,0.0,0.574735791,0.427901573,0.34790659700000004,0.23320774600000002,0.44673180700000004,0.377907207,0.577365355,0.0,0.32054047,0.0,0.0,0.124236408,0.0,0.0,0.0722234757,0.022614872,0.0,0.176351134,0.0,0.0,0.1497773,0.26600395,0.375893132,0.0,0.0466144725,0.340549399,0.223256302,0.0,0.0,0.0,0.0,0.306720316,0.0,0.173006341,0.0,0.37391107799999995,0.211973645,0.0,0.44226026700000004,0.0,0.7095202509999999,0.36426149,0.00530673727,0.47628725200000005,0.065508016,0.45422256299999997,0.0,0.559712917,0.0,0.43334870299999995,0.0,0.398998048,0.104749646,0.386498425,0.0,0.0,0.152419215,0.190074312,0.10177065,0.0,0.22858565,0.0,0.0,0.17246295899999997,0.0,0.0,0.22163488,0.121668447,0.0,0.0,0.0959698333,0.38780934799999994,0.211641923,0.0,0.0960090443,0.206354022,0.0332359953,0.48398753200000005,0.364187826,0.0,0.39937851799999996,0.0,0.416216298,0.0,0.167373262,0.0,0.0,0.0,0.0424616778,0.132947328,0.0,0.125833503,0.438278722,0.0889612122,0.00774120045,0.0,0.0,0.20823543,0.236854602,0.0,0.0350060628,0.22923771399999998,0.139912614,0.0,0.451854284,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
1.09259366,0.929126536,0.785976212,0.701639806,0.692933458,0.7534106709999999,0.8578401940000001,0.9708255859999999,1.05685718,1.08908416,1.0547862,0.9566438159999999,0.810107178,0.638116009,0.46491023600000003,0.31062649999999997,0.18788844300000002,0.10086713900000001,0.0465502581,0.0174201433,0.0045206545299999994,4.4146648e-16,0.0,0.0,0.0,0.0,0.0,0.00141906909,0.00428824795,0.006158823620000001,0.00607088628,0.00380065093,5.808769480000001e-18,0.0,0.0,0.0,0.0,0.0,0.0020550633,0.00535687025,0.00676745547,0.005953793520000001,0.0033609711600000006,2.3235077899999997e-17,0.0,0.0,0.0,0.0,0.0,0.000881455189,0.00196607776,0.00203675685,0.00136310116,0.000500099523,3.2529109100000003e-16,0.00014128167,0.00079373706,0.00147982824,0.0016083323499999998,0.000780781922,0.0,0.0,0.0,0.0,0.0,0.0,0.004071292670000001,0.007499560749999999,0.008875733640000001,0.0073290163,0.00294034712,0.0,0.0,0.0,0.0,0.0,3.39813015e-16,0.00856959879,0.015155173700000002,0.0173026326,0.0138381283,0.00539540968,0.0,0.0,0.0,0.0,0.0,0.0,0.0137096552,0.023920402,0.026972614300000003,0.021325996899999998,0.00822729879,0.0,0.0,0.0,0.0,0.0,0.0,0.0197863083,0.034326917799999995,0.038504205,0.0302965415,0.011636161499999999,0.0,0.0,0.0,0.0,0.0,5.227892530000001e-16,0.027387961000000002,0.047427015700000005,0.0531151383,0.0417391605,0.0160147829,0.0,0.0,0.0,0.0,0.0,0.0,0.0377222531,0.0654069317,0.0733699644,0.0577690396,0.022216848799999998,0.0,0.0,0.0,0.0,0.0,2.38885645e-16,0.053897691399999996,0.0940940359,0.10637555300000001,0.0845090035,0.0328382277,0.0,0.0,0.0,0.0,0.0,0.0,0.09463917,0.17701879899999998,0.22391411,0.22171582199999998,0.171055813,0.0872451653,0.0,0.0,0.0,0.0,2.03306932e-16,0.091580156,0.169559519,0.201728877,0.167973222,0.06829740620000001,0.0,0.0,0.0,0.0,0.0,6.041120259999999e-16,0.29771092600000004,0.619069933,0.9007015309999999,1.08911873,1.15769659,1.11766569,1.01950412,0.943483766,0.9809908970000001,1.21083373,1.67635664,2.36932809,3.22516072,4.13137498,4.94798452,5.5354846,5.78413777,5.63779455,5.10669103,4.26623312,3.24206606,2.18491427,1.24097671,0.524527836,0.0986308689,0.0,0.0831386996,0.358859011,0.694070028,0.996006882,1.19844656,1.27192975,1.22430541,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.13752525699999998,0.0894512976,0.0848503005,0.136116246,0.237908685,0.367552757,0.490588653,0.570058951,0.577012243,0.499278875,0.345972445,0.146294251,0.0,0.0,0.0,0.0,0.0,0.0,0.137363251,0.280430465,0.35333079700000003,0.336324986,0.233911156,0.073580047,0.0,0.0,0.0,0.0,0.0,0.0,0.12183979699999999,0.254894651,0.316378245,0.289115185,0.180576625,0.0208937974,0.0,0.0,0.0,0.0,0.0,0.00427960145,0.17176371699999998,0.29263910600000004,0.332294879,0.278523236,0.14523260300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.06066362769999999,0.23500017899999998,0.346247935,0.361565421,0.274506271,0.107414306,0.0,0.0,0.0,0.0,0.0,0.0,0.13343733800000002,0.320461208,0.42186227200000004,0.406082261,0.27378626,0.0587181415,0.0,0.0,0.0,0.0,0.0,0.0,0.23993013100000002,0.44913575899999997,0.5388234829999999,0.47777042200000003,0.276194412,0.0,0.0,0.0,0.0,0.0,0.0,0.0719133736,0.425247821,0.6792538579999999,0.7537601620000001,0.614124597,0.284249984,0.0,0.0,0.0,0.0,0.0,0.0,0.295682491,0.8677843190000001,1.25413763,1.31724663,0.99204635,0.312750989,0.0,0.0,0.0,0.0,0.0,0.0,1.53898968,3.84497266,6.21562857,8.28232223,9.70879964,10.2572519,9.83565124,8.51608979,6.52014748,4.17451685,1.84656535,0.0,0.0,0.0,0.0,0.0,0.0,0.18764801600000003,0.896731705,1.27004834,1.26026082,0.9196058429999999,0.37577102,0.0,0.0,0.0,0.0,0.0,0.0,0.21687697,0.556690947,0.7201853840000001,0.67670279,0.45272152,0.120908462,0.0,0.0,0.0,0.0,0.0,0.0,0.22535881300000002,0.43215757899999996,0.510143219,0.444427685,0.25986767,0.0124549148,0.0,0.0,0.0,0.0,0.0,0.0219311052,0.22835771600000002,0.364072675,0.394362735,0.31469654199999997,0.15088500900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0710519819,0.228599976,0.31830008,0.317261184,0.228288088,0.07840175519999999,0.0,0.0,0.0,0.0,0.0,0.0,0.10447155699999999,0.22621883199999998,0.282241504,0.258512291,0.163465841,0.025153553199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.126286547,0.21732565899999998,0.24527863800000002,0.204063503,0.107446141,0.0,0.0,0.0,0.0,0.0,0.0,0.110895641,0.225458821,0.29058211899999997,0.28807909800000003,0.218319598,0.10001059,0.0,0.0,0.0,0.0,0.0,0.0,0.0658829274,0.163192413,0.212560943,0.20126436,0.13418566199999998,0.032154521299999995,0.0,0.0,0.0,0.0,0.0,0.0447771539,0.156382093,0.238895503,0.273688098,0.257544379,0.203628232,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.494
0.29776393,3.21683383,6.29174939,8.11081324,7.82659815,5.64648577,2.69232458,0.32491981,0.0,0.0,0.5971373999999999,1.07432337,0.77178103,0.0,0.0,0.0,0.0,0.54946376,0.69516783,0.23256075,0.0,0.0,0.0,0.4413473,1.00947998,0.76882479,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
1.20832942,1.09829097,0.512561519,0.0878793111,0.0,0.0480410296,0.0922127795,0.0037916876200000003,0.0,0.145815748,0.158392653,0.0,0.0,0.518843814,1.13627089,1.12364318,0.9949604129999999,1.12981873,0.987555527,0.353687555,0.0,0.0,0.06886189919999999,0.0,0.0685806085,0.212314555,0.0897985773,0.0,0.0,0.08586281679999999,0.0,0.0,0.0450689182,0.0532495413,0.0,0.0,0.0936427083,0.0,0.0,0.0733342588,0.11359106699999999,0.0,0.8108645940000001,3.89500773,7.37281228,7.92403648,4.85600221,1.0994294,0.0,0.0,0.23380598100000002,7.347040350000001e-15,0.0,0.32099037199999997,0.6883224459999999,0.543903989,0.153870334,0.0,0.0,0.0286342562,0.0,0.0,0.0129651927,0.00872670075,0.0,0.0,0.0138960348,0.0,0.0,0.00925674918,0.035042748,0.114524832,0.225351453,0.178408382,0.0,0.0,0.0564255508,0.057778676900000006,0.0,0.0,0.12590517,0.0,0.0,0.17340393699999998,0.5696966210000001,0.34148047200000003,0.0,0.290801429,0.7651051759999999,0.6936306729999999,0.31227617,0.0689458173,0.0,0.0,0.130512613,0.0,0.0,1.17097488,3.04447123,2.88559556,0.539352,0.0,6.12253362e-16,0.5819194560000001,0.113373423,0.794120298,2.75174144,3.15018936,1.50104431,0.531252488,1.18314916,1.58026036,0.92054214,0.26863176899999996,0.048070375199999994,0.0,0.0,0.336959234,0.400395202,0.109263759,0.0,0.0190644445,0.0,0.0,0.26025192,0.367466654,0.23461319,0.16212346800000002,0.0704505049,0.0,0.0,0.14242571699999998,0.0,0.0,0.131884778,0.187327491,0.0,0.0,1.29559543,2.04337724,1.38820034,0.696561358,0.519940563,0.0267848696,0.0,1.83906371,4.56758329,5.15203072,3.29310758,1.28179255,0.356952066,0.04224529900000001,0.0,5.27898455e-15,0.0221706974,0.0,0.0203746357,0.0,0.0734690574,0.972058695,2.32294698,3.03324128,2.87266412,2.35415906,1.49298677,0.342389981,0.0,0.0,0.18685572600000003,0.0,0.0,0.0916602197,0.0733121374,0.0,0.0,0.108736955,0.0,0.0,0.0616443067,0.0601017789,0.0,0.0,0.0906625103,0.0,0.0,0.0510223472,0.0593373362,0.0,0.0,0.0888034682,0.0,0.0,0.049195243,0.0686875488,0.0,0.0,0.10038086800000001,0.0,0.0,0.375822395,0.571464789,0.174927125,0.0,0.564025485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.457
0.466307025,0.0382482925,0.030865374700000003,0.174223742,0.795205632,0.719229562,1.30399168,1.17085755,1.02030658,0.509019536,0.476141052,0.0288352544,0.0,0.0,0.0492897395,0.399984929,1.81130475,2.22605336,2.11557682,0.77673991,1.02629687,1.44443024,1.48644116,0.950656597,1.13420889,0.93812744,1.40581936,2.01209167,2.47634581,1.85143591,1.49244476,1.38544349,0.960839131,0.445807766,0.060501527199999995,0.46632968700000005,0.405777313,0.0468159988,0.0,0.0290479559,0.250155697,0.0848276265,0.0,0.0,0.0,0.0,0.0,0.22327160399999998,0.140690318,0.451990623,0.0,0.0720730825,0.204855106,0.660844086,0.369586329,0.626783306,0.184551909,0.0,0.39233443100000004,0.730831061,0.881307176,0.0,0.0,0.268678528,0.618070794,0.0,0.0,1.26510757,3.68533351,3.56809243,2.50743264,0.849816818,0.0,0.0125608019,0.0,0.0,0.0,0.19327636199999998,0.0,0.48938128799999997,0.0,0.0,0.0387523811,0.8328702090000001,1.17686412,3.53585225,4.50348011,3.33633845,0.528142431,0.0,0.33519327600000004,0.602374506,0.0,0.0,0.537082911,0.411838259,0.0,0.527720155,0.054622432400000004,0.179448238,0.0,0.587904925,0.416766916,0.0,0.122844269,1.3161044,1.25657293,1.37805862,0.0,0.0,0.17529993300000002,0.0,0.0,0.286129857,0.594323885,0.0,0.0,0.585579748,0.259616795,0.7837784409999999,0.0,0.0,0.00582365032,0.198177388,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.615139532,0.18620536399999998,0.0,0.0,0.0,0.113306721,0.0,0.578176063,0.490182976,0.256919917,0.0,0.0,0.0,1.23302198,0.24889779,1.64826828,1.68972723,1.39495131,0.0,0.0,0.0,0.0688285012,1.40157458,0.826837811,0.421308643,1.80420465,1.5464738,0.441090459,0.914220266,0.374854629,0.0,0.722542125,2.82619546,2.80578581,2.28113001,3.8559687000000005,2.28643432,1.53800047,1.78936688,1.94436094,2.2669694,2.60536623,1.59451342,0.254807619,0.516562031,0.6155277720000001,2.14096939,0.0,1.75937446,3.41715409,1.82341584,1.47873383,0.0,0.35608686799999995,0.283401942,1.16093485,0.0,0.522929918,0.33962907,1.28334459,0.251223336,0.142853081,0.0,0.889141498,0.18819135,0.45933357700000005,0.125265769,0.241735394,0.915975315,0.9367465159999999,1.75050704,1.52254866,1.32406842,0.0,1.44334401,1.85375211,1.12289315,0.0,0.6513541070000001,0.0,1.20075983,0.866909403,0.997180033,2.31529704,1.26630625,2.36299533,1.00055445,0.0,0.666557475,0.47515683299999995,0.0723593592,0.0,0.0,0.755828319,0.697487637,0.17609101800000002,0.0,0.0,0.7063399370000001,0.481052505,0.0,0.0,0.188854482,0.227858867,0.0,1.07866365,0.0,0.30976021600000003,0.295434631,0.0,0.12155446199999999,0.8044961629999999,0.0303157998,0.0,0.0,0.0,0.0,0.0,0.159843076,0.0,0.550067437,0.7436085370000001,0.0,0.0,0.0,0.204084729,0.0,0.0,0.0799517253,0.0,0.33632804299999997,0.0,0.0,0.125174501,0.7467829890000001,0.354502944,0.0,0.0,0.06641156320000001,0.0,0.0,0.872626232,0.0,0.0,0.0474867521,0.134332601,0.258391963,0.0,0.66947279,1.26903905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.150222018,0.261897189,0.37825992799999997,0.412728174,0.31330548199999997,0.10631302599999999,0.0,0.0,0.0,0.087025423,0.40362465700000005,0.673461998,0.795716857,0.739183727,0.551452511,0.328412995,0.161107097,0.0897736785,0.09140689130000001,0.106985392,0.0888356758,0.034700979300000004,0.0,0.0,0.0373076545,0.108700486,0.137797421,0.09471978380000001,0.00675718162,0.0,0.0,0.059189764299999996,0.18564194399999998,0.260331897,0.24164454600000002,0.15108794,0.0522572702,0.000497124496,0.00443573897,0.0285801254,0.0307757391,9.20779561e-16,0.0,0.0,0.0,0.04577891269999999,0.104651995,0.164030161,0.248611429,0.376223504,0.5210382339999999,0.611757192,0.577325448,0.40843076700000003,0.181409326,0.0156020279,0.0,0.0809650039,0.1817667,0.18297674100000003,0.062875964,0.0,0.0,0.0,0.060626487400000005,0.16420708,0.12590489400000002,0.0,0.0,0.0,0.0,0.156002155,0.198269765,0.0637851379,0.0,0.0,0.0,0.114472702,0.27579636399999996,0.20033252699999998,0.0,0.0,0.0,0.297290583,0.938278032,1.35282697,1.27685426,0.7759199609999999,0.218285092,0.0158470786,0.321791779,0.9185386440000001,1.39152822,1.46367571,1.23273256,1.11813309,1.54300799,2.58542419,3.86769296,4.78115734,4.89262782,4.23821739,3.28932479,2.61605639,2.4946484,2.74182775,2.88600688,2.53610504,1.67093093,0.64381535,0.0,0.0,0.0,0.281774945,0.34337404,0.10535388400000001,0.0,0.0,0.0,0.185987188,0.531154407,0.658078834,0.556756237,0.363539646,0.228471509,0.198193722,0.20546582800000002,0.157377577,0.0331379377,0.0,0.0,0.0,0.06603003269999999,0.129983323,0.0803163892,0.0,0.0,0.0,0.00924632807,0.106242528,0.109666988,0.0180140513,0.0,0.0,0.0,0.06684471980000001,0.118490271,0.06676087509999999,0.0,0.0,0.0,0.0180763415,0.11068702300000001,0.108033837,0.00945572407,0.0,0.0,0.031788484900000004,0.26983292,0.494027192,0.6013757670000001,0.554631093,0.386534445,0.16458456900000001,0.0,0.0,0.0,0.0,0.360779829,0.804809635,1.14648303,1.195953,0.88453831,0.345304375,0.0,0.0,0.18260460399999998,0.9503882570000001,1.74130501,2.20278141,2.1591282000000005,1.68584959,1.03329623,0.465056144,0.123313265,0.0,0.0,0.0128313127,0.0208354579,0.0126331546,0.0,0.0,0.0,0.0289356819,0.390526329,1.10220531,2.09794469,3.12694824,3.84091826,3.96253772,3.43550381,2.45995936,1.38844837,0.546859781,0.0895128297,0.0,0.0169214789,0.0793074434,0.0953814875,0.0990968609,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.18537194,0.0,0.9325735999999999,0.81633926,0.59505002,0.0,0.32061555,0.46763832,0.0,0.0,0.0,0.58097151,1.81472045,2.06444727,0.9667728000000001,1.64249148,1.33454172,1.04362814,0.90499465,0.0,0.57057445,1.36296719,1.07534559,2.06746956,0.99244034,1.09089689,0.39794945,0.27930187,0.0,0.0,0.98804964,0.30136611,0.0,1.31723463,0.84485107,0.42170795,1.33287655,0.0,0.14240245,0.0,0.0,0.84335293,0.62758903,0.51191142,0.0,0.26785095,0.0,0.0,1.31438912,0.3592681,0.93995922,1.53534308,1.67880019,0.88112678,3.1353178,2.47127332,4.46303552,3.57226354,1.77775543,2.2190819999999998,1.05832114,1.50123036,0.44364715,0.0,0.0,0.36489574,0.0,0.48407771,0.06365127,0.98432875,0.0,0.0,0.0,0.04506404,0.0,0.98268396,0.4315737,0.52400513,0.0,0.13427797,0.4609433,0.0,0.56704969,1.006294,0.0,0.48688814,0.71814242,0.0,0.0,0.0,0.28871722,0.28231439,1.64746071,0.7953595999999999,0.0,0.0,0.60188294,1.15829913,0.0,0.0,0.38434733,0.0,0.34745109,0.48149034,1.78693574,1.63657025,2.33949619,1.73142702,1.85014806,1.36258967,0.6516774000000001,0.62904524,0.0,0.0,0.29609621,0.19879182,0.11754460000000001,0.41257094,0.33252104,0.0708571,0.23573213,0.49370657,0.0,0.04327264,0.0,0.0,0.60106358,0.0,0.65921623,0.17899008,0.0,0.0,1.01552536,0.74366253,1.91465652,1.35581977,2.40680454,2.10218706,2.0875491000000004,1.16110104,0.98409135,0.94604609,0.0,0.0,0.81186483,0.0,0.06740197,1.83514922,0.96091012,0.64339363,0.61148407,0.30512407,0.61998364,0.6282804,0.0,0.62818394,0.46766291,1.57071794,0.41624739,1.05872188,0.04963263,1.1430743,0.90982623,0.46817954,1.47845746,0.97539171,1.05315335,1.75426948,1.93893572,1.18593395,1.13657926,1.41756341,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.290833873,0.149035433,0.0,0.0,0.14261783,0.20004343100000002,0.0,0.0,0.026383009199999998,0.398603855,0.120594166,0.0,0.0,0.897504242,2.37233893,2.50788276,1.2356544,0.0,0.0,0.0,0.312494353,0.500253072,0.830143069,1.33151667,1.76281851,2.27503251,3.27743556,4.44659238,4.57308042,2.95845121,0.589655215,0.0,0.0,0.323446987,0.40605043799999996,0.0,0.0,0.0,0.281448915,0.09230203990000001,0.0,0.0,0.14035938,0.17207467399999998,0.0,0.0,0.008807168740000001,0.163516092,0.0436448565,0.0,0.0,0.0988760198,0.108263167,0.0,0.0,0.015144989,0.114250634,0.022283123,0.0,0.0,0.0732718716,0.0694756208,0.0,0.0,0.0147975498,0.0646390019,0.00684684306,0.0,0.0192849897,0.06498714400000001,0.0260315669,0.0,0.040006088599999996,0.028875085800000002,0.0,0.0292337928,0.628262598,1.36240832,1.43280501,0.6101674579999999,0.0,0.0,0.263700476,0.64216098,0.284830236,0.0,0.131158669,0.967281378,1.4400538,1.17783744,0.806382629,1.02629204,1.66835402,1.98181771,1.6360758999999998,1.07652189,0.9220548609999999,1.29807577,1.81821041,2.01037102,1.67909085,1.02322122,0.506018716,0.47621895200000003,0.806036588,1.01961626,0.88332937,0.708088611,0.878178272,1.23293814,1.24256199,0.786920246,0.386350154,0.488085465,0.834058255,0.847228502,0.45593688600000004,0.13931991800000001,0.18986897600000002,0.34997811799999995,0.30875932899999997,0.18037298300000001,0.21088349899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
3.61772107,3.04969328,3.54883146,3.26112038,2.55737595,2.8636075,2.62589924,2.40948211,1.9418744,2.05703507,1.61226362,1.34329145,1.06653404,0.86958869,0.51406895,0.63469516,0.23075353,0.35830224,0.31405761,0.0,0.24707153,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08512164,0.0,0.26207933,0.17210676,0.46620654,0.42905238,0.05481828,0.05803418,0.37610883,0.27351378,0.21323964,0.0,0.0,0.16570918,0.20132025,0.0395875,0.22100421,0.02154387,0.3024307,0.44338634,0.0867596,0.20972687,0.05125545,0.0,0.51818522,0.01407194,0.07612343,0.0,0.0,0.22594335,0.36681841,0.47054932,0.32316408,0.27221468,0.16967727,0.3442594,0.38910993,0.94545331,0.71557576,0.52780183,0.91681245,0.39964536,0.59650698,0.75451587,0.75992108,0.27068013,0.26872617,0.28755283,0.582148,0.22851365,0.0,0.1283327,0.36456344,0.0,0.03255321,0.0,0.0,0.18810507,0.0,0.0,0.0,0.0,0.22006022,0.0,0.31820348,0.29881607,0.55756979,0.24950586,0.57159958,1.01781994,0.81436809,1.01221045,1.17661557,1.31980215,1.92708321,1.66128754,2.47267832,2.35665499,2.4719012000000005,3.05004273,2.89515416,2.95500368,3.30376138,3.43758543,3.64379082,3.42683307,3.88733017,3.36562608,3.55468243,3.29790459,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
1.33875317,1.48839131,1.81732092,2.26806402,2.7216855,3.03867784,3.11073252,2.90339379,2.47211942,1.94408692,1.4715783000000002,1.17458527,1.09540853,1.18399413,1.32078156,1.36855993,1.23249542,0.9034134890000001,0.465646237,0.0650642394,0.0,0.0,0.22183497600000002,0.683707987,1.12243058,1.37934226,1.37158271,1.12744256,0.7766005229999999,0.498233634,0.447480641,0.6899805859999999,1.17126168,1.73376374,2.17501,2.32386848,2.10476902,1.56496597,0.855116682,0.172156442,0.0,0.0,0.0,0.0,0.0856466301,0.265144388,0.29178477,0.181374481,0.0059037911700000004,0.0,0.0,0.0,0.0,0.0718707284,0.147276749,0.144946725,0.0749177944,0.0,0.0,0.0,0.0,0.0,0.0597183286,0.0943459552,0.08082387490000001,0.030533634599999998,0.0,0.0,0.0,0.0,0.00615686711,0.0437059574,0.055770178,0.0399765628,0.007895518490000001,0.0,0.0,0.0,0.0,0.0066163167,0.0148538376,0.011142423899999998,0.0027400741399999998,8.746837149999999e-05,0.00864808955,0.0233712056,0.0298042717,0.0124191518,0.0,0.0,0.0,0.0,0.057494146399999994,0.329003001,0.696470783,1.09377551,1.43308811,1.63176134,1.63974789,1.45712175,1.13470448,0.757163537,0.41470148799999995,0.173856117,0.058199172800000004,0.0457583082,0.0834021146,0.111864014,0.0911307901,0.016097662,0.0,0.0,0.0,0.0,0.0789895335,0.254596317,0.38492660799999995,0.41841339200000005,0.339958989,0.181001114,0.011454556599999999,0.0,0.0,0.167772535,0.504707699,0.891121734,1.22928512,1.44077391,1.49812332,1.43796835,1.34913957,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.170088028,0.193932308,0.0,0.0,0.05894582,0.0,0.244917797,0.09056938519999999,0.0313388581,0.0,0.0602315572,0.307664006,0.0,0.24763632100000002,0.644628771,0.701248523,0.43436289299999997,0.30525194,0.12845317,0.727065553,0.343910062,0.314562968,0.505377163,0.6487636,1.04117341,1.80606448,2.32304629,3.01787673,3.11286925,4.15757259,4.22013413,3.97479032,3.52913398,2.99460204,2.5907985,2.06998694,1.38644478,0.530658938,0.0,0.0,0.0,0.0,0.210416424,0.768287797,0.863538696,0.534327935,0.8748359990000001,0.8407330829999999,1.20921715,1.00456484,1.22329765,0.609611072,0.898701009,0.670964976,0.193220757,0.0,0.322084943,0.5203648820000001,0.447746734,0.46118996,0.0,0.0,0.489312587,0.40776261399999997,0.291049123,0.0,0.0,0.0,0.0,0.0,0.0,0.10356762300000001,0.0,0.41668044600000004,0.0,0.0,0.0366890582,0.0719093457,0.0,0.0,0.209022472,0.0,0.0178801723,0.0,0.283455341,0.36390095899999997,0.0,0.440683758,0.0,0.0,0.0,0.0,0.18815495699999998,0.031046001400000002,0.24120911,0.0,0.433240732,0.0,0.18315021899999998,0.0,0.254214954,0.0567805114,0.0,0.266321509,0.151588853,0.0677958155,0.0,0.055842284000000006,0.147313649,0.0,0.0,0.0,0.0,0.112921743,0.219364235,0.146508356,0.0,0.0,0.0,0.0,0.0,0.302064516,0.315853079,0.153050612,0.118310351,0.0,0.195684933,0.38349890700000006,0.0,0.17192806800000002,0.21314360300000001,0.0,0.221963248,0.248199714,0.0,0.154104767,0.474189641,0.382880912,0.0,0.263352521,0.194843397,0.0,0.26188629999999996,0.00354677145,0.0,0.26582551600000004,0.349816705,0.291713307,0.495143634,0.131485661,0.42849522700000003,0.0770253187,0.269788298,0.328691079,0.0,0.31725970800000003,0.0,0.0,0.216234423,0.0,0.407685824,0.284346205,0.0,0.0645715076,0.214814845,0.0184695102,0.0164992593,0.0,0.0,0.40484205,0.0,0.0,0.27583652,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
2.19130438,0.0,0.0,0.6746011,0.227001416,0.0,0.0,0.132933852,0.0,0.0,0.0,0.0,0.052840137599999996,0.0,0.80011688,4.03187481,7.35790025,6.21774049,1.54790299,0.0,0.026202227999999998,0.711863769,0.0,0.0,0.7476162120000001,0.806239934,0.695157719,1.15671101,1.01772281,5.71381465e-16,0.0,0.11938118800000001,0.19318628300000001,0.0,0.0,0.12751384699999999,0.0112999275,0.0,0.0192216059,0.0356213594,0.0,0.0,0.0,0.0,0.0587583662,0.0,0.0,0.07196245150000001,0.09705987710000001,0.0,0.0,0.200661002,0.0,0.0879587167,1.16048589,1.33216645,0.0,0.0,2.29158311,4.1011544,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.020694189499999998,0.079840457,0.0773398498,0.0189007598,0.0,0.0,0.0,0.031814160099999995,0.0104189583,0.0,0.17607648,1.09461593,2.03101648,1.90177745,0.8592263520000001,0.374428197,1.11623092,1.86952692,1.4235089,0.436922233,0.204803825,0.515393639,0.290387871,0.0,0.0,0.42206253899999996,0.40989790299999995,0.0,0.0,0.641718745,0.7343741420000001,0.0,0.0,1.49949904,3.12515585,2.5234617000000004,1.29301109,2.40090913,5.27601153,6.22615533,3.77136927,0.643281853,0.0,0.27802845800000003,0.373531158,0.0,0.0,0.173214302,0.274439983,0.0,0.0,0.108336914,0.21753725,0.0,0.0,0.07401210000000001,0.225362452,0.0547071723,0.0,0.203139008,0.23908987399999998,0.0,0.0,0.032420763,0.180057744,0.0,0.0,0.0198224301,0.322612408,0.305399842,0.092818364,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.37754364,1.21811212,0.0,0.0,0.0,0.0,0.0,0.49823914,0.1410625,0.0,0.40985761,0.16530291,0.0,0.48163992,0.0,0.0,0.0,0.34994379,0.87333553,0.07434185,0.0,0.0,0.0,0.38101134,3.37958496,5.02283488,4.84960602,3.68340257,1.68109133,0.0,0.12268203,2.60976998,4.56651106,5.45649013,4.50937927,2.26553732,0.43138812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.40047878200000003,0.10242472400000001,0.0,0.130472576,0.0,0.0,0.0,0.47941775700000006,0.0,0.772677086,0.40147565399999996,0.0,0.0,0.0,0.0,0.961593825,3.21514162,2.9451895,3.94983668,3.62553241,3.75448626,3.52172091,2.38385095,1.49317411,0.592010697,0.0,0.0667987501,0.0,0.722899631,0.952645605,1.02161506,1.34157669,1.21774906,0.523162711,1.25128162,1.17248192,0.704474151,1.65086747,1.02401479,1.91136841,1.07559082,1.22709344,1.36986946,0.738437225,0.28218204199999997,0.0,0.00176863233,0.253681084,0.0,0.181380302,0.0,0.0,0.0,0.639067533,0.26437366,0.0,0.0,0.0,0.0,0.0786751495,0.0,0.0,0.7020993640000001,0.36034611299999997,0.0,0.0,0.0,0.0,0.862100614,0.0,0.0,0.0,0.214984068,0.0,0.0,0.22505815399999998,0.324533858,1.85806538,1.7681415,1.95579161,0.560901148,0.671515561,0.181270367,0.22647366800000002,0.0,0.0,0.0381561596,0.324258108,0.0561156642,0.0,0.247396862,0.404360792,0.601337452,0.0,0.332650115,0.0357630731,0.0,0.5573848539999999,0.0,0.25544544,0.0,0.0,0.543501763,0.0,0.0,0.0,0.0,0.30128177,0.0201080975,0.0,0.22392905899999999,0.0,0.0,0.0,0.0100129761,0.421297211,0.16645035800000002,0.0,0.0,0.0,0.499028443,0.0,0.344697729,0.392154051,0.0,0.21335964699999999,0.0,0.543030291,0.0,0.671849542,0.0,0.0,0.0,0.0,0.0,0.689040509,1.11870127,3.57674956,4.56464987,6.80237948,7.32867746,6.59685452,5.71336224,4.57421616,2.16832408,0.7163039859999999,0.0,0.0,0.0,0.460266425,0.413515781,0.151105625,0.0,0.0,0.0,0.61914202,0.370594439,0.0,0.0,0.5880463810000001,0.942087945,0.513646918,0.271193365,0.0,0.600238389,0.0,0.0,0.0,0.0,0.464567051,0.617217235,0.0,0.0,0.621723687,0.25103868,0.0,0.0166117162,0.0,0.0,0.0,0.296940133,0.271362399,0.471468625,0.448604382,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.47054018799999997,0.0,0.0,0.286777341,1.82687136,2.38303257,2.5310979,2.95896926,1.45163371,0.988971087,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46299999999999997
2.0364356,2.88989947,4.68913547,5.44287761,6.64398573,6.98650246,5.40563839,4.20495463,2.4366592000000002,0.7956824379999999,0.0,0.0,0.0,0.0,0.0,0.0,0.109736301,0.0262874518,0.160299581,0.518584691,0.0,0.0158579274,0.14903587199999999,0.0,0.0,0.292850332,0.0,0.413719834,0.242694578,0.481959091,0.0313225303,0.339632915,0.0,0.0,0.382719907,0.0,0.42233939,0.0,0.0784542673,0.0214093112,0.042093299800000004,0.20350657100000002,0.0,0.08825055609999999,0.0,0.546613098,0.328201783,0.166918484,0.554129521,0.0,0.0,0.0,0.0,0.6142296270000001,0.135494739,0.305701193,0.0,0.0,0.0,0.0,0.293683998,0.0,0.0,0.0,0.330216263,0.0,0.0,0.0,0.555553449,0.0,0.0,0.0376280436,0.590644456,0.0,0.178360468,0.037405109900000004,0.0,0.6814468690000001,0.0,0.0,0.0,0.196679849,0.361075672,0.41728095600000004,0.139572549,0.0,0.0,0.0,0.0,0.0,0.0,0.262531382,0.456539541,0.245362241,0.419878013,0.19253496399999998,0.39275289799999996,0.0,0.37970571399999997,0.0,0.0,0.074481332,0.406883825,0.510547634,0.47470891,0.0,0.0,0.101913644,0.0,0.0,0.161176243,0.0,0.00513230945,0.27904412100000003,1.18283246,1.38155683,1.00081512,0.9958472890000001,0.723194353,0.0,0.424829885,1.47056324,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.457
0.10117453300000001,0.13793877,0.159980523,0.163920979,0.149514524,0.119669086,0.0799836904,0.0378731937,0.0014127828099999998,0.0,0.0,0.0,0.0299092753,0.0872020858,0.156640989,0.230207634,0.299165849,0.35533139,0.392259993,0.406175475,0.39649941,0.365904643,0.319887166,0.265923698,0.212344445,0.167092722,0.136558824,0.124662685,0.13232049199999998,0.157370703,0.194964307,0.23835336199999999,0.279951971,0.31250385399999997,0.330176688,0.329417279,0.309441001,0.272287512,0.222443097,0.166097503,0.11015911699999999,0.0611881415,0.024417666299999998,0.0030156379700000003,0.0,0.00675889817,0.0264680209,0.051820056600000004,0.0774469982,0.0985729699,0.111838014,0.11585402199999999,0.11139974400000001,0.10122288,0.0894839192,0.08093784059999999,0.07999578190000001,0.08983167630000001,0.11169444199999999,0.144554915,0.18516295300000002,0.228522303,0.26871978399999996,0.299982453,0.317792325,0.31987051,0.30685498899999997,0.282537777,0.253592131,0.22879931399999998,0.21786530399999998,0.22998791,0.272382985,0.34899618,0.45961046299999997,0.5995103860000001,0.759788371,0.928286477,1.09107249,1.23426573,1.34596863,1.41803366,1.44740783,1.43684608,1.39486595,1.33491744,1.27384937,1.22985264,1.22013719,1.25864106,1.35407235,1.50854544,1.71699805,1.96747506,2.24225218,2.51966393,2.77640956,2.99005072,3.14139345,3.2164669999999997,3.20786908,3.11533404,2.94548351,2.71082466,2.42815424,2.11659514,1.79552713,1.48267222,1.1925576999999998,0.935515165,0.7172904040000001,0.539250742,0.399095789,0.291915831,0.21140739600000003,0.151051376,0.105084325,0.069142752,0.0405242167,0.0180772518,0.00179323897,0.0,0.0,0.0,0.00510887516,0.0196608863,0.0353026114,0.0488839887,0.0575264251,0.059233120300000004,0.0533919343,0.0410610035,0.0249642919,0.00917508762,0.0,0.0,0.010917443300000001,0.0401153212,0.08539341810000001,0.144261527,0.2118678,0.281509458,0.34546526899999996,0.396035904,0.42664084,0.432806023,0.41288772,0.368413816,0.303979016,0.22669681100000003,0.145278493,0.0688674617,0.00579649699,0.0,0.0,0.0,0.0,0.0092560632,0.055699872000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
1.4273408,1.4491582,1.29746602,0.237499441,0.0663747965,1.25005529,0.0,0.540337197,0.8277738109999999,0.0,0.0,0.675221236,0.756015143,0.0,0.41931430700000005,0.0,0.0,0.312826189,2.63338463,0.103537874,0.358197586,0.0,0.185388317,0.528534276,0.0,0.0,0.0,0.0,0.0,1.11623312,0.7249334129999999,1.25677269,0.626464042,1.34409678,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6800484640000001,0.135637954,1.2316457,0.0,0.0366287715,0.5315253879999999,0.918891783,0.144709526,0.0,0.0933130433,1.17825966,0.0,0.44641889100000004,0.6916565290000001,1.34158494,1.20146444,1.4733761,0.497911001,0.0,0.244154696,0.5861594179999999,0.328799857,0.0,0.0,0.0,0.243554875,0.282127782,0.21844387,0.314552382,0.0,0.0,0.461328969,1.57744884,0.244787778,0.0,0.0,0.0,0.059612973300000004,0.501838814,1.21610479,0.886264823,0.0,1.44817886,0.97363923,0.677266797,1.52361007,0.0,0.0,1.94216911,0.0,0.447660186,0.0,0.8538490470000001,0.748889885,0.2898002,1.76733689,0.325428396,2.88805309,0.0,0.879359872,0.743486379,0.0,0.381240985,1.78505017,0.652470824,0.331075764,0.0,0.0,0.0,0.5381002779999999,1.18446303,1.69069886,0.815316522,1.19217975,0.0118662853,1.09377879,2.23121261,0.6260091839999999,0.139019738,0.513116479,0.0,0.0,0.0,0.0,0.0,1.18742116,2.68797558,1.44078381,1.49266965,2.27269316,3.32868354,2.67641413,5.14859418,5.81992493,3.67630226,4.42417831,4.54733674,3.04916425,2.63593885,1.92800518,0.533997889,0.371360729,0.170783834,0.726284348,0.0,0.0,0.5582773910000001,1.45187314,0.780855427,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.104901445,0.0,0.40892390799999995,0.36599816,0.0,0.0,0.0727680845,0.05166021480000001,0.0,0.0,0.163222321,0.0,0.0,0.110641731,0.0,0.19537041,0.0,0.04479046230000001,0.276611631,0.0,0.0,0.0,0.103687233,0.232281127,0.0,0.0447897096,0.235184455,0.791647488,0.471601437,1.16485539,2.09586192,1.22869937,0.027114441200000002,0.0,0.430665863,0.517201722,0.360890293,0.363000599,0.649525915,0.732121778,0.817345055,0.780601105,0.0,0.0,0.0,0.306805653,0.0,0.20371072399999998,0.286950028,0.346328945,0.442516645,0.169761164,0.403485672,0.349502074,0.0,0.0,0.37982000299999996,0.118751969,0.0,0.322648426,0.427559905,0.599013459,1.42373829,1.74786212,1.08224694,1.34968453,3.16284089,2.39788469,1.08835258,0.21207161800000002,0.0484382014,1.43978575,2.57772795,0.9279136170000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.28128529399999996,0.36284956399999996,0.098737719,0.48146693,0.0,0.0,0.10520956599999999,0.929068758,0.902636234,0.36554701100000003,0.509604643,0.637826392,0.736539478,0.0,0.0,0.0170764708,0.267610384,0.649023104,0.0533916376,0.888205474,0.803537231,0.26398441899999997,0.827273006,0.41886650700000005,0.46456042399999997,0.497112901,0.520753727,0.0,0.48113175,0.109304834,0.0,0.0,0.0,0.0,0.08940334289999999,0.0,0.403598767,0.211225291,0.0,0.36205067399999996,0.7127950740000001,0.636059968,0.059120294299999994,0.453122646,0.393989409,0.0,0.0,0.0,0.27448021,0.28379288399999997,0.0,0.0,0.0,0.061341756100000006,0.189809085,0.18796641,0.22866749,0.0,0.0,0.0,0.0,0.38050239799999996,0.0,0.0,0.161813591,0.0384325892,0.0177368754,0.0,0.418822743,0.0,0.0,0.32305087,0.34695704,0.0,0.0,0.166486299,0.0,0.0,0.0170115027,0.0,0.147576328,0.255142616,0.0625030136,0.491561487,0.25790131,0.0,0.436157303,0.5688496829999999,0.5011017720000001,0.0289884675,0.5688301060000001,0.418278159,0.211588047,0.0028762817,0.201348561,0.11013360800000001,0.0,0.053995357300000005,0.477559797,0.23808502,0.0,0.204564921,0.0,0.148618657,0.0,0.189258067,0.0,0.0459253805,0.108371341,0.200867993,0.274288549,0.137886834,0.7200774320000001,0.72260503,0.08484953710000001,1.03059349,0.952070097,1.5055009,2.31850259,2.9591833999999997,3.75275398,4.98277254,4.58355466,3.81867739,3.82609789,2.77382093,1.8159792000000001,0.9605332540000001,0.7344332840000001,0.526028565,0.135571473,0.111155775,0.114488095,0.0,0.0,0.0,0.0,0.44091381799999996,0.23309953,0.325620452,0.174569912,0.17103685100000002,0.47339055,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.25238648,0.37234772,0.49356337,0.61277039,0.72685621,0.83293801,0.92842698,1.0110774,1.07902132,1.1307905,1.16532714,1.18198575,1.18052805,1.16111282,1.12428207,1.07094456,1.00235703,0.92010305,0.82606871,0.7224143,0.61154052,0.49604802,0.37868908,0.26231055,0.14978784,0.04395035,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.05370313,0.12865272,0.1980501,0.25821976,0.30585371,0.33818926,0.35317246,0.34959875,0.32722231,0.28682675,0.23025171,0.16037096,0.08102065,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09531994,0.28659067,0.51260158,0.76904494,1.05017251,1.34896466,1.65735921,1.96653158,2.2672152000000003,2.55004915,2.80593823,3.02641024,3.20395473,3.33232838,3.40681325,3.42441634,3.38400122,3.28634558,3.13412175,2.93180082,2.68548418,2.40266974,2.0919629,1.76274474,1.42481196,1.08800386,0.76183272,0.45513298,0.17574416,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.02342191,0.13385191,0.22962772,0.30679573,0.36255475,0.39531645,0.40470967,0.39153105,0.35764679,0.30585243,0.23969907,0.16329567,0.08109759,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.02945892,0.13699969,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.22804617300000002,0.25649963600000003,0.0762352421,0.0,0.0,0.0,0.12134220300000001,0.263532031,0.17930786899999998,0.0,0.0,0.0,0.0,0.253180958,0.297651508,0.0790859174,0.0,0.0,0.0,0.185436792,0.420473005,0.300153271,0.0,0.0,0.0,0.0704630938,0.841369768,1.38841208,1.41236075,1.00885327,0.592643732,0.554931871,0.922013486,1.30350661,1.20273078,0.468381585,0.0,0.0,0.0281852375,2.0267318,4.34520088,5.83859179,5.73209387,4.09996647,1.80951555,0.0,0.0,0.0,0.50361061,1.01518457,0.8899881040000001,0.331176541,0.0,0.0,0.0,0.259187499,0.352776584,0.154048259,0.0,0.0,0.0,0.108134475,0.27866100899999996,0.221643395,0.0,0.0,0.0,0.0,0.127218455,0.173752787,0.07148457429999999,0.0,0.0,0.0969017936,0.309066651,0.403833812,0.29274517699999997,0.045801010999999996,0.0,0.0,0.0,0.13225187800000002,0.19405634800000002,0.0892565149,0.0,0.0,0.0,0.044102576,0.17181781399999999,0.15125587199999999,0.0,0.0,0.0,0.0,0.127517274,0.19389146399999999,0.0920424985,0.0,0.0,0.0,0.149770422,0.3503542,0.338310392,0.126833569,0.0,0.176920889,0.97738381,2.22944683,3.4823627,4.19013044,4.02177039,3.06213666,1.76993474,0.7139235420000001,0.252338584,0.356646677,0.68349201,0.8338908540000001,0.618704508,0.155255255,0.0,0.0,0.0,0.152723896,0.315699722,0.215279917,0.0,0.0,0.0,0.0140926188,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.6267129779999999,0.19900382,0.120653845,0.0,0.24378320399999998,1.71300512,0.8375303159999999,0.599974296,1.58816553,0.6266981229999999,1.40119181,0.730312822,0.316107582,1.02533973,0.6667245039999999,0.0,1.10672734,0.776304298,1.28141558,0.0,0.0,0.0,0.7884294690000001,0.423841168,0.15792456400000002,0.271015708,0.0,0.109225142,0.562451834,0.0,0.391972869,0.7633758429999999,0.7676240209999999,0.0,0.0,1.34253085,1.65848107,2.56790694,2.37672143,2.86944522,4.69087388,3.91321606,2.82158609,1.62205998,0.929661947,1.79027523,0.72097879,0.22070948399999998,0.128256967,0.0,0.0,0.0,0.32174840600000004,0.0,0.008728378699999999,0.0,0.0,0.0,0.33454127100000003,0.0,0.623431952,0.0,0.0,0.0,0.580385012,0.0,0.0,0.0,0.436588941,1.22622671,0.414582306,0.0,0.693879624,0.0,0.0,0.426912191,0.829486407,0.0,0.029237238999999998,0.0563720637,0.0,0.43069077899999997,0.017530526499999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.79194591,0.63907456,1.44708905,1.86697687,1.08497372,2.08571628,1.06416789,1.72868785,1.38287671,1.88990816,2.5038132,2.36730401,2.87553027,2.59506302,2.5858988,1.74286662,3.03330653,1.78010097,1.41199913,1.60792359,1.96020209,0.86070545,0.17859165,0.9263207,0.13855081,0.24178872,0.0,0.0,0.22824956,0.82313466,0.53268555,0.21067306,0.61431633,1.03824437,0.0,0.0,1.03028618,0.6536673000000001,0.64786167,0.30288696,1.42726687,0.87994897,0.9040219999999999,0.11339458,1.26306593,0.40807431,0.98800116,0.35582169,0.68869692,0.66660373,0.0,0.0,0.86575236,0.0,0.0,0.74457644,0.0,0.06542585,0.0,0.2466435,0.0,0.77294345,0.0,0.47791649,0.23473437,0.46537392,0.0,0.46642799999999995,0.67573174,0.0,1.19526621,0.0,0.34936041,0.0,0.18380666,0.35842090000000004,0.0,0.57069347,0.27391355,0.34234632,0.0,0.0,0.27241856,0.0,0.63285306,0.0,0.24377376,0.57206146,0.0,0.0,0.45326947,0.0,0.46600829,0.0,0.64037464,0.18122116,0.0,0.22545791,0.0,0.0,0.75431875,0.0,0.99270047,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.167901312,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.405425307,0.8687349109999999,1.36672836,1.87488059,2.3674312,2.81890047,3.20561588,3.5071470000000002,3.70755164,3.79634782,3.76914462,3.6278881000000003,3.38070475,3.0413533,2.62832241,2.16363675,1.67145379,1.17654771,0.7027841979999999,0.27168919399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00837641232,0.172750383,0.307223183,0.40294554299999996,0.45492521,0.46213849100000004,0.427335873,0.356569852,0.25849337899999997,0.14349326199999998,0.0227333444,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.05130364900000001,0.133615548,0.200478823,0.24647196,0.26823206,0.264675406,0.237012922,0.188565725,0.12440280199999999,0.0508374142,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.006360324109999999,0.0710684635,0.127963682,0.17199201,0.199360487,0.207855657,0.197015518,0.16814215899999999,0.12415648,0.0693103408,0.00878377655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0361230612,0.09100971599999999,0.137255512,0.17062824399999998,0.188083355,0.18803594,0.17050092,0.13708938699999998,0.090861883,0.03605198,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00883679204,0.0699127632,0.125630366,0.170772413,0.20097282100000002,0.21311278399999997,0.20561387,0.17860266,0.13393253,0.0750603071,0.0067878485300000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0731918946,0.19070803,0.311836357,0.43011763299999994,0.539432878,0.634433037,0.7108943059999999,0.765972179,0.7983365109999999,0.808180452,0.797107096,0.76790805,0.724257099,0.670348811,0.610515829,0.548859431,0.488925623,0.433453906,0.38421835600000004,0.341971574,0.306492178,0.27672679899999997,0.25100886,0.22732960100000002,0.20363237399999998,0.17809972899999998,0.149404125,0.116897339,0.080720138,0.0418220749,0.00189048016,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.027494673100000002,0.0901764992,0.158444955,0.22975113100000003,0.301867953,0.373158416,0.44278243700000003,0.5108156389999999,0.578261116,0.6469452520000001,0.719300136,0.7980469020000001,0.885805416,0.984665035,1.09575764,1.21887713,1.35218873,1.49206606,1.63308552,1.76819488,1.8890588,1.98656824,2.05148513,2.07517977,2.05040693,1.97205947,1.83783546,1.64875727,1.40948901,1.12841077,0.817425297,0.491491625,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.254874718,0.22696823300000002,0.0,0.0,0.338434865,0.0,0.163483889,0.0,0.0,0.0,0.33346279999999995,0.0,0.269887477,0.0,0.299685036,0.36457378700000004,0.0,0.240116873,0.0,0.180007571,0.0,0.0,0.202398539,0.334527423,0.0,0.0,0.0,0.221284019,0.09930266160000001,0.0627178349,0.0,0.0,0.0,0.0,0.160533425,0.251851169,0.152901621,0.0,0.159746379,0.0,0.294153158,0.24003757,0.0,0.148917797,0.0,0.0558499818,0.304392399,0.30673972,0.0,0.325398882,0.295984633,0.0,0.259555558,0.0646656293,0.29018794,0.30603406699999997,0.0,0.23771879699999998,0.0,0.0614101179,0.109025149,0.0,0.06675222389999999,0.0339621778,0.0,0.177668758,0.364014816,1.1197540000000001,1.57221195,2.56198446,2.67965001,2.49376106,1.73804786,0.758622293,0.0,0.0,0.0,0.1708682,0.98583246,2.23012334,3.40236534,3.29341282,3.42469613,3.29219269,2.32951374,1.31752005,0.503505141,0.30354618899999997,0.7676724629999999,0.44659391600000004,1.15006151,1.30416331,1.0542321000000001,0.806923321,0.525856781,0.134027542,0.0,0.0,0.0,0.209987604,0.0,0.208898837,0.0,0.044664336500000006,0.267079032,0.280891597,0.323606989,0.0052307106599999995,0.39249141,0.101005321,0.0,0.0,0.0,0.055698591799999995,0.105028981,0.185237364,0.0,0.0,0.0,0.334083262,0.0923434231,0.21189008199999998,0.154143638,0.24545852199999998,0.0,0.0,0.301963963,0.0113881916,0.131955976,0.385870621,0.260216789,0.0,0.45363216100000003,0.0,0.0709262546,0.0,0.0951807294,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
2.42782657,0.920356982,0.0,0.43207247600000004,0.44098384399999996,0.0,0.7773848329999999,0.17781033300000001,0.027030368399999997,0.07586876440000001,0.784087538,0.0,0.0,0.105434359,0.0,0.0,0.0,0.405097376,0.224055907,0.122980021,0.0,0.0419139789,0.0,0.0,0.35603904399999997,0.00806815782,0.0,0.0,0.6929316790000001,0.0726741759,0.0,0.243164771,0.151603945,0.0,1.0389084000000002,2.2589523999999996,0.5386455410000001,0.230961903,0.152219733,0.0697139697,0.0,0.0551323746,0.0,0.611199578,0.104310023,0.042700474,0.0,0.654251571,0.0,0.0,2.1561199,4.16789488,1.98379603,0.0,0.0,0.969723824,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18045337399999997,0.0,0.0,0.0,0.0,0.0,0.302661611,1.14083848,2.02741395,2.6514275,2.03855025,3.35768375,4.26986889,5.1620492,4.19635246,2.02292264,1.0891879999999998,0.0596639025,0.174518786,0.59175193,0.438098119,0.165390601,0.0,0.21447640699999998,0.0,0.5438564379999999,0.8651487309999999,0.648079064,0.9510039570000001,1.75583404,0.906514615,0.636414276,0.940991679,0.0939578459,0.0,0.752528545,0.0396969227,0.0,0.5065151170000001,0.00691118569,0.0,0.721673008,1.90029519,1.57363143,0.154526721,0.265013496,0.0,0.0,0.0,0.0,0.0,3.29760795,5.22736084,1.13355027,0.0,0.809928083,0.303434859,0.0,0.64639961,0.906872717,0.13128520800000001,0.0,0.205146205,0.0,0.0,0.0,0.0,0.09624733099999999,0.41080832,0.38245043799999995,0.0,0.55969624,0.0,0.0,0.0,0.66773317,0.0,0.415367559,0.355066262,0.265606708,0.0,0.18616229899999998,0.0,0.0,0.590968681,0.0855737797,0.0258875825,0.273862487,1.14043356,1.47726544,2.73243436,2.16079851,0.39779593799999996,0.57404539,0.886682162,0.0,0.08912413820000001,0.229897328,0.0,0.0,1.02378154,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.187018372,0.366775808,0.102369585,0.0,0.0,0.0,0.466484484,0.0,0.0,0.0694414211,0.0014795504199999999,0.316468292,0.36425318,0.167891662,0.227597375,0.79362349,0.09348120380000001,0.255847897,0.784465712,1.85679766,3.39151931,2.79567391,1.31526932,0.0,0.0,0.0,0.324538575,0.129281871,0.031263917999999995,0.281079325,0.49197314200000003,0.386569259,0.513633233,0.0,0.33952632,0.263477372,0.0,0.0,0.22801101699999998,0.25321044600000003,0.250513382,0.0788888253,0.21432373,0.0,0.0,0.00732060551,0.192350438,0.0,0.37634327700000003,0.48641594,0.34209618799999997,0.194848994,0.535483133,0.734191901,0.514997705,0.362003949,0.31765756,0.150945262,0.370037015,0.383801942,0.421594522,0.21462288,0.25870505,0.288785215,0.0,0.216087132,0.323582005,0.27470984600000004,0.0,0.0,0.165366601,0.49407046,0.380018995,0.25946783,0.0739200953,0.348106463,0.425526112,0.0353078817,0.25894732600000003,0.28143679899999996,0.0151709073,0.193556399,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.333676692,0.447747829,0.29543504600000003,0.866032373,1.04762952,0.934152628,0.0,0.355271609,0.0,0.0167483948,0.356064295,0.0,0.0,1.18537817,0.0,1.01630387,1.06954925,1.23793158,0.547606713,0.701470803,0.370274356,0.8173749790000001,1.87309976,1.32487053,1.3687208999999998,1.84069967,1.82543409,0.480340314,0.67869035,2.07023336,1.46587364,0.0,0.0,0.104701469,0.483462079,0.0,0.415964567,0.0,0.186640319,1.75627683,1.13721527,2.14395181,1.68885602,2.07827761,3.62119153,3.29771991,1.73973583,2.73428693,1.44297884,1.83321421,1.34685403,0.245597337,1.79290897,0.280217689,0.0,0.26445498300000003,0.0,0.0,0.485559686,0.0,0.276682932,0.145300397,0.538503547,0.0,0.0,1.5259761,0.13746757099999998,0.91018445,0.20326493199999998,0.480587631,0.0,0.21261659100000002,0.19596377899999998,0.0,0.0,0.0,0.42171677,0.0,1.18466318,0.0,0.0994070051,0.132958115,1.63532797,2.12472748,0.102566409,0.425558008,1.01062563,0.38495240000000003,0.250587231,0.0,0.0,0.0,0.998223788,0.0,0.0,0.0,1.05433218,0.0,1.69216721,0.7691082140000001,0.0,0.698888299,0.0,0.0,0.0,0.766433068,0.0,0.341954799,0.0,0.0,0.86900547,0.0,0.365068493,1.16819244,0.0,1.22138029,2.58008063,1.69971131,1.13521836,1.24998606,2.49488416,3.22284728,2.36024605,3.50016065,3.60337917,4.70293671,3.28702844,2.64862512,3.29709502,1.48269884,1.33263979,1.31388814,0.863924417,0.0,1.14193719,0.0,0.0,0.0,0.639437379,0.317622826,1.06521812,1.02965279,0.133664736,0.0,0.0,0.263608891,0.0708651198,0.0,0.547173908,0.0196394387,1.26056703,0.214188973,0.0,0.0,0.79487729,0.0,0.0,0.0917953063,0.0,0.470964006,0.0,0.0362448425,1.57712357,0.559721138,0.0,0.0,0.480358003,1.58183976,0.83288256,0.0,0.0,0.0,0.0,0.0,0.582204255,0.0,0.265647482,0.0,0.450338167,0.427157971,0.0,0.0,0.442522701,1.22020268,0.0,0.556345733,0.0178401436,0.9688670159999999,0.157408308,0.0,0.0,0.0,0.0,1.08924453,0.402327986,0.0,0.0,0.0,0.0,0.394009145,0.0,0.0,0.0,0.0346135672,0.0,0.20138923,0.655344134,0.0,0.8792262209999999,0.491941255,1.89829668,0.0,0.0,0.0,0.521254297,0.0,0.0,0.9829038640000001,0.939120245,0.0,0.330939935,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.958950814,1.23919266,0.324223489,0.0,0.0,0.167935484,0.0,0.0,0.090760141,0.0023623313199999997,0.0,0.0101099188,0.0,0.248646156,0.992614984,1.26674679,0.6822701309999999,0.0905415108,0.0,0.0,0.134047007,0.27790283600000004,0.11143245800000001,0.0,0.0,0.10235490800000001,0.0,0.0,0.0908254108,0.00943644758,0.0,0.0639740867,0.162274372,0.031957311099999997,0.138976088,0.566176406,0.839442402,0.7754283909999999,0.648726227,0.7043770970000001,0.7495245009999999,0.39164257399999997,0.0165524354,0.483686555,1.21910144,0.797257874,0.0,0.0,0.42986153200000005,0.055955862,0.0,0.34685747200000006,0.755722343,0.289371405,0.0689827328,0.178090308,0.0,0.0,0.17000501199999998,0.0240069076,0.331098637,2.2853266,3.65362369,2.28162901,0.510248866,0.6621960020000001,0.9805446109999999,0.251776144,0.238171217,1.09350852,0.8505829690000001,0.0,0.0,0.210814105,0.046210090599999996,0.0,0.0539305246,0.09395553539999998,0.0,0.0,0.0825619607,0.0,0.0,0.0475815724,0.012976971399999999,0.0,0.0128928295,0.024105584300000003,0.0,0.0,0.011337875,0.0,0.005255751529999999,0.0,0.0,0.122459419,0.208398172,0.13648891800000001,0.181903691,0.347230837,0.246153087,0.0,0.0,0.0546466859,0.0181111346,0.0,0.012299669899999999,0.0307225352,0.0,0.0,0.0279185345,0.0,0.0,0.043229257300000004,0.22112684600000002,0.630629012,1.2739197,1.87648787,2.17330434,2.14260777,1.91136993,1.55947114,1.06813469,0.544052998,0.297944731,0.384083842,0.440750055,0.33876787399999997,0.34344728700000005,0.416645447,0.24841284600000002,0.0,0.0,0.0366410348,0.0552885471,0.113753538,0.20159957,0.121839851,0.0,0.0,0.0325613678,0.0,0.0,0.0153086205,0.00800168567,0.0,0.00231194016,0.0101657351,0.0,0.0,0.005818790429999999,0.0,0.0,0.0011631757300000001,0.000504305191,0.0,0.000951259592,0.0353796723,0.09082527619999999,0.147978937,0.34275711299999995,0.705383565,0.8314533909999999,0.581254069,0.651702475,1.34447731,1.7068803,1.20649413,0.822222232,1.17296328,1.38608876,0.931990903,0.627307835,1.02625573,1.58212239,1.81115935,1.91666103,2.12539838,2.28122248,2.19467044,2.03972734,2.15686194,2.4360362,2.39489591,2.03347631,1.8538411,1.95295268,1.97494018,1.80543284,1.51916445,1.05697558,0.506685545,0.203416581,0.348280985,0.849642164,1.39435686,1.67396306,1.72860918,1.62040495,1.00982975,0.0963802631,0.039594469199999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.433879,0.12235845,0.0,0.09512921,0.0,0.14614582,0.0,0.21325756,0.0,0.57762468,0.10112746,0.11052488,0.0,0.22458083,0.0,0.33414445,0.0,1.76781637,1.77416137,1.44846836,0.0,4.56607481,3.61010017,0.41795992,0.8556198,0.8766357,1.88218935,1.70768301,1.42457862,1.82585383,3.47277184,6.54596239,2.93237596,3.16447388,2.41023187,11.78321871,6.83490699,0.34092692,0.54016801,0.0,0.11924026,0.0,0.0,0.07332215,0.0,0.71969891,1.43031393,1.43744883,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
1.55662248,0.0,15.10679846,0.97345652,0.0,0.72748318,0.38508254,0.0,0.85642977,1.57278991,0.0,2.3534002999999997,0.0,2.53645245,1.4398753,7.75101929,3.04277137,0.0,0.0,0.0,1.34208929,0.0,0.05469354,0.0,1.07658032,1.31540557,1.00644099,0.0,0.0,0.0,0.92447479,1.10250861,0.85907293,0.32507907,0.0,0.0,0.0,0.0,0.89768905,1.27221325,2.90269393,4.90131789,0.0,0.0,0.0,0.77511725,0.0,0.0,0.35728836,0.0,1.27468146,0.94703818,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.42075196,3.52169849,3.15514043,2.10381403,1.93492616,0.0,0.0,0.0,0.122314495,0.0,0.0,1.25269889,0.0,1.98765122,0.0,0.0,1.09171648,2.19169552,0.111742121,0.0,0.539309839,2.95893328,0.930715785,0.0,0.730873986,0.331851397,0.24851459899999997,1.31717982,0.248999805,0.0,0.0,0.0,0.8915611040000001,0.0,1.09399664,0.0,0.409940475,1.59883163,1.66988943,0.36956119,0.0,0.0,1.64107527,1.84878217,0.0,0.0,0.0,0.0,0.0,1.32031359,0.31954039100000003,0.0,0.0,0.7531930520000001,0.425373622,0.0,0.907364298,1.7709615,0.88419846,0.0710817829,0.0,0.672764824,0.0770676553,1.07265194,0.592325285,0.0,0.0,1.05746931,0.0,0.665589807,0.379742194,0.0,0.0,1.92756674,0.0,0.0,0.0,0.319302894,0.039447427400000006,0.0,1.70102434,0.20751076100000002,0.645229997,0.0,0.0,0.901377573,1.71162116,2.49316725,2.44052557,0.0,0.0,0.755455705,1.85649643,1.67619331,2.51577254,3.78107552,2.76222835,1.87515072,1.72667052,3.29708367,1.85153411,2.67511743,2.15015733,0.76066709,0.0,0.516927252,0.0,0.0,0.0,1.10577708,0.0,0.123324037,0.0906980267,0.0,0.871892604,0.0,0.0,0.229251437,1.21234578,0.0,0.0,0.59404883,0.0,0.0,0.111601369,2.70779071,1.98698013,0.0,0.7548516409999999,2.52725775,1.46564077,0.370819057,0.0,1.06294694,0.0,0.0,0.0,1.28237611,0.40849110299999997,0.0,1.9364246999999999,0.0,0.7548864359999999,0.0,0.822476889,5.5139892,5.87961975,3.21735439,1.22888585,0.0,0.237331787,0.0,0.741757695,0.0,0.0,0.0,2.06030172,0.0,1.28979828,0.0,0.0,0.0,0.0,0.217774474,0.7055904959999999,0.0,0.0,0.960802646,0.7707275440000001,0.55777704,0.0,0.55860507,2.71115834,0.820966203,0.0,0.0,0.0,0.0,0.8166695140000001,0.0,0.0,0.0,0.817696105,0.39093015700000006,0.811200057,0.0,0.0,0.0,1.11244622,1.44631145,0.0,2.4064475,0.0,2.03212692,0.458298854,1.20141495,0.0,0.347378784,2.4282279,1.80907289,1.6926245999999998,3.07712521,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
3.45618244,2.91719571,2.5217436,1.99094193,1.24473615,0.54191986,0.08988322,0.20075886,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24956139,0.67366607,0.44722992,0.36162484,0.34738177,0.0,0.23390458,0.0,0.0,0.0,0.0,0.0,0.10141177,0.12808472,0.0,0.06657312,0.2221008,0.34401046,0.53488889,0.54079922,0.16298372,0.0,0.15693458,0.08258439,0.0,0.0,0.0,0.0,0.13091283,0.0521061,0.0,0.51166559,0.3728861,0.32010228,0.13718628,0.19258499,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.01574239,0.33172483,0.3475123,0.45488941,0.2898361,0.50903271,0.0,0.11930744,0.24960639999999998,0.03953928,0.15002409,0.0,0.0,0.0,0.0,0.10685981,0.05690428,0.0,0.26760667,0.58571203,0.72650192,0.35852791,0.21716708,0.0,0.07396502,0.0,0.0,0.0,0.0,0.0,0.0,0.27053996,0.62212849,0.9735671,1.69018825,1.98390102,2.98122716,3.39233548,3.45768963,3.09262423,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.48113269,0.557559334,0.0695503977,0.656137842,2.1034146000000002,2.8615744,1.68248798,1.48199958,1.11066781,0.340770443,0.0,0.0,4.6300751,7.33301955,5.16853308,2.03621269,3.29469872,4.23871437,3.76080275,1.69046432,0.154063176,1.7128623,2.12254645,0.566664787,0.0,0.0,0.8983454479999999,0.7195133359999999,0.0,0.479194114,0.9712673470000001,0.0188265882,0.340674542,0.0,0.035451900099999996,0.0,0.0,0.649146728,0.5362154889999999,0.20346070800000002,0.22350772600000002,0.36168220100000004,0.112656535,0.23397463899999998,0.30829766,0.43045067,0.6047038770000001,0.0,0.297823173,0.371449598,0.274548573,0.09780776349999999,0.0,0.0811365013,0.0,0.0263555576,0.0,0.0,0.0,0.0,1.19083462,1.98544732,1.62072806,2.38507286,0.643934362,0.810092105,1.01361373,0.0,0.0754472533,0.7365063390000001,0.00827057003,0.744232085,0.0,0.60798889,0.491340449,0.0,0.0,0.0,0.296301531,0.422710659,0.6611967529999999,0.234555813,0.0,0.0,0.814574613,0.663487685,0.0,0.0,0.0,0.0,0.462395496,0.0,0.341560075,0.0,0.0,0.769590608,0.0,0.0,0.0718968969,0.0,0.9158993209999999,0.104932493,0.0,0.0,0.14131598,0.0,0.0,0.46413103,1.12956482,0.33193783,0.0,0.25104458,4.47537755,7.21466289,5.50998534,3.36170501,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.54415113,0.0,0.0,0.0,0.0,0.0,2.02628996,0.60211375,0.70321122,1.77878678,0.84614224,0.0,0.0,1.33070289,0.0,0.0,0.0,0.0,0.0,0.0,0.13561126,1.00114838,0.0,0.0,1.2106122,2.72550359,0.0,0.0,1.17776163,2.87738409,6.73725938,5.59070702,0.15605184,1.21209897,0.0,3.99642054,2.85520869,0.0,0.0,0.72953376,3.63674318,1.55131896,0.0,0.0,0.36583293,2.19092644,0.0,0.0,0.66335814,0.0,0.27337348,1.59516145,0.69279897,0.24761822,3.25548814,0.56530863,0.0,1.57067531,0.0,0.0,1.46349179,0.78904158,0.0,0.65381966,0.0,0.0,0.93362747,0.60195782,0.34114458,0.0,1.3784121999999999,0.24476456,0.0,0.22902572,1.57472166,0.0,1.1634927,0.0,0.22168371,0.55501843,0.0,0.0,0.0,1.79816203,0.0,0.0,0.0,0.43290279,0.34641017,0.10327525,0.0,0.34666274,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.46186458,0.0,0.0,0.0,0.266713472,0.00136596385,0.08958102009999999,0.0,0.418484966,0.521835611,0.284208912,0.439664059,0.391077248,0.61280098,0.667863353,0.464890322,0.824791541,0.654687124,0.570749007,0.289597073,0.494337215,0.0,0.23984304899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.214640866,0.0,0.266148412,0.0,0.0,0.22136685399999997,0.0700991176,0.0916636839,0.0,0.158212333,0.0,0.042064332,0.0,0.253650928,0.0276705196,0.0,0.293629976,0.0038745794299999995,0.0,0.0,0.122526725,0.38072658600000003,0.138387654,0.0,0.05671134269999999,0.133017357,0.360276227,0.0,0.09349199050000001,0.0,0.06587043940000001,0.23309806600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0893920526,0.176869749,0.0,0.257268534,0.298622834,0.278330471,0.0,0.0,0.0,0.0251631698,0.0,0.308873384,0.0,0.347197728,0.0,0.0,0.252665619,0.210137608,0.469102629,0.0,0.388932919,0.602476649,0.692293135,0.200688647,0.795322482,0.193387115,0.128861997,0.0,0.0,0.286064852,0.0,0.0186571307,0.0,0.0,0.033388656600000004,0.0,0.09776421119999999,0.41289148299999995,0.0,0.0638690746,0.0440216833,0.0273654647,0.390214978,0.24055004600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17322665399999998,0.368247582,0.651011745,0.487418041,0.66366112,0.0,0.0,0.013387258999999999,0.0,0.0,0.0,0.267717494,0.150065306,1.17113286,1.61136094,2.03041251,2.57113411,2.92381407,3.69521533,3.84402802,3.22042072,3.3924870000000005,2.78999057,1.82383101,1.66094859,0.761299415,0.618628327,0.14312002599999998,0.146702894,0.0,0.525524734,0.585822367,1.18911366,1.93639404,1.9084487,2.11759743,2.23746223,1.68589796,1.31538729,1.00897244,0.617073601,0.16759744099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.110635201,0.53736556,0.626369918,0.621110515,0.354870325,0.14786359699999999,0.0195713525,0.0,0.0,0.0,0.0,0.00691155473,0.0,0.0745117783,0.24282681399999997,0.309165945,0.0,0.241054346,0.145609945,0.0,0.245812583,0.29416632600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.5162612910000001,0.260789841,0.66981309,1.12092888,1.30800726,1.5260733,1.40171963,1.44223315,1.45980687,0.7707581179999999,0.6400795979999999,0.61514201,0.765956236,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
5.11845255,0.0,3.71568673,0.42809558,0.67509004,0.0,0.0,0.0,3.55914699,0.46088416,0.97416952,0.0,4.09615811,0.0,0.0,0.0,0.0,3.83891496,0.0,0.0,0.0,0.0,1.96142229,0.0,0.0,0.0,2.61626485,8.3124199,10.692419099999999,3.80914714,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.24399205699999998,0.288088895,0.327691041,0.391036806,0.511378023,0.695648066,0.907280642,1.07573726,1.12996031,1.03871311,0.83548727,0.612442725,0.483370313,0.531940057,0.770040498,1.12724532,1.47803362,1.69539152,1.70668257,1.52639618,1.25109091,1.01924365,0.9544091809999999,1.11678538,1.48323629,1.96200448,2.43268661,2.79192629,2.98494623,3.01179772,2.91009219,2.72650315,2.49271891,2.21691791,1.89234719,1.51543194,1.10158503,0.689202326,0.329438052,0.0671998197,0.0,0.0,0.0,0.0,0.023343688799999998,0.037722444300000005,0.026548515,0.006888089379999999,0.0,0.0,0.00400453927,0.00490640588,0.0,0.0,0.0,0.0,0.0462726509,0.194484057,0.40369539200000004,0.6488636179999999,0.897533923,1.12048924,1.29920341,1.426987,1.50402636,1.52964813,1.49659943,1.3912195,1.20047816,0.923259693,0.580611099,0.21924294,0.0,0.0,0.0,0.0,0.0959856072,0.45612409299999995,0.805439372,1.06893116,1.20564572,1.21887614,1.14893093,1.05142068,0.970493849,0.919123664,0.8758296720000001,0.799899019,0.658306176,0.451219921,0.222523544,0.047948471500000006,0.00387063756,0.129852995,0.40267756299999996,0.736073399,1.00952215,1.11596535,1.00825789,0.722948425,0.36877380600000004,0.0827256155,0.0,0.0661738797,0.305873479,0.567857567,0.7224743709999999,0.693408195,0.492900457,0.214751752,0.0,0.0,0.0,0.167474234,0.294631127,0.257518428,0.023494925299999997,0.0,0.0,0.0,0.0,0.8139049559999999,1.95018237,3.02009086,3.69552094,3.74978109,3.14612863,2.0576806,0.8100610570000001,0.0,0.0,0.0,0.0,0.670666002,1.50654575,2.08794208,2.2825164,2.09327651,1.63118543,1.05819078,0.52702007,0.139479313,0.0,0.0,0.0,0.0893677176,0.224607895,0.330202283,0.38675781,0.392295025,0.361192777,0.319585888,0.295715104,0.307000798,0.349433745,0.39609910600000003,0.408434266,0.357120814,0.24287107300000002,0.105028401,0.0102152265,0.022968685899999997,0.17073743100000002,0.420970866,0.684553625,0.848182329,0.82366924,0.591999831,0.220075488,0.0,0.0,0.0,0.0,0.156158959,0.519081682,0.7481402909999999,0.773306657,0.614600637,0.364466655,0.137735665,0.0150838051,0.00841271861,0.0645873167,0.10363383300000001,0.0693777706,0.0,0.0,0.0,0.0,0.0517155829,0.244572615,0.341322005,0.267322208,0.0393379087,0.0,0.0,0.0,0.426852997,1.2773552,2.1914377999999997,2.89428715,3.16139367,2.90785853,2.22250305,1.33204976,0.511523544,0.0,0.0,0.0,0.321322724,0.626484119,0.7800843679999999,0.7480123409999999,0.584170325,0.385954521,0.23928331100000003,0.18144556899999997,0.19716018300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.584267385,0.677418623,0.187216119,0.275589157,0.0,0.5081862229999999,1.64184994,0.326000554,0.760687305,0.0,0.0,0.657217498,0.163010565,0.634527806,1.31287774,1.13827121,3.20629272,3.49728648,2.60871227,4.10080398,3.80769689,3.89653871,2.55428873,2.6961068999999998,0.779504753,2.24463605,0.8729155690000001,0.531790446,0.784637035,2.39812084,0.0,0.00951008823,0.0,0.0409065154,0.4437684,0.80833561,0.0,0.0,0.0912008098,0.23157419699999998,0.0,0.36960124200000005,0.0,0.0,0.0,0.0,0.215130367,0.0,0.15091659300000002,0.0,0.512992808,0.0,0.0,0.261078816,0.0,0.642081749,0.0,0.0,0.0,0.0,1.03671224,1.06508119,0.0,0.0,1.37305473,0.0,0.259233224,0.216986736,0.38136553700000003,0.0,0.0,0.284266545,0.0,1.43050107,0.642389648,0.0,0.550831759,0.566358157,0.0,0.0,0.0,0.0,0.0,0.218471031,1.39904834,0.0,0.0820039331,0.0,0.171113446,0.0,0.0,0.0,1.09187509,1.00201904,1.29350862,0.0,0.0,0.0,0.28524938699999997,0.30515874800000004,0.930019936,0.0,0.27173376,0.40492557799999995,0.0,0.747313969,0.948196125,0.0,0.111825898,1.6179997,0.336269295,0.0,0.319980651,0.0,1.33995758,1.07068547,0.678384656,1.0716083,1.04737854,0.0,0.146116793,0.8442463309999999,0.0,0.0,0.16928763600000002,0.0,0.0,0.0217397798,0.329951373,0.143064532,0.0,0.419436844,0.0,0.31255228399999996,1.22658001,0.0,0.93568137,0.88978516,0.0787255078,0.0,0.84345589,0.0,0.647410982,0.0,0.0,1.23630682,0.168262859,0.160911837,0.0,1.1495578000000002,0.24976332699999998,0.224550445,0.0,0.34804062700000005,0.0,1.61117812,0.608006326,0.0392326925,1.79571841,1.17453216,0.317066171,0.0,0.0,0.080342428,0.0,0.0,0.0,0.468314073,0.0,0.0,0.141414294,0.0,0.0,0.0,1.35040879,0.0,0.0,0.60574126,0.410239874,0.7925713440000001,0.719951362,0.0,1.12022433,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
1.13153361,0.0,0.0,0.059195000000000005,0.0,0.0,0.0,0.0,0.0,1.09527986,0.0,0.0,0.0,0.0,1.33193855,1.40345134,0.12564431,0.0,0.23108913,0.0,0.0,0.0,0.75681168,0.0,0.0,0.61365538,0.54352181,0.67911238,0.0,0.0,0.42165304,1.37444329,0.0,0.0,0.0,0.0,0.0,0.0,1.22618696,1.1662543,0.0,2.46433822,0.0,1.22409182,0.65566294,1.3073593000000001,0.76842838,2.60216139,4.62164378,1.82795385,2.78430826,3.44996382,3.57501496,2.91806367,3.25857913,0.74244402,0.64560625,0.0,0.0,0.0,0.50567627,0.0,0.0,1.51179085,0.39295132,1.42046488,0.0,1.02936635,0.0,0.0,0.0,0.0,0.0,0.0,0.45161464,0.0,0.17222137,0.0,0.86744573,0.0,0.88267761,0.0,0.19572593,0.06470014,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
2.28167484,1.63510387,0.8040110229999999,1.06457383,0.28834709199999997,0.0,0.0,0.301197846,0.0,0.823832456,1.07649273,0.0,0.18349712399999998,0.212016905,0.0,0.0,0.015540941599999998,0.107657663,0.54333148,0.337606319,0.5554075070000001,0.53359992,0.0,0.489080035,0.349387619,0.252254475,0.0,0.116392467,0.0,0.0612267128,0.0,0.418185652,0.0,0.17665205399999998,0.24968692899999997,0.0,0.366923968,0.0,0.978407276,1.67996609,2.39904377,2.90610589,3.9368727999999997,5.78883192,5.60872443,5.95566773,4.52412168,3.9645468999999998,1.84258596,0.607133488,0.0,0.0,0.0,0.0,0.339828364,0.046871586900000005,0.490993396,0.7274611009999999,0.6729658890000001,0.0,0.0,0.0,0.192556437,0.7239932809999999,0.5470965870000001,0.866825293,0.475721651,1.09041297,0.582217237,0.24790678300000002,0.21295940300000002,1.0824155,0.519311525,1.14364145,0.782114793,0.18585722,0.0885585094,0.528552948,0.0,0.0,0.048622260599999995,0.055118302300000005,0.50497839,0.0832693009,0.487627624,0.473504941,0.00847568751,0.447156354,0.0,0.20980711800000001,0.0327519025,0.0,0.0,0.615153242,0.22031822199999998,0.0,0.555811388,0.0,0.223164655,0.318390458,0.0,0.496193051,0.0,0.396669612,0.0,0.0,0.0,0.42576974700000003,0.24641132,0.0,0.339067216,0.188127485,0.306910649,0.110070238,0.26467343,0.468908626,0.287471278,0.0,0.363988466,0.209726982,0.0825530708,0.430534889,0.0,0.0,0.0,0.508468788,0.528711112,0.652488537,0.0,0.106806144,0.419432191,0.0,0.0760961216,0.396338376,0.120452709,0.348246761,0.594989101,0.0,0.165955201,0.14865019599999998,0.0,0.7087802870000001,0.744280368,0.5787039860000001,0.659139405,1.23679702,1.01696719,0.45715659399999997,0.0,0.0,0.0,0.0,0.07335157269999999,0.833748045,2.30627213,3.33575277,2.86165815,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
2.11161733,1.21993416,6.57353763,6.31214447,2.96459232,0.11587089999999999,0.0,0.11534257,2.48173891,0.0,0.0,0.22480611,1.06018221,1.12139465,2.18388955,0.86456538,1.62432172,1.17455035,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
2.15483545,2.15686312,3.50101066,2.99013685,3.45054401,1.67267547,3.2138112999999997,2.5734765,3.18880687,1.65818357,1.84349215,1.92483374,1.06037705,1.12126516,1.26292455,0.99166956,0.60867844,0.46804089,0.40125872,0.09161498,0.90902277,0.01106373,0.0,0.0,0.0,0.0,1.07853859,0.51333346,0.0,0.0,0.57020205,1.27911957,1.98713794,1.39082722,2.08573496,1.37636412,0.95549488,1.88557368,1.81543437,2.78939791,3.01124263,3.30873137,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.28498439,0.0,0.54248185,0.0,0.60610234,0.51597925,0.75511312,0.0,0.19625075,1.02746533,0.0,0.0,0.0,0.66311045,0.68470255,0.7463666,0.0,0.43291024,0.29173183,0.81519241,0.74609935,1.11962695,0.81591674,1.21842444,0.36325247,0.49504255,0.0,0.12004145,0.61809344,0.44071583,0.0,0.0,0.7188971,0.61995081,0.78574033,0.60016738,0.0,0.02895129,0.0,0.11618098,0.90476889,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11700186,0.33691963,0.507363,0.77784375,0.20695697,2.66149279,2.77018474,2.21936477,2.53663795,3.14441768,1.68869313,2.78700397,2.66198006,2.74625655,0.87523026,1.20391001,1.49216569,0.0,0.09264992,0.0,0.0,0.0,0.36052066,0.0,0.0,0.35629502,0.0,1.04685942,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.9371529820000001,1.17865533,0.326504814,0.49161335,0.7696556840000001,0.14795028,0.0,0.431151999,0.312775792,0.761162219,0.574597994,1.54571243,1.94535074,2.56465782,4.0131616999999995,4.24701741,5.40557257,6.41472372,5.93296375,5.73391959,5.31640659,4.70625987,4.34280622,3.37412907,2.13608739,1.68272076,0.131068729,0.0,0.0,0.0,0.0,0.35528439799999995,0.0,1.01780952,0.909529833,1.12799092,0.7098921909999999,0.878039105,0.145203641,0.092203132,0.0,0.387052529,0.586023571,1.13944128,0.598244418,1.54643079,0.7707357440000001,0.796641736,1.46191956,1.22701824,1.33872836,1.03438981,0.0,0.0,0.0,0.0,0.0,0.07624438509999999,0.0,0.0,0.598407647,0.70420662,0.0,0.20573711,0.220429072,0.22783251,0.0,0.0,0.031183308599999997,0.15717482900000002,0.014093251299999998,0.0,0.0,0.0,0.442658475,0.736760651,0.13382291,0.0,0.0,0.0,0.429491413,0.491025119,0.0,0.0,0.0,0.0,0.22197278899999998,0.22412617699999998,0.0420617097,0.48089471,0.575866591,0.0,0.0,0.535093002,0.155234846,0.7181924409999999,0.0,0.576392951,1.2562874,1.09161631,1.37424382,1.2660056999999998,0.745944442,0.569079136,0.189081182,0.0,0.350658828,0.0,0.0,0.340477475,0.0,0.0,0.530671013,0.365049884,0.532248796,0.0,0.322424067,0.186942025,0.0,0.0951743412,0.0,0.162201315,0.0,0.0,0.0,0.0,0.0,0.07534452030000001,0.788216307,0.481400555,0.0,0.43928233299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.270823853,0.0,0.0,0.0,0.287056044,0.575268134,0.878400717,0.17292148,0.0,0.0,0.011357039099999999,0.185539685,0.400630183,0.0,0.0,0.653517542,0.503940176,0.40798578700000004,0.96013305,0.981781908,1.28908829,0.14239368800000002,0.20857171300000002,0.055462455099999995,0.265631855,0.0,0.0,0.14090666400000001,0.15457416599999999,0.617030776,0.0,0.0,0.0,0.0,0.0,0.312105643,0.0,0.0835253795,0.18737400199999998,0.0,0.0490078299,0.43874587600000003,0.624987756,0.492201266,0.057578610499999995,0.130116219,0.315317417,0.0,0.0,0.181848717,0.0,0.0,0.46615628,1.10075808,1.23306732,2.32844854,2.23464982,2.03649194,2.37783874,2.97606468,2.93694355,2.39167415,2.47445751,1.89965983,0.800396862,0.234228322,0.781975058,0.294580372,0.0,0.312495148,0.17365533100000002,0.415326755,0.00635232544,0.0,0.0,0.17313283899999998,0.174937361,0.15684173,0.45840675,0.286007303,0.105723414,0.027494405099999997,0.104397129,0.216115085,0.0,0.56935625,0.004069795070000001,0.7401506240000001,0.0,0.522305455,0.117776672,0.59179328,1.44800029,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.456
0.37892569,0.722295061,0.573639864,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.693378939,1.19533059,0.355304778,0.765587224,0.0954615646,0.133108002,0.466400129,0.0,0.282703336,0.042877850499999995,0.0,0.48042691,0.0,0.0,0.0,0.584438172,0.0585097495,0.0,0.0,0.0,0.0,0.325456238,0.132931156,0.5139407579999999,0.19738187100000001,0.9830265159999999,1.22373288,1.27118101,0.859653089,0.356362845,0.163737388,0.135718052,0.0268253577,0.0,0.0,0.579891268,0.636231791,0.0538738283,0.0,0.0,0.247177373,0.0,0.313208595,0.25808016,0.11431153699999999,0.6739001590000001,0.283308082,0.611859012,0.694595885,0.848383643,0.546644371,0.846570222,1.15074538,1.18918395,0.755548225,0.63345733,0.301016183,0.71966976,0.0693825903,0.16034111199999998,0.0,0.14286249,0.06124193309999999,0.08432103449999999,0.638230651,0.718934057,0.7586594809999999,1.63336442,1.12833003,0.45536205799999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.599854704,1.05636624,2.17097251,3.41923149,3.85823636,4.91703621,6.6298618000000005,6.27733605,5.74472307,4.83968562,4.60264281,2.88958274,2.7627976000000003,1.62393789,0.346941661,0.88338395,0.25541431600000003,0.0,0.0360178814,0.43785785299999996,0.39510787299999994,0.6718438590000001,0.190526893,0.0,0.0,0.0,0.371601258,0.0,0.0,0.0622698617,0.0,0.574859276,0.147501735,0.0120053147,0.0,0.0,0.300061519,0.38645298299999997,0.574018273,0.056191688899999995,0.229029272,0.0,0.21365670399999998,0.0,0.251524465,0.0,0.0,0.44164003399999996,0.0,0.11125288800000001,0.42628368200000005,0.0,0.0,0.0,0.0,0.0,0.271639071,0.0,0.0,0.0,0.516432815,0.033243754300000004,0.61025668,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.457
1.18255146,0.067348324,0.411361961,0.0,0.0,0.0,0.0,1.05523823,0.302696933,0.0,0.0,0.06040818480000001,0.188635647,0.8843615459999999,0.0,0.790896473,1.12260825,0.027778781699999998,0.137735114,0.42656973,0.0,0.0,0.0,0.0,0.39172498200000005,0.12418853099999999,1.70183031,0.0,0.161945574,1.71020996,0.0,0.0,0.0979824159,0.0,0.0,0.0,0.0,0.150374352,0.648863431,0.0,0.503701848,1.36488189,0.0,0.0,0.16739573800000002,0.0,0.0,0.0,0.355826487,0.824774839,0.9483168340000001,1.76226748,2.63513447,1.63788102,3.04182468,2.42906624,1.78273258,2.00420324,0.9813998709999999,0.9320428009999999,1.1875083999999998,0.0,0.580585883,0.0,0.12547132800000002,0.08774203050000001,0.41980903399999997,0.30471049899999997,0.448274305,0.414421465,0.64605378,2.25590275,1.8864253,3.19561261,2.0820046999999997,3.98724064,2.02426982,2.44382853,1.63244968,1.62540304,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.76991453,1.38222157,2.79874037,3.62281781,2.12708732,3.10663648,2.94097206,0.907608747,1.96724776,0.835993896,0.274331685,0.0,0.641622626,0.0,0.0,0.131945484,0.216722288,0.115359509,1.35887633,0.86503953,0.42715879,0.737337782,0.0,0.0,0.0,0.0,0.39965182299999996,0.5399495870000001,0.31696166600000003,0.0,0.263180238,0.0782798897,0.46759074700000003,1.43097032,0.0,0.0,0.57823329,0.608985215,0.0,1.18700854,0.0,0.394912992,0.0,0.0,0.255182753,0.0,0.230446347,0.725792949,0.0,0.0,0.693815843,0.0,0.28448238800000003,0.6047371770000001,0.0,0.9462241809999999,0.0,0.042866996100000006,0.0,0.0,0.0,0.768942482,0.0,1.42571096,0.0,0.013813373200000001,0.0,0.0,0.0672484254,0.0,0.0,0.0,0.290939302,0.130165842,0.9516230720000001,0.0,0.0,0.0,0.0,0.543042068,0.20238537199999998,0.629309975,0.0,0.306216822,0.151939914,0.0,0.8693121079999999,0.0621545732,0.678947448,0.0,0.0,0.0,0.0,0.0,0.131906481,0.0,0.0571411615,0.314424755,0.489424429,0.0,0.0,0.0,0.340379685,0.0,0.299015468,0.0,0.41272973799999996,0.0,0.287510411,0.207239487,0.7964630090000001,0.0,1.58381064,2.04629388,1.90550934,2.09291632,1.68448087,1.78855181,1.33733734,0.974008578,0.895088595,0.00537983624,0.0,0.0,0.0,0.017283316599999998,0.0,0.0,0.53882624,1.89179154,1.96228853,3.01314058,3.0183348,3.06331762,1.6719272,1.91969914,1.35800666,0.9169636990000001,1.76147552,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.20041192300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.5763660110000001,0.486895215,0.39676355,0.0,0.611991533,1.03933654,0.653600363,0.0,3.70296915,5.16213783,0.0,0.0,0.878918086,0.0,0.523218112,0.0,0.479414975,0.102947888,0.0,0.0,0.0,0.159340221,0.0,0.0490430462,0.0,0.0,0.342442919,0.0,0.426850964,0.0,0.0,1.86674528,3.00519555,2.14298255,0.0,0.0,0.0,0.584055891,0.0,0.128394014,0.33551719,0.119514594,0.651080046,0.66413991,0.0,0.0,0.445490121,0.0,0.0,0.369734028,0.421051842,0.421120685,0.0,0.0561425845,0.306447344,0.0,0.866580865,0.717275463,1.37636623,1.23961449,0.8837284409999999,0.13880668300000001,0.730054623,3.07386911,3.06857004,3.71030099,4.73731147,3.28941898,2.53980384,1.51071981,2.16938059,3.3485961000000004,3.44227942,2.19731145,2.42438183,4.05140865,6.38906875,5.59735714,3.72314048,5.00224411,4.1028395,0.0,0.0,0.0,0.0,0.11909578300000001,0.530815029,0.0,0.5036268979999999,0.0,0.7085635220000001,0.0,0.13910508800000002,0.0,0.0,0.0625664485,0.0,0.508320028,0.657401903,0.0,0.015013803000000001,0.595233152,0.0562718866,0.160926412,0.0,0.538162603,0.0,0.450219498,0.0,0.0449665359,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
2.2212793,3.0344762000000003,3.66132499,2.75879918,3.59543119,2.03907397,2.13403693,1.89589221,1.38545014,1.48209992,0.91228602,0.620618925,0.08701509310000001,0.0,0.556116772,0.0,0.0,0.0,0.0,0.0,0.0,0.348196911,0.0,0.0,0.336150034,0.0,0.017373503000000002,0.0,0.0646584661,0.715942967,1.32865518,0.8098708640000001,0.824059054,1.08484412,2.33153617,1.34299012,0.988424431,1.57493623,1.65811209,1.82252658,1.50730749,1.77737725,0.532418708,0.103967375,0.9948332040000001,0.808275195,0.481837114,0.0,1.0151408000000002,0.0,0.0,0.0,0.0,0.0,0.181511641,0.0,0.0,0.0,0.0,0.23490701,0.0,1.08528807,0.0437017575,0.0,1.00350659,0.0,0.08303945389999999,1.10956634,0.00554497004,0.0,0.038238032400000004,0.0,0.081088824,0.0,0.764871454,0.136618916,0.10984379699999999,0.0,0.111546065,0.0,0.0,0.0,0.0,0.0,0.0,0.19894247,0.0,0.505213433,0.0,0.6282201079999999,0.983894147,1.1227107,0.784132548,1.37428357,2.74901184,1.04265956,2.4173391,3.74145681,1.9855808000000001,2.77230174,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.575687091,0.161909191,0.0,0.06565734,0.0,0.628442986,2.24272557,2.42500754,2.85252277,0.0,2.55405048,0.0331462033,6.21258358,0.0,0.995183125,0.46668274299999996,2.38990191,0.0,2.91906258,0.0,1.22152761,0.0,7.62459541,6.76268831,0.0,4.97829399,7.06527122,0.0,0.690305115,0.0,0.818758584,1.24544979,0.761937193,1.30526362,0.7187208509999999,0.0,1.93900775,0.0033217990299999997,1.77950217,0.227596202,0.00166227008,0.10549606,1.64875149,0.749893282,0.833665436,0.0,0.40114254299999996,0.343936946,0.0,0.22708244800000002,1.02164958,0.0,0.27340296,0.20425149399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
1.01631097,0.0,2.04403756,0.0,0.54269385,1.32795948,0.0,0.25528619,1.47088563,0.0,0.0,0.75508618,0.66899381,0.0,0.0,0.14082047,0.0,2.24084987,0.25777927,0.0,0.32513427,0.0,0.45861409,0.65886311,1.34943361,1.05900368,0.31489073,0.0,0.88818779,1.01817856,0.0,0.0,0.0,1.48158532,0.20536729999999997,0.26349386,1.18448237,0.0,0.0,0.21998982,0.0,1.16734958,1.3917453000000002,0.421021,0.0,0.0,0.0,0.0,1.48582036,0.0,0.0,0.0,0.46718389,0.0,0.44404904,2.78474902,1.34392203,2.52526327,3.37754748,2.15209578,0.85350977,0.0,0.0,1.09741569,1.82272992,0.0,1.47142126,2.5717239,4.25139169,7.44987017,4.66373925,3.60800572,1.79080491,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
0.127461709,0.425059501,0.0953533816,0.32836674600000004,0.42624632700000004,0.16874287899999998,0.18584557,0.40958670700000005,0.0,0.0477150264,0.357296147,0.45900429299999995,0.419073705,0.848975384,0.251002624,0.614400807,0.11178933199999999,0.21279209899999998,0.669836807,0.366116115,0.965719977,1.19405611,0.8728016,0.8908933929999999,0.34907999,0.408225802,0.5425303929999999,0.299826463,0.44674978299999996,1.003156,0.420050427,0.6595569,0.715718975,0.0948745755,0.553316128,0.729874314,0.46857881100000004,0.7373357970000001,1.48364795,1.53782218,1.37087276,1.24203362,1.14391943,0.962182822,0.687959164,0.436142796,0.432921254,0.84496975,1.24140317,1.38965126,1.25959063,1.69450907,1.43264848,1.22923281,0.8776908109999999,0.808367845,0.696234611,1.02170702,0.7685307929999999,0.944127985,0.890113532,0.773301806,0.0,0.1965826,0.0,0.0,0.492648518,0.162291737,0.435938241,0.20573583199999998,0.0,0.0,0.0,0.0,0.013392922,0.513005442,1.09863914,1.20504414,1.21067392,0.453388157,0.392494822,0.0,0.0,0.0,0.0482902745,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0755302321,0.28078650899999996,0.0,0.0,0.202818179,0.0,0.0,0.10793496,0.0,0.0387162827,0.19049423899999998,0.0,0.0,0.0,0.16893894899999998,0.289757259,0.0463865857,0.0,0.08790749449999999,0.0,0.0656298548,0.0,0.09710289679999999,0.12083749699999999,0.0,0.0,0.0,0.0,0.153431417,0.13584937800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.12495029099999999,0.357323196,0.245998031,0.0,0.0,0.0,0.0,0.181718957,0.0,0.17681472899999998,0.24662456,0.131428283,0.0,0.0,0.0,0.0790861934,0.309357852,0.371984131,0.126193462,0.147107113,0.0,0.0,0.07219772940000001,0.0,0.389957065,0.255350404,0.33677978799999997,0.11368349900000001,0.0,0.0,0.0,0.0,1.34260256,2.11369999,2.87980688,3.60801539,3.22400175,3.03082534,2.63270922,1.95535544,1.53930426,1.68856597,1.47754519,1.00756922,0.711669432,0.6650141070000001,0.548695984,0.333510914,0.0249474411,0.0,0.0,0.0,0.0,0.0,0.0,0.540346066,1.3312532,1.62552725,1.66078212,1.83207351,0.9665636890000001,0.6687193920000001,0.0,0.0,0.0,0.0,0.0,0.175389347,0.09660405050000001,0.0,0.0,0.00356197985,0.0,0.0,0.0,0.18637451600000002,0.388532175,0.0661451035,0.0,0.0635370767,0.209149198,0.0,0.430808409,0.0934346286,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.33336616199999997,0.235680132,0.0,0.608013574,0.18641898699999998,0.387427255,0.0,0.154705493,0.0,0.0,0.0,0.0,0.35416818,0.0,0.0,0.44232621200000005,0.0,0.0,0.0,0.459552854,0.0,0.0,0.0165014079,0.0,0.456643381,0.0,0.6102024770000001,0.0,0.0,0.0514068155,0.430713645,0.0,0.388674775,0.0854952752,0.0,0.0,0.264897018,0.0,0.330761639,0.0,0.0,0.207593845,0.585487207,0.788390742,0.0705064416,0.24743895800000001,0.0,0.0,0.0,0.0,0.218623572,0.0,0.005235920220000001,0.511144398,0.0419906906,0.45398074899999996,0.830156172,0.42576766200000005,0.0,0.00989177947,0.0947503766,0.0,0.389220281,0.0,0.0,0.22522759,0.47239678,0.216480053,0.0743651127,0.767777171,0.0,0.606263819,0.0,0.0942492714,0.0,0.0678495492,0.0,0.0,0.0,0.0,0.0,0.0439992318,0.018641599499999998,0.84273757,0.172111653,0.0160385829,0.41709058600000004,0.0,0.0,0.0,0.23464818,0.1918508,0.294514877,0.0,0.0,0.372064244,0.8639206159999999,0.122142004,0.966677978,0.651676126,0.514866465,0.0,0.122580575,0.0,0.0,0.0,0.0,0.33172559100000004,0.926693488,1.73813184,2.55286354,3.99408073,4.31081985,5.12187911,6.38491122,6.609598599999999,5.83165135,5.51077285,4.59349733,4.07762763,3.02195482,1.61722984,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.285014616,0.0710839259,0.38012004899999996,0.0,0.0,0.0,0.0,0.21263739899999998,0.0,0.0,0.0,0.272963087,0.628057726,0.691950521,0.0,0.945395565,0.144510014,0.105765499,0.0,0.388040944,0.0,0.0,0.132044704,0.169301952,0.0,0.0,0.457684556,0.0,0.0,0.0,0.375684449,0.0,0.181505933,0.0,0.288025417,0.0846784325,0.0,0.0,0.0,0.0,0.0,0.0,0.248878047,0.0,0.0,0.438215016,0.519087704,0.0,0.30572737,0.0,0.158455012,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
0.17974666,0.75898778,1.30436045,0.80542311,0.15838583,0.53867654,1.23646423,1.47209065,1.72067778,1.99408318,1.97524945,2.60073584,4.28718158,5.28918578,4.55352908,3.43106226,2.84419559,2.13193054,1.21142778,0.64729372,0.29547858,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.246427127,0.36636541,0.407312495,0.35017011600000003,0.20409372,0.0070533242200000006,0.0,0.0,0.0,0.0,0.147843995,0.504675448,0.848413546,1.08555079,1.1399916,0.9765844140000001,0.616394718,0.138865815,0.0,0.0,0.0,0.0,0.374599571,1.40841275,2.6154265,3.80584117,4.77871901,5.36297254,5.45293019,5.03035186,4.16786317,3.01309751,1.75731846,0.5958423310000001,0.0,0.0,0.0,0.0,0.0,0.0,0.218901449,0.45931636200000003,0.528706103,0.44120458,0.25093267199999997,0.031609201499999996,0.0,0.0,0.0,0.0,0.024005572200000002,0.160976365,0.249747511,0.270012258,0.22759795800000002,0.150824429,0.0797608479,0.051996579400000006,0.0894954067,0.19068655199999998,0.330311784,0.467190661,0.5576760239999999,0.5708369670000001,0.5008182529999999,0.372544518,0.238755699,0.16876259,0.231626506,0.47805496799999997,0.9257342209999999,1.55198072,2.29572605,3.06846571,3.77154422,4.31560869,4.63762771,4.71161944,4.55092721,4.20204262,3.73202358,3.21296288,2.70740344,2.25801484,1.88346407,1.58065252,1.3318463,1.11412792,0.908294136,0.7048307690000001,0.505699792,0.32201600199999997,0.16887065199999998,0.0592569154,0.0,0.0,0.004528664060000001,0.0404439871,0.0747454014,0.0936897286,0.0908034202,0.0675975099,0.0319077666,0.0,0.0,0.0,0.0,0.0,0.0,0.00702767512,0.021345767,0.0294796191,0.0332952279,0.0361467424,0.0408409378,0.0479391831,0.0551225317,0.0579298027,0.0516383996,0.033587891,0.00502060354,0.0,0.0,0.0,0.0,0.0,0.0037358956299999996,0.052562137099999996,0.0913054544,0.10639986800000001,0.09017131699999999,0.0440140045,0.0,0.0,0.0,0.0,0.0,0.0,0.0484432347,0.129929223,0.178833761,0.177310582,0.121762168,0.025359244700000002,0.0,0.0,0.0,0.0,0.0,0.0867021659,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.449
7.56273753,3.63326722,6.1417945,1.70052144,2.00317677,0.73737687,2.39300832,0.0,0.0,0.0,1.30702964,0.0,1.0474713,1.21253537,0.0,0.0,0.0,1.78495826,0.0,0.0,0.0,0.59263663,0.0,0.0,0.0,0.0,0.8780389999999999,1.04186737,0.0,0.0,0.0,0.07726561,1.72801848,0.0,1.38704319,0.85626411,0.06408139,0.94972704,0.83571697,1.74661451,0.0,3.17548883,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.54514008,1.61165561,0.0,1.13672279,1.27037677,0.20489224,0.0,0.0,1.72730098,0.71154671,1.08617386,1.92853519,3.99204934,3.18670495,4.72719868,4.05001736,4.32724358,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
3.39725358,3.32532781,3.52087509,3.08045415,2.57984275,2.94332589,2.47190527,2.25745392,1.4523669,1.46267223,0.79133912,0.67985429,0.72339536,0.30286752,0.14322484,0.26057181,0.0,0.05414356,0.0,0.12537979,0.0,0.40912148,0.0636498,0.0,0.34747664,0.39010171,0.0,0.0629916,0.0,0.0,0.0,0.0,0.12433639,0.0,0.12411997,0.0,0.03551581,0.07111571,0.03350104,0.16244368,0.39636417,0.45342303,0.07927502,0.0730346,0.29243309999999995,0.12169149,0.0,0.12302589,0.0,0.0,0.0,0.0,0.01528171,0.01645868,0.0,0.24227376,0.24595085,0.06086571,0.2084551,0.45149223,0.43677021,0.0,0.0,0.0,0.0,0.13028846,0.1577836,0.10938203,0.30342679,0.37911045,0.33091612,0.09883547,0.49057086,0.7381598,1.40000145,1.21750554,1.82049882,2.05947981,2.69862136,2.5738004,3.05361406,3.13413508,3.42912905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
2.06511278,3.41524691,1.45499072,1.38913908,1.44633684,0.0,0.0,0.0,0.0,0.0,0.01502292,1.26957292,0.34067543,0.0,1.10980281,0.0,0.0,1.25063495,0.49519727,0.0,0.0,0.39138959999999995,0.0,0.0,0.0,1.01763091,0.0,0.57453919,0.0,0.0,0.30601379,0.0,0.51988949,0.15002913,0.0,0.2250044,0.10743729,0.0,1.30615867,0.0,0.62133698,0.0,0.0,0.89603887,0.3034908,0.0,0.0,0.0,0.0,0.95777501,0.0,0.25470875,0.57869416,1.03486444,0.05155641,0.0,0.0,0.0,0.0,0.0,0.16606947,0.34628717,0.0,1.29584067,0.41653891,3.15453851,1.84353313,4.57463139,2.78841172,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.181965089,0.25683816800000003,0.319560561,0.351190065,0.33728641600000003,0.271205271,0.156187105,0.00576786734,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.2722077,0.59465073,0.9109612709999999,1.18352473,1.38007758,1.47852781,1.47013229,1.36049932,1.16826821,0.921728164,0.654001509,0.397661879,0.17974230300000002,0.0179943851,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0482912086,0.11118037900000001,0.161020586,0.183198595,0.1678996,0.11299745900000001,0.0253813745,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11091436,0.257540147,0.36556537,0.40843160799999995,0.37054651,0.251567319,0.0679306183,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20497133,0.514161631,0.7548573470000001,0.868671854,0.814974575,0.580888614,0.187282885,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6601954879999999,1.96172018,3.3915437999999996,4.80313779,6.04251254,6.96902043,7.47483872,7.50015606,7.04171413,6.15336819,4.9385624,3.53586794,2.09979841,0.779825607,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22835578,0.632045696,0.8700715,0.9188192759999999,0.79070706,0.5285221929999999,0.19521919699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.035582289100000004,0.333094715,0.589687121,0.763712794,0.8305593370000001,0.78590282,0.645134314,0.43930314299999995,0.20852179199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0683240537,0.202095542,0.298348044,0.33771253,0.31280952100000003,0.22901234199999998,0.10284722199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.041329706800000005,0.210430205,0.369907335,0.502288835,0.5964314039999999,0.648833063,0.663522271,0.650666358,0.624253804,0.599332859,0.5893175420000001,0.6038063229999999,0.647221052,0.718397875,0.8110852059999999,0.915159506,1.01828021,1.1076794,1.17181423,1.20168431,1.19170888,1.14014686,1.04910883,0.9242432509999999,0.774182264,0.609812448,0.443409405,0.287655525,0.154559843,0.054320752699999995,0.0,0.0,0.00335883036,0.06552583719999999,0.153852115,0.25477788100000004,0.353089637,0.433978976,0.48523216,0.499194514,0.474144089,0.41477134200000004,0.331592605,0.239306286,0.154300836,0.0917039227,0.06248454,0.0711539793,0.114542915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47
0.0807717824,0.0,0.180275987,2.17587209,0.0,0.0,0.0,0.222434639,0.0762395428,0.327281304,0.0,0.526233316,0.0,2.15214063,1.01384583,0.0,0.780826391,0.0,0.40568707600000004,0.0,0.0352121824,0.020449458,0.0,0.18989420399999998,0.294263688,0.0,0.0,0.0,0.605864031,0.225164997,0.205542577,0.0,0.28516616899999997,0.493398805,0.0,0.0,1.27771775,1.74860303,1.28519734,5.41439311,2.32709008,0.0,0.297695251,0.33305983100000003,0.547284378,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.324854478,0.0,0.0,0.27761453399999997,0.0,0.97116709,0.0,0.0,0.0,0.47859092,0.0,0.0,0.0,0.5448485710000001,0.0,1.21057047,0.320305475,0.0,1.1630963,0.0,0.0,2.34988492,0.0,0.603894575,0.577314088,1.30852259,0.0,0.0,2.59875772,0.286141119,0.0,0.0,3.83055793,1.49461606,0.0,0.0,0.0036194021100000003,0.145087512,0.0,0.433473118,0.0,0.0,0.0,0.0,0.0,0.506626401,0.644964408,2.00401844,0.421062069,0.0,0.0,0.0,0.0,0.0,0.0,0.47141976,0.0,0.0,0.0,0.905077402,0.0107784212,0.0,0.0,0.985223567,0.7645263370000001,0.0,0.724260253,0.0,1.19940723,0.0,0.0,0.737800705,0.0,0.0389977636,0.0,0.38520032600000004,0.0,2.05109843,0.9272167859999999,2.56798339,0.201722543,0.0,0.0,0.250988228,0.0,0.0,0.0,0.7007821609999999,0.0,0.0350653352,1.2693816,0.884475255,1.53776631,0.0,0.86644899,0.0,0.557270469,0.0,0.0,0.0,0.0,0.0,0.330533295,0.0,0.0691422094,0.0,0.0,0.0,0.466837465,0.0,0.0,0.449702165,0.0,0.0,0.476695828,1.00000529,0.0921819747,0.462800197,0.899645175,0.0,0.0,0.0,0.0574496372,0.0,2.72216123,2.4939105,3.71232155,5.56933776,6.70939279,7.04100963,5.50856103,5.46932175,2.52026765,0.0,0.059466625700000005,0.0,1.49565494,0.0,0.571783255,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
0.291614718,0.0,0.056683278399999995,0.451002192,0.0,0.0,0.508838198,2.76509668,3.80416504,2.70411584,1.13539401,0.682701315,0.8648351790000001,0.612775868,0.0898734225,0.0,0.104648806,0.027785948799999998,0.0,0.0,0.11529539300000001,0.0,0.0,0.0267370132,0.11638496,0.0,0.0,0.0734315023,0.125891274,0.0,0.0,0.162930908,0.150584121,0.0,0.0,0.44642302899999997,0.21480982899999998,0.0,0.0,4.397258900000001,10.279978,11.8672437,7.79015965,2.35427585,0.0,0.0,0.0,0.0,0.736941115,1.71894267,1.50646103,0.35874473799999995,0.0,0.470415824,0.7780632590000001,0.238967276,0.0,0.0,0.20027192800000002,0.018259486499999998,0.0,0.00916317559,0.154559734,0.0,0.0,0.057671492000000005,0.151468535,0.0,0.0,0.146444192,0.202978632,0.0,0.0,0.770488657,1.91020969,1.58459702,0.228358988,0.0,0.519786338,1.04048338,0.266431184,0.0,0.102978427,1.56185725,1.93640841,0.866658535,0.0,0.0,0.11948718900000001,0.1273995,0.0,0.0,0.0725760437,0.0428828884,0.0,0.0245939287,0.17296845100000002,0.172285473,0.06247536309999999,0.0011987286300000001,0.00108602631,0.0,0.0,0.00317142873,0.0593617362,0.154172361,0.17978372899999998,0.0690688275,0.0,0.025377726899999998,0.0144847473,0.107797857,1.27077339,3.84540299,5.95447769,5.18405182,2.06212195,0.0,0.0,0.555900586,0.024615622099999998,0.0,0.0865791386,1.24386301,1.19986363,0.33320369899999996,0.0,0.09528347599999999,0.0,0.0,0.384419753,1.19682017,1.06556057,0.242787805,0.0,0.0,0.0774984111,0.013329208,0.0,0.0,0.0,0.000801556106,0.0401165526,0.0,0.0,0.023929136099999998,0.0741323746,0.0,0.0,0.0674208747,0.0904341116,0.0,0.0,0.13120384,0.08780155419999999,0.0,0.0,0.22678803,0.0562114321,0.0,0.0,0.40765494799999996,0.0,0.0,0.226177052,1.64105727,1.40725383,0.06850815769999999,0.414051125,2.51635086,3.18495712,1.2229135,0.0,0.0,0.480446329,0.207439008,0.0,0.0,0.319601138,0.0422754209,0.0,0.0036197194,0.236809739,0.0,0.0,0.0642952372,0.175281655,0.0,0.0,0.100551305,0.12248792,0.0,0.0,0.121216461,0.0746537644,0.0,0.0,0.130538045,0.030419260099999998,0.0,0.0,0.131223062,0.0,0.0,0.0314071499,0.125533127,0.0,0.0,0.0735065079,0.116353891,0.0,0.0,0.132035269,0.113788681,0.0,0.0,0.521363809,1.26228049,1.66785212,1.70243249,1.22186374,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.485
0.279080014,0.96793865,1.5276683000000002,1.34042852,0.511231611,0.0,0.0,0.0,0.353804235,0.40772068100000003,0.061459067199999995,0.0,0.0,0.10973366300000001,0.377617669,0.267849862,0.0,0.0,0.0,0.208112248,0.42263324399999996,0.15323192300000002,0.0,0.0,0.0,1.0735346000000001,2.12692481,2.35462196,1.61458374,0.501963324,0.0,0.19647047,1.07211859,1.66346011,1.36773722,0.359929137,0.0,0.0,0.390317466,1.6312398000000001,2.36797118,2.37217461,2.1564798,2.44912752,3.45444927,4.58346253,4.91601394,3.98955623,2.21276124,0.546880162,0.0,0.0,0.555956817,1.22143789,1.94586243,3.08274496,4.77101821,6.55241841,7.55568779,7.12070715,5.32665461,2.97383565,1.04513334,0.094086214,0.0161491154,0.29889961600000003,0.469069829,0.371522346,0.134987234,0.0,0.0,0.0,0.027679215,0.0380650909,0.008800226999999999,0.0,0.0,0.0,0.0283086042,0.028830045699999998,0.0,0.0,0.0,0.0503302121,0.223566075,0.412628369,0.563130411,0.664336652,0.734187047,0.771273946,0.73828727,0.610834068,0.444936095,0.37635368700000005,0.522245712,0.861959887,1.21651544,1.36856127,1.23312452,0.9330600370000001,0.710950747,0.749061925,1.04086739,1.4036732,1.6049771000000002,1.50340318,1.12181913,0.6301438770000001,0.256707951,0.162467415,0.332405299,0.561133945,0.582770079,0.290027009,0.0,0.0,0.153813086,1.02793712,1.85139161,2.07078932,1.51398488,0.538304473,0.0,0.0,0.0,0.194283448,0.263762964,0.050472946399999996,0.0,0.0,0.00557026777,0.158199562,0.12248538099999999,0.0,0.0,0.0,0.0642003157,0.125158687,0.044078247699999996,0.0,0.0,0.0,0.0850154611,0.0829428066,0.0,0.0,0.0,0.0265333953,0.0721388114,0.033884246,0.0,0.0,0.0,0.012337389399999999,0.0,0.0,0.132649261,0.38431100700000004,0.57962454,0.529941087,0.22755005399999997,0.0,0.0,0.0,0.12505928300000002,0.18873143399999998,0.0415597034,0.0,0.0,0.00260988741,0.156129563,0.130416678,0.0,0.0,0.0,0.0812716383,0.171766792,0.0661608591,0.0,0.0,0.0,0.153098344,0.162436409,0.0,0.0,0.0,0.0683950509,0.216685745,0.11957887800000001,0.0,0.0,0.0,0.19904244699999998,0.271927568,0.0234019038,0.0,0.0,0.0660793809,0.430391305,0.33558046799999997,0.0,0.0,0.0,0.762309514,2.16321802,2.83095049,2.33730221,1.1596201000000002,0.26659382800000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.465
2.66767441,0.51073523,1.12094298,2.90011064,2.75943651,3.37414285,4.82394654,5.17958359,6.11705897,7.37703904,5.18258664,6.13918865,4.01168834,2.03832844,1.44604131,0.94885467,1.90282596,0.49860225,0.0,0.4626455,0.0,0.0,0.0,2.72360674,1.38383062,0.0,0.0,0.0365497,0.0,0.0,1.08973731,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.06796569,1.62909417,1.69062473,0.0,0.0,1.93509317,0.57194574,0.0,0.66013193,0.10627834,0.64093255,0.0,0.0,0.0,0.0,0.23733885,0.0,0.0,0.57022299,0.03231796,0.16080623,0.0,0.1328687,0.0,0.0,0.49370686,0.0,0.0,0.70922696,0.0,0.38996984,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
0.7930449940000001,2.64250912,2.55667279,3.18369073,9.97539849,2.93244611,2.13507046,2.16217454,1.95610875,0.1244007,0.559599482,0.029315709300000003,0.415220374,0.0767197054,0.157957632,0.604585179,0.609476749,0.245990035,0.41292325,1.44095843,2.91621644,0.763584082,2.40436293,3.32906712,2.23962106,3.70617878,3.12463896,2.0406553,2.53148812,0.655988084,0.0121729971,0.0,0.029568708399999998,0.0,0.0,0.285225412,0.33699069200000004,0.0,0.08542519650000001,0.0,0.09232197269999999,0.0,0.09411914769999999,0.0,0.316255755,0.38959059100000004,0.276669102,0.0331866885,0.22623791399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.19922717399999998,1.85645787,0.0,0.22083201100000002,1.02781611,1.5968,2.11150271,0.9229401159999999,1.10854064,1.32776667,0.0,0.879196682,1.56472863,0.288926809,0.0,0.0,0.633561873,0.0,0.670416741,0.7459899940000001,0.0,0.0,0.0,0.325962837,0.0,0.0,0.0,0.0,0.47895935700000003,0.0,0.681881354,1.19833703,0.547834603,0.0,0.813285316,0.8105862090000001,0.0,0.0,0.0458751228,0.00898516827,0.387408262,1.45246319,0.0,0.794470511,0.0,0.547243949,0.0,0.0,0.504295129,0.925329318,0.0,0.0,1.34867649,0.195612941,1.4502921999999998,0.465730046,0.292553655,0.0,0.0,1.39896965,1.06539139,0.489782061,0.0,0.0,0.0,0.0,1.64654232,0.0,0.0,0.615367012,0.49293904,0.0,0.0,0.0,0.0,0.0,0.8226688190000001,0.0,1.03584852,0.285071413,0.284483463,0.87890436,0.899284665,2.12632682,0.0,0.0,0.513543353,0.0,0.0,0.271970902,1.36031377,0.0,0.0,1.4047818,0.887750615,0.539380525,1.29845359,0.0,0.313817506,0.0,0.0,0.0,0.0,0.7437627179999999,1.06300777,0.0,0.0,0.439749935,0.0,0.0,0.0,0.0,0.0,0.0,0.193031762,1.99585581,1.11234943,0.0,1.12526644,1.65542527,0.0,1.37990957,0.025168209599999998,0.0,0.0,1.13430265,0.0,1.01735646,0.992162922,2.46545017,1.73155508,0.791610906,0.607465908,0.648283149,2.53581327,2.30547769,3.74083336,5.27028374,6.02576756,4.41783848,3.24287468,4.27700533,1.7514096000000001,1.34192835,0.103118976,0.8550563590000001,1.52778001,1.50729992,2.88832049,0.0,2.24132752,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
2.26251831,3.72539359,2.94737709,3.25327221,0.783694193,0.0,0.0,0.8995568829999999,0.329889247,1.65517686,0.0,0.0,0.0,0.0499574016,0.951691655,0.0,0.0,0.0,0.0,0.899443826,0.0,0.0,1.84147491,3.43413303,0.6239667720000001,1.42733004,0.0,0.5859535370000001,1.84944237,0.5943619529999999,0.772534829,0.0,0.0,0.35634607799999996,0.0,0.0,2.76960422,0.5767970689999999,0.0,1.6842733,0.214026263,0.0,0.951037763,0.0,0.0,1.18309459,0.0,0.0,0.0,1.56987133,0.0,0.268053596,0.376861693,0.18281366100000002,0.0,0.414429946,0.0,0.0,2.92645955,4.31617009,3.04465343,3.01363038,2.09292538,0.522788082,1.01761139,1.64949501,0.77756422,1.85186642,1.42380175,1.17596529,0.38342374700000004,0.542748847,1.53150342,0.6999988340000001,0.670963241,0.0,0.16768697,0.0194172249,0.0,1.61632092,0.0,1.97493638,0.0,0.399865191,1.23619378,0.44615815299999995,1.48038496,0.0,0.210627692,0.0,0.0,1.43590542,0.9392995479999999,1.47298478,0.417233015,1.10990318,0.0,0.0,0.600544402,1.2770823999999998,0.0,0.21816835199999998,0.321571705,0.0,0.661702995,0.0,0.39417649,1.20564784,0.0,0.0,0.0,0.18879950899999998,0.0,0.49655004,0.0,0.0,0.698297785,0.86249912,0.00877776595,1.5077931999999998,0.0,1.25298696,0.395462205,3.46652824,3.7989316,1.95978121,1.68272241,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
4.49686585,4.72068828,4.54524308,3.80919234,4.19350939,3.06693245,2.77599468,1.86469085,2.01261667,1.67422695,0.689992449,0.125149364,0.0800529765,0.0032443153100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12255033300000001,0.49499822,0.31761101199999997,1.06227073,0.838622215,0.38127840799999996,1.03627686,0.434657022,0.684953099,0.416333944,0.0,0.195992003,0.358969785,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.25161029,0.192553666,0.0,0.00285545127,0.580295455,0.294951344,0.644316254,0.947229742,0.5923050360000001,0.479891821,0.38664154100000003,0.602055554,0.423039108,0.21612320399999999,0.239687818,0.0,0.059481788099999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.7524126859999999,1.23821122,1.19721918,2.02826205,2.13488657,2.81555812,3.42542777,3.69221095,4.20849602,4.79228043,4.57733398,4.47157172,5.27618126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.293789814,0.429917948,0.118732589,0.0,0.0,0.7793305429999999,0.841517739,0.281139343,0.0,0.0,0.21676410699999998,0.5883705889999999,0.0,0.0,0.409178965,0.0,0.175201384,0.0,0.0,0.6239423070000001,1.37074979,1.51497606,0.521556295,0.278264112,0.0,0.0128976771,0.7097698440000001,0.36621958299999996,0.0,0.155393004,0.191097693,0.374805919,0.235192662,0.0,0.28751494699999997,0.494680071,0.10399315599999999,0.0,0.0,0.562261742,0.422814499,0.0,0.0,2.10953244,3.76745344,4.9175382,3.03811275,1.6978451,0.6481228379999999,0.00510102036,0.542285613,0.0,0.0,0.0,0.0,0.0,0.364804454,0.00898988639,0.0,0.0,0.270696731,0.0732106013,0.0,0.736799212,2.13426359,3.71895924,4.05283887,2.58967916,0.462684389,0.0,0.040950659300000004,0.0,0.262488039,0.0,0.0,0.226700481,0.7738611609999999,0.15373980199999998,0.523711884,0.111924859,0.31860932,0.0,0.410840146,0.47022098100000004,0.705037347,0.22048353199999998,0.0,0.0,0.50060286,0.245098238,0.0203944067,0.062345429699999996,0.0,0.0,0.0,0.0,0.0,0.0,0.44792848700000004,0.0,0.0,0.0,0.0,0.0,0.257209227,0.11555453,0.0,0.414992675,0.141534319,0.791453172,1.0466780999999998,1.67884553,1.70626977,1.77808807,2.35298784,2.39539665,1.59248505,1.33615619,0.5591979229999999,0.851639775,1.44166872,1.07774204,1.54712174,1.39743803,1.19289085,0.919090211,1.41641572,2.1400864,1.46263456,0.916289915,0.747629859,0.109616929,0.488083218,0.0,0.0,0.113409835,0.42996776299999995,0.403506214,0.954049723,1.04691895,1.45373113,1.40473333,1.03405224,0.059286266799999994,0.436800576,0.32446731100000004,0.0,0.6992716729999999,0.567664478,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.09189404710000001,0.145176267,0.19342413100000003,0.234220937,0.26578772100000003,0.287099214,0.297949091,0.298960965,0.291544986,0.277803228,0.2603902,0.24233743600000002,0.226853262,0.21711022,0.216033258,0.22610164100000002,0.24917658899999998,0.28636500800000003,0.33792745,0.403235732,0.48078266,0.568243246,0.662583746,0.7602121359999999,0.85716127,0.949294167,1.03251971,1.10300655,1.15738334,1.19291415,1.20763971,1.20047701,1.17127229,1.1208052,1.05074457,0.96355897,0.862387775,0.750880388,0.633012941,0.512892848,0.394561964,0.281808936,0.178000518,0.0859403215,0.0077616762199999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0162387908,0.0392084602,0.0567525213,0.0682137761,0.07341370480000001,0.0726191682,0.0664843063,0.0559726519,0.0422654668,0.0266628814,0.010484564,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000498874018,0.00886433667,0.0156888976,0.0205614577,0.0232698183,0.0238064872,0.022357077599999997,0.0192727003,0.015028977399999999,0.0101753229,0.00527888179,0.000867933396,0.0,0.0,0.0,0.0,0.0,0.0,0.000855343973,0.00296933372,0.0041579795,0.0039020344299999996,0.0018085366600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00671045832,0.042719084299999995,0.0882252708,0.142781061,0.20538561,0.274495399,0.34807153700000004,0.423663933,0.49852973100000003,0.569780971,0.634554219,0.690193035,0.7344327340000001,0.765576074,0.782648349,0.785520909,0.774993398,0.7528269190000001,0.721722815,0.685244727,0.64768478,0.613878128,0.58897329,0.578168695,0.586428324,0.618191162,0.677090247,0.7656973000000001,0.8853081859999999,1.03578286,1.21545102,1.42109144,1.64798938,1.89007221,2.14011924,2.39003758,2.63119218,2.85477466,3.05219345,3.21546578,3.33759187,3.41289189,3.43728804,3.40851649,3.32625756,3.19217642,3.00987121,2.78473045,2.52370614,2.23501337,1.92777138,1.61160379,1.2962181000000002,0.990985405,0.704541454,0.444428776,0.216797358,0.026178232000000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0411754318,0.108051118,0.16218322699999999,0.200613767,0.221668262,0.22496731399999997,0.21136402199999998,0.18281356,0.142184915,0.09302783070000001,0.0393102116,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0364720194,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.15592651,0.49876823,0.0,0.0,1.18216626,1.10007457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.45248875,0.0,0.0,0.66316381,3.13935139,1.81350798,0.31713854,0.20496105,1.21195244,0.18212038,0.38148606,1.05157028,0.0,0.0,0.9388863000000002,0.0,1.30224198,1.84919287,1.23833546,2.20818381,2.3620978999999998,0.89526811,0.78227344,1.80926242,2.17160481,0.48321001,1.00061162,1.03984196,0.0,1.26020896,2.1517534,0.88587958,0.0,3.59182757,2.91489649,1.5316843,2.06227682,1.5134127,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
1.21475109,1.27694102,1.39619376,1.64032275,2.06781008,2.71261235,3.57238666,4.60293229,5.7204847999999995,6.81193641,7.75141687,8.42030551,8.72695735,8.62239212,8.108932099999999,7.24013264,6.1120449,4.84752698,3.57662905,2.41675287,1.45619928,0.743907702,0.28684958899999996,0.0549637917,0.0,0.03000548,0.10324249199999999,0.160544508,0.172176411,0.131439275,0.0510299061,0.0,0.0,0.0,0.0,0.0,0.0,0.0301402748,0.102956329,0.145491848,0.148745238,0.11428306099999999,0.0531532591,0.0,0.0,0.0,0.0,0.0,0.0,0.008222711609999999,0.06004263,0.09335657859999999,0.100992827,0.0827286608,0.0448913145,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0323476286,0.0566474007,0.0648861537,0.0562091804,0.0341213726,0.005263810799999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0147218397,0.0299263212,0.0360263412,0.032451162,0.021200849100000002,0.006054457389999999,0.0,0.0,0.0,0.0,0.0,0.0,0.00402287365,0.0096329101,0.0113471592,0.00958079597,0.0057833437199999995,0.0018088827399999998,0.0,0.0,1.85652563e-05,0.00195768443,0.00305512248,0.0021305044,0.0,0.0,0.0,0.0,0.0,0.0,0.00182878116,0.0125252101,0.02164716,0.0260649352,0.023620257000000002,0.0139431199,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0229393856,0.0428442866,0.0529460227,0.0494916855,0.0321569971,0.0044451345399999995,0.0,0.0,0.0,0.0,0.0,0.0,0.030164904700000002,0.0652262088,0.0853832903,0.0840150316,0.0598350525,0.0176422237,0.0,0.0,0.0,0.0,0.0,0.0,0.0339392063,0.09193832310000001,0.129599881,0.13521312900000002,0.10476888699999999,0.043619557,0.0,0.0,0.0,0.0,0.0,0.0,0.0330622187,0.13211050300000002,0.204765499,0.228889323,0.19306708,0.10063059,0.0,0.0,0.0,0.0,0.0,0.0,0.0732899788,0.336663324,0.608908241,0.8502661420000001,1.03240619,1.14777506,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.483
0.677512808,0.886406404,0.9700008720000001,0.912159985,0.7659057,0.605162577,0.46980565799999996,0.350717412,0.22211661300000002,0.0849176766,0.0,0.0,0.0,0.045069135,0.07040904,0.027796530299999997,0.0,0.0,0.0242979925,0.256265875,0.5743482089999999,0.8871070440000001,1.10139354,1.15551697,1.03845571,0.795068255,0.514584009,0.298352434,0.214519072,0.265413174,0.396106694,0.546506877,0.709994703,0.94549345,1.32064022,1.82384447,2.32151146,2.61257474,2.55612174,2.17987876,1.67948446,1.29757402,1.16728941,1.23695993,1.3308592,1.29362272,1.10182112,0.8586429729999999,0.687916825,0.625474018,0.600324605,0.513694223,0.337501692,0.141426037,0.0271686312,0.034230838300000004,0.105301387,0.141509462,0.09375730130000001,0.0042605578,0.0,0.00917409906,0.106284226,0.159926495,0.11536376599999999,0.00765397366,0.0,0.0,0.0352964988,0.110575995,0.105113746,0.0335692295,0.0,0.0,0.0744541095,0.131176128,0.09534153390000001,0.0,0.0,0.0,0.00785775752,0.122964805,0.14442146,0.058211915,0.0,0.0,0.0,0.0882421131,0.107205372,0.0200695033,0.0,0.0,0.0,0.09641388960000001,0.13818667699999998,0.0461373633,0.0,0.0,0.0,0.0982164492,0.17333739,0.0820343032,0.0,0.0,0.0,0.0932143693,0.206828724,0.119440375,0.0,0.0,0.169785045,0.668962495,1.02877066,0.9329347729999999,0.425674524,0.0,0.16811420100000002,1.24526546,2.82371708,4.0747425,4.25394026,3.21032408,1.49443601,0.0,0.0,0.0,0.0,0.291460857,0.226814159,0.0169390177,0.0499924615,0.48946989399999996,1.12356982,1.54161526,1.46732735,0.966403248,0.372838789,0.019337849,0.00446626787,0.172172673,0.28685373399999997,0.233095827,0.07615300009999999,0.0,0.0,0.0398820388,0.0848023588,0.046717445999999996,0.0,0.0,0.0,0.021287712900000002,0.0562987104,0.0526855399,0.0656861249,0.152932032,0.299077639,0.407879061,0.378605664,0.200404886,0.0,0.0,0.0,0.00635725469,0.113173864,0.10550014099999999,0.00351175348,0.0,0.0,0.0,0.0774959818,0.0883396273,0.0166939014,0.0,0.0,0.0,0.0568887809,0.0785784556,0.025868044399999998,0.0,0.0,0.0,0.0413190792,0.0705598695,0.0324984242,0.0,0.0,0.0,0.028353421299999997,0.06270755230000001,0.0369101482,0.0,0.0,0.0,0.0170677132,0.053882019100000005,0.0385979677,0.0,0.0,0.0,0.00773505807,0.0525512278,0.07882785070000001,0.11751380300000001,0.224680868,0.42570541,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.743404955,0.215219092,0.0,1.59631694,0.0,0.490734625,0.0,0.0,0.586203875,0.5698199,1.60137746,0.0,0.0,1.50719933,0.0,0.0,1.00773713,0.0,0.348333547,0.0,1.61474492,0.0,0.0,0.478036354,0.348991582,0.0,0.0,1.00717293,0.0,0.0,0.8681275740000001,1.26229614,0.532528614,0.0,0.348790686,0.767834696,1.03108311,1.31167795,0.809107371,0.93551321,0.382081445,0.0,0.0,0.0,0.0,0.0809973996,0.0,0.850007181,0.0,0.960056873,0.0,0.5181132070000001,0.0,0.339283624,0.23290264,1.54973158,0.448623066,0.0,0.0,1.48555651,0.0,0.0,1.48693294,0.689140492,0.0,0.0,1.73790236,0.9365724390000001,1.43884616,0.0,1.10203967,0.176775365,0.0,0.0,0.0,1.68302242,0.0,0.0,1.72178085,1.32189598,1.19440052,0.0,0.0,1.00711043,0.0,0.0,0.9618071429999999,0.0,0.0,0.0,0.0,0.624148641,1.21201617,0.0,0.0,0.396173557,0.0,0.0,1.69346025,0.0,0.0,1.49211992,0.628458321,0.0,0.28605158199999997,0.7131668170000001,0.0,1.57682244,1.10412754,0.466634365,0.912447021,0.0,0.0,1.65118383,0.184847576,0.0,0.0,0.642890194,0.0,0.0,1.25033166,0.7342837609999999,0.0,0.0,0.0,0.0,0.10658704699999999,0.0,0.0,1.26808017,0.0364245246,0.0,0.351720011,0.0,0.0,0.675864025,1.33612285,0.0,0.0,0.0,0.0,0.0,0.0,0.509315167,0.0,0.0,0.331406013,0.0,0.0,0.0,0.366955385,0.589320955,0.0,0.0,1.49326362,0.0,1.25794952,0.0,0.0,0.12393389199999999,1.63542638,0.0,0.37625513299999996,1.73791272,0.144829381,0.0,0.0462894796,0.0,0.0,0.0,1.18090846,0.701883405,0.0,0.171296997,0.641417959,1.05657489,0.0,0.0,1.2967507999999999,0.566717287,1.58145715,0.0,0.632502741,0.471359384,0.0,0.0,0.198928999,1.38471465,0.804342242,0.726955922,0.0,0.0,0.0,0.0,1.60187403,0.8683019790000001,0.0,0.0,1.41093912,0.0,0.10866667199999999,0.761304042,0.286430637,0.0,0.0,1.30902624,0.621195036,0.0,0.35439250899999997,1.03300868,0.0,0.748069869,0.0,0.0,0.0,0.957399895,0.0,1.29278545,0.0,1.00832907,0.278663157,1.71718179,0.0,0.41915762799999995,1.69817239,0.0190800315,0.0,0.6384401820000001,0.0,0.655307696,0.0,0.0,1.51596178,0.355047822,17.0013527,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45799999999999996
0.0346925519,0.0,0.0,0.0,0.0,0.185519716,0.300259679,0.27272889,0.12187713,0.0,0.0,0.0,0.0,0.0154376872,0.18664596,0.274045996,0.242742138,0.116077504,0.0,0.0,0.0,0.0,0.061124802199999995,0.16173747300000002,0.180384173,0.106529065,0.0,0.0,0.0,0.0,0.0,0.108516226,0.180919343,0.1612107,0.05953005980000001,0.0,0.0,0.0,0.0,0.0330151326,0.146801452,0.186321989,0.131034552,0.00840526227,0.0,0.0,0.0,0.0,0.0871293983,0.18406666600000002,0.189123417,0.0968575758,0.0,0.0,0.0,0.0,0.0039209100299999996,0.204971824,0.381448936,0.49264627299999997,0.538224369,0.552813996,0.5810767579999999,0.646907055,0.733974028,0.789311251,0.749737068,0.5784924920000001,0.293033854,0.0,0.0,0.0,0.0,0.0,0.225801872,0.429025031,0.463266712,0.318402054,0.0680364051,0.0,0.0,0.0,0.0873193275,0.372715091,0.552621374,0.527492587,0.29337021,0.0,0.0,0.0,0.0364180743,0.738926395,1.64552519,2.53102582,3.16572554,3.39296327,3.17750593,2.60814987,1.85701622,1.11476328,0.528469608,0.164848049,0.008539743309999999,0.0,0.025690602200000003,0.0539257508,0.049857050199999996,0.021248076400000003,0.0,0.0,0.0,0.0,0.000147408316,0.0,0.0,0.0,0.0,0.015533290200000001,0.0350326476,0.0390564526,0.0197699011,0.0,0.0,0.0,0.0,0.006880533559999999,0.060355503399999996,0.0881232027,0.0712085626,0.013259056000000002,0.0,0.0,0.0,0.0,0.0466775239,0.120026782,0.136191709,0.0809417345,0.0,0.0,0.0,0.0,0.0,0.117497215,0.19814748100000001,0.180460337,0.0646950407,0.0,0.0,0.0,0.0,0.0571032372,0.232227762,0.298296813,0.210150086,0.00472509706,0.0,0.0,0.0,0.168875783,0.567803915,0.835254249,0.794513175,0.391532074,0.0,0.0,0.0,0.0,1.04477301,3.08988072,5.32103731,7.16899635,8.12647617,7.92263136,6.61896999,4.58887133,2.38776223,0.5634375460000001,0.0,0.0,0.0,0.168368043,0.660411901,0.80061173,0.557187515,0.0828877982,0.0,0.0,0.0,0.0,0.22132443,0.5336875670000001,0.611776269,0.44822242100000004,0.14889138300000002,0.0,0.0,0.0,0.277108024,0.7334812159999999,1.16620703,1.4813931999999999,1.64786667,1.69211249,1.66623712,1.60940346,1.52448645,1.38172335,1.14561651,0.808528751,0.41082732,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47200000000000003
2.05966905,3.55272186,3.61660697,1.89149826,0.939036396,0.230015733,2.11637738,2.86672008,3.05137947,2.1936145000000002,1.60332009,0.874953017,0.565549899,1.68879193,1.53810142,1.20807681,1.19369707,2.72621137,4.08641434,5.62715511,5.28043531,5.08478706,2.50026169,1.61605747,0.695651494,1.58166813,1.28123177,1.56293954,0.531344099,0.41823348899999996,0.016426890700000002,1.08123937,0.8876725240000001,0.0,0.0,0.495527912,0.367469826,0.51442842,0.7635383490000001,1.02649717,0.0,0.0,0.250416152,0.00461430951,0.252036853,0.0,0.0,0.0,0.0,0.894221035,0.752155235,0.446454326,0.393659689,0.0,0.0,0.0,0.647398041,0.44264345,0.687482589,0.0,0.0,0.167908665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.194433918,0.0,0.0,0.132426077,0.43491913299999996,0.0,0.0,0.20597108100000003,0.0,0.43607168,0.39995075,0.337032083,0.0,1.50722425,1.29532843,0.844655165,0.0,1.65676873,0.522753397,1.04258148,1.40222501,1.07404117,2.03248991,0.8956837959999999,2.49718757,1.97801648,1.8078778000000002,2.0302243000000004,1.94611295,2.18242466,2.28941501,3.11524907,1.39572328,2.15844557,2.57207384,2.75176925,2.89040931,2.11912069,1.54395769,1.69106851,1.59336255,1.327013,0.722842137,0.923408738,0.787380926,0.212586825,0.7571135990000001,0.0579080479,0.47827195200000006,0.719388378,0.10548606699999999,0.25851175,0.0,0.575734606,0.111215126,0.575360186,0.8479936770000001,0.395698528,0.0,0.995548885,0.774248563,1.8575639,0.342923634,0.44471621100000003,0.29595981899999996,0.739483553,0.0,0.574506065,0.978431598,0.0,0.117325175,0.0,0.0,0.0842181305,0.0355438312,0.285978452,0.0,0.035535105,0.0,0.0655456956,0.0,1.07957592,0.00795404765,0.50698507,0.451646892,0.0,0.0,0.0,0.258897837,0.00586408288,0.522421085,0.0,0.0723572275,0.0096266496,0.21931731100000001,0.028267212799999997,0.0,0.0,0.0,0.42855167299999997,0.0,0.0,0.0,1.005015,0.0,0.34299718,0.0,1.32168331,0.42369695799999996,0.895253216,0.0,0.0565778716,0.0819011124,0.0,0.0886755256,0.0693956813,0.47987754200000005,0.200258873,0.0,0.0,0.4698241,0.0,0.0,0.0,0.0,0.0,0.0,0.0997863305,0.0,0.0240769835,0.292296917,0.0,0.0,0.0,0.0,0.0,0.34121370100000004,0.0,0.0,0.027825326299999998,0.0,0.0,0.40726702600000003,0.0,0.0,0.0047597755299999996,0.17980061,0.0,0.48602994200000005,0.385607297,0.0,0.134163304,0.532519915,0.909347667,1.33651244,0.467620207,0.153552558,0.74471996,0.398666245,0.199136145,0.356596271,1.31012731,0.131968237,1.37819069,0.747160519,0.785706072,0.957769813,0.40696843899999996,0.715742966,0.7514365709999999,0.42982797,0.6561682120000001,1.49363266,1.38569071,0.887490642,1.36172438,1.3858455,0.816092763,2.06049993,2.0410393,1.31539985,0.985689978,1.24383818,1.04650955,0.375080209,0.744873655,1.33197813,1.09898406,1.02148435,0.966451933,1.03952819,1.00744836,0.9828256559999999,0.0,0.649258609,0.150086259,0.12875659,0.793422787,0.20825666399999998,0.903620986,0.258093027,0.0,0.0,0.276559505,0.0,0.0,0.0,0.44905767700000004,0.0,0.609150644,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.10245019699999999,0.268475532,0.0,0.198314443,0.0,0.37036758299999994,0.284004492,0.42807541,0.365686855,0.557559365,0.146862879,0.0542638714,0.212670633,0.383702971,0.060780716900000004,0.0,0.454946481,0.29048495,0.7925634109999999,1.31898901,1.84633566,2.15298259,2.82093381,3.14927526,2.90038863,3.03823123,2.66376253,2.4660379,1.72119308,1.2351352,0.823719515,0.32965848,0.162022453,0.0,0.195061635,0.0,0.09969019330000001,0.12081785699999999,0.0,0.0,0.0,0.254849059,0.0,0.039770772200000006,0.0,0.05925213519999999,0.147258109,0.0,0.135656884,0.00556807007,0.113892146,0.0,0.149000975,0.0,0.286226563,0.17551474,0.027845727200000003,0.32889080800000003,0.299956295,0.276877755,0.0,0.24216759300000001,0.0,0.0,0.0,0.0,0.030904777400000003,0.24182707,0.0,0.0,0.248031855,0.5260065820000001,0.17722758800000002,0.0742570402,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.0513243364,0.0,0.0,0.261075296,0.0,0.7556335809999999,0.738948718,0.0,0.583915149,0.0,0.0,0.0,0.0,0.0,0.296105664,0.460913625,1.16509295,0.332019158,0.0,0.0,0.0,0.0,0.424081792,2.01795713,2.42611642,2.76864404,1.3150367,1.05408931,0.0,0.0,0.528023175,2.37193102,4.16078874,5.85141797,6.18498712,7.01745811,6.19578408,3.72336991,2.15334819,0.0,0.0,0.0,0.0,0.40314379,0.420879967,0.464280143,0.9832265440000001,0.0,0.301675079,0.0,0.0,0.0,0.11375889900000001,0.08144348950000001,0.833839531,0.034980746,0.107779574,0.0,0.0,0.0,0.333301697,0.0983304092,0.0,0.7408504090000001,0.632994886,0.0,0.0,0.0,0.0,0.34587094,0.0,0.492748095,0.469138296,0.261709848,0.100362516,0.0,0.30525480899999996,0.0,0.05668892019999999,0.7844293929999999,0.569017208,0.0,0.0,0.0,0.0,0.0,0.0,0.561666698,0.72910472,0.32643435600000004,0.275534126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.45332861799999996,0.0,0.255325741,0.0,0.0357959236,0.311532042,0.0920742825,0.179811634,0.63220267,0.0,0.0,0.0,0.0,0.0,0.635244624,0.8845862659999999,0.256737628,0.372588525,0.0,0.0,0.0338307832,0.429281346,0.0,0.0,0.495320308,0.0,0.040842662599999996,0.012978264199999999,0.315931129,0.0184254901,0.0410405629,0.0,0.0,0.0,0.6165585889999999,0.488816521,0.0,0.250023538,0.0,1.13645071,1.0443076,1.04682739,0.503596021,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
0.33781728,0.29455887,0.0,0.0,0.0,0.0,0.01633682,0.0,0.0,0.0,0.0,0.0,0.24039669,0.0,0.46831417,0.0,0.01609196,0.36322835,0.76570655,0.58664906,0.70354745,0.61497308,0.95110393,0.56136606,0.58110722,0.28830232,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04257731,0.53147967,0.97207807,0.7399678000000001,1.10711465,2.23687876,2.61287835,3.12483444,3.07872005,3.12715586,4.26897642,4.45940795,4.52887123,4.55401659,4.83478482,4.37599243,4.60276315,4.36572953,4.10899727,4.11772439,3.3283852999999994,2.580518,2.27038117,2.48157732,1.43021516,1.03825193,1.04642747,0.08406552,0.31400067,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04343599,0.0,0.0,0.0,0.5089169,0.0,0.89286036,0.52958884,0.6324484,0.91378951,0.36568257,0.21669562,0.62798534,0.49319526,0.0,0.70684587,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.268759242,0.44964369600000004,0.834432018,0.6718186759999999,0.27623735,0.328382477,0.189405157,0.0,0.241974324,0.42659800700000006,0.16422356300000002,0.117410729,0.103444095,0.12022475199999999,0.599662936,0.9109810709999999,0.744700576,0.751114698,0.7886527109999999,0.487545358,0.302241406,0.47366099999999994,0.613714045,0.415023971,0.0858886707,0.0,0.023792922,0.0,0.00403096985,0.0258798771,0.0,0.013321293799999998,0.0237833727,0.0,0.0268371892,0.0211641148,0.0,0.0797270154,0.204435912,0.07828007349999999,0.0,0.00473253864,0.227655346,0.285853961,0.0,0.0,0.311002756,0.517865456,0.43654629100000003,0.204138348,0.0,0.0761162903,0.13439457300000002,0.0038171394799999996,1.02348054,2.22514132,1.41614326,0.12181231699999999,0.18855169300000002,0.294982495,0.0,0.0,0.0464365886,0.0,0.00315208822,0.0,0.135670516,0.502347789,0.418640185,0.232674703,0.19242382100000002,0.00717555392,0.200057515,0.660829869,0.48511030299999996,0.512417357,1.57488395,2.01048775,0.84680378,0.0,0.0,0.09977202140000001,0.0,0.66960273,1.30741344,0.728121166,0.0393934313,0.0575911747,0.23818453399999998,0.8261202990000001,1.4274425,0.772853215,0.0,0.0,0.12163134800000001,0.0,0.008356854870000001,0.0639590326,0.0,0.0207423381,0.0367137681,0.0,0.0264373851,0.0191691788,0.0,0.0267409209,0.00636335014,0.0,0.0119753835,0.00045257955499999994,0.131746674,0.204532073,0.0,0.0,0.104733036,0.0979948971,0.250230785,0.369551367,0.34852693700000004,1.41007065,3.2287795,3.74285221,3.23690488,3.24297468,3.30972748,2.88253003,2.51002751,2.28861835,2.24005282,2.359382,1.88284917,0.9515476409999999,0.608131077,0.557484375,0.29732894,0.298624806,0.320947532,0.0708889395,0.114736524,0.172020055,0.0165612889,0.260726634,0.15923774699999999,0.0,1.90206814,5.30938522,5.81546664,4.06930049,3.52211487,3.79749691,3.22606482,1.95221494,0.595536058,0.0,0.035089974700000005,0.05611732690000001,0.0,0.052365946,0.11828877199999999,0.0142573419,0.00548266103,0.000204370995,0.0504791333,0.11184418199999999,0.0,0.0,0.0382431317,0.0,0.0,0.019526535600000002,0.0,0.0782349804,0.132701347,0.08877567480000001,0.101400934,0.038899508900000004,0.0217024356,0.202123804,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.309025341,0.922214819,1.27751293,1.29003171,0.979293594,0.45506447,0.0,0.0,0.0,0.0,0.0,6.572250610000001e-16,0.423126609,0.6970880140000001,0.7362846040000001,0.5304349279999999,0.146874674,0.0,0.0,0.0,0.0,0.0,0.16520527,0.621461846,0.899780172,0.8901482629999999,0.5658252570000001,0.0,0.0,0.0,0.0,0.0,0.0,1.26231067,2.88113596,4.48637086,5.77958619,6.51091361,6.53671953,5.85326738,4.597943099999999,3.01766188,1.41222887,0.0665972672,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
0.296620957,0.352066859,0.8126522820000001,1.28044913,0.39322429799999997,0.290810776,0.0,1.45148815,1.66429411,0.746627988,1.27921018,1.14743221,1.56513114,1.83539905,0.743616608,0.208659613,0.0,0.0524380993,0.266349595,0.0,0.0798856613,0.0,0.27475249399999996,0.551403427,0.658675934,0.37378868200000004,0.227815188,0.0,0.0,0.699246186,3.18106588,0.25337008699999997,0.0,0.303720139,0.0,0.40087594200000004,0.442161663,3.083927,2.14005539,0.0,0.396169751,0.0,0.442538914,0.0,0.168117879,0.0,1.56432061,0.216971424,0.282692149,0.0,0.306561055,0.21970203300000002,0.660223332,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
0.631013736,0.687186062,1.13052411,1.5654964,1.63504361,1.19705146,0.39079928399999997,0.0,0.0,0.0,0.0,0.765022612,1.55393786,1.91776315,1.76558235,1.23900271,0.617106401,0.161943825,0.0,0.0311691971,0.107334636,0.0561126065,0.0,0.0,0.0,0.0,0.7146117359999999,1.62625141,2.36611334,2.62302203,2.27040544,1.43530007,0.44266324700000004,0.0,0.0,0.0,0.0,0.292208731,0.44349574700000005,0.298924511,0.0,0.0,0.0,0.0,0.090784586,0.297478498,0.302834372,0.107935976,0.0,0.0,0.0,0.0,0.24220345899999998,0.377447876,0.263470109,0.0,0.0,0.0,0.0,0.297047771,1.10300999,1.85528904,2.31642992,2.36722092,2.04230606,1.49445413,0.914171373,0.449257681,0.161332886,0.0309899735,0.0,0.0,0.000943737178,0.000211149067,0.000785910333,0.00479656042,0.007147258070000001,0.00187403474,0.0,0.0,0.0,0.00197363186,0.0225665411,0.0305695419,0.017188781,0.0,0.0,0.0,0.0,0.0239449282,0.047676771500000006,0.040033957099999996,0.00343978961,0.0,0.0,0.0,0.0104574819,0.054845195199999995,0.06440339099999999,0.029757447700000002,0.0,0.0,0.0,0.0,0.049903717300000004,0.0869746758,0.06630992349999999,0.0,0.0,0.0,0.0,0.0289936075,0.105841819,0.11599755199999999,0.0451754174,0.0,0.0,0.0,0.0,0.119696866,0.193724984,0.138637992,0.0,0.0,0.0,0.038749185299999996,0.535380221,1.14788699,1.65944461,1.87058544,1.69343764,1.19391079,0.5600132870000001,0.0134561198,0.0,0.0,0.0,0.0458981953,0.166204018,0.157995894,0.0573863057,0.0,0.0,0.0,0.0,0.051925651399999995,0.0746324439,0.047263368300000004,0.0,0.0,0.0,0.0,0.0125651342,0.038926075899999996,0.046945215400000004,0.0414733026,0.032218192400000005,0.0241361024,0.015021459499999999,0.0014426433800000002,0.0,0.0,0.0,0.0297888033,0.0632970758,0.0699072374,0.033982786099999995,0.0,0.0,0.0,0.0,0.0808592332,0.158515187,0.136705148,0.0,0.0,0.0,0.0,0.131108775,0.692188198,1.27510223,1.65597679,1.67278046,1.30705563,0.6982990059999999,0.080674436,0.0,0.0,0.0,0.0335458298,0.23768452699999998,0.261913499,0.120718565,0.0,0.0,0.0,0.0,0.104155178,0.184487359,0.140834676,0.00698705125,0.0,0.0,0.0,0.0384016898,0.195646245,0.289061642,0.292299359,0.22828237,0.14290401,0.0695811228,0.011777654399999999,0.0,0.0,0.0,0.0117663802,0.304877473,0.7717841679999999,1.31015603,1.74542651,1.90471092,1.70528954,1.20791395,0.599842883,0.10997131,0.0,0.0,0.22240849699999998,0.44333475899999997,0.5166802389999999,0.46934362799999996,0.48127275,0.7909726009999999,1.55013038,2.70531426,3.97630837,4.95358428,5.27521877,4.79887715,3.68175094,2.32362678,1.19513691,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
1.08922603,1.75729043,0.0,0.342649944,0.0,3.00068132,1.92723487,1.94903024,1.36583797,0.326451987,1.54985156,1.20341007,0.684462091,0.0,0.0,0.473687765,0.0,0.320088339,0.503103394,1.01826811,1.23790004,0.0625960297,0.0,0.665602027,0.0,0.39952928200000004,0.995680597,0.0,2.49135278,0.0,0.0,0.0,0.30130296,0.0,0.0,1.18737757,1.31618533,0.37316208100000003,0.0,0.0,0.0,0.452646905,0.0,0.0,0.0,0.374794395,0.106288546,0.0,1.03197269,0.0,0.0,0.482181825,0.0,0.0,0.77451169,0.0,0.671441588,0.20154829300000002,0.6698068660000001,0.486844173,0.0,0.0,0.0,0.115735064,1.10568698,0.32091282600000004,0.0,0.0,1.29582869,1.64193602,0.6999726909999999,0.559085353,0.45383516,0.38306804299999997,1.7386333999999999,1.04448686,2.1213826,0.33958344100000004,0.0,0.54257975,0.721524866,0.0,0.0,0.0,0.0,1.1111621999999999,1.42174639,0.0,0.0,0.0,0.0,1.33645627,0.0856030161,1.06385813,0.0,2.26463415,0.0,0.0,0.206151213,1.07493308,0.6810345720000001,0.0,0.0,0.0,0.0,0.0,1.13925517,1.1744416000000002,0.0,0.48090992299999996,1.11875709,0.5394080520000001,0.9913427659999999,0.0,0.44216938,0.0,0.0,0.0,0.0,0.433928814,0.0,0.0,0.0,0.0,1.9623921999999998,2.14907466,2.14705179,5.28641945,4.91612236,5.05561016,4.80743141,4.25206403,4.86302277,4.60982875,4.11302328,3.2605159,2.83575356,0.21255369600000001,2.17445649,1.22244338,0.0,0.25353860699999997,0.0,0.126914645,0.0,0.7824832759999999,0.646039789,0.0,0.0521212558,2.05002546,0.166309404,0.512672353,0.0,1.38647291,0.0,0.0,0.0,0.0,0.783502829,0.284202264,0.33033262,0.0,0.0,1.1711231000000002,1.43003323,0.0,0.42322199899999996,0.0,0.0,0.261286828,0.0,2.11504919,0.00427698886,0.0,0.0,0.675734113,0.0,0.0,0.9167795870000001,1.20240321,0.16480039900000001,0.306572233,0.196359759,0.654476426,0.37710119200000003,2.21107812,0.0,0.0,0.058137351100000005,0.641723119,0.9652089340000001,0.0,0.7152172259999999,0.0,0.0,0.313604848,0.9383236859999999,0.213287532,0.0,1.13263099,0.0009963855319999998,0.0,0.829538923,0.0,0.0,0.0,0.342408951,1.05712268,0.507301941,0.7488941170000001,0.141570917,0.6544846639999999,0.15294766,0.7351916690000001,0.7430052840000001,0.317028396,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.723455528,1.25411632,1.60814625,1.72330911,1.60137642,1.30154676,0.91848322,0.5526693570000001,0.282450068,0.145790445,0.13609089900000002,0.211678022,0.314417887,0.39055086,0.406920369,0.35802789399999996,0.262862657,0.15395720300000001,0.0634450625,0.0113671114,9.35296025e-05,0.0161346263,0.0378133513,0.0452700086,0.028718651,0.0,0.0,0.0,0.0,0.0,0.0018522263600000003,0.0572443504,0.09448953730000001,0.0984121553,0.0660747223,0.00829670523,0.0,0.0,0.0,0.0,0.0,0.045523048600000005,0.0929789159,0.10575617300000001,0.0799064716,0.026904197400000003,0.0,0.0,0.0,0.0,0.0745127611,0.163158135,0.225709519,0.23722570899999998,0.18873229800000002,0.09135236470000001,0.0,0.0,0.0,0.0,0.0,0.00721478047,0.11103024800000001,0.17548513,0.177395104,0.115462649,0.0110596164,0.0,0.0,0.0,0.0,0.0,0.08736261779999999,0.17702209100000002,0.204798065,0.15883629400000002,0.0535744722,0.0,0.0,0.0,0.0,0.0,0.059833434500000005,0.184090787,0.24637252,0.22110037800000001,0.113323417,0.0,0.0,0.0,0.0,0.0,0.0181910248,0.198086535,0.317765275,0.328615153,0.21766959600000002,0.014833361000000002,0.0,0.0,0.0,0.0,0.0,0.26964190899999996,0.6109514460000001,0.86568833,0.9797354220000001,0.951127741,0.833665821,0.7212215790000001,0.716937704,0.896963154,1.28086635,1.81941639,2.40528,2.90484833,3.20218646,3.24137802,3.05301109,2.75463338,2.5226407,2.54200212,2.94769594,3.77529934,4.93653318,6.22898033,7.37948738,8.11076886,8.21347834,7.60375777,6.34982512,4.65957352,2.83201865,1.18557174,0.0,0.0,0.0,0.0,0.514329777,1.23979505,1.78467489,2.0379667,1.99345562,1.73555582,1.39992856,1.12269719,0.994644245,1.03424746,1.18678042,1.34817982,1.40466864,1.27457019,0.938631185,0.449342467,0.0,0.0,0.0,0.0,0.0,0.130237675,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47600000000000003
0.143516961,0.213978038,0.192441712,0.0910043932,0.0,0.0,0.0,0.0,0.0173944785,0.146418894,0.216790357,0.19163173600000002,0.0770007579,0.0,0.0,0.0,0.0,3.90300642e-16,0.179360732,0.289848854,0.270610858,0.11434233099999999,0.0,0.0,0.0,0.0,0.0,0.45277890600000004,0.91463838,1.25069888,1.36511272,1.23549954,0.919595753,0.5316313220000001,0.198057554,0.0104366871,0.0,0.105180038,0.254426734,0.34993101299999996,0.337549211,0.223880843,0.0719240684,0.0,0.0,0.18284498899999999,0.482507774,0.8085152240000001,1.05164736,1.12558825,0.9995112909999999,0.7088187340000001,0.340508816,8.86307708e-16,0.0,0.0,0.0,0.0,0.0819653742,0.21575287199999998,0.29789776100000004,0.342880234,0.38267852700000005,0.44492245799999997,0.535262505,0.63214114,0.6959611990000001,0.687878903,0.5891699539999999,0.412127729,0.197547267,1.2440832999999999e-15,0.0,0.0,0.0,0.0,0.044850183099999996,0.105797641,0.114017063,0.0719515479,0.0,0.0,0.0,0.0,0.0,0.188563426,0.50511296,0.9502187590000001,1.50962498,2.13604196,2.74622037,3.2313266,3.4810974999999997,3.41593928,3.01626092,2.33736901,1.50214779,0.671373239,4.106288e-15,0.0,0.0,0.0,0.0,0.12177301,0.27935564399999996,0.291043102,0.175665883,0.0,0.0,0.0,0.0,0.0,0.0667566222,0.162375809,0.177990218,0.11234881699999999,7.2368244e-16,0.0,0.0,0.0,0.0,0.0519108306,0.129587688,0.145664278,0.09423155539999999,0.0,0.0,0.0,0.0,0.0,0.050513200099999996,0.129537255,0.14975350099999998,0.0997752512,8.45651391e-16,0.0,0.0,0.0,0.0,0.0668593584,0.180053162,0.219714038,0.155483457,0.0,0.0,0.0,0.0,0.0,0.198174532,0.6693467679999999,1.14470494,1.50144768,1.64203877,1.52559372,1.18175241,0.7020043290000001,0.21111546,0.0,0.0,0.0,0.0,3.33381798e-16,0.180763901,0.25878402899999997,0.21470643600000003,0.0806480591,0.0,0.0,0.0,0.0,0.0104366871,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.02839714,0.39402054,0.0,0.92382131,1.05659918,1.29232563,0.26524255,0.57132943,0.96207589,0.78841405,0.67834899,0.45194343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04384465,0.68560119,0.90611226,0.26055131,0.55317257,0.0,0.22386286,0.0790026,0.0,0.0,0.03230897,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07598052,0.37713154,0.61674602,1.06123818,1.29201877,1.03748583,0.64320671,0.55750694,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.58024501,1.47306621,1.97670616,2.76354271,3.93298778,4.71832393,4.9954946,6.07901519,5.43269004,5.82850362,5.4083651,5.98435002,4.54509629,4.50132793,3.64468389,2.32565829,1.65603971,1.71990964,0.90279384,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.441266462,0.0,0.150175285,0.166416593,0.23840035699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0645916821,0.0,0.483627439,0.0,0.0942468325,0.0,0.0,1.1961859,0.0,0.337626721,0.0,0.22602482399999999,1.07616827,1.42283951,0.32300237,0.7698100059999999,0.0,0.0931192052,0.0,0.521744352,0.0,0.7364971379999999,0.583874365,1.00018392,0.0944213635,0.47339599299999996,0.720952629,0.35601378200000006,0.32082709800000003,0.33798108299999996,0.0,0.0,0.0,0.331008675,0.0,0.262770133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.34395834399999997,0.0,0.366335119,0.7415016,0.0,0.871079183,0.0,0.27259609999999995,0.0139951447,0.086257844,1.01988629,0.0,0.0,0.38595925700000006,0.438102416,0.0,0.0,0.123207934,0.0,1.29066077,0.235942853,0.0,0.0,0.41570102600000003,0.0,0.0011600162599999999,0.0,0.0,0.138981449,0.0,0.0,0.289085324,0.0,0.184540478,0.0519109692,0.0325137293,0.0,0.0,0.253025465,0.0,0.437224634,0.35168286299999996,0.30700775199999997,0.9584294740000001,0.506292807,0.276053269,0.40230964,0.844228413,0.575207836,0.43677541299999995,0.877938769,0.158782395,0.0,0.0,0.0,0.145851117,0.0,0.0,0.222396701,0.0,0.0,0.247628928,0.0,0.639146111,0.0,0.0,0.614083441,0.0,0.0,0.14261190599999998,0.22808870399999998,0.575721661,0.640541359,0.0,1.60039595,0.558208542,1.69046106,2.06723398,1.64370051,0.630943251,1.09652415,1.9617335,2.34954371,2.56598475,1.82328397,1.56930362,2.33007482,2.48154864,2.54576427,2.86361618,3.01353466,2.92678959,2.32317772,2.62129998,1.53509205,1.06748146,2.28654835,2.08183931,3.23181772,1.90420821,1.72469197,1.2538498,1.77975018,1.5277849,1.62613323,0.718971377,0.258937348,0.941929529,0.49303213799999995,0.991840385,0.9581095079999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.30165128199999997,1.58214845,0.814785806,2.55046246,3.58986021,4.13912668,3.5237986000000006,2.84486951,1.33306859,0.877278628,2.2523252,0.832709668,0.200489849,0.545288757,0.0,0.0,0.94456057,0.0,0.0,0.0,0.623495601,0.0,0.0,0.0,0.961968075,2.17594298,7.28597302,10.5628095,12.7542686,12.5721588,12.596063800000001,11.4807117,7.79320379,2.1671614,1.15957452,0.0,0.0,0.0,0.468595325,0.508484988,2.28028306,0.592012758,1.38807901,0.0,0.45669864299999996,0.0,0.183459239,1.30627991,0.755423638,1.90175031,0.0715471961,0.0,0.292255945,0.0,0.0,0.0192460674,0.0,0.0,0.514107604,0.0,0.0,0.0,0.0,0.449964405,0.0,0.596566476,1.48377365,0.0,1.40639114,0.424063415,0.106625568,0.0,0.0,1.22539293,1.74045445,0.6257751020000001,1.27254902,0.279130631,0.0,0.0,0.0,0.0,0.304859432,0.22881351600000002,1.10027402,0.912549825,0.567171354,0.0,0.0,0.0,0.47499945299999996,1.71626682,1.65115211,2.71609543,0.927963247,0.10677882400000001,0.0,0.0,0.12473572599999999,0.7000611090000001,1.75575126,1.66083665,0.21747936,0.0,0.628279909,0.29865405,0.0,1.0152097,1.28211915,0.0,0.585836401,1.12302288,0.0,0.990596723,0.0,0.0373937185,0.942285941,1.20879605,0.0,0.861636675,0.628855905,0.0,0.0,0.14671539,0.0,0.0,0.652806317,0.09771829779999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.518
0.199435165,0.117968915,0.33173142699999997,0.794701883,1.18415701,1.16920959,0.7404509640000001,0.288089704,0.310907585,0.97135824,1.88757911,2.38989601,2.07824822,1.22616827,0.655908056,1.12396859,2.67654509,4.50161319,5.43866196,4.78925417,2.82056103,0.580389379,0.0,0.0,0.0,0.454922676,0.6022721089999999,0.19492905100000002,0.0,0.0,0.0,0.258906208,0.355669513,0.132099675,0.0,0.0,0.323808465,0.839192603,1.09857964,0.939191285,0.511548225,0.124395937,0.0,0.0404485927,0.115026708,0.0715429133,0.0,0.0,0.00459006536,0.175237835,0.24878613300000002,0.139992959,0.0,0.0,0.0,0.0507264796,0.164447329,0.111670138,0.0,0.0,0.0766480457,0.37755618399999996,0.6053557039999999,0.594477308,0.37284117899999997,0.132070297,0.0494935487,0.13025415199999998,0.218592549,0.164988156,0.0,0.0,0.0,0.143376851,0.351264051,0.357567962,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.26485501899999997,0.286893174,0.254387154,0.188500809,0.116619846,0.062506447,0.038683148199999996,0.0433733374,0.0627961846,0.0778273459,0.07258167530000001,0.0418334536,0.0,0.0,0.0,0.0,0.10419764699999999,0.279947133,0.49079912600000003,0.697432625,0.8568698379999999,0.9338321629999999,0.910300178,0.7904490059999999,0.599526863,0.37706440700000005,0.166471953,0.0040862914500000005,0.0,0.0,0.0,0.0,0.0460220041,0.0868238611,0.09474802310000001,0.0715539481,0.0290571626,0.0,0.0,0.0,0.0,0.0,3.7655314e-16,0.022700960299999996,0.0332557974,0.030738543599999998,0.0190782151,0.00475047277,0.0,0.0,0.0,0.0,0.00010332028,0.0,0.0,0.0,0.0,0.0,0.0,0.0144279102,0.029896772999999998,0.0375351625,0.0322218634,0.013280747800000001,0.0,0.0,0.0,0.0,0.0,0.00524645346,0.0466577254,0.0765417921,0.08269745490000001,0.0601642668,0.0138211053,0.0,0.0,0.0,0.0,0.0,0.027339350800000002,0.09454175599999999,0.134788166,0.131588932,0.08224975179999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0706583159,0.167357596,0.213893157,0.189965372,0.0981611895,0.0,0.0,0.0,0.0,0.0,0.006854115059999999,0.18863300600000002,0.329670676,0.376485716,0.302175849,0.118410524,0.0,0.0,0.0,0.0,0.0,0.0423885425,0.380714281,0.635285297,0.7033947770000001,0.5286390089999999,0.12656134900000002,0.0,0.0,0.0,0.0,0.0,0.431175951,1.79624172,3.29381151,4.65709847,5.62610842,6.00752944,5.72062296,4.817328400000001,3.47126941,1.93826927,0.498217326,0.0,0.0,0.0,0.0,0.0,0.296611382,0.824838243,1.07514686,0.998182454,0.638253641,0.115540473,0.0,0.0,0.0,0.0,0.0390513526,0.9227726820000001,1.9613023,3.02158676,3.97730266,4.72767707,5.20781055,5.39065046,5.28277254,4.91698202,4.3444237,3.62777252,2.8357519,2.03826923,1.30121313,0.680441359,0.215410419,0.0,0.0,0.0,0.0,0.053684473899999995,0.182303293,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.39770637200000003,0.0,0.0,0.0,3.94929271,3.55554526,3.87458791,0.787848117,0.0,0.0,1.45814488,0.0,0.285038627,0.0,0.312321848,0.0,0.0,0.147684697,0.0,0.0,0.0615993164,0.0,1.4783006,0.773493585,1.13329903,0.0,0.0,0.9729967409999999,0.0,1.4575583,0.0,0.0,0.354129165,0.0,0.0,1.22363579,0.129877019,0.0,0.252983941,0.0,0.0,0.0,0.657483759,1.11847422,0.176261397,0.301025816,0.0,0.604544483,0.0,0.0,0.0,1.39711398,0.0,0.0,0.207688385,0.0,1.20984656,0.0,0.0,0.0,0.0,0.343474499,0.0,0.847319736,0.0,0.0,0.0,0.0439608966,0.0,0.0111508021,0.0,0.75177221,0.0,1.01698831,0.0,0.00665486483,0.32062175800000003,0.0,0.19635109,0.0926839799,0.501718063,0.0,0.0,0.0,0.0,0.714908923,0.0,0.0,0.882471862,0.45981510700000006,0.0,0.0,1.48088888,0.6777773559999999,0.23661923399999998,0.48120331299999997,0.0,0.9751932459999999,0.0,0.11885823599999999,0.0059681590500000005,0.0992867706,1.38375745,3.21135884,1.47182243,0.34665592799999995,1.06302815,0.278580764,0.0,1.6203014999999998,2.32215715,0.0,0.536884525,0.421813932,0.0,0.95918441,0.0,0.923486143,0.23419762,0.754195981,0.5413774370000001,0.0,0.396402198,0.0,1.4301693000000002,0.0183245654,0.95746696,0.0,0.0,0.0,0.926524395,0.0,0.0,0.124906751,0.0805783986,0.6959083859999999,0.848750323,0.0,0.112338985,0.295950153,0.117048591,1.01831537,0.0,0.602339369,0.0,0.0,0.430971489,1.19162327,0.37328660700000005,0.20878460899999998,0.277775298,0.0,0.0,0.266586648,0.895622293,0.0,0.0,0.0355653229,0.0,0.0,0.0,0.0,0.0,0.189308111,0.0,0.0,0.0,0.0,0.0,0.277087447,0.0,0.0,0.22580564600000003,0.454571936,0.29652429,0.0724459779,0.5011268320000001,0.0,0.0338297313,0.8542005979999999,0.0,0.0,0.8849999909999999,1.25474704,1.11760803,1.87336323,1.34065832,0.0,0.0,0.718549632,0.668548559,0.0,0.6922777790000001,0.0,0.578685697,0.0,1.28172999,0.0,0.0,0.322997773,0.5574120370000001,1.8713573000000001,0.0,0.0,0.0,0.48990300700000006,1.1031482,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41200000000000003
1.1559499,0.124387949,1.00839687,1.07522171,0.0,0.0,1.06242251,0.072218231,0.30887385100000003,0.866560742,1.11113913,0.630548685,0.0,0.0,0.48856638399999996,1.27681697,0.0,0.0036059558000000004,0.629460781,0.0,0.0,0.0,0.0,0.603926051,0.41827261,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.449138894,0.0,0.0,0.24081495,0.0,1.02024863,0.0,0.549378487,1.64089253,0.391056485,0.18583782,1.53570738,0.0720618745,1.1867563,2.37474536,1.5511473,1.94217419,2.50966189,2.17841377,1.97012123,3.61100484,2.65400358,2.81935304,2.57637546,2.77831387,2.98284485,3.61812384,1.57737935,3.68757535,2.40506969,2.86449652,2.1018596,3.50176353,2.39599908,2.86412346,0.890171348,0.922659755,2.28297425,1.46345724,1.4335209,0.523197096,0.805386057,0.0,0.527616379,0.0,0.565090645,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12427502900000001,0.0,0.0,0.0,0.0,0.724110613,0.0,0.255514995,0.298842027,0.730140103,0.0,0.41836691,0.0,1.14155415,0.0,0.0,0.330873083,0.6608602379999999,0.028755448399999998,0.94933519,0.744977483,0.663861425,0.0,0.627168233,0.0,0.185387722,0.0,0.315529393,0.48016875,0.12247088699999999,0.0,0.09316265380000001,0.21288317399999998,0.0,0.0,0.559305549,0.0,0.0,0.166737644,0.0,0.0,0.0,0.521663984,0.0,0.0,0.0,0.0,0.0,0.0,0.556427322,0.514644178,0.0,0.0,0.11982818,0.0,0.496718686,0.0,0.171229283,0.0,0.781716402,0.11901433199999999,0.7177330820000001,0.367626999,0.8395120640000001,0.7479196220000001,0.0,0.0,1.21257928,0.21700836399999998,0.070481938,0.0,0.279224806,0.174302161,0.0,0.267108226,0.17170629899999998,0.0,0.39509698200000004,0.25490217800000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.49708844399999996,0.0,0.112379899,0.336441562,0.0,0.0,0.44455110200000003,0.0107083135,0.286065619,0.35747502700000006,0.458419275,0.0,0.14326692,0.23999157399999999,0.0,0.0,0.0,0.176046285,0.190201105,0.0,0.09585160000000001,0.00337342049,0.005967084029999999,0.242825288,0.41983205,0.032269631800000004,0.13822787,0.37077568200000005,0.31206904,0.120678922,0.16834111300000001,0.47398662,0.0,0.0,0.241925786,0.0,0.21973525300000002,0.0029090140899999998,0.142927775,0.0,0.0,0.0,0.0,0.0,0.125642632,0.356362488,0.0,0.25276761600000003,0.28988308,0.216292333,0.40218817700000004,0.0,0.155866933,0.0,0.193150181,0.0,0.0,0.0102060918,0.382202324,0.0,0.0,0.05439199980000001,0.34728298700000004,0.266452538,0.0424788342,0.0193018431,0.42686046,0.715967674,0.258402032,0.0520745134,0.0,0.0,0.0,0.19304096399999998,0.40391334,0.0,0.0,0.28847295300000003,0.28332559399999996,0.21215906199999998,0.00379777114,0.0,0.0,0.0,0.43173787799999996,0.0,0.4944007,0.520441658,0.160152484,0.460817705,0.054706547599999995,0.0,0.0,0.21321429600000003,0.306647465,0.0463499801,0.0387485359,0.0,0.09810400710000002,0.0,0.11961206199999999,0.0,0.0,0.059115995899999996,0.0,0.0,0.49409607299999997,0.0121511146,0.557705894,0.278732556,0.132543768,0.549496406,0.37896803799999995,0.29342674399999996,0.0,0.0307852005,0.0201693544,0.0,0.0,0.0,0.0,0.0,0.0,0.29297051399999996,0.161353564,0.931570577,0.79031108,1.34407329,2.22866531,2.34795866,3.14151575,2.87740972,3.51474941,3.42755627,4.27463428,3.68060459,3.86132235,3.87585667,3.88085766,3.48216736,2.66546157,2.16938909,1.95549207,1.02305926,1.3050167,0.528951149,0.345795367,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.390114891,0.311351728,0.465624449,0.665464834,0.6077528,0.8935885140000001,0.652759659,0.0680276281,0.695788008,0.21929575899999998,0.0,0.0,0.0,0.223442251,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.600375029,0.18524524899999997,0.359723791,0.619765941,0.597309159,1.12501165,0.58249482,0.7449242340000001,0.9366539759999999,0.695332043,1.13198909,0.560150751,0.284767205,0.696672172,0.833442833,0.82473306,0.456783612,0.513293563,0.353156641,1.00845083,0.643368556,0.871697466,0.655447911,1.21993848,0.981530183,1.07693519,1.02387457,1.3447577,0.8858857040000001,1.16180564,0.8640399990000001,1.06807188,1.11179415,0.701120278,0.98381054,0.874260307,0.359776595,0.868257133,0.362477273,0.7871180529999999,0.388369225,0.707330927,0.0034826046,0.583663785,0.509384488,0.417672356,0.507027105,0.0,0.0380860246,0.38472807,0.0,0.201601682,0.0553157346,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
5.64537159,3.05798555,2.17858225,0.141077614,0.0,0.0,0.0,0.0402024729,0.436864875,0.057328359599999996,0.373994526,0.22849745899999999,0.0,0.0,0.0,0.393643598,0.12293438,0.5942998420000001,0.0,0.0,0.0,0.0208806541,0.0379803982,0.0,0.314634164,0.0,0.0,0.521216499,0.437244449,0.566225502,0.0,0.0,0.419508761,0.0,0.47778465200000003,0.0,0.0,0.0,0.657548629,0.421595396,0.0,0.0,0.0,0.38994883399999997,0.0,0.0,0.0,0.263611339,0.0,0.0,0.0,0.16203857300000002,0.0981273207,0.0,0.00527932266,0.0,0.0,0.0,0.0,1.32423414,1.38797845,1.62321634,2.72976651,2.13457514,2.06512557,2.07969273,1.16104757,0.987665758,0.0,0.22934794,0.232862407,0.0,0.0,0.0,0.267030566,0.0,0.0,0.60393753,0.0,0.0,0.0,0.0,0.0,0.469052304,0.0,0.0,0.514125184,0.467374556,0.0,0.0,0.0,0.24434236899999998,0.528351398,0.40680144700000004,0.514518834,0.0,0.0,0.0,0.252682025,0.0,0.0,0.0,0.0872376616,0.0,0.0,0.408210336,0.0,0.0,0.0,0.21352145100000003,0.0,0.0,0.798064166,0.47312987,0.0,0.347702379,0.18566982899999998,0.0250676821,0.0,0.0,1.10433194,1.13514621,0.940637857,0.591879547,0.97984438,1.22967089,0.731993995,0.9027839459999999,0.558893845,0.27684329399999996,0.71606225,0.0,0.0,0.0,0.0,0.9341975020000001,0.6921478520000001,0.532395735,0.0,0.38296559,0.0,2.08058924,2.76418211,5.48517323,6.46824219,6.31887424,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
1.5359604,1.80398977,2.39675612,3.0894839,3.53492612,3.47606374,2.91617365,2.12920582,1.49418671,1.25646359,1.37428036,1.55814486,1.48171986,1.02251916,0.363985128,0.0,0.0,0.388560632,1.09253269,1.56427612,1.5359604,1.09098332,0.614007403,0.53046768,1.00935926,1.83171931,2.51661711,2.62256551,2.0249900000000003,0.9894520440000001,2.15401087e-16,0.0,0.0,0.0,0.229165276,0.341556916,0.178215545,0.0,0.0,0.0,0.0,0.152422685,0.16534241800000002,0.0497187504,0.0,0.0,0.0,0.0371195333,0.10637137,0.0842116606,0.0,0.0,0.0,0.0,0.0412296949,0.0637839856,0.0337295957,0.0,0.0,0.0,0.0,0.0168079546,0.010699824699999999,7.3528921e-05,0.00756719715,0.0290124608,0.0291820125,0.0,0.0,0.0,5.98336352e-17,0.38123186299999995,0.9457878759999999,1.51442609,1.86430631,1.84804699,1.47869957,0.92479621,0.41593725600000003,0.11694817099999999,0.048504012699999995,0.10090796699999999,0.126567854,0.0465147657,0.0,0.0,0.0,0.08456589269999999,0.342292218,0.480018465,0.404200106,0.16460213199999998,0.0,0.0,0.23931255199999998,0.778234887,1.32786775,1.66329758,1.70394038,1.57547084,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.208956938,0.11298260199999999,0.0,0.0,0.08833006560000001,0.153196218,0.0,0.0,0.0,0.266564757,0.159749187,0.0,0.0,0.37827357,1.50737505,1.89504188,1.18947854,0.145031957,0.0,0.0,0.156101362,0.31258806699999997,0.48751099200000003,0.8163447070000001,1.15136522,1.45170659,1.99557537,2.85217158,3.39220958,2.82223856,1.25078382,0.0,0.0,0.0,0.34189115600000003,0.148047343,0.0,0.0,0.105032495,0.18987951600000003,0.0,0.0,0.0,0.136655204,0.0838427008,0.0,0.0,0.0451128934,0.11501818800000001,8.31794333e-17,0.0,0.0,0.0837709317,0.06533891530000001,0.0,0.0,0.021171981,0.0817398459,0.00986487534,0.0,0.0,0.0531133171,0.0504045246,0.0,0.0,0.00660316774,0.0468517415,0.00980710575,0.0,0.00739822203,0.0459411558,0.0250600804,0.0,0.022210791299999998,0.030299084700000003,0.0,0.0,0.316080747,0.8631391140000001,1.0874572,0.656756075,0.0,0.0,0.0143992045,0.424730017,0.34734107700000005,0.0,0.0,0.43264911899999997,0.952749403,0.981026652,0.673060358,0.597698851,0.960479144,1.36481985,1.35823063,0.9834674390000001,0.6736543420000001,0.7388699129999999,1.09076705,1.40076881,1.3988178999999998,1.05186366,0.581672536,0.314931841,0.40084453299999995,0.646354229,0.7276306490000001,0.590405156,0.51158772,0.689354329,0.9182752740000001,0.848949469,0.497983165,0.263212816,0.38591592,0.6202027489999999,0.587222325,0.297186927,0.093518335,0.144743966,0.25396124600000003,0.218638749,0.128809578,0.15149542300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.0040164223,0.0793483826,0.22639378699999999,0.0056651865599999995,0.17070070899999998,0.0,0.0,0.306888363,0.149986901,0.423170672,0.553305866,0.601158461,0.295902276,0.322759857,0.612570725,0.5183623239999999,0.12671902599999998,0.27485976,0.0,0.0,0.209207465,0.0,0.115201422,0.12024977199999999,0.533712616,0.7101629859999999,0.485522176,0.8119138459999999,0.82900513,1.15155804,0.635511918,1.21425593,0.8284767059999999,0.33140325,0.23673808600000001,0.09077668009999999,0.464838925,0.23256912899999999,0.0,0.0460671287,0.0,0.0,0.0,0.0,0.045905202,0.49516618,0.517595104,0.84319732,0.49667572299999996,0.670731246,0.09505037449999999,0.42459055,0.42650033299999995,0.0,0.0,0.0,0.0,0.0,0.101548217,0.030222947799999997,0.0721056638,0.0226025558,0.04833441769999999,0.464136723,0.31999082100000004,0.357917875,0.817344932,0.7324496159999999,0.76187593,0.504695126,0.167849603,0.0,0.309817907,0.23305785399999998,0.43022012299999995,0.0,0.6924222309999999,0.532677116,1.35028472,1.71875145,2.3646439999999997,2.7934049,3.06525771,3.60424143,3.76644582,3.59794535,3.78002858,3.69018688,2.96748785,3.34589241,2.41627275,2.55198167,1.8498013,2.16253054,1.90118091,1.71192661,1.28541833,1.05635701,0.8909666479999999,1.25947173,0.67593026,1.01031695,0.649520306,0.474439675,0.547678392,0.658687431,0.683154508,0.307111125,0.0933345602,0.378404986,0.346691486,0.13639310400000001,0.0,0.25774535,0.26063478100000004,0.45622244,0.18388011199999998,0.0,0.0,0.553398824,0.0,0.33408320399999997,0.378341075,0.38219527799999997,0.171378957,0.20754177199999999,0.112216599,0.197038993,0.0,0.0,0.0,0.0210218423,0.23014356600000002,0.13080649,0.09961654539999999,0.304028127,0.0,0.0020077603,0.30844939600000004,0.354736169,0.0,0.0,0.051849056,0.0,0.045012910499999996,0.0751107364,0.0,0.173566285,0.243803259,0.17695186300000001,0.133146667,0.0,0.21988164600000001,0.0,0.183118002,0.0,0.33920373600000003,0.0,0.0,0.0,0.07627660480000001,0.34429689799999996,0.0326321421,0.0,0.462325141,0.527744102,0.328919144,0.5613440789999999,0.11822815699999999,0.22255988100000001,0.674054093,0.251273132,0.11362781400000001,0.353221755,0.47490918600000004,0.310793278,0.0,0.563349285,0.33700006899999996,0.26758514899999997,0.362292656,0.533937946,0.347564486,0.0853351167,0.215512427,0.0,0.158820624,0.455408749,0.0,0.0807654863,0.0,0.283019081,0.13190802199999999,0.15801562,0.31986739399999997,0.19893354600000002,0.0,0.00257410471,0.033704060099999995,0.0118707059,0.26341596,0.32955968399999996,0.0,0.0,0.02780926,0.33865661700000005,0.283572049,0.0,0.0,0.0,0.153852457,0.0,0.0,0.10807878900000001,0.0,0.208419406,0.0,0.0,0.12679078800000002,0.084585819,0.231726006,0.06649787160000001,0.19022524100000002,0.0211190676,0.0,0.32505470000000003,0.29818951899999996,0.09402839619999999,0.0,0.278162057,0.0,0.46784594,0.299479305,0.403859586,0.19150233100000003,0.40695496200000003,0.272404859,0.237917336,0.0,0.10546656900000001,0.568170697,0.650676626,0.109487742,0.35277858,0.20584661399999998,0.302862998,0.128634004,0.0,0.33946189,0.383568788,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
1.03872124,1.12297118,0.18926110899999998,0.38422580100000003,0.4554595,0.131141115,1.21617008,1.55547241,0.963512018,0.83306744,0.739347056,0.0,0.125203927,0.0,0.129721762,0.0,0.200143982,0.0602178271,0.20545040899999997,0.182736708,0.192771708,0.7378722879999999,0.419299199,0.0,2.18844979,2.37479032,0.0,0.21234430899999998,0.0,0.0487033983,0.747677989,0.380197675,0.372119631,0.831653415,2.55980789,1.83987143,0.0,1.16810545,1.51015317,0.0,1.73585611,1.17485166,0.0,0.273242887,0.0,0.19618556,0.0,0.16815327300000002,0.0,0.202406795,0.115075489,0.032009929900000005,0.32875214199999997,0.73873501,4.92863988,6.71204374,5.40007537,4.7303296999999995,3.90602843,2.62949234,0.332951928,1.04965106,0.0,0.951811868,0.0,4.78711523,9.78783836,6.48005432,4.76912101,0.0,0.19962523100000001,0.0,0.182051199,0.0,0.16461721,0.0,0.06521988299999999,0.0163115949,0.269044089,0.0563730432,0.27071358100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.461
0.09121827140000001,0.8120418420000001,1.58545931,2.30287456,2.86225801,3.18566552,3.23272141,3.0074905,2.55734807,1.9639373,1.32780511,0.749542569,0.31098118199999997,0.0600589042,0.00234093128,0.10096270199999999,0.285174479,0.466002921,0.556121624,0.490117955,0.24114361399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.61956958,2.09395901,3.75901051,5.43189331,6.91337928,8.01753248,8.60027546,8.58203903,7.96065637,6.81229221,5.28021667,3.55328249,1.83768358,0.326660931,0.0,0.0,0.0,0.0,0.0,0.0,0.36981743100000003,0.994676903,1.41430138,1.57545489,1.47704151,1.16487514,0.718734713,0.234561269,0.0,0.0,0.0,0.0,0.0,0.0,0.20806819899999998,0.489082732,0.6890197090000001,0.78378414,0.775952005,0.6920955409999999,0.5751822679999999,0.473862083,0.431001336,0.473874585,0.607993282,0.815740204,1.05996371,1.29167564,1.4601912000000001,1.52360145,1.45745577,1.25994189,0.952589217,0.5764315760000001,0.18446152600000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.137075797,0.314483856,0.415048519,0.425605322,0.351273027,0.21317291600000002,0.0432396505,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.109870531,0.205633208,0.253633802,0.247662188,0.192753724,0.10340511699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00964337312,0.0793749301,0.12715362300000002,0.14527320300000002,0.132767681,0.0950414631,0.0421909843,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0123267636,0.0387232915,0.0526350145,0.053160941399999995,0.042648963,0.0257123627,0.007786587309999999,0.0,0.0,0.0,0.0,0.0,0.001589735,0.0015100255300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.019597994599999998,0.0463129087,0.0674021589,0.0764065723,0.0689668735,0.0442277458,0.00550212205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0660921121,0.12414665800000001,0.160564237,0.165352486,0.134675438,0.07222024610000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0282858918,0.13869888,0.22701409,0.2727903,0.26338858800000003,0.197209785,0.08475073960000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08578978539999998,0.245997606,0.36221095299999995,0.407129222,0.36755674200000005,0.24836462,0.0728680304,0.0,0.0,0.0,0.0,0.0,0.0173522361,0.34249352,0.6922318479999999,1.00246539,1.21037684,1.26706345,1.14842181,0.862028998,0.448412917,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48100000000000004
2.42438429,0.0,0.145470303,0.5572992170000001,1.97981633,0.0,1.81720944,0.0,0.0,1.51572199,0.43921734700000004,0.0,0.0,0.0,0.0,7.02160191,5.4843886,0.0,0.0,0.0,0.43101887,0.0,0.25282984399999997,0.0,0.668864372,2.1032425,0.081377542,0.0,3.68448848,0.0,0.0,0.0,0.0,0.39126233299999996,0.0,2.02150637,0.53001118,0.307603499,0.377894461,0.482312697,1.08947128,0.0,1.03854863,0.0,0.9324478759999999,3.51890216,0.0,0.031145487000000003,0.0,1.10603883,0.0,0.0,0.0,0.0,0.739725082,0.0,0.0,0.0,2.56560293,4.28810223,3.90999842,1.08780444,1.62849594,1.98150317,1.74859028,0.720946145,1.71684183,0.0,2.98549821,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.7004290459999999,0.38591932799999995,0.0,0.0,0.0,0.0,0.823081257,0.24228196,0.549847059,0.442171475,0.312949417,0.317234665,0.501812606,0.77928186,6.54577532,1.5265437,0.275145958,0.0,0.21380073300000002,0.0,1.94493384,0.964286564,0.0,0.0,0.0,0.0,0.538987536,2.67541318,5.307107,0.0,0.0152652095,0.0,3.35060817,0.405209065,0.0218685567,0.679010405,0.63067196,0.209742488,0.0,0.0,0.736391943,0.0,0.82995381,0.0,0.524183563,0.286595342,0.0,0.0,0.09019368130000001,1.24475085,1.51092683,2.03071281,0.441138308,0.0,0.212998231,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
1.20455614,0.0,0.0,0.0,0.0,0.0,0.236181964,0.45066832799999995,0.0,0.0,0.0,0.805936685,0.779374682,0.0,0.0,0.050482097999999996,0.0,1.13469595,0.5061390179999999,0.0,0.102288641,0.0,0.709382573,0.0,1.12667277,0.022790565,0.0,0.23785930100000002,0.368331325,0.0,0.18296482,0.0312280715,0.707919592,0.435054421,0.333048506,0.0,0.0,0.0,0.164026495,0.0,0.325175452,0.0,0.0,0.09141503220000001,0.156196007,0.32785300300000003,0.0,0.9773927579999999,0.0,0.954047518,1.86282996,1.43382493,2.64379897,3.02459102,2.21834573,2.18218697,0.646926372,0.7450756159999999,2.0128459999999997,0.0999864097,0.0,0.15870604800000002,0.55314522,0.81869455,1.05434327,0.941141697,0.0,0.0,0.0,0.23584440899999998,0.0,0.393213663,0.381138534,0.821066009,0.0,1.47426525,3.22585214,1.87410634,1.22058248,0.0,0.0,0.0,0.0,0.322466058,0.262547724,0.0,0.0,0.30676259100000003,0.0,0.897231998,0.0,0.9391254059999999,0.0,0.0,0.0,0.0,1.32750061,0.8334026459999999,0.0,0.826333677,1.42763336,1.73341331,1.71245018,0.0,1.42310104,5.58909304,3.02258159,1.80751449,0.0,0.0,1.62459892,0.0,0.0,0.14028157800000002,0.42146765399999997,0.0,0.0,0.0,0.0,0.368491529,0.0,1.0975517,2.98874887,0.0,0.650535305,0.730040349,0.0,0.0,0.0,0.0,0.0,0.684474316,0.0,1.73438479,0.0,0.257993849,0.182746252,0.45216568,0.0,0.952820564,0.0,0.19011273399999998,1.85791953,0.541134303,1.04606908,0.0256157978,0.0121819061,0.0499848413,0.452334697,1.4116151000000001,0.0516973247,0.0,0.0,0.251313165,0.7442993240000001,0.0,0.0,0.0,0.0,0.9262573740000001,0.0,1.13545754,0.0,0.0,0.30682386100000003,0.0327209362,1.14006641,0.429444955,1.29345104,2.49805363,0.0,0.692966043,0.0,1.07311505,0.525026853,0.0,0.340771689,0.386656412,0.0,0.0,0.0,0.0,0.0,0.208507995,1.12151265,0.0,0.0,0.0,2.41492834,0.465545231,0.164409848,0.42849673200000005,0.0,0.857335563,0.0,0.782380308,0.0,0.0,0.547108363,0.607680057,0.891037082,0.44205071700000004,0.208766905,0.445412718,0.397545769,0.683720474,0.7326593809999999,0.0,0.0,0.49553990200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
1.68811414,1.76158645,1.33953772,0.672590548,0.163562164,0.0,0.0200915124,0.040409596400000004,0.0,0.0,0.0,0.0415630578,0.0986564988,0.0499779672,0.0,0.0,0.0,0.047625853200000005,0.0703318275,0.0195568052,0.0,0.0,0.105648649,0.229045577,0.308435845,0.343899856,0.37104013399999997,0.402807459,0.415721268,0.398724882,0.397780325,0.48497083700000004,0.6693362079999999,0.8485343479999999,0.874861294,0.6911323890000001,0.40455685700000005,0.211584785,0.22977894699999998,0.391742615,0.505425098,0.428346501,0.19360238800000001,0.0,0.0,0.00823043028,0.127601601,0.140020723,0.0383090008,0.0,0.0,0.0,0.0623501624,0.07040167309999999,0.00761037037,0.0,0.0,8.369318930000001e-16,0.0467285284,0.0407418351,0.0,0.0,0.0,0.00783315565,0.032403567,0.021287805,0.0,0.0,0.0,0.0090421762,0.0194731122,0.00907760008,0.0,0.0,0.0,0.007065704859999999,0.010567236899999999,0.0031966106199999996,0.0,0.0,0.0,0.00836205753,0.0114774804,0.00149547957,0.0,0.00333888568,0.0762155658,0.208833568,0.350360073,0.416805847,0.349155069,0.166513375,0.0,0.0,0.0,0.0750081004,0.441845298,1.01970843,1.79717506,2.59547938,3.05331945,2.81517534,1.83012722,0.503473907,0.0,0.0,0.0,0.41510412399999996,0.5608326570000001,0.12359257400000001,0.0,0.0,0.0,0.598798453,0.8500441059999999,0.491936834,0.0,0.0,0.0487167964,0.489458684,0.45468036700000003,0.0,0.0,0.0,0.315811575,1.17473912,1.01511768,0.0,0.0,0.0,1.63417752,5.60818586,8.51470275,8.47177741,5.44523582,1.31482809,0.0,0.0,0.273665372,2.50618358,3.55283927,3.13125719,2.06097875,1.34702992,1.35109412,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.259282655,0.0,0.693969871,0.0,0.634360597,0.0,0.0,0.318406144,0.0,0.07682934599999999,0.0,0.0,0.81341874,0.0,1.31833441,0.0,0.0465980837,0.0,0.0,0.5096003579999999,0.0,0.0,0.0,0.0,2.48851975,1.52157488,0.36101325100000003,0.473928973,0.0,0.0,0.0,0.0,0.8217384459999999,0.0,0.0,0.0,0.340347994,1.47372795,0.34374952700000005,0.367833976,0.0,1.32544927,0.465302527,0.920491398,0.0,0.0,0.952879191,0.0,0.0,1.25581452,0.0,0.0,0.901849117,2.95040055,0.35066183700000003,4.16609927,0.929603243,0.0,0.0,1.22618586,0.903834198,0.0,0.0,0.0,0.0,0.0,2.62856723,2.07369789,2.05248606,1.52847185,0.539426079,1.19768695,1.32951764,2.40785336,0.44073626899999996,0.0,0.0,0.0,3.46691857,6.43946606,5.78388376,6.23297346,3.76446329,0.0,0.0,1.44386267,0.0,0.142146042,1.6608604,0.50699799,0.17941799,0.0,0.0,0.189550931,0.23391530100000002,1.19423081,0.0,0.0,0.0,0.604706884,1.53912696,3.1314659,1.82107241,0.632565101,0.794364018,0.846712618,0.924130936,0.123020923,0.0,0.0,0.647124977,2.84828736,0.358562738,0.057912600999999994,0.473985293,0.0,0.0,0.0,0.668917459,0.642033293,0.87802236,0.328836936,0.0,0.0,0.0,0.429590477,0.523240307,0.0,0.0,0.657645361,0.0,0.545796767,0.0,0.0,0.212867268,0.10754795199999999,0.0,0.0,0.0,1.60400903,2.46529945,1.08208262,2.11601743,1.56866009,1.34888575,0.817595038,0.0,0.0,0.0,0.0,0.0,0.0,2.70044164,0.0,0.0,1.77078733,0.0,0.0,0.0,0.0,1.89329195,1.40739843,0.712745121,0.564293555,0.07199313809999999,0.0,0.0,0.0,0.0,0.13091325,1.00660696,0.0,0.0,0.44784712600000004,0.09407191029999999,0.115269253,0.0,1.32264944,2.51262337,0.45112866,0.0,0.108802716,1.13149138,1.2499441,0.61160637,0.0802457721,0.533367492,1.9013626000000001,0.0,1.07781499,0.32742987100000004,0.0,0.366165321,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
0.7564269640000001,0.30756717100000003,0.0,0.0,0.183103325,0.568699254,0.5866356220000001,0.297083465,0.028993755,0.0,0.0,0.0,0.0,0.0121669373,0.0732282865,0.0779654263,0.026034102599999998,0.0,0.0177597331,0.036973701,0.0145485874,0.0,0.00038765938699999997,0.021311567400000002,0.008173777049999999,0.0,0.00770850286,0.055697966200000004,0.0543139077,0.0,0.0,0.0,0.043361006699999996,0.0293290802,0.0,0.0,0.0150469752,0.0506064076,0.005301065,0.0,0.0,0.0459833618,0.061564439699999994,0.00250454171,0.0,0.0469612578,0.164236706,0.230179286,0.24310204100000002,0.253808798,0.242928316,0.142123689,0.0,0.0,0.0,0.10912535400000001,0.133390584,0.0458293212,0.0,0.0123359927,0.04689585,0.00431055971,0.0,0.0,0.0527364601,0.0683883668,0.0,0.0,0.0035417226700000005,0.06156146690000001,0.022239581600000002,0.0,0.0,0.042021977599999996,0.06912664339999999,0.0,0.0,0.0,0.068548835,0.036469317599999995,0.0,0.129414193,0.456824049,0.611195461,0.36036953299999996,0.0,0.101579507,0.8584980609999999,1.82440475,2.3801736,2.32866599,1.97031424,1.73533663,1.88450601,2.45669,3.26018117,3.8852446000000005,3.96383748,3.56997149,3.20766677,3.20303432,3.21657579,2.64568617,1.5277525,0.707767666,0.876551823,1.65067716,1.95480949,1.29013381,0.26771228,0.0,0.0,0.0463875025,0.08802140060000001,0.404505877,1.26412556,2.13196082,2.1884088,1.36866224,0.48207492,0.233888581,0.464419962,0.551206938,0.298654172,0.08414883220000001,0.20148865800000001,0.442986036,0.469592959,0.317036468,0.27519594199999997,0.39656365200000004,0.422803105,0.215167241,0.0,0.0,0.148970829,0.157753241,0.0,0.0,0.0,0.10450502800000001,0.0727725778,0.0,0.0,0.027233889100000002,0.10114111699999999,0.014021118600000002,0.0,0.0,0.18403720199999998,0.36730720899999997,0.511686254,0.701848067,0.8652747209999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.10065854,0.0,0.35800284200000004,0.12757052800000002,0.435410515,0.187331312,0.420779454,0.286385312,0.391274251,0.46056180399999996,0.761373649,0.9020715,1.62547629,2.00684987,2.72377047,2.77378358,2.70812291,3.11075601,3.12567217,2.40697391,2.1412882,1.77098236,1.38424383,0.897626055,0.283769144,0.264438354,0.42875281299999995,0.741838151,0.829549138,0.974778423,0.628296266,0.616146631,0.172482844,0.203219294,0.0,0.0,0.150099116,0.0,0.23332204899999998,0.260715008,0.024465304700000003,0.0,0.0,0.381833259,0.0,0.22581101399999998,0.0,0.0,0.0,0.0,0.0,0.309823263,0.264083048,0.22140517899999998,0.0899748475,0.0,0.07068866019999999,0.0848130455,0.0,0.0,0.0623125109,0.19888914600000002,0.0,0.122935868,0.029485529500000003,0.018795257,0.0,0.0,0.367692929,0.599627189,0.739475523,0.660200353,0.677202379,0.7691861759999999,0.7555879190000001,0.683597995,1.1555913,1.02371465,1.2899937,1.5051845,1.29935793,1.76012737,1.81198098,1.58306947,1.89129694,1.67519899,1.36255449,1.14788512,0.556092396,0.776280238,0.607614247,0.121863605,0.19621598199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.09418644,1.15711591,0.687313189,1.00039707,0.629330881,0.645581566,0.556859106,0.274834468,0.41101012200000003,0.0015349496400000001,0.257886528,0.0300585631,0.340166591,0.0,0.45284614700000003,0.012623066200000001,0.0,0.185139462,0.896509308,0.439619162,1.22516918,1.38043939,1.11900672,0.956172328,1.06449721,0.366076081,0.5640297,0.7023017420000001,0.36326254399999997,0.867362464,0.7254385329999999,1.52208149,1.82112348,3.07228554,2.87770431,2.99912904,2.68042693,2.05659705,1.08581234,1.33944877,1.96102532,2.07237367,1.3831854,1.40002355,0.37098844700000005,1.08552688,0.9218155140000001,0.6844210820000001,0.761456391,0.45410835899999996,0.276877669,0.0576825221,0.474075068,0.135311362,0.500203928,0.0,0.42242647200000005,0.25276207100000003,0.25409897,0.337896425,0.0,0.0,0.224637893,0.0870999509,0.35357104799999994,0.0,0.0,0.0,0.326328424,0.0,0.056218257599999995,0.424037065,0.332754218,0.38382344700000004,0.227344775,0.21306418,0.0346033013,0.0,0.0,0.16496228599999999,0.0,0.0,0.0,0.0,0.35637281299999995,0.0897428998,0.0,0.528853406,0.0,0.0,0.0,0.0,0.499268814,0.35817372399999997,0.0,0.0,0.0,0.269025044,0.32908280300000003,0.40309676,0.0,0.0,1.03517174,1.12914406,0.74174724,0.247189078,0.0,0.555261644,1.65122128,3.54093719,5.33952482,4.55736067,2.60920533,0.531984726,0.0,0.0,0.21564467699999998,0.463412826,0.600599586,0.0,0.0,0.919111193,1.70655672,2.23410053,1.08801247,0.929511407,0.0853423923,0.24833613300000001,0.386577609,0.18818352100000002,0.312537581,0.0,0.0,0.0,0.35126497700000003,0.48805107,0.0,0.0,0.206044793,0.193918084,0.0,0.0,0.459788971,0.140346361,0.371450633,0.403332625,0.33154965,0.13570676,0.0,0.0,0.0,0.0787061842,0.62156554,0.131600196,0.0,0.0,0.134112675,0.0,0.065604611,0.41051191299999995,0.0,0.0,0.15569804199999998,0.0,0.410692822,0.103906151,0.0,0.0,0.0,0.0,0.4249186,0.0,0.0358036261,0.0303415781,0.07120546679999999,0.0,0.35265324,0.262280899,0.14209145199999998,0.339499576,0.0,0.146494071,0.43829101600000003,0.06392631230000001,0.0,0.0,0.0,0.0,0.301885854,0.6838847290000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
5.05565856,5.63786808,3.96638241,2.85787434,1.65206773,0.652952967,0.0,0.0,0.0317565167,0.0,0.20778335,0.278981249,0.221944637,0.39210855299999997,1.08991865,1.17387781,1.15377163,0.356956591,0.326585563,0.302939746,0.0739091219,0.0,0.0704699579,0.0,0.6211581860000001,0.029391121200000002,0.0,0.0,0.126653715,0.0,0.0,0.0,0.0,0.0,0.0,0.410321035,0.0,0.0,0.0,0.0,0.217916942,0.199716532,0.242561208,0.503570129,1.07408571,0.424141496,0.90060308,0.0,0.0,0.0,0.242420515,0.49121963700000004,0.0287609791,0.0,0.552133026,0.36202537700000004,0.0,0.0,0.0,0.505442349,0.0,0.11475064300000001,0.0,0.0,0.434515725,0.378297389,0.0191353149,0.569374332,0.0,0.0,0.0,1.28673593,2.10522948,3.44509629,5.45662037,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.641157145,0.41032183299999997,0.682431295,0.864751583,1.53080365,0.718972388,0.539445901,1.22395517,0.290421934,0.166549473,0.0,0.0,0.0,0.318560737,0.43016699700000005,0.48934152,0.18572788699999998,0.6921207509999999,0.0,0.615818442,0.16598668,0.62456526,0.480924526,0.0,0.0,0.0,0.374102944,0.11917363,0.702433601,0.33591624,1.14664675,0.15269482,0.359987657,0.309334665,0.0,0.247675998,0.0,0.031194934100000002,0.854024784,0.41725934600000003,0.893993448,1.0391886000000001,0.0505351441,0.0969607929,0.21240493800000002,0.0,0.130944284,0.325680528,0.240656788,0.0,1.09656871,0.0,0.008171026290000001,0.22177346399999998,0.0,0.0,0.0,0.0,0.0,0.48979157,0.0,0.353425095,0.0694500569,0.159084214,1.00481427,0.772178788,0.0,0.632434183,0.9601025240000001,0.0,1.49694502,0.172137437,0.0,0.435703805,0.10416924300000001,0.15167903900000002,0.0,0.305864643,2.21979307,0.44097039600000004,0.869758695,2.04918624,0.0,0.604496867,1.08331208,2.56784199,1.18458212,1.0317180000000001,1.04852894,1.15451061,0.0,0.293773526,0.94183669,1.07543334,1.30361028,0.7228851909999999,1.25788224,2.51282015,2.81547894,3.36663402,2.5152959,2.27041587,1.76555787,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.193865814,0.0,0.139213815,0.588584718,0.0,0.219713603,0.100815541,0.6994175509999999,0.9928976740000001,0.7679811990000001,0.0300230577,0.0,0.599515723,0.34076105700000003,0.261014332,0.0,0.251567372,0.516165318,0.463190244,0.0,0.623891218,2.28791455,3.80111419,4.45421717,3.5404328,2.35585603,0.9700430790000001,1.17005394,0.615959654,0.159372045,0.53912264,0.0,0.627207385,0.0319615233,0.220615886,0.0,0.18491610600000002,0.0459641434,0.0,0.0,0.0,0.0639283375,0.0031971453499999997,0.0,0.40221920200000005,0.490677676,0.6525778,0.698759369,0.640486751,0.310657652,0.410304957,0.22748190199999999,0.12634512,0.377114701,0.340092694,0.195928611,0.0,0.319536614,0.308529855,0.131899805,0.12864826,0.0,0.0,0.045830191,0.0,0.540139261,0.48770534,0.412600404,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.18608308,0.291757863,0.295679708,0.198940055,0.0389545116,0.0,0.0,0.0,0.0,0.015368335,0.18263741,0.292591214,0.300120603,0.19687220000000002,0.0158447673,0.0,0.0,0.0,0.0,0.0,0.20714904399999998,0.37881931,0.418376229,0.296215488,0.0399209754,0.0,0.0,0.0,0.0,0.0,0.473641332,1.07461228,1.58389439,1.88179625,1.90438602,1.66155621,1.23248503,0.740073027,0.31272179899999997,0.0458488036,0.0,0.071952031,0.255551367,0.427547611,0.5064337760000001,0.456587202,0.2999246,0.106896289,0.0,0.0,0.147371204,0.479960438,0.894020545,1.28200582,1.53642369,1.58290901,1.40266943,1.03733396,0.575205172,0.12401209099999999,0.0,0.0,0.0,0.0,0.0,0.13531858,0.30249998,0.410547175,0.472625759,0.5202091560000001,0.585236254,0.6836674009999999,0.806714665,0.9228202240000001,0.9892873879999999,0.968888966,0.845062761,0.629998061,0.362666816,0.09757355949999999,0.0,0.0,0.0,0.0,0.0,0.0627721608,0.143454964,0.165204667,0.127021787,0.0457450046,0.0,0.0,0.0,0.0,0.000211553496,0.24794455699999998,0.631553059,1.16104765,1.82804191,2.59611263,3.39558076,4.12698405,4.67519718,4.93256054,4.82572824,4.33861919,3.52387248,2.49782977,1.41863972,0.45221461399999996,0.0,0.0,0.0,0.0,0.0,0.12481187,0.357304057,0.42920146600000003,0.340774897,0.143927729,0.0,0.0,0.0,0.0,0.0,0.0590151137,0.199410315,0.257645319,0.21818454899999998,0.10120579099999999,0.0,0.0,0.0,0.0,0.0,0.038744459,0.153278318,0.208006286,0.184109849,0.0918547062,0.0,0.0,0.0,0.0,0.0,0.0306929906,0.14681825199999998,0.20987022600000002,0.194777595,0.104617937,0.0,0.0,0.0,0.0,0.0,0.0311451766,0.192658584,0.296672217,0.295877307,0.17549402,0.0,0.0,0.0,0.0,0.0,0.061425643499999995,0.610317387,1.22958066,1.79603699,2.18894795,2.32065583,2.15954719,1.73889625,1.14894465,0.514190203,0.0,0.0,0.0,0.0,0.0,0.014094326,0.244047414,0.35977211299999995,0.335530447,0.19393158600000002,0.0,0.0,0.0,0.0,0.0,0.01474934,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.110288976,0.545816239,1.11908199,1.54813571,1.5628654,1.09775888,0.363788736,0.0,0.0,0.0,0.08644994269999999,0.347822335,0.297496934,0.0119911908,0.0,0.0,0.0,0.185414487,0.289426481,0.146015844,0.0,0.0,0.0,0.049834606600000005,0.256144408,0.243699687,0.020403600900000003,0.0,0.0,0.0,0.183408901,0.313647132,0.174653762,0.0,0.0,0.0,0.0543098317,0.364458182,0.396794035,0.100392524,0.0,0.0,0.0,0.320890021,0.629368803,0.407179675,0.0,0.0,0.0,0.17209142300000002,2.08756945,4.05111217,5.18007389,4.99463682,3.68306886,1.95603779,0.60093423,0.0376249165,0.154078521,0.491580597,0.6115864129999999,0.376448324,0.0,0.0,0.0,0.0,0.18097177399999997,0.22884541,0.0879887325,0.0,0.0,0.0,0.0405808621,0.122079583,0.09037449130000001,0.0,0.0,0.0,0.039172472,0.0897445103,0.0729253081,0.0191849266,0.0,0.022035997400000003,0.060992773,0.0430440298,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.13659575,0.2115909,1.27681932,1.61640348,1.89657365,2.53301008,2.64177042,3.17295394,3.92446865,4.06714186,4.47108781,4.81023578,4.454028299999999,4.26393561,4.44407119,3.75994875,3.20766664,2.55923868,2.3152886,2.12961991,1.10842463,1.33522825,0.89232328,0.44717439,0.30312555,0.0,0.45223527,0.0,0.29122515,0.31019554,0.24190721,0.3079544,0.64055327,0.85046557,1.114609,0.98314722,0.7956548000000001,0.62640409,0.65081854,0.19069579,0.05242553,0.79561461,0.43961317,0.36505842,0.0,0.47292333,0.3981143,0.29449438,0.62631421,0.04395514,0.5810791000000001,0.0,0.21825587,0.41668943,0.37511096,0.0,0.2791852,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.28214861,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.39745662,0.0,5.68594133,2.5367776,0.03729396,0.69249846,6.45178992,7.53888206,2.69395962,3.34567671,0.18518175,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.308423032,0.260153426,0.18052565199999998,0.0945037544,0.0251076543,0.0,0.0,0.0,0.0,4.91429303e-05,0.0,0.0,0.0,0.0,0.00889798652,0.0311364713,0.0431932937,0.034829071,0.00486511535,0.0,0.0,0.0,0.0,0.0276422032,0.11868779800000001,0.20501848,0.26228028600000003,0.276447638,0.248814692,0.194448753,0.134909585,0.08865243769999999,0.0635649985,0.055029923099999996,0.0502293504,0.0363726591,0.008592830479999999,0.0,0.0,0.0,0.0,0.0110407424,0.05871356900000001,0.08408350380000001,0.07105118099999999,0.020667669399999998,0.0,0.0,0.0,0.0,0.0143675333,0.101980809,0.151338948,0.132524544,0.0448310596,0.0,0.0,0.0,0.0,0.0168027432,0.19486846300000002,0.309936525,0.290611346,0.11547457900000001,0.0,0.0,0.0,0.0,0.158584799,0.983589556,1.95362869,2.8467796,3.43691841,3.56354955,3.18393796,2.38940971,1.379788,0.40426133299999994,0.0,0.0,0.0,0.0,0.461478144,0.995127723,1.34421385,1.43827484,1.29157995,0.98327993,0.620585698,0.29996130600000004,0.0797503577,0.0,0.0,0.0,0.0,0.000779146158,0.0,0.0,0.0,0.0,0.00899243723,0.0353613806,0.0471533917,0.036771521200000004,0.00768625061,0.0,0.0,0.0,0.0,0.0101081182,0.0460930982,0.0625314902,0.050221631100000004,0.0129335675,0.0,0.0,0.0,0.0295983122,0.167173664,0.352293034,0.555312467,0.73858807,0.8655643940000001,0.909900478,0.86229263,0.73318377,0.55050609,0.35282868100000003,0.179536583,0.060633136399999996,0.00909459063,0.0181807852,0.0647309662,0.11758581,0.14848274,0.141754014,0.09939680710000001,0.0396218269,0.0,0.0,0.004300013839999999,0.0773652539,0.171603318,0.25758532300000003,0.308204812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.68238657,0.0,0.0,0.0,0.6017320279999999,0.735694782,0.0355471032,0.014461276,0.0,0.7259870829999999,0.496400506,0.225710176,0.55393563,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.444112055,0.0,0.273744765,0.176349581,0.400153989,1.02444879,0.566723408,0.850830878,0.385956904,0.21348592800000002,0.0,0.48896111700000006,0.37469926200000003,0.112115812,0.0,0.0,0.0,1.63768467,4.523288,7.01433933,8.1406291,7.51997615,3.31493078,0.326438467,0.0,0.0,0.360710947,0.0,0.648695437,0.0,0.0,0.0,0.0,0.031763867700000004,0.00636735866,0.0,0.0,0.0,0.547611957,0.0,0.962157565,0.0,0.09641279130000001,0.09182487539999999,0.0934778581,0.0,0.22680510399999998,0.0,0.6875397440000001,0.15259482300000002,0.357423262,0.34524417799999996,1.13249852,1.33866738,0.60255762,0.0,0.0,0.0,0.0,1.24596602,0.606161356,0.0,0.078313423,0.379577702,0.2674425,1.05252124,0.84676531,0.0,0.0,0.0,0.990330322,2.37524317,4.42886044,5.57184651,3.47960361,1.83345345,0.0,0.0,0.0,0.289673671,0.35196445600000004,1.05985766,0.0,0.385106237,0.22385350199999998,0.0,0.0,0.0,0.0,0.0,0.13206987,0.5867992679999999,0.370462205,0.0,0.559429536,0.7216553240000001,0.0,0.564487948,0.700737478,0.020262844,0.0,0.24573867600000002,0.533713929,0.0,0.0,0.105677004,0.0,0.7353811,0.155164053,0.0,0.439589852,0.0,0.0,0.0,0.0918725275,0.648519403,0.0,0.28454040199999997,0.0,0.0,0.0,0.809632461,0.749464248,1.05807492,0.025277772200000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.27268497,4.01876685,2.88215153,0.0,0.90998616,0.47182276,0.74221039,2.33610927,0.08781005,0.0,0.42530122,0.31346786,0.19236632,0.12573689999999998,0.17914577,0.0,0.0,0.0,0.0,0.35791182,0.12936047,0.48397681,0.0,0.0,0.0,0.40588581,0.94302935,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
2.42086261,3.42529322,3.75749095,3.16931599,1.89362243,0.5046195720000001,0.0,0.0,0.0,0.133039612,0.35756539600000004,0.250819846,0.0,0.0,0.0,0.0,0.139349075,0.165538234,0.0541062325,0.0,0.0,0.0,0.043325431100000006,0.100956466,0.0678605629,0.0,0.0,0.0,0.0,0.0494901098,0.053113617,0.0133371102,0.0,0.0,0.0,0.014673354599999999,0.0267144006,0.0146318499,0.0,0.0,0.0,0.000260445878,0.00163055634,0.0,0.0,0.006876744240000001,0.01306171,0.0065695412800000005,0.0,0.0,0.0,0.0103367658,0.031345166699999996,0.0254914975,0.0,0.0,0.0,0.0,0.017597617,0.018144486,0.049198524,0.21697308899999998,0.604320691,1.16801115,1.70399249,1.94090616,1.72648935,1.18066189,0.6830574429999999,0.664373568,1.31694522,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.414
2.17700221,1.82686498,1.1111625,1.1785731000000002,0.7699744940000001,0.0,0.0,0.399417179,0.0,0.0,0.46344552,0.0,0.0,0.931649293,1.66815113,1.48664948,2.43656265,3.64755648,2.94892712,3.82353111,2.9810681,0.636147071,0.16492004400000002,0.810319659,0.0,0.0,0.0,0.8482890829999999,0.6268402829999999,0.34075853700000003,0.71084005,0.0,0.533926069,0.328364649,0.0,0.6879359970000001,0.0,0.36490708299999997,0.0,0.0,0.0,0.0,0.7446154509999999,1.069291,0.0,1.28966792,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.126975094,0.0,0.0,0.70372365,0.0,0.6674315710000001,1.02281225,0.0,0.423736499,0.0206801453,0.0,0.0,0.875925072,1.53364317,0.0,1.07776534,0.0,0.0,0.0,0.34167782799999996,0.0,0.0,1.23346729,0.193621362,1.90953541,0.0,0.589232262,0.0,0.0,0.213593571,0.563140839,0.343730914,1.04058431,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.629834839,0.0,0.33425651100000003,0.558446795,0.0,0.7151381059999999,0.402942976,0.0,0.0,0.35135371,0.875466097,0.997438443,0.9535775870000001,1.00109685,1.47773422,1.80557638,2.55320655,2.68448192,2.30309915,3.32778948,3.47585953,2.13768647,2.90722701,2.39680959,1.76159936,0.325529687,1.50644531,0.0831915604,1.04710156,1.12085582,0.523357555,0.880518288,0.48984715,0.0,0.0,0.0,0.492062623,0.563509979,0.0,0.0,0.167560444,0.392598615,0.0367949163,0.0,0.0,0.0,0.0,0.6731772229999999,0.278776743,0.23528034399999997,0.0,0.19705501399999997,0.0,0.09270484080000001,0.587555057,0.200254054,0.0,0.0,0.0,0.0,0.356045244,0.27100515399999997,0.39153205799999996,0.35332802799999996,0.0,0.44843746100000004,0.6740937359999999,0.757685715,0.561883175,0.0,0.0,0.34963862799999995,0.0875361802,0.0,0.0,0.0,0.0717561942,0.213292061,0.333259383,0.0,0.0,0.0987751626,0.08046876139999999,0.0,0.40734053600000003,0.0,1.0463069999999999,0.0,0.0843646282,0.0769032627,0.748535837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.55627987,0.0,0.5549560570000001,0.222634533,0.0,0.588429854,0.749322887,0.0153965019,0.7404474740000001,0.0,0.0424203744,0.0,0.268684501,0.21154168899999998,0.0,0.7955846540000001,0.0,0.0,0.281595109,0.0,0.48219482,1.21947661,0.501619733,0.416999897,0.0,0.07392092730000001,0.602844601,0.0,0.0,0.25855793899999996,0.0,0.400212474,0.0,0.0,0.0,0.0,0.0,0.0,0.00867467716,1.30139843,0.0,0.180523342,0.526581724,0.0,0.0,0.0,0.223176588,0.0627846306,0.20676783899999998,0.0,0.0,0.35994770299999995,0.300237858,0.0,0.0531270183,0.194788034,0.31055488800000003,0.179824612,0.194773134,0.5727417579999999,0.88791835,0.9135225159999999,0.0,0.0,0.949287653,0.0,0.0,0.0,0.0,0.0,0.0,0.255354368,0.0,0.23669995800000002,0.0,0.0,0.0,0.0,0.886655674,0.152695782,0.16929117300000002,0.0,0.0,0.0,0.406465504,0.694812902,0.47500636,0.00933781979,0.0,0.0,0.0,0.282618983,0.0,0.401293535,0.0,0.8396319659999999,0.747595145,0.0,0.0,0.373936628,0.0,0.0513680625,0.604969189,0.9321859809999999,0.388505431,0.824357833,0.251491428,0.286220613,0.0,0.47369295,0.0,0.36215332299999997,0.194296147,1.00983283,0.543402846,0.304393181,0.30214757600000003,1.31491243,0.163918019,0.0,0.0,0.0,0.413851158,1.00182618,0.43580879200000006,0.0,0.0233515761,0.0,0.16232186,0.0,0.142394696,0.0,0.0,0.0,0.21680851,0.272794997,0.0,0.254925252,0.7341701070000001,0.905318815,0.168185494,0.431493888,1.30747232,0.613571024,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.75845718,0.465148766,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.2488757,0.0,0.0,0.0,0.976845617,0.0542475968,0.0405513977,0.522432386,0.701123031,0.0,1.03745798,0.0,0.865580392,0.0,0.0,0.859843534,0.0,0.0,0.6066776,1.23727708,1.456024,0.0,0.0,1.8544073,1.42157509,0.256889042,0.0,0.0,0.0,0.375682552,0.0,1.49574619,2.68347626,0.0,0.576184486,0.85291496,0.0,0.114877745,0.921352585,0.319836205,0.0,0.7127227829999999,1.22854086,0.608902665,1.48523233,0.927272291,0.0,0.0,0.0,0.0,0.0,0.0,1.37536893,0.0,0.0,1.1650764999999998,0.0,1.09637466,0.0,0.636441071,1.12365025,1.04813236,0.0,1.10178614,1.16041969,0.968674165,2.08370468,0.33959950899999997,0.5451351010000001,0.41357445,0.0,0.866308802,1.20295677,0.0,0.444700785,0.787654148,0.9576784740000001,0.7131761109999999,3.07112962,0.547756496,0.985508762,2.33520305,0.269785223,0.0,0.0,0.000888407866,0.0,0.178114198,0.0,0.16887085300000002,0.0,0.6060419770000001,0.0611670447,0.961227871,3.65165757,2.95815593,5.05568144,4.26011806,6.66217123,6.67540772,4.62690652,5.982439299999999,4.43165505,3.63110704,1.76637137,1.63194536,0.7595954220000001,0.981532313,0.498910897,0.955748292,1.92944864,0.279428104,0.689928946,0.0,0.0,0.0,1.57668341,0.0,0.0,0.285740957,1.26270491,0.0,0.48974339100000003,0.0,0.0,1.92228709,0.744750859,0.31624231199999997,0.0,0.45905291600000003,0.0,0.575147145,0.5953794720000001,0.0,0.0,0.0,1.70342618,0.0,0.403711086,0.0,0.452442423,0.308413414,0.0,0.0,0.0,0.0,0.0,1.31962564,0.7394232690000001,1.78258109,0.9536954609999999,0.0,0.0,0.0,0.0,0.0,0.0,0.979986287,0.0,2.05439103,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.456
5.99210236,5.73608803,5.33537378,4.8087967,4.18098002,3.48094449,2.74048224,1.99239231,1.26868552,0.598866734,0.00839701054,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0423377158,0.299467663,0.51352021,0.671623613,0.765814181,0.7932766929999999,0.7562321009999999,0.661492645,0.519726169,0.344489892,0.151107714,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04779409019999999,0.195704579,0.323633465,0.42200331,0.483798082,0.50503696,0.485007312,0.42624456899999996,0.334265647,0.217080702,0.0845240223,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0593536942,0.18257072100000002,0.290383799,0.37416396799999996,0.427224001,0.445339604,0.42707784,0.37390783,0.290085353,0.18232020100000002,0.0592517095,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0840000579,0.215643317,0.331906995,0.42304560700000005,0.481141974,0.500768141,0.479465035,0.41800077399999996,0.3203836,0.19362352,0.047255550599999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.155875702,0.34674816700000005,0.519592203,0.659436513,0.7531118170000001,0.790352125,0.764736347,0.6743974640000001,0.5224405870000001,0.317029729,0.0711248893,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22524123399999998,0.820643535,1.49028059,2.20834275,2.94517561,3.66883231,4.34679575,4.94776783,5.44341763,5.809981700000001,6.02961821,6.09143134,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.456
5.6513870999999995e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,5.6513870999999995e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,82.43181750000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.675
2.06740758,2.27712333,1.00969503,1.13833093,0.0,0.0,0.0,0.0,0.0,0.898746802,0.2392947,1.48925439,0.0,0.473557419,1.07141899,0.0,0.390120294,0.837087675,1.48913076,0.24307774199999999,0.0,0.0,0.0,0.911917165,0.698463255,0.0,0.0,0.0,0.0,1.87600094,0.985448133,0.031039732900000002,0.800053373,1.51487939,1.00460634,0.0,0.0,0.222696956,0.0,0.0,0.9469449209999999,0.38587315299999997,1.01711685,0.0,0.64172767,1.19582182,0.652239071,1.56210617,0.718165891,1.23986918,0.0,0.234790783,0.80271974,0.0,0.754288748,0.0,0.0,0.048270619199999996,1.30697348,0.0,0.0,0.570447735,0.792258483,0.0,0.291163665,0.0,1.64681643,0.0,1.25734595,0.34182963899999996,0.0,0.0,1.50966506,0.300623453,0.150554339,0.76557843,1.18550608,0.0,0.9426100590000001,1.01281228,0.0,0.8048096509999999,0.0,0.0,0.311522043,0.0,1.40770217,0.0,0.7218973479999999,0.800693144,0.326433903,0.192458889,1.10818345,0.0,0.0,0.0,0.568345035,0.0,0.332293401,0.583734314,0.0,0.0,0.0,0.538243998,0.7985836409999999,0.277550802,0.22535277399999998,1.53425271,0.0,0.0,0.550041339,0.0968661838,0.535462175,0.24391377,0.44489954600000003,0.37131991200000003,0.0,0.38887366,0.967806715,0.0,0.8694695720000001,2.23833333,0.0,0.0,1.13385206,0.0,0.0,0.0,0.48456161299999995,0.0,0.0,0.09094241869999999,0.0,1.26945364,0.9401118970000001,4.21042578,3.63681234,2.19420767,2.68960336,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.327427688,0.468419255,0.460246065,0.45654729200000005,0.335275471,0.485230829,0.30966363199999997,0.325251626,0.0,0.0,0.0,0.214178698,0.0,0.0,0.211222295,0.340291148,0.0,0.0,0.0,0.0,0.0,0.0412318321,0.0,0.0,0.0,0.24694991,0.187058107,0.0268946262,0.0,0.270333916,0.0,0.0,0.24686782899999998,0.0,0.273254277,0.0,0.0,0.0,0.296746844,0.395303881,0.133499323,0.0,0.0126978308,0.0,0.0,0.0,0.22668024,0.13793127300000002,0.315128903,0.0,0.0,0.40280514,0.233291523,0.217469778,0.0,0.0,0.0156894288,0.0681990307,0.0,0.0,0.0,0.356848832,0.258263748,0.0,0.10553938300000001,0.0,0.0,0.0,0.0,0.0,0.31724398,0.0,0.09796093970000001,0.0,0.0,0.0,0.09152426890000001,0.193752463,0.216803097,0.236168433,0.0,0.0,0.0865723309,0.058193910999999994,0.408095328,0.935254545,0.929523311,0.79975725,0.89107773,0.491874379,0.58322856,0.146227949,0.034642093900000004,0.32463028,0.0,0.208622225,0.43838904700000003,0.23500766399999998,0.294432347,0.0,0.0753164194,0.553492141,0.54598408,0.955931593,0.940328721,0.610416312,0.602045551,0.0924310994,0.9084115070000001,0.981241177,1.51032742,2.67402965,3.03326455,2.95634331,2.98305648,2.64470542,2.01544148,1.19253008,0.480015456,0.400042237,0.728188472,0.920520582,1.22598168,1.18178866,1.23860045,0.809507689,0.682744855,0.596079099,0.44638637299999995,1.16471758,1.12749118,1.32871499,1.37132154,1.12102256,0.993650768,0.6104511779999999,0.866023654,0.96859232,0.7294560440000001,0.8264185909999999,0.88176414,0.906693965,0.9928646990000001,0.9641954229999999,0.499162325,0.5664263070000001,0.7446605340000001,0.398070865,0.29701096,0.27614656,0.0812659251,0.235329675,0.0424567377,0.0,0.151964904,0.238069068,0.10124543400000001,0.27371471199999997,0.182812342,0.0716037172,0.20527533899999997,0.0,0.0,0.0,0.163943701,0.270239854,0.0874926504,0.0,0.0,0.0679207098,0.0,0.0,0.0788295076,0.06669294099999999,0.0,0.0,0.41025946,0.268885666,0.605708948,0.854646815,0.7753611640000001,0.574799397,0.700101366,0.819322276,0.894743692,0.713209675,0.9220838840000001,0.9748713109999999,0.587150367,0.884017369,0.96848314,0.670991137,0.39632399100000004,0.212229613,0.59054516,0.30125208600000003,0.084090007,0.0,0.263472867,0.0,0.0703359883,0.270646072,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
0.8659394029999999,1.28032111,0.967448546,0.6983356820000001,0.798832089,0.0,0.639301176,0.21338452800000002,0.0,0.8842804940000001,0.480593845,0.0,0.425935891,1.30813308,0.574153785,0.97975453,1.0990596000000001,0.45946637700000004,0.0,0.7871491429999999,0.0,0.698391055,0.25343391,0.0,0.0914526287,1.39727849,1.93605063,0.914433072,0.975936433,1.28662977,1.44007072,2.35624639,2.69146567,1.08066158,1.06211053,0.0,0.887944238,0.41534287,0.227404188,1.12667587,0.6795361670000001,1.89602163,2.22635181,3.2803737999999996,3.28408003,0.737591627,0.0,0.12756461800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.5650279810000001,0.0,0.0,0.0,0.255758611,0.0,0.602594702,0.0,0.0,0.0119657974,0.0,0.0806131337,0.42077808899999997,0.0,1.04002485,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.06415354,0.6959864,3.08894125,1.11141337,0.68411785,7.57176983,7.65658763,1.69245815,0.75037443,0.94741259,0.12252249,0.04078932,0.0,0.0467338,0.0,0.0,0.08047397,0.0,0.05485442,0.04427629,0.0,1.37218139,2.67280364,0.0,0.0,3.15921751,2.7416069,0.66657176,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.0749760993,0.94634923,0.206591317,0.8300716779999999,0.5184697979999999,0.38950423700000003,0.506680577,0.524014781,0.0,0.5850318529999999,0.8691319270000001,0.265368121,0.153556592,0.0,0.0,0.819711557,0.0,0.0,0.0,0.281260159,0.627188113,0.252689406,0.0,0.6223446020000001,0.628058948,0.0,0.0,1.349911,0.218477208,0.738270105,0.628078038,0.0999950965,0.370382195,0.239032434,0.7955794629999999,1.10875643,1.63210767,1.01745777,0.15308364300000002,1.18373938,0.516957294,0.49539337299999997,0.0,0.529614877,0.0,0.467380522,0.0129749058,0.0,0.48178263600000004,0.0,0.312467394,0.0,0.0,0.241686629,0.0,0.31524444,0.0,0.42230669200000004,0.206452091,0.662593325,0.0,0.203560977,0.586161779,0.00104487877,0.424649675,0.0189727953,0.0,0.390693341,0.0,0.0,0.0,1.08803468,0.0,0.0037185588200000005,0.0,0.0446280853,0.228088773,0.0,0.0,0.07579635480000001,0.24748531399999998,0.132023274,0.0,0.15345061,0.794814777,0.864480637,1.12841016,1.172059,0.7567426429999999,1.93355478,2.07682607,1.8338393,2.32956741,1.64352899,2.22706141,1.45208786,1.75977648,3.0863041,2.1105542,2.37714949,2.96269894,3.09620083,1.47426998,2.02504037,2.24454011,1.65372558,2.03437123,2.50212315,1.91429181,2.37008112,2.27670151,1.73363627,2.12283318,1.64942628,2.01007774,1.09693773,2.211408,1.15975304,1.28778714,1.24294291,1.15310114,0.718297931,0.629273685,0.685073382,0.0,0.46705545600000004,0.0,0.0,0.0,0.0,0.0,0.0,0.506864082,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
1.37362321,0.8262506,2.64342041,0.90376069,0.65104896,0.0,0.05969746,0.0,0.0,1.24387898,1.38771987,0.12733121,2.91119177,0.0,13.86734722,8.90991286,0.0,1.89888388,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47100000000000003
0.88853447,0.0,10.22058921,7.34226473,0.9042418,0.0,1.06047998,0.0,3.0167352000000003,3.25254868,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.412170972,0.27358395399999996,0.368248459,0.547167909,0.772012301,1.00314117,0.848721035,0.182389303,0.0,0.0,0.391055837,0.0911946515,0.0,0.0911946515,0.8925802709999999,0.8207518629999999,0.0935315632,0.0,0.46146945799999994,0.182389303,0.0,0.182389303,2.68684741,4.19495397,2.7065181000000003,0.0,0.0,0.0,0.585031335,2.1149248400000001e-16,0.0,0.455973257,1.56925127,1.82389303,1.28100555,0.63836256,0.218715212,2.87989765e-16,0.0,7.199744129999999e-17,0.0100599811,8.63969295e-16,0.021676280200000002,2.15992324e-16,0.0,0.0,0.118891328,0.0,0.0,0.0911946515,0.8252730420000001,1.09433582,0.7056423140000001,0.8207518629999999,2.03562005,2.91822885,1.93849186,1.79993603e-16,0.0,0.0,0.494608025,3.95985927e-16,0.0,0.0,0.339259776,8.09971214e-17,0.0,0.0,0.285934535,2.15992324e-16,0.0,8.99968016e-17,0.268265775,0.0,0.0,0.0,0.276130598,0.0,0.0,3.14988806e-16,0.328756887,0.0,0.0,0.0,0.8161603829999999,0.911946515,0.304425535,1.4399488300000002e-16,0.300185724,0.547167909,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
1.32435173,0.19378539,0.13906876,0.13507471,0.05816082,1.54483611,2.34276042,6.43012482,5.55310906,4.39351175,2.1676102999999998,1.20075097,0.69092218,0.31623850000000003,0.0,0.0,0.0,0.13688547,0.0,1.65303806,2.0319039,1.38661031,2.0854965,2.48185448,1.57457072,0.73009826,1.1890872,0.20832335,0.58736767,0.16711038,0.0,0.0,0.0,0.06671527,0.7345513000000001,0.0,0.16448143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.45267032,0.0,0.41344058,0.0,0.41406451,0.0,1.92115354,0.36472718,0.18442449,0.0,0.7281009,0.0,0.37799551,0.0,0.49989449999999996,0.0,0.69194734,0.0,1.39094498,0.0,8.94138587,12.29950555,0.0,0.93669351,0.0,2.34167707,3.31422561,0.80174126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.465
1.28341205,2.31365428,1.5887642,0.7079138759999999,1.20804302,1.80846133,0.0,0.0,1.55119741,0.0,0.0,0.690424684,1.15585553,0.247952079,0.40868775700000004,0.0,0.0,0.0,0.9744031470000001,0.0,1.84736131,0.90307784,0.0,0.106416477,0.977481315,0.0,1.61494192,0.0,2.34648139,0.0,0.6810163690000001,1.07445155,0.930614582,2.22395852,3.71341887,3.81209208,4.02820229,4.09063249,4.83900479,0.996184677,0.23854670100000003,0.0,0.0,0.0,0.7383049979999999,1.17689206,0.0,0.713818231,1.25039196,0.501995425,0.0,1.2153254999999998,0.0,2.38982863,0.0,0.9673841959999999,0.0827298699,0.0,0.0,0.0,0.0,0.590192477,0.297408426,0.703114432,0.545827233,0.0,0.012441211499999999,0.0,0.129133276,0.09569230949999999,0.0,0.0,1.40160674,0.0,0.0,0.0,1.19104433,0.0,1.40411518,0.11233625900000001,0.39603493700000003,0.00815742432,0.258468821,0.0,2.36556872,0.601176618,0.254597285,0.947007165,0.0,0.018854939299999998,0.0,0.0,1.80520702,0.259525418,0.0,1.30233923,2.33780425,0.0,1.88814579,0.272460071,0.0,0.458297416,1.23937519,0.8758174999999999,2.18707723,0.0,0.761025046,0.0,0.0,0.61157993,1.32873555,0.99529549,1.46189171,0.452099414,0.08814530400000001,0.24202179999999998,1.65166213,2.17950362,0.522668757,0.355581534,0.0,0.9445764259999999,2.52241963,0.16693593,0.916173425,0.202261589,0.0,0.0,0.3581842,0.18251015899999998,0.7456517659999999,0.464387755,0.12408095400000001,0.0,0.225504149,0.0,0.0,0.6238031070000001,0.34956449100000003,0.916191207,0.419647308,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
0.0981567015,0.688446606,1.12593978,1.30702579,1.20795,0.883403477,0.443591822,0.017899514,0.0,0.0,0.0,0.0,0.12391882900000001,0.326859317,0.418074915,0.373634845,0.215364547,5.9695255e-16,0.0,0.0,0.0,0.0,0.0,0.08742372150000001,0.22560290800000002,0.28405481,0.250771934,0.14307335,0.0,0.0,0.0,0.0,0.0,0.0,0.0544543572,0.13892301199999998,0.17273503,0.150401976,0.0845073676,0.0,0.0,0.0,0.0,0.0,0.0,0.027072554900000004,0.0663764509,0.0788163846,0.0650214275,0.0342682142,8.208097560000001e-16,0.0,0.0,0.0,0.0,0.0,0.00212667446,0.0,0.0,0.0,0.0,9.32738359e-17,0.0217815383,0.0439940829,0.055914052,0.0488733599,0.0205415281,0.0,0.0,0.0,0.0,0.0,9.32738359e-18,0.07195852,0.129323032,0.149855023,0.121515635,0.0479965965,0.0,0.0,0.0,0.0,0.0,3.77759036e-16,0.131950281,0.232721292,0.26530175899999997,0.212118742,0.08277934769999999,0.0,0.0,0.0,0.0,0.0,4.47714413e-16,0.21989624800000002,0.38877939799999994,0.44529097,0.358621746,0.14139907599999998,0.0,0.0,0.0,0.0,0.0,0.0,0.492790195,0.9826332459999999,1.36249495,1.55494056,1.53411075,1.33241422,1.02953342,0.7268235279999999,0.514896709,0.444594831,0.5108027039999999,0.654745635,0.7846320509999999,0.80850417,0.66885718,0.367442283,0.0,0.0,0.0,0.0,0.0,0.241959175,0.864097089,1.38566074,1.62376853,1.4589075,0.881445815,0.0108441131,0.0,0.0,0.0,0.0,5.59643016e-17,1.8956429,4.11792274,6.2750339,7.96181899,8.85271083,8.77745795,7.76018118,6.01173948,3.8775671999999997,1.75475454,2.2385720600000003e-16,0.0,0.0,0.0,0.0,0.0,0.24874912300000002,0.540013957,0.543853416,0.34484284200000004,0.104146998,2.98476275e-16,0.16574792,0.6439495239999999,1.3696832,2.18724965,2.89458054,3.30173768,3.28613929,2.82853077,2.01966678,1.03632985,0.0940952349,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48100000000000004
3.13256326,3.19176273,3.10754131,0.948735992,0.0,0.0938735848,0.0,0.899804825,0.32389282,0.0,0.252087133,0.0,0.15201969099999998,0.0,0.0,0.369856939,0.0,0.0,0.37615351,0.0,0.0,0.14338294099999999,0.0,0.8318888879999999,0.0,0.167417701,0.0,0.0,0.0,0.172676062,0.0,0.173426881,0.216143573,0.0,0.0821868712,0.0,0.0,1.38773728,0.0,1.04358309,1.04698744,0.0433111333,0.729086592,1.18091572,0.0,0.0,0.751846322,0.0,0.0,0.0,0.0,1.23006217,0.340957674,0.434303307,0.24583652600000003,1.73158053,0.00669492069,0.0,0.0,0.339269275,0.0,0.915842244,1.37701759,0.0,0.0,0.0,1.11819142,1.11403609,0.0,0.472835414,0.0,0.966213668,0.0,0.0,0.301650722,0.0,0.911163763,0.507755266,0.111269083,0.0,0.0,0.0,1.64320388,0.48715357,0.0,0.0,0.0,1.03467271,0.17756693399999998,0.0,0.0,0.0,0.0,1.06431954,0.0,0.0316408893,0.84985814,0.0,0.0301155644,0.19041152,0.0,0.0,0.0,0.128037516,0.0,0.0,0.0,0.0,0.08829864300000001,0.0,0.0183057801,0.8270384129999999,0.0,0.13544962800000002,0.0,0.0,0.0,0.10904930199999999,0.372004616,1.45725182,0.0,0.0,0.0,0.0,0.0855300109,0.0,0.0928143651,0.0,0.0,0.0,0.0,0.7573931279999999,0.0,0.329750568,0.0,0.0,0.22454575699999998,0.0,0.665415744,0.0,0.7404279990000001,0.459631878,0.0,0.0,0.0,0.707790501,0.0,0.7818907709999999,0.629322955,0.285560091,0.0,0.0,0.0,1.04936275,2.30023505,3.69490776,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.415
0.16872104100000002,0.0,0.0,0.353854822,0.194461205,0.0,0.0628823308,0.0,0.0,0.326172227,0.362071209,0.518721109,0.396890401,0.45919734700000003,0.378428384,0.036151786,0.792528645,1.6988881999999998,1.78719737,2.64126199,2.18390286,2.03663834,1.13813364,0.482208931,0.489905035,0.105878341,0.126096349,0.37554296600000003,0.0,0.34562009299999996,0.0,0.0,0.17725965,0.12789415699999998,0.245710758,0.336657614,0.0,0.140433516,0.286829095,0.214182675,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.13562543300000002,0.0,0.34750869,0.19851543,0.0,0.0,0.0,0.205046509,0.0,0.0,0.16940058100000002,0.15257331699999999,0.28212264600000003,0.179567217,0.24647280300000002,0.0,0.0663288885,0.11092903,0.0,0.0,0.14512431,0.0,0.0,0.0337944549,0.10737678,0.0,0.11916303,0.386324496,0.0686684598,0.0502523868,0.138958683,0.0,0.235297991,0.353465938,0.30414232199999996,0.0922617883,0.0360207477,0.0,0.0,0.46255637200000005,0.529327105,0.474668019,0.46400428,0.217925658,0.0,0.0,0.358391141,1.40474037,2.79122594,3.65038457,3.69254421,3.20285286,1.95342342,0.529075204,0.0,0.0,0.0,0.40196808100000003,0.940961023,1.08625498,0.629405863,0.598965053,0.29437438899999996,0.346312002,0.477288104,0.550825274,0.786762891,0.706853649,0.208415491,0.0357148613,0.0,0.0,0.28775830399999996,0.0,0.0,0.155596971,0.0,0.0,0.0,0.0,0.0,0.21154172300000001,0.20330379,0.0,0.0,0.0,0.0,0.0819249948,0.125104957,0.208937033,0.0230191879,0.0,0.0799813287,0.0751997988,0.0262504658,0.0,0.23616717899999998,0.0883517524,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.132943396,0.31577107,0.517094892,0.734241647,0.964099985,1.20317919,1.44767829,1.69356382,1.93665457,2.17271115,2.3975283,2.60702767,2.79734871,2.96493555,3.10661758,3.21968173,3.30193466,3.35175332,3.36812248,3.35065841,3.299618,3.21589322,3.10099089,2.95699842,2.78653632,2.59269871,2.37898325,2.14921243,1.90744802,1.65790089,1.40483847,1.15249207,0.904966376,0.666153299,0.439652228,0.228698564,0.036102166,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0541312042,0.12525520699999998,0.187673008,0.240149445,0.28181386399999997,0.31216343399999996,0.33105620399999997,0.338694482,0.335599355,0.32257741100000004,0.300680892,0.271162691,0.23542768,0.194981947,0.151381495,0.10618197,0.060890849299999994,0.016923457700000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.008830075,0.0245722627,0.0374596237,0.047261862,0.0538945066,0.057414796,0.058012209800000006,0.0559941366,0.051767338600000004,0.0458160071,0.038677314500000004,0.0309154474,0.0230951423,0.015755756200000002,0.009386868270000001,0.004406347529999999,0.00114172016,0.0,0.00053534536,0.0032885048600000003,0.00794228863,0.0142490376,0.0218563292,0.0303217435,0.039131692,0.047723610300000004,0.05551068940000001,0.061908213499999996,0.0663605038,0.0683674324,0.0675094719,0.06347027940000001,0.0560558929,0.0452097178,0.031022622200000002,0.0137376195,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00935190869,0.0579949482,0.10881252300000001,0.160375973,0.211147952,0.25952611600000003,0.303890995,0.34265673399999996,0.37432324200000006,0.39752820200000005,0.411097359,0.41409150200000006,0.405848586,0.386019575,0.354596687,0.311932948,0.258752145,0.19614855899999997,0.125576103,0.048826813600000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.007031909100000001,0.7233320390000001,0.609815758,0.0,0.0,0.338767274,0.7259451259999999,0.0,0.9340246209999999,0.0,0.0,0.427034515,0.0,0.305308631,0.0,0.0,0.0,0.0274393969,0.408931506,0.753870881,0.24284024899999998,0.205500265,0.0,0.0,0.091983236,0.44081002,0.631572345,0.508270479,0.0,0.0,0.0,0.362449896,0.0,0.0,0.0,0.732164597,0.0,0.0137256217,0.798818826,0.9310985890000001,0.9499247120000001,0.0,0.0,0.620558996,0.28730438399999997,0.0193803482,0.548320177,0.0,0.0,0.207110417,0.453119019,0.0,0.0,0.0,0.691536233,0.0,0.523743185,0.5186705979999999,0.8087197620000001,0.793079857,0.0,0.0,0.0,0.752857875,0.733435229,0.0,0.875377073,0.0,0.0,0.0,0.0,0.0,0.0,0.320488172,0.769714511,0.433104699,0.0,0.45549443,0.0,0.366557599,0.0,0.242311965,0.506220804,0.0,0.8172143690000001,0.444888574,0.0,0.121373187,0.0,0.0,0.0,0.466444161,0.489840065,0.0,0.0,0.0,0.7491030940000001,0.0,0.0,0.601409254,0.0,0.221389257,0.0,0.0,0.0,0.688130452,0.680287875,0.297557885,0.0,0.0,0.48353087,0.886801081,0.859921102,0.879879903,0.0,0.536551569,0.0,0.0,0.46877564899999996,0.44099583600000003,0.8574463370000001,0.760093441,0.8995563120000001,0.6196532020000001,0.221218949,0.0,0.499907155,0.414064036,1.85756114,4.757233,5.88449843,8.20151682,8.37453729,7.91506377,7.20840501,6.75966369,3.66028154,3.20922239,2.02653791,0.397963579,0.6322978260000001,0.504804707,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47600000000000003
1.21288282,3.24276322,0.0716802864,0.11052967,0.0,0.00856777738,0.0604064706,0.0,0.299432049,0.0,1.79232595,3.55861407,0.0,2.40979186,0.822455514,0.602137225,1.42044246,2.00067701,0.0,0.0,4.34022829,8.29649251,1.28293891,0.373531735,0.0,0.310088958,0.0,4.08774843,0.0,0.42613319200000005,0.00448092944,1.83470921,0.0,0.245240252,0.0,0.279021264,0.0358824756,0.366936135,0.524340817,0.30869045100000003,1.85345198,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
19.7743606,3.42045946,0.0,0.0,5.71180004,6.16153584,0.0,3.22200725,0.0,1.53667334,5.23291214,2.83569611,0.0,0.376619592,0.0,0.0,2.62754105,2.44572913,0.466129571,0.0153323334,1.44032778,0.477181887,0.577309985,2.39366078,2.65059262,1.16844459,0.0,0.7551864290000001,0.0,0.71495259,0.0,2.38775624,1.42585512,0.7135186109999999,0.0,0.816148688,0.0,1.10361413,0.0,1.32917718,1.18447598,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
1.11382557,1.19156367,0.205549857,0.0,0.0,0.0,0.6141129,0.49848593799999996,0.015993963400000002,0.18345411399999997,0.807228543,1.93124846,0.379227328,0.830946658,0.0,0.0,0.0,0.0,2.02776507,0.44030578200000003,0.0,0.0,0.629132708,0.0,0.0,1.5011317,0.128892421,0.200185776,0.401924751,0.8779775790000001,0.427899737,2.61298086,3.16841951,2.10426827,1.19401294,0.972754982,0.15281656,0.0,0.0,0.481640487,0.0,0.0,0.682759095,0.472816874,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.43402516,0.421607012,1.89469815,0.893019443,0.8113664079999999,1.15300697,0.0,0.0,0.374672998,0.840929026,0.0,0.0,0.398401876,0.524299515,1.17709885,1.48988142,0.0,0.0490884742,0.0,1.81466639,0.937526368,0.8614977070000001,0.0,0.0,0.534058976,0.19855314,0.87968633,0.31550034600000004,0.0,0.353979239,1.87616169,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.84655969,0.032316177200000004,0.0,0.15751229,0.0,0.9885553690000001,1.16807214,2.69986379,2.00579647,2.55304734,1.92190728,2.85772862,2.60186719,4.92921239,1.91178628,1.03621015,1.30623991,0.383845645,0.126620351,0.0,0.0,0.0,0.0,0.68071653,1.10246299,0.0,0.0,0.0,0.0,0.24780844300000002,0.0,0.014228984299999999,0.044431035199999996,0.0,0.0,0.0,0.646534121,0.0,0.179184412,0.0,0.0,0.7261860590000001,0.0,0.9002665670000001,0.5432359,0.0,0.0,1.15054593,0.507792565,0.81151182,0.0,0.0,0.0,0.679798366,0.0,0.0,0.287833033,0.247823958,0.0,0.0,0.0,0.344920965,0.0,0.0,0.0,1.50786783,0.114919635,0.613614167,0.0,0.252635603,0.36751146,0.7832485509999999,0.740877362,0.0,0.796752421,1.21846225,1.70717121,1.27653138,1.43090247,1.40309106,0.187710231,1.13336459,0.215287549,0.0,0.23774488,0.210212282,0.24310205399999998,0.8225525890000001,0.726419762,0.0413349281,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.598053664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.0642818664,0.101096971,0.13989954599999999,0.18272501100000002,0.234569663,0.30215163899999997,0.392281404,0.5101071229999999,0.657520251,0.8319851159999999,1.02599659,1.22728091,1.41974901,1.58510403,1.70491008,1.76286061,1.74695139,1.65126871,1.47714848,1.23353829,0.936493667,0.6078471360000001,0.273191421,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0504439243,0.337187015,0.621440339,0.879603957,1.09164444,1.24272741,1.32423883,1.33412964,1.27659637,1.16118049,1.00142539,0.813265615,0.613336223,0.417381679,0.238915607,0.0882412678,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012333391,0.044835530199999994,0.0658396706,0.0743158588,0.0709467165,0.0578020596,0.037910278,0.0147811978,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0067961446799999995,0.021841459700000003,0.0330391979,0.0389139929,0.0387824019,0.0328276771,0.0220585534,0.00815694946,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00726019997,0.0206258734,0.0307604059,0.0360997279,0.035831720299999995,0.0300319481,0.0196587046,0.00640378907,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0061992181799999995,0.0145344994,0.0191818037,0.0200076176,0.0181698951,0.0160991358,0.0172289991,0.0254931388,0.0446473855,0.0775135827,0.125266736,0.18689541,0.258953496,0.335689345,0.40958891700000005,0.472308784,0.515910882,0.53425312,0.524347647,0.487479554,0.42988805,0.36285104100000004,0.302079589,0.26641418,0.275909522,0.349486556,0.502406331,0.743868926,1.07505286,1.48788226,1.9647413,2.47925465,2.9981294,3.4839239,3.89848753,4.20671913,4.38023448,4.40052332,4.26121722,3.96917875,3.54424925,3.01764317,2.42913335,1.82331399,1.24533916,0.736599705,0.330812012,0.050946228499999996,0.0,0.0,0.00503062094,0.20578559899999999,0.46690001200000003,0.7526082959999999,1.02774279,1.26136892,1.4297363,1.51823952,1.52221369,1.44653932,1.30417767,1.11388455,0.897440094,0.676774952,0.47136526100000004,0.29621188,0.160623643,0.0679032444,0.0159053575,0.0,0.00641873806,0.031022082000000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.09936201050000001,0.10178422699999999,0.031628929199999996,0.0,0.025068301400000003,0.0756243781,0.0,0.0,0.133849386,0.0,0.0,0.185078955,0.0,0.0,0.209905343,0.090109286,0.0,0.18182041699999998,0.44365370299999995,0.186678838,2.7024532999999997,6.91302522,6.56173331,1.82994884,0.0,0.638666702,2.66778429,4.67904528,5.63260532,3.44029092,0.33410318899999997,0.0,0.356635363,0.0,0.0,0.18701219300000002,0.0616987101,0.0,0.0696014165,0.0945148073,0.0,0.0,0.0633169202,0.0,0.152987776,0.30850196399999996,0.4173045,0.8018482029999999,0.859900503,0.229196063,0.0,0.0753122236,0.0670983465,0.0,0.0141370207,0.073941612,0.0,0.0,0.0633304086,0.0,0.0,0.044904729299999994,0.0,0.0,0.0267887786,0.016759423500000002,0.0,0.0128647336,0.040504753500000004,0.0,0.0729474204,0.613335352,0.9260988440000001,0.509725725,0.152334989,0.4715705,0.515237244,0.0,0.0088264053,1.03547296,1.29831084,0.502722937,0.0,0.0374041979,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.713888423,0.933852873,0.8307791959999999,0.871498647,0.915430815,1.25816875,1.5463676000000002,1.75639755,1.37634436,2.04070296,1.77454497,2.02425163,1.67814004,2.06126661,1.54604844,1.1731958999999998,1.09404032,0.7656233490000001,1.10955572,0.956584433,0.8457025490000001,0.749881008,0.909616876,0.807142824,0.662444979,0.655956998,0.415725645,0.14674351,0.748130405,0.37536911,0.51083371,0.392657685,0.0,0.48798569700000005,0.0,0.0,0.0732250897,0.0,0.0,0.0,0.36653081299999996,0.0,0.0,0.402420733,0.0,0.0,0.0,0.0,0.0,0.0,0.0884326208,0.0,0.404524237,0.495830341,0.0,0.314233253,0.00305207956,0.09413700800000001,0.14752941,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.393101345,0.631259418,0.9253953659999999,1.93906811,2.72471528,3.08239753,3.35773099,3.52477554,4.14419166,4.28818714,3.78895396,3.74903631,3.19087546,2.6279765,2.28825182,1.22607074,0.798722198,0.831809102,0.361199029,0.0,0.0,0.257089341,0.220810317,0.270796357,0.0,0.27829398,0.0,0.318296831,0.0,0.0,0.0,0.0,0.209539557,0.018423899,0.0346056138,0.0,0.283662317,0.381503905,0.0,0.216706603,0.0255513022,0.0,0.0,0.0,0.165240011,0.0,0.0,0.0,0.0,0.0,0.0,0.318314849,0.792782993,0.97802487,1.09572286,1.43223012,1.29800244,1.27471465,1.24943607,1.70832244,1.17481846,1.65813646,1.40313365,1.07695489,0.934485517,0.334197082,0.24238078300000002,0.172707312,0.166620328,0.0,0.0,0.0,0.0,0.0,0.0,0.397360027,0.0,0.412459148,0.0,0.0,0.38046699799999995,0.36187930799999996,0.12390674199999999,0.217141317,0.28649618600000004,0.0,0.0,0.0,0.0,0.0,0.0808533768,0.0,0.0,0.0,0.133724191,0.390940667,0.17285206,0.0,0.0898626328,0.0,0.0,0.22509707899999998,0.0,0.283917895,0.0,0.0,0.158968524,0.0,0.0,0.36611031,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.77315252,0.0,0.0,2.54622328,2.05608569,0.0,0.0,0.60295753,0.0,0.0,1.85528591,0.43947507,0.68397835,2.74038864,3.24722323,2.41770297,0.57763359,1.100827,0.70978038,0.87061109,1.2902271,1.96001669,1.48133463,0.0,0.0,0.0,0.0,0.0,0.0,0.66316756,2.47108556,1.27859341,4.25532564,4.67951066,4.36284138,4.55864121,3.05375876,1.3691216,1.43998073,0.18874807,0.0,0.0,0.0,1.66013482,0.0,2.27948916,0.35631512,1.18305488,0.0,0.2129814,0.65655527,0.0,1.7778541,0.88611768,1.82877272,0.0,0.0,0.61728883,0.0,0.03922886,0.0,0.92978154,0.77397949,0.0,0.0,1.89282583,0.0,0.03994763,0.0,0.87113515,0.60935599,0.0,1.51840596,0.0,0.0,0.79313075,1.90980779,0.0,0.0,0.75259164,1.03326053,0.0,0.0,0.0,0.13830439,0.29189190000000004,0.0,0.0,0.26401535,1.60377113,0.0,1.00882914,0.0,0.28131131,0.0,0.0,0.19832983,0.0,0.0,0.2636967,1.73949868,0.0,0.0,0.43456721,0.0,0.46691922,0.0,0.91500285,0.50953506,0.0,0.0,0.98826865,0.0,0.0,1.03062181,0.31632733,0.93675521,0.62924823,0.0,1.98116808,0.0,0.0,0.0,0.0,0.0,0.24195416,0.0,0.0,0.0,0.0,0.0,0.37073083,0.0,0.65583084,0.85787047,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.47560097,0.50757411,0.47720804,0.87352898,1.15780926,0.0,0.32622462,0.76091881,0.0,1.05874804,0.0,0.0,0.26638166,0.0,1.19384269,0.57888664,0.0,0.0,0.0,0.0,0.12105554,0.0,1.10147359,1.97068789,2.72422041,2.09206974,1.74109564,2.51039956,3.03966557,0.0,0.08980397,0.0,0.0,0.0,0.93350754,0.0,0.0,0.66277453,3.99458021,0.0,0.0,0.91361496,0.55365906,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.180229117,0.451595175,0.501171499,0.261225269,0.0,0.0,0.0,0.0,0.58762216,1.49658727,2.22826765,2.5284468999999996,2.3111696,1.68716757,0.904982815,0.23644753699999999,0.0,0.0,0.0,0.145867987,0.218436073,0.138185226,0.0,0.0,0.0,0.0,0.08537174630000001,0.187352486,0.159399264,0.018200739,0.0,0.0,0.0,0.0490483522,0.20727346600000002,0.229331987,0.084702839,0.0,0.0,0.0,0.0,0.28720300600000004,0.422439416,0.25888588100000004,0.0,0.0,0.0,0.0,0.7430319959999999,1.96957343,2.96294089,3.31111449,2.86673824,1.82527163,0.629025689,0.0,0.0,0.0,0.204970202,0.598686914,0.6491439920000001,0.360988084,0.0,0.0,0.0,0.0,0.144541144,0.307762322,0.249925528,0.0316488144,0.0,0.0,0.0,0.0492340088,0.20781153600000002,0.215860794,0.0766910222,0.0,0.0,0.0,0.0,0.148112074,0.19667056,0.108273776,0.0,0.0,0.0,0.0,0.103190201,0.183901538,0.135913648,0.0,0.0,0.0,0.0,0.0646060442,0.17944521600000002,0.170934378,0.0402302686,0.0,0.0,0.0,0.028118358399999998,0.24659793,0.383592737,0.378630122,0.255987735,0.10160454099999999,0.00314515765,0.0,0.0433186458,0.0804325879,0.0576375161,0.0,0.0,0.0,0.0,0.0578473617,0.12256363599999999,0.10241289,0.00728047733,0.0,0.0,0.0,0.03695822,0.135259343,0.146767056,0.065299545,0.0,0.0,0.0,0.00209744185,0.0827745979,0.103604596,0.100017925,0.19498389300000002,0.5243266839999999,1.12438558,1.85780444,2.4424537,2.59029044,2.18973843,1.42342394,0.7343624740000001,0.632613347,1.42874144,3.03430268,4.94701895,6.44646642,6.91343413,6.11561421,4.3150656,2.14370957,0.31268382,0.0,0.0,0.0,0.351181069,0.768470593,0.815227294,0.605759652,0.376020666,0.310695025,0.432540076,0.610534259,0.6670191089999999,0.5068026179999999,0.184736807,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
1.04586117,1.85501892,2.82317074,2.79211715,1.81771881,0.0,0.0,0.0,0.564322885,0.531723036,0.0,0.148357983,0.147832299,0.962057822,0.6306099310000001,0.0323030485,0.28106415,0.0,0.0,0.39324802600000003,0.33400377,0.0,0.193533664,0.274843136,0.510957611,0.0,0.0,0.0,0.0,0.0,0.308517347,0.0,0.0,0.0,0.0,0.0,0.0,0.460564419,0.0,0.0,0.316291442,0.00713487605,0.0,0.0,0.0,0.18831088399999998,0.233393197,0.224038365,1.02700933,2.85583449,4.98774911,5.03320977,3.14542021,2.13545903,2.15649357,1.86631395,0.806536447,0.223859673,0.813909078,0.76252074,0.49271187299999997,0.423574214,0.0,0.285953978,0.606893053,0.0,0.0980372036,0.37398992299999995,0.682810265,0.0150012198,0.0696142639,0.274584625,0.0,0.44244735399999996,1.00729296,0.909954734,0.8957022029999999,0.272677603,0.277424185,0.324686955,0.0,0.0938168582,0.0,0.215749277,0.0,0.394602685,0.0,0.0,0.105062726,0.0,0.0,0.264140111,0.30052079800000003,0.423988236,0.0,0.0,0.63985053,1.33019508,1.16512703,0.7290312640000001,0.161306424,0.6088596,1.84820471,1.19680372,0.288388333,0.056806304,0.0,0.288348215,0.286835622,0.0,0.30505573199999997,0.0,0.298590805,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.25217344,0.0,2.2884298,0.0,1.13013829,0.0,1.62928251,0.0,0.0,0.0,1.94278326,0.0,2.41296216,0.77967859,1.37010735,0.0,1.8143196,1.44503537,2.00503622,2.51648327,0.0,2.27828555,0.85514409,0.13258223,0.20928374,0.0,0.0,1.13835741,1.43090107,0.20933872,0.0,0.0,0.56687087,0.39506055,0.0,1.30404617,0.11556757,0.52749108,1.06600028,0.0,0.8752046,1.43672572,0.0,0.21990292,0.0,0.0,0.24497446,0.36613623,0.0,0.22310227,0.0,1.21125631,0.45406221,0.0,0.0,0.0,0.0,0.0,0.0,0.20925947,0.0,0.0,0.0,0.0,0.0,0.07348345,0.4018627,0.20591085,0.0,0.0,0.33681063,1.37191932,0.44190599,0.0,0.0,0.0,0.0,1.0522524,0.0,0.0,0.0,0.24067036,0.29753545,0.0,1.11118709,0.0,0.0,0.0,1.43178088,0.0,0.0,0.0,0.0,0.0,0.77715418,0.0,0.0,2.57634176,0.80421569,0.0,0.0,0.44388983,2.79594719,0.03122992,1.91713444,0.0,0.35737702,0.0,0.0,0.0,0.65594959,0.24750303,0.90539216,0.25734889,0.36273765,1.21371047,1.07753877,0.0,1.1011901000000002,0.0,0.0,0.0,0.0,0.0,0.87485093,0.15811099,2.52796189,1.91587341,2.73202146,4.38073662,4.12854904,5.20943677,5.07694117,5.06624746,3.19014039,2.43138592,0.0,1.05849522,0.0,0.0,0.0,0.0,0.0,0.48562246,0.09403613,0.0,0.68168957,0.64882425,2.4030036,0.0,0.44339483,0.52798612,0.0,0.0,0.81832587,0.0,0.0,0.64508621,1.04552257,0.0,0.3225726,1.14036328,0.0,0.74907393,1.10605319,0.0,0.0,0.0,0.3324289,0.0,0.0779612,0.0,0.91412649,0.0,0.0,0.0,0.0,0.58985218,0.0,0.0,0.8553296999999999,0.0,0.0,0.0,0.94965158,1.8312716,0.0,0.0,2.13996566,0.32687668,1.5545539,0.74544586,0.0,0.18191559999999998,0.0,0.05306309,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.11219866,0.0,0.0,0.20910445,1.64078656,3.18493619,4.05378505,3.76590311,2.45683484,0.79746304,0.0,0.0,0.0,0.22296006,0.53958983,0.39002748,0.0,0.0,0.0,0.0239547,0.26627022,0.25829944,0.021920500000000002,0.0,0.0,0.0,0.18803735,0.26615972,0.10188894,0.0,0.0,0.0,0.13084794,0.30336808,0.20250874,0.0,0.0,0.0,0.09405705,0.46698793,0.50419772,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.139455461,2.49489897,5.14794112,7.22270421,8.01038382,7.27568729,5.35090284,2.97477388,0.958627659,0.0,0.0,0.21760366399999997,0.828749429,1.09990511,0.877412172,0.320807035,0.0,0.0,0.0,0.0,0.35604327700000005,0.5109625320000001,0.380809516,0.0733976109,0.0,0.0,0.0,0.06634594440000001,0.287492113,0.35491990700000003,0.253004261,0.0702688737,0.0,0.0,0.0513163164,0.207498207,0.291316544,0.243849786,0.08981360619999999,0.0,0.0,0.0,0.0,0.105885689,0.162241386,0.115129588,0.0,0.0,0.0,0.0,0.0183100512,0.106480991,0.12370591199999999,0.0636470322,0.0,0.0,0.0,0.0,0.0418358641,0.09594346179999999,0.08765782539999999,0.0258240023,0.0,0.0,0.0,0.0,0.0516332007,0.07905723099999999,0.0560767046,0.0,0.0,0.0,0.0,0.00885290309,0.0513293442,0.059422008899999997,0.0304484561,0.0,0.0,0.0,0.0,0.019459424399999998,0.0443132657,0.0401852056,0.011746126,0.0,0.0,0.0,0.0,0.0225120209,0.034182471400000004,0.024054450800000002,0.0,0.0,0.0,0.0,0.0036963071200000006,0.021368861800000003,0.0246291899,0.0124830893,0.0,0.0,0.0,0.0130553042,0.045870325,0.0707093426,0.0722301228,0.0442539337,0.0,0.0,0.0,0.0,0.112578206,0.310957827,0.546210865,0.7706749140000001,0.939942506,1.0314663,1.0549576,1.04855899,1.0615665,1.13171696,1.26847259,1.45083319,1.64015693,1.79983595,1.90983361,1.96780079,1.97777381,1.93643297,1.82932206,1.64288908,1.38622934,1.10678474,0.884274025,0.798577475,0.884454086,1.09835151,1.321157,1.40401474,1.24023924,0.828456849,0.291859524,0.0,0.0,0.0,0.522761766,1.33503211,2.11005666,2.63050449,2.77472185,2.54318567,2.03515092,1.39735298,0.7748489959999999,0.283491024,0.0034631688899999995,0.0,0.20729455600000002,0.625199683,1.09813068,1.44593293,1.50403742,1.20164536,0.6147982120000001,0.0,0.0,0.0,0.0,0.168452729,0.570146232,0.643400066,0.33632592899999997,0.0,0.0,0.0,0.0,0.458583607,0.9142863729999999,0.843946325,0.175391845,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46299999999999997
0.03707065,0.0159921758,0.0297494269,0.073305672,0.11836314199999999,0.13534522599999999,0.114402829,0.0706635691,0.0312805417,0.0148153355,0.0183764954,0.0218126365,0.005670413670000001,0.0,0.0,0.0,0.0,0.059556261900000004,0.12115425099999999,0.119015306,0.0375386998,0.0,0.0,0.0,0.0,0.119105449,0.266939616,0.275395204,0.111626931,0.0,0.0,0.0,0.0,0.20540402800000002,0.556925469,0.638120573,0.32615696899999996,0.0,0.0,0.0,0.0,0.559429736,2.37560159,4.22949827,5.52508072,5.81637614,4.98903115,3.30986958,1.32249715,0.0,0.0,0.0,0.0,0.227510672,1.06767229,1.51776472,1.51082784,1.16948522,0.70811112,0.319331915,0.09918032710000001,0.036473333,0.055783173600000006,0.0790837313,0.0693255165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
0.147590273,0.0,0.0,0.530648559,0.18465291399999997,0.47646844899999996,1.41868981,2.25272441,2.59825048,3.80607993,3.58302935,3.21580878,2.06357657,1.26563116,0.75946212,1.20398777,1.64812687,1.19024491,1.13015341,0.47119428700000004,0.0754362573,0.0,0.0,0.295601166,0.0126981235,0.13412518699999998,0.21283647600000002,0.174963483,0.0,0.0161629573,0.0,0.0518164496,0.059829723200000004,0.0,0.33694002799999995,0.0408391927,0.123226598,0.0218613964,0.216984835,0.361353049,0.0,0.480122531,0.0658227647,0.0602224433,0.514930595,0.857845932,0.731587856,0.270684052,0.33964247200000003,0.0,0.0,0.0,0.430720665,0.09802543539999999,0.327263013,0.0,0.0,0.0,0.37405020299999997,0.939443777,0.501335485,0.565010621,0.0420759928,0.146835831,0.155485133,0.0,0.198158472,0.161865501,0.0,0.0,0.0,0.028850179,0.030301754700000003,0.0,0.372315978,0.197571583,0.00922686069,0.0,0.0,0.0,0.302729442,0.260252023,0.280848528,0.352884225,0.0,0.0,0.303558076,0.309101647,0.0,0.23158004,0.0,0.0,0.0,0.296935034,0.00239149654,0.048763052800000005,0.23632551699999998,0.0,0.322427057,0.471248858,0.35389661200000005,0.289886878,0.11938800699999999,0.0175695489,0.154845502,0.12410529699999999,0.0,0.0,0.0,0.0,0.0,0.326131231,0.0,0.257119583,0.0,0.33972778600000003,0.366766498,0.385854216,0.056712348899999994,0.0,0.0,0.0,0.0,0.160360865,0.215957905,0.0,0.0389638426,0.0652275685,0.39689868799999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.43737345,0.0,0.127613315,0.0,0.508414708,0.0,0.5666671520000001,0.451211431,0.0651148524,0.0,0.245137799,0.0163209049,0.0,0.0,0.10677202300000001,0.499911992,0.22803307399999997,0.537296486,0.5497446220000001,0.29249488,0.29989318,0.601108702,0.358786868,0.506092404,0.0,0.0,0.0872807461,0.0,0.0,0.0,0.0,0.295173154,0.154266038,0.0,0.0,0.0,0.0,0.0,0.0,0.452351459,0.057747361399999995,0.319768267,0.0,0.387262169,0.0,0.373658881,0.0,0.11203660800000001,0.0,0.0,0.119324771,0.343318138,0.0,0.308911195,0.611837862,0.150828401,0.450316001,0.0,0.29094333699999997,0.310994506,0.25145323399999997,0.242719099,0.149213965,0.138594627,0.0,0.393300115,0.0,0.11812905800000001,0.0752902239,0.0,0.0,0.0,0.0,0.0,0.461651694,0.46895580299999995,0.05416073440000001,0.0,0.0,0.0,0.0,0.0,0.298427003,0.0,0.426747589,0.14737568199999998,0.217302105,0.0,0.0,0.271950473,0.054688577,0.0,0.0760082351,0.529321371,0.450027027,0.597801782,0.533836403,0.0437160077,0.0,0.0,0.0,0.0,0.273363923,0.0,0.6636363479999999,1.32757023,1.35047971,1.72600629,1.3528944,1.59289184,1.38516056,0.9090557159999999,0.558862057,1.32195474,0.9656997979999999,1.04020366,1.60968798,1.9613658999999999,2.12792817,1.74780899,1.98557834,1.19873025,0.7356718170000001,1.19305614,0.493304741,1.40117503,1.7930894,2.75361915,2.95596455,4.34020507,4.31262196,4.97885059,4.76992942,4.06687045,3.57986176,2.60925055,1.47470205,0.041535663,0.0788651482,0.0,0.0,0.601467576,0.777308375,0.97978567,0.486553024,0.212998668,0.816651183,0.287677258,0.31995779399999996,0.47619535799999996,0.708621322,0.39429892299999997,1.62487688,2.35336355,3.01366063,2.89393369,3.54926682,3.57450371,2.70202225,2.76013127,1.70936798,1.04520622,0.8604679559999999,0.0,0.0,0.0,0.0,0.0,0.466492975,0.164133682,0.50520343,1.20627105,0.51030949,0.737312065,0.9270219740000001,0.807816753,0.867626109,0.778026297,0.283999343,0.531178424,0.136329127,0.15382898,0.570900231,0.502185054,0.0,0.726927337,0.676212908,0.0632206535,0.716721012,0.0950000356,0.9227241290000001,0.148044319,0.0,0.139466073,0.508491031,0.0,0.0,0.0,0.258276889,0.238147882,0.0,0.0207526811,0.5361689510000001,0.0,0.0,0.27980892399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.0849264799,0.00470469761,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0217440687,0.113701869,0.208322786,0.299973907,0.38324263799999997,0.45328704799999997,0.506145489,0.538985202,0.550273873,0.539863323,0.508980488,0.460127055,0.39689522200000005,0.323712605,0.24553399899999998,0.167501131,0.0945935876,0.0312945574,0.0,0.0,0.0,0.0,0.0,0.0,0.0232479925,0.0727162578,0.124574537,0.174194883,0.21715712899999998,0.24957157600000002,0.268364267,0.271504908,0.25816133199999997,0.228769403,0.18501297,0.129714633,0.0666442192,0.000257552244,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0644548497,0.147503737,0.22754011600000001,0.29880344,0.35593662200000004,0.394365979,0.410638575,0.40269341399999997,0.370046926,0.313878477,0.237007947,0.143764422,0.039752131600000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0534765558,0.212424213,0.376307426,0.53667236,0.685170652,0.81407727,0.916777242,0.98818952,1.02509974,1.02637889,0.9930718209999999,0.928347528,0.837311861,0.726692145,0.604411566,0.47907866299999996,0.359423175,0.253713667,0.169194255,0.111577428,0.0846272148,0.08986201960000001,0.126399552,0.190957806,0.27801651,0.380133431,0.488399979,0.593011391,0.6839188270000001,0.751524732,0.787378912,0.784831521,0.739600486,0.650214851,0.518301965,0.34869491399999997,0.149346789,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.221949835,0.7139936659999999,1.26909153,1.86985069,2.4959127999999997,3.12483791,3.73311754,4.29726545,4.79492989,5.20596916,5.5134337,5.7044024,5.77062808,5.70895747,5.52150223,5.21555154,4.80322992,4.30091808,3.72846684,3.10824551,2.46407449,1.82009805,1.19965613,0.62421332,0.112400061,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11198201099999999,0.330200275,0.513452927,0.651898729,0.739065413,0.7720453159999999,0.751482097,0.6813560890000001,0.568587097,0.42248344299999996,0.25407406899999996,0.0753662636,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0216948837,0.19195064399999998,0.356531073,0.506376694,0.633627527,0.7320639409999999,0.7974312179999999,0.8276311909999999,0.822772968,0.785083834,0.718690053,0.629285242,0.5237105639999999,0.409475916,0.29425425899999996,0.185382126,0.08939809189999999,0.0116477982,0.0,0.0,0.0,0.0,0.0,0.0236961077,0.0872783033,0.155792809,0.223210935,0.283757368,0.332309547,0.36474427600000003,0.37820947200000005,0.371304287,0.34415714,0.298398149,0.23702945399999997,0.164203652,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.34302990000000005,0.9005204440000001,10.838743899999999,0.9523000209999999,0.0,0.283645178,0.0,0.0879475359,0.0,0.0,0.273133555,0.0,3.16260633,1.99630289,0.0,0.45592808799999995,0.0,0.263600326,0.0,0.160304508,0.0,0.0815001375,0.0,0.00501990893,0.038146232,0.0,0.158602314,0.0,0.594909482,1.34533263,0.435787795,0.0,1.75747448,7.87705926,0.0,0.522317206,0.0,0.77018992,0.0,0.11108355800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.19922443399999998,0.8742344870000001,1.08980881,0.737774119,0.0233089773,0.0,0.0,0.0,0.0,0.635549675,0.9835203920000001,0.823007715,0.260037812,0.0,0.0,0.0,0.0,0.535336557,0.8643938590000001,0.697719141,0.108006188,0.0,0.0,0.0,0.0,0.641007207,1.10731485,0.9482291709999999,0.201851623,0.0,0.0,0.0,0.0,0.929687629,1.77603825,1.66314329,0.46492813299999997,0.0,0.0,0.0,0.0,2.72487377,7.241459599999999,11.1823052,13.230738,12.6939406,9.78085357,5.50711179,1.27347182,0.0,0.0,0.0,0.0,0.850594211,1.58268271,1.34583907,0.443714991,0.0,0.0,0.0,0.0,0.385254695,0.819080445,0.7570045809999999,0.28828745899999997,0.0,0.0,0.0,0.0,0.225197832,0.534961937,0.5228892470000001,0.221746626,0.0,0.0,0.0,0.0,0.14473328,0.385645623,0.39511198399999997,0.183105315,0.0,0.0,0.0,0.0,0.0957753097,0.289903946,0.309630334,0.154601231,0.0,0.0,0.0,0.0,0.0616480527,0.21590339100000003,0.238487275,0.126250881,0.0,0.0,0.0,0.0,0.0345141548,0.141853488,0.157368331,0.0845678557,0.0,0.0,0.0,0.0,0.00854331197,0.0289795031,0.00830483105,0.0,0.00782410542,0.09474999769999999,0.203893415,0.254061377,0.18414759,0.0208328651,0.0,0.063048576,0.6744964520000001,1.7743061000000002,3.16709991,4.46025521,5.20205022,5.07425029,4.04967627,2.43253634,0.7504805840000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.513
0.317615699,0.0,0.0,0.0,0.0,0.0,0.0,0.221529897,0.564705253,0.051028384100000004,1.1054961,0.756524137,0.6920664000000001,0.41465130299999997,1.13361386,0.42820655399999996,0.274294877,0.0998496199,0.0,0.0,0.193485773,0.0,0.0,0.0,0.0681697424,0.647268822,0.740371643,0.657289735,0.00105524269,0.24587526199999998,0.635693693,0.126524847,0.22284171,0.146306089,0.178987268,0.0,0.010655976599999999,0.16197889099999999,0.0,0.14321139300000002,0.44058849,0.0263901845,0.427597522,0.551393374,0.590497084,0.317209371,0.285753495,0.0,0.0,0.0,0.0237664941,0.0316965294,0.0,0.189706934,0.294160198,0.0,0.0186044842,0.477504527,0.519541715,0.6010425429999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.191761878,1.10526272,1.89205273,1.91873275,3.07983304,3.4959492999999995,3.8636356,4.49471126,4.36894044,4.34285048,3.82584739,3.60424625,2.75010802,2.49876554,1.01176339,0.40298297299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.0682203437,0.0487968779,0.0311178948,0.0194403681,0.0178193468,0.029576798300000002,0.0568235175,0.10009679699999999,0.15816466199999998,0.2280286,0.305133168,0.38376557200000005,0.457604581,0.52035899,0.566423856,0.591479416,0.5929634579999999,0.570362241,0.5252859670000001,0.461319721,0.38366659299999994,0.298623113,0.21294554899999998,0.133176745,0.0650060794,0.0127296435,0.0,0.0,0.0,0.0,0.0103923591,0.0416169952,0.0715687582,0.0948971457,0.10716087,0.10532259,0.0881247692,0.0563206664,0.012746724,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0712026333,0.24613700100000002,0.473787722,0.751884995,1.07478412,1.43349358,1.81594449,2.20750997,2.59176303,2.95143904,3.26954644,3.53054805,3.72151997,3.83318714,3.86073577,3.80431557,3.66916706,3.46534111,3.20701517,2.91145084,2.59767503,2.28499783,1.99150107,1.73263818,1.52007826,1.36090481,1.25724459,1.20635834,1.20117743,1.23122407,1.28381346,1.34540783,1.40297913,1.44523966,1.46361862,1.45289437,1.41143346,1.34103357,1.24641168,1.13441718,1.01307676,0.890591459,0.774404449,0.670442666,0.582607785,0.512556859,0.45977482,0.42190479,0.395272526,0.375521554,0.358267919,0.339688063,0.31696903600000004,0.288574233,0.2543064,0.215178702,0.173130124,0.130640131,0.0903071522,0.0544552762,0.0248242096,0.0023808781399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00169513521,0.0102616451,0.020720043400000002,0.0340735464,0.0513126734,0.0731762096,0.09994823539999999,0.1313241,0.166366666,0.203559682,0.240950124,0.27635800899999996,0.30762263300000003,0.332849611,0.350624046,0.360161282,0.36137679899999997,0.354869173,0.341822731,0.323847469,0.30278158,0.280485347,0.258654057,0.23867232300000002,0.22152398,0.20776193,0.197532765,0.190643189,0.186650421,0.18495749600000003,0.184896721,0.18578973,0.186979614,0.187837905,0.187755392,0.186129645,0.182362804,0.17588072300000002,0.166179137,0.152895397,0.13589668400000002,0.115369175,0.0918886639,0.06645272740000001,0.040458037,0.015613641499999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0209441461,0.044859441900000005,0.0673969002,0.0857782291,0.0976958782,0.101664948,0.0972963024,0.0854473396,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.620629871,0.718847565,0.814025118,0.901242137,0.976190875,1.03551929,1.07712897,1.10040784,1.10638081,1.09776569,1.07892687,1.05572476,1.03526511,1.02555813,1.03510267,1.07241582,1.14553161,1.26149544,1.42588189,1.64236306,1.91235302,2.23475049,2.60579744,3.01906558,3.46557639,3.93405351,4.41129934,4.88268109,5.33270555,5.74565668,6.10626663,6.40038812,6.61563578,6.74196473,6.7721575,6.70219426,6.53148721,6.26296582,5.90300744,5.46121497,4.95005077,4.3843434,3.78068952,3.15677901,2.53067466,1.92008016,1.34163076,0.810239257,0.338527656,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0920777373,0.250477903,0.381864087,0.480211069,0.5418344079999999,0.565434205,0.5520138379999999,0.50468246,0.42835591799999995,0.32937568300000003,0.21506915,0.0932771093,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0847317453,0.166451704,0.234878345,0.286150384,0.317589872,0.32782958,0.316857809,0.285980141,0.237702585,0.17554510899999998,0.10379844099999999,0.0272401228,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0238413487,0.08898386609999999,0.147389243,0.195442749,0.23023749100000002,0.249746133,0.252935601,0.23981847,0.21143865,0.16979306800000002,0.11769493,0.058587670999999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.045472535099999996,0.101888077,0.151537864,0.19125585899999997,0.218517662,0.23159870600000002,0.22968183,0.212907624,0.182364467,0.140018961,0.0885911212,0.031382137000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.010774144099999999,0.0710194807,0.127073419,0.17527394699999999,0.212433738,0.236049187,0.244468855,0.237010468,0.21401875399999998,0.176859934,0.127852582,0.0701384551,0.0075006271400000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000490457175,0.09160325779999999,0.18874333199999999,0.2872033,0.382170825,0.469017202,0.543578129,0.602409415,0.6430017020000001,0.663940567,0.665001509,0.6471731789999999,0.612606481,0.564491682,0.506870119,0.44439118299999997,0.382028805,0.324774393,0.277324936,0.24378560300000002,0.22740570899999998,0.23036520800000002,0.253626192,0.296860182,0.358457619,0.435621108,0.5245388670000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.0534462366,0.0,0.0,0.0,0.0073160635,0.070776881,0.0,0.0,0.031389051200000004,0.13318075,0.0,0.0,0.0827153579,0.22788425399999998,0.0,0.0,0.21517325899999998,0.447357548,0.0,0.0,2.2902332000000003,6.18115971,6.9798976999999995,3.76789766,0.373409826,0.0,0.635617918,0.363671566,0.0,0.342310795,1.28997591,0.689525809,0.0,0.11972020800000001,2.15241346,3.00163458,2.03892311,1.28921931,1.85568602,2.42450841,1.81457538,0.7086155009999999,0.130624147,0.0066582363,0.0,0.0,0.117482429,0.0031999805699999997,0.0,0.250867171,1.01048623,1.21318066,0.621327584,0.0101027097,0.0,0.0095223333,0.0,0.011136741799999999,0.0664610881,0.0,0.0,0.334881537,1.04396671,1.20045205,0.596982028,0.0,0.0,0.0652018428,0.06669529610000001,0.0,0.0,0.0255086266,0.017400568999999998,0.0,0.0,0.0,0.0,0.0232087833,0.022429339399999998,0.0,0.0,0.0947516693,0.0631870676,0.0,0.0,0.723773287,1.77769836,1.9965651999999998,1.31784237,0.665370577,0.533533358,0.444192638,0.0314775466,0.0,0.0,0.253594832,0.0,0.0,0.403776585,1.81135446,2.57728404,1.92100065,0.64187633,0.0,0.0370745002,0.138678962,0.0,0.0,0.09175969279999999,0.451590857,0.643083313,0.693278937,0.64242348,0.398056787,0.0547647749,0.0,0.0831664301,0.197070566,0.09164508519999999,0.0,0.0488996659,0.111729477,0.0321312184,0.0,0.07309261809999999,0.16608985199999998,0.10607707400000001,0.0113723962,0.00470569239,0.008964813470000001,0.0,0.0,0.042540767800000004,0.0168497227,0.0,0.0,0.0665958614,0.0130285601,0.0,0.249028621,0.674170598,0.7390089320000001,0.379797034,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.6913536029999999,1.38140652,0.0,0.37422573,0.182075115,0.953773702,0.453316736,0.912471107,1.07521124,4.38946523,1.05137327,0.42761833200000005,0.0,0.906340756,0.0,0.419054816,0.767923219,0.6513515329999999,0.31578732,0.45824210200000004,1.11545395,2.45072968,0.0653576291,0.0,0.0,0.0,1.31100177,7.64364463,0.575549415,0.429887559,0.0,0.22610454,0.0,4.05336845,2.80137702,0.0,0.95570506,0.0,0.37390769100000004,0.0,0.0,0.0,0.348943651,0.141354568,0.0,0.110625525,0.0,5.85578139,3.3767447999999995,0.0,0.0019681482300000002,0.7862794120000001,0.267489757,0.0,0.62404001,0.0,0.0201854418,4.48087172,3.95387821,1.13878193,0.781616415,0.0,0.8233088820000001,0.168516287,0.30956021899999997,0.056575850700000006,0.545021996,1.15200891,2.04741748,2.5552473,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
2.85264818,3.61760285,3.61774948,3.36494652,0.491534049,0.0936453064,0.0,0.0,0.0,0.0,0.0558500859,0.47627418899999996,1.67228808,0.149000391,1.00335734,1.24226801,1.11271704,1.44964854,0.8284807890000001,0.520193593,0.0,0.0,0.92782252,0.0,0.5864710479999999,0.453272623,0.0,0.430114729,0.0,0.0,0.0,0.0,0.42097538799999995,2.26954055,0.157666711,0.0,0.49939512,0.37489396799999997,0.0,0.0,0.0,0.0,0.0,0.0,0.834911368,0.987794664,1.37274673,1.0910749,0.593659049,0.313804089,0.150038292,0.0,0.8619017,0.7924911579999999,0.599470287,0.025465985400000002,0.0,0.0,1.03255668,0.0,0.0,0.626315402,1.59513303,0.0,0.021266734500000002,0.442844909,2.1451056,2.31222352,0.0,0.355653427,1.74333986,0.0,1.61155265,1.4314878,1.97029452,0.47535692799999996,0.0,0.0,0.0,0.563213495,0.0,0.726646985,1.27978662,0.829334102,1.43866152,1.86844791,4.47356328,2.46959514,2.98089966,3.60732242,2.65108626,1.36908352,1.13311424,0.36402331600000004,0.0,0.0,0.0,0.0,0.114514191,0.601843882,0.0,0.46157583399999996,0.0,0.0,0.0,0.0,0.222114487,0.0,0.0,0.0,0.702279289,0.558148868,0.618129816,0.088083751,0.546777582,0.0957481651,0.0,0.146440626,0.0,0.264100354,0.000766910821,0.0715916449,1.02505539,0.9338105440000001,0.0,0.0,0.17920738600000002,0.0,0.0,0.0,0.0,0.487900312,0.73542053,1.54537898,0.746495083,1.41114389,0.563936848,0.0,0.676251411,1.5538292999999999,0.18599731100000003,0.8001178940000001,0.805427404,0.50612054,1.57205861,0.0250442767,1.62193239,1.00727219,0.0,0.0,0.595541422,0.741803937,1.91231488,1.93835452,1.56797531,0.5344837370000001,0.357069115,0.31801552,0.0,0.0,0.0,0.0,0.593251995,0.384788035,0.474767719,1.22280096,0.0,0.70279559,0.0,0.0,0.423293643,0.0,1.04249284,0.0,0.0,0.0,0.0,0.334828972,0.0,0.0,0.763409401,0.0761564105,1.01470786,0.0,0.0,1.05031172,1.41144337,1.37099375,2.22064625,3.15953271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.369495206,0.147579317,0.369653745,1.35543306,1.07981097,1.76257069,2.6949438,2.04489695,2.20326107,0.48543037899999997,0.0,0.0,0.604969671,0.30347867,0.0,0.0,1.57032692,2.41122649,2.67361614,3.48661451,1.11010128,0.0,0.0,0.420394582,0.0,0.43967552600000004,0.0690272173,0.34186450399999996,0.601661572,0.611706788,0.947165048,0.0,0.0,0.0130847747,0.459848169,0.7860285770000001,0.0,0.23075518399999997,0.42876692899999996,0.0,0.00532279212,0.0,0.0,0.462731935,0.371338847,0.9473771940000001,0.0,0.497342912,0.0,0.0,0.0,0.300076467,0.399593511,0.0,0.0,0.09037791070000001,0.8667289109999999,0.08760625539999999,0.6092662560000001,1.25657359,0.0,0.729269033,0.7756163229999999,0.39214041,0.0,0.0,0.479067144,1.15061598,0.251180426,0.50141013,0.0,0.0,0.937415605,0.0,0.296290422,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
2.37888621,1.99211528,1.69641543,1.42236185,0.96348941,0.0,0.0,0.49606087,0.0,0.63109136,0.0,0.17081777,0.65330267,0.0,0.0,0.9348261,0.0,0.2734474,0.0,0.0,1.13492972,0.0,0.0,0.0,0.0,0.0,0.77735323,0.0,1.17454777,0.0,0.78303135,0.0,0.15351625,0.87918808,0.0,0.01773925,1.70094229,1.13033779,1.37235214,0.58418023,1.01762775,1.50503154,1.54365164,1.93175458,2.43734137,0.0,0.39550802,0.0,0.0,0.80844145,1.59713476,2.85544856,2.46471485,4.37790196,3.24320786,3.39530181,3.49133917,1.75043836,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.41006853,0.1291071,0.0,0.13172432,0.0,0.72309908,0.0,1.36282832,0.0,1.44636973,0.8939288000000001,1.8469723999999998,1.17525608,7.37960242,1.75944018,0.77994218,0.0,5.56081526,6.70596269,7.80665608,4.50303374,4.04988787,1.51101175,0.13074373,0.0,0.14494326,0.0,0.18551868,0.0,0.20979133,0.0,0.22741086,0.0,0.55428457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45799999999999996
0.373425325,0.0066046528,0.47992526700000004,0.0,0.0,0.0,0.0,0.633162091,0.762197322,1.699929,3.23322563,1.2951646,1.1134452,0.0097521968,0.0,0.0,0.0,0.656571748,0.0,0.399334105,0.0331456637,0.8155018540000001,0.830766982,0.0,0.405536926,0.0,0.0,0.0,0.0812324289,0.167458863,0.0,0.0,0.21710305,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.187633876,1.49274947,0.841741959,0.0,0.0,0.8319793879999999,0.540382367,0.100842813,0.457237733,0.0341242148,0.5047665920000001,1.53945184,0.37925064399999997,0.385541715,0.057895399900000005,1.60404223,0.562500315,1.50749234,0.0,0.101615182,0.0,0.0,0.0,0.7430754759999999,0.0,0.0,0.0,0.0,0.532785706,0.675568463,0.0,0.7256293970000001,0.0409723901,0.0,0.0,1.25624298,0.0,0.0,0.623233694,0.0,0.0,0.0,0.0,0.706891391,0.0,0.0,1.20959627,0.7417426770000001,0.0,0.565900021,1.62771376,0.594350927,0.0,0.0,0.0,0.0,0.138008978,0.0,0.0,0.950293425,0.0,0.0,0.0,0.102837405,0.0,0.0,0.0,0.0,1.88013665,3.1008382,3.6430176,4.69315417,5.55506667,3.74599228,2.54301469,1.10889762,0.17823671800000002,1.16458318,0.0,0.8163445709999999,0.0,1.15581571,1.6468393,1.91600016,2.08283463,0.50607602,1.63533141,0.0,0.0,0.0,0.0,1.32187879,1.35441587,0.9981411990000001,2.54498459,1.55376766,2.58829461,1.77946989,0.0,0.359784439,0.517748141,0.0,0.0,0.0,0.0,0.0411393685,1.36015459,0.0,0.683242149,0.0,1.00304655,0.0,0.0,0.374788223,0.317329457,0.391280943,0.0,0.0,0.0,0.0,0.0035217607899999995,0.22778616899999998,0.0989585505,2.11283573,2.4432139,1.67510737,3.01811591,1.78275676,2.25860859,0.41437932,0.0,0.327058592,0.0,0.0,0.0,0.667417357,0.8904582740000001,0.0,0.424872855,0.0,0.419635053,0.0,0.0,0.495644944,0.0,1.02301189,0.587252299,1.37563338,0.0,2.01822773,1.02189282,1.8478933000000002,0.0,0.5981391429999999,0.0,0.0,1.41231112,0.0,0.0,0.0,0.845787403,0.204522134,0.379098204,0.0,0.22925145,0.0,0.0,0.0,1.0584209,0.747101584,0.0,0.8062583329999999,0.10482003,0.0,1.19781602,0.0852946035,0.0,0.0,0.0,0.0,0.0,0.332685805,0.575343865,0.51000776,0.0,0.0347696096,0.0,0.0,0.0,0.0,1.59022949,0.0,0.0,0.343733041,0.489988538,0.551559998,0.0,0.200468725,0.246833705,0.722336854,0.0,0.0,0.0,0.0,0.0,0.0,1.62969267,0.306857618,0.0,0.0,0.0,1.49515414,0.49937996,0.0,0.0,0.31240620199999997,1.29363839,0.8734903390000001,0.0,0.598473391,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
11.45142614,9.78606727,6.14259568,2.05629301,0.0,0.0,0.0,1.00435271,2.44349004,2.72601808,1.85761363,0.48783662,0.0,0.0,0.0,0.32840632,0.71378394,0.56718357,0.07329053,0.0,0.0,0.04708051,0.60508706,0.91852618,0.76728709,0.24172639,0.0,0.0,0.0,0.0,0.38822396,0.48849422,0.25004986,0.0,0.0,0.0,0.17338847,0.70578603,1.09817115,1.2193441999999999,1.1134781999999999,0.93611845,0.82516934,0.80578721,0.79568351,0.69878521,0.50876968,0.33752501,0.34088763,0.59290818,1.00273758,1.34296182,1.38125482,1.03214962,0.42591412,0.0,0.0,0.0,0.0,0.31700926,0.41515138,0.22434438,0.0,0.0,0.0,0.0,0.21225409,0.36959809,0.26772484,0.0,0.0,0.0,0.0,0.16864318,0.51175734,0.68625453,0.66454521,0.54051469,0.44444176,0.44223193,0.49257414,0.48989986,0.35688967,0.11444077,0.0,0.0,0.0,0.0,0.12185213,0.13340546,0.04817399,0.0,0.12379247,0.45472563,0.85879562,1.10508171,1.00905561,0.56525287,0.0,0.0,0.0,0.0,0.18132811,0.46933877,0.42339784,0.08694038,0.0,0.0,0.0,0.06657423,0.40132541,0.45521382,0.18801109,0.0,0.0,0.0,0.0,0.35789775,0.51219392,0.30537454,0.0,0.0,0.0,0.0,0.31012479,0.58953693,0.45820792,0.0,0.0,0.0,0.0,0.24427442,0.71075466,0.69861748,0.16830292,0.0,0.0,0.0,0.13998511,1.12674587,1.67756664,1.47331175,0.67374322,0.0,0.0,0.0,0.70551404,1.19196726,0.82822698,0.0,0.0,0.0,0.0,3.08039238,7.17555787,10.42695634,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.457
0.393065571,0.0,0.0,0.0,0.20511454,0.0,0.0160676664,0.0,0.0,0.0,0.821076598,0.0,0.7958887840000001,0.0,0.0,0.28932601199999997,0.0,1.20214928,0.0,0.0,0.0,1.15486999,0.110775976,0.694013075,0.0,0.544215102,0.23094784699999998,0.30253887399999996,1.14983424,0.132101129,0.0,0.0,0.0927461384,0.0,1.31425901,0.0,0.342434646,0.058605930199999996,0.0,1.08025764,0.0,1.8958993999999998,3.20704534,0.80477691,0.602330395,1.39662468,1.00848455,1.58702282,2.64378263,2.42072921,5.62754741,3.73617096,4.4609312,4.096588,2.34040996,0.0903318229,0.757365217,0.0,0.0,0.0,0.433793672,0.7645901540000001,1.9962286,1.61869929,2.15024707,3.78370424,5.39972404,2.04644191,3.31607263,3.89212266,0.0,1.35865521,0.0,0.0,0.0,0.0,1.64490921,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.915027655,1.2188226999999998,0.0,0.0,0.976557883,0.0,0.0,0.0,0.0,0.9182074179999999,0.0,0.0,1.18787158,0.711824655,2.14490009,2.43100104,0.210422907,0.0,0.932806235,1.79972644,1.22389477,0.379270771,0.0,0.620505226,0.0,1.64343788,1.95097826,0.0,1.12841972,0.28392015800000003,0.0,0.0269663043,2.01741219,0.732514355,0.501548843,0.0,0.462698231,0.0,0.0,0.0,0.0,0.7540616859999999,0.0,0.394121655,0.0,0.0,0.381522776,0.0,0.63397649,0.0,0.0,0.0,0.325810704,0.13706505900000002,0.39478393799999995,0.0488156337,0.331558172,1.16463236,0.0,0.8250489240000001,0.303161394,0.0,0.0,1.06184534,0.0,0.0,0.0,2.5707505,0.0,0.0,0.0,0.0,0.021605280299999998,0.112848811,0.394678921,1.46178471,2.12412927,1.89432404,0.0,0.716699357,0.0,0.590788147,1.64260828,0.0,0.517757394,0.0,3.01079369,0.0,0.0,2.24217241,0.387334316,1.09427985,0.0,0.0,0.0,0.95003611,0.104856008,0.0,0.764606233,1.79906494,0.323455568,0.256898269,2.7687037999999995,0.304012817,1.04106845,0.0,3.01158958,0.56444475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.362900345,0.7048755,1.07770865,1.47481472,1.88878481,2.31156232,2.73463991,3.14927199,3.54669665,3.9183608999999997,4.25614276,4.55256372,4.80098568,4.99578641,5.13250863,5.20797838,5.22038906,5.16934897,5.05589082,4.88244303,4.65276366,4.37183909,4.04575025,3.68151047,3.28687975,2.87016076,2.43998254,2.00507822,1.57406296,1.15521853,0.756290556,0.38430391399999997,0.0454013837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.04248059269999999,0.18305233199999998,0.308062477,0.414271638,0.49925161700000004,0.561417584,0.6000327670000001,0.615186479,0.607747158,0.579292826,0.5320220370000001,0.468648901,0.392286201,0.306320847,0.214286029,0.119734421,0.026116556200000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00815968106,0.0629541641,0.112441039,0.155115071,0.189800551,0.215678399,0.232298762,0.23957926699999998,0.237789563,0.227523315,0.20965923,0.185313034,0.155782619,0.122488745,0.08691376140000001,0.0505408119,0.014795867800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013973356599999999,0.025374395299999998,0.0339207315,0.0394990407,0.0421619296,0.0421169308,0.039708330699999995,0.0353928429,0.0297104003,0.0232515366,0.0166229635,0.0104130112,0.00515858928,0.00131524173,0.0,0.0,0.00109358055,0.00505909314,0.0108207918,0.0180386458,0.0262551564,0.0349183323,0.043410054299999994,0.0510785387,0.0572734073,0.061381729100000004,0.062863331,0.0612836771,0.056342694699999994,0.0478980767,0.035981804,0.020808909599999998,0.00277782637,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.011360538600000001,0.0523413591,0.0940666944,0.134932227,0.17327129,0.20741855,0.23577678600000002,0.25688424,0.269479939,0.272564301,0.265452491,0.247818125,0.21972523,0.181646726,0.134468156,0.0794758915,0.0183295916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.06398961780000001,0.18054131399999998,0.300551701,0.42026631,0.5357592760000001,0.643060692,0.7382909809999999,0.81779803,0.8782925659999999,0.916977171,0.931664422,0.920879838,0.883945705,0.821042362,0.733244155,0.622528041,0.491753635,0.34461439899999996,0.18556059,0.019695517,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.057393951,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
2.08319927,1.53402148,2.79437598,0.0,0.0,0.0,0.0,0.0,0.0,2.02851439,0.0,2.30838827,0.737367181,0.6431142479999999,0.0,0.0,0.554071336,1.44887602,1.94677177,0.0,0.0,0.0,0.326679115,0.176392277,3.75365686,0.0,0.0,0.794976857,0.0,0.0,0.0,0.9696999159999999,0.24604643899999998,0.6853543670000001,0.0,2.21645906,0.334165046,0.0,0.0,0.0,1.94278052,0.0,0.843388061,0.0,0.0,1.03235622,0.33428363699999997,0.19452966600000002,0.0,0.759251984,0.366194532,0.0,0.0,0.0,0.0,0.0,0.0,2.22378759,0.8333036690000001,0.0,0.939163968,0.601126675,0.0,0.0,0.42906449,0.570255934,1.15510307,0.241976308,0.0,1.39612452,2.21685715,0.0,0.0,0.0,1.30612896,0.0,0.0,2.63747619,1.79486732,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.09878484,0.0,0.0,0.783611843,0.0,0.840766958,2.39765299,2.65671177,0.7829267809999999,0.0,0.0,0.0,0.0011718286199999999,0.0,0.0,0.548036837,0.0,0.0,0.7897787070000001,0.0,3.30895129,0.0,0.0,0.0,0.0,0.0,0.0,0.5347193570000001,0.0,0.0,0.0,0.9214340409999999,0.418699892,0.818274116,3.01508372,0.0,0.449470631,0.0,0.0,0.781417884,0.0,0.0,0.0352955339,0.634448913,0.0,0.038582699500000005,0.579920914,1.46211889,0.0,4.57226711,0.9649175409999999,0.0,0.0,0.0,3.98546673,0.0,0.0,0.0,0.0908365889,0.0,0.0,0.275627209,0.0,0.0766446119,0.941790515,0.0,0.0966864091,0.0,0.0,0.0,0.5754028870000001,0.876277545,0.25062754600000003,0.0,2.26255509,2.15723877,0.0,1.53948601,0.0,0.0,4.21858859,0.0,0.0695667492,2.92007003,2.5908624,0.0,0.0301437797,0.0,0.0,0.294071839,0.332104175,0.0,1.1839131999999999,0.811419883,0.0,0.0,0.17811444199999998,1.18387359,0.0,0.379117286,0.0,0.0,0.0,0.006064192929999999,0.10047695599999999,0.44134527,3.0351138,0.0,2.53819668,0.0,0.0,0.0,0.0,0.148485009,2.6762498,0.0,0.0,1.51452654,0.368999388,9.54810531,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.11006257,1.1703791000000001,0.42533398,0.0,0.0,0.24677825,0.0,0.84393876,0.11917405,0.0,0.40787339,2.45136983,5.34669203,6.96299751,7.37759785,4.92864247,3.34021942,0.0,0.0,0.66809804,0.46810195,0.0,0.09825779999999999,0.0,0.25120502,1.40149691,0.75543252,0.0,0.0,1.43310733,6.5930613,8.60212204,6.39959147,1.29390252,0.0,0.0,0.7615221,1.93360269,1.69267543,1.46338054,1.37810769,0.48091053,0.13318692,0.0,0.0,0.0,0.94275173,0.95477309,0.14037787,0.0,0.0,0.0,0.1659662,0.65953709,0.0,1.06907878,0.19162278,0.0,0.4700625,0.0,1.12148716,0.62709311,0.78621632,0.13956566,0.0,0.41478235,0.67095009,1.74487461,1.40492072,0.66598641,0.04134748,0.0,0.14602203,0.0,0.0,0.0,0.0,0.20188867,0.41746072,0.69456576,0.0,0.0,0.70505714,0.0,0.09536518,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45799999999999996
0.15360069099999998,0.43735045200000006,0.756713478,1.10400034,1.47011252,1.84485369,2.21729468,2.57617724,2.91033968,3.20914628,3.46290209,3.66323497,3.80342835,3.87869,3.88634498,3.82594425,3.69928421,3.51033617,3.26508898,2.97131172,2.63824693,2.27624786,1.89637557,1.50997351,1.12823775,0.7618013459999999,0.42035025200000004,0.112286655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10388107099999999,0.20399337899999997,0.284519201,0.343111044,0.37871054,0.391503169,0.38281587100000003,0.35496537200000006,0.311067143,0.25481650699999997,0.190254334,0.12153002199999999,0.0526740837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013329254799999999,0.03599573,0.0526626442,0.0629659249,0.0670423482,0.0654867243,0.0592798456,0.049692825999999996,0.0381748099,0.026231927999999998,0.0153057896,0.0066596986399999995,0.0012801806800000002,0.0,0.00245016094,0.00903692665,0.0189573244,0.0312403129,0.0446181813,0.057621202999999996,0.0686897635,0.0762966275,0.0790712401,0.075917682,0.0661181321,0.0494144316,0.0260615484,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.028893371600000002,0.104963246,0.183560515,0.26064610000000005,0.33194924800000003,0.393191329,0.440324548,0.46977349,0.478666696,0.465045521,0.42803813700000004,0.36798788600000004,0.28652712199999997,0.186590095,0.07236132299999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.7157510440000001,0.351527455,0.328578973,0.78723482,2.40835197,0.0,0.0,2.63875602,2.88967428,1.1685687,0.0,0.332167879,0.048683776,0.0,0.427523365,0.0,1.71922866,0.0,0.0,0.0647269055,1.39899255,0.0,1.57982232,1.41780287,1.60777608,0.0,0.0,0.0,0.0,0.691351887,0.26128310899999996,0.0,0.0,0.0,0.0,2.07838169,3.80513287,0.0,0.11156164800000001,0.0,1.61010486,0.0,0.0,2.13769976,0.0,0.245152438,0.052570989699999994,0.0,0.0,0.0,1.07194973,0.0,2.00076196,0.0,0.299881482,0.0,0.700839585,0.904463452,0.9251040909999999,0.640919795,0.0,0.0,1.50626272,0.0,2.66647181,0.0,4.78926827,1.96209882,0.0,2.62313901,1.55941526,0.0,0.0,0.0,0.0,0.920624144,0.0773287277,0.0,0.0,0.0,0.0,0.0,1.11042295,0.0,2.78936784,3.47166766,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.576184504,0.538966056,0.0,0.0,0.0243456559,0.783520236,0.0,0.0,0.0,0.21028788,0.794436968,1.08170647,0.0,0.0,0.0,0.0,0.6706167829999999,2.23317999,1.9113487,0.49862642799999995,0.0,0.126771774,3.00820452,4.87329699,7.45324237,6.18011644,3.68499979,1.21920888,0.0,0.0,0.0,0.715577107,1.06388193,0.627201104,0.0,0.0,0.0,0.6674310410000001,0.7780150309999999,0.0,0.0,0.0338301075,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.100080376,0.0,0.0,0.0,0.0,0.164760064,0.81417908,0.6096034260000001,0.0912388972,0.422686347,0.22003946300000002,0.0,0.940048132,0.0416295997,0.0,0.0,0.0,0.0,0.314091195,0.0,0.0714620505,0.0,0.0020304370499999998,0.586317925,0.7775143529999999,0.637823062,0.0,0.021513065,0.0,0.0,0.711229965,0.0,0.553572733,0.0,0.0,0.545373169,0.399847811,0.753938117,0.0,0.0,0.541185625,0.43821906,0.40816585899999996,0.709921281,0.198177871,0.08023841059999999,0.641378652,0.757082735,1.56031928,1.67031068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.821762069,0.0,0.30458198,0.182871113,0.0,0.0345171404,0.0,0.0,0.359867737,0.199727727,0.806422451,0.0,0.259872941,0.0,0.0,0.45597993200000003,0.5372662979999999,0.42160778200000004,0.528142007,1.00572369,0.556156839,1.02381932,0.800869895,0.8997789279999999,0.173868744,0.33535691100000004,1.27856352,1.26665797,0.466174391,0.766633562,2.34207396,1.35827569,1.44104389,1.96552912,0.915992107,1.56594484,0.896381751,1.17783365,1.05420346,1.18758139,1.70527697,1.43391965,1.84583282,1.7178466000000001,1.82017915,1.08312121,1.9230392,2.00203166,2.54645309,1.83966234,2.16211249,1.47259467,2.02751644,1.42686763,2.32604259,2.05163336,3.03699971,2.26064169,1.7966859,1.94894911,1.48207168,2.78851131,2.40320426,1.08853328,0.638640711,1.42956092,0.5867609970000001,1.68704215,0.477389034,1.06743413,1.60220817,2.25915072,0.0,0.33355849,0.285485555,0.8404880920000001,2.0153659,0.941520253,1.12177178,1.02609305,0.722357075,1.31512666,0.0,1.69051777,0.8482055070000001,0.20898586800000002,0.599988493,0.0,1.47676703,1.15307992,0.89153646,0.932812105,0.0,0.28793133600000004,0.39891132700000004,0.724227295,0.8488429909999999,0.7427125040000001,1.21837342,1.32571486,1.12235923,0.339354499,0.591958987,0.663179024,0.402930567,0.712573166,0.136745847,0.0,0.0,0.0,0.0,0.0,0.831739489,0.0,0.143336614,0.0,0.0,0.0,0.0,0.0430469388,0.0,0.012184900600000001,1.15602928,0.05944781389999999,0.411496295,0.404166838,0.20605434600000003,1.22731352,0.657157677,0.29033316600000003,0.569219977,0.492387908,0.309279917,1.10058547,0.0248193821,0.7665480029999999,0.24017553100000003,0.786904597,0.795238305,0.0,0.023031662999999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.57660881,1.47952699,1.14891127,0.0,0.25126445,0.71527781,0.0,0.07696818,0.30661813,0.0,0.14603183,0.24480528,0.53934406,0.0,0.0,0.63320522,0.73159354,0.0,0.0,0.0,0.86641042,0.72441422,0.0,0.81997915,0.0,0.0,0.5099064999999999,0.26847151,0.0,0.5648993,0.0,0.24799682,0.0,0.0,0.87077488,0.0,0.0,0.0,0.0,0.14483472,0.0,0.0,0.33731469,1.88357983,5.77003597,7.73568814,6.48645222,2.64812183,0.74233063,0.98584986,0.23307256,0.0,0.88295805,0.0,0.20652927,0.82292141,0.72343205,0.0,0.0,0.37359226,0.69510123,0.42070532,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.159663337,0.0359218759,0.0397291534,0.0281069851,0.0,0.0,0.0,0.0,0.10346357099999999,0.131860967,0.0553584503,0.0,0.055849134800000005,0.48026027,1.24518515,2.13751572,2.80111737,2.92062932,2.41447661,1.51539699,0.6731938940000001,0.319511227,0.6244230470000001,1.39013883,2.15266662,2.4394845000000003,2.03516702,1.09892115,0.0656507115,0.0,0.0,0.0,0.204256141,0.48818873799999996,0.392604381,0.0360662421,0.0,0.0,0.0,0.128572666,0.336974379,0.28856909399999997,0.0327640391,0.0,0.0,0.0,0.105894125,0.296707008,0.265318968,0.0357398237,0.0,0.0,0.0,0.10984600900000001,0.34717012399999997,0.37647239200000004,0.19533014699999998,0.0,0.0,0.163713434,0.6734501,1.23249895,1.59667237,1.62450695,1.34429497,0.914485587,0.51504771,0.248338825,0.111523414,0.044728822599999996,0.00448426208,0.000114194272,0.0675457228,0.209586288,0.360706415,0.41487014200000005,0.302097025,0.0549193628,0.0,0.0,0.0,0.076993185,0.280806889,0.280364706,0.0630587981,0.0,0.0,0.0,0.48596472799999996,1.09181182,1.4756061000000003,1.48508691,1.20509586,0.9088102379999999,0.883061772,1.24243083,1.85875029,2.45800654,2.82319028,2.96548618,3.14061969,3.68597486,4.77412969,6.24065995,7.60567494,8.29182104,7.91969839,6.51168551,4.48810429,2.46147899,0.949272459,0.163999319,0.0,0.0902185294,0.183637014,0.126609327,0.0,0.0,0.0,0.0,0.0931879682,0.151790885,0.0960919917,0.0,0.0,0.0,0.0,0.061277072,0.101948879,0.0657678297,0.0,0.0,0.0,0.0,0.040191556499999996,0.0683022744,0.0447944066,0.0,0.0,0.0,0.0,0.0260443821,0.0455545975,0.0308329132,0.0,0.0,0.0,0.0,0.0303360182,0.0838789929,0.131770212,0.16163612300000002,0.160022946,0.116851977,0.0367930623,0.0,0.0,0.0,0.0102103316,0.11816050300000001,0.157689893,0.0713121728,0.0,0.0,0.0,0.0332659952,0.6236802920000001,1.31115435,1.81769115,1.90309653,1.49570665,0.745407556,0.0,0.0,0.0,0.0,0.256017121,0.540848445,0.43578468299999995,0.0,0.0,0.0,0.0,0.63621215,2.17309017,3.77269406,4.96527522,5.41102658,5.02430478,3.99010849,2.67130077,1.45282623,0.59495848,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.475
0.128035753,0.145018272,0.1597519,0.171050315,0.17780544899999998,0.179071092,0.174142221,0.16262416300000002,0.14448609699999998,0.12009411699999999,0.0902202307,0.0560250712,0.0190137916,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0455837783,0.090170813,0.130903934,0.165034771,0.19009985100000001,0.204087806,0.205586823,0.19390217699999998,0.169135058,0.132215939,0.0848881558,0.0296403259,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.09873036e-16,0.08810716869999999,0.176487781,0.259525367,0.331548498,0.3871671,0.421612705,0.431063721,0.412936817,0.366126665,0.291178399,0.190380258,0.0677677143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.027833859300000003,0.36821119,0.758164939,1.18891097,1.64974493,2.12843359,2.61168076,3.08564671,3.53649738,3.95095774,4.31684376,4.62354826,4.86245815,5.02728406,5.11428761,5.12239665,5.0532044,4.9108538,4.70181447,4.43456403,4.11919084,3.76693801,3.38971139,2.99957553,2.60826141,2.22670874,1.86466323,1.530346,1.23020807,0.968778305,0.74860825,0.570312105,0.432695586,0.33296294,0.266987887,0.22963155600000001,0.215088736,0.217243136,0.23001274300000002,0.24766775,0.265105849,0.278072712,0.283319029,0.278689419,0.26314249,0.236705198,0.200368182,0.15593173,0.10581434599999999,0.0528373937,5.4936518099999997e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0183569225,0.052571056,0.0818382887,0.10458330099999999,0.11971317199999999,0.126663172,0.125407262,0.116434195,0.10069223199999999,0.0795073686,0.0544814294,0.0273774192,3.29619109e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00909494145,0.025823346400000002,0.0398276963,0.0503889515,0.0570587753,0.059673348499999994,0.05834719730000001,0.0534484558,0.0455581891,0.0354173871,0.023865930499999997,0.0117781969,1.09873036e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0023299635999999998,0.006123889820000001,0.00863505959,0.00982849832,0.00979863457,0.00875243858,0.0069835096,0.00483960719,0.0026866081199999996,0.0008721124390000001,0.0,0.0,0.0,0.00161358595,0.00410341593,0.007273981800000001,0.0108552554,0.0145320192,0.0179785149,0.0208953502,0.0230453322,0.0242848877,0.0245879994,0.024060112,0.022940207,0.021590165499999998,0.020471561,0.0201110743,0.021056724,0.023827974,0.0288634513,0.036470413300000004,0.0467802166,0.059713826100000006,0.0749608749,0.09197496449999999,0.10998683,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.449
8.28758628,4.08334233,0.0,0.0,0.0,1.47599574,1.09204731,0.0,0.0,0.26990287,0.141246999,0.273632991,1.21761158,0.0,0.0,0.522459641,0.91758741,1.22907765,0.52881229,0.291393387,0.0,0.0,0.494104445,0.0,0.0733540399,0.275676668,0.344706715,2.0890125,1.52374977,2.3301445,1.16833065,0.639671097,0.24672207100000002,0.778589007,0.0,0.0,0.0,1.02123839,0.894174448,0.0,0.8164118140000001,0.0,0.501424061,0.0,0.38637631899999997,0.0,0.324631918,0.0,1.02910508,1.10168916,0.0,0.0,0.0,0.068140802,1.06855427,0.0,0.0,0.0,0.776759657,0.438539905,0.0,0.5585313510000001,0.516077993,0.0,0.067732582,0.271512341,0.493631528,0.0,0.0,0.0281450935,1.63372696,1.18078613,0.0,0.0,0.569843706,4.80938593,9.24879984,9.90865367,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.23036145,1.00854439,0.0,4.26306892,13.81405437,5.29127896,0.0,1.07667614,0.0,0.0,0.31784429999999997,0.41675107,2.24071888,0.59566982,0.0,0.50013081,0.0,0.0,0.30269804,0.0,0.06789073,0.03488351,0.0,0.0,0.02889925,0.02864789,0.0,0.22474614,0.0,0.0,0.36215771,0.0,0.42519086,0.07220282,0.0,2.18543348,1.38467464,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45399999999999996
0.0311126696,0.173064315,0.32808977699999997,0.49465854299999995,0.671035437,0.8553040679999999,1.04539338,1.23910689,1.43415422,1.62818427,1.81881969,2.00369201,2.18047679,2.34692843,2.50091382,2.64044452,2.76370679,2.86908906,2.95520637,3.02092136,3.06536154,3.08793246,3.08832667,3.06652826,3.02281287,2.95774334,2.87216083,2.7671718,2.6441309,2.50462006,2.35042431,2.18350443,2.00596716,1.82003324,1.62800398,1.43222672,1.23505996,1.03883847,0.84583917,0.658248187,0.478129636,0.30739667,0.147785181,0.0008306104519999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,9.595000599999999e-17,0.07423589679999999,0.14448203199999998,0.209393876,0.267777625,0.318607611,0.361040418,0.394425511,0.418312211,0.432452976,0.43680295,0.431515854,0.416936339,0.393588981,0.362164163,0.323501145,0.27856865399999997,0.22844339,0.17428686399999999,0.11732101,0.0588030378,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.052445356,0.103572292,0.15228699699999998,0.19754879,0.238391188,0.27394148100000004,0.303438417,0.326247668,0.341874778,0.34997534,0.35036220799999995,0.343009601,0.328054025,0.305791977,0.276674484,0.241298574,0.200395827,0.15481824,0.105521645,0.0535470149,1.15140007e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0311126696,0.09994590140000001,0.16943189,0.23822602,0.304973586,0.36833594399999997,0.42701675200000005,0.47978782200000003,0.5255140979999999,0.563177296,0.5918977470000001,0.61095404,0.619800063,0.618079108,0.605634749,0.5825182520000001,0.548992341,0.505531205,0.452816701,0.391730759,0.32334409399999997,0.248901357,0.169802956,0.08758381359999999,0.00388939662,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.48659751700000003,0.130729508,0.189021437,0.41295387200000006,0.55171854,0.484325324,0.25492386899999997,0.007772895429999999,0.0,0.0,0.0198979676,0.122688067,0.133232929,0.0517645608,0.0,0.0,0.0,0.0,0.0710086588,0.09230864710000002,0.0492539483,0.0,0.0,0.0,0.0,0.034898487,0.0568515921,0.0379236273,0.0,0.0,0.0,0.0,0.0127112209,0.027489035699999997,0.021127332000000002,0.00285280586,0.0,0.0,0.0,0.00142041364,0.0031722052899999997,0.00010275077799999999,0.0,0.0035237254799999995,0.0103013592,0.010693397,0.0,0.0,0.0,0.0,0.0106371817,0.0338797439,0.035316166600000004,0.00883143038,0.0,0.0,0.0,0.0082478692,0.0561943689,0.0684398662,0.0300094159,0.0,0.0,0.0,0.0,0.0772149884,0.11414285199999999,0.0693561021,0.0,0.0,0.0,0.0,0.09788579380000001,0.185339208,0.144598353,0.0,0.0,0.0,0.0,0.12272815,0.33432819199999997,0.33128507,0.0593377209,0.0,0.0,0.0,0.5149527629999999,1.81075424,3.15844184,4.08238103,4.25264055,3.64023793,2.52300301,1.34160848,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.539293781,0.0,0.0,0.405036171,0.8344943429999999,0.0,0.0,0.0,0.0,0.0,1.38747751,0.6097540779999999,0.0,0.0,0.0,0.68800752,0.0,0.0,0.0,0.736077568,1.67594399,2.02992826,0.0,0.0738202151,0.0,0.430062436,0.621601353,0.0,0.0,0.519416956,0.910230833,0.8644837209999999,0.15381704699999998,0.145778626,0.0,0.794408387,0.0,0.0226881709,0.0,0.0,0.0,0.898203202,0.425505102,0.0,0.9574919620000001,0.0,0.0,0.0,0.345476716,0.427717401,0.912162438,0.0,0.0,0.0,0.7844077559999999,1.32603094,0.895248728,0.415178245,0.0,0.161313185,0.0,0.0,0.0,0.0,0.0932931928,0.0,0.0,0.0,1.48865855,0.0,0.0,1.72672981,1.38729929,1.28266942,1.77577862,0.52119046,0.463494216,0.7845875859999999,0.0,0.0,1.03037806,0.43536835100000004,0.291522725,0.0,1.25894681,1.01395862,0.0,0.0190297679,0.0,0.0,0.0,0.06618988599999999,0.0670407976,1.54365898,0.956858248,0.0,0.7915135590000001,0.878407243,1.84037102,2.03311556,0.0,0.0,0.0,0.345785475,1.65134801,1.02208083,0.0261816015,0.0,0.45219897200000003,0.465327686,2.30184902,0.0,0.0,0.0,4.45713382,12.5886,15.7703459,13.060075,7.49865625,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.52
0.389055176,0.0,0.0,1.07474837,0.35034507200000004,0.07658399440000001,0.0,0.189547169,0.0,1.47941843,0.9662146140000001,0.0,0.585460161,0.0,0.0,1.52892406,0.0,0.0,0.0,1.1127037,0.828982847,0.19342821899999998,1.76075756,2.16375055,0.605207608,3.40916233,2.07552172,0.0,0.38223081700000006,0.301772455,0.0,0.877147777,0.751625813,0.0,1.03383994,0.09093220939999999,0.0,0.933927994,0.0,0.0,1.35345308,0.975597768,1.12101092,1.91297027,0.0,0.0,0.0,0.174593533,0.7685132290000001,0.0,0.691676072,2.78314875,2.2591158,6.046962000000001,4.28815236,1.63423914,0.258195498,0.0,0.512913053,0.733271518,0.0,0.654582978,0.0,0.9146634929999999,0.0,0.0,0.0,0.0,0.8723709009999999,0.0,0.0,0.0,0.0,0.5270859999999999,0.11814813099999999,1.9066549,1.69002152,0.741519904,0.050626354299999995,1.00130406,0.0,0.0,0.0,0.0,1.02280836,2.51153741,0.0,0.833258878,0.0,0.8906502620000001,0.0,0.0,0.38454164,0.0,0.39395696700000005,0.0,0.0,0.0,0.684388216,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
5.08319593,4.34979382,3.31339722,2.13710228,0.998882157,0.0579287551,0.0,0.0,0.0,0.0,0.0,0.358791353,0.674642524,0.8100372290000001,0.747637199,0.5202694529999999,0.198077447,0.0,0.0,0.0,0.0,0.0,0.0,0.13073770699999998,0.319604397,0.409252381,0.38242997799999995,0.253575342,0.0631790487,0.0,0.0,0.0,0.0,0.0,0.0,0.14073110000000003,0.268069309,0.317920489,0.278851156,0.163737965,0.0056941000000000005,0.0,0.0,0.0,0.0,0.0,0.0167817705,0.169693978,0.277144575,0.309006381,0.25490787800000003,0.127081644,0.0,0.0,0.0,0.0,0.0,0.0,0.09599055640000001,0.36756598799999995,0.6311585829999999,0.847474238,0.9894219999999999,1.04656013,1.02525676,0.9448997170000001,0.83146952,0.710364049,0.600405533,0.510486586,0.439478739,0.37907833700000004,0.318466243,0.249221697,0.168960727,0.0826363715,0.00119131914,0.0,0.0,0.0,0.0,0.0,0.055340653899999995,0.101361045,0.119850835,0.104579825,0.0589964621,0.0,0.0,0.0,0.0,0.0,0.0,0.0147696546,0.0812802872,0.12614587900000002,0.13619609,0.107857511,0.048356887800000005,0.0,0.0,0.0,0.0,0.0,0.0,0.03883507,0.10959767699999999,0.150966925,0.150515126,0.107335548,0.0325790491,0.0,0.0,0.0,0.0,0.0,0.0,0.0704693945,0.146450861,0.18318681,0.168955126,0.106076869,0.0107304168,0.0,0.0,0.0,0.0,0.0,0.00402239259,0.11709648800000001,0.20169896899999998,0.23239249399999998,0.19787323199999998,0.104822376,0.0,0.0,0.0,0.0,0.0,0.0,0.049261212699999994,0.198538402,0.30048243399999996,0.322472492,0.25236273800000003,0.103362287,0.0,0.0,0.0,0.0,0.0,0.0,0.15104704800000002,0.388493697,0.539902282,0.55133293,0.40264805600000003,0.11791236,0.0,0.0,0.0,0.0,0.0,0.485702477,1.47201875,2.60332916,3.71994364,4.65006179,5.24254814,5.39679074,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.103963079,0.0,0.297828892,0.456674825,0.70178568,0.475020134,0.310556979,0.723111627,0.0,0.0,0.0,0.0,0.0,0.0,0.18900643399999997,0.0,0.0875167742,0.0,0.0,0.0,0.5125195260000001,0.0,0.0,0.06413080110000001,0.47036105200000006,0.0,0.0,0.0,0.555926606,0.023630803199999998,0.0,0.0,0.0703834005,0.053561025199999994,0.0,0.0825637896,0.0,0.0,0.0,0.387210987,0.0,0.09258968779999999,0.0940881619,0.706861746,1.51427448,1.79880246,3.0271877999999997,3.9236612,4.25233632,5.95296727,6.09407653,5.794665900000001,5.49500446,5.81109405,4.34420767,3.83643246,1.47324144,0.5431472310000001,0.189015025,0.117271415,0.6162994479999999,0.608446128,1.52974027,2.36202437,3.81696681,4.30948929,5.25551686,5.2904545999999995,4.83881124,3.44497833,3.32957214,1.75377177,1.22355656,0.513042081,0.0,0.0,0.0,0.0,0.343605661,0.0737686039,0.570349824,0.05266235230000001,0.550583418,0.718922545,0.0,0.0179197138,0.0,0.0748808892,0.0162688264,0.0,0.39646209299999996,0.0,0.274304605,0.16871024,0.0,0.5735015410000001,0.0,0.43395861399999996,0.0,0.0,0.38497975100000004,0.0685817615,0.49763983,0.596777844,0.662889587,0.76450148,0.0308771572,0.225355594,0.511321942,0.0,0.0,0.0196121276,0.0809494662,0.0,0.318822506,0.679028338,0.23924359899999997,0.0,0.0,0.0,0.0393413964,0.0,0.0850342169,0.0,0.271199786,0.0,0.0,0.0,0.0,0.646260905,0.67614825,0.0,0.135736201,0.0,0.470287335,0.0,0.559738337,0.24738793399999998,0.484337057,0.22222433600000002,0.0,0.0,0.658268863,0.0845786818,0.53550687,0.587874639,0.41095494899999996,0.0,0.49810320799999996,0.0,0.0,0.454842834,0.103542076,0.32861532600000004,0.17943225699999998,0.0,0.41936592799999994,0.0,0.261706353,0.0,0.0,0.0263598473,0.293510355,0.0,0.35014873399999996,0.0,0.0,0.141448763,0.0,0.5934322129999999,0.0,0.0,0.475621636,0.454440561,0.0,0.302889593,0.296066344,0.587888442,0.0,0.37773026600000004,0.47927212700000005,0.0,0.515873711,0.24540658399999998,0.0,0.568127452,0.544723155,0.014770658400000001,0.0,0.0,0.630696558,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.256258243,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.029761126800000003,0.043049888,0.0,0.147389503,0.142196839,0.11722657,0.35286430399999996,0.167610631,0.44511769799999995,0.452350759,0.48055797,0.39020327299999996,0.543535443,0.424114638,0.607999351,0.590062276,0.687670928,0.78369381,0.31741374899999997,0.39781935700000004,0.337636709,0.641975313,0.12297343,0.413003798,0.27353185399999996,0.241268762,0.14509049699999998,0.0219464955,0.0,0.276854428,0.246759748,0.0,0.0592674903,0.0,0.218795921,0.129595621,0.0,0.0,0.241990973,0.0,0.0,0.415253345,0.44948570600000004,0.0526139521,0.43835498799999995,0.279492485,0.19626400100000002,0.41867376,0.23560653199999998,0.0,0.425507246,0.0,0.108456291,0.0,0.152039016,0.0564844316,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.048851526299999996,0.0526251555,0.0,0.227217065,0.656274374,0.90891963,1.20070821,0.9157025,1.70419816,1.77898412,2.16971811,1.92672421,2.5022015,2.59639755,2.53481434,2.95534897,3.02845975,2.8425697,3.05626002,2.78293378,3.02790062,2.84467032,2.64521595,3.02068528,2.84773945,2.26822329,2.56795929,1.89325637,1.66702167,1.75267137,1.40637978,1.35401967,0.8974277490000001,0.8317922959999999,0.62025198,0.595592826,0.321964729,0.150543012,0.41052686,0.00829186875,0.0115129775,0.00026349661,0.139346897,0.25087944100000004,0.0,0.0320560748,0.0,0.322801939,0.30716479,0.41628600200000004,0.0927412472,0.512890619,0.336666555,0.718662182,0.44875382399999997,0.739019828,0.367713511,0.531619914,0.348909174,0.8121167640000001,0.277692418,0.49449834,0.621642531,0.689563503,0.435091227,0.0568832576,0.422573496,0.0,0.220097997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.027574593999999997,0.0,0.218717325,0.0,0.0,0.0,0.301408647,0.322005332,0.653070435,0.599642159,0.30748877399999996,0.22610221600000002,0.17822287899999997,0.536657205,0.183743412,0.322288128,0.171043417,0.080020648,0.0393471714,0.345134405,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
1.40735991,0.420397143,0.0,1.59147069,0.18700709899999998,0.0,0.158750244,0.0,0.0,0.126399433,0.499892836,0.45719330799999996,0.320005638,0.388773775,0.0,0.0378082623,0.362085645,0.0,0.195222297,0.0,0.0,0.0,0.0,0.0,0.32607953,0.16007640199999998,0.0,0.7089788090000001,0.0,0.0,0.0111109794,0.0,0.0,0.0,1.1427803,0.223985285,0.7701990059999999,1.37378305,0.0,0.6888481240000001,0.799793832,0.403506187,0.20863653100000001,0.0,0.0,0.483837455,0.0543914491,0.578327871,0.48136301299999995,0.27966551300000003,0.0,0.0735945202,0.08312524290000001,0.505878827,0.15476408,0.125469745,0.0,0.0,0.0,0.368083499,0.298487445,0.300086056,0.0,0.0,0.420959973,0.0,1.13403694,0.0,0.8479809859999999,1.23329602,0.6956079709999999,0.0,0.0,0.154572686,0.0,0.27203998100000004,0.5631622829999999,0.5288399970000001,0.20337709699999998,0.804795605,0.0,0.419781719,0.250036562,0.123532265,0.034861934,0.0703251676,0.0,1.18637709,0.8441052179999999,1.21130504,1.46704702,1.43013697,2.99515224,2.9412333,3.26506556,2.58371404,1.71749737,2.5482659,2.63116954,2.00922961,2.36624382,2.39132121,1.96842332,0.262594487,0.858255159,0.641643933,1.9981167000000002,0.148753671,0.43461584200000003,0.0,0.698774455,0.0,0.563405273,1.41354536,1.25124949,0.0,0.221443607,0.42750814,0.0,0.0,0.0,0.0,0.19910623600000002,0.0,0.0,0.0,0.775896945,0.09772479390000001,0.0,0.0,0.0,0.0972705724,0.0,0.0,0.77319528,0.0,0.0,1.08542218,0.454450306,0.523621596,0.744895326,1.4339494,1.4911395,1.64788377,0.0,1.41638677,0.006659545260000001,0.7040654340000001,0.10311318800000001,0.0,0.294104648,0.556449623,0.0,1.13899273,0.40707839,0.0,0.11265309,0.0467234471,0.0,0.0,0.198089923,0.0,0.445458942,0.10036558599999999,0.0,0.867307633,0.0,0.0,0.0,0.0,0.0,0.95499803,0.0,0.473116576,0.0370642319,0.0,0.0,0.0,0.5284609570000001,0.239166044,0.0,0.0,0.0,0.0,0.44009787100000003,1.15505974,0.0,0.58943974,0.373986624,0.141131366,0.0,0.00428704597,0.48226716299999994,0.0,0.0,0.0,0.0,0.0,0.909001318,0.0,0.0,0.262697692,0.0,0.0,0.0,0.0,0.435765205,1.163326,0.17623022600000002,0.0,0.0,1.39425629,0.0360578187,0.0519051815,0.0743939813,0.0,0.769111715,0.0,0.854138902,0.74502619,0.131810666,0.0,0.0416590204,0.633945593,0.5058404000000001,0.179387018,0.0,0.282342562,0.0,0.35531136700000004,0.35842066200000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
1.92724285,1.39100817,1.26265402,0.7421314390000001,0.423998572,0.7417022190000001,0.598738919,0.0,0.02398054,0.0063482289,0.516076558,0.644407031,0.997455972,0.204378686,0.0988122272,0.69463577,0.323082769,0.0,0.0,0.0,0.0,0.255568088,0.41229289700000005,0.0,0.0,0.181067943,0.0,0.0679559741,0.0,0.0,0.0,0.384407276,0.0616002437,0.442061252,0.334312732,0.20854823600000003,0.11492004300000001,0.0,0.0,0.0,0.291350726,0.546795904,0.39388670299999995,0.0,0.0,0.108511082,0.0,0.0,0.337310524,0.0,0.0,0.0,0.0,0.140670014,0.0,0.0,0.0,0.517972885,0.0984312944,0.27246352,0.46236657299999995,1.048244,1.06577519,0.866580186,0.353718674,0.579918074,0.557891968,0.358656154,0.42920683299999995,0.640522585,0.36597493799999997,0.976476335,0.359318486,0.49431199200000003,0.44380527799999997,0.70723253,0.373244966,0.0,0.429367468,0.0,0.0449816692,0.0247776279,0.960541476,0.924811376,0.218728554,0.0,0.280113387,0.11929123900000001,0.290104669,0.8766871409999999,0.5456333870000001,1.47835078,1.68960247,1.65044598,1.37833504,0.364335357,0.0,0.0,0.0719581872,0.0,0.0,0.276639573,0.304636217,0.0800369054,0.150828993,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.175758535,0.31296388,0.0,0.0,0.0,0.0,0.0,0.0,0.007499213050000001,0.642691742,0.507698907,0.0,0.0,0.0,0.0,0.16613646199999998,0.371105146,1.51794402,1.66333664,1.29854644,1.14240884,1.27509148,0.266606109,0.0,0.0,0.0,0.0,0.021277750800000002,0.0,0.0,0.0,0.337136686,0.0,0.0,0.0,0.13359126400000002,0.0,0.0262446892,0.0,0.324551443,0.0,0.0441246783,0.14495951599999998,0.360338696,0.0,0.00266015488,0.0,0.0,0.0,0.081043057,0.0,0.246167775,0.597670927,0.521389571,0.6744105440000001,1.19692062,0.920800391,0.10795140800000001,0.281319853,0.319700706,1.27680936,0.8251357420000001,1.25796155,0.97201598,0.833358701,0.5216537520000001,1.05326449,0.357401674,1.06185148,1.60286221,2.15640389,1.92788479,2.48417512,2.77028036,2.90870081,2.8439778,3.84372769,3.61083152,3.9753886,4.15835053,4.97745406,4.50723522,4.54020658,3.90570933,2.7762562,2.45855832,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.9585325309999999,1.47225313,0.0,0.652143885,1.08328752,0.0,0.548453845,0.0,0.497972983,0.5354743989999999,0.851556213,0.38935859799999994,0.0,0.0,0.0,1.34556176,0.0,0.0,0.0,0.438600284,0.14132205,0.162081482,0.0,0.161449384,0.0,0.557762367,0.0,1.20478476,0.0,0.0,0.8908757070000001,0.0624159171,0.156053823,0.694609395,0.9073157820000001,0.0,0.486742465,0.920249375,0.38433791799999995,0.0,0.21890140800000002,0.841136698,0.0,0.6467408889999999,0.0,0.0162013007,0.0,0.9301858390000001,0.33711154299999996,0.0,0.0,0.0,0.0648793807,1.524302,1.49121758,1.33743405,2.39639878,0.5993081379999999,0.367952071,1.53452861,0.047829948600000005,0.344410045,0.0,0.965001856,0.0,0.0,0.030510049900000002,0.72868324,0.0,1.76242445,1.34453205,0.917322822,0.434861427,0.399868151,1.16154944,1.31468052,1.39695805,2.90398644,2.22145532,1.66175741,1.55837725,3.27615265,2.53643732,2.34307045,2.82169243,3.0304217999999996,2.82826429,2.4725906,1.73120253,1.67062376,0.635877735,1.15449795,0.9199874640000001,1.40260528,2.16744388,1.5111311,1.89332798,3.08370522,1.7535398000000002,0.9739935679999999,0.466867208,0.44255155399999996,0.114593529,0.0,0.0,0.0,0.23548918600000002,2.0649557,0.0,0.0,0.36750526,0.0,0.144022633,0.488569955,0.0,1.07174449,0.888366827,0.148055949,1.08104612,0.253520105,0.268179514,1.68304451,0.348973266,0.0,0.0319615563,0.268364705,0.041578509799999996,0.0,0.54185872,0.290513765,0.0,0.0,1.15227042,0.276117011,0.854666327,0.469206836,0.264748741,0.20771335,0.21366682899999997,0.0,0.0346521364,0.0,0.0,0.0,0.0,0.278806424,0.0,0.0,0.0,0.620899894,0.0,0.0,0.236227325,0.93629022,0.0,0.539129575,0.0,0.316910901,0.14119969300000001,0.7334526259999999,0.45778703200000004,0.220656761,0.16254293,0.0,0.0123497265,0.0412880518,0.0,0.0,0.0,0.0,0.374262505,0.989505162,0.0,0.0,0.0,1.16356806,0.0,0.554145727,0.45786069,0.0,0.365559474,0.247564344,0.0,0.428673211,0.218121841,0.0,0.164360904,0.7229593590000001,0.23710516899999998,0.650958586,0.0,0.049597360599999994,0.0,0.0,0.0,0.686415408,0.0,0.0,0.0,0.18286571199999999,0.0,0.0,0.0,0.49914302,0.0,0.0,0.0,0.0,1.22056331,1.34244454,0.7391370079999999,0.279561455,0.0,0.038862520299999995,0.0,0.34813683100000004,0.0,0.316922828,0.0,0.11122177300000001,0.515828304,0.42248168799999997,1.96677978,0.742536545,0.646758088,1.12558699,0.102165935,0.28496335300000003,0.0,0.6411679610000001,0.851030427,0.946067865,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
3.78114393,3.84445029,3.62776785,4.21069157,3.62311843,3.72646926,3.67625564,3.29559208,3.55438405,3.31771722,2.9369057,2.56448759,2.84128822,2.5290245,1.83140802,2.04792022,2.09359442,1.26217715,1.18635288,0.963885145,1.1843471,0.822510902,0.620893355,0.447535299,0.44342616,0.21732230600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.510248041,0.0,0.596075231,0.425462154,0.22592855,0.397718777,0.509557594,0.275905871,0.26393394,0.0807890144,0.23609479100000003,0.55448154,0.487153961,0.769912808,0.5071872279999999,0.7403994359999999,0.161004247,0.11270848800000001,0.591025447,0.451124591,0.558505875,0.0941158216,0.465353394,0.0,0.10932346400000001,0.13824640800000002,0.0,0.268249646,0.413258909,0.338941758,0.0,0.0,0.0558148379,0.421359781,0.0949258156,0.0,0.030577313300000002,0.15537089699999998,0.0,0.123811818,0.335627447,0.0,0.563040095,0.306649895,0.315046545,0.29328725899999997,0.255463454,0.256032071,0.6581198970000001,0.17011795899999999,0.187893373,0.0,0.173699103,0.110785605,0.0,0.437588288,0.222622627,0.21966575300000002,0.284547311,0.25015749,0.325677597,0.02444407,0.0,0.0,0.172512205,0.0846112697,0.0126827452,0.0,0.0330546606,0.020988704500000004,0.0,0.0,0.286500763,0.0,0.0,0.0,0.0,0.326670339,0.349455759,0.0,0.0,0.141363541,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24853718,0.082508937,0.0,0.0,0.329254804,0.0,0.0,0.27968029,0.0,0.0,0.0,0.22547146899999998,0.0,0.0,0.125196222,0.0,0.0,0.0,0.0,0.0,0.156143424,0.0,0.0921954636,0.25902830600000004,0.0,0.118245031,0.224547214,0.0833154603,0.27270199,0.300614917,0.0650832802,0.0,0.284263689,0.0512611879,0.47487082399999997,0.49328972299999996,0.11236568400000001,0.5350911660000001,0.15283339699999998,0.396814314,0.448156603,0.05975765809999999,0.0,0.0029538683399999996,0.642489965,0.0,0.48064257299999996,0.048416216,0.0026874156,0.0,0.310242283,0.0427262659,0.182318077,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0357251703,0.0,0.0,0.26280972199999997,0.655431394,0.663967238,0.974171435,1.42144611,1.37455514,1.8525518,1.91323359,2.06589254,2.36504743,2.7685231,2.90011029,3.05294175,2.78570235,3.3701432999999996,3.54292112,3.1374605,3.56648538,4.13299258,3.70515795,4.25213972,3.71353983,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.52760602,1.29218614,1.51462593,0.991466601,0.20923472199999998,0.0,0.0,0.12605182,0.13396566199999999,0.0,0.0,0.0,0.104192145,0.0631853552,0.0,0.0,0.0230547848,0.09756361960000001,0.0226495692,0.0,0.0,0.0579857665,0.0925095989,0.0,0.0,0.0,0.093873894,0.0802590232,0.0,0.0,0.00986182146,0.13097166,0.0723442508,0.0,0.07095856730000001,0.328750214,0.357416612,4.65319532e-16,0.0,0.0,0.329163043,0.44334119899999996,0.0,0.0,0.26226193800000003,2.12878348,3.63696979,3.40714597,1.63457742,0.0,0.0,0.0,0.39192171,0.21175569800000002,0.0,0.0,0.05523061519999999,0.20369438399999998,0.0388145975,0.0,0.0832280639,0.34939241,0.310628705,0.0,0.0,0.0,0.18531639600000002,0.17721025,0.0,0.0,0.0138500661,0.184173846,0.0759133822,0.0,0.0,0.12994364,0.388850765,0.248854028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
6.71616672,0.5850765379999999,0.0,0.34530551600000003,0.929181835,0.0,0.0,0.260906793,0.291046088,0.0,0.0,0.329501995,0.394051673,0.0802177337,0.0915737567,0.234994812,0.0319562404,0.0,0.0,0.16522015199999998,0.0,0.0,0.052625344000000004,0.15209493,0.0,0.0,0.130967555,0.188424548,0.0,0.0,0.867955647,2.76597417,3.80687961,3.11120899,1.39646513,0.0749683234,0.0,0.0,0.094207104,0.0,0.0,0.013508080700000001,0.030871695600000002,0.0,0.0,0.0125364249,0.0134291428,0.0,0.0,0.0149876277,0.009700173809999999,0.0,0.0,0.0408177235,0.00919813692,0.0,0.169375907,0.75343567,1.04820873,0.551718089,0.0,0.141018907,0.921301131,1.26893077,1.28659511,1.66383022,1.77988542,0.636220837,0.0,0.0,0.662682724,0.214542407,0.0,3.21227046,9.22898494,11.348185800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.772454573,0.13381919,5.04211681,11.727474699999998,10.6734404,3.10756943,0.0,0.388862817,0.8886085290000001,0.0,0.0,0.605351899,0.0414108429,0.0,0.608852563,1.08711075,0.339097556,0.21572298199999998,0.617777097,0.261764267,0.0454056903,0.770194371,1.08242167,0.531421102,0.302657509,0.321819445,0.0,0.0,0.21178355100000001,0.119923555,0.0,0.0219400775,0.29446347,0.0,0.0,0.298318391,0.06798919190000001,0.0,0.993157328,1.58846537,0.545738837,0.44917473,1.56389483,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.11387297,0.331059447,0.0,0.0626927051,1.28841885,2.87256621,2.4123213,2.56771788,3.07603942,3.64236632,1.43440346,2.58457256,1.56597375,0.315507045,1.11471138,0.0,0.7486905909999999,0.0,0.0,0.776231923,0.0,0.0,0.0,0.545816552,0.0,0.0,1.05718495,1.67996434,1.67964396,3.25153132,1.49330293,1.12143226,0.479225888,1.02968931,0.909089032,0.23267807199999999,0.305439549,0.510259527,0.8783765929999999,0.387555903,0.0,0.0,0.6574149020000001,0.0,0.320484495,0.0,0.08787697119999999,0.73426159,0.176801428,0.20749563699999998,0.0,0.0,0.0686066991,0.349152625,0.0,0.0,0.0,0.19151737100000002,0.440691185,0.596715659,0.0777768711,0.46379598,0.017189218200000002,1.19695943,0.0,0.0,0.0,1.09264476,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.582230451,0.0,0.0,0.0,0.221839891,0.0,0.0,0.785064271,0.6549624079999999,0.0,1.00450246,0.26077797399999997,0.0,0.20128690899999999,0.0,0.0,0.435660614,1.00052112,0.797424173,0.0,0.6765304879999999,0.114338101,0.5245966879999999,0.0,0.0,0.79350613,0.0,0.0,0.5059791889999999,0.411573894,0.0,0.0,0.0,0.270602393,0.572792265,0.0,0.0,0.0885116208,0.9513752990000001,0.236687217,0.52652962,0.0,0.20410037399999997,0.121443958,0.238021977,0.5358143320000001,0.386574022,0.0,0.7018298359999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.44323698100000003,0.0,0.0,0.373305121,0.0,0.0,0.0,0.0,0.163353691,0.305417286,0.283323328,0.53255,1.22926294,1.36006254,1.31449839,1.52876141,2.48105842,2.73225305,3.75771639,3.90080476,4.20102323,4.16063821,2.64569874,1.94922569,1.21251197,0.56640229,0.0,0.0,0.10086902199999999,0.0475136684,0.43439352,0.0,0.380786147,0.23373366899999998,0.0,0.0,0.461320096,0.771353395,0.0,0.217367793,0.0,0.112765108,0.211855613,0.0,0.0,0.52260905,0.0,0.189055986,0.502740662,0.268281194,0.5866417420000001,0.44289484,0.0,0.0,0.0,0.0869159525,0.0565765854,0.0,0.0,0.0,0.272921211,0.0,0.0102722912,0.444181525,0.259489331,0.122013232,0.0,0.11495365199999999,0.0,0.0,0.0,0.379057486,0.0370772002,0.13094878199999999,0.0,0.0,0.0,0.0105550891,0.0,0.0145905619,0.29175317,0.0,0.27495622,0.0,0.35282368700000005,0.11006734,0.0,0.0349366372,0.0,0.20281375399999998,0.0,0.0443712041,0.157512177,0.0732236595,0.224318013,0.0,0.0,0.182060125,0.341774585,0.646562886,0.246790848,0.395961967,0.0,0.180590644,0.39004412899999996,0.50378544,0.116655478,0.363603602,0.0,0.14440366599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.126603997,0.18654800300000002,0.354856181,0.334093107,0.0441379184,0.44859196700000004,0.24686560800000001,0.0,0.369705364,0.0,0.264477198,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
7.12912084,6.66577099,5.05191374,2.89808131,0.92954947,0.0,0.0,0.0,0.17031282,0.535668,0.52861832,0.21184461,0.0,0.0,0.0,0.0,0.1718943,0.30708493,0.23760184,0.04110051,0.0,0.0,0.03402299,0.29154671,0.48247520000000005,0.49047664,0.30500804,0.02555198,0.0,0.0,0.0,0.05732008,0.21276896,0.22894924,0.10317828,0.0,0.0,0.0,0.0,0.09906137,0.19957965,0.17271632,0.03909918,0.0,0.0,0.0,0.0,0.12892335,0.18664933,0.12630112,0.0,0.0,0.0,0.0,0.03384296,0.1439986,0.15839335,0.07317457,0.0,0.0,0.0,0.17679316,0.41609237,0.58482389,0.60694742,0.48336216,0.28783979,0.12038884,0.0486219,0.07505462,0.15095541,0.22595788,0.2973217,0.42072091,0.66875022,1.05986235,1.50583527,1.82182343,1.80852262,1.36946115,0.59620815,0.0,0.0,0.0,0.0,0.38254253,0.92571456,0.92888941,0.31031094,0.0,0.0,0.0,0.0,1.79607195,4.21766128,6.21993266,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.0133097951,0.0,0.0,0.0056272898,0.0,0.801072184,0.845003136,0.0,0.447463832,0.999627198,0.588140165,0.04816375690000001,0.0,0.31599918899999996,0.0,0.0,0.0,0.699736237,0.36079089,0.38441747600000004,0.0,0.250092494,0.0,0.0,0.7155559770000001,0.0,0.0,0.505596808,0.108683864,0.0,0.0,0.6991917879999999,0.0,0.027238671000000002,0.47165713,0.0,0.775122758,0.0,0.0,0.0,0.155799837,0.0,0.0,0.0,0.0,0.0,0.0,0.103878816,1.00743991,1.73504102,2.32698867,2.96199766,2.5280867000000002,1.13249029,0.630301562,1.50976315,1.60704465,2.03660919,3.18988786,5.26332419,7.68279308,8.31209811,7.29250606,6.34412306,4.60850052,1.41510234,0.0,0.0,0.0,0.0,2.47285404,4.23427809,5.79706905,5.20658587,5.36821144,4.13398276,2.86338816,0.559511022,0.14604619900000002,0.0,0.0,0.0,0.525406304,0.800285549,0.9858833109999999,0.0,0.0,0.5824931839999999,0.0,0.136734431,0.0,0.0,0.0,0.284804862,0.22629048300000001,0.0,0.21244941399999998,0.6829070709999999,0.0,0.0,0.0,0.0,0.464811546,0.0,0.0,0.580390757,0.0,0.239398608,0.48170025200000005,0.0,0.010900181699999999,0.0,0.0861132158,0.0,0.355079298,0.0,0.0,0.0,0.0,0.0,0.616226295,0.0,0.12600277099999999,0.0,0.35092027600000003,0.0,0.265776372,0.77978018,0.0,0.0,0.33212103600000004,0.304962573,0.293189745,0.329163124,0.0,0.0,0.0,0.0,0.0,0.00323228562,0.692152257,0.0,0.0,0.120532945,0.733901125,0.0,0.526542492,0.0,0.44420635399999997,0.168440221,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47100000000000003
0.44321138600000004,0.11133728,1.1448728000000001,0.137198665,1.05190474,1.33928085,0.0,1.34239665,0.5240609279999999,0.0282387365,0.0,0.0,0.0,0.0,2.91235092,0.7442300820000001,0.0,0.494365355,0.0,0.0,0.18830886,0.0,0.0,0.984530742,0.0,0.0,0.0,0.346182375,0.0,0.0,0.0,0.0,0.0,0.575592766,0.058966130199999994,0.0,0.0,0.0629656292,0.40880193,1.63288599,0.33558151399999997,0.151651231,0.253521885,0.13354567,1.1202347,0.0,0.8785922709999999,0.0,0.0,0.776290295,0.42050830100000003,0.0,0.016020386,0.0,0.23514431600000002,0.726216489,0.0,1.37697937,0.297490771,1.99706662,0.0,0.0186029781,0.9086006520000001,0.0,0.0,0.17764819699999998,0.658883311,0.47836616,0.0,0.464178469,0.0,0.40753017399999997,0.0,0.0,0.0,2.16640651,0.488694302,0.0,0.7388712940000001,0.803086075,1.60226646,0.0,0.000339528412,0.0,0.48187487700000003,3.26625956,3.17340644,0.0,0.0,0.0,0.0,0.6873773,0.708210628,0.0,0.39963117,2.10506939,0.879340694,0.0,0.0,0.818581676,0.466672126,0.724150827,1.09386289,2.01581103,1.70724112,2.36127075,1.29541179,0.0,1.3550698,0.0,0.662573341,0.0,0.0,0.0,0.22758146699999998,0.8868132809999999,1.32553107,0.0,0.0,0.0,0.0,0.0,0.0,1.28440867,1.45516031,0.21556641899999998,0.0,0.0,0.0,0.0,0.961923438,0.8425656220000001,0.0,0.0,0.169811233,0.0,0.24318632399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
0.272867336,1.89569457,1.73757052,3.33837683,2.56038685,1.51696644,0.0,0.264313311,0.0,0.0,0.00849592856,0.0,0.023779478599999997,0.0,0.049415999599999996,0.0,0.140669942,0.7972139690000001,0.507686285,2.41344346,0.0,0.19420198100000002,0.624625034,3.68348824,2.47017495,0.0,0.0,0.0268719291,0.0,0.0408175346,0.0,0.0476867056,0.0,0.08760495619999999,0.336844075,0.0,0.30842094600000003,2.62856308,1.64283161,1.08914542,0.0,0.8983602759999999,2.33715666,0.0,0.121722317,0.0,0.0209811382,0.0733946281,0.451445141,0.0,0.09017418699999999,0.0,0.0670246842,0.0,0.0646358616,0.0,0.0727990398,0.0,0.529587565,0.0973216069,0.717981998,1.67289544,0.0,0.296048313,0.0,0.208462482,0.0,0.253169265,0.0,0.790070912,1.14653052,0.0,0.12991222800000002,0.0,0.0424426562,0.0,0.00615887804,0.0069583640500000005,0.0,0.0323787801,0.0,0.0933826746,0.013165763799999999,0.047307635199999996,0.0,0.0992419464,0.0,0.18563299800000002,0.0,0.722224112,0.593353537,0.127580946,0.0,1.09905086,1.48664335,4.08226378,3.48449057,0.0,1.04268567,0.0,0.959803009,0.0,8.45762647,6.00755458,0.7704342279999999,3.38174928,0.289141502,0.875743822,0.16163044,0.19499116800000002,0.0,0.43814624,0.305613216,0.889687415,0.328170374,0.604830427,0.651628378,0.0,0.24959794300000002,0.0,0.20075700800000001,0.0,0.194630396,0.0,0.21031531399999998,0.0,0.251331394,0.0,0.3506685,0.0,1.16648276,0.23093752899999997,4.14492348,3.24962057,0.627179695,1.51593886,5.28273192,1.56428889,0.43533659399999997,1.18360246,0.0,0.40660217200000004,0.0,0.9994540609999999,0.779358407,0.410238782,0.0355630517,0.21472945,0.0,0.85788885,1.89852387,1.89648985,0.8674693040000001,2.89043748,3.18402342,3.81500695,0.919456816,3.56468278,4.28220566,3.06667269,1.35163352,0.026773762000000003,0.00472215831,0.0,0.0,0.00679916239,0.0,0.0140022831,0.0,0.016657894399999998,0.0443175195,0.0273551782,0.460492409,1.70830533,1.69304377,0.17119873,0.09027747230000001,3.57033062,0.8183027829999999,0.66987902,2.36159676,7.24029822,6.80468475,4.98809379,2.09313859,0.699496617,0.0150517018,0.0642176233,0.232256013,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45299999999999996
0.0695775706,0.576725939,0.35471359799999996,0.0,0.0,0.35823146299999997,2.88256988,4.85919667,4.82387661,3.05568078,1.12345173,0.20029087399999998,0.12868646,0.125618799,0.0,0.143878431,0.8574612909999999,1.53070655,1.39721932,0.490617456,0.0,0.0,0.0723725249,0.350182244,0.11550216199999999,0.0,0.0,0.09444905029999999,0.24978086800000002,0.044868936,0.0,0.0,0.138173653,0.306142105,0.139155141,0.0,0.0,0.196061863,0.457437356,0.38650280299999995,0.0939550233,0.0,0.221047854,0.6565750929999999,0.8420893779999999,0.568019919,0.06435804219999999,0.0,0.0,0.10432536699999999,0.17655487,2.42775094e-16,0.0,0.0,0.1146761,0.15500349300000002,0.0,0.0,0.0,0.166771728,0.20247693,0.00648541657,0.0,0.158723286,0.443875549,0.325176654,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
2.20260079,4.1135934,3.66594324,2.57887019,2.80936759,1.17510598,1.04452617,1.22260611,0.611723256,0.310323726,0.719612732,0.451172178,0.0,0.103182564,0.29046691399999996,0.16930071,0.0,0.0,0.0,0.0,0.28145862899999996,1.21730201,0.302987317,0.0,0.195147226,0.417266123,0.0,0.0,0.0,0.139100955,0.63661844,0.168929103,0.0,1.17542959,0.664439446,0.0,0.588046205,0.488543933,0.0,0.20921191,0.818383535,0.403120243,0.8674708740000001,0.8990765629999999,0.0130364821,0.245830601,0.0,0.303223615,0.0249050198,0.12713973,0.271109247,0.0,0.267562803,0.0477511466,0.0,0.0,0.0,0.0,0.48217728,0.603876734,0.37205825299999995,0.0,0.409729888,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
0.8260849,0.0,1.15204696,0.71798405,0.23964441,0.09578061,0.71574198,1.38162956,1.50211039,0.0,0.0,0.0,0.0,0.0,0.0,1.91183467,0.0,1.24062438,10.5895621,3.26050541,0.0,2.28727106,0.0,0.0,1.74517849,0.22902133,0.86826941,0.68583098,0.6382585999999999,0.90135088,0.23605019,0.0,2.20138761,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.22511849,0.36275460600000003,0.450390357,0.476089284,0.452551081,0.41225354799999997,0.39469165700000003,0.430141396,0.52591298,0.660517231,0.7886443870000001,0.856138618,0.820485213,0.669988987,0.434690454,0.184306012,0.0124602116,0.0109615653,0.241400168,0.712717136,1.37207567,2.11267059,2.7971397000000002,3.29051431,3.49364947,3.36776431,2.9432256000000003,2.31026855,1.5945722,0.9248946029999999,0.402033262,0.0776243797,0.0,0.0,0.0510958767,0.136361908,0.168726665,0.13141719400000001,0.0410767501,0.0,0.0,0.0,0.0,0.0,0.06610113349999999,0.13457734,0.14923019099999998,0.10565501699999999,0.0217558871,0.0,0.0,0.0,0.0,0.0,0.076011948,0.13754174,0.145671942,0.09622118019999999,0.0075168935,0.0,0.0,0.0,0.0,0.06958316980000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
1.033635,0.0,0.0,0.0870438212,0.224569288,0.0,0.630700058,0.342099551,0.114967906,0.49340087200000005,0.0,0.331421613,0.0,0.575821224,0.315588477,0.27775205,0.0,0.0,0.00851226276,0.0,0.0,0.0,0.362054239,0.0,0.188006358,0.49557425200000005,0.023664200099999998,0.0,0.0,0.0,0.218997865,0.31149524,0.0,0.107767444,0.8636819929999999,0.6687265139999999,0.39437433,1.48844222,1.09042364,0.0,0.590689406,0.0,0.0,0.0,0.0,0.33749076299999997,0.0,0.0,0.479204158,0.0,0.194291842,0.374378249,0.100378059,0.658260343,0.32951324600000004,0.214308157,0.521159844,0.0,0.06240078860000001,0.0,0.0787289387,0.0,0.299354016,0.63666481,0.0,0.430249027,0.289927119,0.423862546,0.586013364,0.18231030899999998,1.94374816,2.29497693,1.71118653,1.59355424,0.329793991,0.452326775,0.056894133300000004,0.735150505,0.0,0.0,0.652650023,0.264130915,0.145679506,0.20426163100000003,0.0,0.0,0.15930298,0.601538517,0.0,0.00413728853,0.0,0.0,0.43788455200000004,0.0,0.40434519700000005,0.0,0.320784032,2.25156668,3.43758937,2.50978002,0.29482273,0.0,0.0,0.269675516,1.35515196,0.0,0.0,0.0359579575,0.965680158,0.479733491,0.0,0.0,0.590742246,1.71795736,0.085522826,0.0,0.0,3.92977944,6.05964232,6.32124726,3.83000683,0.581996145,0.0,0.194623427,0.638725914,1.92317998,3.83070331,4.05620036,3.50972339,1.24092289,0.0,0.37762652799999996,0.36206763,1.157831,0.348556775,0.0,0.435073485,0.0419989766,0.225877515,0.552154774,0.0,0.550284965,0.714607239,0.40540729,0.0,0.0,0.0,0.208856437,0.0,0.0,0.5852434470000001,0.0,0.0,1.00693959,2.15851683,3.10120094,2.34312826,1.81199344,1.23809255,1.85195764,1.01270885,0.37070132,0.0,0.0,0.0,0.268597834,0.0,0.145973418,0.0,0.0,0.0,0.107288202,0.0,0.377623971,0.0,0.0,0.0,0.48595552399999997,0.30603765899999996,0.293070016,0.103510835,0.294123085,0.5349611470000001,0.0,0.0,0.264068222,0.9821951590000001,1.79059417,2.52905758,1.02031201,0.9114845420000001,0.0,0.242936603,0.08266865129999999,0.714220583,0.536173615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.692267293,0.434070267,1.6875404999999999,1.68265807,0.0,0.694277426,0.0,0.0,0.213495551,1.21504763,0.0233060051,0.1454093,0.670693039,1.01765518,0.370059239,0.104737317,1.23593,0.0,1.55338232,1.51258684,0.219527842,1.5512695,2.16728415,1.15205776,1.89792064,2.14905708,2.20545432,2.16781004,1.18917395,1.4203317,1.20054445,1.40608011,1.00609667,0.621098021,0.730434615,1.26816216,0.7229359390000001,1.63514249,1.01664658,2.3174782000000005,2.07151213,1.56330225,2.61429336,0.998614563,0.8570334000000001,1.20925917,1.01995625,1.33172737,1.15764693,1.05160959,0.0,0.0,1.65427745,0.6128863529999999,0.541243547,0.8808566879999999,1.21962211,1.65194902,1.71990243,2.99061944,3.17204616,2.51934873,2.61912352,3.06580709,2.65269917,2.7807626,1.03588138,0.649043438,0.0,0.6625057679999999,0.0,0.0,0.0,0.0,0.0,0.752394615,0.22703944,0.42681929700000004,0.0,0.0,0.0,0.539311685,0.191442316,0.0,0.0,0.33579415,0.0,0.0,0.641548618,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.031704371,0.25039643899999997,0.261033105,0.190942621,0.0,0.0,0.0,0.0,1.04328525,0.0,0.440458085,0.06456645009999999,0.57617345,0.0,0.0,0.0,0.8088451809999999,0.146974689,1.12312963,1.14415496,0.531188872,0.0531906295,0.0,0.0,0.168830817,0.0,0.0,0.0,0.0,0.341987132,0.615745859,0.804846326,0.986600956,0.0161914313,0.628371233,0.23839517600000001,0.0,0.0,0.0,0.43555595700000005,0.0,0.79494997,0.460795678,0.0,0.115702582,0.0,0.40394009999999997,0.41788904,0.47660597,0.0,0.0,0.750044997,0.495885361,0.0,0.0,0.09933624320000001,0.0,0.0,0.0,1.10483927,1.61260076,0.0,0.824465173,0.8987146509999999,1.84413482,0.877745775,1.20463586,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.552710472,1.29594431,0.572595008,1.37668456,0.449544419,0.62075235,0.557765673,0.257702675,0.157358569,0.855634681,0.8273532090000001,1.23112598,0.9429452429999999,0.0,0.0,0.0,0.0,0.372609818,0.0,0.0830693971,0.0781412725,0.0,0.257842197,0.0,0.0,0.586982917,0.311441425,0.0,0.0248534795,0.0,0.0,0.029540978399999997,0.41420447299999996,0.0,0.0,0.488017152,0.0,0.0,0.181246181,0.0,0.0,0.0,0.409416555,0.0,0.0,0.10315933199999999,0.20570354,0.34418851200000006,0.382620061,0.8236485370000001,0.9275639940000001,0.42740810799999995,0.0,0.0,0.000854968434,0.49442693600000004,0.706175433,0.34853757700000004,0.8301655059999999,0.0,0.390888222,1.31865178,2.64454412,4.25759837,5.0589086,5.25004161,5.40936104,3.5311953000000003,3.04592749,2.68390963,1.46918065,2.22697148,1.91748077,1.2461275,1.14888083,0.835158823,1.15136356,1.50531455,1.22998425,2.28962366,2.27556065,1.57737615,0.995652344,0.22386825300000002,0.0,0.0,0.15908478,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.24698256,13.61687866,1.21418517,0.27703781,1.9045258999999999,1.39298013,1.55417469,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
1.0134752,0.803206765,0.837445375,0.47589236100000004,0.0,0.436329611,0.0,0.794160998,0.0,0.0,0.0,0.0,0.0,0.0,0.158096273,0.0,0.0,0.799451645,0.0,0.0760721144,0.373352471,1.31045819,0.0,0.135962184,0.825574347,0.512401192,0.00114970449,0.14692218599999998,0.0,0.23880489300000002,0.070304173,0.0,1.79342176,0.898763355,2.29513692,2.44707902,2.66291432,4.03116637,3.73834093,3.74939714,3.21640758,0.9366240570000001,2.44346135,1.52289314,1.69071531,1.31814291,1.15260458,0.856402742,0.285229609,0.0,0.115318666,0.0,0.29927874,0.0,0.0,0.021619422200000002,0.415121731,0.43327494899999996,0.0,0.507341234,0.979816129,0.0,0.0,0.11385218,0.2556928,0.244543302,0.0,0.333610674,0.0,0.0,0.978501112,0.0,0.280277648,0.044321223099999994,0.756065862,1.37001679,0.30165899399999996,0.224529229,0.258565193,0.0,0.426037506,0.364336583,0.0,0.0,0.055136480999999994,1.07244846,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.074337513,0.144591973,0.5506359439999999,0.380759505,0.620286564,0.466280821,0.79626197,0.836646505,0.46624572,0.667238114,0.21329942699999999,0.303419893,0.12812390699999998,0.0,0.0,0.15637314900000002,0.0,0.0,0.0624674195,0.880522655,0.657214557,1.25984223,1.21887175,1.63713521,2.05437652,2.32432993,2.14399506,2.94717694,2.79398019,2.77213115,2.87054832,2.86486203,2.8467624,3.33357449,2.94414787,2.94305536,2.48211467,2.45318866,2.37344925,1.97830682,2.04786981,1.92268333,1.63328847,1.52319623,1.74481312,1.94480948,2.26193541,2.0563747,2.68211136,2.34789237,2.33757505,2.33713485,2.53286373,2.48232346,2.07014008,1.74761736,1.2985646999999998,0.9139183240000001,0.253373575,0.329284753,0.0,0.0,0.0,0.0,0.0,0.0844934408,0.108184583,0.453626996,0.607130773,0.7557633220000001,0.549565496,0.770788334,0.8114026759999999,0.6855897009999999,0.595099888,0.00361711561,0.132018909,0.0,0.0,0.0,0.0,0.0,0.0306598073,0.050860522699999994,0.35561586100000003,0.484723711,0.46605134600000003,0.49073075200000005,0.296579783,0.0,0.0,0.17192163100000002,0.0786627105,0.0,0.164128057,0.0,0.32162139300000003,0.0,0.15012721199999998,0.005888371629999999,0.015880691000000002,0.230424994,0.49709323899999996,0.0,0.0,0.0384367412,0.0,0.0,0.0,0.0,0.0,0.286126092,0.461352155,0.712333414,0.961426896,1.22547568,1.79987711,1.49883872,1.72735458,1.53415686,1.60822968,1.30861327,1.04246006,0.783341759,0.406290096,0.510513894,0.0,0.0,0.0,0.0,0.0,0.0,0.053428114400000004,0.0,0.0735310229,0.401164788,0.218541134,0.284404974,0.21560748,0.0917220634,0.17674474,0.219440883,0.0,0.046631669,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0477049212,0.0421140661,0.160543217,0.0,0.0,0.0,0.0,0.11006863800000001,0.0,0.0,0.0759851805,0.14097468,0.0,0.0,0.0,0.0,0.0,0.0682368607,0.024560462400000004,0.252473348,0.0,0.0,0.0,0.0,0.0493308046,0.0,0.24297032,0.0,0.158417169,0.0,0.0,0.33196513699999997,0.0032442764,0.0,0.112779215,0.0253419177,0.0629913906,0.0,0.0,0.0,0.0,0.0330783769,0.27428887399999996,0.0,0.0,0.37101826200000004,0.291407255,0.347176992,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0303413256,0.0,0.278497982,0.0,0.0,0.0,0.236669393,0.0,0.0,0.0,0.0,0.118029485,0.0,0.0,0.044028062800000003,0.0,0.0,0.0,0.27693711600000004,0.08539990609999999,0.144054011,0.033918729700000004,0.0703251317,0.0,0.024486508900000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.240743281,0.0,0.187356601,0.0,0.171025917,0.0,0.135247067,0.0,0.99381791,2.39014119,0.998431893,0.34154730299999997,0.9219810959999999,2.01895793,2.74877705,2.52155671,0.18736126,1.30844996,4.90002322,5.09277566,4.40047448,3.15943777,4.07665107,2.42701801,0.32849213,1.39092917,1.88317523,3.31010934,1.2250914,0.278155499,0.9205158290000001,0.0,0.0874490876,0.0,0.45457956200000005,0.757124969,0.6628399660000001,0.620726449,3.24253762,2.43370787,1.42227608,3.43325146,0.6643710070000001,1.21425713,1.33020788,2.6058012,3.98701813,0.13372546800000001,0.86176762,0.476878429,0.6879070079999999,0.6890823629999999,0.0,0.47219777,0.0,0.22657406300000002,0.0,0.189515359,0.6254857739999999,0.0591555829,0.26108198899999996,0.0,0.281787947,0.0,0.0750050618,0.0186168579,0.0,0.231178844,0.0,0.33539286100000004,0.0,0.106055525,0.0,0.0,0.07389050259999999,0.0,0.16916391,0.0,0.16562439,0.0,0.261150122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
1.52893624,0.0,0.0,0.0,0.0,2.69434915,0.0,1.11461539,0.0,0.0,0.0,1.62479037,4.82444533,4.415570400000001,6.60220958,5.94528098,2.29420611,1.93804587,0.0,0.0,0.0,3.40896779,0.57780791,1.08794351,0.0,0.63899401,0.0,0.0,0.0,0.668884901,0.0,1.81451628,0.0,0.0604725599,0.0,1.36513007,1.22559555,1.21558906,0.80510412,0.0,0.743354025,0.664207951,0.0,0.0,0.0,0.238153124,1.774032,0.433511725,0.551443958,0.579577343,0.297687103,0.619423562,2.37612093,0.742978742,1.94897703,0.246748356,0.0,0.0,0.11735436699999999,2.43606398,1.99971176,1.0395129,2.77300673,1.76162638,2.10390547,0.0,0.0,1.39611504,0.0,0.0,0.0,0.0,0.0,0.45922544200000004,0.0,0.08695231449999999,2.37593342,0.0,1.88451036,0.263597697,1.74916929,1.76857107,0.0,0.0,0.8860739209999999,0.0,0.0,0.0,1.02075062,0.594746288,0.0,0.770334381,0.0,0.0,1.30654407,0.0,0.0033884065500000005,0.0,1.51693921,1.09946715,0.0,0.0,0.321531702,1.17708554,0.0,0.0,0.0,0.0,0.746785072,0.618935015,0.653654245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.698329929,0.0,0.19929154699999999,0.0,0.413442559,1.0942018,0.021271685499999998,0.846658992,0.325104656,0.0,0.0,0.0,1.41932697,0.949699993,1.20619834,0.0,4.41937282,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.760062522,0.0511700708,0.801977955,0.158012803,0.0,0.705918705,1.05981703,0.0,0.26787235600000003,2.41084829,1.80547992,3.94095177,0.0,1.07832345,3.00316947,0.0,0.0,0.0524905159,0.32753844600000004,1.58044981,3.08238544,0.616157339,0.0,2.58129171,2.13460291,0.0,0.406055622,0.772503196,0.0,2.76339575,0.0,0.0,0.20585872,2.90240896,0.25506004600000004,2.80236514,0.0,0.0,1.84494615,0.0,0.0,0.400231593,0.94852937,0.0,0.0,0.0,2.18950464,1.30233231,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
0.95619578,2.09379437,1.06627205,0.2818005,2.37911174,0.43800935,0.55218742,0.0,0.0,0.0,0.0,0.0,0.0,0.3395224,0.08098013,0.0,0.0,0.0,0.89227116,0.0,0.0,0.22915655,0.57467518,0.0,0.0,0.0,0.78140846,0.0935551,0.0,0.0,0.89001453,0.0,0.0,0.0,0.25809293,0.0,0.0,1.15851255,0.0,0.0,0.68151256,0.0,0.0,0.0,0.0,0.5656316,0.0,0.0,0.67179122,0.04010193,0.0,0.80699956,1.9668442,1.21868306,2.66314968,2.43151367,0.0,0.0,0.0,2.33006142,3.68968128,5.36964322,3.52517889,3.16613049,2.34495895,0.0,0.35266248,1.0225971999999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.42453076700000003,0.46231514799999995,0.0,0.497880876,0.5197271489999999,0.453197229,0.0,0.0,0.436568014,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.610165204,0.0,0.033806433500000004,0.0,1.48728408,1.41833752,1.82997726,1.63350292,0.367497594,0.0,0.608281328,0.9109629570000001,0.280335734,0.0,1.98409295,6.11342468,6.80139796,3.39060696,0.532652401,0.0,0.279805535,1.43454369,0.8635511709999999,1.51553218,0.66722314,0.0,0.6614606120000001,2.85156453,2.39869886,1.25058859,0.0,0.0,0.41496976399999996,0.630294725,0.533187403,0.0,0.7325020879999999,0.65158253,0.0,0.0,0.50319776,0.0,0.0,0.0,0.871874484,1.32983771,0.9789267779999999,0.393838924,0.50824778,1.20131377,1.00839158,0.0,0.058213237599999995,0.0,0.7670991159999999,0.0,0.335937914,0.0,0.314930665,0.46140738600000003,0.0343655521,0.48996201,0.533192924,0.0,0.0969380678,0.0,0.0,0.0,0.114990953,0.584069231,0.0,0.6276619920000001,0.390677007,0.0166999154,0.0,0.570376042,0.7743825209999999,0.0758151897,0.28318660100000004,2.31144409,1.62504662,0.5206350710000001,0.7041128870000001,0.0,0.0,0.0,0.19219036,0.0,0.0,0.306838293,0.0408561359,0.0,0.246717292,0.307479371,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.524342547,0.0,0.915628422,0.0809194331,1.18946263,2.18516003,4.73700666,5.22800965,4.77052662,2.26205576,0.914269983,0.0,0.0,0.53181561,0.11299743,0.45943404200000004,0.0,0.0,0.30722414,0.360112055,0.0,0.0,0.10074748800000001,0.442213652,0.197582683,0.0,0.0,0.196080891,0.0,0.0,0.16230376,0.05847004099999999,0.0,0.0,0.0,0.0,0.016842286,0.0,0.0,0.49570252299999995,0.0,0.0,0.49290433100000003,0.0,0.0,0.0745104707,0.0,0.500367581,0.227965232,0.47882430600000003,0.63770832,0.7546558170000001,0.328091683,0.384310085,0.0153870277,0.378715751,0.307771982,0.0,0.20507315,0.0099505991,0.0,0.0,0.182858209,0.0,0.0,0.0,0.0,0.163108985,0.39022540299999997,0.0,0.324516257,0.49345623299999997,0.0700947073,0.0,0.41851797,0.0,0.0,0.0,0.9816195040000001,0.469306095,0.305384806,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
16.285901000000003,0.61160202,0.402926735,0.114224399,0.0,1.22767555,0.519124797,0.0,0.7344951740000001,0.0,0.0,0.0,0.0,0.644149912,0.60567802,0.0244881306,1.13824793,0.7730882590000001,0.0,0.0,0.0584551362,0.16476659,0.271830595,0.0,0.0,0.771867305,1.30990401,0.976676687,1.56893079,0.0,0.0,1.5217046,0.0,0.31576882300000003,0.989143786,0.437418068,1.25696666,0.0,1.44537476,0.0,1.10187005,0.0,0.697463061,0.0,1.50938774,0.0,0.8472695159999999,0.0,0.0,1.16012048,0.39039455100000003,0.0,0.0,0.83141687,0.413125888,0.0,0.0,0.0,0.0,0.0,0.0,1.12125873,0.0,0.0,0.450668774,0.0,0.0,0.0,0.0,0.258890191,0.728162138,0.0,0.0,0.149360091,1.48735215,1.44824499,0.21562901199999998,0.0,1.35387212,0.0,0.0,1.39217278,0.0,0.22629962,0.0,0.44165656799999997,0.486054605,0.47922552399999996,0.0,0.0,1.54627387,0.0,1.33191699,0.0,0.48659863,0.180375958,0.0,0.0,0.0,0.0,1.56017225,0.0,0.601626222,0.0,0.604126017,0.0,0.0462046274,1.30446943,1.26589708,0.857245962,0.0,0.459755274,0.0,0.0,0.372120513,0.0,0.0,0.0694320545,0.0,0.0,0.0,0.0,1.13201951,0.0,0.235242592,0.0,0.0,0.699180714,0.0401607226,1.38653297,1.44621689,0.6400166820000001,0.0,0.0,0.0,0.517182657,0.18274026699999998,0.0,1.4614341999999998,0.0,1.11237885,1.36024504,0.0,0.0,0.0,0.34969039399999996,0.0,0.0,1.17762981,0.0,0.0,0.0,0.42162826,0.0,0.0,0.0,0.0,0.00468267896,0.0,1.48058174,0.0379709133,0.891130448,0.0,0.52925818,1.58654898,0.0,1.51700229,0.718037412,1.27802072,0.0,0.0,0.18913238,1.11473129,0.724698877,1.14553477,0.0,0.482891167,0.0,0.0686925149,0.0,0.39785921,0.7648047729999999,0.0,0.0,0.0,0.32229014899999997,0.0,0.0,0.0,0.39915390799999995,0.0,1.19911926,1.12264819,1.38088007,0.0,0.5850729729999999,0.0,1.42761676,0.0,0.27900835,0.31674465,0.0,1.35401087,1.19133,0.0,1.18029617,1.52623618,0.0,0.0186027096,0.0,1.21162512,0.465021646,0.0,0.0,0.397686483,0.677070347,1.17403738,0.0,0.931252449,0.0,0.7497239290000001,0.500374261,0.0,0.0,1.43855295,0.0,1.19881658,0.453542791,0.0,0.0,0.0,1.27945621,0.0,0.403533994,0.0,0.0,0.624593473,0.604626831,1.06563993,0.0,0.97183548,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.405
1.67089422,1.1517623,2.7237762,17.75501089,3.6797568999999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.461
8.60622157,5.52037704,2.03427209,0.0,0.0,0.0,0.19179607399999998,1.05336425,1.13896772,0.590996373,0.0,0.0,0.559678511,1.57500685,2.34848766,2.374908,1.57933604,0.356973356,0.0,0.0,0.0,0.029885097599999997,0.627314633,0.7391754429999999,0.35787552100000003,0.0,0.0,0.0,0.0,0.31805805800000003,0.525161254,0.36727551399999997,0.0,0.0,0.0,0.0,0.155188567,0.44321999,0.472219303,0.255822508,0.0,0.0,0.0,0.0178104133,0.209436979,0.254520136,0.12286515699999999,0.0,0.0,0.0,0.0,0.141288346,0.22705756600000002,0.15510632,0.0,0.0,0.0,0.0,0.0727067964,0.181703328,0.162520795,0.0343508316,0.0,0.0,0.0,0.0169030478,0.130899934,0.15002111699999998,0.0669937043,0.0,0.0,0.0,0.0,0.0880879105,0.171254624,0.243442577,0.383421677,0.678084302,1.14726043,1.69863361,2.14928883,2.30995697,2.08709217,1.54274219,0.8734401829999999,0.31534124,0.026423356000000002,0.0116246424,0.133809341,0.20521125899999998,0.107977434,0.0,0.0,0.0,0.240379495,1.0948135,2.08983539,2.89391156,3.22071062,2.95984044,2.22619887,1.30361821,0.512087532,0.0658882417,0.0,0.149963215,0.323198447,0.348579025,0.19305273899999997,0.0,0.0,0.0,0.0,0.10448419999999999,0.22082052,0.18306535899999998,0.022591554700000002,0.0,0.0,0.0,0.0400211101,0.184478475,0.201450902,0.07890517650000001,0.0,0.0,0.0,0.0,0.155148025,0.22432326800000002,0.138012865,0.0,0.0,0.0,0.0,0.114977392,0.236779333,0.193875734,0.0164202781,0.0,0.0,0.0,0.254014797,0.48069871700000005,0.500263396,0.295317443,0.007211733879999999,0.0,0.017228123300000002,0.49771144700000003,1.15465337,1.78367686,2.25265829,2.57364506,2.86348472,3.22136217,3.61469497,3.8648716,3.75665085,3.20354759,2.35073249,1.52770098,1.06134929,1.06264007,1.33401217,1.47840294,1.1596128,0.352025708,0.0,0.0,0.0,0.0,1.02835959,1.49013049,0.915258538,0.0,0.0,0.0,0.0,2.19683676,5.97174858,8.9688049,9.97120973,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.469
0.7936137659999999,0.0,1.9722401999999999,0.0,0.512587039,0.628256626,0.0,1.27425875,0.0,1.09230004,0.637132119,0.0,0.0,0.0,1.28073449,1.71741018,1.25159362,0.0,0.0,0.0,0.0,1.39663128,1.48018864,0.0,0.25228331,0.0,0.0,1.22693458,0.0,0.0,0.0,0.74338875,0.0,0.0,1.35126259,0.0,0.32845941,1.68454803,0.0,1.54144992,0.566520284,0.276362532,0.0,0.185952311,0.450261714,0.0,0.0,0.0,0.0,0.808648514,0.0,0.60534398,1.00545836,0.0,0.0,0.0,0.0,0.0,0.0,2.04897145,0.0,0.0,0.0,2.05595618,0.0,0.0,0.7228861059999999,0.0,0.0,0.47416629600000004,0.0,0.0,0.0,0.0,0.6871642570000001,0.0,1.73960974,0.0,0.0,0.0,0.0,1.3292855,1.79202585,0.0,0.00149964777,0.975430468,0.505631326,0.0,0.0,0.0,0.0,0.328563772,1.93870206,0.0,1.51389666,1.58655714,0.0,0.353460669,0.943996857,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.09276403,0.0,1.22143966,0.0,0.0,0.0,0.0,0.0,0.18882141800000002,0.0,0.0,0.538129461,0.954025275,0.0,0.554232967,1.57703245,1.04162134,2.02750084,0.8209079459999999,0.055251297000000005,0.0,0.0,1.81052991,1.25061367,1.92241655,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.30854754100000004,0.0,0.0,0.909321718,0.0,2.0580421,0.0,0.0,0.0,1.30662798,0.0,0.859650373,1.54798961,0.288078705,1.39038565,1.91446927,1.08960363,0.0,0.859172954,0.321258348,0.195339225,0.73532389,0.0,1.47840638,0.0,0.521904532,0.0,0.0,0.0,1.04261184,0.0,1.9480843,0.060559069199999996,0.0,0.0,1.81335917,0.0,0.0,1.19760309,0.0,0.27368633,0.618740025,0.0,1.05375223,1.60459096,0.128057751,0.0,1.82141069,2.08232246,0.0,0.0,1.23593889,0.40339123299999996,0.0,0.186460834,1.90521753,1.5663113000000002,0.0,0.0,0.6616093239999999,0.0,0.27371751,22.3059608,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47600000000000003
0.0188657005,0.0,0.147303165,0.522172193,0.68325178,0.349916502,0.0,0.0,0.24363207399999998,0.27530286800000003,0.10443128,0.130936854,0.37024693299999994,0.46185815,0.272167559,0.0387278672,0.0,0.00966694888,0.0208748156,0.0,0.0,0.0141143473,0.012010038899999999,0.0,0.0,0.0225116079,0.00491431152,0.0,0.000965869654,0.0320374186,0.0,0.0,0.0195219199,0.0377669423,0.0,0.0,0.0495141618,0.033540344,0.0,0.043099098200000005,0.34214950299999997,0.468608735,0.324931456,0.18602882899999998,0.152132595,0.0808720195,0.0,0.0166815534,0.0318657388,0.0,0.0,0.0629754703,0.030790384,0.0,0.0,0.11463157300000001,0.0,0.0,0.0475644731,0.171578347,0.0,0.012637846299999998,1.18755909,2.54447601,2.79421298,2.06933557,1.19214499,0.300726879,0.0,0.40256495299999995,2.48528307,3.80902356,2.85017983,0.928442764,0.0740295971,0.213301269,0.159422471,0.0,0.0,0.130164215,0.0456289539,0.0,0.0,0.0970401882,0.0,0.0,0.0233355891,0.0604263483,0.0,0.0,0.0344847316,0.0276716589,0.0,0.0,0.0381008433,0.0519860701,0.049026078099999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.325049502,0.566107962,0.0,0.0,0.508077361,0.16225763699999998,0.0,0.166325568,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0549614805,0.0339854193,0.0,0.534246611,0.0,0.0,0.0920959465,0.0,0.0,0.0,0.216205968,0.0,0.0,0.0445288093,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0766932086,0.167495915,0.160296307,0.35324710299999995,0.0,0.651931182,0.775314782,0.433701777,0.0,0.0,0.430540955,1.05911302,2.34471785,3.31917022,5.10575943,5.22417909,5.01161711,4.19262342,3.76583191,2.1901495,0.235469231,0.190411451,0.0,0.0,0.265843935,1.1096278999999998,0.811377734,1.93171681,2.03682243,2.56287191,3.22165404,3.45869289,4.44613974,4.14033001,3.59650562,1.85096033,1.70361806,0.6760168679999999,0.0,0.0,0.0,0.331649441,0.649783192,0.387487584,0.606952045,0.433373095,0.0,0.18598669899999998,0.29134809,0.497995069,0.0,0.268225237,0.240981025,0.423716539,0.18994889,0.0,0.0,0.0,0.0870160531,0.49096105700000003,0.484684766,0.130865077,0.0,0.0,0.0,0.329360523,0.510292918,0.524155195,0.0,0.212624762,0.0,0.16096917800000002,0.46020111,0.431942124,0.46998059299999995,0.202651903,0.746094079,0.0,0.61803955,0.608039035,0.383786357,0.70066652,1.17989174,0.892238025,0.5478464670000001,0.165605206,0.0,0.0,0.0374342837,0.0,0.178177823,0.28420006800000003,0.47906450899999997,0.0,0.418083871,0.0,0.0201429544,0.16148648300000001,0.229205737,0.0,0.0,0.443471026,0.0,0.284273271,0.0,0.0,0.0,0.0,0.249761565,0.111184152,0.486328894,0.231890298,0.186541266,0.219264874,0.0,0.36415807200000005,0.0,0.10976091199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.191821728,0.344075405,0.0,0.48408559999999995,0.0,0.0,0.0,0.0,0.24219069,0.1114539,0.44050517100000003,0.0,0.0,0.0,0.592607291,0.0819003918,0.618302378,0.17247074199999998,0.9500565940000001,0.24381759600000003,0.6879181529999999,0.585557939,0.11782030800000001,0.0,0.0,0.274199566,0.28319484100000003,0.726185535,0.653127834,0.342655937,0.532303026,0.0,0.104025044,0.0,0.0,0.0,0.053219612699999995,1.18812428,1.40344454,1.13091241,1.03072002,0.753256377,0.0,0.19684790600000002,0.0,0.164979171,0.0,0.0751356724,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.0740297346,0.15328329,0.227004066,0.293807896,0.35253024,0.402239468,0.442245018,0.472100405,0.491601169,0.500777971,0.499885102,0.489384812,0.46992789,0.442331039,0.407551616,0.366660356,0.320812741,0.271219653,0.21911799699999998,0.165741904,0.112295152,0.0599253597,0.009700471700000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0143585694,0.0328242946,0.0486002476,0.0614642587,0.0712942385,0.0780669914,0.0818543147,0.0828165558,0.0811938617,0.0772954112,0.0714869695,0.0641771416,0.055802732199999996,0.04681363559999999,0.0376576884,0.028765910699999998,0.0205385496,0.013332311299999998,0.007449132240000001,0.00312679678,0.0005316558069999999,0.0,0.000803715993,0.00361380484,0.00803923763,0.0138636002,0.020805876,0.028529672000000002,0.0366542713,0.044767204000000005,0.0524379838,0.0592326232,0.0647285165,0.06852926620000001,0.0702790237,0.0696759265,0.06648423,0.060544764800000005,0.0517833887,0.0402171505,0.0259579423,0.009213476690000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0175401489,0.0629348335,0.10974938599999999,0.15692571,0.203336023,0.24780654300000002,0.289143303,0.32615958300000003,0.357704371,0.38269125600000004,0.40012710700000004,0.409139886,0.409004948,0.39916918100000004,0.37927239799999996,0.349165409,0.308924259,0.258860229,0.19952520199999998,0.13171217300000002,0.0564507065,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0374266746,0.235405955,0.45013238899999997,0.679542442,0.921282175,1.17273954,1.43108179,1.69329735,1.95624149,2.21668501,2.47136495,2.71703665,2.950526,3.16878109,3.36892225,3.54828952,3.70448681,3.83542178,3.93934083,4.01485842,4.06098036,4.07712034,4.06310978,4.01920045,3.94606004,3.84476066,3.71676056,3.5638793,3.38826697,3.19236792,2.97887973,2.75070819,2.51091906,2.2626876,2.00924666,1.75383443,1.49964267,1.24976642,1.00715606,0.7745725590000001,0.554546705,0.349343004,0.160928827,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
1.55236201,1.75384119,1.94265065,2.09885892,2.18928963,2.17416341,2.01860547,1.70601814,1.24920482,0.695188501,0.121009505,0.0,0.0,0.0,0.0,0.0,0.0775585972,0.517504364,0.823572031,0.8971548109999999,0.696067908,0.251193674,0.0,0.0,0.0,0.0,0.0,0.0,1.17565478,2.55995151,3.8932559,4.94640546,5.53499944,5.55823485,5.019545,4.02437305,2.75587508,1.43457006,0.271631033,0.0,0.0,0.0,0.0,0.0,0.0475703241,0.40764820799999996,0.602155003,0.615832454,0.485742027,0.28256915,0.08542180810000001,0.0,0.0,0.0,0.12114267,0.251143916,0.339801796,0.360438624,0.315544625,0.235367153,0.167242671,0.159235722,0.24329047199999998,0.42314998,0.670788798,0.932518697,1.14304577,1.24342496,1.19773968,1.00372768,0.694335233,0.329776799,0.0,0.0,0.0,0.0,0.0,0.0,0.08448096880000001,0.23430080399999997,0.300735802,0.273430773,0.169141218,0.0247821092,0.0,0.0,0.0,0.0,0.0,0.0259769024,0.127628703,0.18458375600000002,0.183139235,0.127634171,0.0379988911,0.0,0.0,0.0,0.0,0.0,1.11250998e-15,0.0745084015,0.12233858800000001,0.130933375,0.100136791,0.041493174,0.0,0.0,0.0,0.0,0.0,0.0,0.0417064738,0.0802667713,0.0925430772,0.0765676494,0.0389187262,0.0,0.0,0.0,0.0,0.0,0.0,0.0205849625,0.049501742,0.0616076038,0.05457205,0.031958706600000004,0.0017103462300000001,0.0,0.0,0.0,0.0,0.0,0.0077552644200000005,0.027014757799999997,0.0365179577,0.0344036888,0.0224240318,0.0050387539899999995,0.0,0.0,0.0,0.0,0.0,0.0018472023899999998,0.0193740024,0.0381444757,0.0589932998,0.0841849576,0.11652949300000001,0.158238378,0.20990277100000002,0.269905059,0.334408695,0.397879186,0.453941818,0.49632687200000003,0.519697611,0.520266463,0.49622144799999995,0.448049441,0.37882241,0.294415961,0.203504906,0.117098521,0.04740179480000001,0.0059447613,0.0011823928999999999,0.0360524921,0.106179224,0.199424328,0.29726393,0.37802987299999996,0.421504883,0.413861727,0.351658853,0.243673444,0.10979776699999999,0.0,0.0,0.0,0.0,0.0,0.0,0.08556014449999999,0.164942249,0.19633410199999998,0.168607586,0.0872441914,0.0,0.0,0.0,0.0,0.0,0.0,0.153600609,0.39229067100000004,0.645374558,0.893315289,1.12631807,1.34427281,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
1.14191943,1.07673116,0.486286745,1.79841452,0.626531324,1.76237763,2.27373082,1.45336422,1.40143751,1.44792482,1.12342135,0.584044485,0.0,0.0,0.0,0.130615065,0.504640005,0.0,0.0,0.0,0.0,0.0,0.30468061,0.0,0.0,1.07459622,0.464320392,1.52121097,2.68428026,2.50012548,3.89897641,4.20918312,3.40861347,3.85087819,4.246656099999999,1.64363315,0.58836386,0.500527038,0.0,0.0,0.29864943899999996,0.0,0.0,0.0,1.58987829,0.0,0.526960412,0.0,0.0,0.0511727036,0.0,0.0,0.007231785909999999,0.0,0.0,0.334670309,0.23078601,0.0,0.709835067,0.29092481800000003,0.328648877,0.0,0.765351195,0.0,0.0,0.8390664259999999,0.7036247409999999,1.4344453000000001,2.00392553,0.0,0.0,1.2033738,1.44688176,0.669852326,0.621092405,0.0,0.0,0.0,0.254832369,0.0,0.0,0.0,0.0,0.273653388,1.38386295,0.594957882,1.08284301,0.0,0.408116816,0.0,0.0,0.831562006,0.8523516240000001,0.0,0.6978664000000001,0.0,0.0,0.0,0.0,1.26980683,0.0,0.0,0.0,1.58320872,0.0,0.0,0.7687731179999999,0.523208398,0.205659289,0.0,0.0,0.27604413899999997,0.305852482,0.0,0.719611518,0.0,0.0,0.148775678,0.398882929,0.34863290799999996,0.0,0.29339446199999997,0.7191675240000001,0.0,0.876388849,0.0343938787,0.0,0.0,0.5573987779999999,0.0,0.322270196,0.0,0.581919149,0.0,0.839117455,0.0,0.0,0.276495267,0.0,0.0,0.0,0.338301474,0.410487878,0.0637505832,0.0,1.63669446,0.011487501899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.26704475699999997,0.0,0.0,0.0,0.0,0.0,0.622484378,0.0,0.0,1.50822928,0.290032479,0.0,0.0,1.68257803,0.0,0.321382069,0.403829771,0.457699942,0.0,0.363558008,0.0,0.0,0.0,1.08640567,0.0,0.0,0.0,0.3443079,0.0,0.0,0.0,0.0,0.9698209990000001,0.0,0.0,1.3139343,0.0,0.199860185,0.0,0.572170224,0.0,0.0,0.0,0.0,0.799519138,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.0800171092,0.0,0.301062851,0.298094084,0.0,1.05903891,1.03310288,1.21697325,0.983858951,0.43843255799999997,0.374878206,0.474872709,0.0,0.347231135,0.0,0.0,0.0,0.0,0.0,0.251920247,0.0,0.0,0.339545499,0.0,0.577878644,0.0,0.18527757,0.0,0.48311301100000004,0.460989252,0.0,0.0,0.0,0.345927967,0.0,0.346053812,0.374125107,0.158678506,0.738266505,0.68900743,0.733552298,0.0,0.257280004,1.04394679,0.0,0.867862528,0.43172684,0.0,1.7275531000000002,0.7467904000000001,0.8814369590000001,0.573572113,0.167427673,0.663292169,1.43025439,1.22464009,0.0,0.0,0.0,0.0,0.0,0.09097629119999999,0.0182928019,0.19397195399999997,0.201953301,0.0,0.0,0.0122393898,0.0,0.6260676629999999,0.21987019300000002,0.0,0.0,0.0,0.106829295,0.0,0.0,0.0,0.0,0.589556164,0.0,0.0,0.159337387,0.961013267,1.58506037,0.379036569,0.0,0.0,3.14015752,6.18378235,7.77829909,5.34558387,1.32281025,0.0,0.0,0.812596634,0.426722518,0.687198104,0.345594977,0.0,0.483634898,0.17219691199999998,0.0,0.0,0.0,0.46962899,0.81517435,0.215825402,0.610026909,3.61838299,3.42363574,3.0290091,1.05544461,0.465707683,0.0,1.20209457,1.02097384,0.549768932,0.144310056,0.750189762,1.46871539,0.7841381409999999,0.0,0.0,0.0,0.334271986,0.433925017,0.0,0.0,0.0,0.0,0.35251836,0.0,0.428704301,1.03170439,0.390905445,0.0203680525,0.021084499,0.0,0.7477441090000001,0.475399752,0.5211150179999999,0.0,0.0,0.12925192900000002,0.698954376,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45399999999999996
0.0170176568,0.0390794883,0.20431674100000002,0.46481782299999996,0.707637435,0.830788066,0.80876084,0.700192356,0.5964452889999999,0.553808536,0.560144217,0.555896143,0.48688010200000004,0.34606970000000004,0.176440252,0.0403886183,0.0,0.0217173567,0.14023285,0.31188339800000003,0.499002985,0.655487244,0.7368230920000001,0.721768498,0.629498856,0.5097016529999999,0.402944724,0.301485365,0.154329508,0.0,0.0,0.0,0.16740116,1.20267892,2.62560232,3.94744608,4.58668692,4.19270354,2.88764121,1.24991643,0.015456506299999999,0.0,0.143961957,0.9391832529999999,1.41307314,1.23528132,0.587908811,0.0194580277,0.048075912,0.7895361759999999,1.86709854,2.66269281,2.73123044,2.08998383,1.18852616,0.591592105,0.6038732520000001,1.09455367,1.62687345,1.7806787,1.43128412,0.7988002909999999,0.25986671100000003,0.0810907845,0.270093409,0.630573051,0.9467001979999999,1.13555085,1.25389249,1.37877287,1.48700003,1.45180047,1.16564298,0.680491449,0.23088961100000002,0.095886345,0.391333079,0.953807195,1.42036692,1.46348661,1.01817489,0.33478044,0.0,0.0,0.0673210935,0.518092557,0.730011918,0.54013486,0.0795415706,0.0,0.0,0.0,0.35812741,0.74932895,0.8559058829999999,0.681013353,0.37938219700000003,0.12575429400000002,0.00375914277,0.0,0.020175224,0.0670545432,0.152879682,0.300053537,0.47244497700000004,0.57334533,0.511588637,0.282902284,0.0,0.0,0.0,0.0,0.122111657,0.18384075,0.0933027059,0.0,0.0,0.0,0.0179000536,0.139797835,0.143282265,0.0277373898,0.0,0.0,0.0,0.07436531980000001,0.15972509699999998,0.11232675,0.0,0.0,0.0,0.0,0.181718844,0.314364611,0.31171873699999997,0.206288217,0.0965028833,0.06418022849999999,0.11221544300000001,0.17141131,0.16773231800000002,0.09250610869999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
2.5377978,3.0080851,3.03537535,2.52286055,2.47283474,2.43412632,2.76823477,2.33954853,2.51532795,2.43416415,2.05154911,1.7804671000000003,2.03481872,1.53432047,1.50269332,1.10305465,1.07845736,1.14393652,0.87507275,0.49663844,0.72688196,0.24888019,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20888041,0.3966637,0.30345465,0.5986382,0.60403989,1.08255644,1.0224671,1.06882941,1.49569238,1.43379961,1.77667738,2.18619841,1.85175572,2.38902206,2.58975683,2.23322503,2.3021771,2.40227526,2.4300203,2.95356053,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
1.58703684,2.14317587,3.69751569,1.24119902,0.17194984600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.662119644,0.0,0.0,0.836626227,0.0,0.8157177309999999,0.0,0.0,0.0,0.0,1.25607297,0.581453482,1.78408037,0.0,0.417329447,0.8570761640000001,1.30670985,1.47166773,0.0,0.231952945,1.45044817,2.41157419,1.97679673,1.28714454,0.6849189590000001,0.17198378399999997,1.27065511,0.0,1.48662574,1.61424493,0.409854031,0.0,0.652797065,0.808187975,1.00884984,1.02943659,0.0,0.831198456,1.18299178,0.0,0.0,0.0520348583,0.497143548,0.0,0.444451555,0.0560844793,0.0,0.0,0.276189434,0.8661175609999999,1.09848802,1.04257893,1.12312234,1.3152536,1.10603599,0.371144165,0.0,0.0,0.0,0.969354913,1.9411054,2.9274197999999996,1.65672661,0.0,0.0,0.0,1.23572637,0.0,0.0,0.0,0.0,0.42831036200000006,0.0,0.0,0.639629006,1.14504344,1.94011982,1.70859368,1.8902069,2.01887347,1.49370596,2.70004013,3.02162143,3.84640754,3.71706732,3.43629368,3.60385039,3.13271292,0.46312672899999996,0.8275986559999999,1.65639911,1.21468085,1.34959357,0.9248891659999999,0.0,0.33423599800000003,0.0,1.74344331,0.72612992,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.943655548,0.0,0.884083078,0.0,0.88477408,0.0,0.0716332088,1.0620366,0.997445205,0.569525194,0.0,1.33441914,1.32799746,0.829431788,0.0,0.7687653520000001,0.661706812,0.751241323,1.52700233,0.47235239700000003,1.05981611,0.0,0.0,0.0,0.0,0.0,0.402460993,0.554407755,1.02965086,0.0845418135,0.161812627,0.0,0.506964283,0.0,0.0,0.593918263,0.36661099,0.0,0.0,0.0339519545,0.7777422009999999,0.0,1.6257841999999998,0.0,0.0,1.09728112,0.0,0.0,0.506081504,0.347705155,0.32183327899999997,0.0,0.0,0.386672873,0.40801952399999997,0.773750697,0.0,0.719807552,0.0,0.0,0.463984414,0.0,0.0,0.0,0.0,0.43637091299999997,0.0,0.0,0.53198314,0.153495733,0.0926125468,0.453870427,0.6711686,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.128884843,0.0,0.23945008899999998,0.633968792,0.0,0.0,0.643368323,0.222453667,0.0,0.532124583,0.11073153599999999,0.0,0.5123994789999999,0.360254026,0.0,0.369812966,0.052902441200000004,0.40026369799999995,0.0643532603,0.0,0.2701902,0.169214325,0.0,0.0,0.0651815545,0.010831600700000001,0.333878273,0.338321544,0.0,0.281712532,0.245859933,0.0,0.0314111897,0.17478153800000001,0.09711665050000001,0.0,0.0859050101,0.35833136600000004,0.329865659,0.0,0.0,0.118160956,0.0,0.249552601,0.296657901,0.274053047,0.0,0.0,0.0,0.191194125,0.0,0.0,0.0,0.101202391,0.0,0.0,0.0,0.0,0.0,0.0,0.431916636,0.0,0.532343351,0.410902351,0.0,0.00745333502,0.321930841,0.443776151,0.0,0.21373020199999998,0.45390908,0.0,0.0762541913,0.236423469,0.0,0.0,0.0,0.0,0.31735581,0.0,0.0409629246,0.0,0.0,0.0,0.062315595700000004,0.000327266281,0.444448499,0.5286716020000001,0.36215962100000004,0.43566299700000005,0.0343787765,0.574821015,0.41248260200000003,0.222327086,0.893775573,0.340378887,0.7331489390000001,0.23999083300000001,0.874242007,0.367708637,0.0289163329,0.546234213,0.40242416299999995,0.10907087900000001,0.0,0.236882998,0.0,0.036558230899999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.564835237,0.47147933200000003,0.901032046,0.790403304,1.82063171,1.99081462,2.5347812999999997,2.48800895,2.41848952,3.26727061,3.13895994,3.59550588,3.94671909,4.14005042,4.3071097,4.01399572,4.28146011,4.22160774,4.46510574,4.32219406,3.97774632,3.60843175,3.79803394,3.72730718,3.42716614,3.07149524,2.39710499,2.05823414,1.63153766,1.93407983,1.18402501,0.800163339,0.7445402720000001,0.481414159,0.144605436,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0513472619,0.0,0.0,0.00414322026,0.0,0.484035334,0.8172783809999999,0.41307031299999997,0.34002777,0.907458463,0.874481101,1.12555088,1.38315143,1.40744421,0.781089024,0.894753867,1.05804036,1.25921636,0.957807497,1.32191131,0.823034332,1.00616634,1.02855612,0.892565025,0.0452853625,0.0,0.33039805899999997,0.521861884,0.33329598,0.0,0.0,0.0,0.0,0.0257881794,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.274558403,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.45627509899999996,0.309459741,0.0,0.0,0.0,0.0,0.0134473083,0.0,0.0,0.321208828,0.0576892487,0.127193731,0.0,0.14074835800000002,0.0,0.0,0.0,0.302952547,0.0,0.0,0.0,0.0,0.0,0.11083767,0.0,0.0,0.0,0.0967491901,0.252200157,0.0621030729,0.24411884399999997,0.40675116200000005,0.48645014,0.0,0.28542248600000003,0.312481355,0.08072693709999999,0.0,0.0,0.0,0.0,0.27465513,0.224656272,0.293751787,0.294652929,0.046072114000000004,0.257971109,0.0,0.0,0.0,0.38062673700000005,0.0,0.259358231,0.303807924,0.0,0.29435426600000003,0.08931169439999999,0.08695484699999999,0.039988800299999995,1.07328661,1.02304415,1.27734023,0.668472295,0.50884907,0.316025214,0.0,0.0,0.150781215,0.292102142,0.0,0.0,0.0,0.35420185600000004,0.0,0.042561321,0.36285499,0.28309011,0.322106579,0.0,0.0168660019,0.0,0.689798292,1.54463838,1.75898945,0.14416948300000001,0.0,0.0,0.286721677,0.0,0.0,0.0,0.610697605,0.303871387,0.0,0.453593355,0.410473579,0.0,0.0,0.7326419359999999,3.54588835,3.57451224,1.68594598,0.0,0.225329105,0.479710024,0.9545270990000001,1.91611002,2.05512497,1.72146133,0.0,0.0,0.422918164,0.865809853,0.297624447,0.0,0.0,0.0408694122,0.241123198,0.642319895,0.322885424,0.416232084,0.0444128392,0.253249942,0.135575574,0.0,0.30519217600000004,0.189334616,0.0,0.0,1.05437636,1.81262383,1.15114335,1.10977979,0.258506793,0.41428053200000003,0.883570527,0.0,0.210323722,0.0,0.25238823,0.225838717,0.0,0.0,0.0,0.0970685607,0.0,0.225455317,0.0,0.0,0.0,0.475543295,0.323205064,0.183481736,0.0,0.375264534,0.19159467300000002,0.21476191,1.32713978,1.43843946,0.68420099,0.422107209,0.0153782374,0.252049581,0.630968518,0.45566263100000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.192805878,0.876485704,0.822665216,0.0,0.37625342799999995,2.56798116,1.02766995,2.00351658,0.5042996479999999,0.604712657,0.123662494,0.243137141,0.0484631684,0.08999739949999999,0.0,0.0367256685,0.0,0.0257399819,0.0,0.0174963699,0.0,0.00952541045,0.0,0.0,0.007847499479999999,0.0,0.0373247444,0.0,0.511372554,0.9633146440000001,0.46536541600000003,0.179450357,0.0,0.0614089057,0.0,0.0471850178,0.0,0.041311078,0.0,0.0384682783,0.0,0.0374874761,0.0,0.0388559918,0.0,0.090969196,0.0,0.029256869300000002,0.0,0.0324415488,0.0,0.0318512696,0.0,0.0640897395,3.03612886,1.1981409,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.894539298,0.0,0.50766225,0.8597896070000001,0.528494489,0.6857562909999999,0.0,0.0,1.05845858,0.555218671,0.475509158,0.0,0.0,0.38403856700000005,0.0,0.0,0.31811446,0.722991679,0.6592680670000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.435927389,0.0,0.0,0.0,0.220714648,0.680572588,1.18473561,0.0,0.0,0.633423059,0.362462382,0.635054425,0.055856810599999994,0.047272373,0.0,0.7989751740000001,0.7892997490000001,0.22292594699999999,0.0,0.0198743469,0.0,0.0436828176,0.0,0.0,0.0,0.580406526,0.0,0.0,0.233751135,1.19717016,0.0,0.157853095,0.272426932,0.0,0.157088607,0.0,0.551306752,0.658702688,0.14519860699999998,0.0015677118400000002,0.0,0.0,0.45368803,0.553885359,0.0,0.15414903300000002,0.0,0.0,0.0,0.0,0.58890687,1.08690076,0.0,0.0,0.0,0.0,0.0,0.0490505484,0.0,0.0,0.5665123879999999,0.82962644,0.63089936,0.5806011,0.0,0.0,0.309647975,1.4631774,0.0,0.105277676,0.14689315,0.15877781300000002,0.507875163,0.0,0.562057623,0.0,0.0,0.9599635559999999,1.23560151,0.0,0.244217973,0.0,0.0,0.549403458,1.11061822,0.0,0.0,0.0,0.538962634,0.24510429399999997,0.0,0.0,0.35893196899999996,1.19431985,0.0,0.660402402,0.44923390799999996,0.0,0.0,0.0,2.2720526000000003,0.0,0.41557278799999997,0.0,0.0,0.265247875,0.252178649,0.177890981,0.42735547,0.0,0.211886733,0.292420626,0.785832792,0.0,0.7988695840000001,0.476363062,0.0,0.494798962,1.17591082,0.0,0.0,0.0682971526,0.0,0.40239470899999996,0.541421975,0.6928624859999999,1.4605732,0.0,0.0,0.0,0.0,0.0672720661,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.03065168,0.40353581200000005,0.805325397,0.21923879,0.8572586740000001,0.7148006459999999,1.52797703,2.4762258,1.56888777,1.48309179,2.2896812,3.18763059,2.07974831,3.31886523,2.1339085,3.74650923,2.85089557,2.77066105,2.29346559,3.1693186,2.76680995,1.94835836,2.0509789,1.37275534,1.29251188,0.930910694,1.42413993,0.469307176,0.292416652,0.0,0.0,0.0,0.5873618389999999,0.0,0.169516521,0.0,0.0,0.0,0.0,0.0,0.386693269,0.38991839100000003,0.84713129,1.06124828,0.0,1.68466342,0.809950955,1.32311705,0.584150214,0.93479044,0.543296835,1.2070677,1.75915258,0.0,1.28478869,0.720449331,0.574126729,0.75595381,0.11346495599999999,1.01684138,1.13875297,0.76420325,0.22849845300000002,0.0,0.0,0.24652204600000002,0.57226196,0.0,0.0,0.0538208437,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.15624087,0.769535477,0.17741549199999998,0.0,0.0,0.35412481100000004,0.30389965399999996,0.0,0.0,0.0971469359,0.26038707699999997,0.0,0.0,0.0,0.115132264,0.036897803199999996,0.0,0.036775302,0.0,0.0,0.278088234,2.00046099,3.73267911,3.88732534,2.36207941,0.65727444,0.00120265242,0.118865786,0.12219726,0.0,0.0,0.08391007980000001,0.181921773,0.0,0.0,0.0,0.15708036,0.0583894368,0.0,0.0,0.09499478380000001,0.10515872400000001,0.0,0.0,0.025157535099999996,0.11006633199999999,0.005845960359999999,0.0,0.0,0.0846253773,0.0522392608,0.0,0.0,0.0440969149,0.0755419806,0.0,0.0,5.40401504e-16,0.0800730132,0.0223529344,0.0,0.0,0.0714048707,0.0727792506,0.0,0.0,0.04328973480000001,0.149778771,0.0,0.0,0.0,0.306435604,0.203335123,0.0,0.0,1.0193246,3.69827982,5.11784917,3.90476365,1.47399845,0.356882494,1.015182,1.50530773,0.480780328,0.0,0.0,0.643314036,0.926449216,0.0,0.0,0.19360797,1.69842925,1.63866768,0.40592819799999996,0.0,0.43081941799999995,0.409380677,0.0,0.0,0.5532852079999999,1.31656455,0.0,0.0,0.0,6.10693008,10.636496300000001,8.70033426,2.39798164,0.0,0.0,0.803405477,1.19058765,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47
0.30011331199999997,0.0,0.11413057199999999,0.149531359,0.0,0.335703208,0.308958787,0.0,0.257037394,0.0,0.0,0.389744379,0.0,0.0,0.891121568,0.35541695100000004,0.567208716,0.79313464,0.0,1.94457789,3.6086294999999997,1.08475297,0.0324889826,0.751094722,0.227266606,0.624507371,0.578583925,0.0,0.555240681,0.0,0.358565751,6.54885535,5.80868846,0.0,0.0,1.13773998,0.0,0.0,0.5673026520000001,0.0,0.131666141,0.290895619,0.0,0.250426765,0.0971866154,0.0,0.29764706399999996,0.0,0.0,0.25241316399999997,0.0,0.5797125639999999,1.07681799,0.0,0.23196704699999998,1.3580863,0.514896157,0.17025166,0.743580899,0.373469987,0.0033573060799999997,0.0017743812699999998,0.0,0.0671313289,0.0,0.0,0.0953490182,0.0,0.0,0.0896490841,0.0,0.0211722706,0.0595672913,0.0,0.0441472153,0.017019104,0.0,0.0,0.0184645435,0.8124516559999999,0.917676707,0.0,0.0,0.321925738,0.0,0.0371170041,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
2.10297369,1.81714026,1.56563986,0.99796841,0.28138908100000004,0.0,0.0,0.0,0.769236129,0.9300182570000001,1.01862565,0.350322652,0.7172471429999999,0.0,0.0,0.0,0.0,0.369351837,0.16422868300000001,0.0,0.09782718439999999,0.0,0.176687342,0.08501372310000001,0.0,0.0,0.137862352,0.20506915899999997,0.0,0.0,0.0,0.0,0.0,0.0636756651,0.0,0.24991540399999998,0.0,0.0,0.0,0.19821240199999998,0.151198091,0.0,0.190091184,0.105839747,0.0,0.0,0.0,0.0,0.0,0.12688163,0.0,0.170617863,0.0,0.0,0.0,0.060229519100000004,0.22426644199999998,0.0,0.0,0.274833158,0.0186340049,0.172717989,0.48533538299999995,0.192335948,0.0,0.0,0.0,0.24910124,0.640948222,0.436055157,0.783237249,0.560585935,0.549649299,0.440252525,0.328883966,0.455608478,0.562864034,0.535775961,0.17865599100000001,0.160630514,0.0,0.0,0.0,0.0,0.133787624,0.631985184,0.029943667599999998,0.0,0.0,0.0,0.0,0.0,1.44449234,2.23270698,3.93497037,3.85801832,3.828682,3.09173558,2.59432109,1.16516866,0.50762799,0.25138446,0.0,0.165764164,0.0,0.21990559,0.0,0.0,0.142676827,0.275613633,0.0,0.215801734,0.181425996,0.0,0.0598964653,0.0,0.156082235,0.0,0.0,0.0,0.0,0.13447238,0.18043335100000002,0.257247144,0.720594648,0.0170657386,0.5218831629999999,0.0,0.18541617300000002,0.0,0.0,0.60834825,1.3146428999999997,2.40367442,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.120797062,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.325902376,1.17968966,2.03291732,2.44885212,3.19091205,3.62897512,4.10536455,4.53394131,5.23531386,5.12347842,4.59468968,4.29875502,4.26928999,3.91816126,3.35807179,2.36188994,1.52245634,0.9320539609999999,0.76103092,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.37066805700000005,0.659352631,0.652879254,0.512588621,0.799365763,0.51591395,0.356739727,0.48999190600000003,0.0,0.0543896632,0.0,0.194925595,0.0,0.0,0.036336972599999996,0.0,0.0,0.0,0.10338131800000001,0.0,0.18001040899999998,0.0,0.811584078,0.759885211,0.298690668,0.136607657,0.431515794,0.0,0.23859632,0.0,0.0,0.0,0.0,0.0,0.0,0.134602359,0.0,0.0,0.392883153,0.45388862799999996,0.00711614983,0.031071369900000003,0.5299820789999999,0.0,0.711654133,0.19426102399999998,0.0754160582,0.291566363,0.40752853899999997,0.0,0.0,0.0,0.127722739,0.0,0.0,0.0,0.0,0.0,0.0,0.47098616299999996,0.293613854,0.408021635,0.0,0.0480454839,0.0,0.0,0.22121953800000002,0.0,0.0,0.0,0.031419970299999996,0.0,0.0,0.09275579519999999,0.0,0.262954197,0.0,0.0035079067700000003,0.427873035,0.0,0.40518976700000003,0.0,0.37568802700000004,0.22133513,0.0532148038,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143240793,0.0,0.0,0.7029725590000001,0.862249983,0.390501885,0.858670024,1.43790245,0.697974944,1.06825661,0.742410337,0.6726985320000001,1.36878207,0.84712089,0.8729201240000001,0.337048894,0.520109141,0.249697251,0.8150706670000001,0.37062719299999997,0.49314541799999995,0.252549092,0.571707587,0.111156066,0.375256456,0.0,0.0,0.027207931600000002,0.0,0.30894879399999997,0.0,0.0,0.0,0.0759868644,0.0,0.0,0.110131083,0.0,0.298371995,0.208376535,0.0,0.0,0.443498094,0.358178619,1.07531437,0.716417677,0.9538066559999999,0.632718594,0.953194312,0.7688198470000001,1.11927317,1.36213961,2.07556167,1.39992653,2.19090498,2.61944478,2.12056969,2.54776913,2.70192343,2.3779304,2.91980303,2.77926192,2.10200339,1.91188639,2.37853009,1.32320106,1.54846109,0.25628667,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
2.42922377,2.29130555,2.52221607,3.30269077,2.61711321,1.59822151,1.48076265,1.85377596,1.90235308,2.16878744,3.40598151,3.08817153,3.9499717000000003,4.46833816,3.54472832,2.68672444,1.27178458,0.935724287,0.0,0.27162029,0.0,0.34700930700000004,0.0,0.0,0.160682189,0.0,0.0,0.0,0.231270227,0.041993620999999995,0.031595288799999996,0.0411904362,0.0,0.0,0.0,0.469520903,0.0663083574,0.12434777400000001,0.345446949,0.0563702259,0.0,0.0,0.0,0.0,0.0025626610399999998,0.789666625,0.0,0.036495257,0.0,0.0,0.0,0.17763050800000002,2.02291452,3.95202225,4.85279283,5.55845275,5.46984639,3.25448584,1.54077383,0.0,0.0,0.0,0.0,0.243538993,0.96937179,0.437817461,1.06364971,0.5008052820000001,0.0,0.0,0.0,0.0,0.189092625,0.65845083,0.505172582,0.502397353,0.0,0.0,0.0739443506,0.0,0.412022525,0.0,0.585802641,0.798043387,0.0,0.0,0.0,0.0,0.0,0.0,0.5238774820000001,0.0,0.0,0.0,0.0,0.0,0.0054638761800000005,0.0,0.0,0.0926760644,0.5415547510000001,0.0715174296,0.0,0.0,0.0722869414,0.0,0.0,0.546643978,0.0,0.0,0.152684146,0.0,0.118143274,0.0,0.0115638804,0.491013207,0.0,0.38706709899999997,0.0,0.204073266,0.0847785859,0.423437392,0.0,0.658857444,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.709241673,0.0,0.0,0.0,0.0,0.568198871,0.0,0.07447995610000001,0.315591512,0.0753033937,0.539992507,0.259082766,0.0,0.0686678424,0.0,0.0,0.0,0.423008987,0.346453151,0.339388266,0.0,0.0,0.16668249300000001,0.23814999899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.295711326,0.47013239700000004,0.0,0.0,0.0159314889,0.371913789,0.0,0.208534627,0.0,0.0,0.0,0.632870528,0.0,0.556301436,0.0,0.0,0.0,0.0,0.0,0.24185611,0.0270831634,0.363865155,0.225122057,0.0,0.0,0.18328526,0.542015865,0.8289093409999999,0.8064981520000001,0.69204185,1.00594582,1.0332768,1.21292289,1.60302375,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.847796274,0.72947655,1.69585329,0.371915631,0.152033189,0.0,0.235292757,0.0,0.0,0.23529784399999998,0.268304092,0.215208436,0.0984175408,0.0,0.0,0.062477736799999996,0.0330503958,0.390975093,0.41696496899999996,1.03727037,1.08021157,0.541921381,0.0,0.0,0.0,0.0903372207,0.0419296834,0.0,0.0174283984,0.0,0.0,0.0,0.0,0.113175129,0.0,0.0,0.0,0.956112834,2.0084258999999998,2.74683995,2.19228489,0.7042515659999999,0.469619174,0.940286373,0.127848558,0.492221175,0.0,0.266632052,0.74828017,3.01838182,1.24789218,0.08652291289999998,0.73860603,1.40464405,1.74284618,0.526711167,0.116546568,0.305179856,0.11025583900000001,0.32142983,0.154924385,0.36561186,0.117964826,0.0,0.0,0.164885064,0.0,0.06539908059999999,0.7321132459999999,0.0,0.025547868999999997,0.0,0.16877598,0.16235613699999998,0.0533126749,1.19950814,1.96592804,1.55319566,0.906508896,0.269849191,0.294945012,0.0,0.369709135,0.36431473799999997,0.612129571,0.0,0.49768423100000003,0.0,0.0386540999,0.0,0.0,0.059069621100000004,0.0,0.0,0.158316201,0.0,0.0,0.299339383,0.0,0.0,0.17002963199999999,0.654594906,0.535603712,0.0,0.0,0.396625358,0.437155387,0.0,0.64681071,0.8617466840000001,1.09224813,0.9695442059999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.415
7.12798117,4.17413979,0.0,3.55920252,3.91908574,0.0,1.7180078,5.12581979,0.0,0.367337989,3.05803458,1.27321182,2.79118247,1.54503318,5.90604629,0.0,1.61607296,5.57781365,0.481203606,0.492704187,3.03434099,0.11267484900000001,0.510923234,2.12325785,0.0,0.817628825,0.0,0.0,0.9762670520000001,1.39483753,1.7003784,0.557306691,0.0,0.0,3.61329717,0.0,1.0993251,0.6379393320000001,0.0,0.0,2.72136461,0.786611562,2.00085275,0.0,0.0,0.0,0.0,0.0,0.0163472009,0.880166427,1.74807486,1.09507212,0.0,0.0,2.41470467,0.0,0.0,0.0,0.0,2.77725771,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.47037176,1.86097321,3.02609906,3.08693531,2.18948037,0.6338983,0.0,0.0,0.0,0.6361201,0.51461172,0.43884035,0.0,0.0,0.08943189,1.0803781000000001,0.43477686,0.43713234,0.32838609,0.0,0.34236193,0.0,0.19631041,0.71249652,0.70106403,0.49082774,0.0,0.11394494,0.0,0.0,0.0,0.31420298,0.0,0.0,0.39891459,0.0,0.38167654,0.0,0.38557766,0.15964764,0.0,0.46287029999999996,0.45156214,0.0,0.0,0.0,0.0,0.0,0.07144258,0.0,0.41481535,0.2932012,0.28532373,0.0,0.43539633,0.0,0.0,0.0,0.20221358,0.0,0.98198778,2.5571212000000005,3.99304191,5.0709325,4.79295798,4.37207956,2.07668784,0.60469009,0.33009951,0.28917701,0.93493728,0.71724907,0.3603261,0.0,0.19519279,0.32484249,0.08461913,0.81932635,0.0,0.0,0.0,0.12445494,0.5629715999999999,0.53276408,0.61956652,0.0,0.30462451,0.0,0.51553374,0.0,0.0,0.0,1.68823824,3.66862319,4.72708646,3.83405936,2.35992147,0.0,0.0,0.0,0.85964544,0.94234257,0.0910308,0.0,0.0,0.32135041,0.0,0.21677075,0.0,0.0,0.0,0.15970220000000002,0.0,0.24988746,0.0,0.0,0.13859543,0.37324243,0.22278337,0.13070732,0.0,0.49995162,0.0,0.51522431,0.0,0.12741988,0.0,0.0,0.27186968,0.07118636,1.01824489,1.17772083,1.52555961,2.06756134,1.17123578,0.35871418,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
5.16574961,2.17902168,0.0,0.0,0.0,0.590500593,0.487890006,0.0,0.0,0.33532028399999997,0.895671063,0.745789308,0.0177563676,0.0,0.0,0.198451533,0.42465193,0.110927135,0.0,0.0,0.0674323947,0.327376497,0.162684179,0.0,0.0,0.0,0.26070531199999997,0.197672547,0.0,0.0,0.0,0.20637539600000002,0.22591239999999999,0.0,0.0,0.0,0.161256685,0.264024952,0.0239813181,0.0,0.0,0.148882401,0.539148599,0.587702191,0.324153621,0.059336957999999995,0.0037187246399999997,0.0689997294,0.054093575,0.0,0.0,0.0,0.176341608,0.276172863,0.254652724,0.24547216600000002,0.327320842,0.38462377,0.253960265,0.0,0.0,0.0,0.11399864800000001,0.20013876100000003,0.0289895359,0.0,0.0,0.0736905662,0.23161601199999998,0.09267291279999999,0.0,0.0,0.12213058,0.590050831,0.779493918,0.586414157,0.28088633,0.172247116,0.285086939,0.416583114,0.44548409,0.463984112,0.576017515,0.6734629529999999,0.537387328,0.158786012,0.0,0.0,0.13101902099999999,0.273519464,0.0580450009,0.0,0.0,0.109282981,0.479101994,0.405599758,0.0,0.0,0.00928646943,0.364192125,0.27888320000000005,0.0,0.0,0.166286631,1.18982987,1.48808248,0.518793623,0.0,0.0,1.59232819,4.70400598,6.32480252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.209008081,0.677129777,1.00078172,0.98539767,0.670394691,0.280059436,0.0374993935,0.00104056022,0.055574602800000004,0.050983460700000004,0.0,0.0,0.0,0.0480105404,0.189454117,0.165555847,0.0,0.0,0.0,0.0,0.252978902,0.300986258,0.0593313189,0.0,0.0,0.0,0.282160061,0.45869358600000004,0.199922918,0.0,0.0597589817,1.56132114,4.27796409,7.2645807,9.10813027,8.76846451,6.26988082,2.74505628,0.0,0.0,0.0,0.0,0.8018443340000001,0.799850631,0.147834906,0.0,0.0,0.0,0.32377223899999996,0.491200825,0.215943676,0.0,0.0,0.0,0.132167048,0.34567935200000005,0.23768134,0.0,0.0,0.0,0.021261058399999998,0.24763880300000002,0.240257196,0.0194138631,0.0,0.0,0.0,0.169368447,0.23092873600000002,0.0826445446,0.0,0.0,0.0,0.10130876800000001,0.212754341,0.128894623,0.0,0.0,0.0,0.0393346057,0.187737684,0.163501428,0.0,0.0,0.0,0.0,0.15856964099999998,0.193308271,0.0499789409,0.0,0.0,0.0,0.143144765,0.297279719,0.265653064,0.09702640609999999,0.0,0.0,0.0399325923,0.136821411,0.110837145,0.0,0.0,0.0,0.0042173012,0.15138645,0.162379193,0.021896153999999998,0.0,0.0,0.167501411,0.593149193,0.959690345,1.10812281,1.03695536,0.8758771870000001,0.760344626,0.72430635,0.7026970029999999,0.628259381,0.519181108,0.466620909,0.532077232,0.658189519,0.692177406,0.517881288,0.183279907,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47600000000000003
0.377935743,0.403531332,0.41868289799999997,0.422436748,0.41459057,0.39567127700000004,0.366869788,0.329938354,0.287057506,0.240680919,0.193367345,0.147609397,0.10566931800000001,0.0694318377,0.0402838211,0.0190294274,0.00584796747,0.000299397798,0.0013795220800000001,0.00762352577,0.0172526446,0.028354832400000002,0.039086589500000005,0.047880029500000004,0.053637194900000004,0.0558929289,0.054928541100000006,0.051821192599999996,0.0484183364,0.047232461100000005,0.0512583883,0.0637229027,0.08778386099999999,0.126202385,0.181016559,0.253247619,0.342669392,0.447668626,0.5652177070000001,0.690972623,0.819498354,0.9446121890000001,1.05982369,1.15883941,1.23609197,1.28724802,1.30964799,1.3026339,1.26772828,1.20863898,1.1310784,1.04240212,0.9510884479999999,0.866096137,0.796150337,0.749016247,0.730823888,0.745505992,0.7944037690000001,0.876082703,0.9863834999999999,1.11871322,1.26456026,1.41419588,1.55750704,1.68489077,1.7881328,1.86119104,1.90081071,1.90690981,1.88269265,1.83447139,1.77120124,1.70376054,1.64403046,1.60384848,1.59392322,1.62280401,1.69599648,1.81530511,1.97846599,2.17910956,2.40706553,2.64899297,2.88929068,3.1112181,3.29813822,3.43478233,3.50843353,3.50993164,3.43441652,3.2817480000000003,3.05656752,2.76799626,2.42899466,2.05543623,1.66497169,1.27577647,0.9052826070000001,0.568996536,0.279494965,0.045674798899999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0583579329,0.127225795,0.175663565,0.20027258399999998,0.200501908,0.17841823899999998,0.138256656,0.085805923,0.027694639500000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0143441679,0.0542279626,0.0861966574,0.107065651,0.11499505199999999,0.10963020400000001,0.09208056369999999,0.0647451837,0.031008388900000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.030135208700000003,0.0578296869,0.078425773,0.0896505843,0.0903275207,0.0805212152,0.0615550712,0.0359003137,0.006948175890000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0250989166,0.0846408892,0.156151613,0.235858402,0.319207326,0.401225757,0.476918069,0.541659776,0.591556568,0.623738762,0.636568296,0.629743705,0.604297747,0.562491658,0.507618424,0.44373448200000004,0.375344102,0.307063305,0.24329027,0.187907054,0.144033419,0.11384806900000001,0.09848633470000001,0.098016855,0.11149363300000001,0.137074573,0.17219349,0.21376985399999998,0.25843933399999997,0.302788275,0.343576589,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.438726735,0.0,1.19924698,1.37093766,0.420944398,0.8584415409999999,0.487982077,0.49429463,2.99806134,6.2460455999999995,5.25354812,0.40074422200000004,0.0,0.614880594,0.0,0.0,0.0,0.472572999,0.0702769176,0.0,0.0,0.829243658,0.00976870126,0.0,1.23846734,1.51593428,0.138234967,0.0,1.88468124,0.761892516,0.0,0.28270445899999996,0.38906283,0.522042225,0.0,0.0,0.0978828418,0.0,0.0,0.06446865339999999,0.58423516,0.0,0.0135610697,0.0,0.0,0.541612525,0.0,0.7758163020000001,0.428059126,0.030112132799999997,0.563076796,0.0,0.0,0.0,0.103533779,0.0,0.0,0.29414982100000003,0.280286241,1.29594598,2.3804467000000002,3.87143372,4.62847263,3.48953466,3.02727697,1.75589091,0.0,0.645188243,5.52434832,4.98423377,1.70094305,0.0,0.707088686,0.27322411399999996,0.0,0.0,0.484676615,0.981505098,1.17221837,0.231624623,0.245772231,0.53831984,0.051178088499999996,0.0,0.0,0.00475558194,0.0,0.0,0.365143648,0.0,0.310573074,0.0,0.584878943,0.25227639,0.0,0.509111077,0.411111413,0.0109748648,0.119584582,0.0,0.279320393,0.0,0.20913326899999998,0.5412939929999999,0.6699760570000001,0.552260898,0.0,0.0,0.6490343820000001,0.477668132,0.0,0.679686518,2.00924626,2.44560875,2.97066104,1.74410047,0.513148826,0.6275519270000001,0.0,0.40337605200000004,0.504830505,0.44001411700000004,0.0,2.20262173,3.30545661,0.514102229,0.0,0.0723305376,0.0,0.215711225,1.08336739,0.0,0.0,0.233145939,0.0,0.175558009,0.0,0.0,0.0765690748,0.6311065,0.31279751,0.026787464700000003,0.0645578677,0.0,0.197141398,0.336895847,0.0,0.00454934705,0.0980210587,0.0,0.212459034,0.0,0.456230064,0.0,0.0107952758,0.632697015,0.0938178209,0.49771455299999995,0.566789396,0.223810662,0.392668836,0.421236203,0.383398302,0.0,0.0,0.0,0.5864014160000001,0.903453675,0.11146848300000001,0.0,0.15239656599999998,0.47121904700000006,1.67940875,1.99019129,1.33473167,0.0,0.46168341700000004,0.79708069,1.13461979,1.14043332,0.232846789,0.0,0.0,0.0,0.0,1.16361891,1.11003871,2.05668486,1.45723005,0.37133557100000003,0.116781619,0.5540097970000001,0.0,0.33629485600000003,0.543927112,0.0,0.0,0.298466158,0.573052867,0.0,0.09081991,0.487079029,0.15071310300000001,0.0,0.0,0.270188445,0.490632174,0.656284578,0.421129195,0.5880312010000001,1.60276123,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
4.07756835,3.99330942,3.85845439,3.67604846,3.45023982,3.18616896,2.88983088,2.56791436,2.22762291,1.87648274,1.52214329,1.17217617,0.833878406,0.514085493,0.218999755,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0348390909,0.20237610600000003,0.365055504,0.51796235,0.656729522,0.777646203,0.877742705,0.954849603,1.00763004,1.03558492,1.03903159,1.01905741,0.9774505720000001,0.916610791,0.839443662,0.749242388,0.649561222,0.544085036,0.436499426,0.330365683,0.229004648,0.13539309800000002,0.052075776799999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00309899039,0.05011367,0.09644390609999999,0.13977187900000002,0.178001651,0.20933359699999998,0.23232552899999998,0.24593858600000001,0.24956654600000003,0.243047863,0.226660375,0.20109924899999998,0.167439353,0.127083787,0.08170078389999999,0.033151591800000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.028863185099999997,0.0757186579,0.11942252,0.15826358199999999,0.190727337,0.215554105,0.23178708,0.23880848300000002,0.236362496,0.22456415899999999,0.203893943,0.175178255,0.139556663,0.09843714220000001,0.0534410589,0.0063400405000000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0064597959400000005,0.0545823574,0.100785792,0.143241289,0.180256576,0.210342136,0.232269979,0.24512271100000002,0.24833097199999998,0.241697755,0.22540860899999998,0.200027247,0.16647662800000002,0.12600614599999999,0.0801460526,0.030650771,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0383714593,0.0953810812,0.149761447,0.19936208,0.24218521199999998,0.276465279,0.30074089,0.313916427,0.315310806,0.30469134,0.282291189,0.24880944600000002,0.205393541,0.153604289,0.09536456970000001,0.032893208199999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0668387826,0.15118230800000002,0.23430199399999999,0.312836573,0.383460615,0.443009617,0.488603777,0.517766087,0.5285305,0.5195361479999999,0.490103981,0.44029269,0.370931415,0.28362746699999997,0.18074806899999998,0.0653759905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0677119466,0.335024864,0.63009072,0.947760255,1.28210707,1.62656995,1.97411622,2.31742144,2.6490603999999998,2.96170398,3.24831597,3.50234426,3.71790059,3.88992364,4.01432043,4.08808195,4.10936939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.0386838069,0.39334313299999996,0.655149594,0.7948080270000001,0.803247541,0.690962227,0.484842234,0.22306034600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0778986257,0.261779627,0.39533116,0.460701939,0.451263401,0.37206219,0.238519635,0.0736443,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.109897711,0.233545342,0.316929051,0.348190381,0.32387981899999996,0.24926174199999998,0.13727672400000002,0.00635250341,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.017622482,0.13508889400000001,0.229432985,0.286143673,0.296809895,0.26034929,0.18308323899999998,0.077660927,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.059406567699999996,0.16313166199999998,0.240594974,0.279592114,0.27401560199999997,0.22480319199999999,0.13978222099999998,0.032435456800000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10271705699999999,0.200890005,0.267744112,0.292351617,0.270388045,0.204877935,0.10579185,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0365343345,0.159045472,0.258390334,0.31817743,0.327985195,0.285144142,0.195332984,0.0718684766,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.102723997,0.244227869,0.34997835899999996,0.40163510399999997,0.389179194,0.312970247,0.184247612,0.0239209396,0.0,0.0,0.0,0.0,0.0,0.0,0.123419078,0.400377424,0.67814069,0.91369283,1.06595489,1.1021985,1.00378887,0.770397022,0.421987259,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.782968433,1.82306998,2.96051454,4.10309685,5.15289984,6.01666996,6.61590989,6.89548413,6.82970086,6.42513414,5.71984457,4.77909476,3.68808179,2.54256781,1.43853709,0.46211095,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.465
0.276539307,0.22804193,0.0,0.0,0.10070836300000001,0.15424059099999998,0.0,0.12403176699999999,0.6798060309999999,0.61504025,0.00197921108,0.0,0.144849272,0.0,0.0,0.0,0.0,0.0,0.0,0.342299986,0.030045422999999998,0.184440458,0.0,0.290339125,0.512351613,0.21025195300000002,0.0,0.194266882,0.458805663,0.0,0.0,0.0,0.0,0.0,0.119203566,0.0,0.143962531,0.0,0.0606051307,0.12584525400000002,0.0,0.16111321,0.0,0.490631164,0.0,0.06942806,0.625957879,0.0,0.0,0.483442518,0.0,0.42066598899999996,0.531300155,0.712176887,1.51995657,1.66496811,1.63203971,2.1377664000000003,2.34276891,2.29515029,3.46159136,4.19638302,4.23172028,5.12894768,5.05512587,4.74367735,3.93030116,3.96617182,3.04102292,1.88992634,0.7908183879999999,0.633789211,0.026289506400000003,0.0,0.655751262,0.9833546320000001,0.582678991,0.763721733,0.45188613,0.48268091799999996,0.7553230590000001,0.0,0.11190711199999999,0.0,0.41002356,0.18745872800000002,0.0,0.6766739709999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0066817362,0.883064393,0.767049677,0.0,0.0,0.0,0.0,0.0,0.0,0.33734876399999997,2.34149777,4.09472783,4.94980836,5.34385777,6.19007075,5.39264995,4.61687171,2.87435058,1.3702613000000001,0.507944239,0.0,0.0,0.0,0.463962538,0.7247107279999999,0.568292904,1.02988085,1.30142056,0.8081325090000001,0.574066985,0.0,0.0,0.0,0.281975717,0.291929275,0.0206286878,0.20437999699999998,0.0,0.565348712,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
0.70175294,0.0,0.0,0.0,0.0,0.0,0.65431132,0.12932492,0.15919207,0.0,0.0,0.0,0.08512958,0.28504403,0.0,0.0,0.0,0.0,0.0,0.03041199,1.43111693,0.0,0.82085521,1.21240307,0.0,0.0,1.71623783,0.0,0.0,1.39506408,0.0,0.0,0.28754322,0.0,1.18948397,0.0,0.74627533,0.83504174,0.53753041,0.14592917,0.0,0.0,0.0,2.75272954,0.13905993,0.0,1.9533772,0.8387375,0.0,0.0,1.38294614,0.0,1.31220916,0.44915997,1.72573741,1.6415473999999999,0.25169178,1.05150861,0.0,0.0,0.0,0.10405478,1.34497503,0.0,0.0,1.3565715,0.0,0.0,0.0,0.0,0.81272795,0.20778277,0.0,0.0,0.0,0.81818839,0.0,2.0990145,3.00568805,2.32639987,2.59190574,3.88120563,4.96084357,4.49992668,3.47303149,4.45648652,3.6950002,3.06029887,1.50741678,0.94326712,0.0,0.0,0.0,0.57873064,0.0,0.0,0.0,1.04834661,1.77331385,1.34519133,1.0152865,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.27734512,0.10229956,0.30215784,3.42215513,1.51111052,0.08891584,0.0,0.3964458,0.78529098,0.40950333,1.78950914,0.34681678,0.0,0.14232911,0.0,0.0,1.12558824,0.0,1.05778241,1.22166566,0.57772741,0.86830956,0.0,0.0,0.0,0.90535475,0.0,0.04877249,0.0,0.0,1.69668476,0.0,1.16031685,0.0,0.14004525,0.0,0.10221530000000001,0.0,0.46600617,0.0,0.0,1.01315395,0.0,0.47348653,3.2248892999999996,0.39085709,0.40086408,0.0,0.0,1.05430804,0.36262792,1.59575582,0.0,0.0,0.0,0.77092405,0.0,0.60527119,0.0,0.21778506,0.0,0.0,0.0,0.49943484,0.0,0.05472908,0.0,1.13951339,1.29961745,0.0,0.0,0.0,0.77785865,2.33275773,0.0,0.14307523,0.25680795,0.0,0.61472757,0.79553836,0.0,0.18881614,0.0,0.38613309,0.93231729,0.0,0.98601735,1.13675575,0.57751402,0.58887332,0.0,2.68240965,0.75222124,2.00055893,0.0,1.10685438,0.56485168,1.61633882,2.4426965,1.23068087,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.439
0.92882392,0.0,0.0,0.225885428,0.271669068,0.0,1.38711587,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.271611001,0.650926631,0.0,0.286985178,0.316780712,0.30891940000000007,0.0,0.0,0.0976836026,0.0,0.0,0.0,0.0,0.0,0.0,1.53175535,1.44322016,0.900528897,0.0,0.620424014,3.60263215,3.01572495,1.28064266,1.12150528,0.0,0.285687425,0.0,1.01100544,0.0465887152,1.27562761,1.03298323,0.0,0.441375733,0.872204471,0.0,0.12674615,0.0,0.7666874459999999,0.0,0.9177241159999999,0.0,0.687061803,0.0,0.0,0.103119265,0.0,1.08430021,0.429442028,0.6982253709999999,0.0,0.476435858,0.982666082,0.908872929,0.5576559560000001,0.228849973,0.0,0.12869406,1.23013584,0.0,0.0,0.257160587,0.0,0.0,0.0,0.0,0.135021993,0.355220937,0.741738982,0.0,0.0,1.12591115,0.0,0.8828126059999999,0.177224198,0.0,1.11841885,0.1794064,0.202784832,0.402472207,0.0,0.0,0.460846629,1.35112605,0.17062103399999998,0.451155342,0.0,0.0,0.67202719,0.0,0.0,0.426914141,0.0,0.0119388202,0.39107185899999997,1.03269753,0.0,0.372356421,1.08688319,0.0,0.171582538,0.320647593,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
7.30045715,6.7098219,4.97331124,3.53205167,2.71565713,1.37754327,0.0,0.0,0.0,0.0,0.0,0.25939736,0.00113286301,0.0,0.656045946,0.7060547209999999,0.908043762,0.627232809,0.0,0.329934409,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12046768199999999,0.798399243,0.285697992,0.442860052,0.285281343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.276075252,0.132593651,0.5161623320000001,1.01309241,0.0,0.10210837800000001,0.52748706,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.71147036,0.0,0.576879835,0.93651816,0.875050965,0.139829068,0.0,0.125713063,0.294490613,0.0,0.0,0.0,0.0,0.0,0.60318449,1.53872752,1.86799746,1.80081859,1.78067112,2.1318534,2.12126177,1.26779997,1.78140482,1.3073926000000002,1.2113598,0.787468794,0.0,0.0,0.273899983,0.0,0.0,0.40506005,0.11260295199999999,0.0,0.0,0.0,0.0,0.202636493,0.0,0.0,0.0,0.0,0.197449878,0.0,0.13651133099999999,0.0,0.532547268,0.0,0.0,0.0,0.44272136700000003,0.42012001299999996,0.0,0.0,0.0,0.253996645,0.0,0.0,0.0,0.354448274,0.214516787,0.0,0.0,0.0,0.470548077,0.329247716,0.584703022,0.0,0.34684843600000004,0.856279217,0.0,0.441944212,0.0,0.517281313,0.0,0.0373457253,0.312210385,0.0,0.0,0.0,0.7397106440000001,0.86797549,0.16961598100000003,0.467017241,0.0,0.870825253,0.18523478699999998,0.0320102444,0.0,0.17782374899999998,0.0,0.250858818,0.0,0.474235836,0.452899139,0.491741411,0.159792456,0.0,0.0,0.09785449759999999,0.0,0.0,0.10831587,0.0,0.0,0.0,0.0,0.0,0.0,0.554394952,0.032828971,0.0,0.0,0.0,0.0,0.0,0.0,0.08313338769999999,0.0,0.0,0.279833422,1.05596764,0.0,0.24364396600000002,0.0383837165,0.104975729,0.0,0.254266285,0.0,0.0,0.0,0.0,0.0,0.448929349,1.22944647,3.29023874,4.3460184,6.15338352,6.80829879,7.16965753,7.58765406,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.69858361,0.820650665,0.9714297479999999,1.13740087,1.29096947,1.39865874,1.43182521,1.37589117,1.23490852,1.0301573,0.793672032,0.559265187,0.35421674299999995,0.194202223,0.0825702115,0.013383693600000001,0.0,0.0,0.0,0.0,0.0,0.013862941200000001,0.033292851,0.0427462733,0.0367766076,0.014718410800000001,0.0,0.0,0.0,0.0,0.0,0.0220685094,0.0705038967,0.09852516210000001,0.0913385634,0.046037361799999996,0.0,0.0,0.0,0.0,0.0,0.028193356200000002,0.150009008,0.247737403,0.287570478,0.253695451,0.155736459,0.027354731299999997,0.0,0.0,0.0,0.0064187396999999995,0.150937229,0.270285952,0.304058919,0.21591423899999998,0.011867983300000001,0.0,0.0,0.0,0.0,0.0,0.54375702,1.29910356,2.04552846,2.62573699,2.91052356,2.83343522,2.40919289,1.73033038,0.942902224,0.20826992800000002,0.0,0.0,0.0,0.0,0.0,0.157142203,0.343164432,0.38311159,0.286232799,0.10461244800000001,0.0,0.0,0.0,0.0,0.0,0.0525789904,0.160328996,0.199896837,0.16469577900000001,0.0755593003,0.0,0.0,0.0,0.0,0.0,0.10150847199999999,0.185819402,0.22333778399999998,0.204129657,0.137817841,0.0489166287,0.0,0.0,0.0,0.0,8.69001242e-18,0.053150338899999997,0.0844067093,0.0833979825,0.052469357599999995,0.00475865621,0.0,0.0,0.0,0.0,0.0,0.031120777599999996,0.0562630191,0.0595855877,0.0414724436,0.0098517772,0.0,0.0,0.0,0.0,0.0,0.018279888799999998,0.0420088747,0.053257291799999995,0.0508209323,0.039174775,0.0272710361,0.026292015800000002,0.0470937205,0.0979485753,0.18290790199999998,0.300832697,0.445017305,0.6033827420000001,0.759359899,0.8936695290000001,0.9871067029999999,1.02411927,0.9965297940000001,0.906386118,0.766853624,0.600411857,0.434356804,0.294523973,0.198907433,0.153131439,0.149350078,0.169157301,0.18977932600000003,0.191644435,0.164829509,0.112139421,0.0476592052,0.0,0.0,0.0,0.0,0.0453610569,0.0843432709,0.0950544841,0.0682945081,0.00990490162,0.0,0.0,0.0,0.0,0.0,0.0719222619,0.1486527,0.176172487,0.137877222,0.0407291054,0.0,0.0,0.0,0.0,0.0,0.102704362,0.26550213,0.35044958600000004,0.30984942600000004,0.134429038,0.0,0.0,0.0,0.0,0.0,0.243012652,1.02054982,1.90183069,2.73837228,3.38401715,3.72950614,3.72732855,3.40031592,2.83225136,2.14394255,1.46216009,0.89040703,0.489290806,0.2708251,0.206499194,0.24488291199999998,0.33213698199999997,0.428704065,0.517508638,0.602346662,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.588539492,0.808588357,0.892225038,0.36185092,0.8573245429999999,0.387922437,0.23925288399999997,0.0,0.0,0.0,0.0,0.0,0.286532264,0.0,0.566449619,0.574321532,0.153129002,0.387519987,0.0,0.127087829,0.0,0.0,0.223147708,0.0,0.0,0.6160303189999999,0.64632564,0.504553954,0.0,0.7851609740000001,0.0951369784,0.0910872431,0.24574174699999998,0.293048049,0.490858695,0.0,0.0,0.500079218,0.0,0.0,0.27388554,0.0,0.223444778,0.185930706,0.191279964,0.0,0.0,0.0,0.130062299,0.0,0.0618050994,0.0,0.0,0.0,0.0,0.0,0.294765051,0.25927318899999996,0.394760204,0.478847032,0.0,0.0,0.481310825,0.0,0.19101516100000002,0.13595576199999998,0.0,0.230112421,0.0,0.0,0.0,0.085551869,0.172024323,0.0691833606,0.394187213,0.189031967,0.37085095,0.0,0.26308607,0.0463587733,0.496352184,0.656960196,0.0133093849,0.476782889,0.640123453,0.133824467,0.0,0.36473608799999996,0.0,0.0,0.0,0.0,0.23675595100000002,0.0572806721,0.833084267,1.28307541,1.98111401,2.60902815,2.54653616,2.32049706,2.52546068,1.79016096,1.39044097,0.8254045940000001,0.539095189,0.0,0.208988302,0.0,0.457910489,1.20572171,1.62030865,1.54505511,1.1659294,1.53839624,0.861746743,0.105809579,0.0,0.0,0.0,0.0,0.0,0.959601558,1.54652553,2.78486116,4.02334537,4.56577805,5.23227282,5.22177146,4.79409701,4.32657877,3.57679673,2.76923989,1.93792107,1.4211322,0.0943525842,0.42226686399999996,0.000972188796,0.7844615640000001,0.191176227,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
4.39125769,4.15766407,3.80539575,3.35579969,2.83551105,2.2746162999999995,1.70460075,1.15623196,0.6575340000000001,0.231999023,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11167326,0.338882041,0.551592454,0.730537918,0.8605752990000001,0.9316312640000001,0.9392105190000001,0.884442312,0.7736790029999999,0.617695866,0.430571705,0.228352998,0.0276184128,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10420417900000001,0.217332947,0.30435821399999996,0.358515905,0.376332554,0.357794829,0.30620726800000003,0.22776133,0.130863419,0.02528925,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0632739474,0.144037843,0.209033356,0.25249375399999996,0.270812114,0.262827007,0.229875754,0.17561537600000002,0.10563251900000001,0.026882514500000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.045952137000000004,0.11530343300000001,0.17296724,0.21355413,0.233330898,0.230553011,0.205609255,0.160967546,0.10092931699999999,0.031217445400000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0418229146,0.120839746,0.193512199,0.25426218899999997,0.298712074,0.324053193,0.329261409,0.31514193,0.284201941,0.240365885,0.188562872,0.134227508,0.0827631365,0.0390195373,0.0068351457499999995,0.0,0.0,0.0,0.0195293885,0.051083264,0.0868254368,0.122014829,0.152011282,0.17276257399999997,0.181227993,0.17569591199999998,0.155963357,0.12335927099999999,0.0806087905,0.0315517871,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0138499023,0.0516022102,0.0804734067,0.0973944451,0.100912147,0.0915020581,0.0716998321,0.046028502400000004,0.020717868799999997,0.0032320560600000003,0.00164034866,0.0238828198,0.0769944447,0.166358063,0.295056938,0.46339152299999997,0.668612738,0.904906537,1.16364323,1.43388172,1.70309559,1.95806703,2.18587753,2.37491329,2.51579905,2.60217742,2.63126157,2.60410654,2.52556755,2.40393969,2.25030127,2.0776093,1.89961892,1.72971571,1.5797601000000001,1.45904493,1.37346034,1.32494474,1.31127825,1.32624686,1.36017436,1.4007871,1.43434675,1.44696123,1.4259658000000002,1.36125644,1.24645835,1.07982217,0.864760045,0.609961216,0.329059679,0.0398631909,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.235563661,0.731466603,1.28878524,1.88017839,2.47502361,3.04137118,3.54803673,3.96668002,4.27371683,4.45192187,4.4916029,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.253733301,0.0,0.769195893,0.49035327100000003,0.392487884,0.0,0.327733255,0.0,0.0,0.0477615672,0.6815253290000001,1.10337918,0.0,0.0202728477,0.575501886,0.0,1.34858976,0.0,0.127628259,0.0,0.0,0.0,0.42904543700000003,0.967281937,0.201035663,0.0,0.084600903,0.8208431690000001,0.394983662,0.0,0.0,0.16804237600000002,0.40034976,0.15267001,0.0,0.0,0.0,0.0,0.11500737,0.05925725230000001,0.0,0.6894512909999999,0.794450553,0.5587618320000001,0.559578934,0.0,1.211342,0.763117575,0.755624341,1.06940054,0.902837965,1.22261045,0.0641765499,0.731533575,0.9753359109999999,0.5984571329999999,1.70575684,0.0,1.21096942,0.8513252040000001,0.0,1.27276434,0.43868401100000004,1.0155878,1.3131204,0.472738671,1.24852438,0.709977689,1.51844473,1.01566479,0.7839393720000001,1.384239,1.19080998,1.10152428,0.718912065,1.29946276,0.16020057599999998,0.30746509,1.08543075,0.947824142,0.7026267159999999,0.291220594,0.777181459,0.12352759,0.330344052,1.05442199,0.302210128,0.629650135,0.0,1.21047656,1.0658238000000002,1.1931935,1.22336908,0.5505909999999999,0.767768234,1.11698219,0.24099426399999999,0.8584964209999999,1.45178195,0.0,0.0,0.146481572,0.332601222,0.53176287,0.0,0.0,0.8461907390000001,0.256857952,0.38124026899999996,0.568030689,0.036166946299999995,0.012727919099999999,0.315373593,0.0,0.0,0.397954684,0.0,0.945596135,0.0,0.0,0.0,0.7657559970000001,0.0,0.0,0.60928542,0.19317446,0.0,0.0,0.623646226,0.366377965,0.269468435,0.0,0.355856758,0.0,0.0,0.0325014806,0.0,0.854251698,0.0,0.18089300100000003,0.0,0.0,0.501321545,0.050700440199999995,0.0,0.0,0.37030968799999997,0.202179268,0.532963685,0.32350283399999996,0.865446319,0.241214095,0.821253888,0.326632553,0.197585555,0.997900876,0.6170637729999999,0.6350293029999999,0.0,0.856006954,0.583330328,0.842501033,2.04345952,1.5615003,0.9942332009999999,2.27878522,1.35809484,1.11722778,2.00612183,1.88888275,2.49230292,2.7662283,1.5356435,2.20147917,1.10564061,1.91695525,1.25715186,2.1925707,1.20331486,1.05586251,1.51592515,1.1564495000000001,0.716221854,1.01929984,1.0921370000000001,0.5982135000000001,2.07530128,1.70035306,1.98114314,1.61193647,2.26479126,1.22721935,2.27161839,2.64165634,2.08747485,3.51383058,2.95141146,1.37247976,2.55843,1.41139914,2.06106039,2.33148329,2.40023416,1.75827565,0.769842111,1.06442363,1.22541599,1.51054195,1.61925571,0.601558419,0.060983069400000006,0.64631612,0.317695997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
4.1533269,4.04199277,4.19441128,3.51275276,3.23475586,2.58612928,2.1782407999999998,1.07012043,1.28282963,0.0,0.11474081,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14162334,0.18029812,0.94466947,1.11675862,1.18516629,1.41463768,2.2179081000000003,2.15901692,2.3003607,2.09500009,2.43511021,1.60046858,1.55968351,1.84929023,0.83105639,0.6573382,0.93602391,0.15923759,0.54569047,0.64907348,0.04660238,0.0,0.0,0.10729181,0.37818644,0.0,0.0,0.45032323,0.0,0.37522598,0.19772998,0.31545209999999996,0.36055536,0.12239760000000001,0.0,0.0,0.0,0.09626816,0.18497478,0.16850312,0.29059157,0.08031522,0.06200339,0.22902233,0.01421343,0.42934487,0.18294146,0.76499022,0.59573165,0.66213917,0.52303775,0.12309413,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18245566,0.31527627,0.16166176,0.94158755,2.06246443,2.20337643,2.3889815,3.47576796,3.47422999,3.80484396,4.30249128,4.21746405,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.00938733,1.58623504,0.730028859,0.0,0.906595328,0.806311838,0.0,0.0,0.0,1.22724689,0.0,0.131448755,1.38408897,0.0,2.86269357,1.6669793000000002,1.44761698,0.0,0.0,0.0,1.56888469,1.09423659,0.000872338301,0.0,0.0,0.678019052,0.0,0.0,1.20030703,2.56302338,5.58650631,3.69459456,5.05400807,0.6508284329999999,0.0,0.0,1.21525582,1.96814057,1.60051281,0.0,1.12334313,0.0,0.0,2.16700944,0.481540294,0.0,0.0791786969,0.3649705,0.137599353,0.804854225,0.6765031890000001,0.0704194447,0.143512802,0.26334853,0.0,1.01570043,0.0,1.76964529,1.01762824,2.31625554,0.0,0.712466899,0.0,0.0354674159,0.0,0.0,0.0,2.16764949,0.008985624690000001,0.11291436,2.04611037,0.0,0.7256091640000001,1.47581728,1.55679807,0.0,1.30698068,0.955223596,0.549158418,0.0,0.0,0.460491011,0.0,1.4825133999999998,1.2028472,3.29956769,0.7093567390000001,0.0,0.9547384729999999,0.0,0.699280128,1.796301,0.118559447,0.372849428,1.30818449,0.0,1.18973646,0.0,0.0738110778,0.0,2.07271181,1.41809479,0.6769908090000001,0.920554271,0.0906254016,0.194402455,0.7029937690000001,1.28044996,0.0,0.897519359,0.828956935,0.0,0.0,0.08252523889999999,0.0,0.0,0.0,0.0,0.0,0.0,0.551919469,1.50081651,1.57245492,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
12.095579699999998,7.60126582,1.4727924,0.0,0.0,0.0894792699,0.531583638,0.290532744,0.0,1.31170658,0.19305238600000002,0.31929387600000003,1.20742268,0.0,0.721059861,0.0,0.0,0.202574313,0.0,0.0,0.0,0.614002787,0.227068197,0.6813099640000001,0.838826944,1.14382196,0.336068039,0.0,0.0,0.120749568,0.0,0.0285971435,0.65847084,0.395116862,0.00208612507,1.13871512,0.0238838527,0.0664857768,0.19923136,2.20113998,3.39597119,2.66799519,0.0,0.0,0.17667632,0.47563321399999997,0.0,0.0,1.10557116,6.709165700000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
2.52035506,2.28535769,2.86778524,2.85955777,3.50044023,3.26778463,2.21566071,1.45413851,0.588029482,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.607297633,0.47383211700000005,1.73622481,0.660573725,0.7416888070000001,0.0,0.0,0.0,0.0,0.0,1.04337793,2.34590023,4.39606811,7.24221097,7.32114205,7.80904593,6.33311788,4.91319645,3.76283652,0.780659395,0.5779720620000001,0.0,0.0,0.0,0.0,0.0,1.0931517,0.7951621109999999,0.09619469119999999,0.799375305,0.0,0.0,0.0,0.0,0.0,0.222912625,0.042479331399999994,0.0,0.5395422360000001,0.38899470799999997,0.0,0.0,0.909533613,0.78900789,1.11564399,1.511755,2.09957654,1.68230175,1.44234206,1.7380141,0.963400444,0.20236100899999998,0.0,0.0,0.0,0.0,0.0,0.47009642100000004,0.0,0.0843375819,1.06702281,0.21085684899999999,0.676753697,0.35614047,0.0,0.259789058,0.0,0.623281538,0.0,0.0,0.8392022459999999,0.0,0.488009168,0.41725260700000005,0.20645621100000003,0.532383905,0.0,0.124439773,0.19530256699999998,0.0,0.221533416,0.0,0.43608069,0.23993891399999998,0.587295462,0.555720753,0.0,0.581494235,0.0,0.26508560800000003,0.0,0.0,0.0,0.0,0.508636415,0.485808081,0.0,0.151449693,0.0,0.027720414900000004,0.0,0.23758375,0.703424828,0.0,0.314132841,0.0,0.0,0.0,0.0,0.12636459,0.0,0.0,0.0,0.0,0.447035366,0.0,0.447008671,0.589801542,0.0,0.0,0.149177607,0.508197364,0.100390516,0.261540441,0.0,0.0,0.613904887,0.873499641,0.38735488100000004,0.0,0.284544841,0.993375528,1.28049649,0.807004252,1.06173938,1.25825868,0.7013706559999999,0.0,1.03320834,0.007505074499999999,0.0,0.5706592770000001,0.0,0.0504754343,0.0,0.0,0.25648271100000003,0.0,0.966590726,0.127790795,0.0,0.442910385,0.200447737,0.046593699999999995,0.0,0.0,0.09070493019999999,0.0,0.119252564,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.6604468720000001,0.526083461,0.3762242,0.730100284,0.9617331290000001,2.45447529,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46799999999999997
0.604801618,0.0,0.361932835,1.81152477,0.0,0.649346831,0.117071331,0.0,0.509246677,0.423360752,0.665632266,0.7310751190000001,0.808664022,1.15645086,0.8105643090000001,0.536698859,0.540538589,0.798496235,0.622190657,0.340241525,0.0,0.81723239,0.0,0.0,0.0961396985,1.10188727,0.40688453399999996,0.707015497,0.582451234,0.0,0.21183572399999998,0.0,0.0,1.27380494,0.0,0.0686961093,0.0,0.745669523,2.58775406,2.79095989,3.19938624,1.99588535,2.40172654,0.693788631,0.164925574,0.0,0.990593278,0.0,0.465124352,0.0,0.0,0.031051143,1.92948014,0.0,0.0,1.3848694,0.491697184,0.0,1.72188329,1.27653081,1.622357,0.46652490399999996,0.9794956920000001,0.159096563,0.0,0.0,0.0,0.6138072760000001,0.289150429,0.43859864200000004,0.5786203839999999,0.251322667,0.0,0.0,0.0,0.0,0.0,0.0,0.33567475399999996,0.702647347,0.521822545,0.0,0.8457655040000001,0.0,0.273331175,1.1626054,1.53036124,1.77541778,0.352839009,0.0,0.9491927290000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
0.4322457,0.669497155,1.03240768,1.33255456,1.37177074,1.08780216,0.606864555,0.162773103,0.0,0.0,0.109594515,0.185735575,0.11001193699999999,0.0,0.0,0.0,0.0,0.14915552599999998,0.192545603,0.08440888390000001,0.0,0.0,0.0,0.017444643500000002,0.159944327,0.175362497,0.0531690395,0.0,0.0,0.0,0.045398768,0.16885165,0.159140752,0.024039286099999998,0.0,0.0,0.0,0.0738512424,0.18232147699999998,0.147887871,0.0,0.0,0.0,0.0,0.11084803,0.21186106600000001,0.147308512,0.0,0.0,0.0,0.0,0.18612801699999998,0.30313076,0.18209540800000001,0.0,0.0,0.0,0.0,0.662366094,1.36810226,1.77625238,1.70634954,1.20694646,0.519443227,0.0,0.0,0.0,0.0,0.137170289,0.197044697,0.10547324599999999,0.0,0.0,0.0,0.08927894630000001,0.297437025,0.45208592799999997,0.494165105,0.420414962,0.273582113,0.11462752300000001,0.0,0.0,0.0,0.0,0.025493290800000002,0.04275641610000001,0.0270071393,0.0,0.0,0.0,0.0,0.0319945892,0.049543843399999996,0.0278415106,0.0,0.0,0.0,0.0,0.06131700019999999,0.0820694103,0.0356246635,0.0,0.0,0.0,0.0196468292,0.132478935,0.15468507199999998,0.044392791900000006,0.0,0.0,0.0,0.0949473844,0.349306579,0.36911114899999997,0.0415490285,0.0,0.0,0.0,0.6880889020000001,2.47050862,4.23100349,5.23486642,5.0356061,3.72974593,1.9132022000000002,0.35561165299999997,0.0,0.0,0.13785485,0.5475712070000001,0.58137585,0.321215548,0.09568224089999999,0.18430576899999998,0.580927094,0.990946172,1.05965985,0.655531277,0.0,0.0,0.0,0.0,0.43429942200000005,0.6869310240000001,0.445857026,0.0,0.0,0.0,0.0,0.410381571,0.633570974,0.35782559399999997,0.0,0.0,0.0,0.0,0.538918919,0.709076612,0.314511292,0.0,0.0,0.0,0.0916421483,0.784016998,0.901793785,0.28103584800000003,0.0,0.0,0.0,0.441175616,1.83267902,2.5321173,2.14954825,1.03139017,0.0124084968,0.0,0.392202261,1.11054558,1.06253649,0.0,0.0,0.0,0.0,3.38368646,8.31489546,12.135069300000001,13.0199923,10.489821699999998,5.70153137,0.8038178220000001,0.0,0.0,0.0,0.678830598,1.64036394,1.23959145,0.0362061418,0.0,0.0,0.0,0.48374451799999996,0.911669845,0.611981122,0.0,0.0,0.0,0.0,0.406813309,0.624216221,0.351864491,0.0,0.0,0.0,0.0,0.358265885,0.461384635,0.206127577,0.0,0.0,0.0,0.025990904199999998,0.31975997100000003,0.351239408,0.11198715199999999,0.0,0.0,0.0,0.0713618026,0.285317398,0.269136355,0.046844881399999996,0.0,0.0,0.0,0.109445037,0.315516388,0.382428751,0.37092511799999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.507
0.133178873,0.0,0.0,0.0,0.435048651,0.0,6.71027302,2.83386537,0.0,2.09810527,0.0,0.637068935,0.0,2.68854,2.26874731,0.653453629,0.012103948,0.0,0.386140214,0.0,2.62628388,3.87053847,0.692473903,0.147758427,0.0835552087,2.14710326,0.0,0.790446415,0.8741939870000001,0.440044163,0.140570636,0.43154037100000003,2.92255673,2.49119352,0.347991805,0.0,0.590397837,0.0,1.52899503,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
0.95906486,0.0,0.106647869,0.40112756200000005,0.0,0.055290364,0.528223022,0.28425808,1.40378724,2.29188091,1.22888503,0.559170422,0.6564922329999999,0.209168722,0.010556731399999998,0.0648619898,0.0,0.0537580305,0.0992723936,0.0,0.0762098996,0.106822584,0.0,0.0972311896,0.10840568699999999,0.0,0.120559173,0.10818828400000001,0.0,0.149087848,0.107746591,0.0,0.18725055300000001,0.108272745,0.0,0.244846058,0.11218931800000001,0.0,0.364940335,0.244531093,0.0,0.5046344,0.140557809,0.0,1.79389309,4.60937602,1.87894806,0.0,0.0,0.225115442,0.0,0.0,0.0,0.785329596,2.09831184,0.8494567890000001,0.0,0.567884211,0.5812542079999999,0.160441216,0.664869306,0.355131364,0.0,0.214047185,0.662490734,0.706867004,1.16875655,1.2216694,0.7530290959999999,0.5387472010000001,0.252939117,0.0,0.031976053500000004,0.0379654653,0.0,0.030774805899999997,0.0649428534,0.09214889710000002,0.46950453299999995,1.42788646,3.09077676,4.45287846,4.05965935,2.5749686,1.93778625,2.10541075,1.52104182,0.35045872,0.0,0.102374626,0.0,0.0,0.13670668,0.0,0.0,0.18101413,0.0,0.0,0.266378744,0.0,0.0,0.48962117899999996,0.0,0.05438007,3.41117591,3.10785422,0.0,0.0,0.7364884890000001,0.0,0.0,0.370921955,0.0432433908,0.0,0.045470203099999995,0.0184768025,0.369718339,0.199273437,0.0797524759,1.276967,1.31815584,0.0,0.0,0.395656516,0.0,0.0,0.282024557,0.0,0.0,0.23292116899999998,0.0,0.0,0.21053493899999998,0.0,0.0,0.298026931,0.0634056406,0.0,0.18925398899999998,0.0773107833,0.0,0.0751964101,0.155026327,0.312703742,0.260069132,0.198321606,0.320982518,0.11223494199999999,0.0348204446,0.22730903100000002,0.0,0.547247854,1.79021837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.35104964,0.0,0.0,1.1694591,2.76317226,0.0,0.6552041000000001,0.74389703,0.06280487,0.22613661,2.98770843,0.0,0.0,0.0,0.19109287,0.0,0.0,0.62933073,0.0,0.28846809,0.58371394,0.52849701,0.0,0.9042237,0.0,0.18753184,0.82267976,0.75217222,0.0,1.49476745,3.38968466,0.0,0.57302883,1.33596189,0.0,0.0,1.05616671,0.0,0.0,0.0,2.52288672,0.0,0.0,1.80908346,0.0,0.7028350999999999,0.0,0.0,0.44287802,0.0,0.0,0.0,0.37364934,0.74366166,2.68628726,0.0,0.0,0.88913746,0.0,0.48877506,0.0,0.31007209,0.0,0.0,0.0,0.0,0.14632916,0.0,0.07663229,0.0,0.51958206,2.03445984,0.0,0.0,0.6103965,0.0,0.0,0.87474705,0.32244212,0.32460749,0.0,0.24327326,0.0,0.0,1.04679275,0.14460654,0.0,0.65720307,1.87188445,1.49178516,0.13693375,0.0,0.0,0.0,1.50580919,0.7382265,0.0,0.74023787,0.38686618,0.0,0.0,1.43947795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.68047248,2.2423041,4.48964447,5.57546297,2.88664821,5.5916682,6.20220109,4.50944459,3.36519406,2.20220587,0.76866316,2.82703015,0.36762023,0.0,0.0,0.0,0.0,0.37521193,1.25427032,0.0,2.79217473,0.79957344,0.20687991,0.563258,0.0,0.0,0.0,0.0,0.0,0.0,2.28453254,0.13600421,0.0,0.0,0.0,0.0,0.55250957,0.0,0.0,0.72424505,1.47038174,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.65577641,1.15809446,0.0,1.22257235,0.0,0.0,0.0,1.19482864,0.30648938,0.79353192,0.0,1.73029511,0.73681167,1.66755035,0.0,0.0,0.38992845,0.34362420000000005,0.0,0.21769523,1.05562415,0.83145102,0.0,1.04108026,0.0,1.92151424,0.14780958,0.0,1.10281412,0.0,1.21625324,0.0,0.74260556,0.16640643,0.0,1.57230798,0.0,0.0,0.0,0.0,0.0,0.38307005,0.0,0.0,0.0,1.96260022,0.0,0.98979453,0.0,0.0,0.0,0.0,0.27395014,0.0,0.0,0.0,0.83295477,0.0,0.19639147,1.60045752,0.0,0.41633031,0.62124007,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
4.18639065,2.32569586,0.917505417,0.82838436,0.26602139,0.14537729,0.0,0.0,0.68102378,0.0,0.0,0.0,0.0,0.0,2.19552376,4.48322454,1.73576632,0.0,0.0,0.0,0.0,1.11348824,0.0,0.0,0.70118402,0.0,0.0392377662,0.0,0.103588891,1.27927042,0.0,0.0,0.0,1.91217744,1.34760276,0.622089648,0.0,0.09547470050000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.162379622,0.0,0.0,2.44357028,6.29132822,6.0139977,0.37385804,0.0,0.0,0.224897572,2.14908985,0.704003921,1.07297442,0.5380615879999999,0.06209435,0.333664534,0.0,0.0,1.08930659,0.48479451799999995,0.0,0.0,0.0,0.0,0.0,1.24106057,0.0,0.0,0.820910383,1.82966767,0.0513471306,0.875409615,0.0,0.574949909,0.458264606,0.14784329,2.53802255,1.11008028,0.08257404980000001,0.0,1.09409354,0.0,0.0,0.0,1.43382562,0.171158187,0.0,0.264625432,0.0,0.216691457,0.0,0.282691696,0.093774118,1.20884417,0.490996316,0.0,1.43583096,1.70584544,0.263694102,0.0,1.35547752,0.0,1.01871067,0.0,0.0,0.0,0.0,0.861961801,0.0,1.13448044,0.0,0.288652924,1.25886352,1.77118914,2.42270993,0.0,1.75430263,0.0,0.0616523467,0.0,2.96460922e-05,0.0,0.5020305070000001,0.0,0.0,0.0,2.74029763,2.20686604,1.85018926,3.3236833,0.758661205,1.06073574,0.34219982600000004,1.79143182,1.08644114,0.0,0.0,0.0,1.5982027,1.75970479,1.94214034,0.328652434,0.240417797,0.0,0.0,0.0,0.0,3.0221767999999996,0.64836538,0.0,0.706901324,0.9847015379999999,0.0,0.0,0.586177849,0.0,0.879526591,0.0,0.8677726729999999,0.0,0.31669370199999997,0.0,1.24902225,0.0406554323,0.0,0.0,0.26965123,0.9352809590000001,0.0,0.0,1.52877658,2.09875258,1.76479427,0.26143399,0.0,0.0,0.0,0.496785904,0.0,1.73820749,0.0,2.95726874,0.14656757,2.7382927,0.0,0.6201350210000001,1.00416751,0.022484627799999997,0.0,0.0,0.0,0.0,0.0,0.0,0.10040687599999999,2.56174021,0.626123337,3.07920006,0.23452019,1.47503122,1.81643814,0.0,0.0,0.0,1.18183482,1.23717723,0.0,0.0,0.37085133299999995,0.0,2.14140329,1.29104699,1.09303219,1.27331139,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.20061585,0.0,1.37398317,2.29435993,0.0,0.0,0.0,0.0,0.98431584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.2288017000000004,0.0,1.86267971,1.0365165,0.0,0.0,0.55634073,0.0,1.92726035,0.29833525,1.02880133,0.59044358,0.0,0.0,3.04414214,0.0,0.0,2.02155441,2.08718761,2.28145358,1.5532787000000001,0.0,1.97116383,1.14126508,0.75330018,0.0,0.0,0.45023771,1.27970786,0.50114236,0.0,0.0,0.0,1.24276852,0.0,2.89983415,0.0,0.0,0.30713682,0.0,1.99584261,0.0,3.07760488,0.0,0.0,0.0,2.16341036,4.48383558,0.0,0.0,0.0,3.51103555,1.51583307,0.0,0.98005223,0.49615329999999996,0.0,1.21732724,2.73830293,0.0,0.0,0.0,0.0,0.10988534,0.0,0.0,2.23323943,0.0,0.42452049,0.5723583999999999,0.0,0.0,0.0,0.0,1.1012659,2.61604116,0.0,0.0,0.73378953,0.0,0.0,1.1526889999999999,0.0,3.02482884,0.0,0.0,3.49027253,7.79113097,10.75005089,1.81340658,0.0,0.0,0.0,0.0,0.0,0.0,3.17258208,0.0,0.0,3.18816293,0.30037456,1.76298629,0.0,0.51021902,0.0,3.15100362,1.14822192,0.0,0.0,0.0,0.0,0.0,0.0,0.50617216,3.72642784,0.0,0.26323255,0.0,1.80713331,0.0,0.0,1.73157419,0.0,1.0421818999999999,0.11388168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46399999999999997
0.41220387,0.0,0.0,0.319468822,0.0,0.298801711,0.18528854600000003,0.49260286799999997,0.448452405,0.28162828,0.0,0.23296382,0.30929466,0.131069902,0.35579363700000005,0.0,0.141562726,0.0920869901,0.23485698300000002,0.0,0.0,0.0,0.194078425,0.0437635166,1.07851205,1.13470195,1.4247616,0.652126173,0.0,0.0,0.123254211,0.280334757,0.076261192,0.0,0.0,0.0,0.24670482100000002,0.263977658,0.424523969,0.0,0.0,0.0,0.0,0.163694998,0.0,0.0813809461,0.182548766,0.568342904,0.0243414019,0.0,0.0,0.0,0.611149124,2.21282804,3.06043615,3.49370484,2.34420055,1.87218085,0.64153831,0.0,0.233419194,0.38929363100000003,0.0,0.0,0.165045559,0.350109968,0.0,0.0647291898,0.0,0.249055587,0.0,0.0,0.27679597,0.039895619300000004,0.0,0.0243606163,0.18353931399999998,0.908184262,1.73458491,2.40722119,2.87698862,2.70604243,1.17980055,0.42130967700000005,0.0,0.0,0.217799265,0.181417655,0.0,0.0,0.0,0.0671485715,0.463001888,0.46147682799999995,0.044843743,0.30384424,0.284367992,0.0,0.419080345,0.452333835,0.622298829,0.8092681290000001,0.549603985,0.600409249,0.0,0.307687444,0.0,0.09637355539999999,0.0,0.0,0.118228809,0.0,0.0,0.0,0.0,0.0,0.221554681,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.125926971,0.0,0.0,0.0,0.179161634,0.321510185,0.0,0.085176395,0.25516083300000003,0.300449923,1.20788318,1.13618267,1.51125361,1.29341441,1.44892309,1.38810963,1.75480411,1.39792246,0.755736952,0.521370431,1.0629898000000002,0.6552865929999999,0.518065734,0.594981823,0.726495757,0.6736717959999999,0.686583286,0.746503537,1.16960692,1.1452498,1.43985528,1.2724465,1.31673364,1.08438906,0.488422997,0.0,0.178590017,0.0,0.0948979842,0.0,0.0,0.193686219,0.439582695,0.6917490559999999,0.891000186,0.632064062,0.69237091,1.3786671999999998,1.23786765,0.847513903,0.42235692399999997,0.0,0.0,0.140491674,0.0,0.549362016,0.21952182399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
4.37546286,2.3254874,2.79160457,0.0,3.31562709,1.64732613,8.64185061,9.00561129,2.60992369,0.0,0.20636696,0.69189471,0.21092513,0.86123748,0.82792924,0.62988373,1.31303494,0.13802988,5.17602143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
0.42917141700000005,0.35316872200000005,0.0425794107,0.254963252,0.128906919,0.0,0.0,0.479899452,0.0279460629,0.07713038400000001,0.436418175,0.0,0.0,0.451539817,0.0,0.7193960490000001,0.192266863,0.230683859,0.0,0.0,0.0,0.465161847,0.0,0.0,0.0987173565,0.43866653200000005,0.216010797,0.0,0.0323218453,0.30692841600000004,0.0,0.0,0.43086939700000004,0.0,0.23265864100000003,0.0,0.320965925,0.0,0.0,0.0,0.0,0.0,0.291660847,0.226852195,0.0,0.0,0.6442748770000001,0.22950107399999997,0.7186565890000001,1.74434702,1.61222932,0.531006596,0.533241969,0.0,0.0683463626,1.44488268,2.5227584,2.9706446,2.69068436,2.04966943,0.9055999370000001,0.0,0.0,0.216905431,0.00125637417,0.572522312,0.34130365700000004,0.0,0.0,0.0,0.35368091100000004,0.576133299,1.37688608,1.13436661,0.008424967890000001,0.470336439,2.01304811,2.89594984,4.63554494,5.42217419,4.48944246,2.94569147,0.977512514,0.163178162,0.0,0.0,0.553023212,0.152397657,0.0,0.0,0.0,0.24172676399999998,0.5040741639999999,0.400800559,0.4311707,0.253324368,0.355217357,0.16943187399999998,0.49298380700000005,0.112277736,0.0,0.200083636,0.0539941796,0.0,0.0,0.341947913,0.0655414806,0.56841969,0.0,0.0,0.48785382,0.542460352,0.0,0.3219258,0.0,0.0,0.198610565,0.17611213,0.369693252,0.0,0.0350387608,0.0,0.0,0.193007226,0.0,0.0,0.281218064,0.0,0.136780102,0.0,0.210583176,0.210429294,0.0,0.034394876899999996,0.00960368925,0.0466717459,0.0,0.0,0.0,0.0,0.44441507,0.053955642000000005,0.212990481,0.0,0.0693063505,0.19019191100000002,0.254957899,0.0,0.0427110267,0.0,0.0,0.0016384772199999997,0.0623902767,0.770007021,0.690339795,0.376044625,0.46221270200000003,0.059415234299999994,0.36674143299999995,0.780082426,0.0659277984,0.0,0.122332516,0.0,0.387426731,0.14780994,0.723937712,0.6519320120000001,0.360482425,0.0,0.0,0.39080976799999995,0.490045766,0.556615314,0.126187591,0.0,0.0,0.190831005,0.329737273,0.234626857,0.0264477427,0.0,0.13739099300000002,0.0838495229,0.238260857,0.72211304,0.333001232,0.0,0.0,0.0,0.147103064,0.342432478,0.21523175,0.354579097,0.0,0.0,0.0,1.4578351999999999,2.91349761,4.07830633,3.36350085,2.31360851,1.32123484,1.656594,0.904897981,1.92110828,1.54579246,1.26025157,0.39635740799999997,0.051130701699999996,0.0,0.0,0.503723036,0.298611892,0.375429067,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.7407148459999999,1.78535682,0.0,1.32855775,1.23174063,1.03138675,5.06778541,2.31826412,1.40560915,0.716800027,0.0,0.0,0.0,0.0,0.41375395600000003,0.21731630899999999,0.0,0.9518705279999999,0.612749688,5.10108014,0.168401855,0.989014995,1.48453212,0.0,0.563746593,0.09912323869999999,0.620124398,0.224151746,0.0,0.353612772,0.591118216,0.0567754866,0.333993843,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
1.3167316,0.0,0.0,0.392914285,1.15188357,0.48188965,0.0,0.0,5.56901236e-16,1.64688681,1.40332442,0.0,0.0,0.0,2.91283982,6.17439632,5.45503093,1.74986499,0.0,3.37191119,11.2657143,17.5564854,16.9266202,9.51605677,0.75241806,0.0,0.0,1.07351781,2.43372263,0.822813693,0.0,0.0,0.0,1.36824063,0.9744276690000001,0.0,0.0,0.0,0.770903342,0.9600346559999999,0.0,0.0,0.0,0.33865553,0.855791733,0.317433994,0.0,0.0,0.0,0.690308765,0.517067854,0.0,0.0,0.0,0.481937625,0.6209837220000001,0.0,0.0,0.0,0.24656472100000001,0.639534621,0.24321672,0.0,0.0,4.55646466e-16,0.57916516,0.442908869,0.0,0.0,0.0,0.445258461,0.583432678,0.0,0.0,0.0,0.24353929300000002,0.633579267,0.239133872,0.0,0.0,0.188104515,0.757841193,0.494843308,0.0,0.0,0.969007269,2.42475497,2.65205999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.5379999999999999
1.2513669,0.0,2.79904685,6.28960548,4.65969057,5.80984898,0.250880222,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.353108676,0.0,0.06814778269999999,0.0,0.6871093859999999,0.275943195,0.40770675100000003,1.23379411,2.08224655,1.88509529,0.0,0.535457875,0.0,0.0,0.0,0.642618224,0.660342146,0.362495422,0.0,0.7146623809999999,1.52563086,0.259790795,0.7076615540000001,0.0,0.253350305,0.0,0.0,0.0,0.132030655,1.40516523,1.58825371,1.62764006,0.0,0.93524474,0.0,0.584316433,1.52712937,0.0,0.0,0.0,0.0,0.7094419129999999,0.0,0.0,0.0,1.23081828,0.65957455,1.01666541,0.0,0.182830427,0.0,0.28340656,1.05984954,1.22336227,1.14589783,1.82118779,0.418571993,0.887778343,0.253862724,0.771683022,0.608432967,0.0594267012,1.11094479,0.0825378735,0.34638876700000004,0.696743113,0.0,0.5403088970000001,0.0,0.0,1.47402949,1.66878657,1.42771612,0.34305242700000005,0.0,0.963882895,0.0,0.995390619,0.0,0.0,0.39750101299999996,0.0,0.7698739029999999,0.0364333855,1.46386847,0.349547975,0.16322067099999998,0.0,0.0,1.75575706,1.48510467,3.97675538,0.459204049,0.0,0.0,0.780341287,0.0379688061,0.7260560629999999,0.0,1.48393951,0.0,1.48289927,0.0,0.00923330177,1.24820774,0.0,0.0,0.0,0.0,0.438887276,0.0,0.945034626,0.0,0.0,0.0,1.31964275,0.0728011739,0.844221232,0.40210945600000003,1.36429901,0.6017068760000001,0.0,0.0,0.0,0.29040488,0.0,0.0,0.576370331,0.436652621,0.0,0.547486267,0.100630601,0.8682639329999999,0.028297085,1.4195147,0.0,0.34248175700000005,1.14964694,0.0,1.48453223,0.131967685,0.181206814,1.41757215,0.7545686620000001,0.316488912,0.66915004,0.5545595839999999,0.273113076,0.0,0.12325731599999999,0.0,0.0634839629,0.0,0.0,0.213598221,0.0,0.0,0.7152503170000001,2.01373601,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.169690409,0.503522504,0.618887689,1.02180872,1.74585932,2.26546025,2.38976521,2.73498878,3.2924468,3.14590307,3.24338652,2.90087354,2.16236147,1.86999074,1.44507675,1.05957305,0.965475961,0.30463043100000003,0.12495789199999999,0.079412904,0.168106913,0.0,0.0,0.0,0.0,0.012646476100000002,0.326610512,0.34206341,0.613591165,0.357205616,0.38425165,0.0644663647,0.220120211,0.15336570300000002,0.013206225700000001,0.516981669,0.0541944862,0.289117364,0.435542805,0.448594315,0.45357665700000005,0.0,0.0,0.0543156516,0.0,0.435210445,0.53656507,1.45133886,1.43065908,1.98722033,2.55532608,2.51761046,2.30963604,1.70656852,1.42335647,0.605180018,0.5407657779999999,0.0,0.0,0.0,0.208133669,0.424801781,0.571570613,0.43255742700000005,0.549521329,0.24553065,0.0689719386,0.522577242,0.0,0.298782229,0.290456102,0.423023549,0.052544445099999997,0.0,0.0,0.248742441,0.0,0.0,0.029559231499999998,0.0,0.336727965,0.468914833,0.0242661162,0.12719260699999999,0.38670736299999997,0.359837523,0.356356155,0.0,0.0,0.09887239449999999,0.333857948,0.526947411,0.43598157200000004,0.0558554795,0.489672648,0.20696094899999998,0.0,0.0,0.056379827,0.0,0.269550701,0.193267942,0.563700211,0.554892443,0.455257316,0.372964801,0.380473501,0.00745880193,0.18065592,0.29796932,0.265516488,0.49094550299999995,0.5358144189999999,0.300975228,0.7205995070000001,0.357476694,0.5785291920000001,0.498603512,0.44718654799999996,0.687808078,0.610266246,0.636322161,1.04995501,0.55519633,0.953134335,1.08614011,1.01343231,1.4353619,1.07210232,1.11979195,0.952996507,1.17201833,0.766340318,0.718191947,0.404771001,0.317492599,0.0134511635,0.383901045,0.0,0.284300973,0.327372047,0.0,0.0768340359,0.0,0.149038296,0.0,0.0,0.0,0.494379561,0.42382887799999996,0.7011076970000001,0.534652235,0.390836309,0.62300765,0.691557889,0.6247018910000001,0.464311532,0.140136291,0.560922511,0.117015298,0.164643997,0.111326874,0.0218798038,0.334309139,0.308269815,0.628746445,0.690502608,1.31679735,1.1505424,1.16929826,1.09500144,1.51184769,1.2118817,1.11114418,0.846572159,0.6283746139999999,0.608919325,0.798149058,1.13468979,0.896283576,0.796595672,1.14702436,1.34311263,1.17691896,1.02437011,1.12268048,0.6587076239999999,0.621705427,0.768928363,1.03186953,0.813002454,0.909444198,0.933797384,1.0731926999999999,1.24632113,0.977987022,1.00361818,0.7412481870000001,0.201834515,0.0,0.054191354000000004,0.0,0.0,0.274305627,0.0,0.0,0.0,0.296851441,0.138150947,0.0,0.178405736,0.17121683,0.312418943,0.00046068606500000004,0.0,0.0990409776,0.0492923266,0.198647375,0.221506512,0.0,0.0,0.0,0.00370663258,0.0791444115,0.355116075,0.04927744059999999,0.0,0.19137819600000003,0.221189506,0.0,0.19089156699999998,0.0871679833,0.204596045,0.384107531,0.132406065,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.9230391809999999,3.06084872,3.98136239,2.98747854,1.1046694,0.0,0.0,0.0,0.121501977,0.0509750828,0.0,0.0029639547499999996,0.0,0.0,0.0,0.0658947253,0.08440458,0.0,0.0,0.0,0.143319255,0.108899828,0.0,0.0,0.025400088900000003,0.241287406,0.104246491,0.0,0.0,0.144101532,0.41692881299999995,0.055482721500000005,0.0,0.0,0.7939841879999999,1.92076048,1.86729673,0.958432754,0.851866695,2.5611776,4.97822722,5.88437519,4.44541779,2.22934648,1.45588472,2.53106851,3.7809013999999994,3.58245379,2.2029801,1.18088996,1.24409033,1.50254986,0.855793736,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.13015711,0.35631196,0.31269163,0.45278795,0.0,0.40703540000000005,0.0,0.84748025,0.0,1.16314242,1.7809877,0.0,0.0,0.0,1.43559883,0.30309774,0.0,0.78235559,0.48727914,0.0,0.26689135,0.25860473,0.71567675,0.0,1.74219798,0.0,0.52094235,0.88012004,1.42814381,0.56462931,1.78775747,0.0,0.54665309,0.22897368,0.21455385,1.10077895,0.0,0.55914175,0.18872583,0.95890742,1.13307686,1.22477436,1.68589979,1.88179543,0.81960299,1.55569154,0.9427133,0.98263844,1.3601604999999999,3.79126784,2.61397027,4.04138955,5.11697339,3.05999361,2.15526526,1.25816947,0.68462609,0.0,0.14350663,0.0,0.0,0.30238159,0.0,0.48454871,0.0,0.24019472,0.26691433,0.0,0.79849353,1.00161768,0.35298376,0.0,0.28648994,0.35361145,0.0,0.0,1.10035609,0.86799092,0.7091973000000001,0.0,0.0807079,0.43409927,1.08312764,0.0,0.0,1.13209853,0.0,0.63923339,0.0,0.47481294,0.0,1.00100439,0.68956853,0.09426757,0.0,0.2185581,1.44850368,0.80464266,2.2586037999999995,1.88310362,0.9799819,1.61800729,2.00256256,2.157698,1.60670595,1.81777357,2.1416527999999997,0.78554135,0.12887662,0.65062016,0.34063653,0.0,0.63103455,0.0,1.78289871,0.7955153,2.35644232,1.99193792,1.0953795,0.46502732,0.0,2.42364054,0.50296943,1.51340398,0.40729879,0.6633453,0.41020499,1.27016145,0.52454764,0.20883301,1.51585189,0.0,0.12205713,0.90698945,0.5518014,1.56509322,0.49362897,1.33464666,0.89993399,0.47723186,0.70505747,0.0,0.0,0.0,0.07461434,1.54879067,0.99852928,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.65151597,0.0,2.95752625,7.0540997999999995,0.0,0.721669757,0.0,0.930502156,0.0667695232,1.04612454,0.0237729803,1.32586897,0.0,0.059749453200000004,0.0,0.429997025,0.0,0.8015017959999999,0.136818763,0.813303001,0.275931683,0.24408521800000002,0.0,0.619476302,4.63288092,5.80742719,0.0,5.46034825,2.29551041,0.0,0.6953583999999999,1.29335828,0.845105533,0.0365746077,0.125519791,0.0,0.7402686629999999,0.0,0.6972762159999999,0.0,0.645772911,0.0,0.0,0.0,0.670268801,1.75567662,3.19281052,0.45562274399999997,0.867040977,0.579993548,2.17992145,0.448615605,0.0,0.237600704,0.0,0.0,0.211764328,0.706229757,0.565451515,0.534485067,0.0,0.402344728,0.0,0.0,0.0,0.0,0.326013094,0.273212072,0.225934014,0.0,2.57833337,1.19183488,0.7519741870000001,1.15499359,0.0,0.742066268,2.61822924,0.8728529429999999,0.0,0.0,0.0,0.7715735440000001,0.0,1.12487572,0.0,1.06785319,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.0734758926,0.256355718,1.10103515,1.77215271,2.90708985,2.24789902,0.0,0.042237177699999996,0.217244148,0.0,0.257798569,0.0,0.0,0.330992565,0.0033153968199999997,1.32408677,2.30442143,0.935789257,0.176920308,0.103919355,0.8828488179999999,1.8215095000000001,0.751178515,0.0,0.0414287875,0.0,0.19094885,0.0,0.0,0.331942623,0.0,0.351357684,1.748868,0.606738,0.0,0.00953809719,0.0,0.124592291,0.0,0.423572224,0.93064523,0.069059966,1.34924989,2.32605824,0.237050953,0.0,0.30670525,0.0,0.0,0.118647573,0.0,0.0768792012,0.00282563767,0.0,0.0780021589,0.0,0.00187189818,0.0420508574,0.0,0.047087549699999995,0.0,0.0,0.0980406943,0.0,0.036748687200000005,0.727154828,0.395433187,0.0,0.860293269,1.63848579,2.51452196,2.8696764999999997,0.873692056,0.0,1.39434086,1.62681458,0.8019138140000001,0.198712654,0.0,0.143053031,0.0,0.0,0.23905626100000002,0.24365510699999998,1.32303299,1.13545664,0.181778854,1.58337571,1.16497187,1.76958408,6.45476341,4.89697637,0.0,0.0,0.293842513,0.0787321005,0.937844247,0.062712463,0.404484503,1.04143385,0.0,0.0,0.281088257,0.0,0.18330749600000001,0.014313748000000001,0.0,0.224926015,0.0,0.0816925731,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.31013889,0.0,0.0,0.0,0.0,0.0207960906,0.621595486,1.3269798000000002,1.97960201,2.42607542,2.55961282,2.34983818,1.85075437,1.18457446,0.506555235,0.0,0.0,0.0,0.0,0.00262185765,0.26968160399999996,0.444008991,0.475429991,0.367851086,0.17092138199999998,0.0,0.0,0.0,0.0,0.0,0.0335077061,0.14135979699999998,0.184191186,0.154382228,0.07134619860000001,0.0,0.0,0.0,0.0,0.0,0.024107880499999998,0.0807659224,0.10064453400000001,0.0806188735,0.0334380156,0.0,0.0,0.0,0.0,0.0334549776,0.09152884970000001,0.133995466,0.148715019,0.133997595,0.0979954801,0.0545347454,0.0173662715,0.0,0.0,0.0,0.00453074815,0.0102082478,0.00947460005,0.00432649967,5.7006528900000005e-05,0.00227977752,0.0140610699,0.034518779900000005,0.059494856900000004,0.08390838269999999,0.10460599,0.122296461,0.141586859,0.16903514,0.21009824,0.26645067699999997,0.335095884,0.409985825,0.485780948,0.562368333,0.648242148,0.761074151,0.924705937,1.16304901,1.49251244,1.91516787,2.4146989,2.95634972,3.49091573,3.96174379,4.31308965,4.49815861,4.4856158,4.26399406,3.84391734,3.25819833,2.55969222,1.81654191,1.10446705,0.496264054,0.0496786766,0.0,0.0,0.0,0.0,0.177017449,0.296709622,0.309533619,0.210406097,0.0347897579,0.0,0.0,0.0,0.0,0.0756754382,0.34694238899999996,0.564845464,0.649115942,0.5586354170000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.441
0.439775433,0.9456568190000001,0.731322102,0.159058637,0.0,0.1362134,0.100716075,0.0,0.0,0.151756193,0.19364382100000002,0.0,0.0,0.347732515,0.669822253,0.40047161200000003,0.196314259,0.6394739660000001,1.04319628,0.57116158,0.0,0.516748006,1.66460097,1.34666533,0.0,0.0,4.1085032,9.33705196,10.1088775,5.38995613,0.103125207,0.0,1.73210979,3.63631696,2.7594857999999998,0.913652177,0.213042068,0.367847692,0.165731619,0.0,0.0,0.24748727899999998,0.251963733,0.0,0.0,0.130327486,0.293945954,0.0,0.0,0.0160314257,0.39833873399999997,0.256345416,0.0,0.0,0.198026155,0.119405149,0.0,0.0,0.682121135,1.59611901,2.12668183,2.2021648999999996,1.83880075,1.0164118,0.128489995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47200000000000003
0.920989,0.82371473,1.25299777,0.5933149999999999,2.01751662,0.0,0.09963194,0.35631099,0.17949899,0.0,0.0,0.0,0.46332740000000006,0.0,1.21999671,1.02725128,1.02255327,1.23591251,0.3405818,0.0,0.67315409,0.46476126,0.46009849,0.0,0.51656295,0.24899613,0.0,0.61492074,0.0225496,0.99330902,0.09584664,0.0,0.37621679999999996,0.64771018,0.0,0.11159083,0.77409128,0.0,0.23215929999999999,0.22720010000000002,0.59494862,0.0,0.17275726,0.0,0.83906906,0.0,0.83419005,0.0,0.0,0.34261324,0.02430015,0.0,0.0,0.50047256,0.0,0.08110381,0.0,0.67255599,0.64902049,0.77974297,1.01127474,0.26886145,0.19794763,0.0,0.0,0.0,0.0,0.22131246,0.6392769,0.0,0.0,0.42495994,0.0,0.99839317,0.04895345,0.15148387,0.08386375,0.0,0.26997676,0.48453938,0.08087582,0.0,0.0,0.11054298,0.41627579,0.0,0.67496404,0.78938511,0.0,0.2580451,0.0,0.29488902,0.0,0.05957971,0.0,0.0,0.10350748,0.0,0.19666468,1.39732438,1.84175416,1.9680303,0.70616186,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.94279042,1.73216374,5.19991091,6.71158284,8.23756204,8.819209599999999,10.17863672,10.67997847,9.56581752,6.68124556,5.02244651,3.50089155,1.63307967,0.96306721,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.49700000000000005
0.846551807,0.44778701,0.618662266,0.35909465799999996,0.78640044,0.288759047,0.322287228,0.296396418,0.216469761,0.246875173,0.250411535,0.0,0.0,0.099530324,0.0,0.0,0.0,0.151089387,0.0,0.151431628,0.0530987768,0.0,0.455333854,0.135053656,0.107007955,0.2760836,0.07282813839999999,0.0533535597,0.215910005,0.10101975,0.0,0.0249205706,0.0877156372,0.04381773,0.0,0.0,0.0,0.0,0.122923664,0.049188778499999995,0.246039856,0.486968584,0.549460143,0.545354763,0.26876198100000004,0.265477556,0.772518897,0.7181919,0.27419955,0.517347937,0.22621963899999997,0.282794041,0.328635522,0.0,0.249393313,0.446751488,0.333728975,0.51653518,0.624669261,0.581959973,1.02175902,1.34643826,1.52056117,1.87747717,2.10907958,2.11673691,2.48561998,2.84416065,3.14504242,3.21672922,3.07066157,2.79116915,2.85409393,2.70852623,2.2692104,2.22989376,2.05896627,1.33434935,1.42595345,0.857903634,0.824984301,0.423321381,0.313744368,0.47115379,0.0058561478,0.0,0.0885593033,0.0,0.06551648269999999,0.0,0.26221255600000004,0.283403489,0.46653759100000003,0.446118732,0.0460113334,0.296246358,0.42597451,0.48381309200000006,0.0374595475,0.025055635299999997,0.269103943,0.178855641,0.373627851,0.30209609,0.375433256,0.281757055,0.36067125200000005,0.08607154199999999,0.336470715,0.0,0.375621903,0.017157201299999997,0.0,0.0,0.0051284513399999995,0.0,0.0220403065,0.166860114,0.0267707725,0.0,0.0,0.209011709,0.15923847900000002,0.0,0.0,0.245640655,0.051312020800000004,0.0820272454,0.262167166,0.056115888200000005,0.11820210699999999,0.32622112,0.0370462359,0.190269865,0.15594402400000001,0.0,0.0,0.0772814877,0.0,0.0535224893,0.148408997,0.152965993,0.0,0.09806677400000001,0.0,0.0,0.0,0.0,0.0,0.0694687509,0.0008889537619999999,0.215099405,0.0990726765,0.132961791,0.0,0.0,0.21060647899999999,0.254583098,0.0901438862,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18855244899999998,0.038730716899999997,0.289745934,0.359204853,0.19787805600000002,0.5739524020000001,0.230840065,0.378292653,0.57524964,0.6795880879999999,0.81674609,0.432141141,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.0496603721,0.0600355052,0.069580242,0.0773984997,0.0827304097,0.08502900960000001,0.08402932980000001,0.0798049735,0.0728077007,0.06388621559999999,0.0542813025,0.0455956044,0.0397376627,0.0388412446,0.0451624303,0.0609583292,0.0883525627,0.12919373,0.184913892,0.256394593,0.343848114,0.44672135,0.5636291520000001,0.692322889,0.829698678,0.971848061,1.11415204,1.25141735,1.37805171,1.48827288,1.57634428,1.63682837,1.66484763,1.65634192,1.60831071,1.51902855,1.38822271,1.21720303,1.0089356,0.768053874,0.500803067,0.21491663,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11965743699999999,0.632343089,1.19072772,1.7816698,2.39061436,3.00203749,3.59993375,4.16832937,4.69180263,5.15599245,5.54807616,5.85719892,6.07483826,6.19509027,6.21486635,6.13399304,5.95521116,5.68407413,5.32874943,4.89973058,4.40947078,3.87195189,3.30220521,2.715802,2.12833286,1.55489533,1.00960841,0.505171678,0.052484666,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.131023369,0.303500066,0.448981733,0.562780478,0.641915766,0.685134235,0.692857649,0.667064089,0.611110085,0.529503645,0.42763983299999997,0.31151177,0.187410458,0.0616268566,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0255156592,0.10302679,0.171643574,0.22851835199999998,0.27150682600000003,0.29923685,0.311137253,0.307427053,0.28906726899999996,0.257679258,0.215434928,0.164925343,0.109014993,0.050689407400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0345335732,0.0675381099,0.0952116982,0.116495818,0.13071918400000002,0.137611338,0.137294547,0.13025544,0.11729879300000001,0.099486757,0.078067443,0.054397210599999996,0.029861164,0.00579627989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00522644209,0.012994122,0.0186329973,0.0221068633,0.0235666719,0.023331795899999997,0.021860401600000003,0.0197110644,0.017498269099999998,0.0158447816,0.0153340322,0.0164656207,0.0196168286,0.025012625400000002,0.0327061138,0.0425706876,0.05430443980000001,0.0674465826,0.08140487589999999,0.09549236470000001,0.10897111699999999,0.121100195,0.131184793,0.13862337,0.142949668,0.143866821,0.141271173,0.135264057,0.126150508,0.114424678,0.10074259,0.0858836365,0.0707030405,0.056078089500000004,0.042851460999999993,0.0317752496,0.0234593906,0.0183280396,0.0165871093,0.0182055996,0.022912609,0.0302110212,0.0394078733,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
0.49200457200000003,0.0,0.0,0.09392733029999999,0.0,0.0,0.47418425299999994,0.7524984779999999,2.37374416,0.970566101,2.48116654,0.282840949,0.5429831420000001,0.736170859,0.524031601,0.970465185,0.49645079299999995,0.60164814,1.12168861,1.08347171,2.63233006,1.64271556,2.09658928,1.24937853,2.41274213,1.80738345,3.32213128,4.6312417,3.54303375,3.71974811,1.15568822,1.64509165,1.46709941,0.639988829,0.0871937732,0.0,1.01506143,0.0,0.235107065,0.335944475,2.35320995,0.191336234,0.0,0.535297343,1.87162925,0.0,0.682937661,0.0,0.337665183,0.562543695,1.33450454,0.0,0.0,0.0,0.236013499,0.431773975,0.0,0.239508186,0.0,0.0,2.00555142,0.317911268,0.70165363,0.0,0.0,0.0,0.0,0.0172476327,0.0,0.541494729,0.0,0.616629826,1.78799227,0.0,1.16844946,0.845926165,0.0,0.0,0.0,0.554230708,2.23209647,0.0,0.825204677,0.41269983600000004,0.41111401299999994,0.513771875,0.0,0.0,0.659651296,0.560677778,0.0,0.0,0.19787676899999998,0.0,0.19066417100000002,0.667735063,0.755182934,0.281579841,0.6672357170000001,0.0,0.626369843,1.23690329,0.649219581,0.903646946,0.6769968140000001,0.0711397207,0.0,1.39488622,0.29204547,0.9997302440000001,0.0,0.21924143699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.647242134,0.740241603,0.5548749620000001,1.07561516,1.47036709,0.363007872,0.10636444099999999,0.653592834,0.0,0.618694503,0.0,0.260082827,0.0,0.0,0.0,0.0,0.0,0.0,0.40640192399999997,0.0572115804,0.48248033799999995,0.281480587,0.0,0.0778423465,0.325701678,0.0,0.429162439,0.664809808,0.22316006,0.586773774,0.35165388200000003,0.0,0.353506344,0.0,0.0,0.0,0.664045834,0.224235918,0.250734974,0.0979892016,0.0,0.0,0.0,0.46939254700000005,0.6857895390000001,0.355354205,0.0,0.443947614,0.0,0.132857181,0.0,0.377794708,0.329516695,0.35388368,0.0,0.0,0.082181013,0.0,0.757266999,0.729500417,0.189540464,0.254453502,0.0,0.0,0.351886799,0.0499106551,0.26117232100000004,0.6120359999999999,0.599745422,0.607437116,0.0,0.670590582,0.0,0.45962857700000004,0.0,0.0,0.0,0.0,0.0565260705,0.51343815,0.00518511052,0.0,0.201020475,0.0,0.0,0.136386023,0.37055921799999997,0.210496286,0.18703401100000003,0.0,0.0,0.0,0.031220831600000002,0.46229487799999996,0.06760688349999999,0.0,0.0,0.0,0.5190211570000001,0.0,0.710455556,0.0638032393,0.0,0.064126843,0.0,0.0,0.41833854600000003,0.736647292,0.0,0.0,0.0,0.35510715200000004,0.0,0.0,0.328228036,0.0,0.0,0.0,0.0,0.787242161,0.41069312399999996,1.01661074,0.349900906,0.0,0.9022452009999999,0.0,0.0,0.0695982244,0.0,0.18001508,0.0,0.0,0.0,0.0,0.513059199,0.0,0.0125750175,1.08092512,1.21099781,0.871391413,1.11761061,0.17932915600000002,0.737265105,0.0,0.024155019399999998,0.12144977,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.8639887740000001,1.48528744,3.12073384,3.23239469,4.50464025,5.60006511,6.54373519,6.384544,7.16520069,7.52652519,5.94803863,6.11518164,5.05345623,4.06376201,2.75298226,2.35081842,0.7083120190000001,0.12393291099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.162137795,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46799999999999997
0.57778798,0.43006409,0.4613557,0.3051534,0.0,0.54988363,0.90458523,1.30266454,1.12297044,1.36823465,0.62050678,0.16491028,0.60810237,0.07968476,0.31452697,0.0,0.0,0.28416935,0.0,0.0,0.51841955,0.0,0.0,0.59907473,0.56766801,0.0,0.0,1.06685656,0.9437234,0.08022778,1.07471429,3.8452695,3.48294219,1.43154026,0.0,0.63723466,0.43635406,0.0,0.0,0.36620008,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.431910419,0.221916833,0.0,0.0,0.0,0.14878554800000002,0.0,0.0,0.0,0.786254535,0.830587069,0.0,0.0,0.7327852990000001,0.834853455,0.262904568,0.83462911,0.38041902,0.879375675,1.01821174,0.0,0.0,0.0637684004,0.538966388,0.0,0.0,0.6888266390000001,0.163556437,0.0,0.0,0.0,0.19117181800000002,0.0,0.26945242399999997,0.0,0.0,0.543860033,0.535916602,0.0,0.14644105,0.960245696,0.52255067,0.0,0.22932343300000002,0.0,1.9048043000000001,0.774730976,1.20304121,0.9283560340000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33967507,0.0,0.0,0.0,0.0,0.0,0.0,0.0482337029,0.252153982,0.174531486,0.42692826,0.431606857,0.48035913,0.0,1.04608467,0.00621627164,0.11413796699999999,0.0,0.0,0.0,0.0,0.241920479,0.597656308,0.864968485,1.93534823,0.0,0.0,1.08345224,0.0,0.0,0.0,0.0,0.0,0.790112842,0.0,0.689741863,0.24663905,0.43869263,0.0,0.0,0.028053554799999998,0.0,0.450034139,0.0,0.0,0.0,0.0321701582,0.0,0.496528993,0.361684778,0.0,0.0,0.0766374058,0.0,0.250395668,0.220498298,0.20928600600000002,0.126063903,1.99149536,0.0,0.0334384486,0.279348213,0.0620822913,0.0,0.6891894890000001,0.643139099,0.0,0.0,1.56198791,0.0,2.17940084,0.0,0.502771564,0.0,0.48127260899999996,0.0,0.900205172,1.31644876,0.0,1.59758512,0.0,0.799833572,0.0,0.0,0.6616144860000001,0.0,1.3263778,0.18382689800000002,0.0375160281,0.0,0.0,0.0,0.0,1.49008707,0.46360330899999996,0.8235428779999999,1.2677232,1.32206054,2.49078819,3.71571521,2.14563845,0.8488373859999999,2.77877294,0.9609281740000001,1.36338406,1.34408349,0.149903187,1.24995088,0.0,0.0,0.698182399,0.419616365,0.414773316,1.43944322,1.98087563,1.62305004,2.18674057,2.92280727,3.42559839,3.25364214,3.96887145,3.22013507,2.35236845,3.22851906,2.62274697,1.44527761,0.0,0.9561142109999999,0.984680663,1.09477665,0.0,0.0921595709,0.12307870900000001,0.0,1.33009847,1.25330767,0.18136263800000002,0.0,0.0,0.0,0.0,0.0,0.132712009,0.48785269600000003,0.327781435,0.0,0.0,0.7173135509999999,0.0,0.186179022,0.0,0.43504989200000005,0.0375876621,0.6103568620000001,0.214636971,0.0,0.470493307,0.0,0.0,0.753365995,0.0,0.31544479,0.0,0.0,0.500538735,0.0,0.200298244,0.0,0.40735975799999996,1.29490489,0.25915192,0.664193139,0.682099584,0.0,0.0,0.00218664588,0.210988385,0.0,1.95593783,0.0,1.12496299,0.628528499,0.960828907,0.881153672,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.19026970699999998,0.206809952,0.0,0.0,0.0,0.0,1.28232011,0.36573540299999996,0.0,1.45689066,0.0,0.0,0.0,0.0,0.101837185,0.7449690959999999,0.6989477690000001,0.0,0.0,1.26929225,0.0,0.0,0.272220828,1.75310253,1.61952261,1.28156196,0.0,1.51553456,0.990543803,1.16786608,0.466376878,0.0,0.0,0.0,0.8086382129999999,0.125853945,0.994573423,0.0,0.23878437,0.37944365,0.42224722,0.0,0.0,0.295440997,0.524585128,0.0,0.0,0.98966645,0.0,0.0511988601,0.0,0.0,0.0,0.13022428,0.0,0.46230373,0.0,0.0,0.90847432,0.0,0.0,0.0,0.276410791,0.0,0.0,0.0,0.0,0.498487023,0.48701571200000005,0.495783921,0.0,0.0,1.15348403,0.0,0.0562894628,0.0,0.0,0.674026207,0.035600487,0.505000012,0.0,0.593964215,0.0,0.828917463,0.0771089486,0.0,0.0,0.0969441317,0.0131885463,0.18355451899999997,0.5136246879999999,1.46938488,0.014978516200000002,0.25495702600000003,0.407695485,0.0,0.5000928179999999,0.147511341,0.0,0.0,0.0,0.483640112,0.0,0.37564464200000003,0.675326868,2.12549033,0.937451912,2.73137783,2.91323581,3.22041979,3.2228401,2.39191401,3.35700364,3.58827706,1.75254947,1.85100434,1.52919757,0.835214362,0.118716085,0.0,0.0,1.50363378,0.0,0.678577917,0.0,0.487520306,0.615994422,0.0,0.0,0.0,0.37462138899999997,0.422143844,0.0,0.0,0.0,0.0,0.257497341,0.30394635,0.0,0.0,0.149210338,1.19104697,0.31000659199999997,0.290250603,0.0325228106,0.999563856,0.765070371,1.35510289,0.06577168530000001,1.9257776999999998,0.6413271110000001,1.05035683,0.08157370230000001,0.0,0.523504899,0.38354819799999995,0.0,0.0,1.49624906,1.08879181,0.0,0.0,0.0,0.102365716,0.0,0.170052278,0.48815801,0.0,1.07563566,1.08431275,0.662797409,1.46611515,0.8488004720000001,2.08502298,0.0,0.7378178390000001,0.32157621,0.0,0.0,0.355285715,0.0,0.0,0.0,0.718116747,0.437445119,0.61373342,0.32019923100000003,0.671853323,1.12162141,0.0,0.0,0.0,0.8596177209999999,0.64149711,1.11778627,0.414539363,1.23588492,0.0791447336,1.66401745,1.39073776,0.474959001,1.0832396999999998,0.143250585,0.400077571,0.0,0.0,0.0,0.0,0.0,0.845879678,0.0203615026,0.0,0.8106707,0.455534072,0.331673185,0.0,0.111351146,0.0654113381,0.0,0.0,0.0,0.297202548,0.0,0.0,0.514497185,0.0,0.0,0.783505793,0.18875069600000002,1.05895056,0.0,0.0372547619,0.0,0.0,0.0,0.468253624,0.0,1.09510864,0.369047945,0.0,0.445528388,0.0934381716,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.254518122,0.489906987,0.142006515,0.0142031776,0.509961039,0.24757555,0.0,0.33926280299999995,0.7979036270000001,0.0,0.291619698,1.23924662,0.0,0.0,3.16845615,8.46417429,5.70960921,0.0,0.0,1.02130163,0.43706770799999994,0.0,0.123415972,0.6249153789999999,0.0,0.0,0.601060466,0.373452505,0.8385669509999999,3.14257591,4.22788875,2.61386162,0.795885466,0.217712242,0.0260719429,0.0,0.271193544,0.281603774,0.0271503991,0.0212014397,0.0567851183,0.0,0.0,0.09655960970000001,0.0,0.0,0.0804378558,0.0377630923,0.0,0.0224656429,0.0920853384,0.0,0.07528276019999999,0.415439351,0.252580596,0.0,0.189457123,0.7105704970000001,0.549269506,7.842811340000001e-17,0.0,0.0523945442,0.04637988269999999,0.0,0.0,0.0435947444,0.0,0.0,0.0314660893,0.00738840368,0.0,0.0125241826,0.0272417533,0.0,0.0,0.0366051857,0.0,0.0,0.029684763700000002,0.0166710794,0.0,0.006627207779999999,0.0376357503,0.0,0.0,0.0364135784,0.0,0.0,0.00233991923,0.0,0.163246409,0.545864694,0.429313437,0.0,0.0,0.439603202,0.311271821,0.0,0.165563297,0.557188448,0.406559423,0.294719903,0.322964636,0.0,0.0,0.41449368700000006,1.08117777,1.0101969000000002,0.736280842,0.433417271,0.0,0.0,0.179536538,0.0116852048,0.0,0.7098238459999999,0.991846563,0.406556646,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.73717321,0.23115691800000002,0.591036094,0.77968192,0.578512143,0.6790818040000001,0.135817251,0.0584026382,0.129082437,0.0,0.062572253,0.00551268665,0.0,0.0637145697,0.0,0.00760907363,0.047618246100000004,0.033339988,0.0488200265,0.0,0.0,0.0,0.0125090831,0.0,0.0,0.028630285,0.0,0.0403501726,0.0,0.0,0.0812572775,0.0,0.0329887376,0.048245056200000004,0.0,0.1930527,0.161637103,0.19878259,0.192339332,0.0,0.161705475,0.0,0.0,0.329099996,0.0,0.13555343,0.8034343509999999,0.0,0.385182354,0.0,0.0,2.48067314,2.31391948,2.82693498,3.84182766,1.1371961000000002,2.70009513,5.96958505,3.28982036,2.13379392,4.64525765,4.94623684,2.38601963,0.24274512,0.126570815,0.0,0.398625292,1.45712451,0.29964503,0.315133535,0.898979854,0.0,0.514620458,0.45205701299999995,0.0855328182,1.33123502,0.446427578,0.0,0.7301733440000001,0.699241152,0.0142189793,0.054209737,0.047112603899999994,0.0,0.00119455168,0.0183132589,0.0,0.0552925812,0.0,0.0,0.136754706,0.0,0.326359464,0.12305840800000001,0.0,2.27952832,3.75546754,0.320780988,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
1.9892542000000002,0.995108477,1.16851428,0.104423355,0.6983356279999999,0.0600141696,0.752502291,1.95949364,3.56315415,0.0,0.0,0.191767043,1.95183184,3.97917142,2.433408,0.9889735270000001,0.0,0.7127024040000001,0.0,1.40240716,3.00568308,2.7583807,0.0,1.66414634,0.637375954,1.07077524,1.76288384,0.0,0.37287079700000003,0.181054993,0.000503493803,0.40973520799999996,1.27822463,0.0,0.458747306,0.0,0.0,0.0359915244,0.463661279,0.0,0.9616759979999999,0.30511367699999997,0.77039035,0.0,0.706716462,0.0,0.0,0.7239606670000001,0.793031852,1.62287239,0.029414491400000003,0.501322743,2.57214243,1.77508193,0.48893997,1.40202863,0.0,0.0,0.0009824776790000002,0.0,0.0,0.0,0.0,0.0,0.241670608,0.0,0.0,0.738160915,0.0800437077,0.0,0.0,0.0,0.0,0.961438492,0.0,0.0,2.51183533,2.05785948,0.0,2.81464753,0.0,0.0,0.245279544,0.0,0.392604503,0.0,0.132882683,0.0,0.0076234890799999995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.0531268666,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0497994075,0.48429080799999996,0.7427581870000001,0.506249762,1.01250006,1.98498273,2.25304115,2.45667448,2.90637484,3.24093973,4.07211035,4.12500299,4.50097683,4.47918689,4.72206892,4.39969407,4.34219883,4.21272327,4.43680667,4.30615603,3.65207932,2.94253469,2.34709515,2.52074114,1.93690966,1.61284473,0.5332408120000001,0.588215975,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23188371800000002,0.374338865,0.378247151,0.46478985,0.20094073699999998,0.732649683,0.71014756,0.029389185499999998,0.44111709200000004,0.325328487,0.0,0.021399518399999998,0.250417053,0.0,0.08731555070000001,0.0,0.0,0.0,0.0,0.156143879,0.0,0.156901347,0.0,0.0,0.0,0.0,0.27571688699999997,0.0,0.0,0.0,0.5398625189999999,0.182945178,0.0,0.00271004961,0.37669439,0.0,0.557340464,0.578894437,0.107692762,0.341721427,0.08960791300000001,0.0,0.470754601,0.0,0.133141775,0.137892556,0.0,0.0,0.397971089,0.274681307,0.0,0.523240916,0.289050692,0.0,0.0,0.0,0.0,0.0,0.0361321742,0.00808965911,0.0,0.0,0.0,0.0581023898,0.08290566070000001,0.0,0.127988115,0.189739341,0.35625257,0.578390871,0.178151306,0.0,0.546853979,0.0950249968,0.427965703,0.507233113,0.7920044620000001,0.61793282,0.0734692408,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44299999999999995
0.71736044,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.24650929,0.0,0.74291368,0.0,0.90147217,1.41434093,1.20713567,0.86227195,1.27245863,1.43949598,1.05755705,1.29260114,1.10453016,0.207525,0.0,0.39041762,0.62932667,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.40236319,0.0,0.0,0.26381701,0.80141174,0.25448577,0.83869931,0.22274714,0.05058159,0.39931795,0.57319986,0.84965887,0.0,0.0,0.68429593,0.21932457,0.0,0.0,0.0,0.13492506,0.03030815,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.28243821,0.38106933,0.444563,0.0,0.0,0.0,0.0,0.28328393,0.6716462,0.53665809,0.0,0.64049099,0.0,0.56864173,0.0,0.04595882,0.0,0.0,0.0,0.0,0.0,0.68718771,0.37048238,0.0,0.0,0.0,0.32045039,0.0,0.30895365,0.0,0.0,0.37953284,0.0964323,0.26928045,0.0987654,0.0,0.0,0.36996940000000006,0.0,0.18202114,0.0,0.63001128,0.05150854,0.0,0.49962913,0.29793053,0.0,0.0,0.0,0.87588167,0.58291366,0.68416102,0.51059389,0.08767038,0.0,0.0,0.04868946,0.0,0.0,0.0,0.0,0.0,0.0,0.21580021,0.0,0.31919178,0.0,0.44911674,0.95277693,0.57091062,0.80924337,0.5435087,1.22063987,0.2515083,0.18127620000000003,0.90469428,0.96001911,0.44923402,0.97395578,0.0,0.51597656,0.0504021,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.47730403,0.58742463,1.39278851,1.27231386,1.77936919,3.26359031,4.11401557,4.41497606,5.56380856,5.78457268,6.565773299999999,5.87982773,7.012169800000001,6.16042744,6.13789793,6.38163894,5.87169433,5.60570621,5.95863613,5.20777756,4.29038919,4.11691969,2.72400017,2.35033586,1.5201053,1.0725158000000001,0.67901799,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46299999999999997
0.292995535,0.0,0.287760489,0.0774397417,0.24453111800000002,0.164839051,0.239147936,0.0,0.0,0.348492843,0.34691420799999995,0.273378403,0.0,0.0,0.0,0.0,0.0,0.260476213,0.0,0.016169016799999998,0.217084475,0.190216506,0.22101811300000002,0.122376786,0.0,0.13677512,0.0,0.207393968,0.0257259477,0.33823150799999996,0.0,0.0730321551,0.220254585,0.0,0.24665716,0.345459224,0.411666885,0.22483761300000002,0.0,0.0682236844,0.0,0.25137794399999996,0.0744112582,0.0,0.307028977,0.0,0.0,0.0911005719,0.0,0.268887653,0.122171399,0.0,0.0,0.167238,0.149878924,0.0,0.178381399,0.0,0.0,0.0762430194,0.200558348,0.45819878399999997,0.0,0.268103579,0.73708782,1.50364476,1.58665222,1.34673162,1.35061666,0.7456236359999999,0.0525682149,0.36648346299999995,0.977606137,1.75448691,1.7428661,1.46850846,0.592083963,0.0,0.524044033,0.28060080600000004,0.775712134,0.5862487270000001,0.0,0.0,0.122030525,0.787446577,2.41761561,2.9923966,3.29956275,3.38701291,3.39437334,2.35789577,2.51025352,1.8017541000000001,1.02558065,0.7942245920000001,0.220344016,0.0,0.0017418254199999999,0.0,0.542871461,0.0,0.281262058,0.100327309,0.332616627,0.128007058,0.730984218,0.47954816,0.253898582,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
4.94971089,5.08642181,4.99169651,4.67936281,4.18596951,3.56525614,2.88038608,2.19520702,1.56592404,1.0344562,0.624422461,0.34022882600000004,0.169192275,0.08613343009999999,0.0594862149,0.0577714717,0.055290935,0.0361076336,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.108730436,0.27222241199999997,0.44341979200000003,0.598571737,0.715434027,0.777125895,0.774975965,0.709867186,0.5918864970000001,0.43840294,0.27097831899999997,0.11170737,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.046915874,0.0836974663,0.09694960150000001,0.086608393,0.057523156299999996,0.01798591,0.0,0.0,0.0,0.0,0.0,0.0,0.00874138604,0.039030350299999995,0.059263603899999996,0.0650165775,0.0551927604,0.032203726099999996,0.00140898908,0.0,0.0,0.0,0.0,0.0,0.0,0.023906175699999997,0.0570840277,0.0788469456,0.082902111,0.06638462740000001,0.0307948763,0.0,0.0,0.0,0.0,0.0,0.0,0.00437738907,0.120168972,0.256102387,0.39618909999999996,0.52240482,0.617458834,0.667578983,0.664834465,0.6085803439999999,0.505745793,0.36988102,0.219092884,0.0731984525,0.0,0.0,0.0,0.0,0.0,0.0,0.009457345899999999,0.0746634783,0.118032742,0.131483359,0.113632524,0.0698210149,0.010810982299999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0330352946,0.0900726167,0.127430608,0.135257606,0.110055574,0.055803238899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.104260616,0.215728224,0.301860743,0.343303388,0.329418624,0.262003193,0.156961629,0.0434217924,0.0,0.0,0.0530636645,0.298168112,0.698198751,1.24514678,1.90926203,2.64136995,3.37833304,4.05090752,4.59282626,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
0.772346545,0.683017097,0.0,0.7850202890000001,0.0,0.0,0.0,0.0981669455,0.11121838,0.0,0.0,0.743502215,0.0,0.0,0.0,0.0,0.153714978,0.241966985,0.0,1.13052695,0.425632028,0.0,0.0,0.0,1.93979844,0.0,0.0,0.09020483050000001,3.33758998,2.47964152,4.67954997,3.67242787,3.5103334000000004,4.44204273,2.8031971,3.27567679,1.79474343,0.0,0.06484466650000001,0.0,0.386110314,0.0,0.47256216100000004,0.0,0.742044947,1.37917342,1.16200053,1.27509458,0.140790594,0.866577371,0.5441524179999999,0.0,0.0,0.0,0.16794798100000002,0.0,0.0344563375,0.5702169420000001,0.458094128,0.0,0.0,1.91687736,0.0,0.586714602,2.18248155,0.846330755,1.76094439,0.283505207,2.21117154,2.14037802,0.0,1.65208383,1.21378705,0.0,1.55840786,1.3367001,0.0770959129,0.269571144,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.8161560809999999,1.3760812,0.0,0.0,0.0,0.0,0.0,0.929254461,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.644761879,2.19823224,0.302150839,0.0,0.232779887,0.252189532,0.0562582208,0.0,0.6778521059999999,0.0,0.0,0.0,0.302001772,0.0,0.515480854,0.0,1.35296487,0.157503812,0.0,0.0,0.0,0.0,1.10416713,0.5598916070000001,0.32862194699999997,0.012147666699999999,0.0811339022,0.0,0.0,1.66760452,0.0,1.28555913,1.42265719,0.0,0.0,0.0,0.43886280899999996,0.0,0.999588603,0.0,0.0,0.0,0.0,0.0,0.40808906899999997,0.0,1.54501159,1.99179691,0.0,0.965474312,1.11079373,0.0,0.0,0.838803443,0.0,0.0,1.31973924,0.837664425,0.0,0.410259737,0.116525336,0.0,1.9542700000000002,0.0,0.0,0.0,0.0,0.200706783,0.0,0.0,0.0,0.0,0.0,0.0,1.30658717,0.0842197491,1.09016441,0.0,0.0,0.0,0.53656839,0.0,0.0,0.635608401,1.08576826,0.0,0.310510568,0.0,0.0,1.07089562,1.05321607,1.74242637,0.21725354300000002,0.116629753,0.14911455699999998,0.61794057,2.81647115,0.0,0.482297806,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
6.15574138,10.5606625,1.32486442,0.0,1.21689828,0.0,0.0,1.15873134,0.0,0.948719898,1.06609763,0.0,0.0,0.048809510300000004,0.0,0.8957359640000001,0.619436732,0.0,0.0,0.0,0.678987371,0.0,1.60544644,0.26568422199999997,0.0,0.002180467,1.16217325,0.0,0.39362150100000004,0.972516917,0.358298623,0.8913342329999999,0.0,0.0,0.274012176,0.402954839,0.754273108,0.12349326199999999,0.0,0.0,0.0,0.127616667,0.0,0.0,0.0548651104,1.79341071,0.542746988,0.0,0.0,0.0,0.6232964129999999,0.0,0.37763541799999994,0.610831311,1.01411154,4.64788895,4.59596398,1.07309919,1.82423955,3.21877193,0.272967723,0.0,1.84476799,2.50121963,0.37441542,0.0,0.0,0.664611835,0.15061174,0.9403795620000001,0.720472555,0.835651337,0.0,0.0,0.0,0.0,0.0113773596,0.22779068800000002,0.0,0.0,0.848635604,0.0,0.0835514041,0.45053720700000005,0.0,0.6428889179999999,0.0,0.0,0.0,0.0,0.696942159,0.0,0.164417461,1.00296502,0.0,0.8392108079999999,0.53097641,0.765043925,0.0,1.70065467,3.31772817,2.81733454,1.55708854,0.08782918880000001,0.67208502,0.12300498300000001,0.0,1.61857034,0.0,0.0660425724,0.194193103,0.0,0.9029997270000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.49329993299999997,0.0,0.567047734,0.0,0.0,0.0,0.774126102,0.32512656,0.0,0.0,0.0438907912,0.0,0.0,0.975580187,0.0,0.0,0.16189514,0.0,0.0,0.00650660477,0.68419473,0.724879698,0.9311710879999999,0.42975702299999996,1.40727139,0.45521732,1.0806498,0.504655625,0.9522111740000001,0.752557765,0.929103542,0.201659014,0.0,0.254432585,0.0,0.0,0.0,0.137363586,0.444092876,0.0,0.707198677,0.24311587199999998,1.086243,0.0,0.8803510590000001,0.0,0.0,0.0,0.0,0.0,0.231748167,0.266803874,0.0,0.0,0.0,0.578621093,0.0,1.28790121,0.0,0.0,0.407864884,0.0,0.14711613699999998,0.776453836,0.523689733,1.06258442,0.0,0.747133478,0.23536606899999998,0.469186355,0.0,0.0,0.594608654,0.0,0.698988609,0.358408794,0.0,0.18354848699999998,0.0,0.359999516,0.530712372,0.0,0.0,0.0,0.0,0.0750877494,0.150383608,0.48985128899999997,1.02350284,0.0,0.353317979,0.175279308,0.0,0.0,0.0,0.0,0.595286333,0.477729549,0.6877240609999999,0.329094948,0.135433847,0.0,0.0,0.55746074,0.140986286,0.43005079700000004,0.13442591199999998,0.0,0.461428644,0.0,0.0,0.0,0.0,0.159124105,0.0,0.0,0.0,0.0,1.12088153,1.02926163,0.315977071,0.138717145,0.6714687309999999,0.277393723,0.09723950320000001,0.0,0.532093177,0.0736666991,0.5881394839999999,0.0531897518,0.0,0.0,0.0,0.0379203282,0.102551713,0.39181678600000003,0.0,0.5525359129999999,0.326501382,0.0,0.0,0.0,0.188789176,0.0,0.0,0.422833953,0.523456703,0.0,0.524497223,0.0,0.12665616400000002,0.0,0.0950517227,0.339605472,0.0702658162,0.0,0.99045022,0.0,0.529873899,0.0,0.81202218,1.13774928,1.90079008,2.10336223,2.08431664,0.892494892,2.48561982,3.16241111,2.15652304,1.65240207,3.80885206,3.25151261,1.88307653,2.97043259,3.72737937,4.09887469,2.74733403,4.3759779000000005,3.23530347,1.63218808,1.81754428,4.02011241,2.30850874,2.90625607,2.73552375,3.03070941,2.64319558,2.33911661,1.71011057,2.05200125,0.0,1.34891329,0.0,0.717622765,0.909858452,0.444114037,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.0333039109,0.00210176366,0.0,0.035426234,0.0,0.08435221949999999,0.0,0.135711847,0.0,0.16793355100000001,0.0,0.656271767,4.43300062,1.74510901,0.0,0.316625353,0.0,0.78896221,0.0,1.29768556,1.46711285,0.920194945,1.46822909,0.379193519,0.008454900100000001,0.0,0.0623159258,0.0,0.648622236,0.463695996,0.0,0.010575226799999999,0.0159459325,0.0,0.117783965,0.773006005,0.208387403,0.0,0.0460849045,0.0,0.0191275946,0.0,0.0,0.0112201891,0.0,0.0108566323,0.00787720152,0.0,1.00147643,1.03120664,0.35266655700000005,0.24666745,0.0,0.141359351,0.0,0.510408443,1.60402468,0.481210185,0.0,0.045364565499999995,0.0,0.288192787,0.430170761,0.32251126199999997,0.0,0.0739378024,0.0595870397,0.0147992545,0.050086483700000003,0.0,0.103982411,0.0102268907,0.0082569667,0.0,0.029409267599999997,0.0,0.0377371607,0.0,0.275383757,0.427776854,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.406
0.08595646,0.0,0.19641744,2.04403036,5.15410866,8.47273999,10.53446967,10.36840716,8.13188764,4.98695713,2.32118815,0.91324339,0.64194377,0.85747472,1.00365141,0.95059691,0.84367956,0.74792756,0.52433997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.488
0.404923,0.88896885,1.44628549,0.06244236,0.0,0.0,0.78385426,0.98226299,1.11455166,0.89497892,1.45362303,0.41979402,0.0,0.0,0.12951184,0.32774025,0.0,0.7745107,0.96236962,0.0,0.58324988,0.82418392,0.22701412,0.0,2.2118302000000005,3.05525023,3.65815598,3.11612595,2.49612952,1.14304869,0.94662175,2.90076583,1.7233053,0.77986563,0.28207669,0.72513128,0.0,1.23908844,0.62303249,0.70009996,0.0,0.26070875,0.51130919,1.43459931,2.62121507,1.62538602,2.00319515,0.0,1.43612856,0.93416137,0.0,0.36288879,0.27134699,0.0,0.0,0.0,0.0,0.8556563,0.0,0.22630043,0.25537258,0.0,0.26373614,0.54705871,0.0,0.12842478,0.0,0.0,1.17538776,0.6984635,0.7291135999999999,0.66522508,0.0,0.89863986,0.10299075,0.77039631,0.27914258,0.0,0.0,0.19553027,0.0,0.0,0.0,0.96479629,0.09729215,0.41524253,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.22333454,2.34454501,6.49131891,9.661480099999999,9.1029176,5.51612268,2.30634412,1.55876128,1.99265493,1.49448717,0.282527083,0.0400882486,0.766784088,0.6791192979999999,0.0,0.0,1.01542434,3.45023051,3.59891873,1.61136269,0.0167288066,0.0,0.2419325,0.0,0.0796275218,1.64153443,3.35877203,3.39157205,1.87229506,0.494265765,0.123900074,0.16982538100000003,0.0388335579,0.0,0.0,0.023585094700000003,0.0,0.110041599,0.37652213,0.40227262,0.126713124,0.0,0.0,0.0,0.0,0.47917542799999996,1.33002916,1.62072629,0.855140204,0.0,0.0,0.0595414416,0.264086979,0.0,0.0,0.0,0.18425045399999998,0.067098582,0.0,0.0,0.0913652142,0.0328987776,0.0,0.0,0.0548620869,0.0312946483,0.0,0.0,0.009581974870000001,0.0,0.04781861019999999,0.26521673,0.418986526,0.287519537,0.0388118233,0.0,0.151298165,0.24795182600000001,0.35034176,0.773928101,1.34826786,1.30591665,0.469381989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.0740884837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.716114955,0.0,0.0,0.571479753,0.0,0.43588265200000004,0.0,0.0,0.0,0.217275871,0.23523866699999998,0.36362775700000005,0.0,0.0,0.0,1.37362116,0.9886995820000001,0.299337053,1.59647647,1.02796948,0.966498086,2.6887863999999997,1.46714444,2.91794782,2.4277053,3.03967106,2.64828138,2.55294207,2.45665688,2.53247048,3.04760146,3.27295846,3.05848024,2.48766999,4.38366101,2.45191844,2.7028963,3.2987474999999997,2.74604267,2.25294863,2.20253795,2.0149827,2.38859789,2.13651427,2.07856004,2.18923093,0.5291031079999999,1.08032417,1.12702462,1.63527741,1.88273527,1.28969799,0.535735967,0.0,1.30519056,0.0225708075,0.474844429,0.10975947800000001,0.9853617920000001,0.804391574,1.63573827,0.0,1.36886432,0.0,0.0,0.122232379,0.0,0.0,0.15570482800000002,0.0,0.0,0.744004975,0.21048392800000001,0.0,0.823827717,1.12837097,0.511225199,0.567525185,0.0760099194,0.806214228,0.463939686,0.0124955447,0.0,0.0,0.0,0.9514652579999999,0.652130391,0.439376664,0.5909345810000001,0.34284495200000004,0.0,0.0,0.0,0.0,0.0,0.0,0.616081553,0.89088674,1.14598825,0.0,0.0,0.0,0.0,0.324828535,0.6535345779999999,0.0,0.0352690908,0.0,0.0,0.8664895859999999,0.0,0.0,0.0438833185,0.0,0.184123197,0.0,0.0,0.0,0.09373175019999999,0.0,0.0,0.0,0.0,0.0,0.35405836799999996,1.09650797,0.0,1.25005989,0.354176671,0.0,0.0,0.0,0.187069798,0.154156477,0.60191067,0.0,0.37188893799999995,0.7589046209999999,0.0,0.0,0.122819009,0.0,0.0,0.0,0.0,0.48531328,0.0121573805,0.0,0.0,0.523723659,0.0,0.8716272279999999,0.0,0.0,0.0,0.330580444,0.611654995,0.347471597,0.009787002440000001,0.0,0.45795044700000004,1.16685958,0.385289838,0.547953119,0.0261127942,0.993173822,0.0,0.0,0.22834349399999998,0.0,0.0,0.85536064,0.371809483,0.17868539100000003,0.0,0.0,0.789625775,0.0,0.0,0.0,0.0,0.0,0.37508783799999995,0.0,0.0,0.0,0.154621566,1.1606471999999999,0.0,1.88487305,0.431762408,0.10232853199999999,1.56976659,1.39035017,1.31977018,0.0,0.510407198,0.0,0.92128309,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
0.762604446,0.0,0.0,0.166394876,0.0194786786,0.0,0.0,0.232285627,0.627217726,0.0,0.0,1.10238244,1.64700729,1.18324642,0.0,0.275795872,0.0,0.0,0.0,0.788777245,0.0,0.0,0.199268627,0.0,0.49727929600000004,0.0,0.0,0.838576058,0.0520994733,0.0,0.848118928,0.5236730070000001,0.0,0.0,0.036036147000000004,0.657339486,0.0,0.0,1.34747065,1.91593443,1.56662293,0.6986145579999999,0.0,0.0,0.929184696,0.524933141,0.331018602,0.236207727,0.0,0.28704320699999997,0.0,0.0,0.007041806309999999,0.6087270810000001,0.163010398,0.37155078,0.0,0.228145042,0.716395045,0.0,0.0,0.0628443374,0.0,0.327808704,0.0,0.20324789199999999,0.0,0.0,0.568422336,0.574558201,0.12132355800000001,0.119304256,0.0,0.0145508561,0.0,0.471674369,0.982899663,0.924736872,0.383238525,2.66068083,3.92518736,3.17459062,0.0542770872,0.0,1.4721376,2.51413501,2.17388824,0.305715802,0.7673712690000001,0.798049925,0.0,0.0,0.47267288799999996,0.7193722570000001,0.0,0.0,0.0,0.38578326399999996,0.0,1.5855548000000002,7.35861232,8.66001837,4.22502006,0.0,0.0,1.08505143,0.870638035,0.0,0.0,0.63793621,0.0,0.0,0.422703957,0.632852638,0.149647317,0.22370105,0.623010007,0.0,0.0,0.0,0.0,0.0,0.40543865,0.0,0.0,0.0,0.24498609699999999,3.15327391,3.79321061,4.44360349,3.4373372000000004,3.64316063,3.55216918,2.8264429,0.279286997,0.429052548,0.29280022,0.7150944920000001,0.0,0.449727559,1.12994539,0.84352259,0.748424548,0.8606502559999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.455
0.382373394,0.0390843538,0.0932890492,0.0,0.52453423,0.358163409,0.0,0.022342087099999998,0.0,0.00456703071,0.183437674,0.431364946,0.0,0.595317534,0.16735970000000003,0.0,0.26939711,0.30681574899999997,0.418747214,0.0,0.0,0.0146720281,0.0,0.32152411399999997,0.175242625,0.278080997,0.0,0.0,0.212036342,0.360455051,0.0,0.6225746870000001,0.0,0.141984564,0.0,0.0,0.0,0.51917483,0.0,0.648615787,0.0,0.0,0.21154989300000002,0.0,0.0,0.0125376454,0.0687164722,0.5091196020000001,0.208336653,0.412763043,0.391448501,0.0,0.686777332,1.32985627,2.2059187000000002,3.07270454,5.22104737,5.79273095,5.66659295,4.86445975,4.15094086,2.27388402,1.06505794,0.019378336,0.0,0.0,0.0,0.36558495799999996,1.55112719,1.61428299,1.94375294,3.04632039,3.02254493,3.81639763,3.69526809,4.54075113,3.46312902,2.85459099,2.67746521,1.16845473,0.716823441,0.0,0.0,0.0,0.0,0.460426651,0.0,0.0,0.289765464,0.0,0.0635065196,0.0,0.0,0.5110509289999999,0.27200573100000003,0.0,0.458312551,0.0,0.0,0.0,0.367815383,0.329880956,0.0,0.303588123,0.375703971,0.295969989,0.0,0.188906895,0.0,0.341415959,0.259535313,0.0,0.0,0.0453464679,0.0272496295,0.539101431,0.0,0.0,0.0,0.0,0.7322353359999999,0.11356953300000001,0.0,0.222791118,0.6901140379999999,0.302029306,0.48563005,0.299898055,0.85247566,0.410955165,0.8335395729999999,0.276640909,0.49475574200000005,0.0,0.0,0.0,0.0,0.0,0.20258093800000002,0.0,0.0,0.0,0.0,0.0,0.49206381,0.10324689699999999,0.577803933,0.24322701800000002,0.0,0.0,0.0,0.24519436,0.0,0.0498994166,0.0,0.0,0.0,0.22476674100000002,0.0,0.44346397299999996,0.0,0.0120549227,0.21679029800000002,0.231224328,0.25877735,0.539833001,0.0324730268,0.0,0.413582024,0.144510696,0.426827423,0.47094472,0.0,0.0,0.5022155079999999,0.237978792,0.113913385,0.246199964,0.0,0.113523296,0.0,0.450779466,0.0,0.317981373,0.14883044,0.356781034,0.0,0.533497439,0.43975629299999996,0.761370762,0.954931655,0.43105269,0.790362178,0.48422763799999996,0.54498905,0.512490697,0.0,0.44774156,0.5336308989999999,0.502209041,0.360243229,0.74598236,0.640818806,0.0,0.0,0.0,0.0,0.0,0.32682636,0.19849440100000001,0.943263126,0.471420309,1.52962406,0.845085216,0.249234564,0.293442753,0.564990185,0.0,0.527995011,0.0,0.345894143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
0.25496599999999997,1.91377233,0.28287643,0.89664179,1.27062457,1.40835494,1.28449834,0.10328924,0.0,0.0,0.0,1.89530319,0.89654276,1.209354,0.62137304,0.0,0.0,0.0,0.0,0.0,0.34890543,0.0,1.50328084,0.0,1.33869483,5.78298465,0.0,0.99655171,1.75807138,0.0,0.0,0.0,0.19043648,1.30288042,0.14575152,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.419
0.127306235,0.0,0.0,0.358136179,0.0374398965,0.697877145,0.24592087,0.0,0.0476444601,0.43696319299999997,0.890384834,0.46397338,1.21738565,1.15454095,0.749472622,0.663160034,0.268373911,0.0,0.30187670699999997,0.0,0.0,0.305712235,0.47516868799999995,0.563305408,0.49014467700000003,0.0,0.146054123,0.220188157,0.353666504,0.11883757699999999,0.0,0.530007393,0.0,0.0,0.23689151600000002,0.381761234,0.0,0.45437790299999997,0.0,0.272670108,0.0,0.0,0.46699114700000005,0.0,0.349209245,0.40994935899999996,0.0,0.0,0.410018878,0.0,0.0,0.31946223,0.11844714699999999,0.9176758840000001,0.8098339040000001,0.977144415,0.00893029683,0.0,0.19412528699999998,0.519793371,1.06497011,0.633188894,0.8075999690000001,0.276015445,0.7688983620000001,0.0,0.0236960595,0.415179523,0.11849109599999999,0.044552134800000004,0.41167634799999997,0.14220949,0.29605803199999997,0.698571197,1.49707865,2.99814175,4.76982129,6.04494263,5.49462349,4.29949952,1.96472817,1.30448446,0.0,0.0,0.0,0.43279656299999997,1.22127547,2.5362247000000004,2.70672108,2.44475377,0.9549944490000001,0.0614004118,0.30033140199999997,0.509066162,1.30262592,2.51457434,2.61732786,3.18328921,3.00065138,1.85620859,1.75931344,0.440138109,0.0,0.0,0.0,0.0,0.337113585,0.227714878,0.0,0.0,0.0,0.205478579,0.497388512,0.0,0.0,0.0,0.261403128,0.0563228846,0.0,0.044157672099999996,0.0,0.0,0.0,0.5373845660000001,0.0,0.0,0.0,0.10749853,0.0,0.0,0.179715656,0.0,0.0,0.0,0.15606815699999999,0.224071971,0.39704533700000005,0.0,0.291899096,0.0,0.0,0.0,0.0192545946,0.0,0.243201453,0.39445697399999996,0.535097949,0.284131896,0.129706071,0.286282537,0.0,0.0,0.0,0.0,0.18914864399999998,0.0,0.0,0.0,0.0,0.177643097,0.45455941899999996,0.18647074600000002,0.103514199,0.544893252,0.0542789727,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
0.100055763,1.17854073,0.471318929,0.315744801,0.300057239,0.937536479,0.0,1.23414405,0.0,0.40763051299999997,0.0635846388,0.639814508,0.0,0.551671582,1.73664567,0.553062305,0.036486202200000005,0.45733043,1.05468563,0.450696511,0.0,1.09652379,0.0,0.34221258,0.0,0.120000786,0.0,0.0,0.0309777696,0.0,0.068550812,0.592394184,0.836647206,0.0,0.0,0.0,1.20541127,0.0,0.7837844140000001,0.40570194600000004,0.0,0.0,0.0,0.0,0.694039675,0.0,0.0,0.0,0.161347249,0.0,0.0,0.0,0.0,0.0,0.820262136,0.0,0.0,0.0,0.110147004,0.0,0.181928395,0.0,0.577056337,1.33649313,0.594507476,0.707556947,0.0,0.0,0.0,0.701191314,0.187977631,0.0,0.185491398,0.483184148,0.0810240601,0.0,0.0,0.9019043370000001,2.24105437,0.0847492595,0.0,0.648605231,0.608855774,0.0,0.0,1.1153583,0.938670945,0.0,0.44556291299999995,0.0,1.34071777,0.10634031199999999,0.0,1.53527354,0.0,0.308536335,0.340886425,1.23729095,0.22449491600000002,0.130060735,0.41869956399999997,0.07214507769999999,0.0,0.568088327,1.94942078,1.00669487,0.0,0.0,0.880096584,0.0619482079,0.399824932,0.0,0.0,0.0,0.0248406624,1.69362616,0.523679131,1.07386911,1.75396755,0.419006846,0.911361523,0.173334072,1.13770687,2.33931189,2.0668425999999998,2.68362503,3.27197886,2.21969057,3.30108259,1.08388676,2.45134056,0.0,2.69190656,1.09294306,0.261284013,0.0,1.05541196,0.29087907,0.0,0.0,0.0,0.0,1.11812691,0.0,0.0,0.0,0.0172301768,0.0,0.0,1.59125102,0.0,0.0,0.0,0.90872533,0.0,0.0,0.440125579,0.15113906400000002,0.0,0.0,0.41289669,0.348510813,0.310285966,0.0,0.0688871097,0.43773072,0.204917175,0.0,0.668744977,0.0772956883,0.0,0.418073125,1.84016504,0.0,0.435461757,0.0,0.529966725,0.0,0.39969309999999997,0.0,0.968377905,0.06850638490000001,1.09906434,0.0,0.00996888063,0.0,0.0,0.0,0.0,0.5669671820000001,0.0,0.19040322899999998,0.0,0.0,0.162480011,1.76304143,0.0,0.0,0.48528063200000005,0.0,0.0,1.35475668,0.6892113670000001,0.0,0.0,0.0,1.14901888,2.46501277,2.42484735,4.40709022,2.74981032,2.86958676,0.514732515,0.314030853,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
2.02330748,1.5051976,0.33924206,1.37990258,0.13716938,0.59331894,0.20087269,2.93144775,0.61225262,0.0,0.0,0.97792872,1.05500525,0.0,0.0,0.73371349,0.99541292,1.1647662,0.0,0.0,0.96083725,3.17325073,5.31640593,7.8608962,8.37637853,6.88906882,4.3419875,1.74417762,0.25111608,0.0,0.0,0.0,3.48976746,0.045407300000000005,0.0,0.0,1.25416756,0.0,0.0,0.0,0.0,0.0,0.0,0.96757091,0.0,0.0,0.0,0.0,0.0,2.52188703,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.469
0.0486140273,0.112684391,0.14052989400000002,0.12207708199999999,0.0698114996,0.0119477252,0.0,0.0,0.0391081608,0.109430073,0.169193392,0.193005087,0.172107965,0.11851424599999999,0.0596288616,0.0257253875,0.0358530428,0.0885092583,0.161370304,0.22041560699999999,0.23463118800000002,0.189947705,0.09627804390000001,0.0,0.0,0.0,0.0,0.0,0.0519040135,0.11877225400000001,0.131839817,0.0855387855,0.0,0.0,0.0,0.0,0.0,0.045621931,0.140528536,0.189344662,0.17255295899999998,0.0977456325,0.0,0.0,0.0,0.0,0.0505389257,0.194346097,0.324093503,0.400875507,0.40522586299999996,0.342576197,0.238917739,0.129103513,0.0430606727,0.0,0.0,0.0,0.00297781349,0.00334266231,0.0,0.0,0.0,0.00937794755,0.0486140273,0.0895896969,0.11320704300000001,0.105266345,0.0643614358,0.0042049125,0.0,0.0,0.0,0.0,0.0588916841,0.1129931,0.127826826,0.09493376390000001,0.0272505548,0.0,0.0,0.0,0.0,0.089556439,0.200279701,0.294640887,0.371765646,0.46198283,0.6207176520000001,0.908256438,1.36175731,1.97012134,2.66265967,3.31841937,3.79582849,3.97457704,3.79631359,3.28997483,2.57190085,1.81894922,1.22182007,0.9325617740000001,1.0223482,1.4623713,2.13325411,2.8593804,3.45703967,3.78172242,3.76120659,3.40646317,2.79976102,2.06608399,1.33798307,0.724341243,0.290654155,0.0537782046,0.0,0.0480014676,0.171859305,0.311039634,0.432690659,0.524512775,0.592536989,0.654758052,0.7323650270000001,0.840453908,0.980297195,1.13534782,1.27280362,1.35143,1.33444915,1.20415723,0.973396356,0.6889688690000001,0.42397519100000003,0.259564501,0.26060717,0.452800152,0.809336167,1.25291543,1.67408941,1.96126784,2.03326151,1.86375284,1.4893423000000001,0.9981776440000001,0.502784343,0.106173609,0.0,0.0,0.0,0.0201155171,0.142791969,0.201395615,0.181012096,0.102768376,0.009503075829999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
2.0534705,0.369739329,0.0,0.584779236,0.0,0.0,0.434398856,0.028746729500000002,0.0,0.314619341,0.219018212,0.0,0.139431065,0.371179989,0.0,0.0,0.470979114,0.0,0.0,0.508127047,0.0,0.0,0.47317952700000004,0.102745405,0.0,0.355037875,0.374628866,0.0,0.134876531,0.696168565,0.0,0.0,1.09931361,0.0,0.0,1.73742827,0.0,0.0,5.51044358,13.850416899999999,8.10995656,0.0933482442,2.52717487,4.6353049,0.0,0.0,1.11133656,0.44213621,0.0,0.38632086600000004,0.568485052,0.0,1.0036601,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47700000000000004
0.05797416389999999,0.327816088,0.585851118,0.6781346229999999,0.549537328,0.280147804,0.022450336600000002,0.0,0.0,0.0,0.046891317300000006,0.0457355493,0.0075357179500000005,0.0,0.0,0.0,0.00887370382,0.0073035144799999995,0.000831110967,0.000845812472,0.00528082923,0.0029637561800000003,0.0,0.0,0.0,0.0177550551,0.0336148604,0.015500854599999999,0.0,0.0,0.0,0.0461484063,0.09829647150000001,0.054615939100000004,0.0,0.0,0.0,0.470978864,1.29801251,2.19880487,2.84399889,3.00041191,2.65538551,2.00512844,1.32241671,0.801434559,0.48356108200000003,0.297231565,0.15777798099999998,0.0388871567,0.0,0.0,0.018472489499999998,0.068017172,0.0855115308,0.0923682131,0.137383103,0.23721562,0.34264056200000004,0.370327329,0.277177827,0.108725524,0.0,0.0,0.0147705805,0.088072266,0.0777092995,0.0,0.0,0.0,0.00940761527,0.085452302,0.061355089,0.0,0.10934334300000001,0.60176395,1.4750374,2.43150793,3.0153229,2.90421157,2.14564407,1.14968603,0.426896111,0.25580045100000004,0.522486413,0.8442003809999999,0.871872887,0.536159435,0.0592177477,0.0,0.0,0.0,0.150891039,0.16815724899999998,0.0345936985,0.0,0.0,0.0,0.0628071962,0.0683297505,0.012959295,0.000164731164,0.10211355,0.278634917,0.406019494,0.389739801,0.254793251,0.127312734,0.121633794,0.23458099100000002,0.343411476,0.311799288,0.11353587400000001,0.0,0.0,0.0,0.38935208600000004,0.9597916329999999,1.47260575,1.77255224,1.77659687,1.48707123,0.9994910690000001,0.499277455,0.214376287,0.311227512,0.7823847970000001,1.41412209,1.8863979,1.9588781000000002,1.61654418,1.06517111,0.578890297,0.319141314,0.264181373,0.290254051,0.314408898,0.36199159299999994,0.501470445,0.721530828,0.8854150120000001,0.825525905,0.5016726770000001,0.0715147046,0.0,0.0,0.0365887195,0.237202175,0.20793809600000002,0.0,0.0,0.0,0.0190942128,0.273331942,0.274488241,0.0,0.0,0.0,0.311305279,1.18623625,1.89037554,2.0172393,1.51383037,0.7033425109999999,0.0400323699,0.0,0.0,0.164575515,0.268326738,0.183350137,0.0230069741,0.0,0.0,0.0,0.0280770912,0.0427281604,0.0747367579,0.145508167,0.219448413,0.239914457,0.194223295,0.128850147,0.0932395729,0.0795526633,0.045162865,0.0202192773,0.191291403,0.834947615,2.09494169,3.7608333,5.25806206,5.92439849,5.41573585,3.94916172,2.18474885,0.813934533,0.151688772,0.029519398999999998,0.0486847754,0.0,0.0,0.19477847,1.02986546,2.22112626,3.25904271,3.65180618,3.26039897,2.37019154,1.45842289,0.858742318,0.586890014,0.436213119,0.222831872,0.0,0.0,0.0,0.0657246142,0.258834883,0.25524410399999997,0.07295088820000001,0.0,0.0,0.234301368,0.602698129,0.8153651,0.747998578,0.46879925299999997,0.16457439199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.00277801498,0.0798151716,0.107740633,0.044320125099999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.449
1.51793263,0.0,0.0,0.0,0.0588533741,0.516622134,0.0,0.700901035,0.76316681,0.441745701,0.0,0.0,0.528844976,0.175574273,1.02343768,0.0,0.0,0.6326741,0.0,0.447817731,0.360965309,0.0638381258,0.103987148,0.693697563,0.120463308,0.0,0.213215949,0.0,0.0,0.0,0.0941748333,1.27804097,0.0,0.83151591,0.416239195,1.60478537,1.26757088,0.0,0.44544831100000004,0.344005689,0.0787445193,0.0,0.533138769,0.557144245,1.17694279,1.80561453,2.23684261,2.35097202,3.91073985,3.02796681,2.60497215,2.7265955,2.54150466,1.84227112,0.856595558,1.26576968,0.0,0.459940279,0.0,0.0,0.929411012,0.0,0.269843121,0.0,0.271357749,0.657862658,0.373461066,0.0,0.00580738475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.5493498729999999,0.269083922,1.20025161,0.107119151,0.0,0.0,0.208114375,0.0,0.0,0.0,1.07358649,0.235750084,0.06332022150000001,0.028515351,0.0,0.0,1.19523033,0.0420264905,0.26595631399999997,0.665844824,0.0,0.0,0.0269116623,0.97596916,0.006875188879999999,0.0,0.326820597,0.0,0.0,0.55022447,0.41421465700000004,0.45161938799999995,0.0,0.701454747,0.0,0.0,1.06506881,0.0,0.833237593,0.0,0.0,0.0,0.221533493,1.15387255,0.240633034,0.11822703,0.37152007299999995,0.0,0.536828877,0.0,1.77124762,0.0,0.511641279,0.0,0.7778140040000001,0.446121276,0.0,0.0,0.23285655600000002,0.42204992700000005,0.24443851,0.0,0.9102128420000001,0.0,0.07066809809999999,0.552781848,0.244853778,0.0,0.9559667620000001,0.0,0.0,0.697665547,0.05127141599999999,0.0,0.695471904,1.31945266,0.345552223,1.10402082,0.0,0.16396313199999998,0.0,0.0,0.00562815125,0.201329752,0.0,0.0,0.0,0.914647909,0.0,0.0,0.0,0.0,0.09463106789999999,0.197058877,0.441762919,0.0,0.0,0.83478488,0.0,0.0,1.75022585,0.0,0.528356607,0.0,0.0,0.218264903,1.29634053,0.0,0.731705515,0.0,0.0,0.0,0.157565497,0.0,0.0,0.0,0.11070054,0.0,0.158797731,0.964191839,0.730969245,0.7878666409999999,0.853782519,0.301971486,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
3.8139117999999996,3.43509119,3.43628232,3.21593452,3.1385462000000004,3.51703094,3.30059264,2.74670998,2.61939469,2.30684098,1.99979828,2.33258116,2.1320935000000003,1.63346975,1.21619362,1.16009783,0.988561228,0.5738490589999999,0.5389636520000001,0.0,0.133824898,0.156302579,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.021765964300000003,0.0,0.223421528,0.0,0.287315384,0.060481939299999996,0.6292637870000001,0.271015625,0.412696389,0.219244519,0.209704958,0.475695694,0.605675755,0.358653231,0.48159599299999994,0.11650601199999999,0.332136208,0.289323825,0.00217768217,0.0,0.192956992,0.0,0.0814075103,0.0362746301,0.0979193119,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0226788479,0.0,0.0,0.0520859681,0.0847889596,0.0,0.0,0.0,0.30491922899999996,0.192160993,0.010785949,0.45197819200000006,0.547642036,0.341213218,0.264157777,0.0670823569,0.597377584,0.48968845899999996,0.149236428,0.0568596385,0.434414094,0.280634607,0.0,0.29111971,0.0579469669,0.0,0.0,0.121430289,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0753535487,0.0,0.064474191,0.228422443,0.021349077799999998,0.172954998,0.348668945,0.099108579,0.173087648,0.59675846,0.5218425760000001,0.524609433,0.25115569,0.681851036,0.599357241,0.590201262,0.5955120220000001,0.122790126,0.19356884600000002,0.321701842,0.0,0.0,0.122841274,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0988166732,0.0,0.41524275200000005,0.22699501,0.640329436,1.09436226,0.68901202,1.14208909,1.15870935,1.81558277,1.75149799,2.56509209,2.74955421,2.3512633,2.88050597,2.80754399,3.19937355,3.20935551,3.55449484,3.27342313,3.77964398,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.23795093,0.0,0.0,0.577619003,0.0,0.0,0.24333163300000002,0.0,0.0,0.0,2.10924404,0.0,1.56778622,0.26977091,0.0,1.08211001,2.17748484,0.0,0.276863718,0.0,0.0,0.0,1.12985668,0.584289111,0.0,0.0,0.0,0.37543700399999996,0.9240293559999999,0.0,0.0,0.0,1.18579568,1.27002489,0.0,1.94648563,1.11163674,0.017434148899999998,0.0,0.0,0.0,0.46949317700000004,0.0357967154,0.0,1.60868403,0.0,0.09153504009999999,1.13374003,0.0,0.0,0.0,0.0,0.524315138,0.0,0.0,0.0,0.8992892020000001,0.0,0.07836265440000001,0.045858543099999996,0.35315372700000003,0.17644419,0.688794017,0.0,0.0,1.14848211,0.0,0.195605065,0.0,0.0,0.0,0.0,0.0,1.39559122,0.514751539,0.563617713,0.0,0.5658629860000001,0.242527534,1.39639617,0.150570809,1.2658798999999998,0.125459961,0.0,0.0,0.0,1.31876709,0.030018328599999998,0.0,0.592352419,0.30740058600000003,0.0,0.0,0.620355793,0.0,0.440921414,0.980449232,0.0,0.0,0.0,0.0,0.7077460990000001,0.0,0.0,0.0,0.0,0.38493323799999996,1.54273869,0.0,0.0,0.0,2.37016212,0.0,0.223624934,0.0,0.62095861,0.0,0.123594484,0.0,0.825879397,0.566998894,0.325973974,0.0644573642,0.061762699000000004,0.0,0.0,0.509529134,0.0,0.56384741,1.41737634,1.34141821,0.0,1.0496885,0.0,1.48010602,0.0,0.909526004,1.17761915,0.35053122600000003,0.343063861,0.23729036,0.0,1.55372285,1.08689805,0.0,1.19662483,0.46838829200000004,1.01527191,0.703017538,0.0,0.951649014,0.0,0.881669417,0.0,0.0,1.19866482,1.74843089,0.34058771299999996,1.33914392,1.75700889,1.56364555,0.0,2.46022516,0.301050394,2.13595835,0.208062315,0.6883893879999999,1.09873341,0.0871105859,0.0,0.0,0.0,0.0,0.0,0.0,1.69743938,1.23323747,2.11596426,3.39050148,2.4366115,3.65707627,5.48951054,4.22736674,4.44856268,4.21154895,4.52391513,1.92456462,2.89430091,1.35250963,2.07348754,1.71258338,2.1551459,0.6911541,0.0,1.33628517,0.0,0.254879588,0.643951206,0.983065917,0.0,0.453890674,0.543153455,0.509934903,0.0,0.0,1.01853429,0.0,0.0,0.0,0.349266036,0.0,0.0,0.0,0.15716227,0.0,0.0,0.0,0.09713012039999999,0.959559212,0.0,0.0,1.9689458999999998,0.0,0.212266887,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.26165570000000005,0.22567644,0.19295495,0.16611664,0.14776055,0.14037139,0.14623396,0.16735254,0.20537752,0.26154165,0.33660788,0.43083019,0.54392895,0.67508143,0.82292794,0.98559359,1.16072506,1.34554157,1.53689856,1.73136258,1.92529507,2.11494298,2.29653357,2.46637081,2.62093073,2.75695293,2.8715259,2.9621635,3.02687068,3.06419647,3.07327273,3.05383766,3.00624334,2.93144711,2.83098695,2.70694169,2.56187706,2.39877908,2.22097671,2.03205593,1.83576757,1.63593155,1.43634015,1.24066301,1.05235649,0.87457988,0.71012082,0.56133182,0.43007977,0.31770958,0.22502302,0.15227317,0.09917455,0.06492842,0.04826255,0.04748411,0.06054395,0.08511056,0.11865115,0.15851775,0.20203546,0.24659042,0.28971485,0.32916655,0.36300065,0.38963135,0.40788203,0.41702199,0.41678896,0.40739669,0.38952724,0.36430846,0.33327706,0.29832859999999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.772693843,1.24382845,1.45845008,0.8782388859999999,0.544931719,0.0,0.0,0.0,0.010399765600000001,0.351972168,0.250362778,0.0,0.230150725,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.057440735300000004,0.0,0.0,0.0519714842,0.0101671401,0.0,0.0,0.0,0.0,0.290591876,0.0,0.00258324449,0.0,0.0,0.0659223017,0.0,0.0,0.21722087,0.49426706600000003,0.0687387024,0.167881207,0.466645683,0.6608247420000001,1.90055,2.39176882,3.11903561,2.76577291,0.7018415170000001,0.253851512,0.757487956,2.37897543,1.88877878,0.257786012,0.0834390307,1.64198598,2.15560393,0.607729368,0.0,0.0,0.199402037,0.44815525700000003,0.0,0.0,0.07164262099999999,0.0,0.08822193560000001,0.21964208,0.0,0.310457652,0.0,0.21080680699999998,0.253635579,0.192145631,0.00445228363,0.11668285099999999,0.259711091,0.08773909710000001,0.0283527453,0.0,0.0,0.0,0.204151343,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18276209300000001,0.11580446900000001,0.0,0.09084249609999999,0.0,0.09258426199999999,0.428345769,0.0,0.0,0.0,0.191085235,0.0,0.820240402,1.22005808,1.44570549,1.65929092,1.63213811,2.62395052,3.38566125,3.40027496,2.45404469,1.48623415,0.71762104,0.43717469200000003,0.11087240300000001,0.0,0.28442679,0.292817132,0.134889184,0.26726981899999996,0.0,0.216461118,0.0,0.299192772,0.255569447,0.0,0.0,0.111722509,0.0,0.0,0.0,0.0,0.0053400259400000006,0.0,0.21645341899999998,0.0956244698,0.226426132,0.0,0.27703863300000003,0.0,0.0,0.0324543843,0.579516248,1.12506938,1.22864147,1.43303608,1.08966306,0.20851176899999999,0.236480611,0.533387927,0.271253006,0.5027892829999999,0.013069148700000002,0.6235862839999999,1.48813042,1.59582268,0.525673176,0.0,0.0,0.0962403433,0.604942796,0.291779445,0.0,0.43089275,0.27837052100000004,0.144842387,0.0,0.047209777,0.214164745,0.0,0.028186064700000003,0.21366807,0.252537518,0.0,0.0,0.166185279,0.837677331,0.160440324,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.242090248,0.66033265,0.712780462,0.44263062200000003,0.205414768,0.133671744,0.0980330753,0.0202212952,0.0,0.0913944491,0.203115197,0.19156062699999998,0.0806177892,0.0016591108800000003,0.0,0.00324790406,0.0,0.0,0.022270749700000002,0.0249136792,0.0,0.0,0.0162068556,0.048115391699999996,0.0,0.0,0.0131653056,0.09389352640000001,0.0372434075,0.0,0.0,0.0920824714,0.11757844,0.0,0.0,0.0940431043,0.624781344,0.8493223670000001,0.580523453,0.170045074,0.0,0.0,0.0,0.0,0.0618110504,0.201043368,0.20548243100000002,0.0782642125,0.0,0.007512027409999999,0.00102857788,0.0,0.0,0.0708385582,0.0769962984,0.09785250919999999,0.498452237,1.30463303,1.86284935,1.53652969,0.603336038,0.0,0.0,0.125875965,0.0,0.0131769221,0.791819162,1.80028301,1.87210436,0.770119887,0.0,0.0,0.177334463,0.469875396,0.15739310199999998,0.0,0.45098772600000003,0.9762903559999999,0.947146685,0.8085904340000001,1.5998603999999998,3.41691247,4.94641476,4.80257879,3.03973668,1.05035931,0.0989941475,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
0.588939184,0.89226732,0.7066773820000001,0.41912290700000004,0.0,0.414542581,0.26037250100000003,0.177844031,0.528577404,0.988900661,0.29418533,0.974487975,1.53073744,0.974869045,0.38730052200000004,0.7172639340000001,1.45122413,2.39474331,2.52154519,2.34763612,2.786025,2.10773244,1.64179188,0.14499809,0.0,0.0,0.0,0.882080808,0.0,0.0,0.0,0.0,0.0,0.0265038077,0.769937077,0.0,0.49028388700000003,0.601904607,0.0,0.0,0.141872359,0.0,0.611103984,0.855068762,0.783997457,0.8353302779999999,0.0,0.0,0.578774573,0.351850683,0.866757863,0.261621035,0.6851649320000001,0.67518187,0.0,0.65114429,1.93382206,3.41487224,5.72916996,7.0781522,9.27418029,9.07464216,7.4027061000000005,5.59428912,2.91956687,0.634501703,0.0,0.0,0.0,0.0,0.0,1.7094342,0.290366381,0.106443232,0.0,0.0,0.0,0.0,0.201252035,1.20210415,1.30857808,0.538407007,0.626506267,0.0,0.0,0.266477417,0.766091285,0.45409683100000003,0.0378112356,0.10959762599999999,0.5231824970000001,0.676939202,0.0,0.0,0.525734731,0.607147316,0.101913775,0.0,0.34740896200000004,0.327237226,0.0,0.0,0.659545698,0.65337884,0.0,0.0,0.0,0.0,0.40622975,0.10461090099999999,0.0,0.615507086,0.499886203,0.0,0.0,0.08405311619999999,0.576887899,0.307002952,0.0,0.733716019,0.455768505,0.272113487,0.0,0.0,0.0,0.0,0.455007114,0.0,0.0573957524,0.0,0.124152433,0.873680314,0.7258251440000001,0.5513697320000001,0.6911771059999999,0.0,0.33739542299999997,0.0,0.0,0.695893152,0.870973517,0.0,0.0,0.0,0.0,0.319983901,0.8066129390000001,0.443913935,0.0,0.874305335,0.248879336,0.843066249,1.98580486,2.05716273,1.99251015,1.96996447,1.4037022,0.0,0.0,0.0,0.387780464,0.521965741,0.302219156,0.164176593,0.0253270975,0.0,0.149892368,0.0,0.0,0.875857357,0.0,0.0,0.0,1.20680266,0.816666487,0.584197188,0.6858164370000001,0.299612822,0.0,0.0,0.0,0.739691022,0.0,0.722255291,0.0,0.0,0.489947013,0.0,0.370556575,0.372729221,0.18872235399999998,0.0,0.0,0.24440014300000001,0.0,0.54356151,0.19339465600000003,0.226361979,0.0,0.0853711618,0.48453324299999995,0.0,0.0257008463,0.0,0.0,0.703878876,0.0,0.0,0.8158528140000001,0.36236336799999996,0.384124794,0.742014292,0.0,0.404689836,0.729140272,0.487115659,0.0,0.0,0.33630148600000004,0.148566155,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48100000000000004
2.09146266,0.0,0.0,0.85543172,0.0,1.46384097,1.52177579,5.05203574,5.01773016,7.0499135,8.26343656,10.41751255,5.98259669,4.58800638,4.956934400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.55317367,1.29389253,0.0,0.0,0.0,0.37420093,1.53934211,0.0,1.17045131,0.0,0.0,1.39095082,1.5134027,0.0,0.83555106,0.0,0.10747599,0.0,0.0,1.82105081,1.74491721,0.51120599,0.0,0.0,0.0,2.87863345,0.0,1.30495208,0.0,0.0,1.29672887,0.0,0.0,0.0,2.54926429,0.0,0.88514223,0.0,2.01141498,0.62333997,0.71594007,0.22797233,0.0,2.24787676,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.48
0.028173677299999998,1.18927972,2.13956764,4.09940955,4.32567353,5.44158205,5.32524186,4.54575962,2.96790524,1.52172953,0.0,0.0,0.0,0.0,0.08641060099999999,0.43226471299999997,0.0,0.29009985,0.0,0.0,0.515032994,0.535168149,1.1966088,1.64594225,0.963951523,0.569824791,0.460204864,0.517443682,0.0,0.141321396,0.0305416243,0.434492101,0.91311318,0.830619842,0.6745323240000001,0.0,0.0,0.0669086034,0.0,0.0,0.17573413899999998,0.0,0.490598606,0.0,0.0,0.0,0.0,0.0,0.0,0.42210652600000004,1.15369781,2.08134577,1.80679523,1.99480801,2.54953278,2.26962504,1.36662714,1.93145415,1.14386515,2.09127134,1.32973829,2.28194694,2.05767748,2.18466661,1.95238614,2.29517752,1.44943605,1.08237449,0.9811071990000001,0.472934691,1.19118084,1.1792455,1.42308906,1.5504331,1.20429889,1.42445839,1.15461054,0.0,0.0328662767,0.0,0.0,0.15436804699999998,0.0,0.0,0.29915642,0.0,0.582254915,0.0,0.381039105,0.485621475,0.0,0.0,0.0,0.0,0.506946161,0.0,0.0511584749,0.0,0.411840429,0.20043469,0.0,0.19883726899999998,0.47159255200000005,0.0,0.0,0.0,0.0,0.307610489,0.0,0.435450715,0.143937314,0.0,0.0,0.244314175,0.284333126,0.0,0.36971595799999996,0.0,0.279929045,0.0,0.0,0.240664298,0.0,0.625117536,0.52038859,0.0,0.0,0.0,0.0,0.0,0.0,0.128843677,0.213828639,0.33274442600000004,0.0,0.203287505,0.148220055,0.164668382,0.0,0.46507134899999997,0.756650789,0.40408589899999997,0.528448527,0.0,0.0,0.0,0.0,0.22869738899999997,0.27583932899999997,0.360001295,1.00218599,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
0.93179519,0.461192836,0.308994555,0.35932703200000005,0.500414499,1.07714514,0.740011605,1.0144165,1.03924243,0.7311276609999999,0.946832688,0.9350630879999999,0.253526727,0.696602232,0.320247273,0.7098011959999999,0.656372443,0.0,0.0586139677,0.262485659,0.359493322,0.01378663,0.0204000452,0.0,0.28693436699999997,0.183973885,0.0,0.0749108188,0.216853262,0.0,0.0,0.156838376,0.347079945,0.0,0.0,0.297468062,0.0,0.315839021,0.21171537399999998,0.0,0.17093243,0.154879836,0.0,0.206257932,0.125701254,0.0160035879,0.0,0.0,0.344987875,0.0,0.24121166100000002,0.153523013,0.000569242489,0.394101561,0.0,0.0,0.18091579100000002,0.0,0.0601659628,0.320754611,0.0292404268,0.0,0.663838487,0.460048044,0.11468369,0.412283971,0.569947514,0.656636304,0.212589324,0.34211714600000004,0.954525147,0.233156759,0.175616529,0.8200709079999999,0.0,0.656345084,0.0,0.320651776,0.299270935,0.061282984299999996,0.0,0.0,0.0,0.284576795,0.0,0.0,0.0,0.0,0.232099429,0.314641148,0.137993206,0.229165669,0.5492890429999999,0.229256757,0.666401038,0.0,0.461665053,0.304871946,0.38119110700000003,0.0,0.0,0.0266503867,0.12441743599999999,0.117469376,0.262047486,0.221469408,0.0176220088,0.0,0.012374069299999998,0.0381669035,0.149198161,0.0,0.34320629,0.549453257,0.431834427,0.693060536,1.42738588,1.18941818,1.96689966,2.00273304,2.95224992,3.17358075,3.32585718,3.90099217,4.13175905,4.45875842,4.87818119,4.1524972,4.695231,4.97105791,4.57452007,4.17654827,4.61393875,4.28138681,4.08018385,3.71370902,3.43038696,2.71918265,2.4890151,2.36875713,2.24614446,2.06187764,1.30945031,1.48801889,0.656680502,0.259674218,0.0708095745,0.771931343,0.617107344,0.47515347799999996,0.0,0.290158263,0.37275047899999997,0.0,0.0,0.0,0.350359087,0.42711052200000005,0.157497098,0.0,0.0,0.705889757,0.247760996,0.725896957,0.6696102629999999,0.5869754070000001,0.46856082600000004,0.7091783890000001,0.0,0.131233825,0.0674848497,0.418167616,0.0,0.0,0.33685921,0.0,0.0137487326,0.0,0.0808107136,0.0,0.0,0.0,0.050835751799999995,0.0,0.270588031,0.24070301,0.0,0.08845657359999999,0.155651365,0.134665788,0.22582747399999997,0.22368358300000002,0.0,0.26352921,0.0,0.0,0.0,0.0861412299,0.22126670199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.261316563,0.266858897,0.0,0.209522636,0.0384947314,0.278771005,0.576269814,0.566930464,0.472500786,0.544701431,0.59513061,0.142752549,0.201228895,0.508730943,0.498373502,0.226073907,1.13067027,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
5.10715988,4.7185334,3.56676105,1.9823057000000002,0.408483548,0.0,0.0,0.0,0.0,0.524141281,1.2520121000000002,1.62663326,1.59419588,1.24956802,0.7729759070000001,0.345877064,0.0820898649,0.0,0.0355088671,0.0968363606,0.10887695300000001,0.049466417699999994,0.0,0.0,0.0,0.0,0.020997602999999997,0.11810644699999999,0.15451603,0.11191741699999999,0.0129562901,0.0,0.0,0.0,0.0,0.0605689425,0.133601683,0.138106761,0.0726272184,0.0,0.0,0.0,0.0,0.0,0.0990746016,0.158650065,0.150655399,0.0830443246,0.0,0.0,0.0,0.0,0.0288328516,0.09246757189999999,0.109862985,0.0706278831,0.0,0.0,0.0,0.0,0.0,0.061764974900000005,0.11220758800000001,0.105667353,0.0449191079,0.0,0.0,0.0,0.0,0.014483400300000001,0.09249043130000001,0.124390895,0.09293112699999999,0.012929351499999998,0.0,0.0,0.0,0.0,0.05411352480000001,0.12615094,0.13546558,0.0747881997,0.0,0.0,0.0,0.0,0.0,0.109301458,0.174803684,0.153030615,0.0482865128,0.0,0.0,0.0,0.0,0.0641853175,0.229258281,0.296957066,0.212348087,0.0,0.0,0.0,0.0,0.0,0.508383981,1.3773578000000002,2.30819439,3.11627681,3.6471006,3.81710097,3.62937301,3.16183844,2.53538903,1.87546693,1.28061063,0.8065015870000001,0.466760319,0.245471808,0.113515894,0.0417421204,0.00758478395,0.0,0.0,0.0,0.00124052474,0.0,0.0,0.0,0.0,0.0,0.00960267998,0.0168600432,0.0158490245,0.00549526939,0.0,0.0,0.0,0.0,0.00652991405,0.0238263619,0.0297750765,0.0202771543,0.0,0.0,0.0,0.0,0.0,0.0165239985,0.030559329399999998,0.0282360496,0.0119329404,0.0,0.0,0.0,0.0,0.000150415112,0.0,0.0,0.0,0.033827639300000004,0.18244314600000003,0.430954165,0.741905356,1.03271012,1.19864795,1.15310748,0.869677513,0.406527852,0.0,0.0,0.0,0.0,0.0,0.401419036,0.677299219,0.6272963429999999,0.228053737,0.0,0.0,0.0,0.0,0.37648075,1.86606517,3.42750098,4.62619691,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.20749156,0.0,0.35141522,0.0,0.8291103999999999,0.15478652,0.295243,0.0,0.43443559,0.97903217,1.65090946,2.69196804,4.1314826,5.60172778,5.37091922,4.15318585,2.40519468,1.58303593,0.52521382,0.40818974,0.37898912,0.0,0.38411696,0.0,0.0,0.05808314,0.0,0.0,0.0,0.0,0.400986,0.28329645,0.0,0.23066364,0.0,0.0,0.22836079999999997,0.0,0.22474932,0.46547478,0.0632589,0.18446464,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.444
5.72386875,4.67809721,3.8800576,0.0,0.0,0.0,0.916115735,0.0,0.743483908,0.248327623,0.915664914,2.13837302,0.0,1.08349805,0.0,0.0,0.0,0.0,0.12752407699999999,0.0,0.506019176,0.36614447299999997,0.61264107,0.0,1.87087586,0.0,0.0,2.99353661,0.22565044399999998,0.0,0.0,0.0,0.7578121390000001,0.0,0.0,0.04640250730000001,0.881958535,0.662597774,0.9192688090000001,0.0,0.124401359,0.0,0.967147083,0.6633578410000001,0.751282923,0.0,0.0,0.467103056,1.19743153,1.18235959,0.607623351,0.35302073100000003,0.37900518,0.0,0.438851579,0.0,0.0,0.923238515,0.129230018,0.0,1.23645267,0.993938665,0.0,1.61083561,0.992603001,0.137154136,0.57838491,0.0,0.11923007199999999,0.624421617,0.0,0.0,0.325518172,0.0,0.55637829,0.0,2.53410531,0.438393884,0.241822283,1.16435343,0.568792712,0.63666451,0.0,0.0,0.9818291309999999,1.35733753,0.0,0.0,0.0,0.0,0.0,1.57640827,1.3207882,0.0,0.0,0.0,0.379396466,0.755717367,0.0,0.0,0.465627977,0.891276106,0.0,0.0,0.279932162,0.0,0.226308895,0.312538268,0.0,0.0,0.978047197,0.0,0.35087255,0.0,1.1586775,2.10363917,0.623906713,2.36815411,0.0,2.38509561,0.0,0.662528899,0.42584931299999995,0.0558478792,0.983960972,0.0,0.0,1.25866467,0.0,0.0,0.975199473,0.765428322,0.0,1.30600713,0.52962186,0.0,1.59887665,0.0,0.24816311300000002,0.258110012,0.19480618800000002,0.39373377,1.11406802,1.8040098000000002,0.0,0.73898445,0.0,0.0,0.0,0.0,0.0,1.24400588,0.08126767,0.0,0.0,0.550913729,0.0,0.0,0.0,0.0,0.282318511,0.0,0.0308862348,0.0,0.0,0.907711293,0.0,0.0783360844,0.442800838,0.0234811343,0.0,0.648772825,0.0,0.0,0.37349959,0.319786716,0.22604533699999999,0.0,1.30168714,0.187734554,0.273593546,0.0,0.0,0.0,0.241021966,0.0,0.621702326,1.11346375,3.27786371,4.680598000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.710047188,0.43871672799999994,0.33343037,0.44625354700000003,0.0,0.140927755,0.360382921,0.311120164,0.0,0.311556035,0.427554218,0.704418855,0.0,0.0,0.627307954,0.142446344,0.0214645069,0.0,0.0387498811,0.0,0.091825461,0.211243715,0.6469375079999999,0.0,0.0,0.162061917,0.77210884,0.183216319,0.0,0.0,0.617116161,0.0,0.031274669,0.599918278,0.0,0.0472682059,0.2722515,0.0,0.0,0.00265427974,0.0,0.0,0.273562831,0.253338553,0.8085024040000001,0.11523497,0.0,0.0,0.142548659,0.0,0.365749909,0.3967791,0.325492734,0.612937369,0.846413137,0.793829826,0.830408455,0.137472361,0.538346463,0.384223811,0.0,0.0,0.203878382,0.5286381179999999,2.69405626,3.93924576,5.57262149,5.64491587,7.31925494,7.66082508,6.58152034,5.86234316,5.24232299,2.71169584,1.70517955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0686934475,1.19899861,0.0465724048,0.598312737,0.199589488,0.227913347,0.0,0.178149115,0.869271028,0.47224912,1.28470081,0.70190686,0.992202903,0.42759459899999996,0.580653415,0.0,0.6289343070000001,0.187671605,0.0,0.0,0.8657157409999999,0.0,1.22085415,0.6745702990000001,0.187593569,1.10482091,0.0,0.5244356029999999,0.0,0.292290963,0.0,0.272740333,0.09214043300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.0806158895,0.0511249879,0.136895453,0.22556750000000003,0.239958831,0.191547324,0.149292721,0.159666911,0.197313513,0.194730968,0.123154792,0.0459671132,0.08722651349999999,0.33245736,0.740852634,1.14407977,1.34096095,1.22385771,0.84850138,0.399354259,0.0746414914,0.0,0.024276516,0.09685477880000001,0.06647530530000001,0.0,0.0,0.0,0.19254756,0.558344379,0.782745385,0.7133874240000001,0.390265375,0.023773725099999997,0.0,0.0,0.0737387322,0.17563381100000003,0.115839946,0.0,0.0,0.0975135931,0.285313571,0.322861248,0.128255867,0.0,0.0,0.102036271,0.756599152,1.42853621,1.78115339,1.67531688,1.2319541999999999,0.70803553,0.310262067,0.0965301824,0.0121226301,0.0,0.0,0.00867586318,0.027006014900000003,0.0157519048,0.0,0.0,0.109015427,0.33430875600000004,0.564379712,0.6570719389999999,0.53953624,0.270419375,0.0,0.0,0.0,0.0233945167,0.155086516,0.223003824,0.21497670100000002,0.148922834,0.0515124687,0.0,0.0,0.0,0.14842812800000002,0.33100547399999997,0.431713291,0.387728248,0.227614714,0.050887981500000005,0.0,0.0,0.0063806381200000005,0.0393368637,0.025741722999999998,0.0,0.0,0.0,0.00949541936,0.0172650053,0.006162313670000001,0.0,0.0,0.0,0.00463896523,0.0147821048,0.0482834242,0.11641733900000001,0.197393168,0.24088739399999998,0.20515996,0.0963654089,0.0,0.0,0.0,0.0455348964,0.149669632,0.193284916,0.161955565,0.0923235516,0.0378682408,0.023943856099999997,0.028160184100000003,0.00573772394,0.0,0.0,0.00794540236,0.323334821,0.8000092609999999,1.23270185,1.36966304,1.09001888,0.524681828,0.00976042708,0.0,0.247054843,0.91950378,1.54671353,1.85767164,1.82019332,1.60422358,1.40525725,1.29297798,1.20749399,1.07723542,0.921964085,0.833781815,0.862680483,0.9346573990000001,0.898351769,0.664023173,0.300281487,0.0,0.0,0.0,0.07508019860000001,0.10495404900000001,0.0224382035,0.0,0.0,0.0,0.0888884491,0.10824401300000001,0.051101096500000005,0.0,0.0,0.011857096499999999,0.039135809900000006,0.0221617005,0.0,0.0,0.0,0.006097064960000001,0.0,0.0,0.0997935104,0.380158203,0.745083298,1.00778751,1.02810099,0.85354496,0.709146988,0.81916401,1.20290708,1.63001271,1.79613178,1.58895415,1.22398732,1.12392264,1.6198721999999999,2.69778238,3.98063173,4.9569448,5.28595916,4.96755611,4.280905799999999,3.56729953,3.02727476,2.66170715,2.36101652,2.04116605,1.71358241,1.45101598,1.30171381,1.23783667,1.18206044,1.08171868,0.957957139,0.8821235479999999,0.899343021,0.9696732240000001,0.984915037,0.8531200309999999,0.580420836,0.27749861800000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.299946228,0.0,0.203863735,0.0,0.0,0.078096275,0.0,0.0,0.0,0.0,0.06920547889999999,0.535219221,0.125786104,0.276655337,0.0562685347,0.138736995,0.7112564690000001,0.599590252,0.66497879,0.368907971,0.32194694100000004,0.425871276,0.13847784,0.110109291,0.0281059581,0.190664754,0.0,0.0,0.0,0.28397893,0.42824991,0.18038932800000002,0.12080285,0.33788019700000005,0.544057264,0.243405681,0.427925527,0.227756879,0.125951699,0.197821676,0.250028865,0.329662357,0.0,0.0,0.340979769,0.0482233367,0.0,0.259052055,0.475805431,0.34583516200000003,0.307534776,0.509890475,0.604499771,0.0336234255,0.0,0.282866397,0.0,0.0259212235,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0166459232,0.381774835,0.542512097,1.02685899,1.79289085,1.95785994,2.3779471,2.81604572,3.26178506,3.16441418,3.55587029,3.43365447,3.18743973,2.84811451,2.99808168,2.7122507000000002,2.08097728,1.43698733,1.18872186,0.641104444,0.39504377700000004,0.40683295799999997,0.0488359226,0.12925437,0.170056443,0.0,0.0,0.231948017,0.121504759,0.0,0.428181086,0.0155257127,0.115019013,0.0,0.27412842800000004,0.414366202,0.33013331100000004,0.19056340100000002,0.0,0.0,0.18600805399999998,0.0117573876,0.0,0.0,0.0,0.0,0.187176653,0.131245979,0.158719219,0.0,0.0794710151,0.0,0.258570119,0.0,0.0,0.316701772,0.174521062,0.31744574,0.0,0.0,0.0,0.149745669,0.0,0.0036488496000000002,0.0125695694,0.0,0.118542331,0.0,0.39251643,0.045469647300000006,0.0595277291,0.171134903,0.0,0.17097552300000002,0.18374179300000001,0.149295289,0.169954262,0.17424072699999998,0.0,0.286935057,0.0,0.18501337699999998,0.20391999600000002,0.0,0.0844511452,0.121878945,0.0143931006,0.0,0.023220954300000003,0.006744156459999999,0.159057402,0.0,0.0,0.353123046,0.0,0.0,0.403982668,0.275471619,0.175001105,0.0,0.0,0.245911648,0.148535901,0.0,0.232406665,0.0,0.235695197,0.007721878940000001,0.0,0.0,0.191521941,0.0,0.065674683,0.0,0.0,0.308146498,0.29232944,0.0,0.35529995299999995,0.150560505,0.261734278,0.0750162604,0.101583989,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43
5.6802074000000005,5.4120105,4.53462555,3.98202604,3.25815577,2.78058419,1.46359868,1.1202876,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.135259608,0.7970049220000001,1.12845227,0.7697360670000001,0.561507744,0.96570167,0.538451328,0.26533756,0.132797561,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0234182163,0.234816012,0.0,0.528931179,0.0232469984,0.00584072872,0.540271455,0.323811054,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.406601359,0.0,0.31360970000000005,0.044860575199999995,0.573843011,0.0,0.572312305,0.158632215,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.205579371,0.274673703,0.056383609,0.7134730509999999,0.0,0.0,0.462543376,0.0,0.0965439124,0.286654041,0.0,0.09819320050000001,0.0680980388,0.262345125,0.0,0.0,0.217703827,0.0202461693,0.0108601022,0.402050257,0.256720374,0.36417213200000004,0.09120244300000001,0.0,0.42155793700000005,0.290632625,0.127345861,0.0,0.0,0.0,0.270328344,0.0,0.22406349,0.0,0.20013338100000003,0.605904749,0.761251667,0.532432945,0.44047653,0.68607656,0.0,0.35461579,0.242832121,0.0,0.0,0.0,0.137028545,0.07012989559999999,0.164418394,0.319373448,0.562863695,0.922565036,0.031190134900000003,0.0,0.080783093,0.7258140559999999,0.125745956,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.426675941,0.0,0.592286687,0.716098448,0.618624395,0.7425316209999999,1.50632412,1.40622972,0.919066534,1.1585412,0.172203128,0.0,0.354417669,0.398482024,0.51834419,0.507783268,0.767540245,0.827434387,0.307356992,1.3368138,0.6429315720000001,1.14410597,0.766469987,0.7418121879999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.396918616,0.35758321200000004,1.73966619,2.17896629,3.52773987,3.94154407,5.38516858,5.22055133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.46641261100000003,0.556726166,0.312031071,0.833825756,0.937898234,0.393627856,0.31367813,0.249222423,0.418852327,0.353161684,0.0,0.324045491,0.344799874,0.0,0.391832823,0.422551914,0.265294662,0.0348895519,0.0880014894,0.0,0.312856772,0.0422663138,0.0,0.061622665800000004,0.0,0.0,0.0810652821,0.0,0.264533225,0.0,0.12293229900000001,0.0,0.248755442,0.119179059,0.0,0.0,0.0,0.263287534,0.4002143,0.332321174,0.0,0.0,0.0,0.270488808,0.0,0.259028624,0.0,0.100493581,0.0,0.0,0.177510069,0.0,0.202608747,0.0,0.0,0.151704063,0.412170886,0.354395587,0.586912885,0.602101429,0.837100079,0.13838647699999998,0.343623512,0.0546712632,0.19824779,0.0392253848,0.128360253,0.0,0.0,0.0,0.134281949,0.06653690599999999,0.13043786400000001,0.350600952,0.0,0.232484325,0.360667047,0.283908917,0.111788505,0.39306141200000005,0.40859577700000005,0.20575306100000001,0.0,0.0,0.0190360178,0.0,0.32556475,0.0,0.0899113808,0.006728022790000001,0.0,0.0471589588,0.0977181516,0.0,0.00435525885,0.0,0.428729784,0.0,0.18371079199999998,0.0,0.0,0.146093271,0.0,0.0,0.246734022,0.379128357,0.0,0.314445374,0.0,0.38626504100000003,0.264788627,0.05457928980000001,0.0,0.0,0.329300627,0.261860899,0.146924041,0.26813177,0.457646925,0.110241293,0.0,0.0,0.0,0.128618401,0.410087904,0.649699561,0.662022314,0.116111343,0.362285319,0.0,0.0,0.0,0.0,0.696372592,0.6573092739999999,1.86248521,2.95503312,3.50401323,3.73537573,4.13186479,4.29557339,3.38455832,2.68070182,2.14313099,1.8361758999999997,1.13502593,0.907151699,0.0322038563,0.353007814,0.37599826799999997,0.278848585,0.517317951,0.11998386400000001,0.436155315,0.317648954,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
1.67266359,0.400578775,0.347830829,0.959517737,0.585042643,2.54009548,0.0,0.0,0.0,0.0,0.0143496399,0.0,0.0,0.0,0.290425214,0.0,0.0,0.0,2.12236555,0.36284066200000004,0.832865506,0.0,1.74162113,0.0,0.0,1.96838941,1.0256713,0.0,0.0,1.3579013999999998,0.0,1.76674046,0.0,0.0,0.0,0.772683056,0.0,1.33199808,0.0,0.0,0.0,1.82318958,5.28979108,3.96536697,2.33676804,0.0,0.0,1.2895166,0.10611305,0.0,0.0,0.0,0.35279825200000003,0.0,0.0,0.47882536,0.0,0.472814963,1.0253538,0.0,0.0,1.40255206,0.0,0.0,0.0,0.0,0.729894693,2.33878218,0.06445181679999999,0.869916612,0.334468339,1.51883198,2.82292462,0.596995564,1.6202842,0.0,0.329494403,0.12414171,1.85054728,0.713272758,0.642869627,0.0,0.0,0.0,0.238811398,0.20172164199999998,0.0,1.10559733,1.03693502,2.53668694,0.0,2.89206344,0.9139430829999999,1.29102959,0.0,0.0,1.63708941,0.0,0.656902177,0.854511754,1.08894826,0.0,0.0,1.68996132,0.0,0.0,1.10469197,0.818625736,3.86333858,2.40484802,0.0,0.24870916699999998,0.0,0.051946672199999995,0.0,0.383232402,0.0,0.8886585570000001,0.0,0.38845314799999997,0.6719124040000001,0.54720828,0.791844185,0.0,0.0,0.32895952100000003,0.0,0.50540517,0.92000167,0.0,0.0,0.0,1.10794739,0.826269722,0.22641338100000002,0.0,1.83400775,0.0,0.0,0.0,0.0,0.0,2.08364614,0.0,1.93553088,1.04610652,0.0,0.0,0.616261542,0.857899712,0.0,0.0,0.535691796,0.533652601,0.0,0.295768672,3.49330634,0.164085975,0.0,1.61243257,0.8785056720000001,1.87650166,0.611363112,0.325750566,0.0,0.5902950260000001,2.35760802,0.55276113,0.0,0.0,0.0,1.29189916,0.0,0.0,0.0,0.0,0.0,2.40754106,0.0,0.0,0.0850403541,1.01481708,1.55443526,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
0.7055419690000001,0.00511245301,0.0,0.542966686,0.413930054,0.0,0.0772086989,0.0,0.0,0.46507134200000005,0.0383596158,0.54305389,0.0,0.0,0.409399743,0.27918681300000003,0.0668905462,0.35689376799999994,0.0,0.0,0.259026747,0.0472806978,0.0,0.26550981100000004,0.164875139,0.329332177,0.0,0.036733595099999995,0.345954931,0.5311801829999999,0.549474856,0.225729658,0.36517607,0.391123541,0.80400096,0.717439596,0.309332695,0.9494601029999999,0.40450272600000003,0.195825915,0.0,0.0,0.0,0.0283313863,0.0,0.0,0.0669157462,0.0,0.0730373901,0.0,0.0669890442,0.0,0.583123547,0.45889164,0.318450453,0.312735278,0.36435435,0.0,0.487006015,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.31329215,0.128634464,0.0,0.0,0.0,0.0,0.25187160399999997,0.09766688890000001,0.12617070800000002,0.0405411096,0.0,0.0,0.18513349699999998,0.0,0.0,0.0,0.39713677799999997,0.0,0.131083475,0.45633426,0.594155436,0.732146483,0.835379235,0.0,0.00132155162,0.025974795099999996,0.0,0.0,0.0,0.0,0.0,0.059681940700000005,0.0,0.0,0.0,0.059860547699999996,0.837248008,0.454026606,0.179728599,1.15573578,0.341937735,0.42676291899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.559635688,1.40963907,1.55791944,2.83673213,3.27041588,4.39684962,4.393033900000001,5.15075968,5.05771164,4.95963251,4.64307883,4.24556716,3.8725902999999997,2.89927665,2.03819097,1.5076943,0.918274245,0.386423413,0.0,0.0,0.0,0.0,0.0,0.0,0.463471464,0.298421085,0.9852919790000001,1.38360536,0.674385795,0.692232948,0.404304273,0.989537074,0.010834104099999999,0.57807532,0.0,0.130780753,0.0,0.0,0.0,0.052805522599999995,0.26415334,0.282239982,0.0,0.422897066,1.20089434,0.7155806490000001,1.42793815,1.38535208,1.8360151999999998,1.42012292,2.11722446,1.48438194,1.49837542,1.29395828,1.37244013,1.07541842,0.658365654,0.642700742,0.43176183700000004,0.9820737340000001,0.478598243,0.570644006,0.503823131,0.142170298,0.433043371,0.027986589500000002,0.0559472529,0.33139281600000003,0.0,0.0,0.0,0.43744264899999996,0.0,0.278914764,0.470405146,0.0,0.0,0.535658037,0.0,0.0,0.0,0.0,0.301417886,0.0,0.195760104,0.224112355,0.0,0.0,0.0,0.0,0.110079864,0.509031578,0.523563287,0.497130643,0.164337167,0.0,0.0808844044,0.0,0.25211407,0.038288592,0.0148531262,0.0,0.460964162,0.607423131,0.571598984,0.74491992,0.117359578,0.602647855,0.356618875,0.91118515,0.8450396840000001,0.692364462,0.579566963,1.39573267,0.420556845,1.02460602,0.242223406,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
0.39416899299999997,0.295705699,0.128790278,0.31489622100000003,0.267204701,0.335010617,0.196253525,0.513718334,0.42193630000000004,0.57683392,0.412794781,0.413636254,0.113310583,0.41068271,0.508082213,0.608556969,0.14368483,0.26025581600000003,0.210165952,0.316985308,0.269230309,0.581099673,0.585151236,0.742840121,0.723370223,0.347404266,0.538427322,0.5259440710000001,0.40032804899999996,0.48055654,0.7976160109999999,0.47827442299999995,0.764434869,0.534730284,0.6469566139999999,0.60442801,0.873451913,0.524194255,0.714902822,0.506559741,0.46801384,0.5916106489999999,0.596652665,0.636284506,0.626051549,0.190654392,0.22602784399999998,0.325976581,0.0246189079,0.0,0.00426614781,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.007661017459999999,0.0,0.0,0.0,0.0877456013,0.399184097,0.661924311,0.5749307920000001,0.552286549,0.7587004829999999,0.902149575,0.70097421,0.70332443,0.8126125609999999,1.11705582,0.662947517,0.91933962,1.0707775,0.639694484,0.910526095,0.402747864,0.656174241,0.48859455,0.179352916,0.043179477300000005,0.37769135299999995,0.0,0.229689328,0.204754765,0.32312723600000004,0.308089528,0.0761847258,0.583241779,0.754772855,0.998968428,1.0438203000000001,1.60688931,1.60612568,2.08407683,1.8699276999999999,2.23128524,2.76595985,2.45442325,2.70774431,2.75134536,3.31260699,3.28566945,2.78528088,2.81016701,2.7379944,2.86434658,2.78775691,2.35915782,2.7477476000000003,2.60762635,2.27104192,1.84712363,1.91517138,1.55039922,1.69999915,1.25793152,1.65085955,1.50440144,1.3125189,0.9806785440000001,1.18738566,1.07507904,1.17656284,1.11951275,1.31906085,1.13052519,1.54944275,1.20404483,1.12956776,1.0170353,1.15437447,0.92808105,1.04169207,1.19978657,0.763444035,0.990219133,0.820865898,0.687521583,0.394145154,0.582139458,0.221015148,0.127896223,0.277249829,0.0891953714,0.0714380111,0.0,0.0,0.0,0.0,0.110339256,0.0,0.0,0.06637150900000001,0.14542316800000002,0.30607289,0.257960915,0.0140209257,0.0,0.032939903799999996,0.215003036,0.0661785159,0.10275492800000001,0.0,0.356638712,0.0242450014,0.213250067,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0858673487,0.0,0.0,0.17782815899999999,0.0,0.262190977,0.0,0.0,0.291413648,0.0,0.36275644,0.17804568,0.0,0.0,0.286620317,0.240037776,0.301934545,0.14303267,0.0,0.0,0.0234271028,0.0226582414,0.0,0.119046315,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23087759100000002,0.0,0.0942847045,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.8125608609999999,0.388409719,0.0859389207,0.135560856,0.0,0.0,0.0335939273,0.448064745,0.0,0.38450080200000003,0.0,0.0,0.0,0.437886409,0.0,0.0,0.0783655838,0.5320321339999999,0.0,0.0,0.0,0.0824911092,0.0,0.0,0.53917905,0.0,0.33930820799999994,0.0,0.432324389,0.0,0.463264999,0.0,0.0,0.0,0.274904138,0.0,0.02207355,0.07756532070000001,0.21617426399999998,0.268757578,0.0,0.0,0.201186685,0.468872709,0.927524545,0.664562594,0.921819589,0.467209999,0.0,0.0212731474,0.153258729,0.44677850399999997,0.0,0.550227194,0.0,0.868833995,0.45873780399999997,1.96674622,2.32252525,1.80978932,1.40040412,0.970826566,1.06985666,0.4779561,0.0,0.0,0.503577987,0.297889912,0.397851006,0.0,0.208979306,0.0,0.27353365399999996,0.228567954,0.0,0.0,0.150419249,1.28346001,2.30886757,2.08009988,2.09628966,0.204608487,0.0,0.0,0.0,1.80004373,2.35557707,2.81099719,1.45682824,0.0,0.06955901610000001,1.15240413,3.76688413,5.74602123,5.1157485000000005,3.9251416,0.521177809,0.0,0.0,0.0,0.66950115,0.924020576,0.0327230802,0.0,0.0,0.0158203326,0.193721125,0.9874403390000001,0.30876834,0.0,0.0,0.0,0.380499219,0.48145384,0.648272745,0.38251245700000003,0.0,0.0,0.0852446358,0.0,0.18097871899999998,0.32864942399999997,0.0,0.0,0.0,0.0,0.281473367,0.260410672,0.0,0.0,0.158899437,0.528360194,0.0,0.251705508,0.0,0.0,0.186647829,0.0,0.351774265,0.318939885,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.61005347,0.76152754,1.12118052,1.49605099,1.63078971,2.37447987,2.3479794999999997,2.2199965,2.51103015,3.62295184,3.87432474,3.38924957,4.33999491,3.96631367,4.55685908,4.4905739,4.51035561,4.18878935,4.33941816,4.5143364,3.94160041,3.8477751000000002,4.22391919,3.81403388,3.65157965,3.27831742,3.46253548,2.9641474,3.03257576,1.94169359,2.17403832,1.84306434,0.96109088,0.88676781,0.67697537,0.34209335,0.65334793,0.0,0.06361468,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10760036,0.40924287,0.0,0.42954013,0.44754014,0.66000584,0.50008672,0.60983144,0.63252541,0.83931723,0.13471967,0.76570505,0.18060199,0.62144023,0.08266478,0.47483859,0.31881769,0.56171254,0.08046702,0.08105172,0.08490393,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.01034609,0.0,0.0,0.06384382,0.0,0.22172317,0.0,0.36486709,0.0,0.16728056,0.0,0.13607784,0.36503697,0.43717984,0.54067609,0.72120631,0.73970616,0.10141119999999999,0.36210183,0.82955364,0.52569106,0.4330568,0.09278523,0.11021007,0.50704716,0.21442099,0.01058299,0.0,0.0,0.01379043,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.06781083,0.0,0.0,0.25027978,0.0,0.0,0.0,0.29062658,0.0,0.56335893,0.84686546,0.31073152,0.28642665,0.54589023,0.64484392,0.79869054,0.21604675,0.63183798,0.11740108,0.09347059,0.347351,0.78553193,0.06903646,0.0,0.04725589,0.19851056,0.0,0.06121189,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14198671,0.0,0.0,0.30357061,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
0.11677973300000001,1.31095561,0.357857782,0.0,0.34449881200000004,0.62499521,0.0,0.0,0.0,0.0,0.0,0.5134088729999999,0.0,0.8661513679999999,0.0,0.44176814,0.9179091970000001,0.892954202,0.0,0.0,0.0,0.0,0.321498553,0.0,0.0,0.0,0.11848112699999999,0.0,0.522764738,0.61653197,1.23895311,0.0,0.36511911799999996,0.282113135,0.462759615,0.0,1.14594692,0.126801266,0.142836028,0.23806620000000003,0.0,0.0,0.0856244736,0.700699092,0.22582217699999999,0.614794999,0.0,0.913319112,0.518754065,0.0,0.0,0.0,0.0,0.773703605,0.0,0.0,0.0,0.8260370840000001,0.265181509,0.0839249807,0.0,0.498812023,0.681204459,1.24565884,0.77803232,0.21562183899999998,1.46748227,0.0,0.0,0.23618374399999997,0.0,0.0,0.0,1.53828436,0.460500511,1.54244948,0.529276148,1.20473853,0.0,0.0,0.0,0.0,0.0,0.38157904200000003,0.0,0.0,0.0,0.225386975,1.19879167,0.897185187,0.875210809,0.307473648,0.369021361,0.0167027683,0.445402609,0.309646172,0.0590971346,0.0,0.0,0.707892486,0.053855037800000005,0.411842118,0.0,0.0,0.225465057,0.0,0.35583498,0.520159357,0.18679565399999998,1.68836921,0.0,0.0,0.0,0.48926629200000005,0.0,0.0,0.0,0.178043074,0.31254334699999997,1.67101046,1.70549888,0.8444436809999999,0.0,0.0,1.70323213,0.553788256,1.76382807,3.99156595,2.69447055,3.69038887,2.52723479,1.39261182,1.36970167,0.233449888,0.0,1.77727283,0.169245498,1.01119107,0.0,0.437432208,0.121599836,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.64356344,0.0,0.10123187,0.0,0.0,0.30696509,0.26148163,0.81222359,0.84787909,1.12058305,0.96415326,1.23168453,0.95107573,0.51442275,0.87374961,0.69953577,0.05352475,0.21354704,0.06689047,0.18295453,0.0,0.0,0.70760425,0.62789024,1.16859407,1.73712763,2.01505988,2.5132738,2.83945389,3.10265285,3.23031081,3.6746686,3.64562272,3.7876218,3.4961873999999997,3.10541816,2.28020392,2.18777679,1.57702725,1.53065983,1.15006105,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
2.9991604,0.0,0.0,0.0,0.81520581,4.14033119,17.88225522,0.07275124,1.55124907,0.0,2.31286727,0.0,2.25825891,0.9718962999999999,3.76806633,0.0,0.0,0.0,0.0,1.07617245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46799999999999997
2.58501708,4.98790949,7.57963398,7.73511499,7.15337087,2.57154803,1.0044585,0.0,0.0,0.18118522,1.43285657,1.50215745,0.24652145,0.62869297,0.0,0.0,0.0,0.27980254,0.58929076,0.10671161,0.0,0.49338141,0.33793029,0.23756902,0.0,0.0,0.74168984,0.0,0.83105813,0.1395159,0.74393176,0.0,0.0,0.92704707,1.41268738,1.45378512,0.90072341,1.73447956,0.85945687,0.67490319,1.0448636999999998,1.12379931,1.5006653,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46
0.145948559,0.194589437,0.23857762,0.252136103,0.224040495,0.156622521,0.0627197289,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0500228273,0.128485397,0.181366458,0.199363189,0.18004557699999998,0.128035541,0.053882679800000007,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00932875213,0.0797481911,0.133924025,0.16232402699999998,0.160300154,0.128808237,0.0741121214,0.00655247765,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0470993367,0.10790562199999999,0.149752654,0.164709053,0.14939845699999998,0.10561465800000001,0.0400975851,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.029803811099999997,0.159857596,0.297076269,0.42734756,0.5374012260000001,0.6164033320000001,0.657166324,0.656840584,0.617032574,0.543374541,0.44463992399999996,0.33154855,0.21543194,0.10693074400000001,0.0148763367,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0208732563,0.0492863428,0.0662000209,0.0699974413,0.0611999289,0.0422339508,0.0169555457,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0038908892200000002,0.0276570798,0.046443806100000005,0.056812281,0.05676876769999999,0.046140111399999996,0.0266463283,0.0016471402300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.022050394100000002,0.05013530099999999,0.0703253432,0.0783454413,0.0718881589,0.0511417572,0.018907606100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0177328835,0.0861476667,0.156996266,0.222377563,0.275317435,0.31080915600000003,0.326504144,0.32293733399999996,0.303255352,0.272505768,0.23662541,0.20132005600000002,0.17104640699999998,0.14828617800000002,0.133245044,0.12402650400000001,0.117237928,0.10890094199999999,0.09547729519999999,0.0747967909,0.0466910659,0.013193518799999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0163431031,0.0548009053,0.08482533689999999,0.10019985599999999,0.09716642119999999,0.0752924329,0.037743379,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.056752742800000006,0.107676967,0.140735134,0.148588015,0.128320546,0.0822432013,0.0177393115,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0473357723,0.13204449199999999,0.197618065,0.231038002,0.224978653,0.179642103,0.10326546199999999,0.011105543,0.0,0.0,0.0,0.0,0.0,0.0912747734,0.24762108100000002,0.400491881,0.519140536,0.575632806,0.550873409,0.43989574,0.255434697,0.0290011255,0.0,0.0,0.0,0.0,0.222662002,0.904794908,1.85295999,3.03468887,4.38764634,5.82448407,7.24115341,8.52770488,9.58022784,10.3123963,10.6651165,10.613016499999999,10.166941900000001,9.37216587,8.30260078,7.05183377,5.72221916,4.41348708,3.21234485,2.18435426,1.36899994,0.7783804809999999,0.399429873,0.199091871,0.131493555,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.501
0.689889179,0.541693492,1.06263412,0.880076083,1.76228249,1.16257968,2.17995534,1.77805954,1.78553942,2.02324182,2.31125657,2.62667782,1.92816631,2.39513417,2.4302287000000002,1.2986786,1.154021,0.892222049,0.868901058,0.0,0.0,0.0,0.11026863699999999,0.0,0.0,0.0,0.0,0.126964548,0.298327683,0.0,0.22392405399999998,0.32633005800000003,0.0,0.810379363,0.644652246,0.0,0.0,0.0,0.0,0.519602383,0.0,0.0,0.09165541880000001,0.043845881399999995,0.0,0.311290545,0.0,0.49237062600000003,0.303348236,0.502566107,0.0,0.14500168,0.543200224,0.328581579,0.824288027,0.750819006,0.0,0.0,0.0,0.0,0.135571509,0.0,0.296789527,0.134531315,0.29027251600000004,0.157243679,0.846890537,1.54715767,1.4095305,1.14096852,1.56035045,2.41463244,1.97059289,3.03585842,2.4460946,1.68654991,2.40593617,2.63882792,0.755862588,0.750126781,0.450679612,0.0,0.13016687300000002,0.11419770800000001,0.0,0.0,0.0,0.0,0.0,0.014645229899999999,0.0,0.0,0.22947132,0.677154481,0.0,0.0,0.8340192059999999,0.0,0.135113028,0.274812214,0.0,0.0,0.0,0.6252836079999999,0.162587054,0.045234160499999995,0.0,0.0,0.0,0.0,0.0906386031,0.305655587,0.940346268,0.0,0.439931869,1.32026173,0.0,0.483347588,0.603550603,0.0,0.0,0.395649574,0.0,0.419362106,0.204391787,0.30173817199999997,0.322541872,0.0,0.0,0.0,0.0,0.142375556,0.0,0.0,0.660635925,0.0,0.0,0.49838432899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
3.59059942,3.80516271,3.466986,3.31515966,3.87338644,3.33112349,3.43790321,3.21404346,2.89488333,2.52051121,2.24062603,2.11039956,2.12943996,1.82922047,1.4479068000000002,1.08005465,1.25416889,0.630559616,0.13852076300000002,0.544193681,0.0,0.21771536100000002,0.157144077,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0913815034,0.127362179,0.0,0.0,0.191699843,0.47741758700000003,0.0891000283,0.31460102300000004,0.24545498899999998,0.125200788,0.755959837,0.773597275,0.07263196570000001,0.651172605,0.100999096,0.46734359799999997,0.48787166,0.596576079,0.39978168399999997,0.250693979,0.0,0.123127427,0.0,0.0,0.0,0.011909795400000001,0.0022196511,0.0,0.0,0.0231722185,0.0,0.0564489955,0.17465334,0.38107267799999994,0.160417632,0.0032089986100000004,0.14290078,0.0,0.0771780261,0.31649410899999997,0.0,0.191870601,0.0,0.0,0.244918072,0.31965894699999997,0.5380637389999999,0.511672076,0.601062926,0.0,0.36116721700000004,0.0,0.382797767,0.403511546,0.382708885,0.371764039,0.0260266181,0.0,0.40690755799999995,0.0,0.11797118300000001,0.0,0.0446718679,0.0,0.0,0.27961124600000004,0.0,0.0,0.0,0.0,0.148281445,0.392178814,0.11423789300000001,0.17351813300000002,0.0,0.0,0.0,0.0,0.033101447,0.0,0.0,0.320737923,0.0,0.0,0.0,0.252962517,0.0,0.199474245,0.0,0.0,0.0,0.19936031899999998,0.0,0.0,0.0,0.0,0.09846112050000001,0.0,0.303839189,0.0,0.229311419,0.0,0.419370888,0.5136019000000001,0.36175713299999995,0.5619561129999999,0.616490784,0.483994527,0.317389519,0.37112407799999997,0.543669415,0.584834028,0.125660624,0.0783988751,0.10614181,0.0,0.0,0.0,0.0,0.0,0.0,0.0656910462,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.359114252,0.6495197770000001,0.7381387140000001,1.01863393,1.59026654,1.12334299,2.07708357,1.65991138,2.40001314,2.1646725,2.60583678,2.98617371,3.18205959,3.59799663,3.44680512,3.67740589,3.60496408,4.02890782,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.434
0.20357033300000002,0.0,0.245412132,0.157404156,0.0,0.43789406,0.204721837,0.476695734,0.0506281797,0.0,0.40215510200000004,0.16545694800000002,0.149495041,0.32068149100000004,0.5109939689999999,0.434331189,0.411066924,1.01073697,1.27260643,1.18138353,1.30630203,1.39397348,1.36870145,1.28187742,1.67375331,1.77454811,1.33557555,1.38529367,1.1395446000000002,0.5409823570000001,0.6067649079999999,0.286816852,0.0,0.22743758600000002,0.10773267199999999,0.037076722799999996,0.235055166,0.100922514,0.0,0.15643074099999998,0.0,0.48719455100000003,0.31525986100000003,0.0,0.29734013600000003,0.0,0.38668946600000004,0.132506948,0.227181739,0.628869675,0.405918646,0.523908505,1.13816153,1.08817504,0.379213664,0.733055177,0.5437801720000001,0.578410136,0.159937305,0.397131674,1.08855246,1.41071087,1.13047799,0.870208602,1.44236155,1.1144652,1.26729525,1.33271999,2.13278258,2.79804275,2.99665273,3.39801383,3.28426787,3.63879871,3.33540062,2.4075766,1.23412438,1.00859166,0.022835035400000002,0.0,0.0,0.233154922,0.30931526,0.372557216,0.29529016,0.0,0.10046392800000001,0.30765508399999997,0.274567102,0.17014948,0.0,0.300913501,0.161172004,0.0592912485,0.0,0.09503475609999999,0.00107717211,0.32684517399999996,0.36327681,0.692291089,0.720795121,1.00136226,1.19593765,0.7098386999999999,1.3037618999999998,0.483277849,0.8222469729999999,0.585958026,0.185017212,0.141497349,0.0558922516,0.0,0.156857396,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.35256413799999997,0.0,0.0,0.143165868,0.0,0.15568252400000002,0.139673937,0.269058953,0.48241157100000004,0.14384329699999998,0.0,0.0,0.0,0.321556429,0.149170555,0.728241248,1.25595475,1.72867817,1.61277931,2.03978471,1.60163769,1.43597369,1.37585961,0.982163775,0.0366155738,0.473382225,0.0915849532,0.0,0.0304209423,0.0,0.0,0.0,0.102397758,0.236694338,0.0,0.0,0.0,0.127321741,0.0737057311,0.0754291847,0.442096871,0.11206706300000001,0.0112638894,0.0,0.0,0.303351145,0.26277644699999997,0.252422753,0.0959556261,0.0,0.41679217799999996,0.09814010109999999,0.00238759082,0.0,0.115802994,0.346246665,0.0,0.295999167,0.5207764770000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.255787218,0.337613472,0.180718729,0.0,0.0994654484,0.345122896,0.0,0.12171402,0.0,0.38618753,0.309915399,0.0,0.0,0.105267156,0.13419603,0.203190567,0.0,0.0356707479,0.0,0.087737625,0.0,0.0,0.0,0.17957889,0.0,0.149020376,0.287428243,0.101138859,0.37963194299999997,0.031993543199999995,0.0,0.0419107487,0.38629381799999996,0.0,0.0,0.0,0.0362535581,0.0,0.0,0.0,0.0,0.20380779699999998,0.0,0.318196777,0.461340971,0.6135744879999999,0.42844289799999996,0.0,0.0375826481,0.226161905,0.37749589299999997,0.133354663,0.0653774179,0.0,0.19983874699999998,0.420840499,0.0,0.0,0.0240249308,0.418859531,0.6327527070000001,0.13513570800000002,0.117260165,0.586118305,0.363873592,0.162373195,0.0,0.489644276,1.84832433,2.19475432,1.77651797,1.13315402,0.696048401,0.59448344,0.977550245,0.24143767,0.0,0.947837122,1.4291439,1.90277896,0.95121901,0.470044275,0.664270049,1.62777357,1.95527113,1.62633135,0.358262775,0.189059523,0.180248333,0.407397788,0.272404859,0.43903279799999995,0.10204397800000001,0.0244644702,0.0,0.0496941382,0.0,0.0,0.0,0.0258209998,0.6058334329999999,0.39408768,0.27370381899999996,0.206836186,0.134898149,1.29331995,2.09470375,1.73908853,0.927603669,0.802243857,0.61177244,0.451704803,0.443837806,0.537579199,1.02309744,1.98057055,2.42960924,2.15370652,1.51628544,1.71850698,2.13509588,2.4182587000000004,2.89440762,2.78299433,3.10714928,2.42261187,0.787628558,0.0,0.0820376542,0.363079844,1.39539769,1.64883829,1.33323753,1.53162335,0.977317997,1.01817144,0.8306117140000001,0.444253774,0.46173227200000005,0.462265049,0.71649958,1.11774652,1.26143183,0.950791268,0.548087259,0.0,0.0,0.0,0.353970496,0.0,0.0,0.0874277532,0.119222985,0.0,0.0,0.0,0.34079642600000004,0.20283235,0.191361179,0.0,0.322547353,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.425
1.45852083,0.0,0.011281778300000002,2.91738484,0.9509784,2.43487529,0.0,0.0,4.46168432,0.291650945,1.29955726,0.522739415,0.637966199,3.08360578,0.16060717800000002,0.0,0.634200954,0.0,0.983072988,0.0,1.01665583,0.799825583,1.30564229,0.0,0.408764356,0.0,0.407254985,1.41230432,1.2381536,0.27279374300000003,0.575333606,0.0,0.0,0.0,0.8429405059999999,1.7667313999999998,5.63914069,5.10336629,5.76388669,4.05208975,4.08956253,2.90139082,0.0,1.66924767,1.43330706,0.8346997509999999,2.7081771,0.0,0.0,0.0,0.0,0.57843035,0.09677864230000001,1.17899776,0.291094201,0.321850514,0.0,0.0,0.0,0.18859939899999997,0.262109209,0.0,0.0,0.0,0.0,0.0,0.984530425,0.0,1.4266603,0.0,0.0,0.0,0.122062823,0.0,0.0,0.0,1.41326622,1.94506444,0.0,0.0,0.0,0.0,2.19402028,0.0,0.0,0.677694152,0.0,0.0,1.0012578,0.0,1.42134328,0.0,0.6388494579999999,1.52430792,0.0,0.0,1.23070841,0.0,0.0,0.0,1.75411315,0.251041859,0.0,0.0,0.0,0.0,0.930874743,0.0,2.0517854,1.50499192,1.288799,0.409801464,3.65028523,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.446
0.0149314963,0.0,0.0,0.0,0.0,0.0,0.043611719900000005,0.0767907575,0.0925098484,0.09018915890000001,0.0731884447,0.0476283679,0.0208864286,2.8574798900000002e-05,0.0,0.0,0.0127818573,0.0410182501,0.0739356491,0.104780162,0.12691749,0.135098059,0.126479297,0.101228758,0.0626021247,0.0164770454,0.0,0.0,0.0,0.0,0.0,0.0,0.014356681699999999,0.0719168099,0.12542972,0.16510189,0.18274970899999998,0.173244268,0.135544685,0.0731354307,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.10335017,0.212542237,0.29777840899999997,0.344299511,0.34206908,0.287608255,0.184986763,0.0457733278,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.123399935,0.36775418,0.594638005,0.774391259,0.882680007,0.9045793240000001,0.8377092629999999,0.69393215,0.49927823200000004,0.291977688,0.11871513199999999,0.029458164199999998,0.0714138278,0.282808638,0.687248566,1.28938404,2.07248215,2.99830579,4.00943986,5.03391843,5.99172783,6.80252437,7.3937407,7.70818454,7.71026763,7.39013969,6.76522692,5.8789622,4.796810099999999,3.59999782,2.37762511,1.21801196,0.200228348,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.250071789,0.602191238,0.835375326,0.9304585559999999,0.887681278,0.725124503,0.475094339,0.178991273,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.134224369,0.354016345,0.5209151710000001,0.613383029,0.620954217,0.5452553929999999,0.399351829,0.205563573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.153796173,0.308579759,0.415445776,0.460311068,0.438152673,0.35352204600000003,0.219715506,0.0567404122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0771900844,0.22531674399999999,0.33978760700000005,0.404387302,0.41012643200000004,0.356473805,0.25138838,0.110152915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0178408739,0.173842993,0.305961743,0.394879154,0.427272561,0.397764489,0.30977288,0.175133972,0.012539041899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.140294105,0.316189724,0.45300736700000005,0.529299004,0.531177438,0.45449503700000005,0.305800849,0.101929344,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143285226,0.564870539,1.00905318,1.43840223,1.81676306,2.11308314,2.30458257,2.37891145,2.33506853,2.18301383,1.94206966,1.63834972,1.30156634,0.961627557,0.64544377,0.37431680100000003,0.162192256,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.474
0.73132622,0.158085549,0.0,0.0,0.0,0.397419952,0.0,0.179795065,0.883494696,0.44121464299999996,0.0,0.105931595,0.8785725109999999,0.785302928,0.49626838799999995,0.0,0.0912829052,0.0,0.0,0.11910266,0.0,0.292269034,0.0,0.330238057,0.0,0.0,0.27142588100000004,0.0,0.27951479,0.0257921835,0.379331601,0.38520912399999996,0.0,0.0,0.16119829,0.0165621708,0.47524275,0.666097747,0.0,0.0,0.542717452,1.40345723,1.98915424,0.737531426,0.0,0.0,0.412151969,0.17354726199999998,0.214246047,0.0,0.0,0.501962711,0.0,0.17166469,0.0,0.34950889,0.0,0.0,0.0,0.0,0.467507774,0.0,0.36665930399999996,0.0,0.413816446,0.408788118,0.46019287299999995,0.0,0.0,0.0,0.0,0.0,0.480747893,0.141820624,0.0,0.385143258,0.227223493,0.0,0.0,0.798601674,0.833970544,0.792822475,0.24928061699999998,0.16793721399999997,1.84755841,3.12938173,2.12402026,0.0,0.0,0.122465746,1.6306127000000001,1.38098991,0.414483399,0.313966425,0.0,0.205387586,0.25167493,0.0,0.7866615090000001,0.25455846600000004,0.0,0.0,0.282437351,0.14808886599999999,0.0,1.21402458,3.96333035,5.60347172,3.32599712,1.42684322,0.0,0.275936185,1.52896329,0.00542962573,0.0,0.0,0.43812866899999997,0.0,0.0,0.17973151399999998,0.36232731799999995,0.38268644,0.0,0.0,0.194643908,0.0,0.213908746,0.0,0.391595837,0.0,0.17580227899999998,0.436172457,0.0,0.406737471,0.890570656,1.24206621,2.57215738,2.07702488,2.42683523,2.60770753,2.37004567,1.3784819,0.300683876,0.0734245777,0.253612097,0.186771782,0.0,0.0,0.406614108,0.590298601,0.156890856,0.540907412,0.563062345,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.433
0.941479793,0.0,0.0,0.43265532,0.0,0.0,1.1742518,0.0,0.0,0.7006340879999999,0.0,1.66081698,1.5978608,0.0686314333,0.0,0.0,1.17129157,0.0,0.3359336,0.0,0.0,0.44550300299999995,0.429449023,0.0,0.0,0.0,0.582841268,0.22416339,1.02786034,0.0,0.0,0.0,0.0408239066,0.151933192,0.146422744,0.0,0.0,0.630280951,0.688055904,0.0,0.0,0.057031299,0.0,0.796213941,0.0,0.0,0.227651779,0.797183462,0.86304571,1.17611671,0.0,0.36677887600000003,0.0,0.55737451,0.971713539,0.911786553,0.663404314,0.9712083990000001,0.0,0.0,0.0,0.702628253,0.160270631,0.0,0.08924133390000001,0.0,0.0,0.0,0.0,1.41069625,0.0,0.369407745,0.0,0.378276974,0.059636902199999994,0.0,1.22775281,0.25890950100000004,0.171220313,0.0,0.0,0.0,1.00955974,1.07891101,1.10530247,0.335524399,0.597811558,0.8348677870000001,0.501240308,0.662846157,0.40893365600000003,0.0,0.0,0.0,0.0497041259,0.0,0.39837376700000005,0.0,1.4173751,0.0,0.172420569,0.9474119040000001,0.0,0.9129246520000001,1.48319201,0.0,0.5907474460000001,0.0,0.460268333,0.9286294509999999,0.132181495,0.0,0.234993688,0.110196252,0.130560543,0.0,0.0,0.0,0.0,1.97496302,1.18058574,1.00199474,1.14172082,2.88534658,2.64367808,2.21873046,3.4484955000000004,2.34602517,2.52943419,1.55915763,0.814046363,0.994111607,1.14173043,1.25708348,1.26507249,0.396000174,0.0,0.09328775980000001,0.0,0.23132636199999998,0.8399225690000001,0.07318982190000001,0.374033346,0.87551815,0.0,0.679091028,0.408910163,0.165391099,0.0,0.546445279,0.7557956659999999,0.129202764,0.0,0.0,0.0,0.19646864,0.19712196399999998,0.0124343798,0.0,0.0,0.0901234299,0.325475338,0.0,0.0,0.0,0.0,0.0,0.9763229609999999,0.0288847495,0.0269157557,0.655462333,0.0,0.0,0.486997588,0.0540200944,0.0,0.0,0.0302428311,0.015036846000000001,1.06812216,0.0,0.6883243290000001,0.5565375570000001,0.0,0.40357933799999995,0.0,0.0,0.0,0.0,0.0,0.5649230510000001,0.778008492,0.771610122,0.688456375,0.0480839012,0.105243116,0.44891566299999996,0.0,0.236649374,0.239312214,0.0,0.12718839699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.797061143,0.555005784,0.348342241,0.18899701600000002,0.0819250196,0.025362291699999998,0.011880643500000001,0.0300408768,0.0663804157,0.107448694,0.141620089,0.16046501900000001,0.15953616,0.138516715,0.100768485,0.052396592699999994,0.0010052816800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0195564357,0.0548530641,0.0808532506,0.0940427431,0.09302547050000001,0.0786117682,0.053571950300000004,0.022111501800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0041856383899999995,0.0273117787,0.044846759900000005,0.054647588399999995,0.0558676534,0.048992670999999995,0.0356720046,0.0183843453,3.9089827299999994e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00847220508,0.0160357246,0.0200345426,0.0203691758,0.0175790615,0.012678129,0.00691902301,0.00153295846,0.0,0.0,0.0,0.0,0.0,0.000531015135,0.00150311816,0.0009302073029999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00308897926,0.012930488899999999,0.0223280694,0.0295102103,0.032870305,0.0312801585,0.0243463279,0.012558896399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0241215421,0.0465429413,0.0636135347,0.0722387419,0.07041292860000001,0.057616857599999995,0.0350073857,0.00535560681,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0285857996,0.0695789554,0.102672529,0.12231399,0.12464435300000001,0.108192552,0.0742491193,0.026843340299999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.023905237599999997,0.09480485529999999,0.156158872,0.19803842600000002,0.212759781,0.196182288,0.14856776300000002,0.07484721,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,6.18922266e-17,0.13359670199999998,0.259644914,0.358413217,0.41222328700000005,0.40815308299999997,0.340319781,0.21140781,0.0331873504,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.291370901,0.791986948,1.33626577,1.88158462,2.3828077000000003,2.79691645,3.08754912,3.22893128,3.20874104,3.02957061,2.70880469,2.27691813,1.77437701,1.24748817,0.743661573,0.306614057,0.0,0.0,0.0,0.0,0.0,0.21279930600000002,0.541262834,0.887305569,1.21337401,1.48650763,1.68150228,1.78303052,1.78653625,1.69787394,1.53181189,1.30964705,1.05626959,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.409323858,0.42406505200000005,0.414493956,0.376557695,0.311473376,0.22596454800000002,0.131224803,0.040790763199999996,0.0,0.0,0.0,0.0,0.0,0.00838092559,0.0513217253,0.0786007385,0.0836404869,0.0668607663,0.0361171637,0.005383863149999999,0.0,0.012054054299999999,0.0776303097,0.19197361300000002,0.348248825,0.529527074,0.711107553,0.864712842,0.9638161690000001,0.98907351,0.9327471970000001,0.801148085,0.614471957,0.403900249,0.206380683,0.057990882,0.0,0.00877153843,0.121226272,0.30570451600000004,0.529348316,0.75101851,0.928935629,1.02877397,1.03068573,0.933884562,0.757836706,0.539718039,0.32848479399999997,0.17654371600000002,0.130472573,0.22244392600000001,0.46390296200000003,0.842660947,1.32396064,1.8553613000000002,2.3746106,2.81914468,3.13558233,3.28760291,3.26091139,3.06453565,2.72836542,2.29750379,1.8245393,1.36116212,0.950592887,0.6220664379999999,0.38817029399999997,0.245270557,0.176678935,0.157734695,0.161681062,0.165153933,0.152271134,0.116666522,0.0612742883,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0375768217,0.0861170001,0.11369688800000001,0.114400705,0.088533025,0.042389539000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0533811418,0.1162181,0.16914225600000002,0.20742096399999999,0.230719103,0.242767232,0.250001798,0.259532284,0.276950382,0.304533954,0.340304971,0.378197299,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.22989799800000002,0.0,0.586256806,2.90241143,2.85658719,1.61781914,0.0,0.0,0.39579479799999995,0.0,0.0,0.636512359,0.354294029,0.0,0.0,0.48892373100000003,0.294378777,0.823594044,0.0,0.154839705,0.965895169,0.5135395779999999,0.133212509,1.01595336,0.41433435799999996,0.0,1.21211447,2.12371348,0.8329379020000001,2.26444679,4.90296465,3.74541428,3.90376519,5.84742738,3.36713588,0.61570713,0.7848401490000001,1.92299375,0.698072776,0.640997846,1.39676998,0.81832716,1.6077703,1.41288298,0.0,0.225980094,1.11654489,0.0,0.0,1.32518326,2.23658592,1.79808545,0.37962388700000005,0.419850675,2.51474178,3.28513219,1.08350666,0.0,1.51136544,1.64966176,1.15927514,0.43815079100000004,0.172810779,0.0,1.67109607,2.43552831,1.37967314,0.0,0.0,0.341499678,0.0624426973,0.30081379999999996,0.117453025,0.593532289,0.13216302300000002,0.0,0.619914428,0.5145069,0.431859072,0.0,0.458041827,0.0,0.0,0.18290196600000003,0.0,0.132418794,0.527183717,0.0,0.20729264,0.0,0.0,0.26372538100000004,0.194679755,0.0,0.0527702497,0.44825987100000003,0.7832688179999999,0.628501628,0.314957237,1.53321769,1.03630293,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.442
11.88141877,13.70000406,0.0,6.64364096,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.452
0.20124171,0.32983068,0.23692157,0.09750049,0.16725996,0.0,0.18045613,0.02101177,0.03791216,0.0,0.0,0.21641318,0.25200845,0.0,0.0,0.0,0.01930265,0.0,0.0,0.23421002,0.0,0.0,0.11059246,0.0,0.02347062,0.12580523,0.0,0.23308344,0.34031459999999997,0.0,0.33396874,0.16289516,0.0,0.0,0.0,0.11392603,0.07430976,0.0,0.18568124,0.04928932,0.0,0.0,0.0,0.0,0.0,0.05710066,0.1846639,0.0,0.07571266,0.0,0.0,0.0,0.0,0.08865636,0.0,0.3410942,0.23498119,0.72810429,0.5044008,1.17892012,1.13738053,1.69787653,1.96442763,2.26117431,2.53352563,2.6789104999999998,3.32785217,3.05070486,3.40892646,2.97933068,2.71564702,2.70100643,2.25382455,1.82273106,1.8096174999999999,1.1438698,0.92776469,0.59478502,0.20112533,0.29198988,0.0,0.0,0.0,0.0,0.10443008,0.14756099,0.0453114,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
5.20374003,5.0619477999999996,4.83896067,4.54174421,4.17959521,3.76377646,3.30707623,2.82331169,2.32679794,1.83180569,1.35203065,0.900097232,0.487117116,0.12232050400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.138522405,0.260319119,0.359516684,0.432820327,0.478545499,0.49657680600000004,0.48825315399999997,0.45618837100000004,0.40403939,0.33623628899999997,0.257689817,0.173492581,0.08862972,0.00771379138,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00548182736,0.0287035718,0.044340618899999996,0.052117071699999996,0.0524299429,0.0462932687,0.035242297799999996,0.0212047935,0.006348387760000001,0.0,0.0,0.0,0.0,0.0,0.0104309683,0.037287884900000005,0.071350719,0.111173744,0.15482037099999998,0.199985277,0.24414379100000003,0.284719259,0.31925785100000004,0.34559969100000004,0.362035231,0.367436545,0.361354545,0.344075068,0.316629145,0.280755458,0.23881586100000002,0.19366772100000001,0.148499539,0.10663872699999999,0.0713423364,0.0455829131,0.031842311,0.0319262841,0.0468118875,0.0765382342,0.12014902699999999,0.175692615,0.240282241,0.310215857,0.381151443,0.44833057200000004,0.506839912,0.551897918,0.579152027,0.5849705479999999,0.566713048,0.522963594,0.453712506,0.36047446299999997,0.24633363600000002,0.11590994800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0392905952,0.34897595,0.7115212790000001,1.11977957,1.5644855,2.03453763,2.51736676,2.9993762999999998,3.46643667,3.90441326,4.29970545,4.6397737,4.91363156,5.11228131,5.22907385,5.25997696,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.449
0.350327667,2.498382,0.0,0.0,0.489631844,0.0,0.40508565799999996,0.024477611,0.0,0.0,0.526345317,0.0,0.0,1.03052418,0.32271654,0.255774672,0.0,0.0272982597,0.745601583,3.91672333,2.1987243,1.25181975,2.35103222,1.14590322,0.0,0.69042868,0.82329847,0.0,0.0,0.047718414400000006,0.992083926,0.0,0.0,0.0,0.0,0.892960836,0.0,0.881848915,1.72925888,0.483957697,0.707176639,0.25162905,0.0,0.0,0.583619123,0.0,0.000855295453,0.0,0.998873285,3.35100338,3.00560328,5.86286487,6.66611648,7.37064197,5.84842741,2.46497861,4.62709124,0.869926144,0.38182225399999997,0.0,0.286103512,0.0,0.0,0.731570827,0.0,0.0,0.0,0.0,0.0,0.690476427,1.24877689,2.71850148,0.0,1.62058324,0.885974983,0.0383682242,0.0,0.0,0.0,0.571941975,0.493684034,1.2918611999999998,0.435714947,0.0,0.0,0.961968892,0.7489489429999999,0.0,0.34213812600000004,0.0,0.0,0.0,0.302526787,0.0,0.0,0.0,0.0,1.35762376,1.61787349,0.0,0.0,0.0,1.77161808,0.0,0.816057955,0.0,1.37022429,1.42728194,0.75852743,1.03032422,3.64503734,1.29370752,0.7979257259999999,1.1087053999999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.9340139940000001,1.98610028,0.35085070100000004,0.318787127,0.0,0.0,0.6055671810000001,0.0,1.78527602,1.07819492,2.1761689,0.299068956,1.73729894,0.0,0.523992069,0.0315424697,0.17857825300000002,0.06009856,0.0,1.39999264,2.55862315,0.26850755,0.0,0.8916533170000001,0.0,0.318030363,0.863330136,1.59746225,2.21825933,0.9367377240000001,2.88280942,0.270052408,0.0,0.870376629,1.24156238,0.383744135,0.6641013929999999,0.0,0.0,0.31010305899999996,0.523053007,0.43148609200000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.461
1.69198141,3.52342239,0.0,1.0339575,0.39237544,0.0,1.70824759,0.0,1.69427504,0.0,0.0,0.816904195,0.0,1.87732101,0.285044323,0.0,1.69831952,0.0,0.0,0.420920769,0.0,0.0,0.0,0.0,0.0282454638,0.6986921309999999,0.0,0.0,0.35466129999999996,0.0,0.0,0.932405961,0.9176350329999999,1.1701268,0.0,0.0,1.03073428,0.6950022220000001,0.230652215,0.0,0.0,0.435659788,0.0,0.0,2.70952653,3.79231993,5.00082176,3.1408737999999996,0.274793207,0.0,0.0,1.64027368,0.0,0.0,1.43775927,0.0,0.0,0.24399535600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.890010613,0.978046966,0.731728734,0.219105644,0.0,0.909457978,0.0828098289,0.9712751709999999,0.0,0.0,0.0,0.821323853,0.120701396,0.0,0.0,0.0,0.0,1.80175904,3.43557306,2.29411834,0.193742145,0.0,1.22414342,0.7883579820000001,2.62717737,0.513025585,0.8080775490000001,0.234543633,0.521767829,2.83562715,1.44367284,0.0,1.53089478,1.12437003,0.0,1.04446663,0.49945108299999996,0.173582598,0.432731215,0.0,1.95407715,0.0321645225,2.68995346,0.0,1.15595092,0.7638734979999999,1.50345184,0.727805842,1.36241618,0.0,0.725252659,0.847821968,0.0,1.31994164,0.0731196839,0.83140062,1.33254132,0.0,0.0,0.0,1.08634129,0.0120719404,0.0,2.20148045,0.8032727159999999,0.0,0.731765951,0.0,0.82837145,1.19469116,0.767204172,0.0,0.0,0.0,0.0,0.0,0.0,1.64806131,0.0,0.58566487,0.0,0.0,0.0,0.788801566,1.26514547,0.0,0.474784363,0.0,1.02208654,0.0,0.566658718,0.0,0.0,0.0,0.8019600659999999,0.8114303909999999,2.42251013,1.10881239,0.220052849,2.25262124,0.0,0.8195602559999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.579041033,0.525542792,0.20112663600000003,0.490125749,0.0,0.0,0.496261034,0.372681334,0.51692124,0.11876817699999999,0.127816815,0.134118743,0.5926971639999999,0.39072130899999996,0.456389996,0.563587911,0.628283928,0.656818193,0.014196720800000001,0.0477220434,0.288722573,0.170911875,0.265059327,0.410462975,0.116683679,0.5669923000000001,0.277806135,0.55247964,0.76502365,0.9149950040000001,0.396241611,0.9050879079999999,0.9110211009999999,0.86399822,1.30152347,0.9678899609999999,1.20640273,1.27057896,1.04292887,1.09477281,0.815145544,0.904972793,0.76076963,1.22588248,1.06879666,0.6601168510000001,0.8608775559999999,0.6211181570000001,0.900744248,0.7757609540000001,0.915065693,1.24545548,1.33474147,1.33091159,0.7681839659999999,1.16481082,0.937193086,0.7575237859999999,0.8947228629999999,1.0198105,0.627226425,0.713479367,0.349839579,0.155756554,0.404661,0.368305706,0.48946072,0.301317641,0.40050166200000004,0.257652431,0.18776107399999997,0.30652291800000003,0.0130945901,0.646538495,0.309566911,0.0661926806,0.201215951,0.496778056,0.382816969,0.120392145,0.0669306772,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20176301,0.0,0.0,0.0,0.0,0.532486519,0.0,0.538185031,0.282086903,0.0766295372,0.0,0.29254693,0.239619864,0.0,0.12280649099999999,0.134606855,0.0,0.099782767,0.0,0.120764963,0.052121006799999994,0.142668872,0.08704352480000001,0.474047699,0.49470835700000004,0.09536583550000001,0.0675555592,0.572100119,0.261540663,0.40575874700000003,0.448973997,0.0,0.143291217,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.16284719,0.0,0.20726564600000003,0.34003361200000004,0.737649698,0.7021506559999999,0.0962311382,0.59045063,0.22444752399999998,0.0213797195,0.349028169,0.249683932,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.41544314299999996,0.7116883959999999,1.0668832000000001,0.988888463,0.934178755,0.744437081,1.00012942,0.71882939,0.713302351,0.740663393,0.5163568239999999,0.146092326,0.278977608,0.0,0.238243028,0.0,0.0,0.0017480995,0.0,0.042751679800000005,0.503555238,0.638473063,1.32445621,1.20937211,1.78087282,2.50184793,3.12737835,3.0587422,3.27007946,3.53047761,3.44680533,3.49603198,3.19681168,3.27030696,3.05191431,2.52885212,2.03701138,1.64590296,1.32795466,1.32784448,1.09190748,0.49524540000000006,0.6425747279999999,0.497963925,0.0,0.38466987399999997,0.0,0.428055077,0.0518240445,0.0,0.40429329,0.742028932,0.341587133,0.717974743,0.600513462,0.283154814,0.643352064,0.605880552,0.35003333600000003,0.417395175,0.0,0.0,0.10520471,0.0,0.0,0.0,0.0,0.09677216429999999,0.0,0.0,0.0,0.397035454,0.41923165700000004,0.488061255,0.045759572699999994,0.13387544699999998,0.5425071779999999,0.280020303,0.127297983,0.541537402,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.503308395,0.00034393318700000005,0.0,1.08511053,0.8207476909999999,0.0,0.219219466,0.238046553,0.15966986,0.0,0.640982941,0.110875129,0.000919751618,0.408604174,0.6051792220000001,0.359209899,0.204190365,0.494174519,0.182468515,0.433039691,1.06738652,0.7005812,0.32058758600000004,0.0,0.48502322700000006,0.805617921,0.7907940309999999,0.421547289,0.0,0.0,0.622128964,1.08852498,0.5988070670000001,0.0,0.16342525900000002,0.935760185,1.22173817,0.325819627,0.0,0.310820334,0.59010564,0.5970494120000001,0.7740152490000001,0.6225723329999999,0.639625556,0.752314215,0.979662568,0.404026719,0.0,1.8619013999999998,2.58748603,0.0,1.89086926,0.9431863079999999,1.95840887,1.89700907,2.10088881,2.13405344,2.90345983,2.40156197,1.52738555,3.14185464,2.97664762,2.89085536,2.31850562,3.04453052,1.58761553,2.90406231,2.85376416,2.51335505,1.93227342,1.66489038,1.62910131,2.3265901,0.714895321,0.696000057,1.6685608,1.2654357,0.309601442,0.7625835040000001,0.412388862,0.0,0.126748083,0.0,0.36388549600000003,0.0,0.249395919,0.0,0.0,0.113488962,0.0,0.122718782,0.0,0.0,0.0,0.0,0.395527786,0.6341786970000001,0.0,1.07386139,1.65461745,0.050110412800000004,0.0,0.7668086999999999,0.0,0.0,0.6805958590000001,0.319093619,0.421391935,0.7981012829999999,0.386556346,0.895134196,0.0,0.052436204699999996,0.817310795,0.0,1.21479844,0.00618987478,0.0,0.0,0.0,0.0,0.423147604,0.44947586799999995,0.16782529699999998,0.519150564,0.0,0.483898824,0.6611133570000001,0.0,0.634204083,0.0445187895,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.408342084,0.0,0.760603727,0.28384696600000003,0.0,0.10157562099999999,0.0,0.0,1.04834914,0.0,0.270284874,1.27209334,0.0,0.101819991,0.0,0.44620521799999996,0.0,0.0,0.7415853729999999,0.292862207,1.21608116,0.0324001804,0.8683851229999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.424
0.545962084,0.118846609,0.0,0.0,1.0347473,0.0,0.0,0.0,0.0,0.9016273840000001,0.0746875437,0.721542296,0.0,0.0,1.35967757,0.0,0.781671404,2.43925684,2.37438374,0.0,0.0,0.0,0.0,0.0,0.13901576400000001,0.0,1.30430677,0.7996625829999999,0.09153181980000001,0.0,0.454177591,0.258756208,0.193726404,0.0,1.01454462,0.0,0.0,0.0,0.0,1.13253117,0.0,0.00299139468,0.875824541,1.82331724,2.87520298,1.37852298,0.955881245,1.44676343,0.0,0.0,0.0,0.782942658,0.0786137682,0.572295088,0.0,0.976819779,0.9059280190000001,0.0,0.588981805,0.236662188,0.0,0.94158531,1.47021083,0.0,0.0115122149,0.203143889,0.0,0.0,1.46776755,0.730738985,0.14248836199999998,0.16177733,0.0,1.05916787,0.26612591399999996,0.0336547945,0.0,0.416118345,1.0261306000000001,2.3196847000000003,2.23183105,4.11915343,2.54094555,2.72509347,1.70238968,1.40649251,0.822172228,1.54028978,1.8647387999999998,0.0,0.784583292,0.8800425209999999,2.58493714,3.39108,4.59427299,2.91252821,3.5592269999999995,2.84423163,2.19207799,0.6725059259999999,0.040554289300000004,0.883434042,0.0,0.676527325,0.0,1.37190516,0.0,0.12149902,0.330223708,0.0,0.843460475,0.00254062,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.573040256,0.0,0.22008828800000002,0.36105968299999996,2.0775229,0.0,0.9055990159999999,1.38595274,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
6.14002434,5.67930029,5.1283804,4.51198717,3.85726926,3.19216137,2.54372449,1.936582,1.39155855,0.924612289,0.546127489,0.26060727300000003,0.06677514799999999,0.0,0.0,0.0,0.0167373824,0.110850688,0.214087864,0.31140223100000003,0.39042643200000005,0.442168634,0.461396975,0.44669958299999996,0.400233888,0.327203276,0.23511940399999998,0.132923269,0.030046261600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.017419264,0.0798121254,0.130792855,0.165651105,0.181480222,0.17738624100000003,0.154500345,0.115799931,0.0657606813,0.00987671701,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0217144239,0.0752826147,0.1216222,0.155732776,0.173743211,0.17330062699999998,0.153824244,0.116601643,0.0647189323,0.00283073752,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0589533759,0.183466403,0.317227489,0.452530665,0.5813815379999999,0.696070376,0.789721364,0.8567761759999999,0.893375872,0.8976136090000001,0.869641242,0.811624439,0.727552768,0.6229221460000001,0.504316443,0.37892207299999997,0.25401363,0.136449854,0.032217282400000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.009657547640000002,0.0503031785,0.08229044740000001,0.10319471699999999,0.111797801,0.108114155,0.0933131157,0.0695474428,0.0397057242,0.0071119910400000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.010037983,0.0376043366,0.0610304882,0.0778638684,0.0863188503,0.0854551808,0.0752768272,0.0567413325,0.0316777202,0.0026192321300000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0176456837,0.0542375337,0.08714415560000001,0.112545245,0.127133332,0.128476752,0.115322867,0.08781078169999999,0.047569432300000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0696499449,0.19980576,0.343798214,0.493790854,0.641049183,0.776564475,0.8917234390000001,0.9789699940000001,1.03240422,1.04826704,1.02526708,0.9647184540000001,0.8704729859999999,0.748647697,0.607165793,0.455145876,0.30218816800000003,0.157616771,0.0297424087,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0126433731,0.0465833367,0.06761455429999999,0.0765465588,0.077303816,0.0768598679,0.0848759156,0.113058529,0.174275808,0.281493541,0.44661082,0.679286484,0.985852574,1.36840801,1.82417507,2.34518349,2.91832348,3.52578158,4.14584349,4.75401964,5.32442238,5.83130316,6.25064296,6.56168312,6.74828575,6.80002336,6.71291636,6.4897615,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
0.40994976200000005,0.0,0.0,0.0,0.0,0.11947937,0.20962820100000001,0.0,0.34951772,0.0,0.0,0.0,0.103930244,0.0,0.27090764100000003,0.22574752399999998,0.0,0.358566034,0.0,0.0,0.302942404,0.0948658091,0.0,0.0522240966,0.0,0.0,0.177419153,0.0,0.0509179446,0.273753339,0.216198489,0.0,0.0,0.0,0.0507345415,0.0892697975,0.0,0.11644855400000001,0.049380342,0.0,0.0,0.419967862,0.688053316,0.461943858,0.35559570100000004,0.0,0.027574696800000003,0.0,0.0,0.0,0.0,0.43245399799999995,0.329113357,0.0,0.0,0.733958468,0.679332959,0.427849111,0.19216053100000002,0.427401116,0.587366614,0.017879035300000002,0.0,0.89107092,2.27100757,2.96921717,1.87874996,0.893751923,1.05195091,1.43654921,0.7836283159999999,0.45579834700000005,0.565474872,1.59780754,2.08487243,1.46816933,1.01540974,1.16274131,2.24750884,2.19146986,0.967680935,0.6845897940000001,0.130189376,0.254428759,0.509310849,0.189176373,0.65873155,0.091357268,0.0,0.117226314,0.0,0.0,0.0,0.0418326693,0.306227911,0.36449912799999995,0.356235444,0.0,1.13642318,2.18217096,2.36561758,1.27127502,1.16954656,0.9582972409999999,1.039932,0.41018443,0.12146242900000001,1.48438022,2.54793035,2.9396117999999998,2.17695314,2.39205139,2.50591362,2.71323902,3.15278731,3.33189846,3.52167138,2.61487993,1.30322211,0.0,0.29658465300000003,0.980988737,1.8649958999999998,2.05071591,2.10627016,1.44632145,1.12461505,0.5522155129999999,0.329635096,0.040865381400000005,0.430965,0.14989133300000002,1.04421704,1.19066491,1.35770446,0.89732598,0.0877662601,0.0,0.0,0.141826375,0.0,0.0,0.11771095300000001,0.0,0.0,0.0,0.0,0.0963561645,0.141377208,0.180236118,0.387475091,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
1.08262589,1.51719397,0.916507941,0.39327847299999996,0.0,0.0752791035,0.0,0.11356153599999999,1.3543376,1.7905513,0.7905538329999999,0.379275129,0.944609281,2.03843603,4.00539724,3.39464683,1.88233646,2.13715028,1.39484864,0.981379984,0.48953035799999994,0.037005625,0.21312613600000002,0.0,0.23672211399999998,0.0,0.024424837400000003,0.128403239,0.0,0.193391593,0.0,0.173358233,0.00891205845,0.0,0.0937032266,0.0,0.224683642,0.0,0.176506749,0.0,0.0,0.214733929,0.0,1.67049484,0.0851172526,2.8203326,6.83299644,0.919226925,0.0,0.42850372299999995,0.276035853,2.45946205,0.958144925,0.050571192599999995,0.407908504,0.0,0.135620666,0.0,0.0542802834,0.09555897039999998,0.576017046,0.297274586,0.0,0.19789569899999998,0.0,0.061583976299999996,0.0116108828,0.0,0.10959170900000001,0.0,0.10422571800000001,0.0,0.0203585069,0.0269319771,0.0,0.082553905,0.0,0.0712348405,0.237626255,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
2.13375797,3.51601159,5.73235354,6.82912425,7.28677908,5.52936229,4.74422517,2.63274515,0.17146074,0.0,0.0,0.0,0.45930117,1.05476563,1.98000823,3.29450657,3.39706557,2.84057482,2.32213645,0.42249175,0.0,0.70078157,0.3082188,0.0,0.50771221,0.51857737,0.11758792,0.67655274,0.13219249,0.0,0.0,0.30757644,0.26452531,0.0218718,0.0,0.24975253,0.12216106,0.38526329,0.389934,0.66981173,0.18497806,0.27427118,0.0,0.0,0.32930246,0.22926523,0.15168505,0.0,0.93331599,0.19514947,0.79622195,0.15158944,0.0,0.0,0.0,0.0,0.38196266,1.03137597,0.15131,1.29912467,0.04963609,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.456
0.00318617919,0.5030024329999999,1.64833627,3.50523618,4.06486176,1.63579429,0.0,1.99207168,0.313161669,0.59967176,1.41455133,0.497969586,0.0,0.24140459,0.0754258052,0.146127117,0.0,0.298795095,0.0,0.233362608,1.10491631,2.7198729999999998,1.29089431,1.31749208,1.91021195,1.299554,0.37914681299999997,0.940623763,0.16576358900000002,0.0,0.447721684,0.528060208,0.792032211,0.163727817,0.0,0.511204026,0.60834404,1.60723351,2.3388921000000003,0.110960534,2.84868664,0.630193728,0.125286565,0.0,0.093525709,0.271505942,0.49127021600000004,0.0,0.0,0.0,0.490411389,0.027063110699999997,0.166838416,0.00020529248500000003,0.0905749919,0.332826515,0.27518319199999997,0.0,0.647997835,0.219691175,0.912504911,0.547769188,3.3776116000000003,2.71351038,0.0,0.557867249,0.0,1.5553811000000002,1.84009369,0.615318474,0.0,0.317621343,0.631636022,0.17505131100000001,0.29647140000000005,0.186905083,0.0,0.345891505,0.0,0.224718355,0.0,0.0,0.33955701299999996,0.126464582,0.0,0.0,0.258749138,0.842092999,0.0,0.333808531,0.145437182,0.0,0.0,0.7697165090000001,0.50127841,0.56136268,0.0,0.101486286,0.0,0.20600608899999998,0.296863808,0.0888586708,0.3256639,0.111745173,0.316312733,0.19566609,0.0,0.949202074,0.119075628,0.0,1.26028289,0.926081151,0.343515041,0.174192216,0.151910336,0.0,0.0,0.324010132,0.382657543,0.0,0.0609316851,2.18849239,0.424662702,0.0,0.971540458,0.956293658,0.0,0.0,0.0,0.00478939455,0.0,0.0,0.0,0.117600471,0.115722053,1.25808401,1.60070067,1.08907843,0.0891302542,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.415
0.599041711,0.43212689299999996,0.573013349,0.7710351209999999,0.39002672299999996,0.51537806,0.555064688,1.04683067,1.36831451,1.08036827,0.960910026,1.72745351,1.11050909,0.852585778,0.20599141899999998,0.7079588809999999,0.678820054,0.0,0.144200202,0.0483057578,0.195163938,0.189195222,0.0,0.0,0.026302004500000004,0.0,0.0,0.654765336,0.48874650399999997,0.0,0.0,0.0013046544,1.31826354,1.21590251,0.193472792,0.9121731809999999,3.16791926,5.45234484,3.47648861,1.68026077,0.0415651656,0.6144451360000001,0.205916265,0.0,0.0,0.430550924,0.8419088509999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.0836148069,0.198287778,0.0938775525,0.0,0.0,0.007532621800000001,0.114148165,0.057795680999999995,0.0,0.0,0.0119871056,0.0950246165,0.0437947196,0.0,0.0,0.016120728,0.08782396960000001,0.0360227325,0.0,0.0,0.0207986106,0.08662077480000001,0.0306179215,0.0,0.0,0.050231161100000005,0.12082061,0.055878477,0.0,0.0,0.0932744203,0.147572115,0.0322460548,0.0,0.0,0.12498054300000001,0.187369609,0.0668304983,0.220891788,1.29576147,3.35998817,5.5271059000000005,6.51480759,5.70731945,3.68726872,1.70208843,0.613002324,0.35682861899999996,0.333593895,0.153991408,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.451
1.8773799,0.14923236,0.35413994,0.85979292,16.0657099,0.0,1.16000253,4.08075142,3.20404035,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44799999999999995
0.109224331,1.1160736,0.0562830481,0.21368311899999998,0.40043271799999997,0.0,0.5776841460000001,0.775076691,0.6251557320000001,1.05676975,0.899537087,0.9846160270000001,1.19120561,0.460884716,1.20439383,1.05727426,0.848847824,2.18472284,1.31122571,2.4514527999999998,2.34144267,2.48447023,2.0591418000000004,1.19854307,1.07829522,1.37098329,0.765220699,0.921440658,0.806474047,0.755364968,0.0858259906,2.08969644,2.38165972,2.34169016,3.31931113,2.4325175,2.58598477,2.54687212,2.58093828,1.78507116,1.95480437,2.00195675,0.104857174,1.11311026,0.47483278700000003,0.242767075,0.305558149,1.96323957,1.13223579,0.714143285,0.34135142700000004,1.08263625,1.04712816,0.619304917,0.20938353199999998,0.223162672,0.0,0.0,0.30262506899999997,0.0,0.0,0.0,0.69208405,0.49937543799999995,0.268838299,0.901049457,1.09399134,0.95855546,1.10632137,0.00581475565,0.0,0.0,0.0,0.221477311,0.783399478,0.0,1.48623634,0.28654884399999997,0.468049967,0.52926497,0.18050192699999998,0.0,0.0744444643,0.0,0.37024547399999996,0.47270775,0.6897838820000001,0.0650847027,1.13087087,0.8099458509999999,0.59987306,0.215992459,0.084172865,1.12712973,0.052729790199999994,0.0,0.0,0.048222172300000005,0.688034965,0.455676518,0.435935798,0.0,0.417904951,0.0,0.275417495,0.0,0.40524189899999996,0.243962175,0.164071203,0.0,0.25065348600000004,0.0,0.789186728,0.368018825,0.17586536,1.06265321,1.03534584,0.0,0.0,0.443421215,0.0,0.0,0.0,0.0,0.938498288,0.0,0.0,0.811799862,0.0,0.37340271700000005,0.0,0.26740921100000004,0.624966389,2.02747439,1.13942994,2.04327385,0.38689533600000003,2.95526655,1.45438219,1.03010808,2.19431726,1.19765548,1.32706493,0.419302391,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.0874987042,0.636740294,0.50685129,0.523481475,0.739629237,0.8988754529999999,1.48217768,1.48570979,1.57143769,1.66919062,1.60864825,1.8947231,2.03527283,2.45023554,2.50472216,2.52952591,2.59693557,2.85196216,3.14693485,2.90353101,3.16401899,2.99673058,2.99510066,3.18637683,3.3672112999999997,3.29608589,3.07036341,3.32141902,3.16765444,2.92583911,3.12083768,3.15634676,2.89152774,3.02415953,2.51185782,2.42630744,2.30993551,2.35139384,1.81742372,1.74195389,1.84368719,1.34081948,1.17873374,1.31158111,1.36223392,0.9321622490000001,0.79359597,0.418984677,0.7490304320000001,0.44644143399999997,0.21784965399999998,0.0372390356,0.0,0.0548334388,0.145165728,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0834736779,0.0,0.0,0.0,0.0155789453,0.287816164,0.411193924,0.0,0.339358169,0.454376315,0.158248745,0.294642253,0.32730689,0.197966079,0.19167487600000002,0.35452075200000005,0.494105575,0.501864447,0.147122413,0.582943119,0.23607779899999998,0.297022425,0.471839013,0.504444729,0.294829388,0.29310549399999997,0.0,0.372667133,0.30392437699999997,0.0,0.0,0.0,0.0,0.0,0.0071381512,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0687786243,0.022210873199999998,0.21897900399999998,0.132833331,0.0,0.0,0.26161905,0.0,0.155293338,0.0,0.383833429,0.38137438700000004,0.0,0.17665726399999998,0.0762475766,0.18011163300000002,0.554493005,0.377078432,0.156937621,0.24938413899999998,0.177438147,0.0,0.5474525920000001,0.185373782,0.496277514,0.15748193300000002,0.11446000099999999,0.0028180094899999996,0.0720594819,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0688702259,0.0,0.254861605,0.0,0.287981372,0.0185991336,0.388804506,0.37666953299999995,0.519945566,0.10722267199999999,0.276303183,0.704033268,0.176176217,0.187968512,0.6874153679999999,0.174787893,0.38626021299999996,0.361411771,0.6936241559999999,0.50199366,0.389799766,0.479635689,0.42072520799999996,0.42809301,0.23061128600000003,0.0,0.42398702,0.141813534,0.0499744617,0.166005488,0.0,0.0,0.0108419225,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.019099838600000002,0.0341184087,0.0,0.24380020300000002,0.43168155700000005,0.40429814799999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.429
1.06925009,0.81318795,2.7877976,0.69622409,3.01248705,2.07936463,0.86273184,0.0,0.0,0.0,0.51347572,0.0,0.30230278,0.0,0.84353569,0.0,1.07239218,0.0,5.27957981,4.43021736,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
0.19174684,0.96465585,2.23166704,3.37080124,3.48689132,2.81438818,2.19402953,1.17491141,0.73530283,0.80478315,0.43018919,0.0,0.10872392,0.0,0.0,0.0,0.29924376,0.11781527,0.0,0.0,0.0,0.36316395,0.17741256,0.13178034,0.0,0.0,0.0,0.32926821,0.19994926,0.28201363,0.0,0.05994334,0.04601668,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.450940594,0.390464491,0.0,0.71756467,2.15277154,3.39787457,2.90516629,1.72099412,1.62910597,0.0,0.0,0.0,0.0,0.762629381,0.0,1.03036198,0.201415685,0.0,0.0,0.0,0.0,0.667429897,0.0,0.053036069500000005,0.5137827939999999,1.216779,1.71741157,0.6262435510000001,0.0168452974,0.0,1.3945476,0.08068912730000001,0.0,0.09368729560000001,0.0,1.16530958,0.472442365,2.03250297,1.90824604,0.275441176,0.49197926799999997,0.0,0.0,0.0,0.0,0.0,1.65224157,0.0,0.730869985,0.0,0.8019776559999999,1.7026091,0.0,0.0,0.0,1.03514285,0.397904621,0.397401601,1.132248,1.85380905,1.58846012,1.13950373,0.0912819536,0.043362094500000004,0.0,0.0,0.0,0.0,0.0,0.559004676,0.307221993,0.0,0.676815808,0.21628815199999998,0.0,0.598390246,1.76698995,0.0,1.04059864,0.0,0.050186318099999995,0.0,0.489103405,1.0572598,0.8698146000000001,0.0,0.424539693,0.0168770571,0.40330014,1.47627878,1.69682228,4.21049937,2.3134338,0.121168344,0.0,0.34352957700000003,0.0,0.45679153200000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.42191679600000004,2.1181686,2.92796739,2.96229625,3.61449416,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
2.96214581,0.0,0.0,0.0,0.15790739,2.905878,0.0,0.0,0.0,0.90044402,0.0,0.09419111,0.0,0.0,0.0,0.0,0.65664204,0.0,2.75135922,2.56614672,4.75726392,6.61446648,5.1954712999999995,2.21558982,0.0,0.53713075,0.87105818,0.25420173,0.0,0.82981557,0.0,2.27485174,2.28631949,0.83493977,0.0,2.28085175,0.84212531,2.64550538,0.0,0.0,1.07765591,1.14089463,0.0,0.61756211,0.0,0.0,0.0,0.31896176,0.6978241999999999,0.59357171,0.24999509,3.00991189,0.15659456,0.13485357,0.0,0.0,0.92966083,0.0,1.34507063,0.0,0.0,0.0,0.0,1.0545608999999998,2.38282986,0.0,2.32753144,0.18281224,0.33289123,0.6369706999999999,0.43322605,0.0,0.0,0.0,3.9121174,2.47603242,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
1.76397828,0.0,0.24446315100000002,0.0,1.32213207,2.14544624,1.07112995,0.0,3.38622129,2.947478,0.410309902,0.8674505570000001,0.0,0.624990288,0.143705386,0.0,1.00607842,1.22506294,0.0,0.6000540529999999,0.0,0.401990721,0.577811716,1.09572035,0.0,0.0,0.570151145,0.0,0.685529687,0.16797366600000002,0.0,0.0,0.046267080499999995,0.09309466890000001,0.0,0.46492531299999995,1.13362787,0.0,0.568905973,0.0,0.207444412,0.00322743464,0.466325434,0.206704516,0.0,3.38745269,1.3460875,0.0,0.0,0.644350027,1.05709896,0.0,0.625802681,0.0,0.0,0.37579724700000006,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.41600000000000004
0.511213913,0.8453995390000001,0.13403539,0.11094226800000001,0.71367788,0.0241219912,0.665737088,0.326838538,0.25856864,0.36039645600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00463563053,0.0246519344,0.0,0.109220728,0.148577574,0.8160302559999999,0.660373726,1.19686664,1.63787088,1.58117485,1.97446708,2.03037398,1.55566371,1.6752985,1.54018516,1.59852163,1.3263766000000001,0.622623324,0.68759253,0.13378256300000002,0.245787366,0.0,0.026723317599999998,0.0,0.0,0.0,0.114109813,0.029793523,0.0,0.0035263001200000004,0.0,0.187857761,0.0,0.0,0.0,0.498712447,0.310037806,0.0,0.07614982990000001,0.218709247,0.384423539,0.0955404075,0.0,0.0,0.0,0.17529342399999998,0.0,0.0,0.184718386,0.059783112199999995,0.0,0.0,0.32411547,0.130276824,0.269755519,0.0,0.0,0.0,0.0,0.0,0.0,0.321702394,0.20670332600000002,0.0,0.315219347,0.0,0.30471435399999997,0.38809309999999997,0.228749053,0.0,0.206068114,0.231703942,0.0,0.30847314,0.143765692,0.0,0.0,0.0,0.46135847,0.496710505,0.280361166,0.33703899600000004,0.0,0.16840600600000002,0.203278915,0.419510603,0.43570092200000005,0.0267092641,0.0,0.0,0.0,0.0,0.15656161400000002,0.0,0.0,0.276712043,0.0,0.36276613799999996,0.060515760300000006,0.630713164,0.259348932,0.211563155,0.704044291,0.0,0.0,0.111053316,0.0,0.0986366376,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0469864669,1.23462553,1.47596147,1.85020216,2.15589666,2.6384531000000004,3.18604401,3.69582689,3.59407354,4.18837327,3.78821699,3.91912278,3.3605236000000005,2.62705605,2.11626731,2.01064255,0.970818245,0.520953853,0.379755688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.408799526,0.42157083100000003,0.902170528,0.679214845,0.657964985,1.30155609,1.39353531,0.947479673,1.27550677,0.46821776200000004,0.752452042,0.77133059,0.428889732,0.21019374300000002,0.0,0.0343080791,0.0114273816,0.00824328405,1.00990188,0.806437665,1.40214095,1.56889621,2.03624807,2.18605065,2.17400055,2.48203026,2.61383891,2.6104976000000004,2.40204225,1.95360508,1.70758185,1.68428847,1.7502783,1.39449967,0.9718683140000001,1.02488577,0.797100085,0.414750606,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.436
2.00917456,0.65100392,0.98823015,0.81129849,2.25698416,0.11727705,0.7636232,0.26939452,1.69987266,2.58805829,2.64428169,0.83028792,1.97863833,2.61756153,2.856922,1.63253137,2.83768002,3.30056935,2.87510075,3.44818094,2.5202431,3.63598175,1.58720248,2.02465649,2.52889854,3.2576869,1.2006401000000002,2.85898652,1.69226743,2.24259891,0.21166571,0.13987847,0.14329364,1.11694964,0.0,0.0,0.81058247,0.53921767,0.0,0.21865901,0.0,0.0,0.0,0.0,0.0,1.62426131,0.0,1.43825968,0.0,0.0,0.0,1.1419608,0.0,0.0,0.60099429,0.92023499,0.0,0.01868998,0.73461056,0.0,0.15698311,0.0,0.0,0.70345372,0.25819754,0.17373143,1.25129953,1.93149466,0.55128543,0.0,0.0,0.69915371,0.43911036,0.0,0.97683328,0.0,0.60672055,0.55296149,0.0,0.0,0.0,0.40106683,0.27318113,0.0,0.0,0.28951552,0.0,1.17751661,1.0620789,0.0813834,1.18219621,0.13145035,0.51126279,0.05142859999999999,0.02428982,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.0280842999,0.032322952599999996,0.056676958,0.111149209,0.206314511,0.35027300299999997,0.545164105,0.7843288009999999,1.05120657,1.32067419,1.56287298,1.74882245,1.85651271,1.8759039,1.81143742,1.68125406,1.51316321,1.33828287,1.18392203,1.06751642,0.9931781690000001,0.9517393670000001,0.9242424109999999,0.887907905,0.822949342,0.718386317,0.575296343,0.406660824,0.233905188,0.0811437446,0.0,0.0,0.0,0.0,0.0,0.0322053628,0.0656985342,0.0722878525,0.0526689725,0.016185999,0.0,0.0,0.0,0.0,0.0,0.0176582872,0.0414976626,0.0479995975,0.0360012787,0.012352286100000002,0.0,0.0,0.0,0.042740538700000004,0.10409546900000001,0.166337811,0.20913393600000002,0.21546389,0.178056921,0.103354785,0.011446214,0.0,0.0,0.0,0.0224216531,0.182701704,0.37333784700000006,0.554209269,0.6856347070000001,0.740035872,0.711125557,0.617839667,0.501578223,0.41712657,0.419387257,0.549263166,0.822343224,1.22335924,1.70789466,2.21094912,2.66021688,2.99079596,3.15780052,3.14403388,2.96126554,2.64533206,2.24677645,1.81966588,1.41137792,1.05555085,0.769292975,0.554497707,0.40208514799999995,0.297450075,0.225433578,0.173657975,0.133840669,0.10144836300000001,0.0745269011,0.0526199196,0.0363953136,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
8.45016879,5.825906,0.0,0.0,0.29990605,0.07122854,0.0,0.15652035,0.0,0.0,2.11031359,0.89251836,1.59756673,1.67098758,0.0,0.0,0.36943293,0.0,0.0,0.0,0.0,3.39623162,0.0,2.39290836,0.0,1.07506687,0.0,2.17252757,0.0,1.71025453,0.29391585,0.0,0.60091868,0.92299322,0.93399221,0.21320739,2.68546587,0.0,0.0,0.81141774,0.0,0.0,2.98640939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
3.71920482,3.48834691,3.59861076,3.23178312,2.98599729,3.09663456,3.17649824,2.7133334,3.10668761,2.513184,2.72789994,2.47442044,2.24745834,1.80465186,1.94554997,1.63250347,1.36001991,1.49569957,1.39809268,1.08593132,0.451119509,0.44963249899999996,0.5471935179999999,0.535320798,0.18050823800000002,0.29352408,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.284097098,0.39711944600000004,0.0,0.0,0.34159426200000004,0.00967238425,0.116356733,0.386975196,0.68823314,0.44072539899999996,0.41139331799999995,0.263859159,0.168167485,0.7841537540000001,0.166579562,0.13359990800000002,0.7203970909999999,0.720801782,0.664198334,0.0743928893,0.43120082600000004,0.0897339006,0.0,0.175536252,0.0,0.00517608354,0.297338043,0.0,0.0917597942,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0925340868,0.0854815318,0.0,0.24981403800000002,0.17957495699999998,0.185261079,0.0,0.0,0.0,0.13462668,0.143653234,0.537244681,0.138833934,0.615929541,0.142889346,0.377428508,0.477276683,0.597257246,0.172872787,0.0298484696,0.507319069,0.23446309,0.534821256,0.599344604,0.12193807699999999,0.474035534,0.0,0.0,0.429600766,0.0,0.0,0.158238199,0.243778014,0.0750207303,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0318473868,0.0,0.0,0.0,0.23055366,0.0,0.135799651,0.0860601241,0.007005652509999999,0.38754985399999997,0.575567705,0.061229459800000004,0.605013102,0.693985376,0.337135874,0.224369708,0.732311967,0.60377073,0.128744851,0.339823903,0.653416372,0.587713347,0.759176125,0.483328905,0.689887625,0.662504228,0.217593996,0.267807662,0.515087758,0.245813917,0.29553694399999997,0.24730664300000002,0.132281314,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.103274161,0.0,0.322469726,0.004233392020000001,0.0104485541,0.386760631,0.6661580029999999,0.675775149,0.65891681,1.14373582,1.08723575,1.13368896,1.68766874,1.69596554,2.12662207,2.13750188,2.51134998,2.38139765,2.38035206,2.8509001,2.54956354,2.71835073,2.95545101,3.28512325,2.98947262,3.24321377,3.57777484,3.24773835,3.70910398,3.40358739,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.84942911,0.59187742,0.60500127,1.07156674,0.0,0.0,0.13455825,0.0,0.17468881,0.0,0.0,0.0,1.45901334,0.0,0.0,0.6615112,0.0,0.50982254,0.0,0.26708574,0.19509674,0.0326215,0.0,0.0,0.0,0.0,2.66616238,2.33395098,3.30165144,2.7392494,1.15018117,0.15052279999999998,0.04833435,1.94291492,2.80921203,1.45431077,2.76024814,1.91947911,0.49629035,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
2.45105905,2.35073017,1.35670188,0.268541125,0.0,0.42757548799999995,1.08749945,1.10744594,0.365861867,0.0,0.0,0.0,0.519338634,0.574829149,0.0,0.0,0.0,0.169283049,0.6900848759999999,0.44105457200000003,0.0,0.0,0.0,0.648538941,1.07577203,0.233395808,0.0,0.0,0.115741182,3.58939139,6.69946733,7.3829696,5.21137669,1.7046837,0.0,0.0,0.0,0.660801531,0.809380202,0.117620056,0.0,0.0,0.0363773149,0.44920874899999996,0.32687314100000003,0.0,0.0,0.0,0.169687268,0.317076948,0.10805908800000001,0.0,0.0,0.0,0.20854351399999999,0.20639887899999998,0.0,0.0,0.0,0.0668269496,0.20535266300000002,0.110302569,0.0,0.0,0.0,0.152976021,0.247264376,0.143277658,0.0,0.0,0.012247167199999999,0.10769071300000001,0.0822358604,0.0,0.0,0.0,0.0638808958,0.116158225,0.0367039399,0.0,0.0,0.0,0.0971894747,0.093880434,0.0,0.0,0.0,0.0397607658,0.110305857,0.0556694516,0.0,0.0,0.0,0.0822034428,0.104647882,0.007808211450000001,0.0,0.0,0.018887027,0.115476864,0.0824105808,0.0,0.0,0.0,0.0813989659,0.144840239,0.0421864254,0.0,0.0,0.0,0.18917216,0.194878788,0.0,0.0,0.0,0.543567261,1.6091501,2.49956566,2.76269793,2.38243439,1.81019556,1.62070376,2.04802127,2.77281345,3.15433673,2.75250954,1.73174251,0.79500395,0.653597639,1.43380435,2.52190891,3.02523356,2.5066324,1.37412557,0.557532059,0.7131036470000001,1.64117921,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45399999999999996
0.809883982,0.0,0.0,0.0,1.39651129,2.00328356,1.05752949,0.45874146200000004,1.05003095,0.789228461,0.0,0.0116089877,0.0,0.0,0.631612701,0.136350566,0.39741724100000003,0.0,0.0,1.01088309,0.9520418829999999,0.567129996,0.0,0.0,0.0,0.26084774899999996,0.0,0.0,0.0,0.0,0.0,0.0797414434,0.0,0.15539640400000002,0.0,0.00839639161,0.0,0.416313982,1.24330408,0.188527528,0.0467063615,0.37037095700000006,0.059876118799999996,1.0405765,0.8995901070000001,0.21043288699999999,0.46266350700000003,0.495755712,0.0,0.0,0.174221879,0.0,0.0,0.0,0.20635715899999998,0.0,1.196353,0.0,0.0,1.28187292,0.0,0.0,0.0,0.0,0.589867261,0.0,0.724192883,1.0371095,0.868683399,1.37125034,2.78763429,2.76483845,3.37533844,1.37548705,4.11866685,0.0,0.914076586,0.98635302,0.0362256819,0.0,0.0,0.0,0.0,0.0,0.0,1.04136017,0.219923549,0.0,0.489360394,0.0,0.7911594540000001,0.38804658299999994,0.0,0.0,0.0,0.0,0.0,0.0,0.6092281829999999,0.0,0.172297536,1.58480349,0.783824308,1.68027742,0.27165141800000003,0.0,0.350280949,0.9048312079999999,1.39239827,0.0,0.7681698370000001,0.0,0.0,0.794736601,0.0,0.0,0.014140971799999999,0.0,1.12530598,0.22446675600000002,0.211927122,1.20576089,0.23360848399999998,2.09840302,0.0,0.8933857540000001,1.56606381,0.7343164870000001,0.236880218,1.19916591,2.13249997,2.38928398,1.99628553,0.71290487,2.02309023,1.15001707,2.38918987,1.52196177,1.96487873,1.35805403,0.739723609,0.357108311,0.0,1.15646449,0.41888565,0.5426259529999999,0.40253093700000003,0.999481075,0.6118564120000001,1.95160925,1.43654894,1.29481091,2.2440702999999997,0.369294716,0.600380933,1.17641353,0.193950001,0.0,0.7570444940000001,2.50670641,0.858452025,0.407675568,0.493297459,1.14632276,0.0,0.173777865,0.139595403,0.0189126007,0.0,0.076674956,0.0,0.0,0.427432029,1.18345616,1.29428235,1.6965621,2.29331442,0.0,1.16460382,1.14794149,0.6776030820000001,0.42721793,1.17215398,1.1798136000000001,1.07600916,2.03576774,2.13222302,2.12337913,2.91188006,1.97452833,3.57671758,3.9438230000000005,3.03318721,3.64741537,3.72695417,1.58167694,3.04552388,1.17618429,2.98574188,1.94492494,0.265770109,1.89558325,1.48915414,0.185358821,0.613619925,0.0,0.0,0.0,0.134581205,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.566473759,0.169916674,0.0,0.113984155,0.0341996391,0.635531851,0.724659858,0.8212079259999999,1.724559,2.31331236,2.80595032,3.93463217,5.13865963,4.63737836,4.99763228,4.61249429,4.35301778,3.52578103,3.27087572,2.29451999,1.06667937,0.129659732,0.0,0.0,0.0,0.0,0.0,0.0,0.162316039,0.625697498,0.7009289459999999,0.862861612,0.326508992,0.938701041,0.542156664,0.600131659,0.0,0.0,0.190930414,0.0,0.127564296,0.285799346,0.23041295399999998,0.0,0.0,0.0,0.0,0.0,0.6224994970000001,0.43370274700000006,0.0,0.0,0.0,0.125238635,0.0,0.0,0.0,0.501856635,0.0931588003,0.37307675700000004,0.528358631,0.0,0.5133428870000001,0.0,0.0,0.276682085,0.0,0.0884328492,0.009590430390000002,0.054137179,0.0,0.0,0.299659274,0.0,0.000606645706,0.36865755299999997,0.0,0.0,0.007443426640000001,0.0,0.0,0.0,0.00431747886,0.0,0.0772668387,0.81325985,0.450173889,0.0,0.6779582129999999,0.40648790799999995,0.668409293,0.0,0.672649752,0.6805979809999999,0.11165142199999999,0.742898907,0.314387171,0.0,0.0,0.0260199128,0.267941579,0.121330274,0.0,0.0,0.0,0.0,0.0,0.0,0.5252776889999999,0.149332098,0.42984054200000005,0.21103818800000002,0.5040393879999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.256589723,0.604906806,0.85542748,1.16342813,1.83474712,2.01954961,1.58652339,1.30544983,1.33893589,1.01016579,1.25047735,0.597908338,1.09018512,0.366155689,0.238303674,0.8323458220000001,0.276421971,0.015089095700000001,0.719178118,0.290630762,0.793799714,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.445
0.125178329,0.179834485,0.0,0.0,0.126802865,0.022912210699999998,0.045291457800000004,0.502233125,0.641643646,0.220995711,0.107861439,0.54972586,0.737303673,0.369884634,0.011911745100000001,0.0,0.00341360843,0.0026747207899999997,0.00042887518100000004,0.000577019791,0.00102774672,0.00170430687,0.0,0.000223288175,0.0216853336,0.0,0.0,0.034608231600000004,0.0357309302,0.0,0.0,0.137156246,0.0600535491,0.0,0.403800805,0.7297669240000001,0.306174619,0.0594728412,1.00241288,1.91863864,1.20905041,0.0,0.0,0.19634754399999998,0.17522325600000002,0.0,0.0,0.17011073300000001,0.0,0.0,0.050577601500000006,0.0969125499,0.0,0.0,0.08466145929999999,0.0184852625,0.0,0.0116670063,0.0635926288,0.0,0.0,0.0414456511,0.0212414688,0.0,0.0,0.032442039900000004,0.0,0.0,0.0104579889,0.007259245,0.0,0.000552969084,0.0,0.00074206006,0.02539372,0.0,0.0,0.045364104,0.0445755427,0.0,0.0,0.175434442,0.0,0.0,0.459075109,1.72736603,1.69165109,0.325389347,0.0,0.0,0.266082177,0.0,0.0,0.103597383,0.09235682449999999,0.0,0.0,0.0966076582,0.0,0.0,0.0247139149,0.0364113502,0.0,0.0,0.0,0.0,0.05343669980000001,0.0,0.0,0.10545307,0.21150856199999998,0.0,0.0,1.88638612,3.89171417,2.58730007,0.0,0.0,0.8125933190000001,1.65161373,0.762486462,0.250375252,0.362079105,0.0,0.0,0.155059064,0.301381096,0.0,0.0,0.469917576,0.14999499800000002,0.0,0.560998989,2.80655245,3.03484461,1.04721329,0.0,0.0,0.239404069,0.00800256372,0.0,0.035823133300000004,0.0743125315,0.0,0.0,0.0375708462,0.00944081113,0.0,0.00149103208,0.00825557091,0.0023187365,0.0480410871,0.0814299697,0.025168839300000002,0.0,0.0,0.0351536567,0.0,0.0,0.0256276972,0.0370013278,0.0,0.0,0.0828923263,0.00295360917,0.0,0.0509863024,0.157573405,0.0,0.0,0.341453048,0.14228361,0.0,0.13004095599999999,3.05473701,4.02801528,1.44433963,0.0,0.8551769379999999,1.91680575,0.269462579,0.0,0.19409052899999998,0.71478626,0.0,0.0,0.5981102420000001,0.273933249,0.0,0.0,0.756575571,0.0,0.0,0.621675306,0.601677859,0.0,0.0,1.53207654,0.0,0.0,2.03664161,9.74276457,9.63104181,2.00530333,0.0,0.0,1.36069311,0.0,0.0,0.595576666,1.1089645000000001,0.159538265,0.0,0.324391384,0.149646118,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46299999999999997
0.9620128640000001,0.98675773,0.807179375,2.10974768,2.51609219,2.89328167,3.37855425,3.70383439,4.31747852,4.86025581,5.2785125,5.76619619,5.38690067,6.16766557,5.90360491,5.53177928,6.57862322,5.91844472,6.11026817,5.48176388,4.25996509,4.29403972,4.26893131,3.75262788,2.31171642,1.62664128,1.05545502,0.577763986,0.170305743,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.350597469,0.575678809,0.123131269,0.686553359,1.05346014,0.12718923,0.159578879,0.411275124,0.9217730129999999,0.227426054,0.752797258,0.172978222,0.629465626,0.501118644,0.0,0.469774265,0.0,0.09245871439999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.217644075,0.168810778,0.17214496699999998,0.0,0.0892649532,0.528077648,0.34620415600000004,0.0,0.7659657459999999,0.555111036,0.0,0.7572953920000001,0.44952682899999996,0.0,0.771007514,0.09270004820000001,0.0,0.532413805,0.0,0.26697971600000003,0.0,0.35307813899999996,0.450649391,0.39868855700000005,0.091825484,0.28298686300000003,0.0,0.0,0.00510959397,0.09801844130000001,0.0,0.0,0.0,0.0,0.0,0.0150066173,0.314131852,0.548569996,0.0,0.200664956,0.0,0.112030596,0.41576245700000003,0.0,0.22032835,0.35252149200000005,0.0867999741,0.0137549397,0.0,0.340784992,0.31846061600000003,0.0298414132,0.207033844,0.0,0.0,0.0,0.0,0.0,0.0,0.24054949,0.0,0.18307547,0.376149512,0.43595391,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.272513108,0.0,0.0,0.0,0.257550525,0.0,0.0874005043,0.0,0.33782831,0.128164528,0.0,0.0964198191,0.17189410600000002,0.23980174899999998,0.0378412065,0.45251965200000005,0.43177073200000005,0.6561504570000001,0.0,0.615538855,0.08473118240000001,0.0,0.70015939,0.0,0.447625955,0.0,0.393678569,0.0,0.0,0.16016359,0.0,0.012651423,0.0,0.0,0.0,0.0,0.0,0.20953269,0.0,0.470636015,0.145631727,0.5660532620000001,0.07566962440000001,0.726599463,0.400782731,0.385019634,0.38342930299999994,0.7590800320000001,1.47634992,1.58107432,0.9440698479999999,1.45124851,0.507890451,0.41937897399999996,0.508987978,0.34838751700000004,0.0560291948,0.6050263060000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.495495287,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45899999999999996
1.2715301,1.15500192,0.0,0.04791745,0.37120553,0.0,0.0276683,0.42341424,0.79987091,1.62515168,1.71445309,3.1617862,3.14044556,2.2759278,1.02218512,0.0,1.6535291,1.96061163,0.17913566,0.40521845,0.67654217,0.02090621,0.0,0.25127255,0.15810475,0.0,1.12477511,0.0682118,0.22476401,0.0,0.0,0.79001481,1.01650743,0.21032801,0.0875442,0.0,0.66497559,1.24731361,1.8631006999999997,1.97564898,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42100000000000004
1.2530456,1.57929153,0.0,0.601486073,0.732078937,0.414241165,1.74099437,1.61263746,0.24893080199999998,0.0,1.24964734,1.38064318,1.73061735,1.65214429,0.340193499,1.15481171,2.97219136,3.15974153,0.09746821130000001,0.051211676,0.146572491,0.750108131,0.00136324099,0.0,1.0347763,0.213260615,0.334883523,0.283712327,0.909370727,0.396562966,0.0,0.191318727,0.873362078,0.73866272,0.387178436,0.0,1.05104712,2.24633378,1.09169334,0.0,0.32464751399999997,0.0,0.0,0.0,0.0,1.02944602,0.0,0.14498231,0.661674071,0.0,0.778013968,1.50294562,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.418
0.363780676,0.2676535,0.0,0.313593332,0.0,0.568794256,0.547378732,0.0620260745,0.0,0.0,0.0,0.0,0.201188786,0.44492618,0.721428492,1.13578327,1.33546286,1.62577486,1.56111402,1.67658017,1.77616189,1.97350277,2.0235733,2.55839174,2.72792686,2.16320095,1.75244396,1.31273682,1.17308637,0.588140611,0.44924042700000005,0.536880669,0.284608572,0.0,0.133013178,0.0492282792,0.0,0.0,0.337555996,0.46658533700000004,1.49576775,1.93038623,2.70646272,2.87518915,2.43145556,1.89568177,1.21931442,0.15901016099999998,0.0,0.0,0.0,0.0,0.693316858,1.86430948,2.36989795,3.04192765,3.00833962,2.6152658,2.68693654,2.27021417,1.67333751,1.26897173,0.473373101,0.492266308,0.030295741600000002,0.0,0.07922614509999999,0.0,0.568446123,0.285219839,0.643237156,0.54728203,0.0632982874,0.054801688200000004,0.21488533199999998,0.0,0.104016982,0.0,0.41122719799999996,0.53045506,0.421820955,0.584906865,0.476311124,0.0,0.164128768,0.0,0.157526112,0.0058487185700000005,0.19092858899999998,0.17695204,0.21118076300000002,0.0,0.0956052547,0.0,0.0,0.0,0.00157364497,0.29651371600000004,0.0276773404,0.0,0.0,0.0,0.0,0.0,0.0,0.0441606571,0.36042399799999997,0.120959226,0.096659058,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0485427786,0.0,0.08619205710000001,0.17255524600000002,0.0778775361,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.150609393,0.0,0.0,0.364638095,0.297530671,0.8114348240000001,1.16328176,0.79556062,0.9655146459999999,0.89876046,0.549705955,0.396915443,0.16878235100000002,0.0,0.0,0.125563345,0.246508913,0.462144855,0.0,0.281846521,0.0,0.252573797,0.0,0.515867321,0.832732232,1.06503579,1.18036522,0.666727296,0.422399024,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.6042812710000001,0.329604407,0.476112469,0.211361637,0.0,0.0,0.0,0.0,0.0,0.23976459100000003,0.275356903,0.0,0.0114193849,0.455443682,0.0,0.38867746700000005,0.0,0.451994446,0.0334439117,0.0,0.0,0.210062141,0.0,0.210806694,0.0,0.119464717,0.022772152599999998,0.0,0.0,0.0,0.0,0.35717426799999996,0.0,0.359648465,0.205518394,0.167660724,0.0,0.0,0.83327987,0.714918993,0.474805166,0.203697295,0.7506679209999999,1.68936173,2.88896772,4.07944167,5.34939909,6.01670149,4.54369697,3.23889625,1.92460634,0.352443864,0.0,0.0,0.667584975,0.7138612129999999,1.82633049,2.44848492,3.48899173,4.03929733,4.56016373,4.00257821,3.55617928,2.70616989,1.62599446,0.787056568,0.0,0.302974741,0.37181913299999997,0.0,0.142735912,0.0,0.17392201899999998,0.0,0.0,0.0,0.547511526,0.0,0.16187425,0.0,0.0,0.230685526,0.0,0.0,0.0,0.51795327,0.0,0.0,0.0,0.0,0.0,0.0,0.553735787,0.0,0.189499527,0.518665037,0.22594919800000002,0.0,0.0,0.37510450100000003,0.0631722014,0.7647667709999999,1.02522651,1.24163928,0.8258684340000001,0.27158626199999997,0.46479456,0.5628202760000001,0.37832491100000004,0.084415219,0.335080036,0.144561581,0.618926306,0.272498474,0.0363265596,0.360847115,0.0,0.0,0.0,0.0,0.106516562,0.0,0.0,0.00200698725,0.28652923399999997,0.207592988,0.533329941,0.26624437100000004,0.0,0.15180576199999998,0.169517007,0.500279203,0.235013726,0.0304494441,0.0,0.0,0.0193713049,0.331891945,0.0,0.0,0.0,0.0,0.0,0.128834111,0.0,0.552807275,0.48277336,0.588465024,0.47607140200000003,0.174723983,0.0,0.181561783,0.431167132,0.0,0.23632683699999998,1.03951028,0.167253547,1.02713649,0.37086736600000003,0.524700527,0.464619225,0.0,0.6596377920000001,0.0,0.48247784299999996,0.027122160899999997,0.24462323100000002,0.0,0.0858161283,0.0,0.19722422899999997,0.882682396,1.27748345,0.7197793159999999,1.02677085,0.7252492759999999,0.11241488,0.0,0.0,0.00414979584,0.125406168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.447
4.36412986,6.08570527,7.42156282,7.96867619,7.53729273,6.22355076,4.37531339,2.46546125,0.9251773520000001,0.00468044404,0.0,0.0,0.164654079,0.372131484,0.362956949,0.163626789,0.0,0.0,0.0,0.0,0.04631740769999999,0.20131676,0.234780475,0.143225716,0.0,0.0,0.0,0.0,0.0,0.10163019599999999,0.14839361199999998,0.113212915,0.0231435823,0.0,0.0,0.0,0.0,0.0443155072,0.0870114957,0.0795631629,0.0320372782,0.0,0.0,0.0,0.0,0.012511818999999999,0.0411660925,0.043703765,0.0236248056,0.0,0.0,0.0,0.0,7.02342913e-16,0.008099974670000001,0.00727779787,0.00213634563,0.0,0.00370687605,0.010554378799999998,0.0127365073,0.00456541636,0.0,0.0,0.0,0.0,0.0171142411,0.0441486154,0.049838596500000006,0.0260698433,0.0,0.0,0.0,0.0,0.0147871564,0.0730089521,0.096408695,0.0664036207,0.0,0.0,0.0,0.0,0.0,0.0932931457,0.151509853,0.128021033,0.0287543391,0.0,0.0,0.0,0.0644494669,0.306447249,0.521470915,0.622719835,0.580959322,0.44672680200000003,0.330280426,0.345585653,0.545365539,0.8825160670000001,1.22318958,1.41198636,1.36160749,1.12245964,0.89200711,0.949067213,1.53392063,2.72419514,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.467
0.0385481613,0.0,0.0,0.0,0.625835764,1.34028835,1.47220145,0.850091811,0.0,0.0,0.0,1.74618556,3.87990517,5.30904014,5.25636196,3.73936056,1.54382852,0.0,0.0,0.0,0.0,0.572606066,0.6316256060000001,0.30513762899999997,0.0,0.0,0.000426071924,0.188559465,0.23808627899999998,0.133840992,0.0,0.0,0.0,0.00913342591,0.0,0.0,0.0,0.0997760691,0.298070165,0.308650551,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.44
0.307458161,0.368554941,0.516835434,0.532505761,0.19344482699999999,0.609729692,0.0,0.0,0.0,0.43070384700000003,0.0,0.322452728,0.0,0.861248646,0.317010625,0.7179046729999999,0.188455653,0.0,0.06751454679999999,1.05439913,1.10610521,0.525396909,0.0,0.142815304,1.04915388,0.0,0.202729327,0.0,0.625000071,0.21075022100000002,0.0812249178,0.806834745,1.00614698,1.08274148,0.938527909,1.92530106,1.4339031999999998,0.44285338799999996,1.31263639,1.65764935,1.81777056,1.70159196,1.44197302,2.16455484,1.75784744,0.106777334,0.696575732,0.804029324,0.843481697,0.380333825,0.148464382,0.776056291,0.129926525,0.900507818,1.11459005,0.578535966,0.297193704,0.0,0.0,1.1609409,0.226600263,0.338672056,0.0,0.33632048600000003,0.0,0.0,0.0,0.07747606929999999,0.5356693810000001,1.27314927,0.503709092,1.12558823,0.0,0.0106774913,0.0,1.90517485,0.135650623,1.39771203,2.53401868,2.96928216,2.56304396,2.83765828,0.49666035700000005,0.630016153,0.0,0.0,1.09163882,0.128666748,0.554360579,0.525181349,0.690825007,1.24310684,0.0,0.305739432,0.263658472,0.0,0.937944225,0.668332962,0.0,0.0690880613,0.0,0.125615755,0.117248522,0.215230805,0.5075841529999999,0.97258359,1.60290875,0.70593909,0.0,0.5072923970000001,0.0,0.0,0.691053925,0.75053855,1.75353599,1.86753394,1.15181892,2.23066215,1.28430824,1.40225786,1.43663505,0.824892235,1.58155976,1.79599982,1.04321341,1.57374381,2.12909682,0.0,0.44233611100000003,0.493828369,0.5502745379999999,0.76090704,0.702571822,0.44247109100000004,0.0,0.26445907,0.0,0.45664197,0.14124141199999998,0.149671601,0.0254276487,0.0,0.255126737,0.0,0.0,1.13299629,0.0,0.244155092,0.0,0.0744967604,0.222172703,0.279344274,0.0,0.0,0.109027111,0.668339462,0.0,1.1705005,0.0,0.562947006,0.0295086164,0.0,1.30022703,0.0,0.8603882909999999,0.5208173779999999,1.36726108,0.0,0.0,0.8016580190000001,0.7652460059999999,1.43042655,1.60083498,1.86563971,3.03543568,0.660077295,1.18875174,0.435178064,0.0011295496499999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
1.04827557,1.88205828,1.24831729,1.68845927,0.790983012,0.0,0.613657216,0.9081273870000001,0.0,0.15162871,0.118793855,0.0,0.45269708299999994,3.24290878,6.70916659,3.8962419,0.062657825,0.0,0.800809181,0.0829293504,0.0,0.0,0.160262464,0.126960952,0.0,0.17866338699999998,0.0,0.093450714,0.0,0.522830593,0.409610543,0.0,0.0,0.0,0.0,0.179773968,0.0,0.0,0.0,0.0,0.350847919,0.0,0.808201079,1.64081353,2.51353972,2.16488847,0.0,0.0,0.694086335,0.0,0.0,0.0,0.628361605,0.36000818,0.0,0.13163602900000002,1.05699501,0.7764505490000001,0.9962921159999999,0.07553421980000001,0.0,0.619488253,0.0,0.0,0.0,0.412852735,0.0,0.152061565,0.148891835,0.0,0.0,0.020673645900000003,0.37651333200000003,0.0,0.248873105,0.606429662,0.304786055,0.0,0.0,0.546690071,0.0,0.018684281299999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.435
0.21415087100000002,0.27123248,0.332980567,0.397382126,0.462158646,0.5249258139999999,0.583364945,0.6353916270000001,0.679307062,0.7139189340000001,0.7386211140000001,0.753424975,0.758939267,0.756300005,0.7470563159999999,0.733022208,0.716107532,0.698143547,0.6807193979999999,0.665045267,0.651856023,0.641365961,0.633280951,0.626869339,0.621087606,0.6147516439999999,0.606739834,0.59621049,0.5828138620000001,0.566878113,0.549549579,0.532870207,0.519779201,0.514031315,0.520030553,0.542584803,0.5865936110000001,0.656687435,0.7568417040000001,0.8899925329999999,1.05768257,1.25976511,1.49419204,1.75690684,2.04185744,2.34113646,2.64524763,2.94348882,3.22443352,3.47648542,3.68847478,3.85026128,3.95330647,3.9911797,3.95996441,3.85853766,3.68870245,3.45516206,3.16533465,2.82901706,2.4579156,2.06507064,1.66420823,1.26905683,0.8926692629999999,0.5467897660000001,0.241302873,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0249601086,0.115992441,0.18914572699999999,0.24085553699999998,0.269428188,0.274984318,0.259288073,0.225479745,0.177735466,0.120881429,0.059991906,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0243153571,0.052103833499999995,0.0730652629,0.086196406,0.0912285194,0.08858852019999999,0.0793043107,0.0648657118,0.0470556046,0.027767687200000002,0.00882761589,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0010033743199999998,0.00409222891,0.006060873939999999,0.00771305917,0.0101946617,0.0148934369,0.023309988700000003,0.036911664,0.0569827339,0.08448469130000001,0.11993973699999999,0.163348595,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43700000000000006
1.77250892,1.84151506,1.7838738999999997,1.58556667,1.26133858,0.8566175340000001,0.443718303,0.11244198,0.0,0.0563250217,0.46577812,1.19768573,2.21858286,3.44943835,4.77423784,6.05512559,7.15181101,7.9420996,8.34011058,8.30906596,7.86643247,7.08051257,6.05907264,4.93199045,3.83093819,2.86959911,2.12775682,1.64183142,1.40321525,1.36432064,1.45086691,1.57786501,1.66619992,1.65675417,1.51963456,1.25711678,0.900192786,0.49983491799999996,0.115043113,0.0,0.0,0.0,0.0,0.0,0.0,0.0488988224,0.195794427,0.278332902,0.286591635,0.228592565,0.126863864,0.0121465494,0.0,0.0,0.0,0.0,0.0207183168,0.135577998,0.24039326600000002,0.31103891,0.331553186,0.297409833,0.216103022,0.10504267099999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.058375269800000004,0.12137574,0.152342518,0.146367743,0.10717389599999999,0.0457617712,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0506366946,0.0899264414,0.10639189199999999,0.0974089393,0.0663487774,0.0215009471,0.0,0.0,0.0,0.0,0.0,0.0,0.006806724709999999,0.04401992,0.0692306489,0.0771779668,0.0668541335,0.041534638,0.00781389876,0.0,0.0,0.0,0.0,0.0,0.0,0.0114209631,0.0369622158,0.052656921399999994,0.055357279100000004,0.0450939042,0.0249098279,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012503241000000002,0.029198296600000003,0.0381767934,0.0378015213,0.0287102536,0.0135352397,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0109401451,0.0207159751,0.0249814092,0.0231650158,0.016165333100000002,0.006027799059999999,0.0,0.0,0.0,0.0,0.0,0.0,0.00042604513099999997,0.007277645959999999,0.0116526722,0.0128150928,0.010890355,0.00673951804,0.00165991875,0.0,0.0,0.0,0.0,0.0,0.0,0.000579736973,0.00202892067,0.002391401,0.00187124884,0.0009479857369999999,0.000176782335,0.0,0.000483163846,0.0014908165700000002,0.00253749745,0.00306755063,0.00264140107,0.00111517754,0.0,0.0,0.0,0.0,0.0,0.0,0.000465714787,0.00466504917,0.00809145985,0.00976048964,0.009093141400000001,0.00610684417,0.00144703339,0.0,0.0,0.0,0.0,0.0,0.0,0.0017073530899999999,0.006163737900000001,0.008804421590000002,0.0090803048,0.00715252574,0.00381150269,0.000186819022,0.0,0.0,0.0,0.0,0.0,0.0,0.00220057324,0.011014558700000001,0.0313639113,0.0710094427,0.138282136,0.24024420800000001,0.380555701,0.557518049,0.7628267120000001,0.9815018059999999,1.1932733999999998,1.37540334,1.50658365,1.57123782,1.56334494,1.48887161,1.36606613,1.22323257,1.09410244,1.01146463,1.00018266,1.07101121,1.21663522,1.41106148,1.61292374,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.479
0.619534654,0.025260551699999998,0.927738423,0.573436803,0.44432885899999996,0.0,0.294656255,0.0,0.0,0.0,0.0,0.38114273,0.0,0.607497982,0.0,0.0,0.027413863599999998,0.0,0.0,0.0,0.121782642,0.28267155,0.556135766,0.180688813,0.602405761,0.0457397853,0.0,0.078851403,0.0,0.0,0.34186442200000006,0.370620685,0.786790467,0.8532929840000001,0.0481673251,0.34898744600000003,0.0,0.0,0.0,0.0,1.21532716,2.04522164,4.1719203,4.78620572,5.51417817,5.91554171,4.8201335,3.75162089,3.07351447,2.3466112,2.11572146,2.87242036,3.08373375,4.48210838,4.57770307,4.75465085,3.81469024,3.03263416,2.77649096,1.38850787,0.31872698899999996,0.0,0.0,0.0,0.389739279,0.698446986,0.42883315200000005,0.898721255,0.79624186,0.415353872,0.177790616,0.057880754000000006,0.0,0.0,0.0,0.0,0.400146491,0.514794848,0.797337955,0.462445349,0.560052366,0.239984732,0.0,0.0,0.510048596,0.287292406,0.0,0.173449204,0.526332724,0.127460905,0.0,0.258241858,0.0,0.0,0.813149785,0.770687755,0.451788691,0.447025079,0.302252254,0.179527883,0.0,0.0,0.138141298,0.0,0.0,0.0,0.0,0.516171846,0.0,0.0,0.0,0.43469876799999996,0.0,0.0,0.0,0.159116544,0.0,0.0,0.0,0.506165293,0.24719288600000003,0.0,0.0,0.0,0.321999934,0.641433536,0.0,0.024694172900000002,0.0,0.337019788,0.0,0.288696326,0.0574461939,0.10477292099999999,0.267700273,0.0,0.0,0.0,0.0,0.0929714415,0.393924781,0.150930735,0.243782311,0.0,0.0,0.380342014,0.08673401,0.444151595,0.0662623491,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
0.626058369,0.5611357929999999,1.93867661,1.41245201,1.07145128,3.35616609,2.74907475,2.54821691,2.64862027,1.52581417,1.3638191000000002,0.10523013199999999,1.08905793,0.0,0.0,0.0,0.0,0.129074825,0.0,0.0,2.02430071,0.0,1.29746663,0.0,0.541872451,0.75272963,0.0,0.0268736508,0.0,0.0,0.0,0.0,0.262859161,0.013071465,0.7749833770000001,0.657656236,0.0,0.318260327,0.32130242800000003,0.887309755,0.160864927,1.20368303,0.0,0.0,0.0,0.40298789700000004,0.0,0.0,0.0,0.0,0.17659571,0.0,0.0,0.0,0.454622123,0.0,0.950316443,0.0,0.0,0.0704640456,0.0,0.577947425,0.33405034899999997,0.102238546,0.945149164,0.0,1.21834555,0.26871497699999997,0.0,1.67173217,0.0,0.797734348,0.0,0.6225458460000001,0.316327784,0.0,0.501715503,0.225087631,0.292928501,0.0,0.00735520463,0.402934732,0.0013163855100000001,0.0,0.570779856,0.0,0.0,0.5478059279999999,0.39678391799999996,0.0,0.352047736,0.555576528,0.49076669100000003,0.0448922287,0.0,0.0,0.432309276,0.681164564,0.742684247,0.249975086,0.176837623,0.0,0.234256555,0.507359064,0.718587902,0.28479665,0.0503252832,0.0,0.0,0.0,0.0,0.7692067890000001,0.864711837,1.06296881,1.1448061999999999,1.73974034,0.0,0.0,0.0,0.0,0.0,0.194400955,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42
0.85971506,0.0,0.0,0.5223799960000001,0.0,0.0,0.0259731221,0.0,0.0,0.037401932,0.302236345,0.71838181,0.43038240200000005,0.0,0.0335348675,0.919969189,0.201351174,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.249328627,0.169349675,0.0,0.0360043183,0.0,0.17187128399999999,0.0986630564,0.0,0.677805593,0.11904181400000001,1.82363446,0.531077108,0.0,0.0,0.0,0.480325134,0.409432181,0.0009099158710000001,0.957399786,0.0,0.0,0.8273944990000001,0.0,0.0,0.0,0.0,0.0195050202,0.24288851,0.0,1.69308335,0.645367467,0.0,0.9965384829999999,0.136074678,0.0,1.53772495,0.6405080439999999,0.8611398720000001,0.0,0.167544666,1.37473746,1.20117647,1.48834354,2.06607266,1.33224673,1.60101787,2.96443584,3.35225297,3.28683926,2.68946188,4.2414198,3.32127435,2.87978242,3.88031162,2.99360635,3.5095955,2.29132687,2.62861597,3.6232857000000003,3.51367703,3.27645611,2.11395729,1.9264608,4.23384275,2.27243514,2.69829287,1.48645512,2.9943037,1.93430654,0.5678623,1.70655849,1.97266136,0.0,0.0824456703,0.18998810600000002,0.0,0.442705926,0.0,0.0,0.0,0.857245705,0.0,0.0,0.0,0.0,0.0,0.0,0.0629694266,0.141755136,0.00637059537,0.29324115100000003,0.37893191,0.44092341399999996,0.612328536,0.0,0.0240322407,1.40326128,0.616719812,1.05523064,0.756452547,0.0879348697,0.0,0.5564860079999999,0.382731996,0.0,0.0,0.0,0.375626678,0.101869979,0.28790808,0.193360905,0.0,0.0,0.299064455,1.16865666,0.0249764654,0.0,0.0,0.0,0.353260457,0.0,0.5817773070000001,0.170197105,0.0,1.07863003,0.458687719,0.7750683159999999,0.0,0.0,0.0,0.0,0.487191444,0.370835938,0.0,0.0,0.33166845699999997,0.0,0.27652833600000004,0.8036916409999999,0.339789454,0.7875112120000001,1.17248924,0.0,0.575672969,0.0,0.0,0.0,0.0,0.531116574,0.0,0.0,0.0,0.9012214620000001,0.0,0.0,0.0,0.48689786799999996,0.0,0.0,0.727728541,0.647456459,0.501441273,0.044856376600000004,0.0,0.721287947,0.0,0.43575455700000004,0.164081367,0.0,0.0,0.0,0.163594708,1.14320595,0.0453256303,0.196575738,0.0194329707,0.474104688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
0.09466946359999999,0.23167620100000003,0.322268082,0.336007086,0.273356754,0.164129684,0.0551046986,0.0,0.00120249102,0.08223725030000001,0.20664891300000002,0.330368813,0.410498294,0.421598026,0.36518221100000003,0.268951277,0.176147238,0.129073349,0.152947235,0.24609454100000003,0.380123945,0.510040823,0.590612182,0.5930162720000001,0.515713791,0.385581026,0.248869416,0.155215872,0.140403277,0.213981757,0.35608261799999996,0.5244513820000001,0.669097492,0.7493089479999999,0.747042636,0.672107076,0.557561877,0.44725966799999994,0.380186882,0.377256205,0.435147128,0.529110954,0.62336095,0.684967161,0.6960369679999999,0.659764465,0.598333793,0.543742914,0.525221642,0.558094261,0.638272682,0.7443417059999999,0.846272452,0.917283372,0.944205541,0.932327655,0.9028499609999999,0.883940487,0.898870322,0.955860678,1.04365783,1.13468794,1.19474532,1.19563281,1.12597114,0.9960006140000001,0.834408233,0.678212026,0.559397029,0.493307996,0.47324081,0.473413911,0.459363165,0.40195571,0.289742751,0.134856959,0.0,0.0,0.0,0.0,0.0,0.018435619599999998,0.141352809,0.210509947,0.201102518,0.116905582,0.0,0.0,0.0,0.0,0.0,0.0036793539,0.130721752,0.20885858100000002,0.208315975,0.129477657,0.0035972736200000003,0.0,0.0,0.0,0.0,0.112144223,0.275162134,0.38076989899999997,0.395155475,0.322178573,0.20496287600000002,0.111950157,0.111522361,0.243963481,0.501249329,0.82308898,1.11230014,1.26571269,1.2107625,0.93500806,0.497251748,0.014567829,0.0,0.0,0.0,0.0,0.312760517,0.695652305,0.8603755820000001,0.708153446,0.24681701399999997,0.0,0.0,0.0,0.0,0.0,0.9849123879999999,2.68954124,4.4470776,5.91627842,6.80835107,6.96047891,6.37545841,5.21648444,3.75934107,2.31665297,1.15663021,0.43958260899999996,0.18927812800000002,0.30507085100000003,0.608226885,0.9059600290000001,1.05234903,0.987675575,0.745754037,0.429704845,0.166734156,0.058598627,0.144764095,0.38998373399999997,0.699133685,0.952765615,1.05011159,0.944338551,0.658142262,0.27496573,0.0,0.0,0.0,0.0,0.0188255027,0.313098881,0.533358068,0.60678303,0.513719248,0.291597282,0.019489809,0.0,0.0,0.0,0.0,0.0881463705,0.299665527,0.429826394,0.44246261299999995,0.34430784600000003,0.179786671,0.0129937796,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.46299999999999997
0.435881642,0.016709871100000002,0.54496609,0.320673263,0.12628851300000002,0.5622448210000001,0.7987535179999999,0.188877005,0.7096361990000001,0.0,0.355605115,0.0,0.0970365539,0.0,0.0,0.0,0.0,0.0,0.18989055300000002,0.0,0.0,0.0,0.056604941900000004,0.0,0.0,0.10573622099999999,0.0,0.13157455199999998,0.0,0.166852952,0.479312246,0.0,0.286619063,0.0,0.241085813,0.0,0.36564134,0.10824302400000001,0.0,0.307047125,0.231950061,0.0,0.279177099,0.373864697,0.20651280100000002,0.0166041683,0.409104525,0.0,0.0,0.341762037,0.0251204123,0.0,0.345552377,0.0,0.112571119,0.33859184700000006,0.0,0.33850250600000004,0.486981525,0.0819328485,0.0,0.12386172599999999,0.0895411881,0.0,0.43773857,0.0,0.263050976,0.0,0.27435814,0.0743417005,0.0,0.19491064800000002,0.0,0.166103385,0.29206370600000003,0.0,0.351380268,0.0,0.0177589651,0.0,0.0,0.415162965,0.0,0.218446164,0.673789587,0.7325131490000001,0.321013899,0.5449756379999999,0.600425825,0.368665536,1.03608502,1.21181397,1.33003747,1.45513735,1.06700538,1.24887634,1.09540561,0.972019236,0.751242637,0.855199426,0.683229383,0.39828418,0.986035785,0.21969388399999998,0.946283965,1.12702214,1.1945066,1.0876158,1.20132816,1.79886121,1.51976637,0.968532645,1.1300911,1.14447463,0.221794191,0.356952695,0.0,0.502670822,0.0,0.0,0.689529422,0.781313794,0.537088748,0.937562181,0.956847274,1.2498154,0.603651846,0.858332415,0.72492522,0.9151890570000001,1.52007906,1.97986329,1.90213439,2.6232342,3.68671041,4.55283268,4.5604702,5.49397576,5.30012402,5.26645664,3.86808302,3.94994959,2.90956783,2.36636175,0.9199695940000001,0.630209476,0.05658441559999999,0.0,0.0,0.0,0.0,0.294149485,0.0,0.618497986,0.734269669,0.336681757,0.620364018,0.432989645,0.10475109199999999,0.171347206,0.0,0.07614176389999999,0.0,0.0,0.0,0.14040888199999998,0.517865531,0.040235487599999994,0.621019124,0.43655710299999995,0.534042764,0.42263911600000004,0.0,0.0,0.106515074,0.0,0.20355806899999998,0.0,0.0,0.278916322,0.496886644,0.0,0.543562479,0.0901768311,0.472771318,0.0,0.04325056769999999,0.0,0.172101914,0.103665374,0.153040258,0.232419557,0.0657215006,0.578682071,0.042646297300000004,0.280662684,0.0,0.49439004299999995,0.0,0.0,0.0937638943,0.0,0.18682854,0.434403362,0.0,0.0,0.12300588900000001,0.327358723,0.556866024,0.454299357,0.34852944399999997,0.270484336,0.35892826200000005,0.0,0.0,0.0,0.0,0.0,0.271184357,0.0,0.57087875,0.29090552199999997,0.013203362199999999,0.608415763,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.45
1.25956217,1.213323,1.8656522,2.96849555,1.61684242,1.9826743999999998,1.12136402,1.13983809,0.955068259,1.11333665,0.0,0.0,0.64772397,0.585709877,0.730824969,0.0680514435,0.0,0.0,0.0,0.6676486999999999,0.0,0.0545652612,0.9006466879999999,0.196221649,0.0,0.0,0.0,0.0,0.0,0.67465944,1.64943612,0.34917662899999996,0.0,0.131033822,0.33763783799999997,0.0,0.0,0.0133092818,0.0,0.0,0.376342929,0.0,0.0,0.0,0.0,0.25968895399999997,0.8294894490000001,0.0,0.0,0.0,0.7740449290000001,0.0,0.09030173529999999,0.42744448,0.593290336,1.17424717,1.48536968,0.983447691,1.72332197,1.77699146,2.02138906,2.15308665,1.57492392,0.624269218,1.25621373,0.629719436,0.941080668,1.41477185,2.14824392,2.71921481,0.0,0.0912094104,0.0,0.0,0.0,0.226707637,0.0,0.38556294700000004,0.041244941800000004,0.49561296200000005,0.621887504,0.45749728700000003,1.23733624,0.0,0.0,0.05662684900000001,0.45895606,0.967093697,0.7124512129999999,1.26083849,0.393000196,0.0,0.36944118299999995,0.0,0.435153515,0.0,0.8200520859999999,2.00947188,1.03714154,0.620181199,0.7808113190000001,0.42769238299999995,0.0,0.0285819491,0.0,2.13096885,2.13471113,2.82559676,3.75023907,1.7205145,1.622473,1.10615306,0.7094664970000001,0.0,0.0,0.0,0.0,0.450147852,1.61819068,2.17008263,0.7226639490000001,0.0,1.2022563,0.0,0.0,0.0,0.0,0.358601231,0.0,0.164716049,0.128253675,0.0,0.22291564,0.138434635,0.616030326,0.45425109799999996,1.99545964,1.22966732,0.0,1.02039263,0.17287375800000002,0.608324842,0.0,0.0,0.783422605,0.664279827,1.08265078,2.59913709,1.6525928,0.635056638,1.34622093,2.41888978,0.9185772040000001,0.97435952,0.9409242879999999,1.34163343,0.954627357,1.07168686,1.47530779,0.0,1.30576315,0.392271749,0.669431502,0.20189665399999998,0.0,0.0,0.0,1.19600955,0.0,0.44016302700000004,0.450555525,0.271432047,0.9873216,0.957856713,0.0,1.19255138,0.0,0.9820304059999999,0.48780945700000006,0.9688447090000001,0.173042227,0.28963748300000003,0.205786448,0.0,0.14450539999999998,0.0,0.813577709,0.0,0.333912993,0.50083096,0.46739308700000004,0.273612416,0.740977879,0.18900771100000002,0.5256008520000001,0.5158223820000001,0.0,0.578531629,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.423
0.7443758909999999,0.0,0.28766114600000003,0.9087720029999999,0.159664959,0.665369105,0.27804429399999997,0.690815301,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.342304514,0.0,0.0,0.246329367,0.12187394300000001,0.275781117,0.10145691,0.278212002,0.894386263,0.0,0.41831323600000003,0.030864821,0.0,0.0,0.0,0.363800199,0.0,0.45584424799999995,0.613638117,0.0,0.143213735,0.55257787,0.745874622,0.28054603100000003,0.15466297099999998,0.300799319,0.0,0.781668148,0.38158086399999996,0.0,0.0,0.0,0.0,0.460112842,0.481078489,0.552573689,0.19325447199999998,0.0,0.492793825,0.318687039,0.0,0.804704877,0.195849522,0.416094394,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.203632069,0.0,0.283653742,0.0,0.0,0.0,0.747868449,0.0,0.31501214,0.0,0.443403406,0.0,0.0,0.0,0.051417013899999996,0.27407924100000003,0.0,0.00258405491,0.295141477,0.0,0.0,0.0,0.339699825,0.35319938,0.0,0.632204543,0.0,0.0,0.251443317,0.0,0.0,0.39281457,0.0,0.374559035,0.133664276,0.0,0.0,0.0,0.32314596100000004,0.0,0.0,0.0,0.57887798,0.682089088,0.34484951799999997,0.0,0.0,0.556780202,0.0,0.28859092399999997,0.062457518,0.0,0.0,0.0,0.0,0.0,0.246827687,0.0,0.5728639879999999,0.8812320140000001,0.912077767,0.542578397,1.39587609,0.57649194,1.11794915,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.688717757,0.8011970140000001,1.96047507,2.6175007000000003,3.57158058,4.54436221,6.32665562,6.51815375,7.57346372,7.71110076,7.36897847,7.01387217,6.28308825,5.42862069,5.27483067,4.36527554,2.03208911,1.84514552,1.03964388,0.0244560839,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.550656423,0.0131616623,0.11347406199999999,1.23577661,0.7783143220000001,0.265945978,0.888372332,0.153566265,0.0,0.0,0.0,0.0,0.18104404300000002,0.0,0.0,0.0,0.0,0.22036004899999997,0.25665366,0.38855205299999995,0.7690400820000001,0.855400857,0.140708701,0.17504283399999998,0.029288633199999997,0.42753151799999994,0.274465203,0.0,0.0,0.0,0.0,0.0,0.0,0.45065676600000004,0.0,0.0,0.0,0.295580241,0.32625835,0.446634346,0.5659211670000001,0.43969881,0.676124594,0.15340277800000002,0.105468967,0.0734055309,0.0,0.0,0.0,0.0,0.029951239900000003,0.0,0.0,0.372671585,0.0,0.0,0.0,0.0,0.0804864076,0.0,0.0,0.0216256649,0.270234402,0.0,0.0,0.0,0.0,0.5691583720000001,0.0,0.335295325,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.47200000000000003
0.02907021,0.44829856,0.09048065,0.0,1.06716755,0.65921353,1.15894259,0.0,0.15752224,0.28661147,0.61154026,1.12456792,0.70055728,1.40791494,0.62205281,0.0,0.0,0.0,0.24947869,0.5786131999999999,0.0,0.8923144000000001,0.0,0.15338713,0.53678256,1.65027277,1.62163006,2.76913736,3.61853972,2.44527102,2.88704387,2.75155387,3.32717045,3.31038714,2.97513941,2.27243143,2.43622065,2.1312946,0.0,1.53337821,0.99168958,1.31898619,0.45626057,0.0,0.0,0.51762368,0.08200863,0.36404646,0.02644703,0.0,0.18263118,0.22631947,0.0,1.44250562,0.0,0.0,0.42267285,0.0,0.0,0.35871254,0.04451814,0.44044347,0.04701742,0.68370285,1.75962951,0.79149437,2.08300072,1.78429992,1.94137654,1.60643838,1.96839884,1.78769653,2.15107482,1.34751226,2.20083125,0.0,1.09253868,0.0,0.68553461,0.57841154,0.0,0.25167533,0.39211855,0.0,0.0,0.65791588,1.0603122,2.22788329,0.0,0.0,0.0,0.58155922,0.7816274000000001,1.30456999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.8775873590000001,1.07609706,1.06482322,0.8710021640000001,0.5833904529999999,0.315289234,0.164172479,0.18043887399999997,0.354046215,0.621646315,0.8903304059999999,1.0692329,1.09841973,0.9660831059999999,0.7093705990000001,0.39967803700000004,0.118126324,0.0,0.0,0.0,0.0253422011,0.146131615,0.21891855899999998,0.21284322100000003,0.12952413599999998,0.0,0.0,0.0,0.0,0.0,0.0,0.09963995949999999,0.187658645,0.207965765,0.15501778300000002,0.049005227199999994,0.0,0.0,0.0,0.0,0.0,0.0460591562,0.142763422,0.18772972100000002,0.166124452,0.0865665511,0.0,0.0,0.0,0.0,0.0,0.0,0.110681685,0.195617755,0.23684869600000003,0.23618232399999997,0.214143802,0.20171029199999999,0.227793948,0.307040805,0.43250011200000005,0.5760688829999999,0.6968870690000001,0.7549969990000001,0.725597378,0.6088391870000001,0.43150373399999997,0.23962857199999998,0.0842851347,0.00517577527,0.017627940800000002,0.10755782300000001,0.236349389,0.354212532,0.41759800700000005,0.404704767,0.323596771,0.20984884,0.114195744,0.0841739009,0.146003815,0.29313732800000003,0.485848303,0.662597674,0.759845749,0.733894024,0.577316071,0.324020956,0.040585585800000004,0.0,0.0,0.0,0.0,0.09334706359999999,0.304135434,0.41918230799999995,0.388426675,0.211951776,0.0,0.0,0.0,0.0,0.0,0.0,0.364899651,0.643151775,0.725937279,0.563836479,0.194052256,0.0,0.0,0.0,0.0,0.822024007,2.30253871,4.07940969,5.8720365999999995,7.36768778,8.29327273,8.47964861,7.90153144,6.68250778,5.064006099999999,3.34673103,1.82025999,0.6992479159999999,0.0822870113,0.0,0.151649487,0.5246221,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.478
0.197180915,0.0,0.66904917,0.0,0.0,0.09410199849999999,0.115242379,0.0,0.0,0.836899543,0.0,0.0,0.0,0.0,0.5489501520000001,0.21038449999999997,0.89178231,1.34070246,0.266502255,0.0,0.0,0.0,0.853545546,0.0,0.24484923100000003,0.246001665,0.0,0.0,0.289104142,0.0,0.828837653,0.0,0.427674943,0.0,0.56138895,0.0,0.0,0.214078305,0.0,0.0,0.855832756,0.423607286,0.0,0.361085018,0.0,0.0,0.9847736220000001,0.0,0.0,0.0,0.0,1.46829031,0.0,0.22325453899999997,0.0,0.6310366620000001,0.537347509,0.0,0.545343229,0.5555142789999999,1.07914085,1.38622799,0.11788023800000001,0.0,0.3117922,1.97403973,0.59307503,0.0,0.600130928,0.902985576,1.20802755,0.0,0.966653123,1.36173176,0.698795257,0.840116251,1.00936641,2.77865887,1.15712722,2.66497605,2.06875877,3.52969206,1.16747008,1.96886441,3.87985123,2.21715205,4.20447633,2.13697774,1.07233138,0.00506579684,0.0,0.265169241,0.0,0.0,1.81233278,0.0,0.0,0.0,0.0,0.0,0.138285075,0.18162557699999998,0.666357848,0.0,0.0,0.194780023,0.330166573,0.245948408,0.0,0.0,0.0,0.0,0.0,0.0,0.605492858,0.0,1.48803967,1.14232861,0.971965272,0.93426261,0.24639445699999998,0.0,0.0,1.14490263,0.7724993090000001,0.695737536,0.0,0.210246758,0.0,0.44659657399999997,0.0,0.0,0.556347477,0.0,0.37406486299999997,0.248336085,0.651911306,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.428
0.463835589,0.0,0.0,0.0,0.07354566929999999,0.548907241,0.451715541,0.0,0.0,0.0,0.0798463992,0.0,0.0,0.650207168,0.0,0.0,0.65614642,0.0,0.10786609300000001,0.0,0.327057828,0.0,0.0,0.692347151,0.623158904,0.13593293,0.654516274,0.0,0.456648031,0.724014378,0.513193685,0.0,0.5229364089999999,0.638883822,0.6945728729999999,0.0307090155,0.0,0.710229111,0.511468528,1.29996576,0.0,0.9117676109999999,1.24439025,0.28391204800000003,0.435788124,0.0,0.662795163,0.0,0.0,0.7925050929999999,0.0,0.6942440670000001,0.235821886,0.0,0.33815837200000004,0.0,0.177558517,0.350716112,0.0,0.0,0.236812288,0.973564443,3.8746129999999996,4.12604569,3.86684187,2.78744486,1.77102727,0.0,0.0,0.43490258,0.0,0.198110377,0.403972184,0.00622145803,0.0,0.000241993014,0.0,0.0,0.0,0.807632186,0.0,0.528260348,0.0,0.0,0.935619506,0.0,0.61180816,0.185354071,0.614962354,0.0,0.0,0.0,0.0,0.38032219100000003,0.0,0.10028119199999999,0.937621987,0.0,0.0,0.0,0.853894235,0.0,0.445743929,0.551379657,0.0,0.324696469,1.16440796,0.995387274,0.220849725,0.0,0.0,0.7940589240000001,2.27150885,6.23040556,8.12729349,7.87365625,5.58138259,1.77609008,0.0,0.0,0.0,0.16668955400000002,1.13801081,0.0,0.11770694400000001,0.0,0.602094001,0.557139982,0.0407856215,0.533111486,0.0,0.763597195,0.571872718,1.75714294,1.51889554,2.45141797,1.10843934,0.805385789,1.37576962,1.40365866,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.466
1.23000303,0.22348009600000002,1.02293346,0.0,0.0,0.0,0.0,0.0,1.15944084,0.0,0.70690725,0.101617317,1.3110825000000002,0.0,1.03509291,0.0,0.0,0.503005138,0.0,0.37341276100000004,0.319208525,0.0,0.831127438,0.0,0.0,0.873267067,1.22738831,0.9055615840000001,0.0,0.771510835,1.53973594,4.22013943,5.87074063,3.89778125,3.32913971,0.873109391,0.0,0.22681529600000003,0.0,0.344696713,0.308239115,1.15449327,1.07548661,0.0,1.6859297999999998,1.30694065,0.0,1.1692337,0.0,0.211741144,1.1024796000000001,1.93439071,2.79235224,0.638395452,1.22489007,1.47805323,1.36787262,0.18644930699999998,3.82531081,0.432697619,0.12047136900000001,1.02070754,0.0,0.358972621,0.0,0.0,0.12140420099999999,0.0,0.16882361,0.0,0.0,0.0,0.37949535100000004,0.0,1.69820106,1.91056062,1.9353836,0.0,0.9729380879999999,0.0,0.00291147696,0.0228489596,1.16313547,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0916436146,1.36179092,0.0,0.0,0.37570573399999996,0.93401782,0.0,0.0,0.765882946,0.0,1.4646753000000001,0.0,0.867043552,0.439898099,0.0663121616,0.793889245,0.0,1.5264739,0.0,0.0,0.092384841,0.8010316829999999,0.0,0.508293103,0.321893871,0.316285726,0.0,0.0,0.127493314,0.0,0.0,0.681725177,0.0,0.621691094,1.80843136,0.0,0.163614893,1.78087393,1.04464861,0.466358527,1.13689951,0.573377562,0.5647925189999999,0.889453245,0.0,0.727468476,0.6753373770000001,0.294684945,0.052784653499999994,0.151282245,0.0,0.0,1.84537209,0.0,0.9075016029999999,0.7812345820000001,0.0,0.0,0.25640986,1.52187377,2.6516037,1.00041887,0.544597526,0.48746649799999997,0.0,0.0,0.141327048,0.0,1.03492997,1.29523832,0.0,0.98705325,2.28252801,0.0,0.20902903899999997,0.948799708,0.613517346,0.292765395,0.0,0.484929125,0.0,0.0,0.0,0.0,0.9143587940000001,0.0,0.0158435038,0.0,0.0,0.0,0.0,1.1067106000000002,0.179650662,1.10738194,0.0,0.0,0.0,0.0,0.0,0.401066889,0.0,0.0,0.823854193,0.0,0.51115812,0.959860495,1.18637765,0.0,2.48616575,0.0,1.39456129,0.832149536,0.0,0.0,0.08530678970000001,0.0,0.0,1.41400267,0.447222413,1.93322697,0.0,1.48485931,0.0707283679,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
0.0675307271,0.0,0.5095326729999999,0.0,0.0,0.630308851,0.0,0.0,0.307199083,0.0,0.0,0.337129392,0.470675202,0.414339963,0.0,0.0,0.359061449,0.0,0.0,0.00542172927,0.8530554920000001,0.273835916,0.0,0.5410299279999999,0.0,1.42082415,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.361054424,0.0,0.0,0.443942579,0.0,0.365090288,1.19728136,0.0,0.448818011,0.0,0.0,0.19907561399999998,0.13694368,0.0,0.686069322,0.0,0.0,0.28067965100000003,0.036332228,0.0,0.0,0.0,0.0,0.640261226,0.11676367800000001,0.478811672,0.062199431799999996,0.254463421,0.0,0.0,0.0300260541,0.0,1.14747837,0.0,0.0,0.0,0.0,0.0,0.0,0.585493225,0.0,1.70855972,0.0742013913,0.0,0.145742228,0.0,0.0,0.0663849479,0.0,0.0,0.017420286200000003,0.6638322870000001,0.0,0.373051732,0.659270317,0.0962729432,0.8471639540000001,2.37913551,1.53292704,1.29370525,1.98364401,0.602966317,0.6048283560000001,2.693998,0.584577551,0.0,0.0,0.0,0.0,0.0,0.00929509745,0.21047608399999998,0.0,0.0,0.69540501,0.7369378870000001,0.0,0.0,0.0,0.0,1.22658296,0.6624231429999999,0.0,0.0,0.0,0.0,0.273509022,0.0,0.338149025,0.0,0.526285645,0.722147875,0.0174236875,0.838848618,0.225959855,0.0,0.0,1.21818474,0.0,0.0,0.0684888413,0.0,0.508374322,0.0,0.0,0.0,0.0280882748,0.0,0.696814597,0.0,0.43785593899999997,0.782940905,0.67573652,0.0,1.60335539,0.264742309,0.460553675,0.784814283,0.0,0.126858359,0.125032941,0.238127475,0.0,0.0,0.0,0.0,0.305767639,0.0,0.146346698,0.415669499,0.205319561,0.485371334,0.0711120004,0.267636961,0.787924847,0.0,0.0,0.143621684,0.0,0.0,0.281804106,0.0169174485,1.008643,0.672654964,0.0,0.7387166490000001,0.18954083800000002,0.0,0.445105999,0.29373331199999997,0.0,0.0,0.0,0.120671825,0.649785241,0.0,0.0,0.245708827,0.489548489,0.543547778,2.06037782,0.258918616,0.0,0.0,0.0,0.0,0.823833574,0.142432775,1.70558563,1.71295756,2.17242304,2.05788126,2.40600036,3.6560326,2.92375301,2.80691088,2.2450067000000002,1.37076138,2.20940056,1.17833332,0.903408625,1.05723846,0.0,0.214443496,0.0,0.197479614,0.08904396560000001,1.62934695,1.0433373,1.7029843999999998,2.08396545,1.59505187,1.47599621,0.8314185190000001,1.89974601,0.77499914,0.783825833,0.310867862,0.0,0.336648328,1.03279908,0.0,0.535329882,0.0,0.257733194,0.0,0.255364087,0.0,0.46804761,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.426
5.77643372,2.5270519,2.43468332,1.32724774,0.0,0.709096614,0.0,0.0,0.0,0.0,0.5339501560000001,0.0,0.0,0.0,0.633422355,0.5198711460000001,0.0,0.0,0.48922015799999996,0.0,0.8761407259999999,0.0,0.618523909,0.053940552,1.21791175,1.44802859,0.0,0.0,0.0,0.6633852929999999,0.541452571,0.0,0.269638696,0.0,0.0,0.0,0.352877328,1.08328073,1.24374703,0.434380049,1.65491106,1.39768979,1.31374858,0.7065966509999999,0.9563178259999999,0.0,0.286005573,0.0,0.0,0.0,0.809359397,0.0,0.0,0.044890503600000006,0.9169714859999999,1.42381376,0.0,0.0,0.153131281,0.0,0.0,0.0,0.0,0.0,0.526289416,0.0,0.472647039,0.0,0.508317968,0.265821889,0.0,0.0,1.73088494,0.9709518,0.515879457,0.0,0.27602535,1.38784532,1.49767307,0.0,0.0,0.112798515,0.0,0.9270075390000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.757570015,0.44279698100000003,0.0,0.0,0.510201392,0.631123191,0.0,0.41185573,1.00199312,0.23982114300000001,1.03278275,0.9251532570000001,0.0,0.105251684,0.9608039979999999,0.010267179100000001,0.0,1.17552548,0.0,0.529651119,1.22741308,0.403823828,0.389575975,0.0,0.0,0.0,0.0,0.161040512,0.0,0.0,0.0,0.615845324,0.156749382,1.03798983,1.16225599,0.168154718,0.0,0.750001239,1.28797669,0.0,0.729206712,0.921107888,2.2474263999999997,2.2313367000000004,3.13831695,2.73585423,2.90148018,3.81247429,4.37357774,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43200000000000005
0.0659538542,0.0,0.0,0.0,0.0,0.14540346099999998,1.44318569,3.48348109,3.20059934,3.21990858,3.68056233,3.04580221,3.03729766,1.39496555,2.09185622,1.44629125,0.922940733,0.0,0.031279469500000004,0.0,0.194885508,0.36715331100000004,0.706652545,0.24439009899999997,0.142704329,0.0,0.34534515299999996,0.429046959,0.0,0.0,0.0,0.0,0.0270719338,0.279301173,0.7777515359999999,0.643042796,0.0,0.310601155,0.0,0.0,0.439092296,0.42358687899999997,0.0,0.0,0.243797073,0.0037057381,0.53109759,0.0,2.55921786,0.0,0.483475279,1.47056147,0.64405098,1.11543938,0.0,0.228164632,0.0,0.0,0.0,0.411418422,0.0,0.0,0.0,0.0,0.0,0.576158799,0.0,0.0,0.0,0.879945958,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42700000000000005
0.76009705,1.52760274,2.72310909,2.06673918,1.50419248,1.04960837,0.0,6.74949916,6.26767624,0.0,0.19302501,0.0,0.0,0.90238398,0.47710933,4.25862106,0.45569292,0.10164828,0.0,1.46947709,3.95608113,0.99978759,1.01895816,1.18454595,2.83964938,3.24777954,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.43799999999999994
2.7584442000000005,2.65610639,1.98146804,1.07762982,0.410630858,0.281820327,0.66182348,1.24018178,1.64026737,1.64823766,1.31081856,0.857322294,0.521546104,0.39626713399999997,0.413567707,0.444108596,0.423433306,0.403129814,0.49131463299999995,0.736526096,1.05352161,1.25658158,1.1821351,0.811730187,0.302003118,0.0,0.0,0.0,0.157920057,0.313248344,0.25984298699999997,0.050904681900000005,0.0,0.0,0.0,0.123105399,0.220012753,0.14507847,0.0,0.0,0.0,0.0,0.148322944,0.227597456,0.12943695,0.0,0.0,0.0,0.0,0.185586307,0.252140743,0.12076637,0.0,0.0,0.0,0.011929993,0.255211558,0.3128616,0.120528908,0.0,0.0,0.0,0.0705299717,0.42580629299999995,0.487274297,0.14064045,0.0,0.0,0.0,0.33739617299999997,1.6298270000000001,2.7619086,3.24919219,2.95752543,2.18144784,1.45980958,1.24325,1.62346957,2.29350429,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.42200000000000004
0.504294396,0.0,1.6181603999999998,4.59803437,1.22857361,0.0,0.09823960779999999,0.46138567700000005,2.26379,2.58330586,0.0,0.0,0.283048142,0.0,0.198788787,0.627096165,0.0,0.450397957,0.178208156,1.27046974,3.23961891,1.88215418,0.194275452,0.130652676,0.164590922,0.0,0.129583564,0.230654565,0.0232091773,0.0804597059,0.280757469,0.0,0.0,0.485569546,1.783141,1.9798900000000001,1.49313078,0.766105739,0.667579378,2.08085545,1.08046759,0.0,0.0,0.0635201192,1.03852795,2.20711771,2.22613437,0.170680776,0.0,1.19879503,1.86858351,0.351574506,0.0,0.0,0.0,0.338813336,0.111594221,0.323952949,0.0,1.20239406,3.42392575,1.5318924999999999,0.228486286,0.962981839,0.585766106,0.269215366,0.0,0.0,0.8764684159999999,0.0,0.12480198,2.02319547,1.34571897,0.0,0.541902779,0.0,0.7187722040000001,2.30350671,0.653279543,0.825297411,1.18453859,0.0,0.0,0.6334153929999999,0.0,0.25607296399999996,0.0357594413,0.0,0.0,0.304818713,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.413
0.469273579,0.0347725214,0.309156084,0.474200381,0.0,0.0696197365,0.37464897,0.0229585768,0.0,0.120066831,0.302061485,0.358018898,0.253108738,0.0,0.0,0.12178734599999999,0.0,0.14161596199999998,0.0,0.0,0.36989110399999997,0.191917367,0.0,0.0,0.0,0.464460188,0.0,0.0,0.0,0.34646495200000005,0.0332989869,0.504598847,0.609449708,0.07145810820000001,0.248219995,0.443300377,0.0128738752,0.0,0.0,0.130882414,0.0,0.17089628899999998,0.0,0.182462033,0.18408765300000002,0.339738706,0.0,0.298202377,0.0457081266,0.22456668,0.0,0.0,0.0,0.0616465444,0.0,0.0594322188,0.42079380899999996,0.242033783,0.48341855100000003,1.1975719,2.27182888,2.57048664,3.53181407,3.87810883,3.48350211,3.23048679,2.98756561,2.17676683,1.1035635,0.734932017,0.0,0.0,0.0,0.0,0.23917105,0.321625313,0.131256539,0.0,0.33678782700000004,0.0,0.158401755,0.0,0.0,0.0,0.0,0.0,0.376779125,0.0,0.0,0.0555862837,0.0,0.24316432300000002,0.272567861,0.0,0.0,0.0,0.0,0.08690876380000001,0.0,0.0836518587,0.299448714,0.14273285900000002,0.0,0.0004414948,0.052552952699999995,0.0,0.14017379900000002,0.0,0.0,0.148628838,0.0,0.42608752299999997,0.39860906100000004,0.528389652,0.39563023700000005,0.17207088199999998,0.055497850300000005,0.0211453713,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.431
