# Dataset Information
# The goal of this dataset is to predict maximum water depth for flood modelling. 
# The dataset contains 559 hourly rainfall events time series which are used to predict the maximum water depth of a domain (Digital Elevation Model, DEM).
# The rainfall events and DEM are generated synthetically by researchers at Monash University because real DEM data with accurate rainfall events are rare. 
#
# Data Donor
# Jihane Elyahyioui, jihane.elyahyioui@monash.edu
@problemname FloodModeling2
@timestamps false
@missing false
@univariate true
@equallength true
@targetlabel true
@data
1.07209151,1.83798628,3.41722248,5.77034098,8.62398119,11.5072188,13.854499100000002,15.148747400000001,15.0628674,13.555788199999999,10.8918181,7.57550114,4.22070307,1.39329589,0.0,0.0,0.0,0.0,0.0,0.50686367,0.76946633,0.6730744890000001,0.33578526299999994,0.0,0.0,0.0,0.0,0.0,0.179691823,0.303461689,0.280452266,0.137867235,0.0,0.0,0.0,0.0,0.0,0.10118271699999999,0.185486961,0.180753142,0.0963415976,0.0,0.0,0.0,0.0,0.0,0.0659129867,0.131175904,0.133908095,0.0764836897,0.0,0.0,0.0,0.0,0.0,0.0472499205,0.102597828,0.109433111,0.0665231605,0.0,0.0,0.0,0.0,0.0,0.0365895137,0.0875828715,0.09765768050000001,0.06297644690000001,0.0,0.0,0.0,0.0,0.0,0.0307730904,0.0825236005,0.0965207773,0.0660389341,0.00456211087,0.0,0.0,0.0,0.0,0.0290039988,0.089327473,0.11045756300000001,0.08060790059999999,0.0108445658,0.0,0.0,0.0,0.0,0.0333214921,0.123117885,0.16449556,0.130932242,0.0265863563,0.0,0.0,0.0,0.0,0.06893150440000001,0.36733939200000004,0.668772445,0.8916148190000001,0.974958278,0.899224563,0.692340463,0.41904221700000005,0.157277124,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0210692182,0.247943052,0.570784367,0.9233573420000001,1.22221994,1.39992309,1.43411216,1.35926752,1.25420623,1.2084895,1.28060646,1.4660488999999999,1.69142867,1.84162741,1.81360449,1.57797186,1.22302236,0.958913892,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.27399999999999997
0.07974672349999999,0.291276616,0.251993012,0.875941799,2.13316557,0.0,2.2771971,1.28314866,0.0,0.0,0.0,0.585374464,0.0,0.38669222200000003,0.404717149,0.876072727,1.0279982,0.0,0.0,0.0,0.0,0.0,1.13954605,0.9248143740000001,0.0,0.11801109800000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.52752342,0.0,0.0,0.0,1.38036881,0.477290216,0.0,0.0,0.229372682,0.0,0.0,0.20921493600000002,0.0,0.169434119,0.7554241759999999,1.3244175,0.0,0.0,0.0,0.0,0.559618346,1.31452105,0.0,0.0,0.0,1.4766794,0.425693149,0.0,1.60309314,0.0,0.68509109,0.378979743,0.0,1.8585049999999999,1.20465613,0.12880304199999998,0.695015688,0.0,0.0,1.3431122,0.0,0.772286116,0.175045924,0.0,0.0,1.03733196,0.850593238,0.656390766,1.28892349,0.9166964890000001,2.39835778,0.43209689,1.38716714,3.54338319,2.32395411,3.31253471,0.482896706,0.0,0.0,0.0,0.0,0.0,1.23664843,2.08144305,0.301253235,0.276840465,0.0,1.26355847,0.795032086,2.45650457,4.40356299,4.27218699,4.5152562000000005,2.19835315,2.49149556,1.11257592,0.203743218,1.26156216,0.004304548270000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.07644284,2.25686224,4.65896631,0.261055627,0.0,0.5151952479999999,2.13860166,1.23662156,0.0583719704,0.0,0.0,1.85544138,0.0,0.0,0.0,0.072907238,0.905063884,1.51354278,0.8337413379999999,0.0,0.294967849,0.51581198,0.9334686809999999,0.297362631,0.0,0.0,2.08370956,0.725339869,0.0,0.0,0.0,3.85500159,1.01807438,0.0,1.15916096,1.11125397,0.0,1.0295450000000002,0.0323774389,0.0,0.0,0.0,0.0,0.8420189240000001,1.50882122,2.41501284,0.0,0.0,1.49998694,2.00608717,6.531757700000001,5.01460754,3.24002923,1.77782124,0.0,0.113008378,2.97302354,0.8325644590000001,0.0,0.7396211159999999,0.0,2.05893934,0.0,0.957065072,0.0,0.0,2.0496467000000003,0.0,3.32171556,1.80128092,0.0,0.431810518,0.0,0.0,0.952177158,0.102354875,0.0,2.64248784,1.20507952,0.0521624922,3.22637226,0.0,0.4704969,0.0,0.0,0.0,0.0583737725,2.66578868,2.61351287,0.0,0.38900253700000004,0.0,0.428096993,0.0,0.0,0.654326938,0.0,1.55062611,0.0,0.0,0.756708877,4.06114598,2.26358319,5.08444475,0.417680186,0.0,0.0,0.0,1.95678671,2.64538995,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.95086938,2.4201632,2.50032189,2.05320282,1.48308491,1.63382127,1.99562865,2.27425479,2.23214988,2.90224171,3.26911725,3.53782423,4.38642482,4.10902387,3.64864601,2.61037612,1.80370395,1.49362794,0.8782410420000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.34764689299999996,0.427540284,0.47617043600000003,0.8631124509999999,0.565521199,0.0392382677,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.519108789,0.0944720852,0.614341495,0.30292732,0.303407501,0.0,0.0,0.042336600700000004,0.0,0.0,0.0,0.0,0.0,0.14736976599999999,0.0,0.22427502300000002,0.0,0.0,0.0,0.0,0.08546756949999999,0.0,0.0,0.0,0.0,0.0336609055,0.0,0.23448816,0.0,0.497686012,0.471389324,0.0,0.0,0.0,0.0,0.0,0.0,0.041591573199999995,0.19973869600000002,0.0,0.0,0.0,0.138327494,0.308262663,0.168238638,0.0,0.0,0.0,0.0,0.0,0.178596822,0.333190035,0.454333414,0.601592286,0.680241987,0.0386551111,0.429612328,0.291521984,0.0,0.0,0.0,0.0,0.21155202,0.284501816,0.6922858470000001,0.846966815,1.08019442,1.03526,1.77829282,1.20150278,1.39259484,1.73852782,1.64022702,1.15866153,0.76536656,0.69698723,0.96118227,0.7448542979999999,0.6265469229999999,0.323042189,0.568853501,0.352990268,0.332252865,0.291175941,0.818367238,0.599149806,0.8256886379999999,0.711754517,0.681126144,1.35007375,1.63721622,1.69765382,1.95353315,2.343322,2.07815841,2.38072656,1.36171191,1.45773458,1.06836144,0.488075498,0.019274195,0.0,0.6859055270000001,0.782274015,0.97911325,1.51402965,2.41199233,3.02005727,3.4280291,3.62682413,3.79957128,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.54319153,1.23752553,1.04411195,1.03553943,1.18793177,1.40587695,1.57264337,1.60082261,1.46262492,1.19115234,0.857613008,0.538492934,0.288059876,0.126057108,0.0418019837,0.00861028307,0.0,0.0,0.0,0.0,0.0,0.00496242369,0.00904340245,0.00838649544,0.002609189,0.0,0.0,0.0,0.0,0.00349416932,0.00909704041,0.00951732144,0.00502991513,0.0,0.0,0.0,0.0,0.0,0.00271008288,0.00294568465,0.0014771312699999998,0.000123925789,0.000217724778,0.00153040122,0.00245105171,0.0013056484199999998,0.0,0.0,0.0,0.0,0.00258740541,0.00996932548,0.013116302199999999,0.00903364812,0.0,0.0,0.0,0.0,0.0,0.014507208,0.0248411565,0.022415199900000002,0.006969707209999999,0.0,0.0,0.0,0.0,0.0119837185,0.0340419562,0.0393029871,0.0232006545,0.0,0.0,0.0,0.0,0.0,0.0369836407,0.05662623,0.046634976200000004,0.0101121763,0.0,0.0,0.0,0.0,0.0298420987,0.0706346826,0.0757394244,0.0395703217,0.0,0.0,0.0,0.0,0.00830265933,0.0769087687,0.10873965599999999,0.0832684605,0.00973440578,0.0,0.0,0.0,0.0,0.0698052714,0.14555943300000002,0.14821497,0.068560649,0.0,0.0,0.0,0.0,0.0400869952,0.216606295,0.32692561800000003,0.31821445600000003,0.194901577,0.0196668726,0.0,0.0,0.0,0.137137196,0.27488160300000003,0.279581304,0.115555003,0.0,0.0,0.0,0.0,0.180993497,0.792021677,1.34546252,1.66500089,1.68803352,1.51504438,1.38766249,1.59708044,2.35641399,3.68969839,5.3871897,7.051680999999999,8.22365926,8.53989644,7.8648253,6.34356272,4.35589776,2.38924196,0.87939554,0.0785723511,0.0,0.432326828,1.07099971,1.61172411,1.86773989,1.80980036,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.231
0.6989885090000001,0.533035617,0.296054735,0.17509144899999998,0.280959195,0.5578602,0.804512552,0.8080169909999999,0.505363598,0.0499391876,0.0,0.0,0.0,0.230423968,0.28091504100000003,0.05923325769999999,0.0,0.0,0.0,0.245541934,0.35162907200000004,0.10659360000000001,0.0,0.0,0.0,0.362504933,0.612980679,0.250758963,0.0,0.0,0.0,1.10479338,3.13456205,4.46598171,4.32069641,2.79432242,0.782708451,0.0,0.0,0.0,0.327144368,0.585225662,0.308087029,0.0,0.0,0.0,0.12187719699999999,0.260881345,0.141662701,0.0,0.0,0.0,0.053567257,0.127541226,0.0665421261,0.0,0.0140828028,0.19280245899999998,0.39762630299999996,0.478758178,0.398600681,0.26356666,0.218127975,0.30537507,0.426164958,0.43279105700000003,0.267969595,0.0216331183,0.0,0.0,0.0197313699,0.15873991,0.16695586099999998,0.0467658068,0.0,0.0,0.126892345,0.42609901200000005,0.6612949929999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.452250879,0.177266652,0.011351639299999999,0.129568729,0.0,0.19001607,0.0776398909,0.14399911,0.0,0.116214272,0.0,0.126089854,0.0,0.166747313,0.0,1.91604831,2.04166774,0.10840435,0.0,0.0502263733,0.0,0.0426489695,0.0,0.0312762142,0.0,0.00827706249,0.0131109646,0.0,0.512710266,0.357491455,0.118623885,0.8232529270000001,1.16126789,0.38255511,0.0,0.089123706,2.22315258,7.59075354,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.36752417,0.0,0.0,0.78168782,0.0,0.50859978,0.0,0.0,0.48682902,0.85488672,0.0,0.64671138,1.42694184,0.66328952,0.0,0.14161347,0.66940732,0.20614275,0.83460338,0.0,0.35137163,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.89526588,0.94196862,0.0,0.0,0.703786,0.0,0.77506793,1.06949616,0.11291177,0.0,1.97571247,0.69313058,1.49630061,0.0,1.16105148,0.77006965,0.20977751,0.70298919,0.0,1.87556006,0.0,0.0,0.0,0.0,1.18462498,0.95435404,0.0,0.0,0.0,0.0,1.44785879,0.0,0.91480506,1.6831153000000003,0.48024485,0.0,0.54943732,1.34989675,0.0,0.0,3.26853791,2.68036378,1.50336829,1.88988741,0.0,0.0,0.96879721,0.25225669,0.0,0.0,0.11256685,2.64156794,4.70863052,3.75022724,5.44365584,2.05204774,0.0,0.0,0.0,0.92606971,1.18274054,0.11403774,0.0,0.79507145,0.0,0.43309368,0.0,0.0,0.0,1.05144228,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.60441588,0.28748581,0.0,0.70187459,0.0,0.0,0.0,1.78573077,0.0,0.89414882,0.17776624,0.42220947,0.69251246,0.0,1.45709946,0.0,0.97630226,0.0,0.0,0.0,0.0,0.72273128,0.0,2.64061191,0.0,0.0,0.0,0.24889811,0.0,0.0,0.0,0.97799863,0.0,0.63228556,0.0,0.64652137,0.0,0.82008887,0.41166782,0.0,0.44746697,0.0,0.75456718,2.12758951,0.44942802,0.48964671,1.51328951,1.59775683,2.03752347,0.21141489,0.0,0.65663091,0.74147951,3.64803268,0.68837477,3.32674504,2.38052672,3.20453276,0.31244023,1.68521031,0.77378203,0.10109951,1.11499459,0.0,1.14339574,0.28935043,0.0,0.0,0.66661926,2.24209328,2.14988317,3.0543826000000003,0.4373073,0.0,0.0,1.05205062,0.98512033,0.0,0.0,0.97467323,0.0,0.54224759,1.1560928,0.0,1.70720183,1.08637055,0.0,3.57480259,2.75784349,1.15274373,0.81749224,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.30666419,0.0,0.16745693,0.0,0.0,0.57826844,0.74517928,0.0,0.09308761,0.09502460000000001,0.0,0.28804744,0.0,0.38390032,0.0,0.31768841,0.0,0.0,1.1812768999999999,1.04731856,1.02359416,1.91366354,0.82541557,2.24228602,2.46911644,3.17729561,1.15906707,0.25451646,0.0,0.09274253,0.82623265,0.26825631,0.65717907,0.0207289,0.0,0.0,0.0,0.0,0.15331009,0.74136452,0.0,0.0,0.0,0.04300191,0.0,0.0,0.07963849,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18627765300000002,0.524776902,0.00487583434,0.0734048705,0.0,0.0,0.158282899,0.39971334399999997,0.208134195,0.015981484599999998,0.0,0.0278041011,0.301144465,0.0,0.199167409,0.197084245,0.20744230800000002,0.0,0.36115881299999997,0.293284022,0.121296885,0.0,0.0045037788,0.0,0.0,0.0,0.17182682800000001,0.153312629,0.0212681507,0.458095452,0.0,0.140570633,0.480214708,0.447497892,0.00383694119,0.21932687399999998,0.0,0.0,0.127973234,0.42750075200000004,0.105830791,0.0663779397,0.40430728299999996,0.132968389,0.327708507,0.0,0.0,0.4501589,0.726738635,0.157215924,0.566093516,0.5858945010000001,0.6831438879999999,0.481009323,0.967046558,1.03105087,0.9050805740000001,0.941405108,0.7517854840000001,1.00974389,1.03993774,1.12677047,0.895149102,0.79476049,1.12009855,0.949265409,0.59032322,0.7445415390000001,0.893475218,1.03369552,0.46665273700000004,0.880673114,0.40194057200000005,0.473664717,0.5431666629999999,0.998636003,0.981537144,1.27881568,1.01456357,1.06635422,1.40882897,1.51108524,1.30375498,1.60047593,1.5558919,2.26324082,1.82635381,2.672863,2.63538431,2.55336285,3.2209835,3.1793767999999996,3.11047054,3.64534784,3.26406881,3.36432023,3.36516829,3.43156889,3.49725088,3.48042268,3.37018408,3.50529743,3.67833338,3.45921191,3.82866304,3.1967227000000005,3.34796396,3.05941927,2.86187764,2.53550877,2.96124334,2.64528206,2.39226939,1.90136278,2.27234825,2.20561584,1.69994787,2.03149019,1.90634979,1.30554023,1.1423345,1.54154757,1.03931605,1.27940555,0.8021744670000001,0.780253715,0.7030716309999999,0.891706088,0.949508858,0.674827071,0.9699339509999999,0.918176133,0.378368493,0.526591571,0.21830613,0.15850430199999999,0.12537045800000002,0.216914372,0.0879372708,0.020540789099999998,0.386900229,0.00612475924,0.0535646841,0.0,0.0,0.0,0.386089798,0.165936817,0.27518304,0.1454557,0.0377563453,0.156118844,0.11782259699999999,0.692639743,0.429624241,0.536052602,0.19846593699999998,0.283193448,0.67321068,0.34126245899999996,0.659951651,0.6091050929999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.16168645,0.0,0.53844096,0.09497288,0.0,1.13283686,0.0,0.88458763,1.1154979,0.0,1.66233723,0.20759595,0.0,0.0,1.50981518,0.0,0.13404384,0.0,0.36150937,0.87348735,0.81517753,1.5789076000000002,1.30615862,0.91775651,1.47164635,0.82252048,0.0,0.23534635,0.0,1.17203366,3.65620037,3.14900286,2.65880942,0.14865196,0.0,0.0,0.68040229,2.44824752,0.35511352,0.0,1.24930704,0.29144429,0.0,0.20967027,0.65083539,0.0,0.0,0.0,0.0,0.0,0.0,0.83686868,0.0,0.55068996,0.52665929,0.0,1.46604403,1.7134833999999999,0.0,0.0,0.8399416999999999,0.0,0.0,0.94408304,0.0,0.90153584,0.0,0.98826284,0.0,0.0,0.59532343,0.32758550000000003,0.44195476,0.70306813,0.07574809,0.33893076,0.62952219,0.0,0.0,0.77266086,1.82269659,2.52202,2.51537935,1.19929177,0.4485638,0.43445661,0.28916086,0.35200341,0.0,0.0,0.0,0.0,0.0,0.33833111,0.33084258,0.18704278,0.29038659,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0905199858,0.0789979382,0.0490194322,0.007996861329999999,0.000991277563,0.0524899366,0.136809091,0.19556541800000002,0.18294485800000002,0.100654215,0.0,0.0,0.0,0.0,0.0476038902,0.09105743470000001,0.09889769970000001,0.0818465713,0.0558754862,0.0278275105,0.0,0.0,0.0,0.058048120700000004,0.230429467,0.484440534,0.764818309,0.9968501790000001,1.12394433,1.13698322,1.07746156,1.01329183,1.00258519,1.06601456,1.18079652,1.29590479,1.35808958,1.33618637,1.23509272,1.09586347,0.981938278,0.9545324620000001,1.0444848,1.2322693999999998,1.44815423,1.59709586,1.59978337,1.43007898,1.12852795,0.783917712,0.493071909,0.32119173,0.282872261,0.34934733,0.471327299,0.6003761870000001,0.698393577,0.737403228,0.699354448,0.582130116,0.40761841200000004,0.220979581,0.07451852469999999,0.0023555233899999997,0.00255491253,0.041402676,0.07971242469999999,0.103993893,0.139688322,0.235082132,0.42541495100000004,0.701689406,1.00629447,1.25925339,1.39812383,1.40635275,1.31442915,1.17730391,1.04565622,0.948276445,0.89073262,0.8630210079999999,0.8461259109999999,0.814679873,0.7413516490000001,0.608737979,0.425413749,0.23325050600000002,0.0939829499,0.0567294954,0.125146402,0.248433226,0.347190546,0.36071519799999996,0.28473410600000004,0.172594599,0.09764020429999999,0.10260027599999999,0.172056961,0.247699925,0.27448987,0.242593523,0.193019832,0.1825596,0.235185509,0.318265316,0.36364885700000005,0.319295218,0.192712921,0.0521309765,0.0,0.025673935499999998,0.153120214,0.284774961,0.348014294,0.328872061,0.27861181399999996,0.269514552,0.33236997100000004,0.42389921799999997,0.45302601200000003,0.35303559999999995,0.151131475,0.0,0.0328444418,0.425511236,1.13535293,1.96744321,2.63160048,2.87467667,2.60240069,1.92562822,1.10606745,0.43060743700000004,0.0809666589,0.0658025943,0.24604749,0.43210128700000006,0.49336166200000003,0.41787127399999996,0.29330264699999997,0.22936067,0.276008121,0.390806166,0.47357790200000005,0.440914955,0.28717582399999997,0.08985677269999999,0.0,0.0,0.09210671990000001,0.296852623,0.530102622,0.8119043229999999,1.22031315,1.82311755,2.5926869999999997,3.36858195,3.90596931,3.99120317,3.55777038,2.73042276,1.76803237,0.938496558,0.39987130600000004,0.154136116,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.15551035,0.08815747,1.19605228,0.98384988,0.0,0.03871512,0.0,0.31018279,0.0,0.13216246,0.3019196,0.23582575,0.0,0.0,0.62411173,0.77307651,1.66327088,1.88831711,2.45946416,2.72505862,3.53865817,2.28309322,3.62563999,4.21643641,3.80233348,2.44038276,2.30117601,3.48184004,3.99600662,3.24155441,4.15682777,2.58475575,2.87590527,2.61998294,1.32879827,1.7721028000000003,1.94757605,1.85501631,1.11528803,1.13684747,1.38530219,0.6198154,0.91045035,2.62727431,1.35029641,1.62195635,0.92413785,1.83690168,0.83735182,3.07349759,1.83444482,2.27590454,2.49406027,1.91890642,1.83159869,2.39895307,2.09912699,1.01305274,0.26232194,2.16744503,1.45398613,0.0,1.48653255,0.0,0.67078547,2.33680453,0.0,0.0,0.18135237,0.0,0.0,0.01060724,0.44392494,0.72571306,0.29951045,0.0,1.7116212,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.8491311e-15,9.526725799999999e-16,0.0,0.0,1.45303791e-14,4.99714067e-16,3.29988415e-16,0.0,0.0,0.0,2.85124172e-16,2.25636794e-16,0.0,0.0,0.0,2.03955412e-16,1.82261848e-16,0.0,0.0,0.0,1.60900164e-16,1.58284242e-16,9.58295069e-18,0.0,7.26518954e-16,1.33962184e-16,1.42922838e-16,2.38078366e-17,0.0,0.0,1.15334418e-16,1.32133534e-16,3.3944734200000004e-17,0.0,0.0,1.01545266e-16,1.24057131e-16,4.1613045299999994e-17,0.0,0.0,9.08148692e-17,1.1771870300000001e-16,4.7680017399999994e-17,0.0,0.0,8.2135521e-17,1.12557135e-16,5.2652595899999997e-17,0.0,0.0,7.489297840000001e-17,1.0822606000000002e-16,5.6847497e-17,0.0,0.0,6.86906028e-17,1.04499545e-16,6.04733361e-17,0.0,0.0,6.32599448e-17,1.0122337299999999e-16,6.3673677e-17,2.46057873e-18,0.0,5.84119216e-17,9.82881219e-17,6.65511211e-17,7.02771391e-18,0.0,5.40085658e-17,9.56134127e-17,6.91815363e-17,1.12158671e-17,0.0,4.99458564e-17,9.31382547e-17,7.162285820000001e-17,1.5114198e-17,0.0,4.6142826299999994e-17,9.08148692e-17,7.39207655e-17,1.87934615e-17,0.0,4.25343695e-17,8.86045788e-17,7.6112488e-17,2.23117245e-17,0.0,3.90662956e-17,8.647495670000001e-17,7.82294693e-17,2.5718398500000002e-17,0.0,3.5691775399999997e-17,8.439775840000002e-17,8.02993198e-17,2.90572283e-17,0.0,3.23686463e-17,8.234733349999999e-17,8.234733349999999e-17,3.23686463e-17,0.0,2.90572283e-17,8.02993198e-17,8.439775840000002e-17,3.5691775399999997e-17,0.0,2.5718398500000002e-17,7.82294693e-17,8.647495670000001e-17,3.90662956e-17,0.0,2.23117245e-17,7.6112488e-17,8.86045788e-17,4.25343695e-17,0.0,1.87934615e-17,7.39207655e-17,9.08148692e-17,4.6142826299999994e-17,0.0,1.5114198e-17,7.162285820000001e-17,9.31382547e-17,4.99458564e-17,0.0,1.12158671e-17,6.91815363e-17,9.56134127e-17,5.40085658e-17,0.0,7.02771391e-18,6.65511211e-17,9.82881219e-17,5.84119216e-17,0.0,2.46057873e-18,6.3673677e-17,1.0122337299999999e-16,6.32599448e-17,0.0,0.0,6.04733361e-17,1.04499545e-16,6.86906028e-17,0.0,0.0,5.6847497e-17,1.0822606000000002e-16,7.489297840000001e-17,0.0,0.0,5.2652595899999997e-17,1.12557135e-16,8.2135521e-17,0.0,0.0,4.7680017399999994e-17,1.1771870300000001e-16,9.08148692e-17,0.0,0.0,4.1613045299999994e-17,1.24057131e-16,1.01545266e-16,0.0,0.0,3.3944734200000004e-17,1.32133534e-16,1.15334418e-16,0.0,0.0,2.38078366e-17,1.42922838e-16,1.33962184e-16,7.26518954e-16,0.0,9.58295069e-18,1.58284242e-16,1.60900164e-16,0.0,0.0,0.0,1.82261848e-16,2.03955412e-16,0.0,0.0,0.0,2.25636794e-16,2.85124172e-16,0.0,0.0,0.0,3.29988415e-16,4.99714067e-16,1.45303791e-14,0.0,0.0,9.526725799999999e-16,2.8491311e-15,103.54700799999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.408
0.0201778379,0.392276445,0.289296213,0.11590029,0.175574244,0.0,0.19767691,0.29578186,0.350351209,0.18129431399999998,0.0,0.27884396100000003,0.147557361,0.40548430799999996,0.0,0.0,0.122140803,0.0,0.7431424329999999,1.25276491,0.5218026729999999,0.273830963,2.40031846,3.94258863,1.97858278,0.0,0.329865025,1.63080212,0.20228038399999998,0.0,0.0,0.45093429700000004,0.117023616,0.0,0.29309632,0.0,0.0,0.416202685,0.0,0.252878686,0.29761767699999997,0.0,0.0,0.0,0.44687085299999996,0.12257294,0.0,0.24251481,0.0,0.0,0.33848424899999996,0.0,0.0,0.277625755,0.879082762,1.28748184,1.15850654,0.406876416,0.5151238229999999,0.56718848,0.7823735209999999,0.712244402,0.617789543,0.733963732,0.331830151,0.0,0.0,0.153860409,0.166648472,0.0,0.279676007,0.8161688140000001,1.05748137,0.7487116509999999,0.0802244429,0.245782917,0.10617640099999999,0.165634397,0.0,0.366786489,0.0,0.0,0.0754486538,0.0,0.0,0.16066623800000002,0.482105009,0.419444456,0.0,0.542733366,0.0952638023,0.18587100199999998,0.619967289,0.5322554970000001,0.847944156,0.45800613,0.7864559190000001,0.585727125,0.9102810020000001,0.655774235,0.9846239940000001,2.01350773,1.96303919,1.07506511,0.552935414,0.568899603,0.382417192,0.100772225,0.6658827589999999,1.67871777,1.28796601,1.56108131,2.99754261,2.40852262,1.67240829,1.09578577,0.5068611789999999,0.446796806,2.33784578,3.50484851,2.94209609,0.227070699,0.51053637,1.74440336,1.042485,0.7101444640000001,1.49661138,2.12305233,1.40399292,0.819661495,0.6912624909999999,0.0751416111,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45211054,0.0,1.70680007,2.9803203999999996,5.41220066,3.50960325,0.97313586,0.0,0.0,0.0,0.0,0.0,0.0,0.23970434,0.17787309,0.66741525,0.97207777,0.0,0.02149895,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.07890336,0.37109249,0.5327964,1.67957047,0.4059483,2.00195881,2.15146688,2.89955432,2.50743885,2.58227648,3.2879205999999996,2.50753533,2.92214097,3.0149154,2.08070061,2.27239929,1.69909723,1.66442105,1.77871591,0.58275757,1.06481011,0.44927227,0.95552634,0.58889987,0.0,0.0,0.73263755,0.0,0.0,0.0,0.0,0.08297712,0.0,0.24803651,0.0,0.0395275,0.0,0.54433138,0.05910459,0.19535357,0.30600888,0.0,0.96659792,1.16486061,0.0,0.0,0.15818566,0.0,0.16387751,0.5424011,0.21479046,0.87775713,1.15972329,0.0,0.0,0.0,0.0,0.0,0.0,0.22799452,0.42626361,0.0,0.0,0.44374393,0.19309517,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18634388600000001,0.203252337,0.24901277100000002,0.31399988,0.373772426,0.39823429899999996,0.364561491,0.268463917,0.128708828,0.0,0.0,0.0,0.0,0.0,0.0809553675,0.172469087,0.20421978699999999,0.167233823,0.082254467,0.0,0.0,0.0,0.111003158,0.304341327,0.5147268770000001,0.683382305,0.761838927,0.727774099,0.5915421710000001,0.391476779,0.18018414100000002,0.00715394472,0.0,0.0,0.0,0.0,0.027148696400000002,0.058512792699999996,0.0574136885,0.0316742023,0.0,0.0,0.0,0.0,0.0,0.012404417,0.0237129406,0.0225991215,0.0115732302,0.0,0.0,0.0,0.0,0.0,0.0067799971,0.011420528400000001,0.0102068045,0.00460226851,0.0,0.0,0.0,0.0,0.0,0.0033678590999999996,0.0049357136200000006,0.0039772131700000005,0.00146405568,0.0,0.0,0.0,0.0,2.68371708e-05,0.000687723222,0.000599985427,0.000157254741,0.0,0.000251808459,0.000913535183,0.00134796467,0.00100036391,0.0,0.0,0.0,0.0,0.0,0.0019091447199999997,0.00399344118,0.0042994141,0.0023839102,0.0,0.0,0.0,0.0,0.0,0.00331757009,0.00540310635,0.00444307944,0.0014383852599999998,0.0,0.0042812096000000004,0.019422793799999997,0.0474678092,0.0875742787,0.13650553099999999,0.191003316,0.25109087199999996,0.323042441,0.42070383899999997,0.564333623,0.776975915,1.07923478,1.48384911,1.9914678,2.58853801,3.24749808,3.92885467,4.58447884,5.16162462,5.60756486,5.87502323,5.92847479,5.7508193,5.34912116,4.75749284,4.03523003,3.25922122,2.5113056,1.86310699,1.36219378,1.02356764,0.82922452,0.736165222,0.69054223,0.643597521,0.564463189,0.446033345,0.30258392300000003,0.160704273,0.047326450199999995,0.0,0.0,0.0,0.00152338915,0.0262661618,0.0351491777,0.026731526499999998,0.00786507873,0.0,0.0,0.0,0.0,0.0032300067,0.024324936000000002,0.053423654400000006,0.0964510834,0.15842908,0.23858190399999998,0.32718624399999996,0.406304331,0.45484089,0.45627513700000005,0.405916664,0.314377748,0.205318269,0.107881508,0.0465884858,0.0327327476,0.060883592699999996,0.11206711400000001,0.16237748400000002,0.193387118,0.19984522600000001,0.191229122,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.09146266,0.0,0.0,0.85543172,0.0,1.46384097,1.52177579,5.05203574,5.01773016,7.0499135,8.26343656,10.41751255,5.98259669,4.58800638,4.956934400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.55317367,1.29389253,0.0,0.0,0.0,0.37420093,1.53934211,0.0,1.17045131,0.0,0.0,1.39095082,1.5134027,0.0,0.83555106,0.0,0.10747599,0.0,0.0,1.82105081,1.74491721,0.51120599,0.0,0.0,0.0,2.87863345,0.0,1.30495208,0.0,0.0,1.29672887,0.0,0.0,0.0,2.54926429,0.0,0.88514223,0.0,2.01141498,0.62333997,0.71594007,0.22797233,0.0,2.24787676,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23199999999999998
0.00027682343999999997,0.00878628525,0.0676009233,0.154187493,0.23920448800000002,0.294401729,0.300296145,0.251776613,0.160362093,0.0526657204,0.0,0.0,0.00640250407,0.19121892100000001,0.49705314799999994,0.907384002,1.38576499,1.87983589,2.32827324,2.66990031,2.85379972,2.84894103,2.65163363,2.28915429,1.81828117,1.3182273000000002,0.878532113,0.58364404,0.49692511899999997,0.647327468,1.02180533,1.56557117,2.19072353,2.79190634,3.26596119,3.53146073,3.54388482,3.30310631,2.85160119,2.26396238,1.63032487,1.03767708,0.5533853,0.21451779399999998,0.024940594,0.0,0.0,0.030484500299999998,0.0786456457,0.0976930206,0.0811946333,0.0380626666,0.0,0.0,0.0,0.0,0.0,0.0,0.0334724749,0.0518793522,0.0510034791,0.0335393095,0.0073562813500000004,0.0,0.0,0.0,0.0,0.0,0.0075438345999999995,0.0195366221,0.022994774500000002,0.0182717248,0.008560492890000002,0.0,0.0,0.0,0.0,0.0,0.0,0.00102678675,0.0,0.0,0.0,0.0,0.00376562158,0.010589888700000001,0.015510610900000001,0.0151793181,0.00788435148,0.0,0.0,0.0,0.0,0.0,0.00235632701,0.029282345699999997,0.050948580800000004,0.0575783846,0.0430462263,0.00801289137,0.0,0.0,0.0,0.0,0.0,0.0977178439,0.241564852,0.391315556,0.517783263,0.594666488,0.605455332,0.548082036,0.435934328,0.294836554,0.156722495,0.051650305,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8601877529999999,0.0498989129,1.13362735,0.657296146,0.0,0.0,0.46497612200000005,0.698370134,0.19300586100000003,0.0,0.45012663700000005,0.5169038539999999,0.158740536,0.529317058,0.279779653,0.0,0.133366419,0.0,0.0,0.237220132,0.0,0.0,0.0,0.82420256,0.180540122,0.0,0.266120481,0.0,0.0,0.603993221,0.557705978,0.600906195,0.332472845,0.0,0.228022387,0.320167541,0.0,0.0,1.14351294,0.122518725,0.0,0.705716097,0.156596898,0.7937798309999999,0.0,0.591752019,0.009158295129999999,0.356073753,0.0,0.5993154070000001,0.0,0.0,0.0,0.0,0.7107734040000001,1.45562619,0.0,1.25235593,0.0,0.510363384,0.712113199,0.9377726009999999,0.0,0.357508492,0.0,0.1064288,0.0,0.837702417,0.0,0.568970265,0.0356487154,0.0,0.246319467,1.16900605,0.45102666399999997,0.60838045,0.128672437,0.0,0.0933100534,0.0,0.0,0.0,0.0,0.056926915300000006,1.14748422,1.27006148,1.51416678,2.02615078,2.20128612,1.49183991,2.34862108,2.52488892,2.49440025,2.82863221,3.10568179,1.74730974,0.659028517,0.719179465,0.0467599326,0.0,0.0,0.0,0.0,0.0,0.337331327,0.798316769,0.8849593170000001,0.0290461742,0.23285784,0.343687088,0.0,0.524166435,0.339134812,0.454966851,0.588507064,0.0,0.0,0.12268921,0.0,0.448522597,0.0,1.31442737,0.0683946443,0.301473916,0.404920061,0.36998695299999995,1.02158338,0.626323231,1.58869538,0.43795155,0.79597688,0.445837982,0.0,0.406358768,1.2533101999999998,1.36246077,1.8840814,0.64638071,1.05620484,0.27352989,0.683183368,1.17163263,0.976644634,0.435736329,1.07350826,0.0,1.1870236,0.0,0.748665618,1.3810973,0.166390324,0.72863121,1.18353681,0.630434685,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0575283063,0.14578202,0.225748681,0.295481381,0.3534467,0.39854654,0.430126766,0.447972854,0.452293159,0.44369070200000005,0.423124745,0.391863635,0.35143063399999996,0.303544604,0.250057512,0.19289075100000003,0.133972239,0.0751761956,0.0182673305,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0115754348,0.0322407183,0.0491967433,0.0621329159,0.07092759530000001,0.0756436488,0.0765170739,0.07393928400000001,0.0684338723,0.06062884650000001,0.0512254792,0.040965018,0.0305945619,0.020833425200000002,0.012341273,0.005689237979999999,0.00133510684,0.0,0.000671817053,0.004562378529999999,0.011141208100000001,0.020123348200000002,0.0310846017,0.043479233,0.0566629711,0.0699204544,0.0824960857,0.0936271322,0.102577808,0.10867303,0.111330536,0.110090088,0.10463858,0.0948299976,0.0806993526,0.062469898899999994,0.0405531967,0.015541814499999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0506223976,0.103604747,0.157278993,0.20985092600000002,0.25945337399999996,0.304204343,0.342268409,0.37191956,0.391603539,0.39999771700000003,0.39606652200000003,0.379110546,0.348807561,0.305243877,0.248934735,0.180832689,0.10232329,0.015207721,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.015704533200000002,0.21746385,0.43688904700000003,0.670460074,0.914206326,1.16379153,1.41461019,1.66189337,1.90082107,2.12663857,2.33477359,2.5209513,2.68130415,2.81247355,2.91170054,2.97690309,3.00673765,3.00064326,2.9588667,2.88246791,2.77330522,2.63400045,2.46788475,2.27892607,2.07164014,1.85098701,1.62225559,1.39093912,1.16260456,0.9427592659999999,0.736718275,0.5494755339999999,0.38558239200000005,0.24903645,0.143183611,0.0706358518,0.0332068376,0.0318670427,0.0667195307,0.13699703300000002,0.24108040100000003,0.376537964,0.540184777,0.728160253,0.936022165,1.15885463,1.39138729,1.62812267,1.86346846,2.09187136,2.30794911,2.50661743,2.68320865,2.83357915,2.95420298,3.04224941,3.09564266,3.11310243,3.09416439,3.03918046,2.94929902,2.82642576,2.67316665,2.49275442,2.28896095,2.06599781,1.8284078000000001,1.58095036,1.32848391,1.07584814,0.827749385,0.588651864,0.362677487,0.153516711,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.232068026,0.0,0.32665765199999997,0.0,0.0,0.143689551,0.322068862,0.455796983,0.0418720857,0.98086425,1.17818604,3.03975444,2.61219464,2.73519619,2.01722234,0.162831751,0.0,0.0,0.0,0.721132138,2.83222037,4.67130363,5.52602871,5.88715831,5.21666078,3.76326317,1.71717552,0.54385517,0.0,0.10738615900000001,0.41001812299999996,1.1743673000000001,1.42141691,1.26610032,0.20055064,0.0,0.0,0.0,0.0,0.437329687,0.0193040468,1.02579751,0.7883590109999999,0.52725026,0.0,0.0,0.0,0.466811779,0.19915033,0.606365874,0.0596358563,0.43159370399999997,0.0,0.314915336,0.118108629,0.127678127,0.0,0.5547384160000001,0.0,0.0,0.226708543,0.135598759,0.316579609,0.0,0.0104753617,0.444495889,0.0,0.296951602,0.0,0.0,0.27042130600000003,0.0,0.48564086100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.747355914,0.20143203399999998,0.0,0.0,0.0,0.0549791554,0.411482946,0.634123742,0.604652504,0.310605227,0.0,0.0,0.0,0.0,0.0,0.273141598,0.8023825809999999,1.04866878,0.874583239,0.300011863,0.0,0.0,0.0,0.0,0.0,1.01905793,2.36915825,3.34740295,3.64474039,3.17295329,2.11571705,0.8882339859999999,0.0134964104,0.0,0.944367664,2.90813309,5.44565428,7.94452205,9.75322306,10.3732086,9.60728039,7.61739864,4.87428962,2.01610494,0.0,0.0,0.0,0.0,0.0,0.52565823,1.23001654,1.36988118,0.973231188,0.25706665100000003,0.0,0.0,0.0,0.0,0.0,0.44351895,0.776591615,0.7811201190000001,0.480921803,0.0147028578,0.0,0.0,0.0,0.0,0.0500573969,0.41206145899999996,0.592247472,0.529444819,0.26059292300000003,0.0,0.0,0.0,0.0,0.0,0.136815645,0.39437237,0.485733775,0.380589953,0.127413504,0.0,0.0,0.0,0.0,0.0,0.195201505,0.38200321299999995,0.411393644,0.275408137,0.032170945,0.0,0.0,0.0,0.0,0.00766997267,0.239844771,0.37191014899999997,0.352460483,0.191550964,0.0,0.0,0.0,0.0,0.0,0.0784678511,0.277212736,0.362484425,0.300830442,0.11815325300000001,0.0,0.0,0.0,0.0,0.0,0.142742654,0.31048459300000003,0.352280652,0.251388029,0.048707858799999997,0.0,0.0,0.0,0.0,0.0,0.204277323,0.340286332,0.338596706,0.199438566,0.0,0.0,0.0,0.0,0.0,0.0565211871,0.260146996,0.35738304200000004,0.308838317,0.135728582,0.0,0.0,0.0,0.0,0.0,0.236866262,0.40726929,0.43149222600000003,0.299059142,0.0713762854,0.0,0.0,0.0,0.291965886,0.778202533,1.24367679,1.53210551,1.53744795,1.24637008,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.242
0.160009226,0.151031262,0.147865724,0.153610144,0.167183064,0.183701709,0.19641919600000002,0.19952490899999997,0.190766692,0.17288942,0.153295725,0.141977916,0.148413891,0.178526873,0.232822152,0.306416292,0.390997575,0.478038876,0.56208695,0.642865992,0.7253074829999999,0.817337903,0.9260770909999999,1.05373257,1.19468396,1.33494175,1.45442067,1.53153012,1.54876919,1.49760945,1.38110691,1.21337218,1.01602387,0.812724186,0.623515387,0.460722571,0.32763783399999996,0.220235025,0.131112798,0.054094002300000006,0.0,0.0,0.0,0.0,0.0,0.00718602429,0.0835060767,0.153403283,0.197223464,0.202389563,0.16880759899999997,0.110698705,0.053748064500000005,0.027981283500000002,0.058294016500000004,0.15555049,0.311254375,0.497884667,0.6753125209999999,0.8017747679999999,0.8462969690000001,0.798773018,0.674397239,0.510719606,0.35781046200000005,0.26420459999999996,0.262750103,0.360718717,0.53741224,0.7503155359999999,0.9482397340000001,1.08766397,1.14732911,1.13645972,1.09374388,1.07689681,1.14548102,1.34179642,1.67542414,2.11614406,2.59767125,3.03161758,3.32816368,3.41797766,3.2695091,2.89703997,2.35741772,1.73648951,1.12900979,0.6174277979999999,0.255045007,0.057589718600000006,0.00475657609,0.050460467599999996,0.138272151,0.217365344,0.254575176,0.23968135699999998,0.18326247399999998,0.108712297,0.0415937926,0.0,0.0,4.4158456100000005e-05,0.016596803700000003,0.021081506099999998,0.00308594182,0.0,0.0,0.0,0.0,0.0,0.11416431099999999,0.302777698,0.517781267,0.725233408,0.891057243,0.988983466,1.00616466,0.9450969570000001,0.82164734,0.660109603,0.486955524,0.32511328100000003,0.19019802600000002,0.08932841650000001,0.022285032799999997,0.0,0.0,0.0,0.0,0.0,0.0061757242599999995,0.0190755362,0.0253663772,0.0226232346,0.011181976699999999,0.0,0.0,0.0,0.0,0.0385697289,0.0970780218,0.161701647,0.215095774,0.23929832,0.221784339,0.161032084,0.0696829908,0.0,0.0,0.0,1.1244845e-16,0.191718095,0.470105404,0.8003428359999999,1.13247448,1.41178998,1.59083719,1.64000023,1.55390888,1.35204721,1.07349162,0.767279658,0.481038698,0.250870379,0.0950034577,0.012558406299999998,0.0,0.0,0.0104114474,0.016994548300000002,0.00765757627,0.0,0.0,0.0,0.0,0.0,0.0209090559,0.0630036022,0.09510927050000001,0.108031741,0.0989230111,0.0720683984,0.0372127975,0.00610849527,0.0,0.0,0.006642478120000001,0.0338689974,0.061509213,0.0810622961,0.08788060550000001,0.0825739223,0.0704573213,0.059329649000000005,0.0564525659,0.0658539125,0.086923094,0.11476692699999999,0.142139305,0.16218648300000002,0.17096681600000002,0.16880759899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.024576317200000003,0.157377996,0.306355249,0.457392991,0.59546919,0.7064816890000001,0.7789974409999999,0.805698267,0.7843381779999999,0.71809312,0.615265391,0.488390127,0.352868315,0.22530888699999999,0.121793899,0.0562817676,0.0393347781,0.07730362959999999,0.172032346,0.321072119,0.51832395,0.754977331,1.02058303,1.30409576,1.59474648,1.88264886,2.15910274,2.41661759,2.64873235,2.84974348,3.01446628,3.13814204,3.21656769,3.24647211,3.22610202,3.15592323,3.03929836,2.88298116,2.69727394,2.49573038,2.29434673,2.11026241,1.96007406,1.8579433,1.81373325,1.83143415,1.90812579,2.03367467,2.19128064,2.35888114,2.51130594,2.62296644,2.67077729,2.63695888,2.51136382,2.29301392,1.99062114,1.6219871000000001,1.21231531,0.791610587,0.391461251,0.041585972400000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.157237865,0.34250789200000004,0.488233232,0.579153919,0.608299302,0.577330406,0.49574878299999997,0.37911223200000005,0.246528887,0.117793244,0.0105684522,0.0,0.0,0.0,0.0,0.0352445599,0.11543026699999999,0.18979953800000002,0.24473021600000003,0.27044154800000003,0.262466767,0.22226224100000003,0.156870439,0.0776968579,0.0,0.0,0.0,0.0,0.0,0.0,0.061475232000000005,0.151492806,0.233032254,0.29043508,0.31104348600000004,0.287449932,0.219061753,0.112723428,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0413662517,0.317922204,0.636872659,0.970920184,1.2896413999999998,1.56294402,1.76453702,1.87497469,1.88389015,1.79114017,1.60672506,1.34950639,1.04489948,0.721846381,0.409461663,0.133776304,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0325634666,0.123408589,0.18502233899999998,0.210785764,0.20019119100000002,0.158311801,0.0945378259,0.0208036544,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.006994210600000001,0.0589951349,0.098468264,0.11970785099999999,0.120222292,0.10096492,0.06601500589999999,0.0217833664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0361927341,0.0677463656,0.08716469519999999,0.09158719609999999,0.0806820112,0.056633793200000004,0.023726173399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.025039028199999997,0.054021050599999995,0.0736606013,0.0807835709,0.0743141504,0.055433152400000005,0.0273666756,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0184837526,0.0484283779,0.0704076557,0.0806777618,0.07741368559999999,0.061026814000000006,0.034118403900000004,0.00107339688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013935506200000001,0.0492673777,0.07723826219999999,0.092904786,0.093223895,0.0776119967,0.0481203516,0.009187935040000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.009849808270000001,0.0623621399,0.10861507599999999,0.140646209,0.152296236,0.140299943,0.104995931,0.0505323245,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.19082655899999998,0.241659588,0.560554751,0.251936029,0.468934686,0.0,0.12185365699999999,0.274823404,0.18811067399999998,0.0,0.0,0.30877798,0.068812844,0.343263547,0.0745540331,0.0,0.0,0.366220066,0.0,0.0,0.0,0.0,0.23962804199999999,0.129454003,0.0989094716,0.037044161,0.209289554,0.0,0.0814768941,0.198826051,0.0,0.449765908,0.0,0.0,0.09607672910000001,0.586425111,0.23972706100000002,0.612630406,0.22021083800000002,0.0,0.0,0.0,0.0,0.215413954,0.0,0.166997155,0.0,0.0,0.31821726899999997,0.35991079,0.0,0.0,0.0,0.17311092399999997,0.318694787,0.6306700439999999,0.942976125,1.30902587,1.25969119,0.621745666,0.0,0.0,0.0380816349,0.0,0.08618004859999999,0.761729277,1.28103052,1.27643082,1.09661716,0.0,0.0,0.0,0.6803496840000001,0.0938948726,0.0,0.225312935,0.47100661,1.03145954,0.492174344,1.35961296,2.8258603,4.25429012,4.00799379,2.59826415,0.9411985159999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.52439687,1.15823788,0.08454645,0.81180973,2.25005408,0.26951695,0.22846505,0.0,0.10345730000000002,0.23247857,0.0,0.0,0.0,0.0,0.0,0.0,0.0345927,0.19940940000000001,0.03067564,0.0,1.21010698,0.43381593,0.0,0.1314358,0.89955509,1.6058887,0.57015332,0.0,0.0,2.46157754,6.27844449,8.32261885,8.84514601,6.05458083,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.188614559,7.18947715,10.817936099999999,6.59909613,0.753354009,0.0,1.34672319,0.862543933,0.0,0.0,0.6660289939999999,0.21524964800000002,0.0,0.045343667000000004,0.48152181,0.0923172759,0.0,0.306314043,0.294237103,0.0,0.0,0.191320861,0.0862357951,0.0,0.0,0.172322224,0.0,0.0,0.0445187434,0.120907565,0.0,0.0,0.0798886444,0.061143376,0.0,0.0,0.0808169903,0.0109605111,0.0,0.00708048843,0.0603100094,0.0,0.0,0.027356442999999998,0.0334057275,0.0,0.0,0.0312359135,0.0110879124,0.0,0.0338658967,0.101305289,0.028283197799999996,0.0,0.0775438388,0.64428717,1.22855361,1.42616887,1.43156448,1.71061533,2.22919342,2.59528031,2.67042287,2.42209838,1.75480948,1.1253382,1.31253415,1.8800696,1.38564441,0.0,0.0,1.56396209,3.48459619,3.48020678,1.89984599,0.353784118,0.0,0.969001922,2.02035393,1.39799401,0.0,0.0,0.554448996,0.675854278,0.0,0.0,1.15785776,0.396431762,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.047875479900000004,0.0,0.0,0.0,0.0,0.0,0.0,0.23933592,0.0,0.0,0.0,0.0,0.248544166,1.69263109,0.0,1.50554894,1.31418468,0.7034916379999999,0.0,0.7568045409999999,0.367897125,0.066792064,0.0,1.63199496,0.0,0.793571019,0.717352195,0.0,0.0,0.0,0.0631736959,0.49317429999999995,0.0,0.026475383999999998,0.0,0.0,0.701476608,0.0,0.0,0.246283854,0.0,0.0,0.0,0.103614995,0.423102359,0.547303557,0.856556126,0.617800654,0.0,0.0,0.0997469659,0.0,0.9787273940000001,0.0,0.582245871,0.0,0.0,0.22797173699999998,0.0,0.301090887,0.0,0.0,0.277882958,0.33675904,0.22444310899999997,0.0933075309,0.0,1.48878964,0.0,0.17024071699999999,1.16785292,0.0,0.0,0.829647085,0.63783951,0.981060797,0.127969156,0.15475906,0.0,0.0,0.0,0.0,0.0,0.954256461,0.0,0.841212712,0.34724924100000004,0.0035771873,0.286468216,0.56611701,0.0,0.0373729726,1.0752656,0.729031058,0.287266097,0.0,0.0,1.74761378,0.0,0.0,0.09471894039999999,0.0,0.0,0.0,0.048198365,0.6614148479999999,0.0,0.0,0.0,0.0,0.0,0.057741401799999995,0.0,0.0,0.0787663373,0.43098909,0.0,0.0,0.0,0.15932453300000002,0.0,0.7050882270000001,0.0,0.0490619934,1.72271913,0.22504587199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.494215247,0.0,0.562776206,1.09148169,0.0,0.43997975200000006,0.0,0.20186653699999998,0.0,0.36361174399999996,0.0,0.0,0.536787198,0.0,1.01666239,0.0634503362,0.48921703899999996,0.190039172,0.0,0.6127826,0.0,0.646363365,1.1180774,0.0,0.0,0.0617846442,0.0,0.0,0.0,0.0,0.0,1.35054388,1.10939443,0.0,0.38845921299999997,0.0,0.0,0.0,0.0,0.814873325,0.0,0.0,0.0,0.509435147,0.796620762,0.0,0.235318693,0.0,0.528147499,0.8800395529999999,0.202173121,0.17379454100000002,0.301612216,0.432583421,0.0,0.0,0.177371528,0.567848395,0.0,0.0,0.45288714700000005,0.0,1.37101596,0.0,0.268545641,0.0,0.298240801,0.0446635799,0.277900327,0.69569233,0.0700093051,0.025251052000000003,0.62893334,0.0,0.990027147,0.35384491799999995,0.0,0.0,0.0,0.0,0.218190805,0.0428720911,0.0,0.285370358,0.46373317700000005,0.0,0.0031416230199999996,0.0,0.0,0.0,0.831899347,1.53309245,1.61591417,0.0,2.07815638,1.72745643,3.57543518,2.58757316,3.10472219,2.1163407000000003,3.03205775,4.81616814,4.47838109,3.24076711,3.73291562,1.97823277,2.34514693,2.21231221,1.96912245,1.44150448,1.84271443,1.57302002,0.827306707,0.0,0.22337408399999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.0505018999999998,0.31911125,0.0,0.0,0.88556487,3.53693063,8.90515419,5.47664791,0.0,0.4599536,4.10092825,0.02615855,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.10175462699999999,0.21119478100000003,0.86492121,1.44297918,1.51847043,2.37468233,4.12681569,4.71203963,4.83135827,5.10889978,5.13591515,4.74150607,4.83097826,4.25976915,2.5497502,1.67443642,1.6020471,1.38682983,0.876276086,1.23413779,0.45425803,1.40446622,0.769110807,1.19325861,1.05628091,1.09571486,0.342812338,0.0,0.188048043,0.0853687467,0.14020641,0.0,0.48558539,0.80910624,0.8995572909999999,0.904557306,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.04635886,1.09836747,1.34695396,1.59279644,1.64045968,2.23515662,2.12601702,1.22942345,0.743688452,0.360721219,0.125571001,0.00171860348,0.043008455099999995,0.0,0.0,0.0,0.0,0.100534427,0.326229084,0.0,0.0,0.20196539100000002,0.45622644700000003,1.04955207,1.23288659,1.80551562,2.36568889,1.91337829,1.68709688,2.21586443,1.65585973,0.930992612,0.340286171,0.947698872,0.0650950076,0.51149399,0.605356778,0.611982165,0.029148889900000002,0.611321905,0.0,0.032292852999999996,0.5071933989999999,0.0,0.0,0.290906587,0.0283872567,0.0,0.0677405379,0.42162654899999996,0.39277864,0.0,0.46273904,0.0,0.0,0.483448882,0.0,0.24107313800000002,0.430453549,0.441836216,0.24782474300000001,0.0,0.13063663,0.0,0.0,0.364014591,0.122402773,0.0,0.0,0.06854701889999999,0.0,0.00614409629,0.0,0.529725454,0.0,0.0,0.0,0.7022894590000001,0.34814426600000004,0.863603731,0.8208493290000001,1.46799869,0.5553817839999999,1.09597653,0.9371533609999999,0.353916845,0.18422654300000002,0.0835045216,0.0,0.0,0.178576421,0.0,0.0163664491,0.0,0.5699575410000001,0.0,0.0,0.349202215,0.182953798,0.0,0.0,0.21602259399999998,0.0,0.0,0.0,0.551137282,0.0,0.10792255,0.43410394399999996,0.0,0.0,0.32240664199999997,0.0,0.0,0.0,0.0,0.537494434,0.0,0.43669694600000003,0.0,0.445615374,0.084398094,0.0,0.183915702,0.456911571,0.230604814,0.34877326399999997,0.20317962399999998,0.0,0.359424115,0.0,0.438965339,0.0,0.0311148648,0.0,0.0,0.0,0.0,0.0666466644,0.0,0.40113221600000004,0.549334326,0.0574719696,0.0,0.16800695300000001,0.42378315200000005,0.0,0.0,0.372042518,0.587861549,0.279013286,0.56600165,0.49141346399999997,0.0,0.0127121615,0.34747641,0.0,0.470123511,0.0,0.0,0.0367896995,0.237533159,0.0,0.563790004,0.640104199,0.736785617,0.967660994,0.510744925,0.620154119,1.30017791,1.25893878,1.28089587,0.7693570209999999,1.01604424,0.450140789,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0284159,0.0,0.0,0.07070231,0.12869982,0.0,0.09307096,0.04391807,0.24470829,0.86918855,1.71608195,2.38448744,3.07912689,2.79001186,3.1077265,2.06069035,1.36808857,0.49318936,0.10486456,0.0,0.0,0.21978317,0.39397101,0.17708482,0.60851897,0.41340347,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0530637715,0.0,0.0,0.0,0.0,0.0,0.00763675812,0.0434223388,0.048076549100000004,0.0305950685,0.00728638792,0.0,0.005645581439999999,0.041248399399999996,0.0951892719,0.155153904,0.209361535,0.25320798699999997,0.294206425,0.35335466600000004,0.462000464,0.654542498,0.958553716,1.38479866,1.91987895,2.52378251,3.13352219,3.67258915,4.0644789,4.247449400000001,4.18723104,3.88475371,3.37701956,2.73078029,2.03030764,1.36188149,0.798339768,0.386970162,0.14319996699999998,0.0511668321,0.0706686659,0.14857856,0.231900515,0.27943215899999996,0.269512387,0.202409162,0.0972587392,0.0,0.0,0.0,0.0,0.0,0.108657478,0.253286768,0.382660285,0.471905508,0.506356117,0.48400476,0.414708146,0.316650315,0.21121288,0.117691636,0.049192099,0.010594952099999999,0.0,0.00523798596,0.0187125379,0.0293516481,0.0309135806,0.021954479500000002,0.005381813399999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0128244965,0.0228628626,0.025471402799999997,0.0207979285,0.011141601899999999,0.0,0.0,0.0,0.0,0.0,0.0,0.00059452268,0.00326471788,0.00325451463,0.00143339836,0.0,0.0,0.000766514848,0.00458638613,0.00885900741,0.0114231008,0.0103609455,0.00487028358,0.0,0.0,0.0,0.0,0.0,0.0,0.00987086055,0.026288160499999998,0.0370597806,0.0379571591,0.0273318367,0.00696619823,0.0,0.0,0.0,0.0,0.0,0.0,0.029344537900000002,0.05823131769999999,0.0726623838,0.06690933,0.0407400985,1.43073508e-16,0.0,0.0,0.0,0.0,0.0,0.00833184679,0.0654632094,0.108575584,0.12365087699999999,0.10360663,0.0510002962,0.0,0.0,0.0,0.0,0.0,0.0,0.0442210572,0.142432369,0.210095933,0.223432534,0.171357158,0.060225214900000004,0.0,0.0,0.0,0.0,0.0,0.0110486799,0.336126756,0.7153918420000001,1.09130149,1.40329221,1.60012697,1.65041074,1.54885421,1.31686527,0.997397222,0.645345455,0.315819215,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.42198814,0.56433008,1.01550264,0.09931909,0.0,0.0,0.0,0.35792899,1.2265834,1.19638433,0.0,0.96692609,0.43910271,0.0,0.0,0.43249512,0.24334742,0.0,0.98798619,0.95616738,0.0,0.37935752,2.48375926,0.0,2.7444077,1.64171274,1.47065014,0.85504698,2.349764,0.88187171,0.38052528,0.05681337,1.75068116,1.08642587,0.0,0.0,0.05482530000000001,0.0,0.0,1.05551407,0.48116164,0.20830346,0.61869805,0.44970253,0.46142947,0.11346789999999998,1.42187329,0.18378292,0.0,0.75901132,0.38183259,0.0,0.0,0.71283322,0.0,0.40970181,0.04040079,0.0,0.27276183,1.25707599,1.41242754,0.84506786,0.6667257,0.56281404,0.0,0.44903949,0.0,0.0,0.0,0.81855755,0.6607673000000001,0.0,0.0,0.20242398,0.17174255,0.48557123,0.53648082,0.0,0.0,0.0,0.14589012,0.34126338,0.56434002,0.08919512,0.0,1.06076899,0.0,0.37217778,0.0,0.0,0.0,0.46724750000000004,0.0,0.0,0.0,0.0,0.0,0.06016164,0.0,0.0,1.2193669,0.0,0.10238101,0.0,0.41249663,0.0,0.0,0.0,0.0,0.17238469,0.0,0.0,1.07254099,0.03494939,0.15064589,0.46492685,0.0,0.30759028,0.4766071,1.17103691,0.0,0.73190023,0.29248148,0.0,0.47436355,0.0,0.0,0.55221899,0.76544459,0.0,0.60200536,0.0,0.19619001,0.14489998,0.74610864,0.22008985,0.0,0.0,0.0,0.0,0.16146971,0.34619856,1.03861737,0.0,0.0,1.9143191000000002,0.0,0.0,0.0,0.25766652,0.0,0.0,0.2866297,0.0,0.0,0.0,0.67433933,0.0,1.08248274,0.0,0.16098099999999999,0.89234155,0.17670053,0.0,0.0,0.0,0.98101631,0.0,0.0,0.52704453,0.0,0.0,0.21488467,1.09787247,1.14516876,0.37118495,0.5395324,0.0,0.0,0.0,0.0,0.0,0.0,0.45822816,0.09664461,2.49842395,0.92306042,1.99427007,2.49844126,2.76410499,3.04150731,3.20735039,1.82522529,2.5628962000000004,0.25804413,0.9775795,0.0,0.48864669,0.0,0.0,0.0,0.61414546,0.0,0.0,0.67093297,0.27949525,0.8518924999999999,1.08122768,0.0,0.16439443,0.10056837,0.03255811,0.0,0.0,0.0,0.0,1.83734218,1.38536686,0.0,1.50520117,1.45006242,1.34166166,0.0,0.80488006,0.2349444,0.61431066,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
23.86151096,2.60298426,1.34405326,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.108676255,0.442979956,0.126961929,0.25868171100000004,0.717730833,0.0,0.0678166518,0.0,0.645364002,0.0,0.408946099,0.0,0.0,0.225939602,0.060683441500000004,0.844844239,0.516141325,0.992100888,1.02208682,0.8710596690000001,0.785201719,1.48878479,1.25390974,1.3003341999999998,1.63177597,1.85314021,1.60693233,2.09746085,1.19069166,1.04399757,1.25180365,1.64690915,1.37339183,0.640053355,0.609691101,0.405013966,0.0016536899,0.0650880504,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.127870169,0.0,0.0,0.10107094800000001,0.18361902100000002,0.520744411,0.385885076,0.0570113332,0.0,0.0,0.33688016,0.0,0.0,0.0,0.0,0.0,0.0,0.176696672,0.0,0.231597105,0.0,0.25856534800000003,0.0,0.0,0.213896853,0.451687245,0.532149203,0.305841252,0.0,0.445322706,0.021432371699999998,0.164818732,0.377760095,0.37177529600000003,0.0405495306,0.0,0.0,0.0,0.0,0.0,0.17852553699999998,0.00043956193700000004,0.0,0.0,0.0,0.327950348,0.10083341900000001,0.0,0.0,0.0722702232,0.0656341829,0.0,0.0,0.456444458,0.33745928799999997,0.18817436,0.0,0.0,0.0,0.22816514899999998,0.156568192,0.0,0.14789002199999998,0.0,0.0,0.0,0.0,0.0,0.39367130100000003,0.0,0.0,0.276612613,0.408307504,0.392907606,0.355506971,0.0,0.0,0.0,0.175305495,0.135483364,0.44174803,0.0,0.0,0.0,0.0,0.0,0.0,0.0759357469,0.0,0.0,0.267818397,0.09679833970000001,0.0,0.0,0.0,0.18697076199999998,0.390826348,0.7290030009999999,0.64696885,0.24929652800000002,0.923698725,0.889759772,1.00049081,1.32582378,0.933452272,1.89893532,1.24204264,1.57772205,1.70573823,1.14109082,1.94612727,1.14568276,0.820266203,1.03597863,0.718930648,0.49275275399999996,0.76637456,0.5536915370000001,0.22617433,0.0,0.0,0.0,0.0,0.0560858313,0.129039284,0.0,0.0,0.0,0.0,0.509379988,0.444457235,0.743853105,0.9592781229999999,0.548652817,0.28904279899999996,0.684263816,0.387785716,0.0,0.09876803140000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.336390804,1.3379169,1.2923938,2.28592226,2.82358822,3.19148693,3.39976657,3.7503306000000003,4.82590175,4.93227759,4.51014036,5.1090195,4.46066624,4.34106079,4.47122011,3.97217551,3.10952117,3.3727712,3.00611513,2.31304546,1.8671057,1.57520884,0.792337318,0.5873769320000001,0.46135679399999996,0.34392273,0.0938437166,0.0,0.0,0.0,0.0,0.262522197,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.7148765840000001,0.429193649,1.52635574,0.0,1.80154912,0.0,0.950788663,0.601130575,0.0,1.24461458,1.00793217,1.11154769,0.0,0.0,0.100294618,0.014560836399999999,0.0,0.0,0.0,0.522815166,0.0,0.0,0.0,0.0,0.274377973,0.89775918,1.28823872,4.21602295,6.29002789,4.97246884,1.94936056,0.0,0.137884418,1.62961357,0.886748633,2.07850657,2.64668768,2.04117008,0.791220302,2.92107219,2.10653062,0.879250535,0.850487177,1.3511271999999999,0.945698107,0.853492044,0.0,0.176648311,0.0,3.60957623,0.0,0.0,0.0,1.10680857,0.0,0.0,0.0,0.0,0.0,0.737205885,1.91717571,1.1669797,0.0,0.0333852252,0.264482156,1.57227662,1.3075941,1.24429414,0.0205540811,1.05055245,0.0,0.0,0.0768861125,1.00740097,0.952127429,0.56057109,0.0,0.0953627579,0.0,0.0,0.797629591,0.8058931709999999,1.65382015,0.0,0.0,0.320636138,0.0,0.6502349000000001,0.0,1.2107725,0.0,0.0,0.598125541,0.0,0.6132778320000001,0.40555331899999997,0.0,0.0,0.251394975,0.0,0.0,0.390211194,0.0,0.751735899,1.40299166,0.342500414,0.47343052399999996,0.0,0.0,1.31178872,0.6316727639999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0493588435,0.0,0.0,0.0,0.0,0.134686349,0.285925384,0.288008834,0.160577959,0.0,0.0,0.0,0.0,0.0,0.094563544,0.17911232300000002,0.17421029,0.08918758060000001,0.0,0.0,0.0,0.0,0.0,0.0797859527,0.135712742,0.125144821,0.0565375221,0.0,0.0,0.0,0.0,0.0,0.072679144,0.11237166800000001,0.0975564965,0.037267721600000005,0.0,0.0,0.0,0.0,0.0055140092,0.0688914402,0.0977409093,0.0794341005,0.0239982581,0.0,0.0,0.0,0.0,0.012878926399999999,0.0660827592,0.0863880531,0.065091912,0.0136056342,0.0,0.0,0.0,0.0,0.0171768835,0.056677557999999996,0.06514620389999999,0.0414807305,0.00357725749,0.0,0.0,0.062322876,0.16353263,0.268788403,0.341457915,0.35576370399999996,0.30827872100000003,0.219606065,0.125324622,0.0602391059,0.0431119312,0.0688897634,0.112009451,0.139238949,0.126051834,0.0688354924,0.0,0.0,0.0,0.0,0.0,0.058352730400000004,0.114147565,0.11620697699999999,0.061561098099999996,0.0,0.0,0.0,0.0,0.0,0.0853653542,0.152292973,0.148987581,0.0703831594,0.0,0.0,0.0,0.0,0.0,0.171977861,0.29853477300000003,0.301822569,0.151244873,0.0,0.0,0.0,0.0,0.12427119199999999,1.08598446,2.3989903999999997,3.89514415,5.34471645,6.50529937,7.17467527,7.23474651,6.67645452,5.60056625,4.19486432,2.693393,1.32709278,0.276866306,0.0,0.0,0.0,0.0,0.10451747900000001,0.313740267,0.36247787299999995,0.260827953,0.0766273201,0.0,0.0,0.0,0.0,0.169827175,0.295718315,0.314640647,0.215216625,0.039658918599999995,0.0,0.0,0.0,0.0,0.108551126,0.23725444199999998,0.250393359,0.139354429,0.0,0.0,0.0,0.362803475,1.04749013,1.91174787,2.76170147,3.38086418,3.60386848,3.37636161,2.77769743,1.99651604,1.26707094,0.789274305,0.661852917,0.853105172,1.21939412,1.56334734,1.70891033,1.56467986,1.15239746,0.591699999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.91122383,0.286779629,0.0,0.0,0.6273495960000001,0.351098051,0.0,0.0,0.376220589,0.69907431,0.387169505,0.639635773,1.91705653,2.95693731,2.58191689,1.39431926,0.7499301190000001,0.830344697,0.7907792220000001,0.33608777700000003,0.0108755502,0.0636635552,0.08537829599999999,0.0,0.0,0.101114784,0.188365395,0.0,0.0,0.0336354044,0.243669876,0.0143306949,0.0,0.0,0.25431717800000003,0.12278052,0.0,0.0,0.218190522,0.23284248899999999,0.0,0.0,0.134894031,0.328763645,0.0,0.0,0.00546959128,0.396658777,0.0765883404,0.0,0.0,0.42481263799999996,0.281602548,0.0,0.0,0.415432431,0.673865528,0.0,0.0,0.22905690199999998,0.943846802,0.0,0.0,0.0,3.50979529,5.97589141,4.50934458,0.986237453,0.0,0.0,0.34462752799999996,0.251776791,0.0,0.0,0.0,0.0,0.10776244800000001,1.61657475,2.72170563,2.00600454,0.318572867,0.0,0.39134664700000005,1.00998036,0.657523445,0.203322224,0.499928803,0.93597997,0.580874451,0.0,0.0,0.260439584,0.792994454,0.8597703940000001,0.94678481,1.37017828,1.69838699,1.51121458,1.06322232,0.790884461,0.647142157,0.363338304,0.025837070400000002,0.0,0.045801162400000005,0.0856058192,0.0,0.0,0.00810827742,0.09053550380000001,0.07567315299999999,0.100178266,0.33567935600000004,0.8715628670000001,1.8231388,3.25965044,4.85768348,5.85453081,5.64214879,4.42401412,3.12179872,2.54306365,2.65434963,2.70560639,2.0816118,0.97990435,0.148255823,0.0,0.122042692,0.061822648099999995,0.0,0.0,0.135131929,0.14167966699999998,0.0,0.0,0.101216721,0.240740423,0.0,0.0,0.0143723264,0.372487487,0.06554422809999999,0.0,0.0,0.58320876,0.41785034,0.0,0.0,1.43895712,4.49309789,4.91393495,2.27329041,0.0,0.0,0.553518862,0.8987045690000001,0.0544243416,0.0,0.0,0.478055677,0.272719113,0.0,0.0,0.060628256900000004,0.00666491506,0.0651165811,0.411831405,0.5087511029999999,0.10955818099999999,0.0470712227,0.9948527420000001,2.03549839,1.7048226999999998,0.21116800800000002,0.0,0.0,0.466896291,0.27686772600000004,0.0,0.0,0.23291337199999998,0.30578061300000003,0.0,0.0,0.07995287150000001,0.29978906899999996,0.0,0.0,0.0,0.268826568,0.09274974009999999,0.0,0.0,0.265755747,0.370854244,0.0806112586,0.0,0.0868128101,0.254178088,0.157992907,0.00185951228,0.0060310197,0.0864931191,0.14414194800000002,0.25516757,0.402275485,0.402966063,0.27178438899999996,0.264921519,0.39834836700000004,0.358101425,0.09637793509999999,0.00951127798,0.21943419600000003,0.265771,0.00434604737,0.179155576,1.2837575,2.33542112,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.34246911,0.33268571,0.0,0.0,0.0,0.0,0.0,0.0,0.08138913,0.0,0.0,0.51194764,0.0,0.20464324,0.0,0.06981473,0.25838483,0.1832855,0.62452659,0.455071,1.60361636,1.11974027,1.95092871,1.14793016,2.33412245,1.00414682,2.8775422,1.47220653,2.77256708,1.88641953,2.86085992,3.77288373,2.7921556,3.19065485,3.08478362,3.67202986,2.6739755,2.32855317,3.4166892,3.34904977,3.54885729,3.32841192,2.78246379,2.28801802,1.76858851,0.75500434,0.84971189,1.77031155,2.29030806,1.86792422,0.76219266,0.81967778,1.93477014,0.38674439,1.01699704,0.37151551,0.0,0.97134349,0.39595602,0.0,0.08136248,0.0,0.09059811,0.10451746,0.94969112,0.07154483,0.0,1.10273273,0.0,0.05526344,0.0,0.0,0.41557414,0.09575729,0.0,0.0,0.59794318,0.81561218,0.0,0.0,0.0,0.81022549,1.05585851,0.24830505,0.0,1.83887525,0.0,0.03869612,0.16133883,0.10337110000000001,0.0,0.0,0.0,0.0,0.0,0.45609265,0.0,0.06760167,0.47170614,0.50018749,0.0,0.0,0.44957008,0.0,0.17359709,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.33815671,0.39909402,0.0,0.0,0.3554521,0.0,0.36002671,0.59567593,0.14832046,0.58668415,0.37468139,0.3489636,0.0,0.0,0.0,0.07695795,0.51663292,0.14779175,0.0,0.76978918,0.45038339,0.0,0.0,0.40193883,0.0,0.0,0.09930869,0.0,0.0,0.27525419,0.0,0.0,0.45318166,0.0,0.0,0.0,0.0,1.54722646,0.14243438,0.0,0.44037715,0.49291303,0.21064304,0.0,0.36374753,0.0,0.0,0.0,0.0,0.54236418,0.86397756,0.0,0.0896418,1.53881042,0.03927573,0.04022272,0.0,0.0,0.0,0.0,0.0,1.11728109,0.17613444,0.44162092,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0976943194,0.23473264800000002,0.242687349,0.144440485,0.0698819963,0.113744529,0.24158700100000002,0.329039026,0.287043041,0.145763223,0.0170289811,0.0,0.006282303120000001,0.010517187800000001,0.0,0.0,0.0,0.107001264,0.212435951,0.105701986,0.0,0.0,0.0,0.629976334,1.89400477,2.97705297,3.2905227999999997,2.64440179,1.39579686,0.229415127,0.0,0.0134695216,0.759026845,1.42783271,1.64282126,1.36818387,0.841176501,0.35441175799999997,0.0704459915,0.0,0.0,0.00234802467,0.0030481625,0.0,0.000651453616,0.00441229424,0.0035647567100000003,0.0,0.0,0.000465459155,0.0,0.0,0.0,0.0,0.0141993537,0.0181214593,0.00140459187,0.0,0.0,0.0,0.0343101035,0.0453727208,0.009277613359999999,0.0,0.0,0.0,0.059110166,0.08843977189999999,0.028689614900000004,0.0,0.0,0.0,0.117504715,0.26094120600000004,0.291927522,0.254595588,0.31318607,0.615213282,1.13666696,1.64931622,1.85794572,1.61116767,1.01911563,0.38095434,0.0,0.0,0.019354065400000002,0.137937481,0.14124825400000002,0.0567593992,0.0,0.0,0.0,0.0,0.0,0.0,0.013472001200000002,0.0737024946,0.0727124393,0.0,0.0,0.0,0.218280823,0.655644812,1.00788571,1.05692622,0.772275959,0.34066604799999994,0.0243983948,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45267032,0.0,0.41344058,0.0,0.41406451,0.0,1.92115354,0.36472718,0.18442449,0.0,0.7281009,0.0,0.37799551,0.0,0.49989449999999996,0.0,0.69194734,0.0,1.39094498,0.0,8.94138587,12.29950555,0.0,0.93669351,0.0,2.34167707,3.31422561,0.80174126,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.16088306900000002,0.0,0.0,0.276520955,0.0,0.0,1.79966006,2.88122208,0.724209433,0.0,0.0,0.0186727229,0.413471204,3.12504694,0.0,0.0,4.70020644,0.0,0.0,4.06093417,6.81216357,5.6459988,1.77223236,0.0,2.24159449,0.0,0.812436721,2.74824839,0.0,0.0,0.308085991,1.6691761999999999,0.748074221,1.01137818,0.8538328209999999,3.73003142,0.0,1.03950003,0.796353147,0.0,0.0,0.0,0.423646367,0.0,0.9176660790000001,2.96739078,0.0,0.0,2.03347496,0.0,1.36267151,0.391716967,0.0,2.63314922,0.0,0.0,1.13896078,0.7185209570000001,0.0,0.0,0.0,0.70099931,0.0,1.42075999,2.34210113,0.5402893910000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.52670328,0.0,0.0,0.0710400549,0.0,0.05278086059999999,0.0,0.0,0.0452803016,0.0,0.148555073,0.0,0.314413396,0.0,0.653596736,0.0,2.89031767,9.809772500000001,0.0,1.82152512,0.0,0.713676678,0.0,0.41678912700000004,0.0,0.275711869,1.5457732,1.42301839,0.0,0.23980624399999997,0.0,0.0,0.212423257,0.0,2.42674006,4.2738156,0.0,3.91000268,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.23674705,2.72928278,1.81160548,2.14348829,0.0,2.1847533,0.59961267,0.0,0.0,1.41983676,0.0,0.55183746,0.0,1.66180996,0.0,1.28859906,2.59389127,0.23400949999999998,0.0,0.0,0.0,1.73958048,0.0,1.73663012,0.0,0.0,0.0,0.39172634,0.0,0.91981204,0.43860569,0.26683336,0.0,0.87735861,0.0,0.0,0.31662119,0.0,0.38090175,0.0,1.26252912,0.0,0.37449240000000006,0.0,0.0,0.0,0.80752539,0.0,0.0,0.0,0.0,0.18878128,0.32113488,0.0,3.65021318,0.0,0.0,0.43101155,1.5367950000000001,0.45251529,0.0,0.0,0.04445403,1.03232573,0.0,0.69588098,1.42470861,2.55063009,5.12671129,6.44665823,6.78683966,4.91406836,2.73644055,4.15492297,2.35361002,0.0,0.16138053,0.0,1.34905346,0.06231913,0.0,0.0,1.96336112,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.13804953,1.90699479,3.058599,3.07196893,4.30433932,4.68021648,5.53743383,5.44048904,4.4564808,4.09621633,2.71082093,2.1818256000000003,0.904917668,0.169785291,0.0835277555,0.0,0.0,0.0,0.0,0.230970575,0.0801475425,0.615888777,0.539719034,0.167398367,0.578221193,0.152561522,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0511994134,0.752178586,0.6740472470000001,0.350788971,0.0,0.005041126779999999,0.222094825,0.0,0.0,0.0,0.444914498,0.0,0.0343125995,0.36296344700000005,0.8188981209999999,0.239988179,0.320885059,0.594982725,1.32439904,1.55968156,1.51057307,1.53181015,1.71050851,2.32876421,1.82281256,1.75186687,1.78842702,1.32464274,0.926774457,0.429768217,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0756254117,0.00500322279,0.0787359173,0.56237396,0.0,0.197112221,0.0,0.0,0.0,0.255159564,0.293870227,0.653566329,0.7368124140000001,0.34198193600000004,0.0,0.0,0.381683041,0.00131667533,0.241498493,0.0,0.0,0.0,0.0194851527,0.0547663697,0.735612113,0.0,0.543367142,0.0,0.307937065,0.0900182859,0.0,0.0815753513,0.0,0.127661624,0.179293306,0.0,0.5192142160000001,0.057812741200000003,0.421302193,0.20218077199999998,0.0,0.19692773,0.0,0.0,0.0,0.0,0.0,0.2612285,0.0,0.715251118,0.724289828,0.450426565,1.23576389,0.6988313759999999,1.1378489,1.12125244,0.416289498,0.9421220440000001,1.14225364,0.780493223,0.471381813,0.758447331,0.898616993,0.977873245,0.474871009,0.14147058099999998,0.30271886600000003,0.36589709600000003,0.635932767,0.0827119011,0.780139589,0.489556492,0.662755698,0.711402366,0.7577631109999999,0.496287831,0.397599301,0.114833514,0.248428978,0.0,0.0,0.0,0.0,0.0,0.230070897,0.61282137,0.913918777,2.30602573,2.90318826,3.09214012,3.26445907,2.32577032,2.38726635,1.90216292,0.9475336320000001,0.21159584399999998,0.490848665,0.0,0.0,0.0904199119,0.0,0.17319442100000002,0.0,0.20584819899999998,0.0,0.460279514,0.0,0.0,0.0,0.371388014,0.0,0.0,0.376842402,0.44428988700000005,0.249354833,0.278927997,0.464646448,0.0307057969,0.456202912,0.0,0.430713109,0.318519255,0.107162155,0.37471184399999996,0.378481634,0.15137303800000002,0.389269705,0.0,0.18665902399999998,0.0737786424,0.316789322,0.0,0.0,0.0,0.0,0.0803969209,0.726296197,0.595052955,0.3276002,0.12106361300000001,0.288286766,0.0,0.0,0.0,0.197072907,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.239063942,0.36832134299999997,0.470560906,0.534454067,0.554684146,0.53270245,0.476533965,0.39968105200000004,0.31929370100000004,0.253866798,0.22077752,0.23398449699999999,0.302176454,0.427588681,0.60561247,0.8252192759999999,1.07012177,1.3205105,1.55514647,1.75356199,1.89812454,1.97574891,1.97909455,1.90714986,1.76517528,1.56404337,1.31907112,1.04848239,0.7716646970000001,0.5073934210000001,0.272190159,0.0789611459,0.0,0.0,0.0,0.0,0.0,0.0,3.88852048e-16,0.07130921330000001,0.128029505,0.162238209,0.16982223899999999,0.150761378,0.10891148199999999,0.051312650700000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0252205556,0.08441780900000001,0.130741855,0.156725876,0.157965641,0.13385854,0.0877752143,0.026621137599999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0593068391,0.126154845,0.17465109899999998,0.196340408,0.186812543,0.146551824,0.08103002990000001,4.536607230000001e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0196174401,0.11551156900000001,0.19633608100000002,0.248312433,0.261801789,0.233036842,0.164972633,0.0670830069,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08151185,0.209355194,0.308885315,0.362485202,0.35918012299999996,0.296734719,0.18243729,0.0323834528,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.201205285,0.381376411,0.5096913679999999,0.561862894,0.524450166,0.397699288,0.19637819,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.141321431,0.49323102,0.7971626740000001,0.998320172,1.05270784,0.934929298,0.64392179,0.20565994899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.9382169490000001,2.29418959,3.75390675,5.19364718,6.48472787,7.50764631,8.1654927,8.394977699999998,8.17370267,7.52276122,6.50434313,5.21463754,3.77291951,2.30817498,0.944912665,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20919420800000002,0.655775695,0.953311362,1.07475653,1.02054387,0.815986008,0.505563158,0.145057025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.20456150899999997,0.41507805299999995,0.548474959,0.588838349,0.535333081,0.401478379,0.212315872,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0351162704,0.198600665,0.324349433,0.39431109,0.399772222,0.34232591700000004,0.233229501,0.0913123049,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.08116425440000001,0.20256352,0.29130274100000003,0.334874697,0.328076572,0.273624594,0.181560273,0.067573165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09850690919999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23199999999999998
1.43126232,0.225366917,0.0,0.0,0.0,0.0,0.205405841,0.7343187940000001,0.10548793,0.0,0.259652615,0.391163297,0.0,0.93003962,0.0,0.0,1.23011056,1.46013195,0.192931137,1.96312978,2.92211475,0.595054306,0.0,1.48355764,0.0,0.0,0.712352091,0.0,0.33895454399999997,0.446063689,0.0,0.0,0.487748821,0.0,0.118819965,0.0,0.400585695,0.5089219739999999,0.0,0.0,0.229491503,0.0,0.110391399,0.23956765,0.432165894,1.04717149,0.7889809609999999,0.0,0.0555131526,0.818589337,0.0,0.0,0.144292169,0.0176431796,0.0124989256,0.0,0.0,1.13760667,1.0102905999999998,0.0666507608,2.62300349,2.4627877999999996,0.223810321,0.130653949,0.27591978899999997,0.0,0.0,0.0,0.13119785,0.0,0.0,0.319833412,0.289485084,0.0,0.0,0.241237153,0.08614140390000001,0.0,0.0,0.0,0.0,0.800833947,0.612937121,0.0,0.178327595,2.7809061,2.72480449,0.266111182,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.556153387,0.7086754679999999,0.333621768,0.229796631,0.263599714,1.30658274,0.582039272,0.0,0.334709264,0.176424785,0.0,0.562170859,1.07566401,0.184821502,2.7591693999999998,4.15516865,2.11246241,1.37070744,1.13339237,0.0,0.0,0.0595021201,0.0,0.0,0.0,0.0,0.0,0.0518178775,0.0,0.11800177,0.0,0.352054696,0.339111084,0.0,0.0,0.193734839,0.333524799,0.0093328419,0.257542094,0.154834172,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45565374299999994,0.691985952,0.0,0.0,0.0360586165,0.0,0.0614901197,0.131636591,0.54864029,0.0,0.0,0.373877205,0.897814221,0.795266747,0.0,0.664800406,0.133483956,0.0,0.0746655409,0.36771097399999997,0.38957045,0.0536009983,0.0476904155,0.7512875859999999,0.419679565,0.0874777091,0.0,0.0,0.0,0.0492782287,0.0143592475,0.0,0.21609995,0.0,0.0,0.254313203,0.628562057,0.0,0.7919460009999999,0.05319139269999999,0.0181950444,0.0122904802,0.0,0.0,0.0,0.0,0.0,0.19478035300000002,0.0,0.0,0.544258069,0.37498120799999995,0.341445073,0.906415898,0.432572501,1.19439833,0.819291178,1.04730395,1.80356615,1.83575901,1.49392437,1.12077445,1.68626016,2.74612041,3.42905386,2.57480966,2.54461997,1.99353466,2.16690987,2.35680596,2.76939228,1.66538883,1.97314813,1.87674118,2.19053162,0.986473554,0.0,0.836700918,1.463593,1.24500173,0.795957823,0.822892429,0.319389756,1.16356343,1.67294604,1.14794009,0.979164127,0.254453963,1.1637492,0.79716003,0.929741466,0.18889847899999998,0.510977016,1.06458619,1.31702624,1.18888223,0.768139358,1.58224712,0.37818438,0.834848571,0.94050328,1.02645009,0.446324093,0.0,0.27147527899999996,0.380216008,0.625224199,0.260506135,0.96323117,0.0,0.187889118,0.217977977,0.107082944,0.0385819001,0.121663971,0.0,0.224750184,0.0,0.868478155,0.008886216700000001,0.0824320347,0.53749222,0.0,0.0,0.0,0.508763277,0.0,0.0,0.603592682,0.0,0.446975203,0.0,0.0,0.0,0.063722943,0.0,0.341403877,0.0,0.240472838,0.177765347,0.052463887599999995,0.750092106,0.977983552,0.0,0.0,0.741816488,0.0,0.0801701186,0.26598051899999997,0.220804045,0.25053111100000003,0.139497669,0.164364023,0.218481172,0.0,0.0,0.39216232700000003,0.005022783239999999,0.325203959,0.0,0.0,0.7979529390000001,0.0,0.008726645290000001,0.0,0.0,0.0,0.0,0.332599603,0.47645584399999996,0.0843234878,0.40164492700000004,0.0,0.231996653,0.6975844990000001,0.218806716,0.0175540203,0.0,0.14859536199999998,0.0,0.163796268,0.255210368,0.0,0.0,0.525890815,0.0,0.160190479,0.259224454,0.0,0.0,0.0,0.598822408,0.273040416,0.0,0.8801954120000001,0.15142414199999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.34956474,0.196546293,1.6325018999999998,0.47545475600000003,0.0,0.272527896,0.0,0.545311924,0.0,2.94693889,4.30229264,0.0,1.19481145,0.0,0.31022778100000004,0.0,0.121370257,0.195096162,0.701362575,0.0566554231,0.7947198520000001,0.0,0.292287198,0.0,0.259905057,0.0,0.71333871,2.66618624,0.0,0.444394626,0.06522445240000001,0.408323703,0.0,0.025019721499999998,0.0,0.0348796083,0.0,0.05849909230000001,0.0,0.69050735,1.03412876,0.0,0.0,0.0413068148,0.0,0.0771490879,0.0,0.117443158,0.0,0.18698263399999998,0.0,0.892738315,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.362640581,0.0206530808,0.0,0.0,0.0,0.0365992073,0.0624395455,0.046009031799999996,0.014555376799999999,0.0,0.0174783296,0.0607628163,0.104613104,0.12239767800000001,0.10213648199999999,0.0543450412,0.00678713593,0.0,0.0121654394,0.062819915,0.103282329,0.0923325867,0.00981121306,0.0,0.0,0.0,0.0,0.186308323,0.6570094910000001,1.1583881999999999,1.54573747,1.69349741,1.54498835,1.14003774,0.607360091,0.12207171800000001,0.0,0.0,0.129098921,0.546263296,0.9288519140000001,1.11593668,1.02378925,0.6777359409999999,0.201059618,0.0,0.0,0.0,0.0,0.151117979,0.451183392,0.561784566,0.433628674,0.12088019400000001,0.0,0.0,0.0,0.0,0.33335836399999996,0.98267009,1.6015785,2.06860078,2.32426836,2.3768745,2.2805225,2.09905231,1.87447822,1.61470066,1.30462297,0.932643261,0.516647548,0.11384531099999999,0.0,0.0,0.0,0.0,0.28550726,0.547134528,0.658711815,0.582101303,0.359458874,0.0952781925,0.0,0.0,0.0155689643,0.224191967,0.37708062200000003,0.356020985,0.118657934,0.0,0.0,0.0,0.0,0.22309694300000002,1.32444836,2.57686694,3.69159445,4.40550825,4.56482151,4.16956084,3.36368471,2.37702497,1.44345835,0.7275083440000001,0.286105718,0.07626222349999999,1.11836645e-17,0.0,0.0,0.0,0.0,0.123613587,0.44797421299999995,0.8588495540000001,1.243265,1.47363119,1.45989751,1.18938009,0.736233727,0.235726278,0.0,0.0,0.0,0.0,0.07719711480000001,0.25076556899999997,0.28912297600000003,0.19006505,0.015125540500000001,0.0,0.0,0.0,0.025526342900000002,0.210130893,0.328757401,0.32318605899999997,0.18989656600000002,0.0,0.0,0.0,0.0,0.0,0.182348443,0.448440567,0.642363659,0.727710359,0.715170243,0.653315161,0.604513665,0.61696358,0.704610475,0.8425641909999999,0.9786752329999999,1.05532651,1.03194581,0.899416357,0.681725074,0.425719368,0.184292223,0.0,0.0,0.0,0.0,0.0,0.0426715943,0.102649246,0.135978107,0.13889834,0.115541517,0.0763157101,0.035329276,0.00647492816,0.0,0.0109250273,0.0322894851,0.0440673725,0.0288073577,0.0,0.0,0.0,0.0,0.0,0.212354557,0.527718936,0.8643524220000001,1.13053173,1.23883204,1.13826555,0.8373365009999999,0.40783178299999995,0.0,0.0,0.0,0.0,0.0,0.24329124100000002,0.570390495,0.7807989000000001,0.8538199129999999,0.8392158759999999,0.835949788,0.94999549,1.2475166000000002,1.72191435,2.28814319,2.80723255,3.13225114,3.15864447,2.86024489,2.29788844,1.5981544,0.9110098,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
8.45016879,5.825906,0.0,0.0,0.29990605,0.07122854,0.0,0.15652035,0.0,0.0,2.11031359,0.89251836,1.59756673,1.67098758,0.0,0.0,0.36943293,0.0,0.0,0.0,0.0,3.39623162,0.0,2.39290836,0.0,1.07506687,0.0,2.17252757,0.0,1.71025453,0.29391585,0.0,0.60091868,0.92299322,0.93399221,0.21320739,2.68546587,0.0,0.0,0.81141774,0.0,0.0,2.98640939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.51195823,2.72319126,0.628162181,0.0,0.827761009,0.0,0.0,1.30267194,0.0,0.0388582778,0.0,0.0,0.9212343690000001,0.0,6.30793018,2.63731243,4.31136734,3.19100877,0.647814745,1.12726786,0.0,0.0149103495,0.581409546,1.56255249,1.53766109,0.0,0.0,0.0,0.0,3.37912873,0.0,1.17034126,0.12483780300000001,3.52769037,5.57764075,1.14991809,0.0,2.55279892,1.60055589,0.0,0.0,0.579051755,0.0,0.0,1.61907762,2.66434354,0.0,0.7032650429999999,1.91499051,0.0,0.643477384,0.0,0.0,0.0,0.64464817,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.055342057,0.0,0.0,0.162264101,0.091310571,0.0,0.0,0.0769319401,0.11640069199999999,0.0,0.0,0.0027159810700000003,0.125015947,0.039550504,0.0,0.0,0.746737379,3.10615332,6.12478673,7.78010399,6.45497653,2.91820032,0.0,0.0,0.605965765,1.1677045,0.38735529,0.0,0.0,0.429064961,0.44908631600000004,0.0,0.0,0.025936205299999997,0.344232131,0.06823106129999999,0.0,0.0,0.230501708,0.193475342,0.0,0.0,0.0949675207,0.24847012100000002,0.0,0.0,0.0828499484,0.580032004,0.656827934,0.30397117100000004,0.0215400719,0.029919843199999997,0.0691263952,0.0,0.0,0.0131864171,0.116049636,0.019263539099999998,0.0,0.0,0.0983791894,0.0777055225,0.0,0.0,0.045217335,0.10279069099999999,0.0,0.0,0.0,0.07883181480000001,0.0288486914,0.0,0.0,0.0,0.0,0.0893562069,0.6389610729999999,1.17012785,1.01991403,0.246287592,0.0,0.0,0.27699425699999997,0.196341181,0.0,0.0,0.38765869399999997,0.781375167,0.570201974,0.21198804699999999,0.260288043,0.49987082,0.395744569,0.0384485445,0.0,0.35675860600000003,0.570429251,0.342668497,0.060308358799999996,0.0892674745,0.18673916699999998,0.013804116699999999,0.0,0.0,0.210378503,0.149470384,0.0,0.0,0.147074726,0.293773532,0.0,0.0,0.0,0.401489892,0.142056955,0.0,0.0,0.419608594,0.492250535,0.0,0.0,0.807807352,2.28805022,1.51370191,0.0,0.0,4.17352785,10.817374800000001,13.832432699999998,11.0350086,5.41333648,1.29051302,0.036555550299999996,0.12145370400000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.248
0.7241406659999999,1.69973479,1.94945254,1.49040445,0.68473876,0.12890199300000002,0.0,0.0,0.0,0.483494384,0.670267698,0.0,0.348580255,0.0,0.141352121,0.193551069,0.0,0.0,0.45744682,0.0,0.335578948,0.0,0.47430090399999997,0.475787604,0.145633269,0.45184888799999995,0.123348512,0.0,0.0,0.0053865966500000004,0.54546273,0.147354443,0.586642592,1.67275326,2.4513342999999996,2.55628928,2.71152465,2.88431737,2.60611196,2.8971443999999997,2.06084922,0.8558674009999999,0.27509890800000003,0.24731301,0.00875429543,0.492906012,0.107191248,0.778399928,0.0,0.0,0.0,0.434038751,0.0,0.0,0.37542472200000004,0.0,0.275501127,0.13954450300000001,0.189757856,0.639635401,0.0,0.0,0.0,0.0,0.623928087,0.28682043100000004,0.135744541,0.0,0.0,0.0,0.206821953,0.31484686,0.0,0.0,0.0,0.8252371559999999,2.19737029,4.40846624,5.26879131,4.54448281,2.26732095,0.261507635,0.0,0.0,0.0,0.501735412,0.977288348,0.17920364100000002,0.0,0.0,0.17565423300000002,0.33114177300000003,0.451176022,0.0,0.294373829,0.13606210000000002,0.27657381,0.409651717,0.0,0.462346239,0.244764134,0.0,0.191772255,0.0451204875,0.0933453078,0.602168141,0.0,0.0,0.0,0.0,0.61411019,0.0,0.0,0.0,0.0,0.41205524,0.532281134,0.462435584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.17759709899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.552617936,0.07015395719999999,0.82977789,0.0,0.0,0.845110907,0.0,0.0,0.0,0.208823421,0.0,0.50946044,0.0,0.0,0.421707861,0.0,0.0,0.390453816,0.21927784399999997,0.468260113,0.225184257,0.0,0.0,0.369110685,1.8686171999999999,0.0,0.148341164,0.0,0.0,0.0,0.0,0.0,0.6462361879999999,0.0,0.0,0.976877839,0.316582762,0.522843364,0.0,1.15869232,0.856176472,0.568469885,1.05028147,0.0,0.355030574,0.0645652634,0.0631747635,0.0,0.0,0.154040075,0.586286006,0.0,0.0973642774,1.35200772,0.0,0.566364863,0.0,0.142111046,0.331393304,0.0,0.0,0.0,0.520871933,0.45108747,0.46586128200000004,0.0,0.9105511079999999,1.61955049,1.05332725,0.0,1.55286256,0.815613626,1.55825246,2.03638446,2.49292654,0.0,0.89125763,1.98194537,0.683804138,0.10941921199999999,0.666907299,1.5979021999999998,1.41473318,0.484330589,1.39055227,1.15961637,2.4388622000000004,1.5612723,2.10722512,0.0,0.0273103657,0.0,0.193669233,0.0,0.0,1.04641655,0.922864033,0.535381491,0.62253355,0.0,0.0,0.0,0.20490318899999999,0.20988742800000001,0.0,0.719256606,0.0800635518,0.578862514,0.633448992,0.0900667514,0.09107181119999999,0.802567735,0.569232683,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18504002100000003,0.231496853,0.466509378,0.36117064600000004,0.407178964,0.0,0.0,0.762103625,1.41315932,1.13675388,0.700659734,1.66048013,0.39001075700000004,0.0,0.337678462,0.760791125,0.0,0.0,0.027208687000000002,0.0,0.0,0.9608402070000001,0.09482992539999999,0.20596366800000002,0.0,0.140497615,0.16734653300000002,0.6975039009999999,1.24749646,0.580192778,1.96617843,0.69452493,0.939336582,0.0,0.0,0.11568379300000001,0.0,0.276466724,0.787906221,0.22267036,0.106889949,0.0,0.0,0.27045259,0.0,0.0,0.479418182,0.15994176300000001,0.529080179,0.7009773979999999,0.0,0.0,0.0,0.0601876666,0.0,0.7020991129999999,0.543875229,0.41889385,0.272499078,0.362854257,0.18419349699999998,0.587702088,0.0,0.311384928,0.0,0.0,0.0,0.0,0.0,1.25525801,0.493944293,0.558971311,0.46032113700000005,0.943083208,2.43124151,3.00293615,2.08902762,2.21307898,2.31844326,3.18057682,3.7099349999999998,2.23562945,1.38008198,0.0,0.993977177,0.156915558,0.0189021726,0.571913249,0.40653117200000005,0.0,1.58450887,0.37155657700000005,0.247152526,1.61533758,0.6938696440000001,0.34766765299999997,0.0,0.33019678199999997,0.24119691899999998,0.0,0.0,0.0,0.687211793,0.323017985,1.02515627,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
10.12114541,6.65840363,1.66704036,6.28060436,0.0,11.13994809,16.13567411,0.0,0.0,3.81669302,0.0,1.27870799,0.30448624,0.0,0.66964188,0.0,0.25692305,0.0,0.0,1.38269088,0.0,0.0,1.11654296,0.36839644,0.0,2.15237417,0.0,0.0,0.64112913,0.16122701,0.64444397,1.36376176,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.237
0.5448923170000001,0.883535829,0.354586296,0.0687745815,0.47256992299999995,1.69209714,0.0,0.693484436,0.110443259,1.55784655,2.91321258,0.8627921909999999,0.0,1.29220436,0.035090028599999996,0.04283728059999999,0.0,0.0389612928,0.0,0.00380078261,0.134343422,1.03286574,1.40493162,0.11121071099999999,0.330406475,5.35177985,0.31260276800000003,0.12559506,0.0,0.102910001,0.0,0.097244974,0.0180584666,0.0494529913,0.0160872814,0.24763301,0.0,0.360157858,0.613481443,0.0,0.0737615553,0.0,0.36514887,0.8612420270000001,0.0337588608,0.52341427,0.441274335,0.19629438,0.361683135,2.01367384,0.35719172,0.304818756,0.10681749199999999,0.427177295,0.280375541,0.0145292756,0.0784649473,0.0698999049,0.0,0.140547073,0.21486780600000002,0.21554778,0.0695490697,0.0,0.0,0.00276282142,0.0031401855499999997,0.0,0.051960850700000005,0.0729234102,1.7440179,2.74349811,0.559191304,0.499521461,0.0,1.71555196,1.05694371,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.25965302100000004,0.33749085100000004,0.0725691439,0.10940075699999999,0.24611135899999997,0.0,0.0,0.378145391,0.575060647,0.837362295,1.23221921,1.76185763,1.6783997,2.10858701,1.98887681,2.01225047,1.92053341,1.32909414,0.7472387159999999,0.397617692,0.074770226,0.318494898,0.537606801,1.02013374,1.77966709,2.43592026,2.52742836,3.26651599,3.09612477,2.82711138,2.73987616,2.27932524,1.55044188,1.22712105,0.427549756,0.275486035,0.0210841779,0.238579635,0.0,0.0745832956,0.0021926986899999997,0.238024944,0.121634533,0.0,0.0,0.0,0.0,0.0,0.115977267,0.200849912,0.34937712200000004,0.0954063123,0.312031331,0.10192350900000001,0.0,0.162851139,0.0,0.0,0.0,0.0,0.007556940890000001,0.0,0.247728995,0.0847768106,0.0684317629,0.38971660399999997,0.0,0.0,0.0,0.0,0.0,0.21376248,0.392247429,0.313713915,0.699493393,0.7628161259999999,0.863180345,0.45982673,0.505267103,0.18973753,0.16649275800000002,0.342029329,0.0,0.231553393,0.0,0.146592812,0.0,0.285922317,0.0,0.0536267909,0.39412619600000004,0.35276734,0.0,0.0,0.0,0.289541562,0.0,0.21544109399999997,0.183144117,0.0,0.10455347300000001,0.226328155,0.144829929,0.248200835,0.0,0.325903638,0.0769956945,0.061950135999999996,0.0,0.189005653,0.20639410100000002,0.0,0.0,0.0322677587,0.0,0.0,0.40984992,0.59395498,0.96104393,1.16551996,1.45259937,1.86054227,1.58167501,1.99710871,1.28593752,1.29806805,0.521005805,0.570177212,0.186286795,0.0,0.0,0.0,0.22581162800000001,0.32444356,0.42172245399999997,0.220024432,0.5499498110000001,0.0,0.0561958916,0.23826008,0.183008671,0.0,0.0656220373,0.458529015,0.508204946,0.523281979,0.058038918200000005,0.105301576,0.600783854,0.195309882,0.28489041800000003,0.196777302,0.12954802,0.24342466199999999,0.0,0.138820482,0.229953978,0.0,0.120916812,0.165991041,0.146405905,0.0,0.0,0.0,0.135009949,0.0,0.0,0.0730919153,0.0,0.04824193,0.191599021,0.0,0.271584372,0.15419936,0.0,0.0,0.200249428,0.00428832996,0.0,0.0,0.0913796041,0.0,0.06600764049999999,0.0459998472,0.0,0.0,0.076788857,0.15153287099999999,0.0908790089,0.007306940140000001,0.09785717529999999,0.0834013913,0.120300059,0.298130354,0.21865695899999998,0.0,0.0,0.0130727899,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0878323409,0.025231352999999998,0.45158184,3.21171292,6.30003733,5.5138548,1.5478747,0.0,0.0,0.42573312,0.0,0.0,0.162318892,0.0910328086,0.0,0.0128117494,0.138090544,0.0,0.0,0.12043949300000001,0.0101552378,0.0,0.058173626900000004,0.091318438,0.0,0.0,0.139383375,0.0,0.0,0.133352928,0.07511509129999999,0.0,0.0422765619,0.320070483,0.0,0.0,1.30661708,3.1920362,3.16614993,1.59359125,0.256384435,0.0,0.0,0.0750614948,0.0,0.0,0.06509063150000001,0.027016944100000002,0.0,0.0226144309,0.0757437272,0.0,0.310980759,0.723290388,0.221370659,0.0,0.425000534,0.965896871,0.282891035,0.900635794,3.71361121,4.62735236,1.71731225,0.0,0.0,0.656109078,0.0,0.0,0.471531366,0.665628189,0.11338783699999999,0.011950018,0.09424821779999999,0.0,0.118564289,0.34580600100000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.81726505,2.15910728,2.15967616,1.89418958,2.48511472,1.8113408,1.70298893,1.86504928,1.65679548,3.07150174,1.8713904,1.89990837,1.26664046,1.18471269,0.750637168,1.60368038,0.857488215,0.959034948,1.81969126,0.973437023,0.40362366200000005,0.480851146,0.6875597090000001,0.639848448,1.2322374,0.0,0.5424474970000001,0.433109387,0.0,0.436038281,0.0,0.694550552,0.20388181600000002,0.7434826440000001,0.0,0.0,0.038864336,0.191609103,0.0,0.165037254,0.0,0.0,0.0,0.0374084584,0.602918872,0.168108772,0.426777025,0.0658343953,0.506495561,0.0,0.0,0.0,0.52277357,0.0708984394,0.0,0.347053936,0.0,0.0455755546,0.0043437684100000006,0.0,0.722945976,0.0,0.167237359,0.0,0.270914534,0.61137671,0.049482407,0.959537805,0.12902819599999998,0.387106305,0.0,0.0,0.44051777299999995,0.219387508,0.0766359462,0.412185454,0.0,0.31717465100000003,0.0,0.0,0.17062092199999998,0.0,0.0,0.346131266,0.0,0.0,0.29344409899999996,0.0310988808,0.43041987299999995,0.826829183,0.0601093504,0.0415657273,0.194585719,0.0,0.34172163,0.44488927100000003,0.69289877,0.0630197895,0.0,0.0293245111,0.27554379,0.0172804286,0.352290307,0.62678494,0.132282656,0.702774479,0.0,0.301772312,0.662950493,0.0,0.0,0.06950049330000001,0.34125495299999997,0.892506695,0.0,1.04364936,0.00767387728,0.439014655,0.0,0.0,0.0,0.0,0.464530702,0.0,0.0,0.589783209,0.0,0.636116865,0.138540375,0.283908969,0.080607124,0.16973653,0.0,0.628002492,0.0,0.0,0.0,0.292187687,0.290942812,0.0,1.29562363,0.09097438210000001,0.506083586,0.0,0.0,0.0,0.0317602986,0.0285125917,0.793398788,0.10164514300000001,0.0,0.0,0.00913480105,0.0652386613,0.0,0.0,0.0,0.383705013,0.0,0.630969275,0.0,0.205110595,0.7882687079999999,0.0,0.0,0.0,0.443461325,0.0,0.101018137,0.0,0.0,0.0522079892,0.8374706000000001,0.0,0.0,0.0,0.5401017770000001,0.47786850700000005,0.0,0.0,0.6187304570000001,0.307385766,0.0,0.58303021,0.0,0.388268978,0.0,0.0,0.0,0.7712330390000001,0.0,1.70023747,0.962800323,1.99582749,1.14614536,1.41295498,1.0580368999999998,0.750745353,1.87083677,1.24128927,1.64432211,1.80409494,1.98930137,1.92422606,2.02655608,2.2134956000000003,2.0014853,3.14419779,2.84590927,2.87366508,3.14504325,2.62970285,1.95272247,2.20844405,2.03959579,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.134970032,0.22847931100000002,0.348941684,0.477877156,0.59807285,0.697539591,0.7723785479999999,0.8279296340000001,0.877901174,0.9415765620000001,1.03958301,1.18901424,1.39886165,1.66669167,1.97730872,2.30379624,2.61089345,2.86022338,3.01651982,3.05377867,2.96022764,2.74117741,2.41916238,2.03123946,1.62380935,1.24576635,0.941091133,0.742116872,0.664602345,0.705448447,0.843450136,1.04296075,1.259851,1.44875752,1.57040398,1.59777722,1.52015119,1.34433309,1.09299078,0.80042132,0.506549049,0.250224221,0.0629818453,0.0,0.0,0.0379770927,0.17942278,0.35458798,0.532545434,0.685764714,0.794581561,0.849945979,0.8540441670000001,0.8187972809999999,0.76263199,0.706221975,0.668062461,0.660735627,0.688559632,0.747023744,0.8240553340000001,0.902810308,0.9653938790000001,0.996755232,0.987985125,0.93837844,0.85587486,0.7558093570000001,0.658227663,0.5842889920000001,0.552439696,0.575069821,0.656257965,0.790992665,0.96597527,1.16181548,1.35618253,1.52731761,1.6572733,1.73432592,1.75418771,1.71988749,1.64044266,1.52866259,1.39856241,1.2629048,1.13132218,1.00932138,0.89827198,0.796270762,0.699601555,0.604405813,0.508162745,0.410648257,0.314180436,0.22313332100000002,0.14287131,0.07838653549999999,0.0329835845,0.007337892579999999,0.0,0.0035668991700000003,0.0140479645,0.023864645,0.027503852999999998,0.0218799592,0.00698586636,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.035450144100000004,0.0667487718,0.0859312258,0.087079534,0.0679186395,0.0307040879,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.052489521399999996,0.123364973,0.175070707,0.192933624,0.167708902,0.0982896263,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.110480761,0.426926728,0.78650625,1.15093928,1.4783932,1.72955662,1.87352613,1.89252888,1.78468313,1.5643208,1.25980444,0.9091947979999999,0.554487531,0.23537592699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0531707585,0.14835094199999999,0.204744588,0.213544982,0.176578155,0.104937832,0.016000785400000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0131303405,0.08131848309999999,0.129150128,0.14734365800000002,0.133225178,0.0910365365,0.030799865099999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0495649203,0.0932770208,0.11499223,0.11067338800000001,0.08237638900000001,0.0378258432,0.0,0.0,0.0,0.0,0.0,0.031859459799999996,0.104678652,0.175458846,0.228770721,0.25177329,0.23711199600000002,0.184822868,0.10281543900000001,0.00578183399,0.0,0.0,0.0,0.0,0.0,0.0313781378,0.18075044699999998,0.337923178,0.47942523600000003,0.584058836,0.63675147,0.6313265779999999,0.571656931,0.47096889200000003,0.34941887,0.230397345,0.136265605,0.084345725,0.08394121859999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
6.94296493,6.01599096,4.27328728,3.11508007,2.08295378,0.6881104579999999,0.0,0.0,0.0,0.0,0.565183122,0.7639955970000001,0.681130727,1.04571905,2.22223282,1.8569950000000002,1.37209955,0.557275347,0.520842089,0.349759803,0.0,0.0,0.0,0.0,0.0,0.443144272,0.0,0.402141956,0.112310911,0.482194988,0.871295851,0.165727676,0.0,0.0,0.0,0.0,0.0,0.0,0.301546594,0.371526453,0.0,0.877064981,0.12149190300000001,0.0,0.478285247,0.189721269,0.0,0.0,0.0,0.0,0.21684566,0.0,0.8287519640000001,0.289468333,0.0,0.35851807700000005,0.7294480959999999,0.0,0.0,0.412040264,0.0,0.0,0.0,0.0,0.0,0.0,0.804806303,0.0,0.0,0.0,0.0,0.08093030820000001,0.0,0.0,0.39060364799999997,0.658176022,0.6977401259999999,0.0,0.08950235179999999,0.0,0.0,0.0902792532,0.0,0.0,0.341647152,0.5222164579999999,0.0,0.0,0.421166544,0.18672952199999998,0.0,0.0,0.261804311,0.44164556200000005,0.0,0.0,0.0,0.0,0.50960954,0.0,0.0681021605,0.0,0.0,0.38801229,0.49360376,0.46685247399999996,0.49053093299999995,0.0,0.335804361,0.0,0.0513501337,0.17386560899999998,0.0,0.0,0.240800345,0.0,0.0,0.22446642100000003,0.0,0.5111463070000001,0.0,0.6457936989999999,0.5040859010000001,0.0,0.512515544,0.601956164,0.380338744,0.0,0.418349769,0.0,0.0,0.231619148,0.0,0.0653777052,0.0,0.392147955,0.164186738,0.316348097,1.11757068,0.0,0.684233055,0.0,0.168697723,0.0,0.0,0.0,0.0,0.41239937600000004,0.40707418100000003,0.591196078,0.7158045390000001,0.999879416,0.824614162,0.0,0.016712174,0.0,0.0,0.0,0.0,0.0,0.955688332,2.01513266,3.84220752,4.90942418,6.77105273,7.01790125,7.21151147,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.31694723,0.91305924,0.0,0.86396542,0.0,0.0,0.22936979,0.32120429999999994,0.24522948,0.22855599,0.88109912,0.0,0.0,0.28597808,0.85644857,0.0,0.91800552,0.0,0.34505747,1.17801909,0.0,1.35487315,0.0,0.0,0.22596961,0.0,0.0,0.16091134,1.07286218,0.7171074000000001,1.24838426,0.0,1.24205224,0.8108819,0.0,0.18805539999999998,0.0,0.0,0.0,1.44998366,1.09532008,0.0,0.22993782,0.0,0.22110893,0.0,0.0,0.0,0.0,0.0,0.0,0.47986937,0.57527693,0.0,0.0,0.0,0.13510287,0.91568396,0.45211219,0.0,0.0,0.0,0.0,0.37326039,0.73121808,1.05116987,1.80703095,0.28613039,0.43429346,1.41515899,1.30447836,1.34921757,0.35801055,2.11792331,1.39887775,0.0,0.0,1.43046079,1.72256231,1.74211362,2.69723737,2.16571126,2.50311606,4.77632591,2.43553294,3.35060423,3.78266073,2.76179061,1.59980591,1.27124611,0.0,0.0,0.44334399999999996,0.0,0.0,0.0,0.59163378,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.656200097,0.6043620439999999,0.0,0.0,0.0,0.0,0.0,0.44971017399999996,0.71641925,1.04047506,0.940794921,0.648607731,0.9262413190000001,0.0,0.187132565,0.0,0.0,0.673411023,0.0,0.348911992,0.0,0.363607148,0.19176251600000002,0.0,0.6921799479999999,0.5580531910000001,0.0,0.0,0.670152127,0.314485438,0.669256361,0.275754434,0.0,0.0,0.335026204,0.387057108,0.0,0.23689159699999998,0.118438893,0.0,0.0,0.560272604,0.507576623,0.0,0.0619981915,0.92392492,0.6731760809999999,0.7456149540000001,0.0,0.551822554,0.0,0.590572203,0.41318731200000003,0.323351648,0.31884176399999997,0.336882668,0.157109111,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.687862874,0.6734255929999999,0.0,0.0,0.0,0.162174908,0.539582377,0.0,0.0,0.150482699,0.459870616,1.41504236,1.95717684,1.20150876,0.912337334,0.0,0.13556616,0.0,1.2715906000000001,1.4342617,1.99258786,1.55697936,2.02458375,2.89726817,4.41103163,5.25470671,5.99600504,5.03767798,3.98262896,2.91775241,3.47639201,3.04845917,4.00734631,2.9430615,1.77436738,0.247833925,0.0,0.0,0.35148571100000003,0.43422382,0.0,0.0,0.0,0.0785820517,0.0,0.89541018,1.24729008,0.345016345,0.0,0.612400088,0.0930313104,0.853831905,0.35519783299999996,0.394124944,0.0,0.13440560699999998,0.0,0.705382594,0.0756420067,0.0,0.0610807538,0.306936781,0.0,0.6204625770000001,0.084271586,0.0,0.0816426787,0.0,0.170978302,0.331702812,0.49576884600000004,0.0,0.0,0.0,0.0,0.0,0.526387989,0.0,0.440526631,0.318371845,0.49959365200000005,0.0,1.0262062,0.743457082,0.045328658,0.8093795309999999,0.426426325,0.0,0.309986487,0.0,0.769248877,1.63695367,1.83897204,1.48378505,0.643496732,0.18596619,0.0,0.0021343720000000003,1.27265244,2.33336388,3.0992554,2.05861529,2.19013977,1.01036315,0.0973684695,0.586218712,0.0,0.0,0.0,0.0709194375,0.0,0.0,0.0,0.0701836371,0.8963894790000001,1.55309518,3.11337939,4.54641582,5.24254036,4.69578573,4.21797385,1.93903939,1.02676216,0.8305421129999999,0.35346416399999997,0.440918662,0.0,0.436080531,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.281977193,2.24028528,2.21575419,0.0,1.42887957,0.0769127867,0.277515494,0.0,0.43746247,0.0,3.39343873,3.43338266,0.95210957,0.183397554,0.139423993,0.0,0.21013253899999998,0.0,0.730622296,2.03549187,0.724876684,0.959504838,0.0,0.06712131660000001,0.0,0.00633060647,0.310574727,0.0,0.6737659429999999,1.0925124,0.365957714,0.927773812,0.08651935320000001,0.0,0.431634644,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.141867642,0.045636382,0.0,0.0,0.0,0.0,0.042990697800000005,0.151491699,0.284149685,0.431181535,0.582567013,0.729162057,0.8635443770000001,0.980492107,1.07706209,1.15230222,1.20669141,1.24144107,1.25780812,1.25655877,1.23768721,1.20044077,1.1436416,1.0662363000000001,0.9679581759999999,0.849961179,0.7152841999999999,0.569029523,0.418186334,0.271091163,0.136581962,0.022960215699999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0072170896299999995,0.0598084093,0.10066406800000001,0.123603844,0.12567152199999998,0.10749929400000001,0.0731349924,0.0293504942,0.0,0.0,0.0,0.0,0.0,0.0,0.037523154100000004,0.098992469,0.157844591,0.20464641,0.23144585399999998,0.233063787,0.20798001,0.158667061,0.0913092745,0.0149395266,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00229870845,0.0713538931,0.128883848,0.165776282,0.17613393100000002,0.15821902699999998,0.114757126,0.0525441174,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0362864097,0.10611101099999999,0.159688652,0.188112697,0.186416608,0.154443946,0.0969551084,0.022936916499999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07553325849999999,0.145033907,0.192850611,0.21323245300000002,0.20651792,0.17968549399999997,0.145784939,0.122252616,0.128293084,0.18167089399999997,0.295375333,0.474676321,0.7150699070000001,1.0015155,1.30920419,1.60588849,1.85557691,2.02318333,2.07955384,2.00619722,1.79903933,1.47060874,1.05023667,0.582095275,0.121177141,0.0,0.0,0.0,0.0,0.0,0.389394366,1.13450599,2.01193938,2.95272313,3.87842817,4.70918915,5.37204189,5.80860832,5.98122979,5.87683177,5.50807432,4.91166994,4.14409084,3.27519868,2.38057193,1.53344902,0.7972322159999999,0.219406617,0.0,0.0,0.0,0.0,0.0,0.23461216399999998,0.516916464,0.759601475,0.930570954,1.01152411,0.9988605690000001,0.90262153,0.74374328,0.5501047370000001,0.35198113,0.17755748300000002,0.049106503899999994,0.0,0.0,0.027393856,0.123765733,0.245015404,0.369941917,0.478541691,0.554905436,0.589305709,0.579217815,0.52918821,0.449639709,0.354855679,0.260494929,0.181040805,0.127577193,0.10621504699999999,0.11737850300000001,0.15601878,0.212679073,0.275206571,0.33081703,0.368175341,0.379166712,0.36009383100000003,0.312134457,0.24101493699999998,0.155978637,0.0682353563,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0463960181,0.0924576779,0.12324739300000001,0.1336945,0.12233597800000001,0.0914205824,0.0464108185,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.014227230700000001,0.053927085,0.0821204516,0.09458216230000001,0.0901681125,0.071080193,0.042568768300000004,0.0121150146,0.0,0.0,0.0,0.0267772793,0.0868477637,0.16676035,0.258910834,0.353210908,0.43844431799999994,0.503831438,0.540574611,0.54315882,0.510218272,0.44484348100000004,0.354285556,0.249101932,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.19974636,0.0,0.260364796,0.215776135,0.28421310699999996,0.531329551,0.32983230399999997,0.562086117,0.744953761,0.540293915,0.0671097633,0.270766987,0.167309384,0.279274819,0.0,0.33549325399999996,0.252084023,0.13970343300000002,0.0,0.11817122599999999,0.0,0.262141792,0.22498848100000002,0.0,0.257164028,0.0,0.316906393,0.412654687,0.46429043299999995,0.361242015,0.40644376600000004,0.49655420299999997,0.320144268,0.111922214,0.34310393899999997,0.224030378,0.151664781,0.0,0.0,0.0,0.0,0.112562014,0.0,0.196046909,0.700385375,0.493286039,0.921458302,1.15556002,1.17710374,1.47746896,1.4592419,1.30002011,1.09701874,0.778342619,1.02531306,0.7406689940000001,1.20091913,1.11464457,1.64199693,1.73031274,1.6420384999999997,1.41191332,1.02500307,1.05440142,0.483020571,0.146939019,0.141849237,0.074116931,0.141029241,0.251487484,0.367416664,0.744020052,0.7999593209999999,1.09003648,0.582177121,0.40484582700000005,0.0396946272,0.0,0.0,0.0197747566,0.06833937129999999,0.49706423899999996,0.457213327,0.575118463,0.141368303,0.169237804,0.0215526965,0.0,0.0,0.0,0.0,0.0,0.37144093899999997,1.03879074,1.33107515,1.54716311,1.34575734,0.912371858,0.7937422129999999,0.19785353600000002,0.0,0.11796940199999999,0.0908685396,0.693234302,1.68919625,1.87333533,2.72540556,3.08695376,2.59903516,2.15101101,1.66855006,0.7927176359999999,0.28756418899999997,0.0,0.0,0.0,0.113102189,0.42113092700000004,0.708981965,0.869636634,1.15211837,1.02695609,0.738394275,0.518705093,0.135502607,0.0,0.0,0.185121968,0.25884832399999996,0.37649706299999997,0.853918609,0.609226135,0.7420983640000001,0.747744692,0.31777243899999996,0.347396483,0.0,0.335104336,0.234139348,0.309365141,0.23252403600000002,0.529497381,0.513293431,0.488457855,0.366938279,0.0,0.0135225613,0.00439868857,0.0,0.0,0.0,0.738344744,1.04658787,1.09925092,1.49110994,1.4995438,1.79730576,1.67470816,1.08141905,1.14652945,0.692808889,0.8120466359999999,0.757514947,1.08394337,1.25049986,1.58815983,1.32738653,1.43133558,1.12492981,0.9178112009999999,0.401268843,0.446594505,0.11987451,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.23677415300000001,0.0,0.186394812,0.0,0.22947598800000002,0.12253396400000001,0.250936004,0.0,0.243141512,0.0,0.08398932939999999,0.0,0.0,0.0,0.0,0.0,0.0,0.100514958,0.0,0.0,0.121474656,0.050621896500000006,0.0,0.0,0.0,0.269870434,0.025612813999999998,0.0,0.27003685899999996,0.21558138,0.0,0.0,0.0,0.0,0.0,0.0991640734,0.0,0.22221759800000002,0.0430400182,0.155113441,0.0,0.061076069299999994,0.0,0.046765499,0.36764640299999995,0.542633971,0.6701174329999999,0.8557896999999999,1.43013324,1.52022038,1.93183777,1.62558316,1.83590373,1.43195485,1.23618133,0.741061912,0.18278117300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.11351021,1.13057556,0.0,0.39234887,1.32128236,3.80813966,5.07711064,5.46673525,6.75405255,2.32316214,0.62802268,0.50617086,0.14126647,0.0,0.0,0.0,1.1886164,1.62977244,0.0,0.0,0.0,0.41149029,0.24396088,2.21510102,0.0,0.0,0.47926658,0.0,0.0,1.32507118,0.0,8.31730375,5.93268897,0.0,2.67411704,1.55938933,4.16556972,0.0,0.88303026,0.12568221,0.0,0.0,0.59505053,0.0,0.0,6.2558751,0.0,1.4524045,0.0,0.0,0.0,0.84926555,2.71023483,0.0,0.0,0.28733383,2.76179777,0.0,0.86674201,0.86977131,1.67976572,0.0,2.0144964,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.210934177,0.25083510600000003,0.29085721800000003,0.36747716399999997,0.510418394,0.704242558,0.881609381,0.9574978559999999,0.884718188,0.694312308,0.49139628700000004,0.40380648700000005,0.510908801,0.794173882,1.14028754,1.39775146,1.45685756,1.30906092,1.05319968,0.8457503940000001,0.822872038,1.03599341,1.43301933,1.89067403,2.27607619,2.50272654,2.55358381,2.46554379,2.29163343,2.06696835,1.79781891,1.47590231,1.10378758,0.711775005,0.354032755,0.0862809175,0.0,0.0,0.0,0.0,0.0273936188,0.0293487844,0.0126091444,0.0,0.0,0.00283924483,0.00409978775,0.0,0.0,0.0,0.0,0.10009132800000001,0.274952427,0.49740084700000003,0.731789219,0.943333612,1.1096485,1.22315143,1.28417107,1.2903901000000002,1.23061698,1.08841823,0.855146803,0.545627692,0.206743677,0.0,0.0,0.0,0.0,0.218542486,0.5599454979999999,0.8432948459999999,1.00499841,1.03493835,0.973058922,0.88208492,0.810695974,0.7673302359999999,0.7197799840000001,0.621660511,0.45092176799999995,0.236953262,0.0573632617,0.00192025835,0.120947457,0.38720393799999997,0.696050284,0.9092257090000001,0.922750174,0.7233965440000001,0.401165595,0.10728037900000001,0.0,0.0592076031,0.288503177,0.522865034,0.621862372,0.525684477,0.288195778,0.0436716959,0.0,0.0,0.138786234,0.253233566,0.191920835,0.0,0.0,0.0,0.0,0.452083694,1.48590654,2.50853627,3.14301895,3.13091852,2.45479434,1.35486045,0.23059345399999998,0.0,0.0,0.0,0.49147235200000006,1.27859386,1.80317219,1.92295463,1.6640868999999998,1.17489496,0.642732131,0.21762184,0.0,0.0,0.0,0.08404741869999999,0.20852616899999998,0.297723575,0.334007437,0.321665441,0.283952485,0.253499378,0.255804637,0.29257727699999997,0.33624163,0.343319721,0.282940492,0.164414165,0.0440422896,0.00100487681,0.09120882179999999,0.304838432,0.556021335,0.7173598179999999,0.6856689770000001,0.443809116,0.0813526518,0.0,0.0,0.0,0.0459798495,0.396133567,0.627481779,0.6507556520000001,0.488576526,0.251255105,0.0653289505,0.0,0.0330226377,0.0828525547,0.0701102698,0.0,0.0,0.0,0.0,0.101687581,0.25836425399999996,0.273737086,0.10995218300000001,0.0,0.0,0.0,0.41279600899999996,1.22951494,2.05910306,2.59248977,2.62114706,2.13828064,1.34201581,0.539464072,0.0031455960600000003,0.0,0.030866952599999997,0.344916444,0.595375588,0.66591998,0.5623142289999999,0.37849880399999997,0.223062615,0.155338743,0.166911531,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.28643841600000003,0.0916416449,1.05395382,0.145777983,0.748837773,0.776186699,0.582660236,0.0,0.0,0.47489152,0.5709210220000001,0.559443192,1.05162436,0.0,0.835466693,0.198106676,0.350157196,0.0,0.7186789720000001,0.254020181,0.465758495,0.0,0.559015503,0.0,0.788404427,0.500313943,0.37391929399999996,0.0,1.1587371000000002,0.0,1.86284553,0.0,0.0218854674,3.68642971e-05,0.0,0.0,0.42861804299999995,0.583098749,0.0,0.53717635,0.0,1.21849346,1.19597762,1.77859675,3.35816428,3.06316111,2.83966052,0.7187739320000001,0.36499272299999996,0.0,0.14044454,0.791112371,0.0,0.0,0.80573906,0.916040237,1.23442041,0.0,0.0,0.0953538548,0.0781466826,0.0,0.190168334,0.0,0.0,0.0926213589,0.0,0.147416506,0.0,0.258100228,0.738912696,0.47186063100000003,0.169436803,0.0,0.0,0.47705534200000005,0.0,0.0,0.0,0.0,0.21844867399999998,0.249821968,0.0,0.45619108399999997,0.0,0.0,0.357545905,0.47126799700000005,0.49525574899999997,0.112015655,0.358147748,0.0,0.7733959290000001,0.0,0.707082001,0.0,0.0,0.0119782579,1.07252398,0.0,1.29249167,0.0,0.0,0.0,0.0,0.0,0.844679181,0.33421133,0.0,0.0,0.0,0.0,1.04442574,0.0,0.152644645,0.125818348,0.573983157,0.130787855,0.035260726,0.261296071,1.14663225,0.17695897800000002,0.162289285,0.0,0.5021951920000001,0.0,0.0,0.513222903,1.75967819,1.31987914,0.8972832759999999,1.74111235,0.845049719,0.15530085400000002,0.0,0.0,0.261167459,0.0,0.0,0.0,0.351874925,0.0,0.0,1.36674415,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
6.00462825,6.99706994,5.66892411,6.18477195,4.27347236,1.61991532,2.83447744,0.0,0.08044603,0.0,0.0,0.42837354,0.0,0.74318496,0.0,0.0,2.00233555,1.88077322,0.0,0.33022956,0.0,1.77442402,0.0,0.0,0.0,0.14212494,0.0,0.0,0.52586003,0.11984214,0.49956204,0.397858,1.67790875,0.8020215999999999,1.11087039,0.0,0.51834938,0.0,0.0,0.48608349,1.08358739,0.0,0.0,0.0,0.33837531,0.0,0.0,0.0,0.37467658,0.93957376,0.69658901,0.18141,0.0,0.0,1.5565544,0.75598473,0.35605168,0.05874355,0.84240506,0.0,0.49354153,0.14564836,0.70233811,0.67419224,0.0,2.27797002,0.66002826,1.63568415,0.0,0.98247464,2.82756527,0.0,1.25772012,0.0,0.31750868,0.26310137,0.14959078,2.4159783999999997,0.67625245,0.0,0.0,0.0,0.0,0.03907054,1.51670936,0.0,1.42274182,0.0,0.0,0.0,0.0,0.44805068,0.0,0.0,0.0,0.0,0.05987965,0.0,0.0,0.5734868000000001,2.00148637,0.0,0.0,0.13202718,3.5758818,0.0,0.0,0.0,0.0,0.9543162000000001,1.67871315,0.0877939,0.0,0.83639598,0.0,0.0,0.0,0.0,0.55828282,0.0,0.0,1.65266484,0.0,0.17849161,1.00546281,0.0,0.0,0.0,0.06602929,0.0,0.0,0.0,1.89145511,1.2396557,0.28568083,0.05165726,0.0,1.27754472,0.96062894,0.0,0.0,0.0,0.25685876,0.69259643,0.20908289999999996,0.0,1.20482143,0.0,0.70833955,0.0,0.55293349,0.0,0.04610231,0.0,0.13455572,1.84373043,0.0,2.48303463,0.58073077,2.04869836,2.35730494,0.7482667,1.13410713,0.0,0.06019911,2.56695678,0.1779169,0.0,0.81800958,0.0,0.56105983,4.9638196,4.62590566,4.68471925,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.37754364,1.21811212,0.0,0.0,0.0,0.0,0.0,0.49823914,0.1410625,0.0,0.40985761,0.16530291,0.0,0.48163992,0.0,0.0,0.0,0.34994379,0.87333553,0.07434185,0.0,0.0,0.0,0.38101134,3.37958496,5.02283488,4.84960602,3.68340257,1.68109133,0.0,0.12268203,2.60976998,4.56651106,5.45649013,4.50937927,2.26553732,0.43138812,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.72101521,0.0,0.0,0.0,0.0,0.10773881,0.46622074,0.62765854,0.21271034,0.27603902,0.0,0.98572318,0.0,0.48236147,0.15143604,0.0,0.0,1.2823968000000001,0.0,0.0,0.0,0.27788126,1.66151618,1.31829531,0.0,0.0,0.0,0.0,0.0,0.51878706,0.0,0.44381505,0.0,0.95117257,0.0,1.45064554,0.0,0.61848085,0.76525063,0.0,0.39123983,0.0,0.0,0.0,0.0,0.63841613,0.27817189,0.68683935,0.21350846,0.0,0.55153991,0.0,0.0,1.08159611,0.0,0.0,0.05386701,0.04057106,0.0,0.987399,1.01961559,0.63286715,0.0,0.07762557,0.0,0.0,0.54956892,0.0,0.0,0.0,0.83937386,0.0,0.0,0.0,0.0,0.0,0.0,0.45970407,0.57796214,0.52420186,0.20773633,1.13721905,0.93722674,0.37796183,0.34473682,0.0,0.52756797,0.05916394,0.0,0.59593233,0.17583078,0.0,0.29668692,0.08273707,0.07004355,0.0,0.0,0.2371631,0.0,0.0,0.07968914,0.0,0.0,0.35055765,0.11894239,0.97247327,0.24931515,0.27976614,0.70022788,0.09083285,0.28935511,0.0,0.79851513,0.96705442,0.83085809,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.74815036,0.0,0.0,0.0,1.615246,2.03423291,1.93915908,1.22520582,2.5485888,1.89628951,2.77214543,2.24386947,3.58317494,2.79696366,3.51592745,3.96273669,3.70954531,2.96288318,2.23313351,1.79767267,1.64976442,1.74864439,1.58083543,1.50905605,1.67122729,0.28102265,0.0,0.0,0.0,0.0,0.08603034,0.0,0.0,0.28497295,0.0,0.0388491,0.12885786,0.0,1.28706861,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5156042479999999,0.25343154,0.23272101899999997,0.0,0.14110777,0.80569379,0.0,0.0796830439,0.157930083,0.0,0.8326896859999999,0.620868995,0.0,0.0,0.29442164600000004,0.498869931,0.46878298799999996,0.0,0.550875078,0.0,0.0,0.513225997,0.547346484,0.0,0.1984849,0.0,0.046725288600000005,0.140901781,0.10756540699999999,0.7994018209999999,0.426767678,1.12286023,0.031132773,0.940740062,0.0,0.220403089,0.0,0.170631712,0.0,0.64753591,0.973848928,3.50546162,2.05557104,1.23495926,0.0,0.0,0.734919984,0.52607763,0.31023229399999996,0.239507942,0.6552267070000001,0.027548637200000003,0.0,1.55643563,1.8610621999999999,2.29764273,0.325120219,0.0,0.0,0.237716347,0.0,0.0,0.246960905,0.7838724640000001,0.0,0.25415469,0.0,0.0149837977,0.744079945,0.08599792880000001,0.0,0.0,0.13618529099999999,0.842316629,0.0,0.5436478220000001,0.0,0.023391064700000002,2.19347468,0.7741310509999999,0.12857027699999998,0.0,0.0,0.624946095,0.0,0.31039150600000004,0.0,0.117670994,0.39321920200000005,0.924014025,2.23583295,0.9635434390000001,0.550438093,0.40914130299999996,0.0,0.0,0.189843326,0.6818373590000001,0.48543428299999997,0.0,1.7785593999999998,2.70144633,2.23597081,2.44741943,2.21368696,2.75774338,2.83631687,0.666863227,0.0,0.0,0.854899595,0.637849453,0.0,0.8369727290000001,0.0265566483,0.0,0.0,3.51681739,7.93582413,8.23705033,4.54695811,0.0784159901,0.0,0.0,0.0,0.0,0.0,0.117933604,0.0,0.0,0.0,0.09070925880000001,0.0855483139,0.08183974200000001,0.0,0.0,0.029019261400000003,0.0,0.0,0.116848326,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.39788569700000004,0.0,0.0,0.0,0.14840123,0.120436821,0.17459682699999998,0.12272119599999999,0.207837091,0.0492759717,0.0,0.175299015,0.0,0.132269954,0.299690038,0.0,0.0,0.0,0.166545288,0.0,0.295268166,0.0,0.0,0.153408198,0.0358676377,0.0,0.1896016,0.191648273,0.033741642599999996,0.0,0.392585313,0.206461383,0.0,0.14080305699999998,0.136569478,0.0,0.0,0.245477175,0.0,0.0,0.33884266399999996,0.287195799,0.0,0.0,0.0,0.0,0.360722066,0.0288263141,0.40973399299999996,0.0196785181,0.175181552,0.0,0.0,0.0,0.29828149,0.444114966,0.319856237,0.408331491,0.0,0.0,0.0,0.0,0.0694870156,0.639484692,0.619454841,0.9878400629999999,1.13840823,1.46323019,1.19564924,0.725883342,0.8139939540000001,0.7011420629999999,1.89072419,2.63353459,3.12547136,3.47164973,3.2313028999999998,2.8965657000000005,2.39258684,1.11131686,0.550171555,0.0,0.118203503,0.0,0.41712797700000004,0.298508492,0.38054648,0.0,0.17320317100000002,0.0,0.0,0.30884513199999997,0.553910174,1.17261073,2.1790935,2.69366016,2.66303644,3.24884384,3.03621852,2.76679215,1.77563368,1.648881,1.07276963,0.59495279,0.0,0.0732415491,0.0,0.138001442,0.348619395,0.601153014,0.640773253,0.30130657,0.212993944,0.15348805199999999,0.19246242600000002,0.0,0.0,0.0,0.157860188,0.197902994,0.0457932208,0.233567895,0.040122459,0.307875248,0.336998864,0.0,0.43381137700000005,0.609208664,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.906649134,1.22056232,1.82741493,0.167599919,0.273177821,0.8245535909999999,1.93710045,1.11188618,0.0026513055600000004,0.0,0.0,0.0,0.665935486,1.07452604,0.7586751970000001,0.521772535,0.0282339958,0.0,0.537423958,0.0,0.0,0.0,0.56237761,0.0,0.440777219,0.37231163899999997,0.0,0.7971724240000001,0.20389232,0.486568857,1.92941089,3.82473536,2.79327128,1.62540493,0.0,0.0,0.7632266520000001,0.610039231,0.38415928,0.341378151,0.0,0.8393374659999999,0.0469897749,1.33244444,0.0,0.00776266046,0.0,0.0,0.0,0.17859599199999998,1.76914584,1.40500708,0.0,0.0,0.851704675,1.91477674,0.7545851440000001,0.6817696520000001,0.0,0.0,0.0,1.0886069,0.0445563247,0.489531596,2.26802863,2.56485582,0.0,0.151494867,4.70690218,10.2943631,7.15614843,0.0,0.0,0.142277867,3.37359962,0.395177259,0.0,1.09220328,2.84442031,1.27296077,0.0,0.424531527,0.0,0.0,0.0,0.0,0.0,0.48792655700000004,0.0,0.0,0.467539544,0.4893471,0.441535681,0.0173045029,0.0,0.0,0.0,0.696336284,0.0,0.77654422,0.0,0.0,0.0,0.0,0.46927318,0.0,0.0,0.0,0.666736542,0.3624203,0.0,0.309862609,0.109191707,0.0,0.670611873,0.0,0.605474056,0.0,0.897823892,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.29755491100000003,0.0480601945,0.594894406,1.61652151,1.20327469,0.0,0.0,0.336044265,0.5189473520000001,0.0,0.0,0.392292883,0.359394217,0.0,0.0,0.46831479,0.24177327699999998,0.0,0.0,0.5676428029999999,0.11914723,0.0,0.0,0.72336643,0.0,0.0,0.18860201699999998,1.07795197,0.0,0.0,1.13772605,5.14488897,5.07988318,1.60358878,0.014020207600000001,1.66395314,3.49195092,4.87018188,7.69666298,10.2013552,8.06871314,2.22249736,0.0,0.0,1.63554977,1.1960464,0.13210718800000001,0.161542969,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.494350964,0.207780128,0.0,0.44923864799999996,0.0,0.0,0.0,0.282542446,0.0,0.589584118,0.550567209,0.024007860099999997,0.0,0.0,0.793405185,1.43258025,2.65924888,2.73199499,2.1961437999999998,1.2752985000000001,0.444590521,0.598273271,0.348705549,0.373719739,0.0,0.668309732,0.920982992,1.24896735,2.07191648,3.08721195,3.84341791,4.7780846,3.95751157,1.68440675,0.9062805890000001,0.0,0.0,0.532809441,0.0,0.0,0.0,0.135439032,0.0,0.45449862,0.0,0.257752141,0.0,0.298452595,0.192884899,0.18836781,0.0,0.283407586,0.0,0.0,0.0,0.0,0.0443215704,0.0,0.421220306,0.0,0.43637470100000003,0.0,0.0,0.0,0.172771742,0.0,0.0,0.377408478,0.16898239899999998,0.0260112135,0.0,0.178758017,0.07114044929999999,0.0,0.0253020694,0.326515094,0.0,0.20600627100000002,0.0,0.0,0.295661402,0.27241254,0.244521546,0.110821571,0.0,0.439467161,0.0,0.0394348966,0.0,0.0,0.434149829,0.0,0.044543443200000005,0.0,0.269829268,0.493489499,0.483864565,1.57374089,1.90941081,1.84239767,0.782331338,1.29597405,0.546178815,0.33486047,0.122606664,0.0,0.35360677100000004,0.0,0.13366689699999998,0.0036719520899999997,0.0390394003,0.0,0.0,0.0,0.0,0.0,0.339909607,0.11252692,0.424328769,0.12486167199999999,0.34800377,0.341862076,0.178477623,0.315222377,0.46345924299999997,0.274880748,0.60772064,0.798317644,0.5783158110000001,0.37469429600000004,0.198534265,0.0,0.269675436,0.0444253369,0.256654663,0.289743869,0.0825791156,0.036754310299999995,0.0,0.358149206,0.09085592449999999,0.0,0.0,0.0810672083,0.0,0.0,0.0,0.162486656,0.0,0.0,0.0,0.0,0.0334809601,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.08280993,0.0,0.000988172816,0.0,0.561155054,0.226178342,0.0,0.0,0.42708775,1.38430542,0.050589122699999996,0.0,0.134218812,0.0,0.0,0.0,0.0,2.89990567,0.0,1.00544609,0.527532356,0.0,0.834391111,0.0,0.18272712800000002,0.0527673545,0.7393896109999999,0.0,0.810208588,0.9524881359999999,0.0,0.0,0.0,0.0,0.0,0.949109368,0.0,1.45126092,0.261736735,0.69667814,1.30354453,0.0,0.38665018,0.0,0.0888339203,1.04298113,3.96960409,8.44865261,4.48531885,2.74941269,0.665910974,2.27245802,1.51393953,1.59450315,0.0,0.770518635,0.774829227,0.19221491,0.0,0.0,1.60525911,0.0,0.0,0.0,0.81845137,0.473333237,2.11121058,0.505891912,2.25167812,0.169818761,0.298280315,0.0,0.0,0.5344822229999999,0.8147043759999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.41743459,5.51009536,4.65973576,3.31817854,6.28055199,4.33106649,6.21542634,3.42796103,3.03791238,2.96147197,2.10868348,0.0,1.9314113000000002,1.4729843999999999,0.0,0.0,0.73725229,0.0,0.16423904,1.20533433,3.44285476,1.31477673,0.72300254,3.11281059,0.04483797,0.0,0.0,0.23503247,1.92282056,1.22590295,0.0,0.84919301,1.07857326,0.0,0.0,1.00398877,0.1325831,0.0,1.16694592,0.0,1.11292117,0.0,0.91398664,0.0,0.65596511,1.27574165,0.87781066,0.0,0.0,0.0,0.0,0.14396448,0.0,0.58583235,0.0,0.65597531,0.0,0.0,0.0,2.08267191,0.74005783,0.16576368,2.73258579,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.67652142,5.58451504,5.97008072,5.08664946,3.36203997,2.73278814,0.829569764,0.17081198399999997,0.0,0.0475449471,0.0747538803,0.059170272,0.661261377,0.0869478792,0.883663306,0.30888130199999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.330809285,0.847864863,1.38099365,0.781577953,1.12186523,0.717932737,0.749575779,0.354818304,0.227816976,1.22248372,0.5230100089999999,0.136681222,0.603954789,0.6485027489999999,0.8015940970000001,0.39507269899999997,0.0,0.343597576,0.0190843057,0.144883649,0.09426074599999999,0.565220543,0.589056654,0.371464487,0.0,0.0617389704,0.964023858,1.04560042,0.0,0.865995008,0.682384436,0.0,0.565740372,0.330374569,0.0,0.0,0.57421082,0.0,0.206019685,0.37720833600000003,0.0,0.0,0.0,0.0,0.0,0.489108736,0.0,0.0,0.46066829299999995,0.0,0.0,0.0,0.5442175770000001,0.0,0.581183411,0.06540775830000001,0.36162437799999997,0.24171438899999997,0.0,0.0,0.385352339,0.178750463,0.0,0.426645657,0.0,0.21895498100000002,0.0,0.261657872,0.0,0.0,0.0,0.494638022,0.531144684,0.0,0.38677348200000006,0.379426418,0.0246189798,0.0,0.0290307371,0.0,0.240543864,0.11398653,0.339954016,0.196403546,0.411115681,0.497534859,0.0,0.0,0.0,0.0,0.0,0.371422335,0.0,0.0821820313,0.319750886,1.14559758,1.33588155,1.84453904,2.39409419,2.26747751,1.79733186,1.56780424,1.46842775,1.68156544,1.20159518,0.0,0.559128527,0.0,0.0,0.0,0.167508184,0.0,0.0,0.59521207,0.004884199420000001,0.37830754299999997,0.13076190099999999,0.0,0.256203758,0.0,0.155223589,0.0,0.382975464,0.487320188,0.529735776,0.306372129,0.330054893,0.24922276399999999,0.0,0.0,0.032242990299999996,0.0,0.0,0.0,0.471340624,0.0,0.160909994,0.166900142,0.5189479379999999,0.441464111,0.0,0.0,0.0,0.0,0.28512085800000003,0.455100634,0.219965594,0.505947949,0.6816590509999999,0.308469955,0.469265703,0.0,0.0,0.0,0.0113269727,0.0,0.256828602,0.7450992679999999,0.6606362729999999,0.229642546,0.0576587035,0.0,0.0,0.0,0.294778184,0.274897058,0.0,0.0,0.506718992,0.0,0.0,0.0,0.147375775,0.0,0.0,0.0603983755,0.0,0.391642792,0.621858324,0.046390927199999994,0.789303981,0.44220163,0.117805892,0.251355373,0.0,0.0,0.0,0.0,0.804516186,2.51660692,3.51567492,4.537936900000001,5.31240381,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.343850253,0.0902193778,0.194320427,0.157179005,0.0,0.0596069065,0.0,0.0498533584,0.0,0.04753747059999999,0.0,0.04799510059999999,0.0,0.0530636966,0.0,0.19696786100000002,2.04420992,1.21471495,0.534688764,0.089473891,0.7546205029999999,4.3884767,0.10327103800000001,0.105003275,0.0,0.19849083399999998,0.0,0.6783888240000001,0.610933222,1.55596589,0.0,0.270892304,0.0,3.68723934,4.69401558,0.0,0.317501383,0.0,0.449121925,0.138026603,0.733639041,0.0,0.588999125,0.0,2.07222862,1.06482694,0.0,0.174295509,0.0,1.28334795,2.09792555,0.0,0.170111163,0.0,0.129822142,0.0,0.138273532,0.0538191015,0.0640983867,0.0,0.22269268,2.02166293,4.23027999,5.14123902,3.96066617,1.20703295,0.0,0.35006595100000004,0.18117250199999999,1.03432008,1.40689442,3.81467937,4.44254489,2.75630223,1.02834051,0.0,0.254835198,0.0,0.192827329,0.0,0.148252669,0.0,0.158223859,0.0,0.21372731399999997,0.0,1.80069602,0.934292149,0.0,0.0394661148,0.0935552909,0.575663109,1.72874845,0.0,0.309563343,0.11784114400000001,0.386831386,0.0386738111,0.116933065,0.0,0.275499648,1.73127303,0.453234126,0.0,0.37958449200000005,0.0,0.804008156,1.82920231,0.0,0.21448152199999998,0.0,0.106918952,0.0,0.0686973829,0.0,0.0867727634,0.597150416,0.439821974,0.6559701410000001,1.03012955,0.210124329,0.120420521,0.482149754,0.348657635,0.256202404,0.156829377,0.0,0.055548819900000004,0.0,0.140678881,0.47675262,0.17582665600000003,0.062768388,0.0,0.0416216179,0.0,0.0459935541,0.0,0.358507361,0.51667405,0.535516703,0.0820437505,0.0,0.0345759138,0.0,0.0379626235,0.153957912,0.025677605200000002,0.16848100600000002,0.220848044,0.108757054,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.16380966,6.49573762,9.06556666,2.17242168,0.0,1.53419524,3.7093708,0.0,1.42368449,0.0,1.54331348,0.0,0.48288517,0.0,0.0,0.68537998,0.0,0.0,0.89133563,1.87771348,1.80448322,0.0,0.0,0.0,0.37916098,0.0,4.41318106,2.12705697,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.1465747,0.10517055,0.59226143,0.057580099999999995,0.0,0.12014753,0.0,0.0,0.0,0.39181335,2.26963616,4.13269278,5.05607692,5.39163453,5.21522404,3.83785937,1.89480922,0.31102771,0.1605728,0.0,0.0,0.18289585,0.0,0.37164293,0.12823536,0.0,0.0,0.08028018,0.0,0.37140688,0.0,0.0,0.51340888,0.33128738,0.43605135,0.38017555,0.70771034,0.78723457,1.00439502,0.82719253,1.16633233,0.73736344,0.52024805,0.0,0.0,0.0,0.0,0.0,0.0,0.24629231,0.08022564,0.40145327,0.0,0.0,0.0,0.0,0.41574464,0.0,0.0,0.32691974,0.0,0.44812682,0.19856145,0.0,0.0,0.0,0.2098294,0.0,0.0,0.0,0.05301137,0.31196425,0.0,0.51343749,0.23186934,0.27023785,0.2645059,0.33501422,0.06716227,0.0,0.0,0.0,0.22487609,0.36146629,0.07959481,0.2755382,0.0,0.0,0.36052601,0.46022938,0.40462059999999994,0.0,0.19913102,0.09766944,0.28128384,0.0,0.0,0.57673327,0.0,0.1410221,0.26036816,0.35046948,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.15614889,0.0,0.17883232,0.98809278,1.32183946,0.60251395,1.15612289,0.77633555,0.22842914,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.276137173,0.0,0.0,0.0,0.0,0.0,0.15549653800000002,0.296092057,0.35652538799999994,0.331661004,0.237394176,0.10378016300000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0618722075,0.105150102,0.11497746699999999,0.0953035906,0.057563129500000004,0.0166877503,0.0,0.0,0.0,0.01336549,0.045433809900000004,0.0710458137,0.0808033367,0.070941022,0.044731589100000003,0.011690530800000001,0.0,0.0,0.0,0.0333076421,0.0877024475,0.137748117,0.16213995,0.14230197,0.0687205358,0.0,0.0,0.0,0.0,0.0,0.0,0.0106652452,0.45624034,1.01411274,1.6241706,2.20932234,2.6876094,2.98619413,3.05459487,2.87456342,2.46456124,1.87778827,1.19395708,0.506233587,0.0,0.0,0.0,0.0,0.0,0.0,0.0734279204,0.43746394200000005,0.727074094,0.899559782,0.93992285,0.8612084390000001,0.699305645,0.5035780639999999,0.325484884,0.20766041,0.17569615100000002,0.234180145,0.36755669799999996,0.545300276,0.729984918,0.886268768,0.9887135659999999,1.02672705,1.00565447,0.943975648,0.867470431,0.80189233,0.765989192,0.7665720770000001,0.796800356,0.8380543970000001,0.8648965940000001,0.8518809509999999,0.7805320570000001,0.644775537,0.453469771,0.22937448100000002,0.00473424588,0.0,0.0,0.0,0.0,0.0,0.0,0.107133453,0.234614393,0.303532829,0.299724616,0.225838421,0.10045457599999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.131018973,0.238930665,0.290052757,0.272279593,0.189680155,0.0615838754,0.0,0.0,0.0,0.0,0.0,0.0,0.0299956589,0.17135617399999997,0.27415322,0.31319643399999997,0.277890067,0.174997307,0.027413767999999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0824458681,0.248913014,0.36366892,0.39640947600000004,0.334359835,0.18616423199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0348574835,0.446641102,0.90889596,1.36384367,1.75547734,2.03911594,2.1883867,2.19835893,2.08440868,1.87731172,1.61583778,1.33858483,1.07685452,0.8500258740000001,0.664227071,0.514293011,0.38822363200000004,0.272802945,0.158827221,0.0445646269,0.0,0.0,0.0,0.0,0.0,0.0,0.0271426171,0.142892286,0.23325476,0.27471443,0.253967145,0.17210856,0.045593361,0.0,0.0,0.0,0.0,0.0,0.0,0.175409295,0.367502934,0.50379888,0.5446637010000001,0.469753529,0.285592993,0.0279970128,0.0,0.0,0.0,0.0,0.0453814251,0.692792332,1.54525347,2.52161183,3.51324946,4.40042765,5.07118934,5.43942299,5.45880513,5.13009285,4.50048093,3.65522478,2.7031637,1.75887582,0.9247465009999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.471270752,0.211460482,0.00950987967,0.0,0.0,0.331756288,0.537489833,0.530818695,0.633733601,0.411704345,1.62949717,0.492458035,0.60160899,0.0,0.37060924100000003,0.0,0.0,0.0,0.0,0.0,0.0883736208,0.27593983699999997,0.309224963,0.717210545,0.0,0.0,0.0,0.43682685299999996,0.0,0.34999489899999997,0.0,0.508502351,0.462404992,0.191842743,0.0,0.0,0.0,0.00460794666,0.418386765,0.0,0.47054951,0.11276817300000001,0.650057068,0.0,0.68481228,0.664430615,0.426563223,0.371108915,0.0,0.0,0.0,0.0473789996,0.0,0.0,0.0855427222,0.0,0.508865817,0.0,0.53110795,0.245199261,0.0,0.0,0.0,0.0,0.0,0.0,0.300070734,0.45610871399999997,0.0,0.741412808,0.8176913720000001,0.9570756770000001,0.21690824,0.7166313190000001,0.840811561,0.226930772,0.0,0.6706981870000001,0.31991405100000003,0.0268349461,0.803673385,1.86599881,2.24108996,4.15944996,3.87133614,4.88472333,6.51831345,6.43974809,7.2779261,7.10431119,5.76092607,4.40466669,4.11524275,2.80620585,2.19528474,0.414347853,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.36196671799999997,0.647312007,0.0,0.0,0.0,0.0,0.0,0.0,0.920931576,0.65698472,0.7485652359999999,0.17539612699999999,0.0,0.24512372100000002,0.359634105,0.100417873,1.78531485,2.18171936,2.61010565,0.8508834259999999,1.72194091,0.0,1.23994292,0.293519488,0.543318286,1.0785937,1.59189934,0.0,1.61836249,0.593467698,0.010741266999999999,1.72139963,1.30060633,2.93992929,2.8655294999999996,3.56672825,2.68634066,3.05904859,1.57160622,0.111801692,0.192498272,0.0,0.259077204,0.20405015199999998,0.34737495,0.0,0.0,0.0,0.266766426,0.0,0.0,0.154048341,0.161901499,0.517625329,0.0,0.0,0.150351745,0.0,0.0,0.80207922,1.79747817,0.0,1.27749468,0.9677197409999999,0.22650092600000002,0.0,2.19551035,0.15666724099999998,0.316237663,0.0,0.3162365,0.9425423390000001,0.0,0.0,0.0,0.0,0.045260200199999996,0.8647411290000001,0.329019133,0.0,0.529835581,0.0,0.524552384,0.0,0.0,0.0,0.0,0.24510422699999998,0.0832413177,0.149388032,0.262124363,0.0,0.11048937699999999,0.751409928,0.334633434,0.0,0.0,0.0,0.497049685,0.0,0.0,1.78760239,0.0,0.0,0.0,1.12804095,0.159126077,1.12583373,0.0,0.184654503,1.04246835,0.929459527,0.451790474,0.885207,0.0,0.933648685,1.10199228,0.0,0.553648991,0.7657288609999999,1.8011471999999997,1.71015876,0.9879973390000001,2.46572605,0.0,0.0,1.1077449,0.420481816,0.0,0.17479992800000002,0.6790439970000001,0.0,1.08531257,0.690904745,0.0,1.76332173,0.0,0.7898226559999999,0.0,0.5841227170000001,0.0,0.239520679,0.7009287390000001,0.0,0.0,0.0,0.8953065170000001,0.0,0.0,0.493867079,0.0,0.0,0.285107877,0.0,0.531152275,0.998677728,0.225581902,0.10781853,0.0,0.797301534,0.8922002520000001,0.0,0.345085856,0.0,0.155687233,0.00828219773,0.0,0.6803338870000001,0.0,0.9428767640000001,0.0,0.730985832,0.0,0.04277140980000001,0.0,0.6362601689999999,0.988557019,0.0,0.869729135,0.392849368,0.0,0.0,0.677552901,0.0654426608,0.0,0.0,0.25524908399999996,0.0,0.0,0.623451093,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.610501456,0.0,0.0,0.0,0.0,0.0,0.567552808,0.387260449,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.25583108,0.422103386,0.20888417899999998,0.486185427,0.0,0.023995964100000003,0.0,0.0,1.43035356,0.794760283,0.178495987,0.608403386,0.287738313,0.566601285,0.0,0.6507108189999999,0.0,1.52191218,0.7976875240000001,1.18900653,0.00323513744,0.629747508,0.0,0.86243013,0.37262785299999995,0.0,0.303116338,0.496837408,0.235538367,0.0,0.6042367820000001,0.0,0.0,0.0,0.491313926,0.0,0.0,0.0,0.0,0.358932717,0.0,0.0,0.0,0.705117143,0.0,0.0,1.21636931,1.10976698,0.14265511,0.802657539,0.8088248459999999,0.0,0.0253634373,0.548343238,0.343451997,0.0,0.0,0.916072806,1.79300998,0.0,0.0,0.702509578,0.276023615,0.0,0.181999462,0.874692507,0.303822148,0.0,0.39414637,0.434000093,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.508897052,0.0,0.289237693,0.325281443,0.0,0.0,0.0,0.0,0.0,0.564503063,0.0,0.529883895,0.0,0.35813823899999997,0.39311759799999996,0.961654503,0.43453616899999997,0.10838970199999999,0.6949879520000001,1.71905924,2.34017125,2.2904869,2.01616358,1.82364612,3.10446748,2.77327169,1.53013619,3.5748919000000003,3.14696588,2.68011205,2.71166737,4.54684505,2.98485448,3.10667972,2.70543296,3.23670997,3.70711283,3.08150881,2.10292627,2.35917466,2.67746075,2.62236591,2.50757505,2.20889576,1.87819918,2.63235817,2.1650222,0.9201876090000001,0.375511088,2.33838995,1.24523251,1.29999507,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.943784642,0.0,0.0,0.0,0.059401812199999994,0.0,0.5890196529999999,0.772843655,0.0503277964,0.0,0.0,0.262177409,0.0,0.0,0.48955991600000004,1.87362927,0.0,1.16117657,0.24064644699999999,1.62144618,0.799453403,0.0,0.317568617,0.114183539,0.5116668360000001,1.0453597,0.664638682,0.723812298,1.83414796,0.22462839399999998,0.36051818399999996,0.055486532000000005,0.339915605,0.0,0.0,0.803170025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.5190424999999999,2.71798877,0.0,0.8367102790000001,0.0,0.33121647,0.9405898770000001,0.0,0.131283561,0.0,0.180665957,0.0,0.501172266,0.146378515,0.368116475,0.574976265,0.0,0.745632671,1.31957599,0.7432209809999999,0.35129041299999997,0.0,0.0,1.10677494,0.968616817,1.52782533,0.810156375,1.18112277,0.41066421299999994,0.6927778859999999,1.09610787,0.198475242,1.35900724,0.19770319,1.32256025,0.613985136,0.17159861899999998,0.60800205,0.677088784,0.8355968140000001,1.15273564,0.0,0.0,0.8195520820000001,0.0,0.0,0.0,0.281800736,0.635234277,0.0956235924,0.0,0.0,0.0,0.18118288100000002,0.01635017,0.745059438,0.165050589,0.43885134,1.02726558,0.0,0.152673444,0.0,0.0,0.13213659,0.0,0.59210347,0.0,0.649232577,0.0,0.0,0.0,0.0,0.400395769,0.0,0.508948617,0.0,0.0,0.0,0.644492445,0.0,0.0,0.0,0.902594232,0.0,0.9593977309999999,0.0,0.0,0.0,0.0,0.0,0.552649152,0.0767324773,0.0,0.338042933,0.835957608,0.24623172699999998,0.0,0.0,0.0,0.0,0.0,0.0370284766,0.0,0.0,2.44170445,3.0244744999999997,2.14042784,1.84582025,0.298754933,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5535071570000001,0.0,0.0932570484,0.319106465,0.27807017100000003,0.471427294,0.7459031840000001,0.307428319,0.0,0.241085482,0.0,0.476520836,0.0,0.349665696,0.855777564,1.17114664,1.41258009,1.0852556999999998,1.55612995,0.7986860659999999,1.2245528,1.00781409,0.047984868099999994,0.0,0.30156364399999996,0.190474153,0.0,0.0807427284,0.417706321,0.0,1.32624841,0.7202018440000001,0.586851566,0.293299757,0.333930781,0.24471747,0.475326546,0.0246305127,0.0,0.315212086,0.0,0.567495312,0.5639889779999999,1.07596101,0.0865376742,0.260910099,0.169699613,0.140187889,1.09006331,0.940190855,0.543357535,0.0,0.34861142799999995,0.0767504765,0.334570576,0.209227757,0.13117964,0.30882309,0.0,0.0451263078,0.272584195,0.0102926659,0.0,0.0,0.245023309,0.0,0.667069864,0.309769116,0.139882679,0.029234743799999997,0.0,0.0,0.453339382,0.241211493,0.0,0.0682501632,0.0,0.506635579,0.0,0.6773263009999999,0.443362305,0.413798985,0.0,0.0,0.0,0.0,0.0,0.0,0.24454088699999998,0.0,0.0,0.0,0.410353845,0.235653138,0.144467394,0.0,0.359816036,0.041210417,0.051374996,0.598011481,0.0,0.0,0.506494011,0.45369761,0.0,0.0,0.0,0.004000788789999999,0.0,0.0,0.0,0.284941648,0.756829495,0.0,0.0326729387,0.490959456,0.0,0.164220666,0.16262569,0.0,0.0,0.0551142045,0.0,0.140452151,0.37473416600000004,0.0929435851,0.777212667,1.20560409,0.440076719,0.0,0.551444164,0.0,0.06216782480000001,0.151344999,0.0,1.95781355,2.9411833,4.4286417,4.54383504,6.5993973,6.96847392,5.81032018,5.87403474,4.37718204,3.35036008,2.1719,0.299029208,0.0,0.0,0.0,0.0,0.0,0.0,0.35896634299999997,0.291098447,1.26963312,0.7368172059999999,0.47208087,0.293472909,0.0,0.0,0.0,0.0,0.0,0.0,0.540413221,1.45738099,1.66892424,1.70588335,1.69619271,0.9904282059999999,1.37372228,1.13345548,0.010580995,0.19010599600000003,0.0,0.608097581,0.0,1.01291753,0.469605579,0.79833789,0.8750224390000001,0.0579395611,0.253015038,0.0,0.0,0.0,0.544461049,0.625569729,0.8193176320000001,1.94299197,1.50763404,2.6627645,1.52239532,2.755546,1.53287862,1.7571075,1.12225288,0.148295827,0.0,0.0,0.144308179,0.0,0.0,0.0,0.323759728,0.368914824,0.0,0.970358596,1.36546867,1.10209086,1.10925293,1.25097477,1.05290284,1.92140808,1.17356182,0.344191831,0.12200673,0.0,0.137612231,0.0,0.559293544,0.0,0.004747113010000001,0.550937051,0.503837051,0.0,0.0,0.0,0.20855277600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.65223348,0.0,10.72393934,3.41431858,0.0,3.02405775,2.22183658,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.138618529,0.32373066,0.534814362,0.7101974109999999,0.8368808990000001,0.9078557840000001,0.895264692,0.7768047770000001,0.574355064,0.35751841799999995,0.212369578,0.197748895,0.302735682,0.42976372799999996,0.444587109,0.287464858,0.047372980700000004,0.0,0.0,0.0356714103,0.0831884192,0.0145895658,0.0,0.0,0.0343540987,0.0687948557,0.005985021460000001,0.0,0.0,0.0391373116,0.0659429226,0.0,0.0,0.0,0.0457018309,0.0653302088,0.0,0.0,0.0,0.052644500000000004,0.0641673587,0.0,0.0,0.0,0.057021456500000005,0.0582898342,0.0,0.0,0.0,0.0374401115,0.015437393899999999,0.0132811622,0.198498836,0.545892982,0.796068088,0.7714723990000001,0.670250812,0.9009888659999999,1.57877903,2.28515299,2.4350718999999996,1.86684945,0.9865364679999999,0.32804526,0.0675241473,0.0153002076,0.0,0.0,0.00876024367,0.07946572730000001,0.0406939413,0.0,0.0,0.027642224,0.130561561,0.0492156327,0.0,0.0,0.0551513682,0.181250262,0.0493756849,0.0,0.0,0.0988140514,0.252595258,0.043323075499999995,0.0,0.0,0.18400478399999998,0.39624536200000005,0.0267188911,0.0,0.0,0.548669534,1.58680638,1.83665488,1.37888906,1.09501004,1.45684548,1.8494604,1.43023469,0.498884137,0.500782202,2.37866969,5.15535619,6.59187427,5.38869715,2.51215318,0.166169655,0.0,0.185765937,0.525110194,0.117845725,0.0,0.0,0.16708777800000002,0.358739356,0.048675698200000006,0.0,0.0,0.149347708,0.265644457,0.0112658213,0.0,0.0,0.139194576,0.20933050399999997,0.0,0.0,0.0,0.132789365,0.17102042399999998,0.0,0.0,0.0,0.128545986,0.142905568,0.0,0.0,0.0,0.126437736,0.122092102,0.0,0.0,0.0,0.13236383699999998,0.11465406800000001,0.0,0.0,0.0,0.339452549,0.77416611,1.19590626,1.54764758,1.65941852,1.34350805,0.6747546640000001,0.050485967699999995,0.0,0.0135324525,0.18325488899999998,0.0906862657,0.0,0.0,0.0297103218,0.170548783,0.0692241146,0.0,0.0,0.05049900400000001,0.22809936600000003,0.221887164,0.167668078,0.269148485,0.449330547,0.41102918899999996,0.06817044309999999,0.0,0.0,0.437902745,1.03058565,1.40914517,1.8071465,2.60521706,3.7238884,4.55193073,4.57083628,3.94538562,3.35616891,3.26135282,3.45400223,3.39718335,2.8810887000000003,2.21663841,1.80537361,1.67052601,1.49967603,1.07161063,0.510769433,0.105549765,0.0,0.0110098981,0.0344207479,0.007909287840000001,0.0,0.0,0.00289217619,0.0120072602,0.042951357999999995,0.0974316968,0.128099446,0.10400413,0.0727572462,0.111596584,0.21844418899999998,0.29395669399999996,0.25377792600000004,0.135624616,0.0676498548,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.136575324,0.0,0.0,0.37590091,1.00336438,1.61607727,1.99522449,2.01670109,1.69519821,1.16449762,0.608625223,0.18092726899999997,0.0,0.0,0.0,0.0,0.006229275429999999,0.0,0.0,0.0,0.0179487476,0.0431493686,0.0432909862,0.0113925521,0.0,0.0,0.0,0.0,0.05073440110000001,0.08153221620000001,0.06190637190000001,0.0,0.0,0.0,0.0,0.010844165900000001,0.0891035549,0.11740845,0.0717654017,0.0,0.0,0.0,0.0,0.053560332,0.17608126300000002,0.203686342,0.0960581818,0.0,0.0,0.0,0.0,0.304041639,0.8805323709999999,1.39760432,1.66853141,1.58986475,1.18820504,0.609886755,0.0577026983,0.0,0.0,0.0,2.93475618e-16,0.182529163,0.224767567,0.130984596,0.0,0.0,0.0,0.0150844828,0.168350972,0.262313621,0.23874483100000002,0.10712436300000001,0.0,0.0,0.0,0.0,0.0738823133,0.178953277,0.184025682,0.09236693630000001,0.0,0.0,0.0,0.0,0.0883054329,0.162385642,0.151091282,0.06959754679999999,0.0,0.0,0.00906656137,0.127764013,0.23055684199999998,0.244065633,0.144703399,0.0,0.0,0.0,0.0,0.100436926,0.25167527100000003,0.271872608,0.136154926,0.0,0.0,0.0,0.0,0.131648176,0.331718883,0.344262443,0.149493577,0.0,0.0,0.0,0.452855214,1.28107047,2.12235802,2.71409799,2.92778063,2.84762432,2.7362528,2.89674824,3.49809055,4.45591381,5.4372987,5.99707796,5.78486685,4.72257218,3.06302998,1.29716947,0.0,0.0,0.0,0.310709786,1.1321371,1.6524071,1.67987669,1.27293224,0.671279297,0.155910102,0.0,0.0,0.24293245800000002,0.560118097,0.8214482390000001,1.00285894,1.14357091,1.28591694,1.42104315,1.47881174,1.37000024,1.05452884,0.591593791,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.47250413,1.72965831,0.19830836300000002,0.402552057,0.0,0.497964429,0.0,0.0,0.349131026,0.0,0.597048263,0.162449086,0.0,0.6847936579999999,0.564777409,0.0,0.48003355600000003,0.460965843,0.130117868,0.0,0.0,0.369032445,0.72097686,0.113012559,0.39475047700000004,0.0,0.10556973,0.6155801879999999,0.0,0.0,0.9627218059999999,1.25749332,0.778220247,0.820551046,1.78984108,3.22928583,3.69826389,1.93689901,1.80155131,0.7463328659999999,1.19929225,0.187684448,0.217707349,0.00828601242,1.74162037,4.75337555,7.06001225,7.57782077,5.18408755,2.18161083,0.0,0.453699343,2.07230161,2.49348025,2.31345991,2.16533471,2.5369998,1.98339861,0.0,0.0,0.20591556100000002,0.540041143,0.0,0.588475135,0.0,0.0,0.316762363,0.678166292,0.0,0.573431182,0.0,0.366042869,0.31863654399999997,0.270503048,0.470449159,0.0,0.7208123559999999,1.10533242,1.52629112,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.958412168,0.22304690800000002,0.0,0.621338042,1.10648214,1.81092736,0.156870245,0.433353934,0.207587477,0.0,0.841251851,0.8108079990000001,0.0,0.0,0.889478863,0.286646595,0.144829145,0.0,0.549570979,0.00590574955,0.811904365,0.0,1.10028096,0.47656888700000005,0.690139947,0.0,0.0,0.611999198,0.271224571,0.368607006,0.223970213,0.288528461,0.0,0.30566771800000003,0.0,0.0,0.450288455,0.658943241,0.0,0.490064764,0.090447849,0.240409892,0.0,0.692394972,0.284990665,4.11380589,0.341159858,0.0,1.10978314,0.46381230799999995,0.24563965,0.0,0.376607042,0.211729406,0.0,1.67826504,1.33403639,0.0,1.4826736,1.0260199,0.000288876618,0.0,0.0989291766,0.608063754,0.0494177436,0.0,0.567988293,0.76136348,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.13794044800000002,0.607116356,0.928238179,0.972698864,0.7816471309999999,0.5387906029999999,0.45562938,0.631773103,0.972662314,1.2215040000000001,1.10191541,0.503153603,0.0,0.0,0.0,0.0,2.22004444,5.15446804,7.96868633,9.80992594,10.1132883,8.8341927,6.46876201,3.85125095,1.81870675,0.8913084259999999,1.10485554,2.05707266,3.1296621,3.77210799,3.71599657,3.03428553,2.04152323,1.10567108,0.473980035,0.193050702,0.144029398,0.15234605,0.09965771849999999,0.0,0.0,0.0,0.0,0.0824996338,0.205857003,0.215511917,0.10300797,0.0,0.0,0.0,0.0,0.0741494048,0.17546100399999998,0.165917469,0.056982745099999996,0.0,0.0,0.0,0.0,0.073457809,0.119807694,0.08378733049999999,0.0112170342,0.0,0.0673650467,0.254288061,0.46502999100000003,0.584105047,0.52812964,0.299610869,0.0,0.0,0.0,0.0,0.0304571958,0.22804548800000002,0.280385288,0.161838551,0.0,0.0,0.0,0.0,0.07374930519999999,0.240292029,0.25937446399999997,0.11839594699999999,0.0,0.0,0.0,0.0,0.12383955199999999,0.27617888,0.26041576899999996,0.0813281346,0.0,0.0,0.0,0.0,0.19295308600000002,0.33826252,0.277669039,0.0372894643,0.0,0.0,0.0,0.0,0.31266146899999997,0.46241068399999996,0.328594198,0.0,0.0,0.0,0.0,0.11133116300000001,0.67776967,0.9862081009999999,0.83037785,0.252813519,0.0,0.0,0.0,0.615932467,2.21777284,3.78913126,4.75328916,4.74185332,3.75569119,2.16065426,0.522538842,0.0,0.0,0.0,0.0,0.388870723,0.62134157,0.463317435,0.07161985650000001,0.0,0.0,0.0,0.0,0.256017764,0.35524901200000003,0.237071019,0.0,0.0,0.0,0.0,0.0350102053,0.23006855399999998,0.281061999,0.160364642,0.0,0.0,0.0,0.0,0.0876895206,0.28047017399999996,0.3083744,0.140516601,0.0,0.0,0.0,0.387864429,1.31436936,2.39346004,3.29869743,3.71821415,3.4797077000000005,2.62736884,1.41552101,0.217506107,0.0,0.0,0.0,0.0,0.4839192,0.7532582529999999,0.6464747789999999,0.26543907899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.239
0.53147306,1.09656933,0.7315227,0.07492944,0.30775196,1.59694975,2.66078936,2.22158055,0.76690877,0.39682858,2.59467363,6.27994417,8.47384607,7.13599689,3.24948015,0.0,0.0,0.88798809,2.21613356,1.74377045,0.13406741,0.0,0.0,0.25059496,0.43795351,0.08457802,0.23352532,1.41484549,2.81183413,3.1140706000000002,2.01220135,0.54109598,0.0,0.21260474,0.57445156,0.30008274,0.0,0.0,0.0,0.44301092,0.3180631,0.0,0.0,0.0,0.46538463,0.40036370000000004,0.0,0.0,0.0,0.3793818,0.44752561,0.0,0.0,0.0,0.36546661,0.5709649,0.03741130000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.27583938,2.16203619,0.0,2.24175982,2.14805845,7.33843081,0.11994579,4.57295186,7.42818435,0.0,0.72382945,2.48046685,1.56468677,5.07935923,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.17872816600000002,0.12612745,0.190239309,0.126232176,0.0,0.0,0.0734584649,0.0315715921,0.0,0.0,0.0643597912,0.0,0.0,0.0351436676,0.18926227399999998,0.701118405,1.65313798,2.20466328,1.63539872,0.670122425,0.387407493,0.421200484,0.0,0.0,0.720796494,2.19244803,1.91123668,0.17962325399999998,0.0,0.0652510051,0.406491535,0.0,0.0,0.30737579600000003,0.463782656,0.0443331579,0.0326595451,0.257169086,0.0,0.0,0.106600864,0.24328639600000002,0.0,0.0,0.37637344,0.43439115899999997,0.0369877442,0.229793356,0.598724195,0.249899802,0.0,0.264269967,0.245688171,0.0,0.0,0.427483154,0.0292235981,0.0,1.27978863,2.55845642,1.36499621,0.218950877,1.72821205,3.12600324,1.65086903,0.130872814,1.27775186,2.40511093,1.09981442,0.0,0.588927898,1.44296256,0.986835397,0.634217829,0.861844128,0.542495819,0.0,0.20418677699999999,0.5341448129999999,0.182583443,0.023120015600000002,0.506112157,0.614644516,0.07884749,0.0,0.0079014137,0.0744282484,0.0,0.0,0.276221996,1.05581342,1.75316568,1.26546414,0.196915375,0.204260761,0.6574649229999999,0.0,0.0,0.661918499,0.7886937409999999,0.0,0.0,6.68567478,11.4765698,7.49800103,0.623694474,0.0,1.64204257,1.07332448,0.0,0.0,1.22389714,0.521131358,0.0,0.11098515099999999,0.508147654,0.0,0.0,0.36799455,0.238803887,0.0,0.0,0.521690994,0.12385856,0.0,0.44672976,1.17051348,0.886709236,0.345712291,0.18445172,0.0347236391,0.0,0.00882820404,0.130797604,0.0,0.0,0.10368262199999999,0.15997617,0.00480842779,0.0428481862,0.20230081800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.230679865,0.20307862399999999,0.0529683002,0.0,0.0,0.028379129399999998,0.0,0.0,0.024286580800000002,0.013112526299999998,0.0,0.006899111640000001,0.0461964713,0.0,0.0,0.0794364867,0.00401133985,0.0,0.088937535,0.28693898,0.0847320963,0.166040236,0.7926113779999999,0.853196071,0.166892196,0.12836097,0.813020538,0.964089565,1.07204754,2.1460817000000003,2.55770738,0.910890435,0.0,0.06991222400000001,0.588147677,0.0,1.11854038,4.91233186,7.5331772,6.36042026,3.35988292,1.13057983,0.15993639099999998,0.0637083109,0.24416491399999998,0.103571586,0.0,0.219379541,0.17812495899999997,0.0,0.0,1.00005206,1.35751107,0.967598847,1.06443179,1.30595543,0.6845866840000001,0.0,0.038784081899999996,0.299858055,0.302327106,0.653374094,1.15653098,1.12101551,1.08355819,1.51841724,1.42329753,0.429539444,0.0,0.501703636,0.85739049,0.38580839200000006,0.000564863048,0.17504556899999998,0.347776263,0.222590275,0.0624752147,0.0042064519799999995,0.0148655701,0.115068246,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
7.33690171,7.18152335,6.64204565,5.77160223,4.65555275,3.40127245,2.12548801,0.940795822,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.330480483,0.6660424220000001,0.861443308,0.9003173059999999,0.791423986,0.565100166,0.266940016,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.128869565,0.332794922,0.471206626,0.525315007,0.490794944,0.377734332,0.20832130199999999,0.012734668300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0538004151,0.206630008,0.320038623,0.37680690200000005,0.369536749,0.301525287,0.185883264,0.0430943984,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.012905066399999998,0.139654327,0.24026846699999999,0.298736487,0.30635169100000004,0.262976563,0.176878273,0.0631921105,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0970301849,0.190980331,0.251728553,0.269678545,0.24246177600000002,0.175226115,0.0796815766,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0662143144,0.157330959,0.22138431,0.247929348,0.232844457,0.178964633,0.0955577732,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0413608184,0.132568408,0.201295153,0.236118909,0.231303777,0.187740766,0.11278513800000001,0.0190197821,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.019058786299999998,0.113074511,0.188319392,0.232136468,0.23709166,0.202229479,0.133253214,0.0415962577,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0965696216,0.18096107,0.235575198,0.250980365,0.224238083,0.159452075,0.0671466292,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.081263919,0.17882761,0.24761684,0.275606843,0.257447479,0.195462551,0.0993818506,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0652164363,0.182719695,0.271930069,0.31710515899999997,0.309548433,0.249235535,0.145029754,0.013417464399999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0453158042,0.19580719,0.318211318,0.39075305,0.399274896,0.339881065,0.21996897199999998,0.057422250300000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0140691076,0.23204322100000002,0.425153306,0.560193901,0.611945859,0.567759702,0.43032150399999997,0.218067299,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000989791839,0.37342781,0.7426211890000001,1.05075005,1.24528554,1.28768244,1.16057341,0.872305405,0.457992413,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.82318216,1.93316768,3.16574781,4.41141662,5.55273861,6.47787028,7.09369756,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.37546286,2.3254874,2.79160457,0.0,3.31562709,1.64732613,8.64185061,9.00561129,2.60992369,0.0,0.20636696,0.69189471,0.21092513,0.86123748,0.82792924,0.62988373,1.31303494,0.13802988,5.17602143,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8697960370000001,1.82465908,1.7944203999999997,1.19459004,0.0,0.0,0.663445653,0.437066222,0.0,0.0,0.0,0.126178945,0.381501528,0.142831738,0.0,0.45038163200000003,0.415118654,0.0,0.621471725,1.0084681999999998,0.0,0.18125439399999999,0.0,1.83309761,1.67886701,2.35191404,2.06015501,1.71158161,0.770932754,0.38621349200000005,0.0,0.192906705,0.0,0.0,0.405274466,0.0,0.0,0.0,0.0,0.0,0.0,0.04525171309999999,0.0,0.9416171409999999,0.22607065199999998,0.0,0.0,0.26958329,0.41807732700000005,0.332746873,0.0567327015,0.0893319829,0.69135567,0.0,0.299890242,0.0320401862,0.256296625,0.94378596,1.52705647,0.9564246390000001,0.9832586759999999,0.0,0.0,0.595047471,0.219096039,0.0,0.0502385962,0.485180603,0.547605155,0.0,0.25165566699999997,1.05292558,0.37125484700000005,0.0,1.08068061,4.42945537,6.08194481,3.548774,0.0,0.0,0.33817189200000003,0.0115070547,0.030771531600000002,0.0,0.704934411,0.9023733979999999,0.15734077400000002,0.0,0.0,0.578831462,0.0,0.0,0.642466264,2.48161921,2.93306869,3.03443123,1.86391948,0.790914364,0.0,0.0,0.742670123,1.08894278,1.20913913,0.0,0.25535858,0.0,0.0,0.0,0.29574401899999997,0.6171205710000001,0.0,0.0,0.613921936,0.0,0.0,0.453332866,0.0,0.456913684,0.154295185,0.11826883199999999,0.15733692300000002,0.0622150203,0.0,0.402880287,0.0,0.288695667,0.0,0.0026934550399999994,1.10502113,0.356011746,0.0,1.02110095,3.90473828,4.64538881,3.81908193,1.28723799,0.843956755,0.0,0.0,0.0,0.0,0.0,0.515189889,0.8769552279999999,0.6246069710000001,0.45405418399999997,0.0,0.0,0.375326019,0.0,0.13395689300000002,0.0,0.313056454,0.0,0.36466103,0.0626386208,0.457755423,0.033482406400000005,0.0,1.07032931,2.17109453,3.12790306,3.83090537,2.71329404,0.5705803620000001,0.7415953129999999,1.13799551,0.307001438,0.0,0.0,0.37234910200000004,0.449708221,0.0250003191,0.0,0.296119085,0.5063183760000001,0.0,0.158516719,0.670663156,0.397805487,0.440669895,0.381596755,0.1500124,0.294178269,0.0,0.0,0.762952165,0.8911646529999999,0.149094678,0.827735452,0.0311356211,1.28491607,0.816441875,2.50192802,2.73793875,1.75819857,0.54488885,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.07500716,3.51853235,3.66223508,3.18197643,3.3686489,3.15437354,2.90976418,2.40447851,2.37358822,2.56639657,2.07032291,2.00065188,1.59739365,1.43409185,1.52476634,1.06960952,1.12980228,0.703422333,0.351249682,0.445956481,0.007412566230000001,0.19143210600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.000702290844,0.0,0.0,0.0,0.047220883899999996,0.153592808,0.0,0.0,0.0,0.230439151,0.10262710800000001,0.0,0.208493719,0.511691939,0.0,0.272621515,0.442952722,0.361535674,0.164897869,0.0495461175,0.212944152,0.0368140701,0.295228207,0.139025457,0.0,0.11550313400000001,0.206007699,0.0,0.232862192,0.0,0.0836540439,0.0,0.19508781100000003,0.0,0.0395154816,0.0316314828,0.0,0.0873146146,0.19291736199999998,0.0,0.0,0.0,0.0,0.214655679,0.0,0.0,0.0,0.0246065637,0.0,0.0,0.112954764,0.0,0.302736936,0.0,0.0,0.0,0.126034142,0.247096238,0.0,0.198568362,0.0,0.20021591100000002,0.0,0.253118473,0.0157567171,0.269009681,0.0,0.0507224265,0.007461109549999999,0.261543691,0.142033191,0.0,0.137756503,0.0,0.24902320600000002,0.0,0.306695549,0.0,0.0,0.139514269,0.0,0.32184284,0.345148698,0.267657392,0.20785806899999998,0.00587263128,0.0602940847,0.0,0.0,0.104900509,0.0,0.0456930535,0.17567088,0.0,0.0,0.0,0.0624843063,0.0,0.0,0.0,0.175974876,0.0,0.030817080499999996,0.0,0.06698470549999999,0.417862224,0.0,0.08196368450000001,0.146428479,0.132365089,0.3364236,0.0890830947,0.42452276899999997,0.267790975,0.300212114,0.0,0.34217194,0.231421501,0.319997797,0.363766772,0.0,0.0,0.0,0.232016849,0.0,0.0570011308,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.154136997,0.404720952,0.20823779999999997,0.762488417,0.6686602779999999,0.625250989,1.03095189,1.66148878,1.27593919,1.82948833,2.23491648,2.43778993,2.74693243,2.8538959999999998,2.83528135,2.89735986,3.40671038,2.99003865,3.09473532,3.39500928,3.58719025,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0311126696,0.173064315,0.32808977699999997,0.49465854299999995,0.671035437,0.8553040679999999,1.04539338,1.23910689,1.43415422,1.62818427,1.81881969,2.00369201,2.18047679,2.34692843,2.50091382,2.64044452,2.76370679,2.86908906,2.95520637,3.02092136,3.06536154,3.08793246,3.08832667,3.06652826,3.02281287,2.95774334,2.87216083,2.7671718,2.6441309,2.50462006,2.35042431,2.18350443,2.00596716,1.82003324,1.62800398,1.43222672,1.23505996,1.03883847,0.84583917,0.658248187,0.478129636,0.30739667,0.147785181,0.0008306104519999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,9.595000599999999e-17,0.07423589679999999,0.14448203199999998,0.209393876,0.267777625,0.318607611,0.361040418,0.394425511,0.418312211,0.432452976,0.43680295,0.431515854,0.416936339,0.393588981,0.362164163,0.323501145,0.27856865399999997,0.22844339,0.17428686399999999,0.11732101,0.0588030378,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.052445356,0.103572292,0.15228699699999998,0.19754879,0.238391188,0.27394148100000004,0.303438417,0.326247668,0.341874778,0.34997534,0.35036220799999995,0.343009601,0.328054025,0.305791977,0.276674484,0.241298574,0.200395827,0.15481824,0.105521645,0.0535470149,1.15140007e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0311126696,0.09994590140000001,0.16943189,0.23822602,0.304973586,0.36833594399999997,0.42701675200000005,0.47978782200000003,0.5255140979999999,0.563177296,0.5918977470000001,0.61095404,0.619800063,0.618079108,0.605634749,0.5825182520000001,0.548992341,0.505531205,0.452816701,0.391730759,0.32334409399999997,0.248901357,0.169802956,0.08758381359999999,0.00388939662,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.10403396599999999,0.711630421,1.35351898,1.86388003,2.13097599,2.13262703,1.93019547,1.62733136,1.31645075,1.04064568,0.789190752,0.526014891,0.232278105,0.0,0.0,0.0,0.0,0.0,0.25537726,0.392677372,0.318160867,0.07684488639999999,0.0,0.0,0.6447809870000001,2.02323928,3.96522037,6.08734498,7.85381132,8.74906805,8.46184804,7.00804768,4.7406322,2.23820254,0.11225829699999999,0.0,0.0,0.0,0.0,0.49396602,0.878806585,0.7830260840000001,0.335332014,0.0,0.0,0.0,0.0,0.0644537154,0.38877044299999997,0.488155471,0.33570542700000006,0.0313996516,0.0,0.0,0.0,0.0,0.262190402,0.427385539,0.39134584200000005,0.175729568,0.0,0.0,0.0,0.0,0.0343353565,0.265833445,0.36057040100000004,0.274265111,0.0536119745,0.0,0.0,0.0,0.0,0.167079025,0.38967289899999996,0.47177585299999997,0.38894333600000003,0.194721901,0.0,0.0,0.0,0.0145454111,0.161788168,0.23941441100000002,0.191974798,0.031888607,0.0,0.0,0.0,0.0,0.223131633,0.5572136010000001,0.81384153,0.929600636,0.901039875,0.777116925,0.6283441470000001,0.509864884,0.437528984,0.38808678700000004,0.321332318,0.210452503,0.06296216240000001,0.0,0.0,0.0,0.0,0.0733263264,0.17352746300000002,0.186093335,0.100075271,0.0,0.0,0.0,0.0,0.00542909578,0.162086426,0.24154381800000002,0.19656594,0.0429023843,0.0,0.0,0.0,0.0,0.118931694,0.30470789800000003,0.347994281,0.209570013,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.231
0.447456033,0.29787561100000004,0.0,0.059620317400000004,0.308531173,0.12728078,0.21346389699999999,0.0,0.30010519,0.0,0.673342083,0.765775373,0.465608125,0.603112931,0.681163944,0.626018556,0.0364002671,0.557980548,0.0,0.381479181,0.664756731,1.0041415,0.696364458,0.683815003,0.49694425700000006,0.7035696459999999,0.8776509640000001,0.567840298,0.729615865,1.01072352,0.651525829,0.483412945,0.529432184,0.808610973,0.122074529,0.333282688,0.07047481530000001,0.46764022,1.2383812,0.794166997,1.13279861,1.83392974,1.79750085,1.80452871,1.74466986,0.90699058,0.586751372,1.02711466,0.692275434,0.994615221,1.21749312,0.9780727159999999,1.7765618000000003,1.8197488999999998,1.51692946,1.49260111,0.8931559590000001,1.07465511,0.949917413,0.51043282,0.9414938359999999,1.41495099,1.10157121,1.15356658,0.518504664,0.724605553,0.06965069139999999,0.00919293861,0.0,0.267022561,0.26452934899999997,0.871588093,0.591119087,0.274724165,0.149524546,0.0,0.0,0.054523724100000004,0.0,0.76241084,0.680327942,1.07757866,1.45222761,0.9282140040000001,0.796203538,0.580047695,0.235800153,0.0,0.0,0.0939399508,0.0,0.0,0.0,0.0,0.0473912987,0.25095864,0.0,0.0,0.0,0.209171233,0.165466253,0.0181722649,0.0,0.134972196,0.0902525568,0.0,0.3105607,0.0,0.0612884513,0.0,0.11120487300000001,0.251185607,0.38375351799999996,0.0,0.0,0.0,0.203849833,0.0,0.0,0.21313955199999998,0.0699077663,0.37844087299999996,0.0,0.222547453,0.0,0.0,0.0522431365,0.153540537,0.0889817892,0.0208179227,0.0,0.31507247,0.0,0.0,0.0,0.0,0.11673104699999999,0.0,0.129788084,0.0,0.0,0.0,0.0,0.0,0.19973633600000001,0.16397838,0.18777118199999998,0.519976033,0.335847654,0.0998785634,0.0,0.0,0.0,0.267641937,0.0313093541,0.351967074,0.0,0.162214843,0.0,0.0,0.0,0.0,0.6818068970000001,0.46584081299999996,0.0670237942,0.0,0.0,0.0,0.0,0.222247613,1.11884918,2.25490421,3.24013247,3.98653256,3.55965731,3.68447872,3.16003881,2.76441971,2.2402328,1.7560543000000002,1.75722124,1.10643073,1.57508432,0.7724662379999999,0.46094448600000004,0.727932568,0.168062023,0.215099032,0.051962362699999994,0.0,0.313424696,0.0,0.0,0.0,0.44929351,0.300368765,1.35747096,1.63450511,2.5396166,1.72606622,1.85274602,1.02003361,0.414558917,0.0,0.0,0.0,0.010435406099999999,0.0258640963,0.0,0.380702489,0.44577678200000004,0.200759988,0.0,0.015277808899999998,0.0,0.16645708,0.22204894,0.237797032,0.0,0.0,0.0,0.048434697400000004,0.0,0.387950402,0.536917751,0.16779910399999998,0.0518483365,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.27248672399999996,0.923620452,1.26956483,0.8271960629999999,0.00967850136,0.0,0.0,0.259777875,0.331073739,0.0100239725,0.0,0.0,0.216471936,0.297584005,0.014764171599999999,0.0,0.0,0.172791185,0.339177055,0.0264158877,0.0,0.0,0.439868364,1.50827923,1.9490528999999999,1.39634931,0.395764529,0.0,0.312128803,1.10370184,1.34040221,0.67674462,0.0,0.0,0.22742960399999998,1.34676476,1.95872383,1.88000825,1.77036996,2.32046127,3.38238676,4.02349125,3.4710965,1.93265601,0.417257946,0.0,0.0482572525,0.653641335,1.25165576,2.06817127,3.43215958,5.0825157999999995,6.12470094,5.76499982,4.06937234,1.96022126,0.467744104,0.0,0.142814511,0.36330764600000004,0.330842935,0.124296029,0.0,0.0,0.0,0.030780277400000004,0.021757631200000002,0.0,0.0,0.0,0.021895341699999998,0.022733247,0.0,0.0,0.0,0.104856515,0.276421857,0.42768742299999996,0.528630998,0.5946563779999999,0.628183293,0.589418446,0.459861278,0.32476883300000003,0.340938671,0.581129314,0.9189100290000001,1.10979558,1.01567876,0.746571467,0.567289705,0.659165075,0.966014657,1.25105453,1.28719483,1.01566037,0.577221921,0.22008188,0.135413949,0.305165756,0.486521442,0.40813986700000005,0.0590232784,0.0,0.0,0.712945869,1.48342799,1.67470302,1.1041843999999998,0.218489446,0.0,0.0,0.0663928553,0.227751457,0.0749897474,0.0,0.0,0.0345123639,0.137464277,0.050273409000000005,0.0,0.0,0.0233123896,0.102283451,0.0397310447,0.0,0.0,0.0169639237,0.0806674054,0.0325314216,0.0,0.0,0.0117664806,0.058640252999999996,0.023142135499999997,0.0,0.0,0.0038034725399999996,0.003254623,0.0,0.068547464,0.283159863,0.469733274,0.417029462,0.12567129,0.0,0.0,0.0227683402,0.157335526,0.0733533768,0.0,0.0,0.016476335,0.13667869800000002,0.0685662031,0.0,0.0,0.013886759299999999,0.136464647,0.071953077,0.0,0.0,0.0123607815,0.14722603,0.0812660659,0.0,0.0,0.011365893500000002,0.171219354,0.09917468289999999,0.0,0.0,0.010779277700000001,0.221011525,0.135777306,0.0,0.0,0.010793148,0.34954475100000004,0.23755306699999998,0.0,0.0,0.014043029299999999,1.28166115,2.22541129,2.06516607,1.05415294,0.217025755,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
10.9005173,10.615515,8.42269016,5.22973291,2.22052466,0.29139997100000004,0.0,0.0,0.522587224,0.674881825,0.305339288,0.0,0.0,0.0,1.20417964e-16,0.827534542,1.49520383,1.77721304,1.69523601,1.4515385,1.26201004,1.21116859,1.22071236,1.13733637,0.8661060770000001,0.45334681,0.0658892271,0.0,4.81671854e-16,0.33948483799999996,0.7279429759999999,0.9770700290000001,0.984030037,0.770666625,0.451970889,0.162694289,0.0,0.0,0.0,0.022262430899999998,0.0428660616,0.029343139700000003,1.6055728499999999e-16,0.0,0.0,0.0,0.00853417859,0.0176994336,0.013374226699999998,0.0,0.0,0.0,0.0,0.00745792816,0.0176311135,0.015051976100000001,0.0,0.0,0.0,0.0,0.0129232202,0.0323014437,0.0289948669,1.6055728499999999e-16,0.0,0.0,0.0,0.0320862861,0.08595601119999999,0.0838096929,4.81671854e-16,0.0,0.0,0.0,0.220679192,0.89067566,1.77928562,2.69349434,3.39149486,3.66504366,3.41719824,2.70405595,1.72142064,0.73815286,0.0,0.0,0.0,0.0,0.112563463,0.22460724399999998,0.163682264,2.70940418e-16,0.0,0.0,0.0,0.070426482,0.15493172800000002,0.122460358,3.21114569e-16,0.0,0.0,0.0,0.0681131306,0.154909778,0.12616682699999998,1.20417964e-16,0.0,0.0,0.0,0.08260235469999999,0.20534131,0.214540197,0.12654000199999998,0.0393921744,0.056159176799999995,0.197325268,0.37125370399999996,0.432582504,0.292475026,8.32890914e-16,0.0,0.0,0.0,0.162324878,0.378826506,0.315892485,0.0,0.0,0.0,0.0,0.5471058870000001,0.9370613959999999,0.764339325,0.0,0.0,0.0,0.0,2.45119237,5.89595133,9.10597209,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.4500292,0.79605666,0.0,0.0,2.19845028,3.21410512,0.629420353,0.0,0.137912944,4.88651568,1.5334940000000001,0.395900835,2.71989509,0.0,0.0,0.0,0.0,0.913602507,1.71171811,2.08861798,3.07612093,0.0,3.06112851,4.70612081,0.0,0.0,0.0,1.30015354,1.89037641,0.848064582,0.7906307020000001,0.0910586797,0.0,0.816938789,0.693362978,1.06687778,0.0,0.0,1.25111113,0.716008923,0.0,1.64510051,2.08313467,1.8676814999999998,3.90765358,0.285830992,0.0,2.33301047,0.0,0.0,1.22562362,0.778452975,0.0,0.443185285,0.0,0.0,0.0,0.0185338766,0.031456936,0.0,0.999245189,0.567263063,1.21675591,0.9081208209999999,4.21673697,2.08172537,0.8248693159999999,1.45068323,0.00571557456,1.47805153,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.25790464,4.57752475,4.21013581,3.58291451,3.48245322,2.53334599,2.00606805,1.51378549,0.0,0.0848804271,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.648211464,0.681602753,0.420254955,0.37340985600000004,0.478626579,1.04203218,0.564182111,0.27409581899999996,0.670049834,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21183665,0.0,0.0,0.20729027,0.710334186,0.0,0.44015666600000003,0.755888208,0.0,0.0,0.565781965,0.422319585,0.350041786,0.0,0.0,0.146171449,0.24159349300000002,0.0,0.22678808600000003,0.215738409,0.479889854,0.0431741313,0.10350803300000001,0.7838672790000001,0.342035985,0.0,0.260156736,1.02590256,0.43283149600000004,0.107227104,0.171531111,0.0,0.0,0.0,0.659729342,0.768779931,0.0,0.0333920596,0.662630295,0.0,0.11199800900000001,0.21377610600000002,0.5625401320000001,0.357333086,0.0389163458,0.6212987879999999,0.17103744699999998,0.530764195,0.50569763,0.0,0.43586136799999997,0.0,0.0,0.0,0.191796347,0.0,0.118227576,0.483739365,0.00543382814,0.0,0.0807452035,0.156373433,0.0,0.0,0.360989925,0.26876752800000003,0.22558875,0.0,0.0,0.0,0.0,0.0,0.0,0.428507526,0.452108985,0.0,0.392289504,0.0,0.516999281,0.377845375,0.0,0.0,0.0,0.253743664,0.40675175,0.47354077299999997,0.0,0.0,0.242190166,0.30056146899999997,0.489573253,0.0,0.508306505,0.533110173,0.6229407779999999,0.0,0.0,0.5704686170000001,0.0,0.0,0.166322198,0.0,0.0,0.500915168,0.0303023954,0.0729698916,0.0,0.0,0.242962061,0.0,0.154083893,0.0788688424,0.0,0.0,0.46713875899999996,0.0,0.363337311,0.0,0.0,0.0,0.327651065,0.0051990336,0.169440267,0.0,0.0,0.0,0.0,0.0,0.101173695,0.0,0.0,0.0,0.0,0.42688376,0.11459393699999999,0.364336769,0.0,0.0,0.0753887389,0.0,0.0,0.0,0.0,0.0,0.0,0.19767984100000002,0.0,0.134449603,0.286823806,0.0648371618,0.0,0.0,0.0,0.0,0.0754596205,0.6840152979999999,0.12133526800000001,0.378695526,0.131929305,0.0,0.0,0.0,0.0,0.0,0.0,0.19531291899999997,0.0,0.0686903765,1.00844265,1.37135788,2.03622664,3.13408514,2.96949283,3.77616816,5.11969243,4.74136708,5.97736514,5.80084667,6.04516596,5.86211099,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.132190724,0.0,0.0,0.030327228799999998,0.598980561,0.17661612,0.580721874,0.0,0.0,0.390951383,0.52174692,0.7930454920000001,0.0,1.66935244,0.0,0.151485634,0.9723322209999999,0.41558535700000004,0.5865328670000001,0.0,0.374527792,0.326073553,0.0802337258,1.19428967,0.5735059029999999,0.0,0.0,0.0,0.0,0.41972413299999994,1.40479483,0.0,0.0,0.0,0.26169858,0.0,0.590438992,0.0,0.773311485,0.0,0.0,0.851021778,0.013123369499999999,0.0,0.0654809625,0.842235295,0.052559675800000004,0.0294581048,0.29980233100000003,0.0,1.08782489,0.0,0.0,0.31284005800000003,0.0,0.0,0.0449735056,0.24858954800000002,0.0,0.0,0.0,0.0,0.0,0.6285958629999999,0.0580824423,0.172116097,0.0,0.025390023799999998,0.0,0.0,0.0,0.0,0.77486868,0.0,0.0,0.0,0.0,0.0,1.17673553,0.529692313,0.369703502,0.36501455299999996,0.13499677300000001,0.0,0.933241386,0.18644853,0.142950158,0.890355054,0.69158354,0.565805646,0.325007842,0.166103806,0.44592257799999996,0.225804956,0.475096932,0.247868913,0.65854608,0.308607697,0.829201289,0.988416593,0.47096641,0.0,0.0036197229100000004,0.0022639195100000002,0.51497653,0.271020146,0.0,0.631407234,0.8170360879999999,0.0,0.0,0.0,0.420312571,0.286943148,0.556005874,0.0,0.9688739940000001,0.0,1.00966937,0.0,0.257682998,0.441240034,1.25937952,0.33660646899999996,1.99887856,0.8234062390000001,1.03882888,1.79052849,1.94213116,1.75923643,1.35464886,2.89449807,2.65138633,3.48391169,3.20850398,2.90770712,2.40183921,3.2896919999999996,2.40241121,2.76248308,2.48350748,1.86624443,1.50420322,2.50371606,2.61973527,2.04800778,2.30836857,2.01063435,1.24538189,1.71495281,2.26869829,1.006153,0.895189096,0.444622248,0.69234994,0.25459172,1.11756856,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.383945786,0.418730926,0.7336385120000001,1.15618074,0.843407861,0.0,0.10221616300000001,0.33979119700000004,0.0,0.652455019,0.997553848,0.0,0.49904877,0.0,0.0,3.84158259,4.12950891,0.0,0.0,0.690043463,0.0,0.44933726399999996,2.13269324,1.65351041,0.584753341,0.0464272399,0.0,0.0155937222,0.00122174671,0.0243491775,0.0,0.0778163078,0.0278640822,0.0,0.8191193179999999,1.2193496000000001,0.787333695,2.68146433,3.01962706,0.0,0.0,0.589497823,0.0,0.0,0.345672911,0.0,0.120751815,0.16200276,0.0,0.252615768,0.0,0.0,0.325884522,0.0,0.0,0.35895845200000004,0.0,0.195225101,1.18157591,0.293225187,0.146500293,0.649952352,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.18432885899999998,0.19250293,0.19290364,0.17687314699999998,0.143143585,0.0987132564,0.0568067591,0.0326359337,0.038378273399999996,0.0790111463,0.150328249,0.23973751899999998,0.329545404,0.401664189,0.44227853,0.445087689,0.412254071,0.352950143,0.280146253,0.20677786399999998,0.142524613,0.0921180047,0.055499432300000005,0.0294935872,0.0101726652,0.0,0.0,0.0,0.0,0.0,0.00392923755,0.0207305671,0.0322239829,0.0327563373,0.0201243393,0.0,0.0,0.0,0.0,0.0138235253,0.09231131140000001,0.199544865,0.321631524,0.440758384,0.540553786,0.611776636,0.65669546,0.6907807140000001,0.741004161,0.840930545,1.02364591,1.31415178,1.72300528,2.24267126,2.8473738999999996,3.49639153,4.13996205,4.7264565,5.20934243,5.55269213,5.73448532,5.74754407,5.59844825,5.30508961,4.89358801,4.39515357,3.84322973,3.27100969,2.70927011,2.18444943,1.71698856,1.32008186,0.9990749590000001,0.7517331079999999,0.56947264,0.43943456799999997,0.34705456100000004,0.278629538,0.223358716,0.174463007,0.129227733,0.0880965617,0.0531823348,0.026681231,0.00964820323,0.0014304591199999998,0.0,0.00176083872,0.0042782216799999995,0.0052970080200000005,0.00406309244,0.00107979851,0.0,0.0,0.0,0.0,0.0,0.00163296082,0.0037324202299999997,0.004292489470000001,0.00328462135,0.00126363458,0.0,0.0,0.0,0.0,0.0,0.000361919862,0.0011617624099999999,0.00128366112,0.0008771460679999999,0.000312445942,0.0,1.70718899e-05,0.000362929523,0.000677268613,0.0005995989469999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0021196055800000004,0.00408730816,0.00479312849,0.0036474096999999997,0.000745773462,0.0,0.0,0.0,0.0,0.0,0.0038703793,0.008959488659999999,0.011295536100000001,0.00950579352,0.00365492786,0.0,0.0,0.0,0.0,0.0,0.00504081992,0.0166054456,0.023447263700000002,0.0220918694,0.0117115104,0.0,0.0,0.0,0.0,0.0,0.0043495036299999994,0.0331204214,0.054773336299999996,0.0589982791,0.0398085691,0.0,0.0,0.0,0.0,0.0,0.0,0.123302366,0.294247741,0.47290820899999997,0.625470085,0.720755667,0.7382389570000001,0.673735383,0.541054282,0.36897197200000004,0.19419016600000003,0.052109288600000005,0.0,0.0,0.0,0.0644793414,0.140874737,0.190269064,0.19331649199999998,0.14612539900000002,0.0609701166,0.0,0.0,0.0,0.0,0.0,0.0306938421,0.156055149,0.269994313,0.35025169700000003,0.38511812799999995,0.375629713,0.33388883199999997,0.278270483,0.227186895,0.193438,0.180881282,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.6513870999999995e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,5.6513870999999995e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,82.43181750000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.358
0.02907021,0.44829856,0.09048065,0.0,1.06716755,0.65921353,1.15894259,0.0,0.15752224,0.28661147,0.61154026,1.12456792,0.70055728,1.40791494,0.62205281,0.0,0.0,0.0,0.24947869,0.5786131999999999,0.0,0.8923144000000001,0.0,0.15338713,0.53678256,1.65027277,1.62163006,2.76913736,3.61853972,2.44527102,2.88704387,2.75155387,3.32717045,3.31038714,2.97513941,2.27243143,2.43622065,2.1312946,0.0,1.53337821,0.99168958,1.31898619,0.45626057,0.0,0.0,0.51762368,0.08200863,0.36404646,0.02644703,0.0,0.18263118,0.22631947,0.0,1.44250562,0.0,0.0,0.42267285,0.0,0.0,0.35871254,0.04451814,0.44044347,0.04701742,0.68370285,1.75962951,0.79149437,2.08300072,1.78429992,1.94137654,1.60643838,1.96839884,1.78769653,2.15107482,1.34751226,2.20083125,0.0,1.09253868,0.0,0.68553461,0.57841154,0.0,0.25167533,0.39211855,0.0,0.0,0.65791588,1.0603122,2.22788329,0.0,0.0,0.0,0.58155922,0.7816274000000001,1.30456999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.2400229,1.29822492,0.0,0.164470662,0.005845648929999999,0.9152691470000001,0.0,0.00171568493,0.0,0.622910674,0.0,0.39953996799999997,1.20148798,0.0,1.6947105,2.68607725,1.60969891,0.0,3.16587673,0.0,0.556128951,0.0,0.424735294,0.0,0.21742807,0.0,0.0,0.0,0.845566011,0.6791651340000001,0.210970007,0.22883773300000002,0.44344322799999997,0.0,0.651203154,1.07189306,0.0,0.41571513600000004,0.383102583,0.0,1.06190036,0.0,0.0,1.08928939,1.93654305,3.89128379,5.97716514,4.37920589,2.41605329,0.0,0.0,0.0,0.0,0.279808526,0.0,1.44160182,0.10230540199999999,0.47367717299999995,0.18411861399999999,0.847211287,0.0,0.0,0.433995232,0.045513253200000006,1.67361431,0.0,0.193757515,0.0,0.0,0.9425745879999999,0.5103540879999999,0.291854202,0.09527945480000001,0.0,0.424146601,0.813606849,0.7036001270000001,0.508697516,1.22915829,0.0333258488,0.0,0.407875307,0.0,0.0,0.0,0.0,0.483386325,0.400608009,1.38696785,0.0,2.0351215,1.18469623,1.64885235,0.0,0.260928773,0.0,0.566248089,0.0,0.637052895,0.0,1.83701072,2.98712518,1.63157364,0.26877265899999997,0.0,0.0,0.862401465,0.0,0.0,2.89713441,3.33416966,0.54625514,0.0,0.787008791,1.28010645,0.0,0.155659704,0.0,0.394289499,0.0,1.15082986,0.655133211,0.111467119,0.0,0.0,0.0,0.0,0.0,0.873482318,0.0,0.0,1.75497461,0.0,0.0,0.0,2.1879675,0.963327591,0.7323603390000001,0.0562035144,0.0,0.0,0.0,1.11237472,2.08733979,0.0,2.48969761,1.14228604,0.801709549,0.0,3.75651472,4.47801333,4.28932067,2.18531022,0.0,0.0,0.0,0.5673158770000001,0.0,0.766072326,1.75055139,0.0,0.0,1.18321284,0.263988764,1.42054419,2.41008721,1.92523396,0.602727153,1.68102565,0.0,0.769459978,0.0,0.701759665,0.0547590508,0.39055585200000004,0.115787326,0.0,1.24779159,0.0,0.0,0.299594187,0.0,0.594759454,0.0,0.0,0.5614999039999999,0.0,0.137467801,0.0,0.617891505,0.438781685,1.76045603,1.78377316,1.29286952,0.0,1.01709308,0.0,1.05896187,0.523440208,0.0,0.0,0.0,0.9818070590000001,0.0,0.139178797,1.2778690000000001,0.41268345700000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
62.013688,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.1317253399999998e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,7.829313349999999e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,7.829313349999999e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.1317253399999998e-15,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.16560212400000002,0.174237187,0.0,0.0,0.487441112,1.44812061,0.917840868,1.43871745,1.74568105,2.97645406,2.22182333,0.547323679,0.0,0.15387141199999999,0.6391041670000001,0.685469242,0.061813960599999995,0.0,0.152344573,0.0,0.0,0.0,0.12084669099999999,0.219828169,0.0,0.0740881999,0.320126529,0.325831537,0.41176134,0.0,0.13555557,0.0,0.25455437,0.0,0.287901538,0.40141348200000004,0.0,0.0149863464,0.601906763,0.0,0.32041516,0.0,0.205496505,0.314893149,0.374392354,0.0,0.0,0.214294032,0.0,0.0,0.0489001217,0.0,0.0,0.043127638899999994,0.0,0.0,0.0,0.124208224,0.399627654,0.0941393697,0.0,0.126708776,0.116747056,0.0,0.0,0.304544773,0.22607284,0.312737484,0.34669538899999996,0.0,0.0,0.0,0.324148596,0.141315577,0.34012534200000005,0.180484754,0.0,0.0631616991,0.0469214201,0.0,0.026339757000000002,0.055942375700000005,0.555556895,0.0,0.049929443,0.8825243079999999,3.16037435,4.13458306,3.4316531,1.18059768,0.509215348,0.8997618820000001,1.02935156,0.262703475,0.0,0.0,0.7148662440000001,0.101963395,0.0,0.24606513800000002,2.02242906,2.43490014,1.5178823000000001,0.7349815890000001,0.0,0.556689628,0.8740535079999999,0.541882587,0.0759050251,0.0,0.0,0.0,0.00396901123,0.253700535,0.061750285099999996,0.0,0.08945468919999999,0.106081895,0.0336435885,0.17945761600000001,0.0973122814,0.36010443200000003,0.274966753,0.0,0.42052843100000004,0.0,0.0450197235,0.42253924,0.47488316700000005,0.10839640099999999,0.0,0.0,0.0234252488,0.0,0.287173127,0.0,0.417736114,0.33323567800000004,0.0,0.0,0.404378616,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.044432199900000004,0.0864418991,0.700712832,0.943276606,0.24913143199999999,0.635922279,0.261614258,0.192088005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.659392555,2.20965823,2.53043694,3.81345035,3.89983357,4.28294339,4.96074038,4.3924518,4.86818902,4.31256926,3.48017078,3.4554646,1.95828884,1.93934715,1.09233492,0.958925205,0.583746,0.632246485,0.179361682,0.0,0.557700024,0.0,0.332324297,0.261654017,0.0,0.153231722,0.405216325,0.349741869,0.0,0.0,0.0,0.255710197,0.285557922,1.25463884,1.21236242,1.8030702,1.5397998,1.28139082,1.6676278000000002,0.883880667,1.04617755,0.41565267899999997,0.40294816,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.315269008,0.0,0.26755587,0.758324439,0.690752335,0.239479272,0.0,0.32169565,0.0405194895,0.13567041800000001,0.0279653414,0.015876437099999998,0.018214788500000002,0.0,0.0,0.0,0.0,0.596249885,0.354033109,0.0708799728,0.0774475246,0.46821228200000004,0.32176751,0.0,0.18909362100000002,0.0,0.0,0.0,0.0,0.0,0.0,0.527092396,0.10900218199999999,0.0,0.057168187800000006,0.430590755,0.279285302,0.0,0.141622635,0.242996027,0.339648465,0.0,0.0,0.24471872100000003,0.25076374,0.0,0.5354443210000001,0.0,0.22234036,0.669282894,0.17786402899999998,0.0865256054,0.587562304,0.0,0.548636938,0.352290074,0.0,0.0,0.0,0.0329207064,0.0,0.106089271,0.457107471,0.229831373,0.37541037299999996,0.953315285,0.45361508,0.462347164,0.685002192,1.13184196,0.559115542,0.861496716,0.0,0.511041905,0.262602577,0.0,0.0,0.0,0.0,0.0,0.121798479,0.0,0.0,0.0,0.0,0.121466634,0.23754250600000001,0.0,0.0,0.0,0.0,0.0,0.167100403,0.0,0.0,0.0,0.11215738800000001,0.369534664,0.38462439200000004,0.0,0.170649573,0.389386719,0.305016758,0.0,0.130976795,0.0,0.25697497,0.0,0.136376525,0.0,0.0,0.10179179699999999,0.0,0.281634647,0.15376467800000002,0.0,0.570617357,0.290449552,0.0,0.19109656100000003,0.345878247,0.09029972039999999,0.0,0.166305163,0.368062538,0.315043738,0.0,0.46097612,0.515476281,0.679794775,0.331270661,0.608302675,0.0,0.0,0.0,0.0,0.0,0.0,0.078305682,0.0134644447,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.6042812710000001,0.329604407,0.476112469,0.211361637,0.0,0.0,0.0,0.0,0.0,0.23976459100000003,0.275356903,0.0,0.0114193849,0.455443682,0.0,0.38867746700000005,0.0,0.451994446,0.0334439117,0.0,0.0,0.210062141,0.0,0.210806694,0.0,0.119464717,0.022772152599999998,0.0,0.0,0.0,0.0,0.35717426799999996,0.0,0.359648465,0.205518394,0.167660724,0.0,0.0,0.83327987,0.714918993,0.474805166,0.203697295,0.7506679209999999,1.68936173,2.88896772,4.07944167,5.34939909,6.01670149,4.54369697,3.23889625,1.92460634,0.352443864,0.0,0.0,0.667584975,0.7138612129999999,1.82633049,2.44848492,3.48899173,4.03929733,4.56016373,4.00257821,3.55617928,2.70616989,1.62599446,0.787056568,0.0,0.302974741,0.37181913299999997,0.0,0.142735912,0.0,0.17392201899999998,0.0,0.0,0.0,0.547511526,0.0,0.16187425,0.0,0.0,0.230685526,0.0,0.0,0.0,0.51795327,0.0,0.0,0.0,0.0,0.0,0.0,0.553735787,0.0,0.189499527,0.518665037,0.22594919800000002,0.0,0.0,0.37510450100000003,0.0631722014,0.7647667709999999,1.02522651,1.24163928,0.8258684340000001,0.27158626199999997,0.46479456,0.5628202760000001,0.37832491100000004,0.084415219,0.335080036,0.144561581,0.618926306,0.272498474,0.0363265596,0.360847115,0.0,0.0,0.0,0.0,0.106516562,0.0,0.0,0.00200698725,0.28652923399999997,0.207592988,0.533329941,0.26624437100000004,0.0,0.15180576199999998,0.169517007,0.500279203,0.235013726,0.0304494441,0.0,0.0,0.0193713049,0.331891945,0.0,0.0,0.0,0.0,0.0,0.128834111,0.0,0.552807275,0.48277336,0.588465024,0.47607140200000003,0.174723983,0.0,0.181561783,0.431167132,0.0,0.23632683699999998,1.03951028,0.167253547,1.02713649,0.37086736600000003,0.524700527,0.464619225,0.0,0.6596377920000001,0.0,0.48247784299999996,0.027122160899999997,0.24462323100000002,0.0,0.0858161283,0.0,0.19722422899999997,0.882682396,1.27748345,0.7197793159999999,1.02677085,0.7252492759999999,0.11241488,0.0,0.0,0.00414979584,0.125406168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.308192225,0.247232431,0.20197579999999998,0.16560735199999999,0.133337302,0.102646504,0.0730931895,0.0457695375,0.0225511534,0.00530743166,0.0,0.0,0.0,0.0031023725199999996,0.0117222197,0.018873248000000002,0.0223589877,0.020977150299999997,0.014744633799999999,0.0048587002200000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00970429816,0.020743086100000002,0.027688139,0.0289652567,0.024148316800000003,0.0140701018,0.00067654449,0.0,0.0,0.0,0.0,0.0,0.0,0.00247773596,0.0200044642,0.0356919188,0.04687834,0.0517724292,0.0497903369,0.0416511714,0.029212617000000003,0.015080596399999998,0.00207252963,0.0,0.0,0.0,0.0,0.00498202606,0.014512156399999998,0.0219025458,0.0250513221,0.0228104174,0.0152599617,0.0037228027600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0148398288,0.0291010627,0.0380149692,0.0393056757,0.0321713947,0.0175480698,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00797878727,0.035749214700000004,0.0587723884,0.0715512944,0.0700653853,0.05272693690000001,0.020972584,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0660269085,0.185219973,0.32050964600000004,0.461031288,0.59546971,0.71371636,0.80835458,0.875738178,0.9164961979999999,0.935392386,0.940574496,0.942347851,0.951682044,0.978696858,1.03136734,1.11464039,1.23007568,1.37602679,1.54828237,1.74100919,1.94779291,2.16256633,2.38024888,2.59698826,2.8099818,3.01694521,3.21537154,3.40177031,3.57108518,3.71645821,3.8294433,3.90068488,3.92098454,3.88259733,3.7805449,3.6137156999999998,3.38554706,3.10414553,2.78179061,2.43386709,2.07736509,1.72915834,1.40430744,1.11463031,0.867737267,0.666651656,0.51004237,0.392998158,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
8.0944125,0.0,0.0,0.38502328,0.0,5.30854869,1.91802348,1.93871075,0.68012304,2.04531669,0.88881202,10.80989009,9.44150417,0.0,4.42394089,9.24821144,5.40580277,0.0,1.51750838,5.23789848,0.0,0.0,2.17601635,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.7660653140000001,0.431834244,0.0,0.0,0.0,0.0,1.26479025,0.38144279,1.6224686000000001,0.095203259,0.40157207799999994,0.596837458,0.006901403359999999,0.379741695,0.0,0.613003415,0.664019609,0.0,0.0,0.0,0.783806627,0.0,0.733866111,0.214277828,0.95743236,0.0,0.0984917657,0.640701457,0.594868398,0.0,0.0,0.0,0.0,0.0,0.358593231,0.0674732218,0.751609423,0.889695395,0.0,0.0,0.0,0.0,0.775526222,0.0,0.5772843910000001,0.0,0.40165816299999996,0.421667432,0.534319112,0.295323306,0.0,1.22091069,0.0,1.00975214,1.06872407,2.75860846,2.65198784,1.10357702,0.280795647,0.0,0.12131115699999999,1.02656905,2.13868955,4.76297257,4.21914667,3.19636545,2.67570486,0.5424174270000001,1.89643828,0.838807174,0.40680279700000005,0.891893484,1.41977849,1.40936179,0.37035491200000004,1.51797294,0.334292594,0.15000407400000002,0.21888475300000002,0.20067341,1.13148178,0.0,0.0,0.562251596,0.0,0.513797288,0.0,0.221018285,0.0,0.592133195,0.327403616,0.0,0.0,0.0,0.35352138299999997,0.6527748489999999,0.0,0.0,0.217441448,1.01083421,0.871529953,0.456842242,0.0,0.181287583,0.0,0.696813173,0.7320602509999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.24102009300000002,0.35629762,0.232071026,0.0,0.155901329,0.0,0.0,0.0,0.0,0.184460885,0.33928073,0.0,0.22544994699999998,0.0,0.0,0.129150146,0.0,0.322699966,1.03554997,1.11335389,1.12222375,0.635041127,0.147863523,0.0,0.0,0.0,0.015992527700000002,0.622663657,0.763957384,1.24284584,1.84719451,2.0867688,1.64205107,1.30845242,0.950703525,0.787478885,0.061547697400000004,0.0964627852,0.0,0.259986724,0.0627751961,0.0,0.0,0.0,0.0,0.373913815,0.211856755,0.183661821,0.364656844,0.7513251390000001,0.624885598,0.639829591,0.891944117,0.827476324,0.911238372,0.809171396,0.898382975,0.503953775,0.8106371379999999,0.6840138920000001,1.03496807,1.02034075,1.66671776,1.79928954,1.81629014,1.63698254,1.77592721,1.87336434,2.30344726,3.25946321,3.1317424,3.04470805,1.9762041000000001,0.765459433,0.21839491100000002,0.0,0.0,0.33265495100000003,0.762258518,1.10448322,1.2110002,1.16688408,0.510555483,0.517195147,0.240880845,0.887696765,0.5944897570000001,0.95653671,0.69127939,0.655322999,0.940789463,1.10103826,1.36909002,0.8907847740000001,0.643937165,0.130727136,0.11127954,0.0,0.0,0.405615849,0.8488261359999999,0.520276785,0.520983054,0.436267468,0.13873270699999998,0.140848566,0.0561693727,0.776073638,0.722344488,0.853692349,1.07381023,0.229760402,0.282573948,0.0,0.0,0.0,0.0761606162,0.0772035813,0.225227856,0.14009841,0.0,0.0605763167,0.147377066,0.0,0.0,0.0,0.156777728,0.150127163,0.0,0.0,0.0,0.0,0.0,0.267868497,0.161421962,0.0,0.0904253275,0.17168315399999998,0.254786625,0.320325271,0.41664729899999997,0.09968206289999999,0.457091176,1.07635409,1.70088034,1.72501121,1.96407455,1.63900969,1.43686644,0.26760614899999996,0.10540380199999999,0.0,0.0,0.0,0.328602939,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.239122151,0.0,0.030651287200000002,0.211345702,0.0,0.0,0.349610199,0.0,0.0,0.0,0.125138479,0.0,0.0,0.208403165,0.0,0.22385148300000002,0.0,0.010653801000000001,0.0,0.0,0.0933021032,0.0,0.131502753,0.0579299176,0.133187376,0.347258356,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.63387989e-15,0.0,0.0,0.0,0.0,0.0,4.07157532e-16,3.9258519e-16,3.57537466e-16,0.0,1.76721328e-15,4.05903699e-16,0.0,0.0,0.0,0.0,0.0,0.0,7.717395090000001e-17,1.11202747e-16,0.0,1.76721328e-15,2.1070288399999998e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.2063148399999997e-17,0.0,0.0,1.33242029e-16,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,8.59041037e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.4718673400000003e-17,0.0,4.90847522e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4.90847522e-17,0.0,1.4718673400000003e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,8.59041037e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.33242029e-16,0.0,0.0,3.2063148399999997e-17,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.1070288399999998e-16,1.76721328e-15,0.0,1.11202747e-16,7.717395090000001e-17,0.0,0.0,0.0,0.0,0.0,0.0,4.05903699e-16,1.76721328e-15,0.0,3.57537466e-16,3.9258519e-16,4.07157532e-16,0.0,0.0,0.0,0.0,0.0,4.63387989e-15,85.3173184,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.366
0.521211182,1.90776866,0.14745878,0.618060698,0.0,0.0,0.0,0.0,0.0,0.735024595,0.0,1.01987569,0.644417995,0.0,0.018607303000000002,0.0,0.0,0.0,0.0,0.458093295,0.932825288,0.276105848,0.04890291,0.0,0.893543111,0.0,0.461400911,0.276457787,0.378809255,1.03881087,0.0,0.533163098,0.0,0.0,1.30691117,0.0,0.769303313,0.0,0.129463482,0.77177278,0.0,0.0,0.0,0.0,1.26513818,1.68939476,0.0,0.0784511514,0.268873383,0.0,0.0,0.0,1.35501929,0.0,0.0,0.0,0.0,0.0,0.778438924,0.0,1.75718636,0.650974689,0.566481583,0.0,0.0,0.0,0.259201236,0.0,0.0,0.40277461,0.0,0.116807525,0.0,0.0565547548,0.0,0.0,0.0,1.02535935,0.0,0.0,0.42101607700000004,0.0,0.0,0.0,0.0,0.0,0.23933236300000002,1.28627533,1.59686931,0.9559273970000001,0.0,0.74450444,0.0,0.0,0.9099858340000001,0.39703330600000003,0.78759779,0.0,0.0,0.0,0.0,0.0,0.555889559,0.0,0.141311354,0.0,0.239100952,0.0,0.0,0.0,0.32763792,1.45132585,1.49402629,3.21663069,3.93668487,3.98886906,2.9567237,2.32082448,1.83028661,1.20052828,0.0,0.233860015,0.0,0.0,0.214149593,0.0,0.729257589,0.0,0.0,0.0,0.622636658,2.33200704,0.8817357929999999,3.24055864,2.47534768,1.39313185,1.82287814,0.670103353,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.21473955,0.885129683,0.128370206,0.602095777,0.09012285119999999,0.0,0.0,0.0,0.0,0.182209858,0.0,0.0346303589,0.0,0.0,0.0,0.0,0.431924783,0.220529858,0.36531150700000004,0.0,0.235229164,0.06778170139999999,0.335204732,0.0,0.0,0.0,0.0,0.0,0.0,0.20296159800000002,0.218463977,0.0,0.0,0.132014193,0.101472862,0.16620636,0.133201753,0.0,0.0295421498,0.135196342,0.13098601599999998,0.541670789,0.0,0.0,0.166341572,0.0,0.0,0.10540521300000001,0.0,0.0,0.24565403,0.0,0.494845484,0.535486695,0.395777115,0.0,0.139616137,0.23111537699999998,0.169458107,0.283446666,0.0,0.061462333099999995,0.0,0.0595535184,0.313954303,0.0,0.0,0.0,0.453304683,0.24538799100000003,0.0,0.0,0.0,0.313445182,0.355591361,0.0,0.145432225,0.15340441,0.226736482,0.510183872,0.42096411799999994,0.029846044300000003,0.0,0.285210573,0.414358926,0.45774775,0.0,0.254753901,0.273788693,0.0,0.0,0.0,0.44462365,0.143237552,0.437594989,0.0,0.0459874013,0.0,0.0,0.46091513100000003,0.0,0.491821959,0.51539873,0.0,0.18993949699999998,0.0,0.345540795,0.523778227,0.274554821,0.335091951,0.0,0.0,0.0032800263199999997,0.000184947689,0.0,0.0,0.0,0.538345031,0.0,0.0,0.0,0.0,0.0,0.37900565799999997,0.0,0.0,0.38594075899999997,0.0,0.0804913782,0.0,0.0219308172,0.0,0.0109933242,0.49204549700000005,0.389256261,0.0,0.0222306271,0.0,0.0782267078,0.463196833,0.30270715600000003,0.130051778,0.519440406,0.270687766,0.0,0.0,0.0,0.0,0.0,0.0,0.0431055178,0.16070847800000002,0.0860723725,0.25785648,0.23239801,0.0,0.0,0.528124523,0.0,0.0,0.227030179,0.125053375,0.165365514,0.528033554,1.328783,1.77191968,2.47742966,3.07969349,4.23349164,4.16803823,5.66562809,5.30670911,5.51298459,5.68181008,5.28975527,4.568884,3.2431785,2.85881033,2.41653476,2.16913891,1.74621914,0.8240373209999999,0.710475477,1.1979271,0.9480371459999999,0.763841943,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
6.24197452,5.3644868,5.32507129,4.16322374,3.06457779,2.62090402,0.86006072,1.24436408,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.02763422,0.0,0.30548585,0.73476983,0.93431177,0.54673935,0.4890754,1.23542992,1.09296774,0.25320990000000004,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07115475,0.09416195,0.0,0.0,0.69417776,0.06353212,0.18801319,0.081602,0.70174002,0.38150282,0.77154453,0.41672309999999996,0.65194577,0.0,0.31355558,0.12928198,0.17079923,0.14094868,0.62233036,0.30378947,0.49232463,0.35405331,0.77397109,0.07821719,0.71535695,0.53353852,0.33904998,0.49391679,1.00199901,0.559034,1.04655877,0.52613369,0.0,0.08818200000000001,0.0,0.69392934,0.50154306,0.724162,0.79429888,0.36703813,0.0,0.0,0.41092668,0.77596963,0.58070021,0.0,0.48207877,0.14433852,0.0,0.04824251,0.0,0.0,0.50782782,0.0,0.22705883,0.0,0.0,0.0,0.0,0.0,0.43239252,0.6079817,0.51556352,0.0,0.0,0.0,0.59091403,0.54312426,0.0,0.43843224,0.44936217,0.36728107,0.0,0.0,0.19388643,0.0,0.199152,0.51350699,0.0,0.25432481,0.43200582,0.0,0.0,0.0,0.0,0.0,0.47513895,0.0,0.0,0.0,0.26393698,0.0,0.17244957,0.0,0.46128089,0.0,0.0,0.0,0.04275487,0.53871954,0.39846993,0.0,0.0760297,0.06831923,0.63928223,0.62429865,0.64129236,0.42758781,0.0,0.6399351,0.0,0.57965006,0.0,0.10811985,0.06440607,0.17095853,0.0,0.0,0.35112249,0.54065111,0.09293146,0.02781443,0.52112583,0.0,0.38208353,0.0,0.0,0.61783739,0.23074525,0.0,0.25128648,0.09776911,0.0,0.0,0.0,0.0,0.0,0.0,0.1674928,0.0,0.5985600999999999,0.19851004,0.8373304,0.71874358,0.39341325,0.0,0.5694005999999999,0.0,0.0,0.0,0.0,0.0,0.0,0.23373476,0.46207604,1.52202021,1.12040659,2.76333742,3.25224337,4.39508375,4.48933917,4.98496368,5.69386219,6.25466363,6.59184094,6.26125454,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0250302104,0.008201927409999999,0.0,0.00163860766,0.0196565303,0.0566687008,0.115190111,0.196286501,0.299206068,0.42116578,0.557324513,0.7009588179999999,0.843838668,0.976781653,1.09034649,1.17561204,1.22497751,1.23291489,1.19660498,1.11639605,0.996036105,0.8426473040000001,0.666431266,0.480116021,0.298177063,0.135884488,0.00824391402,0.0,0.0,0.0,0.0763407614,0.266916136,0.5237644379999999,0.8376234490000001,1.19537933,1.58083247,1.97568331,2.36066836,2.71676485,3.02637819,3.27442766,3.44925458,3.54329091,3.55344507,3.48118345,3.33230878,3.11645926,2.84637183,2.53696949,2.20434335,1.86470555,1.53338822,1.2239573000000001,0.947498437,0.712116352,0.522671468,0.38075805100000004,0.28490986100000004,0.231002787,0.212810716,0.222661964,0.252139264,0.29276687100000004,0.336633399,0.376907854,0.408218142,0.426874789,0.430936572,0.420128061,0.39563043600000003,0.359775775,0.315680502,0.266855702,0.21683059100000002,0.168820952,0.12546737300000002,0.088659548,0.0594535331,0.038079628,0.024030343399999998,0.0162113351,0.0131337855,0.0131247159,0.0145321287,0.0159045028,0.0161285664,0.0145149084,0.0108272135,0.00525707139,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0033385441600000004,0.012248351599999999,0.0200227418,0.025834956699999998,0.0290639903,0.0293594579,0.026676792,0.0212798449,0.0137114355,0.0047356358399999994,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00619619767,0.015429165,0.0232485065,0.0288660369,0.0316932716,0.0313978098,0.0279370604,0.0215665589,0.012822256899999999,0.0024782709,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0137661066,0.028849665400000002,0.0424173806,0.052959319500000004,0.0590817093,0.0596404772,0.05386990480000001,0.0414965897,0.022828875499999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.013110206200000002,0.09636652009999999,0.197101315,0.31233344,0.437790643,0.568055702,0.6968080659999999,0.817152623,0.922019727,1.0046138,1.05888211,1.07997141,1.06463841,1.01158093,0.921659982,0.797989445,0.645878011,0.47261856799999996,0.287131178,0.09947725460000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.119246314,0.332855771,0.551511805,0.763845158,0.95912923,1.12795529,1.26280251,1.35846107,1.41227852,1.42421355,1.39669711,1.33431663,1.24335291,1.13121174,1.00579979,0.8748988540000001,0.7455910729999999,0.623782858,0.5138652570000001,0.41853569799999996,0.338790902,0.274084781,0.22262983100000003,0.18180725600000003,0.148640998,0.120285075,0.0944725849,0.0698786237,0.046357905899999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.04586117,1.85501892,2.82317074,2.79211715,1.81771881,0.0,0.0,0.0,0.564322885,0.531723036,0.0,0.148357983,0.147832299,0.962057822,0.6306099310000001,0.0323030485,0.28106415,0.0,0.0,0.39324802600000003,0.33400377,0.0,0.193533664,0.274843136,0.510957611,0.0,0.0,0.0,0.0,0.0,0.308517347,0.0,0.0,0.0,0.0,0.0,0.0,0.460564419,0.0,0.0,0.316291442,0.00713487605,0.0,0.0,0.0,0.18831088399999998,0.233393197,0.224038365,1.02700933,2.85583449,4.98774911,5.03320977,3.14542021,2.13545903,2.15649357,1.86631395,0.806536447,0.223859673,0.813909078,0.76252074,0.49271187299999997,0.423574214,0.0,0.285953978,0.606893053,0.0,0.0980372036,0.37398992299999995,0.682810265,0.0150012198,0.0696142639,0.274584625,0.0,0.44244735399999996,1.00729296,0.909954734,0.8957022029999999,0.272677603,0.277424185,0.324686955,0.0,0.0938168582,0.0,0.215749277,0.0,0.394602685,0.0,0.0,0.105062726,0.0,0.0,0.264140111,0.30052079800000003,0.423988236,0.0,0.0,0.63985053,1.33019508,1.16512703,0.7290312640000001,0.161306424,0.6088596,1.84820471,1.19680372,0.288388333,0.056806304,0.0,0.288348215,0.286835622,0.0,0.30505573199999997,0.0,0.298590805,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.130198049,0.0,0.0,0.0,0.684595501,1.8909151000000002,3.29718535,4.59073609,5.47334451,5.75754172,5.42098231,4.60002554,3.52955303,2.45735072,1.56882257,0.948996548,0.589089695,0.424462884,0.37936625799999996,0.39603733,0.438891824,0.4807152,0.48786575299999996,0.420264097,0.250571854,0.0,0.0,0.0,0.0,0.0,0.6796533709999999,1.53020391,2.34058311,2.89427671,3.04888204,2.79244717,2.24873641,1.62747381,1.14009571,0.917133815,0.9626064809999999,1.16395397,1.35096699,1.3755411,1.17589984,0.797637785,0.36497548,0.0187364215,0.0,0.0,0.008537477120000001,0.151614355,0.21049189,0.153471056,0.016476191799999998,0.0,0.0,0.0,0.0,0.09341320189999999,0.168263515,0.150450699,0.0534930327,0.0,0.0,0.0,0.0,0.045724294699999994,0.130321358,0.142637816,0.07832112349999999,0.0,0.0,0.0,0.0,0.00832088123,0.0980637016,0.133308806,0.09621423720000001,0.00800978878,0.0,0.0,0.0,0.0,0.0684565322,0.122239399,0.109483875,0.0376484813,0.0,0.0,0.0,0.0,0.0396803451,0.109208055,0.119489289,0.0648854482,0.0,0.0,0.0,0.0,0.0102944098,0.0943740067,0.12815074,0.09244417640000001,0.00534087547,0.0,0.0,0.0,0.0,0.0832320402,0.156766114,0.16216864,0.0998274873,0.00511030841,0.0,0.0,0.0,0.038688278,0.10581837300000001,0.117588205,0.0637223351,0.0,0.0,0.0,0.0,0.014331346000000002,0.108604246,0.14661117699999998,0.104873748,0.0031222598100000003,0.0,0.0,0.0,0.0,0.09801242210000001,0.171480968,0.156709278,0.06648414820000001,0.0,0.0,0.07003376509999999,0.351537865,0.728639307,1.09413935,1.34142793,1.41291716,1.32504319,1.15631031,1.00351394,0.928206777,0.921796328,0.9095445390000001,0.7945631959999999,0.521860653,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.56004401,3.77201003,3.35275795,3.50928457,3.61527392,3.43771098,3.49788964,2.77384969,3.0630121,3.10875199,2.67716092,2.49532093,2.06435813,2.19680802,2.07846623,1.80806243,1.78827306,1.44765059,1.52566566,0.662383788,0.74201061,1.05869548,0.314426915,0.473804281,0.16643075699999998,0.364800319,0.20935187600000002,0.458736455,0.338729816,0.115971029,0.245663408,0.319934237,0.0,0.277720032,0.370720072,0.12097847699999999,0.0855296331,0.43337896299999995,0.15959061900000002,0.469540475,0.0,0.253313343,0.37635462799999997,0.585830602,0.577437835,0.31087314,0.129989092,0.405296469,0.34610466100000004,0.413343074,0.0291111914,0.507647863,0.462329768,0.56916898,0.532411754,0.0,0.31332427,0.0,0.27647666600000004,0.0,0.0,0.0,0.0,0.07393197900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.17184951899999998,0.154211337,0.0,0.0,0.26488226,0.024707187599999996,0.36012529600000004,0.0,0.24285692,0.0,0.278489003,0.516136981,0.279478687,0.0,0.402490534,0.142138261,0.57077511,0.0701008904,0.586947628,0.577168172,0.521611969,0.0,0.0204518633,0.0,0.140723186,0.322839955,0.0,0.0,0.186006163,0.31493526899999996,0.0027977610700000003,0.153525979,0.0,0.14431200800000002,0.0,0.0,0.0,0.0,0.0,0.125519043,0.0,0.0,0.0,0.0,0.0,0.0,0.146442706,0.0,0.0,0.0,0.0,0.0,0.0,0.323209182,0.274146887,0.19295489899999999,0.38089204,0.0871348044,0.49011857700000006,0.0777621664,0.19613615899999998,0.0,0.12462998199999999,0.414767451,0.0,0.17292024,0.278346789,0.0,0.0,0.11815869,0.0,0.19406353699999998,0.00249368454,0.0,0.212555845,0.126464662,0.0,0.0,0.18592291800000002,0.272156157,0.220281321,0.639921677,1.06861389,0.961503868,0.731852585,1.20248902,1.67025823,1.23885623,2.06317531,1.82550499,2.03493609,2.58052597,2.88236936,2.53597605,2.67104525,3.30962096,2.87032735,3.47958375,3.65354007,3.6743032999999996,3.36693455,3.99328486,3.61756294,3.7441076,3.68093267,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.07565412,0.19067146,0.56300329,0.0906235,0.70140793,0.0,0.3337857,0.74293831,0.07846317,0.0,0.0,0.20934106,0.0,0.0,0.0,0.0,0.0587933,0.0,0.0,0.68067528,0.55835975,0.23790248,0.65475369,0.0,0.26326309,0.0,0.65087843,0.13453746,0.62148154,0.0,0.0,0.0,0.0,0.43856186,0.54379861,0.26779264,0.46956177,0.0,0.0,0.0,0.0,0.0,0.01243559,0.34076749,0.03863257,0.0,0.58528195,0.43694897,0.84093599,0.98738326,0.7411388000000001,0.63507033,0.07668675,0.0,0.27961656,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.96808538,1.69719431,2.32387235,3.72517769,3.75303415,4.50719883,4.98605333,5.93280205,5.16303281,5.95664782,4.78101358,4.21174286,3.61961684,2.96114736,2.74517789,2.02696609,1.02303533,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.41733707,1.05284753,0.42113087,0.7946792220000001,0.81292828,1.88980649,1.48835329,0.573698033,2.25230622,1.72345409,1.28911584,0.286522279,0.019028058400000002,1.48057178,0.609486269,0.401585113,0.137293807,0.295683161,0.517289853,0.0,0.482763864,0.600145646,0.9255288559999999,0.550117648,1.52885398,0.56574641,1.04473538,0.771378233,0.40776932299999996,0.902874288,0.6045436820000001,0.829611439,0.7932473859999999,0.059517288700000004,0.0,0.300876648,0.557981344,0.12517091800000002,0.7313370109999999,0.0480832441,0.0,1.46721398,0.375315831,0.061045196600000004,0.889249319,0.8382348409999999,0.147343963,1.05834722,0.8910105140000001,0.29914013899999997,1.16222582,0.8532960959999999,0.535123821,0.591053495,1.1966403,2.12889199,2.28370115,1.79707242,2.38682063,2.50219602,3.13716296,2.13269448,2.08466167,1.9976852999999999,2.6277706000000003,1.66268895,1.53697365,1.5024343,1.2974326999999999,0.904180785,1.23402142,0.9317366659999999,1.44257645,0.8083373759999999,0.497831471,0.733425918,0.0,0.612084029,0.16574957099999998,0.415977298,1.02938319,0.532698319,0.165988561,0.46818767899999997,0.362641334,0.125063183,0.037586873300000004,0.0,0.015244618799999998,0.0,0.7461546520000001,0.0,0.0,0.533096721,0.535928238,0.164919286,0.198752596,0.0560046133,1.10879795,0.314630124,0.0,0.0,0.798575571,0.09032581960000001,0.0,0.647760116,0.177274492,0.0,0.0,0.0,0.94640782,0.421610274,0.055720581,1.1258115,0.212403901,0.49647643399999997,0.0153993643,0.177825688,0.0807895513,0.0,0.0,0.262228628,0.20671065800000002,0.365102456,0.368461745,0.0,0.283756575,0.38401222399999996,0.0,0.0,0.982185103,0.0,0.0,0.0,0.140165328,0.341270691,0.0,0.512681878,0.0,0.0,0.45456359999999996,0.0,0.0,0.0,0.198166481,0.143425116,0.0,0.266065021,0.703535183,0.788936462,0.0387399971,0.176256815,0.984266946,0.39092002,0.367147347,0.541453042,0.0,0.7997641040000001,0.280165679,0.0,0.0,0.0,0.38692296299999995,0.0,0.0,0.0,0.293606605,0.9432698740000001,0.0,0.31562714199999997,0.259108369,0.6637083420000001,0.10278895,1.27414958,0.0,0.0,0.18368728199999998,0.268592156,0.00810422797,0.0,0.0,0.804616982,0.0,0.025050512999999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0701081211,0.567401826,1.14858005,1.7731218999999998,2.39336078,2.9591012,3.42267615,3.74387432,3.89417131,3.85977256,3.6431107000000003,3.26261953,2.75080812,2.15085809,1.51213815,0.885153451,0.316506197,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.030423167200000004,0.22024812300000002,0.356071042,0.426505814,0.429921933,0.373611643,0.271926993,0.143697659,0.00931223172,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0562030665,0.120071311,0.160250999,0.173540479,0.160941879,0.127105637,0.07928806940000001,0.0260164256,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00687978248,0.0262415186,0.0369390562,0.0388167602,0.0334544792,0.023675854,0.012854668400000002,0.0041575994,0.0,0.000919403207,0.006716780009999999,0.015288433700000001,0.0237261274,0.0288362948,0.0278752167,0.019225864,0.00288095235,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0300165249,0.077514231,0.119126646,0.147169572,0.155305486,0.139768809,0.100288406,0.0405278273,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.081282353,0.20998484,0.32749445899999996,0.414575614,0.45418285799999997,0.43422687299999996,0.349930739,0.205415202,0.014231511799999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.64304843,0.24523587100000002,0.5184320729999999,0.257074315,0.012287579199999999,0.443917336,0.10468611900000001,0.692265267,0.423477805,1.0169355,1.27520914,1.64984002,1.91789225,2.55427848,2.99385243,3.1409248,3.19257771,3.26548022,3.48365831,3.89571799,3.31408517,3.67581127,3.01047634,2.52027478,2.0835552,1.61929237,1.1430372,1.18666672,0.5398909129999999,0.10000905,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.484829855,0.36439435600000003,1.02246179,1.23417678,0.998809154,1.48047841,0.8077201409999999,1.31202569,0.662028116,1.12702999,0.702493203,0.228530483,0.456863309,0.399279248,0.0,0.0,0.0,0.26130515,0.450536704,0.508843471,0.708351252,0.964788828,0.7369145090000001,1.46004672,1.78547135,2.10559227,1.92011083,1.88622888,2.04449345,1.88578789,2.02844293,1.37863789,1.16033521,1.07835055,0.850573824,0.273384205,0.123212133,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.364954244,0.215499513,0.534472563,0.59388687,0.32160664699999997,0.352509068,0.42683759,0.151140087,0.0633655714,0.434716754,0.106644628,0.190614347,0.0,0.0331826921,0.0,0.241253297,0.301422034,0.0946404259,0.187739717,0.059198119,0.101022183,0.0,0.37837069700000003,0.0,0.0,0.0,0.34669618399999996,0.0,0.00136711168,0.0,0.0,0.0,0.15763751,0.0,0.0,0.0,0.0,0.0,0.0347303693,0.0,0.00219604557,0.0,0.0573962704,0.0024704347,0.157784135,0.0,0.0,0.0,0.0,0.253885869,0.0,0.0816182359,0.0,0.0792972859,0.0974289624,0.34734791,0.0,0.297728915,0.265768584,0.0,0.3193005,0.09309968630000001,0.205168428,0.38031847,0.221490131,0.162907731,0.0,0.0418927805,0.25629162899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.257101621,0.0,0.0,0.0,0.0,0.20419741,0.0,0.33508746,0.0799751371,0.0,0.0,0.0,0.37653619200000005,0.23113957,0.0,0.0,0.0450413678,0.247246973,0.307374968,0.43086792700000004,0.04442067139999999,0.112420861,0.49015164,0.0,0.471551715,0.0290325056,0.248974517,0.0,0.0,0.27283886,0.0,0.0,0.0880689385,0.0,0.0,0.0,0.09878062,0.0,0.419915052,0.0,0.313192203,0.0,0.476983506,0.519069021,0.0,0.0395592427,0.149015397,0.175301851,0.0,0.0687121075,0.0,0.0,0.0,0.0,0.148297275,0.159025042,0.17369321199999999,0.23417486399999998,0.45410858600000004,0.240302325,0.515511498,0.579630557,0.886020432,0.7330486270000001,0.929167767,0.308829653,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.326514973,0.37863206299999996,0.344059283,0.0938045642,0.26336864600000004,0.0,0.382865396,0.11801663400000001,0.0,0.0,0.0,0.0,0.012795913700000001,0.561296412,0.626077592,1.12066146,1.17217884,1.37781125,1.21655193,1.47678593,1.01056791,0.998920971,0.628805368,0.65469436,0.328345185,0.0,0.11212691699999999,0.0,0.0,0.0,0.0,0.00962060272,0.231918994,0.0,0.0,0.23358422,0.15967863300000001,0.11952222,0.0,0.0,0.0,0.312237948,0.0,0.0351192244,0.107521407,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.507596336,0.530464499,0.5866231820000001,0.257084097,0.186085315,0.0,0.055753970800000004,0.14513595,0.0,0.38910358700000003,0.723664997,0.8957841540000001,1.27399206,2.15690457,2.14574257,2.7570862000000003,3.0449569,2.57233162,2.57318671,1.83037241,1.56996068,0.8965030140000001,0.435086679,0.11869406,0.0,0.0,0.0,0.0,0.0980625289,0.0,0.323024313,0.231744027,0.289065345,0.22161365,0.34561720100000004,0.0,0.0,0.0,0.0,0.20492775,0.0,0.0,0.0709807697,0.0,0.0890672525,0.0,0.0,0.0,0.0,0.0,0.0577303157,0.49129593,0.889432047,1.1592014,1.34832826,1.0689258999999998,1.17686072,1.24474549,1.0820309,0.6986385,0.55932676,0.710575847,0.677633956,0.798107783,0.640458681,0.7698601909999999,0.668048513,0.71897222,0.5888894889999999,0.255626507,0.281619271,0.058816802,0.015117531299999999,0.0,0.0,0.048010205300000004,0.366041874,1.11708982,1.74031354,2.27582061,2.58241661,2.81447995,2.80139259,2.40060544,2.08227768,1.67226789,0.7347768,0.668517742,0.0,0.0,0.0,0.0,0.0,0.0,0.016845129599999998,0.370702225,0.126219053,0.454500499,0.128435444,0.42210289100000004,0.448256305,0.235545399,0.23726425,0.21466632800000002,0.51192312,0.736911271,0.787066499,1.24401158,1.09603485,1.0793337,1.06528017,1.13143278,0.972684957,0.893568171,0.363100143,0.134044055,0.0,0.313646317,0.150398965,0.0757857492,0.0,0.226924842,0.0,0.0,0.31584497899999997,0.42496756700000005,0.128493306,0.274828703,0.139677904,0.35830952299999996,0.399273219,0.512354038,0.324770147,0.497685816,0.5983328370000001,0.31548562,0.235926873,0.0898870034,0.281352918,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.21844478,0.584154524,0.18338995600000002,0.0281443519,0.0584259588,0.174943237,0.278603284,0.30319526,0.231575223,0.0923535998,0.0,0.0,0.0,0.0,0.0,0.0851308016,0.16281965,0.17636771199999998,0.125367428,0.0334632781,0.0,0.0,0.0,0.0,0.0,0.042185220700000005,0.0932824436,0.105318362,0.078666444,0.027805111,0.0,0.0,0.0,0.0,0.0,0.0130662604,0.0344067181,0.0382320338,0.0273629997,0.010216795899999999,0.0,0.0,0.0,0.0,0.0028444932899999997,0.0,0.0,0.0,0.0,0.0,0.004650352020000001,0.0342472025,0.0570331021,0.060584511900000006,0.0388018399,0.0,0.0,0.0,0.0,0.0,4.17214796e-16,0.0718818787,0.124777982,0.134783249,0.09239278769999999,0.00811424978,0.0,0.0,0.0,0.0,0.0,0.106807264,0.206624692,0.236054858,0.176099998,0.0408280325,0.0,0.0,0.0,0.0,0.0,0.144462429,0.32627015,0.400717645,0.326341316,0.114613034,0.0,0.0,0.0,0.0,0.0,0.202073317,0.573537659,0.77723083,0.7033268159999999,0.328217172,0.0,0.0,0.0,0.0,0.0,0.43499718,1.97354353,3.62564252,5.04714152,5.92481283,6.06101918,5.42943848,4.18516076,2.62563475,1.11328293,0.0,0.0,0.0,0.26209713,1.25452957,2.26654344,3.03089073,3.37312189,3.24694198,2.73064805,1.98949595,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.36997819600000004,0.507976332,0.7360695309999999,1.19939904,1.59897557,1.42689322,0.74575623,0.307463279,0.653296653,1.38488226,1.66536382,1.28150099,0.800076518,0.680961218,0.6915384109999999,0.41989247700000004,0.0,0.0,0.178773235,0.359433196,0.190822199,0.0114005484,0.16811919600000003,0.416505919,0.302513768,0.0,0.0,0.31329135199999997,0.544805083,0.186468064,0.0,0.329270296,1.64665126,2.56131547,2.1377214,0.8207951040000001,0.0,0.0119285521,0.75816229,1.26939941,1.14918982,0.585607422,2.39470433e-15,0.0,0.0,0.227763482,0.179484655,0.0,0.0,0.506146488,1.72582597,2.21001601,1.43693492,0.195979354,0.0,0.0,0.24425457,0.126019981,0.0,0.125038356,0.493068591,0.448868414,0.0,0.0,0.0,0.344070566,0.42791980700000004,0.437898326,0.6894989559999999,0.895460096,0.5408213479999999,0.0,0.309206981,2.21514935,4.59082433,5.5895703,4.54872116,2.59846943,1.26454433,0.920410115,0.879437351,0.606271248,0.27984872,0.22605373899999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.1483256,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12186828,0.25761068,0.36544353,0.42799177,0.43259436,0.37326755,0.25204526,0.07947923,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17295141,0.66777058,1.22641843,1.8107939999999998,2.37839434,2.8863244999999997,3.29543913,3.57416485,3.70158399,3.66944126,3.48285599,3.15966894,2.72850691,2.22579198,1.69203693,1.16784263,0.69003646,0.28836319,0.0,0.0,0.0,0.0,0.0,0.0,0.02237193,0.16360757,0.28043177,0.35672524,0.38334932,0.35852228,0.28734597,0.18061246,0.05309293,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.09680737,0.28855112,0.4906442,0.69046237,0.87586912,1.03586588,1.16109182,1.24420037,1.28014797,1.26642515,1.20324307,1.09366518,0.94364976,0.76195205,0.55982866,0.35049675,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.1559499,0.124387949,1.00839687,1.07522171,0.0,0.0,1.06242251,0.072218231,0.30887385100000003,0.866560742,1.11113913,0.630548685,0.0,0.0,0.48856638399999996,1.27681697,0.0,0.0036059558000000004,0.629460781,0.0,0.0,0.0,0.0,0.603926051,0.41827261,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.449138894,0.0,0.0,0.24081495,0.0,1.02024863,0.0,0.549378487,1.64089253,0.391056485,0.18583782,1.53570738,0.0720618745,1.1867563,2.37474536,1.5511473,1.94217419,2.50966189,2.17841377,1.97012123,3.61100484,2.65400358,2.81935304,2.57637546,2.77831387,2.98284485,3.61812384,1.57737935,3.68757535,2.40506969,2.86449652,2.1018596,3.50176353,2.39599908,2.86412346,0.890171348,0.922659755,2.28297425,1.46345724,1.4335209,0.523197096,0.805386057,0.0,0.527616379,0.0,0.565090645,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.12427502900000001,0.0,0.0,0.0,0.0,0.724110613,0.0,0.255514995,0.298842027,0.730140103,0.0,0.41836691,0.0,1.14155415,0.0,0.0,0.330873083,0.6608602379999999,0.028755448399999998,0.94933519,0.744977483,0.663861425,0.0,0.627168233,0.0,0.185387722,0.0,0.315529393,0.48016875,0.12247088699999999,0.0,0.09316265380000001,0.21288317399999998,0.0,0.0,0.559305549,0.0,0.0,0.166737644,0.0,0.0,0.0,0.521663984,0.0,0.0,0.0,0.0,0.0,0.0,0.556427322,0.514644178,0.0,0.0,0.11982818,0.0,0.496718686,0.0,0.171229283,0.0,0.781716402,0.11901433199999999,0.7177330820000001,0.367626999,0.8395120640000001,0.7479196220000001,0.0,0.0,1.21257928,0.21700836399999998,0.070481938,0.0,0.279224806,0.174302161,0.0,0.267108226,0.17170629899999998,0.0,0.39509698200000004,0.25490217800000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.79730219,3.07075573,3.45111794,4.02057949,3.98302235,3.41601495,2.90457912,2.65008533,2.74257436,2.53748516,2.57537981,1.83727235,0.7566601040000001,0.719396646,0.644480908,0.632723821,1.07031909,1.35233285,0.882464482,0.501061002,0.6920018379999999,0.313117302,0.884918339,1.1428096,0.595131628,0.183982481,0.0,0.0,0.0,0.250785968,0.467263062,0.0,0.0,0.0259302714,0.0,0.148576616,0.0,0.317105798,0.0329799719,0.0,0.0570690384,0.0,0.0,0.0,0.0,0.25442554,0.22057296,0.69811472,1.23358718,1.69889198,0.72466058,0.535829414,0.259480598,0.0,0.0,0.0785144408,0.0,0.545527619,0.39300997600000004,0.0,0.0,0.124941735,0.197044377,0.6030034360000001,0.0,0.147780152,0.0,0.0,0.120349999,0.0,0.475788738,0.051942765700000004,0.0,0.0,0.134090732,0.2873393,0.847257455,1.76866475,1.13664047,1.14248166,0.10964479699999999,0.389547405,0.34503768700000004,0.554734589,0.865424777,0.813588913,0.0785057099,0.0,0.265120567,0.26153235,0.333419572,0.7812135859999999,0.6757702640000001,0.344115173,0.43667493,0.644176347,0.0859071702,0.6513640070000001,0.7283859779999999,0.416619731,0.729266524,0.16037921900000002,0.0732125993,0.27180039899999997,0.16331042,0.0578546431,0.0,0.0,0.0,0.060796582300000006,0.11927397699999999,0.0,0.312621195,0.0,0.169381494,0.0,0.0,0.313417768,0.0,0.16669203300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.134596175,0.0,0.0518045501,0.34883116799999997,0.18730499,0.216853758,0.0,0.0,0.102234849,0.309616779,0.48118941299999995,0.51706941,0.00993096328,0.0,0.1691388,0.0,0.23015506800000002,0.412415135,1.00652729,1.35201108,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.007090814809999999,0.7632536129999999,0.0,0.42296464899999997,1.02706333,0.653780479,1.26405355,0.0,0.0,0.153598026,0.307959357,0.0197582044,0.978177576,0.17326659600000002,0.57411133,0.511431072,0.372697875,0.12735987099999999,1.1032412,0.0,0.0,0.6788026509999999,1.01381126,0.0,0.189678449,0.0,0.0,0.632550399,0.137068453,0.0,0.009879584949999999,0.567610793,0.053068898499999996,0.149600456,0.0,0.0,0.782839788,0.0,1.16370626,0.0,0.684890089,1.38159484,2.78034174,3.72492126,1.50834121,2.43458064,1.07912588,0.0,0.0295347894,0.0,0.262163007,0.782364367,0.990357791,0.649082747,1.5872218999999999,2.07142255,2.07335974,1.42738069,0.33620913,0.411399575,1.17410283,0.151260381,0.0,1.17740659,0.0,0.0,0.0,0.398230984,0.8128315979999999,0.596534105,0.469396927,0.0,1.0591727,0.157804993,0.517717753,0.0,0.00044890943099999995,0.852365791,0.0,0.0,0.296987067,0.42531564899999996,0.031279012099999996,0.039105553599999995,0.47977026100000003,0.0,0.0,0.37785027299999996,0.99627135,0.0,0.0,1.12536076,0.685371307,0.0,0.36682899700000005,0.125929703,0.40506912899999997,0.125821453,0.09554618890000001,0.561811789,0.865112537,0.11327054800000001,0.0,0.0,0.0,0.501399746,0.0,0.0,0.0,1.49588817,0.00876492085,0.42429626200000004,0.0009302534829999999,0.0,0.0,1.27770053,0.0,0.161905761,0.414117595,0.38859549299999996,0.0,0.30922984600000003,0.8599319590000001,1.0167423,0.898863463,0.5355193429999999,0.61141509,2.20936435,1.7868243000000001,0.657244743,0.5468645870000001,0.0,1.6496365000000002,0.49235717,0.191408356,0.0,0.252196064,0.0664616809,0.254130505,0.38855668200000004,0.0,0.0,0.0,0.0,0.0,0.16917257,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.509604314,0.274734274,0.52121709,0.856020676,0.07039658830000001,0.0,0.0,0.0,0.0663062463,0.664642724,0.0283433158,1.2579806,0.129907144,0.586338421,1.86715167,1.06544113,1.2190834,1.11382271,0.0,0.31256292199999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.332574743,0.551096476,0.7400192870000001,0.835506173,0.7941013729999999,0.619933478,0.375003325,0.15283608699999998,0.024981776,0.0,0.0196804877,0.0238310631,0.0,0.0,0.0,0.00388880089,0.0657592394,0.0740210849,0.011492295100000001,0.0,0.0,0.0,0.0710468556,0.121380487,0.0623477812,0.0,0.0,0.0,0.0493314399,0.173346988,0.149435927,0.0,0.0,0.0,0.0,0.245041665,0.33195961,0.10348819199999999,0.0,0.0,0.0,0.506944406,1.56900676,2.33744428,2.39597524,1.72258191,0.706768822,0.0,0.0,0.0,0.511341452,0.9119123109999999,1.01237067,0.91793821,0.847905661,0.919891957,1.04927387,1.03598809,0.75367656,0.276982524,0.0,0.0,0.0,0.0604716441,0.236475983,0.192723405,0.0,0.0,0.0,0.0,0.147162429,0.18957802199999998,0.0639398973,0.0,0.0,0.0,0.09457555949999999,0.22377213399999998,0.169590551,0.0,0.0,0.0,0.0324239838,0.41432621,0.705885971,0.739404697,0.51364167,0.195371291,0.00731493145,0.08059715,0.371316195,0.6941592329999999,0.8461223259999999,0.7352817079999999,0.43058306,0.105132702,0.0,0.0,0.0172390736,0.0996972942,0.0858638055,0.00324558136,0.0,0.0,0.11742476,0.223510386,0.211141957,0.073042181,0.0,0.0,0.0,0.0499337501,0.105422129,0.045733328399999995,0.00393807785,0.20113734100000003,0.73361412,1.39753005,1.73396745,1.33342736,0.221993964,0.0,0.0,0.0723556421,2.95144234,6.31934961,8.63540265,8.72703198,6.50121935,3.03557239,0.0,0.0,0.0,0.0990554449,1.06812881,1.01715129,0.12068125099999999,0.0,0.0,0.0,0.64341039,1.02591467,0.49381499799999995,0.0,0.0,0.0,1.36217498,3.64822216,5.22316721,5.30595589,3.92784205,1.85476002,0.0759131759,0.0,0.0,0.0,0.314410054,0.38078728,0.13546581,0.0,0.0,0.0,0.0783982914,0.220455862,0.22627564,0.13772353199999998,0.0513632339,0.0461641946,0.14749087800000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0643905646,0.0,0.0523232102,0.0,0.24571474199999999,0.0604148611,0.43512188,0.86616783,0.39774223,0.247172123,0.0,0.494977768,0.0,0.0819932391,0.0,0.7207635309999999,0.8948282909999999,0.18752492399999998,0.0,0.19611888800000002,0.0,0.335736935,0.0,4.97974401,2.15429251,0.0,0.646034363,0.18153775,0.237176783,0.0,0.111503091,0.428061817,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.31523221,2.13218423,1.84030744,1.50244616,1.18339693,0.93669783,0.7943700909999999,0.761774355,0.818579355,0.92546423,1.03489682,1.10343586,1.10269395,1.02643741,0.89220744,0.737116254,0.608811586,0.553710166,0.605224829,0.7747126259999999,1.04725518,1.38329053,1.72579764,2.01148974,2.18358096,2.20335007,2.05800719,1.7632033999999999,1.35971563,0.905116653,0.462315223,0.08748506060000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0400537511,0.093190908,0.10009498900000001,0.07350169549999999,0.0361231433,0.0131785505,0.0247513927,0.0799290944,0.174165015,0.290443774,0.40384691899999997,0.48825141899999996,0.523361315,0.5002029020000001,0.423620956,0.311095104,0.188155558,0.0815752312,0.012123251699999999,0.0,0.00633875147,0.046294177699999994,0.0824440479,0.08846469900000001,0.0464975274,0.0,0.0,0.0,0.0,0.0,0.0,0.11803226900000001,0.5770479589999999,1.14300256,1.75029603,2.31706962,2.75926222,3.00606771,3.0136602000000003,2.77430604,2.31886265,1.7119944,1.04093337,0.399955375,0.0,0.0,0.0,0.0,0.0,0.0,0.14901277599999999,0.371961799,0.492801169,0.493347074,0.384495498,0.201419524,0.0,0.0,0.0,0.0,0.0,0.0,0.0886510038,0.25780214,0.37622135700000003,0.41756180600000004,0.374600486,0.260197275,0.103513517,0.0,0.0,0.0,0.0,0.0,0.0,0.09792549310000001,0.22148857600000002,0.301830295,0.32620429,0.298905217,0.240532224,0.183239751,0.163091147,0.21129949,0.346387285,0.569072053,0.861047848,1.18793733,1.50574579,1.76937446,1.94131945,1.9986846999999999,1.93706122,1.77056207,1.52817449,1.24739401,0.966657471,0.718275287,0.5233495810000001,0.38961977,0.31244264899999996,0.278370956,0.270220107,0.272237403,0.27406552,0.272588852,0.271356773,0.277933708,0.30006550600000004,0.34184155899999996,0.4010045,0.46822723299999996,0.528630379,0.565195026,0.5631961639999999,0.514478297,0.420396041,0.292551505,0.151001425,0.0202459438,0.0,0.0,0.0,0.0,0.0624370555,0.17628832600000002,0.274246918,0.333073128,0.338652106,0.289214085,0.195693538,0.0791189814,0.0,0.0,0.0,0.0,0.0,0.00752460696,0.104291903,0.18129567,0.218165991,0.204555042,0.142678631,0.0468027793,0.0,0.0,0.0,0.0,0.0,0.0,0.0337536794,0.13457112,0.203102586,0.222057595,0.186158672,0.10358626900000001,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0940029362,0.191663015,0.243659856,0.236067606,0.16940111100000002,0.0588163313,0.0,0.0,0.0,0.0,0.0,0.0,0.0400350848,0.173178891,0.26761774899999996,0.298375742,0.255353517,0.146365573,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.143557299,0.305100263,0.3996362,0.398776349,0.295886559,0.10942121199999999,0.0,0.0,0.0,0.0,0.0,0.0,0.392313749,0.902834237,1.41982194,1.86977824,2.19028091,2.3418702000000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.829051271,1.55881424,1.95949232,1.91411319,1.92405851,1.61399655,0.8880731079999999,0.427146035,0.614964873,1.02324875,0.940508308,0.7763513809999999,0.866845082,0.6747917859999999,0.245532972,0.155024945,0.108421979,0.7372552090000001,0.780167127,1.22759406,1.22590952,1.55891195,0.900240013,0.606698231,0.0,0.0,0.0,0.34806343700000003,0.0,0.31832896899999996,0.315859244,0.206152963,0.0,0.242464605,0.34207742700000004,0.5586568670000001,0.839468752,0.842257795,1.3656581,0.900215984,0.927268926,1.42986608,1.22658449,0.529936245,0.131110191,0.11560279400000001,0.0,0.0,0.0,0.57516744,1.45411512,1.82979849,3.05067436,3.44073204,3.63848756,2.87562835,2.52823975,1.19785208,0.912247041,0.7501333309999999,1.30745562,1.64813988,3.16917141,3.11511852,3.32111082,2.44879091,1.68806947,0.5437328,0.0,0.0,0.0,0.360385898,0.705218902,0.36861224200000003,0.47132474799999996,0.130967817,0.0,0.0,0.0815827422,0.0,0.572051788,0.0,0.0,0.233123665,0.114231604,0.0,0.222986705,0.35970449,0.0,0.0,0.18200654800000002,0.0,0.151747809,0.46441124899999997,0.146511565,0.563174253,0.128407957,0.010670770900000001,0.0215047642,0.0,0.0,0.152898546,0.0,0.0,0.21260232699999998,0.190311375,0.0,0.19482303399999998,0.175632819,0.0840932244,0.905802888,0.510982035,0.322265452,0.033850275,0.0,0.0,0.0,0.044456002,0.276511004,0.451978159,0.0,0.0,0.14986403199999998,0.07718559950000001,0.294995038,0.603395115,0.741207475,0.973638531,0.724757978,0.0945892222,0.044395495599999994,0.0,0.0590901028,0.401967831,0.28202628399999996,0.40227465,0.0,0.0,0.0,0.0,0.430942793,1.00235964,1.45442989,1.27983793,0.954139645,0.313903844,0.0129309481,0.33686491,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.434552731,0.47439282899999996,0.231974488,0.0,1.00582577,1.34958566,0.695729079,0.434699471,2.22798774,0.0,0.7101606859999999,0.8459124440000001,0.8012990520000001,0.0,0.403686514,1.13326179,0.0,0.0,0.640184655,0.17566874100000002,0.0,0.0,0.470205295,0.9382868440000001,0.0,0.0,0.0,0.0,0.0,0.0,0.9509134370000001,0.159390477,0.0,0.9770333000000001,0.5191425479999999,0.122231437,0.0,0.528154959,0.0,0.0,0.0,0.0,0.0,0.0,1.44368603,0.573595175,1.29272435,0.927895485,2.57891533,2.37470978,1.38410997,0.8398598620000001,1.85750148,1.33338273,0.975039098,0.0,1.3196018999999999,0.7222879720000001,0.0,0.393904414,0.619117869,0.0,0.0,0.0,0.0,0.749451462,0.207962995,0.0,0.48011806100000004,0.292481201,0.256240627,0.0623063683,0.17355223399999997,1.57399952,0.323318759,0.33917796299999997,0.0,0.0,0.0,0.0,0.38312913200000004,0.731087347,0.0244022189,0.0,0.0,0.0,0.49408959,0.0,0.722810501,0.798809984,0.0,0.12094529,1.07697561,0.449967109,0.024620943,0.0,0.0,0.030254831,0.0,0.110643802,0.84649523,0.0,0.11178002599999999,0.0,0.416488522,0.866382428,0.262600567,0.0,0.0582415652,0.258248255,0.264603592,0.0,0.0,1.18670932,0.0,1.03227063,0.401868076,0.0,0.0649279282,0.0,0.0,0.0,0.0,0.0,0.427023227,0.5855138520000001,2.00260913,2.00126008,1.8146836,1.37363828,0.577291962,0.994909722,0.478451246,0.0,0.0,0.045198431399999996,0.776450917,2.18896195,1.91389859,2.43495715,2.39929118,3.42943382,2.72941257,3.12310884,2.80786376,0.7979732709999999,2.29993718,0.587431684,0.0,0.0,1.32833067,0.0,0.0,1.00814227,0.0,0.761498316,0.238937747,0.434028828,0.0,0.275014208,0.0,1.05854625,0.292605398,0.0,0.0564885958,0.193214362,1.23307341,0.183572352,0.0,0.0,0.757150928,0.620574938,0.0,0.202679826,0.305719395,0.7507182379999999,0.0,1.15933692,0.0,0.0,0.236018069,0.0,0.346576239,1.35300547,0.698287359,0.37665352700000004,0.0,0.415537079,0.0,0.400379529,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.290332934,0.14520955300000002,0.23416311,0.316111138,0.132278381,0.0,0.38511624200000005,0.0,0.0,0.0,0.0,0.0,0.11938716699999999,0.0,0.0,0.409647121,0.0,0.0,0.0,0.343023065,0.390532004,1.98047984,0.7248401409999999,0.593650758,0.0,0.0,0.19880062399999998,2.82809321,2.11682704,0.0,0.387458749,0.0,0.0,0.0,0.496372142,0.0,1.05445744,0.0730281989,1.40878863,0.0,0.467292184,0.307492761,0.50184457,1.07714388,4.36814882,0.93854432,0.0,0.426018392,0.369028088,0.34455441700000006,0.384723007,0.216914816,0.2543406,0.463499354,0.183032673,0.405338407,0.357668869,0.17701192300000002,1.30063101,0.130230433,0.0,0.0,0.0,0.0750193615,0.191707152,1.69606193,0.34473224399999997,0.0,0.09708551,0.0,0.0,0.0,0.0,0.261585567,0.0,0.0,0.148937058,0.180879757,0.12817990699999998,0.0,1.39948468,2.2075186,3.14480385,3.19031911,2.40569624,1.0639254999999999,0.0,0.0,0.0785107638,0.045657200599999996,0.522424019,0.56183707,0.999047927,2.24796337,3.17336041,2.43471199,1.77315694,0.77956999,0.0478595949,0.208186525,0.0904306427,0.0,0.11207921400000001,0.0,0.203706092,0.0,0.164579107,0.182074806,0.20831065899999998,0.0,0.0,0.020288548,0.28688522699999996,1.65991441,0.741301234,0.0,0.260008116,0.0,0.0,0.436968374,1.30543595,0.8931189140000001,0.0,0.545152379,0.454195522,0.0,0.555354231,0.0,0.0450013083,0.22806402399999998,0.062358586900000006,0.0,1.2236292,0.77285864,0.0,0.12330010699999999,0.160258991,0.52758853,0.0,0.5308462829999999,2.09986098,0.335001227,0.46112924200000005,0.0540742926,0.0,0.0,0.0,0.0,0.0904410991,0.21119560699999998,0.00246146506,0.0,0.354568914,0.129861449,0.40081948,0.37129015299999996,0.9800029,0.0657973823,0.34968263,0.0,0.485611774,0.303918578,0.131221569,0.39704663700000004,0.348687134,0.0,0.39594801700000004,0.15998469699999998,0.0341758854,0.321740453,0.231567881,0.0,0.154704393,0.40440898200000003,0.0,0.0,0.0,0.054527737199999995,0.11077141800000001,0.0,0.165027748,0.207086098,0.699805074,0.252271767,0.520921855,0.0,0.22236991600000003,0.257475599,0.0,0.0,0.39440923899999997,0.0,0.0297529409,0.0,0.301621276,0.0,0.172100742,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.87182294,0.0,0.0936754057,3.07981969,0.287300762,0.0,0.0,2.98546252,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3.05334875,3.55582708,0.8528628229999999,0.862810235,0.0,2.09025884,2.09225348,1.94261674,0.0,0.0,1.52949956,0.0,0.273586701,0.0,6.29807216,2.39154302,0.0,0.0,8.02319028,0.533065095,0.0,0.0,1.21533973,2.62238836,0.0,1.49788235,0.0,3.37292945,0.0,0.405732665,0.0,0.0,0.0,0.0,1.1197967,0.0,0.064208065,1.16090492,0.0,0.0,3.37280156,1.69747098,0.0,1.5003672,1.48194288,0.0,0.8305509879999999,0.0,0.0,0.0,1.35320256,0.0,4.32151227,0.10683430599999999,0.0,0.46306135299999995,3.29746159,0.0,0.494924604,0.0,0.0,0.0,1.40528651,1.11003031,0.163938482,0.0,0.0,2.77360207,0.479139645,0.0,0.0,2.14232867,2.24211837,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8045775909999999,0.8880336590000001,0.524805021,0.47910486700000005,0.0,0.120602165,0.1861981,0.6468879439999999,0.181622089,0.198659179,0.14797511300000002,0.130120268,0.22497271600000002,0.0,0.0,0.0,0.0,0.0,0.0,0.00827505113,0.028240975499999998,0.12622330199999998,0.0,0.0,0.23188357,0.0,0.0,0.560346473,1.34141544,2.40502187,3.05188514,2.1929945,1.02363873,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.107300254,0.356027793,0.544250586,0.622758368,0.565718328,0.378071845,0.09609764789999999,0.0,0.0,0.0,0.0,0.0,0.0,0.156150219,0.552449925,0.87487207,1.05435319,1.05274591,0.872532985,0.557247576,0.18213717399999999,0.0,0.0,0.0,0.0,0.0,0.27154866899999996,0.596591175,0.805548858,0.826624461,0.632687815,0.251416775,0.0,0.0,0.0,0.0,0.0,0.0,0.116976235,0.8220018459999999,1.40477061,1.70068144,1.59437358,1.05335674,0.146482566,0.0,0.0,0.0,0.0,0.0,0.0,1.28988687,3.99383254,6.90087282,9.62402868,11.7809601,13.059681199999998,13.273293300000002,12.3932462,10.5546784,8.03273872,5.19437871,2.43479412,0.11054284699999999,0.0,0.0,0.0,0.0,0.0,0.509431764,1.51426559,2.16047645,2.34151272,2.05976682,1.41497139,0.574052715,0.0,0.0,0.0,0.0,0.0,0.0,0.0160737449,0.54314096,0.89774419,1.01319389,0.882650678,0.555967037,0.124061974,0.0,0.0,0.0,0.0,0.0,0.0,0.14452768,0.440186815,0.613367653,0.6310084539999999,0.498538818,0.25627768300000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.184167932,0.358617733,0.43828546,0.409615556,0.28546602,0.100604468,0.0,0.0,0.0,0.0,0.0,0.0,0.032168088,0.18092686600000002,0.278090711,0.303592531,0.25561526100000004,0.149970787,0.0152867174,0.0,0.0,0.0,0.0,0.0,0.0,0.0620659233,0.147849966,0.19218908199999998,0.18763801,0.139134135,0.0618883164,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0516732985,0.0869888375,0.100643015,0.0970320683,0.08709458869999999,0.08496526880000001,0.10373395699999999,0.151456888,0.228477304,0.326753193,0.431360565,0.523781747,0.586142732,0.605341389,0.576058659,0.501946137,0.39475132700000004,0.271652461,0.151498252,0.0508813362,0.0,0.0,0.0,0.0,0.0,0.022411422400000002,0.0439251904,0.051948822900000004,0.046423865300000006,0.030910366600000003,0.010925991000000001,0.0,0.0,0.0,0.0,0.0,0.0,0.00191239122,0.0174266799,0.0369496496,0.061758660599999994,0.09206803470000001,0.125991612,0.15910365099999998,0.184890793,0.19611331,0.186785797,0.154240465,0.100632531,0.0333315449,0.0,0.0,0.0,0.0,0.0,0.0,0.014703333899999999,0.07528614480000001,0.115526356,0.12515258,0.102635453,0.0564982697,0.00398342557,0.0,0.0,0.0185223944,0.12329243599999999,0.269535643,0.431953661,0.57662126,0.668379297,0.679373852,0.5967023,0.427169965,0.19771068,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.263
0.284266578,0.0,0.0,0.0888676691,0.0,0.536749472,0.174561274,0.8512820440000001,0.6599265679999999,0.548986447,0.850229564,0.0,0.128535346,0.0,0.0,0.0,0.34454366799999997,0.21274401,0.0,0.410621129,0.0,0.0,0.352931744,1.35792806,0.210710989,1.50753292,0.318998933,0.0,0.08964570279999999,0.9998470359999999,0.378649905,0.53774522,0.24070108699999998,0.680105705,1.65465598,1.63053419,1.11775435,1.5900689,1.70305038,2.03018541,1.06438557,1.77908804,2.27581683,1.4141252,2.20822098,2.77216645,2.60696188,2.87731336,2.97000458,3.45249791,2.61221053,2.46119926,2.23775376,2.2265505,3.29673071,2.73227834,1.96217879,2.6534071,2.24503758,3.12930497,2.13489984,2.81483168,1.76931177,2.62621013,1.18409251,2.22066626,1.55627449,2.14425923,1.48039941,1.70578735,1.43215334,0.826889863,1.91804524,0.9791641320000001,1.07926123,1.20077114,0.6748914420000001,0.489983265,0.0,0.558633182,0.0,0.292391965,0.372234915,1.103615,0.901026367,0.044381877800000004,0.0,0.0,0.31248538,0.48316629999999994,0.0,0.17171983,0.050757344100000004,0.492277795,0.816867625,0.06462960059999999,0.855547872,0.766439746,0.708104662,1.30275888,0.6858174659999999,0.875243483,0.559866689,0.0,0.643986952,0.19943555899999998,0.0,0.206941916,0.346275089,0.0051248991,0.386472925,0.254525918,0.39110096299999997,0.18724389,1.17765458,0.0,0.43658770700000005,0.0,0.0,0.0,0.735419355,0.16490726,0.0,0.7056701459999999,0.41804943,0.453271692,0.319531363,0.00255570188,0.19738255100000002,0.35998640299999995,0.0,0.0,0.0289390531,0.5112205,0.0,0.0,0.0,0.0,0.0673133461,0.0,0.18497532600000002,0.35156103,0.0619450479,0.0,0.0,0.672612038,0.706861382,0.0,0.359084051,0.0,0.147339245,0.162308326,0.11914449699999999,0.0,0.387312895,0.484784657,1.07330836,0.0,0.0,0.0,0.502106245,0.0,0.33090259899999996,0.0,0.0,0.0,0.52504479,0.611468241,0.0,0.0,0.0,0.0,0.7339532870000001,0.471447875,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.366719774,0.973018396,0.0,0.0,0.14347059,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.111234266,0.0,0.0,0.129817133,0.283298067,0.0,0.0363384869,0.250629547,0.413577931,0.19050782100000002,0.0,0.117723489,0.026497845,0.0,0.0,0.0,0.0,0.0602377471,0.022968140699999997,0.131766025,0.272320451,0.0,0.23647421899999999,0.0901326675,0.0,0.0,0.0,0.201188722,0.0500602271,0.0,0.278818565,0.428683995,0.6173194089999999,0.9237415809999999,0.740098962,0.730349576,1.0488846,0.9400509659999999,0.68595026,0.627067467,0.584703935,0.723700291,0.9389480720000001,1.0891383,0.823528092,0.981895285,0.8882163270000001,0.947095922,0.829855742,0.678726697,0.495215911,1.03531251,0.7594921590000001,1.31698089,1.22175557,1.00832757,1.3939046,0.934556475,1.17174694,0.797671628,0.28755501699999997,0.207281865,0.222341887,0.288344664,0.250262906,0.0417167827,0.18493124,0.6469887670000001,0.473375229,0.6922471729999999,0.732572296,0.434351514,0.41276250200000003,0.056338161100000006,0.41839380299999995,0.0,0.0,0.0605756576,0.0,0.23884305399999997,0.27374522100000004,0.135973898,0.0,0.13180507800000002,0.11293674,0.00261566565,0.593224536,0.5878371579999999,0.668787035,1.02921618,1.09132105,0.818676338,1.17514471,0.8444168240000001,0.595720853,1.06832803,0.7997378629999999,0.627182768,0.7155265590000001,0.779142048,0.343797584,0.322897001,0.533787844,0.602726154,0.32249122399999997,0.385706289,0.19067722199999998,0.356058155,0.0,0.33200645,0.020177603500000002,0.408372539,0.374216118,0.0988113361,0.43091279,0.32689709699999997,0.17838868800000002,0.0,0.19592198,0.24293875,0.00768165811,0.32716185,0.0344127575,0.163613825,0.0476398455,0.0,0.0,0.0,0.398137251,0.061977396500000004,0.46169220000000005,0.0476451565,0.0,0.24810469,0.0,0.0,0.0479090617,0.0,0.0,0.360524509,0.08428032949999999,0.0722161242,0.379501861,0.23743462899999998,0.381148141,0.464235422,0.551169393,0.168015065,0.0859856819,0.396493961,0.0,0.24692043100000002,0.221192597,0.340598534,0.448336908,1.27359946,1.30995627,2.16158347,2.1894827,2.157166,1.99485703,1.38480383,0.620308289,0.484595259,0.0587323793,0.20580561100000003,0.17877842100000002,0.252645078,0.133308799,0.30990978399999997,0.23859119399999998,0.0555643449,0.0,0.30921590600000004,0.36538048100000003,0.352472168,0.209430335,0.581395611,0.430187494,0.37463850299999996,0.22251448899999998,0.125902608,0.149380789,0.0,0.20234532,0.347949354,0.06477023900000001,0.315867685,0.81138958,0.700256158,0.902250524,1.72357804,1.87296918,2.47815311,3.01573631,3.18328928,3.01091242,2.21831627,1.70647474,1.2617167999999999,0.632459275,0.35814807600000004,0.0466157134,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.45623888,0.56927541,0.0,0.0,0.0,0.33895673,0.3756393,0.0,0.0,0.0,0.52939097,0.58683405,0.0,0.0,0.71269973,3.00997652,4.88660705,4.75154364,2.63246338,0.18450408,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.548594486,0.7549166559999999,0.213853923,0.0206672504,0.195806008,0.0,0.0,0.0,0.767916133,1.4885586000000002,2.4428477,0.0,0.0,0.0,0.617242387,1.48667756,0.0,0.0,0.0,0.339210674,0.0,0.0,1.16354902,0.0,1.19892276,0.0,0.0,3.9449235000000002,2.4850426,3.82368262,5.69229202,3.73326479,2.74619959,0.0,0.0,0.272502714,1.84376609,1.92897249,3.23921855,4.77560586,3.51258938,1.58201492,0.6726273140000001,0.0,0.863591413,0.0,0.062132905700000005,1.30183849,0.0,0.0,0.0,0.0,0.23283572600000002,1.69888544,0.6589505210000001,0.17413674399999998,0.743513065,0.0,0.0837634813,0.0,0.8189654340000001,0.0,0.0,0.0,1.02809095,0.012670557399999999,0.9323935309999999,0.0,0.45714772600000003,0.0,0.0,0.344697979,0.374516615,0.06606188519999999,0.0,0.690592581,0.970763624,0.0,0.0,0.460344837,0.886739353,0.0,0.0,0.7695931579999999,0.0,0.20723850100000002,0.0,1.05851657,0.0,0.0,0.0,1.02810577,2.56861072e-05,0.9659042720000001,0.9066566359999999,1.37726562,0.417960966,0.8749375490000001,0.38589299,1.56168535,1.11437508,0.804173878,0.0,0.103111751,0.138705252,0.592037921,0.08417816880000001,1.37965222,0.311029589,0.0,0.0,0.25087764,0.7344007359999999,0.0,0.0,1.89641884,0.605265991,1.25431802,1.19649919,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.83571463,0.0,1.96462958,0.0,0.0,0.0,0.0,0.35170599,1.18170403,1.05263591,1.29221338,0.83615448,0.0,0.0,1.2425058,4.25381546,2.21244215,0.0,0.0,0.87746507,0.78932084,1.13691823,0.0,0.0,0.22686833,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.52581608,1.91992694,0.04429023,0.66777225,0.23962472,0.0,1.47596036,1.1962815,0.18690998,0.72669453,0.0,0.88800424,0.0,1.95633047,0.0,1.64530594,0.0,0.0,2.21402715,0.37146804,2.0590004,1.96888176,0.0,0.0,0.0,0.43352151,0.0,4.56369555,5.69447433,5.18596326,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.97208544,0.74475787,1.09945647,0.51793525,0.42293687,0.66276741,0.50828649,0.60676091,0.62508401,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.28170779,0.28442405,0.49000829999999995,0.40055218,0.45958712,0.18007807,0.42414567,0.0,0.0,0.25002733,0.0,0.0,0.0,0.19462726,0.08703024,0.0,0.41415064,0.47373471,0.12463646,0.03676043,0.34891569,0.0,0.0,0.28637598,0.22105275,0.0,0.0,0.0,0.22692941,0.0,0.0,0.0,0.0,0.23440676,0.03746462,0.0,0.15941325,0.64030041,0.47196348,0.41930685,0.61374359,0.0,0.0,0.0,0.0,0.22173152,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.18448349,0.93738543,1.03527888,2.1118695,2.27497332,3.17801138,3.38756574,4.1612216,3.91318252,4.34555446,4.97560186,4.673808,4.22880482,4.16442556,4.28382416,3.37514646,2.96888014,2.57582935,1.59118873,1.86846419,0.68425153,0.49606959,0.63104377,0.3335219,0.52891536,0.10721563,0.30779423,0.55771726,0.53093957,0.42425523,0.37893391,0.72249409,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
4.31220444,4.69801406,2.13826819,1.509859,2.48439622,2.19156397,1.01803729,1.52578915,1.04126769,0.67463421,0.0,9.25863756,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
5.37106621,0.0,0.0257649173,4.05989556,0.0,7.1855776,10.2392734,1.4218305,5.47483697,0.0,3.80972367,0.0,4.14672966,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.33948037,0.743048475,2.2892296,0.668144683,0.374392613,1.48700548,0.0,0.0,0.0,0.0,0.073583578,0.0,0.0,1.18455268,0.544186904,0.5341929910000001,0.0,0.157494306,0.0,0.0,0.5610755820000001,0.0,0.555830542,0.0,0.0,0.0,0.0,0.7661352859999999,0.0,0.988481852,0.29395746300000003,0.141143363,0.0570168979,0.106425608,0.0,0.764724352,0.0,0.0954052369,0.0586241674,0.020300870500000002,0.129680997,0.0,0.0,0.0,0.0,0.513589596,1.10103823,0.322997753,0.686391585,0.040128834700000005,0.0,0.0875176089,0.0,0.0,0.0662701881,0.0,0.0,0.8030912659999999,0.494888635,0.29054525600000003,0.27974529600000003,0.658424447,1.18223568,0.98607503,0.0,0.15715147599999998,0.18828355100000002,0.0,0.0,0.0,0.0,0.106117907,0.0,0.0,0.0,0.0,0.404305409,0.0,0.0,0.343943391,0.983509875,0.7812073620000001,1.28872359,0.289792409,0.0,0.26379806699999997,0.0,0.09257455,0.0,0.0,0.0,0.0,0.69560476,0.274062873,0.538260497,0.82350928,0.0,0.0,0.541366632,0.0,0.0,0.0,0.0,0.520904838,1.12912004,0.0,0.491944746,0.0,0.604119238,0.0,0.557643284,0.0,0.0,0.36711351200000003,0.0,0.603078357,1.67727772,0.7349447809999999,1.55689151,3.17697536,3.33400672,2.47549672,3.75448135,3.8941742999999995,4.37968476,1.9300075,2.65623193,2.26769882,2.37527918,2.36301293,1.59126079,1.79534476,0.0,0.0,0.223741871,0.0,0.0,0.0,0.0,0.0,0.963302145,1.22256772,0.0,1.04816293,0.0411493125,0.0,1.36262091,0.0,0.0129142151,0.0,1.06486611,0.909288199,1.86429312,0.433385788,2.88981648,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.1804898000000001,0.839149019,0.36009132,0.0,0.0,0.0,0.17224682600000002,0.31509667199999997,0.24858757399999998,0.0104604988,0.0,0.0,0.0,0.347725911,0.6803936079999999,0.788667863,0.664289597,0.462358085,0.37841347700000005,0.494470815,0.7138022759999999,0.8379140620000001,0.727258579,0.417787654,0.0970529655,0.0,0.0317205149,0.18311379600000002,0.208854693,0.0299423556,0.0,0.0,0.0,0.199708826,0.446115737,0.33666954600000004,0.0,0.0,0.0,0.0,0.7076290759999999,1.02541524,0.527802085,0.0,0.0,0.0,0.381183321,3.42289622,6.44053506,8.00628771,7.33430508,4.74883362,1.49932694,0.0,0.0,0.0,0.140616824,0.9870580179999999,0.929540743,0.19729685600000002,0.0,0.0,0.0,0.260700872,0.618515619,0.46052064,0.0,0.0,0.0,0.0,0.330966682,0.521191775,0.288780435,0.0,0.0,0.0,0.0261040427,0.7540321259999999,1.32225828,1.47329201,1.20219368,0.735249568,0.376833104,0.32896223,0.588693617,0.970091501,1.22387769,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.29388058,0.454108396,0.0,0.39497747200000005,0.0,0.347087335,0.510193212,0.326368422,0.0,0.0,0.35534704899999997,0.0,0.0,0.270753557,0.196969885,0.272141688,0.0,0.0,0.20202318800000002,0.0,0.0,0.210938787,0.08579118779999999,0.0,0.170421441,0.399862265,0.32497358,0.318469467,0.077051744,0.468810906,0.059824042,0.139107483,0.42850926799999994,0.0,0.048135411100000004,0.15069258,0.415182034,0.346090964,0.0,0.0,0.39767918700000005,0.0,0.285990961,0.0533586312,0.0,0.0,0.174692682,0.0,0.0,0.30870213399999996,0.20744833399999998,0.22317987600000003,0.0,0.0,0.305090591,0.26137849999999996,0.010475081899999999,0.332050494,0.0,0.0,0.0232517511,0.0,0.21868376899999997,0.0,0.0,0.0,0.40398383,0.29456491,0.0379490209,0.47783006200000006,0.0,0.0,0.010656328400000002,0.30172446,0.568358976,0.0,0.43599955799999995,0.0,0.0,0.0,0.0,0.0,0.0135722941,0.48453222700000004,0.0815881047,0.0,0.0,0.0,0.0633506514,0.43199167,0.550977361,0.634212545,0.233601013,0.35339077700000004,0.618308336,0.809825369,0.209412732,0.234550361,0.233200272,0.33077202899999997,0.0,0.13883120599999998,0.0,0.0,0.0,0.0,0.0,0.3239675,0.0497176713,0.25566830100000004,0.693271825,0.823444958,0.792199986,0.397286174,0.0,0.0,0.0,0.0,0.0,0.0031466525399999994,0.133921263,0.9038516759999999,1.41647781,1.96757437,2.85565605,2.94508308,3.27752818,3.51609531,3.19466024,3.2589697,2.98887357,2.70231645,2.42204888,2.05396221,2.35435482,2.02481509,2.67567263,3.29991761,3.99199032,3.92976557,4.29651762,4.32831301,4.06413192,3.63766876,2.88503429,1.63320155,1.0635626,0.08548960679999999,0.0940223631,0.0,0.0,0.0,0.0,0.152065191,0.0818676318,0.532914091,0.137917441,0.47288668700000003,0.646051674,0.627189284,0.0,0.0,0.00190977755,0.0,0.0,0.0,0.0,0.0,0.0,0.0106434142,0.0,0.0,0.0,0.371125386,0.38517001,0.194030352,0.0,0.0,0.0,0.13516171400000002,0.0,0.313789357,0.391248595,0.00717759152,0.025635193100000002,0.0,0.042227594800000004,0.173696093,0.0,0.0,0.154323505,0.0033577426299999996,0.0,0.296903779,0.13260881,0.0,0.251097885,0.262807787,0.0,0.14367154099999999,0.162419177,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.17354347,0.48498715200000003,1.09020818,0.264187288,0.0,0.0527556195,0.0,0.019414743600000003,0.0,0.0,0.0162087905,0.044085045,0.0027037435200000003,0.0,0.0,0.41009235299999997,0.118167391,0.0869127281,0.546627784,0.162232983,0.0,0.0100636697,0.0,0.0132420267,0.0,0.04432585519999999,1.28422168,2.01421873,0.995494575,0.154056614,0.0,0.0162092255,0.0,0.028365738999999997,0.0,0.043847047400000005,0.0,0.137245163,0.336647752,8.027998159999999e-17,0.449465431,0.0335353966,0.11662593800000001,0.0,5.46632853,11.0019359,2.94829909,1.82758236,2.76973717,0.0,0.175780186,0.0253566323,1.26686733,0.331353544,0.0,0.14030605,0.0,0.13110787699999998,0.0,0.101215841,0.0,0.0639544811,0.0,0.0275064813,0.0,0.0694173879,0.118537425,0.0,0.0125617189,0.0,0.0131390336,0.0,0.000775617167,0.0093458175,0.0,0.260965928,0.794359258,0.324377163,2.8900793400000004e-16,0.005639867629999999,0.0,0.014211441699999999,0.0,0.014002175700000001,0.0,0.018584596999999998,0.0936915587,0.11838803,0.0,0.0118536215,0.0,3.53231919e-16,0.051865402000000005,0.011039309399999999,0.0,0.0216281233,0.0,0.0687497263,0.0,0.725006301,3.29201388,3.14593452,0.6814138059999999,0.0678809098,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.505976167,0.0,0.0,0.8398929759999999,1.19373335,2.13005527,3.64455525,3.24926449,1.51532152,0.0,0.0,0.0,0.0845137458,0.521521248,0.8218001859999999,1.47105939,0.0,0.8111659720000001,0.013430981699999999,0.0,0.555801195,0.0,0.179665358,0.025210009199999998,0.70406375,0.72593053,1.13577851,0.0,0.0,0.0,0.0,0.0,0.0,0.012184473500000001,0.0,0.0,0.267449333,0.556525144,0.0,0.770942386,1.14051701,0.339152055,0.563913448,1.37686341,1.02876063,1.49581276,1.75957813,1.34717418,0.0,0.0,0.6580841829999999,0.0,0.9744721359999999,0.0,0.0,0.255809861,0.0,0.0,0.0,0.0,0.427560331,0.20083151100000002,0.0,0.0,0.590607325,0.013541871200000001,0.0,0.821021132,0.0,0.712475856,0.31756498,0.0,0.103629493,0.329091822,0.0,0.0,0.0,0.7182274829999999,1.50164653,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.100374565,0.0663045345,0.110730075,0.27836479999999997,0.567368435,0.9210551140000001,1.24766488,1.45816955,1.50254363,1.38658488,1.16276556,0.9026800140000001,0.6672066839999999,0.48910829,0.37330140100000003,0.309031994,0.282644556,0.282397735,0.29502802899999997,0.301123696,0.277397674,0.20789938,0.0975976702,0.0,0.0,0.0,0.0,0.0406487028,0.11738973800000001,0.121301431,0.044761157,0.0,0.0,0.0,0.0,0.11170578800000001,0.19420480699999998,0.154354438,3.16979637e-16,0.0,0.0,0.0,0.0546374107,0.312089161,0.410576069,0.232276806,0.0,0.0,0.0,0.0,0.718821823,2.25703493,3.84106204,4.98069829,5.31360745,4.75778348,3.54332877,2.10786587,0.90554029,0.22053881399999997,0.0716349554,0.247186625,0.444817016,0.440076529,0.198401192,0.0,0.0,0.0,0.573835549,1.43265108,2.24481246,2.73570087,2.76066325,2.35987991,1.7262577000000001,1.10885291,0.7026219579999999,0.576140593,0.6649981229999999,0.8245260190000001,0.9091661059999999,0.838698189,0.624127662,0.34898891299999996,0.122409547,0.029309440099999997,0.0988637955,0.299915917,0.559152224,0.7904065029999999,0.922915528,0.92036596,0.78756253,0.565175089,0.31508687,0.100374565,0.0,0.0,0.0,0.0120082569,0.0574087409,0.0627486248,0.0292749657,0.0,0.0,0.0,0.0,0.0247601725,0.0493824383,0.0418735203,0.00810184552,0.0,0.0,0.0,1.5848981799999998e-16,0.034123892999999995,0.045748721900000004,0.027892022000000002,0.0,0.0,0.0,0.0,0.0132888075,0.0354862758,0.0323327728,0.0095531149,0.0,0.00661603052,0.0713673876,0.17711201,0.29342106,0.382837828,0.419640102,0.401498261,0.347599638,0.285149262,0.233110285,0.193309137,0.15393104400000002,0.10232887199999999,0.0381778494,0.0,0.0,0.0,0.0532934443,0.18237662699999999,0.337633965,0.501707438,0.668687515,0.841061258,1.01790945,1.1833067,1.30486935,1.34634892,1.2885953,1.14628279,0.968434652,0.819368122,0.748457444,0.7648942240000001,0.832210529,0.8869005659999999,0.871797825,0.76601174,0.594728203,0.41351962700000006,0.276529183,0.207304982,0.189450775,0.182412115,0.15256840300000002,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.11352850099999999,0.411528381,0.8148125359999999,0.922750912,0.6408923639999999,0.232584302,0.010725956799999999,0.0329614233,0.116309284,0.10324818,0.0429054879,0.08863464230000001,0.26803183,0.426482109,0.418898239,0.308961904,0.31504626399999996,0.5464161,0.8405225609999999,0.914930765,0.6835905240000001,0.37720528799999997,0.309332216,0.530040104,0.7533359000000001,0.655226611,0.228146693,0.0,0.0,0.0,0.213888511,0.190496897,0.0,0.0,0.0,0.194994655,0.426560001,0.38971864799999995,0.178843418,0.0185550638,0.0101506095,0.058335696900000004,0.0318025049,0.0,0.0,0.0,0.13584164199999998,0.174922701,0.0872291053,0.0,0.0,0.0495610594,0.0707848797,0.0,0.0,0.0,0.0480577207,0.111873899,0.0349158969,0.0,0.0,0.0179109258,0.156234323,0.10826425699999999,0.0,0.0,0.0,0.42732946200000005,0.85147442,0.9301276359999999,0.629333865,0.182623697,0.0,0.0,0.0301601452,0.446054798,1.01163602,1.59114511,1.94845518,1.88128473,1.40819879,0.795857134,0.361808998,0.23163254600000002,0.283393795,0.31276857199999997,0.22922747,0.0932981079,0.00244197463,0.0,0.0,0.0117289976,0.0102311734,0.0,0.0,0.0,0.11977362,0.440674378,0.805211882,0.96840701,0.784703645,0.376132243,0.043256036799999995,0.0,0.0868645091,0.12069303099999999,0.0,0.0,0.0,0.0931222307,0.18402270699999998,0.0399052861,0.0,0.344692302,1.37608782,2.5097715,2.93748566,2.28624544,1.01186818,0.0622965235,0.121404667,1.12528528,2.4202748,3.30131582,3.40878866,2.76249851,1.62369324,0.41169759,0.0,0.0,0.183574395,0.764185462,0.723484453,0.07748521059999999,0.0,0.0,1.30264957,2.65114713,2.94128703,1.92858661,0.412393045,0.0,0.0,0.126502074,0.487172163,0.410241739,0.28256285800000003,0.506637055,0.962963728,1.13037275,0.695261543,0.0,0.0,0.0,0.312814542,0.756108126,0.718204512,0.371569249,0.12745278300000001,0.203628492,0.451870406,0.5616095560000001,0.386937321,0.085094986,0.0,0.29883136,0.9858347759999999,1.71307124,2.08195294,1.89852282,1.32801955,0.7768603820000001,0.5572429520000001,0.620773085,0.640391672,0.39640886,0.0737890263,0.11208200800000001,0.7087628890000001,1.49947316,1.82084818,1.35630648,0.504253596,0.0366171791,0.348023696,1.05810299,1.39216572,0.9576735000000001,0.11708342199999999,0.0,0.0,0.163844686,0.36794768,0.11657005599999999,0.0,0.0,0.029468103500000002,0.40656843299999995,0.470452475,0.233977658,0.0,0.0,0.0892280747,0.109648484,0.0,0.0,0.0,0.0784337921,0.14558841,0.0300617265,0.0,0.0,0.0331423926,0.154794553,0.0838035806,0.0,0.0,0.0,0.15272580300000002,0.143100215,0.0,0.0,0.0,0.14547795300000002,0.232431876,0.0182095467,0.0,0.0,0.159075766,0.7005262240000001,0.905714564,0.641688997,0.229532918,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.5546424560000001,0.484537668,0.0,0.0,0.0,0.279854715,0.498156194,0.12533974,0.0,0.0,0.11111273099999999,0.7456880790000001,0.798812423,0.265023772,0.0,0.0,0.270625807,0.470948524,0.09685155179999999,0.0,0.0,0.0687659512,0.6149201670000001,0.459823569,0.0,0.0,0.0,0.704417544,1.46955557,1.30714239,0.639081115,0.40849613100000004,0.947423331,1.5470215,1.30314555,0.327356948,0.0,1.13117819,3.72619099,5.86618177,5.86723739,3.746626,1.19121548,0.0,0.295050104,1.09061729,1.19829853,0.644674417,0.318799837,0.722835303,1.32378542,1.2598402,0.489273795,0.0,0.212702791,0.867728085,0.619179632,0.0,0.0,0.0,4.77519787,10.4229506,12.901988000000001,10.2095014,4.10585378,0.0,0.0,0.0,1.39869502,1.85736662,0.341671376,0.0,0.0,0.116904009,1.09195909,0.73628565,0.0,0.0,0.0,0.552243215,0.791874167,0.118047199,0.0,0.0,0.105169735,0.652617495,0.42043229299999996,0.0,0.0,0.0,0.396443792,0.532219523,0.051115368,0.0,0.0,0.0971958908,0.422670361,0.219514221,0.0,0.10470212,1.00137468,1.84329614,1.76610131,0.7293858559999999,0.0,0.0,0.652157684,1.89316275,2.27350847,1.58765558,0.57843349,0.13941342,0.482936753,1.0722286,1.26213278,0.909948493,0.37672527200000006,0.054248192599999995,0.0,0.014365318200000001,0.0,0.0,0.0,0.09238931550000001,0.112336282,0.0,0.0,0.0,0.057576225599999996,0.160606296,0.0743162867,0.0,0.0,0.0,0.140957697,0.14440534,0.0,0.0,0.0,0.0685985818,0.160177711,0.0626577478,0.0,0.0,0.0,0.106279535,0.08972628269999999,0.0,0.0,0.0,0.0,0.0,0.0,0.32114959,1.09083778,1.75843213,1.7243355,0.873931942,0.0,0.0,0.0,0.30991564899999996,0.559901237,0.159927036,0.0,0.0,0.0625678222,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.243
0.05805529,0.0,0.0,0.38918469,0.0,0.94137731,0.0,0.0,0.48466876,0.0,0.41366064,0.0,0.0,0.27314797,0.0,0.40958166,0.0,0.61911596,1.7524288000000001,0.85405988,1.76732753,1.95338325,2.616809,2.43128008,3.36570234,2.35331826,2.20922055,3.45189147,2.61906964,2.7537062999999997,2.86690742,2.86075887,3.31407351,2.88750168,3.44776404,3.62616941,2.18517159,2.99106463,3.27729108,3.28230163,2.1413493,3.40669451,3.57028609,2.07314455,1.8469113999999998,3.25310479,1.60471274,1.56562122,1.7920393000000001,0.64860299,1.034541,1.2283461000000002,1.79740715,1.08937777,0.50810923,0.0,0.0,1.05095592,0.0,0.0,0.0,0.10853734,1.03584663,0.01490465,0.0,0.253108,0.0,0.13007462,0.0,0.0,0.0,0.0,1.15410839,0.55569883,0.14129636,0.0,0.17533793,0.0,0.43774648,0.14776978,0.80086647,0.21486146,0.73100902,0.47421545,0.0,0.62587297,0.26042088,0.0,0.0,0.0,0.0,0.0,0.05513995,1.02422224,0.80029722,0.0,0.0,0.0,0.0,0.80566314,0.46255086,0.23804837,0.0,0.0,0.0,1.26982823,0.0,0.91791044,0.0,0.0,0.48830858,0.0,0.0,0.0,0.54157059,0.49094553,0.03923413,0.0,0.0,0.0,0.0504823,0.3501828,0.0,0.31170433,0.16501446,0.0,0.33999214,0.0,1.29538566,0.0,0.73572472,0.26494508,0.08094523,0.0,0.0,0.0,0.75635919,0.77463538,0.0,0.0,1.24428565,0.0,0.0,0.0,0.15971811,0.0,0.0,0.38916757,0.0,0.01288037,0.44597233,0.42389219,0.30698831,0.0,1.00649028,0.0,0.0,1.11884627,0.25180372,0.71784974,0.5541429,0.0,0.87169931,1.27311024,1.17545232,0.0,0.25815816,0.72235197,0.86986498,0.50375925,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.9164145109999999,0.0,0.0,0.466150204,0.00142047709,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.00479999863,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.20701136,0.317540153,0.8437252540000001,0.0,0.0,0.0,0.334007643,0.468690392,0.15104092800000002,0.0,0.36240890600000003,0.535500214,0.6918384120000001,0.0,0.327926183,0.249850983,0.0155078145,0.0,0.0,1.01154636,0.0,0.0,0.340131775,0.0,1.11389,0.183846418,1.36339343,0.6632197679999999,1.27292919,0.41612793,2.09697373,1.31363213,0.6005732810000001,2.19057074,2.24827133,2.03036559,2.51198351,2.3108352,2.90178517,2.44911189,3.74135655,4.11792025,2.86420267,3.80423665,3.50960565,4.76347769,2.7021552000000004,3.63803511,3.19038835,1.94264252,1.73329309,2.3582634,3.27967229,1.83160744,2.1301838,0.72068863,1.30082556,0.77810061,1.47394624,1.69993272,0.555356614,1.29396936,1.86389133,0.0,0.0,1.72494619,0.51612654,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.623549055,0.0,0.0,0.8412572770000001,0.693322358,0.25428738300000003,0.478410898,1.76331851,0.56707713,1.25592826,0.748426494,0.24985854,0.0,0.12655173,1.08739973,0.40043161299999996,0.847254417,1.03565102,0.633060078,1.50968302,0.0,0.456774746,0.24434639800000002,0.852752823,1.29759198,0.7671568,0.0,0.720600943,0.0,0.741559137,0.0,0.43451348799999995,1.11809411,0.0,0.979494436,0.184114472,0.0,0.0,0.0,0.117286005,0.52464162,0.0,0.464321505,0.830097619,0.0,0.0,0.0,1.05568285,0.21070195600000002,0.026847753399999997,1.10798461,0.0,0.40370738700000003,1.31207524,0.056684615,0.0,0.0854721535,0.391295267,0.867051098,0.654396462,0.0,1.11370147,0.0,0.0015022551199999998,1.39394108,0.22941136899999998,0.0,0.8073639,1.33592498,0.0,0.240682425,0.10793342199999999,0.0,0.7916842340000001,0.0,0.338986213,0.0879316138,0.16884696,0.0,0.0,0.0,0.0,0.0,0.0,0.575188524,0.794825716,0.0,0.309106365,0.0,1.1682383,0.275891166,0.0,0.000752217954,0.258455865,0.0555156202,0.447629991,0.585497695,0.5454489579999999,0.712007078,0.0,0.0,0.0,1.30276849,0.647444287,0.279051493,0.0,0.0,0.0,0.27737680800000003,0.18735378100000002,0.0945141201,0.0350708285,0.0,0.994881259,0.310075229,0.0,0.0,1.26688467,0.0998137851,0.972450915,0.012325023300000001,0.6569056529999999,0.0,0.0,0.0,0.253312583,0.0,0.0180934684,0.0,0.704158666,1.03815475,0.0,0.34478575100000003,0.716892842,0.0,0.0,0.0,0.337266853,0.0,0.0,1.02919737,0.352082868,0.8826908609999999,0.0,0.485581096,1.85806499,1.61697069,2.21460813,3.93356917,3.29482444,2.45096982,2.69694125,3.10294771,2.01235028,0.0805881465,0.974616658,0.0,0.84538364,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.20727266,0.50793549,0.79529621,1.06567364,0.90394633,1.44980232,1.02975351,1.24291284,1.00191768,0.99778943,1.62337964,1.42594538,1.05711744,1.48671672,1.21883328,1.24946097,1.16221183,1.71534448,1.72401005,1.56606255,1.77596795,1.33966035,2.27089663,2.37778989,2.70088192,1.51745179,2.20968006,2.11082385,2.36148855,2.58273562,1.51055792,3.03408237,2.3761612000000003,2.63309443,1.69519682,2.15988184,1.44897874,2.49094949,2.26288361,2.66744674,2.33311237,2.32676162,0.59841781,2.23068011,1.46180002,1.63099284,0.66480458,2.0975762000000002,1.83770514,1.32341415,1.66572069,1.30449422,1.36560924,0.29507306,0.39991769,0.9332121999999999,0.71450642,0.77290215,1.10422138,0.97331589,1.02571656,0.0,0.13384479999999999,1.01199458,0.0,0.0,0.53451805,0.5781036999999999,0.33716246,0.18048229999999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.15689943,0.0,0.0,0.0,0.06391835,0.0,0.00917605,0.0,0.0,0.20725718,0.8667019,0.39941243,0.3261708,0.28615706,0.53755277,0.47487328,0.65109234,0.31446934,0.44034362,0.01525296,0.50338694,0.73042141,0.0,0.36833469,1.01544453,0.64851005,0.0,0.86630492,0.47159775,0.21754658,0.70860586,0.58514537,0.27633551,0.41636386,0.54469152,0.84521824,0.19291428,0.99115187,0.14190654,1.03466671,0.36705994,0.2666917,0.23589334,0.0,0.0,0.03599551,0.91772994,0.24145569,0.1289058,0.0,1.05388482,0.41749763,0.68085875,0.56133145,0.0,0.0,0.58485663,0.45510078,0.66163992,0.20620105,0.0,0.01515529,0.0,0.14141799,0.0,0.0,0.0,0.29485053,0.0,0.0,0.31023181,0.0,0.0,0.0,0.41765145,0.0,0.0,0.0,0.0,0.150644,0.0,0.0,0.0,0.0,0.44092061,0.0,0.12596103,0.0,0.09288168,0.0,0.25830231,0.0,0.85950069,0.0,0.20504889,0.37588498,0.69501606,0.0,0.0,0.0,0.0,0.25756129,0.73308215,0.0,0.18244957,0.03431619,0.38313302,0.56024715,1.23177479,0.65736305,0.0,0.0,0.0,0.0,0.35600764,0.34002373,0.0,0.76179425,0.43618959999999996,0.24772034,0.0,0.32499671,0.0,0.30715286,0.3419991,0.0,0.48325516,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.30311089,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.11561165,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.189190131,0.287609718,0.0,0.0,0.0837421838,0.279963402,0.489999675,0.124973,0.20195068300000002,0.0,0.0,0.322546952,0.0,0.17668582,0.0,0.114419949,0.041004351,0.0530441076,0.20397300399999999,0.223875363,0.0,0.0,0.0,0.207442656,0.301512929,0.20196373,0.46575711399999997,0.0,0.38890805,0.06485942559999999,0.08885766810000001,0.0,0.0,0.0,0.306452052,0.18728723600000002,0.0,0.0,0.0253128019,1.36864366,2.57766181,3.32291876,2.90987066,1.76312451,0.389500216,0.0,0.20458547300000002,0.272477287,0.209042212,0.0,0.0,0.285102868,0.233247598,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.394397985,0.0,0.0,0.186872598,0.0,0.0692973079,0.0,0.0,0.15982961699999998,0.35970985,0.09576356720000001,0.18604072300000002,0.0,0.0,0.0409904056,0.0,0.0,0.078754718,0.0222578298,0.170227937,0.0,0.0,0.21690259399999998,0.0,0.0,0.154363795,0.0,0.281997192,0.316547092,0.0,0.0,0.18317815,0.284881008,0.0,0.0,0.0,0.0,0.0,0.0561747104,0.214903449,0.0,0.0,0.0,1.5088335,2.0770129,1.58984225,0.357424707,0.0651015786,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.19636449399999997,0.35458075,0.0638975749,0.21247814899999998,0.0214407294,0.0260358935,0.0,0.11977506199999999,0.8013235879999999,0.749140094,0.141973489,0.0,0.029478657999999998,0.0,0.0167315353,0.22686233600000003,0.681649373,0.0618527475,0.0,0.0,0.18976922300000001,0.421783015,0.662965041,0.390106261,0.275851323,1.58369885,0.674929902,0.92278481,0.222876186,0.0,0.0390681823,0.0,0.0721526703,0.0,0.6721481420000001,2.55278419,0.0,0.644648584,0.0,2.13258121,1.10944576,0.0,0.161971311,0.255333262,0.47843966600000004,0.127439436,0.607968388,2.29230816,0.0,0.334136819,0.0,2.54054088,0.8123842290000001,0.0,0.0562549903,0.0005889612890000001,0.0,0.0693901968,0.0,0.219523649,0.0,0.7823179459999999,4.16396783,6.92031776,4.0407001000000005,1.42710811,0.665358432,0.162669919,0.15473749,4.50857592,7.80100694,6.0501648,1.89121958,0.0,0.0657166378,0.131188385,0.0715200237,0.0,0.0701457831,0.0,0.716167062,3.24852018,0.0,0.27177847,0.0,2.92762979,0.834638896,0.23039622199999998,0.328096154,0.814838198,0.223397285,0.462698615,0.0,2.07441489,7.63798348,0.22020842100000002,0.0,0.776857164,1.99970932,0.535735803,0.195425113,0.0,0.20983554199999999,0.0,5.63230388,0.976003782,0.23033807899999997,1.53952492,2.85617136,0.269322865,0.0,0.0382057364,0.0,0.0181973499,0.0,0.0131049251,0.0,0.0145377282,0.0,0.324441107,0.163532848,0.444151632,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.935051031,0.0,2.89678732,0.0857789798,0.204987582,0.08586096160000001,0.0,0.0,0.0,0.981231891,0.0,1.77681096,1.17632995,0.0,0.34919943600000003,1.24091743,0.0,0.49446328700000003,0.608583135,0.8955629970000001,0.0,1.28635738,0.12761138,0.0,2.46734966,0.0897120412,0.0,1.11694621,0.0,1.45922905,0.0,0.0,0.0,0.0,0.0,0.0,0.19081908600000003,0.544256802,0.38490767200000003,0.130224115,0.628900638,0.287347719,0.233404406,0.0,0.0,0.0,0.726643273,0.0,0.0,0.715141902,0.0,0.0,2.84528564,0.0,1.07076085,0.0,0.0,0.0173785592,0.0,1.14265112,0.626187409,0.0,0.0,0.0,0.0,0.0,0.0,0.336837855,0.0,0.0,0.0,0.7157463759999999,0.0,1.85211911,0.29474634,0.7255187120000001,0.0,0.0,0.0,0.0,0.0,0.9986435509999999,0.0,1.34703958,0.39734573700000003,0.0,0.200857132,0.655231982,0.0,0.295278997,0.0,1.95348628,0.945368222,2.06399114,0.6298419,0.0,0.400802759,0.0,0.0,0.842595056,0.0,0.0464559134,0.0382742617,0.0,1.69162351,0.0109165141,1.18758633,0.540424455,0.0,0.82892617,0.8921837159999999,0.0,0.0,0.0,0.0385682823,0.9342299740000001,0.0,0.747152812,1.01794681,1.20378382,0.661938262,0.11637981,0.263792318,0.320109658,0.7411312659999999,0.0,0.929586122,0.321024756,0.186778585,1.274926,0.22311311399999997,1.09738006,0.201706976,0.710575837,0.014388766899999999,0.0,0.0,0.0,0.882020349,0.0,2.67017569,3.31165504,2.63578837,5.31153349,3.41234744,5.15058661,3.51214075,2.77594747,2.41682608,0.8886543170000001,0.805449341,0.0,0.0,2.89322367,1.83437715,1.9161607,1.82267864,1.65164574,1.4029186000000002,1.15390977,1.82045044,1.10602659,0.0,2.15441706,1.73129933,0.7258321609999999,0.0,0.5382015729999999,0.0,3.12658295,0.420500524,0.051421021500000004,0.0,1.07095755,1.47152277,0.409866426,0.44370970299999996,0.0,0.0,0.0262277161,0.565046307,0.817232042,0.8162565979999999,0.951336637,1.1192648,0.0,0.38112956600000003,1.59688393,0.0816729031,0.0,0.576934069,0.491447805,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
9.31854013,4.67770533,0.0,0.59025161,1.1496933999999999,1.83081096,2.3220294999999997,0.0,0.0,0.75181613,0.0,0.0,0.64876066,0.0,0.32740158,0.61537653,0.0,3.46808107,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0693088865,0.0,0.213001297,0.0,0.0637800885,0.13763469,0.0,0.0,0.456964739,0.398556998,0.27474549,0.311542914,0.0,0.0,0.026327942400000002,0.0,0.0,0.025765702,0.0,0.256113508,0.19646082399999998,0.08431403859999999,0.0,0.0,0.0910647459,0.0,0.0690829368,0.0501744207,0.336513479,0.0,0.315787368,0.0,0.0,0.0329146013,0.031921869900000004,0.006406123929999999,0.0,0.0,0.0,0.0,0.220873862,0.455632969,0.360752161,0.319316324,0.279915178,0.12643374,0.305890355,0.427487176,0.6141625039999999,0.717509152,0.0940966257,0.25448754100000004,0.703123058,0.121056645,0.5876025739999999,0.340359626,0.36023365799999996,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.26834732699999997,0.15418142099999999,0.0029304616,0.0,0.272229547,0.0,0.253029564,0.0,0.0,0.0,0.0,0.0,0.0,0.0354940125,0.0,0.0,0.0,0.0,0.073264501,0.0,0.0961618159,0.404643168,0.391184298,0.376065334,0.408122052,0.6755857129999999,0.37776747299999996,0.41080751299999996,0.0,0.000396479719,0.0,0.0,0.0,0.464890866,0.514663447,0.38583393200000005,0.79041682,0.48944482799999994,0.445954619,0.192348503,0.414525928,0.129158801,0.508890297,0.23813274899999998,0.523381511,1.06088972,1.84817106,2.03297992,1.85838384,2.46335474,2.49567376,2.1783086,1.81512395,1.8692156999999998,1.11457053,0.909747665,1.01784869,0.507897476,0.485768277,0.209237647,0.0,0.197252116,0.12111469400000001,0.0254659117,0.0309060086,0.0,0.0639846637,0.0,0.0181632543,0.0,0.499203271,0.40165276200000005,0.8690814170000001,1.23349503,1.35576926,1.33005788,1.21518847,0.679102436,0.435648118,0.0,0.0,0.0,0.0,0.30623246,1.24266162,2.59503339,2.83625972,3.80562624,3.4918002999999995,2.84799235,2.65503742,1.23030592,1.01738272,0.11789734800000001,0.0,0.0,0.0,0.100156303,0.44918547799999997,0.338492102,0.512456247,0.0,0.457025972,0.6868779970000001,1.36857724,1.76875075,2.32453478,2.32930676,2.61796028,1.91688947,1.78981589,1.16367409,0.0,0.0,0.0,0.0,0.0,0.0,0.471111957,0.20968472100000002,0.382962061,0.0,0.0,0.024666213,0.0,0.0728843545,0.0,0.29376101600000004,0.0419419167,0.0,0.0,0.298792524,0.10783187699999999,0.0,0.0,0.128880402,0.0,0.328688635,0.0,0.130859597,0.18095903600000002,0.014314238799999998,0.279113574,0.0,0.0622515642,0.0,0.2239553,0.033450621800000004,0.150150985,0.275876183,0.0816735513,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.26347732100000004,0.387382512,0.42858547,0.383315079,0.279343778,0.159945079,0.063774176,0.010273513,0.0,0.0036198160600000003,0.0116556629,0.00850075443,0.0,0.0,0.0,0.0,0.0019739147500000003,0.0186124691,0.0248735596,0.0177908296,0.00205732807,0.0,0.0,0.0,0.0,0.006733053929999999,0.0113161077,0.00860377269,0.0026310245199999997,0.0,0.000511103263,0.00458519239,0.00516584097,0.0,0.0,0.0,0.00288974271,0.06773075049999999,0.179189968,0.322118102,0.464132001,0.565660297,0.594738532,0.540193224,0.417093969,0.261597546,0.11710376300000001,0.0177003624,0.0,0.0,0.00886689337,0.0300236772,0.0306643319,0.0144148747,0.0,0.00615423599,0.0454706685,0.109615818,0.174534126,0.21040955600000003,0.196179882,0.130763844,0.0352937126,0.0,0.0,0.0,0.0,0.0326472498,0.09632910199999999,0.116818255,0.08618175900000001,0.0210801177,0.0,0.0,0.0,0.04786579269999999,0.18305864100000002,0.334072293,0.47920894700000005,0.614453288,0.756006106,0.931709612,1.16469416,1.45639685,1.77688293,2.06772701,2.25764798,2.28572722,2.1236131,1.78808028,1.33874327,0.861282531,0.442024894,0.142956592,0.0,0.0,0.0,0.0480335469,0.07923091089999999,0.0670658588,0.021037862999999997,0.0,0.0,0.0,0.0,0.018431531,0.0531777876,0.058889807999999995,0.0340390613,0.0,0.0,0.0,0.0,0.0,0.0353762361,0.0538641493,0.0439328825,0.010986639199999999,0.0,0.0,0.0,0.0,0.0197724783,0.049138225199999996,0.05278360309999999,0.028447834900000003,0.0,0.0,0.0,0.0,0.0022410483899999996,0.0415724684,0.0596810163,0.046355869800000005,0.00785255218,0.0,0.0,0.0,0.0,0.0288346412,0.0628466904,0.0643086753,0.0312418158,0.0,0.0,0.0,0.0,0.00893184374,0.060031717400000004,0.0810212749,0.0592095008,0.004353418679999999,0.0,0.0,0.0,0.0,0.0483986194,0.0946737324,0.0921798592,0.039413866,0.0,0.0,0.0,0.0,0.0235867317,0.102964206,0.131905485,0.09073100349999999,0.0,0.0,0.0,0.0,0.0,0.102478605,0.185998592,0.17536774,0.0650340658,0.0,0.0,0.0,0.0,0.08467783710000001,0.302285232,0.405267256,0.319777018,0.061374657,0.0,0.0,0.0,0.34859860299999995,1.42114828,2.80142437,4.23549162,5.43726281,6.17293454,6.32516123,5.91604152,5.08501453,4.03478476,2.9683477000000003,2.03969367,1.33136042,0.85900515,0.592844385,0.48233191299999995,0.474091125,0.520578757,0.583419985,0.6372165710000001,0.676380172,0.72186498,0.8207611690000001,1.03275333,1.40367279,1.93472364,2.56163741,3.15707362,3.56126934,3.63340927,3.30522368,2.6145707000000002,1.70284162,0.774002585,0.0291011009,0.0,0.0,0.0,0.0,0.210748632,0.30556075,0.23694752,0.0633566763,0.0,0.0,0.0,0.0,0.0640608147,0.164897286,0.174088555,0.09417674720000001,0.0,0.0,0.0,0.0,0.095249708,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.41220387,0.0,0.0,0.319468822,0.0,0.298801711,0.18528854600000003,0.49260286799999997,0.448452405,0.28162828,0.0,0.23296382,0.30929466,0.131069902,0.35579363700000005,0.0,0.141562726,0.0920869901,0.23485698300000002,0.0,0.0,0.0,0.194078425,0.0437635166,1.07851205,1.13470195,1.4247616,0.652126173,0.0,0.0,0.123254211,0.280334757,0.076261192,0.0,0.0,0.0,0.24670482100000002,0.263977658,0.424523969,0.0,0.0,0.0,0.0,0.163694998,0.0,0.0813809461,0.182548766,0.568342904,0.0243414019,0.0,0.0,0.0,0.611149124,2.21282804,3.06043615,3.49370484,2.34420055,1.87218085,0.64153831,0.0,0.233419194,0.38929363100000003,0.0,0.0,0.165045559,0.350109968,0.0,0.0647291898,0.0,0.249055587,0.0,0.0,0.27679597,0.039895619300000004,0.0,0.0243606163,0.18353931399999998,0.908184262,1.73458491,2.40722119,2.87698862,2.70604243,1.17980055,0.42130967700000005,0.0,0.0,0.217799265,0.181417655,0.0,0.0,0.0,0.0671485715,0.463001888,0.46147682799999995,0.044843743,0.30384424,0.284367992,0.0,0.419080345,0.452333835,0.622298829,0.8092681290000001,0.549603985,0.600409249,0.0,0.307687444,0.0,0.09637355539999999,0.0,0.0,0.118228809,0.0,0.0,0.0,0.0,0.0,0.221554681,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.125926971,0.0,0.0,0.0,0.179161634,0.321510185,0.0,0.085176395,0.25516083300000003,0.300449923,1.20788318,1.13618267,1.51125361,1.29341441,1.44892309,1.38810963,1.75480411,1.39792246,0.755736952,0.521370431,1.0629898000000002,0.6552865929999999,0.518065734,0.594981823,0.726495757,0.6736717959999999,0.686583286,0.746503537,1.16960692,1.1452498,1.43985528,1.2724465,1.31673364,1.08438906,0.488422997,0.0,0.178590017,0.0,0.0948979842,0.0,0.0,0.193686219,0.439582695,0.6917490559999999,0.891000186,0.632064062,0.69237091,1.3786671999999998,1.23786765,0.847513903,0.42235692399999997,0.0,0.0,0.140491674,0.0,0.549362016,0.21952182399999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.46146767,2.40160531,4.35092987,5.63170186,5.82030046,4.93913911,3.43600016,1.96238196,1.06491793,0.94565178,1.40655785,1.99439198,2.25823649,1.97935598,1.2572066000000002,0.41989665,0.0,0.0,0.0,0.20254518,0.40670413,0.34171539,0.06546091,0.0,0.0,0.0,0.03866377,0.27803538,0.32860444,0.16152691,0.0,0.0,0.0,0.0,0.17594611,0.32791503,0.26221356,0.01900855,0.0,0.0,0.0,0.06051432,0.31149011,0.35911341,0.16351379,0.0,0.0,0.0,0.20997892,0.71068281,0.9667293,0.73868016,0.04914028,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.19497165,0.27720076,0.34632768,0.39546913,0.41938152,0.41488695,0.38116207,0.31985788,0.23502971,0.13287124,0.02126225,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.07606408,0.19355406,0.29607037,0.37339928,0.41732737,0.42251571,0.38715684,0.31334247,0.20709219,0.07802115,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.22980376,0.48848635,0.7531277,1.00190354,1.2126382,1.36472559,1.44104499,1.42970885,1.32548578,1.13076152,0.85593252,0.51916909,0.14553397,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.13639471,0.83507103,1.64384596,2.52534825,3.43569354,4.3272155,5.1515334,5.86273787,6.42046395,6.79262635,6.95761468,6.90578492,6.64013536,6.17611527,5.5405793,4.76996424,3.90782224,3.00189217,2.10092366,1.25148502,0.49498501,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.037832300000000006,0.42141852,0.7784079,1.07984844,1.30328273,1.43403982,1.46587299,1.40092275,1.24903782,1.02653536,0.75452253,0.45693097,0.15843168,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.17870242,0.34853062,0.48239461,0.56909047,0.60184366,0.57869756,0.50250437,0.38053895,0.22378520000000005,0.045967400000000005,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.14217831,0.41226908,0.69318851,0.97145041,1.2340591,1.46920508,1.66684104,1.81911585,1.92065658,1.96869916,1.96307731,1.90608629,1.80224152,1.65795447,1.48114772,1.2808296000000001,1.06664677,0.84843063,0.6357514,0.43749282,0.26145963,0.11403046,0.0,0.0,0.0,0.0,0.0,0.0,0.0237434,0.10763984,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.12062495599999999,1.55110101,2.98715443,3.99774437,4.28811389,3.80709891,2.76294792,1.53936239,0.543291365,0.0445076619,0.0721153197,0.411912991,0.708604531,0.633742984,0.051413103099999996,0.0,0.0,0.0,0.0,0.589232978,3.48601352,6.75239219,9.58938316,11.2424231,11.2463791,9.58190743,6.68694545,3.31858632,0.313742495,0.0,0.0,0.0,0.0,0.8448243529999999,1.81516996,2.07626141,1.64098233,0.779274088,0.0,0.0,0.0,0.0,0.109770255,0.668250036,0.995885707,1.02610119,0.8445866209999999,0.633692861,0.577915727,0.773918364,1.18400585,1.65142375,1.96869772,1.96808595,1.59503501,0.934042438,0.177225735,0.0,0.0,0.0,0.0,0.0276228532,0.40305724299999995,0.568868487,0.48328515899999996,0.209339567,0.0,0.0,0.0,0.0,0.0,0.165147182,0.318455072,0.324521963,0.19594534,2.39143935e-17,0.0,0.0,0.0,0.0,0.0457510275,0.158445091,0.19149913699999999,0.141571889,0.040832872799999996,0.0,0.0,0.0,0.0,0.0,0.051206795199999995,0.0720311666,0.0576669099,0.0242846154,0.0,0.0,0.0,0.0,0.0027577361699999995,0.0,0.0,0.0,0.0,0.0,0.045118802199999995,0.0891310738,0.09934604359999999,0.0613202562,0.0,0.0,0.0,0.0,0.0,0.0643397178,0.176605554,0.22170372,0.16928251,0.0314852759,0.0,0.0,0.0,0.0,0.027396219700000002,0.23531226100000002,0.35664686700000003,0.32710958100000004,0.145540543,0.0,0.0,0.0,0.0,0.0,0.24507590899999998,0.486181336,0.52455176,0.328431695,0.0,0.0,0.0,0.0,0.157845431,0.824278548,1.41531388,1.67760036,1.45954465,0.789025015,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.247
1.38957434,0.73837667,2.90435513,0.0,0.0,1.59883125,0.0,0.0,0.0,0.0,0.0,0.0,1.80276301,0.85447247,3.09608942,3.16578095,0.47875358,2.85837201,0.0,1.92523693,1.2321263999999998,0.29407445,1.08521953,0.05706611,0.0,0.75264331,1.09780452,3.38952518,4.62867584,4.89598476,4.26431997,3.67147587,5.33806448,4.12141392,2.4999432,0.0,0.62293818,0.83872878,0.0,0.0,4.08924625,1.1724768,3.51720826,2.8873502999999996,3.80485633,4.17813422,0.74347601,2.01147368,2.43586215,0.0,0.61190274,0.39007277,0.0,0.0,1.20754743,0.0,1.4298566000000001,1.35865715,0.19569706,2.21622635,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.21759858,2.13437051,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.35883899,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.8582629540000001,0.0,0.0,0.0,0.112120411,1.25347655,2.02912516,1.68070068,1.64452523,1.87799527,1.11321291,0.13129775400000002,0.0363181095,0.16840043300000002,0.102349779,0.18539396,0.223723305,0.08822775640000001,0.0624501342,0.175234959,0.599821987,1.30852171,1.33798554,0.489916215,0.0,0.12059364199999999,0.0408387106,0.0,0.0453347833,0.0637417557,0.0,0.00572558751,0.0722592023,0.0,0.0,0.0695295126,0.0,0.0,0.0585282119,0.0,0.0,0.0417942799,0.0147927325,0.0,0.172132559,0.33524299399999996,0.262688758,0.223319958,0.415877939,0.647205693,0.569802872,0.186916445,0.0,0.179546233,0.33094346399999996,0.302429253,0.254643938,0.0900094095,0.06344186339999999,0.74823589,1.75393757,2.29748333,2.58206266,2.7949978,2.29199206,1.05328369,0.0681046177,0.0,0.0494403449,0.0539563738,0.0,0.0188636342,0.144563499,0.0,0.0,1.0987853,1.60987354,0.420724306,0.0,0.053340578,0.216874735,0.0,0.0,0.14464085,0.0,0.161430729,0.42363881700000006,0.0387003965,0.0,0.14369309800000002,0.0335863937,0.0,0.0860631893,0.081757299,0.0,0.114950756,0.550698145,1.40216218,2.90938877,3.23222804,1.71325369,0.838340677,1.01973271,0.31549807399999996,0.27927085100000004,3.0700577,5.35299762,3.7660258,0.9409289059999999,0.0,0.0697281929,0.0362161773,0.19050728100000003,0.29092022,0.160206616,0.40957401,1.00153658,1.23120745,0.998545492,0.917540169,1.69887832,3.20861074,4.19070825,3.96708839,3.29731926,2.63310721,1.60248018,0.49939155,0.024649100099999998,0.0163615415,0.0025421186600000003,0.0,0.00806465315,0.004024037720000001,0.0,0.000134034724,0.0,0.00500510541,0.000830487855,0.0,0.00793947173,0.0066423490000000005,0.0,0.00497018847,0.0133545595,0.0,0.0,0.0159168236,0.0,0.0,0.0541060549,0.325440995,0.939359512,1.47699486,1.57566031,1.56499106,1.4462575,0.7926080609999999,0.0964511789,0.0193857277,0.0658088302,0.0,0.0,0.10687943,0.0,0.0,0.134664927,0.0,0.0,0.15545668699999998,0.006437396429999999,0.0,0.203606526,0.380805002,0.00930492698,0.046181163600000005,0.13643961300000002,0.0,0.0,0.40437662799999996,0.0,0.0,2.01605721,3.20789479,2.0264069,1.2295741000000002,1.46471726,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
12.04777826,11.07921801,6.42781489,1.51699412,0.0,0.23106614,1.85392934,2.23493491,1.37842187,0.65837717,0.78657748,0.95989625,0.17993226,0.0,0.0,3.29694021,8.59452098,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.51790447,3.56945485,3.07289702,3.52177548,3.33466017,2.97002332,2.62972364,2.47385606,2.36742838,2.10078616,1.37871957,0.960490704,1.00818219,0.416145187,0.598379459,0.029067568999999998,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.120276558,0.35549108799999996,0.51063084,0.11715801599999999,0.783575968,0.772345043,0.22011149800000002,0.450592286,0.624700261,0.596827268,0.560996382,0.118313616,0.0,0.287574935,0.0,0.00954043639,0.116768021,0.0,0.0,0.0378979343,0.0,0.117875836,0.0,0.0,0.0,0.0496602272,0.0312676308,0.21013849,0.417163905,0.22223010699999998,0.392009244,0.0756733024,0.36878924,0.38975016799999995,0.0492020816,0.0281425852,0.0,0.0,0.22955823399999997,0.0,0.0,0.000972812697,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.142894061,0.5105396170000001,0.302182797,0.949311804,1.15545034,1.60472814,1.45693354,1.82477138,2.29543498,2.28132355,2.62585459,2.97273539,2.90617967,3.03083554,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.16390847,0.0,0.0,1.2981782,0.0,0.0,0.0,1.58595392,0.0,1.4554016,1.70280465,0.736758092,0.0,0.0,0.88072556,1.05843762,0.39807505299999996,0.6017162189999999,0.116800711,0.0,0.0,0.0,0.0,0.952590417,0.0,0.887438932,0.0,0.0807353366,0.0,0.316750403,1.77539575,0.7347575209999999,0.0,0.619440623,0.0,0.990782655,0.0,0.0,0.0,0.122312479,0.0,0.0,0.0,0.0655063884,0.0739815259,0.0,0.0,0.0,0.0703471092,1.7224147,0.0,0.215114482,0.0,0.0,1.31124344,0.0,1.7737011999999999,0.0,0.0,0.0,0.525874139,0.683229309,1.43954769,1.16896168,0.0,0.0,0.09948879810000001,1.73854699,0.9384989690000001,1.66266316,0.0,0.462915134,0.0,0.0,0.355219709,0.7683569720000001,0.0253377395,0.26052949,0.591225914,0.0,0.0,0.0,0.0,0.3172081,0.708051779,0.0,0.0,0.0,0.549393914,0.334334682,0.0,0.0369383345,0.0455540674,0.0,1.65925824,0.19422059600000002,1.63830989,0.0,0.364943333,0.8779641020000001,0.0,0.0,0.8995377720000001,1.45474722,0.0,1.31046976,0.0,0.0,1.47067723,0.0,0.0,0.0,0.639691921,1.36552236,0.497084511,1.16487242,1.68389992,0.0,0.402321389,0.0,0.0,0.0,0.0,0.0,0.0,0.37718065,0.800449506,1.73623832,0.9436233490000001,0.119119365,0.0,0.0,1.12586223,0.0,0.0,0.504416309,0.0,0.386563647,0.487187972,0.0,0.0,0.0,0.0,0.875009922,0.29908213300000003,0.0,0.752880595,0.0,0.54683892,0.911050283,1.56312579,0.8413082679999999,0.0,0.0,0.0,0.0,1.65652749,0.0,1.05427671,0.376294044,0.0778091482,0.5962481829999999,0.0,1.6961322,0.763113556,0.0,0.0,0.576512425,0.0,0.0,0.153195309,0.38825695200000004,1.17935768,0.0,0.0,0.0,1.00430944,1.18556268,1.02678653,0.0,0.0,0.578559345,1.17671317,1.43707808,1.15018123,1.09914822,1.04578654,0.9811017740000001,1.60252226,0.0,0.953102012,0.0,17.3345706,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.19130438,0.0,0.0,0.6746011,0.227001416,0.0,0.0,0.132933852,0.0,0.0,0.0,0.0,0.052840137599999996,0.0,0.80011688,4.03187481,7.35790025,6.21774049,1.54790299,0.0,0.026202227999999998,0.711863769,0.0,0.0,0.7476162120000001,0.806239934,0.695157719,1.15671101,1.01772281,5.71381465e-16,0.0,0.11938118800000001,0.19318628300000001,0.0,0.0,0.12751384699999999,0.0112999275,0.0,0.0192216059,0.0356213594,0.0,0.0,0.0,0.0,0.0587583662,0.0,0.0,0.07196245150000001,0.09705987710000001,0.0,0.0,0.200661002,0.0,0.0879587167,1.16048589,1.33216645,0.0,0.0,2.29158311,4.1011544,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
3.79317252,11.3453535,0.0,0.0,0.439873739,0.338867907,1.87687665,1.61973361,2.89621789,0.0,0.0287252466,1.79143246,4.33592204,4.68130531,5.01984076,0.5652820279999999,0.49451334399999997,0.0,1.31315702,1.60896113,0.0,0.0,1.61392999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.134464165,0.0,0.0,0.0,0.237729131,0.306645547,0.511946514,0.101695996,0.0,0.0,0.130582199,0.22767517399999998,0.0,0.324210916,0.0,0.0,0.22056141,0.38994451700000005,0.0,0.0,0.15380386,0.0,0.0808829326,0.217476865,0.491682368,0.661622107,0.0,0.0332398908,0.0,0.117664708,0.0,0.053367320700000005,0.0,0.0,0.0,0.7130466959999999,0.0831751305,0.552755451,0.0,0.044592797999999996,0.0,0.0,0.0382247168,0.0,1.49286726,2.2953706,3.32468603,4.13871596,3.99733286,4.16997296,3.36855539,2.42354165,1.81566631,0.475201959,0.332399532,0.0,0.0,0.0,0.0,0.559467653,0.508644234,0.72458107,0.843676526,0.220737515,0.44036566899999996,0.114061855,0.0,0.0,0.0808059944,0.307275819,0.524562336,0.52257013,0.0,0.168315838,0.00984043566,0.0,0.0,0.0,0.0,0.007238371259999999,0.142654687,0.160669386,0.349750689,0.0,0.0130988828,0.0,0.133461035,0.0,0.0,0.0,0.0,0.48213369799999994,0.35025056600000004,0.40787098200000005,0.240060785,0.0,0.0,0.0,0.0,0.0,0.163880398,0.125728685,0.235318158,0.0,0.0,0.0,0.165082264,0.0347455224,0.126892909,0.0,0.0,0.0,0.422156407,0.0,0.43795583,0.0,0.0,0.0,0.0,0.0,0.36481050200000004,0.154496573,0.0,0.0,0.19509968100000002,0.0,0.0,0.0,0.0,0.0,0.115412084,0.219253754,0.51389888,0.269786084,0.0497995241,0.430741243,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
2.42922377,2.29130555,2.52221607,3.30269077,2.61711321,1.59822151,1.48076265,1.85377596,1.90235308,2.16878744,3.40598151,3.08817153,3.9499717000000003,4.46833816,3.54472832,2.68672444,1.27178458,0.935724287,0.0,0.27162029,0.0,0.34700930700000004,0.0,0.0,0.160682189,0.0,0.0,0.0,0.231270227,0.041993620999999995,0.031595288799999996,0.0411904362,0.0,0.0,0.0,0.469520903,0.0663083574,0.12434777400000001,0.345446949,0.0563702259,0.0,0.0,0.0,0.0,0.0025626610399999998,0.789666625,0.0,0.036495257,0.0,0.0,0.0,0.17763050800000002,2.02291452,3.95202225,4.85279283,5.55845275,5.46984639,3.25448584,1.54077383,0.0,0.0,0.0,0.0,0.243538993,0.96937179,0.437817461,1.06364971,0.5008052820000001,0.0,0.0,0.0,0.0,0.189092625,0.65845083,0.505172582,0.502397353,0.0,0.0,0.0739443506,0.0,0.412022525,0.0,0.585802641,0.798043387,0.0,0.0,0.0,0.0,0.0,0.0,0.5238774820000001,0.0,0.0,0.0,0.0,0.0,0.0054638761800000005,0.0,0.0,0.0926760644,0.5415547510000001,0.0715174296,0.0,0.0,0.0722869414,0.0,0.0,0.546643978,0.0,0.0,0.152684146,0.0,0.118143274,0.0,0.0115638804,0.491013207,0.0,0.38706709899999997,0.0,0.204073266,0.0847785859,0.423437392,0.0,0.658857444,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.709241673,0.0,0.0,0.0,0.0,0.568198871,0.0,0.07447995610000001,0.315591512,0.0753033937,0.539992507,0.259082766,0.0,0.0686678424,0.0,0.0,0.0,0.423008987,0.346453151,0.339388266,0.0,0.0,0.16668249300000001,0.23814999899999997,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.295711326,0.47013239700000004,0.0,0.0,0.0159314889,0.371913789,0.0,0.208534627,0.0,0.0,0.0,0.632870528,0.0,0.556301436,0.0,0.0,0.0,0.0,0.0,0.24185611,0.0270831634,0.363865155,0.225122057,0.0,0.0,0.18328526,0.542015865,0.8289093409999999,0.8064981520000001,0.69204185,1.00594582,1.0332768,1.21292289,1.60302375,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.0356255577,0.205423885,1.16505476,1.54112509,1.53356196,1.30300875,0.739916252,0.250459767,0.24659315699999998,0.731884593,1.27779041,1.60739203,1.78353748,1.72665666,1.69807633,2.04120671,2.21896066,1.9492947,1.84498567,2.02062664,2.00587787,1.77845509,1.64351225,1.41925735,0.823835228,0.591845062,1.10504932,1.1700428,0.748141873,1.12058427,1.53653714,0.927172907,0.47187335700000005,0.710238598,0.654825525,0.28012198899999996,0.11409315800000001,0.059854591299999996,0.00800609229,0.0,0.000414657344,0.0007688167290000001,0.0,0.00321847145,0.000924762214,0.0,0.009385972170000001,0.0,0.0,0.0177821944,0.0,0.0,0.0288738838,0.0,0.024119263300000002,0.17365465300000002,0.12552028199999998,0.0503797791,0.0261436379,0.0,0.0792728345,0.350985161,0.325840872,0.303870666,0.40147306299999996,0.303417609,0.335690255,0.8044382370000001,1.34930571,1.72893181,1.95278373,1.89158429,1.40858618,0.7083619059999999,0.222590415,0.0310532634,0.0,0.0123462702,0.0102875651,0.0,0.0257214179,0.0021158182199999998,0.0,0.0519424099,0.0,0.0,0.22147893800000001,0.295225085,0.124620387,0.163142142,0.150066455,0.0,0.0,0.0036345503100000003,0.00235719609,0.00698747563,0.0,0.0185172418,0.006111672710000001,0.0,0.0421765658,0.0,0.0,0.07350000570000001,0.0,0.0,0.11573387,0.0,0.0,0.187624807,0.0,0.132064399,1.06327317,0.43522901799999997,0.159173808,0.8978188490000001,0.454404088,0.934513123,3.03341569,2.53184664,0.376444116,0.047986786,0.0927573596,0.0,0.109101901,0.0850369491,0.249340775,0.6870945690000001,0.0669120925,0.0,0.37169889,0.0,0.0,0.88465561,0.9204026390000001,0.09852926990000001,0.22077549100000002,0.660300666,0.625961404,0.600062705,0.74773606,0.647916378,0.201438055,0.0242923777,0.150653232,0.0,0.0,0.0860545622,0.0,0.0,0.0953085058,0.0,0.0,0.237217462,0.14535553199999998,0.0,0.0,0.23649611,0.970128943,1.03960639,0.27596842,0.0,0.00281886761,0.0,0.0731977732,0.0,0.0,0.162422259,0.0,0.0,0.901930672,0.991517089,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.273622322,0.337607036,1.619918,0.367987665,0.09297031730000001,0.110969315,0.404043074,5.28760045,6.54345209,1.68289575,0.0,0.18542413300000002,0.0,0.021948116099999998,0.0,0.0760645396,0.0,0.343745253,0.9381291390000001,0.00250446114,1.0636465,1.57025931,0.0,0.6564906939999999,1.40539762,0.142711678,0.103285116,0.0,0.0,0.143160854,0.0,0.21846903,0.034184823999999996,0.0,0.179918495,0.0,0.0356953229,0.07437261860000001,0.0,0.39205574299999996,0.152030007,0.0,0.08854403300000001,0.0,0.120887259,0.0,0.0,0.165403349,0.0,0.450468535,2.14570792,4.34546671,5.35788151,3.9288803,2.55764148,0.35434693700000003,0.13455451599999999,5.10664413,5.23148795,5.62216466e-15,0.0,0.552992611,0.0,0.268952336,0.807909346,0.776162976,0.40530649799999996,0.0,0.00478584446,0.0369371367,0.0,0.02662718,0.0,0.0,0.0,0.00785881968,0.0,0.0023481983800000003,0.0159229714,0.0,0.0388601375,0.0,0.0,0.0518306929,0.0,0.08232717099999999,0.13030188199999998,0.110131621,0.138647032,0.0,0.0694907136,0.023657155299999996,0.0,1.09033888,2.07959126,2.78366214,2.55018167,1.37725011,0.8946427570000001,0.0535695734,0.22504625,0.785654147,0.0,1.1672723999999999,3.10402665,0.553429931,0.0,0.57967228,0.0,0.530424419,0.32545553,0.0,0.21673933399999998,0.0,0.0,0.14015470800000002,0.0,0.0804018776,0.0,0.0,0.088891977,0.0,0.0263002965,0.0201223778,0.0,0.048774554500000004,0.0,0.0019731812899999998,0.0204704193,0.0,0.09887218269999999,0.479815334,0.580068038,0.126910141,0.0,0.0,0.005525988440000001,0.0541376167,0.0,0.388750968,0.780183121,0.0503422071,0.0,0.43513995200000005,1.34882046,1.89057016,0.764565002,0.41483528700000005,0.47728282299999997,0.34747425200000004,1.20420834,0.510566344,0.0,0.214997926,0.0,0.53742985,1.6680456999999997,1.35363727,0.829891642,0.0335547129,0.0,0.19337889800000002,0.0,0.0434511047,0.06105874519999999,0.0,0.291160849,0.0,0.0,0.570094559,0.283524628,0.10160915300000001,0.0,0.0,0.0,0.440341529,1.3321462,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.37133779,0.47724160000000004,0.63034013,1.0525451000000001,0.97234103,1.13648798,1.51340509,1.44403139,1.54037095,1.90931892,1.59204877,1.95031638,1.68416105,1.92217904,1.47316607,1.48358709,1.49381008,1.21823547,0.81307771,1.04899489,0.38461361,0.44263357,0.55824034,0.04772008,0.29994884,0.2750253,0.0,0.0,0.0,0.36593775,0.43184096,0.46618776,0.30802131,0.65906511,0.79976768,1.32635182,1.61779071,1.85979427,1.89860045,1.90565625,2.5188781000000002,2.47550734,2.76065477,2.70386022,3.09619985,3.07303864,2.99393615,2.67880015,2.52163246,2.52616086,2.42437871,2.32375928,1.9822455,1.58632437,1.35097436,1.5172419,1.23698034,0.78250862,0.55588123,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
1.54658102,0.0,2.06524658,0.866111745,0.23184223,0.0,0.420282548,0.0,0.8979882370000001,0.437092855,0.284376035,0.0,0.0,0.0,0.250686404,0.157269257,0.0,0.0,0.0,1.0127017,0.0,1.14532948,0.0,1.17937583,3.28276344,1.46329454,1.72960136,1.42267779,1.38432855,0.47884291100000004,0.374549275,0.0,0.0,0.0,1.12688827,1.08130821,0.014605523,0.46493045200000005,0.897800576,0.0,1.67339811,0.0,0.0,2.08317927,0.0,0.80823885,1.02437148,0.0,0.0,0.0,0.504179132,0.816971662,0.0,0.0,1.08487744,0.0,2.40376908,0.0,0.0,0.313125284,1.76328005,0.536825326,0.0,0.0,0.550404386,1.06778865,1.01416402,0.9801583159999999,1.83981897,2.83336687,2.15859028,0.0,1.90803892,0.485629718,0.0,0.0,0.0,0.0,2.53219699,4.13776188,1.94053328,4.70495871,4.51529498,4.1187601,4.47409953,3.70695462,1.99067282,3.49270238,1.08767069,0.0,0.0,0.0,1.11842794,0.720450609,0.0,1.88415976,1.06802992,0.0,0.0,0.966744574,0.864038434,0.0,1.11814854,0.0,0.0,0.44873828200000004,0.0,0.648700513,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.179708724,0.162051749,0.0,1.23115212,0.0,1.22893975,0.528223057,0.0,0.0,0.0,0.0,0.1171339,1.64234323,0.603875608,0.8710316709999999,0.0,0.907419619,0.0,0.9266999570000001,0.64687258,0.0,0.6991094309999999,0.0,0.433389743,0.836781153,0.0,0.0,0.392551054,0.0,0.0,2.03758551,0.447090117,0.10161439800000001,0.0,0.0,0.0,0.0,0.0,0.0,1.10646252,0.746442583,0.28309375,0.0,0.0311295069,0.0828718401,0.0,0.22630186800000002,0.0,0.0,0.30402808,0.188652087,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.296823569,0.110382336,0.412352974,0.603032715,0.0,0.529352968,0.16814799100000002,0.33793006,0.21129314100000002,0.0,0.11082703599999999,0.193501641,0.163598801,0.139098382,0.184932425,0.0,0.0,0.09615319439999999,0.153132915,0.0152394022,0.0,0.36365266399999996,0.168366643,0.0626350282,0.0,0.0,0.0,0.18880814899999998,0.0,0.26159313300000003,0.0,0.39613350700000005,0.45097338299999995,0.0,0.0,0.31998025399999996,0.371235415,0.168588811,0.0,0.308261108,0.460321484,0.0,0.515362202,0.0,0.130718689,0.0,0.0,0.272467718,0.103553744,0.035685179500000004,0.121704525,0.317849493,0.0,0.398138526,0.0,0.285360758,0.281760091,0.643743717,1.26978915,1.50761131,1.86489684,1.93517545,1.93760253,1.26300179,0.530077205,0.10290883199999999,0.0,0.0,0.0,0.245075568,0.7077583009999999,1.54980541,2.86502497,3.51738319,3.85632536,4.31970124,4.68497734,4.25610436,3.23480866,1.84745092,1.01797762,0.25079561300000003,0.0,0.0,0.0,0.0,0.45210387,0.49268225600000004,0.34443925700000005,0.0,0.21970156300000002,0.0,0.0,0.523197065,0.447543505,1.08770587,1.62221944,1.64434594,1.86063806,1.47930189,0.757016784,0.39819012299999995,0.0,0.0,0.09331709939999999,0.688106269,0.904257208,1.73299313,1.3828658999999999,1.45397609,1.18901735,1.09754752,0.7936304759999999,0.430073851,0.0,0.0,0.16077013199999998,0.0,0.0,0.0,0.253452227,0.111076091,0.241086057,0.0,0.392945835,0.0186471448,0.0,0.381377856,0.18740596399999998,0.38948209,0.0,0.0,0.0,0.15456808800000002,0.408867104,0.233641525,0.0,0.045536968,0.0,0.285533898,0.21095167,0.0,0.389024555,0.063067466,0.148500713,0.0,0.12891493199999998,0.150744544,0.0,0.00330693585,0.421099186,0.401781991,0.0,0.0,0.322264137,0.0,0.21655942600000003,0.0,0.0,0.250076415,0.059472463200000006,0.128949902,0.20986945199999998,0.0,0.0,0.0,0.0,0.20225955699999998,0.0,0.129453387,0.0,0.0991946287,0.0,0.447082071,0.430168645,0.104586256,0.749085874,0.147520534,0.0,0.0,0.155851032,0.29120317100000004,0.349337422,0.422917857,0.20273623100000002,0.300679264,0.0,0.0,0.30467600100000003,0.10615159800000001,0.5732119960000001,1.29904948,1.66546892,1.41760565,1.40902383,1.11655231,0.5603443810000001,1.12481645,0.897815591,0.829118558,1.45429763,1.20822517,1.38883053,0.987013385,0.31904176300000003,0.21330551600000003,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.419301926,0.366362843,0.235631769,0.067267465,0.0,0.0,0.0,0.0133292383,0.12798483300000002,0.194491201,0.186265071,0.11803028199999999,0.035665634700000004,0.0,0.013844928700000002,0.09860082640000001,0.206365744,0.28584619,0.298712243,0.237735582,0.128986877,0.0178715019,0.0,0.0,0.0,0.032399036400000004,0.0729075161,0.0739601105,0.0367032942,0.0,0.0,0.0,0.0,0.0037798858700000006,0.043952323200000004,0.058651043,0.042447577599999994,0.0063006726299999994,0.0,0.0,0.0,0.0,0.027575638399999998,0.046307742,0.042266500199999994,0.0190760565,0.0,0.0,0.0,0.0,0.0028292793100000006,0.0240318058,0.0380217136,0.0467694658,0.057920835,0.079066606,0.11167172199999999,0.148318767,0.175093315,0.178088108,0.150692511,0.0978088407,0.0346661978,0.0,0.0,0.0,0.0,0.00479394443,0.028110867,0.0342194708,0.0228085707,0.00175928768,0.0,0.0,0.0,0.0,0.0114233116,0.0221457998,0.021458573300000002,0.009611600849999999,0.0,0.0,0.0,0.015760748999999998,0.08963822029999999,0.210041681,0.37384120299999996,0.566352604,0.761755629,0.9279194190000001,1.03530166,1.06740725,1.02876788,0.9465294459999999,0.863787205,0.826092665,0.8656530459999999,0.989170013,1.17421922,1.3758796,1.5413226,1.62700583,1.61229096,1.50498486,1.33761176,1.15662266,1.00880974,0.929281068,0.933836942,1.01653723,1.15175206,1.29955219,1.41362675,1.45121254,1.38408612,1.20847306,0.950520897,0.663897496,0.417887268,0.277838239,0.283614409,0.43390300299999995,0.683296276,0.954824907,1.16453757,1.2494094999999998,1.18788183,1.00489819,0.759558903,0.520785765,0.341390666,0.24132555600000002,0.206441972,0.20188181800000002,0.192665025,0.161224633,0.113819586,0.0737259833,0.06581265019999999,0.101182329,0.17003443399999998,0.246192545,0.300401872,0.314902721,0.29132675,0.24782133899999997,0.207347476,0.184007717,0.175334507,0.165074959,0.134969385,0.07866836049999999,0.00931463697,0.0,0.0,0.0,0.0892749558,0.18749606,0.24496201,0.231449216,0.14966073300000002,0.0369580369,0.0,0.0,0.00373134365,0.130573661,0.254065799,0.31223166199999997,0.27311751100000004,0.15376678400000002,0.0156920615,0.0,0.0,0.148431162,0.400797615,0.65515016,0.833985819,0.89967387,0.870971822,0.8104164079999999,0.788442565,0.8426377690000001,0.9541725879999999,1.05574823,1.06962813,0.95805725,0.7599284909999999,0.591816319,0.607286573,0.928714345,1.58102281,2.45903628,3.3475439,3.99072275,4.18519795,3.85903565,3.10324106,2.14144089,1.24915913,0.6551345820000001,0.46421801,0.63152839,0.995329455,1.35150618,1.53635923,1.48337709,1.2333858,0.899124637,0.604782101,0.42983321799999996,0.38148691100000004,0.40453305,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
0.410376356,0.543057545,0.0,2.1003083,1.24796521,2.29650162,1.87154318,1.73732101,2.10906461,0.0,0.575010619,1.06343702,0.42181778799999997,0.216563774,1.13778239,0.2338732,0.13681384300000002,0.458381015,0.449911117,0.0,0.13763492900000002,0.0,0.0,0.0,0.0,0.0,0.0996241324,1.01952251,1.30685812,2.45893674,1.36611492,0.415644977,2.21883367,0.672141622,0.48737193799999995,0.0,0.7556302979999999,0.637550955,0.0,0.0,0.0,0.363352944,0.0,0.23716608399999997,0.0721973055,0.08636585640000001,0.0,0.0405663531,0.571065798,0.0,1.50390111,0.587564334,0.23825051600000002,0.477618366,1.87171481,0.8537245990000001,0.0,1.01696266,1.01356209,1.31488931,1.08378881,0.9911287209999999,0.65412322,0.0,0.666540271,1.63232817,0.0,0.20495414899999997,0.0,0.0,0.0,0.0,0.0,0.602604453,0.0,0.117105559,0.9727529140000001,1.97658455,3.12447282,1.98356074,2.62437317,1.59744044,2.38708402,1.87812138,2.16041069,1.62598392,2.11377373,0.477748323,0.23783320000000002,0.9994643990000001,0.9387467859999999,0.874851335,1.49576863,0.832748438,1.69466528,3.36422587,2.13806915,3.00180534,2.98942316,2.50355359,0.181709172,1.3729081,0.725928749,0.0,0.0,0.0,0.0,0.0,0.906224824,0.454030008,0.0,1.75215762,0.134792924,0.917984006,0.652168396,0.0,0.0,0.0,0.0,0.0,0.471175323,0.127863209,0.0,0.0,0.669528683,0.26585234399999996,0.0,0.0,0.0,0.0,0.0,0.0,0.4150179,0.0,0.840302894,0.128406398,0.0,0.0,0.34869122399999997,0.5041263189999999,0.0,0.44913707,0.0817285918,0.0,0.0,0.9284221340000001,0.0,0.14276303099999998,0.965011891,0.14612209199999998,0.0,0.0,0.0,0.0,0.0,0.0139570324,0.0,0.0,0.40213878700000005,0.0,0.0,0.224844226,0.0,0.239661407,0.0,0.0,0.0,0.0,0.389076542,1.54717808,0.7270520140000001,0.11000986300000001,0.0332298925,0.187824138,0.0,0.297226742,0.577590526,0.0,0.0,0.0,0.0,0.6293973660000001,0.0,0.047155116600000005,0.0935005575,1.12060469,0.0,0.0,0.0,0.105547271,0.139553617,1.09839412,0.512612254,1.44794564,0.0,0.222825,0.108505498,0.117681165,0.11939775,0.0,0.11531424,0.536048203,0.403221406,0.0,0.892692362,0.245019282,0.296071776,1.02464989,0.37977911299999995,0.0190627627,0.0,0.0,0.0,0.0,0.0,0.526417435,0.958855529,1.57391101,0.59505141,0.929969339,0.388280216,1.48351919,0.0,0.470153789,0.0570285821,0.9926467609999999,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0:0.23
